local ggameplay = game.gameplay
local floor = math.floor

local ghub = game.hub

local _participants = ggameplay.participants
local _participants_by_teams = ggameplay.participants_by_teams
local _ai_participants = ggameplay.AI_participants
local _tribes_to_participants_ptrs = ggameplay.tribes_to_participants_ptrs

local mg_player_vars = ggameplay.mg_player_vars
local mg_vars = ggameplay.mg_vars

function update_pointers()
	_participants = ggameplay.participants
	_participants_by_teams = ggameplay.participants_by_teams
	_ai_participants = ggameplay.AI_participants
	_tribes_to_participants_ptrs = ggameplay.tribes_to_participants_ptrs
	mg_vars = ggameplay.mg_vars
	ghub = game.hub
end

----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
--BOAT RACE I----------------------------------BOAT RACE I--------------------------------------------------------BOAT RACE I---------------------------------------------------------BOAT RACE I---
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

function BR1_refresh_mg_variables()
	local start_zone = Coord3D.new();
	start_zone = MAP_XZ_2_WORLD_XYZ(96, 28)
	local end_zone = Coord3D.new();
	end_zone = MAP_XZ_2_WORLD_XYZ(98, 4);
	mg_vars.mid_zone_c2d = coord_to_c2d(98, 16)
	
	local fireballs_tbl = {}
	SearchMapCells(CIRCULAR, 0, 0, 2, world_coord3d_to_map_idx(MAP_XZ_2_WORLD_XYZ(96, 6)), function(me)
		local c3d = Coord3D.new();
		local map_idx = MAP_ELEM_PTR_2_IDX(me);
		map_idx_to_world_coord3d(map_idx, c3d);
		table.insert(fireballs_tbl, c3d)
	    return true;
	end)
	mg_vars.fireballs_tbl = fireballs_tbl

	mg_vars.powerup_perm_list = { 
	{
		Marker = 27,
		Model = M_SPELL_CONVERT_WILD,
		Cooldown = 12*40,
		CurrCooldown = 0;
	},
	{
		Marker = 36,
		Model = M_SPELL_SHIELD,
		Cooldown = 12*30,
		CurrCooldown = 0;
	},
	{
		Marker = 37,
		Model = M_SPELL_ANGEL_OF_DEATH,
		Cooldown = 12*30,
		CurrCooldown = 0;
	},
	{
		Marker = 38,
		Model = M_SPELL_FIRESTORM,
		Cooldown = 12*30,
		CurrCooldown = 0;
	},
	{
		Marker = 39,
		Model = M_SPELL_SHIELD,
		Cooldown = 12*30,
		CurrCooldown = 0;
	},
}

	mg_vars.positions = {}
	mg_vars.power_up_mode = 1; -- 0 old, 1 new
	mg_vars.powerup_markers = 14; -- 0 ~ 14
	mg_vars.POWERUP_CD = 10*6;
	mg_vars.powerup_cds = { [0]= 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
	mg_vars.spawn_zone = { x = 96, z = 22, marker = 34 };
	mg_vars.start_zone = start_zone
	mg_vars.end_zone = end_zone
	mg_vars.boats_spawn = { x = 96, z = 36 };
	mg_vars.blast_timer = 2*12;
	mg_vars.last_model = M_SPELL_NONE;
	mg_vars.angel_cd = 0;
	mg_vars.checkpoints_boat_wars = {
function() return rndb(92, 106), 72 end,
function () return 164, rndb(96, 106) end,
function () return rndb(188, 206), 40 end,
function () return 190, 210 end,
function () return rndb(140, 150), 174 end,
function () return 240, 180 end,
function () return 84, rndb(166, 170) end,
function () return 96, 6 end,
}
end

function reset_tribe_boat_c2d(tribe)
	local ai = mg_player_vars[tribe]
	ai.targ_xz_idx = 1
	local x, z = mg_vars.checkpoints_boat_wars[ai.targ_xz_idx]()
	ai.targ_c2d = coord_to_c2d(x, z)
	ai.deadlock = true
end

function boat_race_init_single_AI(player)
	local ai = mg_player_vars[player]
	
	reset_tribe_boat_c2d(player)
	ai.blast_boat_cdr = 12*rndb(14, 20)
	ai.blast_enemies_cdr = 12*rndb(16, 22)
	ai.higher_spell_cdr = 12*rndb(24, 28)
end

function increase_boat_c2d(shaman, ai, diff)
	if ai.targ_xz_idx < #mg_vars.checkpoints_boat_wars then
		ai.targ_xz_idx = ai.targ_xz_idx + 1
		local x, z = mg_vars.checkpoints_boat_wars[ai.targ_xz_idx](diff)
		ai.targ_c2d = coord_to_c2d(x, z)
	end
end

function move_to_boat_c2d(shaman, ai)
	command_person_go_to_coord2d(shaman, ai.targ_c2d)
end

function try_to_spell_an_enemy_2(tribe, spell, radius, _chance, ai, difficulty)
	if chance(_chance) and not shaman_casting(tribe) then
		local random_enemy = get_random_enemy_shaman_near_thing(getShaman(tribe), radius)
		
		if random_enemy ~= nil then
			if shaman_has_healthy_state(tribe) then
				local t = createThing(T_SPELL, spell, tribe, random_enemy.Pos.D3, false, false)
				
				if not mg_vars.nosclick then
					if shaman_has_healthy_state(random_enemy.Owner) then
						if chance(70+difficulty*10) then
							t.u.Spell.TargetThingIdx:set(random_enemy.ThingNum)
						end
					end
				end
				return true
			end
		end
	end
	
	return false
end

function find_boat_higher_spell(tribe)
	local spells = {M_SPELL_LIGHTNING_BOLT, M_SPELL_WHIRLWIND, M_SPELL_FIRESTORM, M_SPELL_ANGEL_OF_DEATH}
	local tbl = {}
	
	for _, spell in ipairs(spells) do
		if (I_HAVE_ONE_SHOT(tribe, T_SPELL, spell) == true) then
			table.insert(tbl, spell)
		end
	end
	
	return randomItemFromTable(tbl)
end

function GetRandomSpellModel()
	local model = M_SPELL_BLAST;
	local very_rare = G_RANDOM(11);
	if (very_rare >= 9) then
		model = M_SPELL_ANGEL_OF_DEATH;
	else
		local medium_rare_steak = G_RANDOM(10);
		if (medium_rare_steak >= 8) then
			model = M_SPELL_FIRESTORM;
		else
			local rare = G_RANDOM(7);
			if (rare >= 5) then
				model = M_SPELL_SHIELD;
			else
				local common = G_RANDOM(4);
				if (common >= 2) then
					model = M_SPELL_WHIRLWIND;
				else
					model = M_SPELL_LIGHTNING_BOLT;
				end
			end
		end
	end
	if (model == mg_vars.last_model) then
		local new = G_RANDOM(10);
		if (new >= 5) then
			model = M_SPELL_CONVERT_WILD;
		else
			model = GetRandomSpellModel(); -- second try, adds some variety
		end
	end
	mg_vars.last_model = model;
	return model;
end

function CacheSafeZones()
	if (#mg_vars.positions == 0) then
		-- Start zone
		SearchMapCells(SQUARE, 0, 0, 8, world_coord3d_to_map_idx(mg_vars.start_zone), function(me)
			local map_idx = MAP_ELEM_PTR_2_IDX(me);
			table.insert(mg_vars.positions, map_idx);
			return true;
		end)
	
		-- End zone
		SearchMapCells(SQUARE, 0, 0, 6, world_coord3d_to_map_idx(mg_vars.end_zone), function(me)
			local map_idx = MAP_ELEM_PTR_2_IDX(me);
			table.insert(mg_vars.positions, map_idx);
			return true;
		end)
	end
end

function ProcessAngelSpawn(sx, sz, ax, az)
	-- sx, sz = shaman pos (will trigger the spawn if she's in that area)
	-- ax, az = aod spawn pos 
	if (mg_vars.angel_cd <= 0) then
		local do_quit = false;
		SearchMapCells(SQUARE, 0, 0, 8, world_coord3d_to_map_idx(MAP_XZ_2_WORLD_XYZ(sx, sz)), function(me)
			me.MapWhoList:processList(function(t)
				if (t.Type == T_PERSON and t.Model == M_PERSON_MEDICINE_MAN) then
					local owner = t.Owner + 1;
					if (owner > 7) then
						owner = 0;
					end
					createThing(T_PERSON, M_PERSON_ANGEL, owner, MAP_XZ_2_WORLD_XYZ(ax, az), false, false)
					mg_vars.angel_cd = 12*20;
					do_quit = true;
					return false;
				end
				return true;
			end)
			if (do_quit == true) then
				return false;
			end
			return true;
		end)
	else
		if (mg_vars.angel_cd > 0) then
			mg_vars.angel_cd = mg_vars.angel_cd - 1;
		end
	end
end

function CheckMS(pn) 
	if (I_HAVE_ONE_SHOT(pn, T_SPELL, M_SPELL_SHIELD) == true) then
		disable_spell(pn, M_SPELL_SHIELD, true);
		local shaman = getShaman(pn);
		if (shaman ~= nil) then
			shaman.u.Pers.u.Owned.ShieldCount = 20;
			shaman.Flags3 = EnableFlag(shaman.Flags3, TF3_SHIELD_ACTIVE);
		end
	end
end

function ProcessBoats(x, z)
	local boats = count_boats(nil, x, z, 7);

	if (boats < 8) then
		for i=boats,8,1 do
			local boat = create_thing_cache(T_VEHICLE, M_VEHICLE_BOAT_1, SAFE_NEUTRAL, MAP_XZ_2_WORLD_XYZ(x, z))
		end
	end
end

function ProcessAngelsInSafeZones()
	ProcessGlobalTypeList(T_PERSON, function(t)
		if (t.Model == M_PERSON_ANGEL) then
			local pos = world_coord3d_to_map_idx(t.Pos.D3);
			for _, v in pairs(mg_vars.positions) do
				if (v == pos) then
					t.u.Pers.Life = 0;
					break;
				end
			end
		end
		return true
	end)
end

function ProcessEndZone()
	for _, c3d in ipairs(mg_vars.fireballs_tbl) do
		local f = createThing(T_EFFECT, M_EFFECT_FIREBALL, 0, c3d, false, false);
	end
end

function init_mg_constants()
	local a, b = M_SPELL_VOLCANO, M_SPELL_TELEPORT
	local stiA, stiB = sti[a], sti[b]

	stiA.AvailableSpriteIdx = stiB.AvailableSpriteIdx;
	stiA.NotAvailableSpriteIdx = stiB.NotAvailableSpriteIdx;
	stiA.ClickedSpriteIdx = stiB.ClickedSpriteIdx;
	stiA.ToolTipStrIdx = stiB.ToolTipStrIdx; 
	stiA.ToolTipStrIdxLSME = stiB.ToolTipStrIdxLSME;
	stiA.CursorSpriteNum = stiB.CursorSpriteNum;
	stiA.DiscoveryDrawIdx = stiB.DiscoveryDrawIdx;

	a, b = M_SPELL_CONVERT_WILD, M_SPELL_BLAST
	stiA, stiB = sti[a], sti[b]
	
	stiA.AvailableSpriteIdx = stiB.ClickedSpriteIdx;
	stiA.NotAvailableSpriteIdx = stiB.NotAvailableSpriteIdx;
	stiA.ClickedSpriteIdx = stiB.ClickedSpriteIdx;
	stiA.ToolTipStrIdx = stiB.ToolTipStrIdx;
	stiA.ToolTipStrIdxLSME = stiB.ToolTipStrIdxLSME;
	stiA.CursorSpriteNum = stiB.CursorSpriteNum;
	stiA.DiscoveryDrawIdx = stiB.DiscoveryDrawIdx;
	stiA.Flags = stiB.Flags;

	pti[M_PERSON_ANGEL].DefaultLife = 1000; -- 10.000 default
end

function check_if_in_endzone(pn)
	local alive = true
	
	if (IS_SHAMAN_IN_AREA(pn, 33, 1) > 0) then
		give_points_to_team(1, pn, true)
		queue_fixed_sound_event(SND_EVENT_PLACE_BOAT_HUT, 0)
		delete_thing_type_safe(getShaman(pn))
		alive = false
	end
	
	return alive
end

function sink_empty_boats_near_end()
	local mk_c2d = marker_to_coord2d(33)
	
	ProcessGlobalTypeList(T_VEHICLE, function(boat)
		if boat.Model < 3 then
			if chance(50) then
				if get_world_dist_xz(boat.Pos.D2, mk_c2d) <= 512*6 then
					if vehicle_empty(boat) then
						boat.State = S_VEHICLE_BOAT_DYING
					end
				end
			end
		end
	return true end)
end

function boat_race_process_shamans(everySecond1, everySecond2, everySecond4)
	for _, player in ipairs(_participants) do
		local tribe = player.tribe
		local ai = player.ai
		local alive = process_death_shamans(tribe, player)
		
		CheckMS(tribe)
		
		if alive then
			if everySecond1 then
				alive = check_if_in_endzone(tribe)
			end
		end
		
		if ai then
			local diff = player.diff
			BR1_process_AI(tribe, alive, everySecond1, everySecond2, everySecond4, diff)
		end
	end
end

function ProcessPowerUps()
	-- for new powerups method
	if not (mg_vars.power_up_mode == 1) then return end
	
	local pup_cds = mg_vars.powerup_cds
	local wtf_is_this = (_gsi.Counts.ProcessThings & 12 == 0)
	local pup_cdr = mg_vars.POWERUP_CD
	
	for i=0,mg_vars.powerup_markers,1 do
		local spawned_effects = 0;
		local exit_block = false;
		--local e_c3d = Coord3D.new();
		--map_idx_to_world_coord3d(_gnsi.ThisLevelHeader.Markers[i], e_c3d);
		--create_thing(T_EFFECT, M_EFFECT_FIREBALL, 0, e_c3d, false, false);
		if (pup_cds[i] == 0) then
			SearchMapCells(CIRCULAR, 0, 0, 2, _gnsi.ThisLevelHeader.Markers[i], function(me)
				if wtf_is_this then
					if (spawned_effects % 2 == 0) then
						local c3d = Coord3D.new();
						local map_idx = MAP_ELEM_PTR_2_IDX(me);
						map_idx_to_world_coord3d(map_idx, c3d);
						createThing(T_EFFECT, M_EFFECT_SMALL_SPARKLE, 0, c3d, false, false);
					end
					spawned_effects = spawned_effects + 1;
				end

				me.MapWhoList:processList(function(t)
					if (t.Type == T_PERSON and t.Model == M_PERSON_MEDICINE_MAN) then
						if (i <= 2) then
							for j=2,0,-1 do
								pup_cds[2-j] = pup_cdr
							end
						elseif (i <= 5) then
							for j=2,0,-1 do
								pup_cds[5-j] = pup_cdr
							end
						elseif (i <= 8) then
							for j=2,0,-1 do
								pup_cds[8-j] = pup_cdr
							end
						elseif (i <= 11) then
							for j=2,0,-1 do
								pup_cds[11-j] = pup_cdr
							end
						elseif (i <= 14) then
							for j=2,0,-1 do
								pup_cds[14-j] = pup_cdr
							end
						end
						
						if (G_RANDOM(11) == 0) then
							ProcessGlobalTypeList(T_VEHICLE, function(_t)
								if (_t.u.Vehicle.NumOccupants > 0 and _t.Owner ~= t.Owner) then
									local blast = createThing(T_SPELL, M_SPELL_BLAST, t.Owner, _t.Pos.D3, false, false);
									blast.u.Spell.TargetThingIdx:set(_t.ThingNum);
								end
								return true
							end)
						end

						local spell = GetRandomSpellModel();
						if (spell == M_SPELL_SHIELD) then
							t.u.Pers.u.Owned.ShieldCount = 20;
							t.Flags3 = EnableFlag(t.Flags3, TF3_SHIELD_ACTIVE);
							return false;
						end

						if (spell == M_SPELL_WHIRLWIND) then
							GIVE_ONE_SHOT(spell, t.Owner); -- Double shots
						end
						GIVE_ONE_SHOT(spell, t.Owner);
						exit_block = true;
						return false;
					end
					return true;
				end)
				if (exit_block) then
					return false;
				end
				return true;
			end)
		else
			pup_cds[i] = pup_cds[i] - 1;
		end
	end
end

function CreatePowerUp(marker, model)
	local c3d = Coord3D.new();
	map_idx_to_world_coord3d(_gnsi.ThisLevelHeader.Markers[marker], c3d);
	local d = createThing(T_GENERAL, M_GENERAL_DISCOVERY, 0, c3d, false, false);
	local t = createThing(T_GENERAL, M_GENERAL_TRIGGER, 0, c3d, false, false);
	d.u.Discovery.DiscoveryType = T_SPELL;
	d.u.Discovery.DiscoveryModel = model;
	d.u.Discovery.AvailabilityType = AVAILABLE_ONCE; -- 3
	d.u.Discovery.TriggerType = DISCOVERY_TRIGGER_IMMEDIATE; -- 1
	t.u.Trigger.EditorThingIdxs[0] = d.ThingNum;
	t.u.Trigger.CreatePlayerOwned = 1;
	
	insert_thing_in_cache(d)
	insert_thing_in_cache(t)
end

function ProcessPermanentPowerUps()
	local powerup_perm_list = mg_vars.powerup_perm_list
	
	for i=1,#powerup_perm_list,1 do
		local pup = powerup_perm_list[i]
		local exists = false;
		local me = marker_to_elem_ptr(pup.Marker);	
		me.MapWhoList:processList(function(t)
			if (t.Type == T_GENERAL and t.Model == M_GENERAL_DISCOVERY) then
				exists = true;
			end
			return true;
		end)
		
		if (exists == false) then
			pup.CurrCooldown = pup.CurrCooldown - 1;
			if (pup.CurrCooldown <= 0) then	
				local model = pup.Model;
				if (model == -1) then model = GetRandomSpellModel(); end
				CreatePowerUp(pup.Marker, model);
				pup.CurrCooldown = pup.Cooldown;	
			end
		end
	end
end

function boat_race_I_on_turn(everySecond1, everySecond2, everySecond4)
	if mg_turn == 1 then
		BR1_refresh_mg_variables()
		for _, player in ipairs(_ai_participants) do
			boat_race_init_single_AI(player.ptr.tribe)
		end
		init_mg_constants()
		disable_spells_effects_for_this_level({M_SPELL_VOLCANO, M_SPELL_CONVERT_WILD})
		CacheSafeZones()
		
		for _, player in ipairs(_participants) do
			enable_spell(player.tribe, M_SPELL_BLAST)
		end
		
		for i=0,mg_vars.powerup_markers,1 do
			if (mg_vars.power_up_mode == 0) then
				CreatePowerUp(i, GetRandomSpellModel())
			end
		end
		
		mg_vars.faster_boats = is_map_rule_active(1)
		mg_vars.nosclick = is_map_rule_active(2)
	end
	
	if mg_vars.faster_boats then
		local max = 512*16
		ProcessGlobalSpecialListAll(BOATLIST, function(t)
			if t.u.Vehicle.NumOccupants > 0 then
				if get_world_dist_xz(t.Pos.D2, mg_vars.mid_zone_c2d) > max then
					t.Move.SelfPowerSpeed = 220 --110 default
				end
			end
		return true end)
	end
	
	ProcessPermanentPowerUps();
	
	if everyTurns_mg(2) then
		ProcessPowerUps();
	end

	if everyTurns_mg(16) then
		ProcessEndZone();
	end

	if everyTurns_mg(32) then
		ProcessAngelsInSafeZones();
		local boatstbl = mg_vars.boats_spawn
		ProcessBoats(boatstbl.x, boatstbl.z);
	end
	
	ProcessAngelSpawn(144, 178, 168, 166);

	if (mg_vars.blast_timer > 0) then
		mg_vars.blast_timer = mg_vars.blast_timer - 1;
		if (mg_vars.blast_timer == 0) then
			for _, player in ipairs(_participants) do
				GIVE_ONE_SHOT(M_SPELL_BLAST, player.tribe);
				GIVE_ONE_SHOT(M_SPELL_VOLCANO, player.tribe);
			end
			mg_vars.blast_timer = 2*12;
		end
	end
	
	if everyTurns_mg(200) then
		sink_empty_boats_near_end()
		createThing(T_EFFECT, M_EFFECT_FIRESTORM, SAFE_NEUTRAL, coord_to_c3d(2,164), false,false)
	end
	
	if everyTurns_mg(260) then
		createThing(T_EFFECT, M_EFFECT_FIRESTORM, SAFE_NEUTRAL, coord_to_c3d(210,30), false,false)
		createThing(T_EFFECT, M_EFFECT_FIRESTORM, SAFE_NEUTRAL, coord_to_c3d(210,6), false,false)
	end
	
	if everyTurns_mg(320) then
		createThing(T_EFFECT, M_EFFECT_FIRESTORM, SAFE_NEUTRAL, coord_to_c3d(184,30), false,false)
		createThing(T_EFFECT, M_EFFECT_FIRESTORM, SAFE_NEUTRAL, coord_to_c3d(184,6), false,false)
	end
	
	boat_race_process_shamans(everySecond1, everySecond2, everySecond4)
	
	if everySecond4 then
		AI_shaman_stuck_checker(256, AI_UNSTUCK_METHOD_KILL)
	end
end

function boat_race_on_create_thing(t, owner, type, model)
	if not (type == T_SPELL) then return end
	
	if (model == M_SPELL_VOLCANO) then
		local spawn_zone = mg_vars.spawn_zone
		local c3d = MAP_XZ_2_WORLD_XYZ(spawn_zone.x, spawn_zone.z)
		createThing(T_EFFECT, M_EFFECT_TELEPORT, owner, c3d, false, false);
		--t.Model = _NO_SPELL_MODEL;
		--insert_c3d_from_land_location(c3d) 
	else
		local dont
		local pos = world_coord3d_to_map_idx(t.Pos.D3);
		for _, v in pairs(mg_vars.positions) do
			if (v == pos) then
				t.Model = _NO_SPELL_MODEL;
				dont = true
				break;
			end
		end

		if (model == M_SPELL_CONVERT_WILD and (not dont)) then
			--t.Model = _NO_SPELL_MODEL;
			createThing(T_EFFECT, M_EFFECT_SIMPLE_BLAST, owner, t.Pos.D3, false, false);
			ProcessGlobalTypeList(T_VEHICLE, function(_t)
			--	if (is_thing_on_ground(_t) > 0) then
					if (_t.u.Vehicle.NumOccupants > 0) then
						createThing(T_EFFECT, M_EFFECT_SIMPLE_BLAST, _t.Owner, _t.Pos.D3, false, false);
					end
			--	end
				return true
			end)
		else
			if mg_vars.nosclick then
				if not t.u.Spell then return end
				
				local targindex = t.u.Spell.TargetThingIdx
				
				if (not targindex:isNull()) then
					local clicked_owner = targindex:get().Owner
					if clicked_owner ~= owner then
						targindex:set(0)
					end
				end
			end
		end
	end
end

function BR1_process_AI(tribe, alive, everySecond1, everySecond2, everySecond4, diff)
	local shaman = getShaman(tribe)
	local ai = mg_player_vars[tribe]
	--local c2d = ai.powerup_chasing
	
	ai.blast_boat_cdr = ai.blast_boat_cdr - 1
	ai.blast_enemies_cdr = ai.blast_enemies_cdr - 1
	ai.higher_spell_cdr = ai.higher_spell_cdr - 1

	if alive then
		ai.deadlock = true
		local vehicled = is_person_in_boat(shaman) > 0
		local shaman_c2d = copy_c2d(shaman.Pos.D2)
		
		if everySecond1 then
			if vehicled then
				if get_world_dist_xz(ai.targ_c2d, shaman_c2d) <= 512*4 then
					increase_boat_c2d(shaman, ai, diff)
				end
				
				move_to_boat_c2d(shaman, ai)
			else
				if IS_SHAMAN_IN_AREA(tribe, 34, 7) > 0 then
					if not boat_race_unstuck_multiplayer_ai_shaman(tribe, shaman) then
						if shaman.State ~= S_PERSON_UNDER_COMMAND then
							local boat = get_me_a_random_boat_in_location(nil, 96, 32, 5)
							
							if boat then
								command_person_enter_vehicle(shaman, boat)
							else
								command_person_go_to_coord2d(shaman, coord_to_c2d(rndb(86,106), 28))
							end
						end
					end
				end
			end
			if chance(1) then
				if chance(10) then
					create_emote(tribe)
				end
			end
		end

		if get_world_dist_xz(shaman_c2d, marker_to_coord2d(33)) > 512*3 then
			if get_world_dist_xz(shaman_c2d, marker_to_coord2d(34)) > 512*10 then
				if everySecond4 then
					if not vehicled then
						if chance(70 + diff*10) then
							if shaman_has_healthy_state(tribe) then
								createThing(T_SPELL, M_SPELL_VOLCANO, tribe, shaman.Pos.D3, false, false)
								reset_tribe_boat_c2d(tribe)
								if chance(40) then
									create_emote(tribe, randomItemFromTable(_disappointed_emojis))
								end
							end
						end
					end
				end
				
				if ai.blast_boat_cdr <= 0 then
					if everySecond1 then
						local success = try_to_blast_own_boat(tribe, shaman, 20 + diff*20)
						
						if success then
							ai.blast_boat_cdr = rndb(12*6, 12*(12-diff*2)) - diff*12 * rndb(1,2)
							if chance(20) then
								create_emote(tribe)
							end
						else
							ai.blast_boat_cdr = rndb(12*(4-diff), 12*(6-diff))
						end
					end
				end
				
				if ai.higher_spell_cdr <= 0 then
					local spell = find_boat_higher_spell(tribe)
					
					if spell ~= nil then
						local success = try_to_spell_an_enemy_2(tribe, spell, 5, 30 + diff*20, ai, diff)
						
						if success then
							ai.higher_spell_cdr = rndb(12*(16-diff), 12*(26-diff)) - diff*12 * rndb(1,3)
						else
							ai.higher_spell_cdr = rndb(12*(12-diff), 12*(14-diff))
						end
					end
				end
				
				if ai.blast_enemies_cdr <= 0 then
					local success = try_to_spell_an_enemy_2(tribe, M_SPELL_BLAST, 5, 20 + diff*20, ai, diff)
					
					if success then
						ai.blast_enemies_cdr = rndb(12*(10-diff), 12*(16-diff)) - diff*12 * rndb(1,2)
					else
						ai.blast_enemies_cdr = rndb(12*(8-diff), 12*(10-diff))
					end
				end
			end
		end
	else
		if ai.deadlock then
			reset_tribe_boat_c2d(tribe)
			ai.deadlock = false
		end
	end
end

----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
--BOAT RACE II----------------------------------BOAT RACE II--------------------------------------------------------BOAT RACE II---------------------------------------------------------BOAT RACE II---
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

function boat_race_2_process_shamans(everySecond1, everySecond2, everySecond4)
	for _, player in ipairs(_participants) do
		local tribe = player.tribe
		local ai = player.ai
		local alive = process_death_shamans(tribe, player)
		
		CheckMS(tribe)
		
		if alive then
			if everySecond1 then
				alive = check_if_in_endzone(tribe)
			end
		end
		
		if ai then
			local diff = player.diff
			BR2_process_AI(tribe, alive, everySecond1, everySecond2, everySecond4, diff)
		end
	end
end

function boat_race_unstuck_multiplayer_ai_shaman(tribe, shaman)
	--need this in MP, in SP it works fine without...
	--just cache pos, and it keeps for too long in that pos, reset
	--if not multiplayer then return false end
	
	if (IS_SHAMAN_IN_AREA(tribe, 34, 2) > 0) and chance(30) then
		reset_tribe_boat_c2d(tribe)
		remove_shaman_melee(tribe)
		shaman.State = S_PERSON_NONE
		shaman.Flags = EnableFlag(shaman.Flags, TF_RESET_STATE)
		return true
	end
	
	return false
end

function BR2_process_AI(tribe, alive, everySecond1, everySecond2, everySecond4, diff)
	--in this small boat race, AI blasting less often seem to be stronger?? maybe not though
	--it's super close in all tests, but more often still won most times (close calls)
	local shaman = getShaman(tribe)
	local ai = mg_player_vars[tribe]
	--local c2d = ai.powerup_chasing
	
	ai.blast_boat_cdr = ai.blast_boat_cdr - 1
	ai.blast_enemies_cdr = ai.blast_enemies_cdr - 1
	ai.higher_spell_cdr = ai.higher_spell_cdr - 1

	if alive then
		ai.deadlock = true
		local vehicled = is_person_in_boat(shaman) > 0
		local shaman_c2d = copy_c2d(shaman.Pos.D2)
		
		if everySecond1 then
			if vehicled then
				if get_world_dist_xz(ai.targ_c2d, shaman_c2d) <= 512*4 then
					increase_boat_c2d(shaman, ai)
				end
				
				move_to_boat_c2d(shaman, ai)
			else
				if IS_SHAMAN_IN_AREA(tribe, 34, 7) > 0 then
					if not boat_race_unstuck_multiplayer_ai_shaman(tribe, shaman) then
						if shaman.State ~= S_PERSON_UNDER_COMMAND then
							local boat = get_me_a_random_boat_in_location(nil, 96, 32, 5)
							
							if boat then
								command_person_enter_vehicle(shaman, boat)
							else
								command_person_go_to_coord2d(shaman, coord_to_c2d(rndb(86,106), 28))
							end
						else
							--in multiplayer, this might be needed idk why
							if chance(4) then
								reset_tribe_boat_c2d(tribe)
							end
						end
					end
				end
			end
			if chance(1) then
				if chance(10) then
					create_emote(tribe)
				end
			end
		end

		if get_world_dist_xz(shaman_c2d, marker_to_coord2d(33)) > 512*3 then
			if get_world_dist_xz(shaman_c2d, marker_to_coord2d(34)) > 512*10 then
				if everySecond4 then
					if not vehicled then
						if chance(70 + diff*10) then
							if shaman_has_healthy_state(tribe) then
								createThing(T_SPELL, M_SPELL_VOLCANO, tribe, shaman.Pos.D3, false, false)
								reset_tribe_boat_c2d(tribe)
								if chance(40) then
									create_emote(tribe, randomItemFromTable(_disappointed_emojis))
								end
							end
						end
					end
				end
				
				if ai.blast_boat_cdr <= 0 then
					if everySecond1 then
						local success = try_to_blast_own_boat(tribe, shaman, 20 + diff*20)
						
						if success then
							--ai.blast_boat_cdr = rndb(12*6, 12*(14-diff*3)) - diff*12 * rndb(1,2) --NORMAL
							ai.blast_boat_cdr = rndb(12*6, 12*(14-(2-diff)*3)) - (2-diff)*12 * rndb(1,2) --INVERTED IF NEEDED
							if chance(20) then
								create_emote(tribe)
							end
						else
							ai.blast_boat_cdr = rndb(12*(4-diff), 12*(6-diff)) --NORMAL
							--ai.blast_boat_cdr = rndb(12*(2+diff), 12*(4+diff)) --INVERTED IF NEEDED
						end
					end
				end
				
				if ai.higher_spell_cdr <= 0 then
					local spell = find_boat_higher_spell(tribe)
					
					if spell ~= nil then
						local success = try_to_spell_an_enemy_2(tribe, spell, 5, 30 + diff*20, ai, diff)
						
						if success then
							ai.higher_spell_cdr = rndb(12*(16-diff), 12*(26-diff)) - diff*12 * rndb(1,3)
						else
							ai.higher_spell_cdr = rndb(12*(12-diff), 12*(14-diff))
						end
					end
				end
				
				if ai.blast_enemies_cdr <= 0 then
					local success = try_to_spell_an_enemy_2(tribe, M_SPELL_BLAST, 5, 20 + diff*20, ai, diff)
					
					if success then
						ai.blast_enemies_cdr = rndb(12*(10-diff), 12*(16-diff)) - diff*12 * rndb(1,2)
					else
						ai.blast_enemies_cdr = rndb(12*(8-diff), 12*(10-diff))
					end
				end
			end
		end
	else
		if ai.deadlock then
			reset_tribe_boat_c2d(tribe)
			ai.deadlock = false
		end
	end
end

function BR2_refresh_mg_variables()
	mg_vars.positions = {}
	mg_vars.end_only_positions = {}
	mg_vars.power_up_mode = 1
	mg_vars.powerup_markers = 14
	mg_vars.POWERUP_CD = 10*4
	mg_vars.powerup_cds = { [0]= 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
	mg_vars.spawn_zone = { x = 96, z = 22, marker = 34 };
	local start_zone = Coord3D.new();
	start_zone = MAP_XZ_2_WORLD_XYZ(96, 28)
	mg_vars.start_zone = start_zone
	local end_zone = Coord3D.new();
	end_zone = MAP_XZ_2_WORLD_XYZ(98, 4)
	mg_vars.end_zone = end_zone
	mg_vars.boats_spawn = { x = 96, z = 36 };
	mg_vars.last_model = M_SPELL_NONE;
	mg_vars.angel_cd = 0
	mg_vars.blast_timer = 12*2;
	mg_vars.powerup_perm_list = { 
	{
		Marker = 27,
		Model = M_SPELL_CONVERT_WILD,
		Cooldown = 12*20,
		CurrCooldown = 0;
	},
	{
		Marker = 36,
		Model = M_SPELL_ANGEL_OF_DEATH,
		Cooldown = 12*20,
		CurrCooldown = 0;
	},
	{
		Marker = 37,
		Model = M_SPELL_FIRESTORM,
		Cooldown = 12*20,
		CurrCooldown = 0;
	},
	{
		Marker = 38,
		Model = M_SPELL_CONVERT_WILD,
		Cooldown = 12*20,
		CurrCooldown = 0;
	},
	{
		Marker = 39,
		Model = M_SPELL_SHIELD,
		Cooldown = 12*20,
		CurrCooldown = 0;
	},
};
	local fireballs_tbl = {}
	SearchMapCells(CIRCULAR, 0, 0, 2, world_coord3d_to_map_idx(MAP_XZ_2_WORLD_XYZ(96, 6)), function(me)
		local c3d = Coord3D.new();
		local map_idx = MAP_ELEM_PTR_2_IDX(me);
		map_idx_to_world_coord3d(map_idx, c3d);
		table.insert(fireballs_tbl, c3d)
	    return true;
	end)
	mg_vars.fireballs_tbl = fireballs_tbl
	mg_vars.checkpoints_boat_wars = {
function() return rndb(90, 98), rndb(84, 90) end,
function() return rndb(56, 72), rndb(84, 88) end,
function() return chance(50) and 64 or (chance(50) and 72 or 56), 244 end,
function() return rndb(64, 70), rndb(206, 214) end,
function() return rndb(90, 94), rndb(208,214) end,
function() return 96, 6 end,
}
end

function BR2_init_mg_constants()
	local sti2 = sti[M_SPELL_VOLCANO]
	local sti2_b = sti[M_SPELL_TELEPORT]
	sti2.AvailableSpriteIdx = sti2_b.AvailableSpriteIdx;
	sti2.NotAvailableSpriteIdx = sti2_b.NotAvailableSpriteIdx;
	sti2.ClickedSpriteIdx = sti2_b.ClickedSpriteIdx;
	sti2.ToolTipStrIdx = sti2_b.ToolTipStrIdx;
	sti2.ToolTipStrIdxLSME = sti2_b.ToolTipStrIdxLSME;
	sti2.CursorSpriteNum = sti2_b.CursorSpriteNum;
	sti2.DiscoveryDrawIdx = sti2_b.DiscoveryDrawIdx;
	
	sti2 = sti[M_SPELL_CONVERT_WILD]
	sti2_b = sti[M_SPELL_BLAST]
	sti2.AvailableSpriteIdx = sti2_b.AvailableSpriteIdx;
	sti2.NotAvailableSpriteIdx = sti2_b.NotAvailableSpriteIdx;
	sti2.ClickedSpriteIdx = sti2_b.ClickedSpriteIdx;
	sti2.ToolTipStrIdx = sti2_b.ToolTipStrIdx;
	sti2.ToolTipStrIdxLSME = sti2_b.ToolTipStrIdxLSME;
	sti2.CursorSpriteNum = sti2_b.CursorSpriteNum;
	sti2.DiscoveryDrawIdx = sti2_b.DiscoveryDrawIdx;
	sti2.Flags = sti2_b.Flags;

	pti[M_PERSON_ANGEL].DefaultLife = 1000; -- 10.000 default
end

function boat_race_2_on_turn(everySecond1, everySecond2, everySecond4)
	if mg_turn == 1 then
		disable_spells_effects_for_this_level({M_SPELL_VOLCANO, M_SPELL_CONVERT_WILD})
		BR2_init_mg_constants()
		BR2_refresh_mg_variables()
		CacheSafeZones()

		for _, player in ipairs(_ai_participants) do
			boat_race_init_single_AI(player.ptr.tribe)
		end
		
		for _, player in ipairs(_participants) do
			enable_spell(player.tribe, M_SPELL_BLAST)
		end
		
		for i=0,mg_vars.powerup_markers,1 do
			if (mg_vars.power_up_mode == 0) then
				CreatePowerUp(i, GetRandomSpellModel())
			end
		end
		
		ProcessBoats(mg_vars.boats_spawn.x, mg_vars.boats_spawn.z)
		mg_vars.nosclick = is_map_rule_active(1)
		mg_vars.braves_deadly_zones = { world_coord2d_to_map_idx(coord_to_c2d(84, 46)), world_coord2d_to_map_idx(coord_to_c2d(82, 46)), 
										world_coord2d_to_map_idx(coord_to_c2d(78, 46)) }
										
		for i = 0, 7 do
			local x = (i <= 3) and 81 or 79
			local z = (i <= 3) and (72+i*2) or (76 - (i-4)*2)
			local c3d = coord_to_c3d(x, z)
			
			for amt = 1, 5 do
				local t = create_thing_cache(T_PERSON, M_PERSON_BRAVE, i, c3d, false, false)
			end
		end
		
		insert_c3d_from_land_location(coord_to_c3d(64,56))
		insert_c3d_from_land_location(coord_to_c3d(64,226))
	end
	
	ProcessPermanentPowerUps()
	
	if everyTurns_mg(2) then
		ProcessPowerUps()
	end
	
	if everyTurns_mg(4) then
		ProcessEndZone()
	end
	
	if everyTurns_mg(32) then
		ProcessAngelsInSafeZones();
		local boatstbl = mg_vars.boats_spawn
		ProcessBoats(boatstbl.x, boatstbl.z);
		--ProcessEndZoneVehicles();
	end
	
	ProcessAngelSpawn(64, 250, 64, 226);
	
	if (mg_vars.blast_timer > 0) then
		mg_vars.blast_timer = mg_vars.blast_timer - 1;
		if (mg_vars.blast_timer == 0) then
			for _, player in ipairs(_participants) do
				GIVE_ONE_SHOT(M_SPELL_BLAST, player.tribe);
				GIVE_ONE_SHOT(M_SPELL_VOLCANO, player.tribe);
			end
			mg_vars.blast_timer = 2*12;
		end
	end
	
	if everyTurns_mg(300) then
		sink_empty_boats_near_end()
		createThing(T_EFFECT, M_EFFECT_HILL, SAFE_NEUTRAL, coord_to_c3d(64,56), false,false)
		createThing(T_EFFECT, M_EFFECT_HILL, SAFE_NEUTRAL, coord_to_c3d(64,226), false,false)
	end
	
	if everyTurns_mg(450) then
		createThing(T_EFFECT, M_EFFECT_EROSION, SAFE_NEUTRAL, coord_to_c3d(64, 58), false,false)
		createThing(T_EFFECT, M_EFFECT_EROSION, SAFE_NEUTRAL, coord_to_c3d(64, 56), false,false)
		createThing(T_EFFECT, M_EFFECT_EROSION, SAFE_NEUTRAL, coord_to_c3d(64, 54), false,false)
		createThing(T_EFFECT, M_EFFECT_EROSION, SAFE_NEUTRAL, coord_to_c3d(64, 228), false,false)
		createThing(T_EFFECT, M_EFFECT_EROSION, SAFE_NEUTRAL, coord_to_c3d(64, 226), false,false)
		createThing(T_EFFECT, M_EFFECT_EROSION, SAFE_NEUTRAL, coord_to_c3d(64,224), false,false)
	end
	
	if everyTurns_mg(40) then
		createThing(T_EFFECT, M_EFFECT_SIMPLE_BLAST, SAFE_NEUTRAL, coord_to_c3d(64, 32), false,false)
		createThing(T_EFFECT, M_EFFECT_FIREBALL, SAFE_NEUTRAL, coord_to_c3d(64, 32), false,false)
		createThing(T_EFFECT, M_EFFECT_SIMPLE_BLAST, SAFE_NEUTRAL, coord_to_c3d(72, 4), false,false)
		createThing(T_EFFECT, M_EFFECT_FIREBALL, SAFE_NEUTRAL, coord_to_c3d(72, 4), false,false)
	end
	
	if everyTurns_mg(30) then
		createThing(T_EFFECT, M_EFFECT_SIMPLE_BLAST, SAFE_NEUTRAL, coord_to_c3d(56, 30), false,false)
		createThing(T_EFFECT, M_EFFECT_FIREBALL, SAFE_NEUTRAL, coord_to_c3d(56, 30), false,false)
		createThing(T_EFFECT, M_EFFECT_SIMPLE_BLAST, SAFE_NEUTRAL, coord_to_c3d(72, 18), false,false)
		createThing(T_EFFECT, M_EFFECT_FIREBALL, SAFE_NEUTRAL, coord_to_c3d(72, 18), false,false)
		createThing(T_EFFECT, M_EFFECT_SIMPLE_BLAST, SAFE_NEUTRAL, coord_to_c3d(56, 4), false,false)
		createThing(T_EFFECT, M_EFFECT_FIREBALL, SAFE_NEUTRAL, coord_to_c3d(56, 4), false,false)
	end
	
	if everyTurns_mg(35) then
		createThing(T_EFFECT, M_EFFECT_SIMPLE_BLAST, SAFE_NEUTRAL, coord_to_c3d(64, 18), false,false)
		createThing(T_EFFECT, M_EFFECT_FIREBALL, SAFE_NEUTRAL, coord_to_c3d(64, 18), false,false)
	end
	
	if everyTurns_mg(45) then
		createThing(T_EFFECT, M_EFFECT_SIMPLE_BLAST, SAFE_NEUTRAL, coord_to_c3d(64, 24), false,false)
		createThing(T_EFFECT, M_EFFECT_FIREBALL, SAFE_NEUTRAL, coord_to_c3d(64, 24), false,false)
		createThing(T_EFFECT, M_EFFECT_SIMPLE_BLAST, SAFE_NEUTRAL, coord_to_c3d(64, 10), false,false)
		createThing(T_EFFECT, M_EFFECT_FIREBALL, SAFE_NEUTRAL, coord_to_c3d(64, 10), false,false)
	end
	
	if everyTurns_mg(50) then
		createThing(T_EFFECT, M_EFFECT_SIMPLE_BLAST, SAFE_NEUTRAL, coord_to_c3d(56, 18), false,false)
		createThing(T_EFFECT, M_EFFECT_FIREBALL, SAFE_NEUTRAL, coord_to_c3d(56, 18), false,false)
		createThing(T_EFFECT, M_EFFECT_SIMPLE_BLAST, SAFE_NEUTRAL, coord_to_c3d(72, 30), false,false)
		createThing(T_EFFECT, M_EFFECT_FIREBALL, SAFE_NEUTRAL, coord_to_c3d(72, 30), false,false)
	end
	
	if everyTurns_mg(60) then
		createThing(T_EFFECT, M_EFFECT_SIMPLE_BLAST, SAFE_NEUTRAL, coord_to_c3d(56, 30), false,false)
		createThing(T_EFFECT, M_EFFECT_FIREBALL, SAFE_NEUTRAL, coord_to_c3d(56, 30), false,false)
		createThing(T_EFFECT, M_EFFECT_SIMPLE_BLAST, SAFE_NEUTRAL, coord_to_c3d(64, 2), false,false)
		createThing(T_EFFECT, M_EFFECT_FIREBALL, SAFE_NEUTRAL, coord_to_c3d(64, 2), false,false)
	end
	
	if everyTurns_mg(420) then
		createThing(T_EFFECT, M_EFFECT_FIRESTORM, SAFE_NEUTRAL, coord_to_c3d(80, 208), false,false)
	end
	
	if everyTurns_mg(30) then
		for z = 202, 214, 2 do
			createThing(T_EFFECT, M_EFFECT_SIMPLE_BLAST, SAFE_NEUTRAL, coord_to_c3d(80, z), false,false)
			createThing(T_EFFECT, M_EFFECT_FIREBALL, SAFE_NEUTRAL, coord_to_c3d(80, z), false,false)
		end
	end
	
	if everySecond1 then
		for _, zone in ipairs(mg_vars.braves_deadly_zones) do
			SearchMapCells(SQUARE, 0, 0, 0, zone, function(me)
				me.MapWhoList:processList(function(t)
					if t.Type == T_PERSON then
						delete_thing_type_safe(t)
					end
					return true
				end)
				return true
			end)
		end
	end
	
	boat_race_2_process_shamans(everySecond1, everySecond2, everySecond4)
	
	if everySecond4 then
		AI_shaman_stuck_checker(256, AI_UNSTUCK_METHOD_KILL)
	end
end

----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
--BOAT RACE III----------------------------------BOAT RACE III--------------------------------------------------------BOAT RACE III---------------------------------------------------------BOAT RACE III---
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

function BR3_refresh_mg_variables()
	mg_vars.positions = {}
	mg_vars.end_only_positions = {}
	mg_vars.power_up_mode = 1
	mg_vars.powerup_markers = 14
	mg_vars.POWERUP_CD = 10*4
	mg_vars.powerup_cds = { [0]= 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
	mg_vars.spawn_zone = { x = 96, z = 22, marker = 34 };
	local start_zone = Coord3D.new();
	start_zone = MAP_XZ_2_WORLD_XYZ(96, 28)
	mg_vars.start_zone = start_zone
	local end_zone = Coord3D.new();
	end_zone = MAP_XZ_2_WORLD_XYZ(98, 4)
	mg_vars.end_zone = end_zone
	mg_vars.boats_spawn = { x = 96, z = 36 };
	mg_vars.last_model = M_SPELL_NONE;
	mg_vars.angel_cd = 0
	mg_vars.blast_timer = 12*2;
	mg_vars.highest_laps = 0
	mg_vars.powerup_perm_list = { 
	{
		Marker = 27,
		Model = M_SPELL_CONVERT_WILD,
		Cooldown = 12*30,
		CurrCooldown = 0;
	},
	{
		Marker = 36,
		Model = M_SPELL_ANGEL_OF_DEATH,
		Cooldown = 12*20,
		CurrCooldown = 0;
	},
	{
		Marker = 37,
		Model = M_SPELL_FIRESTORM,
		Cooldown = 12*25,
		CurrCooldown = 0;
	},
	{
		Marker = 38,
		Model = M_SPELL_SHIELD,
		Cooldown = 12*20,
		CurrCooldown = 0;
	},
	{
		Marker = 39,
		Model = M_SPELL_SHIELD,
		Cooldown = 12*20,
		CurrCooldown = 0;
	},
	{
		Marker = 60,
		Model = M_SPELL_FIRESTORM,
		Cooldown = 12*25,
		CurrCooldown = 0;
	},
};
	mg_vars.powerup_zones = {
	{
		Markers = {
			{ Index = 0, Radius = 2 },
			{ Index = 1, Radius = 2 },
			{ Index = 2, Radius = 2 }
		},
		Cooldown = 0
	},
	{
		Markers = {
			{ Index = 3, Radius = 2 },
			{ Index = 4, Radius = 2 },
			{ Index = 5, Radius = 2 }
		},
		Cooldown = 0
	},
	{
		Markers = {
			{ Index = 6, Radius = 2 },
			{ Index = 7, Radius = 2 },
			{ Index = 8, Radius = 2 }
		},
		Cooldown = 0
	},
	{
		Markers = {
			{ Index = 9, Radius = 2 },
			{ Index = 10, Radius = 2 },
			{ Index = 11, Radius = 2 }
		},
		Cooldown = 0
	},
	{
		Markers = {
			{ Index = 12, Radius = 2 },
			{ Index = 13, Radius = 2 },
			{ Index = 14, Radius = 2 }
		},
		Cooldown = 0
	},
	{
		Markers = {
			{ Index = 54, Radius = 2 },
			{ Index = 55, Radius = 2 },
			{ Index = 56, Radius = 2 },
		},
		Cooldown = 0
	},
	{
		Markers = {
			{ Index = 57, Radius = 2 },
			{ Index = 58, Radius = 2 },
			{ Index = 59, Radius = 2 },
		},
		Cooldown = 0
	},
};
	local fireballs_tbl = {}
	SearchMapCells(CIRCULAR, 0, 0, 2, world_coord3d_to_map_idx(MAP_XZ_2_WORLD_XYZ(96, 6)), function(me)
		local c3d = Coord3D.new();
		local map_idx = MAP_ELEM_PTR_2_IDX(me);
		map_idx_to_world_coord3d(map_idx, c3d);
		table.insert(fireballs_tbl, c3d)
	    return true;
	end)
	mg_vars.fireballs_tbl = fireballs_tbl
	mg_vars.lb_triggers = { 
	{ exec = 0, func = function() BR3_lap_mimic(1) end, --[[createThing(T_EFFECT, M_EFFECT_VOLCANO, SAFE_NEUTRAL, coord_to_c3d(234, 166), false,false) end, mks = { 49, 50, 53 }]] }, -- first lap 
	{ exec = 0, func = function() BR3_lap_mimic(2) end, --[[mks = { 51, 52 }]] }, -- someone's score == 2
};
	mg_vars.offset_fires = {
		{ cdr = 100, start_x = 174, end_x = 118, x = 174, z = 198 },
		{ cdr = 170, start_x = 174, end_x = 118, x = 174, z = 192 }
	}
	mg_vars.checkpoints_boat_wars = {
function() return rndb(88, 104), 126 end,	
function() return rndb(94, 104), rndb(186, 190) end,
function() return rndb(154, 160), rndb(192, 196) end,
function() return rndb(158, 174), 130 end,
function() return 198, rndb(92, 102) end,
function() return rndb(6, 16), rndb(96, 100) end,
function() return rndb(8, 14), 132 end,
function(diff) return BR3_AI_decide_path_A(diff) end,
function(diff) return BR3_AI_decide_path_B(diff) end,
function() if chance(50) then return 196, 232 else return 196, 246 end end,
function() if chance(50) then return 142, 232 else return 142, 246 end end,
function() return 110, 228 end,
function() return 96, 6 end,
}
	
end

function BR3_AI_decide_path_A(diff)
	local laps = mg_vars.highest_laps
	
	if laps >= 2 then
		return 8, 198
	elseif laps == 1 then
		if chance(20 - diff*6) then
			return 210, 138
		else
			if chance(50 + diff*10) then
				return 6, 172
			else
				return 20, 172
			end
		end
	else
		if chance(30 - diff*4) then
			return 212, 154
		else
			if chance(50) then
				return rndb(0, 18), 176
			else
				return rndb(244, 254), 176
			end
		end
	end
end

function BR3_AI_decide_path_B(diff)
	local laps = mg_vars.highest_laps
	
	if laps >= 2 then
		return rndb(6, 12), rndb(230, 236)
	else
		if chance(50 + diff*10) then
			return 214, 224
		else
			return rndb(6, 12), rndb(230, 236)
		end
	end
end

function BR3_volc_mimic()
	for mk = 62, 69 do
		createThing(T_EFFECT, M_EFFECT_RISE, SAFE_NEUTRAL, marker_to_coord3d(mk), false, false)
	end
end

function BR3_lap_mimic(lap_id)
	-- volc creates unsinkable land, which ruins DEFORGE phase.
	-- landbridge effect has A-B points, and cant be replicated with lua
	-- so we try a similar workaround
	
	if lap_id == 1 then
		BR3_volc_mimic()
		local alt = coord_to_c3d(214, 110).Ypos
		for i = 96, 110 do
			for j = 214, 216, 2 do
				local idx = world_coord3d_to_map_idx(coord_to_c3d(j, i))
				SearchMapCells(SQUARE, 0, 0, 0, idx, function(me)
					me.Alt = alt
					return true
				end)
			end
		end
		set_square_map_params(world_coord3d_to_map_idx(coord_to_c3d(214, 102)), 6, TRUE)

		local alt = coord_to_c3d(242, 82).Ypos
		for i = 82, 96 do
			for j = 242, 244, 2 do
				local idx = world_coord3d_to_map_idx(coord_to_c3d(j, i))
				SearchMapCells(SQUARE, 0, 0, 0, idx, function(me)
					me.Alt = alt
					return true
				end)
			end
		end
		set_square_map_params(world_coord3d_to_map_idx(coord_to_c3d(242, 90)), 6, TRUE)
	else
		local alt = coord_to_c3d(208, 208).Ypos
		for i = 208, 222 do
			for j = 208, 210, 2 do
				local idx = world_coord3d_to_map_idx(coord_to_c3d(i, j))
				SearchMapCells(SQUARE, 0, 0, 0, idx, function(me)
					me.Alt = alt
					return true
				end)
			end
		end
		set_square_map_params(world_coord3d_to_map_idx(coord_to_c3d(216, 208)), 6, TRUE)

		local alt = coord_to_c3d(0, 166).Ypos
		for i = 0, 28 do
			for j = 166, 168, 2 do
				local idx = world_coord3d_to_map_idx(coord_to_c3d(i, j))
				SearchMapCells(SQUARE, 0, 0, 0, idx, function(me)
					me.Alt = alt
					return true
				end)
			end
		end
		set_square_map_params(world_coord3d_to_map_idx(coord_to_c3d(6, 166)), 6, TRUE)
		set_square_map_params(world_coord3d_to_map_idx(coord_to_c3d(22, 166)), 6, TRUE)
	end
end

function BR3_on_lap_finished(player, awarded, old_pts, new_pts)
	mg_vars.highest_laps = new_pts
	if new_pts > 2 then return end
	
	local exec_tbl = mg_vars.lb_triggers
	
	if exec_tbl[new_pts].exec == 0 then
		exec_tbl[new_pts].exec = 1
		exec_tbl[new_pts].func()
	end
end

function BR3_ProcessPowerUps()
	if not (mg_vars.power_up_mode == 1) then return end
	
	local pup_cds = mg_vars.powerup_cds
	local wtf_is_this = (_gsi.Counts.ProcessThings & 12 == 0)
	local pup_cdr = mg_vars.POWERUP_CD
	
	for i=1,#mg_vars.powerup_zones,1 do
		local pup = mg_vars.powerup_zones[i]
		local spawned_effects = 0;
		local exit_block = false;
		if (pup.Cooldown == 0) then
			for j=1, #pup.Markers do	
				local marker = pup.Markers[j].Index
				local radius = pup.Markers[j].Radius
		
				SearchMapCells(CIRCULAR, 0, 0, radius, _gnsi.ThisLevelHeader.Markers[marker], function(me)
					if wtf_is_this then
						if (spawned_effects % 2 == 0) then
							local c3d = Coord3D.new();
							local map_idx = MAP_ELEM_PTR_2_IDX(me);
							map_idx_to_world_coord3d(map_idx, c3d);
							createThing(T_EFFECT, M_EFFECT_SMALL_SPARKLE, 0, c3d, false, false);
						end
						spawned_effects = spawned_effects + 1;
					end

					me.MapWhoList:processList(function(t)
						if (t.Type == T_PERSON and t.Model == M_PERSON_MEDICINE_MAN) then
							pup.Cooldown = mg_vars.POWERUP_CD
							
							if (G_RANDOM(11) == 0) then
								ProcessGlobalTypeList(T_VEHICLE, function(_t)
									if (_t.u.Vehicle.NumOccupants > 0 and _t.Owner ~= t.Owner) then
										local blast = createThing(T_SPELL, M_SPELL_BLAST, t.Owner, _t.Pos.D3, false, false);
										blast.u.Spell.TargetThingIdx:set(_t.ThingNum);
									end
									return true
								end)
							end

							local spell = GetRandomSpellModel();
							if (spell == M_SPELL_SHIELD) then
								t.u.Pers.u.Owned.ShieldCount = 20;
								t.Flags3 = EnableFlag(t.Flags3, TF3_SHIELD_ACTIVE);
								return false;
							end

							if (spell == M_SPELL_WHIRLWIND) then
								GIVE_ONE_SHOT(spell, t.Owner); -- Double shots
							end
							GIVE_ONE_SHOT(spell, t.Owner);
							exit_block = true;
							return false;
						end
						return true;
					end)
					if (exit_block) then
						return false;
					end
					return true;
				end)
			end
		else
			pup.Cooldown = pup.Cooldown - 1;
		end
	end
end

function BR3_init_mg_constants()
	local sti2 = sti[M_SPELL_VOLCANO]
	local sti2_b = sti[M_SPELL_TELEPORT]
	sti2.AvailableSpriteIdx = sti2_b.AvailableSpriteIdx;
	sti2.NotAvailableSpriteIdx = sti2_b.NotAvailableSpriteIdx;
	sti2.ClickedSpriteIdx = sti2_b.ClickedSpriteIdx;
	sti2.ToolTipStrIdx = sti2_b.ToolTipStrIdx;
	sti2.ToolTipStrIdxLSME = sti2_b.ToolTipStrIdxLSME;
	sti2.CursorSpriteNum = sti2_b.CursorSpriteNum;
	sti2.DiscoveryDrawIdx = sti2_b.DiscoveryDrawIdx;
	
	sti2 = sti[M_SPELL_CONVERT_WILD]
	sti2_b = sti[M_SPELL_BLAST]
	sti2.AvailableSpriteIdx = sti2_b.AvailableSpriteIdx;
	sti2.NotAvailableSpriteIdx = sti2_b.NotAvailableSpriteIdx;
	sti2.ClickedSpriteIdx = sti2_b.ClickedSpriteIdx;
	sti2.ToolTipStrIdx = sti2_b.ToolTipStrIdx;
	sti2.ToolTipStrIdxLSME = sti2_b.ToolTipStrIdxLSME;
	sti2.CursorSpriteNum = sti2_b.CursorSpriteNum;
	sti2.DiscoveryDrawIdx = sti2_b.DiscoveryDrawIdx;
	sti2.Flags = sti2_b.Flags;

	pti[M_PERSON_ANGEL].DefaultLife = 1000; -- 10.000 default
end

function boat_race_3_on_turn(everySecond1, everySecond2, everySecond4)
	if mg_turn == 1 then
		disable_spells_effects_for_this_level({M_SPELL_VOLCANO, M_SPELL_CONVERT_WILD})
		BR3_init_mg_constants()
		BR3_refresh_mg_variables()
		CacheSafeZones()

		for _, player in ipairs(_ai_participants) do
			boat_race_init_single_AI(player.ptr.tribe)
		end
		
		for _, player in ipairs(_participants) do
			enable_spell(player.tribe, M_SPELL_BLAST)
		end
		
		for i=0,mg_vars.powerup_markers,1 do
			if (mg_vars.power_up_mode == 0) then
				CreatePowerUp(i, GetRandomSpellModel())
			end
		end
		
		ProcessBoats(mg_vars.boats_spawn.x, mg_vars.boats_spawn.z)
		mg_vars.nosclick = is_map_rule_active(1)
		insert_c3d_from_land_location(coord_to_c3d(214, 110))
		insert_c3d_from_land_location(coord_to_c3d(214, 96))
		insert_c3d_from_land_location(coord_to_c3d(242, 96))
		insert_c3d_from_land_location(coord_to_c3d(242, 82))
		insert_c3d_from_land_location(coord_to_c3d(208, 208))
		insert_c3d_from_land_location(coord_to_c3d(222, 208))
		insert_c3d_from_land_location(coord_to_c3d(0, 166))
		insert_c3d_from_land_location(coord_to_c3d(14, 166))
		insert_c3d_from_land_location(coord_to_c3d(28, 166))
		insert_c3d_from_land_location(coord_to_c3d(234, 166))
		insert_c3d_from_land_location(coord_to_c3d(234, 152))
		insert_c3d_from_land_location(coord_to_c3d(248, 166))
		insert_c3d_from_land_location(coord_to_c3d(234, 180))
		insert_c3d_from_land_location(coord_to_c3d(220, 166))
		insert_c3d_from_land_location(coord_to_c3d(220, 180))
		insert_c3d_from_land_location(coord_to_c3d(220, 152))
		insert_c3d_from_land_location(coord_to_c3d(248, 152))
		insert_c3d_from_land_location(coord_to_c3d(248, 180))
		insert_c3d_from_land_location(coord_to_c3d(96, 114))
		insert_c3d_from_land_location(coord_to_c3d(96, 176))
		insert_c3d_from_land_location(coord_to_c3d(166, 140))
	end
	
	ProcessPermanentPowerUps()
	
	if everyTurns_mg(2) then
		BR3_ProcessPowerUps()
	end
	
	if everyTurns_mg(4) then
		ProcessEndZone()
	end
	
	if everyTurns_mg(32) then
		ProcessAngelsInSafeZones();
		local boatstbl = mg_vars.boats_spawn
		ProcessBoats(boatstbl.x, boatstbl.z);
		--ProcessEndZoneVehicles();
	end
	
	ProcessAngelSpawn(192, 104, 230, 96);
	
	if (mg_vars.blast_timer > 0) then
		mg_vars.blast_timer = mg_vars.blast_timer - 1;
		if (mg_vars.blast_timer == 0) then
			for _, player in ipairs(_participants) do
				GIVE_ONE_SHOT(M_SPELL_BLAST, player.tribe);
				GIVE_ONE_SHOT(M_SPELL_VOLCANO, player.tribe);
			end
			mg_vars.blast_timer = 2*12;
		end
	end
	
	if everyTurns_mg(30) then
		for z = 228, 236, 2 do
			createThing(T_EFFECT, M_EFFECT_SIMPLE_BLAST, SAFE_NEUTRAL, coord_to_c3d(186, z), false,false)
			createThing(T_EFFECT, M_EFFECT_FIREBALL, SAFE_NEUTRAL, coord_to_c3d(186, z), false,false)
		end
		for z = 228, 236, 2 do
			createThing(T_EFFECT, M_EFFECT_SIMPLE_BLAST, SAFE_NEUTRAL, coord_to_c3d(156, z), false,false)
			createThing(T_EFFECT, M_EFFECT_FIREBALL, SAFE_NEUTRAL, coord_to_c3d(156, z), false,false)
		end
	end
	
	if everyTurns_mg(220) then
		createThing(T_EFFECT, M_EFFECT_FIRESTORM, SAFE_NEUTRAL, coord_to_c3d(234, 138), false,false)
	end
	
	if everyTurns_mg(420) then
		createThing(T_EFFECT, M_EFFECT_FIRESTORM, SAFE_NEUTRAL, coord_to_c3d(236, 192), false,false)
	end

	if everyTurns_mg(300) then
		sink_empty_boats_near_end()
		createThing(T_EFFECT, M_EFFECT_HILL, SAFE_NEUTRAL, coord_to_c3d(96, 114), false,false)
		createThing(T_EFFECT, M_EFFECT_HILL, SAFE_NEUTRAL, coord_to_c3d(96, 176), false,false)
		createThing(T_EFFECT, M_EFFECT_HILL, SAFE_NEUTRAL, coord_to_c3d(166, 140), false,false)
	end
	
	if everyTurns_mg(450) then
		createThing(T_EFFECT, M_EFFECT_EROSION, SAFE_NEUTRAL, coord_to_c3d(96, 112), false,false)
		createThing(T_EFFECT, M_EFFECT_EROSION, SAFE_NEUTRAL, coord_to_c3d(96, 114), false,false)
		createThing(T_EFFECT, M_EFFECT_EROSION, SAFE_NEUTRAL, coord_to_c3d(96, 116), false,false)
		
		createThing(T_EFFECT, M_EFFECT_EROSION, SAFE_NEUTRAL, coord_to_c3d(96, 174), false,false)
		createThing(T_EFFECT, M_EFFECT_EROSION, SAFE_NEUTRAL, coord_to_c3d(96, 176), false,false)
		createThing(T_EFFECT, M_EFFECT_EROSION, SAFE_NEUTRAL, coord_to_c3d(96, 178), false,false)
		
		createThing(T_EFFECT, M_EFFECT_EROSION, SAFE_NEUTRAL, coord_to_c3d(166, 142), false,false)
		createThing(T_EFFECT, M_EFFECT_EROSION, SAFE_NEUTRAL, coord_to_c3d(166, 140), false,false)
		createThing(T_EFFECT, M_EFFECT_EROSION, SAFE_NEUTRAL, coord_to_c3d(166, 138), false,false)
	end
	
	local fires_tbls = mg_vars.offset_fires
	for _, tbl in ipairs(fires_tbls) do
		local new_cdr = math.max(0, tbl.cdr - 1)
		tbl.cdr = new_cdr
		
		if new_cdr == 0 then
			local x, z = tbl.x, tbl.z
			local c3d = coord_to_c3d(x, z)
			createThing(T_EFFECT, M_EFFECT_FIREBALL, SAFE_NEUTRAL, c3d, false,false)
			createThing(T_EFFECT, M_EFFECT_SIMPLE_BLAST, SAFE_NEUTRAL, c3d, false,false)
			
			tbl.x = tbl.x - 4
			if tbl.x < tbl.end_x then
				tbl.x = tbl.start_x
				tbl.cdr = 30
			else
				tbl.cdr = 5
			end
		end
	end
	
	boat_race_process_shamans(everySecond1, everySecond2, everySecond4)
	
	if everySecond4 then
		AI_shaman_stuck_checker(256, AI_UNSTUCK_METHOD_KILL)
	end
end

----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
--COLOR BATTLE----------------------------------COLOR BATTLE--------------------------------------------------------COLOR BATTLE---------------------------------------------------------COLOR BATTLE---
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

function CB_init_single_AI(player)
	local ai = mg_player_vars[player]

	ai.powerup_chasing = nil
	ai.blast_cdr = rndb(12*5, 12*10)
	ai.light_cdr = rndb(12*16, 12*28)
end

function CB_try_to_spell_an_enemy(tribe, spell, radius, _chance, diff)
	if chance(_chance) then
		if I_HAVE_ONE_SHOT(tribe, T_SPELL, spell) then
			local random_enemy = get_random_enemy_shaman_near_thing(getShaman(tribe), radius)
			
			if random_enemy then
				if shaman_has_healthy_state(tribe) and not shaman_casting(tribe) then
					local t = createThing(T_SPELL, spell, tribe, random_enemy.Pos.D3, false, false)
					
					if not mg_vars.nosclick then
						if shaman_has_healthy_state(random_enemy.Owner) then
							if chance(60+diff*10) then
								t.u.Spell.TargetThingIdx:set(random_enemy.ThingNum)
							end
						end
					end
					return true
				end
			end
		end
	end
	
	return false
end

function CB_process_spells(tribe, alive, ai, diff, everySecond1, diff)
	ai.blast_cdr = ai.blast_cdr - 1
	ai.light_cdr = ai.light_cdr - 1
	
	if not alive then return end
	
	if ai.blast_cdr <= 0 then
		local success = CB_try_to_spell_an_enemy(tribe, M_SPELL_BLAST, 5, 10 + diff*20, diff)
		
		if success then
			ai.blast_cdr = rndb(12*(8-diff), 12*(14-diff)) - diff*12 * rndb(1,2)
		else
			ai.blast_cdr = rndb(12*(4-diff), 12*(6-diff))
		end
	elseif ai.light_cdr <= 0 then
		if everySecond1 then
			local success = CB_try_to_spell_an_enemy(tribe, M_SPELL_LIGHTNING_BOLT, 5, 20 + diff*15, diff)
			
			if success then
				ai.light_cdr = rndb(12*(18-diff*2), 12*(22-diff)) - diff*12 * 2
			else
				ai.light_cdr = rndb(12*6, 12*(10-diff))
			end
		end
	end
end

function CB_process_AI(tribe, alive, everySecond1, everySecond4, diff)
	local ai = mg_player_vars[tribe]
	CB_process_spells(tribe, alive, ai, diff, everySecond1, diff)
	
	if not alive then return end
	
	local shaman = getShaman(tribe)
	local c2d = ai.powerup_chasing
	
	if c2d == nil then
		if chance(2 + diff*2) then
			local places = get_me_the_closest_powerup_max_rad(tribe, shaman, 8+diff*2)
			
			if #places == 1 then
				local item = places[1]
				ai.powerup_chasing = item.c2d
			else
				if #places >= 2 then
					if chance(50) then
						local item = places[2]
						ai.powerup_chasing = item.c2d
					else
						local item = places[1]
						ai.powerup_chasing = item.c2d
					end
				end
			end
		end
		
		if everySecond1 then
			if shaman_has_healthy_state(tribe) then
				if chance(80) then
					if chance(60) then
						MOVE_SHAMAN_TO_MARKER(tribe, rndb(0,51))
					end
				end
			end
		end
	else
		if is_powerup_in_c2d(c2d) then
			if shaman_has_healthy_state(tribe) then
				command_person_go_to_coord2d(shaman, c2d)
			end
		else
			ai.powerup_chasing = nil
			
			if shaman_has_healthy_state(tribe) then
				MOVE_SHAMAN_TO_MARKER(tribe, rndb(0,51))
			end
		end
	end
	
	if everySecond4 then
		if chance(70) then
			for mk = 52,55 do
				if IS_SHAMAN_IN_AREA(tribe, mk, 2) == 1 then
					local t = createThing(T_SPELL, M_SPELL_TELEPORT, tribe, marker_to_coord3d(56), false, false)
				end
			end
		end
	end
end

function CB_on_power_up(id, c3d)
	local c2d = c3d_to_c2d(c3d)
	
	for _, aiplayer in ipairs(_ai_participants) do
		local player = aiplayer.ptr
		local ai_tribe = player.tribe
		
		if nilS(ai_tribe) then
			local diff = player.diff
			
			if chance(40 + 15*diff) then
				local shaman = getShaman(ai_tribe)
				local shaman_c2d = shaman.Pos.D2
				local old_c2d = mg_player_vars[ai_tribe].powerup_chasing
				
				if (not old_c2d) or (get_world_dist_xz(shaman_c2d, c2d) < get_world_dist_xz(shaman_c2d, old_c2d)) then
					mg_player_vars[ai_tribe].powerup_chasing = c2d
					command_person_go_to_coord2d(shaman, c2d)
				end
			end
		end
	end
end

function CB_process_shamans(everySecond1, everySecond4)
	local everySecond14 = everySeconds_mg(14)

	for _, player in ipairs(_participants) do
		local tribe = player.tribe
		local ai = player.ai
		local alive = process_death_shamans(tribe, player)
		
		if alive then
			remove_shaman_melee(tribe)
			Paint_Cell_1(tribe, player)
		end
		
		if everySecond4 then
			GIVE_ONE_SHOT(M_SPELL_BLAST, tribe)
		end
		
		if everySecond14 then
			GIVE_ONE_SHOT(M_SPELL_LIGHTNING_BOLT, tribe)
		end
		
		if ai then
			local diff = player.diff
			CB_process_AI(tribe, alive, everySecond1, everySecond4, diff)
		end
	end
end

function Bucket_1(catcher)
	local pts = 0
	
	ProcessGlobalTypeList(T_EFFECT,function(t)
		if t.Type == T_EFFECT then
			if t.Model == M_EFFECT_SMOKE_CLOUD then
				if t.Owner == catcher then
					pts = pts + 1
					t.u.Effect.Duration = 1
				end
			end
		end
		return true
	end)
	
	remove_objects_of_type_model_owned_by(T_EFFECT, M_EFFECT_SMOKE_CLOUD, catcher)
	give_points_to_team(pts, catcher, true)
end

function Spray_1(catcher)
	local enemies = get_enemy_tribes(catcher)

	for _, enemy in ipairs(enemies) do
		remove_objects_of_type_model_owned_by(T_EFFECT, M_EFFECT_SMOKE_CLOUD, enemy)
	end
end

function PaintOver_1(catcher)
	ProcessGlobalTypeList(T_EFFECT,function(t)
		if t.Type == T_EFFECT then
			if t.Model == M_EFFECT_SMOKE_CLOUD then
				if t.Owner ~= catcher then
					if is_player_enemy(catcher, t.Owner) then
						t.DrawInfo.Alpha = _tribes_to_participants_ptrs[catcher].g_color
						t.Owner = catcher
					end
				end
			end
		end
		return true
	end)
end

function Paint_Cell_1(pn, player_tbl)
	local shaman = getShaman(pn)
	if thing_has_flag(shaman, TF2_THING_IN_AIR, 2) then return end
	
	local has = false
	local shaman_c3d = copy_c3d(shaman.Pos.D3)

	SearchMapCells(CIRCULAR, 0, 0, 0, world_coord3d_to_map_idx(shaman_c3d), function(me)
		me.MapWhoList:processList(function(t)
			if t.Type == T_EFFECT then
				if t.Model == M_EFFECT_SMOKE_CLOUD then
					if t.Owner ~= pn then --will pain allies as well, intended
						if get_world_dist_xyz(shaman_c3d, t.Pos.D3) <= 256 then
							has = true
							t.Owner = pn
							t.DrawInfo.Alpha = player_tbl.g_color
							t.u.Effect.Duration = -1
						end
					else
						has = true
					end
				end
			end
			return true
		end)
		return true
	end)
	
	if not has then
		local t = create_thing_cache(T_EFFECT, M_EFFECT_SMOKE_CLOUD, pn, shaman_c3d, false, false)
		if not t then return end
		set_thing_draw_info(t, TDI_SPRITE_F1_D1, rndb(1224, 1225))
		t.DrawInfo.Alpha = player_tbl.g_color
		t.u.Effect.Duration = -1
		t.Pos.D3.Ypos = -128-32
	end
end

function color_battle_on_shaman_dead(victim, killer, killer_was_ally)
	if not killer_was_ally then
		give_points_to_team(3, killer, true)
	end
end

function color_battle_on_turn(everySecond1, everySecond2, everySecond4)
	if mg_turn == 1 then
		ggameplay.max_powerups_at_once = 8
		for _, player in ipairs(_ai_participants) do
			CB_init_single_AI(player.ptr.tribe)
		end
		mg_vars.nosclick = is_map_rule_active(2)
	end
	
	CB_process_shamans(everySecond1, everySecond4)
end

function color_battle_on_create_thing(t, owner, type, model)
	if not (type == T_SPELL) then return end

	if mg_vars.nosclick then
		if not t.u.Spell then return end
		local targindex = t.u.Spell.TargetThingIdx
		
		if (not targindex:isNull()) then
			targindex:set(0)
		end
	end
end

----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
--MAP_NAVAL_WARFARE----------------------------------MAP_NAVAL_WARFARE--------------------------------------------------------MAP_NAVAL_WARFARE---------------------------------------------------------MAP_NAVAL_WARFARE---
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

function naval_water_c3d()
	local c3d = nil
	
	while c3d == nil do
		local _c3d = coord_to_c3d(rndb(12,132), rndb(12,132))
		local able = true
		
		SearchMapCells(SQUARE, 0, 0, 0, world_coord3d_to_map_idx(_c3d), function(me)
			if me.Alt > 0 then
				able = false
			end
			return true
		end)
		
		if able then
			c3d = _c3d
		end
	end
	
	return c3d
end

function naval_warfare_AI_lock_player(tribe, tribe_ai)
	tribe_ai.locked_player = get_closest_alive_enemy_shaman(tribe)
	
	local locked_targ = tribe_ai.locked_player
	if locked_targ then
		local vehicled = is_person_in_boat(getShaman(locked_targ)) > 0
		
		if not vehicled then
			tribe_ai.locked_player = nil
		end
	end
end

function init_single_AI_3(player)
	local vars = mg_player_vars[player]
	
	vars.powerup_chasing = nil
	vars.locked_player = nil
	vars.cannon_cdr = rndb(12*5, 12*10)
	vars.greek_cdr = rndb(12*16, 12*28)
end

function try_to_spell_enemy_3(tribe, spell, radius, _chance, difficulty)
	if chance(_chance) then
		if I_HAVE_ONE_SHOT(tribe, T_SPELL, spell) then
			local caster = getShaman(tribe)
			local random_enemy = get_random_enemy_shaman_near_thing(caster, radius)
			
			if random_enemy then
				local vehicled = is_person_in_boat(random_enemy) > 0
				
				if vehicled then
					if shaman_has_healthy_state(tribe) and not shaman_casting(tribe) then
						local target_c3d = random_enemy.Pos.D3
						
						if spell == M_SPELL_INSECT_PLAGUE then
							if get_world_dist_xz(random_enemy.Pos.D2, caster.Pos.D2) <= 512*5 then
								return false
							end
						else
							if chance(15 + difficulty*12) then
								local bomb_rad = 18 * difficulty
								local _c3d = aim_spell_at_target(tribe, random_enemy, bomb_rad)
								
								if _c3d then
									target_c3d = _c3d
								end
							end
						
							if get_world_dist_xyz(target_c3d, caster.Pos.D3) <= 512*3 then
								return false
							end
						end
						
						local t = createThing(T_SPELL, spell, tribe, target_c3d, false, false)
					
						return true
					end
				end
			end
		end
	end
	
	return false
end

function process_AI_3(tribe, nils, everySecond1, _diff)
	local shaman = getShaman(tribe)
	local ai = mg_player_vars[tribe]
	
	ai.cannon_cdr = ai.cannon_cdr - 1
	ai.greek_cdr = ai.greek_cdr - 1
	
	if not nils then return end
	
	local c2d = ai.powerup_chasing
	
	if ai.cannon_cdr <= 0 then
		if everySecond1 then
			if I_HAVE_ONE_SHOT(tribe, T_SPELL, M_SPELL_CONVERT_WILD) then
				local can_rad = 18 + _diff
				if mg_vars.close_combat then can_rad = can_rad // 2 end
				local success = try_to_spell_enemy_3(tribe, M_SPELL_CONVERT_WILD, can_rad, 45 + _diff*15, _diff)
				local light_cannonballs = btn(ai.light_iron > 0)
				
				if success then
					ai.cannon_cdr = rndb(12*5 - _diff*4, 12*(12-_diff*2)) - light_cannonballs*2
				else
					ai.cannon_cdr = rndb(12*3, 12*(8-_diff*2))
				end
			end
		end
	elseif ai.greek_cdr <= 0 then
		if I_HAVE_ONE_SHOT(tribe, T_SPELL, M_SPELL_INSECT_PLAGUE) then
			local success = try_to_spell_enemy_3(tribe, M_SPELL_INSECT_PLAGUE, 14 + _diff, 60 + _diff*10, _diff)
			
			if success then
				ai.greek_cdr = rndb(12*8 - _diff*4, 12*(16-_diff*3))
			else
				ai.greek_cdr = rndb(12*5, 12*(14-_diff*2))
			end
		end
	end

	if everySeconds_mg(18 + tribe) then
		if chance(50 + _diff*15) then
			naval_warfare_AI_lock_player(tribe, ai)
		end
	end

	if not everySecond1 then return end
	
	local vehicled = is_person_in_boat(shaman) > 0
	if vehicled then
		if c2d == nil then
			-- vehicled, not chasing power up
			if chance(24 + _diff*12) then
				local places = get_me_the_closest_powerup_max_rad(tribe, shaman, 15+_diff*5)
				
				if #places == 1 then
					local item = places[1]
					ai.powerup_chasing = item.c2d
				else
					if #places >= 2 then
						if chance(50) then
							local item = places[2]
							ai.powerup_chasing = item.c2d
						else
							local item = places[1]
							ai.powerup_chasing = item.c2d
						end
					else
						command_person_go_to_coord2d(shaman, c3d_to_c2d(naval_water_c3d()))
					end
				end
			else
				if chance(20 + _diff*20) or shaman.State ~= S_PERSON_UNDER_COMMAND then
					if shaman_has_healthy_state(tribe) then
						if chance(30 + _diff*10) then
							local target_player = ai.locked_player
							
							if target_player == nil then
								naval_warfare_AI_lock_player(tribe, ai)
							else
								if nilS(target_player) then
									local targSh = getShaman(target_player)
									
									if is_person_in_boat(targSh) > 0 then
										if chance(60 + _diff*10) then
											command_person_go_to_coord2d(shaman, targSh.Pos.D2)
										else
											command_person_go_to_coord2d(shaman, c3d_to_c2d(naval_water_c3d()))
										end
									else
										command_person_go_to_coord2d(shaman, c3d_to_c2d(naval_water_c3d()))
									end
								else
									naval_warfare_AI_lock_player(tribe, ai)
									command_person_go_to_coord2d(shaman, c3d_to_c2d(naval_water_c3d()))
								end
							end
						else
							command_person_go_to_coord2d(shaman, c3d_to_c2d(naval_water_c3d()))
						end
					end
				end
			end
		else
			--vehicled, chasing power up
			if is_powerup_in_c2d(c2d) then
				if shaman_has_healthy_state(tribe) then
					command_person_go_to_coord2d(shaman, c2d)
				end
			else
				ai.powerup_chasing = nil
				
				if shaman_has_healthy_state(tribe) then
					command_person_go_to_coord2d(shaman, c3d_to_c2d(naval_water_c3d()))
				end
			end
		end
	else
		if IS_SHAMAN_IN_AREA(tribe, tribe, 6) > 0 then
			if shaman.State ~= S_PERSON_UNDER_COMMAND then
				local boat = get_me_a_random_boat_in_location(marker_to_coord3d(tribe), nil, nil, 5)
				
				if boat then
					command_person_enter_vehicle(shaman, boat)
				else
					command_person_go_to_coord2d(shaman, marker_to_coord2d(tribe))
				end
			end
		else
			command_person_go_to_coord2d(shaman, marker_to_coord2d(tribe))
		end
	end
end

function catch_powerup_3(tribe, id)
	local ai_vars = mg_player_vars[tribe]
	
	if id == 1 then
		GIVE_ONE_SHOT(M_SPELL_INSECT_PLAGUE, tribe)
	elseif id == 2 then
		ai_vars.light_iron = ai_vars.light_iron + 12*25
	else
		ai_vars.gun_powder = ai_vars.gun_powder + 12*25
	end
end

function spell_away_from_cors_3(t)
	local c2d = t.Pos.D2
	
	for _, player in ipairs(_participants) do
		local mk_c2d = marker_to_coord2d(player.tribe)
		
		if get_world_dist_xz(c2d, mk_c2d) <= 512*8 then
			return false
		end
	end
	
	return true
end

function naval_warfare_invi_stones()
	-- ProcessGlobalTypeList(T_SCENERY, function(t)
		-- if t.Model < 10 then
			-- set_thing_draw_info(t, TDI_SPRITE_F1_D1, 687) 
		-- end
	-- return true end)
end

function init_mg_constants_3()
	local CannonSpell, greekFireSpell = M_SPELL_CONVERT_WILD, M_SPELL_INSECT_PLAGUE
	local cannonsti, greeksti = sti[CannonSpell], sti[greekFireSpell]
	
	cannonsti.Cost = 10000
	cannonsti.OneOffMaximum = 1
	cannonsti.WorldCoordRange = 8192+4096
	cannonsti.CursorSpriteNum = 163
	cannonsti.AvailableSpriteIdx = 1861
	cannonsti.NotAvailableSpriteIdx = 1861
	cannonsti.ClickedSpriteIdx = 1861

	greeksti.Cost = 90000
	greeksti.OneOffMaximum = 2
	greeksti.WorldCoordRange = 8192+2048
	greeksti.CursorSpriteNum = 103
	greeksti.AvailableSpriteIdx = 1862
	greeksti.NotAvailableSpriteIdx = 1862
	greeksti.ClickedSpriteIdx = 1862
	
	if mg_vars.close_combat then
		cannonsti.WorldCoordRange = cannonsti.WorldCoordRange // 2
	end
	
	for _, player in ipairs(_participants) do
		local limits_spell = getPlayer(player.tribe).LimitsSpell
	
		limits_spell.MaxCharges[CannonSpell] = cannonsti.OneOffMaximum
		limits_spell.WorldCoordRange[CannonSpell] = cannonsti.WorldCoordRange
		
		limits_spell.MaxCharges[greekFireSpell] = greeksti.OneOffMaximum
		limits_spell.WorldCoordRange[greekFireSpell] = greeksti.WorldCoordRange
	end
end

function reset_player_variables_3(tribe)
	local vars = mg_player_vars[tribe]
	vars.cannonball = 0
	vars.light_iron = 0
	vars.gun_powder = 0
	
	vars.boatHP = 1024
	vars.boatOnFire = 0
	vars.last_fire_damager = SAFE_NEUTRAL
	
	vars.cannoncdr = 0
	vars.greekFirecdr = 0
	vars.cannonc3d = nil
	vars.greekFirec3d = nil
	
	vars.clr = _tribes_to_participants_ptrs[tribe].color
end

function refresh_mg_variables_3()
	for _, player in ipairs(_participants) do
		reset_player_variables_3(player.tribe)
	end
end

function init_naval_warfare()
	disable_spells_effects_for_this_level({M_SPELL_CONVERT_WILD, M_SPELL_INSECT_PLAGUE, M_SPELL_SHIELD})
	init_mg_constants_3()
	refresh_mg_variables_3()
	ggameplay.max_powerups_at_once = 6
	for _, player in ipairs(_ai_participants) do
		init_single_AI_3(player.ptr.tribe)
	end
	naval_warfare_invi_stones()
end

function ExplodeBoat(pn)
	ProcessGlobalTypeList(T_VEHICLE, function(boat)
		if boat.Model < 3 and boat.Owner == pn then
			boat.State = S_VEHICLE_BLAST_EXPLODING
		end
	return true end)
end

function CannonBallEffect(tribe, c3d, vars)
	createThing(T_EFFECT, M_EFFECT_LAVA_GLOOP, SAFE_NEUTRAL, c3d, false, false)
	
	local bf = createThing(T_EFFECT, M_EFFECT_BIG_FIRE, SAFE_NEUTRAL, c3d, false, false) ; bf.u.Effect.Duration = 12*rndb(3,5)
	--create child fires nearby
	for i = 1, 3 do
		local child = createThing(T_EFFECT, M_EFFECT_BIG_FIRE, SAFE_NEUTRAL, c3d, false, false) ; child.u.Effect.Duration = 24 + rndb(1, 24)
		child.Pos.D3.Ypos = -96 ; child.Pos.D3.Xpos = bf.Pos.D3.Xpos + rndb(-256,256) ; child.Pos.D3.Zpos = bf.Pos.D3.Zpos + rndb(-256,256)
	end

	if chance(60) then
		local child = createThing(T_EFFECT, M_EFFECT_BIG_FIRE, SAFE_NEUTRAL, c3d, false, false) ; child.u.Effect.Duration = 24 + rndb(1, 24)
		child.Pos.D3.Ypos = -96 ; child.Pos.D3.Xpos = bf.Pos.D3.Xpos + rndb(-512,512) ; child.Pos.D3.Zpos = bf.Pos.D3.Zpos + rndb(-512,512)
	end
	
	if chance(30) then
		local child = createThing(T_EFFECT, M_EFFECT_BIG_FIRE, SAFE_NEUTRAL, c3d, false, false) ; child.u.Effect.Duration = 24 + rndb(1, 24)
		child.Pos.D3.Ypos = -96 ; child.Pos.D3.Xpos = bf.Pos.D3.Xpos + rndb(-512,512) ; child.Pos.D3.Zpos = bf.Pos.D3.Zpos + rndb(-512,512)
	end

	local explosion = {M_EFFECT_EXPLOSION_1, M_EFFECT_EXPLOSION_2, M_EFFECT_EXPLOSION_3, M_EFFECT_ROCK_EXPLOSION}
	local explo = createThing(T_EFFECT, explosion[rndb(1, #explosion)], SAFE_NEUTRAL, c3d, false, false)
	local fc = createThing(T_EFFECT, M_EFFECT_FIRECLOUD, SAFE_NEUTRAL, c3d, false, false) ; fc.Pos.D3.Ypos = -76 ; fc.u.Effect.Duration = 12
	local rnd_sound = 1 + btn(chance(50))
	rnd_sound = tostring(rnd_sound)
	queue_custom_sound_event(explo, "y_explosion" .. rnd_sound .. ".wav", 127)
	
	if is_c3d_water_or_coast(c3d) then
		local splash = createThing(T_EFFECT, M_EFFECT_SPLASH, SAFE_NEUTRAL, c3d, false, false)
		queue_sound_event(splash, SND_EVENT_W_SPLASH, SEF_FIXED_VARS)
	else
		createThing(T_EFFECT, M_EFFECT_WW_DUST, SAFE_NEUTRAL, c3d, false, false)
		createThing(T_EFFECT, M_EFFECT_LAVA_SQUARE, SAFE_NEUTRAL, c3d, false, false)
		createThing(T_EFFECT, M_EFFECT_BLDG_DAMAGED_SMOKE, SAFE_NEUTRAL, c3d, false, false)
		createThing(T_EFFECT, M_EFFECT_GROUND_SHOCKWAVE, SAFE_NEUTRAL, c3d, false, false)
	end

	local gunpowder = vars.gun_powder > 0
	local _powder = btn(gunpowder)
	local distMin, distMax = 512 + _powder*256, 1536 * (_powder+1)
	local damageDivider = 1.5 + _powder*(2.5)
	local fireTimer = 12*3 + _powder*12

	for _, player in ipairs(_participants) do
		local victim = player.tribe
		
		if nilS(victim) then
			local shaman = getShaman(victim)
			
			if shaman.u.Pers.Life > 0 then
				local dist = get_world_dist_xz(explo.Pos.D2, shaman.Pos.D2)
				
				if dist < distMax then
					local damage = 1024
					local victim_tbl = mg_player_vars[victim]
				
					if dist > distMin then
						damage = math.ceil((distMax - dist)/damageDivider)
						victim_tbl.boatOnFire = victim_tbl.boatOnFire + fireTimer
						victim_tbl.last_fire_damager = tribe
					end
					
					victim_tbl.boatHP = victim_tbl.boatHP - damage --LOG(victim .. " at distance " .. dist .. ", boat damage: " .. damage)
					deal_zero_damage(victim, tribe)
					
					if victim_tbl.boatHP <= 0 then
						damage_person(shaman, tribe, 6666, 1)
						ExplodeBoat(victim)
					end
				end
			end
		end
	end
	
	if gunpowder then
		bf = createThing(T_EFFECT, M_EFFECT_ROCK_EXPLOSION, SAFE_NEUTRAL, c3d, false, false)
		
		for i = 1, 5 do
			local child = createThing(T_EFFECT, M_EFFECT_BIG_FIRE, SAFE_NEUTRAL, c3d, false, false) ; child.u.Effect.Duration = 24 + rndb(1, 24)
			child.Pos.D3.Ypos = -96 ; child.Pos.D3.Xpos = bf.Pos.D3.Xpos - rndb(-1024,1024) ; child.Pos.D3.Zpos = bf.Pos.D3.Zpos - rndb(-1024,1024)
		end
		
		for i = 1, 2 do
			local child = createThing(T_EFFECT, M_EFFECT_BIG_FIRE, SAFE_NEUTRAL, c3d, false, false) ; child.u.Effect.Duration = 24 + rndb(1, 24)
			child.Pos.D3.Ypos = -96 ; child.Pos.D3.Xpos = bf.Pos.D3.Xpos - rndb(-512,512) ; child.Pos.D3.Zpos = bf.Pos.D3.Zpos - rndb(-512,512)
		end
	end
end

function GreekFireEffect(tribe, c3d)
	SearchMapCells(CIRCULAR , 0, 5, 4, world_coord3d_to_map_idx(c3d), function(me)
		local ptr = MAP_ELEM_PTR_2_IDX(me)
		local _c3d = Coord3D.new()
		map_idx_to_world_coord3d(ptr, _c3d)
		local greekFire = createThing(T_EFFECT, M_EFFECT_FIREBALL, tribe, _c3d, false, false)
		centre_coord3d_on_block(greekFire.Pos.D3)
		greekFire.u.Effect.Duration = 12*10 + rndb(1, 24)
		set_thing_draw_info(greekFire, TDI_SPRITE_F9_D1_ALPHA, 1090)
		--greekFire.DrawInfo.Alpha = players[tribe].g_color
	return true end)
	
	local ef = createThing(T_EFFECT, M_EFFECT_SMOKE, tribe, c3d, false, false)
	ef.u.Effect.Duration = 1
	local fire_sounds = {"364_Fire_04","364_Fire_04","365_Fire_02","366_Fire_03","367_Fire_01","368_Bldg_fire04","369_Bldg_fire02","370_Bldg_fire03","371_Bldg_fire01","2_fire"}
	queue_custom_sound_event(ef, fire_sounds[rndb(1, #fire_sounds)] .. ".wav", 127)
end

function ProcessBoatOnWater(shaman, vars)
	local shaman_c2d = copy_c2d(shaman.Pos.D2)

	SearchMapCells(CIRCULAR, 0, 0 , 0, world_coord3d_to_map_idx(shaman.Pos.D3), function(me)
		ProcessGlobalTypeList(T_EFFECT, function(gf) --greek fire
			if (gf.Model == M_EFFECT_FIREBALL) then
				local fire_owner = gf.Owner
			
				if fire_owner ~= SAFE_NEUTRAL then
					if get_world_dist_xz(shaman_c2d, gf.Pos.D2) < 256+64 then
						vars.boatOnFire = 12*8 + 12*(G_RANDOM(3)) --8-10sec
						vars.last_fire_damager = fire_owner
					end
				end
			end
			return true
		end)
		return true
	end)
end

function draw_low_hp_fires(boat, low)
	local _low = btn(low)
	local c3d = copy_c3d(boat.Pos.D3)
	local offset = 256 + _low*256
	
	for i = 1, 3 + 3*_low do
		local smoke = createThing(T_EFFECT, M_EFFECT_BLDG_DAMAGED_SMOKE, SAFE_NEUTRAL, c3d, false, false)
		smoke.u.Effect.Duration = 12 + rndb(-2, 4)
		smoke.Pos.D3.Xpos = smoke.Pos.D3.Xpos + rndb(-offset, offset) ; smoke.Pos.D3.Zpos = smoke.Pos.D3.Zpos + rndb(-offset, offset)
	end
end

function DrawFire(vehicle)
	local c3d = copy_c3d(vehicle.Pos.D3)

	--fire inside boat
	local fire = createThing(T_EFFECT, M_EFFECT_BIG_FIRE, SAFE_NEUTRAL, c3d, false, false)
	fire.u.Effect.Duration = 2 ; fire.DrawInfo.Alpha = 0
	
	--smoke inside boat
	local smoke = createThing(T_EFFECT, M_EFFECT_BLDG_DAMAGED_SMOKE, SAFE_NEUTRAL, c3d, false, false)
	smoke.u.Effect.Duration = 24
	
	--fire outside boat
	if everyTurns_mg(4) then
		local fire2 = createThing(T_EFFECT, M_EFFECT_BIG_FIRE , SAFE_NEUTRAL, c3d, false, false)
		fire2.u.Effect.Duration = 36 + rndb(24,60) ; fire2.DrawInfo.Alpha = 0
		
		--smoke outside boat
		if chance(50) then
			local smoke = createThing(T_EFFECT, M_EFFECT_BLDG_DAMAGED_SMOKE, SAFE_NEUTRAL, c3d, false, false)
			smoke.u.Effect.Duration = 48 + rndb(48,70)
		end
		
		--some fires on the sides
		local fire2 = createThing(T_EFFECT, M_EFFECT_BIG_FIRE, SAFE_NEUTRAL, c3d, false, false)
		fire2.u.Effect.Duration = 36 + rndb(24,60) ; fire2.DrawInfo.Alpha = 0
		fire2.Pos.D3.Xpos = fire2.Pos.D3.Xpos + rndb(-512,512) ; fire2.Pos.D3.Zpos = fire2.Pos.D3.Zpos + rndb(-512,512)
	end
end

function process_boat_on_fire(tribe, shaman, vars, ldb)
	vars.boatOnFire = math.max(0, vars.boatOnFire - 1)
	local onfire = vars.boatOnFire

	if onfire > 0 then
		vars.boatHP = vars.boatHP - rndb(1,5)
		DrawFire(shaman)
		draw_low_hp_fires(shaman, vars.boatHP < 256)
		deal_zero_damage(tribe, vars.last_fire_damager)
		
		if vars.boatHP <= 0 then
			if nilS(tribe) then
				damage_person(getShaman(tribe), ldb, 6666, 1)
			end
			
			
			ProcessGlobalTypeList(T_VEHICLE, function(boat)
				if boat.Model < 3 and boat.Owner == tribe then
					boat.State = S_VEHICLE_BOAT_DYING
				end
			return true end)
		end
	end
end

function process_shamans_3(everySecond1, everySecond2, everySecond4)
	for _, player in ipairs(_participants) do
		local tribe = player.tribe
		local is_ai = player.ai
		local cdrs = mg_player_vars[tribe]
		
		cdrs.cannonball = math.max(0, cdrs.cannonball - 1)
		cdrs.gun_powder = math.max(0, cdrs.gun_powder - 1)
		cdrs.light_iron = math.max(0, cdrs.light_iron - 1)
		cdrs.cannoncdr = math.max(0, cdrs.cannoncdr - 1)
		cdrs.greekFirecdr = math.max(0, cdrs.greekFirecdr - 1)
		
		if cdrs.cannonball == 0 then
			if not I_HAVE_ONE_SHOT(tribe, T_SPELL, M_SPELL_CONVERT_WILD) then
				GIVE_ONE_SHOT(M_SPELL_CONVERT_WILD, tribe)
			end
		end
		
		if cdrs.greekFirec3d ~= nil then
			if cdrs.greekFirecdr == 0 then
				GreekFireEffect(tribe, cdrs.greekFirec3d)
				cdrs.greekFirec3d = nil
			end
		end
		
		if cdrs.cannonc3d ~= nil then
			if cdrs.cannoncdr == 0 then
				CannonBallEffect(tribe, cdrs.cannonc3d, cdrs)
				cdrs.cannonc3d = nil
			end
		end
		
		local alive = process_death_shamans(tribe, player)
		
		if alive then
			local shaman = getShaman(tribe)
			local vehicled = is_person_in_boat(shaman) > 0
			
			if everySecond4 then
				if not vehicled then
					if get_world_dist_xz(shaman.Pos.D2, marker_to_coord2d(tribe)) < 512*6 then
						if count_boats(marker_to_coord3d(8+tribe), nil, nil, 4) == 0 then
							create_thing_cache(T_VEHICLE, M_VEHICLE_BOAT_1, tribe, marker_to_coord3d(8+tribe))
						end
					end
				end
			end
		
			if vehicled then
				if everyTurns_mg(4) then
					ProcessBoatOnWater(shaman, cdrs)
				end
				process_boat_on_fire(tribe, shaman, cdrs, player.ldb)
			end
		end
		
		if is_ai then
			alive = nilS(tribe)
			process_AI_3(tribe, alive, everySecond1, player.diff)
		end
	end
end

function spawn_cannonball_3(t, owner)
	local g = createThing(T_EFFECT, M_EFFECT_SPARKLE, SAFE_NEUTRAL, t.Pos.D3, false, false)
	set_thing_draw_info(g,TDI_SPRITE_F8_D1_ALPHA, 1441)
	g.u.Effect.Duration = 24
	g.DrawInfo.Alpha = _tribes_to_participants_ptrs[owner].g_color
	
	t.u.Spell.TargetThingIdx:set(0)
	t.u.Spell.ShotThingIdx:set(0)
	
	local s = getShaman(owner)
	
	if s then
		local z = t.Pos.D2.Zpos - s.Pos.D2.Zpos
		local x = t.Pos.D2.Xpos - s.Pos.D2.Xpos

		x = toSigned16(x)
		z = toSigned16(z)
		
		local angle = math.atan(z, x) * 180 / math.pi
		angle = math.ceil(angle)
		
		if (angle < 0) then
			angle = angle + 360
		end

		local rotation = (angle * math.pi) / 180
		local veloc = Coord3D.new()
		local distance_xyz = math.ceil(get_world_dist_xyz(s.Pos.D3,t.Pos.D3)/512)
		veloc.Xpos = math.ceil((math.cos(rotation) * 32*distance_xyz))
		veloc.Zpos = math.ceil((math.sin(rotation) * 32*distance_xyz))
		
		local grenade = createThing(T_SHOT, M_SHOT_VOLCANO_FIREBALL_1, owner, s.Pos.D3, false, false)
		local grenade_move = grenade.Move
		grenade_move.Velocity.X = veloc.Xpos
		grenade_move.Velocity.Z = veloc.Zpos
		grenade_move.Velocity.Y = 256
		grenade_move.SelfPowerSpeed = 128
		--insert_thing_into_table(grenade)
		
		local vars = mg_player_vars[owner]
		vars.cannonc3d = copy_c3d(t.Pos.D3)
		vars.cannoncdr = 16
		
		queue_custom_sound_event(s, rndb(0, 1) == 0 and "y_cannonball1.wav" or "y_cannonball2.wav", 127)
	end
end

function SinkBoatsAdrift()
	ProcessGlobalTypeList(T_VEHICLE,function(boat)
		if boat.Model < 3 then
			if chance(40) then
				if boat ~= nil and boat.State == S_VEHICLE_DRIFT_TO_SHORE then if chance(50) then boat.State = S_VEHICLE_BOAT_DYING else boat.State = S_VEHICLE_BLAST_EXPLODING end end
			end
		end
	return true end)
end

function naval_warfare_on_turn(everySecond1, everySecond2, everySecond4)
	if mg_turn == 1 then
		mg_vars.faster_boats = is_map_rule_active(1)
		mg_vars.close_combat = is_map_rule_active(2)
		mg_vars.no_death_unscore = is_map_rule_active(3)
		init_naval_warfare()
	end
	
	if everySeconds_mg(16) then
		SinkBoatsAdrift()
	end
	
	if mg_vars.faster_boats then
		local max = 512*16
		ProcessGlobalSpecialListAll(BOATLIST, function(t)
			if t.u.Vehicle.NumOccupants > 0 then
				if not thing_close_to_land(t, 1) then
					t.Move.SelfPowerSpeed = 220 --110 default
				end
			end
		return true end)
	end
	
	process_shamans_3(everySecond1, everySecond2, everySecond4)
end

function naval_warfare_on_frame()
	if player_is_spectator(playernum) then return end
	
	local tbl = mg_player_vars[playernum]
	
	if tbl.boatHP then
		local hp, iron, powder = tbl.boatHP, tbl.light_iron, tbl.gun_powder
		
		local spr = 125
		if playernum < 4 then spr = spr+playernum else spr = 1723+(playernum-4) end
		local barLen = mf(W, 6)
		local barHeight = mf(H, 38)
		local divider = mf(W, DROP_BOX_ALERT_W_DIVIDER)
		local _x, _y = GUIW + divider + 4, H - 4 - barHeight
		
		DrawBox(_x-1, _y-1, barHeight+2, barHeight+2, 1)
		DrawBox(_x, _y, barHeight, barHeight, 0)
		LbDraw_ScaledSprite(_x, _y, get_sprite(0, spr), barHeight, barHeight)
		
		local percent = floor((hp * 100)/1024)
		local barpercent = floor((barLen * percent) / 100)
		local color = nilS(playernum) and tbl.clr or 0
		
		DrawBox(_x + barHeight + 4-1, _y-1, barLen+2, barHeight+2, 1)
		DrawBox(_x + barHeight + 4, _y, barLen, barHeight, 0)
		DrawBox(_x + barHeight + 4, _y, barpercent, barHeight, color)
		
		PopSetFont(11, 0)
		local fh = CharHeight2()
		_x = _x + barHeight + barLen + 4*2
		
		if iron > 0 then
			DrawBox(_x-1, _y-1, barHeight+2, barHeight+2, 1)
			DrawBox(_x, _y, barHeight, barHeight, 0)
			LbDraw_ScaledSprite(_x, _y, get_sprite(0, 1859), barHeight, barHeight)
			LbDraw_Text(_x, _y-fh, tostring(mf(iron, 12)), 0)
			_x = _x + barHeight + 4
		end
		
		if powder > 0 then
			DrawBox(_x-1, _y-1, barHeight+2, barHeight+2, 1)
			DrawBox(_x, _y, barHeight, barHeight, 0)
			LbDraw_ScaledSprite(_x, _y, get_sprite(0, 1860), barHeight, barHeight)
			LbDraw_Text(_x, _y-fh, tostring(mf(powder, 12)), 0)
		end
	end
end

function naval_warfare_on_shaman_dead(victim, killer, were_allies)
	if not were_allies then
		give_points_to_team(5, killer, false)
	end
	
	if not mg_vars.no_death_unscore then
		give_points_to_team(-2, victim, false)
	end
	
	reset_player_variables_3(victim)
	order_scores()
end

function naval_warfare_on_create_thing(t, owner, type, model)
	if type == T_SPELL then
		if model ~= M_SPELL_SHIELD then
			--t.Model = _NO_SPELL_MODEL
			local shaman = getShaman(owner)
			
			if nilS(owner) then
				local vehicled = is_person_in_boat(shaman) > 0
				
				if not vehicled then
					GIVE_ONE_SHOT(model, owner)
				else
					if spell_away_from_cors_3(t) then
						local cdrs = mg_player_vars[owner]
						
						if model == M_SPELL_CONVERT_WILD then
							local cdr = (cdrs.light_iron <= 0) and 12*4 or 12*2
							cdrs.cannonball = cdr
							spawn_cannonball_3(t, owner)
							
							for _, player in ipairs(_participants) do
								local pn = player.tribe
								
								if pn ~= owner then
									if player.ai then
										if nilS(pn) then
											if get_world_dist_xz(t.Pos.D2, getShaman(pn).Pos.D2) < 512*3 then
												try_to_dodge_on_water(pn, 2, 10 + player.diff*15)
											end
										end
									end
								end
							end
						else
							cdrs.greekFirecdr = 12
							cdrs.greekFirec3d = copy_c3d(t.Pos.D3)
							createThing(T_SPELL, M_SPELL_SHIELD, t.Owner, t.Pos.D3, false, false)
							queue_custom_sound_event(shaman, "y_greekfire.wav", 127)
						end
					else
						GIVE_ONE_SHOT(model, owner)
					end
				end
			end
		end
	elseif type == T_SHOT then
		if (t.Model == M_SHOT_VOLCANO_FIREBALL_1) then
			t.u.Shot.TargetThingIdx:set(0)
			t.DrawInfo.Alpha = -16
			local cdrs = mg_player_vars[owner]
			local light_iron, powder = cdrs.light_iron > 0, cdrs.gun_powder > 0
			local powder_btn = btn(powder)
			local spr = 1863 + powder_btn*3
			
			if light_iron then
				spr = 1864 + powder_btn
			end
			
			set_thing_draw_info(t, TDI_SPRITE_F1_D1, spr)
		end
	end
end

function NW_on_end()
	-- ProcessGlobalTypeList(T_SCENERY, function(sh)
		-- if sh and sh.Model == M_SCENERY_HEAD then
			-- --set_thing_draw_info(sh, TDI_SPRITE_F1_D1, 687) 
			-- sh.DrawInfo.Flags = DisableFlag(sh.DrawInfo.Flags, DF_USE_ENGINE_SHADOW)
		-- end
	-- return true end)
end

----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
--QUIZZ----------------------------------QUIZZ--------------------------------------------------------QUIZZ---------------------------------------------------------QUIZZ---
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

--2000
quiz_questions = {
{"How many wood piles are required to build a balloon hut?", "11", "9", "10", "13", "12", "8"},{"Which modder created the Populous campaign 'Odd Worlds'?", "GBA1990", "Alex Bond", "Divinity", "Impboy", "MrKosjak", "Sulivan"},{"What is Populous level 21 called?", "Fractured Earth", "Solo", "Unlikely Allies", "Archipelago", "Head Hunter", "Middle Ground"},{"What is Populous level 13 called?", "Aerial Bombardment", "An Easy Target", "Attacked From All Sides", "Treacherous Souls", "Incarcerated", "Fire in the Mist"},{"Which spell has lower range than all the other options?", "Angel of Death", "Firestorm", "Magical Shield", "Hypnotise", "Swamp", "Flatten"},{"What gets permanently unlocked in 'Attacked from All Sides'?", "Firestorm", "None of the Options", "Spies", "Earthquake", "Balloons", "Erosion"},{"In Undiscovered Worlds level 'Worlds Wide Web', what particularity is on the stone heads?", "spawn units", "create Magical Shielded Zones", "grant a random spell", "bloodlust the worshippers", "generate land on the base", "spawn trees on the base"},{"How many trees can spawn using the guest spell 'Trees'?", "3", "2", "4", "between 2 and 4", "between 3 and 4", "between 2 and 3"},{"What is the capital of Afghanistan?", "Kabul", "Kandahar", "Herat", "Mazar-i-Sharif", "Jalalabad", "Ghazni"},{"What is the capital of Albania?", "Tirana", "Durres", "Vlore", "Shkoder", "Fier", "Saranda"},{"What is the capital of Algeria?", "Algiers", "Oran", "Constantine", "Annaba", "Blida", "Batna"},{"What is the capital of Andorra?", "Andorra la Vella", "Escaldes-Engordany", "Encamp", "La Massana", "Canillo", "Sant Julia de Loria"},{"What is the capital of Angola?", "Luanda", "N'dalatando", "Huambo", "Lobito", "Benguela", "Kuito"},{"What is the capital of Argentina?", "Buenos Aires", "Cordoba", "Rosario", "Mendoza", "La Plata", "Salta"},{"What is the capital of Armenia?", "Yerevan", "Gyumri", "Vanadzor", "Vagharshapat", "Artik", "Kapan"},{"What is the capital of Australia?", "Canberra", "Sydney", "Melbourne", "Brisbane", "Perth", "Adelaide"},{"What is the capital of Austria?", "Vienna", "Salzburg", "Graz", "Innsbruck", "Linz", "Klagenfurt"},{"What is the capital of Azerbaijan?", "Baku", "Ganja", "Sumqayit", "Lankaran", "Mingachevir", "Shirvan"},{"What is the capital of Bahamas?", "Nassau", "Freeport", "Lucaya", "Marsh Harbour", "Rock Sound", "Spanish Wells"},{"What is the capital of Bahrain?", "Manama", "Riffa", "Muharraq", "Sitra", "Hamad Town", "A'ali"},{"What is the capital of Bangladesh?", "Dhaka", "Chittagong", "Khulna", "Rajshahi", "Sylhet", "Barisal"},{"What is the capital of Barbados?", "Bridgetown", "Speightstown", "Oistins", "Bathsheba", "Saint Lawrence", "Holetown"},{"What is the capital of Belarus?", "Minsk", "Gomel", "Mogilev", "Vitebsk", "Brest", "Grodno"},{"What is the capital of Belgium?", "Brussels", "Antwerp", "Ghent", "Bruges", "Namur", "Liege"},{"What is the capital of Belize?", "Belmopan", "Belize City", "San Ignacio", "Orange Walk", "Corozal", "Punta Gorda"},{"What is the capital of Benin?", "Porto-Novo", "Cotonou", "Parakou", "Djougou", "Bohicon", "Natitingou"},{"What is the capital of Bhutan?", "Thimphu", "Phuntsholing", "Paro", "Jakar", "Gelephu", "Wangdue Phodrang"},{"What is the capital of Bolivia?", "Sucre", "La Paz", "Cochabamba", "Santa Cruz", "Oruro", "Potosi"},{"What is the capital of Bosnia and Herzegovina?", "Sarajevo", "Banja Luka", "Tuzla", "Zenica", "Mostar", "Bijeljina"},{"What is the capital of Botswana?", "Gaborone", "Francistown", "Molepolole", "Maun", "Kasane", "Selibe-Phikwe"},{"What is the capital of Brazil?", "Brasilia", "Rio de Janeiro", "Sao Paulo", "Salvador", "Fortaleza", "Belo Horizonte"},{"What is the capital of Brunei?", "Bandar Seri Begawan", "Kuala Belait", "Seria", "Tutong", "Bangar", "Lumut"},{"What is the capital of Bulgaria?", "Sofia", "Plovdiv", "Varna", "Burgas", "Ruse", "Shumen"},{"What is the capital of Burkina Faso?", "Ouagadougou", "Bobo-Dioulasso", "Koudougou", "Banfora", "Manga", "Tenkodogo"},{"What is the capital of Burundi?", "Gitega", "Bujumbura", "Ngozi", "Kayanza", "Muramvya", "Makamba"},{"What is the capital of Cabo Verde?", "Praia", "Mindelo", "Santa Maria", "Sao Filipe", "Espargos", "Tarrafal"},{"What is the capital of Cambodia?", "Phnom Penh", "Siem Reap", "Battambang", "Sihanoukville", "Kampot", "Koh Kong"},{"What is the capital of Cameroon?", "Yaounde", "Douala", "Garoua", "Bertoua", "Bafoussam", "Maroua"},{"What is the capital of Canada?", "Ottawa", "Toronto", "Vancouver", "Montreal", "Calgary", "Edmonton"},{"What is the capital of Central African Republic?", "Bangui", "Bangassou", "Berberati", "Bimbo", "Bouar", "Mbaiki"},{"What is the capital of Chad?", "N'Djamena", "Moundou", "Sarh", "Abeche", "Kelo", "Doba"},{"What is the capital of Chile?", "Santiago", "Valparaiso", "Concepcion", "La Serena", "Antofagasta", "Temuco"},{"What is the capital of China?", "Beijing", "Shanghai", "Hong Kong", "Guangzhou", "Shenzhen", "Chengdu"},{"What is the capital of Colombia?", "Bogota", "Medellin", "Cali", "Barranquilla", "Cartagena", "Bucaramanga"},{"What is the capital of Comoros?", "Moroni", "Moutsamoudou", "Mitsamiouli", "Domoni", "Fomboni", "Sima"},{"What is the capital of Congo, Democratic Republic of the?", "Kinshasa", "Lubumbashi", "Mbuji-Mayi", "Kisangani", "Kananga", "Kolwezi"},{"What is the capital of Congo, Republic of the?", "Brazzaville", "Pointe-Noire", "Dolisie", "Owando", "Nkayi", "Kouilou"},{"What is the capital of Costa Rica?", "San Jose", "Alajuela", "Cartago", "Heredia", "Guanacaste", "Limon"},{"What is the capital of Croatia?", "Zagreb", "Split", "Dubrovnik", "Rijeka", "Osijek", "Pula"},{"What is the capital of Cuba?", "Havana", "Santiago de Cuba", "Camaguey", "Holguin", "Santa Clara", "Cienfuegos"},{"What is the capital of Cyprus?", "Nicosia", "Limassol", "Famagusta", "Kyrenia", "Larnaca", "Paphos"},{"What is the capital of Czech Republic?", "Prague", "Brno", "Ostrava", "Plzen", "Liberec", "Hradec Kralove"},{"What is the capital of Denmark?", "Copenhagen", "Aarhus", "Odense", "Aalborg", "Esbjerg", "Randers"},{"What is the capital of Djibouti?", "Djibouti", "Ali Sabieh", "Tadjourah", "Dikhil", "Obock", "Loguanda"},{"What is the capital of Dominica?", "Roseau", "Portsmouth", "Marigot", "Salisbury", "Calibishie", "Berekua"},{"What is the capital of Dominican Republic?", "Santo Domingo", "Santiago", "La Romana", "San Pedro de Macoris", "San Francisco de Macoris", "Puerto Plata"},{"What is the capital of Ecuador?", "Quito", "Guayaquil", "Cuenca", "Manta", "Loja", "Ambato"},{"What is the capital of Egypt?", "Cairo", "Alexandria", "Giza", "Luxor", "Aswan", "Sharm El Sheikh"},{"What is the capital of El Salvador?", "San Salvador", "Santa Ana", "San Miguel", "Sonsonate", "La Libertad", "Ahuachapan"},{"What is the capital of Equatorial Guinea?", "Malabo", "Bata", "Ebebiyin", "Aconibe", "Luba", "Mongomo"},{"What is the capital of Eritrea?", "Asmara", "Keren", "Mendefera", "Massawa", "Assab", "Barentu"},{"What is the capital of Estonia?", "Tallinn", "Tartu", "Narva", "Kohtla-Järve", "Pärnu", "Viljandi"},{"What is the capital of Eswatini?", "Mbabane", "Manzini", "Siteki", "Lobamba", "Piggs Peak", "Hlatikulu"},{"What is the capital of Ethiopia?", "Addis Ababa", "Dire Dawa", "Mekelle", "Gondar", "Hawassa", "Jimma"},{"What is the capital of Fiji?", "Suva", "Nadi", "Lautoka", "Labasa", "Ba", "Sigatoka"},{"What is the capital of Finland?", "Helsinki", "Espoo", "Vantaa", "Tampere", "Oulu", "Turku"},{"What is the capital of France?", "Paris", "Marseille", "Lyon", "Nice", "Bordeaux", "Toulouse"},{"What is the capital of Gabon?", "Libreville", "Port-Gentil", "Franceville", "Oyem", "Mouila", "Bitam"},{"What is the capital of Gambia?", "Banjul", "Serrekunda", "Bakau", "Brikama", "Gunjur", "Farafenni"},{"What is the capital of Georgia?", "Tbilisi", "Batumi", "Kutaisi", "Zugdidi", "Rustavi", "Zestaponi"},{"What is the capital of Germany?", "Berlin", "Munich", "Frankfurt", "Hamburg", "Cologne", "Stuttgart"},{"What is the capital of Ghana?", "Accra", "Kumasi", "Tamale", "Takoradi", "Sekondi", "Cape Coast"},{"What is the capital of Greece?", "Athens", "Podgorica", "Nicosia", "Rome", "Tirana", "Volos"},{"What is the capital of Grenada?", "St. George's", "Gouyave", "Sauteurs", "Victoria", "Grenville", "Carriacou"},{"What is the capital of Guatemala?", "Guatemala City", "Quetzaltenango", "Escuintla", "Mixco", "Villa Nueva", "Chimaltenango"},{"What is the capital of Guinea?", "Conakry", "Kankan", "Nzerekore", "Kindia", "Labe", "Fria"},{"What is the capital of Guinea-Bissau?", "Bissau", "Gabu", "Bolama", "Cacheu", "Oio", "Tombali"},{"What is the capital of Guyana?", "Georgetown", "Linden", "New Amsterdam", "Anna Regina", "Rosignol", "Lethem"},{"What is the capital of Haiti?", "Port-au-Prince", "Cap-Haitien", "Les Cayes", "Jacmel", "Petit-Goave", "Miragoane"},{"What is the capital of Honduras?", "Tegucigalpa", "San Pedro Sula", "Choloma", "La Ceiba", "El Progreso", "Comayagua"},{"What is the capital of Hungary?", "Budapest", "Debrecen", "Szeged", "Miskolc", "Pecs", "Gyor"},{"What is the capital of Iceland?", "Reykjavik", "Akureyri", "Kopavogur", "Selfoss", "Vestmannaeyjar", "Egilsstaoir"},{"What is the capital of India?", "New Delhi", "Mumbai", "Bangalore", "Chennai", "Kolkata", "Hyderabad"},{"What is the capital of Indonesia?", "Jakarta", "Bali", "Surabaya", "Bandung", "Medan", "Semarang"},{"What is the capital of Iran?", "Tehran", "Isfahan", "Shiraz", "Tabriz", "Mashhad", "Ahvaz"},{"What is the capital of Iraq?", "Baghdad", "Basra", "Mosul", "Erbil", "Sulaymaniyah", "Najaf"},{"What is the capital of Ireland?", "Dublin", "Cork", "Limerick", "Galway", "Waterford", "Kilkenny"},{"What is the capital of Israel?", "Jerusalem", "Tel Aviv", "Haifa", "Eilat", "Nazareth", "Ashdod"},{"What is the capital of Italy?", "Rome", "Milan", "Naples", "Turin", "Florence", "Genoa"},{"What is the capital of Jamaica?", "Kingston", "Montego Bay", "Spanish Town", "Portmore", "Mandeville", "Ocho Rios"},{"What is the capital of Japan?", "Tokyo", "Osaka", "Kyoto", "Hiroshima", "Nagoya", "Sapporo"},{"What is the capital of Jordan?", "Amman", "Zarqa", "Irbid", "Aqaba", "Mafraq", "Karak"},{"What is the capital of Kazakhstan?", "Astana", "Almaty", "Shymkent", "Karaganda", "Aktobe", "Taraz"},{"What is the capital of Kenya?", "Nairobi", "Mombasa", "Kisumu", "Nakuru", "Eldoret", "Garissa"},{"What is the capital of Kiribati?", "Tarawa", "Bairiki", "Betio", "Teaoraereke", "Buota", "London"},{"What is the capital of Kosovo?", "Pristina", "Pec", "Mitrovica", "Ferizaj", "Gjakova", "Vushtrri"},{"What is the capital of Kuwait?", "Kuwait City", "Hawalli", "Salmiya", "Al Ahmadi", "Farwaniya", "Mubarak Al-Kabeer"},{"What is the capital of Kyrgyzstan?", "Bishkek", "Osh", "Jalal-Abad", "Karabalta", "Tokmok", "Naryn"},{"What is the capital of Laos?", "Vientiane", "Luang Prabang", "Pakse", "Savannakhet", "Xam Neua", "Thakhek"},{"What is the capital of Latvia?", "Riga", "Daugavpils", "Liepaja", "Jelgava", "Rēzekne", "Ventspils"},{"What is the capital of Lebanon?", "Beirut", "Tripoli", "Sidon", "Tyre", "Zahle", "Jounieh"},{"What is the capital of Lesotho?", "Maseru", "Teyateyaneng", "Maputsoe", "Quthing", "Hlotse", "Leribe"},{"What is the capital of Liberia?", "Monrovia", "Gbarnga", "Bensonville", "Harper", "Kakata", "Buchanan"},{"What is the capital of Libya?", "Tripoli", "Benghazi", "Misrata", "Tobruk", "Sebha", "Zliten"},{"What is the capital of Liechtenstein?", "Vaduz", "Schaan", "Balzers", "Eschen", "Schellenberg", "Ruggell"},{"What is the capital of Lithuania?", "Vilnius", "Kaunas", "Klaipeda", "siauliai", "Panevėžys", "Alytus"},{"What is the capital of Luxembourg?", "Luxembourg City", "Esch-sur-Alzette", "Differdange", "Dudelange", "Ettelbruck", "Grevenmacher"},{"What is the capital of Madagascar?", "Antananarivo", "Toamasina", "Antsiranana", "Fianarantsoa", "Toliara", "Mahajanga"},{"What is the capital of Malawi?", "Lilongwe", "Blantyre", "Mzuzu", "Zomba", "Mangochi", "Karonga"},{"What is the capital of Malaysia?", "Kuala Lumpur", "Putrajaya", "George Town", "Johor Bahru", "Kota Kinabalu", "Malacca"},{"What is the capital of Maldives?", "Male", "Addu City", "Fuvahmulah", "Hithadhoo", "Dhidhdhoo", "Kulhudhuffushi"},{"What is the capital of Mali?", "Bamako", "Sikasso", "Kayes", "Koutiala", "Tombouctou", "Mopti"},{"What is the capital of Malta?", "Valletta", "Birkirkara", "Sliema", "St. Julian's", "Mosta", "Qormi"},{"What is the capital of Marshall Islands?", "Majuro", "Ebeye", "Arno", "Bikini Atoll", "Kili", "Wotje"},{"What is the capital of Mauritania?", "Nouakchott", "Nouadhibou", "Kaedi", "Kiffa", "Atar", "Rosso"},{"What is the capital of Mauritius?", "Port Louis", "Beau Bassin-Rose Hill", "Vacoas-Phoenix", "Quatre Bornes", "Curepipe", "Black River"},{"What is the capital of Mexico?", "Mexico City", "Guadalajara", "Monterrey", "Puebla", "Tijuana", "Cancun"},{"What is the capital of Micronesia?", "Palikir", "Weno", "Kolonia", "Chuuk", "Pohnpei", "Yap"},{"What is the capital of Moldova?", "Chisinău", "Bălti", "Bender", "Tighina", "Ungheni", "Cahul"},{"What is the capital of Monaco?", "Monaco", "Monte Carlo", "La Condamine", "Menton", "Roquebrune-Cap-Martin", "Beausoleil"},{"What is the capital of Mongolia?", "Ulaanbaatar", "Erdenet", "Darkhan", "Choibalsan", "Baganuur", "Moron"},{"What is the capital of Montenegro?", "Podgorica", "Niksić", "Herceg Novi", "Bijelo Polje", "Tivat", "Kotor"},{"What is the capital of Morocco?", "Rabat", "Casablanca", "Marrakech", "Fes", "Tangier", "Agadir"},{"What is the capital of Mozambique?", "Maputo", "Beira", "Nampula", "Tete", "Pemba", "Quelimane"},{"What is the capital of Myanmar?", "Naypyidaw", "Yangon", "Mandalay", "Naypyidaw", "Bago", "Pathein"},{"What is the capital of Namibia?", "Windhoek", "Swakopmund", "Walvis Bay", "Oshakati", "Katima Mulilo", "Rundu"},{"What is the capital of Nauru?", "Yaren", "Denigomodu", "Boe", "Meneng", "Anabar", "Nauru"},{"What is the capital of Nepal?", "Kathmandu", "Pokhara", "Biratnagar", "Lalitpur", "Bhaktapur", "Nepalgunj"},{"What is the capital of Netherlands?", "Amsterdam", "The Hague", "Rotterdam", "Utrecht", "Eindhoven", "Groningen"},{"What is the capital of New Zealand?", "Wellington", "Auckland", "Christchurch", "Hamilton", "Dunedin", "Tauranga"},{"What is the capital of Nicaragua?", "Managua", "Leon", "Granada", "Masaya", "Esteli", "Matagalpa"},{"What is the capital of Niger?", "Niamey", "Zinder", "Maradi", "Agadez", "Tahoua", "Diffa"},{"What is the capital of Nigeria?", "Abuja", "Lagos", "Port Harcourt", "Ibadan", "Kano", "Benin City"},{"What is the capital of North Macedonia?", "Skopje", "Bitola", "Ohrid", "Kumanovo", "Tetovo", "Veles"},{"What is the capital of Norway?", "Oslo", "Bergen", "Stavanger", "Drammen", "Trondheim", "Bodø"},{"What is the capital of Oman?", "Muscat", "Salalah", "Sohar", "Nizwa", "Sur", "Ibra"},{"What is the capital of Pakistan?", "Islamabad", "Karachi", "Lahore", "Rawalpindi", "Faisalabad", "Multan"},{"What is the capital of Palau?", "Ngerulmud", "Melekeok", "Koror", "Angaur", "Babeldaob", "Sonsorol"},{"What is the capital of Panama?", "Panama City", "David", "Colon", "Santiago", "Chiriqui", "La Chorrera"},{"What is the capital of Papua New Guinea?", "Port Moresby", "Lae", "Mount Hagen", "Madang", "Rabaul", "Goroka"},{"What is the capital of Paraguay?", "Asuncion", "Ciudad del Este", "Encarnacion", "Pedro Juan Caballero", "Concepcion", "Villa Hayes"},{"What is the capital of Peru?", "Lima", "Arequipa", "Trujillo", "Chiclayo", "Piura", "Iquitos"},{"What is the capital of Philippines?", "Manila", "Quezon City", "Davao City", "Cebu City", "Zamboanga City", "Iloilo City"},{"What is the capital of Poland?", "Warsaw", "Krakow", "Wroclaw", "Poznan", "Gdansk", "lodź"},{"What is the capital of Portugal?", "Lisbon", "Porto", "Coimbra", "Braga", "evora", "Funchal"},{"What is the capital of Qatar?", "Doha", "Al Rayyan", "Al Wakrah", "Umm Salal", "Al Khor", "Mesaieed"},{"What is the capital of Romania?", "Bucharest", "Cluj-Napoca", "Timisoara", "Iasi", "Brasov", "Constanta"},{"What is the capital of Russia?", "Moscow", "Saint Petersburg", "Novosibirsk", "Yekaterinburg", "Kazan", "Nizhny Novgorod"},{"What is the capital of Rwanda?", "Kigali", "Butare", "Gisenyi", "Musanze", "Nyamata", "Rubavu"},{"What is the capital of Saint Kitts and Nevis?", "Basseterre", "Charlestown", "Cayon", "Sandy Point Town", "Dieppe Bay Town", "Mango"},{"What is the capital of Saint Lucia?", "Castries", "Vieux Fort", "Soufriere", "Gros Islet", "Bisee", "Bonaire"},{"What is the capital of Saint Vincent and the Grenadines?", "Kingstown", "Bequia", "Union Island", "Canouan", "Mayreau", "Mustique"},{"What is the capital of Samoa?", "Apia", "Leone", "Faleula", "Lalomanu", "Salelologa", "Savai'i"},{"What is the capital of San Marino?", "San Marino", "Serravalle", "Borgo Maggiore", "Murata", "Fiorentino", "Domagnano"},{"What is the capital of Sao Tome and Principe?", "Sao Tome", "Principe", "Santana", "Neves", "Trindade", "Paguia"},{"What is the capital of Saudi Arabia?", "Riyadh", "Jeddah", "Mecca", "Medina", "Dhahran", "Dammam"},{"What is the capital of Senegal?", "Dakar", "Pikine", "Touba", "Thies", "Kaolack", "Ziguinchor"},{"What is the capital of Serbia?", "Belgrade", "Novi Sad", "Nis", "Kragujevac", "Subotica", "Senta"},{"What is the capital of Seychelles?", "Victoria", "Beau Vallon", "Anse Royale", "La Digue", "Praslin", "Mahe"},{"What is the capital of Sierra Leone?", "Freetown", "Bo", "Kenema", "Makeni", "Moyamba", "Kabala"},{"What is the capital of Singapore?", "Singapore", "Marina Bay", "Orchard Road", "Sentosa", "Jurong", "Raffles Place"},{"What is the capital of Slovakia?", "Bratislava", "Kosice", "Presov", "Nitra", "Trnava", "Žilina"},{"What is the capital of Slovenia?", "Ljubljana", "Maribor", "Celje", "Kranj", "Nova Gorica", "Trbovlje"},{"What is the capital of Solomon Islands?", "Honiara", "Gizo", "Auki", "Lata", "Buala", "Munda"},{"What is the capital of Somalia?", "Mogadishu", "Hargeisa", "Bosaso", "Kismayo", "Baidoa", "Galkayo"},{"What is the capital of South Africa?", "Pretoria", "Cape Town", "Durban", "Johannesburg", "Port Elizabeth", "Bloemfontein"},{"What is the capital of South Korea?", "Seoul", "Busan", "Incheon", "Suwon", "Gwangju", "Ulsan"},{"What is the capital of South Sudan?", "Juba", "Malakal", "Wau", "Bor", "Rumbek", "Aweil"},{"What is the capital of Spain?", "Madrid", "Barcelona", "Valencia", "Seville", "Bilbao", "Malaga"},{"What is the capital of Sri Lanka?", "Sri Jayawardenepura Kotte", "Colombo", "Galle", "Kandy", "Jaffna", "Negombo"},{"What is the capital of Sudan?", "Khartoum", "Omdurman", "Nyala", "El Fasher", "Port Sudan", "Kassala"},{"What is the capital of Suriname?", "Paramaribo", "Moengo", "Nickerie", "Brokopondo", "Brownsweg", "Albina"},{"What is the capital of Sweden?", "Stockholm", "Gothenburg", "Malmo", "Uppsala", "Linkoping", "orebro"},{"What is the capital of Switzerland?", "Bern", "Zurich", "Geneva", "Basel", "Lausanne", "Lucerne"},{"What is the capital of Syria?", "Damascus", "Aleppo", "Homs", "Latakia", "Tartus", "Daraa"},{"What is the capital of Taiwan?", "Taipei", "Kaohsiung", "Taichung", "Tainan", "Hsinchu", "Keelung"},{"What is the capital of Tajikistan?", "Dushanbe", "Khujand", "Kulob", "Istaravshan", "Qurghonteppa", "Tursunzoda"},{"What is the capital of Tanzania?", "Dodoma", "Dar es Salaam", "Arusha", "Mwanza", "Mbeya", "Tanga"},{"What is the capital of Thailand?", "Bangkok", "Chiang Mai", "Pattaya", "Nakhon Ratchasima", "Khon Kaen", "Hat Yai"},{"What is the capital of Togo?", "Lome", "Sokode", "Kara", "Kpalime", "Tsevie", "Atakpame"},{"What is the capital of Tonga?", "Nukualofa", "Vava'u", "Ha'apai", "Auckland", "Fua'amotu", "Neiafu"},{"What is the capital of Trinidad and Tobago?", "Port of Spain", "San Fernando", "Scarborough", "Chaguanas", "Princes Town", "Arima"},{"What is the capital of Tunisia?", "Tunis", "Sfax", "Sousse", "Kairouan", "Bizerte", "Gabes"},{"What is the capital of Turkey?", "Ankara", "Istanbul", "Izmir", "Antalya", "Bursa", "Adana"},{"What is the capital of Turkmenistan?", "Ashgabat", "Turkmenbashi", "Mary", "Balkanabat", "Dashoguz", "Turkmenabat"},{"What is the capital of Tuvalu?", "Funafuti", "Fakaofo", "Nukufetau", "Nanumea", "Vaitupu", "Nui"},{"What is the capital of Uganda?", "Kampala", "Entebbe", "Jinja", "Mbarara", "Gulu", "Mbale"},{"What is the capital of Ukraine?", "Kyiv", "Kharkiv", "Odesa", "Lviv", "Dnipro", "Donetsk"},{"What is the capital of United Arab Emirates?", "Abu Dhabi", "Dubai", "Sharjah", "Ajman", "Ras Al Khaimah", "Fujairah"},{"What is the capital of United Kingdom?", "London", "Edinburgh", "Birmingham", "Manchester", "Liverpool", "Glasgow"},{"What is the capital of United States?", "Washington, D.C.", "New York City", "Los Angeles", "Chicago", "Houston", "San Francisco"},{"What is the capital of Uruguay?", "Montevideo", "Salto", "Paysandu", "Maldonado", "Tacuarembo", "Colonia del Sacramento"},{"What is the capital of Uzbekistan?", "Tashkent", "Samarkand", "Bukhara", "Andijan", "Nukus", "Namangan"},{"What is the capital of Vanuatu?", "Port Vila", "Luganville", "Sola", "Tanna", "Malekula", "Espiritu Santo"},{"What is the capital of Vatican City?", "Vatican City", "Rome", "Florence", "Milan", "Naples", "Bologna"},{"What is the capital of Venezuela?", "Caracas", "Maracaibo", "Valencia", "Barquisimeto", "Ciudad Guayana", "Maturin"},{"What is the capital of Vietnam?", "Hanoi", "Ho Chi Minh City", "Da Nang", "Nha Trang", "Hue", "Can Tho"},{"What is the capital of Yemen?", "Sana'a", "Aden", "Taiz", "Hodeidah", "Ibb", "Mokha"},{"What is the capital of Zambia?", "Lusaka", "Ndola", "Kitwe", "Livingstone", "Chingola", "Chipata"},{"What is the capital of Zimbabwe?", "Harare", "Bulawayo", "Gweru", "Mutare", "Kwekwe", "Masvingo"},{"What is the largest planet in our solar system?", "Jupiter", "Saturn", "Earth", "Mars", "Neptune", "Venus"},{"What is the closest star to Earth?", "Proxima Centauri", "Sirius", "Alpha Centauri", "Betelgeuse", "Vega", "Arcturus"},{"What planet is known as the Red Planet?", "Mars", "Venus", "Jupiter", "Saturn", "Mercury", "Uranus"},{"What is the name of our galaxy?", "Milky Way", "Andromeda", "Triangulum", "Whirlpool", "Pinwheel", "Sombrero"},{"What is the process by which stars generate energy?", "Nuclear fusion", "Fission", "Radioactivity", "Photosynthesis", "Combustion", "Conduction"},{"What celestial body orbits the Earth?", "Moon", "Mars", "Venus", "Jupiter", "Sun", "Saturn"},{"What is the name of the first artificial satellite launched into space?", "Sputnik 1", "Apollo 11", "Voyager 1", "Hubble", "International Space Station", "Lunar Module"},{"Which planet has the most moons?", "Saturn", "Jupiter", "Mars", "Earth", "Neptune", "Uranus"},{"What is the term for a rock or metal fragment from space that hits Earth?", "Meteorite", "Asteroid", "Comet", "Meteoroid", "Satellite", "Planetoid"},{"What is the hottest planet in our solar system?", "Venus", "Mercury", "Mars", "Jupiter", "Saturn", "Uranus"},{"What do we call a solar system's star?", "Sun", "Planet", "Moon", "Asteroid", "Comet", "Nebula"},{"What is the term for the distance light travels in one year?", "Light-year", "Parsec", "Astronomical Unit", "Kilometer", "Mile", "Nautical mile"},{"What type of galaxy is the Milky Way?", "Spiral", "Elliptical", "Irregular", "Lenticular", "Barred spiral", "Dwarf"},{"What is a black hole?", "A region in space with gravitational pull so strong that nothing can escape it", "A collapsed star", "A dark nebula", "A type of galaxy", "A neutron star", "A comet"},{"What phenomenon causes the phases of the Moon?", "The Moon's position relative to the Earth and Sun", "Earth's rotation", "Solar winds", "Lunar eclipses", "Planetary alignment", "Tidal forces"},{"What is the main component of the Sun?", "Hydrogen", "Oxygen", "Carbon", "Helium", "Nitrogen", "Iron"},{"What is the second-largest planet in our solar system?", "Saturn", "Jupiter", "Neptune", "Earth", "Uranus", "Mars"},{"What type of star is the Sun classified as?", "G-type main-sequence star", "Red giant", "White dwarf", "Supernova", "Neutron star", "Brown dwarf"},{"What is the name of the effect that causes light from distant galaxies to appear redshifted?", "Doppler effect", "Photoelectric effect", "Gravitational lensing", "Hubble effect", "Compton effect", "Thermal radiation"},{"What is the name of the boundary around a black hole beyond which nothing can escape?", "Event horizon", "Accretion disk", "Singularity", "Photon sphere", "Schwarzschild radius", "Kerr radius"},{"What is the largest volcano in the solar system?", "Olympus Mons", "Mauna Kea", "Mount Everest", "Mount Kilimanjaro", "Mount St. Helens", "Kilimanjaro"},{"Which planet has a day longer than its year?", "Venus", "Mars", "Jupiter", "Saturn", "Mercury", "Neptune"},{"What is the main reason for the seasons on Earth?", "Tilt of the Earth's axis", "Distance from the Sun", "Earth's rotation speed", "Solar flares", "Ocean currents", "Atmospheric pressure"},{"What is the name of the process that forms the rings of Saturn?", "Accretion", "Erosion", "Condensation", "Sublimation", "Dissolution", "Fission"},{"What is the most abundant element in the universe?", "Hydrogen", "Helium", "Oxygen", "Carbon", "Nitrogen", "Iron"},{"What is the primary ingredient in comets?", "Ice and dust", "Rock", "Gas", "Metal", "Plasma", "Liquid"},{"What is the Kuiper Belt?", "A region of icy bodies beyond Neptune", "A belt of asteroids between Mars and Jupiter", "A region of gas giants", "A star cluster", "A type of galaxy", "A meteor shower"},{"Which planet is known for its prominent ring system?", "Saturn", "Jupiter", "Neptune", "Uranus", "Mars", "Mercury"},{"What is the coldest place in the universe?", "The Boomerang Nebula", "Pluto", "Neptune", "Mars", "Venus", "Titan"},{"What astronomical event occurs when the Earth passes between the Sun and the Moon?", "Lunar eclipse", "Solar eclipse", "Meteor shower", "Planetary alignment", "Tidal wave", "Equinox"},{"What is the name of the force that keeps planets in orbit around the Sun?", "Gravity", "Magnetism", "Friction", "Inertia", "Pressure", "Tension"},{"What celestial phenomenon is a massive explosion of a star?", "Supernova", "Nova", "Black hole", "Pulsar", "Quasar", "Neutron star"},{"What is the largest known structure in the universe?", "Hercules-Corona Borealis Great Wall", "Milky Way", "Andromeda", "Virgo Supercluster", "Laniakea", "Great Attractor"},{"What is the primary purpose of the Hubble Space Telescope?", "Observing deep space", "Weather forecasting", "Earth monitoring", "Satellite communications", "Space debris tracking", "Planetary exploration"},{"What is a quasar?", "An extremely luminous active galactic nucleus", "A type of star", "A black hole", "A planet", "A moon", "An asteroid"},{"What is the name of the first manned mission to the Moon?", "Apollo 11", "Gemini 4", "Mercury 7", "Apollo 13", "Artemis 1", "Soyuz 1"},{"What are shooting stars?", "Meteors", "Comets", "Planets", "Asteroids", "Satellites", "Dwarf planets"},{"What is the name of the region where stars are born?", "Nebula", "Galaxy", "Cluster", "Supernova", "Horizon", "Accretion disk"},{"Which planet is known for its Great Red Spot?", "Jupiter", "Mars", "Saturn", "Neptune", "Uranus", "Venus"},{"What is the term for the study of the universe and celestial objects?", "Astronomy", "Astrophysics", "Astrobiology", "Geology", "Meteorology", "Oceanography"},{"What is the largest asteroid in the asteroid belt?", "Ceres", "Vesta", "Pallas", "Eros", "Euphrosyne", "Hygiea"},{"Which moon is known for having a thick atmosphere?", "Titan", "Europa", "Ganymede", "Callisto", "Io", "Rhea"},{"What is the primary component of a comet's tail?", "Gas and dust", "Ice", "Rock", "Metal", "Plasma", "Liquid"},{"What is the term for a planet that orbits a star outside our solar system?", "Exoplanet", "Dwarf planet", "Asteroid", "Meteoroid", "Comet", "Satellite"},{"What is the main reason we see different constellations at different times of the year?", "Earth's orbit around the Sun", "Earth's rotation", "Stars moving", "Galactic rotation", "Solar activity", "Lunar phases"},{"Which planet has the strongest winds in the solar system?", "Neptune", "Jupiter", "Saturn", "Uranus", "Mars", "Earth"},{"What is the term for the apparent shift in position of a star due to Earth's movement?", "Parallax", "Redshift", "Blueshift", "Aberration", "Doppler effect", "Refraction"},{"What do we call a star that suddenly increases in brightness?", "Nova", "Supernova", "Pulsar", "Quasar", "Dwarf star", "Red giant"},{"Which country provided the first photographs from the surface of another planet?", "USSR", "USA", "United Kingdom", "Japan", "France", "Germany"},{"What is the term for a group of stars that form a recognizable pattern?", "Constellation", "Galaxy", "Cluster", "Nebula", "Star system", "Solar system"},{"What type of galaxy is the Milky Way?", "Spiral", "Elliptical", "Irregular", "Lenticular", "Peculiar", "Dwarf"},{"Which planet has the highest mountain in the Solar System?", "Mars", "Earth", "Venus", "Mercury", "Jupiter", "Saturn"},{"What is the largest known star by volume?", "UY Scuti", "Betelgeuse", "VY Canis Majoris", "Sirius", "Rigel", "Antares"},{"Which planet has the fastest rotation?", "Jupiter", "Earth", "Mars", "Saturn", "Venus", "Neptune"},{"What is the most abundant element in the Sun?", "Hydrogen", "Helium", "Carbon", "Oxygen", "Nitrogen", "Iron"},{"What causes the red color of Mars?", "Iron oxide", "Carbon dioxide", "Sulfur", "Methane", "Silicon", "Magnesium"},{"Which moon is the largest in the Solar System?", "Ganymede", "Titan", "Callisto", "Europa", "Io", "Triton"},{"What is the name of the first artificial satellite?", "Sputnik 1", "Explorer 1", "Vanguard 1", "Telstar", "Luna 1", "Apollo"},{"How many Earths could fit inside the Sun?", "About 1.3 million", "About 130,000", "About 3.3 million", "About 330,000", "About 10 million", "About 100,000"},{"Which planet is known as the 'morning star'?", "Venus", "Mars", "Mercury", "Jupiter", "Saturn", "Neptune"},{"What is the densest planet in the Solar System?", "Earth", "Jupiter", "Saturn", "Mercury", "Mars", "Uranus"},{"What is the largest object in the asteroid belt?", "Ceres", "Vesta", "Pallas", "Hygeia", "Icarus", "Eros"},{"What is the most distant object visible to the naked eye?", "Andromeda Galaxy", "Orion Nebula", "Sirius", "Polaris", "Alpha Centauri", "Betelgeuse"},{"What is the term for a star that suddenly increases in brightness?", "Nova", "Supernova", "Red giant", "Pulsar", "Quasar", "White dwarf"},{"What is the closest star system to the Solar System?", "Alpha Centauri", "Proxima Centauri", "Barnard's Star", "Sirius", "Wolf 359", "Luyten 726-8"},{"What phase is the Moon in when it is fully illuminated?", "Full Moon", "New Moon", "First Quarter", "Last Quarter", "Waning Gibbous", "Waxing Crescent"},{"How many moons does Mars have?", "Two", "One", "Three", "Four", "Five", "None"},{"What is the name of the boundary around a black hole beyond which nothing can escape?", "Event horizon", "Singularity", "Accretion disk", "Photon sphere", "Schwarzschild radius", "Neutron shell"},{"Which planet has the Great Red Spot?", "Jupiter", "Saturn", "Mars", "Venus", "Neptune", "Uranus"},{"What type of stars end their life cycle in a supernova?", "Massive stars", "Red dwarfs", "White dwarfs", "Brown dwarfs", "Neutron stars", "Pulsars"},{"What is the second largest planet in the Solar System?", "Saturn", "Jupiter", "Uranus", "Neptune", "Earth", "Mars"},{"What is the closest galaxy to the Milky Way?", "Andromeda Galaxy", "Triangulum Galaxy", "Magellanic Clouds", "Messier 81", "Whirlpool Galaxy", "Pinwheel Galaxy"},{"What term describes the brightness of a star as seen from Earth?", "Apparent magnitude", "Absolute magnitude", "Luminosity", "Brightness index", "Bolometric magnitude", "Intensity scale"},{"What element is produced in the cores of stars and is essential for life?", "Carbon", "Hydrogen", "Helium", "Nitrogen", "Oxygen", "Iron"},{"What type of object is Sagittarius A*?", "Black hole", "Neutron star", "Quasar", "White dwarf", "Pulsar", "Red giant"},{"What is the smallest planet in the Solar System?", "Mercury", "Mars", "Venus", "Earth", "Neptune", "Uranus"},{"What planet has rings made mostly of ice and rock?", "Saturn", "Jupiter", "Uranus", "Neptune", "Mars", "Venus"},{"Which planet has the most moons?", "Saturn", "Jupiter", "Neptune", "Uranus", "Mars", "Earth"},{"What is the name of the NASA telescope launched to observe distant galaxies?", "Hubble Space Telescope", "James Webb Telescope", "Spitzer Space Telescope", "Chandra X-ray Observatory", "Kepler Space Telescope", "Fermi Gamma-ray Telescope"},{"What causes the different colors in the auroras?", "Solar particles interacting with atmospheric gases", "Sunlight reflecting off clouds", "Moonlight scattering", "Refraction of sunlight", "Lightning in the atmosphere", "Magnetic field fluctuations"},{"What is the largest planet in the Solar System?", "Jupiter", "Saturn", "Uranus", "Neptune", "Earth", "Venus"},{"What is the name for the hypothetical ninth planet in the Solar System?", "Planet Nine", "Planet X", "Nemesis", "Nibiru", "Vulcan", "Zarmina"},{"What is the hottest planet in the Solar System?", "Venus", "Mercury", "Earth", "Mars", "Jupiter", "Saturn"},{"Which planet has seasons that last for over 20 years?", "Uranus", "Neptune", "Saturn", "Mars", "Venus", "Jupiter"},{"What galaxy cluster is the Milky Way a part of?", "Local Group", "Virgo Cluster", "Coma Cluster", "Hercules Cluster", "Perseus Cluster", "Leo Cluster"},{"What is the main component of Jupiter's atmosphere?", "Hydrogen", "Helium", "Ammonia", "Methane", "Oxygen", "Carbon dioxide"},{"Which type of star is the Sun?", "G-type main-sequence star", "Red dwarf", "White dwarf", "Neutron star", "Blue giant", "Red giant"},{"What was the first planet discovered with a telescope?", "Uranus", "Neptune", "Saturn", "Mercury", "Mars", "Venus"},{"What is the bright spot on Neptune caused by?", "Methane storms", "Ice crystal clouds", "Solar reflections", "Iron dust", "Volcanoes", "Atmospheric distortions"},{"What phenomenon causes the Sun to appear redder at sunrise and sunset?", "Atmospheric scattering", "Solar flares", "Refraction", "Reflection", "Rayleigh dispersion", "Absorption"},{"Which planet's day is longer than its year?", "Venus", "Mercury", "Mars", "Jupiter", "Saturn", "Neptune"},{"What kind of telescope uses lenses to collect and focus light?", "Refracting telescope", "Reflecting telescope", "Radio telescope", "Gamma-ray telescope", "X-ray telescope", "Infrared telescope"},{"How long does it take for light from the Sun to reach Earth?", "About 8 minutes", "About 2 minutes", "About 12 minutes", "About 5 minutes", "About 15 minutes", "About 10 minutes"},{"What kind of object is Halley's Comet?", "Comet", "Asteroid", "Dwarf planet", "Meteorite", "Protostar", "Nebula"},{"What is the name of the theory that describes the origin of the universe?", "Big Bang Theory", "Steady State Theory", "Nebular Theory", "Inflation Theory", "Oscillating Universe Theory", "Gravitational Collapse Theory"},{"What is the densest type of star?", "Neutron star", "White dwarf", "Red dwarf", "Main-sequence star", "Brown dwarf", "Red giant"},{"Which planet has polar ice caps like Earth?", "Mars", "Venus", "Jupiter", "Saturn", "Neptune", "Mercury"},{"What is the second brightest star in the night sky?", "Canopus", "Sirius", "Arcturus", "Vega", "Rigel", "Betelgeuse"},{"Which planet is known for its extreme axial tilt of 98 degrees?", "Uranus", "Neptune", "Venus", "Mars", "Saturn", "Mercury"},{"What is the brightest planet in the night sky?", "Venus", "Jupiter", "Mars", "Saturn", "Mercury", "Neptune"},{"Who is the king of the Greek gods?", "Zeus", "Hades", "Poseidon", "Apollo", "Ares", "Hermes"},{"What is the Norse term for the end of the world?", "Ragnarok", "Valhalla", "Yggdrasil", "Bifrost", "Fenrir", "Asgard"},{"In Egyptian mythology, who is the god of the underworld?", "Osiris", "Ra", "Horus", "Anubis", "Thoth", "Sekhmet"},{"What creature is known for its ability to turn people to stone in Greek mythology?", "Medusa", "Chimera", "Cerberus", "Hydra", "Sphinx", "Harpy"},{"Who is the Roman goddess of love?", "Venus", "Juno", "Minerva", "Diana", "Ceres", "Vesta"},{"In Hindu mythology, who is the god of destruction?", "Shiva", "Brahma", "Vishnu", "Ganesha", "Lakshmi", "Hanuman"},{"What is the name of the winged horse in Greek mythology?", "Pegasus", "Hippogriff", "Chimera", "Griffin", "Cerberus", "Sphinx"},{"Who is the goddess of wisdom in Greek mythology?", "Athena", "Hera", "Artemis", "Demeter", "Aphrodite", "Persephone"},{"What is the name of the trickster god in Norse mythology?", "Loki", "Thor", "Odin", "Freyr", "Baldur", "Heimdall"},{"Who is the Egyptian god of the sun?", "Ra", "Osiris", "Anubis", "Horus", "Thoth", "Sekhmet"},{"In Greek mythology, who is the hero that completed twelve labors?", "Heracles", "Theseus", "Achilles", "Odysseus", "Jason", "Perseus"},{"What is the name of the Norse tree that connects the nine worlds?", "Yggdrasil", "Mimir", "Asgard", "Midgard", "Niflheim", "Helheim"},{"Who is the Roman god of war?", "Mars", "Jupiter", "Neptune", "Mercury", "Apollo", "Vulcan"},{"In Egyptian mythology, who is the goddess of fertility and motherhood?", "Isis", "Hathor", "Bastet", "Nephthys", "Sekhmet", "Nut"},{"What creature is a half-man, half-horse in mythology?", "Centaur", "Minotaur", "Sphinx", "Satyr", "Nymph", "Dryad"},{"Who is the Greek goddess of the harvest?", "Demeter", "Persephone", "Artemis", "Hera", "Athena", "Aphrodite"},{"What is the name of the underworld in Greek mythology?", "Hades", "Elysium", "Tartarus", "Asphodel", "Styx", "Avernus"},{"Who is the Norse god associated with thunder?", "Thor", "Loki", "Odin", "Balder", "Freyr", "Heimdall"},{"In Hindu mythology, who is the monkey god?", "Hanuman", "Ganesha", "Shiva", "Vishnu", "Brahma", "Lakshmi"},{"What is the name of the Greek god of wine?", "Dionysus", "Apollo", "Hermes", "Hades", "Zeus", "Ares"},{"Who is the goddess of the hunt in Greek mythology?", "Artemis", "Athena", "Demeter", "Hera", "Persephone", "Aphrodite"},{"What is the name of the one-eyed giants in Greek mythology?", "Cyclopes", "Titans", "Giants", "Furies", "Nymphs", "Sphinx"},{"Who is the god of the sea in Greek mythology?", "Poseidon", "Hades", "Zeus", "Apollo", "Hermes", "Ares"},{"What creature is known for guarding the gates of the Underworld?", "Cerberus", "Chimera", "Hydra", "Griffin", "Sphinx", "Minotaur"},{"In Egyptian mythology, who is the god of writing and knowledge?", "Thoth", "Osiris", "Anubis", "Ra", "Horus", "Isis"},{"What is the name of the goddess of love and beauty in Greek mythology?", "Aphrodite", "Hera", "Demeter", "Artemis", "Athena", "Persephone"},{"Who is the king of the Titans in Greek mythology?", "Cronus", "Uranus", "Zeus", "Poseidon", "Hades", "Rhea"},{"What is the name of the Greek hero who fought in the Trojan War and was invulnerable except for his heel?", "Achilles", "Hector", "Odysseus", "Agamemnon", "Paris", "Patroclus"},{"In Norse mythology, who is the ruler of the gods?", "Odin", "Thor", "Loki", "Freyr", "Balder", "Heimdall"},{"Who is the goddess of spring and rebirth in Greek mythology?", "Persephone", "Demeter", "Artemis", "Aphrodite", "Athena", "Hera"},{"What mythical creature is known for its fire-breathing abilities?", "Dragon", "Phoenix", "Griffin", "Hydra", "Chimera", "Sphinx"},{"In Hindu mythology, who is the god of creation?", "Brahma", "Vishnu", "Shiva", "Ganesha", "Hanuman", "Lakshmi"},{"What is the name of the hero who sought the Golden Fleece?", "Jason", "Theseus", "Hercules", "Odysseus", "Achilles", "Perseus"},{"Who is the Roman goddess of the hunt?", "Diana", "Venus", "Minerva", "Juno", "Ceres", "Vesta"},{"What is the name of the trickster figure in Native American mythology?", "Coyote", "Raven", "Bear", "Eagle", "Snake", "Fox"},{"Who is the god of the underworld in Roman mythology?", "Pluto", "Mars", "Jupiter", "Neptune", "Mercury", "Apollo"},{"What is the name of the winged creature that brings messages in Greek mythology?", "Hermes", "Apollo", "Ares", "Zeus", "Hades", "Dionysus"},{"In Chinese mythology, who is the goddess of the moon?", "Chang'e", "Xiwangmu", "Nuwa", "Guanyin", "Fuxi", "Zhurong"},{"What is the name of the hero known for his twelve labors?", "Heracles", "Theseus", "Achilles", "Odysseus", "Perseus", "Jason"},{"Who is the god of love in Roman mythology?", "Cupid", "Mars", "Apollo", "Jupiter", "Neptune", "Mercury"},{"In Slavic mythology, who is the goddess of the harvest?", "Mokosh", "Veles", "Perun", "Dazhbog", "Svarog", "Rod"},{"What is the name of the great serpent in Norse mythology?", "Jormungandr", "Fenrir", "Niohoggr", "Fafnir", "Loki", "Tyrfing"},{"Who is the goddess of the night in Greek mythology?", "Nyx", "Hecate", "Eris", "Selene", "Persephone", "Demeter"},{"What is the name of the Egyptian goddess who represents the sky?", "Nut", "Isis", "Hathor", "Sekhmet", "Nephthys", "Ma'at"},{"Who is the hero of the Indian epic, the Ramayana?", "Rama", "Krishna", "Hanuman", "Arjuna", "Brahma", "Shiva"},{"In Aztec mythology, who is the god of the sun?", "Huitzilopochtli", "Quetzalcoatl", "Tezcatlipoca", "Xipe Totec", "Tlaloc", "Mictlantecuhtli"},{"What is the name of the Norse goddess associated with love and beauty?", "Freyja", "Sif", "Frigg", "Skadi", "Idun", "Hel"},{"Who is the Greek god of dreams?", "Hypnos", "Thanatos", "Eros", "Thanatos", "Moros", "Phantasos"},{"What creature is half-woman and half-snake in mythology?", "Sirens", "Mermaids", "Nymphs", "Dryads", "Furies", "Gorgons"},{"Who is the Greek goddess of the harvest?", "Demeter", "Hera", "Artemis", "Athena", "Aphrodite", "Persephone"},{"Who was the Greek god of the underworld?", "Hades", "Poseidon", "Zeus", "Ares", "Hermes", "Apollo"},{"Which Norse god is known as the god of mischief?", "Loki", "Thor", "Odin", "Freyr", "Baldur", "Heimdall"},{"In Egyptian mythology, who is the god of the afterlife?", "Osiris", "Ra", "Anubis", "Horus", "Thoth", "Set"},{"Who is the Greek goddess of wisdom and warfare?", "Athena", "Aphrodite", "Artemis", "Hera", "Demeter", "Persephone"},{"Which mythological creature has the body of a lion and the head of a human?", "Sphinx", "Griffin", "Chimera", "Minotaur", "Hippogriff", "Cerberus"},{"Who was the chief god in Norse mythology?", "Odin", "Thor", "Loki", "Freyr", "Tyr", "Baldur"},{"In Greek mythology, who flew too close to the sun?", "Icarus", "Perseus", "Theseus", "Hercules", "Achilles", "Orpheus"},{"Which Egyptian goddess is associated with magic and motherhood?", "Isis", "Bastet", "Hathor", "Nut", "Nephthys", "Ma'at"},{"Who are the Norse female figures that choose who lives and dies in battle?", "Valkyries", "Norns", "Jotnar", "Disir", "Alfar", "Fylgja"},{"Which Greek hero killed the Minotaur?", "Theseus", "Perseus", "Heracles", "Achilles", "Odysseus", "Jason"},{"What is the name of Thor's hammer?", "Mjolnir", "Gungnir", "Gram", "Hofund", "Tyrfing", "Fafnir"},{"In Greek mythology, who is the god of wine?", "Dionysus", "Apollo", "Hermes", "Ares", "Zeus", "Hephaestus"},{"Who is the Hindu god known as the destroyer?", "Shiva", "Vishnu", "Brahma", "Indra", "Krishna", "Ganesha"},{"What is the name of the river that forms the boundary of Hades?", "Styx", "Lethe", "Acheron", "Phlegethon", "Cocytus", "Nile"},{"Who is the Roman counterpart of the Greek god Hermes?", "Mercury", "Apollo", "Mars", "Neptune", "Vulcan", "Jupiter"},{"In Greek mythology, who was turned into a spider by Athena?", "Arachne", "Medusa", "Siren", "Circe", "Echo", "Cassandra"},{"Which creature guards the gates of the underworld in Greek mythology?", "Cerberus", "Hydra", "Minotaur", "Chimera", "Sphinx", "Gorgon"},{"Who was the hero of the Trojan War and central figure in Homer's Iliad?", "Achilles", "Odysseus", "Hector", "Ajax", "Agamemnon", "Paris"},{"What is the name of the Norse world tree?", "Yggdrasil", "Midgard", "Asgard", "Jotunheim", "Alfheim", "Niflheim"},{"In Egyptian mythology, who weighed the souls of the dead?", "Anubis", "Ra", "Thoth", "Horus", "Osiris", "Hathor"},{"Who is the Greek goddess of the hunt?", "Artemis", "Hera", "Aphrodite", "Demeter", "Athena", "Hestia"},{"Which Hindu goddess is often depicted riding a tiger or lion?", "Durga", "Lakshmi", "Saraswati", "Kali", "Parvati", "Sita"},{"In Roman mythology, who is the king of the gods?", "Jupiter", "Mars", "Neptune", "Vulcan", "Apollo", "Mercury"},{"Which Norse god lost his hand to the wolf Fenrir?", "Tyr", "Thor", "Loki", "Odin", "Freyr", "Baldur"},{"Who was the Greek god of dreams?", "Morpheus", "Hypnos", "Thanatos", "Erebus", "Hermes", "Dionysus"},{"What creature did Hercules kill as one of his twelve labors?", "Nemean Lion", "Minotaur", "Chimera", "Hydra", "Cyclops", "Cerberus"},{"In Egyptian mythology, which god is depicted with the head of a jackal?", "Anubis", "Ra", "Horus", "Osiris", "Thoth", "Set"},{"Which Norse goddess is known as the goddess of love and beauty?", "Freyja", "Frigg", "Hel", "Sif", "Idun", "Skadi"},{"In Greek mythology, who is the god of war?", "Ares", "Apollo", "Hermes", "Zeus", "Hades", "Poseidon"},{"What is the Roman name for the Greek goddess Hera?", "Juno", "Venus", "Minerva", "Diana", "Ceres", "Vesta"},{"In Egyptian mythology, which god is associated with chaos and the desert?", "Set", "Osiris", "Thoth", "Ra", "Anubis", "Horus"},{"Which creature was part lion, part goat, and had a snake as a tail?", "Chimera", "Sphinx", "Cerberus", "Hydra", "Griffin", "Minotaur"},{"In Greek mythology, who was cursed to turn everything he touched into gold?", "King Midas", "King Minos", "King Aegeus", "King Theseus", "King Creon", "King Sisyphus"},{"Who was the mother of the Greek hero Achilles?", "Thetis", "Athena", "Hera", "Aphrodite", "Demeter", "Leto"},{"In Norse mythology, who is the wife of Odin?", "Frigg", "Freyja", "Sif", "Skadi", "Hel", "Idun"},{"Which Greek god was known for stealing fire from the gods and giving it to humans?", "Prometheus", "Hermes", "Apollo", "Zeus", "Hephaestus", "Hercules"},{"In Hindu mythology, who is the elephant-headed god?", "Ganesha", "Hanuman", "Krishna", "Shiva", "Brahma", "Indra"},{"Who was the Greek goddess of the harvest?", "Demeter", "Hera", "Aphrodite", "Artemis", "Athena", "Persephone"},{"In Norse mythology, who is the father of Thor?", "Odin", "Loki", "Tyr", "Frey", "Baldur", "Heimdall"},{"Which hero sailed with the Argonauts to find the Golden Fleece?", "Jason", "Theseus", "Heracles", "Odysseus", "Achilles", "Perseus"},{"What was the name of Achilles' companion killed in the Trojan War?", "Patroclus", "Hector", "Ajax", "Agamemnon", "Paris", "Aeneas"},{"In Egyptian mythology, which god was associated with wisdom and writing?", "Thoth", "Ra", "Horus", "Anubis", "Osiris", "Hathor"},{"In Roman mythology, who was the goddess of the hearth and home?", "Vesta", "Ceres", "Juno", "Venus", "Minerva", "Diana"},{"Who was cursed to repeat only what others said in Greek mythology?", "Echo", "Narcissus", "Arachne", "Circe", "Siren", "Medusa"},{"What is the name of the ship that carried the Norse gods during Ragnarok?", "Naglfar", "Skidbladnir", "Hlidskjalf", "Gungnir", "Fafnir", "Sleipnir"},{"In Greek mythology, who was the god of medicine?", "Asclepius", "Apollo", "Hermes", "Dionysus", "Pan", "Hades"},{"In Hindu mythology, who is the preserver god?", "Vishnu", "Shiva", "Brahma", "Indra", "Krishna", "Ganesha"},{"Who was the goddess of the rainbow in Greek mythology?", "Iris", "Athena", "Aphrodite", "Hera", "Artemis", "Demeter"},{"Which mythological bird is reborn from its own ashes?", "Phoenix", "Roc", "Simurgh", "Griffin", "Thunderbird", "Bennu"},{"In Norse mythology, what is the hall where warriors go after death?", "Valhalla", "Asgard", "Niflheim", "Midgard", "Helheim", "Jotunheim"},{"Who is known as the King of Pop?", "Michael Jackson", "Elvis Presley", "Prince", "Madonna", "Whitney Houston", "David Bowie"},{"Which band was Freddie Mercury the lead vocalist for?", "Queen", "The Beatles", "Led Zeppelin", "The Rolling Stones", "Pink Floyd", "ABBA"},{"What is the highest-selling album of all time?", "Thriller", "Back in Black", "The Dark Side of the Moon", "Their Greatest Hits", "Rumours", "Hotel California"},{"Who composed the Four Seasons?", "Antonio Vivaldi", "Ludwig van Beethoven", "Johann Sebastian Bach", "Wolfgang Amadeus Mozart", "Frederic Chopin", "Claude Debussy"},{"Which artist is known for the hit song 'Like a Rolling Stone'?", "Bob Dylan", "Johnny Cash", "Bruce Springsteen", "Paul Simon", "Elton John", "David Bowie"},{"What genre of music is characterized by its use of the banjo?", "Bluegrass", "Blues", "Jazz", "Rock", "Country", "Folk"},{"Which instrument has black and white keys?", "Piano", "Guitar", "Violin", "Drum", "Flute", "Trumpet"},{"What is the name of the famous music festival held in Woodstock in 1969?", "Woodstock Music Festival", "Coachella", "Glastonbury", "Lollapalooza", "Burning Man", "Montreux Jazz Festival"},{"Who is the composer of the famous 'Clair de Lune'?", "Claude Debussy", "Ludwig van Beethoven", "Frederic Chopin", "Johann Sebastian Bach", "Wolfgang Amadeus Mozart", "Franz Liszt"},{"Which pop singer is known for the song 'Bad Romance'?", "Lady Gaga", "Beyonce", "Taylor Swift", "Katy Perry", "Rihanna", "Ariana Grande"},{"What is the name of the musical scale consisting of seven notes?", "Major scale", "Minor scale", "Chromatic scale", "Pentatonic scale", "Whole tone scale", "Harmonic scale"},{"Who is the lead singer of the rock band U2?", "Bono", "Mick Jagger", "Freddie Mercury", "Robert Plant", "Bruce Springsteen", "Axl Rose"},{"Which famous composer was deaf?", "Ludwig van Beethoven", "Johann Sebastian Bach", "Wolfgang Amadeus Mozart", "Frederic Chopin", "Igor Stravinsky", "Pyotr Ilyich Tchaikovsky"},{"What instrument does Yo-Yo Ma play?", "Cello", "Violin", "Piano", "Double bass", "Flute", "Trumpet"},{"What is the term for a group of musicians performing together?", "Ensemble", "Solo", "Duo", "Trio", "Quartet", "Band"},{"Which artist is known for the song 'Rolling in the Deep'?", "Adele", "Beyonce", "Rihanna", "Taylor Swift", "Katy Perry", "Lady Gaga"},{"In what year did the Beatles break up?", "1970", "1965", "1968", "1975", "1962", "1972"},{"What is the term for a musical composition for a solo instrument accompanied by an orchestra?", "Concerto", "Sonata", "Symphony", "Suite", "Overture", "Intermezzo"},{"Which instrument is known as the 'king of instruments'?", "Organ", "Piano", "Violin", "Trumpet", "Drum", "Guitar"},{"Who is the best-selling female artist of all time?", "Mariah Carey", "Madonna", "Whitney Houston", "Celine Dion", "Taylor Swift", "Beyonce"},{"What genre of music is characterized by heavy use of synthesizers and drum machines?", "Synthpop", "Rock", "Jazz", "Blues", "Country", "Folk"},{"Which singer is known for her hit 'I Will Always Love You'?", "Whitney Houston", "Celine Dion", "Mariah Carey", "Beyonce", "Adele", "Taylor Swift"},{"What is the term for a piece of music written for a small group of instruments?", "Chamber music", "Orchestral", "Solo", "Duet", "Trio", "Quartet"},{"Who is known for the iconic song 'Imagine'?", "John Lennon", "Paul McCartney", "Elton John", "David Bowie", "Bob Dylan", "George Harrison"},{"Which instrument is commonly used in jazz music?", "Saxophone", "Guitar", "Violin", "Piano", "Flute", "Harp"},{"What is the main theme of the song 'Born to Run'?", "Escape and freedom", "Love", "War", "Nature", "Life struggles", "Success"},{"What is the name of the lead guitarist for the Rolling Stones?", "Keith Richards", "Mick Jagger", "Brian Jones", "Ronnie Wood", "Chuck Berry", "Jimmy Page"},{"What genre of music did Elvis Presley popularize?", "Rock and roll", "Jazz", "Blues", "Country", "Pop", "Soul"},{"What is a musical notation that indicates to play loudly?", "Forte", "Piano", "Mezzo-forte", "Crescendo", "Decrescendo", "Staccato"},{"Which famous music video features the dance known as the Moonwalk?", "Thriller", "Like a Prayer", "Bad", "Billie Jean", "Smooth Criminal", "Beat It"},{"Who composed the famous 'Symphony No. 5'?", "Ludwig van Beethoven", "Johann Sebastian Bach", "Wolfgang Amadeus Mozart", "Frederic Chopin", "Igor Stravinsky", "Pyotr Ilyich Tchaikovsky"},{"What is the primary instrument in a string quartet?", "Violin", "Cello", "Viola", "Double bass", "Harp", "Piano"},{"Who is known as the 'Queen of Soul'?", "Aretha Franklin", "Diana Ross", "Whitney Houston", "Mariah Carey", "Beyonce", "Adele"},{"What is the name of the first music video played on MTV?", "Video Killed the Radio Star", "Thriller", "Like a Virgin", "Billie Jean", "Sweet Child o' Mine", "Girls Just Want to Have Fun"},{"What is the term for a repeated section in a song?", "Chorus", "Verse", "Bridge", "Intro", "Outro", "Solo"},{"Who is the lead singer of the band Coldplay?", "Chris Martin", "Jonny Buckland", "Guy Berryman", "Will Champion", "Bono", "James Blunt"},{"What is the primary genre of the band Nirvana?", "Grunge", "Rock", "Metal", "Pop", "Punk", "Alternative"},{"Which musical term means to gradually get softer?", "Decrescendo", "Crescendo", "Piano", "Forte", "Mezzo-piano", "Staccato"},{"What instrument is associated with the term 'saxophone'?","Woodwind", "Brass", "Percussion", "String", "Keyboard", "Electronic"},{"Who is known for the hit song 'Umbrella'?", "Rihanna", "Beyonce", "Adele", "Katy Perry", "Lady Gaga", "Taylor Swift"},{"What is the primary focus of a music producer?", "Creating and managing recordings", "Performing live", "Writing lyrics", "Teaching music", "Playing instruments", "Arranging concerts"},{"What is the name of the famous street in London known for its music scene?", "Abbey Road", "Baker Street", "Carnaby Street", "Portobello Road", "Oxford Street", "Regent Street"},{"What is the name of the musical genre that originated in Jamaica?", "Reggae", "Hip-hop", "Jazz", "Blues", "Country", "Rock"},{"Who is known for the song 'Shape of You'?", "Ed Sheeran", "Justin Bieber", "Bruno Mars", "Sam Smith", "Shawn Mendes", "Zayn Malik"},{"What is the name of the classical music piece often associated with weddings?", "Bridal Chorus", "Pachelbel's Canon", "Clair de Lune", "Ave Maria", "The Wedding March", "Air on the G String"},{"What is the term for a musical performance by one person?", "Solo", "Duet", "Trio", "Ensemble", "Quartet", "Band"},{"Who is the famous rapper known for the album 'The Marshall Mathers LP'?", "Eminem", "Jay-Z", "Drake", "Kanye West", "50 Cent", "Snoop Dogg"},{"What is the term for a song's introductory section?", "Intro", "Verse", "Chorus", "Bridge", "Outro", "Solo"},{"Which instrument is often associated with country music?", "Banjo", "Saxophone", "Piano", "Drum", "Violin", "Flute"},{"Who is known for the hit song 'Thinking Out Loud'?", "Ed Sheeran", "Sam Smith", "Justin Bieber", "Shawn Mendes", "Bruno Mars", "Zayn Malik"},{"Which composer is often called the 'Father of the Symphony'?", "Joseph Haydn", "Wolfgang Amadeus Mozart", "Ludwig van Beethoven", "Johann Sebastian Bach", "Antonio Vivaldi", "Franz Schubert"},{"Who composed the Brandenburg Concertos?", "Johann Sebastian Bach", "George Frideric Handel", "Antonio Vivaldi", "Arcangelo Corelli", "Domenico Scarlatti", "Johann Pachelbel"},{"Which Italian composer wrote 'The Four Seasons'?", "Antonio Vivaldi", "Giovanni Gabrieli", "Domenico Scarlatti", "Claudio Monteverdi", "Niccolo Paganini", "Luigi Boccherini"},{"Who was the first African American woman to be recognized as a symphonic composer?", "Florence Price", "Margaret Bonds", "Ethel Smyth", "Amy Beach", "Germaine Tailleferre", "Nadia Boulanger"},{"Which opera by Mozart features the characters Papageno and the Queen of the Night?", "The Magic Flute", "Don Giovanni", "The Marriage of Figaro", "Cosi fan tutte", "Idomeneo", "La Clemenza di Tito"},{"What was the first electronic instrument used in a public performance?", "Theremin", "Moog synthesizer", "Hammond organ", "Ondes Martenot", "Fairlight CMI", "Mellotron"},{"In jazz, which musician is famously known as the 'Bird'?", "Charlie Parker", "Dizzy Gillespie", "Miles Davis", "Thelonious Monk", "John Coltrane", "Duke Ellington"},{"What instrument did John Coltrane famously play?", "Saxophone", "Trumpet", "Piano", "Clarinet", "Guitar", "Trombone"},{"Who composed the opera 'Tristan und Isolde'?", "Richard Wagner", "Giuseppe Verdi", "Giacomo Puccini", "Georges Bizet", "Wolfgang Amadeus Mozart", "Franz Schubert"},{"Which composer is known for the ballet 'The Firebird'?", "Igor Stravinsky", "Sergei Prokofiev", "Pyotr Ilyich Tchaikovsky", "Nikolai Rimsky-Korsakov", "Bela Bartok", "Maurice Ravel"},{"In Beethoven's Ninth Symphony, what poem by Schiller is set to music?", "Ode to Joy", "The Robbers", "To the Spring", "Song of the Bell", "The Gods of Greece", "The Walk"},{"What instrument is featured in Saint-Saëns' 'The Swan'?", "Cello", "Flute", "Violin", "Piano", "Oboe", "Clarinet"},{"Which female composer was a significant figure in the Romantic era?", "Clara Schumann", "Louise Farrenc", "Fanny Mendelssohn", "Amy Beach", "Elisabeth Jacquet de La Guerre", "Nadia Boulanger"},{"Who composed 'Rhapsody in Blue'?", "George Gershwin", "Leonard Bernstein", "Aaron Copland", "Samuel Barber", "Charles Ives", "Philip Glass"},{"Which jazz saxophonist released the influential album 'A Love Supreme'?", "John Coltrane", "Miles Davis", "Thelonious Monk", "Ornette Coleman", "Charlie Parker", "Sonny Rollins"},{"What is the term for a repeated musical phrase, often in the bass, in Baroque music?", "Ground bass", "Ostinato", "Fugue", "Passacaglia", "Ritornello", "Aria"},{"Who composed 'Carmina Burana'?", "Carl Orff", "Richard Strauss", "Gustav Mahler", "Igor Stravinsky", "Sergei Rachmaninoff", "Paul Hindemith"},{"Which composer is known for his minimalistic style in works like 'Music for 18 Musicians'?", "Steve Reich", "Philip Glass", "Terry Riley", "John Adams", "La Monte Young", "Arvo Pärt"},{"Who was the composer of 'Porgy and Bess'?", "George Gershwin", "Leonard Bernstein", "Aaron Copland", "Duke Ellington", "Richard Rodgers", "Irving Berlin"},{"What era of music is Hildegard von Bingen associated with?", "Medieval", "Baroque", "Classical", "Romantic", "Renaissance", "Modern"},{"Which band is known for the album 'Dark Side of the Moon'?", "Pink Floyd", "The Beatles", "Led Zeppelin", "The Rolling Stones", "The Who", "Queen"},{"Who composed 'Bolero'?", "Maurice Ravel", "Claude Debussy", "Erik Satie", "Camille Saint-Saëns", "Gabriel Faure", "Francis Poulenc"},{"Which opera by Puccini is set in Japan?", "Madama Butterfly", "La Boheme", "Tosca", "Turandot", "Manon Lescaut", "Gianni Schicchi"},{"What is the Italian term for the concluding section of a musical composition?", "Coda", "Finale", "Recapitulation", "Da capo", "Piu mosso", "Andante"},{"Who is considered the first great composer of opera?", "Claudio Monteverdi", "Johann Sebastian Bach", "Wolfgang Amadeus Mozart", "George Frideric Handel", "Jean-Baptiste Lully", "Henry Purcell"},{"What is a traditional ensemble style of Indonesia, using gongs and metallophones?", "Gamelan", "Sitar", "Tabla", "Taiko", "Koto", "Erhu"},{"Which 20th-century composer is known for the ballet 'Appalachian Spring'?", "Aaron Copland", "Samuel Barber", "Leonard Bernstein", "Philip Glass", "George Gershwin", "John Cage"},{"What German composer wrote 'Ein deutsches Requiem'?", "Johannes Brahms", "Ludwig van Beethoven", "Richard Wagner", "Franz Schubert", "Gustav Mahler", "Felix Mendelssohn"},{"Which composer pioneered twelve-tone technique?", "Arnold Schoenberg", "Alban Berg", "Anton Webern", "Igor Stravinsky", "Sergei Prokofiev", "Dmitri Shostakovich"},{"In which city was the jazz genre born?", "New Orleans", "Chicago", "New York", "St. Louis", "Los Angeles", "Memphis"},{"What is the Baroque term for sudden dynamic contrasts?", "Terraced dynamics", "Crescendo", "Diminuendo", "Sforzando", "Pianissimo", "Legato"},{"Which composer wrote 'La Campanella'?", "Franz Liszt", "Ludwig van Beethoven", "Wolfgang Amadeus Mozart", "Johann Sebastian Bach", "Frederic Chopin", "Claude Debussy"},{"Which composer wrote 'Water Music'?", "George Frideric Handel", "Johann Sebastian Bach", "Antonio Vivaldi", "Henry Purcell", "Wolfgang Amadeus Mozart", "Franz Schubert"},{"Who is known for composing the ballets 'Swan Lake' and 'The Nutcracker'?", "Pyotr Ilyich Tchaikovsky", "Igor Stravinsky", "Sergei Prokofiev", "Maurice Ravel", "Jean Sibelius", "Claude Debussy"},{"What genre is Duke Ellington most associated with?", "Jazz", "Blues", "Swing", "Classical", "Ragtime", "Rock"},{"What type of piece is a 'Fugue'?", "Polyphonic", "Homophonic", "Monophonic", "Modal", "Heterophonic", "Atonal"},{"Who composed the opera 'Carmen'?", "Georges Bizet", "Giuseppe Verdi", "Giacomo Puccini", "Richard Wagner", "Johann Strauss II", "Gaetano Donizetti"},{"What composition by Richard Strauss features in '2001: A Space Odyssey'?", "Also sprach Zarathustra", "Der Rosenkavalier", "Don Juan", "Salome", "Till Eulenspiegel", "Ein Heldenleben"},{"What is the lowest female voice type?", "Contralto", "Mezzo-soprano", "Soprano", "Alto", "Coloratura", "Tenor"},{"What composer wrote 'Nixon in China'?", "John Adams", "Philip Glass", "Leonard Bernstein", "Aaron Copland", "Steve Reich", "Samuel Barber"},{"Which artist released the album '25' in 2015?", "Adele", "Taylor Swift", "Beyonce", "Lady Gaga", "Ed Sheeran", "Rihanna"},{"What was the title of Billie Eilish's debut album?", "When We All Fall Asleep, Where Do We Go?", "Happier Than Ever", "Don't Smile at Me", "Bad Guy", "Ocean Eyes", "Everything I Wanted"},{"Which rapper is known for the hit song 'Sicko Mode'?", "Travis Scott", "Kendrick Lamar", "Drake", "Lil Wayne", "J. Cole", "Post Malone"},{"What rock band is known for the 2020 album 'Everyday Life'?", "Coldplay", "Imagine Dragons", "Maroon 5", "Linkin Park", "Paramore", "The Killers"},{"Who won the Grammy Award for Best New Artist in 2020?", "Billie Eilish", "Megan Thee Stallion", "Lizzo", "Shawn Mendes", "Rosalia", "H.E.R."},{"Which artist released the song 'Peaches' featuring Daniel Caesar and Giveon in 2021?", "Justin Bieber", "The Weeknd", "Post Malone", "Charlie Puth", "Drake", "Ed Sheeran"},{"What is the title of Lil Nas X's debut EP, released in 2020?", "7", "Montero", "Old Town Road", "Holiday", "Panini", "C7osure"},{"Which band was fronted by Adam Levine?", "Maroon 5", "Coldplay", "OneRepublic", "Imagine Dragons", "The Killers", "Panic! At The Disco"},{"Who is the female artist behind the 2021 hit song 'Good 4 U'?", "Olivia Rodrigo", "Dua Lipa", "Taylor Swift", "Billie Eilish", "Halsey", "Lorde"},{"Which rapper's real name is Aubrey Drake Graham?", "Drake", "J. Cole", "Kendrick Lamar", "Lil Wayne", "Travis Scott", "50 Cent"},{"Who is known for the theory of relativity?", "Albert Einstein", "Isaac Newton", "Galileo Galilei", "Niels Bohr", "Stephen Hawking", "Richard Feynman"},{"Who was the first president of the United States?", "George Washington", "Thomas Jefferson", "John Adams", "Abraham Lincoln", "James Madison", "Franklin D. Roosevelt"},{"Which female scientist is famous for her work on radioactivity?", "Marie Curie", "Rosalind Franklin", "Jane Goodall", "Ada Lovelace", "Lise Meitner", "Barbara McClintock"},{"Who was the leader of the Soviet Union during World War II?", "Joseph Stalin", "Vladimir Lenin", "Leon Trotsky", "Nikita Khrushchev", "Mikhail Gorbachev", "Boris Yeltsin"},{"Who is known for his philosophy of nonviolent resistance?", "Mahatma Gandhi", "Nelson Mandela", "Martin Luther King Jr.", "Malcolm X", "Henry David Thoreau", "Desmond Tutu"},{"Who painted the Mona Lisa?", "Leonardo da Vinci", "Vincent van Gogh", "Pablo Picasso", "Michelangelo", "Raphael", "Claude Monet"},{"Who is credited with discovering penicillin?", "Alexander Fleming", "Louis Pasteur", "Joseph Lister", "Edward Jenner", "Robert Koch", "Gregory Pincus"},{"Which famous playwright wrote 'Romeo and Juliet'?", "William Shakespeare", "Christopher Marlowe", "George Bernard Shaw", "Tennessee Williams", "Arthur Miller", "Henrik Ibsen"},{"Who was the first woman to fly solo across the Atlantic Ocean?", "Amelia Earhart", "Bessie Coleman", "Harriet Quimby", "Jacqueline Cochran", "Sally Ride", "Valentina Tereshkova"},{"Who is known for the theory of evolution by natural selection?", "Charles Darwin", "Gregor Mendel", "Louis Pasteur", "Jean-Baptiste Lamarck", "Richard Dawkins", "James Watson"},{"Which American civil rights leader delivered the 'I Have a Dream' speech?", "Martin Luther King Jr.", "Malcolm X", "Rosa Parks", "Frederick Douglass", "W.E.B. Du Bois", "John Lewis"},{"Who is known for his work in the field of psychoanalysis?", "Sigmund Freud", "Carl Jung", "B.F. Skinner", "Alfred Adler", "William James", "Abraham Maslow"},{"Who was the famous queen of ancient Egypt?", "Cleopatra", "Nefertiti", "Hatshepsut", "Elizabeth I", "Marie Antoinette", "Catherine the Great"},{"Which ancient philosopher is known for the Socratic method?", "Socrates", "Plato", "Aristotle", "Epicurus", "Pythagoras", "Confucius"},{"Who was the famous leader of the Indian independence movement?", "Mahatma Gandhi", "Jawaharlal Nehru", "Subhas Chandra Bose", "B.R. Ambedkar", "Sardar Patel", "Bhagat Singh"},{"Which scientist is known for the laws of motion and universal gravitation?", "Isaac Newton", "Albert Einstein", "Galileo Galilei", "Nicolaus Copernicus", "Johannes Kepler", "Michael Faraday"},{"Who is famous for the quote 'Give me liberty, or give me death'?", "Patrick Henry", "Thomas Paine", "George Washington", "John Adams", "Samuel Adams", "Benjamin Franklin"},{"Who was the first African American to win a Nobel Prize?", "W.E.B. Du Bois", "Martin Luther King Jr.", "Ralph Bunche", "Barack Obama", "Toni Morrison", "James Baldwin"},{"Which composer is known for the 'Four Seasons'?", "Antonio Vivaldi", "Johann Sebastian Bach", "Ludwig van Beethoven", "Wolfgang Amadeus Mozart", "Frederic Chopin", "Claude Debussy"},{"Who was the first female Prime Minister of the United Kingdom?", "Margaret Thatcher", "Theresa May", "Angela Merkel", "Indira Gandhi", "Golda Meir", "Ellen Johnson Sirleaf"},{"Who discovered the structure of DNA?", "James Watson and Francis Crick", "Rosalind Franklin", "Maurice Wilkins", "Gregg Semenza", "Craig Venter", "Kary Mullis"},{"Who is known for leading the Haitian Revolution?", "Toussaint L'Ouverture", "Jean-Jacques Dessalines", "Henri Christophe", "Dutty Boukman", "Boukman Dutty", "Ariel Henry"},{"Which philosopher wrote 'The Republic'?", "Plato", "Aristotle", "Socrates", "Descartes", "Hobbes", "Locke"},{"Who was the famous inventor of the light bulb?", "Thomas Edison", "Nikola Tesla", "Alexander Graham Bell", "Benjamin Franklin", "Henry Ford", "Guglielmo Marconi"},{"Who was the first person to circumnavigate the globe?", "Ferdinand Magellan", "Christopher Columbus", "James Cook", "Vasco da Gama", "Hernan Cortes", "Marco Polo"},{"Who was the famous civil rights activist who refused to give up her bus seat?", "Rosa Parks", "Harriet Tubman", "Coretta Scott King", "Angela Davis", "Ida B. Wells", "Malcolm X"},{"Which famous inventor is known for the phonograph?", "Thomas Edison", "Graham Bell", "Nikola Tesla", "Henry Ford", "James Watt", "Michael Faraday"},{"Who was the leader of the French Revolution?", "Maximilien Robespierre", "Napoleon Bonaparte", "Louis XVI", "Georges Danton", "Jean-Paul Marat", "Lazare Carnot"},{"Which scientist is known for developing the polio vaccine?", "Jonas Salk", "Albert Sabin", "Edward Jenner", "Louis Pasteur", "Robert Koch", "Paul Ehrlich"},{"Who was the author of 'Pride and Prejudice'?", "Jane Austen", "Charlotte Bronte", "Mary Shelley", "Virginia Woolf", "Emily Dickinson", "Louisa May Alcott"},{"Who was the famous African American abolitionist and writer?", "Frederick Douglass", "Harriet Tubman", "Sojourner Truth", "W.E.B. Du Bois", "Ida B. Wells", "Malcolm X"},{"Who is known for the invention of the  printing press?", "Johannes Gutenberg", "Thomas Edison", "Benjamin Franklin", "Leonardo da Vinci", "Isaac Newton", "Henry Ford"},{"Which female figure is known for her role in the suffragette movement?", "Emmeline Pankhurst", "Susan B. Anthony", "Elizabeth Cady Stanton", "Alice Paul", "Florence Nightingale", "Sojourner Truth"},{"Who is famous for the 'Iliad' and 'Odyssey'?", "Homer", "Virgil", "Sophocles", "Aristotle", "Plato", "Euripides"},{"Who was the founder of psychoanalysis?", "Sigmund Freud", "Carl Jung", "B.F. Skinner", "Alfred Adler", "William James", "Erik Erikson"},{"Which leader is known for his role in the Russian Revolution?", "Vladimir Lenin", "Joseph Stalin", "Leon Trotsky", "Nikita Khrushchev", "Mikhail Gorbachev", "Boris Yeltsin"},{"Who is known for his role in the American independence movement?", "Thomas Jefferson", "George Washington", "John Adams", "Benjamin Franklin", "Samuel Adams", "James Madison"},{"What famous scientist developed the laws of planetary motion?", "Johannes Kepler", "Isaac Newton", "Galileo Galilei", "Nicolaus Copernicus", "Albert Einstein", "Tycho Brahe"},{"Who was the first female Chancellor of Germany?", "Angela Merkel", "Margaret Thatcher", "Golda Meir", "Indira Gandhi", "Ellen Johnson Sirleaf", "Viktor Orban"},{"Which famous artist painted the ceiling of the Sistine Chapel?", "Michelangelo", "Raphael", "Leonardo da Vinci", "Caravaggio", "Botticelli", "Donatello"},{"Who is known for founding the Mongol Empire?", "Genghis Khan", "Kublai Khan", "Attila the Hun", "Hannibal", "Alexander the Great", "Julius Caesar"},{"Which famous female writer wrote 'Wuthering Heights'?", "Emily Bronte", "Charlotte Bronte", "Jane Austen", "Mary Shelley", "Virginia Woolf", "Agatha Christie"},{"Who was the first African American president of the United States?", "Barack Obama", "Bill Clinton", "George W. Bush", "Jimmy Carter", "Lyndon B. Johnson", "Richard Nixon"},{"What famous explorer is known for his voyages to the New World?", "Christopher Columbus", "Ferdinand Magellan", "Hernan Cortes", "Jacques Cartier", "James Cook", "Vasco da Gama"},{"Who was the first emperor of the Roman Empire?", "Augustus", "Julius Caesar", "Nero", "Tiberius", "Caligula", "Trajan"},{"Who was the famous civil rights leader who fought for the abolition of slavery?", "Frederick Douglass", "Harriet Tubman", "Rosa Parks", "Martin Luther King Jr.", "W.E.B. Du Bois", "Ida B. Wells"},{"Which composer is known for the 'Brandenburg Concertos'?", "Johann Sebastian Bach", "Wolfgang Amadeus Mozart", "Ludwig van Beethoven", "Antonio Vivaldi", "Frederic Chopin", "Claude Debussy"},{"Who is known as the father of modern physics?", "Albert Einstein", "Isaac Newton", "Galileo Galilei", "Niels Bohr", "Stephen Hawking", "Richard Feynman"},{"Which scientist is known for formulating the laws of heredity?", "Gregor Mendel", "Charles Darwin", "Louis Pasteur", "James Watson", "Francis Crick", "Robert Hooke"},{"Who is famous for her activism for women's rights and suffrage?", "Susan B. Anthony", "Emmeline Pankhurst", "Harriet Tubman", "Rosa Parks", "Margaret Thatcher", "Clara Zetkin"},{"Which actor famously turned down the role of Neo in 'The Matrix'?", "Will Smith", "Brad Pitt", "Leonardo DiCaprio", "Johnny Depp", "Tom Cruise", "Nicolas Cage"},{"What is Rihanna's real first name?", "Robyn", "Rihanna", "Nia", "Carla", "Rachel", "Dana"},{"Which actor has been nominated for the most Academy Awards?", "Meryl Streep", "Katharine Hepburn", "Jack Nicholson", "Denzel Washington", "Tom Hanks", "Al Pacino"},{"Who was the youngest person to win an Oscar for Best Actress?", "Marlee Matlin", "Jennifer Lawrence", "Emma Stone", "Audrey Hepburn", "Halle Berry", "Natalie Portman"},{"What was Beyonce's first solo album?", "Dangerously in Love", "B'Day", "I Am... Sasha Fierce", "4", "Lemonade", "Beyonce"},{"Which Hollywood actor is known for the line 'Alright, alright, alright'?", "Matthew McConaughey", "Brad Pitt", "Leonardo DiCaprio", "Chris Hemsworth", "Robert Downey Jr.", "Ryan Reynolds"},{"Which celebrity's father is also known as a famous country singer?", "Miley Cyrus", "Taylor Swift", "Katy Perry", "Selena Gomez", "Demi Lovato", "Shakira"},{"What is Lady Gaga's real name?", "Stefani Germanotta", "Gabriella Monetti", "Maria Gaga", "Stefania Agnelli", "Angelina Jolie", "Gloria Montone"},{"Who was the highest-paid actor in Hollywood in 2022?", "Tom Cruise", "Dwayne Johnson", "Leonardo DiCaprio", "Robert Downey Jr.", "Chris Hemsworth", "Ryan Reynolds"},{"Which actress played the lead in 'Breakfast at Tiffany's'?", "Audrey Hepburn", "Grace Kelly", "Ingrid Bergman", "Vivien Leigh", "Sophia Loren", "Marilyn Monroe"},{"Which famous musician was born with the name Reginald Kenneth Dwight?", "Elton John", "Rod Stewart", "David Bowie", "Eric Clapton", "Sting", "Phil Collins"},{"What major city did Justin Bieber grow up in?", "Stratford, Ontario", "Vancouver", "Toronto", "Montreal", "Ottawa", "Calgary"},{"Which supermodel is known as 'The Body'?", "Elle Macpherson", "Cindy Crawford", "Naomi Campbell", "Claudia Schiffer", "Kate Moss", "Gisele Bündchen"},{"Who is the founder of the cosmetics company Fenty Beauty?", "Rihanna", "Kylie Jenner", "Kim Kardashian", "Selena Gomez", "Jessica Alba", "Drew Barrymore"},{"Which singer became famous as the winner of the first season of 'American Idol'?", "Kelly Clarkson", "Carrie Underwood", "Jordin Sparks", "Fantasia Barrino", "Jennifer Hudson", "Chris Daughtry"},{"What is the title of Jennifer Lopez's debut album?", "On the 6", "This Is Me... Then", "J.Lo", "Brave", "Love?", "Rebirth"},{"Who was the first African American to win an Oscar for Best Actor?", "Sidney Poitier", "Denzel Washington", "Morgan Freeman", "Eddie Murphy", "Samuel L. Jackson", "Forest Whitaker"},{"Which actress famously said, 'I want to be alone'?", "Greta Garbo", "Marilyn Monroe", "Bette Davis", "Katharine Hepburn", "Ingrid Bergman", "Sophia Loren"},{"Which celebrity made the controversial 'wardrobe malfunction' headline in 2004?", "Janet Jackson", "Britney Spears", "Christina Aguilera", "Jennifer Lopez", "Madonna", "Beyonce"},{"What is Taylor Swift's lucky number, often featured in her albums?", "13", "7", "22", "5", "9", "21"},{"Which actor was married to Angelina Jolie before Brad Pitt?", "Billy Bob Thornton", "Johnny Depp", "Nicolas Cage", "Tom Cruise", "Robert Downey Jr.", "Edward Norton"},{"What was the title of the first movie Zendaya starred in?", "Spider-Man: Homecoming", "Euphoria", "Shake It Up", "Dune", "The Greatest Showman", "Malcolm & Marie"},{"What movie gave Leonardo DiCaprio his first Oscar win?", "The Revenant", "Titanic", "Inception", "The Aviator", "Django Unchained", "The Wolf of Wall Street"},{"Who is the founder of Goop?", "Gwyneth Paltrow", "Reese Witherspoon", "Jessica Alba", "Demi Moore", "Jennifer Aniston", "Oprah Winfrey"},{"Which actor plays the character Loki in the Marvel Cinematic Universe?", "Tom Hiddleston", "Chris Hemsworth", "Robert Downey Jr.", "Chris Evans", "Mark Ruffalo", "Benedict Cumberbatch"},{"Which actress was known as 'America's Sweetheart' in the 1990s?", "Julia Roberts", "Meg Ryan", "Sandra Bullock", "Reese Witherspoon", "Jennifer Aniston", "Winona Ryder"},{"Who was the first guest on 'The Ellen DeGeneres Show'?", "Jennifer Aniston", "Oprah Winfrey", "Reese Witherspoon", "Julia Roberts", "Adam Sandler", "Drew Barrymore"},{"Which musician's daughter is actress Zoe Kravitz?", "Lenny Kravitz", "Prince", "David Bowie", "Seal", "Phil Collins", "Keith Richards"},{"Who wrote the memoir 'The Woman in Me'?", "Britney Spears", "Shania Twain", "Mariah Carey", "Janet Jackson", "Jessica Simpson", "Christina Aguilera"},{"Which actress starred alongside Bradley Cooper in 'A Star is Born'?", "Lady Gaga", "Jennifer Lawrence", "Emma Stone", "Scarlett Johansson", "Beyonce", "Daisy Ridley"},{"Which actor is known for playing Captain Jack Sparrow?", "Johnny Depp", "Orlando Bloom", "Hugh Jackman", "Russell Crowe", "Colin Farrell", "Tom Cruise"},{"What year did Kim Kardashian first appear on 'Keeping Up with the Kardashians'?", "2007", "2005", "2009", "2006", "2010", "2008"},{"Who is Billie Eilish's brother and frequent collaborator?", "Finneas", "Jack Antonoff", "Joel Little", "Mark Ronson", "Tobias Jesso Jr.", "Greg Kurstin"},{"Which famous actor was a backup dancer for Janet Jackson before becoming famous?", "Jennifer Lopez", "Madonna", "Kylie Minogue", "Beyonce", "Shakira", "Britney Spears"},{"Who is the father of Madonna's daughter Lourdes?", "Carlos Leon", "Sean Penn", "Guy Ritchie", "Dennis Rodman", "Jean-Michel Basquiat", "Tupac Shakur"},{"Which actor voiced the character 'Woody' in 'Toy Story'?", "Tom Hanks", "Tim Allen", "Robin Williams", "Billy Crystal", "Steve Martin", "Eddie Murphy"},{"Who was married to Michael Jackson from 1994 to 1996?", "Lisa Marie Presley", "Madonna", "Whitney Houston", "Diana Ross", "Janet Jackson", "Debbie Rowe"},{"What is the title of Shakira's first English-language album?", "Laundry Service", "Oral Fixation", "She Wolf", "Sale El Sol", "El Dorado", "Shakira"},{"Who was the first woman to reach a billion-dollar net worth from her cosmetics empire?", "Kylie Jenner", "Rihanna", "Kim Kardashian", "Lady Gaga", "Selena Gomez", "Jessica Alba"},{"Which actor starred as James Bond in 'Casino Royale'?", "Daniel Craig", "Pierce Brosnan", "Sean Connery", "Roger Moore", "Timothy Dalton", "George Lazenby"},{"What is Zendaya's last name?", "Coleman", "Smith", "Johnson", "Brown", "Harris", "Miller"},{"Who was the highest-paid actress in 2018, according to Forbes?", "Scarlett Johansson", "Angelina Jolie", "Jennifer Lawrence", "Jennifer Aniston", "Sandra Bullock", "Emma Watson"},{"Which actress famously tripped on her way to accept her Oscar in 2013?", "Jennifer Lawrence", "Emma Stone", "Anne Hathaway", "Sandra Bullock", "Natalie Portman", "Charlize Theron"},{"What is Meghan Markle's title after her marriage?", "Duchess of Sussex", "Duchess of Cambridge", "Duchess of Cornwall", "Princess of Wales", "Queen Consort", "Countess of Wessex"},{"Who is the main actor in the 'Mission Impossible' franchise?", "Tom Cruise", "Matt Damon", "Keanu Reeves", "Robert Downey Jr.", "Chris Hemsworth", "Brad Pitt"},{"What was Whitney Houston's debut hit single?", "Saving All My Love for You", "I Wanna Dance with Somebody", "How Will I Know", "Greatest Love of All", "I'm Your Baby Tonight", "All at Once"},{"Who is known as the 'Material Girl'?", "Madonna", "Cher", "Whitney Houston", "Janet Jackson", "Mariah Carey", "Tina Turner"},{"What was the title of Tom Hiddleston's popular miniseries with Hugh Laurie?", "The Night Manager", "Broadchurch", "Loki", "The Fall", "Sharp Objects", "The Honourable Woman"},{"Who is known as the 'King of Pop'?", "Michael Jackson", "Elvis Presley", "Prince", "David Bowie", "Justin Timberlake", "Stevie Wonder"},{"Which actress was known for her role as Hermione Granger?", "Emma Watson", "Kristen Stewart", "Natalie Portman", "Jennifer Lawrence", "Anna Kendrick", "Chloë Grace Moretz"},{"What is the chemical symbol for water?", "H2O", "O2", "CO2", "NaCl", "H2O2", "C6H12O6"},{"Who is known as the father of modern physics?", "Albert Einstein", "Isaac Newton", "Galileo Galilei", "Niels Bohr", "Richard Feynman", "Stephen Hawking"},{"What gas do plants absorb from the atmosphere?", "Carbon dioxide", "Oxygen", "Nitrogen", "Hydrogen", "Methane", "Argon"},{"What is the process by which plants make their food?", "Photosynthesis", "Respiration", "Transpiration", "Fermentation", "Digestion", "Evaporation"},{"What is the powerhouse of the cell?", "Mitochondria", "Nucleus", "Ribosome", "Endoplasmic reticulum", "Golgi apparatus", "Lysosome"},{"What is the basic unit of life?", "Cell", "Tissue", "Organ", "Organism", "System", "Species"},{"What is the speed of light?", "299,792 km/s", "150,000 km/s", "300,000 km/s", "400,000 km/s", "250,000 km/s", "350,000 km/s"},{"Who formulated the laws of motion?", "Isaac Newton", "Albert Einstein", "Galileo Galilei", "Niels Bohr", "Max Planck", "Johannes Kepler"},{"What is the chemical formula for table salt?", "NaCl", "KCl", "MgO", "CaCO3", "NH3", "HCl"},{"Which planet is known as the Red Planet?", "Mars", "Venus", "Jupiter", "Saturn", "Mercury", "Neptune"},{"What is the main gas found in the Earth's atmosphere?", "Nitrogen", "Oxygen", "Carbon dioxide", "Argon", "Hydrogen", "Helium"},{"What is the hardest natural substance on Earth?", "Diamond", "Ruby", "Sapphire", "Emerald", "Quartz", "Topaz"},{"Who is known for the theory of evolution?", "Charles Darwin", "Gregory Mendel", "Isaac Newton", "Albert Einstein", "Louis Pasteur", "James Watson"},{"What is the most abundant element in the universe?", "Hydrogen", "Oxygen", "Carbon", "Helium", "Nitrogen", "Iron"},{"What type of bond involves the sharing of electron pairs?", "Covalent bond", "Ionic bond", "Metallic bond", "Hydrogen bond", "Polar bond", "Van der Waals bond"},{"What is the unit of measurement for electric current?", "Ampere", "Volt", "Ohm", "Watt", "Joule", "Coulomb"},{"What do you call an animal that can live both in water and on land?", "Amphibian", "Reptile", "Mammal", "Fish", "Bird", "Insect"},{"What is the main function of red blood cells?", "Transport oxygen", "Fight infections", "Clot blood", "Digest food", "Regulate temperature", "Maintain pH"},{"What is the study of fungi called?", "Mycology", "Botany", "Zoology", "Entomology", "Microbiology", "Pathology"},{"What is the primary organ of the circulatory system?", "Heart", "Lungs", "Liver", "Kidneys", "Brain", "Spleen"},{"What is the largest organ in the human body?", "Skin", "Liver", "Heart", "Lungs", "Brain", "Kidneys"},{"What is the chemical symbol for gold?", "Au", "Ag", "Fe", "Pb", "Hg", "Cu"},{"What is the process by which a solid turns into a gas?", "Sublimation", "Evaporation", "Condensation", "Deposition", "Fusion", "Crystallization"},{"What is the main purpose of DNA?", "Store genetic information", "Produce energy", "Support cell structure", "Transport materials", "Fight diseases", "Regulate metabolism"},{"Who is credited with the discovery of penicillin?", "Alexander Fleming", "Louis Pasteur", "Edward Jenner", "Joseph Lister", "Robert Koch", "Paul Ehrlich"},{"What is the smallest unit of matter?", "Atom", "Molecule", "Cell", "Compound", "Ion", "Element"},{"Which planet has the most moons?", "Jupiter", "Saturn", "Mars", "Earth", "Neptune", "Uranus"},{"What is the main component of natural gas?", "Methane", "Propane", "Butane", "Ethane", "Hydrogen", "Carbon dioxide"},{"What is the pH level of pure water?", "7", "6", "5", "8", "9", "10"},{"What is the term for a group of similar cells that perform a specific function?", "Tissue", "Organ", "Organ system", "Cell", "Organism", "Species"},{"Who is known for the periodic table of elements?", "Dmitri Mendeleev", "Albert Einstein", "John Dalton", "Niels Bohr", "Lavoisier", "Avogadro"},{"What is the most common type of rock on Earth's surface?", "Igneous", "Metamorphic", "Sedimentary", "Volcanic", "Granite", "Limestone"},{"What is the term for the measure of how much matter is in an object?", "Mass", "Weight", "Volume", "Density", "Gravity", "Pressure"},{"What is the primary function of the immune system?", "Fight infections", "Digest food", "Circulate blood", "Transport oxygen", "Produce energy", "Regulate temperature"},{"Which gas is produced during photosynthesis?", "Oxygen", "Carbon dioxide", "Nitrogen", "Hydrogen", "Methane", "Sulfur dioxide"},{"What type of energy is stored in food?", "Chemical energy", "Kinetic energy", "Potential energy", "Thermal energy", "Nuclear energy", "Electromagnetic energy"},{"What is the main component of the Earth's crust?", "Silicon", "Oxygen", "Iron", "Calcium", "Magnesium", "Aluminum"},{"What is the study of living organisms called?", "Biology", "Chemistry", "Physics", "Geology", "Astronomy", "Ecology"},{"Who discovered the circulation of blood in the body?", "William Harvey", "Hippocrates", "Louis Pasteur", "Edward Jenner", "Gregor Mendel", "Joseph Lister"},{"What type of reaction releases energy?", "Exothermic reaction", "Endothermic reaction", "Catalytic reaction", "Combustion reaction", "Redox reaction", "Synthesis reaction"},{"What is the term for the change of an element into another through nuclear decay?", "Transmutation", "Fission", "Fusion", "Radioactivity", "Isotope", "Chemical reaction"},{"What is the term for the amount of space an object occupies?", "Volume", "Mass", "Density", "Weight", "Area", "Dimension"},{"Who developed the concept of natural selection?", "Charles Darwin", "Gregor Mendel", "Louis Pasteur", "Albert Einstein", "Isaac Newton", "Richard Dawkins"},{"What is the unit of force?", "Newton", "Joule", "Watt", "Pascal", "Volt", "Ampere"},{"What is the most common gas in the Earth's atmosphere?", "Nitrogen", "Oxygen", "Carbon dioxide", "Argon", "Helium", "Hydrogen"},{"What type of biological macromolecule are enzymes?", "Proteins", "Carbohydrates", "Lipids", "Nucleic acids", "Vitamins", "Minerals"},{"What is the process by which cells divide called?", "Mitosis", "Meiosis", "Binary fission", "Cytokinesis", "Fertilization", "Transcription"},{"What is the main component of Earth's core?", "Iron", "Nickel", "Copper", "Aluminum", "Lead", "Zinc"},{"Who is known for his work on the laws of heredity?", "Gregor Mendel", "Charles Darwin", "Francis Crick", "James Watson", "Louis Pasteur", "Richard Dawkins"},{"What is the boiling point of water in Celsius?", "100C", "0C", "50C", "25C", "75C", "150C"},{"What is the most abundant gas in Earth's atmosphere?", "Nitrogen", "Oxygen", "Carbon Dioxide", "Argon", "Helium", "Methane"},{"What is the chemical symbol for Potassium?", "K", "P", "Po", "Pt", "Pa", "Ps"},{"Who is known as the father of modern chemistry?", "Antoine Lavoisier", "Dmitri Mendeleev", "John Dalton", "Robert Boyle", "Joseph Priestley", "Marie Curie"},{"What is the molecular formula of glucose?", "C6H12O6", "C5H10O5", "C6H10O5", "C4H8O4", "C7H14O7", "C3H6O3"},{"Which element is most commonly used in nuclear reactors as fuel?", "Uranium", "Plutonium", "Thorium", "Radium", "Neptunium", "Polonium"},{"Which element has the highest electronegativity?", "Fluorine", "Oxygen", "Chlorine", "Nitrogen", "Sulfur", "Phosphorus"},{"What type of bond forms when electrons are shared between atoms?", "Covalent bond", "Ionic bond", "Metallic bond", "Hydrogen bond", "Van der Waals force", "Peptide bond"},{"What is the main component of natural gas?", "Methane", "Propane", "Butane", "Ethane", "Pentane", "Hexane"},{"Which acid is found in vinegar?", "Acetic acid", "Citric acid", "Hydrochloric acid", "Sulfuric acid", "Formic acid", "Lactic acid"},{"Which of these elements is a noble gas?", "Neon", "Oxygen", "Hydrogen", "Nitrogen", "Chlorine", "Argon"},{"Which of these is NOT an alkali metal?", "Calcium", "Sodium", "Lithium", "Potassium", "Rubidium", "Cesium"},{"What is the main element in diamond?", "Carbon", "Oxygen", "Silicon", "Sulfur", "Nitrogen", "Boron"},{"Which gas is produced when hydrochloric acid reacts with sodium bicarbonate?", "Carbon dioxide", "Oxygen", "Hydrogen", "Nitrogen", "Ammonia", "Sulfur dioxide"},{"What is the color of copper sulfate solution?", "Blue", "Green", "Yellow", "Red", "Orange", "Clear"},{"Which element is known for its use in thermometers?", "Mercury", "Gallium", "Lead", "Tin", "Copper", "Gold"},{"What is the pH of pure water at 25C?", "7", "0", "14", "5", "9", "11"},{"Who created the first periodic table?", "Dmitri Mendeleev", "Henry Moseley", "Antoine Lavoisier", "Marie Curie", "Niels Bohr", "Ernest Rutherford"},{"What is the chemical formula of table salt?", "NaCl", "KCl", "NaBr", "CaCl2", "MgCl2", "LiCl"},{"What is the primary component of limestone?", "Calcium carbonate", "Calcium sulfate", "Magnesium oxide", "Silicon dioxide", "Aluminum oxide", "Sodium chloride"},{"What is the only metal that is liquid at room temperature?", "Mercury", "Gallium", "Bromine", "Lead", "Aluminum", "Bismuth"},{"What is the term for a substance that speeds up a chemical reaction?", "Catalyst", "Enzyme", "Inhibitor", "Acid", "Base", "Electrolyte"},{"Which organic molecule is often referred to as the 'universal solvent'?", "Water", "Ethanol", "Methanol", "Benzene", "Acetone", "Ether"},{"What is Avogadro's number?", "6.022 x 10^23", "6.022 x 10^24", "3.141 x 10^22", "9.81 x 10^23", "1.66 x 10^24", "2.718 x 10^23"},{"Which compound is known as laughing gas?", "Nitrous oxide", "Carbon monoxide", "Carbon dioxide", "Sulfur dioxide", "Hydrogen sulfide", "Ammonia"},{"What is the oxidation state of iron in Fe2O3?", "+3", "+2", "+1", "0", "-1", "-2"},{"Which gas makes up around 78% of the Earth's atmosphere?", "Nitrogen", "Oxygen", "Carbon dioxide", "Argon", "Helium", "Methane"},{"What is the main component of chalk?", "Calcium carbonate", "Calcium sulfate", "Silicon dioxide", "Magnesium carbonate", "Aluminum oxide", "Potassium nitrate"},{"What kind of hybridization does carbon exhibit in methane (CH4)?", "sp3", "sp2", "sp", "dsp3", "sp3d2", "d2sp3"},{"What is the chemical name of Vitamin C?", "Ascorbic acid", "Citric acid", "Folic acid", "Acetic acid", "Lactic acid", "Pantothenic acid"},{"What type of radiation is the most penetrating?", "Gamma radiation", "Alpha radiation", "Beta radiation", "Neutron radiation", "X-ray radiation", "Ultraviolet radiation"},{"What is the chemical symbol for tungsten?", "W", "Tg", "Tm", "Tu", "Ta", "Tn"},{"What type of bond holds the two strands of DNA together?", "Hydrogen bonds", "Ionic bonds", "Covalent bonds", "Metallic bonds", "Van der Waals forces", "Peptide bonds"},{"What color does phenolphthalein turn in a basic solution?", "Pink", "Blue", "Yellow", "Green", "Red", "Clear"},{"What is the main element in the alloy bronze?", "Copper", "Iron", "Nickel", "Aluminum", "Zinc", "Magnesium"},{"Which element was first discovered using a spectroscope?", "Helium", "Oxygen", "Nitrogen", "Argon", "Neon", "Krypton"},{"Who discovered radioactivity?", "Henri Becquerel", "Marie Curie", "Ernest Rutherford", "Isaac Newton", "Albert Einstein", "Louis Pasteur"},{"What is the IUPAC name for acetone?", "Propan-2-one", "Ethanol", "Methanol", "Propanol", "Acetic acid", "Butanone"},{"Which compound is used as an anesthetic and has the formula CHCl3?", "Chloroform", "Methanol", "Ether", "Acetone", "Benzene", "Toluene"},{"Which of these compounds contains a triple bond?", "Acetylene", "Ethane", "Methanol", "Propane", "Formaldehyde", "Acetic acid"},{"Which element is used as a semiconductor in computer chips?", "Silicon", "Copper", "Carbon", "Iron", "Aluminum", "Zinc"},{"Which ion gives blood its red color?", "Iron (Fe2+)", "Copper (Cu2+)", "Calcium (Ca2+)", "Magnesium (Mg2+)", "Potassium (K+)", "Zinc (Zn2+)"},{"Which chemical is added to drinking water to prevent tooth decay?", "Fluoride", "Chlorine", "Sodium", "Calcium", "Iodine", "Magnesium"},{"What is the molecular geometry of CO2?", "Linear", "Bent", "Trigonal planar", "Tetrahedral", "Octahedral", "Square planar"},{"Who developed the first model of the atom as a solid sphere?", "John Dalton", "Ernest Rutherford", "Niels Bohr", "J.J. Thomson", "Democritus", "Marie Curie"},{"What is the atomic number of oxygen?", "8", "10", "12", "6", "16", "18"},{"Which element has the highest melting point?", "Tungsten", "Iron", "Carbon", "Titanium", "Gold", "Silver"},{"What is the main ingredient in baking soda?", "Sodium bicarbonate", "Sodium carbonate", "Calcium carbonate", "Sodium hydroxide", "Potassium nitrate", "Ammonium chloride"},{"Which of these compounds is an alcohol?", "Ethanol", "Methane", "Ethene", "Formaldehyde", "Acetone", "Benzene"},{"What color does litmus paper turn in acidic solutions?", "Red", "Blue", "Yellow", "Green", "Purple", "Clear"},{"Which element is the lightest metal?", "Lithium", "Beryllium", "Sodium", "Magnesium", "Aluminum", "Calcium"},{"Who wrote 'Pride and Prejudice'?", "Jane Austen", "Charlotte Bronte", "Emily Bronte", "Mary Shelley", "Virginia Woolf", "Louisa May Alcott"},{"What is the title of the first Harry Potter book?", "Harry Potter and the Philosopher's Stone", "Harry Potter and the Chamber of Secrets", "Harry Potter and the Prisoner of Azkaban", "Harry Potter and the Goblet of Fire", "Harry Potter and the Order of the Phoenix", "Harry Potter and the Deathly Hallows"},{"Who wrote 'Moby Dick'?", "Herman Melville", "Mark Twain", "Ernest Hemingway", "F. Scott Fitzgerald", "John Steinbeck", "Jules Verne"},{"What is the main theme of George Orwell's '1984'?", "Totalitarianism", "Romance", "Adventure", "Friendship", "Science fiction", "Coming of age"},{"Who is the author of 'The Great Gatsby'?", "F. Scott Fitzgerald", "Ernest Hemingway", "William Faulkner", "John Steinbeck", "Tennessee Williams", "Ray Bradbury"},{"Which play was written by William Shakespeare?", "Hamlet", "Death of a Salesman", "A Streetcar Named Desire", "The Crucible", "Waiting for Godot", "The Glass Menagerie"},{"Who is the main character in 'The Catcher in the Rye'?", "Holden Caulfield", "Jay Gatsby", "Huckleberry Finn", "Tom Sawyer", "Atticus Finch", "Frodo Baggins"},{"What is the genre of 'The Lord of the Rings'?", "Fantasy", "Science Fiction", "Mystery", "Historical Fiction", "Romance", "Adventure"},{"Who wrote 'The Picture of Dorian Gray'?", "Oscar Wilde", "Charles Dickens", "Leo Tolstoy", "Fyodor Dostoevsky", "George Orwell", "Virginia Woolf"},{"What is the setting of 'To Kill a Mockingbird'?", "Maycomb, Alabama", "New York City", "London", "Paris", "Harper Lee's hometown", "Chicago"},{"Who wrote 'Brave New World'?", "Aldous Huxley", "George Orwell", "Ray Bradbury", "Philip K. Dick", "Isaac Asimov", "Kurt Vonnegut"},{"Which author created the character Sherlock Holmes?", "Arthur Conan Doyle", "Agatha Christie", "Edgar Allan Poe", "Raymond Chandler", "Dashiell Hammett", "Ian Fleming"},{"What is the central conflict in 'Romeo and Juliet'?", "Family feud", "Class struggle", "War", "Political power", "Social inequality", "Religious conflict"},{"Who wrote the epic poem 'Paradise Lost'?", "John Milton", "William Blake", "John Keats", "Robert Frost", "T.S. Eliot", "Samuel Taylor Coleridge"},{"What is the title of the novel about a boy's journey to find his father in 'The Alchemist'?", "The Alchemist", "The Little Prince", "Siddhartha", "The Prophet", "The Old Man and the Sea", "The Catcher in the Rye"},{"Who is the author of 'The Chronicles of Narnia' series?", "C.S. Lewis", "J.R.R. Tolkien", "Philip Pullman", "J.K. Rowling", "Madeleine L'Engle", "Lloyd Alexander"},{"What is the name of the fictional land in 'The Lion, the Witch and the Wardrobe'?", "Narnia", "Hogwarts", "Middle-earth", "Oz", "Neverland", "Wonderland"},{"Who wrote 'Wuthering Heights'?", "Emily Bronte", "Charlotte Bronte", "Jane Austen", "Mary Shelley", "Virginia Woolf", "Agatha Christie"},{"Which novel begins with the line 'Call me Ishmael'?", "Moby Dick", "The Great Gatsby", "1984", "To Kill a Mockingbird", "The Catcher in the Rye", "Pride and Prejudice"},{"Who is the protagonist of 'The Adventures of Huckleberry Finn'?", "Huckleberry Finn", "Tom Sawyer", "Jim", "Becky Thatcher", "Injun Joe", "Aunt Polly"},{"What is the central theme of 'Fahrenheit 451'?", "Censorship", "War", "Love", "Family", "Friendship", "Identity"},{"Who wrote 'The Metamorphosis'?", "Franz Kafka", "James Joyce", "Virginia Woolf", "Gabriel Garcia Marquez", "Haruki Murakami", "Toni Morrison"},{"What is the title of the novel that features a character named Heathcliff?", "Wuthering Heights", "Jane Eyre", "Pride and Prejudice", "Great Expectations", "The Tenant of Wildfell Hall", "Middlemarch"},{"Who wrote the poem 'The Road Not Taken'?", "Robert Frost", "Walt Whitman", "Emily Dickinson", "Langston Hughes", "T.S. Eliot", "John Keats"},{"What is the main focus of 'Animal Farm'?", "Political allegory", "Romance", "Adventure", "Science Fiction", "Mystery", "Coming of age"},{"Who wrote 'The Bell Jar'?", "Sylvia Plath", "Virginia Woolf", "Margaret Atwood", "Toni Morrison", "Zadie Smith", "Flannery O'Connor"},{"What is the main character's name in 'The Hobbit'?", "Bilbo Baggins", "Frodo Baggins", "Gandalf", "Aragorn", "Legolas", "Gimli"},{"Who wrote 'The Fault in Our Stars'?", "John Green", "Rainbow Rowell", "Stephen Chbosky", "Suzanne Collins", "J.K. Rowling", "David Levithan"},{"What is the setting of 'The Road' by Cormac McCarthy?", "Post-apocalyptic", "Medieval", "Victorian", "Futuristic", "Fantasy", "Dystopian"},{"Who wrote 'The Handmaid's Tale'?", "Margaret Atwood", "George Orwell", "Aldous Huxley", "Toni Morrison", "J.K. Rowling", "Suzanne Collins"},{"What is the name of the famous detective in Agatha Christie's novels?", "Hercule Poirot", "Miss Marple", "Sam Spade", "Philip Marlowe", "Sherlock Holmes", "Nero Wolfe"},{"What novel features the character Jay Gatsby?", "The Great Gatsby", "To Kill a Mockingbird", "1984", "Brave New World", "The Catcher in the Rye", "The Picture of Dorian Gray"},{"Who wrote 'Little Women'?", "Louisa May Alcott", "Jane Austen", "Charlotte Bronte", "Virginia Woolf", "Harper Lee", "Mary Shelley"},{"What is the central theme of 'Beloved' by Toni Morrison?", "Slavery and its legacy", "Romance", "War", "Friendship", "Identity", "Family"},{"Who is the author of 'Gone with the Wind'?", "Margaret Mitchell", "Harper Lee", "Emily Bronte", "F. Scott Fitzgerald", "Zora Neale Hurston", "Toni Morrison"},{"What is the title of the first book in the 'A Song of Ice and Fire' series?", "A Game of Thrones", "A Clash of Kings", "A Storm of Swords", "A Feast for Crows", "A Dance with Dragons", "The Winds of Winter"},{"Who wrote the fantasy series 'His Dark Materials'?", "Philip Pullman", "J.K. Rowling", "C.S. Lewis", "Terry Pratchett", "Neil Gaiman", "Brandon Sanderson"},{"What is the title of the famous poem by Emily Dickinson that begins with 'Because I could not stop for Death'?", "Because I could not stop for Death", "Hope is the thing with feathers", "I dwell in Possibility", "A bird came down the walk", "Success is counted sweetest", "The soul selects her own society"},{"Who is the protagonist in '1984'?", "Winston Smith", "John Smith", "O'Brien", "Julia", "Big Brother", "Emmanuel Goldstein"},{"Who wrote 'The Old Man and the Sea'?", "Ernest Hemingway", "F. Scott Fitzgerald", "John Steinbeck", "Mark Twain", "Jack London", "Ray Bradbury"},{"What is the title of the epic poem attributed to Homer?", "The Iliad", "The Odyssey", "The Aeneid", "Beowulf", "Paradise Lost", "The Divine Comedy"},{"Who wrote 'Catch-22'?", "Joseph Heller", "Kurt Vonnegut", "Ray Bradbury", "Thomas Pynchon", "Norman Mailer", "John Updike"},{"What is the main character's name in 'The Picture of Dorian Gray'?", "Dorian Gray", "Lord Henry Wotton", "Basil Hallward", "Sibyl Vane", "James Vane", "Alfred Lord Tennyson"},{"What genre is 'The Hitchhiker's Guide to the Galaxy'?", "Science Fiction", "Fantasy", "Mystery", "Romance", "Horror", "Thriller"},{"Who wrote 'The Kite Runner'?", "Khaled Hosseini", "Mohsin Hamid", "Salman Rushdie", "Chimamanda Ngozi Adichie", "Arundhati Roy", "Jhumpa Lahiri"},{"What is the title of the novel that features the character Elizabeth Bennet?", "Pride and Prejudice", "Emma", "Sense and Sensibility", "Northanger Abbey", "Mansfield Park", "Jane Eyre"},{"Who wrote 'The Road Less Traveled'?", "M. Scott Peck", "Wayne Dyer", "Deepak Chopra", "Brene Brown", "Stephen Covey", "Tony Robbins"},{"What novel features the character Winston Smith?", "1984", "Brave New World", "Fahrenheit 451", "The Handmaid's Tale", "The Giver", "Animal Farm"},{"Who is the author of 'The Color Purple'?", "Alice Walker", "Toni Morrison", "Zora Neale Hurston", "Maya Angelou", "Sylvia Plath", "Virginia Woolf"},{"What is the title of the play written by Arthur Miller about the American Dream?", "Death of a Salesman", "The Crucible", "All My Sons", "A View from the Bridge", "The Misfits", "The Price"},{"Who wrote 'One Hundred Years of Solitude'?", "Gabriel Garcia Marquez", "Jorge Luis Borges", "Mario Vargas Llosa", "Isabel Allende", "Carlos Fuentes", "Pablo Neruda"},{"In which century was Geoffrey Chaucer's 'The Canterbury Tales' written?", "14th century", "15th century", "13th century", "16th century", "12th century", "17th century"},{"Which author is known for creating the character Sherlock Holmes?", "Arthur Conan Doyle", "Agatha Christie", "Wilkie Collins", "Dorothy L. Sayers", "Dashiell Hammett", "P.D. James"},{"Who wrote 'Crime and Punishment'?", "Fyodor Dostoevsky", "Leo Tolstoy", "Anton Chekhov", "Nikolai Gogol", "Ivan Turgenev", "Maxim Gorky"},{"What is the title of Mary Shelley's famous Gothic novel?", "Frankenstein", "Dracula", "The Monk", "The Strange Case of Dr. Jekyll and Mr. Hyde", "The Picture of Dorian Gray", "The Castle of Otranto"},{"Which of the following works was written by Virginia Woolf?", "Mrs. Dalloway", "Pride and Prejudice", "Wuthering Heights", "Jane Eyre", "Middlemarch", "Tess of the d'Urbervilles"},{"In what year was 'To Kill a Mockingbird' by Harper Lee published?", "1960", "1945", "1955", "1975", "1980", "1965"},{"What is the pen name of Samuel Clemens?", "Mark Twain", "O. Henry", "Lewis Carroll", "Saki", "Washington Irving", "Ambrose Bierce"},{"Which French author wrote 'Les Miserables'?", "Victor Hugo", "Gustave Flaubert", "emile Zola", "Alexandre Dumas", "Honore de Balzac", "Stendhal"},{"Which poet wrote the line 'Do not go gentle into that good night'?", "Dylan Thomas", "W.H. Auden", "T.S. Eliot", "Robert Frost", "Ezra Pound", "Wallace Stevens"},{"What novel features the characters Tom Buchanan and Daisy Buchanan?", "The Great Gatsby", "Pride and Prejudice", "Jane Eyre", "Anna Karenina", "Madame Bovary", "The Catcher in the Rye"},{"Who wrote the play 'A Raisin in the Sun'?", "Lorraine Hansberry", "Tennessee Williams", "August Wilson", "Arthur Miller", "Langston Hughes", "James Baldwin"},{"Which Shakespeare play features the characters Iago and Desdemona?", "Othello", "Hamlet", "Macbeth", "King Lear", "The Tempest", "A Midsummer Night's Dream"},{"What is the name of the dystopian society in George Orwell's '1984'?", "Oceania", "Eurasia", "Airstrip One", "Panem", "Gilead", "The Inner Party"},{"Which American poet is known for her reclusive life and unique style, with many of her poems published posthumously?", "Emily Dickinson", "Sylvia Plath", "Anne Sexton", "Edna St. Vincent Millay", "Elizabeth Bishop", "Louisa May Alcott"},{"Which author wrote the novel 'Beloved'?", "Toni Morrison", "Alice Walker", "Zora Neale Hurston", "Maya Angelou", "Gloria Naylor", "Ntozake Shange"},{"What is the title of George Eliot's most famous novel?", "Middlemarch", "Silas Marner", "Adam Bede", "Daniel Deronda", "The Mill on the Floss", "Romola"},{"Which Greek epic is attributed to Homer?", "The Iliad", "The Aeneid", "The Argonautica", "The Odyssey", "The Metamorphoses", "The Georgics"},{"Who wrote 'The Road'?", "Cormac McCarthy", "Philip Roth", "Don DeLillo", "Raymond Carver", "John Updike", "Thomas Pynchon"},{"In 'Moby-Dick', what is the name of Captain Ahab's ship?", "Pequod", "Hispaniola", "Nautilus", "Beagle", "Endurance", "Mary Celeste"},{"Which of the Brontë sisters wrote 'Wuthering Heights'?", "Emily Brontë", "Charlotte Brontë", "Anne Brontë", "Elizabeth Brontë", "Maria Brontë", "Jane Brontë"},{"What is the name of the main character in 'The Catcher in the Rye'?", "Holden Caulfield", "Jay Gatsby", "Tom Sawyer", "Huck Finn", "Nick Carraway", "Atticus Finch"},{"Who wrote 'The Grapes of Wrath'?", "John Steinbeck", "Ernest Hemingway", "F. Scott Fitzgerald", "William Faulkner", "James Baldwin", "Jack London"},{"In the Harry Potter series, who wrote 'Fantastic Beasts and Where to Find Them'?", "Newt Scamander", "Albus Dumbledore", "Gilderoy Lockhart", "Hermione Granger", "Sirius Black", "Remus Lupin"},{"Which poet wrote 'The Waste Land'?", "T.S. Eliot", "Ezra Pound", "W.B. Yeats", "Robert Frost", "Wallace Stevens", "D.H. Lawrence"},{"Who wrote the Gothic novel 'The Picture of Dorian Gray'?", "Oscar Wilde", "Bram Stoker", "Mary Shelley", "Robert Louis Stevenson", "Charlotte Perkins Gilman", "Ann Radcliffe"},{"What is the real name of the author Lemony Snicket?", "Daniel Handler", "Neil Gaiman", "Philip Pullman", "J.K. Rowling", "R.L. Stine", "Rick Riordan"},{"In 'Pride and Prejudice', what is Mr. Darcy's first name?", "Fitzwilliam", "Edward", "George", "Henry", "Edmund", "Charles"},{"Who wrote the novel 'Things Fall Apart'?", "Chinua Achebe", "Ngũgĩ wa Thiong'o", "Wole Soyinka", "Ben Okri", "Nadine Gordimer", "Buchi Emecheta"},{"Which character in 'The Odyssey' is known for her loyalty to Odysseus?", "Penelope", "Circe", "Calypso", "Nausicaa", "Athena", "Helen"},{"Who wrote the dystopian novel 'Brave New World'?", "Aldous Huxley", "George Orwell", "Ray Bradbury", "H.G. Wells", "Kurt Vonnegut", "Anthony Burgess"},{"Which play by Arthur Miller examines the Salem witch trials?", "The Crucible", "Death of a Salesman", "A View from the Bridge", "All My Sons", "After the Fall", "An Enemy of the People"},{"What is the title of the sequel to 'Alice's Adventures in Wonderland'?", "Through the Looking-Glass", "The Hunting of the Snark", "Sylvie and Bruno", "The Jabberwocky", "The White Knight", "The Red Queen"},{"Which novel by Herman Hesse explores Eastern spirituality?", "Siddhartha", "Demian", "Steppenwolf", "The Glass Bead Game", "Narcissus and Goldmund", "Peter Camenzind"},{"Who wrote the essay 'Self-Reliance'?", "Ralph Waldo Emerson", "Henry David Thoreau", "Walt Whitman", "Nathaniel Hawthorne", "Herman Melville", "Emily Dickinson"},{"What is the name of Shakespeare's wife?", "Anne Hathaway", "Mary Arden", "Joan Shakespeare", "Anne Whateley", "Elizabeth Hall", "Susan Hall"},{"What is the title of Charles Dickens's last unfinished novel?", "The Mystery of Edwin Drood", "A Tale of Two Cities", "David Copperfield", "Bleak House", "Our Mutual Friend", "Great Expectations"},{"In 'The Scarlet Letter', what letter does Hester Prynne wear?", "A", "S", "H", "P", "T", "M"},{"Who wrote the novel 'Invisible Man'?", "Ralph Ellison", "Richard Wright", "James Baldwin", "Langston Hughes", "Zora Neale Hurston", "Toni Morrison"},{"Which Russian author wrote 'The Brothers Karamazov'?", "Fyodor Dostoevsky", "Leo Tolstoy", "Anton Chekhov", "Nikolai Gogol", "Ivan Turgenev", "Vladimir Nabokov"},{"Who wrote the book 'A Brief History of Time'?", "Stephen Hawking", "Carl Sagan", "Richard Feynman", "Albert Einstein", "Isaac Asimov", "Michio Kaku"},{"Which Shakespearean play features the characters Rosencrantz and Guildenstern?", "Hamlet", "Macbeth", "King Lear", "Othello", "The Tempest", "Much Ado About Nothing"},{"What was the nationality of poet Pablo Neruda?", "Chilean", "Mexican", "Argentine", "Colombian", "Brazilian", "Peruvian"},{"Who wrote 'Slaughterhouse-Five'?", "Kurt Vonnegut", "Ray Bradbury", "Philip K. Dick", "Isaac Asimov", "Aldous Huxley", "Arthur C. Clarke"},{"Which writer coined the term 'catch-22'?", "Joseph Heller", "Ernest Hemingway", "Norman Mailer", "J.D. Salinger", "Truman Capote", "Graham Greene"},{"In Dante's 'Inferno', how many circles of Hell are there?", "Nine", "Seven", "Ten", "Five", "Twelve", "Four"},{"Who wrote the poetry collection 'Leaves of Grass'?", "Walt Whitman", "Henry David Thoreau", "Emily Dickinson", "Robert Frost", "Edgar Allan Poe", "Mark Twain"},{"What is the name of the monster in Mary Shelley's 'Frankenstein'?", "It has no name", "Adam", "Victor", "Prometheus", "The Fiend", "Goliath"},{"What is the title of J.R.R. Tolkien's sequel to 'The Hobbit'?", "The Lord of the Rings", "The Silmarillion", "The Fellowship of the Ring", "The Return of the King", "Unfinished Tales", "The Two Towers"},{"Who wrote the novel 'Lolita'?", "Vladimir Nabokov", "Gabriel Garcia Marquez", "Milan Kundera", "Kazuo Ishiguro", "Salman Rushdie", "Italo Calvino"},{"What is the largest desert in the world?", "Sahara Desert", "Arabian Desert", "Gobi Desert", "Kalahari Desert", "Great Victoria Desert", "Patagonian Desert"},{"Which river is the longest in the world?", "Nile River", "Amazon River", "Yangtze River", "Mississippi River", "Yellow River", "Ganges River"},{"What mountain range separates Europe and Asia?", "Ural Mountains", "Andes Mountains", "Rocky Mountains", "Himalayas", "Appalachian Mountains", "Alps"},{"Which ocean is the largest by surface area?", "Pacific Ocean", "Atlantic Ocean", "Indian Ocean", "Southern Ocean", "Arctic Ocean", "Caribbean Sea"},{"What is the highest mountain in the world?", "Mount Everest", "K2", "Kangchenjunga", "Lhotse", "Makalu", "Annapurna"},{"Which country has the most natural lakes?", "Canada", "Russia", "United States", "Brazil", "India", "China"},{"What is the largest island in the world?", "Greenland", "New Guinea", "Borneo", "Madagascar", "Baffin Island", "Sumatra"},{"Which continent is known as the 'Dark Continent'?", "Africa", "Asia", "South America", "Australia", "North America", "Europe"},{"What is the smallest country in the world by land area?", "Vatican City", "Monaco", "Nauru", "San Marino", "Liechtenstein", "Malta"},{"Which desert is known for its red sand dunes?", "Namib Desert", "Sahara Desert", "Gobi Desert", "Karakum Desert", "Sonoran Desert", "Thar Desert"},{"What river flows through Egypt?", "Nile River", "Amazon River", "Tigris River", "Euphrates River", "Jordan River", "Mississippi River"},{"Which continent is home to the Amazon Rainforest?", "South America", "North America", "Africa", "Asia", "Australia", "Europe"},{"Which country has the largest population?", "India", "China", "United States", "Indonesia", "Pakistan", "Brazil"},{"What is the term for a body of water surrounded by land?", "Lake", "River", "Ocean", "Bay", "Strait", "Pond"},{"Which mountain range runs along the border of the United States and Canada?", "Rocky Mountains", "Appalachian Mountains", "Sierra Nevada", "Cascade Range", "Alaska Range", "Coast Mountains"},{"What is the most spoken language in the world?", "Mandarin Chinese", "Spanish", "English", "Hindi", "Arabic", "Bengali"},{"Which country is known as the 'Land of the Rising Sun'?", "Japan", "China", "South Korea", "Thailand", "Vietnam", "India"},{"What is the largest continent by area?", "Asia", "Africa", "North America", "South America", "Antarctica", "Europe"},{"Which two countries share the longest international border?", "United States and Canada", "Brazil and Argentina", "Russia and Kazakhstan", "China and India", "Australia and Papua New Guinea", "Mexico and the United States"},{"What is the main mountain range in South America?", "Andes Mountains", "Rocky Mountains", "Appalachian Mountains", "Alps", "Himalayas", "Urals"},{"Which sea is the saltiest?", "Dead Sea", "Red Sea", "Mediterranean Sea", "Caribbean Sea", "Aegean Sea", "Baltic Sea"},{"What is the largest freshwater lake by volume?", "Lake Baikal", "Lake Superior", "Lake Victoria", "Lake Huron", "Lake Michigan", "Lake Tanganyika"},{"Which country is home to the Great Barrier Reef?", "Australia", "United States", "Brazil", "Mexico", "Philippines", "Indonesia"},{"What is the term for a narrow strip of land connecting two larger land masses?", "Isthmus", "Peninsula", "Archipelago", "Delta", "Cove", "Lagoon"},{"Which country is known for the fjords?", "Norway", "Sweden", "Finland", "Denmark", "Iceland", "Canada"},{"What mountain range is known as the 'Roof of the World'?", "Pamirs", "Himalayas", "Andes", "Rockies", "Alps", "Carpathians"},{"Which continent has the highest number of countries?", "Africa", "Asia", "Europe", "North America", "South America", "Australia"},{"What is the largest volcano in the world?", "Mauna Loa", "Mount Kilimanjaro", "Mount St. Helens", "Mount Fuji", "Mount Elbrus", "Kilimanjaro"},{"Which river runs through London?", "Thames River", "Seine River", "Danube River", "Rhine River", "Nile River", "Elbe River"},{"What is the name of the desert located in northern Africa?", "Sahara Desert", "Kalahari Desert", "Sonoran Desert", "Gobi Desert", "Great Sandy Desert", "Atacama Desert"},{"What is the official language of Brazil?", "Portuguese", "Spanish", "English", "French", "Italian", "German"},{"Which region is known for its polar bears?", "Arctic", "Antarctic", "Tropical", "Desert", "Temperate", "Savanna"},{"What is the largest country in the world by area?", "Russia", "Canada", "China", "United States", "Brazil", "Australia"},{"Which country is home to the ancient city of Petra?", "Jordan", "Egypt", "Iraq", "Syria", "Lebanon", "Saudi Arabia"},{"What is the highest capital city in the world?", "La Paz", "Quito", "Bhutan", "Addis Ababa", "Bogota", "Sucre"},{"Which ocean is the Bermuda Triangle located in?", "Atlantic Ocean", "Pacific Ocean", "Indian Ocean", "Arctic Ocean", "Southern Ocean", "Caribbean Sea"},{"What is the name of the mountain range that runs through Italy?", "Apennines", "Andes", "Rockies", "Himalayas", "Alps", "Urals"},{"What is the smallest continent by land area?", "Australia", "Europe", "Antarctica", "South America", "North America", "Asia"},{"Which country is known for having kangaroos?", "Australia", "New Zealand", "South Africa", "Canada", "United States", "India"},{"What type of landform is the Grand Canyon?", "Canyon", "Valley", "Plateau", "Mountain", "Hill", "Plain"},{"Which country has the most volcanoes?", "Indonesia", "Japan", "United States", "Italy", "Mexico", "Philippines"},{"What is the largest bay in the world?", "Bay of Bengal", "Chesapeake Bay", "Gulf of Mexico", "San Francisco Bay", "Tokyo Bay", "Hudson Bay"},{"Which mountain range is known for its height and jagged peaks?", "Himalayas", "Andes", "Rockies", "Alps", "Ural Mountains", "Appalachians"},{"What is the term for a naturally formed body of saltwater smaller than an ocean?", "Sea", "Ocean", "Lake", "River", "Creek", "Pond"},{"Which continent has the fewest countries?", "Antarctica", "Oceania", "South America", "North America", "Europe", "Asia"},{"What is the largest city by population in the world?", "Tokyo", "Shanghai", "Delhi", "Sao Paulo", "Mexico City", "Cairo"},{"Which river is known as the longest river in North America?", "Missouri River", "Mississippi River", "Colorado River", "Columbia River", "Rio Grande", "Ohio River"},{"What is the name of the largest coral reef system in the world?", "Great Barrier Reef", "Belize Barrier Reef", "Red Sea Coral Reef", "New Caledonia Reef", "Andros Barrier Reef", "Maldives Coral Reef"},{"What is the longest river in the world?", "Nile River", "Amazon River", "Yangtze River", "Mississippi River", "Congo River", "Danube River"},{"Which country has the most time zones?", "France", "Russia", "United States", "China", "India", "Australia"},{"What is the longest river in the world?", "Nile", "Amazon", "Yangtze", "Mississippi", "Danube", "Mekong"},{"Which country has the most islands within its territory?", "Sweden", "Indonesia", "Canada", "Philippines", "Norway", "Finland"},{"What is the driest place on Earth?", "Atacama Desert", "Sahara Desert", "Gobi Desert", "Kalahari Desert", "Mojave Desert", "Arabian Desert"},{"Which continent is the only one without any native species of snakes?", "Antarctica", "Europe", "Australia", "Asia", "South America", "North America"},{"What is the largest lake in Africa?", "Lake Victoria", "Lake Tanganyika", "Lake Malawi", "Lake Chad", "Lake Albert", "Lake Kivu"},{"Mount Everest lies on the border between which two countries?", "Nepal and China", "India and Nepal", "China and Bhutan", "Nepal and Bhutan", "India and China", "China and Pakistan"},{"Which ocean is the deepest?", "Pacific Ocean", "Atlantic Ocean", "Indian Ocean", "Arctic Ocean", "Southern Ocean", "Mediterranean Sea"},{"What is the longest mountain range on land?", "Andes", "Rockies", "Himalayas", "Alps", "Urals", "Appalachians"},{"In which U.S. state would you find the Great Salt Lake?", "Utah", "Arizona", "Nevada", "Idaho", "Wyoming", "Montana"},{"What is the largest desert in the world?", "Antarctic Desert", "Sahara Desert", "Arabian Desert", "Gobi Desert", "Kalahari Desert", "Patagonian Desert"},{"Which river runs through Baghdad?", "Tigris", "Euphrates", "Nile", "Indus", "Jordan", "Ganges"},{"Which is the only continent with no active volcanoes?", "Australia", "Europe", "Africa", "South America", "Asia", "North America"},{"What is the largest island in the Caribbean?", "Cuba", "Jamaica", "Hispaniola", "Puerto Rico", "Trinidad", "Barbados"},{"What is the largest peninsula in the world?", "Arabian Peninsula", "Balkan Peninsula", "Indochina Peninsula", "Yucatan Peninsula", "Iberian Peninsula", "Korean Peninsula"},{"Which country is home to the world's largest coral reef system?", "Australia", "Philippines", "Indonesia", "Belize", "Maldives", "Fiji"},{"Which African country is known for having both Mediterranean and desert climates?", "Morocco", "Egypt", "Sudan", "Algeria", "Tunisia", "Libya"},{"What is the largest freshwater lake by volume?", "Lake Baikal", "Lake Superior", "Lake Victoria", "Lake Michigan", "Lake Tanganyika", "Caspian Sea"},{"Where is the Mariana Trench located?", "Pacific Ocean", "Atlantic Ocean", "Indian Ocean", "Arctic Ocean", "Southern Ocean", "Mediterranean Sea"},{"Which river is sacred in Hinduism?", "Ganges", "Yamuna", "Indus", "Brahmaputra", "Krishna", "Godavari"},{"What is the smallest country in terms of land area?", "Vatican City", "Monaco", "San Marino", "Liechtenstein", "Andorra", "Malta"},{"Which mountain is considered the tallest when measured from its base underwater?", "Mauna Kea", "Mount Everest", "Mount Kilimanjaro", "Mount Denali", "Mount Elbrus", "Mount Vinson"},{"Which European river flows through the most countries?", "Danube", "Rhine", "Seine", "Volga", "Elbe", "Thames"},{"What is the most populous city in Africa?", "Lagos", "Cairo", "Kinshasa", "Johannesburg", "Nairobi", "Addis Ababa"},{"The Amazon Rainforest spans nine countries; which has the largest portion?", "Brazil", "Peru", "Colombia", "Venezuela", "Ecuador", "Bolivia"},{"In which country would you find Mount Kilimanjaro?", "Tanzania", "Kenya", "Uganda", "Ethiopia", "Rwanda", "Malawi"},{"What is the largest country by land area entirely in Europe?", "Ukraine", "France", "Germany", "Poland", "Spain", "Italy"},{"Which desert covers much of Botswana and parts of Namibia and South Africa?", "Kalahari Desert", "Namib Desert", "Sahara Desert", "Arabian Desert", "Sonoran Desert", "Atacama Desert"},{"What is the deepest lake in North America?", "Great Slave Lake", "Lake Superior", "Lake Ontario", "Crater Lake", "Lake Michigan", "Lake Erie"},{"Which country has the most volcanoes?", "Indonesia", "Japan", "United States", "Russia", "Philippines", "Italy"},{"What is the name of the region located at the southernmost tip of South America?", "Patagonia", "Andes", "Pampas", "Amazon Basin", "Atacama", "Gran Chaco"},{"Which country is known as the 'Land of the Rising Sun'?", "Japan", "China", "South Korea", "Thailand", "India", "Vietnam"},{"What country has the largest rainforest after the Amazon?", "Congo (Democratic Republic)", "Indonesia", "Brazil", "Peru", "India", "Australia"},{"Which body of water separates Saudi Arabia from Africa?", "Red Sea", "Persian Gulf", "Arabian Sea", "Gulf of Aden", "Indian Ocean", "Mediterranean Sea"},{"The Great Wall of China primarily lies in which country?", "China", "Mongolia", "Nepal", "India", "North Korea", "Tibet"},{"In which continent is the Andes mountain range?", "South America", "North America", "Africa", "Europe", "Asia", "Australia"},{"Which country is bordered by both the Atlantic and Indian Oceans?", "South Africa", "Argentina", "Australia", "Madagascar", "Brazil", "Nigeria"},{"What is the term for a narrow strip of land connecting two larger land areas?", "Isthmus", "Peninsula", "Strait", "Delta", "Archipelago", "Plateau"},{"What is the primary river flowing through Paris, France?", "Seine", "Rhine", "Loire", "Danube", "Garonne", "Marne"},{"What is the tallest waterfall in the world?", "Angel Falls", "Niagara Falls", "Victoria Falls", "Yosemite Falls", "Iguazu Falls", "Kaieteur Falls"},{"Which country has the highest population density?", "Monaco", "Singapore", "Bangladesh", "Malta", "Netherlands", "India"},{"Which country has the most UNESCO World Heritage Sites?", "Italy", "China", "India", "France", "Germany", "Spain"},{"What type of ecosystem is the Everglades in Florida?", "Wetland", "Desert", "Rainforest", "Prairie", "Savanna", "Tundra"},{"Where is the Sahara Desert located?", "North Africa", "Middle East", "Southern Africa", "Central Asia", "North America", "South America"},{"What is the largest bay in the world?", "Bay of Bengal", "Hudson Bay", "San Francisco Bay", "Persian Gulf", "Biscayne Bay", "Bay of Fundy"},{"The Rock of Gibraltar is located near which continent?", "Europe", "Africa", "Asia", "South America", "North America", "Australia"},{"Which Scandinavian country is known for having thousands of fjords?", "Norway", "Sweden", "Finland", "Denmark", "Iceland", "Greenland"},{"What is the largest canyon in the world?", "Grand Canyon", "Yarlung Tsangpo Grand Canyon", "Copper Canyon", "Kali Gandaki Gorge", "Colca Canyon", "Fish River Canyon"},{"Which ocean current keeps Europe warmer than it would otherwise be?", "Gulf Stream", "Labrador Current", "Humboldt Current", "Benguela Current", "Agulhas Current", "North Atlantic Drift"},{"What country is Mount Elbrus located in?", "Russia", "Turkey", "Kazakhstan", "Georgia", "Armenia", "Iran"},{"Which U.S. state is the largest by land area?", "Alaska", "Texas", "California", "Montana", "New Mexico", "Nevada"},{"What is the medical term for high blood pressure?", "Hypertension", "Hypotension", "Hyperglycemia", "Hypoglycemia", "Arrhythmia", "Atherosclerosis"},{"Which part of the brain is responsible for regulating balance and coordination?", "Cerebellum", "Cerebrum", "Brainstem", "Thalamus", "Hypothalamus", "Amygdala"},{"What is the most common mental health disorder worldwide?", "Anxiety disorder", "Depression", "Bipolar disorder", "Schizophrenia", "OCD", "PTSD"},{"What is the main function of red blood cells?", "Transporting oxygen", "Fighting infection", "Clotting blood", "Regulating temperature", "Transmitting nerve signals", "Producing hormones"},{"What is the study of the mind and behavior called?", "Psychology", "Sociology", "Anthropology", "Psychiatry", "Neurology", "Philosophy"},{"Which organ is primarily responsible for detoxifying chemicals in the body?", "Liver", "Kidney", "Heart", "Lungs", "Pancreas", "Spleen"},{"What is the term for a fear of heights?", "Acrophobia", "Claustrophobia", "Agoraphobia", "Xenophobia", "Social anxiety", "Ophidiophobia"},{"Which vitamin is essential for blood clotting?", "Vitamin K", "Vitamin C", "Vitamin D", "Vitamin A", "Vitamin E", "Vitamin B12"},{"What is the name of the psychiatric disorder characterized by extreme mood swings?", "Bipolar disorder", "Major depressive disorder", "Generalized anxiety disorder", "Schizophrenia", "Borderline personality disorder", "Obsessive-compulsive disorder"},{"What is the common name for the condition 'myocardial infarction'?", "Heart attack", "Stroke", "Angina", "Cardiac arrest", "Arrhythmia", "Aneurysm"},{"What structure in the human body is primarily responsible for the regulation of calcium levels in the blood?", "Parathyroid glands", "Thyroid gland", "Pituitary gland", "Adrenal glands", "Pancreas", "Hypothalamus"},{"What is the largest organ in the human body?", "Skin", "Liver", "Heart", "Lungs", "Kidney", "Brain"},{"Which neurotransmitter is primarily associated with mood regulation?", "Serotonin", "Dopamine", "Norepinephrine", "Acetylcholine", "GABA", "Glutamate"},{"What is the medical term for inflammation of the joints?", "Arthritis", "Osteoporosis", "Tendinitis", "Bursitis", "Fibromyalgia", "Rheumatism"},{"What type of doctor specializes in treating mental illnesses?", "Psychiatrist", "Psychologist", "Neurologist", "Therapist", "Counselor", "Social worker"},{"What is the primary function of the pancreas?", "Regulating blood sugar", "Producing bile", "Filtering blood", "Transporting oxygen", "Digesting proteins", "Absorbing nutrients"},{"Which condition is characterized by the presence of persistent, unwanted thoughts?", "Obsessive-Compulsive Disorder", "Generalized Anxiety Disorder", "Post-Traumatic Stress Disorder", "Bipolar Disorder", "Major Depressive Disorder", "Social Anxiety Disorder"},{"What is the term for a significant drop in mood lasting at least two weeks?", "Major depression", "Dysthymia", "Bipolar disorder", "Seasonal Affective Disorder", "Adjustment disorder", "Schizophrenia"},{"What is the primary focus of psychodynamic therapy?", "Unconscious processes", "Behavior modification", "Cognitive restructuring", "Emotion regulation", "Mindfulness", "Supportive therapy"},{"What is the term for the body's response to stress?", "Fight or flight response", "Rest and digest", "Homeostasis", "Adaptive response", "Endocrine response", "Neurotransmitter release"},{"Which part of the nervous system controls involuntary actions?", "Autonomic nervous system", "Central nervous system", "Somatic nervous system", "Peripheral nervous system", "Sympathetic nervous system", "Parasympathetic nervous system"},{"What condition is characterized by a progressive loss of cognitive function?", "Alzheimer's disease", "Parkinson's disease", "Multiple sclerosis", "Huntington's disease", "Dementia", "Aphasia"},{"Which psychological condition is characterized by an intense fear of gaining weight?", "Anorexia nervosa", "Bulimia nervosa", "Binge-eating disorder", "Obesity", "Pica", "Orthorexia"},{"What is the term for a substance that can induce psychological or physical dependence?", "Addictive substance", "Hallucinogen", "Stimulant", "Depressant", "Narcotic", "Anxiolytic"},{"What is the primary purpose of vaccinations?", "Preventing disease", "Treating illness", "Boosting metabolism", "Improving digestion", "Enhancing mental health", "Increasing energy levels"},{"What is the term for a chronic fear of social situations?", "Social anxiety disorder", "Agoraphobia", "Specific phobia", "Panic disorder", "Generalized anxiety disorder", "Separation anxiety disorder"},{"Which hormone is often referred to as the 'stress hormone'?", "Cortisol", "Adrenaline", "Insulin", "Serotonin", "Dopamine", "Norepinephrine"},{"What is the medical term for a stroke?", "Cerebrovascular accident", "Myocardial infarction", "Pulmonary embolism", "Aneurysm", "Arrhythmia", "Thrombosis"},{"What type of therapy uses exposure techniques to treat phobias?", "Exposure therapy", "Cognitive Behavioral Therapy", "Dialectical Behavior Therapy", "Humanistic therapy", "Psychoanalysis", "Play therapy"},{"What condition is characterized by chronic pain without a clear physical cause?", "Fibromyalgia", "Rheumatoid arthritis", "Chronic fatigue syndrome", "Irritable bowel syndrome", "Celiac disease", "Diabetes"},{"Which part of the human body produces insulin?", "Pancreas", "Liver", "Kidneys", "Lungs", "Heart", "Gallbladder"},{"What is the name of the psychological test that measures personality traits?", "MMPI", "Rorschach test", "Beck Depression Inventory", "TAT", "Stanford-Binet test", "Wechsler test"},{"What is the term for the psychological phenomenon where a person feels detached from their body?", "Depersonalization", "Derealization", "Anxiety", "Panic", "Obsessive thinking", "Psychosis"},{"What is the medical term for the study of the causes of diseases?", "Etiology", "Pathology", "Diagnosis", "Prognosis", "Anatomy", "Physiology"},{"What is the term for therapy that focuses on self-exploration and personal growth?", "Humanistic therapy", "Behavioral therapy", "Cognitive therapy", "Psychodynamic therapy", "Supportive therapy", "Family therapy"},{"Which vitamin is essential for vision?", "Vitamin A", "Vitamin B12", "Vitamin C", "Vitamin D", "Vitamin E", "Vitamin K"},{"What is the primary role of the immune system?", "Fighting infections", "Regulating hormones", "Digesting food", "Producing energy", "Controlling emotions", "Transporting oxygen"},{"What is the term for a mental disorder involving persistent feelings of sadness?", "Depressive disorder", "Anxiety disorder", "Schizophrenia", "Bipolar disorder", "Dissociative disorder", "Personality disorder"},{"Which therapy technique involves talking about past experiences to understand present behavior?", "Psychoanalysis", "Behavioral therapy", "Cognitive therapy", "Humanistic therapy", "Group therapy", "Family therapy"},{"What is the common name for the condition known as 'hypertension'?", "High blood pressure", "Low blood pressure", "High cholesterol", "Heart disease", "Diabetes", "Stroke"},{"What psychological concept explains the tendency to attribute one's successes to internal factors and failures to external factors?", "Self-serving bias", "Fundamental attribution error", "Confirmation bias", "Hindsight bias", "Availability heuristic", "Dunning-Kruger effect"},{"What is the term for a sudden and intense episode of fear?", "Panic attack", "Anxiety attack", "Nervous breakdown", "Phobia", "Stress response", "OCD episode"},{"What medical field specializes in the treatment of mental disorders?", "Psychiatry", "Psychology", "Neurology", "Therapy", "Counseling", "Social work"},{"Which neurotransmitter is primarily involved in the pleasure and reward system?", "Dopamine", "Serotonin", "Norepinephrine", "Acetylcholine", "GABA", "Glutamate"},{"What is the term for the psychological process of adapting to new information?", "Assimilation", "Accommodation", "Sensation", "Perception", "Cognition", "Learning"},{"What is the main purpose of the immune response?", "To protect the body from pathogens", "To digest food", "To regulate blood sugar", "To transport oxygen", "To maintain body temperature", "To produce hormones"},{"What is the medical term for a physician who specializes in children's health?", "Pediatrician", "Geriatrician", "Internist", "Cardiologist", "Endocrinologist", "Neurologist"},{"Which condition is characterized by the presence of multiple personalities?", "Dissociative identity disorder", "Schizophrenia", "Bipolar disorder", "Borderline personality disorder", "Anxiety disorder", "Depression"},{"What is the primary treatment for major depressive disorder?", "Antidepressants", "Antipsychotics", "Mood stabilizers", "Anxiolytics", "Stimulants", "Placebo"},{"What is the term for the psychological defense mechanism of attributing one's own undesirable traits to others?", "Projection", "Denial", "Rationalization", "Repression", "Displacement", "Sublimation"},{"What is the longest bone in the human body?", "Femur", "Humerus", "Tibia", "Fibula", "Ulna", "Radius"},{"What type of tissue is responsible for connecting bones to other bones?", "Ligaments", "Tendons", "Cartilage", "Fascia", "Synovium", "Muscle tissue"},{"Where are the adrenal glands located?", "On top of the kidneys", "Near the pancreas", "Behind the thyroid gland", "In the brain", "Beside the heart", "In the liver"},{"What is the main function of hemoglobin?", "Transport oxygen in the blood", "Digest proteins", "Break down fats", "Form blood clots", "Produce white blood cells", "Regulate blood pressure"},{"What part of the brain is responsible for regulating balance and coordination?", "Cerebellum", "Medulla oblongata", "Cerebrum", "Hypothalamus", "Thalamus", "Pons"},{"Which type of muscle tissue is found only in the heart?", "Cardiac muscle", "Skeletal muscle", "Smooth muscle", "Striated muscle", "Fibrous muscle", "Elastic muscle"},{"What part of the human body is the 'hallux'?", "Big toe", "Thumb", "Knee", "Elbow", "Heel", "Ankle"},{"What is the role of osteoclasts in the body?", "Break down bone tissue", "Form new blood cells", "Build muscle fibers", "Repair damaged tissue", "Filter waste", "Store fat"},{"Which cells in the pancreas produce insulin?", "Beta cells", "Alpha cells", "Delta cells", "Gamma cells", "Omega cells", "Langerhans cells"},{"What is the smallest bone in the human body?", "Stapes", "Incus", "Malleus", "Hyoid", "Lacrimal", "Scaphoid"},{"In which organ is bile stored?", "Gallbladder", "Liver", "Pancreas", "Small intestine", "Kidney", "Spleen"},{"Which part of the eye controls the amount of light that enters?", "Iris", "Cornea", "Retina", "Lens", "Sclera", "Macula"},{"What type of joint is found at the shoulder and hip?", "Ball and socket", "Hinge", "Pivot", "Saddle", "Condyloid", "Gliding"},{"Which enzyme breaks down carbohydrates in the mouth?", "Amylase", "Lipase", "Pepsin", "Trypsin", "Lactase", "Maltase"},{"What is the main function of the mitochondria?", "Produce energy", "Store genetic material", "Synthesize proteins", "Protect cells from toxins", "Aid in cell division", "Transmit nerve signals"},{"Which part of the heart pumps oxygenated blood to the body?", "Left ventricle", "Right atrium", "Right ventricle", "Left atrium", "Aorta", "Pulmonary vein"},{"What is the name of the largest artery in the human body?", "Aorta", "Pulmonary artery", "Carotid artery", "Femoral artery", "Brachial artery", "Subclavian artery"},{"What is the main structural protein found in skin and connective tissue?", "Collagen", "Elastin", "Keratin", "Myosin", "Actin", "Fibronectin"},{"Where are the islets of Langerhans located?", "Pancreas", "Liver", "Kidney", "Stomach", "Lung", "Spleen"},{"What part of the brain controls involuntary actions like breathing and heart rate?", "Medulla oblongata", "Cerebellum", "Cerebrum", "Hypothalamus", "Thalamus", "Pineal gland"},{"Which part of the digestive system absorbs most of the nutrients?", "Small intestine", "Large intestine", "Stomach", "Esophagus", "Liver", "Gallbladder"},{"How many pairs of ribs do humans normally have?", "12", "10", "14", "11", "9", "13"},{"Which cells in the human body have no nucleus?", "Red blood cells", "White blood cells", "Muscle cells", "Neurons", "Platelets", "Stem cells"},{"What is the main function of the spleen?", "Filter blood and fight infections", "Produce bile", "Regulate blood sugar", "Store fats", "Absorb vitamins", "Produce insulin"},{"What is the hardest substance in the human body?", "Tooth enamel", "Bone", "Cartilage", "Nail", "Dentine", "Hair"},{"What is the scientific term for the voice box?", "Larynx", "Pharynx", "Trachea", "Esophagus", "Bronchi", "Glottis"},{"Which type of blood vessel carries blood away from the heart?", "Arteries", "Veins", "Capillaries", "Venules", "Lymph vessels", "Arterioles"},{"What hormone is primarily responsible for regulating metabolism?", "Thyroxine", "Insulin", "Adrenaline", "Estrogen", "Testosterone", "Melatonin"},{"In which layer of the skin are sweat glands located?", "Dermis", "Epidermis", "Hypodermis", "Stratum corneum", "Stratum lucidum", "Subcutaneous tissue"},{"Which cranial nerve is responsible for vision?", "Optic nerve", "Olfactory nerve", "Trigeminal nerve", "Facial nerve", "Vagus nerve", "Glossopharyngeal nerve"},{"What is the primary function of platelets?", "Aid in blood clotting", "Carry oxygen", "Fight infections", "Produce insulin", "Store calcium", "Regulate temperature"},{"What is the main function of the liver in digestion?", "Produce bile", "Absorb nutrients", "Secrete enzymes", "Neutralize stomach acid", "Store bile", "Produce insulin"},{"Which muscle is known as the 'calf muscle'?", "Gastrocnemius", "Biceps", "Triceps", "Deltoid", "Pectoralis", "Sartorius"},{"What is the name of the valve between the stomach and the small intestine?", "Pyloric valve", "Mitral valve", "Ileocecal valve", "Pulmonary valve", "Aortic valve", "Cardiac valve"},{"Which part of the human brain is the largest?", "Cerebrum", "Cerebellum", "Brainstem", "Hypothalamus", "Thalamus", "Medulla"},{"What organ is primarily responsible for filtering toxins from the blood?", "Liver", "Kidney", "Spleen", "Pancreas", "Lung", "Gallbladder"},{"What type of cell is the primary component of nervous tissue?", "Neuron", "Osteocyte", "Chondrocyte", "Myocyte", "Hepatocyte", "Erythrocyte"},{"Where in the body is the 'patella' located?", "Knee", "Elbow", "Wrist", "Shoulder", "Hip", "Ankle"},{"Which part of the immune system produces antibodies?", "B cells", "T cells", "Macrophages", "Neutrophils", "Eosinophils", "Platelets"},{"What is the main component of hair and nails?", "Keratin", "Collagen", "Elastin", "Melanin", "Myosin", "Fibronectin"},{"What is the longest nerve in the human body?", "Sciatic nerve", "Vagus nerve", "Optic nerve", "Trigeminal nerve", "Facial nerve", "Ulnar nerve"},{"What type of joint is the knee?", "Hinge joint", "Ball and socket joint", "Pivot joint", "Saddle joint", "Gliding joint", "Ellipsoidal joint"},{"What is the average pH of human blood?", "7.4", "6.8", "7.0", "7.8", "6.5", "8.0"},{"What is the name of the largest lymphatic organ in the body?", "Spleen", "Liver", "Thymus", "Tonsil", "Lymph node", "Appendix"},{"Which enzyme is responsible for breaking down fats in the digestive system?", "Lipase", "Amylase", "Pepsin", "Trypsin", "Lactase", "Maltase"},{"What is the structure in the ear responsible for maintaining balance?", "Semicircular canals", "Cochlea", "Eardrum", "Ossicles", "Auditory canal", "Utricle"},{"What is the name of the layer of cells that lines the interior of blood vessels?", "Endothelium", "Epidermis", "Dermis", "Myocardium", "Pericardium", "Lamina propria"},{"What type of blood cell fights infections?", "White blood cells", "Red blood cells", "Platelets", "Stem cells", "Plasma cells", "Epithelial cells"},{"Where in the body would you find alveoli?", "Lungs", "Heart", "Brain", "Kidney", "Liver", "Pancreas"},{"What hormone is released in response to stress?", "Cortisol", "Insulin", "Thyroxine", "Estrogen", "Melatonin", "Testosterone"},{"What is the best-selling video game of all time?", "Minecraft", "Tetris", "Grand Theft Auto V", "Wii Sports", "PlayerUnknown's Battlegrounds", "Super Mario Bros."},{"Which card game is known as the 'game of kings'?", "Chess", "Poker", "Bridge", "Go", "Checkers", "Rummy"},{"In which year was the original Nintendo Entertainment System (NES) released?", "1983", "1985", "1987", "1990", "1993", "1996"},{"What is the primary objective in the game of Monopoly?", "Bankruptcy your opponents", "Collect properties", "Build hotels", "Collect the most money", "Avoid jail", "Trade properties"},{"Which game features characters like Mario, Link, and Donkey Kong?", "Super Smash Bros.", "Mortal Kombat", "Street Fighter", "Tekken", "Final Fantasy", "Call of Duty"},{"What is the fictional setting of the game 'The Elder Scrolls V: Skyrim'?", "Tamriel", "Azeroth", "Hyrule", "Runeterra", "Midgard", "Zelda"},{"Which board game involves trading and building railroads?", "Monopoly", "Ticket to Ride", "Catan", "Risk", "Clue", "Scrabble"},{"What is the main character's name in the 'Legend of Zelda' series?", "Link", "Zelda", "Ganon", "Navi", "Impa", "Sheik"},{"In which game do players build settlements and trade resources?", "Settlers of Catan", "Monopoly", "Risk", "Carcassonne", "Pandemic", "Ticket to Ride"},{"What is the primary objective in the game of Fortnite?", "Be the last player standing", "Collect resources", "Build structures", "Complete quests", "Form alliances", "Capture the flag"},{"Which tabletop role-playing game is known for its D20 system?", "Dungeons & Dragons", "Pathfinder", "Shadowrun", "Call of Cthulhu", "GURPS", "Fiasco"},{"What is the name of the popular battle royale game developed by Respawn Entertainment?", "Apex Legends", "Fortnite", "PUBG", "Call of Duty: Warzone", "Valorant", "Escape from Tarkov"},{"Which classic arcade game features a yellow character eating dots?", "Pac-Man", "Donkey Kong", "Space Invaders", "Galaga", "Pong", "Frogger"},{"In 'Magic: The Gathering', what is the term for the cards you draw from your deck?", "Library", "Hand", "Graveyard", "Battlefield", "Stack", "Sideboard"},{"Which game features a character named Master Chief?", "Halo", "Gears of War", "Call of Duty", "Doom", "Half-Life", "Battlefield"},{"What is the name of the largest expansion pack for 'World of Warcraft' released in 2020?", "Shadowlands", "Battle for Azeroth", "Legion", "Warlords of Draenor", "Mists of Pandaria", "Cataclysm"},{"What board game is known for its detective work and solving a murder mystery?", "Clue", "Monopoly", "Risk", "Guess Who?", "Battleship", "Scrabble"},{"Which video game franchise features a character named Geralt of Rivia?", "The Witcher", "Elder Scrolls", "Dark Souls", "Dragon Age", "Mass Effect", "Final Fantasy"},{"In poker, what is the highest possible hand?", "Royal Flush", "Straight Flush", "Four of a Kind", "Full House", "Flush", "Straight"},{"What is the main goal in the game 'Among Us'?", "Identify the impostor", "Complete tasks", "Survive", "Collect resources", "Build structures", "Eliminate crew members"},{"What game series features characters like Kratos and Atreus?", "God of War", "Uncharted", "Assassin's Creed", "Final Fantasy", "Dark Souls", "The Last of Us"},{"Which tabletop game involves players rolling dice to move around the board and buy properties?", "Monopoly", "Catan", "Life", "Clue", "Sorry!", "Risk"},{"In which game do players manage a theme park?", "RollerCoaster Tycoon", "SimCity", "Zoo Tycoon", "Planet Coaster", "Theme Park World", "Parkitect"},{"Which card game involves collecting and battling with creatures, spells, and enchantments?", "Magic: The Gathering", "Yu-Gi-Oh!", "Pokemon Trading Card Game", "Hearthstone", "KeyForge", "Duel Masters"},{"What is the main currency used in 'Animal Crossing'?", "Bells", "Coins", "Stars", "Gems", "Tokens", "Points"},{"Which game features a post-apocalyptic world inhabited by zombies?", "The Last of Us", "Resident Evil", "Dead Rising", "Dying Light", "Left 4 Dead", "Days Gone"},{"What is the objective of the game 'Overcooked'?", "Cook and serve meals", "Collect ingredients", "Build a restaurant", "Compete against other chefs", "Complete levels", "Manage a kitchen"},{"In 'Call of Duty', what does the term 'killstreak' refer to?", "Getting multiple kills without dying", "Achieving high scores", "Completing missions", "Reviving teammates", "Capturing objectives", "Winning matches"},{"What is the primary genre of the game 'The Sims'?", "Life simulation", "Role-playing", "Strategy", "Adventure", "Action", "Puzzle"},{"Which game involves racing on hoverboards and performing tricks?", "Jet Set Radio", "Tony Hawk's Pro Skater", "SSX", "Mario Kart", "Wave Race", "Forza Horizon"},{"What is the main feature of 'League of Legends'?", "Multiplayer online battle arena", "First-person shooter", "Role-playing game", "Puzzle game", "Adventure game", "Card game"},{"Which tabletop game features hexagonal tiles for resource management?", "Catan", "Carcassonne", "Ticket to Ride", "Pandemic", "Dominion", "7 Wonders"},{"In chess, what piece can move in an L-shape?", "Knight", "Bishop", "Rook", "Queen", "King", "Pawn"},{"What type of game is 'Fortnite' primarily classified as?", "Battle royale", "First-person shooter", "RPG", "Puzzle", "Simulation", "Strategy"},{"In which game do players search for a hidden treasure in a competitive environment?", "Treasure Island", "Tomb Raider", "Uncharted", "Sea of Thieves", "Minecraft", "The Legend of Zelda"},{"Which board game requires players to complete a word by placing letter tiles?", "Scrabble", "Boggle", "Pictionary", "Trivial Pursuit", "Risk", "Monopoly"},{"In 'World of Warcraft', what is the maximum level a character can reach?", "60", "70", "80", "90", "100", "110"},{"What is the name of the famous card game that uses a 52-card deck and involves betting?", "Poker", "Rummy", "Bridge", "Solitaire", "Go Fish", "Blackjack"},{"What is the main character's name in the 'Final Fantasy VII' series?", "Cloud Strife", "Tidus", "Squall Leonhart", "Noctis Lucis Caelum", "Zidane Tribal", "Lightning"},{"Which game allows players to build and create their own world using blocks?", "Minecraft", "Roblox", "Terraria", "Fortnite", "ARK: Survival Evolved", "No Man's Sky"},{"What is the objective of the game 'Dungeons & Dragons'?", "Role-playing in a fantasy setting", "Solving mysteries", "Collecting cards", "Building cities", "Racing cars", "Fighting monsters"},{"Which game is known for its famous catchphrase, 'It's dangerous to go alone! Take this!'", "The Legend of Zelda", "Final Fantasy", "Dark Souls", "Metroid", "Castlevania", "Mega Man"},{"What board game features properties based on real streets in Atlantic City?", "Monopoly", "Life", "Clue", "Risk", "Scrabble", "Trivial Pursuit"},{"What type of game is 'Among Us' primarily categorized as?", "Social deduction", "Battle royale", "First-person shooter", "RPG", "Puzzle", "Simulation"},{"Which video game franchise is known for its 'Mortal Kombat' series?", "Fighting games", "RPG", "Adventure", "Puzzle", "Simulation", "Platformer"},{"What is the main goal in the game 'Candy Crush Saga'?", "Match three candies", "Collect coins", "Solve puzzles", "Reach the top level", "Defeat bosses", "Explore worlds"},{"What type of game is 'Call of Duty'?", "First-person shooter", "Role-playing", "Simulation", "Adventure", "Puzzle", "Strategy"},{"In 'The Legend of Zelda: Ocarina of Time', what item is used to travel through time?", "Ocarina", "Boomerang", "Hookshot", "Sword", "Shield", "Lantern"},{"Which game is set in a fictional universe where players can build their own worlds?", "Roblox", "Minecraft", "Fortnite", "ARK: Survival Evolved", "Terraria", "Sims"},{"What is the objective in the card game 'Uno'?", "Get rid of all your cards", "Collect the most cards", "Reach a certain score", "Win tricks", "Play the highest card", "Complete sets"},{"What year was the original Pac-Man arcade game released?", "1980", "1978", "1982", "1985", "1979", "1981"},{"In Dungeons & Dragons, what is the highest level a character can reach?", "20", "15", "30", "25", "40", "50"},{"Which color in Scrabble offers a triple word score?", "Red", "Blue", "Green", "Yellow", "Purple", "Black"},{"In chess, how many possible moves are there for each player in the starting position?", "20", "16", "12", "18", "24", "10"},{"What card is known as the 'Dead Man's Hand' in poker?", "Aces and Eights", "Kings and Queens", "Aces and Kings", "Jacks and Tens", "Queens and Jacks", "Tens and Nines"},{"Which piece can only move diagonally in checkers?", "All pieces", "King only", "Regular pieces only", "Opponent's pieces only", "Captured pieces only", "None"},{"What is the main objective in Settlers of Catan?", "Reach 10 points", "Conquer the island", "Collect 20 resources", "Reach 5 cities", "Trade the most resources", "Build the largest army"},{"In Monopoly, which property is the most expensive?", "Boardwalk", "Park Place", "Illinois Avenue", "Pennsylvania Avenue", "Marvin Gardens", "Pacific Avenue"},{"In Fortnite, what is the name of the location with a large meteor crater?", "Dusty Divot", "Salty Springs", "Tilted Towers", "Pleasant Park", "Fatal Fields", "Lazy Lake"},{"Which video game series features characters like Yennefer and Geralt?", "The Witcher", "Dark Souls", "Dragon Age", "Assassin's Creed", "The Elder Scrolls", "Mass Effect"},{"In Go, how many stones does each player begin with?", "An unlimited supply", "150", "250", "360", "450", "100"},{"In Magic: The Gathering, how many colors are represented in the mana system?", "Five", "Three", "Four", "Six", "Seven", "Eight"},{"What is the primary objective in Risk?", "Conquer all territories", "Build the longest road", "Defend your capital", "Collect the most resources", "Build the largest army", "Protect the borders"},{"In Overwatch, which character can hack enemies and health packs?", "Sombra", "Reaper", "Tracer", "D.Va", "Genji", "Mercy"},{"What is the name of the realm where The Elder Scrolls V: Skyrim is set?", "Tamriel", "Hyrule", "Azeroth", "Narnia", "Middle-earth", "Dunwall"},{"In Among Us, what role does a player take if they're assigned to sabotage and eliminate others?", "Impostor", "Crewmate", "Detective", "Pilot", "Alien", "Engineer"},{"In Poker, what is the highest possible hand?", "Royal Flush", "Straight Flush", "Four of a Kind", "Full House", "Flush", "Straight"},{"In Legend of Zelda, what is Link's primary weapon?", "Master Sword", "Great Bow", "Wind Staff", "Power Gauntlets", "Golden Hammer", "Ice Wand"},{"In Settlers of Catan, which resource is not available?", "Gold", "Wood", "Sheep", "Wheat", "Brick", "Ore"},{"In Chess, which piece is sometimes called the 'castle'?", "Rook", "Bishop", "Knight", "Queen", "Pawn", "King"},{"In World of Warcraft, what is the name of the planet where most of the game takes place?", "Azeroth", "Tamriel", "Pandora", "Eorzea", "Arda", "Zerith Mortis"},{"What type of game is Pictionary?", "Drawing", "Word", "Strategy", "Card", "Dice", "Racing"},{"Which Mario Kart track is known for its infamous rainbow road?", "Rainbow Road", "Mushroom Gorge", "Bowser Castle", "Toad's Turnpike", "Mario Circuit", "Luigi Raceway"},{"In Minecraft, what item is needed to mine obsidian?", "Diamond Pickaxe", "Iron Pickaxe", "Stone Pickaxe", "Gold Pickaxe", "Wooden Pickaxe", "Flint and Steel"},{"In Uno, how many cards does each player begin with?", "Seven", "Five", "Nine", "Six", "Eight", "Ten"},{"What does XP stand for in most video games?", "Experience Points", "Extra Points", "Extended Play", "Exclusive Points", "Experience Percentage", "Extra Power"},{"In League of Legends, what term is used to describe defeating many enemy players without dying?", "Killing spree", "Power up", "Triple kill", "Wave clear", "Victory dance", "Ace"},{"In Street Fighter, what is Ryu's iconic move called?", "Hadouken", "Shoryuken", "Tatsumaki", "Flash Kick", "Electric Thunder", "Psycho Crusher"},{"Which board game was originally called 'The Landlord's Game'?", "Monopoly", "Clue", "Risk", "Life", "Catan", "Battleship"},{"Which character is the main protagonist in The Last of Us Part II?", "Ellie", "Joel", "Tommy", "Marlene", "Sarah", "Bill"},{"In Final Fantasy VII, who wields the Buster Sword?", "Cloud", "Sephiroth", "Tifa", "Zack", "Barret", "Aerith"},{"What color represents a 50-point ball in Snooker?", "There is no 50-point ball", "Black", "Red", "Yellow", "Blue", "Green"},{"In Halo, what is Master Chief's real name?", "John", "James", "Marcus", "Paul", "David", "Michael"},{"What card game uses the terms 'flop', 'turn', and 'river'?", "Texas Hold'em Poker", "Bridge", "Blackjack", "Pinochle", "Rummy", "Go Fish"},{"In The Sims series, what is the fictional language spoken by the characters?", "Simlish", "Gibberish", "Sim-tongue", "Simspeak", "Simglish", "Simanese"},{"In Monopoly, how much money does a player collect for passing 'GO'?", "$200", "$100", "$300", "$400", "$500", "$250"},{"Which video game series features characters like Kratos and Atreus?", "God of War", "Assassin's Creed", "Uncharted", "Dark Souls", "Bloodborne", "Sekiro"},{"In Magic: The Gathering, which color is associated with healing and protection?", "White", "Red", "Blue", "Black", "Green", "Yellow"},{"What is the maximum score possible in a standard game of ten-pin bowling?", "300", "400", "250", "200", "150", "350"},{"In Resident Evil, what is the name of the pharmaceutical company responsible for the zombie outbreak?", "Umbrella Corporation", "Biotech Corp", "GenePharm", "Helix Biolabs", "Horizon", "NeoScape"},{"Which card in Clue represents the location of the crime?", "Room", "Weapon", "Character", "Tool", "Evidence", "Witness"},{"In Scrabble, what is the point value of the letter 'Q'?", "10", "8", "5", "4", "3", "12"},{"What popular board game includes characters like Colonel Mustard and Professor Plum?", "Clue", "Monopoly", "Risk", "Catan", "Life", "Yahtzee"},{"In Tetris, what is the shape of the Tetrimino?", "L-shaped", "Square", "T-shaped", "Line", "Z-shaped", "O-shaped"},{"In Overwatch, which character is known for using a bow and arrows?", "Hanzo", "Genji", "Widowmaker", "Tracer", "Reaper", "McCree"},{"In Dungeons & Dragons, which class can cast healing spells by default?", "Cleric", "Wizard", "Fighter", "Rogue", "Warlock", "Barbarian"},{"In the game of Clue, which character is known for wearing a green suit?", "Mr. Green", "Colonel Mustard", "Professor Plum", "Mrs. Peacock", "Miss Scarlet", "Mrs. White"},{"In the game Scrabble, what is the highest scoring letter?", "Z", "X", "Q", "J", "K", "C"},{"In the game 'Pictionary,' what is the maximum number of players allowed on a team according to the official rules?", "Four", "Six", "Three", "Five", "Two", "Seven"},{"In 'Codenames,' what is the role of the spymaster?", "To give one-word clues to help teammates guess words", "To select the words to guess", "To act as a referee", "To provide additional hints if needed", "To make the final guesses", "To keep track of the score"},{"What is the name of the first Pokemon ever created?", "Bulbasaur", "Pikachu", "Mewtwo", "Charizard", "Rhydon", "Squirtle"},{"Which type is effective against Water-type Pokemon?", "Electric", "Fire", "Grass", "Ground", "Rock", "Ice"},{"What is Pikachu's evolution?", "Raichu", "Pichu", "Eevee", "Charmeleon", "Gyarados", "Machoke"},{"What item is used to evolve Eevee into Vaporeon?", "Water Stone", "Fire Stone", "Leaf Stone", "Thunder Stone", "Moon Stone", "Sun Stone"},{"Which Pokemon is known as the 'Mouse Pokemon'?", "Pikachu", "Rattata", "Sandshrew", "Spearow", "Zubat", "Nidoran"},{"What is the maximum level a Pokemon can reach?", "100", "50", "150", "200", "75", "120"},{"Which Pokemon is known as the 'Legendary Pokemon of the Sea'?", "Lugia", "Kyogre", "Mew", "Rayquaza", "Groudon", "Celebi"},{"What type of Pokemon is Charizard?", "Fire/Flying", "Fire", "Flying", "Dragon", "Fire/Dragon", "Ground"},{"Which Pokemon can evolve into multiple forms depending on the item used?", "Eevee", "Pikachu", "Meowth", "Machop", "Snorlax", "Jigglypuff"},{"What is the name of the Pokemon Professor in the Kanto region?", "Professor Oak", "Professor Elm", "Professor Birch", "Professor Kukui", "Professor Sycamore", "Professor Rowan"},{"Which Pokemon is known for its ability to create black holes?", "Giratina", "Mewtwo", "Rayquaza", "Lugia", "Darkrai", "Dialga"},{"What is the first Pokemon game released?", "Pokemon Red and Green", "Pokemon Blue", "Pokemon Yellow", "Pokemon Gold", "Pokemon Silver", "Pokemon Ruby"},{"Which Pokemon is known as the 'Sleeping Pokemon'?", "Snorlax", "Jigglypuff", "Machamp", "Ditto", "Psyduck", "Togepi"},{"What type of Pokemon is Gardevoir?", "Psychic/Fairy", "Psychic", "Fairy", "Ghost", "Fighting", "Normal"},{"Which Pokemon is the mascot of the Pokemon franchise?", "Pikachu", "Eevee", "Mewtwo", "Charizard", "Gengar", "Lucario"},{"What is the primary objective of Pokemon battles?", "Defeat the opponent's Pokemon", "Capture wild Pokemon", "Complete the Pokedex", "Train Pokemon", "Win Gym badges", "Become a champion"},{"Which Pokemon can Mega Evolve into two different forms?", "Mewtwo", "Charizard", "Gardevoir", "Blastoise", "Lucario", "Gallade"},{"What is the name of the Pokemon League in the Sinnoh region?", "Sinnoh League", "Indigo Plateau", "Johto League", "Unova League", "Kalos League", "Alola League"},{"What item is needed to evolve Porygon into Porygon-Z?", "Upgrade", "Dubious Disc", "Link Cable", "Water Stone", "Thunder Stone", "Fire Stone"},{"Which Pokemon is known for its signature move, 'Hydro Pump'?", "Blastoise", "Gyarados", "Kingler", "Vaporeon", "Tentacruel", "Swampert"},{"What type of Pokemon is Arceus?", "Normal", "Psychic", "Dragon", "Fairy", "Electric", "Fighting"},{"Which Pokemon has the ability 'Levitate'?", "Gengar", "Alakazam", "Koffing", "Misdreavus", "Porygon", "Rotom"},{"What is the evolution of Caterpie?", "Metapod", "Butterfree", "Beedrill", "Venonat", "Heracross", "Paras"},{"What does the term 'Shiny Pokemon' refer to?", "Rare color variant", "Legendary Pokemon", "Fully evolved Pokemon", "Event Pokemon", "Mega Evolved Pokemon", "Mythical Pokemon"},{"Which Pokemon is known as the 'Time Travel Pokemon'?", "Dialga", "Celebi", "Mewtwo", "Lugia", "Giratina", "Rayquaza"},{"What type of Pokemon is Tyranitar?", "Rock/Dark", "Fighting", "Steel/Ground", "Normal", "Psychic", "Ghost"},{"Which Pokemon is known for its ability to teleport?", "Abra", "Alakazam", "Kadabra", "Gardevoir", "Gengar", "Mew"},{"What is the name of the Pokemon League in the Unova region?", "Unova League", "Indigo Plateau", "Kanto League", "Johto League", "Sinnoh League", "Kalos League"},{"Which Pokemon evolves from Turtwig?", "Grotle", "Torterra", "Chikorita", "Bulbasaur", "Treecko", "Snivy"},{"What is the primary type of Pokemon for Gym Leader Brock?", "Rock", "Ground", "Fighting", "Electric", "Water", "Grass"},{"Which Pokemon is known as the 'Cocoon Pokemon'?", "Metapod", "Kakuna", "Cascoon", "Cocoon", "Wurmple", "Pineco"},{"What is the signature move of Pikachu?", "Thunderbolt", "Volt Tackle", "Quick Attack", "Thunder Wave", "Electro Ball", "Iron Tail"},{"Which Pokemon is known for its ability to change forms based on the time of day?", "Sawk", "Zorua", "Cherrim", "Cresselia", "Lunala", "Shedinja"},{"What is the name of Ash's first Pokemon?", "Pikachu", "Charizard", "Butterfree", "Bulbasaur", "Squirtle", "Kingler"},{"Which Pokemon has the highest base stat total?", "Arceus", "Mewtwo", "Rayquaza", "Giratina", "Dragonite", "Zygarde"},{"What is the primary ability of the Pokemon Shedinja?", "Wonder Guard", "Levitate", "Sturdy", "Speed Boost", "Truant", "Sand Stream"},{"Which Pokemon is known for its 'Flame Body' ability?", "Magmar", "Charizard", "Blaziken", "Houndoom", "Ninetales", "Talonflame"},{"What type of Pokemon is Gyarados?", "Water/Flying", "Dragon", "Water", "Electric", "Ground", "Fire"},{"Which Pokemon is known for its evolution requiring friendship?", "Togepi", "Pichu", "Eevee", "Chingling", "Ralts", "Swablu"},{"What is the evolution of Magnemite?", "Magneton", "Magnezone", "Electrode", "Raichu", "Ampharos", "Electabuzz"},{"Which Pokemon is known for being the 'Ember Pokemon'?", "Charmander", "Vulpix", "Torchic", "Flareon", "Charizard", "Blaziken"},{"What is the name of the region introduced in Pokemon X and Y?", "Kalos", "Hoenn", "Sinnoh", "Unova", "Johto", "Kanto"},{"Which Pokemon evolves into Blissey?", "Chansey", "Jigglypuff", "Togetic", "Clefairy", "Porygon2", "Happiny"},{"What is the primary objective of Pokemon contests?", "Earn ribbons", "Capture Pokemon", "Win battles", "Complete the Pokedex", "Trade Pokemon", "Level up Pokemon"},{"What is the name of the Pokemon that resembles a small dragon and has a fire type?", "Charmander", "Dratini", "Bagon", "Gible", "Talonflame", "Dragonite"},{"Which Pokemon is known for its ability to create illusions?", "Zoroark", "Gardevoir", "Mimikyu", "Eevee", "Ditto", "Sableye"},{"What type of Pokemon is Shedinja?", "Bug/Ghost", "Bug/Flying", "Ghost/Fighting", "Bug/Steel", "Ghost/Dragon", "Bug/Poison"},{"Which Pokemon is often considered the 'face' of the Pokemon franchise?", "Pikachu", "Eevee", "Mewtwo", "Charizard", "Jigglypuff", "Snorlax"},{"What is the primary move type for Gym Leader Misty?", "Water", "Electric", "Grass", "Fire", "Rock", "Flying"},{"What is the name of the move that allows a Pokemon to heal itself?", "Recover", "Rest", "Synthesis", "Roost", "Milk Drink", "Healing Wish"},{"What is the only Pokemon that can learn the move 'Sketch'?", "Smeargle", "Ditto", "Mew", "Zorua", "Eevee", "Lurantis"},{"Which Pokemon has the unique ability 'Wonder Guard' that allows it to be immune to all but super-effective moves?", "Shedinja", "Arceus", "Ninjask", "Spiritomb", "Zygarde", "Gardevoir"},{"What is the primary typing of the Pokemon Gardevoir when it first evolves from Ralts?", "Psychic", "Fairy", "Ghost", "Flying", "Steel", "Fighting"},{"In Pokemon battles, what type of move is super effective against Psychic types?", "Dark", "Fighting", "Ghost", "Fairy", "Poison", "Steel"},{"Which item is necessary for a Magneton to evolve into Magnezone?", "Thunder Stone", "Magnet", "Metal Coat", "Trade with a Link Cable", "Electrolyte", "None"},{"What is the maximum number of times a Pokemon can use the move 'Protect' consecutively in a battle before it fails?", "3", "5", "2", "1", "4", "Unlimited"},{"Which Pokemon evolves into Blaziken when it reaches level 36?", "Combusken", "Torchic", "Mudkip", "Sceptile", "Treecko", "Piplup"},{"What move has the highest priority in battle?", "Quick Attack", "Extreme Speed", "Bullet Punch", "Mach Punch", "Sucker Punch", "Fake Out"},{"In Pokemon lore, which Pokemon is known as the 'Guardian of the Sky'?", "Rayquaza", "Ho-Oh", "Lugia", "Zekrom", "Mewtwo", "Celebi"},{"What item can be used to evolve a Sneasel into Weavile?", "Razor Claw", "Ice Stone", "Dusk Stone", "Trade with a Link Cable", "Friendship", "None"},{"Which Pokemon can evolve into two different forms depending on whether it is leveled up during the day or night?", "Eevee", "Sliggoo", "Togepi", "Zangoose", "Umbreon", "Espeon"},{"What move deals damage based on the user's Special Attack and the target's Special Defense, ignoring type effectiveness?", "Foul Play", "Feint Attack", "Psychic", "Weather Ball", "Secret Sword", "Overheat"},{"What is the primary type of the Pokemon Dracovish?", "Water/Ice", "Water/Ground", "Dragon/Ground", "Dragon/Water", "Ice/Rock", "Water/Fighting"},{"Which Pokemon is known for having the highest base Special Attack stat of all non-Mega Evolutions?", "Deoxys (Attack Forme)", "Mega Mewtwo Y", "Rayquaza", "Gardevoir", "Sceptile", "Gengar"},{"What is the effect of the item 'Focus Sash' in battle?", "Prevents a Pokemon from being knocked out in one hit", "Boosts Speed in the rain", "Increases Defense when at half health", "Heals 1/4 of the maximum HP", "Increases critical hit ratio", "Restores status conditions"},{"Which Pokemon is the only one with the ability 'Magic Guard'?", "Alakazam", "Abra", "Gardevoir", "Metagross", "Gothitelle", "Mismagius"},{"What is the hidden ability of the Pokemon Bidoof?", "Simple", "Adaptability", "Frisk", "Pickpocket", "Pressure", "Quick Feet"},{"Which move increases the user's Attack and Special Attack by one stage when used?", "Howl", "Bulk Up", "Swords Dance", "Dragon Dance", "Work Up", "Calm Mind"},{"What is the evolution requirement for a Porygon to become Porygon-Z?", "Use a Dubious Disc", "Trade with a Link Cable", "Use an Upgrade", "Evolve from Porygon2", "Level up in a specific location", "None"},{"What is the name of the move that allows a Pokemon to attack first but fails if the target is not a damaging move?", "Counter", "Protect", "Quick Attack", "Detect", "Fake Out", "Foul Play"},{"Which Pokemon has a base stat total of 540 and is classified as a 'Dragon/Flying' type?", "Dragonite", "Salamence", "Rayquaza", "Altaria", "Garchomp", "Charizard"},{"What item must be held by a Piloswine to evolve into Mamoswine?", "Ice Shard", "Razor Claw", "Thick Club", "Soothe Bell", "None", "Dusk Stone"},{"Which Pokemon is known for the move 'Earthquake' as its signature attack?", "Groudon", "Garchomp", "Excadrill", "Zygarde", "Landorus", "Gardevoir"},{"Which Pokemon has a unique ability called 'Propeller Tail' that negates priority moves?", "Sonic the Hedgehog", "Rillaboom", "Zygarde", "Zarude", "Sliggoo", "Duraludon"},{"What is the primary type of the Pokemon Galarian Weezing?", "Poison/Fairy", "Poison/Ground", "Poison/Steel", "Fairy/Ground", "Fairy/Flying", "Fairy/Dragon"},{"Which Pokemon is known for having the highest base Speed stat among all Pokemon?", "Deoxys (Speed Forme)", "Ninjask", "Electrode", "Regieleki", "Mega Rayquaza", "Crobat"},{"What move does the Pokemon Smeargle learn by default?", "Sketch", "Transform", "Copycat", "Mud-Slap", "Pound", "Tackle"},{"In Pokemon Sword and Shield, which Pokemon is exclusive to the Shield version?", "Galarian Yamask", "Galarian Ponyta", "Galarian Stunfisk", "Mimikyu", "Zacian", "Zamazenta"},{"Which status condition prevents the affected Pokemon from healing, including through moves like Rest?", "Burn", "Poison", "Curse", "Trauma", "Confusion", "Badly Poisoned"},{"What is the only Pokemon that can learn the move 'Roar of Time'?", "Dialga", "Palkia", "Giratina", "Mewtwo", "Rayquaza", "Zekrom"},{"What is the signature move of the Pokemon Decidueye?", "Spirit Shackle", "Leaf Blade", "Razor Leaf", "Shadow Sneak", "Synthesis", "Grass Pledge"},{"Which Pokemon evolves into Milotic?", "Feebas", "Magikarp", "Carvanha", "Psyduck", "Luvdisc", "Swablu"},{"What is the effect of the move 'Parabolic Charge'?", "Restores HP based on damage dealt", "Deals damage and paralyzes", "Increases special attack", "Heals teammates", "Does double damage in rain", "Negates status effects"},{"Which Pokemon has a secondary typing of Fairy that can be obtained by evolving Spritzee?", "Aromatisse", "Slurpuff", "Gardevoir", "Sylveon", "Togekiss", "Granbull"},{"Which item allows Pokemon to evolve without leveling up when traded?", "Link Cable", "Everstone", "Trade Stone", "Dusk Stone", "Sun Stone", "None"},{"In Pokemon lore, what creature is said to have been created by Arceus?", "Dialga", "Giratina", "Palkia", "Mew", "Rayquaza", "Zekrom"},{"What is the only move that has a base power of 0 but can still damage the target if the user has an Ability that activates on hit?", "Feint", "Flail", "Whirlwind", "Transform", "Endure", "Trick"},{"Which Pokemon was initially a Dragon-type but was later reclassified as a Water-type?", "Rayquaza", "Dragapult", "Gyarados", "Salamence", "Charizard", "Lugia"},{"What is the name of the ability that allows a Pokemon to ignore the effects of the battlefield terrain?", "Mold Breaker", "Overcoat", "Magic Guard", "Liquid Ooze", "Trace", "Levitate"},{"In competitive Pokemon battling, what does the term 'stall' refer to?", "A strategy that focuses on wearing down opponents", "A strategy that relies on offensive moves", "A strategy that prioritizes speed", "A strategy focused on critical hits", "A strategy that involves Pokemon switching", "A strategy to finish battles quickly"},{"Which item is required for a Clamperl to evolve into Gorebyss?", "Water Stone", "Deep Sea Tooth", "Deep Sea Scale", "Trade with a Link Cable", "King's Rock", "None"},{"What move deals damage and has a 30% chance to confuse the target?", "Psybeam", "Rock Slide", "Dynamic Punch", "Confusion", "Psychic", "Hex"},{"Which Pokemon's evolution can be influenced by its friendship level?", "Togepi", "Charmander", "Ralts", "Pichu", "Electabuzz", "Murkrow"},{"What is the effect of the item 'Choice Band' in battles?", "Increases the holder's Attack but locks them into one move", "Allows the holder to use items multiple times", "Restores HP each turn", "Increases Speed for three turns", "Boosts critical hit ratio", "Negates entry hazards"},{"Which Pokemon is the first to be introduced with the ability 'Dry Skin'?", "Paras", "Shroomish", "Sewaddle", "Surskit", "Venipede", "Cacturne"},{"What is the evolution requirement for a Galarian Yamask to evolve into Runerigus?", "Faint with 49 or more damage", "Level up in a specific area", "Use a Dusk Stone", "Trade with a Link Cable", "None", "Level up at night"},{"Which Pokemon is known for its ability 'Unburden' that doubles its Speed after consuming an item?", "Sceptile", "Swellow", "Drifblim", "Shaymin", "Togekiss", "Gliscor"},{"What is the base power of the move 'Hyper Beam'?", "150", "120", "130", "140", "160", "110"},{"What is the maximum level that Pokemon can reach?", "100", "50", "200", "150", "75", "90"},{"Which Pokemon is known to evolve into Kingdra?", "Seadra", "Horsea", "Goldeen", "Shellder", "Marill", "Tentacool"},{"Who was the first President of the United States?", "George Washington", "Thomas Jefferson", "Abraham Lincoln", "John Adams", "Franklin D. Roosevelt", "Theodore Roosevelt"},{"Which ancient civilization is known for building pyramids?", "Egyptians", "Greeks", "Romans", "Aztecs", "Mayans", "Babylonians"},{"What was the primary cause of the fall of the Roman Empire?", "Internal strife", "Invasion by barbarians", "Economic decline", "Corruption", "Natural disasters", "Political instability"},{"Who is known for the theory of evolution?", "Charles Darwin", "Albert Einstein", "Isaac Newton", "Galileo Galilei", "Louis Pasteur", "Carl Linnaeus"},{"What was the main goal of the Crusades?", "To reclaim the Holy Land", "To spread Christianity", "To establish trade routes", "To conquer new territories", "To defeat the Byzantine Empire", "To eliminate heresy"},{"Which country was the birthplace of the Renaissance?", "Italy", "France", "Germany", "England", "Spain", "Greece"},{"What document declared the American colonies' independence from Britain?", "Declaration of Independence", "Constitution", "Bill of Rights", "Magna Carta", "Articles of Confederation", "Treaty of Paris"},{"Who was the leader of the Soviet Union during World War II?", "Joseph Stalin", "Vladimir Lenin", "Leon Trotsky", "Nikita Khrushchev", "Mikhail Gorbachev", "Boris Yeltsin"},{"Which movement sought to end racial segregation in the United States?", "Civil Rights Movement", "Women's Suffrage Movement", "Labor Movement", "Progressive Movement", "Abolitionist Movement", "Environmental Movement"},{"What was the primary function of the ancient Silk Road?", "Trade", "Military conquest", "Cultural exchange", "Diplomacy", "Exploration", "Colonization"},{"Which ancient structure is located in Greece and is dedicated to the goddess Athena?", "Parthenon", "Colosseum", "Great Pyramid", "Hanging Gardens", "Acropolis", "Lighthouse of Alexandria"},{"What was the primary goal of the French Revolution?", "Establish a republic", "Defeat the monarchy", "Expand territory", "Reform the church", "End serfdom", "Achieve independence"},{"Who is known for his nonviolent resistance against British rule in India?", "Mahatma Gandhi", "Jawaharlal Nehru", "B.R. Ambedkar", "Subhas Chandra Bose", "Sardar Patel", "Rabindranath Tagore"},{"What was the main purpose of the United Nations when it was founded?", "Promote peace", "Increase trade", "Facilitate colonization", "Enhance military power", "Control resources", "Regulate technology"},{"Which empire was known for its vast territory and cultural diversity, stretching across three continents?", "Ottoman Empire", "Roman Empire", "Mongol Empire", "Byzantine Empire", "British Empire", "Persian Empire"},{"What was the main ideology behind the Cold War?", "Communism vs. Capitalism", "Nationalism vs. Imperialism", "Fascism vs. Democracy", "Socialism vs. Conservatism", "Anarchism vs. Authoritarianism", "Isolationism vs. Interventionism"},{"Who was the first female Prime Minister of the United Kingdom?", "Margaret Thatcher", "Theresa May", "Angela Merkel", "Indira Gandhi", "Golda Meir", "Ellen Johnson Sirleaf"},{"What was the main purpose of the Berlin Wall?", "Separate East and West Berlin", "Control trade routes", "Prevent espionage", "Promote tourism", "Enforce communism", "Establish borders"},{"Which document established the framework for the government of the United States?", "U.S. Constitution", "Bill of Rights", "Declaration of Independence", "Federalist Papers", "Articles of Confederation", "Treaty of Paris"},{"Who is considered the father of modern psychology?", "Sigmund Freud", "Carl Jung", "B.F. Skinner", "William James", "Ivan Pavlov", "Jean Piaget"},{"Which country was involved in the Opium Wars with Britain?", "China", "India", "Japan", "Vietnam", "Korea", "Thailand"},{"What was the main cause of World War I?", "Assassination of Archduke Franz Ferdinand", "Territorial disputes", "Imperial ambitions", "Militarism", "Alliance systems", "Nationalism"},{"Who was the famous civil rights leader who delivered the 'I Have a Dream' speech?", "Martin Luther King Jr.", "Malcolm X", "Rosa Parks", "Frederick Douglass", "Nelson Mandela", "Harriet Tubman"},{"What was the main goal of the Marshall Plan?", "Rebuild Europe", "Support military operations", "Promote democracy", "Establish trade agreements", "Control resources", "Enhance military alliances"},{"Which historical figure is known for his role in the American Revolution and as a Founding Father?", "Benjamin Franklin", "George Washington", "Thomas Jefferson", "John Adams", "Alexander Hamilton", "James Madison"},{"What was the primary purpose of the ancient Greek Olympics?", "Religious festivals", "Military training", "Political gatherings", "Cultural exchange", "Trade agreements", "Diplomatic relations"},{"Who was the last ruler of the Soviet Union?", "Mikhail Gorbachev", "Leonid Brezhnev", "Nikita Khrushchev", "Joseph Stalin", "Vladimir Lenin", "Boris Yeltsin"},{"Which ancient civilization is known for its contributions to mathematics and astronomy?", "Babylonians", "Egyptians", "Greeks", "Romans", "Indians", "Chinese"},{"What was the main result of the Treaty of Versailles?", "End of World War I", "Formation of the League of Nations", "Division of empires", "Establishment of new countries", "Economic sanctions", "Military alliances"},{"Which movement aimed to abolish slavery in the United States?", "Abolitionist Movement", "Civil Rights Movement", "Women's Suffrage Movement", "Labor Movement", "Progressive Movement", "Temperance Movement"},{"What was the main purpose of the Lewis and Clark Expedition?", "Explore the American West", "Map new territories", "Establish trade routes", "Find a Northwest Passage", "Claim land", "Study Native American cultures"},{"Which leader is associated with the unification of Italy?", "Giuseppe Garibaldi", "Count Cavour", "Victor Emmanuel II", "Mussolini", "Machiavelli", "Dante Alighieri"},{"What is the significance of the Magna Carta?", "Limited the power of the king", "Established the church's authority", "Promoted democracy", "Protected trade rights", "Created the parliament", "Ended feudalism"},{"Which war was fought between the North and South regions of the United States?", "American Civil War", "World War I", "World War II", "Vietnam War", "Korean War", "Revolutionary War"},{"Who was the famous German leader during World War II?", "Adolf Hitler", "Wilhelm II", "Otto von Bismarck", "Joseph Goebbels", "Hermann Goring", "Erwin Rommel"},{"What was the primary goal of the suffragette movement?", "Women's right to vote", "Education for women", "Employment rights", "Health care access", "Gender equality", "Property rights"},{"Which ancient civilization is known for its philosophers, such as Socrates and Plato?", "Greeks", "Romans", "Egyptians", "Persians", "Chinese", "Indians"},{"What was the main focus of the Enlightenment?", "Reason and individualism", "Religion", "Tradition", "Authority", "Superstition", "Collectivism"},{"Which event led to the start of the American Revolutionary War?", "Boston Tea Party", "Lexington and Concord", "Boston Massacre", "Signing of the Declaration", "Battle of Bunker Hill", "Formation of Congress"},{"Who is known as the 'Father of India'?", "Mahatma Gandhi", "Jawaharlal Nehru", "B.R. Ambedkar", "Subhas Chandra Bose", "Sardar Patel", "Rabindranath Tagore"},{"What was the primary result of the Industrial Revolution?", "Urbanization", "Rural development", "Feudalism", "Colonial expansion", "Military advancements", "Cultural stagnation"},{"Who was the famous British Prime Minister during World War II?", "Winston Churchill", "Neville Chamberlain", "Clement Attlee", "Tony Blair", "David Cameron", "Margaret Thatcher"},{"What was the purpose of the Spanish Inquisition?", "Religious conformity", "Economic control", "Political power", "Military expansion", "Colonization", "Social order"},{"Which ancient civilization is known for its city-states and democracy?", "Greeks", "Romans", "Egyptians", "Sumerians", "Minoans", "Phoenicians"},{"What was the main consequence of the American Civil War?", "End of slavery", "Expansion of territory", "Economic growth", "Political stability", "Reconstruction", "Native American conflicts"},{"Who was the first woman to fly solo across the Atlantic Ocean?", "Amelia Earhart", "Bessie Coleman", "Harriet Quimby", "Jacqueline Cochran", "Eleanor Roosevelt", "Marie Curie"},{"What was the main focus of the Harlem Renaissance?", "African American culture", "European art", "Scientific advancement", "Political activism", "Industrial growth", "Religious revival"},{"Which treaty ended World War I?", "Treaty of Versailles", "Treaty of Paris", "Treaty of Ghent", "Treaty of Trianon", "Treaty of Utrecht", "Treaty of Versailles"},{"What was the main objective of the Reformation?", "Religious reform", "Political power", "Economic gain", "Cultural revival", "Colonial expansion", "Social justice"},{"What was the main goal of the Crusades initiated by the Catholic Church in the late 11th century?", "To reclaim the Holy Land", "To spread Christianity", "To conquer Jerusalem", "To establish trade routes", "To defeat the Ottoman Empire"},{"What ancient civilization is known for creating one of the earliest forms of writing, cuneiform?", "Sumerians", "Egyptians", "Indus Valley", "Phoenicians", "Babylonians", "Minoans"},{"Which empire was known for its vast network of roads, known as the Royal Road?", "Persian Empire", "Roman Empire", "Mongol Empire", "Ottoman Empire", "Byzantine Empire", "Carolingian Empire"},{"Who was the famous Carthaginian general who crossed the Alps to invade Italy during the Second Punic War?", "Hannibal", "Scipio", "Cato", "Marius", "Augustus", "Julius Caesar"},{"What was the primary cause of the fall of the Western Roman Empire?", "Barbarian invasions", "Economic troubles", "Political corruption", "Plague", "Civil wars", "Religious conflicts"},{"Which ancient civilization built the pyramids at Giza?", "Egyptians", "Mayans", "Greeks", "Romans", "Phoenicians", "Sumerians"},{"In which region did the Renaissance begin?", "Italy", "France", "Germany", "Spain", "England", "Netherlands"},{"Who is credited with formulating the heliocentric theory of the solar system?", "Copernicus", "Galileo", "Kepler", "Newton", "Ptolemy", "Aristotle"},{"Which war was fought between the North and South regions of the United States from 1861 to 1865?", "American Civil War", "Revolutionary War", "War of 1812", "Spanish-American War", "Mexican-American War", "World War I"},{"What was the name of the political and social system in medieval Europe characterized by the exchange of land for service?", "Feudalism", "Socialism", "Capitalism", "Monarchy", "Communism", "Meritocracy"},{"Which document, signed in 1215, limited the powers of the English king?", "Magna Carta", "Bill of Rights", "Habeas Corpus", "Declaration of Independence", "Constitution", "Treaty of Versailles"},{"Who was the first emperor of a unified China?", "Qin Shi Huang", "Kublai Khan", "Sun Yat-sen", "Mao Zedong", "Li Yuan", "Wudi"},{"What major global event was triggered by the assassination of Archduke Franz Ferdinand in 1914?", "World War I", "World War II", "The Great Depression", "Cold War", "Vietnam War", "Korean War"},{"What empire is known for its trade routes connecting Asia and Europe, often referred to as the Silk Road?", "Mongol Empire", "Ottoman Empire", "Roman Empire", "Byzantine Empire", "Persian Empire", "Chinese Empire"},{"Which famous document was signed in 1776, declaring the thirteen American colonies independent from British rule?", "Declaration of Independence", "Constitution", "Bill of Rights", "Magna Carta", "Treaty of Paris", "Federalist Papers"},{"Which ancient culture is known for its advanced knowledge of mathematics and astronomy, including the Mayan calendar?", "Maya", "Inca", "Aztec", "Babylonian", "Sumerian", "Egyptian"},{"What was the primary material used by the ancient Egyptians for making their hieroglyphic writing?", "Papyrus", "Stone", "Clay tablets", "Wood", "Leather", "Silk"},{"Who was the famous leader of the Mongol Empire known for uniting the Mongol tribes?", "Genghis Khan", "Kublai Khan", "Tamerlane", "Batu Khan", "Ogedei Khan", "Boris Godunov"},{"What major event marked the end of the Middle Ages and the beginning of the Renaissance?", "Fall of Constantinople", "Signing of the Magna Carta", "Discovery of America", "Plague", "Hundred Years' War", "Great Schism"},{"Which empire is known for its contributions to mathematics, including the concept of zero and the decimal system?", "Gupta Empire", "Mughal Empire", "Ottoman Empire", "Ming Dynasty", "Roman Empire", "Byzantine Empire"},{"What was the primary goal of the Crusades launched by European Christians in the 11th to 13th centuries?", "Recapture the Holy Land", "Expand territory", "Convert Muslims", "Establish trade routes", "Defend against Mongols", "Strengthen feudalism"},{"Which revolutionary leader is known for his role in the Haitian Revolution and the establishment of Haiti as a free state?", "Toussaint L'Ouverture", "Simon Bolivar", "Emiliano Zapata", "Che Guevara", "Jose de San Martin", "Julius Caesar"},{"What was the main reason for the decline of the Ottoman Empire in the 19th century?", "Nationalism", "Economic difficulties", "World War I", "Colonialism", "Military defeats", "Religious conflicts"},{"Who is known as the father of modern physics and formulated the laws of motion and universal gravitation?", "Isaac Newton", "Albert Einstein", "Galileo Galilei", "Niels Bohr", "Max Planck", "Stephen Hawking"},{"Which country was the first to grant women the right to vote in 1893?", "New Zealand", "United States", "Finland", "Australia", "Canada", "Sweden"},{"What event began on July 14, 1789, and is considered the start of the French Revolution?", "Storming of the Bastille", "Execution of Louis XVI", "Estates-General", "Reign of Terror", "Napoleon's rise", "Declaration of Rights of Man"},{"Which ancient civilization is credited with the invention of the arch and dome in architecture?", "Romans", "Greeks", "Babylonians", "Indus Valley", "Egyptians", "Minoans"},{"Who was the first female pharaoh of ancient Egypt?", "Hatshepsut", "Cleopatra", "Nefertiti", "Nefertari", "Maatkare", "Merneith"},{"What was the primary cause of the fall of the Byzantine Empire?", "Ottoman conquest", "Crusades", "Plague", "Economic decline", "Civil strife", "Religious division"},{"Which famous battle in 1066 marked the beginning of Norman rule in England?", "Battle of Hastings", "Battle of Agincourt", "Battle of Bosworth Field", "Battle of Waterloo", "Battle of Trafalgar", "Battle of Stamford Bridge"},{"What was the main cultural and political center of the ancient Maya civilization?", "Tikal", "Chichen Itza", "Copan", "Palenque", "Uxmal", "Calakmul"},{"Which treaty ended the Thirty Years' War in 1648 and established the principle of state sovereignty?", "Peace of Westphalia", "Treaty of Versailles", "Treaty of Utrecht", "Treaty of Paris", "Treaty of Ryswick", "Treaty of Amiens"},{"Which major event occurred on December 7, 1941, leading to the United States' entry into World War II?", "Attack on Pearl Harbor", "D-Day", "Battle of Midway", "Battle of Stalingrad", "Hiroshima bombing", "Nagasaki bombing"},{"What ancient structure was built as a tomb for Pharaoh Khufu?", "Great Pyramid of Giza", "Hanging Gardens", "Great Wall of China", "Machu Picchu", "Stonehenge", "Colosseum"},{"What is the name of the series of conflicts between England and France from 1337 to 1453?", "Hundred Years' War", "Thirty Years' War", "War of Roses", "Crusades", "Napoleonic Wars", "Franco-Prussian War"},{"Which revolutionary document established the principles of liberty and equality in France?", "Declaration of the Rights of Man and Citizen", "Magna Carta", "U.S. Constitution", "Bill of Rights", "Communist Manifesto", "Napoleonic Code"},{"What was the primary purpose of the Great Wall of China?", "Defense against invasions", "Trade routes", "Symbol of power", "Agriculture", "Religion", "Cultural exchange"},{"Who was the leader of the Soviet Union during World War II?", "Joseph Stalin", "Leon Trotsky", "Vladimir Lenin", "Nikita Khrushchev", "Mikhail Gorbachev", "Boris Yeltsin"},{"What was the name of the period of cultural flourishing in Europe during the 14th to 17th centuries?", "Renaissance", "Enlightenment", "Industrial Revolution", "Baroque", "Romanticism", "Modernism"},{"Which famous civilization is known for its complex city-states and development of writing and mathematics?", "Sumerians", "Egyptians", "Greeks", "Romans", "Minoans", "Phoenicians"},{"What event is marked by the fall of the Berlin Wall in 1989?", "End of the Cold War", "Fall of communism", "Reunification of Germany", "U.S. invasion of Iraq", "European integration", "Rise of the EU"},{"Who was the famous Egyptian queen known for her relationships with Julius Caesar and Mark Antony?", "Cleopatra", "Nefertiti", "Hatshepsut", "Merneith", "Sethi", "Ramses II"},{"Which ancient civilization developed the first known legal code, known as the Code of Hammurabi?", "Babylonian", "Egyptian", "Assyrian", "Phoenician", "Sumerian", "Hittite"},{"What was the primary cause of the Opium Wars between China and Britain in the 19th century?", "Trade imbalance", "Territorial expansion", "Cultural differences", "Religious conflict", "Industrial competition", "Narcotics policy"},{"Which European explorer is credited with being the first to circumnavigate the globe?", "Ferdinand Magellan", "Christopher Columbus", "Vasco da Gama", "Hernan Cortes", "James Cook", "Marco Polo"},{"What major historical event took place in 1963, resulting in the assassination of U.S. President John F. Kennedy?", "Assassination of JFK", "Civil Rights Movement", "Cuban Missile Crisis", "Vietnam War", "Space Race", "Watergate Scandal"},{"What was the name of the ancient trade route that connected China with the Mediterranean?", "Silk Road", "Spice Route", "Incense Route", "Amber Road", "Trans-Saharan Route", "Royal Road"},{"What was the significant outcome of the Treaty of Versailles in 1919?", "End of World War I", "Start of World War II", "Creation of the League of Nations", "German reparations", "Dissolution of the Ottoman Empire", "Rise of communism"},{"Which empire is known for its advanced irrigation systems and urban planning in the Indus Valley?", "Indus Valley Civilization", "Sumerians", "Minoans", "Phoenicians", "Egyptians", "Babylonians"},{"Which civilization is credited with the invention of paper and gunpowder?", "Chinese Civilization", "Mesopotamian Civilization", "Roman Civilization", "Indus Valley Civilization", "Mesoamerican Civilization", "Egyptian Civilization"},{"What was the main goal of the Marshall Plan initiated after World War II?", "Rebuild European economies", "Establish NATO", "Prevent communism", "Support decolonization", "Promote globalization", "Create the EU"},{"In what year did the Declaration of Independence get signed?", "1776", "1789", "1765", "1812", "1754", "1801"},{"When did World War I begin?", "1914", "1918", "1939", "1912", "1920", "1905"},{"What year did the Berlin Wall fall?", "1989", "1991", "1975", "1985", "1995", "2000"},{"In which year was the U.S. Constitution ratified?", "1788", "1776", "1791", "1801", "1812", "1789"},{"What year did the American Civil War start?", "1861", "1865", "1850", "1876", "1860", "1880"},{"When was the first manned moon landing?", "1969", "1972", "1965", "1970", "1959", "1980"},{"In which year did the Titanic sink?", "1912", "1905", "1915", "1900", "1920", "1898"},{"What year did the French Revolution begin?", "1789", "1776", "1792", "1804", "1750", "1815"},{"When was the Treaty of Versailles signed?", "1919", "1920", "1914", "1930", "1905", "1918"},{"In what year did the stock market crash, leading to the Great Depression?", "1929", "1931", "1927", "1935", "1941", "1925"},{"When did the Soviet Union collapse?", "1991", "1989", "1990", "1995", "1985", "2000"},{"What year was the first atomic bomb dropped on Hiroshima?", "1945", "1946", "1944", "1939", "1950", "1943"},{"In which year did the U.S. enter World War II?", "1941", "1939", "1944", "1940", "1942", "1937"},{"What year was the Emancipation Proclamation issued?", "1863", "1865", "1861", "1850", "1870", "1880"},{"When was the first female vote in the U.S.?", "1920", "1918", "1930", "1940", "1950", "1965"},{"In what year did Christopher Columbus first arrive in the Americas?", "1492", "1498", "1500", "1485", "1510", "1470"},{"What year did the Korean War begin?", "1950", "1955", "1945", "1949", "1960", "1953"},{"When was the first Olympic Games held in modern history?", "1896", "1900", "1888", "1924", "1936", "1948"},{"What year did the Magna Carta get signed?", "1215", "1199", "1225", "1250", "1300", "1400"},{"In which year did Martin Luther King Jr. deliver his 'I Have a Dream' speech?", "1963", "1965", "1960", "1970", "1955", "1975"},{"When did the U.S. land on the moon?", "1969", "1971", "1973", "1965", "1975", "1963"},{"What year did the first World War officially end?", "1918", "1919", "1920", "1921", "1922", "1914"},{"When was the Great Wall of China primarily built?", "Ming Dynasty (1368–1644)", "Qin Dynasty (221–206 BC)", "Han Dynasty (206 BC–220 AD)", "Tang Dynasty (618–907)", "Song Dynasty (960–1279)", "Yuan Dynasty (1271–1368)"},{"What year did the Cuban Missile Crisis occur?", "1962", "1961", "1963", "1960", "1959", "1965"},{"In which year was the U.S. Bill of Rights ratified?", "1791", "1789", "1800", "1787", "1793", "1795"},{"What year did the Vietnam War officially end?", "1975", "1973", "1968", "1980", "1970", "1985"},{"When was the first successful powered flight by the Wright brothers?", "1903", "1905", "1899", "1910", "1912", "1907"},{"What year did the Persian Gulf War begin?", "1990", "1989", "1991", "1992", "1988", "1995"},{"In which year did the Boston Tea Party take place?", "1773", "1776", "1781", "1789", "1775", "1772"},{"When was the first manned spaceflight?", "1961", "1960", "1963", "1965", "1957", "1959"},{"What year did the United States adopt its Constitution?", "1788", "1776", "1791", "1789", "1801", "1803"},{"In which year did the attack on Pearl Harbor occur?", "1941", "1939", "1945", "1942", "1937", "1940"},{"What year was the first human organ transplant performed?", "1954", "1960", "1970", "1980", "1990", "1945"},{"When did the first successful heart transplant occur?", "1967", "1965", "1972", "1960", "1975", "1980"},{"In what year did the War of 1812 start?", "1812", "1810", "1814", "1816", "1808", "1820"},{"What year was the first nuclear power plant built?", "1954", "1960", "1958", "1950", "1945", "1965"},{"When was the first email sent?", "1971", "1980", "1965", "1990", "1975", "1985"},{"What year was the Space Shuttle program launched?", "1981", "1979", "1985", "1980", "1990", "1983"},{"In which year did the first man walk in space?", "1965", "1961", "1963", "1967", "1969", "1970"},{"What year did the United Nations form?", "1945", "1940", "1950", "1960", "1939", "1948"},{"When did the Great Fire of London occur?", "1666", "1665", "1670", "1650", "1680", "1700"},{"What year was the first atomic bomb tested?", "1945", "1940", "1950", "1939", "1949", "1942"},{"When was the first episode of 'The Simpsons' aired?", "1989", "1990", "1988", "1992", "1995", "1987"},{"In what year did the first man land on the moon?", "1969", "1970", "1965", "1960", "1975", "1972"},{"What year did the Berlin Wall begin construction?", "1961", "1959", "1965", "1960", "1962", "1970"},{"When did the first successful polio vaccine get developed?", "1955", "1945", "1960", "1965", "1950", "1970"},{"What year was the Magna Carta signed?", "1215", "1210", "1250", "1190", "1300", "1220"},{"In which year did the Gulf War begin?", "1990", "1991", "1989", "1988", "1995", "1993"},{"When did the American Revolutionary War officially end?", "1783", "1781", "1776", "1790", "1785", "1793"},{"In which year did the American Civil War begin?", "1861", "1776", "1812", "1941", "1865"},{"In which year did World War I officially begin?", "1914", "1912", "1918", "1916", "1910", "1915"},{"What year was the Treaty of Versailles signed, marking the end of World War I?", "1919", "1920", "1918", "1916", "1921", "1917"},{"When did the American Civil War start?", "1861", "1865", "1855", "1860", "1870", "1880"},{"In what year did the Berlin Wall fall?", "1989", "1991", "1987", "1990", "1985", "1988"},{"Which year marks the beginning of World War II?", "1939", "1938", "1941", "1945", "1940", "1937"},{"What year did India gain independence from British rule?", "1947", "1945", "1950", "1942", "1939", "1952"},{"When was the assassination of Archduke Franz Ferdinand, an event that triggered World War I?", "1914", "1913", "1915", "1916", "1912", "1918"},{"What year did the Japanese attack Pearl Harbor, leading the U.S. to enter World War II?", "1941", "1940", "1942", "1939", "1938", "1943"},{"In what year was the first manned moon landing by Apollo 11?", "1969", "1970", "1968", "1971", "1965", "1967"},{"What year did the Soviet Union officially dissolve?", "1991", "1990", "1993", "1989", "1992", "1994"},{"When did the French Revolution begin?", "1789", "1785", "1792", "1776", "1794", "1800"},{"In which year was the United Nations founded?", "1945", "1948", "1939", "1950", "1947", "1960"},{"What year did the first atomic bomb drop on Hiroshima?", "1945", "1944", "1946", "1943", "1947", "1948"},{"Which year did the stock market crash, leading to the Great Depression?", "1929", "1931", "1928", "1930", "1932", "1933"},{"When did Martin Luther King Jr. deliver his 'I Have a Dream' speech?", "1963", "1965", "1968", "1960", "1970", "1962"},{"What year did the U.S. sign the Treaty of Guadalupe Hidalgo, ending the Mexican-American War?", "1848", "1850", "1846", "1845", "1853", "1854"},{"In what year was the Great Wall of China completed?", "1644", "1550", "1700", "1200", "1300", "1800"},{"When did the Chernobyl disaster occur?", "1986", "1989", "1984", "1985", "1983", "1987"},{"What year did the Cold War officially begin?", "1947", "1945", "1950", "1953", "1960", "1965"},{"When did the Rwandan Genocide take place?", "1994", "1990", "1996", "1992", "1995", "1993"},{"In what year was the Magna Carta signed?", "1215", "1210", "1220", "1199", "1300", "1250"},{"What year was the first successful heart transplant performed?", "1967", "1968", "1970", "1965", "1975", "1980"},{"When was the Treaty of Paris signed, officially ending the American Revolutionary War?", "1783", "1781", "1784", "1785", "1780", "1790"},{"What year did the South African apartheid officially end?", "1994", "1990", "1985", "1989", "1992", "1991"},{"When did the Vietnam War officially end?", "1975", "1973", "1968", "1980", "1970", "1974"},{"In what year did the first Gulf War begin?", "1990", "1991", "1989", "1993", "1992", "1988"},{"What year did the Suez Crisis occur?", "1956", "1955", "1954", "1953", "1958", "1960"},{"When was the first successful vaccine for smallpox developed?", "1796", "1800", "1750", "1820", "1780", "1776"},{"What year did the Treaty of Tordesillas divide the New World between Spain and Portugal?", "1494", "1492", "1500", "1501", "1485", "1503"},{"In which year did the Berlin Conference take place, leading to the 'Scramble for Africa'?", "1884", "1885", "1890", "1895", "1900", "1882"},{"What year did the Korean War begin?", "1950", "1951", "1949", "1945", "1946", "1953"},{"When did the first modern Olympics take place?", "1896", "1900", "1894", "1888", "1904", "1908"},{"In what year did the first human spaceflight occur?", "1961", "1960", "1965", "1963", "1959", "1962"},{"What year did the United States enter World War I?", "1917", "1916", "1915", "1918", "1919", "1914"},{"When did the Great Fire of London occur?", "1666", "1665", "1670", "1680", "1650", "1700"},{"What year was the first edition of 'The Communist Manifesto' published?", "1848", "1850", "1846", "1855", "1839", "1854"},{"When did the Spanish Civil War take place?", "1936", "1939", "1937", "1940", "1935", "1945"},{"In what year did the first President of the United States take office?", "1789", "1776", "1790", "1800", "1787", "1785"},{"When was the U.S. Constitution ratified?", "1788", "1787", "1789", "1790", "1791", "1792"},{"What year did the Apollo 13 mission experience a critical failure?", "1970", "1969", "1972", "1971", "1968", "1973"},{"In which year did the Haitian Revolution begin?", "1791", "1789", "1795", "1800", "1804", "1793"},{"When was the first written record of the Code of Hammurabi created?", "c. 1754 BC", "c. 1800 BC", "c. 1600 BC", "c. 1500 BC", "c. 1700 BC", "c. 1900 BC"},{"What year did the United States purchase Alaska from Russia?", "1867", "1857", "1870", "1880", "1890", "1895"},{"When was the first nuclear bomb test conducted by the United States?", "1945", "1946", "1942", "1943", "1944", "1950"},{"What year did the British Raj begin in India?", "1858", "1848", "1876", "1885", "1900", "1820"},{"When did the Khmer Rouge begin its reign in Cambodia?", "1975", "1973", "1970", "1976", "1972", "1980"},{"In what year did the U.S. Congress pass the Civil Rights Act?", "1964", "1965", "1963", "1968", "1960", "1962"},{"What year did the Great Depression officially begin?", "1929", "1930", "1928", "1931", "1932", "1935"},{"When was the Battle of Gettysburg fought?", "1863", "1861", "1865", "1864", "1860", "1850"},{"What year did the Russian Revolution occur, leading to the rise of the Soviet Union?", "1917", "1918", "1914", "1920", "1916", "1915"},{"Who invented the  printing press?", "Johannes Gutenberg", "Thomas Edison", "Alexander Graham Bell", "Isaac Newton", "Leonardo da Vinci", "Henry Ford"},{"What year was the first successful airplane flight?", "1903", "1905", "1896", "1910", "1915", "1920"},{"Which invention is Thomas Edison famous for?", "Light bulb", "Telephone", "Television", "Steam engine", "Phonograph", "Battery"},{"What was the first programmable computer called?", "Z3", "ENIAC", "Colossus", "UNIVAC", "IBM 701", "Apple I"},{"In what year was the first atomic bomb tested?", "1945", "1940", "1950", "1939", "1944", "1949"},{"Who is credited with inventing the telephone?", "Alexander Graham Bell", "Gustavus Swift", "Thomas Edison", "Elisha Gray", "Nikola Tesla", "Henry Ford"},{"What year was the first successful heart transplant performed?", "1967", "1954", "1970", "1980", "1965", "1975"},{"Which ancient civilization is credited with inventing the wheel?", "Sumerians", "Egyptians", "Greeks", "Romans", "Indians", "Chinese"},{"What invention is James Watt known for improving?", "Steam engine", "Printing press", "Cotton gin", "Electric motor", "Telegraph", "Refrigerator"},{"In what year was the Internet publicly launched?", "1991", "1985", "1995", "2000", "1993", "1988"},{"Who invented the first practical automobile?", "Karl Benz", "Henry Ford", "Gottlieb Daimler", "Nikola Tesla", "Ransom Olds", "Edwin Drake"},{"What year was the first email sent?", "1971", "1965", "1980", "1985", "1990", "1975"},{"Which invention is attributed to Nikola Tesla?", "Alternating current", "Direct current", "Television", "Radio", "Battery", "Telephone"},{"In what year was the first artificial heart implanted?", "1982", "1970", "1990", "1980", "1965", "1975"},{"Who is credited with inventing the light bulb?", "Thomas Edison", "Nikola Tesla", "Alexander Graham Bell", "Michael Faraday", "Hedy Lamarr", "Benjamin Franklin"},{"What year was the first television broadcast?", "1928", "1930", "1940", "1950", "1925", "1935"},{"Which invention did Marie Curie contribute to?", "Radioactivity", "X-ray machine", "Telegraph", "Insulin", "Vaccination", "Antibiotics"},{"What year did the Wright brothers achieve the first powered flight?", "1903", "1905", "1910", "1896", "1915", "1920"},{"Who developed the polio vaccine?", "Jonas Salk", "Albert Sabin", "Edward Jenner", "Louis Pasteur", "Robert Koch", "Paul Ehrlich"},{"In what year was the first successful use of insulin to treat diabetes?", "1922", "1920", "1930", "1940", "1950", "1960"},{"Which invention is credited to Robert Fulton?", "Steamboat", "Submarine", "Airplane", "Television", "Bicycle", "Automobile"},{"What year did the first human organ transplant occur?", "1954", "1960", "1970", "1980", "1990", "1945"},{"Who invented the safety pin?", "Walter Hunt", "Elias Howe", "Thomas Edison", "Alexander Graham Bell", "Isaac Singer", "James Spangler"},{"What year was the first smartphone released?", "1992", "2000", "1995", "1998", "1985", "2005"},{"Who is known for developing the first successful vaccine for rabies?", "Louis Pasteur", "Edward Jenner", "Robert Koch", "Jonas Salk", "Albert Sabin", "Hedy Lamarr"},{"What invention is Eli Whitney known for?", "Cotton gin", "Telegraph", "Refrigerator", "Steam engine", "Light bulb", "Typewriter"},{"In what year was the first email sent?", "1971", "1985", "1990", "1965", "1980", "1975"},{"Which invention allowed for mass production of goods?", "Assembly line", "Steam engine", "Printing press", "Cotton gin", "Telegraph", "Electric motor"},{"What year was the first successful cloning of a mammal, Dolly the sheep?", "1996", "1995", "1997", "1998", "1990", "2000"},{"Who invented the first mechanical computer?", "Charles Babbage", "Alan Turing", "John von Neumann", "Ada Lovelace", "Hermann Hollerith", "Konrad Zuse"},{"What year was the first rocket to reach space?", "1944", "1957", "1961", "1969", "1975", "1980"},{"Who invented the first successful light bulb?", "Thomas Edison", "Joseph Swan", "Nikola Tesla", "Alexander Graham Bell", "Michael Faraday", "Heinrich Hertz"},{"What year was the first electric car built?", "1828", "1900", "1910", "1920", "1930", "1940"},{"In what year did Alexander Graham Bell make his first successful phone call?", "1876", "1870", "1880", "1890", "1865", "1900"},{"Who invented the first mechanical typewriter?", "Christopher Latham Sholes", "Elias Howe", "Isaac Singer", "Thomas Edison", "Alexander Graham Bell", "Samuel Morse"},{"What year did the first mobile phone call take place?", "1973", "1980", "1965", "1970", "1990", "1995"},{"Which invention is attributed to Tim Berners-Lee?", "World Wide Web", "Email", "Computer", "Smartphone", "HTML", "Internet"},{"What year was the first electric light bulb patented?", "1879", "1865", "1885", "1900", "1890", "1920"},{"Who invented the first successful heart-lung machine?", "John Gibbon", "Michael DeBakey", "Christiaan Barnard", "Thomas Starzl", "Norman Shumway", "Paul Zoll"},{"In what year was the first space shuttle launched?", "1981", "1975", "1980", "1990", "1985", "1995"},{"Which invention is Henry Ford famous for?", "Assembly line", "Television", "Light bulb", "Telephone", "Refrigerator", "Airplane"},{"What year did the first successful vaccine for smallpox get developed?", "1796", "1800", "1780", "1820", "1850", "1900"},{"Who invented the first successful digital computer?", "ENIAC", "Z3", "IBM PC", "Colossus", "Apple I", "UNIVAC"},{"What year was the first laser invented?", "1960", "1950", "1945", "1975", "1965", "1972"},{"In what year was the first credit card issued?", "1950", "1940", "1960", "1935", "1975", "1985"},{"Who invented the microwave oven?", "Percy Spencer", "Albert Einstein", "Nikola Tesla", "Thomas Edison", "George Washington Carver", "Michael Faraday"},{"What year was the first electric car produced?", "1828", "1900", "1910", "1920", "1930", "1940"},{"When was the first successful commercial jetliner, the Boeing 707, introduced?", "1958", "1960", "1955", "1965", "1945", "1970"},{"Who is known for inventing the phonograph?", "Thomas Edison", "Graham Bell", "Emile Berliner", "Elisha Gray", "Alexander Graham Bell", "Nikola Tesla"},{"What year was the first 3D  printer created?", "1984", "1990", "1995", "2000", "1975", "2005"},{"Who invented the telephone in 1876?", "Alexander Graham Bell", "Thomas Edison", "Guglielmo Marconi", "Nikola Tesla", "Elisha Gray", "Henry Ford"},{"Which inventor is credited with developing the first practical steam engine?", "James Watt", "George Stephenson", "Richard Trevithick", "Thomas Newcomen", "Eli Whitney", "Henry Bessemer"},{"Who is known for inventing the light bulb?", "Thomas Edison", "Nikola Tesla", "Michael Faraday", "Benjamin Franklin", "Alexander Graham Bell", "Hedy Lamarr"},{"What device did Johannes Gutenberg invent in the 15th century that revolutionized  printing?", "Printing press", "Typewriter", "Photocopier", "Telegraph", "Loom", "Camera"},{"Who invented the first successful airplane?", "Orville and Wilbur Wright", "Charles Lindbergh", "Glenn Curtiss", "Amelia Earhart", "Leonardo da Vinci", "Howard Hughes"},{"Which inventor is known for the development of the phonograph?", "Thomas Edison", "Graham Bell", "Emile Berliner", "Nikola Tesla", "Charles Babbage", "Herman Hollerith"},{"Who invented the cotton gin in 1793?", "Eli Whitney", "Isaac Singer", "George Washington Carver", "Henry Ford", "John Deere", "Andrew Carnegie"},{"Which scientist invented the first vaccine for smallpox?", "Edward Jenner", "Louis Pasteur", "Joseph Lister", "Robert Koch", "Alexander Fleming", "Paul Ehrlich"},{"Who is credited with inventing the first practical refrigerator?", "Carl von Linde", "Gustav Magnus", "William Cullen", "Alexander Cummings", "Thomas Midgley", "James Harrison"},{"What invention is Thomas Edison also known for developing alongside the light bulb?", "Phonograph", "Television", "Electric car", "Telegraph", "Radio", "Computer"},{"Who developed the theory of evolution and also contributed to the invention of the modern scientific method?", "Charles Darwin", "Albert Einstein", "Isaac Newton", "Galileo Galilei", "Louis Pasteur", "Thomas Edison"},{"Which inventor is associated with the development of the assembly line for automobile manufacturing?", "Henry Ford", "Walter Chrysler", "Karl Benz", "Ransom Olds", "Giovanni Agnelli", "Louis Renault"},{"Who invented the first practical air conditioner in 1902?", "Willis Carrier", "Albert Einstein", "Nikola Tesla", "Hermann Hesse", "Wernher von Braun", "Thomas Edison"},{"What invention did Nikola Tesla create that laid the foundation for modern electricity transmission?", "Alternating current", "Direct current", "Radio", "Television", "X-ray", "Laser"},{"Who invented the first successful vaccine for rabies?", "Louis Pasteur", "Edward Jenner", "Joseph Lister", "Robert Koch", "Alexander Fleming", "Paul Ehrlich"},{"Which inventor is known for the development of the mechanical calculator in the 17th century?", "Blaise Pascal", "Charles Babbage", "Ada Lovelace", "John von Neumann", "Alan Turing", "Herman Hollerith"},{"Who is credited with inventing the first successful practical sewing machine?", "Elias Howe", "Isaac Singer", "Walter Hunt", "James W. Marshall", "Thomas Edison", "William W. Judson"},{"What invention is attributed to Louis Pasteur that significantly impacted food safety?", "Pasteurization", "Vaccination", "Sterilization", "Fermentation", "Distillation", "Homogenization"},{"Who invented the first true electronic computer, known as the ENIAC?", "John W. Mauchly", "Alan Turing", "Charles Babbage", "Konrad Zuse", "John von Neumann", "Bill Gates"},{"What device did Alexander Graham Bell invent that revolutionized long-distance communication?", "Telephone", "Telegraph", "Television", "Radio", "Cell phone", "Satellite"},{"Who is known for inventing the first practical typewriter in 1868?", "Christopher Latham Sholes", "Elias Howe", "Isaac Singer", "Thomas Edison", "Henry Mill", "James Densmore"},{"What invention did Tim Berners-Lee create that transformed the internet?", "World Wide Web", "Email", "Search engine", "Firewall", "Router", "Ethernet"},{"Who invented the first commercially successful airplane?", "The Wright Brothers", "Charles Lindbergh", "Glenn Curtiss", "Amelia Earhart", "Howard Hughes", "Boeing"},{"Which inventor is known for developing the modern bicycle in the 19th century?", "John Kemp Starley", "Baron von Drais", "Henry J. Lawson", "Albert A. Pope", "Thomas B. Jeffery", "James Starley"},{"Who is credited with the invention of the first practical scuba diving equipment?", "Jacques Cousteau", "William Beebe", "Hans Hass", "G. W. H. Johnson", "Gottlieb Daimler", "John H. Haldane"},{"What invention did John Logie Baird demonstrate in 1926?", "Television", "Radio", "Telegraph", "Telephone", "Computer", "Phonograph"},{"Who invented the first electric battery?", "Alessandro Volta", "Benjamin Franklin", "Michael Faraday", "Thomas Edison", "Nikola Tesla", "William Grove"},{"Which scientist is known for inventing the first practical automobile powered by an internal combustion engine?", "Karl Benz", "Henry Ford", "Gottlieb Daimler", "Wilhelm Maybach", "Enzo Ferrari", "Henry M. Leland"},{"Who is known for creating the first functional artificial heart?", "Paul Winchell", "Robert Jarvik", "Michael DeBakey", "Christiaan Barnard", "Adrian Kantrowitz", "C. Walton Lillehei"},{"What invention is Alexander Graham Bell most famous for?", "Telephone", "Telegraph", "Television", "Phonograph", "Air conditioner", "Electric car"},{"Who invented the first mechanical computer, known as the Analytical Engine?", "Charles Babbage", "Ada Lovelace", "Alan Turing", "John von Neumann", "Herman Hollerith", "Nikola Tesla"},{"Which inventor is known for creating the first successful model of the modern light bulb?", "Thomas Edison", "Nikola Tesla", "Joseph Swan", "Hedy Lamarr", "George Westinghouse", "Alexander Bell"},{"Who invented the first successful parachute?", "Louis-Sebastien Lenormand", "Leonardo da Vinci", "Andre-Jacques Garnerin", "George Pullman", "Otto Lilienthal", "William H. Macy"},{"What was the primary invention of Eli Whitney that transformed the cotton industry?", "Cotton gin", "Mechanical reaper", "Seed drill", "Spinning jenny", "Power loom", "Wool carder"},{"Who is known for creating the first practical electric car?", "Thomas Parker", "Henry Ford", "Nikola Tesla", "Carl Benz", "William Morrison", "Ransom E. Olds"},{"Which inventor created the first practical video camera?", "Willis H. Carrier", "John Logie Baird", "Philo Farnsworth", "Thomas Edison", "Konrad Zuse", "Gordon Moore"},{"What major invention did Frank Whittle develop during World War II?", "Jet engine", "Rocket engine", "Turboprop engine", "Internal combustion engine", "Helicopter", "Gas turbine"},{"Who is credited with inventing the first successful insulin treatment for diabetes?", "Frederick Banting", "J.J. Thomson", "Paul Langerhans", "Charles Best", "Robert H. Grubbs", "Wilhelm Röntgen"},{"What invention is attributed to Thomas Edison that greatly improved communication?", "Phonograph", "Television", "Radio", "Telegraph", "Telephone", "Intercom"},{"Who invented the first modern electric motor?", "Michael Faraday", "Nikola Tesla", "Thomas Edison", "Joseph Henry", "James Clerk Maxwell", "Samuel Morse"},{"What invention did Nikola Tesla create that is crucial for modern electricity distribution?", "Alternating current", "Direct current", "Induction motor", "Capacitor", "Transformer", "Voltage regulator"},{"Who invented the first successful motion picture camera?", "Louis Lumiere", "Thomas Edison", "Georges Melies", "Eadweard Muybridge", "D.W. Griffith", "Sergei Eisenstein"},{"What significant invention did Alva Fisher create in 1907?", "Electric washing machine", "Electric stove", "Electric refrigerator", "Vacuum cleaner", "Electric iron", "Electric toaster"},{"Who invented the first successful robotic vacuum cleaner?", "iRobot", "Dyson", "Samsung", "Electrolux", "Shark", "Neato Robotics"},{"What invention is attributed to George Washington Carver that helped agriculture?", "Crop rotation", "Fertilizer", "Hybrid seeds", "Pesticides", "Irrigation system", "Drip irrigation"},{"Who invented the modern computer mouse?", "Douglas Engelbart", "Bill Gates", "Steve Jobs", "Alan Turing", "Vannevar Bush", "John von Neumann"},{"What invention did Thomas Edison create that transformed film entertainment?", "Kinetoscope", "Cinematograph", "Movie projector", "Television", "Radio", "Phonograph"},{"Who is known for developing the first functional GPS technology?", "Roger L. Easton", "John McCarthy", "William H. Pickering", "Ivan Getting", "Hugh G. McElroy", "Arthur C. Clarke"},{"What was the primary invention of Sir Tim Berners-Lee that led to the modern internet?", "World Wide Web", "Email", "FTP", "Usenet", "Hypertext", "Browser"},{"Who invented the first true mechanical clock in Europe?", "Giovanni de Dondi", "Richard of Wallingford", "Henry de Vick", "Giovanni B. Della Porta", "Nicolaus of Cusa", "Henricus Valesius"},{"What does HTML stand for?", "HyperText Markup Language", "HighText Machine Language", "HyperText Multiple Language", "HyperLink and Text Markup", "HighText Markup Language", "Hyperlink Text Markup Language"},{"What year was the first iPhone released?", "2007", "2005", "2009", "2006", "2008", "2010"},{"What does CPU stand for?", "Central Processing Unit", "Central Program Unit", "Control Processing Unit", "Computer Personal Unit", "Core Processing Unit", "Central Programing Unit"},{"Which company developed the Windows operating system?", "Microsoft", "Apple", "IBM", "Google", "Oracle", "Linux"},{"What is the primary function of an operating system?", "Manage hardware and software resources", "Run applications", "Store data", "Connect to the internet", "Provide security", "Create documents"},{"What does URL stand for?", "Uniform Resource Locator", "Universal Resource Locator", "Uniform Resource Link", "Universal Resource Link", "Unified Resource Locator", "Uniform Reference Locator"},{"Who is known as the father of the computer?", "Charles Babbage", "Alan Turing", "Bill Gates", "Steve Jobs", "John von Neumann", "Ada Lovelace"},{"What year was the first email sent?", "1971", "1965", "1980", "1985", "1990", "1975"},{"Which programming language is primarily used for web development?", "JavaScript", "Python", "C++", "Java", "Ruby", "Swift"},{"What does AI stand for?", "Artificial Intelligence", "Automated Interface", "Artificial Interaction", "Advanced Integration", "Automated Intelligence", "Artificial Internet"},{"What is the main purpose of a firewall?", "To protect networks from unauthorized access", "To boost internet speed", "To store data", "To connect devices", "To create websites", "To run applications"},{"Which device is used to connect to a wireless network?", "Router", "Modem", "Switch", "Access Point", "Firewall", "Network Cable"},{"What is the primary function of a hard drive?", "Store data", "Process data", "Connect devices", "Display graphics", "Manage memory", "Execute applications"},{"What does VPN stand for?", "Virtual Private Network", "Virtual Public Network", "Variable Private Network", "Virtual Protected Network", "Virtual Personal Network", "Virtual Program Network"},{"Which company is known for the Android operating system?", "Google", "Apple", "Microsoft", "IBM", "Samsung", "Oracle"},{"What year was the World Wide Web invented?", "1989", "1991", "1995", "1990", "1993", "1985"},{"What does SSD stand for?", "Solid State Drive", "Super Speed Drive", "Solid Storage Device", "Standard Storage Drive", "Super Solid Disk", "Solid State Device"},{"Who co-founded Microsoft?", "Bill Gates", "Steve Jobs", "Larry Page", "Elon Musk", "Mark Zuckerberg", "Jeff Bezos"},{"What is the main purpose of cloud computing?", "To store and access data over the internet", "To enhance gaming", "To improve internet speed", "To manage networks", "To create applications", "To run operating systems"},{"Which technology uses electromagnetic fields to identify and track tags attached to objects?", "RFID", "NFC", "Bluetooth", "Wi-Fi", "GPS", "Infrared"},{"What is the most widely used social media platform?", "Facebook", "Twitter", "Instagram", "LinkedIn", "Snapchat", "TikTok"},{"What does IoT stand for?", "Internet of Things", "Interconnected Online Technology", "Internet of Technology", "Integrated Online Tools", "Internet of Telecommunications", "International Online Transactions"},{"Which company developed the first successful personal computer?", "Apple", "IBM", "Microsoft", "Commodore", "Tandy", "Atari"},{"What is the purpose of a database?", "Store and manage data", "Run applications", "Create websites", "Connect devices", "Protect networks", "Process transactions"},{"What is the term for a program that can replicate itself?", "Virus", "Trojan", "Worm", "Spyware", "Adware", "Malware"},{"What does the acronym HTTP stand for?", "HyperText Transfer Protocol", "HighText Transfer Protocol", "HyperText Transmission Protocol", "HyperLink Transfer Protocol", "HighText Transmission Protocol", "HyperText Transfer Process"},{"What year was the first video game created?", "1958", "1965", "1972", "1980", "1960", "1975"},{"Which technology is used for contactless payments?", "NFC", "Bluetooth", "RFID", "Wi-Fi", "GPS", "Infrared"},{"What is the main function of a search engine?", "To retrieve information from the web", "To store data", "To create websites", "To enhance security", "To connect devices", "To run applications"},{"What does the acronym BIOS stand for?", "Basic Input/Output System", "Binary Input/Output System", "Basic Integrated Operating System", "Binary Integrated Operating System", "Basic Internal Operating System", "Binary Internal Operating System"},{"What year did Apple release the first Macintosh computer?", "1984", "1983", "1985", "1986", "1982", "1980"},{"What is the primary function of a web browser?", "To access the internet", "To create websites", "To send emails", "To run applications", "To manage networks", "To store data"},{"What does GPS stand for?", "Global Positioning System", "Geographic Positioning System", "Global Personal System", "Geographic Personal System", "Global Positioning Service", "Geographic Positioning Service"},{"Which programming language is known for its use in data science?", "Python", "Java", "C++", "Ruby", "JavaScript", "Swift"},{"What is a common use for blockchain technology?", "Cryptocurrency", "Social media", "Email", "Video streaming", "Online shopping", "Gaming"},{"What does the term 'phishing' refer to?", "Fraudulent attempts to obtain sensitive information", "Hacking a network", "Creating viruses", "Spamming emails", "Stealing data", "Accessing secure servers"},{"What is the primary use of a modem?", "To connect to the internet", "To store data", "To process information", "To enhance graphics", "To manage networks", "To run applications"},{"Which company is famous for the Linux operating system?", "Linus Torvalds", "Microsoft", "Apple", "IBM", "Oracle", "Google"},{"What is the main function of a spreadsheet program?", "To organize and analyze data", "To create presentations", "To manage emails", "To design graphics", "To store files", "To code software"},{"What technology is used in virtual reality?", "Head-mounted displays", "Smartphones", "Tablets", "Laptops", "Televisions", "Game consoles"},{"What is the primary function of a router?", "To direct internet traffic", "To store data", "To enhance graphics", "To connect devices", "To run applications", "To manage networks"},{"What does the term 'bandwidth' refer to?", "Data transfer capacity of a network", "Speed of a processor", "Storage capacity of a hard drive", "Quality of a video", "Distance of a signal", "Power consumption of a device"},{"What is a common use for augmented reality?", "Gaming", "Document editing", "Emailing", "Data storage", "Web browsing", "Database management"},{"What is the purpose of a graphics card?", "To render images and videos", "To store data", "To connect to the internet", "To manage networks", "To run applications", "To process information"},{"Which device is primarily used for listening to music digitally?", "Smartphone", "Television", "Printer", "Camera", "Computer", "Tablet"},{"What does the term 'open source' mean?", "Source code is available for anyone to use and modify", "Software is free", "Software is proprietary", "Software is hardware-based", "Software is obsolete", "Software is for personal use only"},{"What year was the first successful test of a robotic vacuum cleaner?", "2002", "2000", "1998", "1995", "2005", "2010"},{"What does the term 'machine learning' refer to?", "Algorithms that allow computers to learn from data", "Computers that can think like humans", "Hardware that processes data", "Software for data storage", "Programming languages", "Networks that connect devices"},{"What is the primary purpose of a data center?", "To store and manage data", "To run applications", "To connect devices", "To enhance security", "To process transactions", "To create websites"},{"What technology underlies cryptocurrency?", "Blockchain", "Cloud computing", "Machine learning", "Artificial intelligence", "Augmented reality", "Virtual reality"},{"What was the first programmable computer?", "Z3", "ENIAC", "Colossus", "UNIVAC", "IBM 701", "PDP-8"},{"Who is considered the father of the World Wide Web?", "Tim Berners-Lee", "Marc Andreessen", "Vint Cerf", "Ray Tomlinson", "Bill Gates", "Steve Jobs"},{"Which company developed the first successful personal computer?", "Apple", "IBM", "Commodore", "Atari", "Microsoft", "Xerox"},{"What technology underlies blockchain?", "Distributed ledger", "Cloud computing", "Quantum computing", "Virtual reality", "Artificial intelligence", "Machine learning"},{"What was the first mobile phone to use a touchscreen interface?", "IBM Simon", "Nokia 9000", "Motorola StarTAC", "BlackBerry", "iPhone", "LG Prada"},{"Which programming language was created by James Gosling in 1995?", "Java", "Python", "C++", "Ruby", "Swift", "JavaScript"},{"What is the primary function of a router?", "Directing data traffic", "Storing data", "Running applications", "Providing internet access", "Encrypting data", "Backing up files"},{"Which technology is primarily used for virtual reality experiences?", "Head-mounted displays", "Augmented reality", "3D rendering", "Simulated environments", "Haptic feedback", "Artificial intelligence"},{"Who is credited with inventing the first successful email program?", "Ray Tomlinson", "Vint Cerf", "Tim Berners-Lee", "Marc Andreessen", "Steve Jobs", "Bill Gates"},{"What technology does Wi-Fi primarily use for wireless communication?", "Radio waves", "Infrared signals", "Microwaves", "Ultrasound", "Laser beams", "Satellite signals"},{"Which of the following technologies is used for large-scale data storage?", "Cloud storage", "Solid-state drives", "Hard disk drives", "USB flash drives", "Magnetic tape", "Optical discs"},{"What does the acronym 'IoT' stand for?", "Internet of Things", "Interconnected Online Technologies", "Information of Technology", "Integrated Online Tools", "Intelligent Operational Technology", "Interface of Things"},{"Who invented the first successful electric light bulb?", "Thomas Edison", "Nikola Tesla", "Hedy Lamarr", "Alexander Graham Bell", "Michael Faraday", "Benjamin Franklin"},{"What is the main purpose of a compiler in programming?", "Translating source code", "Debugging code", "Executing programs", "Managing memory", "Optimizing performance", "Connecting to databases"},{"Which company developed the first successful video game console?", "Atari", "Nolan Bushnell", "Magnavox", "Nintendo", "Sega", "Sony"},{"What was the first widely used web browser?", "Mosaic", "Netscape Navigator", "Internet Explorer", "Firefox", "Safari", "Chrome"},{"Which technology uses a decentralized network to verify transactions?", "Blockchain", "Cloud computing", "Peer-to-peer networks", "Distributed databases", "Virtual machines", "Big data"},{"What is the primary function of an operating system?", "Managing hardware and software resources", "Providing internet access", "Running applications", "Storing data", "Securing data", "Optimizing performance"},{"Which technology is primarily associated with machine learning?", "Artificial intelligence", "Blockchain", "Cloud computing", "Virtual reality", "Big data", "Internet of Things"},{"Who is known for developing the concept of the graphical user interface (GUI)?", "Douglas Engelbart", "Steve Jobs", "Bill Gates", "Alan Kay", "Vint Cerf", "Tim Berners-Lee"},{"What technology is used for creating 3D models and simulations?", "3D  printing", "Virtual reality", "Augmented reality", "Computer-aided design (CAD)", "Rendering", "Animation"},{"What is the primary purpose of a firewall?", "Protecting networks from unauthorized access", "Storing data", "Running applications", "Providing internet access", "Monitoring network traffic", "Encrypting data"},{"Which programming language is known for its use in web development?", "JavaScript", "Python", "Java", "C++", "Ruby", "Swift"},{"What is the primary use of RFID technology?", "Tracking and identifying objects", "Storing data", "Transmitting audio signals", "Providing internet access", "Creating virtual environments", "Collecting data"},{"Which company introduced the first smartphone?", "IBM", "Apple", "Nokia", "Motorola", "BlackBerry", "Samsung"},{"What is the main technology behind self-driving cars?", "Artificial intelligence", "Machine learning", "Computer vision", "LiDAR", "GPS", "Robotics"},{"Which technology allows for real-time communication over the internet?", "Voice over Internet Protocol (VoIP)", "Instant messaging", "Email", "WebRTC", "Teleconferencing", "Social media"},{"What was the first widely used personal computer?", "Apple II", "IBM PC", "Commodore 64", "Tandy TRS-80", "Atari ST", "Zilog Z80"},{"What technology uses quantum bits for processing information?", "Quantum computing", "Cloud computing", "Supercomputing", "Artificial intelligence", "Machine learning", "Distributed computing"},{"Which company developed the first successful tablet computer?", "Apple", "Microsoft", "Samsung", "Amazon", "IBM", "Microsoft"},{"What is the primary technology behind voice assistants like Siri and Alexa?", "Natural language processing", "Machine learning", "Artificial intelligence", "Speech recognition", "Deep learning", "Computer vision"},{"Who is known for inventing the first computer program?", "Ada Lovelace", "Alan Turing", "Charles Babbage", "Hedy Lamarr", "John von Neumann", "Bill Gates"},{"What is the main purpose of a database management system (DBMS)?", "Managing data", "Running applications", "Providing internet access", "Securing networks", "Transmitting information", "Debugging code"},{"Which technology allows for the virtualization of physical hardware?", "Virtual machines", "Cloud computing", "Hypervisors", "Containers", "Remote desktop", "Serverless computing"},{"What is the primary purpose of a search engine?", "Indexing and retrieving information", "Providing internet access", "Storing data", "Running applications", "Monitoring network traffic", "Securing data"},{"Which programming language is known for its use in scientific computing?", "Python", "Java", "C++", "R", "MATLAB", "FORTRAN"},{"What is the primary use of biometrics in technology?", "Identifying individuals based on physical characteristics", "Tracking data", "Encrypting information", "Providing security", "Creating digital signatures", "Monitoring health"},{"Who invented the first successful digital camera?", "Steven Sasson", "Kodak", "Canon", "Nikon", "Sony", "Fujifilm"},{"What technology is used to connect devices to the internet wirelessly?", "Wi-Fi", "Ethernet", "Bluetooth", "Zigbee", "NFC", "Li-Fi"},{"What is the primary purpose of a content management system (CMS)?", "Managing digital content", "Creating websites", "Hosting applications", "Storing data", "Monitoring traffic", "Securing networks"},{"Which of the following is an example of an open-source operating system?", "Linux", "Windows", "macOS", "iOS", "Android", "Chrome OS"},{"What technology is used for creating and managing smart contracts?", "Blockchain", "Cloud computing", "Artificial intelligence", "Machine learning", "Distributed databases", "Virtual machines"},{"Who is known for developing the theory of information entropy?", "Claude Shannon", "Alan Turing", "John von Neumann", "Norbert Wiener", "Hedy Lamarr", "Vint Cerf"},{"What was the first popular social media platform?", "Friendster", "MySpace", "Facebook", "Twitter", "LinkedIn", "Instagram"},{"What is the primary use of cloud computing?", "Storing and processing data over the internet", "Running local applications", "Providing internet access", "Securing networks", "Transmitting information", "Creating virtual environments"},{"Which of the following is a major programming paradigm?", "Object-oriented programming", "Functional programming", "Procedural programming", "Declarative programming", "All of the above", "None of the above"},{"What technology is commonly used for online payments?", "Payment gateways", "Cryptocurrencies", "Blockchain", "Digital wallets", "Contactless payments", "All of the above"},{"Who is known for pioneering the development of artificial intelligence?", "John McCarthy", "Alan Turing", "Marvin Minsky", "Herbert Simon", "Claude Shannon", "Norbert Wiener"},{"What is the primary function of a semiconductor?", "Controlling electrical flow", "Storing data", "Running applications", "Transmitting signals", "Converting energy", "Enhancing performance"},{"Which technology uses algorithms to analyze large data sets?", "Data mining", "Cloud computing", "Blockchain", "Machine learning", "Artificial intelligence", "Big data analytics"},{"What is the main ingredient in guacamole?", "Avocado", "Tomato", "Onion", "Lime", "Pepper", "Garlic"},{"Which fruit is known as the 'king of fruits'?", "Durian", "Mango", "Apple", "Banana", "Pineapple", "Grapes"},{"What is tofu made from?", "Soybeans", "Wheat", "Rice", "Corn", "Peas", "Almonds"},{"What type of pasta is shaped like small rice grains?", "Orzo", "Fusilli", "Penne", "Spaghetti", "Fettuccine", "Linguine"},{"Which spice is derived from the flower of the Crocus sativus?", "Saffron", "Turmeric", "Cumin", "Paprika", "Cardamom", "Ginger"},{"What is the main ingredient in hummus?", "Chickpeas", "Lentils", "Black beans", "Peas", "Soybeans", "Rice"},{"What type of cuisine is sushi associated with?", "Japanese", "Chinese", "Korean", "Thai", "Vietnamese", "Filipino"},{"Which vegetable is known for its high vitamin K content?", "Kale", "Carrot", "Broccoli", "Spinach", "Potato", "Cabbage"},{"What is the traditional dish made of raw fish and rice called?", "Sushi", "Sashimi", "Poke", "Ceviche", "Tartare", "Tempura"},{"What type of bread is used to make a traditional Reuben sandwich?", "Rye bread", "Sourdough", "Wheat bread", "White bread", "Pita bread", "Focaccia"},{"Which fruit is typically used to make cider?", "Apple", "Pear", "Grape", "Peach", "Cherry", "Plum"},{"What is the main ingredient in a traditional pesto sauce?", "Basil", "Parsley", "Cilantro", "Mint", "Thyme", "Oregano"},{"Which nut is used to make marzipan?", "Almond", "Walnut", "Pistachio", "Cashew", "Pecan", "Hazelnut"},{"What type of cheese is traditionally used in lasagna?", "Ricotta", "Mozzarella", "Parmesan", "Cheddar", "Feta", "Gorgonzola"},{"Which vegetable is known as 'courgette' in the UK?", "Zucchini", "Eggplant", "Bell pepper", "Cucumber", "Squash", "Pumpkin"},{"What is the main ingredient in traditional kimchi?", "Napa cabbage", "Carrot", "Radish", "Cucumber", "Garlic", "Onion"},{"What is the primary flavoring ingredient in traditional teriyaki sauce?", "Soy sauce", "Oyster sauce", "Hoisin sauce", "Fish sauce", "Chili sauce", "Barbecue sauce"},{"Which dish is made from ground meat, often served with a sauce?", "Meatballs", "Burgers", "Tacos", "Sausages", "Stir-fry", "Casserole"},{"What type of cuisine is known for its use of spices like cumin, coriander, and turmeric?", "Indian", "Italian", "Mexican", "Thai", "Chinese", "Greek"},{"Which fruit is known for having seeds on its exterior?", "Strawberry", "Blueberry", "Raspberry", "Blackberry", "Cherry", "Grape"},{"What is the primary ingredient in falafel?", "Chickpeas", "Lentils", "Black beans", "Fava beans", "Peas", "Soybeans"},{"Which herb is known for its use in Mediterranean cuisine and is often paired with lamb?", "Rosemary", "Basil", "Thyme", "Oregano", "Parsley", "Mint"},{"What is the traditional filling in a tamale?", "Corn dough with meat or vegetables", "Rice with beans", "Potato with cheese", "Flour with fruit", "Meat with cheese", "Pasta with sauce"},{"Which vegetable is also known as 'aubergine'?", "Eggplant", "Zucchini", "Bell pepper", "Carrot", "Squash", "Cucumber"},{"What is the main ingredient in traditional Japanese miso soup?", "Miso paste", "Soy sauce", "Tofu", "Seaweed", "Rice", "Fish"},{"What type of dish is risotto?", "Italian rice dish", "French pastry", "Mexican soup", "Japanese noodle dish", "Indian curry", "Greek salad"},{"What is the key ingredient in traditional Thai green curry?", "Green curry paste", "Coconut milk", "Rice", "Noodles", "Vegetables", "Chicken"},{"Which fruit is often used to make wine?", "Grapes", "Apples", "Cherries", "Pears", "Plums", "Peaches"},{"What is the main ingredient in the Middle Eastern dish baba ganoush?", "Eggplant", "Chickpeas", "Lentils", "Tomatoes", "Peppers", "Zucchini"},{"What type of flour is typically used to make naan bread?", "Wheat flour", "Corn flour", "Rice flour", "Barley flour", "Oat flour", "Rye flour"},{"Which leafy green is known for its high iron content?", "Spinach", "Lettuce", "Kale", "Collard greens", "Arugula", "Swiss chard"},{"What type of cuisine is known for dishes like pho and banh mi?", "Vietnamese", "Thai", "Chinese", "Korean", "Japanese", "Filipino"},{"What is the main ingredient in a Caesar salad dressing?", "Anchovies", "Olive oil", "Vinegar", "Mustard", "Cream", "Mayonnaise"},{"What is the primary ingredient in a traditional shepherd's pie?", "Ground lamb", "Ground beef", "Pork", "Chicken", "Turkey", "Fish"},{"What is the main ingredient in the Middle Eastern dish tabbouleh?", "Bulgur wheat", "Rice", "Quinoa", "Couscous", "Lentils", "Barley"},{"Which fruit is known for its high vitamin C content and is often used in drinks?", "Orange", "Banana", "Grapefruit", "Apple", "Pear", "Kiwi"},{"What type of cuisine is known for dishes like baklava and moussaka?", "Greek", "Turkish", "Lebanese", "Egyptian", "Italian", "Persian"},{"What is the main ingredient in traditional Italian risotto?", "Arborio rice", "Basmati rice", "Jasmine rice", "Long-grain rice", "Brown rice", "Wild rice"},{"What spice is commonly used in pumpkin pie?", "Cinnamon", "Nutmeg", "Clove", "Ginger", "Allspice", "Cardamom"},{"What is the main ingredient in a traditional French ratatouille?", "Vegetables", "Meat", "Fish", "Grains", "Pasta", "Cheese"},{"Which nut is used to make traditional pesto sauce?", "Pine nuts", "Walnuts", "Almonds", "Cashews", "Hazelnuts", "Pistachios"},{"What type of vegetable is commonly used in sauerkraut?", "Cabbage", "Carrot", "Turnip", "Radish", "Beet", "Cauliflower"},{"Which dish is typically made with potatoes, cheese, and onions?", "Rosti", "Poutine", "Shepherd's pie", "Colcannon", "Mashed potatoes", "Chips"},{"What is the main ingredient in a traditional pizza margherita?", "Tomato sauce", "Pepperoni", "Mushrooms", "Pineapple", "Olives", "Cheese"},{"What type of cuisine features dishes like tacos and enchiladas?", "Mexican", "Spanish", "Argentinian", "Peruvian", "Cuban", "Chilean"},{"What is the primary ingredient in traditional miso paste?", "Fermented soybeans", "Rice", "Wheat", "Barley", "Corn", "Peas"},{"What is the main ingredient in traditional Japanese tempura?", "Battered and fried vegetables or seafood", "Noodles", "Rice", "Grains", "Meat", "Fish"},{"Which fruit is known for its ability to ripen other fruits?", "Banana", "Apple", "Avocado", "Peach", "Mango", "Kiwi"},{"What is the key ingredient in the Middle Eastern dish falafel?", "Chickpeas or fava beans", "Lentils", "Rice", "Meat", "Eggplant", "Zucchini"},{"Which spice is made from the dried flower buds of the Syzygium aromaticum?", "Clove", "Cinnamon", "Nutmeg", "Pepper", "Cardamom", "Ginger"},{"What is the primary ingredient in traditional Japanese miso soup?", "Miso paste", "Soy sauce", "Dashi", "Tofu", "Seaweed", "Rice"},{"Which French cooking technique involves cooking food slowly in fat?", "Confit", "Sauteing", "Poaching", "Braising", "Steaming", "Baking"},{"What is the name of the Italian dish made with thinly sliced raw meat or fish, typically served as an appetizer?", "Carpaccio", "Tartare", "Bruschetta", "Antipasto", "Crostini", "Frittata"},{"Which spice is commonly used in Indian cuisine and is known for its vibrant yellow color?", "Turmeric", "Cumin", "Saffron", "Cardamom", "Fenugreek", "Coriander"},{"What is the primary method of cooking used in the dish paella?", "Sauteing", "Steaming", "Braising", "Simmering", "Grilling", "Frying"},{"Which type of pasta is shaped like small rice grains and often used in soups?", "Orzo", "Fusilli", "Penne", "Farfalle", "Linguine", "Ravioli"},{"What is the French term for a mixture of egg yolks and cream used to thicken sauces?", "Sabayon", "Roux", "Bechamel", "Creme anglaise", "Hollandaise", "Aioli"},{"Which fruit is traditionally used to make the Middle Eastern dish baba ghanoush?", "Eggplant", "Zucchini", "Tomato", "Pepper", "Carrot", "Pumpkin"},{"What is the key ingredient in the traditional Spanish dish gazpacho?", "Tomatoes", "Cucumbers", "Peppers", "Garlic", "Onions", "Basil"},{"Which cuisine is known for dishes such as kimchi, bulgogi, and bibimbap?", "Korean", "Japanese", "Chinese", "Thai", "Vietnamese", "Filipino"},{"What type of cheese is traditionally used in Greek salads?", "Feta", "Ricotta", "Mozzarella", "Parmesan", "Cheddar", "Gorgonzola"},{"What cooking method involves immersing food in hot oil until cooked?", "Deep frying", "Sauteing", "Roasting", "Baking", "Boiling", "Steaming"},{"What is the main ingredient in traditional pesto sauce?", "Basil", "Parsley", "Cilantro", "Oregano", "Rosemary", "Mint"},{"Which dish is made from fermented soybeans and often served as a condiment in Japanese cuisine?", "Natto", "Miso", "Tofu", "Tempeh", "Soy sauce", "Edamame"},{"What is the primary flavoring agent in traditional Thai curry paste?", "Lemongrass", "Ginger", "Coriander", "Chili peppers", "Garlic", "Turmeric"},{"What is the term for a dish cooked in a sealed pot with a small amount of liquid, often resulting in tender meat?", "Braising", "Stewing", "Poaching", "Sauteing", "Roasting", "Grilling"},{"Which fruit is used to make the traditional French dessert tarte Tatin?", "Apples", "Pears", "Peaches", "Cherries", "Plums", "Figs"},{"What is the Italian term for a dish that is served cold and consists of various cured meats and cheeses?", "Antipasto", "Bruschetta", "Caprese", "Insalata", "Frittata", "Crostini"},{"Which herb is a key ingredient in the classic French sauce bearnaise?", "Tarragon", "Chervil", "Thyme", "Rosemary", "Sage", "Oregano"},{"What type of cuisine is characterized by the use of fresh herbs, citrus, and seafood, often found in dishes like ceviche?", "Peruvian", "Mexican", "Brazilian", "Chilean", "Argentinian", "Colombian"},{"Which type of bread is typically used in a Reuben sandwich?", "Rye bread", "Sourdough", "Whole wheat", "Ciabatta", "French baguette", "Pita"},{"What is the main ingredient in traditional hummus?", "Chickpeas", "Lentils", "Beans", "Peas", "Tofu", "Nuts"},{"Which cooking method involves cooking food with steam?", "Steaming", "Boiling", "Poaching", "Baking", "Sauteing", "Grilling"},{"What is the Japanese term for grilled skewered chicken?", "Yakitori", "Sukiyaki", "Tempura", "Sashimi", "Noodle", "Udon"},{"Which dish is a traditional Indian bread made from whole wheat flour and cooked in a tandoor oven?", "Naan", "Chapati", "Paratha", "Roti", "Puri", "Bhakri"},{"What is the main ingredient in traditional Spanish chorizo?", "Pork", "Beef", "Chicken", "Lamb", "Fish", "Turkey"},{"Which cooking method involves quickly cooking food over high heat with a small amount of oil?", "Stir-frying", "Grilling", "Sauteing", "Roasting", "Baking", "Poaching"},{"What is the Italian term for a type of pastry filled with cream or custard?", "Profiterole", "Tiramisu", "Panettone", "Panna cotta", "Cannoli", "Sfogliatella"},{"What is the primary ingredient in traditional French ratatouille?", "Vegetables", "Meat", "Fish", "Grains", "Pasta", "Legumes"},{"Which cuisine is known for using miso, tofu, and sushi?", "Japanese", "Korean", "Chinese", "Thai", "Vietnamese", "Filipino"},{"What type of dessert is a souffle?", "Egg-based", "Cream-based", "Fruit-based", "Chocolate-based", "Custard-based", "Gelatin-based"},{"What is the main ingredient in the Italian dish risotto?", "Arborio rice", "Basmati rice", "Jasmine rice", "Sushi rice", "Brown rice", "Wild rice"},{"What is the primary cooking technique used to prepare sushi rice?", "Steaming", "Boiling", "Baking", "Frying", "Roasting", "Poaching"},{"Which type of pasta is shaped like little ears?", "Orecchiette", "Fusilli", "Penne", "Farfalle", "Ravioli", "Linguine"},{"What is the main flavoring ingredient in traditional French onion soup?", "Onions", "Garlic", "Thyme", "Parsley", "Beef broth", "Bay leaves"},{"Which type of cuisine is known for its use of spices like cumin, coriander, and cinnamon, often found in curry dishes?", "Indian", "Thai", "Middle Eastern", "Mexican", "Chinese", "Italian"},{"What is the term for a type of Italian pasta that is made by rolling thin sheets of dough and cutting them into strips?", "Tagliatelle", "Fettuccine", "Lasagna", "Pappardelle", "Spaghetti", "Linguine"},{"Which cooking technique involves using dry heat in an oven?", "Baking", "Boiling", "Steaming", "Frying", "Poaching", "Simmering"},{"What is the primary ingredient in the Middle Eastern dish falafel?", "Chickpeas", "Fava beans", "Lentils", "Peas", "Nuts", "Rice"},{"What is the traditional preparation method for making kimchi?", "Fermentation", "Pickling", "Canning", "Freezing", "Drying", "Smoking"},{"Which dish is made from minced meat, typically lamb or beef, and cooked on a skewer over an open flame?", "Kebab", "Souvlaki", "Tandoori", "Shish", "Fajita", "Grill"},{"What is the main component of the French dish coq au vin?", "Chicken", "Beef", "Pork", "Duck", "Rabbit", "Fish"},{"What is the Japanese word for a small, bite-sized sushi roll?", "Maki", "Nigiri", "Sashimi", "Temaki", "Uramaki", "Onigiri"},{"What type of cheese is traditionally used in a classic lasagna?", "Ricotta", "Mozzarella", "Parmesan", "Cheddar", "Gorgonzola", "Feta"},{"What is the primary cooking method for preparing a traditional Scottish haggis?", "Boiling", "Baking", "Steaming", "Roasting", "Grilling", "Frying"},{"Which cuisine is known for its use of ingredients like lemongrass, galangal, and kaffir lime leaves?", "Thai", "Vietnamese", "Indonesian", "Filipino", "Malaysian", "Laotian"},{"What is the name of the flatbread that is a staple in Indian cuisine?", "Naan", "Pita", "Tortilla", "Focaccia", "Lavash", "Chapati"},{"What is the primary ingredient in the traditional dish bouillabaisse?", "Fish", "Chicken", "Beef", "Vegetables", "Pork", "Shellfish"},{"What type of dish is a 'tartare'?", "Raw", "Cooked", "Baked", "Fried", "Grilled", "Steamed"},{"Which type of cuisine includes dishes like falafel, tabbouleh, and baklava?", "Middle Eastern", "Mediterranean", "North African", "Turkish", "Persian", "Greek"},{"Which country has won the most FIFA World Cup titles?", "Brazil", "Germany", "Argentina", "Italy", "France", "England"},{"In which sport would you perform a slam dunk?", "Basketball", "Tennis", "Soccer", "Rugby", "Baseball", "Cricket"},{"How many players are on a soccer team on the field?", "11", "10", "12", "9", "8", "7"},{"Where did the Olympic Games originate?", "Greece", "Italy", "France", "China", "USA", "Russia"},{"Which sport uses a shuttlecock?", "Badminton", "Tennis", "Squash", "Golf", "Table Tennis", "Cricket"},{"Who holds the record for the most Grand Slam titles in tennis?", "Serena Williams", "Maria Sharapova", "Steffi Graf", "Martina Navratilova", "Billie Jean King", "Venus Williams"},{"Which country is known for winning the most Rugby World Cup titles?", "New Zealand", "Australia", "South Africa", "England", "France", "Argentina"},{"How long is a marathon?", "26.2 miles", "20 miles", "22 miles", "24.5 miles", "25 miles", "30 miles"},{"In which sport would you find a pommel horse?", "Gymnastics", "Polo", "Equestrian", "Wrestling", "Weightlifting", "Judo"},{"What is the term for scoring three goals in a single soccer game?", "Hat-trick", "Triple", "Score trio", "Three-pointer", "Triple Goal", "Trifecta"},{"Which sport uses the term 'birdie'?", "Golf", "Tennis", "Badminton", "Basketball", "Cricket", "Rugby"},{"How many players are on a baseball team?", "9", "11", "10", "7", "8", "12"},{"In which country was cricket invented?", "England", "Australia", "India", "South Africa", "Pakistan", "New Zealand"},{"What is the highest possible break in snooker?", "147", "150", "180", "200", "155", "170"},{"Which sport is known as 'the beautiful game'?", "Soccer", "Basketball", "Tennis", "Rugby", "Baseball", "Volleyball"},{"Which NBA team did Michael Jordan play the majority of his career for?", "Chicago Bulls", "Los Angeles Lakers", "Boston Celtics", "Miami Heat", "San Antonio Spurs", "New York Knicks"},{"How many holes are there in a standard round of golf?", "18", "9", "12", "16", "20", "15"},{"What is the minimum age required to compete in the Olympics?", "16", "14", "18", "20", "12", "21"},{"Who was the first gymnast to score a perfect 10 in the Olympics?", "Nadia Comaneci", "Simone Biles", "Shannon Miller", "Mary Lou Retton", "Olga Korbut", "Kerri Strug"},{"In which sport do teams compete for the Stanley Cup?", "Ice Hockey", "Basketball", "Baseball", "Soccer", "Cricket", "Tennis"},{"Which country won the first-ever Soccer World Cup?", "Uruguay", "Brazil", "Italy", "Argentina", "Germany", "France"},{"How many minutes are there in a standard soccer match?", "90", "80", "100", "75", "85", "95"},{"Which race is known as 'The Fastest Two Minutes in Sports'?", "Kentucky Derby", "Indianapolis 500", "Tour de France", "Boston Marathon", "Monaco Grand Prix", "Wimbledon Final"},{"What does NFL stand for?", "National Football League", "National Field League", "New Football League", "North American Football League", "National Futbol League", "National Federation League"},{"In which sport would you perform a Fosbury Flop?", "High Jump", "Long Jump", "Triple Jump", "Pole Vault", "Gymnastics", "Diving"},{"Which sport is known as America's pastime?", "Baseball", "Football", "Basketball", "Soccer", "Hockey", "Golf"},{"What is the maximum score in a single frame of bowling?", "300", "150", "200", "250", "350", "100"},{"Which country has won the most Olympic medals?", "USA", "Russia", "China", "Germany", "United Kingdom", "France"},{"What is the top soccer league in England called?", "Premier League", "La Liga", "Serie A", "Bundesliga", "Ligue 1", "MLS"},{"How many sets must a player win to win a tennis match in a Grand Slam?", "3 (for women), 5 (for men)", "2", "3", "4", "5", "6"},{"What sport is the Tour de France associated with?", "Cycling", "Running", "Car Racing", "Horse Racing", "Swimming", "Rowing"},{"In which sport would you find a 'power play'?", "Ice Hockey", "Soccer", "Rugby", "Tennis", "Basketball", "Cricket"},{"What is the maximum weight of a bowling ball?", "16 pounds", "14 pounds", "18 pounds", "12 pounds", "20 pounds", "10 pounds"},{"Which Olympic sport takes place in a velodrome?", "Cycling", "Running", "Swimming", "Gymnastics", "Skiing", "Wrestling"},{"What sport has a position called the 'libero'?", "Volleyball", "Soccer", "Basketball", "Baseball", "Rugby", "Tennis"},{"In American football, how many points is a touchdown worth?", "6", "5", "7", "3", "2", "1"},{"Which country has won the most Olympic gold medals in ice hockey?", "Canada", "USA", "Russia", "Sweden", "Finland", "Germany"},{"In which sport is the term 'home run' used?", "Baseball", "Football", "Soccer", "Rugby", "Basketball", "Hockey"},{"What is the standard height of a basketball hoop?", "10 feet", "8 feet", "9 feet", "11 feet", "12 feet", "10.5 feet"},{"What color jersey does the leader of the Tour de France wear?", "Yellow", "Green", "Red", "White", "Blue", "Orange"},{"What is a baseball field called?", "Diamond", "Pitch", "Court", "Rink", "Mat", "Lane"},{"Which sport would you associate with Wimbledon?", "Tennis", "Golf", "Soccer", "Cricket", "Hockey", "Basketball"},{"Which country hosted the 2016 Summer Olympics?", "Brazil", "Russia", "China", "Japan", "South Korea", "United Kingdom"},{"How many periods are there in a hockey game?", "3", "2", "4", "5", "1", "6"},{"Which sport features the terms 'bogey' and 'eagle'?", "Golf", "Soccer", "Cricket", "Tennis", "Baseball", "Hockey"},{"What is the length of a regulation basketball court?", "94 feet", "90 feet", "80 feet", "100 feet", "75 feet", "88 feet"},{"What sport is associated with the Ryder Cup?", "Golf", "Tennis", "Soccer", "Rugby", "Cricket", "Basketball"},{"Which country is known for sumo wrestling?", "Japan", "China", "South Korea", "Thailand", "India", "Mongolia"},{"What is the standard size of a soccer goal?", "8 feet high and 24 feet wide", "10 feet high and 30 feet wide", "6 feet high and 20 feet wide", "12 feet high and 26 feet wide", "7 feet high and 22 feet wide", "8 feet high and 22 feet wide"},{"Which team won the first-ever Super Bowl?", "Green Bay Packers", "New York Giants", "Dallas Cowboys", "Pittsburgh Steelers", "Kansas City Chiefs", "San Francisco 49ers"},{"Which country won the first FIFA World Cup in 1930?", "Uruguay", "Brazil", "Germany", "Italy", "Argentina", "France"},{"What is the maximum number of players allowed on a Major League Baseball team roster during the regular season?", "26", "25", "28", "30", "24", "27"},{"Which athlete holds the record for the most Olympic gold medals won?", "Michael Phelps", "Mark Spitz", "Usain Bolt", "Carl Lewis", "Larisa Latynina", "Bjørn Dæhlie"},{"What is the term for the area where a basketball team scores?", "Key", "Paint", "Arc", "Box", "Lane", "Three-point line"},{"In which year did Roger Federer win his first Wimbledon title?", "2003", "2004", "2001", "2002", "2005", "2000"},{"Which NFL team has the most Super Bowl victories?", "Pittsburgh Steelers", "New England Patriots", "Dallas Cowboys", "San Francisco 49ers", "New York Giants", "Green Bay Packers"},{"What is the distance of a marathon race in miles?", "26.2", "24.5", "25.0", "26.0", "27.0", "25.5"},{"Who is the all-time leading scorer in the NBA?", "Kareem Abdul-Jabbar", "Karl Malone", "Michael Jordan", "LeBron James", "Kobe Bryant", "Bill Russell"},{"Which country has hosted the Summer Olympics the most times?", "United States", "France", "Germany", "Greece", "Japan", "Australia"},{"What is the name of the annual championship game of the National Football League?", "Super Bowl", "World Series", "Stanley Cup", "NBA Finals", "Grey Cup", "Bowl Championship Series"},{"In tennis, what is the term for a serve that the opponent cannot touch?", "Ace", "Fault", "Let", "Service winner", "Double fault", "Break point"},{"Which team won the UEFA Champions League in the 2019-2020 season?", "Bayern Munich", "Paris Saint-Germain", "Manchester City", "Real Madrid", "Liverpool", "Barcelona"},{"In which sport would you perform a 'slalom'?", "Skiing", "Surfing", "Rowing", "Cycling", "Running", "Hiking"},{"Who holds the record for the most home runs in a single MLB season?", "Barry Bonds", "Mark McGwire", "Sammy Sosa", "Babe Ruth", "Hank Aaron", "Alex Rodriguez"},{"Which athlete is known for the quote, 'I am the greatest'?", "Muhammad Ali", "Michael Jordan", "Babe Ruth", "Wayne Gretzky", "Tiger Woods", "Usain Bolt"},{"Which country has won the most Rugby World Cup titles?", "New Zealand", "South Africa", "Australia", "England", "France", "Wales"},{"In which sport is the term 'hole-in-one' used?", "Golf", "Tennis", "Cricket", "Bowling", "Baseball", "Soccer"},{"Who was the first female athlete to win a Nobel Prize?", "Marie Curie", "Helen Keller", "Billie Jean King", "Maya Angelou", "Jackie Joyner-Kersee", "Serena Williams"},{"Which Olympic sport features events such as the 100m, 200m, and 400m races?", "Athletics", "Swimming", "Gymnastics", "Cycling", "Diving", "Sailing"},{"What is the primary governing body for international soccer?", "FIFA", "UEFA", "CONCACAF", "CONMEBOL", "AFC", "OFC"},{"Who was the first player to score 100 points in a single NBA game?", "Wilt Chamberlain", "Kobe Bryant", "Michael Jordan", "Bill Russell", "Larry Bird", "Magic Johnson"},{"In which year did the Summer Olympics take place in Beijing?", "2008", "2004", "2012", "2000", "1996", "2016"},{"What is the term for the final match in a tennis tournament?", "Finals", "Quarterfinals", "Semifinals", "Championship", "Playoff", "Round robin"},{"Which sport features a ball that must be thrown into a hoop?", "Basketball", "Soccer", "Baseball", "Hockey", "Volleyball", "Rugby"},{"Which athlete was known as 'The Greatest Show on Earth'?", "Pele", "Muhammad Ali", "Babe Ruth", "Tiger Woods", "Michael Jordan", "Usain Bolt"},{"Which country won the 2018 FIFA World Cup?", "France", "Croatia", "Brazil", "Germany", "Argentina", "Spain"},{"What is the name of the trophy awarded to the winner of the Stanley Cup Finals?", "Stanley Cup", "Vezina Trophy", "Hart Memorial Trophy", "Lady Byng Memorial Trophy", "Calder Memorial Trophy", "Conn Smythe Trophy"},{"Who was the first woman to run the Boston Marathon?", "Bobbi Gibb", "Kathrine Switzer", "Joan Benoit Samuelson", "Grete Waitz", "Mara Yamauchi", "Shalane Flanagan"},{"What is the term for the distance swum in an Olympic swimming pool?", "50 meters", "25 meters", "30 meters", "100 meters", "75 meters", "200 meters"},{"Which NFL quarterback is known for winning six Super Bowl titles?", "Tom Brady", "Joe Montana", "Terry Bradshaw", "Peyton Manning", "Drew Brees", "Johnny Unitas"},{"What is the main goal in the game of rugby?", "Score tries", "Kick goals", "Touch down", "Pass", "Tackle", "Run"},{"Which country is known for the sport of sumo wrestling?", "Japan", "China", "Korea", "Mongolia", "Thailand", "Vietnam"},{"In golf, what does the term 'par' refer to?", "Expected number of strokes", "A hole-in-one", "Total score", "Over par", "Under par", "Golf ball"},{"What is the traditional distance of a steeplechase race?", "3000 meters", "5000 meters", "10000 meters", "1500 meters", "2000 meters", "4000 meters"},{"Which American city is home to the Chicago Marathon?", "Chicago", "New York", "Los Angeles", "Boston", "Seattle", "Houston"},{"What is the term for a player who scores a hat-trick in soccer?", "Three goals", "One goal", "Two goals", "Four goals", "Five goals", "No goals"},{"Which sport uses terms like 'paddle', 'serve', and 'smash'?", "Badminton", "Squash", "Tennis", "Table Tennis", "Pickleball", "Racquetball"},{"Who was the first athlete to appear on the cover of Sports Illustrated?", "Eddie Mathews", "Mickey Mantle", "Ted Williams", "Jackie Robinson", "Joe DiMaggio", "Babe Ruth"},{"What sport involves the use of a oar and a boat on water?", "Rowing", "Canoeing", "Kayaking", "Sailing", "Fishing", "Surfing"},{"Which Olympic event includes the decathlon and heptathlon?", "Track and field", "Swimming", "Gymnastics", "Cycling", "Boxing", "Wrestling"},{"In which sport would you find the term 'alley-oop'?", "Basketball", "Football", "Baseball", "Volleyball", "Hockey", "Rugby"},{"What is the name of the governing body for international rugby union?", "World Rugby", "FIFA", "IOC", "NCAA", "NFL", "NHL"},{"Which country has the most medals in Olympic history?", "United States", "Russia", "China", "Germany", "Great Britain", "France"},{"What is the scoring system in volleyball?", "Rally scoring", "Point scoring", "Game scoring", "Set scoring", "Match scoring", "Serve scoring"},{"Which sport is played on a diamond-shaped field?", "Baseball", "Soccer", "Hockey", "Rugby", "Cricket", "Lacrosse"},{"In swimming, what is the stroke that involves moving arms in a windmill motion?", "Freestyle", "Breaststroke", "Backstroke", "Butterfly", "Individual medley", "Relay"},{"What is the name of the annual college football championship game in the U.S.?", "College Football Playoff National Championship", "Bowl Championship Series", "Cotton Bowl", "Rose Bowl", "Sugar Bowl", "Orange Bowl"},{"Which athlete is known as 'The Flying Tomato'?", "Shaun White", "Michael Phelps", "Usain Bolt", "Tony Hawk", "Bode Miller", "Lindsey Vonn"},{"Which sport features the event known as the 'Triple Jump'?", "Athletics", "Swimming", "Gymnastics", "Wrestling", "Rugby", "Soccer"},{"In which sport would you use a 'cue'?", "Billiards", "Bowling", "Darts", "Poker", "Rugby", "Hockey"},{"Who said 'I think, therefore I am'?", "Rene Descartes", "Albert Einstein", "Socrates", "Galileo Galilei", "Isaac Newton", "Plato"},{"Who is famous for the quote 'The only thing we have to fear is fear itself'?", "Franklin D. Roosevelt", "Winston Churchill", "John F. Kennedy", "Theodore Roosevelt", "Dwight D. Eisenhower", "Abraham Lincoln"},{"Who said 'I have a dream'?", "Martin Luther King Jr.", "Malcolm X", "Barack Obama", "Nelson Mandela", "Mahatma Gandhi", "Jesse Jackson"},{"Who is credited with the quote 'To be or not to be, that is the question'?", "William Shakespeare", "Charles Dickens", "Jane Austen", "Homer", "Dante Alighieri", "Geoffrey Chaucer"},{"Who said 'That's one small step for man, one giant leap for mankind'?", "Neil Armstrong", "Buzz Aldrin", "Yuri Gagarin", "John Glenn", "Michael Collins", "Alan Shepard"},{"Who famously said 'Give me liberty, or give me death!'?", "Patrick Henry", "George Washington", "Thomas Jefferson", "Alexander Hamilton", "John Adams", "James Madison"},{"Who is known for saying 'Knowledge is power'?", "Francis Bacon", "Voltaire", "Galileo Galilei", "John Locke", "Aristotle", "Confucius"},{"Who said 'The unexamined life is not worth living'?", "Socrates", "Plato", "Aristotle", "Confucius", "Epicurus", "Marcus Aurelius"},{"Who declared 'I am the greatest'?", "Muhammad Ali", "Mike Tyson", "Michael Jordan", "Babe Ruth", "Pele", "Usain Bolt"},{"Who is known for the quote 'An eye for an eye only ends up making the whole world blind'?", "Mahatma Gandhi", "Nelson Mandela", "Martin Luther King Jr.", "Albert Einstein", "Dalai Lama", "Mother Teresa"},{"Who said 'Float like a butterfly, sting like a bee'?", "Muhammad Ali", "Bruce Lee", "Sugar Ray Leonard", "Joe Frazier", "Mike Tyson", "Jack Dempsey"},{"Who is famous for saying 'Imagination is more important than knowledge'?", "Albert Einstein", "Isaac Newton", "Nikola Tesla", "Stephen Hawking", "Leonardo da Vinci", "Galileo Galilei"},{"Who said 'Ask not what your country can do for you, ask what you can do for your country'?", "John F. Kennedy", "Franklin D. Roosevelt", "Abraham Lincoln", "Ronald Reagan", "Theodore Roosevelt", "George Washington"},{"Who said 'In the end, we will remember not the words of our enemies, but the silence of our friends'?", "Martin Luther King Jr.", "Nelson Mandela", "Mahatma Gandhi", "Frederick Douglass", "Harriet Tubman", "Malcolm X"},{"Who said 'I came, I saw, I conquered'?", "Julius Caesar", "Alexander the Great", "Napoleon Bonaparte", "Hannibal", "Cleopatra", "Marcus Aurelius"},{"Who said 'The only way to do great work is to love what you do'?", "Steve Jobs", "Bill Gates", "Elon Musk", "Warren Buffett", "Richard Branson", "Jeff Bezos"},{"Who said 'Genius is one percent inspiration, ninety-nine percent perspiration'?", "Thomas Edison", "Albert Einstein", "Nikola Tesla", "Leonardo da Vinci", "Stephen Hawking", "Galileo Galilei"},{"Who famously said 'Et tu, Brute?'?", "Julius Caesar", "Augustus Caesar", "Nero", "Brutus", "Cassius", "Caligula"},{"Who is known for the quote 'I think, therefore I am'?", "Rene Descartes", "Socrates", "Plato", "Jean-Jacques Rousseau", "Voltaire", "Thomas Hobbes"},{"Who said 'The future belongs to those who believe in the beauty of their dreams'?", "Eleanor Roosevelt", "Oprah Winfrey", "Maya Angelou", "Marie Curie", "Margaret Thatcher", "Audrey Hepburn"},{"Who is known for saying 'If you tell the truth, you don't have to remember anything'?", "Mark Twain", "Oscar Wilde", "Ernest Hemingway", "Charles Dickens", "Leo Tolstoy", "F. Scott Fitzgerald"},{"Who said 'It is never too late to be what you might have been'?", "George Eliot", "Oscar Wilde", "Jane Austen", "Virginia Woolf", "Emily Dickinson", "Louisa May Alcott"},{"Who said 'Be the change you wish to see in the world'?", "Mahatma Gandhi", "Mother Teresa", "Nelson Mandela", "Martin Luther King Jr.", "Albert Einstein", "The Dalai Lama"},{"Who famously said 'I think, therefore I am'?", "Rene Descartes", "Plato", "Aristotle", "Socrates", "Francis Bacon", "Blaise Pascal"},{"Who said 'The only thing we have to fear is fear itself'?", "Franklin D. Roosevelt", "John F. Kennedy", "Abraham Lincoln", "Winston Churchill", "Theodore Roosevelt", "Woodrow Wilson"},{"Who declared 'I have nothing to offer but blood, toil, tears, and sweat'?", "Winston Churchill", "Franklin D. Roosevelt", "Charles de Gaulle", "Adolf Hitler", "Joseph Stalin", "Benito Mussolini"},{"Who said 'Success is not final, failure is not fatal: It is the courage to continue that counts'?", "Winston Churchill", "Albert Einstein", "Mark Twain", "Theodore Roosevelt", "Abraham Lincoln", "Nelson Mandela"},{"Who famously said 'Do or do not, there is no try'?", "Yoda", "Darth Vader", "Obi-Wan Kenobi", "Gandalf", "Harry Potter", "Hercules"},{"Who is known for the quote 'A journey of a thousand miles begins with a single step'?", "Lao Tzu", "Confucius", "Sun Tzu", "Buddha", "Homer", "Socrates"},{"Who said 'Insanity is doing the same thing over and over and expecting different results'?", "Albert Einstein", "Sigmund Freud", "Thomas Edison", "Carl Jung", "Isaac Newton", "Charles Darwin"},{"Who said 'You must be the change you wish to see in the world'?", "Mahatma Gandhi", "Nelson Mandela", "Martin Luther King Jr.", "Mother Teresa", "Dalai Lama", "Eleanor Roosevelt"},{"Who is famous for saying 'With great power comes great responsibility'?", "Uncle Ben (Spider-Man)", "Superman", "Batman", "Wonder Woman", "Iron Man", "Professor X"},{"Who said 'The only limit to our realization of tomorrow is our doubts of today'?", "Franklin D. Roosevelt", "John F. Kennedy", "Nelson Mandela", "Winston Churchill", "Ronald Reagan", "Barack Obama"},{"Who said 'If you're going through hell, keep going'?", "Winston Churchill", "Franklin D. Roosevelt", "Theodore Roosevelt", "Abraham Lincoln", "Napoleon Bonaparte", "Nelson Mandela"},{"Who said 'Education is the most powerful weapon you can use to change the world'?", "Nelson Mandela", "Martin Luther King Jr.", "Mahatma Gandhi", "Eleanor Roosevelt", "Albert Einstein", "Malala Yousafzai"},{"Who said 'Injustice anywhere is a threat to justice everywhere'?", "Martin Luther King Jr.", "Malcolm X", "Nelson Mandela", "Mahatma Gandhi", "Frederick Douglass", "Abraham Lincoln"},{"Who said 'I have not failed. I've just found 10,000 ways that won't work'?", "Thomas Edison", "Albert Einstein", "Isaac Newton", "Galileo Galilei", "Nikola Tesla", "Leonardo da Vinci"},{"Who said 'All men are created equal'?", "Thomas Jefferson", "George Washington", "Abraham Lincoln", "John Adams", "James Madison", "Benjamin Franklin"},{"Who said 'The pen is mightier than the sword'?", "Edward Bulwer-Lytton", "William Shakespeare", "Charles Dickens", "John Milton", "Victor Hugo", "Oscar Wilde"},{"Who said 'A house divided against itself cannot stand'?", "Abraham Lincoln", "George Washington", "Thomas Jefferson", "Alexander Hamilton", "Benjamin Franklin", "John Adams"},{"Who famously said 'I disapprove of what you say, but I will defend to the death your right to say it'?", "Voltaire", "Jean-Jacques Rousseau", "Montesquieu", "Diderot", "Rene Descartes", "Francis Bacon"},{"Who said 'The greatest glory in living lies not in never falling, but in rising every time we fall'?", "Nelson Mandela", "Winston Churchill", "Franklin D. Roosevelt", "Mahatma Gandhi", "Martin Luther King Jr.", "Albert Einstein"},{"Who said 'Success usually comes to those who are too busy to be looking for it'?", "Henry David Thoreau", "Thomas Edison", "Albert Einstein", "Mark Twain", "Winston Churchill", "Nikola Tesla"},{"Who said 'The best way to predict the future is to create it'?", "Peter Drucker", "Steve Jobs", "Elon Musk", "Albert Einstein", "Henry Ford", "Warren Buffett"},{"Who said 'If you want something said, ask a man; if you want something done, ask a woman'?", "Margaret Thatcher", "Eleanor Roosevelt", "Marie Curie", "Rosa Parks", "Indira Gandhi", "Golda Meir"},{"Who said 'A fool thinks himself to be wise, but a wise man knows himself to be a fool'?", "William Shakespeare", "Socrates", "Plato", "Aristotle", "Benjamin Franklin", "Confucius"},{"Who famously said 'When you reach the end of your rope, tie a knot in it and hang on'?", "Franklin D. Roosevelt", "Abraham Lincoln", "Theodore Roosevelt", "Winston Churchill", "John F. Kennedy", "George Washington"},{"Who said 'Life is what happens when you're busy making other plans'?", "John Lennon", "Bob Dylan", "Paul McCartney", "George Harrison", "Mick Jagger", "Jim Morrison"},{"Who said 'The journey of a thousand miles begins with one step'?", "Lao Tzu", "Buddha", "Confucius", "Sun Tzu", "Aristotle", "Socrates"},{"Who is known for the quote 'Be yourself; everyone else is already taken'?", "Oscar Wilde", "Mark Twain", "Ernest Hemingway", "Charles Dickens", "Jane Austen", "George Bernard Shaw"},{"Who is known for developing the hierarchy of needs?", "Abraham Maslow", "Carl Rogers", "Sigmund Freud", "B.F. Skinner", "Jean Piaget", "Erik Erikson"},{"Which psychological concept refers to the tendency to attribute one's successes to internal factors and failures to external factors?", "Self-serving bias", "Fundamental attribution error", "Confirmation bias", "Cognitive dissonance", "Hindsight bias", "Actor-observer effect"},{"Who introduced the concept of operant conditioning?", "B.F. Skinner", "John Watson", "Ivan Pavlov", "Albert Bandura", "Carl Rogers", "Sigmund Freud"},{"Which disorder is characterized by recurrent and unexpected panic attacks?", "Panic disorder", "Generalized anxiety disorder", "Social anxiety disorder", "Agoraphobia", "Obsessive-compulsive disorder", "Post-traumatic stress disorder"},{"Who is associated with the development of the psychosexual stages of development?", "Sigmund Freud", "Carl Jung", "Erik Erikson", "Jean Piaget", "Abraham Maslow", "Alfred Adler"},{"Which therapy approach focuses on changing negative thought patterns?", "Cognitive-behavioral therapy (CBT)", "Psychoanalytic therapy", "Humanistic therapy", "Gestalt therapy", "Behavioral therapy", "Existential therapy"},{"What term describes the process of unlearning a conditioned response?", "Extinction", "Habituation", "Desensitization", "Generalization", "Counterconditioning", "Reinforcement"},{"Which type of study involves observing behavior in a natural environment without manipulation?", "Naturalistic observation", "Experimental study", "Case study", "Survey", "Longitudinal study", "Cross-sectional study"},{"Who developed the theory of cognitive development in children?", "Jean Piaget", "Lev Vygotsky", "Erik Erikson", "Sigmund Freud", "Carl Rogers", "Albert Bandura"},{"What is the term for the mental process of organizing and interpreting sensory information?", "Perception", "Sensation", "Cognition", "Attention", "Memory", "Learning"},{"Which disorder is characterized by persistent feelings of sadness and loss of interest?", "Major depressive disorder", "Bipolar disorder", "Dysthymia", "Seasonal affective disorder", "Generalized anxiety disorder", "Schizophrenia"},{"Who introduced the concept of the collective unconscious?", "Carl Jung", "Sigmund Freud", "Alfred Adler", "Erik Erikson", "William James", "Abraham Maslow"},{"Which psychological approach emphasizes the importance of free will and personal growth?", "Humanistic psychology", "Behaviorism", "Cognitive psychology", "Psychoanalysis", "Social psychology", "Evolutionary psychology"},{"What is the primary focus of cognitive-behavioral therapy (CBT)?", "Changing negative thought patterns", "Exploring unconscious motives", "Fostering self-actualization", "Improving interpersonal relationships", "Addressing childhood experiences", "Modifying behavior through reinforcement"},{"Which concept refers to the mental shortcuts that ease the cognitive load of making decisions?", "Heuristics", "Biases", "Schemas", "Cognitive distortions", "Attribution", "Framing"},{"What type of bias occurs when a person's expectations influence their perception of reality?", "Expectation bias", "Confirmation bias", "Observer effect", "Hindsight bias", "Anchoring bias", "Self-serving bias"},{"Which disorder involves the experience of intrusive and unwanted thoughts accompanied by compulsive behaviors?", "Obsessive-compulsive disorder (OCD)", "Generalized anxiety disorder", "Panic disorder", "Social anxiety disorder", "Phobia", "Post-traumatic stress disorder"},{"Who is known for the concept of social learning theory?", "Albert Bandura", "B.F. Skinner", "John Watson", "Sigmund Freud", "Carl Rogers", "Erik Erikson"},{"What is the term for a sudden loss of memory or identity, often following a traumatic event?", "Dissociative amnesia", "Dissociative fugue", "Post-traumatic stress disorder", "Depersonalization", "Anxiety disorder", "Conversion disorder"},{"Which psychological term describes the tendency to favor information that confirms one's preexisting beliefs?", "Confirmation bias", "Cognitive dissonance", "Self-serving bias", "Anchoring bias", "Framing effect", "Fundamental attribution error"},{"Who developed the theory of multiple intelligences?", "Howard Gardner", "Daniel Goleman", "Robert Sternberg", "Jean Piaget", "Lev Vygotsky", "Carl Rogers"},{"What is the primary purpose of a psychological assessment?", "To evaluate and understand behavior", "To diagnose mental disorders", "To measure intelligence", "To administer therapy", "To prescribe medication", "To conduct research"},{"Which neurotransmitter is often linked to mood regulation and is implicated in depression?", "Serotonin", "Dopamine", "Norepinephrine", "Acetylcholine", "Glutamate", "GABA"},{"What psychological phenomenon refers to the tendency to attribute one's own thoughts, feelings, and motives to others?", "Projection", "Displacement", "Transference", "Rationalization", "Sublimation", "Denial"},{"Which term refers to the psychological tension that arises from holding two conflicting beliefs?", "Cognitive dissonance", "Anxiety", "Depression", "Compulsion", "Obsessive thought", "Social anxiety"},{"Who is credited with the development of client-centered therapy?", "Carl Rogers", "Sigmund Freud", "B.F. Skinner", "Albert Ellis", "Aaron Beck", "Virginia Satir"},{"What psychological theory focuses on the impact of society and culture on behavior?", "Social psychology", "Cognitive psychology", "Behaviorism", "Humanistic psychology", "Psychoanalysis", "Biopsychology"},{"Which psychological condition is characterized by excessive worry about various aspects of life?", "Generalized anxiety disorder", "Panic disorder", "Social anxiety disorder", "Phobia", "Obsessive-compulsive disorder", "Post-traumatic stress disorder"},{"What is the main focus of existential psychology?", "The search for meaning in life", "Behavioral modification", "Cognitive restructuring", "Emotional healing", "Social interaction", "Unconscious desires"},{"Which defense mechanism involves refusing to accept reality or facts?", "Denial", "Repression", "Rationalization", "Displacement", "Sublimation", "Projection"},{"What is the term for a therapeutic approach that focuses on understanding and changing maladaptive behavior?", "Behavioral therapy", "Cognitive therapy", "Humanistic therapy", "Psychoanalytic therapy", "Existential therapy", "Systemic therapy"},{"Who proposed the theory of psychosexual development?", "Sigmund Freud", "Carl Jung", "Erik Erikson", "Abraham Maslow", "Alfred Adler", "John Bowlby"},{"What is the primary focus of positive psychology?", "Well-being and personal strengths", "Mental illness treatment", "Behavior modification", "Cognitive restructuring", "Interpersonal relationships", "Child development"},{"Which psychological concept describes the phenomenon of learning by observing others?", "Modeling", "Conditioning", "Im printing", "Reinforcement", "Habit formation", "Cognition"},{"What is the main focus of psychodynamic therapy?", "Exploring unconscious processes", "Changing behavior patterns", "Improving cognitive functions", "Enhancing social skills", "Addressing nutrition", "Developing emotional intelligence"},{"Who is known for his work on the stages of psychosocial development?", "Erik Erikson", "Sigmund Freud", "Jean Piaget", "Carl Rogers", "Abraham Maslow", "Lev Vygotsky"},{"What term describes the process by which individuals learn to associate a behavior with a consequence?", "Operant conditioning", "Classical conditioning", "Observational learning", "Cognitive restructuring", "Habit formation", "Sublimation"},{"Which psychological disorder involves a persistent pattern of inattention and/or hyperactivity-impulsivity?", "Attention-deficit hyperactivity disorder (ADHD)", "Anxiety disorder", "Mood disorder", "Obsessive-compulsive disorder", "Post-traumatic stress disorder", "Schizophrenia"},{"What term refers to the study of how people perceive and think about themselves and others?", "Social cognition", "Behavioral psychology", "Cognitive psychology", "Developmental psychology", "Clinical psychology", "Cultural psychology"},{"Who developed the concept of emotional intelligence?", "Daniel Goleman", "Howard Gardner", "Robert Sternberg", "Carl Rogers", "Sigmund Freud", "Erik Erikson"},{"What psychological concept refers to the ability to manage and regulate one's emotions?", "Emotional intelligence", "Cognitive dissonance", "Resilience", "Self-efficacy", "Self-regulation", "Social intelligence"},{"Which type of therapy focuses on changing unhelpful cognitive distortions and behaviors?", "Cognitive-behavioral therapy (CBT)", "Psychoanalytic therapy", "Humanistic therapy", "Gestalt therapy", "Transpersonal therapy", "Play therapy"},{"What term describes the tendency to evaluate one's own abilities and opinions by comparing oneself to others?", "Social comparison", "Self-perception", "Reference group", "Cognitive dissonance", "Fundamental attribution error", "Self-esteem"},{"Who proposed the idea of the 'id,' 'ego,' and 'superego'?", "Sigmund Freud", "Carl Jung", "Alfred Adler", "Erik Erikson", "B.F. Skinner", "Abraham Maslow"},{"What is the term for a psychological disorder characterized by extreme mood swings?", "Bipolar disorder", "Major depressive disorder", "Generalized anxiety disorder", "Obsessive-compulsive disorder", "Schizophrenia", "Borderline personality disorder"},{"Which psychological approach emphasizes the role of the environment in shaping behavior?", "Behaviorism", "Cognitive psychology", "Humanistic psychology", "Psychoanalysis", "Gestalt psychology", "Biopsychology"},{"Who is known for his research on attachment theory?", "John Bowlby", "Erik Erikson", "Sigmund Freud", "B.F. Skinner", "Albert Bandura", "Carl Rogers"},{"What is the primary focus of behavior therapy?", "Changing maladaptive behaviors", "Exploring unconscious motivations", "Developing cognitive skills", "Enhancing emotional awareness", "Improving interpersonal relationships", "Promoting personal growth"},{"Which psychological phenomenon involves the tendency to underestimate the influence of situational factors on others' behavior?", "Fundamental attribution error", "Self-serving bias", "Cognitive dissonance", "Hindsight bias", "Confirmation bias", "Actor-observer bias"},{"What term describes the process by which individuals justify their decisions after the fact?", "Hindsight bias", "Cognitive dissonance", "Self-justification", "Rationalization", "Overconfidence effect", "Anchoring effect"},{"What is the only known mammal capable of true sustained flight?", "Bat", "Flying squirrel", "Sugar glider", "Flying lemur", "Eagle", "Falcon"},{"Which bird has the longest wingspan of any living species?", "Wandering albatross", "Bald eagle", "Peregrine falcon", "Golden eagle", "Andean condor", "Great white pelican"},{"What is the main food source of the manatee?", "Seagrass", "Algae", "Small fish", "Krill", "Plankton", "Coral"},{"Which animal's eye is larger than its brain?", "Ostrich", "Elephant", "Horse", "Tiger", "Camel", "Blue whale"},{"What unique defense mechanism does the sea cucumber have?", "Ejecting internal organs", "Spraying venom", "Changing colors", "Producing loud sounds", "Inflating its body", "Releasing ink"},{"Which animal has the thickest fur of any mammal?", "Sea otter", "Polar bear", "Arctic fox", "Siberian tiger", "Beaver", "Grizzly bear"},{"How many hearts does an octopus have?", "Three", "One", "Two", "Four", "Five", "Seven"},{"Which mammal has the highest blood pressure?", "Giraffe", "Elephant", "Blue whale", "Hippopotamus", "Rhino", "Polar bear"},{"What is the primary diet of the snow leopard?", "Blue sheep", "Mountain goats", "Pikas", "Hares", "Rodents", "Deer"},{"What type of creature is a pangolin?", "Mammal", "Reptile", "Amphibian", "Bird", "Insect", "Fish"},{"Which animal can regenerate its heart and brain if injured?", "Axolotl", "Starfish", "Octopus", "Newt", "Lungfish", "Salamander"},{"What type of venom does a blue-ringed octopus release?", "Tetrodotoxin", "Cytotoxin", "Hemotoxin", "Neurotoxin", "Myotoxin", "Necrotoxin"},{"Which animal's finger prints are so similar to humans that they could be mistaken at a crime scene?", "Koala", "Chimpanzee", "Orangutan", "Raccoon", "Baboon", "Panda"},{"Which bird can sleep while flying?", "Alpine swift", "Pigeon", "Falcon", "Hawk", "Vulture", "Eagle"},{"What is the only venomous primate?", "Slow loris", "Tarsier", "Aye-aye", "Lemur", "Spider monkey", "Capuchin monkey"},{"What unique trait does the male seahorse have?", "Carries and births offspring", "Changes color when mating", "Produces venom", "Can regrow fins", "Hibernates", "Breathes through its skin"},{"Which animal has a tongue that can reach up to one and a half times its body length?", "Chameleon", "Anteater", "Giraffe", "Hummingbird", "Pangolin", "Echidna"},{"Which animal does not have vocal cords?", "Giraffe", "Koala", "Tiger", "Horse", "Goat", "Deer"},{"Which marine animal can weigh up to 200 tons?", "Blue whale", "Sperm whale", "Great white shark", "Orca", "Dolphin", "Manatee"},{"What kind of animal is a quokka?", "Marsupial", "Rodent", "Reptile", "Amphibian", "Bird", "Fish"},{"Which animal can change its sex multiple times in its lifetime?", "Clownfish", "Octopus", "Seahorse", "Jellyfish", "Swordfish", "Lobster"},{"What is the only mammal immune to most types of snake venom?", "Honey badger", "Mongoose", "Armadillo", "Hedgehog", "Opossum", "Meerkat"},{"What animal has no known natural predators?", "Orca", "Komodo dragon", "Lion", "Polar bear", "Great white shark", "Tiger"},{"What is the fastest marine animal?", "Black marlin", "Blue whale", "Great white shark", "Dolphin", "Orca", "Tuna"},{"What type of animal is an axolotl?", "Amphibian", "Fish", "Reptile", "Insect", "Mammal", "Bird"},{"Which reptile is known to live the longest?", "Tortoise", "Alligator", "Komodo dragon", "Iguana", "Crocodile", "Gecko"},{"What type of animal is the aye-aye?", "Lemur", "Monkey", "Squirrel", "Porcupine", "Raccoon", "Bat"},{"What animal can hold its breath for over an hour underwater?", "Sea turtle", "Dolphin", "Seal", "Otter", "Penguin", "Swan"},{"What type of animal is the vaquita?", "Porpoise", "Seal", "Dolphin", "Manatee", "Sea otter", "Beluga whale"},{"Which animal can sleep with one half of its brain awake?", "Dolphin", "Shark", "Owl", "Cat", "Rabbit", "Elephant"},{"What animal has the largest brain relative to body size?", "Tree shrew", "Elephant", "Human", "Dolphin", "Octopus", "Whale"},{"Which animal is known for using tools to hunt?", "Dolphin", "Orca", "Seal", "Penguin", "Otter", "Sea lion"},{"What animal has the longest migration distance?", "Arctic tern", "Monarch butterfly", "Gray whale", "Humpback whale", "Caribou", "Elephant seal"},{"Which fish is known to produce electric fields?", "Electric eel", "Pufferfish", "Clownfish", "Salmon", "Mackerel", "Shark"},{"What mammal has the most teeth?", "Giant armadillo", "Elephant", "Hippo", "Jaguar", "Lion", "Otter"},{"What animal produces a slime used for defense and hunting?", "Hagfish", "Squid", "Octopus", "Starfish", "Sea cucumber", "Salmon"},{"What type of fish can survive being frozen?", "Antarctic icefish", "Salmon", "Carp", "Goldfish", "Tuna", "Bass"},{"Which animal can live over 500 years?", "Greenland shark", "Bowhead whale", "Giant tortoise", "Lobster", "Oyster", "Jellyfish"},{"Which bird is known for diving at speeds over 200 mph?", "Peregrine falcon", "Eagle", "Osprey", "Albatross", "Owl", "Kestrel"},{"What animal can squirt blood from its eyes to scare predators?", "Horned lizard", "Komodo dragon", "Gila monster", "Frilled lizard", "Gecko", "Iguana"},{"What fish can change from female to male?", "Clownfish", "Salmon", "Shark", "Trout", "Pufferfish", "Bass"},{"Which animal has a detachable tail to escape predators?", "Gecko", "Snake", "Frog", "Spider", "Lizard", "Rabbit"},{"Which insect is known to live the longest?", "Termite queen", "Honey bee", "Ant", "Dragonfly", "Butterfly", "Beetle"},{"Which mammal is capable of deep-sea diving up to 10,000 feet?", "Cuvier's beaked whale", "Sperm whale", "Orca", "Blue whale", "Elephant seal", "Harp seal"},{"What bird has a claw-like appendage on its wings as a chick?", "Hoatzin", "Eagle", "Ostrich", "Flamingo", "Stork", "Penguin"},{"What creature is known for creating underwater 'crop circles'?", "Pufferfish", "Octopus", "Dolphin", "Sea turtle", "Crab", "Stingray"},{"Which creature is bioluminescent and often found in the deep sea?", "Anglerfish", "Shark", "Octopus", "Dolphin", "Jellyfish", "Lobster"},{"Which reptile has a tongue longer than its body?", "Chameleon", "Gecko", "Komodo dragon", "Iguana", "Snake", "Monitor lizard"},{"Which animal has scales made of the same protein as human fingernails?", "Pangolin", "Snake", "Fish", "Turtle", "Iguana", "Chameleon"},{"What animal is known for its unique rectangular pupils?", "Goat", "Cat", "Dog", "Horse", "Rabbit", "Elephant"},{"Which animal is known to have the largest brain-to-body ratio?", "The ant", "The human", "The blue whale", "The bottlenose dolphin", "The African grey parrot", "The elephant"},{"What is the term for the process by which certain species develop physical or behavioral traits that help them survive in their environment?", "Natural selection", "Genetic drift", "Speciation", "Mutation", "Adaptation", "Co-evolution"},{"Which animal is known for its ability to regenerate lost body parts, including limbs and even parts of its heart?", "Axolotl", "Starfish", "Planarian", "Newt", "Lizard", "Octopus"},{"What is the largest living species of lizard?", "Komodo dragon", "Iguana", "Monitor lizard", "Bearded dragon", "Chameleon", "Gecko"},{"Which marine mammal is known for its complex vocalizations, often referred to as songs?", "Humpback whale", "Orca", "Beluga whale", "Dolphin", "Sperm whale", "Narwhal"},{"Which animal has the longest migration of any terrestrial mammal?", "Caribou", "Wildebeest", "Elephant", "Zebra", "Bison", "Reindeer"},{"What is the primary diet of the giant panda?", "Bamboo", "Meat", "Fruits", "Leaves", "Insects", "Fish"},{"Which insect is known for its highly organized social structure and division of labor?", "Honeybee", "Ant", "Termite", "Wasp", "Dragonfly", "Beetle"},{"Which bird is capable of mimicry and can imitate human speech and sounds from its environment?", "African grey parrot", "Mockingbird", "Lyrebird", "Blue jay", "Cockatoo", "Canary"},{"What is the fastest land animal?", "Cheetah", "Pronghorn antelope", "Lion", "Horse", "Greyhound", "Gazelle"},{"Which amphibian is known for its ability to survive extreme dehydration by entering a state of cryptobiosis?", "Surinam toad", "Wood frog", "Axolotl", "African clawed frog", "Tiger salamander", "Red-eyed tree frog"},{"Which animal has a heart that can beat for up to 30 minutes after being decapitated?", "Cockroach", "Grasshopper", "Frog", "Lizard", "Cricket", "Snail"},{"Which mammal is known for having the highest known body temperature?", "Fennec fox", "Camel", "Elephant", "African wild dog", "Horses", "Kangaroo"},{"Which reptile can produce a venom that can kill a human in less than an hour?", "Inland taipan", "Black mamba", "King cobra", "Gila monster", "Banded sea krait", "Gaboon viper"},{"Which species of fish is known for its ability to change gender during its lifetime?", "Clownfish", "Wrasse", "Grouper", "Parrotfish", "Seahorse", "Catfish"},{"What is the only known mammal that can fly?", "Bat", "Flying squirrel", "Colugo", "Flying fox", "Sugar glider", "Petaurus"},{"Which type of animal has a specialized gland to secrete venom that can be used for defense and hunting?", "Snake", "Lizard", "Spiders", "Scorpions", "Certain frogs", "Cone snail"},{"Which bird is considered the most intelligent non-human animal, capable of solving complex problems?", "Corvids (crows and ravens)", "Parrots", "Pigeons", "Magpies", "Macaws", "Doves"},{"Which mammal has the longest gestation period?", "African elephant", "Blue whale", "Hippopotamus", "Giraffe", "Orca", "Sperm whale"},{"Which animal uses echolocation to navigate and hunt?", "Bats", "Dolphins", "Certain species of birds", "Mice", "Shrews", "Whales"},{"Which marine animal has the ability to produce bioluminescent light?", "Lanternfish", "Deep-sea jellyfish", "Firefly squid", "Cookiecutter shark", "Gulper eel", "All of the above"},{"What is the primary diet of the leafcutter ant?", "Fungi", "Leaves", "Nectar", "Seeds", "Insects", "Bark"},{"Which bird is known for its elaborate courtship dance and vibrant plumage?", "Bird of paradise", "Peacock", "Flamingo", "Macaw", "Swallow", "Canary"},{"Which animal has been found to have a unique finger print pattern similar to humans?", "Koala", "Dolphin", "Chimpanzee", "Gorilla", "Orangutan", "Aye-aye"},{"What type of symbiotic relationship is observed between clownfish and sea anemones?", "Mutualism", "Commensalism", "Parasitism", "Predation", "Competition", "Neutralism"},{"Which animal is known for having the fastest metabolism?", "Shrew", "Hummingbird", "Mouse", "Bat", "Frog", "Lizard"},{"What is the term for animals that are active during the night?", "Nocturnal", "Diurnal", "Crepuscular", "Seasonal", "Endemic", "Migratory"},{"Which animal can survive without water longer than a camel?", "Tarantula", "Fennec fox", "Cockroach", "Kangaroo rat", "Desert tortoise", "Scorpion"},{"Which insect is capable of lifting objects over 50 times its own body weight?", "Dung beetle", "Ant", "Beetle", "Termite", "Butterfly", "Grasshopper"},{"Which mammal is known to have a highly developed sense of smell, used for hunting?", "Bloodhound", "Wolf", "Bear", "Elephant", "Rat", "Cat"},{"Which fish species is known for its vibrant coloration and is a popular aquarium fish?", "Clownfish", "Guppy", "Neon tetra", "Betta", "Angelfish", "Zebra danio"},{"Which animal has the ability to mimic the sounds of chainsaws, camera shutters, and car alarms?", "Lyrebird", "African grey parrot", "Mockingbird", "Starling", "Crows", "Magpie"},{"What is the largest species of rodent in the world?", "Capybara", "Beaver", "Nutria", "Porcupine", "Guinea pig", "Squirrel"},{"Which animal has the longest lifespan of any terrestrial mammal?", "Elephant", "Greenland shark", "Bowhead whale", "Giant tortoise", "Ostrich", "Humpback whale"},{"What unique feature do male seahorses have during reproduction?", "They carry the eggs", "They build nests", "They sing to their mates", "They change colors", "They perform dances", "They protect the fry"},{"Which animal is known for its ability to see ultraviolet light?", "Mantis shrimp", "Honeybee", "Pigeon", "Certain species of birds", "Reindeer", "Cat"},{"What type of animal is a cassowary?", "Bird", "Mammal", "Reptile", "Amphibian", "Fish", "Insect"},{"Which animal is considered to have the most powerful bite relative to its size?", "Saltwater crocodile", "Great white shark", "Jaguar", "Hyena", "Lion", "Tyrannosaurus rex (extinct)"},{"Which mammal is known for using tools to obtain food?", "Chimpanzee", "Dolphin", "Orangutan", "Elephant", "Corvids", "All of the above"},{"Which species of penguin is the largest?", "Emperor penguin", "King penguin", "Adelie penguin", "Chinstrap penguin", "Gentoo penguin", "Little blue penguin"},{"What is the term for animals that live in trees?", "Arboreal", "Terrestrial", "Aquatic", "Fossorial", "Aerial", "Endemic"},{"Which animal is known for its ability to survive in extreme cold temperatures?", "Arctic fox", "Polar bear", "Snow leopard", "Walrus", "Musk ox", "Penguin"},{"What is the primary defense mechanism of the octopus?", "Camouflage", "Ink expulsion", "Speed", "Shell", "Poison", "Flight"},{"Which animal is famous for its unique gait, known as the 'pacing' walk?", "Horse", "Camel", "Elephant", "Zebra", "Giraffe", "Tapir"},{"Which animal's milk is the richest in fat content?", "Hooded seal", "Cow", "Goat", "Buffalo", "Camel", "Reindeer"},{"What is the term for animals that can survive both in water and on land?", "Amphibians", "Reptiles", "Mammals", "Fish", "Insects", "Arachnids"},{"Which animal is known to communicate using a complex series of clicks, whistles, and body movements?", "Dolphin", "Elephant", "Great ape", "Wolf", "Cat", "Dog"},{"Which type of animal exhibits bi-parental care, with both males and females raising their young?", "Birds", "Mammals", "Reptiles", "Fish", "Amphibians", "Insects"},{"Which mammal has specialized teeth adapted for grinding plants?", "Herbivores", "Carnivores", "Omnivores", "Insectivores", "Frugivores", "Detritivores"},{"What is the largest species of cat?", "Siberian tiger", "African lion", "Jaguar", "Leopard", "Cheetah", "Cougar"},
}

function reset_pn_and_AI_vars()
	for _, player in ipairs(_participants) do
		local vars = mg_player_vars[player.tribe]
		
		vars.answer_cdr = rndb(12*3, 12*(mg_vars.quiz_answer_timer))
		vars.selected_answer = nil
	end
end

function init_single_AI_quiz(player)
	local vars = mg_player_vars[player]
	
	vars.answer_cdr = 1
	vars.selected_answer = nil
	
	if mg_vars.teamwork then
		vars.teammates = get_allied_tribes(player)
	end
end

function process_AI_5(tribe, diff)
	if mg_vars.quiz_stage == 3 then
		local vars = mg_player_vars[tribe]
		vars.answer_cdr = vars.answer_cdr - 1
		
		if vars.answer_cdr == 0 then
			if vars.selected_answer == nil then
				local correct = mg_vars.quiz_question_tbl[3]
				
				if chance(30 + diff*20) then
					vars.selected_answer = correct
				elseif chance(1) then
					return
				else
					vars.selected_answer = rndb(1, mg_vars.hard_mode and 6 or 4)
				end
			end
		end
	end
end

function get_question_category(id)
	local curr = 0
	local categories = {"populous", "capitals", "astronomy", "mythology", "music", "celebrities", "chemistry", "literature", "geography", "medicine and anatomy", "games", "pokemon", "history", "historic events", "inventions", "technology", "food and cuisine", "sports", "quotes", "psychology","animals"}
	local amt = {8,192,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,50,50,100}
	
	for k, v in ipairs(amt) do
		curr = curr + v
		
		if id <= curr then
			return categories[k]
		end
	end
	
	return categories[1] --fallback, shouldnt happen
end

function scramble_answers(question_tbl, answers)
	local _tbl = {}
	local nums = {}
	for i = 1, answers do nums[i] = i end
	
	for i = 1, answers do
		local _idx = rndb(1, #nums)
		local random_num = nums[_idx]
		table.remove(nums, _idx)
		
		_tbl[i] = { question_tbl[random_num + 1], btn(random_num == 1) }
	end
	
	return _tbl
end

function write_question_on_board(x, y, w, h)
	local question = mg_vars.quiz_question_tbl[2]
	local limit_w = x + w
	local currX = x
	local curr_word = 1
	local line = 0
	local ch = CharHeight2()
	
	for word in string.gmatch(question, "%S+") do
		local _w = word .. " "
		local w_width = string_width(_w)
		
		if currX + w_width > limit_w then
			currX = x
			line = line + 1
		end
	
		LbDraw_Text(currX, y + line*ch, _w, 0)
		currX = currX + w_width
	end
end

function quiz_set_next_question(answers)
	mg_vars.quiz_question_tbl = {}
	local id = rndb(1, #quiz_questions)
	local question_tbl = quiz_questions[id]
	local category = get_question_category(id)
	local answers_tbl = scramble_answers(question_tbl, answers)
	local correct = nil
	
	for k, v in ipairs(answers_tbl) do
		if v[2] == 1 then
			correct = k
			break
		end
	end

	mg_vars.quiz_question_tbl = { category, question_tbl[1], correct, answers_tbl }
end

function quiz_process_round_timer()
	local q_stage = mg_vars.quiz_stage
	local curr_timer = ggameplay.map_curr_round_timer

	ggameplay.map_curr_round_timer = curr_timer - 1
	curr_timer = curr_timer - 1
	
	if curr_timer <= 0 then
		mg_vars.quiz_stage = q_stage + 1
		q_stage = q_stage + 1
		
		if q_stage > 4 then
			mg_vars.quiz_stage = 1
			q_stage = 1
		end
	
		if q_stage == 1 then
		
			local correct = mg_vars.quiz_question_tbl[3]
			
			for _, player in ipairs(_participants) do
				local tribe = player.tribe
				local vars = mg_player_vars[tribe]
				if vars.selected_answer == correct then
					give_points_to_team(1, tribe, true)
				end
			end
			
			ggameplay.map_curr_round_timer = 12*1
			quiz_set_next_question(mg_vars.hard_mode and 6 or 4)
			reset_pn_and_AI_vars()
			reset_ingame_cursors()
			increase_round()
			
		elseif q_stage == 2 then
		
			ggameplay.map_curr_round_timer = 12*5
			queue_custom_sound_event(nil, "y_q_1.wav", 127)
			
		elseif q_stage == 3 then

			ggameplay.map_curr_round_timer = 12*mg_vars.quiz_answer_timer
			local t_seconds = ggameplay.map_curr_round_timer // 12
			local sndfile = (t_seconds == 10) and "y_q_2.wav" or (t_seconds == 15) and "y_q_2b.wav" or "y_q_2c.wav"
			queue_custom_sound_event(nil, sndfile, 127)
			
		elseif q_stage == 4 then
		
			ggameplay.map_curr_round_timer = 12*5
			
		end
	else
		if q_stage == 4 then
			if curr_timer == 12*3 then
				if im_spectating then return end
				
				local correct = mg_vars.quiz_question_tbl[3]
				local player_correct_answer = (mg_player_vars[playernum].selected_answer == correct)
				queue_custom_sound_event(nil, player_correct_answer and "y_q_3.wav" or "y_q_4.wav", 127)
			end
		end
	end
end

function quiz_on_frame(ghover)
	local hover = false
	hide_panel()
	local quiz_stage = mg_vars.quiz_stage
	
	if not (quiz_stage ~= 1) then return ghover end
	if player_in_options() then return ghover end
	
	local w, h, guiw = W, H, GUIW
	local vars = mg_player_vars[playernum]
	local timer = ggameplay.map_curr_round_timer
	local answers = (mg_vars.hard_mode and 6 or 4)
	local timer_bar_h = mf(h, 64)
	local oH1 = mf(h, 64)
	local oH2 = oH1 * 3
	local f1, f2, f3
	if w <= 800 then
		f1, f2, f3 = 6,4,3
	else
		f1, f2, f3 = 4,3,9
	end
	local s1, s2, s3 = 0, 0, 0
	PopSetFont(f1, 0)
	s1 = CharHeight2()
	PopSetFont(f2, 0)
	s2 = CharHeight2()
	PopSetFont(f3, 0)
	s3 = CharHeight2()
	local question_id, category = "Question " .. ggameplay.map_curr_round, mg_vars.quiz_question_tbl[1]

	local top_h = oH1 + oH2 + s3 + s1
	local question_h = s3 * 3 + oH1*2
	local answer_card_h = s2 + (oH1*2)
	local half_answers = floor(answers / 2)
	local answers_h = floor(oH2*2 + (answer_card_h + oH1)*half_answers - oH1)
	local bottom_h = oH1 + timer_bar_h
	local total_h = top_h + question_h + answers_h + bottom_h
	
	local w_borders = mf(w, 48)
	local total_w = mf(w, 1.5) + w_borders*2
	local x, y = mf((guiw + w) - total_w, 2), mf(h - total_h, 2)
	local x_content = x + w_borders
	local w_content = total_w - w_borders*2
	local center = x + mf(total_w, 2)
	local answers_w_gap = mf(w, 64)
	local answers_total_w = w_content - answers_w_gap
	local answer_total_w = mf(answers_total_w, 2)
	
	
	draw_border(x, y, total_w, total_h, "creme", true, true, true, true, true, true, true, true, 	true)
	fill_with_hfx_sprite_clipped(x, y, total_w, total_h, GUI_COLOR_F, nil)

	local _y = y + oH1
	PopSetFont(f3, 0)
	
	if quiz_stage ~= 2 or (quiz_stage == 2 and timer < 12*4) then
		LbDraw_Text(center - mf(string_width(question_id), 2), _y, question_id, 0)
	end
	_y = _y + s3
	if quiz_stage ~= 2 or (quiz_stage == 2 and timer < 12*4 - 6) then
		PopSetFont(f1, 0)
		local _category = "category: " .. category
		LbDraw_Text(center - mf(string_width(_category), 2), _y, _category, 0)
	end
	_y = _y + s1 + oH2
	
	if quiz_stage ~= 2 or (quiz_stage == 2 and timer < 12*3) then
		draw_border(x_content, _y, w_content, question_h, "gray", true, true, true, true, true, true, true, true, 	true)
		fill_with_hfx_sprite_clipped(x_content, _y, w_content, question_h, GUI_COLOR_J, nil)
	end
	PopSetFont(f3, 0)
	if quiz_stage ~= 2 or (quiz_stage == 2 and timer < 12*2) then
		write_question_on_board(x_content + oH1, _y + oH1, w_content - oH1*2, question_h - oH1*2)
	end
	_y = _y + question_h + oH2
	local answer_id = 1
	local answers_tbl = mg_vars.quiz_question_tbl[4]
	local correct = mg_vars.quiz_question_tbl[3]
	PopSetFont(f2, 0)
	local curr_font = f2
	local curr_selected = vars.selected_answer
	local show_masks = quiz_stage == 4
	local letter_size = answer_card_h - oH1*2
	local half_letter = mf(letter_size, 2)
	local letters = {"A","B","C","D","E","F"}
	local tt
	
	if quiz_stage ~= 2 or (quiz_stage == 2 and timer < 12*1) then
		for i = 0, half_answers-1 do
			local __y = _y + i*(answer_card_h + oH1)
		
			for j = 0, 1 do
				__x = x_content + j*(answer_total_w + answers_w_gap)
				local clr = GUI_COLOR_J
				
				if quiz_stage == 3 then
					if not im_spectating then
						if not hover and (not ghover) then
							if cursor_inside(__x, __y, answer_total_w, answer_card_h) then
								hover = true
								hovering_ingame = HOVERING_MINIGAME_BTN
								hovering_ingame_id = answer_id
								clr = clr - 2
							end
						end
					end
				end
				
				if curr_selected ~= nil then
					if curr_selected == answer_id then
						clr = GUI_COLOR_C
					end
				end
				
				if show_masks then
					if timer < 12*3 then
						if vars.selected_answer == answer_id then
							if correct == answer_id then
								clr = 1796
							else
								clr = 1794
							end
						else
							if correct == answer_id then
								clr = 1796
							end
						end
					end
				end
			
				draw_border(__x, __y, answer_total_w, answer_card_h, "gray", true, true, true, true, true, true, true, true, 	true)
				fill_with_hfx_sprite_clipped(__x, __y, answer_total_w, answer_card_h, clr, nil)
				
				DrawBox(__x + oH1-1, __y + oH1-1, letter_size+2, letter_size+2, 1)
				DrawBox(__x + oH1, __y + oH1, letter_size, letter_size, 0)
				
				local let = letters[answer_id]
				LbDraw_Text(__x + oH1 + half_letter - mf(string_width(let), 2), __y + oH1, let, 0)
				
				local answer_txt = answers_tbl[answer_id][1]
				
				if string_width(answer_txt) >= answer_total_w - letter_size then
					PopSetFont(f1, 0)
					curr_font = f1
				end
				
				LbDraw_Text(__x + oH1*2 + letter_size, __y + oH1, answer_txt, 0)
				
				if show_masks then
					local hover_masks = false
					local _curr_x = __x + answer_total_w - oH1 - s2 - 2
					
					for _, player in ipairs(_participants) do
						local tribe = player.tribe
						local ans = mg_player_vars[tribe].selected_answer
						
						if ans ~= nil then
							if ans == answer_id then
								LbDraw_ScaledSprite(_curr_x, __y + oH1, get_sprite(0, 1809+tribe), s2, s2)
								
								if not im_spectating and (not is_player_enemy(tribe, playernum)) then
									local a, b = _curr_x, __y + oH1
									DrawBoxOutline(a-1, b-1, s2+2, s2+2, 7)
								end
								
								if (not hover_masks) and tribe ~= playernum then
									if cursor_inside(_curr_x, __y + oH1, s2, s2) then
										hover_masks = true
										tt = player.name
									end
								end
								
								_curr_x = _curr_x - 2 - s2
							end
						end
					end
				else
					if quiz_stage == 3 and (mg_vars.teamwork or im_spectating) then
						local _teamwork_x = __x + answer_total_w - oH1 - s2 - 2
						local hover_masks = false
						
						for _, player in ipairs(_participants) do
							local tribe = player.tribe
							if tribe ~= playernum then
								if im_spectating or (not is_player_enemy(tribe, playernum)) then
									local ans = mg_player_vars[tribe].selected_answer
									
									if ans ~= nil then
										if ans == answer_id then
											LbDraw_ScaledSprite(_teamwork_x, __y + oH1, get_sprite(0, 1809+tribe), s2, s2)
											
											if not hover_masks then
												if cursor_inside(_teamwork_x, __y + oH1, s2, s2) then
													hover_masks = true
													tt = player.name
												end
											end
											
											_teamwork_x = _teamwork_x - 2 - s2
										end
									end
								end
							end
						end
					end
				end
				
				answer_id = answer_id + 1
				PopSetFont(f2, 0)
			end
		end
	end
	
	_y = _y + answers_h - oH2
	local real_timer = mg_vars.quiz_answer_timer * 12
	
	if quiz_stage == 3 then
		local percent = floor((timer / real_timer) * 100)
		DrawPercentBar(x_content, _y, w_content, timer_bar_h, percent, 1, 10, "creme")
	else
		DrawPercentBar(x_content, _y, w_content, timer_bar_h, real_timer, 1, 10, "creme")
	end
	
	if tt then
		PopSetFont(W > 800 and 3 or 4, 0)
		local sw = string_width(tt)
		local _x, _y = mouseX + 12, mouseY - 12
		DrawBox(_x-2, _y-2, sw+4, CharHeight2()+4, 0)
		DrawBox(_x-1, _y-1, sw+2, CharHeight2()+2, 1)
		LbDraw_Text(_x, _y, tt, 0)
	end

	return (hover or ghover)
end

function quiz_on_mouse_up(left)
	if not left then return end
	if im_spectating then return end
	if not mg_vars.quiz_stage == 3 then return end
	if not hovering_ingame then return end
	if not hovering_ingame_id then return end
	
	mg_player_vars[playernum].selected_answer = hovering_ingame_id
	
	-- if multiplayer then
		-- local data = tostring(btn(left))..tostring(hovering_ingame_id)
		-- send_packet_now("b", data)
	-- else
		-- mg_player_vars[playernum].selected_answer = hovering_ingame_id
	-- end
end

function quiz_on_mouse_up_multiplayer(from, str)
	if type(str) ~= "string" then return end
	if not mg_vars.quiz_stage == 3 then return end
	
	local left = decode_boolean(str:sub(1,1))
	if not left then return end

	mg_player_vars[from].selected_answer = tonumber(str:sub(2,2))
end

function quiz_on_turn(everySecond1)
	if mg_turn == 1 then
		mg_vars.hard_mode = (game.hub.selected_map == MAP_QUIZ_HARD)
		mg_vars.more_time = is_map_rule_active(1)
		mg_vars.teamwork = is_map_rule_active(2)
		mg_vars.quiz_stage = 1
		mg_vars.quiz_question_tbl = {}
		mg_vars.quiz_answer_timer = 10 + btn(mg_vars.hard_mode)*5 + btn(mg_vars.more_time)*5
		for _, player in ipairs(_ai_participants) do
			init_single_AI_quiz(player.ptr.tribe)
		end
		increase_round()
		ggameplay.map_curr_round_timer = 12*1
		quiz_set_next_question(mg_vars.hard_mode and 6 or 4)
	end
	
	for _, player in ipairs(_participants) do
		local tribe = player.tribe
		local is_ai = player.ai
		
		if is_ai then
			process_AI_5(tribe, player.diff)
		end
	end

	quiz_process_round_timer()
end

----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
--MAP_POTION_BATTLE----------------------------------MAP_POTION_BATTLE--------------------------------------------------------MAP_POTION_BATTLE---------------------------------------------------------MAP_POTION_BATTLE---
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

function PB_refresh_mg_variables()
	mg_vars.potions_descriptions = {
								{ "Healing", "Dealing damage heals your shaman." }, --light green
								{ "Vitality", "Refills shaman's HP once you kill an enemy." }, --dark green
								{ "Anger", "Your spells deal 50% extra damage." }, --light red
								{ "Revenge", "Killing an enemy steals one of their potions (prioritizes potions you already own)." }, --dark red
								{ "Magic", "Grants your shaman 50% extra mana regeneration." }, --light blue
								{ "Antimagic", "Whenever a shaman targets you with an S-clicked spell, you have a 50% chance to spawn a quick shield." }, --dark blue
								{ "Fortune", "Casting a spell has a % chance to grant you a random spell (higher chance the stronger the spell was)" }, --yellow
								{ "Virtue", "Killing an enemy shaman refills all shots of a random spell." }, --orange
								{ "Darkness", "Killing an enemy shaman grants 1 extra point; Whenever you die, you don't lose 1	point." }, --black
								{ "Vigor", "Unlocks firestorm until this potion fades." }, --white
								{ "Stealth", "Become invisible until your next spell cast, until the potion fades, or until you melee attack or die. You can drink another potion while invisible, but the trail will reveal your position." }, --purple
								{ "Skill", "If your shaman falls to water, she teleports back to land; then, this potion fades." }, --brown
								{ "Insight", "Grants 1 random spell shot, and permanently lowers the cost of that spell by 5%." } --swamp green
}
	mg_vars.potions_to_color = { 7,3,2,12,4,8,5,14,1,9,11,9,3 }
end

function PB_init_single_AI(player)
	local ai = mg_player_vars[player]
	
	ai.powerup_chasing = nil
	ai.locked_player = nil
	ai.dodged = false
	ai.blast_cdr = 12*(rndb(1, 3))
	ai.light_cdr = 12*(rndb(12, 17))
	ai.ghost_cdr = 12*(rndb(8, 13))
	ai.swarm_cdr = 12*(rndb(9, 15))
	ai.tornado_cdr = 12*(rndb(16, 32))
end

function PB_try_to_spell_an_enemy(tribe, spell, radius, _chance, difficulty)
	if chance(_chance) then
		local random_enemy = get_random_enemy_shaman_near_thing(getShaman(tribe), radius)
		
		if random_enemy ~= nil then
			local c3d = random_enemy.Pos.D3
			
			if ((spell == M_SPELL_BLAST) or (spell == M_SPELL_LIGHTNING_BOLT)) and chance(30) then
				local aimed_c3d = aim_spell_at_target(tribe, random_enemy, radius)
				c3d = aimed_c3d or c3d
			end
			
			local t = createThing(T_SPELL, spell, tribe, c3d, false, false)
			
			if not aimed_c3d and shaman_has_healthy_state(random_enemy.Owner) then
				if chance(70+difficulty*10) then
					t.u.Spell.TargetThingIdx:set(random_enemy.ThingNum)
				end
			end
			return true
		end
	end
	
	return false
end

function PB_try_to_spell_an_enemy_unit(tribe, spell, radius, _chance, difficulty)
	if chance(_chance) then
		local enemies = {}
		
		SearchMapCells(SQUARE, 0, 0, radius, world_coord3d_to_map_idx(getShaman(tribe).Pos.D3), function(me)
			me.MapWhoList:processList(function(t)
				if t.Type == T_PERSON and is_player_enemy(tribe, t.Owner) then
					if not isInvisible(t) then
						table.insert(enemies, t)
					end
				end
			return true end)
		return true end)
		
		local target = randomItemFromTable(enemies)
		
		if target then
			local t = createThing(T_SPELL, spell, tribe, target.Pos.D3, false, false)
			
			if chance(40+difficulty*15) then
				t.u.Spell.TargetThingIdx:set(target.ThingNum)
			end
			return true
		end
	end
	
	return false
end

function PB_process_AI(tribe, alive, vars, everySecond1, everySecond2, everySecond4, diff)
	local blast_cdr, light_cdr = math.max(0, vars.blast_cdr - 1),  math.max(0, vars.light_cdr - 1)
	local ghost_cdr, swarm_cdr, tornado_cdr = math.max(0, vars.ghost_cdr - 1),  math.max(0, vars.swarm_cdr - 1), math.max(0, vars.tornado_cdr - 1)
	vars.blast_cdr = blast_cdr
	vars.light_cdr = light_cdr
	vars.ghost_cdr = ghost_cdr
	vars.swarm_cdr = swarm_cdr
	vars.tornado_cdr = tornado_cdr
	
	if alive then
		local shaman = getShaman(tribe)
		local c2d = vars.powerup_chasing
		local target_player = vars.locked_player
		local casted = false
		--local shaman_c3d = copy_c3d(shaman.Pos.D3)
		
		if not target_player or not nilS(target_player) or (chance(1) and chance(5)) then
			vars.locked_player = get_closest_alive_enemy_shaman(tribe)
			target_player = vars.locked_player
		end
		
		if not casted and chance(60 + diff*10) and shaman_can_cast(shaman) then
			local fast_mana = PB_tribe_is_using_potion(tribe, 5) and 2+diff*2 or 0
			local ninja_increaser = PB_tribe_is_using_potion(tribe, 11) and 10 or 0
			
			if everySecond1 or chance(16 + ninja_increaser) then
				if light_cdr <= 0 then
					casted = PB_try_to_spell_an_enemy(tribe, M_SPELL_LIGHTNING_BOLT, 8, 4 + diff*13 + fast_mana + ninja_increaser, diff)
			
					if casted then
						vars.light_cdr = 12*rndb(4-diff, rndb(11, 16 - diff)) + 1
						goto after_casting_phase
					end
				end
			end
			if blast_cdr <= 0 then
				casted = PB_try_to_spell_an_enemy(tribe, M_SPELL_BLAST, 4, 10 + diff*12 + fast_mana, diff)
		
				if casted then
					vars.blast_cdr = 12*rndb(3-diff, 10 - diff*2) + 1
					goto after_casting_phase
				end
			end
			if chance(6) then
				if ghost_cdr <= 0 then
					casted = PB_try_to_spell_an_enemy(tribe, M_SPELL_GHOST_ARMY, 5, 5 + diff*12 + fast_mana, diff)
				
					if casted then
						vars.ghost_cdr = 12*(rndb(7-diff, 14-diff))
						if chance(20 + diff*5) then
							vars.blast_cdr = 12*1
						end
						goto after_casting_phase
					end
				end
			end
			if chance(4 + diff*2) then
				if tornado_cdr <= 0 then
					casted = PB_try_to_spell_an_enemy(tribe, M_SPELL_WHIRLWIND, 6, 8 + diff*6 + fast_mana, diff)
				
					if casted then
						vars.tornado_cdr = 12*(rndb(10-diff, 32-diff*2))
						goto after_casting_phase
					end
				end
			end
			if PB_tribe_is_using_potion(tribe, 10) then
				if chance(5) then
					casted = PB_try_to_spell_an_enemy(tribe, M_SPELL_FIRESTORM, 6, 5 + diff*7, diff)
				
					if casted then
						goto after_casting_phase
					end
				end
			end
			if chance(36) then
				if swarm_cdr <= 0 then
					local near = count_persons_of_model_in_area(tribe, true, shaman.Pos.D3, 2, -1, false, true)

					if near > 1 then
						casted = PB_try_to_spell_an_enemy_unit(tribe, M_SPELL_INSECT_PLAGUE, 2, 34 + diff*6 + fast_mana, diff)
			
						if casted then
							vars.swarm_cdr = 12*(rndb(9-diff, 18-diff))
							goto after_casting_phase
						else
							casted = PB_try_to_spell_an_enemy_unit(tribe, M_SPELL_BLAST, 2, 44 + diff*8 + fast_mana, diff)
						end
					end
				end
			end
		end
		
		::after_casting_phase::
		
		if casted then
			vars.blast_cdr = math.max(vars.blast_cdr, 14)
			vars.light_cdr = math.max(vars.light_cdr, 14)
			vars.ghost_cdr = math.max(vars.ghost_cdr, 14)
			vars.swarm_cdr = math.max(vars.swarm_cdr, 14)
			vars.tornado_cdr = math.max(vars.tornado_cdr, 14)
		end
		
		local moving_to_shaman = false
		
		if not vars.dodged then
			if not c2d then
				if chance(3 + diff*3) then
					local places = get_me_the_closest_powerup_max_rad(tribe, shaman, 18+diff*4)
					
					if #places == 1 then
						local item = places[1]
						vars.powerup_chasing = item.c2d
					else
						if #places >= 2 then
							if chance(50) then
								local item = places[2]
								vars.powerup_chasing = item.c2d
							else
								local item = places[1]
								vars.powerup_chasing = item.c2d
							end
						end
					end
				else
					if everySecond1 then
						if shaman_has_healthy_state(tribe) then
							if chance(80) then
								if chance(60) then
									MOVE_SHAMAN_TO_MARKER(tribe, rndb(0,32))
									moving_to_shaman = true
								end
							end
						end
					end
				end
			else
				if is_powerup_in_c2d(c2d) then
					if shaman_has_healthy_state(tribe) then
						if #vars.owned_potions_cache >= 6 then
							MOVE_SHAMAN_TO_MARKER(tribe, rndb(0,32))
							moving_to_shaman = true
						else
							if chance(32) then
								local dist2d = get_world_dist_xz(c2d, shaman.Pos.D2)
								if dist2d <= 512+32 then
									MOVE_SHAMAN_TO_MARKER(tribe, rndb(0,32))
									moving_to_shaman = true
								else
									try_to_dodge_on_land(tribe, 1, 2 + diff)
								end
							else
								command_person_go_to_coord2d(shaman, c2d)
								moving_to_shaman = true
							end
						end
					end
				else
					vars.powerup_chasing = nil
					
					if shaman_has_healthy_state(tribe) then
						if target_player then
							if nilS(target_player) then
								command_person_go_to_coord2d(shaman, getShaman(target_player).Pos.D2)
							end
						else
							MOVE_SHAMAN_TO_MARKER(tribe, rndb(0,32))
						end
						moving_to_shaman = true
					end
				end
			end
			
			if not c2d and not moving_to_shaman then
				if chance(16) then
					MOVE_SHAMAN_TO_MARKER(tribe, rndb(0,32))
					moving_to_shaman = true
				end
			end
		end
		
		if everySecond4 then
			if chance(4) then
				if not is_tribe_using_emoji(tribe) then
					if chance(1) then
						create_emote(tribe)
					end
				end
			elseif chance(14) then
				local random_enemy_shaman = get_random_alive_enemy_shaman(tribe)
				
				if random_enemy_shaman then
					local c2d = copy_c2d(random_enemy_shaman.Pos.D2)
					
					ProcessGlobalTypeList(T_PERSON, function(d)
						if d.Model ~= M_PERSON_MEDICINE_MAN then
							command_person_go_to_coord2d(d, c2d)
						end
					return true end)
				end
			end
		end
		
		if everySecond2 then
			vars.dodged = false
		end
		
		if (chance(4) and not tribe_using_any_potion(tribe)) or (rndb(1, 1000) <= 2) then
			local used_potion = try_to_use_a_random_potion(tribe, vars)
			
			--if used_potion then
				--i forgot about this what was it for
			--end
		end
	end
end

function try_to_use_a_random_potion(tribe, vars)
	local tbl = vars.owned_potions_cache
	local slots = #tbl
	
	if slots > 0 then
		local slot = rndb(1, slots)
		local potion_id = tbl[slot]
		PB_use_potion(tribe, slot)
		return potion_id
	end
	
	return nil
end

function tribe_using_any_potion(tribe)
	return mg_player_vars[tribe].active_potion.id ~= 0
end

function PB_tribe_is_using_potion(tribe, potion_id)
	return mg_player_vars[tribe].active_potion.id == potion_id
end

function PB_refresh_potions_cache(tribe, edited_potion_id, was_already_owned, new_value)
	local cache = mg_player_vars[tribe].owned_potions_cache
	
	if not was_already_owned then
		table.insert(cache, edited_potion_id)
		return
	end
	
	if new_value <= 0 then
		for k, v in ipairs(cache) do
			if v == edited_potion_id then
				table.remove(cache, k)
				break
			end
		end
	end
end

function PB_give_potions_to_player(tribe, potion_id, amt, optional_dropping)
	local potions_var = mg_player_vars[tribe].potions
	local curr_owned_amt = potions_var[potion_id]
	
	if curr_owned_amt > 0 then
		local have_3_or_more = (curr_owned_amt >= 3)
		if ((not optional_dropping) and have_3_or_more and amt > 0) then return false end
		
		local new_value = clamp(curr_owned_amt + amt, 0, 3)
		potions_var[potion_id] = new_value
		PB_refresh_potions_cache(tribe, potion_id, true, new_value)
		return true
	else
		local has_free_slot = #mg_player_vars[tribe].owned_potions_cache < 6
		if has_free_slot then
			potions_var[potion_id] = 1
			PB_refresh_potions_cache(tribe, potion_id, false, 1)
			return true
		end
	end
	
	return false
end

function PB_check_sinking(tribe, shaman, vars) 
	if shaman_is_drowning(shaman) then
		if PB_tribe_is_using_potion(tribe, 12) then
			local active_potion = vars.active_potion
			
			if shaman.u.Pers.Life > 0 then
				local found = false
				
				SearchMapCells(SQUARE, 0, 0, 5, world_coord3d_to_map_idx(shaman.Pos.D3), function(me)
					if not found then
						if is_map_elem_sea_or_coast(me) <= 0 then
							local new_c3d = me2c3d(me)
							move_thing_within_mapwho(shaman, new_c3d)
							active_potion.id = 0
							active_potion.timer = -1
							found = true
						end
					end
				return true end)
			end
		end
	end
end

function PB_catch_potion(tribe, potion_id)
	return PB_give_potions_to_player(tribe, potion_id, 1)
end

function PB_steal_potion(killer, victim)
	local victims_potions = {}
	local victims_potions_in_common = {}
	
	for _, v in pairs(mg_player_vars[victim].owned_potions_cache) do
		table.insert(victims_potions, v)
		
		local amt = mg_player_vars[killer].potions[v]
		
		if amt > 0 and amt < 3 then
			table.insert(victims_potions_in_common, v)
		end
	end
	
	if #victims_potions_in_common > 0 then
		local potion_id = randomItemFromTable(victims_potions_in_common)
		
		PB_give_potions_to_player(killer, potion_id, 1)
		PB_give_potions_to_player(victim, potion_id, -1)
		return
	end
	
	if #victims_potions > 0 then
		local potion_id = randomItemFromTable(victims_potions)
		
		PB_give_potions_to_player(killer, potion_id, 1)
		PB_give_potions_to_player(victim, potion_id, -1)
	end
end

function PB_process_potion_timers(tribe, vars)
	local active_potion = vars.active_potion
	local timer = active_potion.timer
	
	active_potion.timer = math.max(-1, timer - 1)
	
	if timer - 1 == -1 then
		if PB_tribe_is_using_potion(tribe, 10) then
			disable_spell(tribe, M_SPELL_FIRESTORM, true)
		end
		
		active_potion.id = 0
	end
end

function PB_use_potion(tribe, potion_slot)
	if not nilS(tribe) then return end

	local vars = mg_player_vars[tribe]
	local slot_potion = vars.owned_potions_cache[potion_slot]
	if not slot_potion then return end
	
	local used = PB_give_potions_to_player(tribe, slot_potion, -1)
	if not used then return end
	
	local timer = mg_vars.shorter_potions and 21 or 41

	vars.active_potion = {id = slot_potion, timer = timer*12}
	
	local alive = nilS(tribe)
	local shaman = getShaman(tribe)
	
	if alive then
		local snd = "y_p_" .. rndb(1,3) .. ".wav"
		queue_custom_sound_event(shaman, snd, 127)
	end
	
	if slot_potion ~= 10 then
		disable_spell(tribe, M_SPELL_FIRESTORM, true)
		
		if slot_potion == 11 then
			if alive then
				giveInvisibility(shaman, timer)
			end
		elseif slot_potion == 13 then
			vars.active_potion = {id = 0, timer = -1}
			
			local spelz = {M_SPELL_BLAST, M_SPELL_GHOST_ARMY, M_SPELL_INSECT_PLAGUE, M_SPELL_LIGHTNING_BOLT, M_SPELL_WHIRLWIND}
			local possibilities = {}
			
			for _, v in ipairs(spelz) do
				local max = sti[v].OneOffMaximum
				local curr = count_player_spell_shots(tribe, v)
				
				if curr < max then
					table.insert(possibilities, v)
				end
			end
			
			if #possibilities > 0 then
				local spell = randomItemFromTable(possibilities)
				give_shots_to_player(tribe, spell, 1)
				local pn_limits_spell = getPlayer(tribe).LimitsSpell
				local curr_cost = pn_limits_spell.Cost[spell]
				pn_limits_spell.Cost[spell] = math.max(floor(curr_cost - curr_cost * 0.95), 4096)
			end
		end
	else
		enable_spell(tribe, M_SPELL_FIRESTORM)
	end
end

function PB_discard_potion(tribe, potion_slot)
	local vars = mg_player_vars[tribe]
	local slot_potion = vars.owned_potions_cache[potion_slot]
	if not slot_potion then return end
	
	local dropped = PB_give_potions_to_player(tribe, slot_potion, -1, true)

	if dropped then
		if tribe == playernum then
			queue_custom_sound_event(getShaman(tribe), "15_chop1.wav", 64)
			
			local shaman = getShaman(playernum)
			if nilS(tribe) then
				-- local isSelected = (shaman.u.Pers.CmdGroupFlags & CGF_CURRENTLY_SELECTED) ~= 0
				-- if not isSelected then
					-- shaman.u.Pers.CmdGroupFlags = shaman.u.Pers.CmdGroupFlags | CGF_CURRENTLY_SELECTED
				-- else
					-- shaman.u.Pers.CmdGroupFlags = shaman.u.Pers.CmdGroupFlags & (~CGF_CURRENTLY_SELECTED)
				-- end
				shaman.u.Pers.CmdGroupFlags = shaman.u.Pers.CmdGroupFlags | CGF_CURRENTLY_SELECTED
			end
		end
	end
end

function PB_give_mana(tribe)
	local mana = mg_vars.mana_regen and 4200 or 2800
	
	if PB_tribe_is_using_potion(tribe, 5) then
		mana = mana * 1.5
	end
	
	GIVE_MANA_TO_PLAYER(tribe, floor(mana))
end

-- function potionmaster_on_damage(victim, damaging_player, damage_value, ignore_shield)
		

	-- local damager_tbl = mg_player_vars[damaging_player]
	-- if not damager_tbl then return end

	-- if not damager_tbl.damage_lock then
		-- damager_tbl.damage_lock = true
		
		-- if PB_tribe_is_using_potion(damaging_player, 1) then
			-- if nilS(damaging_player) then
				-- local damager_shaman = getShaman(damaging_player)
				-- damager_shaman.u.Pers.Life = math.min(damager_shaman.u.Pers.MaxLife, damager_shaman.u.Pers.Life + damage_value)
			-- end
		-- elseif PB_tribe_is_using_potion(damaging_player, 3) then
			-- if victim ~= nil then
				-- damage_person(victim, damaging_player, math.max(1, mf(damage_value, 2)), 0)
			-- end
		-- end
	-- end
-- end

function potionmaster_on_damage(victim, damaging_player, damage_value, ignore_shield)
    if not damaging_player or type(damage_value) ~= "number" then return end

    local damager_tbl = mg_player_vars[damaging_player]
    if not damager_tbl then return end

    if not damager_tbl.damage_lock then
        damager_tbl.damage_lock = true

        local damager_shaman = getShaman(damaging_player)
        if PB_tribe_is_using_potion(damaging_player, 1) and damager_shaman and damager_shaman.u.Pers then
            local current = damager_shaman.u.Pers.Life or 0
            local max_life = damager_shaman.u.Pers.MaxLife or 0
            damager_shaman.u.Pers.Life = math.min(max_life, current + damage_value)
        elseif PB_tribe_is_using_potion(damaging_player, 3) and victim then
            damage_person(victim, damaging_player, math.max(1, mf(damage_value, 2)), 0)
        end
    end
end

function PB_potions_c3d()
	local c3d = nil
	local tries = 10
	
	while c3d == nil and tries > 0 do
		tries = tries - 1
		local mk = rndb(9, 32)
		
		local _c3d = marker_to_coord3d(mk)
		
		if not c3d_has_shaman_rad(_c3d, 0) then
			c3d = _c3d
			centre_coord3d_on_block(c3d)
		end
	end
	
	return c3d
end

function PB_init_mg_constants()
	local spelz = {M_SPELL_BLAST, M_SPELL_GHOST_ARMY, M_SPELL_INSECT_PLAGUE, M_SPELL_LIGHTNING_BOLT, M_SPELL_WHIRLWIND, M_SPELL_FIRESTORM}
	local potionbattle_spells_mana = { 8000, 18000, 24000, 32000, 46000, 50000 } --10, 18, 40, 80, 90, 400
	
	for _, player in ipairs(_participants) do
		for _, spell in ipairs(spelz) do
			if spell ~= M_SPELL_FIRESTORM then
				enable_spell(player.tribe, spell)
			end
		end
	end
	
	lock_spell_order()
	
	for _, player in ipairs(_participants) do
		for k, spell in ipairs(spelz) do
			sti[spell].Cost = potionbattle_spells_mana[k]
		end
	end
end

function PB_refresh_player_variables()
	for _, player in ipairs(_participants) do
		local vars = mg_player_vars[player.tribe]
		vars.potions = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
		vars.active_potion = {id = 0, timer = -1}
		vars.owned_potions_cache = {}
		vars.damage_lock = false
	end
end

function PB_process_shamans(everySecond1, everySecond2, everySecond4)
	for _, player in ipairs(_participants) do
		local tribe = player.tribe
		local ai = player.ai
		local alive = process_death_shamans(tribe, player)
		local shaman = getShaman(tribe)
		local vars = mg_player_vars[tribe]
		local turns4 = everyTurns_mg(4)
		
		PB_process_potion_timers(tribe, vars)
		
		if turns4 then
			PB_give_mana(tribe)
			
			if alive then
				if PB_tribe_is_using_potion(tribe, 11) then
					if not isInvisible(getShaman(tribe)) then
						vars.active_potion.id = 0
						vars.active_potion.timer = -1
					end
				end
			end
		end
		
		if alive then
			local potion = vars.active_potion.id
		
			if potion > 0 then
				if potion ~= 11 then
					if chance(60) then
						if not shaman_is_flying(shaman) then
							if not shaman_is_drowning(shaman) then
								local spriteStart = 2433 + 4*(potion-1)
								local footsteps = createThing(T_EFFECT, 60, SAFE_NEUTRAL, shaman.Pos.D3, false, false)
								set_thing_draw_info(footsteps, TDI_SPRITE_F1_D1, spriteStart+rndb(0,3))
								footsteps.u.Effect.Duration = 20
							end
						end
					end 
				end
			end
			
			PB_check_sinking(tribe, shaman, vars)
			vars.damage_lock = false
			local s_ondmg = shaman.u.Pers.OnDamage
			s_ondmg:clear()
			s_ondmg:add(potionmaster_on_damage)
		end
		
		if ai then
			alive = nilS(tribe)
			PB_process_AI(tribe, alive, vars, everySecond1, everySecond2, everySecond4, player.diff)
		end
	end
end

function PB_on_shaman_dead(victim, killer, allies)
	if not allies and (killer ~= SAFE_NEUTRAL) then
		local earn, remov = 3, -1
		
		if PB_tribe_is_using_potion(killer, 9) then
			earn = earn + 1
		elseif PB_tribe_is_using_potion(killer, 2) then
			if nilS(killer) then
				getShaman(killer).u.Pers.Life = getShaman(killer).u.Pers.MaxLife
			end
		elseif PB_tribe_is_using_potion(killer, 4) then
			PB_steal_potion(killer, victim)
		elseif PB_tribe_is_using_potion(killer, 8) then
			local spelz = {M_SPELL_BLAST, M_SPELL_GHOST_ARMY, M_SPELL_INSECT_PLAGUE, M_SPELL_LIGHTNING_BOLT, M_SPELL_WHIRLWIND}
			local possibilities = {}
			
			for k, v in ipairs(spelz) do
				local max = sti[v].OneOffMaximum
				local curr = count_player_spell_shots(killer, v)
				
				if curr < max then
					table.insert(possibilities, v)
				end
			end
			
			if #possibilities > 0 then
				local spell = randomItemFromTable(possibilities)
				local needed = sti[spell].OneOffMaximum - count_player_spell_shots(killer, spell)
				give_shots_to_player(killer, spell, needed)
			end
		end
		
		if PB_tribe_is_using_potion(victim, 9) then
			remov = 0
		end
		
		give_points_to_team(earn, killer, false)
		give_points_to_team(remov, victim, true)
	end
end

function potionbattle_on_turn(everySecond1, everySecond2, everySecond4)
	if mg_turn == 1 then
		ggameplay.max_powerups_at_once = 6
		PB_init_mg_constants()
		PB_refresh_mg_variables()
		for _, player in ipairs(_ai_participants) do
			PB_init_single_AI(player.ptr.tribe)
		end
		PB_refresh_player_variables()
		mg_vars.mana_regen = is_map_rule_active(1)
		mg_vars.shorter_potions = is_map_rule_active(2)
		mg_vars.dont_auto_spawn_powerups = true
	end
	
	PB_process_shamans(everySecond1, everySecond2, everySecond4)

	if everySecond4 and chance(80) then
		local powerups = #ggameplay.active_powerups

		if powerups < ggameplay.max_powerups_at_once then
			local custom_powerup_tbl = {
			
		general = 	{ id = 0, name = "potion", catch_rad = POWERUP_CATCH_RADIUS_DEFAULT-32, snd_appear = SND_EVENT_BLDG_STAMP, snd_catch = "y_p_4.wav" },
		creation = 	{ T_GENERAL, M_GENERAL_MAPWHO_THING, SAFE_NEUTRAL },
		location = 	function() return PB_potions_c3d() end,
		drawinfo = 	{ min = 2243, max = 2243, turnChanger = 1, alpha = -16, shadow = true, dfflag = nil },
		movement = 	{ moving = true, startingY = 16, Ybounce_offset = 64, speed = 2 },
		timer = 	{ spawn_every_seconds = function() return 0 end, only_after_turn_x = 0, chance = 100, max_of_this_type = 2, cdr = 0, fade_after_turns = 12*rndb(30,40) },
		effect = 	function(catcher) return PB_catch_potion(catcher, 13) end,
			}
			
			local id = rndb(1,13)
			custom_powerup_tbl.general.id = id
			custom_powerup_tbl.drawinfo.min = 2232 + id
			custom_powerup_tbl.drawinfo.max = 2232 + id
			--custom_powerup_tbl.effect = function(catcher) PB_catch_potion(catcher, id) end
			
			if chance(50) then
				custom_powerup_tbl.general.snd_catch = "y_p_5.wav"
			end
			
			spawn_power_up(id, custom_powerup_tbl)
		end
		
		AI_shaman_stuck_checker(512, AI_UNSTUCK_METHOD_LAND_DODGE)
	end
end

function potionbattle_on_create_thing(t, owner, type, model)
	if type == T_SPELL then
		if isInvisible(getShaman(owner)) then
			getShaman(owner).Flags2 = DisableFlag(getShaman(owner).Flags2, TF2_THING_IS_AN_INVISIBLE_PERSON)
			mg_player_vars[owner].active_potion.id = 0
			mg_player_vars[owner].active_potion.timer = -1
		elseif PB_tribe_is_using_potion(owner, 7) then
			local chances = { [M_SPELL_BLAST]=20, [M_SPELL_GHOST_ARMY]=25, [M_SPELL_INSECT_PLAGUE]=35, [M_SPELL_LIGHTNING_BOLT]=45, [M_SPELL_WHIRLWIND]=60, [M_SPELL_FIRESTORM]=80 }
			local _chance = chances[model] or 5
			
			if player_is_ai(owner) then
				_chance = _chance + get_participant_table(owner).diff*5
			end
			
			if chance(_chance) then
				local spelz = {M_SPELL_BLAST, M_SPELL_GHOST_ARMY, M_SPELL_INSECT_PLAGUE, M_SPELL_LIGHTNING_BOLT, M_SPELL_WHIRLWIND}
				local possibilities = {}
				
				for _, v in ipairs(spelz) do
					local max = sti[v].OneOffMaximum
					local curr = count_player_spell_shots(owner, v)
					
					if curr < max then
						table.insert(possibilities, v)
					end
				end
				
				if #possibilities > 0 then
					local spell = randomItemFromTable(possibilities)
					GIVE_ONE_SHOT(spell, owner)
				end
			end
		end
		
		local got_shield
		local targ = t.u.Spell.TargetThingIdx:get()
		if targ then
			local victim = targ.Owner
			
			if victim ~= owner then
				if PB_tribe_is_using_potion(victim, 6) then
					local _chance = 50
					if player_is_ai(victim) then
						_chance = _chance +  get_participant_table(victim).diff*5
					end
					
					if chance(_chance) then
						giveShield(targ, 2)
						got_shield = true
					end
				end
			end
		end
		
		if not got_shield then
			if model ~= M_SPELL_FIRESTORM and model ~= M_SPELL_INSECT_PLAGUE and model ~= M_SPELL_GHOST_ARMY then
				for _, aiplayer in ipairs(_ai_participants) do
					local player = aiplayer.ptr
					local possible_victim = player.tribe
					
					if possible_victim ~= owner then
						if nilS(possible_victim) then
							if get_world_dist_xz(t.Pos.D2, getShaman(possible_victim).Pos.D2) < 512*3 then
								if try_to_dodge_on_land(possible_victim, 2, 20 + player.diff*20) then
									mg_player_vars[possible_victim].dodged = true
								end
							end
						end
					end
				end
			end
		end
		
	elseif type == T_PERSON then
		if model == M_PERSON_MEDICINE_MAN then
			if mg_turn > 1 then
				if PB_tribe_is_using_potion(owner, 11) then
					mg_player_vars[owner].active_potion.id = 0
					mg_player_vars[owner].active_potion.timer = -1
				end
			end
		end
	end
end

function potionbattle_on_frame(ghover)
	if player_is_spectator(playernum) then return end
	
	local w, h, guiW = W, H, GUIW
	local size = mf(w, 42)
	local o = math.max(mf(w, 128), 4)
	local bar_size = size*6 + o*5
	local bar_h = mf(h, 64)
	local startX = guiW + mf(w, DROP_BOX_ALERT_W_DIVIDER) + 8
	local startY = h - 8 - size - 4 - bar_h
	local hover = false
	PopSetFont(11, 0)
	local vars = mg_player_vars[playernum]
	local x = startX
	
	for slot = 1, 6 do
		local spr = 2493
		local owned = vars.owned_potions_cache[slot]
		local amt = vars.potions[owned]
		
		if owned ~= nil then
			spr = 2217 + owned
			
			if not hover then
				if cursor_inside(x, startY, size, size) then
					hover = true
					hovering_ingame = true
					hovering_ingame_id = slot
					LbDraw_ScaledSprite(x, startY, get_sprite(0, 2231), size, size)
					PopSetFont((w <= 800) and 4 or 3, 0)
					local fonth = CharHeight2()
					local max_desc_w = mf(w, 5)
					local tbl = mg_vars.potions_descriptions[owned]
					local title, description = tbl[1], tbl[2]
					local bottom_offset = 40
					local txt_y = startY - 24 - bottom_offset
					local txt_h, max_desc_w = type_text_in_area(description, 0, 0, max_desc_w, fonth, false)
					txt_y = txt_y - txt_h
					
					DrawBox(mouseX-2, txt_y, max_desc_w+4, txt_h+4 + bottom_offset, 1)
					draw_border(mouseX-2, txt_y, max_desc_w+4, txt_h+4 + bottom_offset, "orange_shadow", true, true, true, true, true, true, true, true, true)
					type_text_in_area(description, mouseX, txt_y, max_desc_w, fonth, true)
					
					PopSetFont((w <= 800) and 3 or 9, 0)
					local d = CharHeight2()
					local a, b = mouseX + max_desc_w // 12, txt_y - d - 3
					local c = string_width(title)
					DrawBox(a-1, b-1, c+2, d+2, 1)
					DrawBox(a, b, c, d, 14)
					LbDraw_Text(a, b, title, 0)
					
					txt_y = txt_y + txt_h + 25
					PopSetFont(10, 0)
					local s1, s2 = "{ use ", "| discard"
					local w2 = string_width(s2)
					LbDraw_Text(mouseX, txt_y, s1, 0)
					PopSetFont(11, 0)
					LbDraw_Text(mouseX + max_desc_w - w2, txt_y, s2, 0)
				end
			end
		end
		
		LbDraw_ScaledSprite(x, startY, get_sprite(0, spr), size, size)
		
		if amt ~= nil then
			LbDraw_Text(x + size - 2, startY + size - 2, tostring(amt), 0)
		end
		
		x = x + (size+o)
	end
	
	local timer = vars.active_potion.timer
	local max_potion = mg_vars.shorter_potions and 20 or 40
	local percent = floor(((timer * 100)/ max_potion) / 12)
	local active_potion = vars.active_potion.id
	local clr = active_potion == 0 and 10 or mg_vars.potions_to_color[active_potion]
	local percent_bar_h = h - 4 - bar_h
	DrawPercentBar(startX, percent_bar_h, bar_size, bar_h, percent, 0, clr, false, true)
	
	if active_potion ~= 0 then
		--if cursor_inside(startX, percent_bar_h, bar_size, bar_h) then
			--PopSetFont((w <= 800) and 4 or 3, 0)
			PopSetFont(4, 0)
			local fonth = CharHeight2()
			local max_desc_w = mf(w, 5)
			local tbl = mg_vars.potions_descriptions[active_potion]
			local title, description = tbl[1], tbl[2]
			local txt_y = h
			local txt_x = startX + bar_size + w // 32
			local txt_h, max_desc_w = type_text_in_area(description, 0, 0, max_desc_w, fonth, false)
			txt_y = txt_y - txt_h - 4
			
			DrawBox(txt_x-2, txt_y, max_desc_w+4, txt_h+4, 1)
			draw_border(txt_x-2, txt_y, max_desc_w+4, txt_h+4, "orange_shadow", true, true, true, true, true, true, true, true, true)
			type_text_in_area(description, txt_x, txt_y, max_desc_w, fonth, true)
		--end
	end
	
	return (hover or ghover)
end

function PB_on_mouse_up(left)
	if not hovering_ingame then return end
	if not hovering_ingame_id then return end
	
	if left then
		PB_use_potion(playernum, hovering_ingame_id)
	else
		PB_discard_potion(playernum, hovering_ingame_id)
	end
end

function PB_on_mouse_up_multiplayer(clicker, str)
	if type(str) ~= "string" then return end
	
	local left = decode_boolean(str:sub(1,1))
    local potion_id = tonumber(str:sub(2,2))
	

	if left then
		PB_use_potion(clicker, potion_id)
	else
		PB_discard_potion(clicker, potion_id)
	end
end

----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
--MAP_TECTONIC----------------------------------MAP_TECTONIC--------------------------------------------------------MAP_TECTONIC---------------------------------------------------------MAP_TECTONIC---
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

function TK_land_c3d(is_powerUp)
	if  mg_vars.tectonic_stage == 3 then return nil end
	
	local c3d = nil
	
	while c3d == nil do
		local a, b = 240, 255
		if chance(50) then
			a, b = 0, 12--
		end
		
		local _a, _b = 242, 255
		if chance(50) then
			_a, _b = 0, 14--
		end
		
		local _c3d = coord_to_c3d(rndb(a, b), rndb(_a, _b))
		
		if is_powerUp ~= nil then
			if is_powerup_location_free(_c3d) ~= nil then
				c3d = _c3d
			end
		else
			c3d = _c3d
		end
	end
	
	return c3d
end

function TK_init_single_AI(player)
	mg_player_vars[player].coord = TK_land_c3d()
end

function TK_init_AI()
	for _, player in ipairs(_ai_participants) do
		TK_init_single_AI(player.ptr.tribe)
	end
end

function TK_process_AI(tribe, alive, everySecond1, everySecond4, diff)
	if not alive then return end
	if not shaman_has_healthy_state(tribe) then return end
	
	local shaman = getShaman(tribe)
	local vars = mg_player_vars[tribe]
	local idle = shaman_idle(tribe)
	local tectonic_stage = mg_vars.tectonic_stage

	if tectonic_stage == 1 then
		if idle then
			if chance(5 + diff*5) then
				local places = get_me_the_closest_powerup_max_rad(tribe, shaman, 4+diff*2)
				if #places > 0 then
					local _c2d = places[1].c2d
					command_person_go_to_coord2d(shaman, _c2d)
					if chance(20) then
						vars.coord = c2d_to_c3d(_c2d)
					end
				end
			else
				command_person_go_to_coord2d(shaman, c3d_to_c2d(vars.coord))
			end
		end
	elseif tectonic_stage == 2 then
		if chance(40+15*diff) then
			if idle then
				command_person_go_to_coord2d(shaman, c3d_to_c2d(vars.coord))
			end
		end
	elseif tectonic_stage == 3 then
		if chance(40) then
			remove_all_persons_commands(shaman)
		end
	else
		if chance(12) then
			vars.coord = TK_land_c3d()
			command_person_go_to_coord2d(shaman, c3d_to_c2d(vars.coord))
		end
	end
	
	if everySecond1 or chance(4) then
		if I_HAVE_ONE_SHOT(tribe, T_SPELL, M_SPELL_CONVERT_WILD) then
			if chance(20 + 10*diff) and (tectonic_stage == 2) then
				if ggameplay.map_curr_round_timer < 12 then
					if TK_shaman_in_danger(shaman) then
						createThing(T_SPELL, M_SPELL_CONVERT_WILD, tribe, shaman.Pos.D3, false, false)
						set_spell_charges(tribe, M_SPELL_CONVERT_WILD, math.max(0, count_player_spell_shots(tribe, M_SPELL_CONVERT_WILD) - 1))
					end
				end
			end
		elseif I_HAVE_ONE_SHOT(tribe, T_SPELL, M_SPELL_BLAST) then
			if chance(8 + 4*diff) then
				local random_enemy = get_random_enemy_shaman_near_thing(shaman, 5)
				
				if random_enemy ~= nil then
					local t = createThing(T_SPELL, M_SPELL_BLAST, tribe, random_enemy.Pos.D3, false, false)
					
					if chance(60+diff*8) then
						t.u.Spell.TargetThingIdx:set(random_enemy.ThingNum)
					end
					set_spell_charges(tribe, M_SPELL_BLAST, math.max(0, count_player_spell_shots(tribe, M_SPELL_BLAST) - 1))
				end
			end
		end
		
		if chance(1) then
			create_emote(tribe)
		end
	end
end

function TK_shaman_in_danger(shaman)
	local zones = mg_vars.tectonic_zones
	local shaman_c3d = shaman.Pos.D3
	
	for _, zone in pairs(zones) do
		if get_world_dist_xyz(shaman_c3d, zone) <= 512*2 then
			return true
		end
	end
	
	return false
end

function TK_ai_find_safe_location()
	local tectonic_zones = mg_vars.tectonic_zones
	
	for _, player in ipairs(_ai_participants) do
		local tribe = player.ptr.tribe
		
		if nilS(tribe) then
			local shaman = getShaman(tribe)
			local c3d = nil
			local tries = 0
			
			while (c3d == nil) do
				local a, b = 240, 255
				if chance(50) then
					a, b = 0, 12
				end
				
				local _a, _b = 242, 255
				if chance(50) then
					_a, _b = 0, 14
				end
				
				local _c3d = coord_to_c3d(rndb(a, b), rndb(_a, _b))
				local safe = true
				
				if get_world_dist_xyz(shaman.Pos.D3, _c3d) >= 512*4 then
					safe = false
				end
				
				if safe then
					for _, v in ipairs(tectonic_zones) do
						if get_world_dist_xyz(_c3d, v) <= 1024 then
							safe = false
							break
						end
					end
				end
				
				if safe then
					c3d = _c3d
				else
					tries = tries + 1
				
					if tries > 4 + player.ptr.diff*8 then
						break
					end
				end
			end
			
			local vars = mg_player_vars[tribe]

			if not c3d then
				vars.coord = TK_land_c3d()
				command_person_go_to_coord2d(shaman, c3d_to_c2d(vars.coord))
			else
				vars.coord = c3d
				command_person_go_to_coord2d(shaman, c3d_to_c2d(vars.coord))
			end
		end
	end
end

function TK_cache_tectonic_zones()
	mg_vars.tectonic_zones = {}
	local zones = rndb(16, 64)
	local idx = 1
	
	for i = 1, zones do
		mg_vars.tectonic_zones[idx] = TK_land_c3d()
		idx = idx + 1
	end
end

function TK_show_eq()
	for _, v in ipairs(mg_vars.tectonic_zones) do
		local s = createThing(T_EFFECT, M_EFFECT_BIG_SPARKLE, SAFE_NEUTRAL, v, false, false)
		s.u.Effect.Duration = 24
		s.DrawInfo.Alpha = -16
		set_thing_draw_info(s, TDI_SPRITE_F1_D1, 1933)
	end
	
	queue_fixed_sound_event(SND_EVENT_REIN_ROCK, 0)
end

function TK_sink_zones()
	for _, v in ipairs(mg_vars.tectonic_zones) do
		local idx = world_coord3d_to_map_idx(v)
		
		SearchMapCells(SQUARE, 0, 0, 1, idx, function (me)
			me.Alt = 32
			set_square_map_params(idx, 1, TRUE)
		return true
		end)
	end
	
	queue_fixed_sound_event(SND_EVENT_LANDSPLIT, 0)
end

function TK_regen_map()
	for mk = 1, 2 do
		local center = marker_to_coord3d(mk)

		SearchMapCells(SQUARE, 0, 0, 7, world_coord3d_to_map_idx(center), function (me)
			me.Alt = 510
			me.Flags = DisableFlag(me.Flags, (1<<2))
			me.Flags = DisableFlag(me.Flags, (1<<19))
		return true
		end)
		
		set_square_map_params(world_coord3d_to_map_idx(center), 8, TRUE)
	end
	
	queue_fixed_sound_event(SND_EVENT_SHRAPNEL, 0)
	local did_emj
	
	for _, player in ipairs(_participants) do
		local tribe = player.tribe
		if nilS(tribe) then
			give_points_to_team(1, tribe, false)
			
			if player.ai then
				if (not did_emj) and (not is_tribe_using_emoji(tribe)) then
					if chance(4) then
						create_emote(tribe, (chance(50) and nil) or randomItemFromTable(_make_fun_emojis))
						if chance(50) then
							did_emj = true
						end
					end
				end
				
				if chance(50) then
					local shaman = getShaman(tribe)
					local places = get_me_the_closest_powerup_max_rad(tribe, shaman, 4+player.diff*2)
					if #places > 0 then
						command_person_go_to_coord2d(shaman, places[1].c2d)
					else
						local e = rndb(4, 7)
						local s = e - rndb(0, 2)
						SearchMapCells(SQUARE, 0, s, e, world_coord3d_to_map_idx(marker_to_coord3d(1)), function (me)
							if chance(24) then
								command_person_go_to_coord2d(shaman, me2c2d(me))
								return false
							end
						return true
						end)
					end
				end
			end
		end
	end
	order_scores()
end

function TK_tectonic_lava()
	if not mg_vars.tectonic_stage == 3 then return end
	
	SearchMapCells(SQUARE, 0, 0, 7, world_coord3d_to_map_idx(marker_to_coord3d(1)), function (me)
		if me.Alt <= 48 then
			local effect = createThing(T_EFFECT, M_EFFECT_LAVA_GLOOP, SAFE_NEUTRAL, me2c3d(me), false, false)
		end
	return true
	end)
end

function TK_check_shaman_height(tribe)
	local shaman = getShaman(tribe)
	
	if shaman.Pos.D3.Ypos <= 64 then
		queue_fixed_sound_event(SND_EVENT_ANGEL_BLAST, 0)
		delete_thing_type_safe(shaman)
		return false
	end
	
	return true
end

function TK_renew_shamans()
	if mg_vars.rng_speeds then
		tmi[TMI_PERSON_MEDICINE_MAN].BaseSpeed = rndb(80, 156)
	end
	
	for _, player in ipairs(_participants) do
		local tribe = player.tribe
		
		if not nilS(tribe) then
			spawn_shaman_at_map_position(tribe, false, game.shield_respawn, false)
		end
	end
end

function TK_init_mg_constants()
	local tectonic_jump = M_SPELL_CONVERT_WILD
	local jump_sti = sti[tectonic_jump]
	jump_sti.Cost = 10000
	jump_sti.OneOffMaximum = 2
	jump_sti.WorldCoordRange = 4096
	--1834? --2249?
	jump_sti.CursorSpriteNum = 162
	jump_sti.AvailableSpriteIdx = 1834
	jump_sti.NotAvailableSpriteIdx = 1834
	jump_sti.ClickedSpriteIdx = 1834
	
	for _, player in ipairs(_participants) do
		local pn = player.tribe
		local limits_spell = getPlayer(pn).LimitsSpell
	
		limits_spell.MaxCharges[tectonic_jump] = jump_sti.OneOffMaximum
		limits_spell.WorldCoordRange[tectonic_jump] = jump_sti.WorldCoordRange
	end
	
	disable_spells_effects_for_this_level({M_SPELL_CONVERT_WILD})
	tmi[TMI_PERSON_MEDICINE_MAN].BaseSpeed = 96
end

function TK_refresh_mg_variables()
	set_participants_can_reinc(false)
	
	mg_vars.tectonic_stage = 1
	mg_vars.tectonic_zones = {}
end

function TK_process_shamans(everySecond1, everySecond4)
	for _, player in ipairs(_participants) do
		local tribe = player.tribe
		local is_ai = player.ai
		local alive = process_death_shamans(tribe, player)
		
		if alive then
			remove_shaman_melee(tribe)
			alive = TK_check_shaman_height(tribe)
		end
		
		if is_ai then
			TK_process_AI(tribe, alive, everySecond1, everySecond4, player.diff)
		end
	end
end

function TK_process_round_timer()
	local curr = ggameplay.map_curr_round_timer - 1
	ggameplay.map_curr_round_timer = curr
	
	if curr <= 0 then
		mg_vars.tectonic_stage = mg_vars.tectonic_stage + 1
		
		if mg_vars.tectonic_stage > 4 then
			mg_vars.tectonic_stage = 1
			increase_round()
		end
		
		local new_stage = mg_vars.tectonic_stage
	
		if new_stage == 1 then --before eq
		
			ggameplay.map_curr_round_timer = 12*1
			TK_renew_shamans()
			TK_cache_tectonic_zones()
			
		elseif new_stage == 2 then --show eq
		
			ggameplay.map_curr_round_timer = 12*3 - rndb(0, 8)
			TK_show_eq()
			TK_ai_find_safe_location()
			
		elseif new_stage == 3 then --sink zones
		
			ggameplay.map_curr_round_timer = 12*2
			TK_sink_zones()
			
		elseif new_stage == 4 then --reset map
		
			ggameplay.map_curr_round_timer = 12*1
			TK_regen_map()
			
		end
	end
end

function tectonic_on_turn(everySecond1, everySecond2, everySecond4)
	if mg_turn == 1 then
		TK_init_mg_constants()
		TK_refresh_mg_variables()
		TK_init_AI()
		TK_cache_tectonic_zones()
		increase_round()
		ggameplay.map_curr_round_timer = 12*1
		ggameplay.max_powerups_at_once = is_map_rule_active(2) and 0 or 3
		mg_vars.rng_speeds = is_map_rule_active(1)
	end
	
	TK_tectonic_lava()
	TK_process_round_timer()
	TK_process_shamans(everySecond1, everySecond4)
end

function tectonic_on_create_thing(t, owner, type, model)
	if type == T_SPELL then
		if model == M_SPELL_CONVERT_WILD then
			if nilS(owner) then
				set_shaman_height(owner, 1024)
				local c3d = marker_to_coord3d(1)
				for i = 1, 32, 2 do
					afa(i, cast_spell_safe, M_SPELL_SHIELD, owner, c3d, false, false)
				end
			end
		end
	end
end

----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
--MAP_SHIFTING_SANDS----------------------------------MAP_SHIFTING_SANDS--------------------------------------------------------MAP_SHIFTING_SANDS---------------------------------------------------------MAP_SHIFTING_SANDS---
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

function SS_init_single_AI(player)
	local ai = mg_player_vars[player]
	
	ai.blast_cdr = rndb(12*3, 12*6)
	ai.locked_player = nil
end

function SS_spawn_trees(amt)
	for i = 1, amt do
		local c3d
		local tries = 0
		repeat
			local x = chance(50) and rndb(0, 38) or rndb(214, 256)
			local z = chance(50) and rndb(0, 38) or rndb(214, 256)
			c3d = coord_to_c3d(x, z)

			if is_c3d_water_or_coast(c3d) or (not c3d_totally_free(c3d)) then
				c3d = nil
			end
			tries = tries + 1
		until c3d or (tries > 8)

		if c3d then
			create_thing_cache(T_SCENERY, rndb(1, 6), SAFE_NEUTRAL, c3d)
		end
	end
end

function SS_try_to_spell_an_enemy(tribe, spell, radius, _chance, diff)
	if chance(_chance) then
		local random_enemy = get_random_enemy_shaman_near_thing(getShaman(tribe), radius)

		if random_enemy then
			if shaman_has_healthy_state(tribe) and not shaman_casting(tribe) then
				if c3d_scenery_free(random_enemy.Pos.D3) then
					local t = createThing(T_SPELL, spell, tribe, random_enemy.Pos.D3, false, false)
					
					if shaman_has_healthy_state(random_enemy.Owner) then
						if chance(60+diff*15) then
							t.u.Spell.TargetThingIdx:set(random_enemy.ThingNum)
						end
					end
					return true
				end
			end
		end
	end
	
	return false
end

function SS_process_AI(tribe, alive, everySecond1, everySecond4, diff)
	local vars = mg_player_vars[tribe]

	local blast_cdr = math.max(vars.blast_cdr - 1, 0)
	vars.blast_cdr = blast_cdr
	if not alive then return end

	if blast_cdr <= 0 then
		local success = SS_try_to_spell_an_enemy(tribe, M_SPELL_BLAST, 5, 5 + diff*5, diff)
		
		if success then
			vars.blast_cdr = rndb(12* (3-diff), 12* (6-diff))
		else
			if shaman_has_healthy_state(tribe) and not shaman_casting(tribe) then
				if chance(1 + diff) then
					local random_enemy = get_random_enemy_shaman_near_thing(getShaman(tribe), 6+diff)
					
					if random_enemy then
						local aim_c3d = aim_spell_at_target(tribe, random_enemy, 5)
						
						if aim_c3d then
							local t = createThing(T_SPELL, M_SPELL_BLAST, tribe, aim_c3d, false, false)
							vars.blast_cdr = rndb(12* (3-diff), 12* (5-diff)) + 1
							return
						end
					end
				end
			end
		end
	end
	
	local shaman = getShaman(tribe)
	local target_shaman = vars.locked_player
	local idle = shaman_idle(tribe)
	
	if not target_shaman then
		vars.locked_player = get_closest_alive_enemy_shaman(tribe)
		target_shaman = vars.locked_player
		if chance(20+diff*5) then
			if target_shaman then
				command_person_go_to_coord2d(shaman, getShaman(target_shaman).Pos.D2)
			end
		else
			if chance(4+diff*4) then
				local x = chance(50) and rndb(0, 38) or rndb(214, 256)
				local z = chance(50) and rndb(0, 38) or rndb(214, 256)
				local c2d = coord_to_c2d(x,z)
				if not is_c2d_water(c2d) then
					command_person_go_to_coord2d(shaman, c2d)
				end
			end
		end
	else
		if chance(4) then
			vars.locked_player = get_closest_alive_enemy_shaman(tribe)
			target_shaman = vars.locked_player
		end
		
		if target_shaman and nilS(target_shaman) then
			if chance(2 or idle) then
				command_person_go_to_coord2d(shaman, getShaman(target_shaman).Pos.D2)
			else
				if chance(2+diff*2) or idle then
					local x = chance(50) and rndb(0, 38) or rndb(214, 256)
					local z = chance(50) and rndb(0, 38) or rndb(214, 256)
					local c2d = coord_to_c2d(x,z)
					if not is_c2d_water(c2d) then
						command_person_go_to_coord2d(shaman, c2d)
					end
				end
			end
		else
			vars.locked_player = get_closest_alive_enemy_shaman(tribe)
			target_shaman = vars.locked_player
			
			if target_shaman then
				command_person_go_to_coord2d(shaman, getShaman(target_shaman).Pos.D2)
			end
		end
	end
	
	if everySecond4 then
		if not is_tribe_using_emoji(tribe) then
			if chance(3) then
				create_emote(tribe)
			end
		end
	end
end

function SS_process_shamans(everySecond1, everySecond4)
	local everyTurns4 = everyTurns_mg(4)
	
	for _, participant in ipairs(_participants) do
		local tribe = participant.tribe
		local is_ai = participant.ai
		local alive = process_death_shamans(tribe, participant)
		
		if is_ai then
			SS_process_AI(tribe, alive, everySecond1, everySecond4, participant.diff)
		else
			if everyTurns4 then
				GIVE_MANA_TO_PLAYER(tribe, 2048)
			end
		end
		
	end
end

function shifting_sands_on_turn(everySecond1, everySecond2, everySecond4)
	if mg_turn == 1 then
		for _, player in ipairs(_participants) do
			local tribe = player.tribe
			
			if player.ai then
				SS_init_single_AI(tribe)
			end
			
			enable_spell(tribe, M_SPELL_BLAST)
		end
		tmi[TMI_PERSON_MEDICINE_MAN].BaseSpeed = 80
		mg_vars.faster_trees = is_map_rule_active(1)
		mg_vars.tree_spawn_cdr = mg_vars.faster_trees and 12*rndb(10, 14) or 12*rndb(18,24)
		mg_vars.shenanigan_id = 1
		mg_vars.Locations = {
			MAP_XZ_2_WORLD_XYZ(2, 0), --Centre 1
			MAP_XZ_2_WORLD_XYZ(0, 28), --North 2
			MAP_XZ_2_WORLD_XYZ(28, 254), -- East 3
			MAP_XZ_2_WORLD_XYZ(254, 224), -- South 4
			MAP_XZ_2_WORLD_XYZ(226, 2), --West 5
			MAP_XZ_2_WORLD_XYZ(242, 14), --NorthWest 6
			MAP_XZ_2_WORLD_XYZ(12, 14), --NorthEast 7
			MAP_XZ_2_WORLD_XYZ(12, 240), --SouthEast 8
			MAP_XZ_2_WORLD_XYZ(242, 240), --SouthWest 9
			MAP_XZ_2_WORLD_XYZ(2, 6), --CentreSpecial 10
			MAP_XZ_2_WORLD_XYZ(8, 0), --CentreSpecial 11
			MAP_XZ_2_WORLD_XYZ(2, 250), --CentreSpecial 12
			MAP_XZ_2_WORLD_XYZ(252, 0) --CentreSpecial 13
		}
		mg_vars.shenanigans = {
			[1] = function()
				for i = 6, 9 do
					createThing(T_EFFECT, M_EFFECT_RISE, TRIBE_NEUTRAL, mg_vars.Locations[i], false, false)
				end
			end,
			[2] = function()
				local c3d = mg_vars.Locations[1]
				createThing(T_EFFECT, M_EFFECT_DIP, TRIBE_NEUTRAL, c3d, false, false)
				createThing(T_EFFECT, M_EFFECT_DIP, TRIBE_NEUTRAL, c3d, false, false)
				createThing(T_EFFECT, M_EFFECT_EROSION, TRIBE_NEUTRAL, c3d, false, false)
				createThing(T_EFFECT, M_EFFECT_EROSION, TRIBE_NEUTRAL, c3d, false, false)
			end,
			[3] = function()
				for i = 2, 5 do
					local c3d = mg_vars.Locations[i]
					createThing(T_EFFECT, M_EFFECT_HILL, TRIBE_NEUTRAL, c3d, false, false)
					insert_c3d_from_land_location(c3d)
				end
			end,
			[4] = function()
				for a = 1, 2 do
					for i = 2, 5 do
						createThing(T_EFFECT, M_EFFECT_DIP, TRIBE_NEUTRAL, mg_vars.Locations[i], false, false)
					end
					
					for i = 2, 5 do
						createThing(T_EFFECT, M_EFFECT_EROSION, TRIBE_NEUTRAL, mg_vars.Locations[i], false, false)
					end
				end
			end,
			[5] = function()
				local c3d
				
				for i = 1, 5 do
					c3d = mg_vars.Locations[i]
					createThing(T_EFFECT, M_EFFECT_RISE, TRIBE_NEUTRAL, c3d, false, false)
				end
			
				c3d = mg_vars.Locations[1]
				createThing(T_EFFECT, M_EFFECT_HILL, TRIBE_NEUTRAL, c3d, false, false)
				insert_c3d_from_land_location(c3d)
				for i = 10, 13 do
					c3d = mg_vars.Locations[i]
					createThing(T_EFFECT, M_EFFECT_HILL, TRIBE_NEUTRAL, c3d, false, false)
					insert_c3d_from_land_location(c3d)
				end
			
				for i = 6, 9 do
					local c3d = mg_vars.Locations[i]
					createThing(T_EFFECT, M_EFFECT_DIP, TRIBE_NEUTRAL, c3d, false, false)
					createThing(T_EFFECT, M_EFFECT_EROSION, TRIBE_NEUTRAL, c3d, false, false)
				end
			end,
		}
		mg_vars.Reincarnations = {
			MAP_XZ_2_WORLD_XYZ(28, 46),
			MAP_XZ_2_WORLD_XYZ(228, 44),
			MAP_XZ_2_WORLD_XYZ(208, 26),
			MAP_XZ_2_WORLD_XYZ(208, 228),
			MAP_XZ_2_WORLD_XYZ(228, 208),
			MAP_XZ_2_WORLD_XYZ(26, 208),
			MAP_XZ_2_WORLD_XYZ(46, 228),
			MAP_XZ_2_WORLD_XYZ(46, 28)
		}
		mg_vars.custom_reinc_location = function(tribe)
			return mg_vars.Reincarnations[rndb(1, #mg_vars.Reincarnations)]
		end
	end
	
	SS_process_shamans(everySecond1, everySecond4)
	
	local new_tree_cdr = math.max(mg_vars.tree_spawn_cdr - 1, 0)
	mg_vars.tree_spawn_cdr = new_tree_cdr
	
	if new_tree_cdr == 0 then
		local trees_amt = count_things_of_type(T_SCENERY)
		local min_required = mg_vars.faster_trees and 12 or 6
		
		if trees_amt < min_required then
			SS_spawn_trees(mg_vars.faster_trees and 2 or 1)
			mg_vars.tree_spawn_cdr = mg_vars.faster_trees and 12*rndb(10, 14) or 12*rndb(18,24)
		else
			mg_vars.tree_spawn_cdr = 12 * rndb(2, 8)
		end
	end
	
	if everyTurns_mg(720) then --12*60 (1 min)
		mg_vars.shenanigans[mg_vars.shenanigan_id]()
		
		mg_vars.shenanigan_id = mg_vars.shenanigan_id  + 1
		if mg_vars.shenanigan_id > #mg_vars.shenanigans then
			mg_vars.shenanigan_id = 1
		end
	end
end

function shifting_sands_on_create_thing(t, owner, type, model)
	if (type == T_SPELL) then
		local dist = 512*4
		local ignored = false
		
		for mk = 0, 7 do
			local c3d = marker_to_coord3d(mk)
			
			if (get_world_dist_xyz(c3d, t.Pos.D3) <= dist) then
				t.Model = _NO_SPELL_MODEL--M_SPELL_NONE
				ignored = true
			end
		end
		
		if not ignored then
			local targ = t.u.Spell.TargetThingIdx:get()
			if targ then
				local victim = targ.Owner
				
				if targ.Type == T_PERSON and ((victim >= 0) and (victim <= 7)) then
					if is_player_enemy(owner, victim) then
						local victim_tbl = get_participant_table(victim)
						
						if victim_tbl.ai then
							local diff = victim_tbl.diff
							
							if chance(30 + diff*20) then
								if shaman_has_healthy_state(victim) and not shaman_casting(victim) then
									if nilS(owner) then
										local dist = get_world_dist_xyz(getShaman(victim).Pos.D3, getShaman(owner).Pos.D3)
										local cells_dist = dist // 512
										
										afa(math.min(14, rndb(5, 6)+cells_dist), tribe_try_blast_trick, victim, true, 100)
										mg_player_vars[victim].blast_cdr = rndb(12* (3-diff), 12* (6-diff))
									end
								end
							end
						end
					end
				end
			else
				for _, aiplayer in ipairs(_ai_participants) do
					local player = aiplayer.ptr
					local possible_victim = player.tribe
					
					if possible_victim ~= owner then
						if nilS(possible_victim) then
							if get_world_dist_xz(t.Pos.D2, getShaman(possible_victim).Pos.D2) < 512*2 then
								try_to_dodge_on_land(possible_victim, 2, 25 + player.diff*20)
							end
						end
					end
				end
			end
		end
	elseif (type == T_EFFECT) then
		if (t.Model == M_EFFECT_SPELL_BLAST) then
			SearchMapCells(CIRCULAR, 0, 0, 0, world_coord3d_to_map_idx(t.Pos.D3), function(me)
				me.MapWhoList:processList(function(p)
					if (p.Type == T_SCENERY) then
						if (p.Model <= M_SCENERY_TREE_6) then
							local heretic = getShaman(t.Owner)

							if (heretic ~= nil) then
								createThing(T_EFFECT, M_EFFECT_LIGHTNING_BOLT, TRIBE_NEUTRAL, heretic.Pos.D3, false, false)
							end
						end
					end
				return true
				end)
			return true
			end)
		end
	end
end

function shifting_sands_on_shaman_dead(victim, killer, killer_was_ally)
	if not killer_was_ally then
		give_points_to_team(1, killer, true)
	end
end

----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
--MAP_TEMPEST----------------------------------MAP_TEMPEST--------------------------------------------------------MAP_TEMPEST---------------------------------------------------------MAP_TEMPEST---
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

function TP_init_single_AI(tribe)
	local ai = mg_player_vars[tribe]
	
	ai.blast_cdr = rndb(12*3, 12*6)
	ai.light_cdr = rndb(12*5, 12*8)
	ai.c2d = nil
end

function TP_init()
	mg_vars.LightningLocations = {}
	ProcessGlobalTypeList(T_SCENERY, function(t)
		if (t.Type == T_SCENERY) then
			if (t.Model == M_SCENERY_RS_PILLAR) then
				table.insert(mg_vars.LightningLocations, t)
			end
		end
	return true
	end)
	mg_vars.angels = {}
	local c2d = Coord2D.new()
	local c3d = Coord3D.new()
	MAP_XZ_2_WORLD_XYZ(2, 0, c3d)
	coord3D_to_coord2D(c3d, c2d)
	mg_vars.angels_nest = c2d
	mg_vars.custom_reinc_location = function(tribe)
		return marker_to_coord3d(rndb(0, 7))
	end
	for _, player in ipairs(_ai_participants) do
		TP_init_single_AI(player.ptr.tribe)
	end
end

function TP_process_AI(tribe, alive, everySecond1, everySecond4, diff)
	local vars = mg_player_vars[tribe]
	
	local blast_cdr, light_cdr = math.max(0, vars.blast_cdr - 1),  math.max(0, vars.light_cdr - 1)
	vars.blast_cdr = blast_cdr
	vars.light_cdr = light_cdr

	if alive then
		local shaman = getShaman(tribe)
		local c2d = vars.c2d
		local targ_shaman
		
		if c2d then
			local was_spawn_camping = false
			
			if everySecond4 then
				local dist = 512*2
				local sc3d = shaman.Pos.D3
				
				for mk = 0, 7 do
					local c3d = marker_to_coord3d(mk)
					
					if (get_world_dist_xyz(c3d, sc3d) <= dist) then
						c2d = mg_vars.LightningLocations[rndb(1, #mg_vars.LightningLocations)].Pos.D2
						command_person_go_to_coord2d(shaman, c2d)
						was_spawn_camping = true
						break
					end
				end
			end
			
			if not was_spawn_camping then
				local dist = get_world_dist_xz(shaman.Pos.D2, c2d)
				
				if ((dist <= 512) and (chance(8))) or chance(5) then
					if chance(50 - diff*8) then
						c2d = mg_vars.LightningLocations[rndb(1, #mg_vars.LightningLocations)].Pos.D2
						command_person_go_to_coord2d(shaman, c2d)
					else
						targ_shaman = get_closest_alive_enemy_shaman(tribe)
						
						if targ_shaman then
							c2d = copy_c2d(getShaman(targ_shaman).Pos.D2)
							command_person_go_to_coord2d(shaman, c2d)
						end
					end
				end
			end
		else
			if chance(50 - diff*8) then
				c2d = mg_vars.LightningLocations[rndb(1, #mg_vars.LightningLocations)].Pos.D2
				command_person_go_to_coord2d(shaman, c2d)
			else
				targ_shaman = get_closest_alive_enemy_shaman(tribe)
				
				if targ_shaman then
					c2d = copy_c2d(getShaman(targ_shaman).Pos.D2)
					command_person_go_to_coord2d(shaman, c2d)
				end
			end
		end
		
		vars.c2d = c2d
		
		for _, spell in ipairs({M_SPELL_BLAST, M_SPELL_LIGHTNING_BOLT}) do
			local is_blast = (spell == M_SPELL_BLAST)
			
			local cdr = is_blast and blast_cdr or light_cdr
			if not (cdr <= 0) then goto next_iteration end
			
			local rad = is_blast and 5 or 8
			local _chance = is_blast and (15 + diff*5) or (4 + diff*4)
			local success = try_to_spell_an_enemy_general(tribe, spell, rad, _chance, diff, 65+diff*12)
			
			if success then
				vars.blast_cdr = math.max(blast_cdr, rndb(12* (3-diff), 12* (6-diff)))
				vars.light_cdr = math.max(light_cdr, rndb(12* (5-diff), 12* (10-diff*2)))
				break
			else
				if shaman_has_healthy_state(tribe) and not shaman_casting(tribe) then
					if chance(1 + diff) then
						local random_enemy = get_random_enemy_shaman_near_thing(shaman, 6+diff)
						
						if random_enemy then
							local aim_c3d = aim_spell_at_target(tribe, random_enemy, rad + 2)
							
							if aim_c3d then
								local t = createThing(T_SPELL, spell, tribe, aim_c3d, false, false)
								vars.blast_cdr = math.max(blast_cdr, rndb(12* (3-diff), 12* (5-diff)))
								vars.light_cdr = math.max(light_cdr, rndb(12* (5-diff), 12* (9-diff*2)))
								break
							end
						end
					end
				end
			end
			
			::next_iteration::
		end
		
		if everySecond4 then
			if not is_tribe_using_emoji(tribe) then
				if chance(2) then
					create_emote(tribe)
				end
			end
		end
	end
end

function TP_process_shamans(everySecond1, everySecond4, everyTurns2)
	for _, participant in ipairs(_participants) do
		local tribe = participant.tribe
		local is_ai = participant.ai
		local alive = process_death_shamans(tribe, participant)
		
		if is_ai then
			TP_process_AI(tribe, alive, everySecond1, everySecond4, participant.diff)
		else
			if everyTurns2 then
				GIVE_MANA_TO_PLAYER(tribe, 4096)
			end
		end

		if alive then
			if everyTurns2 then
				local sh_c2d = getShaman(tribe).Pos.D2
				local nest = mg_vars.angels_nest
				
				for k, ang in ipairs(mg_vars.angels) do
					if ang then
						if (get_world_dist_xz(ang.Pos.D2, sh_c2d) <= 1536) then
							if ang.u.Pers then
								ang.u.Pers.Life = 0
							end
						end

						if (get_world_dist_xz(ang.Pos.D2, nest) >= 8192) then
							if ang.u.Pers then
								ang.u.Pers.Life = 0
							end
						end
					else
						table.remove(mg_vars.angels, k)
						break
					end
				end
			end
		end
	end
end

function tempest_on_turn(everySecond1, everySecond2, everySecond4)
	if mg_turn == 1 then
		for _, player in ipairs(_participants) do
			local tribe = player.tribe
			
			if player.ai then
				SS_init_single_AI(tribe)
			end
			
			enable_spell(tribe, M_SPELL_BLAST)
			enable_spell(tribe, M_SPELL_LIGHTNING_BOLT)
		end
		tmi[TMI_PERSON_MEDICINE_MAN].BaseSpeed = 80
		mg_vars.no_s_clicks = is_map_rule_active(1)
		TP_init()
	end
	
	local everyTurns2 = everyTurns_mg(2)
	
	TP_process_shamans(everySecond1, everySecond4, everyTurns2)
	
	if everyTurns_mg(2200) then
		local c3d = MAP_XZ_2_WORLD_XYZ(2, 0)
		
		for tribe = 0, 7 do
			local angel = create_thing_cache(T_PERSON, M_PERSON_ANGEL, tribe, c3d)
			table.insert(mg_vars.angels, angel)
		end
	end
	
	if everyTurns_mg(60 + G_RANDOM(240)) then
		local lightsToShoot = {}
		for i = 1, G_RANDOM(12) + 1 do
			table.insert(lightsToShoot, mg_vars.LightningLocations[rndb(1, #mg_vars.LightningLocations)])
		end

		for _, loc in pairs(lightsToShoot) do
			local foundShaman

			SearchMapCells(SQUARE, 0, 0, 2, world_coord3d_to_map_idx(loc.Pos.D3), function(me)
				me.MapWhoList:processList(function(p)
					if (p.Type == T_PERSON) then
						if (p.Model == M_PERSON_MEDICINE_MAN) then
							createThing(T_EFFECT, M_EFFECT_LIGHTNING_BOLT, SAFE_NEUTRAL, p.Pos.D3, false, false)
							foundShaman = p.Owner
						end
					end
				return true
				end)
			return true
			end)

			if foundShaman then
				get_participant_table(foundShaman).ldb = SAFE_NEUTRAL
				if nilS(foundShaman) then
					getShaman(foundShaman).u.Pers.u.Owned.LastDamagedBy = SAFE_NEUTRAL
				end
				
				createThing(T_EFFECT, M_EFFECT_LIGHTNING_BOLT, SAFE_NEUTRAL, loc.Pos.D3, false, false)
			end
		end
	end
end

function tempest_on_create_thing(t, owner, type, model)
	if type == T_SPELL then
		local dist = 3072 --6rad
		local ignored = false
		
		for mk = 0, 7 do
			local c3d = marker_to_coord3d(mk)
			
			if (get_world_dist_xyz(c3d, t.Pos.D3) <= dist) then
				t.Model = _NO_SPELL_MODEL--M_SPELL_NONE
				ignored = true
			end
		end
		
		if not ignored then
			local targ = t.u.Spell.TargetThingIdx:get()
			
			if targ then
				if model == M_SPELL_LIGHTNING_BOLT then
					if mg_vars.no_s_clicks then
						local targindex = t.u.Spell.TargetThingIdx
						
						if (not targindex:isNull()) then
							targindex:set(0)
						end
					end
				end
			
				local victim = targ.Owner
				
				if targ.Type == T_PERSON and ((victim >= 0) and (victim <= 7)) then
					if is_player_enemy(owner, victim) then
						local victim_tbl = get_participant_table(victim)
						
						if victim_tbl.ai then
							local diff = victim_tbl.diff
							local _chance = ((model == M_SPELL_LIGHTNING_BOLT) and (5 + diff*5)) or (30 + diff*20)
							
							if chance(_chance) then
								if shaman_has_healthy_state(victim) and not shaman_casting(victim) then
									if nilS(owner) then
										local dist = get_world_dist_xyz(getShaman(victim).Pos.D3, getShaman(owner).Pos.D3)
										local cells_dist = dist // 512
										
										afa(math.min(14, rndb(5, 6)+cells_dist), tribe_try_blast_trick, victim, true, 100)
										mg_player_vars[victim].blast_cdr = math.max(mg_player_vars[victim].blast_cdr, rndb(12* (3-diff), 12* (4-diff)))
									end
								end
							end
						end
					end
				end
			else
				for _, aiplayer in ipairs(_ai_participants) do
					local player = aiplayer.ptr
					local possible_victim = player.tribe
					
					if possible_victim ~= owner then
						if nilS(possible_victim) then
							if is_player_enemy(owner, possible_victim) then
								if get_world_dist_xz(t.Pos.D2, getShaman(possible_victim).Pos.D2) < 512*2 then
									local diff = player.diff
									local _chance = ((model == M_SPELL_LIGHTNING_BOLT) and (50 + diff*15)) or (30 + diff*15)
									
									try_to_dodge_on_land(possible_victim, 2, _chance)
								end
							end
						end
					end
				end
			end
		end
	end
end

function tempest_on_shaman_dead(victim, killer, killer_was_ally)
	if not killer_was_ally then
		give_points_to_team(1, killer, true)
	end
end

----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
--MAP_TILES_WAR----------------------------------MAP_TILES_WAR--------------------------------------------------------MAP_TILES_WAR---------------------------------------------------------MAP_TILES_WAR---
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

function TW_init_single_AI(tribe)
	local ai = mg_player_vars[tribe]
	
	ai.lights = 0
	ai.torns = 0
	ai.c2d = nil
end

function TW_give_spell(tribe, model)
	local is_ai = get_participant_table(tribe).ai
	
	if is_ai then
		if model == M_SPELL_LIGHTNING_BOLT then
			mg_player_vars[tribe].lights = math.min(mg_player_vars[tribe].lights + 1, 4)
		else
			mg_player_vars[tribe].torns = math.min(mg_player_vars[tribe].torns + 1, 3)
		end
	else
		GIVE_ONE_SHOT(model, tribe)
	end
end

function TW_process_AI(tribe, alive, everySecond1, everySecond4, diff)
	if alive then
		local vars = mg_player_vars[tribe]
		local shaman = getShaman(tribe)
		local c2d = vars.c2d
		local height = shaman.Pos.D3.Ypos
		
		if not c2d then
			if chance(10) then
				local coord2d = coord_to_c2d(rndb(40, 90), rndb(30, 66))
				vars.c2d = coord2d
			else
				local places = get_me_the_closest_powerup_max_rad(tribe, shaman, 6+diff*2)

				if #places == 1 then
					local item = places[1]
					vars.c2d = item.c2d
				elseif #places > 1 then
					if #places >= 2 then
						if chance(50) then
							local item = places[2]
							vars.c2d = item.c2d
						else
							local item = places[1]
							vars.c2d = item.c2d
						end
					end
				else
					if height < 512 then
						if chance(50) then
							local targ_shaman = get_closest_alive_enemy_shaman(tribe)
						
							if targ_shaman then
								vars.c2d = copy_c2d(getShaman(targ_shaman).Pos.D2)
							end
						else
							local coord2d = coord_to_c2d(rndb(40, 90), rndb(30, 66))
							vars.c2d = coord2d
						end
					else
						local coord2d = coord_to_c2d(rndb(40, 90), rndb(30, 66))
						vars.c2d = coord2d
					end
				end
			end
			
			if vars.c2d then
				command_person_go_to_coord2d(shaman, vars.c2d)
			end
		else
			local dist = get_world_dist_xz(c2d, shaman.Pos.D2)
			
			if dist < 256 then
				local coord2d = coord_to_c2d(rndb(40, 90), rndb(30, 66))
				vars.c2d = coord2d
				command_person_go_to_coord2d(shaman, coord2d)
			else
				local idle = shaman_idle(tribe)
				
				if idle then
					local coord2d = coord_to_c2d(rndb(40, 90), rndb(30, 66))
					vars.c2d = coord2d
					command_person_go_to_coord2d(shaman, coord2d)
				else
					if chance(3-diff) then
						if chance(40) then
							local coord2d = coord_to_c2d(rndb(40, 90), rndb(30, 66))
							vars.c2d = coord2d
							command_person_go_to_coord2d(shaman, coord2d)
						else
							local targ_shaman = get_closest_alive_enemy_shaman(tribe)
						
							if targ_shaman then
								vars.c2d = copy_c2d(getShaman(targ_shaman).Pos.D2)
								command_person_go_to_coord2d(shaman, vars.c2d)
							end
						end
					end
				end
			end
			
			if chance(8 + diff*16) then
				local coord_2d = get_cell_in_direction_of_walking_thing(shaman, rndb(1, 2), true)
				if coord_2d then
					local dark_path
					
					SearchMapCells(SQUARE, 0, 0, 0, world_coord2d_to_map_idx(coord_2d), function(me)
						if me.ShadeIncr <= -16 then
							dark_path = true
							return false
						end
					return true
					end)
				
					if dark_path then
						local coord2d = coord_to_c2d(rndb(40, 90), rndb(30, 66))
						vars.c2d = coord2d
						command_person_go_to_coord2d(shaman, coord2d)
					end
				end
			end
		end
		
		--if not mg_vars.no_spells then
			local lights = vars.lights
			local torns = vars.torns
			
			if (lights > 0) or (torns > 0) then
				local spell =
					(lights > 0 and torns > 0) and (chance(50) and M_SPELL_LIGHTNING_BOLT or M_SPELL_WHIRLWIND)
						or (lights > 0 and M_SPELL_LIGHTNING_BOLT or (torns > 0 and M_SPELL_WHIRLWIND))
				local radius = (spell == M_SPELL_LIGHTNING_BOLT) and (8+diff) or (4+diff)
				
				if chance(1+diff) then
					if chance(50+diff*10) then
						local random_enemy = get_random_enemy_shaman_near_thing(shaman, 6+diff)
							
						if random_enemy then
							local aim_c3d = aim_spell_at_target(tribe, random_enemy, radius + 2)
							
							if aim_c3d then
								local t = createThing(T_SPELL, spell, tribe, aim_c3d, false, false)
								
								if spell == M_SPELL_LIGHTNING_BOLT then
									vars.lights = math.max(lights - 1, 0)
								else
									vars.torns = math.max(torns - 1, 0)
								end
							end
						end
					else
						if try_to_spell_an_enemy_general(tribe, spell, radius, 100, diff, 90 + diff*5) then
							
							if spell == M_SPELL_LIGHTNING_BOLT then
								vars.lights = math.max(lights - 1, 0)
							else
								vars.torns = math.max(torns - 1, 0)
							end
						end
					end
				end
			end
		--end
		
		if everySecond4 then
			if not is_tribe_using_emoji(tribe) then
				if chance(2) then
					create_emote(tribe)
				end
			end
		end
	end
end

function TW_process_shaman_cells(tribe, shaman, everyTurns4)
	if not shaman then return end
	local died = false
	
	SearchMapCells(SQUARE, 0, 0, 0, world_coord3d_to_map_idx(shaman.Pos.D3), function(me)
		local curr = me.ShadeIncr
		me.ShadeIncr = math.max(-32, curr - 3)
		if me.ShadeIncr <= -32 then
			shaman.u.Pers.Life = 0
			afa(12*rndb(12, 24), reset_cell_shadowincr, me)
			died = true
			return false
		end
	return true
	end)
	
	if everyTurns4 then
		if not died then
			give_points_to_team(1, tribe, false)
		end
	end
end

function set_me_shadowincr(me, value)
	me.ShadeIncr = value
end

function reset_cell_shadowincr(map_elem)
	if map_elem.ShadeIncr <= -32 then
		map_elem.ShadeIncr = 24
	end
end

function TW_powerup_c3d()
	local c3d
	
	while not c3d do
		local x = rndb(40, 90)
		local z = rndb(30, 66)
		local _c3d = coord_to_c3d(x,z)
		
		if c3d_person_free(_c3d) and is_powerup_location_free(_c3d) then
			c3d = _c3d
		end
	end
	
	return c3d
end

function TW_reset()
	local value = rndb(-4, 24)
	local i = 1
	
	for z = 30, 66, 2 do
		for x = 40, 90, 2 do
			SearchMapCells(SQUARE, 0, 0, 0, coord_to_map_idx(x,z), function(me)
				afa(i, set_me_shadowincr, me, value)
			return true end)
		end
		i = i + 2
	end
end

function TW_process_shamans(everySecond1, everySecond4, everyTurns2)
	local everyTurns4 = everyTurns_mg(4)
	
	for _, participant in ipairs(_participants) do
		local tribe = participant.tribe
		local is_ai = participant.ai
		local alive = process_death_shamans(tribe, participant)
		
		if is_ai then
			TW_process_AI(tribe, alive, everySecond1, everySecond4, participant.diff)
		end

		if alive then
			local shaman = getShaman(tribe)
			local height = shaman.Pos.D3.Ypos
			
			remove_shaman_melee(tribe)
			
			if height < 390 then
				shaman.u.Pers.Life = 0
				goto early_return
			elseif height <= 392 then
				TW_process_shaman_cells(tribe, shaman, everyTurns4)
			end
		end
		
		::early_return::
	end
	
	order_scores()
end

function TW_reset_shadowincr(value)
	for mk = 8, 17 do
		local radius = (mk <= 11) and 7 or 2
		
		SearchMapCells(CIRCULAR, 0, 0, radius, world_coord3d_to_map_idx(marker_to_coord3d(mk)), function(me)
			me.ShadeIncr = value
		return true
		end)
	end
end

function tiles_war_on_turn(everySecond1, everySecond2, everySecond4)
	if mg_turn == 1 then
		for _, player in ipairs(_ai_participants) do
			TW_init_single_AI(player.ptr.tribe)
		end
		tmi[TMI_PERSON_MEDICINE_MAN].BaseSpeed = 128
		TW_reset_shadowincr(24)
		ggameplay.max_powerups_at_once = 10--is_map_rule_active(1) and 0 or 9
		--mg_vars.no_spells = is_map_rule_active(2)
		mg_vars.reset_after_seconds = 100 - #_participants*5
	end
	
	TW_process_shamans(everySecond1, everySecond4)
	
	if everySeconds_mg(mg_vars.reset_after_seconds) then
		TW_reset()
	end
end

----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
--SUN_AND_MOON----------------------------------SUN_AND_MOON--------------------------------------------------------SUN_AND_MOON---------------------------------------------------------SUN_AND_MOON---
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

function SM_init_single_AI(tribe)
	local vars = mg_player_vars[tribe]
	vars.lights_cdr = 12*5
	vars.blasts_cdr = 12*rndb(3, 7)
	vars.c2d = nil
end

function SM_process_AI(tribe, alive, everySecond1, everySecond4, diff, vars, star_owner_valid, star_owner)
	local lights_cdr = math.max(0, vars.lights_cdr - 1)
	local blasts_cdr = math.max(0, vars.blasts_cdr - 1)
	vars.lights_cdr = lights_cdr
	vars.blasts_cdr = blasts_cdr
	
	if alive then
		local shaman = getShaman(tribe)
		if not shaman_can_cast(shaman) then return end
		
		local acq_shots = GET_NUM_ONE_OFF_SPELLS(tribe, M_SPELL_INSECT_PLAGUE)
		local i_have_star = star_owner == tribe
		
		if star_owner_valid then
			if acq_shots > 0 then
				if chance(3 + diff*2) then
					if nilS(star_owner) then
						if is_player_enemy(tribe, star_owner) then
							local star_shaman = getShaman(star_owner)
							local dist = get_world_dist_xyz(star_shaman.Pos.D3, shaman.Pos.D3)
							
							if dist < 512*(10 + diff) then
								if chance(50 + diff*15) then
									local aim_c3d = aim_spell_at_target(tribe, star_shaman, 10 + diff)
							
									if aim_c3d then
										local t = createThing(T_SPELL, M_SPELL_INSECT_PLAGUE, tribe, aim_c3d, false, false)
										local shots = GET_NUM_ONE_OFF_SPELLS(tribe, M_SPELL_INSECT_PLAGUE)
										set_spell_charges(tribe, M_SPELL_INSECT_PLAGUE, math.max(0, shots - 1))
										goto end_of_casts
									end
								else
									local t = createThing(T_SPELL, M_SPELL_INSECT_PLAGUE, tribe, copy_c3d(star_shaman.Pos.D3), false, false)
									local shots = GET_NUM_ONE_OFF_SPELLS(tribe, M_SPELL_INSECT_PLAGUE)
									set_spell_charges(tribe, M_SPELL_INSECT_PLAGUE, math.max(0, shots - 1))
									goto end_of_casts
								end
							end
						end
					end
				end
			end
		end

		if i_have_star and lights_cdr <= 0 then
			if chance(3 + diff*4) then
				local random_enemy = get_random_enemy_shaman_near_thing(shaman, 8+1)
					
				if random_enemy then
					local aim_c3d = aim_spell_at_target(tribe, random_enemy, 8+1)
					
					if aim_c3d and chance(30 + diff*20) then
						local t = createThing(T_SPELL, M_SPELL_LIGHTNING_BOLT, tribe, aim_c3d, false, false)
						vars.lights_cdr = rndb(12*5, 12*(7-diff)+1)
						goto end_of_casts
					else
						goto light_sclick
					end
				else
					goto light_sclick
				end
				
				::light_sclick::
				local success = try_to_spell_an_enemy_general(tribe, M_SPELL_LIGHTNING_BOLT, 8, 80, diff, 50+diff*20)
	
				if success then
					vars.lights_cdr = rndb(12*5, 12*(7-diff)+1)
					goto end_of_casts
				end
			end
		end
		
		if blasts_cdr <= 0 then
			if chance(1+diff) and chance(16+diff*4) then
				local random_enemy = get_random_enemy_shaman_near_thing(shaman, 5+1)
						
				if random_enemy then
					local aim_c3d = aim_spell_at_target(tribe, random_enemy, 5+1)
					
					if aim_c3d and chance(10 + diff*10) then
						local t = createThing(T_SPELL, M_SPELL_BLAST, tribe, aim_c3d, false, false)
						vars.blasts_cdr = rndb(12*2, 12*(10-diff*2)+1)
						goto end_of_casts
					else
						goto blast_sclick
					end
				else
					goto blast_sclick
				end
				
				::blast_sclick::
				if try_to_spell_an_enemy_general(tribe, M_SPELL_BLAST, 5, 70+diff*4, diff, 55+diff*16) then
					vars.blasts_cdr = rndb(12*2, 12*(10-diff*2)+1)
				end
			end
		end
		
		::end_of_casts::
		
		local c2d = vars.c2d
		local star = mg_vars.star
		local star_c2d = star.Pos.D2
		
		local idle = shaman_idle(tribe)
		if idle then
			goto follow_star
		end
		
		do
			if c2d then
				local dist_to_c2d = get_world_dist_xz(star_c2d, shaman.Pos.D2)
				
				if dist_to_c2d >= 512*10 then
					goto follow_star
				else
					if chance(1+diff) then
						if chance(50) then
							if chance(50) then
								goto move_to_marker
							else
								goto follow_star
							end
						else
							if chance(50) then
								local random_enemy = get_random_enemy_shaman_near_thing(shaman, 10)
								if random_enemy then
									vars.c2d = copy_c2d(random_enemy.Pos.D2)
									command_person_go_to_coord2d(shaman, vars.c2d)
									return
								else
									goto move_to_marker
								end
							else
								goto follow_star
							end
						end
					end
				end
			else
				goto follow_star
			end
			
			--close to target c2d
			if vars.c2d then
				if i_have_star then
					local dist = get_world_dist_xz(vars.c2d, shaman.Pos.D2)
					
					if dist < 512 then
						goto move_to_marker
					else
						if chance(4+diff) then
							goto move_to_marker
						end
					end
				else
					local dist = get_world_dist_xz(star_c2d, shaman.Pos.D2)
					
					if dist <= 256+128+32 then
						if is_player_enemy(tribe, star_owner) then
							if nilS(star_owner) then
								goto follow_star
							else
								goto move_to_marker
							end
						else
							if chance(50) then
								local random_enemy = get_random_enemy_shaman_near_thing(shaman, 10)
								if random_enemy then
									vars.c2d = copy_c2d(random_enemy.Pos.D2)
									command_person_go_to_coord2d(shaman, vars.c2d)
									return
								else
									goto move_to_marker
								end
							else
								goto move_to_marker
							end
						end
					end
				end
			end
		end
		
		goto exit
		
		::move_to_marker::
		do
			local mk = rndb(8, 30)
			local mkc2d = marker_to_coord2d(mk)
			MOVE_SHAMAN_TO_MARKER(tribe, mk)
			vars.c2d = mkc2d
			return
		end
		
		::follow_star::
		vars.c2d = copy_c2d(star_c2d)
		command_person_go_to_coord2d(shaman, vars.c2d)
		
		::exit::
	else
		vars.c2d = copy_c2d(mg_vars.star.Pos.D2)
	end
end

function SM_process_shamans(everySecond1, everySecond4)
	local everySecond8 = everyTurns_mg(8*12)
	
	for _, participant in ipairs(_participants) do
		local tribe = participant.tribe
		local is_ai = participant.ai
		local alive = process_death_shamans(tribe, participant)
		local shaman = getShaman(tribe)
		local star = mg_vars.star
		local star_owner = star.Owner
		local star_owner_valid = (star_owner >= 0) and (star_owner <= 7)
		local vars = mg_player_vars[tribe]
		
		if is_ai then
			SM_process_AI(tribe, alive, everySecond1, everySecond4, participant.diff, vars, star_owner_valid, star_owner)
		else
			GIVE_MANA_TO_PLAYER(tribe, 400)
		end
		
		if everySecond8 then
			local shots = GET_NUM_ONE_OFF_SPELLS(tribe, M_SPELL_INSECT_PLAGUE)
			set_spell_charges(tribe, M_SPELL_INSECT_PLAGUE, math.min(2, shots + 1))
		end

		if alive then
			local shaman_c3d = shaman.Pos.D3
			
			if not star_owner_valid then
				local dist = get_world_dist_xyz(shaman_c3d, star.Pos.D3)
				
				if dist <= 256+128 then
					star.Owner = tribe
					star.DrawInfo.Flags = DisableFlag(star.DrawInfo.Flags, DF_USE_ENGINE_SHADOW)
					give_points_to_team(5, tribe, true)
				end
			end
			
			if star_owner == tribe then
				local light_give_cdr = math.max(0, vars.light_give_cdr - 1)
				vars.light_give_cdr = light_give_cdr
				
				if light_give_cdr <= 0 then
					vars.light_give_cdr = 12*5
					local shots = GET_NUM_ONE_OFF_SPELLS(tribe, M_SPELL_LIGHTNING_BOLT)
					set_spell_charges(tribe, M_SPELL_LIGHTNING_BOLT, math.min(4, shots + 1))
				end
			end
		end
	end
end

function SM_process_cycle()
	local cdr = math.max(mg_vars.texture_cdr - 1, 0)
	mg_vars.texture_cdr = cdr
	
	if cdr <= 0 then
		local cycle = mg_vars.daycicle
		if cycle == 1 then
			mg_vars.daycicle = 2
			set_level_type(3)
			draw_sky_clr_overlay(-1, -1)
			local star = mg_vars.star
			if star then
				set_thing_draw_info(star,TDI_SPRITE_F16_D1_ALPHA, 2250+16)
				star.DrawInfo.Alpha = -16
				if star.Owner == SAFE_NEUTRAL then
					star.DrawInfo.Flags = EnableFlag(star.DrawInfo.Flags, DF_USE_ENGINE_SHADOW)
				end
			end
		else
			mg_vars.daycicle = 1
			set_level_type(14)
			draw_sky_clr_overlay(2, -1)
			local star = mg_vars.star
			if star then
				set_thing_draw_info(star,TDI_SPRITE_F16_D1_ALPHA, 2250)
				star.DrawInfo.Alpha = -16
				if star.Owner == SAFE_NEUTRAL then
					star.DrawInfo.Flags = EnableFlag(star.DrawInfo.Flags, DF_USE_ENGINE_SHADOW)
				end
			end
		end
		
		mg_vars.texture_cdr = 12 * 60
	end
end

function SM_process_star(everySecond1)
	local star = mg_vars.star
	if not star then return end
	
	local star_owner = star.Owner
	local owner_valid = (star_owner >= 0) and (star_owner <= 7)
	
	if owner_valid then
		if nilS(star_owner) then
			local shaman = getShaman(star_owner)
			local shaman_c3d = copy_c3d(shaman.Pos.D3)
			mg_vars.c3d = shaman_c3d
			move_thing_within_mapwho(star, shaman_c3d)
			star.Pos.D3.Ypos = shaman_c3d.Ypos + 256
			
			if everySecond1 then
				local day = (mg_vars.daycicle == 1)
				give_points_to_team(day and 2 or 1, star_owner, false)
				
				if not day then
					local star_owner_team_ptr = _tribes_to_participants_ptrs[star_owner].team_ptr
					local star_owner_uid = star_owner_team_ptr.uid
					
					for _, team in ipairs(_participants_by_teams) do
						if star_owner_uid ~= team.uid then
							team.points = math.max(0, team.points - 1)
						end
					end
				end
				
				order_scores()
			end
		else
			star.Owner = SAFE_NEUTRAL
			mg_vars.star_dir = 1
			local star_c3d = mg_vars.c3d
			star.Pos.D3.Ypos = point_altitude(star_c3d.Xpos, star_c3d.Zpos)
			star.DrawInfo.Flags = EnableFlag(star.DrawInfo.Flags, DF_USE_ENGINE_SHADOW)
		end
	else
		local star_c3d = mg_vars.c3d
		
		if is_c3d_water_or_coast(star_c3d) then
			for radius = 1, 24 do
				local land = false
				
				SearchMapCells(CIRCULAR, 0, radius - 1, radius, world_coord3d_to_map_idx(star_c3d), function(me)
					if (is_map_elem_all_land(me) > 0) then
						local land2D = Coord2D.new()
						map_ptr_to_world_coord2d(me, land2D)
						local land3D = Coord3D.new()
						coord2D_to_coord3D(land2D, land3D)
						move_thing_within_mapwho(star, land3D)
						land = true
					return true end
				return true end)
				
				if land then break end
			end
			mg_vars.star_dir = 1
			star.Pos.D3.Ypos = point_altitude(star.Pos.D3.Xpos, star.Pos.D3.Zpos)
			mg_vars.c3d = star.Pos.D3
		else
			local cell_alt = point_altitude(star_c3d.Xpos, star_c3d.Zpos)
			local star_curr_y = star.Pos.D3.Ypos
			local speed = 6
			
			if mg_vars.star_dir == 1 then
				local limit = cell_alt + 128
				star_curr_y = math.min(star_curr_y + speed, limit)
				
				if star_curr_y >= limit then
					mg_vars.star_dir = 2
				end
			else
				local limit = cell_alt
				star_curr_y = math.max(star_curr_y - speed, limit)
				
				if star_curr_y <= limit then
					mg_vars.star_dir = 1
				end
			end
			
			star.Pos.D3.Ypos = star_curr_y
		end
	end
end

function sun_moon_on_turn(everySecond1, everySecond2, everySecond4)
	if mg_turn == 1 then
		disable_spells_effects_for_this_level({M_SPELL_INSECT_PLAGUE})
		tmi[TMI_PERSON_MEDICINE_MAN].BaseSpeed = 72
		
		local acq = M_SPELL_INSECT_PLAGUE
		local acq_sti = sti[acq]
		
		acq_sti.OneOffMaximum = 2
		acq_sti.WorldCoordRange = 8192
		acq_sti.CursorSpriteNum = 152
		acq_sti.AvailableSpriteIdx = 2282
		acq_sti.NotAvailableSpriteIdx = 2282
		acq_sti.ClickedSpriteIdx = 2282
		
		for _, player in ipairs(_participants) do
			local tribe = player.tribe
			local limits_spell = getPlayer(tribe).LimitsSpell
			local vars = mg_player_vars[tribe]
		
			limits_spell.MaxCharges[acq] = acq_sti.OneOffMaximum
			limits_spell.WorldCoordRange[acq] = acq_sti.WorldCoordRange
			
			if player.ai then
				SM_init_single_AI(tribe)
			end
			
			enable_spell(tribe, M_SPELL_BLAST)
			vars.light_give_cdr = 12*5
		end
		
		mg_vars.custom_reinc_location = function(tribe)
			return marker_to_coord3d(rndb(9, 30))
		end
		
		mg_vars.daycicle = 1
		mg_vars.texture_cdr = 12*60
		draw_sky_clr_overlay(2,-1)
		
		local star = create_thing_cache(T_EFFECT, 60, SAFE_NEUTRAL, marker_to_coord3d(8))
		if star then
			centre_coord3d_on_block(star.Pos.D3)
			set_thing_draw_info(star,TDI_SPRITE_F16_D1_ALPHA, 2250)
			star.u.Effect.Duration = -1
			star.DrawInfo.Alpha = -16
			star.DrawInfo.Flags = EnableFlag(star.DrawInfo.Flags, DF_USE_ENGINE_SHADOW)
			mg_vars.star = star
			mg_vars.star_dir = 1
			mg_vars.c3d = copy_c3d(star.Pos.D3)
		end
		mg_vars.acquire_hitbox_radius = is_map_rule_active(1) and 512 or (256 + 64)
	end
	
	SM_process_cycle()
	SM_process_star(everySecond1)
	SM_process_shamans(everySecond1, everySecond4)
end

function sun_moon_on_create_thing(t, owner, type, model)
	if type == T_SPELL then
		if model == M_SPELL_INSECT_PLAGUE then
			if nilS(owner) then
				queue_sound_event(t, SND_EVENT_BIRTH, SEF_FIXED_VARS) --SND_EVENT_SHOT_STANDARD
				afa(12, SM_acquire_spell, owner, copy_c3d(t.Pos.D3))
			end
		end
		
		for _, aiplayer in ipairs(_ai_participants) do
			local player = aiplayer.ptr
			local possible_victim = player.tribe
			
			if (model ~= M_SPELL_INSECT_PLAGUE) or (mg_vars.star.Owner == possible_victim) then
				if possible_victim ~= owner then
					if nilS(possible_victim) then
						if get_world_dist_xz(t.Pos.D2, getShaman(possible_victim).Pos.D2) < 512*2 then
							try_to_dodge_on_land(possible_victim, 2, 25 + player.diff*20)
						end
					end
				end
			end
		end
	elseif type == T_EFFECT then
		if model == M_EFFECT_INSECT_PLAGUE then
			t.u.Effect.Duration = 1
		end
	end
end

function SM_acquire_spell(owner, c3d)
	local s = createThing(T_EFFECT, 66, SAFE_NEUTRAL, c3d, false, false)
	s.u.Effect.Duration = 4
	s.DrawInfo.Alpha = _tribes_to_participants_ptrs[owner].g_color
	
	if not nilS(owner) then return end
	local star = mg_vars.star
	local star_owner = star.Owner
	if star_owner == SAFE_NEUTRAL then return end
	if not is_player_enemy(owner, star_owner) then return end
	
	if nilS(star_owner) then
		local star_shaman = getShaman(star_owner)
		local dist = get_world_dist_xyz(star_shaman.Pos.D3, c3d)
		
		if dist <= mg_vars.acquire_hitbox_radius then
			star.Owner = owner
			star.DrawInfo.Flags = DisableFlag(star.DrawInfo.Flags, DF_USE_ENGINE_SHADOW)
			give_points_to_team(5, owner, true)
			queue_sound_event(star, SND_EVENT_DISCOBLDG_END, 1)
			local shots = GET_NUM_ONE_OFF_SPELLS(star_owner, M_SPELL_LIGHTNING_BOLT)
			set_spell_charges(star_owner, M_SPELL_LIGHTNING_BOLT, math.max(0, shots - 1))
		end
	end
	
	queue_sound_event(star, SND_EVENT_SHRAPNEL, 1)
end

function sun_moon_on_shaman_dead(victim, killer, killer_was_ally)
	local vars = mg_player_vars[victim]
	
	disable_spell(victim, M_SPELL_LIGHTNING_BOLT, true, true)
	vars.light_give_cdr = 12*5
end

----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
--MAP_TESLA_COIL----------------------------------MAP_TESLA_COIL--------------------------------------------------------MAP_TESLA_COIL---------------------------------------------------------MAP_TESLA_COIL---
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

function TC_init_single_AI(tribe)
	local vars = mg_player_vars[tribe]
	vars.blasts_cdr = 12*8
	vars.lights_cdr = 12*rndb(12, 16)
	vars.torns_cdr = 12*rndb(24, 32)
	vars.fs_cdr = 12*rndb(32, 64)
	vars.selfblast_cdr = 12*rndb(4, 8)
	vars.c2d = nil
end

function TC_give_turbo(catcher)
	mg_player_vars[catcher].turbo = 12*10
	if nilS(catcher) then
		local shaman = getShaman(catcher)
		if shaman.u.Pers then
			shaman.u.Pers.Life = shaman.u.Pers.MaxLife
		end
	end
end

function TC_powerup_c3d()
	local c3d

	while not c3d do
		local x = rndb(122, 202)
		local z = rndb(62, 142)
		local _c3d = coord_to_c3d(x,z)
		
		if is_c3d_water(_c3d) and is_powerup_location_free(_c3d) then
			c3d = _c3d
		end
	end
	
	return c3d
end

function TC_process_AI(tribe, alive, everySecond1, everySecond2, everySecond4, diff, vars, shaman, vehicled, prize)
	vars.blasts_cdr = math.max(0, vars.blasts_cdr - 1)
	vars.lights_cdr = math.max(0, vars.lights_cdr - 1)
	vars.torns_cdr = math.max(0, vars.torns_cdr - 1)
	vars.fs_cdr = math.max(0, vars.fs_cdr - 1)
	vars.selfblast_cdr = math.max(0, vars.selfblast_cdr - 1)
	
	if not alive then return end
	
	if everySecond4 then
		if (not is_tribe_using_emoji(tribe)) then
			if chance(1) then
				create_emote(tribe, (chance(50) and nil) or 4)
			end
		end
	end
	
	if vehicled then
		if prize then
			local targ_c2d = vars.c2d
			local prize_c2d = prize.Pos.D2
			
			if not targ_c2d then
				command_person_go_to_coord2d(shaman, prize_c2d)
				vars.c2d = prize_c2d
			else
				if shaman.State ~= S_PERSON_UNDER_COMMAND then
					command_person_go_to_coord2d(shaman, prize_c2d)
				else
					local casted = false
					
					if shaman_can_cast(shaman) then
						local dist = get_world_dist_xz(shaman.Pos.D2, prize_c2d)
						
						if dist > 512*(8-diff) and (vars.selfblast_cdr <= 0) then
							if try_to_blast_own_boat(tribe, shaman, 16+diff*16) then
								vars.selfblast_cdr = 12*rndb(2, 8-diff*2)
							else
								goto try_spells
							end
						else
							if chance(4) or shaman_idle(tribe) then
								local water_tbl = {}
								
								SearchMapCells(SQUARE, 0, 0, rndb(1, 4), world_coord3d_to_map_idx(prize.Pos.D3), function(me)
									if is_map_elem_all_sea(me) > 0 then
										table.insert(water_tbl, me)
									end
									return true
								end)
								
								if #water_tbl > 0 then
									local water_c2d = water_tbl[rndb(1, #water_tbl)]
									water_c2d = me2c2d(water_c2d)
									command_person_go_to_coord2d(shaman, water_c2d)
									return
								else
									goto try_spells
								end
							else
								goto try_spells
							end
						end
					end
					do return end
					
					::try_spells::
					
					if chance(2) and (vars.fs_cdr <= 0) and try_to_spell_an_enemy_general(tribe, M_SPELL_FIRESTORM, 5, 1, diff, 30+diff*10) then
						vars.fs_cdr = 12*rndb(32-diff, 60-diff*2)
						goto end_of_cast
					elseif chance(12 + diff*12) and (vars.torns_cdr <= 0) and try_to_spell_an_enemy_general(tribe, M_SPELL_WHIRLWIND, 6, 1, diff, 60+diff*15) then
						vars.torns_cdr = 12*rndb(24-diff*2, 44-diff*3)
						goto end_of_cast
					elseif chance(24+diff*8) and (vars.lights_cdr <= 0) and try_to_spell_an_enemy_general(tribe, M_SPELL_LIGHTNING_BOLT, 7+diff, 1, diff, 80+diff*10) then
						vars.lights_cdr = 12*rndb(8-diff, 16-diff*2)
						goto end_of_cast
					elseif chance(32+diff*16) and (vars.blasts_cdr <= 0) and try_to_spell_an_enemy_general(tribe, M_SPELL_BLAST, 5, 1, diff, 60+diff*10) then
						vars.blasts_cdr = 12*rndb(4-diff, 12-diff)
						goto end_of_cast
					end
					
					::end_of_cast::
					
					if casted then
						vars.blasts_cdr = math.max(12, vars.blasts_cdr)
						vars.lights_cdr = math.max(12, vars.lights_cdr)
						vars.torns_cdr = math.max(12, vars.torns_cdr)
						vars.fs_cdr = math.max(12, vars.fs_cdr)
						vars.selfblast_cdr = math.max(12, vars.selfblast_cdr)
					end
				end
			end
		end
	else
		if shaman.State ~= S_PERSON_UNDER_COMMAND then
			local boat = get_me_a_random_boat_in_location(shaman.Pos.D3, nil, nil, 3)
			
			if boat then
				command_person_enter_vehicle(shaman, boat)
			end
		end
	end
end

function TC_process_teslas()
	local cdr = math.max(0, mg_vars.timer - 1)
	mg_vars.timer = cdr
	
	if cdr <= 0 then
		for i = 0, 7 do mg_player_vars[i].c2d = nil end
		mg_vars.prize = nil
		for _, ef in ipairs(mg_vars.prize_objs) do delete_thing_type_safe(ef) end
		for _, ef in ipairs(mg_vars.teslas_objs) do delete_thing_type_safe(ef) end
		mg_vars.prize_objs = {}
		mg_vars.teslas_objs = {}
		mg_vars.teslas = {}
		mg_vars.timer = 12*rndb(30, 60)
		
		local potentials = {}
		for i = 17, 33 do table.insert(potentials, i) end
		
		while #mg_vars.teslas < 5 do
			local idx = rndb(1, #potentials)
			local marker = potentials[idx]
			local c3d = marker_to_coord3d(marker)

			SearchMapCells(SQUARE, 0, 0, 0, world_coord3d_to_map_idx(c3d), function(me)
				me.MapWhoList:processList(function(t)
					if (t.Type == T_SCENERY and t.Model == M_SCENERY_RS_PILLAR) then
						table.insert(mg_vars.teslas, t)
					end
					return true
				end)
				return true
			end)
			
			local le = createThing(T_EFFECT, M_EFFECT_LIGHTNING_ELEM, SAFE_NEUTRAL, c3d, false, false)
			le.Pos.D3.Ypos = 256
			le.u.Effect.Duration = -1
			centre_coord3d_on_block(le.Pos.D3)
			set_thing_draw_info(le, TDI_SPRITE_F4_D1_ALPHA, le.DrawInfo.DrawNum)
			le.DrawInfo.Alpha = -16
			table.insert(mg_vars.teslas_objs, le)
			
			local le2 = createThing(T_EFFECT, M_EFFECT_LIGHTNING_STRAND, SAFE_NEUTRAL, c3d, false, false)
			le2.Pos.D3.Ypos = 256
			le2.u.Effect.Duration = -1
			centre_coord3d_on_block(le2.Pos.D3)
			table.insert(mg_vars.teslas_objs, le2)
			
			table.remove(potentials, idx)
		end
		
		local prize_mk = potentials[rndb(1, #potentials)]
		local c3d = marker_to_coord3d(prize_mk)
		
		SearchMapCells(SQUARE, 0, 0, 0, world_coord3d_to_map_idx(c3d), function(me)
			me.MapWhoList:processList(function(t)
				if (t.Type == T_SCENERY and t.Model == M_SCENERY_RS_PILLAR) then
					mg_vars.prize = t
				end
				return true
			end)
			return true
		end)
		
		for i = 1, 64 do
			local alt = 256 + i*32
			local t = createThing(T_EFFECT, M_EFFECT_LIGHTNING_ELEM, SAFE_NEUTRAL, c3d, false, false)
			t.Pos.D3.Ypos = alt
			t.u.Effect.Duration = -1
			centre_coord3d_on_block(t.Pos.D3)
			set_thing_draw_info(t, TDI_SPRITE_F4_D1_ALPHA, t.DrawInfo.DrawNum)
			t.DrawInfo.Alpha = -16
			table.insert(mg_vars.prize_objs, t)
		end
	end
end

function TC_ashby_effects()
	local amt = #mg_vars.prize_objs
	local ashby_clr = rndb(2494, 2501)
	
	for k, ef in ipairs(mg_vars.prize_objs) do
		afa(k, set_obj_drawinfo, ef, TDI_SPRITE_F1_D1, ashby_clr, -16)
		afa(k+1, set_obj_drawinfo, ef, TDI_SPRITE_F4_D1_ALPHA, 322, -16)
	end
end

function TC_process_shamans(everySecond1, everySecond2, everySecond4)
	local everyTurns4 = everyTurns_mg(4)
	local mana = 4096 + 2048
	local prize = mg_vars.prize
	local teslas = mg_vars.teslas
	local max_pts = 8
	local max_dist = 512*16
	local coils_dist = 512*6
	
	for _, participant in ipairs(_participants) do
		local tribe = participant.tribe
		local is_ai = participant.ai
		local alive = process_death_shamans(tribe, participant)
		local shaman = getShaman(tribe)
		local vars = mg_player_vars[tribe]
		local vehicled = is_person_in_boat(shaman) > 0
		
		vars.turbo = math.max(0, vars.turbo - 1)
		
		if alive then
			local shaman_c2d = shaman.Pos.D2
			
			if everySecond2 then
				if not vehicled then
					local shamanc3d = shaman.Pos.D3
					local boats = count_boats(shamanc3d, nil, nil, 2, true, true)
					
					if (boats == 0) then
						local boat = create_thing_cache(T_VEHICLE, M_VEHICLE_BOAT_1, tribe, shamanc3d)
					end
				else
					ProcessGlobalSpecialList(tribe, BOATLIST, function(boat)
						if boat.u.Vehicle.NumOccupants == 0 then
							delete_thing_type_safe(boat)
						end
					return true end)
				end
			end
			
			if vars.turbo > 0 then
				ProcessGlobalSpecialList(tribe, BOATLIST, function(boat)
					if boat.u.Vehicle.NumOccupants > 0 then
						boat.Move.SelfPowerSpeed = 512
						createThing(T_EFFECT, M_EFFECT_FIREBALL, SAFE_NEUTRAL, boat.Pos.D3, false, false)
					end
				return true end)
			end
			
			if everyTurns4 and prize then
				if vehicled then
					local dist = get_world_dist_xz(shaman_c2d, prize.Pos.D2)
					local pts = 0
				
					if dist <= 256 then
						pts = max_pts
					elseif dist <= max_dist then
						local t = (dist - 256) / (max_dist - 256)
						pts = floor(max_pts * (1 - t))
					end
					
					give_points_to_team(pts, tribe, false)
				end
			end
			
			for _, coil in ipairs(teslas) do
				local dist = get_world_dist_xz(shaman_c2d, coil.Pos.D2)
				
				if dist <= coils_dist then
					local segments = 4 + floor(dist / 512)
					TC_spawn_chaotic_arc(coil, shaman, segments)
					
					local pers = shaman.u.Pers
					if pers then
						local dmg = math.max(0, floor((max_dist - dist) / 200))
						pers.Life = pers.Life - dmg
					end
				end
			end
		end
		
		if is_ai then
			TC_process_AI(tribe, alive, everySecond1, everySecond2, everySecond4, participant.diff, vars, shaman, vehicled, prize)
		else
			if everyTurns4 then
				GIVE_MANA_TO_PLAYER(tribe, mana)
			end
		end
	end
end

function TC_spawn_chaotic_arc(A, B, segments)
    local a3 = A.Pos.D3
    local b3 = B.Pos.D3
	local arc_len = 512

    for i = 1, segments do
        local t = i / segments

        -- linear interpolation
        local x = floor(a3.Xpos + (b3.Xpos - a3.Xpos) * t)
        local y = floor(a3.Ypos + (b3.Ypos - a3.Ypos) * t)
        local z = floor(a3.Zpos + (b3.Zpos - a3.Zpos) * t)

        -- -- jitter
        -- x = x + rndb(-arc_len, arc_len)
        y = y + rndb(-arc_len, arc_len)
        -- z = z + rndb(-arc_len, arc_len)

		local c3d = Coord3D.new()
		c3d.Xpos = x
		c3d.Ypos = y
		c3d.Zpos = z
		local g = createThing(T_EFFECT, M_EFFECT_LIGHTNING_STRAND, SAFE_NEUTRAL, c3d, false, false)
		g.Pos.D3.Ypos = y
		
		if chance(6) then
			local delay = floor((i - 1) / segments * 2) + 1
			afa(delay, createThing, T_EFFECT, M_EFFECT_SMOKE, SAFE_NEUTRAL, copy_c3d(c3d), false, false)
		end
    end
end

function tesla_on_turn(everySecond1, everySecond2, everySecond4)
	if mg_turn == 1 then
		ggameplay.max_powerups_at_once = 2
		for _, player in ipairs(_participants) do
			local tribe = player.tribe
			
			if player.ai then
				TC_init_single_AI(tribe)
			end
			
			enable_spell(tribe, M_SPELL_BLAST)
			enable_spell(tribe, M_SPELL_LIGHTNING_BOLT)
			enable_spell(tribe, M_SPELL_WHIRLWIND)
			enable_spell(tribe, M_SPELL_FIRESTORM)
			local vars = mg_player_vars[tribe]
			vars.turbo = 0
			
			local limits_spell = getPlayer(tribe).LimitsSpell
			limits_spell.MaxCharges[M_SPELL_LIGHTNING_BOLT] = 2
			limits_spell.MaxCharges[M_SPELL_WHIRLWIND] = 2
			limits_spell.MaxCharges[M_SPELL_FIRESTORM] = 1
			limits_spell.Cost[M_SPELL_LIGHTNING_BOLT] = floor(limits_spell.Cost[M_SPELL_LIGHTNING_BOLT] * 2)
			limits_spell.Cost[M_SPELL_WHIRLWIND] = floor(limits_spell.Cost[M_SPELL_WHIRLWIND] * 3)
			limits_spell.Cost[M_SPELL_FIRESTORM] = floor(limits_spell.Cost[M_SPELL_FIRESTORM] * 1)
		end
		for mk = 17, 33 do
			local rod = create_thing_cache(T_SCENERY, M_SCENERY_RS_PILLAR, SAFE_NEUTRAL, marker_to_coord3d(mk))
			if rod then
				local angle = rndb(0, 7) * 256
				rod.AngleXZ = angle
			end
		end
		mg_vars.prize = nil
		mg_vars.prize_objs = {}
		mg_vars.teslas = {}
		mg_vars.teslas_objs = {}
		mg_vars.timer = 12*3
	end
	
	TC_process_shamans(everySecond1, everySecond2, everySecond4)
	TC_process_teslas()
	
	if everySeconds_mg(12) then
		TC_ashby_effects()
	end
	
	if everySecond1 then
		order_scores()
	end
	
	if everySecond4 then
		--clean middle shamans AI might get stuck there
		local idx = world_coord3d_to_map_idx(marker_to_coord3d(8))
		SearchMapCells(SQUARE, 0, 0, 3, idx, function(me)
			me.MapWhoList:processList(function(t)
				if t.Type == T_PERSON then
					if is_person_in_boat(t) == 0 then
						delete_thing_type_safe(t)
					end
				end
				return true
			end)
			return true
		end)
	end
end

function TC_on_end()
	for _, ef in ipairs(mg_vars.prize_objs) do delete_thing_type_safe(ef) end
	for _, ef in ipairs(mg_vars.teslas_objs) do delete_thing_type_safe(ef) end
end

----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
--MAP_WOOD_BEARERS----------------------------------MAP_WOOD_BEARERS--------------------------------------------------------MAP_WOOD_BEARERS---------------------------------------------------------MAP_WOOD_BEARERS---
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

function WE_init_single_AI(tribe)
	local vars = mg_player_vars[tribe]
	
	vars.c2d = nil
	vars.blast_cdr = 12 * rndb(2, 6)
	vars.lights_cdr = 12 * rndb(6, 14)
end

function WE_get_random_wood_try_closest(shaman_c2)
	local c2d
	
	SearchMapCells(CIRCULAR, 0, 0, 3, world_coord2d_to_map_idx(shaman_c2), function(me)
		me.MapWhoList:processList(function(t)
			if t.Type == T_SCENERY then
				local model = t.Model
				
				if (model <= M_SCENERY_TREE_6) or model == M_SCENERY_WOOD_PILE then
					c2d = t.Pos.D2
					return false
				end
				return true
			end
			return true
		end)
		return true
	end)
	
	if not c2d then
		ProcessGlobalTypeList(T_SCENERY, function(t)
			local model = t.Model
			if (model <= M_SCENERY_TREE_6) or model == M_SCENERY_WOOD_PILE then
				c2d = t.Pos.D2
				return false
			end
		return true end)
	end
	
	return c2d
end

function WE_c2d_middle()
	local x = rndb(154, 170)
	local z = rndb(74,90)
	local c2d = coord_to_c2d(x,z)
	return c2d
end

function get_closest_c3d(coord3d, coords_tbl)
	local closest
	local closest_dist = math.huge
	
	for _, c3d in ipairs(coords_tbl) do
		local dist = get_world_dist_xyz(coord3d, c3d)
		if dist < closest_dist then
			closest_dist = dist
			closest = c3d
		end
	end
	
	return closest
end

function get_closest_c2d(coord2d, coords_tbl)
	local closest
	local closest_dist = math.huge
	
	for _, c2d in ipairs(coords_tbl) do
		local dist = get_world_dist_xz(coord2d, c2d)
		if dist < closest_dist then
			closest_dist = dist
			closest = c2d
		end
	end
	
	return closest
end

function WE_process_AI(tribe, alive, everySecond1, everySecond2, everySecond4, diff, vars, shaman)
	local blast_cdr = math.max(0, vars.blast_cdr - 1)
	local lights_cdr = math.max(0, vars.lights_cdr - 1)
	vars.blast_cdr = blast_cdr
	vars.lights_cdr = lights_cdr

	if alive then
		local c2d = vars.c2d
		local c2d_orig = c2d and copy_c2d(c2d) or nil
		local player_piles = #vars.wood
		local player_c2d = shaman.Pos.D2
		
		if not c2d then
			c2d =  WE_get_random_wood_try_closest(player_c2d)

			if not c2d then
				c2d = WE_c2d_middle()
			else
				if player_piles > 0 then
					if player_piles >= rndb(1, 4) then
						if chance(20 + diff*10) then
							c2d = WE_c2d_middle()
						else
							c2d = get_closest_c2d(player_c2d, mg_vars.bases)
						end
					end
				else
					c2d = WE_c2d_middle()
				end
			end
		else
			local dist = get_world_dist_xz(player_c2d, c2d)
			
			if dist <= 256+64 then
				if player_piles > 0 then
					if player_piles >= rndb(1, 4+diff) then
						if chance(20 + diff*10) then
							if chance(50-diff*10) then
								c2d = WE_c2d_middle()
							else
								c2d = WE_get_random_wood_try_closest(player_c2d)
							end
						else
							c2d = get_closest_c2d(player_c2d, mg_vars.bases)
						end
					end
				else
					if chance(70 + diff*10) then
						c2d = WE_get_random_wood_try_closest(player_c2d)
					else
						c2d = WE_c2d_middle()
					end
				end
			else
				if shaman_idle(tribe) then
					command_person_go_to_coord2d(shaman, c2d)
				end
			end
		end
		
		if c2d then
			if is_c2d_water(c2d) then
				vars.c2d = nil
				return
			elseif c2d_orig ~= c2d or shaman_idle(tribe) or is_c2d_water(c2d) then
				command_person_go_to_coord2d(shaman, c2d)
			else
				-- casting spells
				local caster = getShaman(tribe)
				
				if shaman_can_cast(shaman) then
					if lights_cdr <= 0 and chance(2+diff*3) then
						local random_enemy = get_random_enemy_shaman_near_thing(caster, 24+diff)
						if random_enemy and not isInvisible(random_enemy) then
							local c3d = aim_spell_at_target(tribe, random_enemy, 26)
							if c3d then
								local spell = createThing(T_SPELL, M_SPELL_LIGHTNING_BOLT, tribe, c3d, false, false)
								if chance(10 + diff*4) and get_world_dist_xyz(random_enemy.Pos.D3, c3d) <= 512*28 then
									spell.u.Spell.TargetThingIdx:set(random_enemy.ThingNum)
								end
								vars.lights_cdr = 12*rndb(9-diff, 18-diff*3)
								goto leave_casting_spells
							end
						end
					end
					
					::try_blast::
					
					if blast_cdr <= 0 and chance(1+diff*2) then
						local random_enemy = get_random_enemy_shaman_near_thing(caster, 5)
						if random_enemy and not isInvisible(random_enemy) then
							local c3d = aim_spell_at_target(tribe, random_enemy, 7)
							if c3d then
								local spell = createThing(T_SPELL, M_SPELL_BLAST, tribe, c3d, false, false)
								if chance(40 + diff*5) then
									spell.u.Spell.TargetThingIdx:set(random_enemy.ThingNum)
								end
								vars.blast_cdr = 12*rndb(6-diff, 12-diff*2)
							end
						end
					end
					
				end
			end
			
			::leave_casting_spells::
			
			vars.c2d = c2d
		end
	else
		vars.c2d = nil
	end
end

function WE_process_shamans(everySecond1, everySecond2, everySecond4)
	local everyTurns4 = everyTurns_mg(4)
	local mana = 2048 - 64*#_participants
	local order_score = false
	
	for _, participant in ipairs(_participants) do
		local tribe = participant.tribe
		local is_ai = participant.ai
		local alive = process_death_shamans(tribe, participant)
		local shaman = getShaman(tribe)
		local vars = mg_player_vars[tribe]
		local vehicled = is_person_in_boat(shaman) > 0
		
		if alive then
			if shaman.State == S_PERSON_ELECTROCUTED then
				shaman.u.Pers.Life = vars.cached_hp
				shaman.Flags = DisableFlag(shaman.Flags, TF_STATE_LOCKED)
				shaman.Flags2 = EnableFlag(shaman.Flags2, TF2_THING_INITED)
				shaman.State = S_PERSON_GOTO_POINT
			else
				if shaman.u.Pers then
					local limit_wood = isBloodlusted(shaman) and 12 or 8
					vars.cached_hp = shaman.u.Pers.Life
					local shaman_c3d = shaman.Pos.D3

					SearchMapCells(CIRCULAR, 0, 0, 0, world_coord3d_to_map_idx(shaman_c3d), function(me)
						me.MapWhoList:processList(function(t)
							if t.Type == T_SCENERY then
								local curr_wood = #vars.wood
								
								if curr_wood < limit_wood then
									local model = t.Model
									
									if model <= 6 then
										local amt_to_pick = math.min(4, limit_wood - curr_wood)
										
										if amt_to_pick > 0 then
											--t.u.Scenery.ResourceRemaining = t.u.Scenery.ResourceRemaining - 100 * amt_to_pick
											delete_thing_type_safe(t)
											for i = 1, amt_to_pick do
												local w = createThing(T_EFFECT, 10, SAFE_NEUTRAL, shaman_c3d, false, false)
												w.u.Effect.Duration = -1
												set_thing_draw_info(w, TDI_SPRITE_F1_D1, 23)
												w.DrawInfo.Alpha = -16
												table.insert(vars.wood, w)
											end
										end
									elseif model == M_SCENERY_WOOD_PILE then
										delete_thing_type_safe(t)
										mg_vars.active_wood_amt = mg_vars.active_wood_amt - 1
										local w = createThing(T_EFFECT, 10, SAFE_NEUTRAL, shaman_c3d, false, false)
										w.u.Effect.Duration = -1
										set_thing_draw_info(w, TDI_SPRITE_F1_D1, 23)
										w.DrawInfo.Alpha = -16
										table.insert(vars.wood, w)
									end
								end
							end
							return true
						end)
						return true
					end)
					
					local shaman_y = shaman_c3d.Ypos
					local piles_start_y = shaman_y + 128
					local c3d_copy = copy_c3d(shaman_c3d)
					local shaman_c2d = shaman.Pos.D2
					local invis = isInvisible(shaman)
					
					for k, pile in ipairs(vars.wood) do
						if pile then
							if invis then
								if pile.DrawInfo then
									pile.DrawInfo.Flags = EnableFlag(pile.DrawInfo.Flags, DF_THING_NO_DRAW)
								end
							else
								if pile.DrawInfo then
									pile.DrawInfo.Flags = DisableFlag(pile.DrawInfo.Flags, DF_THING_NO_DRAW)
								end
								pile.Pos.D3 = c3d_copy
								pile.Pos.D3.Ypos = piles_start_y + (k * 32)
							end
						end
					end
					
					for _, base_c2d in ipairs(mg_vars.bases) do
						local dist = get_world_dist_xz(shaman_c2d, base_c2d)
						
						if dist <= 1024 then
							local wood_amt = #vars.wood
							
							if wood_amt > 0 then
								order_score = true
								WE_delete_tribe_woods(tribe, vars)
								give_points_to_team(wood_amt, tribe, false)
								mg_vars.active_wood_amt = mg_vars.active_wood_amt - wood_amt
								
								local ef_clr = participant.g_color
								for i = 1, wood_amt do
									local o = createThing(T_EFFECT, M_EFFECT_ORBITER, SAFE_NEUTRAL, shaman_c3d, false, false)
									o.DrawInfo.Alpha = ef_clr
									local w = createThing(T_EFFECT, M_EFFECT_ORBITER, SAFE_NEUTRAL, shaman_c3d, false, false)
									set_thing_draw_info(w, TDI_SPRITE_F1_D1, 23)
								end
							end
						end
					end
				end
			end
		end
		
		if is_ai then
			WE_process_AI(tribe, alive, everySecond1, everySecond2, everySecond4, participant.diff, vars, shaman)
		else
			if everyTurns4 then
				GIVE_MANA_TO_PLAYER(tribe, mana)
			end
		end
	end
	
	if order_score then
		order_scores()
	end
end

function WE_delete_tribe_woods(tribe, vars)
	local pvars = vars or mg_player_vars[tribe]
	
	for _, v in ipairs(pvars.wood) do
		if v then
			if v.u.Effect then
				v.u.Effect.Duration = 1
				delete_thing_type(v)
			end
		end
	end
	pvars.wood = {}
end

function WE_powerup_c3d()
	local x = rndb(154, 170)
	local z = rndb(74,90)
	local _c3d = coord_to_c3d(x,z)
	if c3d_scenery_free(_c3d) and c3d_person_free(_c3d) and is_powerup_location_free(_c3d) then
		return _c3d
	end
	return nil
end

function WE_on_end()
	for _, player in ipairs(_participants) do
		local tribe = player.tribe
		WE_delete_tribe_woods(tribe)
	end
end

function WE_process_wood_regen(everySecond1)
	if not everySecond1 then return end
	if not chance(64 + #_participants*2) then return end
	
	local curr = mg_vars.active_wood_amt
	local limit_wood = 45
	
	--doesnt work, tree still fades at end
	-- ProcessGlobalTypeList(T_SCENERY, function(t)
		-- if (t.Model <= M_SCENERY_TREE_6) then
			-- if t.State == S_SCENERY_ON_FIRE then
				-- t.State = S_SCENERY_STAND
			-- end
		-- end
	-- return true end)
	
	if curr < limit_wood then
		local x = rndb(154, 170)
		local z = rndb(74,90)
		local _c3d = coord_to_c3d(x,z)
		if --[[c3d_scenery_free(_c3d) and]] c3d_person_free(_c3d) then
			local model = chance(6) and rndb(1, 6) or M_SCENERY_WOOD_PILE
			local pile = createThing(T_SCENERY, model, SAFE_NEUTRAL, _c3d, false, false)
		end
	end
end

function wood_bearers_on_turn(everySecond1, everySecond2, everySecond4)
	if mg_turn == 1 then
		ggameplay.max_powerups_at_once = 1
		for _, player in ipairs(_participants) do
			local tribe = player.tribe
			
			if player.ai then
				WE_init_single_AI(tribe)
			end
			
			enable_spell(tribe, M_SPELL_BLAST)
			enable_spell(tribe, M_SPELL_LIGHTNING_BOLT)
			
			local limits_spell = getPlayer(tribe).LimitsSpell
			limits_spell.MaxCharges[M_SPELL_LIGHTNING_BOLT] = 2
			limits_spell.WorldCoordRange[M_SPELL_LIGHTNING_BOLT] = 512*26
			limits_spell.Cost[M_SPELL_LIGHTNING_BOLT] = floor(limits_spell.Cost[M_SPELL_LIGHTNING_BOLT] / 6)
			
			local vars = mg_player_vars[tribe]
			vars.cached_hp = 0
			vars.wood = {}
		end
		tmi[TMI_PERSON_MEDICINE_MAN].BaseSpeed = 96
		mg_vars.active_wood_amt = 0
		mg_vars.bases = {
				marker_to_coord2d(0),
				marker_to_coord2d(1),
				marker_to_coord2d(2),
				marker_to_coord2d(3),
				marker_to_coord2d(4),
				marker_to_coord2d(5),
				marker_to_coord2d(6),
				marker_to_coord2d(7),
			}
	end
	
	WE_process_shamans(everySecond1, everySecond2, everySecond4)
	WE_process_wood_regen(everySecond1)
end

function WE_on_shaman_dead(victim, killer, killer_was_ally)
	for _, wood in ipairs(mg_player_vars[victim].wood) do
		delete_thing_type_safe(wood)
	end
	mg_player_vars[victim].wood = {}
end

function wood_bearers_on_create_thing(t, owner, type, model)
	if type == T_SPELL then
		local dodge_range = 512*2 + 256
		
		for _, aiplayer in ipairs(_ai_participants) do
			local player = aiplayer.ptr
			local possible_victim = player.tribe
			
			if nilS(possible_victim) then
				if is_player_enemy(owner, possible_victim) then
					local victim_shaman = getShaman(possible_victim)
					
					if get_world_dist_xz(t.Pos.D2, victim_shaman.Pos.D2) < dodge_range then
						local diff = player.diff
						local _chance = ((model == M_SPELL_LIGHTNING_BOLT) and (50 + diff*15)) or (30 + diff*15)
						
						try_to_dodge_on_land(possible_victim, 2, _chance)
						
						if chance(20 + diff*10) then
							if nilS(owner) then
								local dist = get_world_dist_xyz(victim_shaman.Pos.D3, getShaman(owner).Pos.D3)
								local cells_dist = dist // 512
								afa(math.min(14, rndb(5, 6)+cells_dist), tribe_try_blast_trick, possible_victim, true, 100)
								mg_player_vars[possible_victim].blast_cdr = rndb(12* (3-diff), 12* (6-diff))
							end
						end
					end
				end
			end
		end
	end
end

----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
--MAP_CORROSION----------------------------------MAP_CORROSION--------------------------------------------------------MAP_CORROSION---------------------------------------------------------MAP_CORROSION---
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

function CO_init_single_AI(tribe)
	local ai = mg_player_vars[tribe]
	ai.c2d = nil
	ai.c2dalt = nil
	ai.blast_cdr = 12*rndb(2, 4)
	ai.lights_cdr = 12*rndb(6, 10)
	ai.backstab_cdr = 12*rndb(15, 30)
end

function CO_process_AI(tribe, alive, everySecond1, everySecond2, everySecond4, diff, vars, shaman, everyTurnsX)
	local blast_cdr = math.max(0, vars.blast_cdr - 1)
	local lights_cdr = math.max(0, vars.lights_cdr - 1)
	local backstab_cdr = math.max(0, vars.backstab_cdr - 1)
	vars.blast_cdr = blast_cdr
	vars.lights_cdr = lights_cdr
	vars.backstab_cdr = backstab_cdr

	if alive then
		if everySecond4 then
			if rndb(1, 1000) <= 4 then
				if (not is_tribe_using_emoji(tribe)) then
					if chance(1) then
						create_emote(tribe)
					end
				end
			end
		end
	
		if not shaman_can_cast(shaman) then
			return
		end
		
		if backstab_cdr <= 0 and chance(1+diff) then
			local random_enemy = get_random_enemy_shaman_near_thing(shaman, 10)
			if random_enemy then
				local aim_c3d = aim_spell_at_target(tribe, random_enemy, 12)
				
				if aim_c3d then
					if not is_c3d_water(aim_c3d) then
						if get_world_dist_xyz(shaman.Pos.D3, aim_c3d) > 512*6 then
							local t = createThing(T_SPELL, M_SPELL_INSECT_PLAGUE, tribe, aim_c3d, false, false)
							vars.backstab_cdr = 12* rndb(20-diff*2, 35-diff*3)
							return
						end
					end
				--else
					-- if try_to_spell_an_enemy_general(tribe, M_SPELL_INSECT_PLAGUE, 10, 1+diff, diff, 50+diff*20) then
						-- vars.backstab_cdr = 12* rndb(20-diff*2, 35-diff*3)
						-- return
					-- end
				end
			end
		end
		
		if blast_cdr <= 0 and chance(2+diff*2) then
			local random_enemy = get_random_enemy_shaman_near_thing(shaman, 14)
			if random_enemy then
				local aim_c3d = aim_spell_at_target(tribe, random_enemy, 12)
				
				if aim_c3d and chance(60+diff*10) then
					local t = createThing(T_SPELL, M_SPELL_BLAST, tribe, aim_c3d, false, false)
					vars.blast_cdr = 12* rndb(5-diff, 8-diff)
					return
				else
					if try_to_spell_an_enemy_general(tribe, M_SPELL_BLAST, 12, 1+diff, diff, 50+diff*20) then
						vars.blast_cdr = 12* rndb(5-diff, 8-diff)
						return
					end
				end
			end
		end
		
		if lights_cdr <= 0 and chance(1+diff*2) then
			local random_enemy = get_random_enemy_shaman_near_thing(shaman, 14)
			if random_enemy then
				local aim_c3d = aim_spell_at_target(tribe, random_enemy, 12)
				
				if aim_c3d and chance(60+diff*10) then
					local t = createThing(T_SPELL, M_SPELL_LIGHTNING_BOLT, tribe, aim_c3d, false, false)
					vars.lights_cdr = 12* rndb(8-diff, 14-diff*2)
					return
				else
					if try_to_spell_an_enemy_general(tribe, M_SPELL_LIGHTNING_BOLT, 12, 2+diff, diff, 50+diff*20) then
						vars.lights_cdr = 12* rndb(8-diff, 14-diff*2)
						return
					end
				end
			end
		end
		
		-- moving zone
	
		if not everyTurnsX then return end
		
		local shaman_c3d = shaman.Pos.D3
		local shaman_c2d = shaman.Pos.D2
		local shaman_pos_idx = world_coord3d_to_map_idx(shaman_c3d)
		local shaman_y = shaman_c3d.Ypos
		local c2dalt = vars.c2dalt
		local c2d = vars.c2d
		
		if not c2d then
			goto set_c2d
		else
			local dist = get_world_dist_xz(shaman_c2d, c2d)
			if dist <= 512*3 or chance(1) then
				if chance(24) then
					goto set_c2d
				else
					c2d = marker_to_coord2d(rndb(0, 9))
					goto set_c2d_alt
				end
			else
				if chance(16) then
					local targ_tribe = get_closest_alive_enemy_shaman(tribe)
					if targ_tribe then
						local targ_sh_c2d = copy_c2d(getShaman(targ_tribe).Pos.D2)
						if get_world_dist_xz(shaman_c2d, targ_sh_c2d) < dist then
							c2d = targ_sh_c2d
							goto set_c2d_alt
						elseif chance(8) then
							goto set_c2d
						end
					else
						goto set_c2d_alt
					end
				else
					c2d = marker_to_coord2d(rndb(0, 9))
					goto set_c2d_alt
				end
			end
		end
		
		::set_c2d::
		do
			local targ_tribe = get_closest_alive_enemy_shaman(tribe)
			if targ_tribe and chance(50) then
				local targ_shaman = getShaman(targ_tribe)
				--LOG(targ_shaman.Owner)
				--LOG(tribe .. " " .. targ_tribe .. " " .. ATTACK_PERSON)
				--local nav = NAV_CHECK(tribe, targ_tribe, ATTACK_PERSON, 0, 0)
				--if nav then
					c2d = copy_c2d(targ_shaman.Pos.D2)
				--else
					--c2d = marker_to_coord2d(rndb(0, 9))
				--end
			else
				c2d = marker_to_coord2d(rndb(0, 9))
			end
		end
		
		::set_c2d_alt::
		
		-- if not c2dalt then
			-- goto set_c2d_now
		-- else
			-- local dist = get_world_dist_xz(shaman_c2d, c2dalt)
			-- if dist <= 512 then
				-- goto set_c2d_now
			-- end
		-- end
		
		-- ::set_c2d_now::
		
		local ALT_WEIGHT  = rndb(20,25)
		local DIST_WEIGHT = rndb(1,3)

		local best_cell = nil
		local best_score = -1e20

		SearchMapCells(CIRCULAR, 0, 3, 3, shaman_pos_idx, function(me)

			local alt = me.Alt
			if alt <= 0 then
				return true -- skip water
			end

			-- convert this map element (me) into world C2D
			local me_c2d = Coord2D.new()
			map_ptr_to_world_coord2d(me, me_c2d)

			-- distance to target (c2d)
			local dist = get_world_dist_xz(me_c2d, c2d)

			-- compute score
			local score = alt * ALT_WEIGHT - dist * DIST_WEIGHT

			if score > best_score then
				best_score = score
				best_cell = me_c2d
			end

			return true
		end)
		
		if best_cell then
			c2dalt = best_cell
		else
			c2dalt = marker_to_coord2d(rndb(0, 9))
		end
		
		if everySecond1 then
			if c2d and is_c2d_water(c2d) then
				vars.c2d = nil
				remove_all_persons_commands(shaman)		
				return
			end
		end
		
		command_person_go_to_coord2d(shaman, c2dalt)
		vars.c2d = c2d
		vars.c2dalt = c2dalt
	end
end

function CO_process_shamans(everySecond1, everySecond2, everySecond4)
	local everyTurns4 = everyTurns_mg(4)
	local mana = 4096 - 64*#_participants
	local everyTurnsX = everyTurns_mg(2)
	
	for _, participant in ipairs(_participants) do
		local tribe = participant.tribe
		local is_ai = participant.ai
		local alive = process_death_shamans(tribe, participant)
		local shaman = getShaman(tribe)
		local vars = mg_player_vars[tribe]
		
		if alive then
			if shaman.State == S_PERSON_ELECTROCUTED then
				shaman.u.Pers.Life = shaman.u.Pers and shaman.u.Pers.MaxLife or 2000
				shaman.Flags = DisableFlag(shaman.Flags, TF_STATE_LOCKED)
				shaman.Flags2 = EnableFlag(shaman.Flags2, TF2_THING_INITED)
				shaman.State = S_PERSON_GOTO_POINT
			else
				if shaman.u.Pers then
					shaman.u.Pers.Life = shaman.u.Pers.MaxLife
				end
			end
		end
		
		if is_ai then
			CO_process_AI(tribe, alive, everySecond1, everySecond2, everySecond4, participant.diff, vars, shaman, everyTurnsX)
		else
			if everyTurns4 then
				GIVE_MANA_TO_PLAYER(tribe, mana)
			end
		end
	end
end

function CO_erode_land(c3d, model)
	--centre_coord3d_on_block(c3d)
	local map_idx = world_coord3d_to_map_idx(c3d)
	local radius = model == M_EFFECT_EXPLOSION_1 and 4 or 5
	local speeds = {
		[M_EFFECT_EXPLOSION_1] = { 140, 80, 40, 20 }, --blast
		[M_EFFECT_SIMPLE_BLAST] = { 240, 200, 140, 80, 40 }, --light
	}
	
	for i = 0, radius-1 do
		local speed = speeds[model][i+1]
		
		SearchMapCells(SQUARE, 0, math.max(0, i-1), i, map_idx, function(me)
			me.Alt = math.max(0, me.Alt - speed)
			return true
		end)
	end
	
	set_square_map_params(map_idx, radius + 2, TRUE)
end

function CO_process_land()
    local marker = mg_vars.marker_idx
    local tbl = mg_vars.land_cache[marker+1]
    local speed = mg_vars.land_speed
    local edited
	local min_land_h = 12

    for _, data in ipairs(tbl.land) do
		local old_water_cdr = data.water_cdr
		local water_cdr = math.max(0, old_water_cdr - 1)
		data.water_cdr = water_cdr
		
		if water_cdr == 0 then
			local me = data.mapelem

			local target = data.alt
			local current = me.Alt

			if current < target then
				if current <= min_land_h and old_water_cdr == water_cdr then
					--if is_map_elem_sea_or_coast(me) > 0 then
						data.water_cdr = floor((12*12) // 10)
						data.water_helper = 64
					--end
				else
					local water_helper = math.max(0, data.water_helper - 8)
					data.water_helper = water_helper
					me.Alt = math.min(target, math.max(min_land_h, current + math.max(water_helper, speed)))
					edited = true
				end
			end
		end
    end

    if edited then
        set_square_map_params(tbl.center_point, 6, TRUE)
    end

    for k, obj in ipairs(tbl.objects) do
		local thing = GetThing(obj.t)
		local c3d = obj.c3d
		local coordisland = is_c3d_land(c3d)
		
        if not thing then
			if coordisland then
				local type, model = obj.type, obj.model
				local new_t = create_thing_cache(type, model, SAFE_NEUTRAL, c3d)
				if new_t and (new_t.Type == T_SCENERY) then ensure_thing_on_ground(new_t) end
				tbl.objects[k] = {t = new_t.ThingNum, type = type, model = model, c3d = c3d}
			end
		else
			if coordisland then
				ensure_thing_on_ground(thing)
			else
				delete_thing_type_safe(thing)
			end
        end
    end

    mg_vars.marker_idx = (marker + 1) % 10
end

function CO_cache_land()
	local tbl = {}
	for i = 0, 9 do
		local center_point = world_coord3d_to_map_idx(marker_to_coord3d(i))
		local subtbl = { land = {}, objects = {}, center_point = center_point }
		
		SearchMapCells(SQUARE, 0, 0, 4, center_point, function(me)
			table.insert(subtbl.land, { alt = me.Alt, mapelem = me, water_cdr = 0, water_helper = 0 } )
			local c3d = copy_c3d(me2c3d(me))
			
			me.MapWhoList:processList(function(t)
				local type, model = t.Type, t.Model
				if type == T_SCENERY then
					table.insert(subtbl.objects, {t = t.ThingNum, type = type, model = model, c3d = c3d})
				end
				return true
			end)
			return true
		end)
		
		table.insert(tbl, subtbl)
	end
	
	mg_vars.land_cache = tbl
end

function CO_reinc_pos()
	local tries = 0
	local c3d
	while (tries < 8) or (not c3d) do
		local loc
		local highest_found = -math.huge
		local ridx = rndb(0, 9)
		local _c3d = marker_to_coord3d(ridx)
		local map_idx = world_coord3d_to_map_idx(_c3d)
		
		SearchMapCells(SQUARE, 0, 0, 3, map_idx, function(me)
			local alt = me.Alt

			if alt > 0 then
				if alt > highest_found then
					highest_found = alt
					loc = me2c3d(me)
				end
			end
			return true
		end)
		
		c3d = loc
		
		if c3d and (not c3d_person_free(c3d)) then
			c3d = nil
		end
		
		tries = tries + 1
	end

	return c3d or marker_to_coord3d(10)
end

function corrosion_on_turn(everySecond1, everySecond2, everySecond4)
	if mg_turn == 1 then
		for _, player in ipairs(_participants) do
			local tribe = player.tribe
			
			if player.ai then
				CO_init_single_AI(tribe)
			end
			
			enable_spell(tribe, M_SPELL_BLAST)
			enable_spell(tribe, M_SPELL_LIGHTNING_BOLT)
			enable_spell(tribe, M_SPELL_INSECT_PLAGUE)
			
			local limits_spell = getPlayer(tribe).LimitsSpell
			limits_spell.MaxCharges[M_SPELL_BLAST] = 3
			limits_spell.WorldCoordRange[M_SPELL_BLAST] = 512*12
			limits_spell.Cost[M_SPELL_BLAST] = floor(limits_spell.Cost[M_SPELL_BLAST] / 2)
			limits_spell.MaxCharges[M_SPELL_LIGHTNING_BOLT] = 2
			limits_spell.WorldCoordRange[M_SPELL_LIGHTNING_BOLT] = 512*12
			limits_spell.Cost[M_SPELL_LIGHTNING_BOLT] = floor(limits_spell.Cost[M_SPELL_LIGHTNING_BOLT] * 0.5)
			local backstab = M_SPELL_INSECT_PLAGUE
			limits_spell.MaxCharges[backstab] = 1
			limits_spell.WorldCoordRange[backstab] = 512*10
			limits_spell.Cost[backstab] = floor(limits_spell.Cost[backstab] *4)
			local stiA = sti[backstab]
			stiA.AvailableSpriteIdx = 371
			stiA.NotAvailableSpriteIdx = 389
			stiA.ClickedSpriteIdx = 407
			stiA.CursorSpriteNum = 57
		end
		tmi[TMI_PERSON_MEDICINE_MAN].BaseSpeed = 128
		mg_vars.land_speed = 6 + #_participants
		mg_vars.hyper_speed_cdr = 12*32 - #_participants
		mg_vars.marker_idx = 0
		CO_cache_land()
		mg_vars.custom_reinc_location = CO_reinc_pos
		disable_spells_effects_for_this_level({M_SPELL_INSECT_PLAGUE})
	end
	
	CO_process_shamans(everySecond1, everySecond2, everySecond4)
	CO_process_land()
	
	local hyper_speed_cdr = math.max(0, mg_vars.hyper_speed_cdr - 1)
	mg_vars.hyper_speed_cdr = hyper_speed_cdr
	
	if hyper_speed_cdr <= 0 then
		if mg_vars.land_speed == 2 then
			mg_vars.land_speed = 32
		else
			mg_vars.land_speed = 6 + #_participants
		end
		mg_vars.hyper_speed_cdr = 12*8
	end
end

function CO_on_shaman_dead(victim, killer, killer_was_ally)
	if not killer_was_ally then
		give_points_to_team(1, killer, true)
	end
	
	local ai = mg_player_vars[victim]
	ai.c2d = nil
	ai.c2dalt = nil
end

function CO_on_create_thing(t, owner, type, model)
	if type == T_EFFECT then
		local pos = t.Pos.D3
		
		if model == M_EFFECT_EXPLOSION_1 then
			--LOG("blast")
			CO_erode_land(pos, model)
			goto try_2_dodge
		elseif model == M_EFFECT_SIMPLE_BLAST then
			--LOG("light")
			CO_erode_land(pos, model)
			goto try_2_dodge
		else
			return
		end
		
		::try_2_dodge::
		
		for _, aiplayer in ipairs(_ai_participants) do
			local player = aiplayer.ptr
			local possible_victim = player.tribe
			
			if possible_victim ~= owner then
				if shaman_has_healthy_state(possible_victim) then
					if get_world_dist_xz(t.Pos.D2, getShaman(possible_victim).Pos.D2) < 512*2 + 256 then
						try_to_dodge_on_land(possible_victim, 2, 25 + player.diff*20)
					end
				end
			end
		end
	elseif type == T_SPELL then
		if model == M_SPELL_INSECT_PLAGUE then
			local pos = t.Pos.D3
			afa(10, CO_backstab, owner, copy_c3d(pos))
			--afa(9, createThing, T_EFFECT, M_EFFECT_SMOKE_CLOUD, SAFE_NEUTRAL, copy_c3d(getShaman(owner).Pos.D3), false, false)
			afa(9, create_thing_at_thing_pos_safe, T_EFFECT, M_EFFECT_SMOKE_CLOUD, SAFE_NEUTRAL, getShaman(owner))
		end
	end
end

function CO_backstab(tribe, c3d)
	if not nilS(tribe) then return end
	
	local caster = getShaman(tribe)
	move_thing_within_mapwho(caster, c3d)
	
	if not shaman_can_cast(caster) then return end
	
	local blasted = false
	
	SearchMapCells(SQUARE, 0, 0, 3, world_coord3d_to_map_idx(c3d), function(me)
		me.MapWhoList:processList(function(t)
			if not blasted and t.Type == T_PERSON then
				local owner = t.Owner
				
				if is_player_enemy(tribe, owner) and t then
					local blast = createThing(T_SPELL, M_SPELL_BLAST, tribe, t.Pos.D3, false, false)
					blast.u.Spell.TargetThingIdx:set(t.ThingNum)
					blasted = true
					
					if player_is_ai(owner) then
						local diff = get_participant_table(owner).diff
						
						if chance(24 + diff*16) then
							afa(rndb(3, 8), tribe_try_blast_trick, owner, true, 100)
							mg_player_vars[owner].blast_cdr = rndb(12*(3-diff), 12*(6-diff))
						end
					end
				end
			end
			return true
		end)
		return true
	end)
end

----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
--MAP_LUCK_OF_THE_DRAW----------------------------------MAP_LUCK_OF_THE_DRAW--------------------------------------------------MAP_LUCK_OF_THE_DRAW---------------------------------------------MAP_LUCK_OF_THE_DRAW---
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

function LD_init_single_AI(tribe)
	local ai = mg_player_vars[tribe]
	ai.c2d = nil
	ai.blast_cdr = 12*rndb(2, 4)
end

function LD_get_random_c2d_around(rad)
	--higher rad = worse
	local cell_offset = 2*rad
	local x_min = 46 - cell_offset
	local x_max = 54 + cell_offset
	local z_min = 70 - cell_offset
	local z_max = 78 + cell_offset
	return coord_to_c2d(rndb(x_min, x_max), rndb(z_min, z_max))
end

function LD_process_AI(tribe, alive, everySecond1, everySecond2, everySecond4, diff, vars, shaman, center2d)
	local blast_cdr = math.max(0, vars.blast_cdr - 1)
	vars.blast_cdr = blast_cdr

	if alive then
		local c2d = vars.c2d
		
		if not c2d then
			if chance(50 + diff*10) then
				c2d = center2d
			else
				c2d = LD_get_random_c2d_around(5-diff)
			end
			
			command_person_go_to_coord2d(shaman, c2d)
			vars.c2d = c2d
		else
			local dist = get_world_dist_xz(shaman.Pos.D2, c2d)
			
			if dist <= 256 + 128 then
				if chance(32+diff*8) then
					c2d = LD_get_random_c2d_around(4-rndb(diff, diff*2))
				else
					c2d = center2d
				end
			else
				if chance(8-diff*2) then
					c2d = LD_get_random_c2d_around(4-diff*2)
				--else
					--c2d = center2d
				end
			end
			
			command_person_go_to_coord2d(shaman, c2d)
			vars.c2d = c2d
		end
		
		if blast_cdr <= 0 then
			if try_to_spell_an_enemy_general(tribe, M_SPELL_BLAST, 4, 4+diff*2, diff, 30+diff*15) then
				vars.blast_cdr = 12*(rndb(4, 12-diff*2))
			end
		end
	end
end

function LD_init_rings(c3d)
	local coord_center = c3d
	local mult = 512 * 2
	for i=0,35 do
	  local rotation = (((i * 10)) * math.pi) / 180;
	  local c3d = Coord3D.new();
	  c3d.Xpos = coord_center.Xpos + floor((math.cos(rotation) * mult));
	  c3d.Zpos = coord_center.Zpos + floor((math.sin(rotation) * mult));

	  local m = create_thing_cache(7, 61, 8, c3d);
		if m then
		  m.Pos.D3.Ypos = 0;
		  m.DrawInfo.Alpha = 11;
		  m.u.Effect.Duration = -1;
		end
	end

	mult = 512 * 8
	for i=0,71 do
	  local rotation = (((i * 5)) * math.pi) / 180;
	  local c3d = Coord3D.new();
	  c3d.Xpos = coord_center.Xpos + floor((math.cos(rotation) * mult));
	  c3d.Zpos = coord_center.Zpos + floor((math.sin(rotation) * mult));

	  local m = create_thing_cache(7, 61, 8, c3d);
		if m then
		  m.Pos.D3.Ypos = 0;
		  m.DrawInfo.Alpha = -2;
		  m.u.Effect.Duration = -1;
		end
	end

	mult = 512 * 12
	for i=0,71 do
	  local rotation = (((i * 5)) * math.pi) / 180;
	  local c3d = Coord3D.new();
	  c3d.Xpos = coord_center.Xpos + floor((math.cos(rotation) * mult));
	  c3d.Zpos = coord_center.Zpos + floor((math.sin(rotation) * mult));

	  local m = create_thing_cache(7, 61, 8, c3d);
		if m then
		  m.Pos.D3.Ypos = 0;
		  m.DrawInfo.Alpha = -1;
		  m.u.Effect.Duration = -1;
		end
	end

	mult = 512 * 18
	for i=0,71 do
	  local rotation = (((i * 5)) * math.pi) / 180;
	  local c3d = Coord3D.new();
	  c3d.Xpos = coord_center.Xpos + floor((math.cos(rotation) * mult));
	  c3d.Zpos = coord_center.Zpos + floor((math.sin(rotation) * mult));

	  local m = create_thing_cache(7, 61, 8, c3d);
		if m then
		  m.Pos.D3.Ypos = point_altitude(c3d.Xpos, c3d.Zpos) - 128;
		  m.DrawInfo.Alpha = 1;
		  m.u.Effect.Duration = -1;
		end
	end
end

function LD_process_shamans(everySecond1, everySecond2, everySecond4)
	local center2d = mg_vars.center2d
	
	for _, participant in ipairs(_participants) do
		local tribe = participant.tribe
		local is_ai = participant.ai
		local alive = process_death_shamans(tribe, participant)
		local shaman = getShaman(tribe)
		local vars = mg_player_vars[tribe]
		
		if alive then
			if shaman.u.Pers.Life > 0 then
				local dist = get_world_dist_xyz(shaman.Pos.D3, mg_vars.coord_center)
				
				if dist < 1024 then
					give_points_to_team(12, tribe, false)
				elseif dist < 4096 then
					give_points_to_team(5, tribe, false)
				elseif dist < 6144 then
					give_points_to_team(3, tribe, false)
				elseif dist < 9216 then
					give_points_to_team(1, tribe, false)
				end
			end
		end
		
		if is_ai then
			LD_process_AI(tribe, alive, everySecond1, everySecond2, everySecond4, participant.diff, vars, shaman, center2d)
		end
	end
	
	order_scores()
end

function LD_spawn_random_lightnings(_coord, _tile_radius)
  local rotation = (G_RANDOM(360) * math.pi) / 180;
  local c3d = Coord3D.new();
  c3d.Xpos = _coord.Xpos + floor((math.cos(rotation) * G_RANDOM(512 * _tile_radius)));
  c3d.Zpos = _coord.Zpos + floor((math.sin(rotation) * G_RANDOM(512 * _tile_radius)));
  local delay = G_RANDOM(20) + 18
  local smoke = createThing(T_EFFECT, M_EFFECT_BLDG_SMOKE_2_PARTIAL, SAFE_NEUTRAL, c3d, false, false)
  smoke.u.Effect.Duration = delay
  afa(delay, createThing, T_EFFECT, M_EFFECT_LIGHTNING_BOLT, SAFE_NEUTRAL, c3d, false, false)
  afa(delay, delete_thing_type_safe, smoke)
end

function luck_draw_on_turn(everySecond1, everySecond2, everySecond4)
	if mg_turn == 1 then
		pti[M_PERSON_MEDICINE_MAN].DefaultLife = 8000
		pti[M_PERSON_MEDICINE_MAN].LifeIncrease = 255
		pti[M_PERSON_MEDICINE_MAN].ManaValue = 72
			
		for _, player in ipairs(_participants) do
			local tribe = player.tribe
			
			if player.ai then
				LD_init_single_AI(tribe)
			end
			
			enable_spell(tribe, M_SPELL_BLAST)
			
			local limits_spell = getPlayer(tribe).LimitsSpell
			limits_spell.Cost[M_SPELL_BLAST] = 500
			
			if nilS(tribe) then
				local c3d = getShaman(tribe).Pos.D3
				createThing(T_EFFECT, M_EFFECT_RISE, SAFE_NEUTRAL, c3d, false, false)
				insert_c3d_from_land_location(copy_c3d(c3d))
			end
		end
		
		tmi[TMI_PERSON_MEDICINE_MAN].BaseSpeed = 128
		local coord_center = MAP_XZ_2_WORLD_XYZ(50, 74)
		centre_coord3d_on_block(coord_center)
		mg_vars.coord_center = coord_center
		mg_vars.center2d = c3d_to_c2d(coord_center)
		LD_init_rings(coord_center)
	end
	
	LD_process_shamans(everySecond1, everySecond2, everySecond4)
	
	local coord_center = mg_vars.coord_center
	
	if everyTurns_mg(4) then
		LD_spawn_random_lightnings(coord_center, 18)
	end
	
	if everyTurns_mg(36) then
		LD_spawn_random_lightnings(coord_center, 2)
	end
	
	if everySecond2 then
		LD_spawn_random_lightnings(coord_center, 8)
	end
	
	if everySecond1 then
		LD_spawn_random_lightnings(coord_center, 12)
	end
end

function luck_draw_on_create_thing(t, owner, type, model)
	if not (type == T_SPELL) then return end
	
	local targindex = t.u.Spell.TargetThingIdx
	
	if (not targindex:isNull()) then
		local clicked_owner = targindex:get().Owner
		
		if player_is_ai(clicked_owner) then
			local vars = mg_player_vars[clicked_owner]
			
			if vars.blast_cdr > 12 then
				local diff = get_participant_table(clicked_owner).diff
				if tribe_try_blast_trick(clicked_owner, true, 20 + diff*20) then
					vars.blast_cdr = vars.blast_cdr + 12
				end
			end
		end
	end
end

function LD_onEnd()
	ProcessGlobalTypeList(T_EFFECT, function(t)
		delete_thing_type_safe(t)
		return true
	end)
end

----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
--MAP_SPARKLING_TILES----------------------------------MAP_SPARKLING_TILES--------------------------------------------------MAP_SPARKLING_TILES---------------------------------------------MAP_SPARKLING_TILES---
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

function ST_init_single_AI(tribe)
	local ai = mg_player_vars[tribe]
	ai.c2d = nil
	ai.blast_cdr = 12*rndb(6, 12)
	ai.lights_cdr = 12*rndb(25, 35)
	ai.torns_cdr = 12*rndb(35, 40)
end

function ST_process_AI(tribe, alive, everySecond1, everySecond2, everySecond4, diff, vars, shaman)
	local blast_cdr = math.max(0, vars.blast_cdr - 1)
	local lights_cdr = math.max(0, vars.lights_cdr - 1)
	local torns_cdr = math.max(0, vars.torns_cdr - 1)
	vars.blast_cdr = blast_cdr
	vars.lights_cdr = lights_cdr
	vars.torns_cdr = torns_cdr

	if alive then
		local c2d = vars.c2d
		local moved
		
		if not c2d then
			c2d = coord_to_c2d(rndb(192, 248), rndb(198, 254)) 
			vars.c2d = c2d
			command_person_go_to_coord2d(shaman, c2d)
			moved = true
		else
			local dist = get_world_dist_xz(shaman.Pos.D2, c2d)
			
			if dist <= 1024 or chance(1+diff) then
				c2d = coord_to_c2d(rndb(192, 248), rndb(198, 254))
				vars.c2d = c2d
				command_person_go_to_coord2d(shaman, c2d)
				moved = true
			end
		end
		
		if moved then return end

		if chance(8 + diff*14) and (vars.torns_cdr <= 0) and try_to_spell_an_enemy_general(tribe, M_SPELL_WHIRLWIND, 6, 2, diff, 70+diff*15) then
			vars.torns_cdr = 12*rndb(32-diff*2, 44-diff*3)
			goto end_of_cast
		elseif chance(24+diff*8) and (vars.lights_cdr <= 0) and try_to_spell_an_enemy_general(tribe, M_SPELL_LIGHTNING_BOLT, 6+diff, 2, diff, 70+diff*10) then
			vars.lights_cdr = 12*rndb(12-diff, 24-diff*2)
			goto end_of_cast
		elseif chance(32+diff*16) and (vars.blast_cdr <= 0) and try_to_spell_an_enemy_general(tribe, M_SPELL_BLAST, 5, 2, diff, 65+diff*15) then
			vars.blast_cdr = 12*rndb(4-diff, 12-diff)
			goto end_of_cast
		else
			return
		end
		
		::end_of_cast::
		
		vars.blast_cdr = math.max(12, vars.blast_cdr)
		vars.lights_cdr = math.max(12, vars.lights_cdr)
		vars.torns_cdr = math.max(12, vars.torns_cdr)
		
		if everySecond4 then
			if not is_tribe_using_emoji(tribe) then
				if chance(1) then
					create_emote(tribe)
				end
			end
		end
	end
end

function ST_process_shamans(everySecond1, everySecond2, everySecond4)
	local everyTurns3 = everyTurns_mg(3)
	
	for _, participant in ipairs(_participants) do
		local tribe = participant.tribe
		local is_ai = participant.ai
		local alive = process_death_shamans(tribe, participant)
		local shaman = getShaman(tribe)
		local vars = mg_player_vars[tribe]
		
		if alive then
			if everyTurns3 then
				if not shaman_is_flying(shaman) then
					LD_process_shaman_cell(tribe, shaman.Pos.D3, vars)
				end
			end
		end
		
		if everySecond1 then
			local sparkles_amt = vars.sparkles
			give_points_to_team(sparkles_amt, tribe, false)
			vars.gsiP.ManaUnspent = vars.gsiP.ManaUnspent + (sparkles_amt * 82)
		end
		
		if is_ai then
			ST_process_AI(tribe, alive, everySecond1, everySecond2, everySecond4, participant.diff, vars, shaman)
		end
	end
	
	order_scores()
end

function LD_process_shaman_cell(tribe, c3d, vars)
	SearchMapCells(CIRCULAR, 0, 0, 0, world_coord3d_to_map_idx(c3d), function(me)
		me.MapWhoList:processList(function(t)
			if t.Type == T_EFFECT then
				if t.Model == M_EFFECT_SMALL_SPARKLE then
					if t.Owner ~= tribe then
						t.Owner = tribe
						t.DrawInfo.Alpha = mg_vars.spark_a_clrs[tribe+1]
						vars.sparkles = vars.sparkles + 1
					end
				end
			end
			return true
		end)
		return true
	end)
end

function LD_init_sparkles()
	local coord_large = MAP_XZ_2_WORLD_XYZ(220, 226)
	centre_coord3d_on_block(coord_large)
	local r = 28
	
	local mapXZ = MapPosXZ.new()
	mapXZ.Pos = world_coord3d_to_map_idx(coord_large)
	mapXZ.XZ.X = mapXZ.XZ.X-r+1
	mapXZ.XZ.Z = mapXZ.XZ.Z-r+1
	local mapXZ = mapXZ.XZ
	local x = 0
	local z = 0
	local count = 0
	for i=0,r do
		x = mapXZ.X + i*2
		for i=0,r do
			z = mapXZ.Z + i*2
			local c3d_local = Coord3D.new()
			c3d_local = MAP_XZ_2_WORLD_XYZ(x,z)
			centre_coord3d_on_block(c3d_local)
			local zone_trail = create_thing_cache(T_EFFECT, M_EFFECT_SMALL_SPARKLE, SAFE_NEUTRAL, c3d_local)
			if zone_trail then
				zone_trail.u.Effect.Duration = -1
				zone_trail.Pos.D3.Ypos = zone_trail.Pos.D3.Ypos - 128
				--table.insert(_TABL,zone_trail)
				--local me = world_coord3d_to_map_ptr(c3d_local)
				--is spot walkable?
			end
		end
	end
end

function sparkling_tiles_on_turn(everySecond1, everySecond2, everySecond4)
	if mg_turn == 1 then
		pti[M_PERSON_MEDICINE_MAN].ManaValue = 377
			
		for _, player in ipairs(_participants) do
			local tribe = player.tribe
			
			if player.ai then
				ST_init_single_AI(tribe)
			end
			
			enable_spell(tribe, M_SPELL_BLAST)
			enable_spell(tribe, M_SPELL_LIGHTNING_BOLT)
			enable_spell(tribe, M_SPELL_WHIRLWIND)
			
			local limits_spell = getPlayer(tribe).LimitsSpell
			limits_spell.Cost[M_SPELL_LIGHTNING_BOLT] = 50000
			limits_spell.MaxCharges[M_SPELL_LIGHTNING_BOLT] = 2
			limits_spell.Cost[M_SPELL_WHIRLWIND] = 80000
			limits_spell.MaxCharges[M_SPELL_WHIRLWIND] = 1
			
			mg_player_vars[tribe].sparkles = 0
			mg_player_vars[tribe].gsiP = _gsi.Players[tribe]
		end
		
		mg_vars.spark_a_clrs = {2,-2,3,1,10,11,12,-1}
		tmi[TMI_PERSON_MEDICINE_MAN].BaseSpeed = 128
		LD_init_sparkles()
	end
	
	ST_process_shamans(everySecond1, everySecond2, everySecond4)
end

function sparkling_tiles_on_create_thing(t, owner, type, model)
	if not (type == T_SPELL) then return end
	
	local targindex = t.u.Spell.TargetThingIdx
	
	if targindex:isNull() then
		for _, aiplayer in ipairs(_ai_participants) do
			local player = aiplayer.ptr
			local possible_victim = player.tribe
			
			if possible_victim ~= owner then
				if nilS(possible_victim) then
					if shaman_has_healthy_state(possible_victim) then
						if get_world_dist_xz(t.Pos.D2, getShaman(possible_victim).Pos.D2) < 512*2 then
							local dodged, dodged_c2d = try_to_dodge_on_land(possible_victim, rndb(1,3), 25 + player.diff*20)
							
							if dodged then
								mg_player_vars[possible_victim].c2d = dodged_c2d
							end
						end
					end
				end
			end
		end
	else
		if not (model == M_SPELL_BLAST) then return end
		local clicked_owner = targindex:get().Owner
		
		if (clicked_owner ~= owner) and player_is_ai(clicked_owner) then
			local vars = mg_player_vars[clicked_owner]
			
			--if vars.blast_cdr > 12 then
				if nilS(owner) then
					local diff = get_participant_table(owner).diff
					
					if chance(20 + diff*30) then
						local dist = get_world_dist_xyz(getShaman(clicked_owner).Pos.D3, getShaman(owner).Pos.D3)
						local cells_dist = dist // 512
						
						afa(math.min(14, rndb(6, 8)+cells_dist), tribe_try_blast_trick, clicked_owner, true, 100)
						vars.blast_cdr = vars.blast_cdr + 12
					end
				end
			--end
		end
	end
end

----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
--MAP_QUAKE_ARENA----------------------------------MAP_QUAKE_ARENA--------------------------------------------------MAP_QUAKE_ARENA---------------------------------------------MAP_QUAKE_ARENA---
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

function QA_init_single_AI(player)
	local ai = mg_player_vars[player]
	ai.c2d = marker_to_coord2d(rndb(0, 10))
	ai.laser_cdr = 12*rndb(3, 6)
	ai.going_for_pup = false
end

function QA_process_AI(tribe, alive, everySecond1, everySecond2, everySecond4, diff, vars, shaman)
	local laser_cdr = math.max(0, vars.laser_cdr - 1)
	vars.laser_cdr = laser_cdr

	if alive then
		local c2d = vars.c2d
		local idle = shaman_idle(tribe)
		
		if not c2d then
			local random_enemy_shaman = get_random_alive_enemy_shaman(tribe)
			if random_enemy_shaman and chance(40) then
				c2d = copy_c2d(random_enemy_shaman.Pos.D2)
			else
				if idle or chance(4) then
					local mk = rndb(7,10)
					local mkc2d = marker_to_coord2d(mk)
					c2d = mkc2d
				elseif chance(50) then
					local places = get_me_the_closest_powerup_max_rad(tribe, shaman, 8+diff*4)
					if #places == 1 then
						local item = places[1]
						c2d = item.c2d
					else
						if #places >= 2 then
							if chance(50) then
								local item = places[2]
								c2d = item.c2d
							else
								local item = places[1]
								c2d = item.c2d
							end
						end
					end
				end
			end
		else
			if not idle then
				local going4pup = vars.going_for_pup
				if going4pup then
					if not is_powerup_in_c2d(c2d) then
						c2d = nil
					end
				else
					local dist = get_world_dist_xz(shaman.Pos.D2, c2d)
					
					if dist <= 512 then
						if chance(12) then
							c2d = nil
						elseif chance (32) then
							local places = get_me_the_closest_powerup_max_rad(tribe, shaman, 8+diff*4)
							if #places == 1 then
								local item = places[1]
								c2d = item.c2d
							else
								if #places >= 2 then
									if chance(50) then
										local item = places[2]
										c2d = item.c2d
									else
										local item = places[1]
										c2d = item.c2d
									end
								end
							end
						else
							local mk = rndb(0,10)
							local mkc2d = marker_to_coord2d(mk)
							c2d = mkc2d
						end
					else
						if chance(1+diff) and chance(2 + diff*2) then
							if chance(50) then
								local random_enemy_shaman = get_random_alive_enemy_shaman(tribe)
								if random_enemy_shaman then
									c2d = copy_c2d(random_enemy_shaman.Pos.D2)
								else
									local mk = rndb(0,10)
									local mkc2d = marker_to_coord2d(mk)
									c2d = mkc2d
								end
							end
						elseif chance(2+diff) then
							local places = get_me_the_closest_powerup_max_rad(tribe, shaman, 8+diff*4)
							if #places == 1 then
								local item = places[1]
								c2d = item.c2d
							else
								if #places >= 2 then
									if chance(50) then
										local item = places[2]
										c2d = item.c2d
									else
										local item = places[1]
										c2d = item.c2d
									end
								end
							end
						end
					end
				end
			end
		end
		
		vars.c2d = c2d
		
		if c2d then
			if idle or chance(1+diff) then
				command_person_go_to_coord2d(shaman, c2d)
			end
		end
		
		if shaman_has_healthy_state(tribe) then
			local casted
			
			if count_player_spell_shots(tribe, M_SPELL_BLAST) > 0 then
				if chance(2+diff*2) then
					local closest_enemy = get_closest_alive_enemy_shaman(tribe)
					
					if closest_enemy then
						local closest_enemy_shaman = getShaman(closest_enemy)
						
						if closest_enemy_shaman then
							local dist = get_world_dist_xz(shaman.Pos.D2, closest_enemy_shaman.Pos.D2)
							
							if (dist > 512*10) and (dist <= 512*(14+diff)) then
								--only grenade if no close targets for laser exist
								createThing(T_SPELL, M_SPELL_BLAST, tribe, copy_c3d(closest_enemy_shaman.Pos.D3), false, false)
								goto casted
							end
						end
					end
				end
			end
			
			if laser_cdr == 0 then
				if chance(3+diff*3) then
					local closest_enemy = get_closest_alive_enemy_shaman(tribe)
					
					if closest_enemy then
						local closest_enemy_shaman = getShaman(closest_enemy)
						
						if closest_enemy_shaman then
							local dist = get_world_dist_xz(shaman.Pos.D2, closest_enemy_shaman.Pos.D2)
							
							if dist <= 512*(12+diff*2) then
								local offset = 1536 - 512*diff
								local offsetted_c3d = copy_c3d(closest_enemy_shaman.Pos.D3)
								offsetted_c3d.Xpos = offsetted_c3d.Xpos + rndb(-offset, offset)
								offsetted_c3d.Zpos = offsetted_c3d.Zpos + rndb(-offset, offset)
								createThing(T_SPELL, M_SPELL_CONVERT_WILD, tribe, offsetted_c3d, false, false)
								vars.laser_cdr = 12*rndb(rndb(3,4)-diff, math.min(6, 8-diff*rndb(2,3)))
							end
						end
					end
				end
			end
			
			::casted::
			
			if casted then
				vars.laser_cdr = math.max(vars.laser_cdr, 12)
			end
		end
		
		if everySecond4 then
			if not is_tribe_using_emoji(tribe) then
				if chance(2) then
					create_emote(tribe)
				end
			end
		end
	end
end

function QA_on_power_up(id, c3d)
	local c2d = c3d_to_c2d(c3d)
	
	for _, aiplayer in ipairs(_ai_participants) do
		local player = aiplayer.ptr
		local ai_tribe = player.tribe
		
		if nilS(ai_tribe) then
			if chance(40 + 15*player.diff) then
				mg_player_vars[ai_tribe].c2d = c2d
				mg_player_vars[ai_tribe].going_for_pup = true
				command_person_go_to_coord2d(getShaman(ai_tribe), c2d)
			end
		end
	end
end

function QA_process_shamans(everySecond1, everySecond2, everySecond4)
	for _, participant in ipairs(_participants) do
		local tribe = participant.tribe
		local is_ai = participant.ai
		local alive = process_death_shamans(tribe, participant)
		local shaman = getShaman(tribe)
		local vars = mg_player_vars[tribe]
		
		if is_ai then
			QA_process_AI(tribe, alive, everySecond1, everySecond2, everySecond4, participant.diff, vars, shaman)
		end
	end
end

function QA_powerup_c3d()
	local c3d
	local tries = 0

	while (not c3d) and (tries < 16) do
		local marker = rndb(7, 10)
		local _c3d = marker_to_coord3d(marker)
		
		if is_powerup_location_free(_c3d) then
			c3d = _c3d
			centre_coord3d_on_block(c3d)
		end
		
		tries = tries + 1
	end
	
	return c3d
end

function quake_on_turn(everySecond1, everySecond2, everySecond4)
	if mg_turn == 1 then
		for _, player in ipairs(_participants) do
			local tribe = player.tribe
			
			if player.ai then
				QA_init_single_AI(tribe)
			end
			
			enable_spell(tribe, M_SPELL_CONVERT_WILD)
			
			local limits_spell = getPlayer(tribe).LimitsSpell
			limits_spell.Cost[M_SPELL_CONVERT_WILD] = 225
			limits_spell.MaxCharges[M_SPELL_CONVERT_WILD] = 1
			limits_spell.WorldCoordRange[M_SPELL_CONVERT_WILD] = 3072
			limits_spell.Cost[M_SPELL_BLAST] = 1225
			limits_spell.MaxCharges[M_SPELL_BLAST] = 2
			limits_spell.WorldCoordRange[M_SPELL_BLAST] = 1024*8
			
			pti[M_PERSON_MEDICINE_MAN].AttackPower = 5
			mg_player_vars[tribe].lives = 10
			disable_spells_effects_for_this_level({M_SPELL_CONVERT_WILD, M_SPELL_BLAST})
		end
		
		mg_vars.tribe_colored_laser = is_map_rule_active(1)
		mg_vars.deathmatch = is_map_rule_active(2)
		if mg_vars.deathmatch then
			mg_vars.ignore_timer_objective = true
			mg_vars.ignore_high_score_objective = true
			log_msg(8, "Quake Arena Deathmatch enabled! Each shaman has 10 lives!")
		end
		mg_vars.custom_reinc_location = function(tribe)
			return marker_to_coord3d(rndb(0, 6))
		end
		tmi[TMI_PERSON_MEDICINE_MAN].BaseSpeed = 128
		ggameplay.max_powerups_at_once = 1
		_constants.ShamenDeadManaPer256Gained = 0
	end
	
	QA_process_shamans(everySecond1, everySecond2, everySecond4)
end

function QA_on_deathmatch_life_lost(tribe)
	local new_lives = math.max(0, mg_player_vars[tribe].lives - 1)
	mg_player_vars[tribe].lives = new_lives

	if new_lives <= 0 then
		local participant = _tribes_to_participants_ptrs[tribe]
		participant.can_reinc = false
		local team_ptr = participant.team_ptr
		local team_died = true
		
		for _, member in ipairs(team_ptr.players) do
			local member_tribe = member.tribe
			if _tribes_to_participants_ptrs[member_tribe].can_reinc then
				team_died = false
				break
			end
		end
		
		if team_died then
			team_ptr.active_playing = false
			local still_active = 0
			local won_name
			
			for _, team in ipairs(_participants_by_teams) do
				if team.active_playing then
					team.points = team.points + 1
					still_active = still_active + 1
					won_name = team.name
				end
			end
			
			order_scores()
			
			if still_active > 1 then
				log_msg(8, team_ptr.name .. " is out of the game.")
				queue_custom_sound_event(nil, "y_game_over.wav", 127)
			else
				log_msg(8, won_name .. " wins the Quake Arena Deathmatch!")
				queue_custom_sound_event(nil, "y_victory.wav", 127)
				end_game()
			end
		else
			--just one of the team members died
			log_msg(8, participant.name .. " is out of the game, but their team remains...")
			queue_custom_sound_event(nil, "10_v_hit08.wav", 127)
		end
	end
end

function quake_on_create_thing(t, owner, type, model)
	if type == T_SPELL then
		local t_spell = t.u.Spell
		t_spell.TargetThingIdx:set(0)
		t_spell.ShotThingIdx:set(0)
		set_spell_charges(owner, model, math.max(0, count_player_spell_shots(owner, model) - 1))
		--DestroyThing(t)

		if model == M_SPELL_BLAST then
			local s = getShaman(owner)
			if s then
				local z = t.Pos.D2.Zpos - s.Pos.D2.Zpos
				local x = t.Pos.D2.Xpos - s.Pos.D2.Xpos

				x = toSigned16(x)
				z = toSigned16(z)
				
				local angle = math.atan(z, x) * 180 / math.pi
				angle = math.ceil(angle)
				
				if (angle < 0) then
					angle = angle + 360
				end

				local rotation = (angle * math.pi) / 180
				local veloc = Coord3D.new()
				local distance_xyz = math.ceil(get_world_dist_xyz(s.Pos.D3,t.Pos.D3)/512)
				veloc.Xpos = math.ceil((math.cos(rotation) * 32*distance_xyz))
				veloc.Zpos = math.ceil((math.sin(rotation) * 32*distance_xyz))
				
				local grenade = createThing(T_SHOT, M_SHOT_VOLCANO_FIREBALL_1, owner, s.Pos.D3, false, false)
				local grenade_move = grenade.Move
				grenade_move.Velocity.X = veloc.Xpos
				grenade_move.Velocity.Z = veloc.Zpos
				grenade_move.Velocity.Y = 256
				grenade_move.SelfPowerSpeed = 128
			end
		elseif model == M_SPELL_CONVERT_WILD then
			local s = getShaman(owner)
			if s then
				--cant really dodge as laser is instant, but in case it misses, it adds AI movement patterns
				for _, aiplayer in ipairs(_ai_participants) do
					local player = aiplayer.ptr
					local possible_victim = player.tribe
					if nilS(possible_victim) then
						if is_player_enemy(owner, possible_victim) then
							if get_world_dist_xz(t.Pos.D2, getShaman(possible_victim).Pos.D2) < 512*8 then
								try_to_dodge_on_land(possible_victim, rndb(1, 4), 20 + 20*player.diff)
							end
						end
					end
				end
			
				local order_scores_now = false

				local x = toSigned16(t.Pos.D2.Xpos - s.Pos.D2.Xpos)
				local z = toSigned16(t.Pos.D2.Zpos - s.Pos.D2.Zpos)

				local angle = math.deg(math.atan(z, x))
				if angle < 0 then angle = angle + 360 end
				local rotation = math.rad(angle)

				local alt_limit = s.Pos.D3.Ypos + 256
				local alt_low_limit = s.Pos.D3.Ypos - (512 - 128)

				local distance_xyz = get_world_dist_xyz(s.Pos.D3, t.Pos.D3)
				local amount = math.ceil(distance_xyz / 512)
				local clr = mg_vars.tribe_colored_laser and _tribes_to_participants_ptrs[owner].g_color or -1
				local already_affected = {0,0,0,0,0,0,0,0} --sometimes it was triggering twice

				for i = 1, 20 do
					local spawnC3d = Coord3D.new()
					spawnC3d.Xpos = math.ceil(s.Pos.D3.Xpos + math.cos(rotation) * 512 * i)
					spawnC3d.Zpos = math.ceil(s.Pos.D3.Zpos + math.sin(rotation) * 512 * i)
					spawnC3d.Ypos = s.Pos.D3.Ypos

					local res = point_altitude(spawnC3d.Xpos, spawnC3d.Zpos)

					if (res < alt_limit and res > alt_low_limit) then
						alt_limit = res + 256
						alt_low_limit = res - (512 - 128)

						local smok = createThing(T_EFFECT, M_EFFECT_SMALL_SPARKLE, SAFE_NEUTRAL, spawnC3d, false, false)
						local me = world_coord2d_to_map_ptr(smok.Pos.D2)

						me.MapWhoList:processList(function(tg)
							local victim = tg.Owner
							
							if already_affected[victim+1] == 0 then
								if tg.Type == T_PERSON and victim ~= owner then
									if tg.Model == M_PERSON_MEDICINE_MAN then
										local dmg = (tg.u.Pers.u.Owned.ShieldCount > 0) and 500 or 65535
										damage_person(tg, owner, dmg, TRUE)
										already_affected[victim+1] = 1
										createThing(T_EFFECT, M_EFFECT_ORBITER, SAFE_NEUTRAL, spawnC3d, false, false)

										local victim_shaman = getShaman(victim)
										if nilS(victim) and victim_shaman.u.Pers then
											if victim_shaman.u.Pers.Life <= 0 then
												if mg_vars.deathmatch then
													QA_on_deathmatch_life_lost(victim)
												else
													if is_player_enemy(owner, victim) then
														give_points_to_team(1, owner, false)
														order_scores_now = true
													end
												end
											end
										end
									end
								end
							end
							return true
						end)

						smok.u.Effect.Duration = 2
						smok.Pos.D3.Ypos = smok.Pos.D3.Ypos - 128
						smok.DrawInfo.Alpha = ((i % 2) == 0) and 0 or clr
					else
						goto break_out
					end
				end
				
				::break_out::
				
				if order_scores_now then
					order_scores()
				end
			end
		end
		--t.Model = M_SPELL_NONE
		if t then
			delete_thing_type_safe(t)
		end
	elseif type == T_SHOT then
		if (model == M_SHOT_STANDARD) then
			t.u.Shot.TargetThingIdx:set(0)
		end
	elseif type == T_EFFECT then
		if model == M_EFFECT_SIMPLE_BLAST then
			local order_scores_now = false
			
			for _, participant in ipairs(_participants) do
				local tribe = participant.tribe
				
				if nilS(tribe) and (tribe ~= owner) then
					local target_shaman = getShaman(tribe)
					local target_pos = target_shaman.Pos.D3
					
					if (get_world_dist_xyz(target_pos, t.Pos.D3) < 1536) then
						local dmg = isShielded(target_shaman) and 1400 or 65535
						damage_person(target_shaman, owner, dmg, TRUE)
						createThing(T_EFFECT, M_EFFECT_ORBITER, SAFE_NEUTRAL, target_pos, false, false)
						
						if nilS(tribe) and target_shaman.u.Pers then
							if target_shaman.u.Pers.Life <= 0 then
								if mg_vars.deathmatch then
									QA_on_deathmatch_life_lost(tribe)
								else
									if is_player_enemy(owner, tribe) then
										give_points_to_team(1, owner, false)
										order_scores_now = true
									end
								end
							end
						end
					end
				end
			end
			
			if order_scores_now then
				order_scores()
			end
		end
	end
end

function quake_on_frame(ghover)
	local hover = false
	
	if mg_vars.deathmatch then
		PopSetFont(3, 0)
		local ch = CharHeight2()
		local box = math.max(ch, W // 64)
		local box2 = box // 2
		local small_gap = box // 4
		local big_gap = box * 2
		
		local amt = im_spectating and #_participants or #get_participant_table(playernum).team_ptr
		local teams_amt = im_spectating and #_participants_by_teams or 0
		local team_members = 0
		if not im_spectating then
			for _, v in ipairs(_participants_by_teams) do team_members = team_members + (#v.players - 1) end
		end
		local total_w = box*amt + (teams_amt-1)*big_gap + team_members*small_gap
		
		local x = (W+box) // 2 - total_w // 2
		local y = H - box - 4
		local centered_text_y = y + box2 - ch // 2
		
		if im_spectating then
			for _, team in ipairs(_participants_by_teams) do
				for _, member in ipairs(team.players) do
					local tribe = member.tribe
					local color = member.color
					local lives = tostring(mg_player_vars[tribe].lives)
					local centered_text_x = x + box2 - string_width(lives) // 2
					
					DrawBox(x, y, box, box, color)
					LbDraw_Text(centered_text_x, centered_text_y, lives, 0)
					
					if not hover and cursor_inside(x, y, box, box) then
						hover = true
						PopSetFont(4, 0)
						local h_ch = CharHeight2()
						local h_str = team.uid <= 8 and member.name or member.name .. " (" .. team.name .. ")"
						DrawBox(mouseX-1, y - h_ch - 12-1, string_width(h_str)+2, h_ch+2, 1)
						LbDraw_Text(mouseX, y - h_ch - 12, h_str, 0)
						PopSetFont(3, 0)
					end
					
					x = x + box + small_gap
				end
				
				x = x + box + big_gap
			end
		else
			for _, member in ipairs(get_participant_table(playernum).team_ptr.players) do
				local tribe = member.tribe
				local color = member.color
				local lives = tostring(mg_player_vars[tribe].lives)
				local centered_text_x = x + box2 - string_width(lives) // 2
				
				DrawBox(x, y, box, box, color)
				LbDraw_Text(centered_text_x, centered_text_y, lives, 0)
				
				if not hover and cursor_inside(x, y, box, box) then
					hover = true
					PopSetFont(4, 0)
					local h_str = member.name
					DrawBox(mouseX-1, y - CharHeight2() - 12-1, string_width(h_str)+2, CharHeight2()+2, 1)
					LbDraw_Text(mouseX, y - CharHeight2() - 12, h_str, 0)
					PopSetFont(3, 0)
				end
				
				x = x + box + small_gap
			end
		end
	end
	
	return (hover or ghover)
end

----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
--MAP_DISCO_FLOOR----------------------------------MAP_DISCO_FLOOR--------------------------------------------------MAP_DISCO_FLOOR---------------------------------------------MAP_DISCO_FLOOR---
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

function DF_init_single_AI(tribe)
	local ai = mg_player_vars[tribe]
	ai.c2d = nil
end

function DF_init_boat()
	if not mg_vars.boat_dance then return end
	
	local idx = world_coord3d_to_map_idx(MAP_XZ_2_WORLD_XYZ(45,161))
	SearchMapCells(SQUARE, 0, 0, 18+4, idx, function(me)
		me.Alt = 0
		return true
	end)
	set_square_map_params(idx, 18+4, TRUE)
	
	mg_vars.islands_tbl = {}
	DF_refresh_islands(false)
	
	for _, participant in ipairs(_participants) do
		local tribe = participant.tribe
		
		if nilS(tribe) then
			local shaman = getShaman(tribe)
			local random_island_c3d = DF_get_random_island_c3d()
			move_thing_within_mapwho(shaman, random_island_c3d)
			afa(2, DF_spawn_boat_there, tribe, random_island_c3d)
		end
	end
end

function DF_spawn_boat_there(tribe, c3d)
	local boat = create_thing_cache(T_VEHICLE, M_VEHICLE_BOAT_1, tribe, c3d)
	table.insert(mg_vars.boats, boat)
end

function DF_get_random_island_c3d()
	local ridx = rndb(1, #mg_vars.islands_tbl)
	local ptr = mg_vars.islands_tbl[ridx]
	return ptr.c3d
end

function DF_refresh_islands(clear_prev_ones)
	if clear_prev_ones then
		for _, island in ipairs(mg_vars.islands_tbl) do
			local idx = island.center_idx
			SearchMapCells(SQUARE, 0, 0, island.size, idx, function(me)
				me.Alt = 0
				return true
			end)
			set_square_map_params(idx, island.size + 2, TRUE)
		end
		mg_vars.islands_tbl = {}
	end

	local islands = rndb(1, math.max(2, #_participants + 0))
	
	for i = 1, islands do
		local c3d = MAP_XZ_2_WORLD_XYZ(rndb(20,70), rndb(136, 186))
		local size = rndb(rndb(0,1), rndb(1, 2))
		
		local idx = world_coord3d_to_map_idx(c3d)
		SearchMapCells(SQUARE, 0, 0, size, idx, function(me)
			me.Alt = rndb(32, 128)
			return true
		end)
		set_square_map_params(idx, size+2, TRUE)
		table.insert(mg_vars.islands_tbl, {c3d = c3d, center_idx = idx, size = size})
		local a = createThing(T_EFFECT, M_EFFECT_EROSION, SAFE_NEUTRAL, c3d, false, false)
		a.u.Effect.Duration = 4
	end
end

function DF_process_AI(tribe, alive, everySecond1, everySecond2, everySecond4, diff, vars, shaman, boat_dance)
	if alive then
		local c2d = vars.c2d
		local vehicled = is_person_in_boat(shaman) > 0
		
		if boat_dance then
			if not vehicled then
				if shaman_has_healthy_state(tribe) then
					if shaman.State ~= S_PERSON_UNDER_COMMAND then
						local boat = get_me_a_random_boat_in_location(shaman.Pos.D3, nil, nil, 4, true)
						
						if boat then
							command_person_enter_vehicle(shaman, boat)
						end
					end
				end
				
				return
			end
		end
		
		if mg_vars.rest_cdr > 0 then
			if chance(1+diff) or shaman_idle(tribe) then
				command_person_go_to_coord2d(shaman, coord_to_c2d(rndb(10,68), rndb(138, 184)))
			end
		else
			if c2d then
				local dist = get_world_dist_xz(shaman.Pos.D2, c2d)
				if dist < 256+32 then
					remove_all_persons_commands(shaman)
				else
					command_person_go_to_coord2d(shaman, c2d)
				end
			else
				if everyTurns_mg(32-diff*8) then
					local wanted_clr = mg_vars.correct_color
					local tries = 0
					while (not c2d) and (tries < (2 + diff*2)) do
						local _c2d = coord_to_c2d(rndb(20, 70), rndb(136, 186))
						local idx = world_coord2d_to_map_idx(_c2d)
						SearchMapCells(SQUARE, 0, 0, 2, idx, function(me)
							me.MapWhoList:processList(function(t)
								if t.DrawInfo.DrawNum == 1293 then
									if t.DrawInfo.Alpha == wanted_clr then
										local new_c2d = Coord2D.new()
										map_ptr_to_world_coord2d(me, new_c2d)
										c2d = new_c2d
										return false
									end
								end
								return true
							end)
							return true
						end)
						tries = tries + 1
					end
					
					if c2d then
						vars.c2d = c2d
						command_person_go_to_coord2d(shaman, c2d)
					end
				elseif shaman_idle(tribe) and chance(10 + diff*10) then
					command_person_go_to_coord2d(shaman, coord_to_c2d(rndb(10,68), rndb(138, 184)))
				end
			end
		end
		
		if everySecond4 then
			if not is_tribe_using_emoji(tribe) then
				if chance(2) then
					create_emote(tribe)
				end
			end
		end
	end
end

function DF_process_shamans(everySecond1, everySecond2, everySecond4)
	local boat_dance = mg_vars.boat_dance
	
	for _, participant in ipairs(_participants) do
		local tribe = participant.tribe
		local is_ai = participant.ai
		local alive = process_death_shamans(tribe, participant)
		local shaman = getShaman(tribe)
		local vars = mg_player_vars[tribe]
		
		if is_ai then
			DF_process_AI(tribe, alive, everySecond1, everySecond2, everySecond4, participant.diff, vars, shaman, boat_dance)
		end
		
		if everySecond1 and boat_dance then
			if alive then
				local vehicled = is_person_in_boat(shaman) > 0
				if not vehicled then
					if count_boats(shaman.Pos.D3, nil, nil, 3, true, true) == 0 then
						DF_spawn_boat_there(tribe, shaman.Pos.D3)
					end
				end
			end
		end
	end
end

function DF_reinc_now(tribe)
	if mg_vars.boat_dance then
		local c3d = DF_get_random_island_c3d()
		DF_spawn_boat_there(tribe, c3d)
		return c3d
	else
		return MAP_XZ_2_WORLD_XYZ(45,171)
	end
end

function disco_floor_on_turn(everySecond1, everySecond2, everySecond4)
	if mg_turn == 1 then
		for _, player in ipairs(_participants) do
			local tribe = player.tribe
			
			if player.ai then
				DF_init_single_AI(tribe)
			end
			
			enable_spell(tribe, M_SPELL_CONVERT_WILD)
			
			local limits_spell = getPlayer(tribe).LimitsSpell
			limits_spell.Cost[M_SPELL_CONVERT_WILD] = 100
			limits_spell.MaxCharges[M_SPELL_CONVERT_WILD] = 2
			limits_spell.WorldCoordRange[M_SPELL_CONVERT_WILD] = 2048
		end
		
		tmi[TMI_PERSON_MEDICINE_MAN].BaseSpeed = 128
		mg_vars.boat_dance = is_map_rule_active(1)
		mg_vars.color_idxes_names = { [11]="pink", [10]="cyan", [9]="orange", [8]="black", [4]="brown", [3]="yellow", [2]="blue", [1]="green", [0]="white", [-2]="red" }
		mg_vars.timer_cdr = 0
		mg_vars.rest_cdr = 0
		mg_vars.rest_max = 0
		mg_vars.wrong_colors_this_round = {}
		mg_vars.correct_color = nil
		mg_vars.extra_dangerous_color = nil
		mg_vars.boats = {}
		DF_init_sparkles()
		DF_init_boat()
		
		mg_vars.custom_reinc_location = function(tribe)
			return DF_reinc_now(tribe)
		end
	end
	
	if mg_turn == 12*3 then
		DF_init_round()
	elseif mg_turn > 12*3 then
		local new_cdr = math.max(0, mg_vars.timer_cdr - 1)
		mg_vars.timer_cdr = new_cdr
		
		if new_cdr <= 0 then
			if mg_vars.rest_cdr == 0 then
				DF_check_shamans_on_sparkles()
				local rest_timer = rndb(12, 12*4)
				mg_vars.rest_cdr = rest_timer
				mg_vars.rest_max = rest_timer
				if chance(50) then
					if mg_vars.boat_dance then
						DF_refresh_islands(chance(66))
					end
				end
				for _, player in ipairs(_participants) do
					local tribe = player.tribe
					if player.ai then
						mg_player_vars[tribe].c2d = nil
					end
				end
			else
				local new_rest_cdr = math.max(0, mg_vars.rest_cdr - 1)
				mg_vars.rest_cdr = new_rest_cdr
				
				if new_rest_cdr <= 0 then
					DF_init_round()
				end
			end
		end
	end
	
	if everySecond4 then
		if #mg_vars.boats > 16 then
			for i = #mg_vars.boats, #mg_vars.boats // 2, -1 do
				local boat = mg_vars.boats[i]
				if boat then
					if (boat.u.Vehicle) then
						if (boat.u.Vehicle.NumOccupants == 0) then
							boat.State = S_VEHICLE_BOAT_DYING
						end
					end
				end
			end
		end
	end

	DF_process_shamans(everySecond1, everySecond2, everySecond4)
	process_bloods()
end

function DF_on_frame(ghover)
	local hover = false
	
	PopSetFont(3, 0)
	local ch = CharHeight2()
	local cdr, rest = mg_vars.timer_cdr, mg_vars.rest_cdr
	local center_x = GUIW + (W-GUIW) // 2
	
	if rest <= 0 then
		local seconds = floor((cdr / 12) * 10) / 10
		seconds = string.format("%.1f", seconds)
		local seconds_w = string_width(seconds)
		LbDraw_Text(center_x - seconds_w//2, H - 16 - ch, seconds, 0)
	
		local correct = mg_vars.correct_color
		if correct then
			local str = "Stand on " .. mg_vars.color_idxes_names[correct] or "???"
			LbDraw_Text(center_x - string_width(str)//2, H - 16 - ch*3, str, 0)
		end
	else
		local rest_max = mg_vars.rest_max
		local percent = floor(((rest * 100)/ rest_max))
		local bar_w = W // 6
		DrawPercentBar(center_x - bar_w // 2, H - 16 - ch*2, bar_w, ch, percent, 0, 10, false, true)
	end
	
	return (hover or ghover)
end

function DF_check_shamans_on_sparkles()
	local correct_clr = mg_vars.correct_color
	local grunt
	
	for _, participant in ipairs(_participants) do
		local tribe = participant.tribe
		
		if nilS(tribe) then
			local blood = true
			
			SearchMapCells(CIRCULAR, 0, 0, 0, world_coord3d_to_map_idx(getShaman(tribe).Pos.D3), function(me)
				me.MapWhoList:processList(function(t)
					if t.DrawInfo.DrawNum == 1293 then
						if t.DrawInfo.Alpha == correct_clr then
							give_points_to_team(1, tribe, false)
							blood = false
							return false
						end
					end
					return true
				end)
				return true
			end)
			
			if blood then
				local victim_thing = getShaman(tribe)
				create_blood(victim_thing.Pos.D3, rndb(1, 8))
				grunt = victim_thing
			end
		end
	end
	
	order_scores()
	
	if grunt then
		queue_custom_sound_event(victim_thing, "33_Sv_grnt01.wav", 127)
	end
end

function DF_init_round()
	if increase_round() then
		local round_timer = 12*rndb(rndb(rndb(2,3),5), rndb(rndb(5,6),7))
		if mg_vars.boat_dance then
			round_timer = floor(rndb(floor(round_timer*1.5), floor(round_timer*2)))
		end
		ggameplay.map_curr_round_timer = round_timer
		mg_vars.timer_cdr = round_timer
		DF_init_picking_colors_this_round()
		DF_generate_round()
		DF_apply_sparkle_colors()
		queue_custom_sound_event(nil, "97_volbrst3.wav", 127)
	end
end

function DF_init_picking_colors_this_round()
	mg_vars.wrong_colors_this_round = {}
	mg_vars.correct_color = nil
	mg_vars.extra_dangerous_color = nil
	local colors_amt = rndb(rndb(2,4), rndb(5,rndb(7,9)))
	local poss = {11,10,9,8,4,3,2,1,0,-2}
	
	while #mg_vars.wrong_colors_this_round < colors_amt do
		local idx = rndb(1, #poss)
		local picked_clr = poss[idx]
		table.remove(poss, idx)
		table.insert(mg_vars.wrong_colors_this_round, picked_clr)
	end
	
	local idx = rndb(1, #poss)
	mg_vars.correct_color = poss[idx]
	table.remove(poss, idx)
	mg_vars.extra_dangerous_color = randomItemFromTable(poss) or randomItemFromTable(mg_vars.wrong_colors_this_round)
	--LOG("pick " .. mg_vars.color_idxes_names[mg_vars.correct_color] .. " out of " .. colors_amt .. " colors.")
end

function DF_init_sparkles()
	mg_vars.SIZE = 30
	mg_vars.TOTAL_TILES = mg_vars.SIZE*mg_vars.SIZE
	mg_vars.DF_tiles = {}


	for x = 1, mg_vars.SIZE do
		mg_vars.DF_tiles[x] = {}
		for y = 1, mg_vars.SIZE do
			mg_vars.DF_tiles[x][y] = { thing = nil, color = nil }
		end
	end

    local gx = 1
    for x = 16, 74, 2 do
        local gz = 1
        for z = 132, 190, 2 do

            local c3d = MAP_XZ_2_WORLD_XYZ(x, z)
            centre_coord3d_on_block(c3d)

            local t = create_thing_cache(T_GENERAL, M_GENERAL_MAPWHO_THING, SAFE_NEUTRAL, c3d)
			if t then
				t.Pos.D3.Ypos = t.Pos.D3.Ypos - 192
				t.DrawInfo.DrawNum = 1293

				-- Store the thing reference in the cell
				mg_vars.DF_tiles[gx][gz].thing = t
			end
            gz = gz + 1
        end
        gx = gx + 1
    end
end

function DF_inside(x, y)
    return x >= 1 and x <= mg_vars.SIZE and y >= 1 and y <= mg_vars.SIZE
end

function DF_randomTile()
    return rndb(1, mg_vars.SIZE), rndb(1, mg_vars.SIZE)
end

function DF_clear_colors()
    for x = 1, mg_vars.SIZE do
        for y = 1, mg_vars.SIZE do
            mg_vars.DF_tiles[x][y].color = nil
        end
    end
end

function DF_fill_cluster(startX, startY, limit, color)
    local queue = { {x=startX, y=startY} }
    local placed = 0

    while #queue > 0 and placed < limit do

        -- pick and remove a random element
        local idx = rndb(1, #queue)
        local node = table.remove(queue, idx)
        local x, y = node.x, node.y

        if DF_inside(x, y) and mg_vars.DF_tiles[x][y].color == nil then
            mg_vars.DF_tiles[x][y].color = color
            placed = placed + 1

            -- neighbor positions
            local neighbors = {
                {x+1, y}, {x-1, y},
                {x, y+1}, {x, y-1}
            }

            -- add neighbors randomly
            for _, nb in ipairs(neighbors) do
				local NEIGHBOR_CHANCE = 0.50 + rand01() * 0.35 --0.5 -> 0.85
                if rand01() < NEIGHBOR_CHANCE then
                    table.insert(queue, { x = nb[1], y = nb[2] })
                end
            end
        end
    end
end

function DF_generate_round()
    DF_clear_colors()

    -- Make CLUSTER_COUNT clusters
	local limit = chance(50) and rndb(32, 64) or rndb(96, 164)
	local CLUSTER_COUNT = rndb(rndb(6, limit), rndb(limit, limit*2))
	local CLUSTER_MIN_SIZE = math.max(2, floor(mg_vars.TOTAL_TILES / (CLUSTER_COUNT * rndb(2, 5))))
	local CLUSTER_MAX_SIZE = CLUSTER_MIN_SIZE * rndb(2, 4)
	
    for i = 1, CLUSTER_COUNT do
        local color = ((i == 1) or (chance(rndb(2, rndb(8, 16))))) and mg_vars.correct_color or randomItemFromTable(mg_vars.wrong_colors_this_round)
        local size = rndb(CLUSTER_MIN_SIZE, CLUSTER_MAX_SIZE)

        local sx, sy = DF_randomTile()
        DF_fill_cluster(sx, sy, size, color)
    end

    -- Fill uncolored tiles with default 0
	-- in fact, fill with a dangerous color (all same)
	local dangerous_clr = mg_vars.extra_dangerous_color
    for x = 1, mg_vars.SIZE do
        for y = 1, mg_vars.SIZE do
            if mg_vars.DF_tiles[x][y].color == nil then
                mg_vars.DF_tiles[x][y].color = dangerous_clr
            end
        end
    end
end

function DF_apply_sparkle_colors()
    for x = 1, mg_vars.SIZE do
        for y = 1, mg_vars.SIZE do
            local cell = mg_vars.DF_tiles[x][y]
            local t = cell.thing
            local c = cell.color

            if t then
                t.DrawInfo.Alpha = c
            end
        end
    end
end

----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
--MAP_JUMPERS----------------------------------MAP_JUMPERS--------------------------------------------------MAP_JUMPERS---------------------------------------------MAP_JUMPERS---------------------------------
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

function JU_init_single_AI(tribe)
	local ai = mg_player_vars[tribe]
	ai.tpcdr = 12*rndb(1, 2)
	ai.blast_cdr = 12*rndb(1,4)
	ai.lights_cdr = 12*rndb(4, 10)
end

function JU_process_AI(tribe, alive, everySecond1, everySecond2, everySecond4, diff, vars, shaman)
	local tpcdr = math.max(0, vars.tpcdr - 1)
	local blast_cdr = math.max(0, vars.blast_cdr - 1)
	local lights_cdr = math.max(0, vars.lights_cdr - 1)
	vars.tpcdr = tpcdr
	vars.blast_cdr = blast_cdr
	vars.lights_cdr = lights_cdr

	if alive then
		local idle = shaman_idle(tribe)
		
		if idle then
			local places = get_me_the_closest_powerup_max_rad(tribe, shaman, 4)
			if #places > 0 then
				command_person_go_to_coord2d(shaman, places[1].c2d)
			else
				try_to_dodge_on_land(tribe, rndb(1, 2), 6+diff*4)
			end
		else
			local tribe_c2d = shaman.Pos.D2
			
			if not shaman_can_cast(shaman) then
				goto move
			end
			
			do
				local closest_enemy = get_closest_alive_enemy_shaman(tribe)
				if closest_enemy then
					local closest_enemy_shaman = getShaman(closest_enemy)
					if closest_enemy_shaman then
						local dist = get_world_dist_xz(tribe_c2d, closest_enemy_shaman.Pos.D2)
						if (dist <= 512*5) then
							if (lights_cdr == 0) and try_to_spell_an_enemy_general(tribe, M_SPELL_LIGHTNING_BOLT, 5, 4+diff*4, diff, 60+diff*15) then
								vars.lights_cdr = 12* rndb(8-diff, 14-diff*2)
								goto dont_move
							elseif (blast_cdr == 0) and try_to_spell_an_enemy_general(tribe, M_SPELL_BLAST, 5, 4+diff*4, diff, 64+diff*12) then
								vars.blast_cdr = 12* rndb(rndb(3,4)-diff, 6-diff) + 6
								goto dont_move
							elseif (count_player_spell_shots(tribe, M_SPELL_WHIRLWIND) > 0) and try_to_spell_an_enemy_general(tribe, M_SPELL_WHIRLWIND, 16, 4+diff*4, diff, 70+diff*15) then
								set_spell_charges(tribe, M_SPELL_WHIRLWIND, 0)
								goto dont_move
							end
						elseif (dist <= 512*22) then
							if (blast_cdr == 0) and try_to_spell_an_enemy_general(tribe, M_SPELL_BLAST, 22, 4+diff*4, diff, 60+diff*15) then
								vars.blast_cdr = 12* rndb(rndb(3,4)-diff, 6-diff) + 6
								goto dont_move
							end
						end
					end
				end
			end
			
			::move::

			if tpcdr <= 0 then
				if shaman_has_healthy_state(tribe) then
					if chance(5+diff*5) then
						if JU_jump_to_island(tribe, shaman, diff) then
							local min = 12 + (12-diff*3)
							local max = 12*5 - 12*(diff) + 1
							vars.tpcdr = rndb(min, max)
						end
					elseif chance(32) then
						local places = get_me_the_closest_powerup_max_rad(tribe, shaman, 3)
						if #places > 0 then
							command_person_go_to_coord2d(shaman, places[1].c2d)
						end
					end
				end
			end
			
			::dont_move::
		end
	end
end

function JU_jump_to_island(tribe, shaman, diff)
	local poss = {}
	local poss_with_sh = {}
	local shaman_c2d = shaman.Pos.D2
	
	for mk = 0, 8 do
		local dist = get_world_dist_xz(shaman_c2d, marker_to_coord2d(mk))
		if dist > 512*5 then --dont jump to own island
			if dist < 14336 then --512*28
				local has_enemy = false
				for _, enemy in ipairs(get_enemy_tribes(tribe)) do
					if IS_SHAMAN_IN_AREA(enemy, mk, 3) then
						has_enemy = true
						break
					end
				end
				
				table.insert(has_enemy and poss_with_sh or poss, mg_vars.islands_c3d[mk+1])
			end
		end
	end
	
	local isl_with_enemies = #poss_with_sh > 0
	local empty_isl = #poss > 0
	
	if isl_with_enemies or empty_isl then
		local c3d
		
		if chance(25 + diff* 10) then
			if isl_with_enemies then
				c3d = randomItemFromTable(poss_with_sh)
			else
				c3d = randomItemFromTable(poss)
			end
		else
			if empty_isl then
				c3d = randomItemFromTable(poss)
			else
				c3d = randomItemFromTable(poss_with_sh)
			end
		end
		
		c3d.Xpos = c3d.Xpos + rndb(-256, 256)
		c3d.Zpos = c3d.Zpos + rndb(-256, 256)
		local _c3d = copy_c3d(c3d)
		createThing(T_SPELL, M_SPELL_CONVERT_WILD, tribe, _c3d, false, false)
		
		return true
	end
	
	return false
end

function JU_init_trees()
	for i = 1, rndb(200, 256) do
		local c3d = MAP_XZ_2_WORLD_XYZ(rndb(132,238), rndb(34,154))
		if is_c3d_water(c3d) and c3d_scenery_free(c3d) then
			local t = create_thing_cache(T_EFFECT, 10, SAFE_NEUTRAL, c3d)
			if t then
				t.u.Effect.Duration = -1
				
				set_thing_draw_info(t, 2, rndb(13, 18))
				t.Pos.D3.Ypos = -256
				t.AngleXZ = rndb(0, 512*3)
				t.Flags2 = EnableFlag(t.Flags2, TF2_DONT_DRAW_IN_WORLD_VIEW)
			end
		end
	end
end

function JU_process_shamans(everySecond1, everySecond2, everySecond4)
	for _, participant in ipairs(_participants) do
		local tribe = participant.tribe
		local is_ai = participant.ai
		local alive = process_death_shamans(tribe, participant)
		local shaman = getShaman(tribe)
		
		GIVE_MANA_TO_PLAYER(tribe, 512)
		
		if is_ai then
			local vars = mg_player_vars[tribe]
			JU_process_AI(tribe, alive, everySecond1, everySecond2, everySecond4, participant.diff, vars, shaman)
		end
	end
end

function jumpers_on_turn(everySecond1, everySecond2, everySecond4)
	if mg_turn == 1 then
		ggameplay.max_powerups_at_once = 1
		local sti2 = sti[M_SPELL_CONVERT_WILD]
		local sti2_b = sti[M_SPELL_TELEPORT]
		sti2.AvailableSpriteIdx = sti2_b.AvailableSpriteIdx
		sti2.NotAvailableSpriteIdx = sti2_b.NotAvailableSpriteIdx
		sti2.ClickedSpriteIdx = sti2_b.ClickedSpriteIdx
		sti2.CursorSpriteNum = sti2_b.CursorSpriteNum
		sti2.DiscoveryDrawIdx = sti2_b.DiscoveryDrawIdx
	
		for _, player in ipairs(_participants) do
			local tribe = player.tribe
			
			if player.ai then
				JU_init_single_AI(tribe)
			end
			
			--enable_spell(tribe, M_SPELL_CONVERT_WILD)
			enable_spell(tribe, M_SPELL_BLAST)
			enable_spell(tribe, M_SPELL_LIGHTNING_BOLT)
			
			local limits_spell = getPlayer(tribe).LimitsSpell
			--limits_spell.Cost[M_SPELL_CONVERT_WILD] = 512
			limits_spell.MaxCharges[M_SPELL_CONVERT_WILD] = 1
			limits_spell.WorldCoordRange[M_SPELL_CONVERT_WILD] = 1024*14
			limits_spell.Cost[M_SPELL_BLAST] = 4096
			limits_spell.MaxCharges[M_SPELL_BLAST] = 2
			limits_spell.WorldCoordRange[M_SPELL_BLAST] = 1024*22
			limits_spell.Cost[M_SPELL_LIGHTNING_BOLT] = 4096*2
			limits_spell.MaxCharges[M_SPELL_LIGHTNING_BOLT] = 2
			limits_spell.WorldCoordRange[M_SPELL_LIGHTNING_BOLT] = 512*6
			set_spell_charges(tribe, M_SPELL_CONVERT_WILD, 1)
			limits_spell.WorldCoordRange[M_SPELL_WHIRLWIND] = 512*16
			--limits_spell.MaxCharges[M_SPELL_WHIRLWIND] = 1
		end
		
		JU_init_trees()
		disable_spells_effects_for_this_level({M_SPELL_CONVERT_WILD})
		
		mg_vars.islands_c3d = {}
		for mk = 0, 8 do
			table.insert(mg_vars.islands_c3d, marker_to_coord3d(mk))
		end
		
		mg_vars.custom_reinc_location = function(tribe)
			return marker_to_coord3d(rndb(0, 8))
		end
	end
	
	JU_process_shamans(everySecond1, everySecond2, everySecond4)
end

function jumpers_on_create_thing(t, owner, type, model)
	if not (type == T_SPELL) then return end

	if model == M_SPELL_CONVERT_WILD then
		set_spell_charges(owner, model, 1)
		local c3d = copy_c3d(t.Pos.D3)
		createThing(T_EFFECT, M_EFFECT_SPRITE_CIRCLES, SAFE_NEUTRAL, c3d, false, false)
		afa(11, JU_backstab, owner, c3d)
		afa(10, create_thing_at_thing_pos_safe, T_EFFECT, M_EFFECT_SMOKE_CLOUD, SAFE_NEUTRAL, getShaman(owner))
		
		if t then
			delete_thing_type_safe(t)
		end
	end
end

function JU_backstab(tribe, c3d)
	if not nilS(tribe) then return end
	
	local caster = getShaman(tribe)
	move_thing_within_mapwho(caster, c3d)
	caster.Pos.D3.Ypos = rndb(256, 512+256)
end

function JU_on_shaman_dead(victim, killer, killer_was_ally)
	if not killer_was_ally then
		give_points_to_team(1, killer, true)
	end
end

----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
--MAP_PAINTBALL----------------------------------MAP_PAINTBALL--------------------------------------------------MAP_PAINTBALL---------------------------------------------MAP_PAINTBALL-------------------------
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

function PA_init_single_AI(tribe)
	local ai = mg_player_vars[tribe]
	ai.c2d = nil
	ai.paintball_cdr = 12
end

function PA_process_AI(tribe, alive, everySecond1, everySecond2, everySecond4, diff, vars, shaman)
	local paintball_cdr = math.max(0, vars.paintball_cdr - 1)
	vars.paintball_cdr = paintball_cdr

	if alive then
		local c2d = vars.c2d
		local idle = shaman_idle(tribe)
		local shaman_c2d = shaman.Pos.D2
		
		if not c2d then
			goto find_new_c2d
		else
			local dist = get_world_dist_xz(c2d, shaman_c2d)
			
			if (dist <= POWERUP_CATCH_RADIUS_DEFAULT + 128) and chance(16) then
				goto find_new_c2d
			else
				-- if chance(0) --[[and chance(1+diff) and chance(diff)]] then
					-- goto find_new_c2d
				-- else
					--cast spells
					if paintball_cdr == 0 and chance(4 + diff*2) then
						local enemy, min_dist = get_closest_alive_enemy_shaman(tribe)
						if (not enemy) or (min_dist > 512*(18+diff)) then
							enemy = get_random_enemy_shaman_near_thing(shaman, 18 + diff)
						end
						
						if enemy then
							local enemy_shaman = getShaman(enemy)
							
							local c3d = mg_vars.moon and aim_spell_at_target(tribe, enemy_shaman, 21 + diff) or c3d_offsetted(enemy_shaman.Pos.D3, rndb(200 - diff*100, 500 - diff*100))
							if c3d and chance(50 + diff*10) then
								local spell = createThing(T_SPELL, M_SPELL_CONVERT_WILD, tribe, c3d, false, false)
								vars.paintball_cdr = rndb(rndb(10,15), 42-diff*rndb(5,6)) - diff*rndb(2,3)
								try_to_dodge_on_land(tribe, rndb(1, 2), 1+diff)
							else
								if try_to_spell_an_enemy_general(tribe, M_SPELL_CONVERT_WILD, 21, 100, diff, 0) then
									vars.paintball_cdr = rndb(rndb(10,15), 42-diff*rndb(5,6)) - diff*rndb(2,3)
									try_to_dodge_on_land(tribe, rndb(1, 2), 1+diff)
								end
							end
						end
						
						return
					else
						command_person_go_to_coord2d(shaman, c2d)
						return
					end
				--end
			end
		end
		
		::find_new_c2d::
		
		local places = get_me_the_closest_powerup_max_rad(tribe, shaman, 26 + diff*8)
		if #places > 0 then
			if #places > 1 then
				new_c2d = chance(50+diff*10) and places[1].c2d or places[2].c2d
			else
				new_c2d = places[1].c2d
			end
		else
			if chance(75) then
				new_c2d = marker_to_coord2d(rndb(0, 17))
			else
				local random_enemy_shaman = get_random_alive_enemy_shaman(tribe)
				if random_enemy_shaman then
					new_c2d = copy_c2d(random_enemy_shaman.Pos.D2)
				else
					new_c2d = marker_to_coord2d(rndb(0, 17))
				end
			end
		end
		
		command_person_go_to_coord2d(shaman, new_c2d or c2d)
		vars.c2d = new_c2d
		
		if everySecond4 then
			if not is_tribe_using_emoji(tribe) then
				if chance(1) then
					create_emote(tribe)
				end
			end
		end
	end
end

function paintball_on_frame(ghover)
	local hover = false
	
	if not im_spectating then
		local pvars = mg_player_vars[playernum]
		local maxhp = pvars.maxhp
		local high_dmg = pvars.high_dmg
		local atk2 = pvars.atk2
		local bar_h = math.max(6, H // 96)
		local bar_w = W // 4
		local center_screen_x = (W + GUIW) // 2
		local bar_x = center_screen_x - bar_w // 2
		local bar_y = H - 6 - bar_h
		
		local percent = floor((maxhp / 2000) * 100)
		DrawPercentBar(bar_x, bar_y, bar_w, bar_h, percent, 1, 12, "orange_shadow")
		
		PopSetFont(11, 0)
		local ch = CharHeight2()
		local box = ch*4
		local box2 = box // 2
		local y = H - 4 - box
		
		if high_dmg > 0 then
			high_dmg = tostring(high_dmg // 12)
			local x = bar_x + bar_w + ch
			DrawBox(x-1, y-1, box+2, box+2, 0)
			DrawBox(x, y, box, box, 10)
			LbDraw_ScaledSprite(x+2, y+2, get_sprite(0, 1855), box-4, box-4)
			LbDraw_Text(x + box2 - string_width(high_dmg) // 2, y - ch - 2, high_dmg, 0)
		end
		
		if atk2 > 0 then
			atk2 = tostring(atk2 // 12)
			local x = bar_x - box - ch
			DrawBox(x-1, y-1, box+2, box+2, 0)
			DrawBox(x, y, box, box, 10)
			LbDraw_ScaledSprite(x+2, y+2, get_sprite(0, 2516), box-4, box-4)
			LbDraw_Text(x + box2 - string_width(atk2) // 2, y - ch - 2, atk2, 0)
		end
	end
	
	return (hover or ghover)
end

function PA_on_power_up(id, c3d)
	local c2d = c3d_to_c2d(c3d)
	
	for _, aiplayer in ipairs(_ai_participants) do
		local player = aiplayer.ptr
		local ai_tribe = player.tribe
		
		if nilS(ai_tribe) then
			if chance(12 + 12*player.diff) then
				local shaman = getShaman(ai_tribe)
				local shaman_c2d = shaman.Pos.D2
				local old_c2d = mg_player_vars[ai_tribe].c2d
				
				if (not old_c2d) or (get_world_dist_xz(shaman_c2d, c2d) < get_world_dist_xz(shaman_c2d, old_c2d)) then
					mg_player_vars[ai_tribe].c2d = c2d
					command_person_go_to_coord2d(shaman, c2d)
				end
			end
		end
	end
end

function PA_process_shamans(everySecond1, everySecond2, everySecond4)
	for _, participant in ipairs(_participants) do
		local tribe = participant.tribe
		local is_ai = participant.ai
		local alive = process_death_shamans(tribe, participant)
		local shaman = getShaman(tribe)
		local vars = mg_player_vars[tribe]
		
		local new_high_dmg = math.max(0, vars.high_dmg - 1)
		local new_atk2 = math.max(0, vars.atk2 - 1)
		vars.high_dmg = new_high_dmg
		vars.atk2 = new_atk2
		
		if alive then
			if shaman.State == S_PERSON_SPELL_TRANCE then
				shaman.Flags = EnableFlag(shaman.Flags, TF_RESET_STATE)
				vars.gsip.SpellDelayCount = 3
			else
				remove_shaman_melee(tribe)
			end
			shaman.u.Pers.Life = vars.maxhp
		end
		
		if is_ai then
			PA_process_AI(tribe, alive, everySecond1, everySecond2, everySecond4, participant.diff, vars, shaman)
		end
	end
end

function PA_spawn_color(c3d, tribe)
	local do_order = false
	local clr = mg_vars.paint_colors[tribe]
	local t = createThing(T_EFFECT, M_EFFECT_FIREBALL, tribe, c3d, false, false)
	t.u.Effect.Duration = -1
	set_thing_draw_info(t, TDI_SPRITE_F1_D1, rndb(clr, clr + 3))
	t.DrawInfo.Alpha = -16
	table.insert(mg_vars.colors, { t = t, timer = 12*rndb(30, 45) })
	local hit_distance = 512-32 --256+64+32
	
	for _, participant in ipairs(_participants) do
		local enemy = participant.tribe
		if nilS(enemy) then
			if is_player_enemy(enemy, tribe) then
				local shaman = getShaman(enemy)
				if not isShielded(shaman) then
					local dist = get_world_dist_xyz(shaman.Pos.D3, c3d)
					if dist <= hit_distance then
						local curr_life = shaman.u.Pers.Life
						if curr_life > 0 then
							local base_dmg = mg_vars.moon and 1000 or 500
							local dmg = (mg_player_vars[tribe].high_dmg > 0) and base_dmg*2 or base_dmg
							damage_person(shaman, tribe, dmg, 1)
							mg_player_vars[enemy].maxhp = mg_player_vars[enemy].maxhp - dmg
							if curr_life - dmg > 0 then
								give_points_to_team(1, tribe, false)
							end
							do_order = true
						end
					end
				end
			end
		end
	end
	
	return do_order
end

function PA_bomb_hit(c3d, tribe)
	local do_order = false
	local clr = mg_vars.paint_colors[tribe]
	local colors_tbl = {}
	
	for i = 1, 64 do
		local _c3d = c3d_offsetted(c3d, rndb(256, 1024 + 512))
		if not is_c3d_water(_c3d) then
			local t = createThing(T_EFFECT, M_EFFECT_FIREBALL, tribe, _c3d, false, false)
			t.u.Effect.Duration = -1 --rndb(12*12, 12*16)
			set_thing_draw_info(t, TDI_SPRITE_F1_D1, rndb(clr, clr + 3))
			t.DrawInfo.Alpha = -16
			ensure_thing_on_ground(t)
			table.insert(colors_tbl, t)
		end
	end
	
	table.insert(mg_vars.bombs, { list = colors_tbl, timer = 12*rndb(30, 45) })
	
	for _, participant in ipairs(_participants) do
		local enemy = participant.tribe
		if nilS(enemy) then
			if is_player_enemy(enemy, tribe) then
				local shaman = getShaman(enemy)
				local dist = get_world_dist_xyz(shaman.Pos.D3, c3d)
				
				if dist <= 1024 + 512 + 256 then
					local was_shielded = isShielded(shaman)
					shaman.u.Pers.u.Owned.ShieldCount = 0
					shaman.u.Pers.u.Owned.BloodlustCount = 0
					local enemy_vars = mg_player_vars[enemy]
					enemy_vars.high_dmg = 0
					enemy_vars.atk2 = 0
					
					if not was_shielded then
						local curr_life = shaman.u.Pers.Life
						if curr_life > 0 then
							local dmg = 500
							damage_person(shaman, tribe, dmg, 1)
							enemy_vars.maxhp = enemy_vars.maxhp - dmg
							if curr_life - dmg > 0 then
								give_points_to_team(1, tribe, false)
							end
							do_order = true
						end
					end
				end
			end
		end
	end
	
	return do_order
end

function PA_atk1(tribe)
	if not nilS(tribe) then return end
	
	local shaman = getShaman(tribe)
	local c3d = shaman.Pos.D3
	local enemies = get_enemy_tribes(tribe)
	local casted
	for _, enemy in ipairs(enemies) do
		if nilS(enemy) then
			createThing(T_SPELL, M_SPELL_LIGHTNING_BOLT, tribe, getShaman(enemy).Pos.D3, false, false)
			casted = true
		end
	end
	
	if casted then
		queue_custom_sound_event(nil, "y_paint_bomb.wav", 127)
	end
end

function PA_process_floor_colors(everySecond1)
	for i = #mg_vars.colors, 1, -1 do
		local tbl = mg_vars.colors[i]
		local thing = tbl.t
		if thing then
			local new_timer = math.max(0, tbl.timer - 1)
			tbl.timer = new_timer
			
			if new_timer == 0 then
				if thing.u.Effect then
					thing.u.Effect.Duration = 1
				end
				delete_thing_type_safe(thing)
				table.remove(mg_vars.colors, i)
			end
		else
			table.remove(mg_vars.colors, i)
		end
	end
	
	for i = #mg_vars.bombs, 1, -1 do
		local tbl = mg_vars.bombs[i]
		local new_timer = math.max(0, tbl.timer - 1)
		tbl.timer = new_timer
		
		if new_timer == 0 then
			local list = tbl.list
			local list_amt = #list
			
			if list_amt > 0 then
				if everySecond1 then
					for i = math.max(1, list_amt // 2), 1, -1 do
						local thing = list[i]
						afa(rndb(6, 24), delete_effect_and_hide_anim_safe, thing)
						table.remove(list, i)
					end
				end
			else
				table.remove(mg_vars.bombs, i)
			end
		end
	end
end

function PA_process_paintballs()
	local do_order = false
    local tbl = mg_vars.paintballs
    local WORLD_SIZE = 65536
    local HALF_SIZE  = 32768
	local moon = mg_vars.moon

    for i = #tbl, 1, -1 do
        local paintball = tbl[i]
        local t = paintball.thing

        if t then
			if moon then
				paintball.speed = math.min(4096, math.ceil(paintball.speed*1.5))
			end
            local speed = paintball.speed
            local c3d   = t.Pos.D3
            local targ  = paintball.targc3d
            local dx = targ.Xpos - c3d.Xpos
            if dx > HALF_SIZE then dx = dx - WORLD_SIZE end
            if dx < -HALF_SIZE then dx = dx + WORLD_SIZE end

            local dz = targ.Zpos - c3d.Zpos
            if dz > HALF_SIZE then dz = dz - WORLD_SIZE end
            if dz < -HALF_SIZE then dz = dz + WORLD_SIZE end

            local dy = targ.Ypos - c3d.Ypos
            local dist = math.sqrt(dx*dx + dy*dy + dz*dz)
			
            if dist <= speed then
                c3d.Xpos = targ.Xpos
                c3d.Ypos = targ.Ypos
                c3d.Zpos = targ.Zpos

                move_thing_within_mapwho(t, c3d)
				
				if is_c3d_water_or_coast(c3d) then
					createThing(T_EFFECT, M_EFFECT_SPLASH, SAFE_NEUTRAL, c3d, false, false)
				else
					if PA_spawn_color(c3d, t.Owner) then
						do_order = true
					end
				end
				
                delete_thing_type_safe(t)
                table.remove(tbl, i)
            else
                local f = speed / dist

                c3d.Xpos = floor(c3d.Xpos + dx * f)
                c3d.Ypos = floor(c3d.Ypos + dy * f)
                c3d.Zpos = floor(c3d.Zpos + dz * f)
                if c3d.Xpos < 0 then c3d.Xpos = c3d.Xpos + WORLD_SIZE end
                if c3d.Xpos >= WORLD_SIZE then c3d.Xpos = c3d.Xpos - WORLD_SIZE end

                if c3d.Zpos < 0 then c3d.Zpos = c3d.Zpos + WORLD_SIZE end
                if c3d.Zpos >= WORLD_SIZE then c3d.Zpos = c3d.Zpos - WORLD_SIZE end
                move_thing_within_mapwho(t, c3d)
            end

        else
            table.remove(tbl, i)
        end
    end
	
	if do_order then
		order_scores()
	end
end

function PA_pup_c3d()
	local poss = {}
	for mk = 11, 17 do
		local c3d = marker_to_coord3d(mk)
		if is_powerup_location_free(c3d) then
			centre_coord3d_on_block(c3d)
			table.insert(poss, c3d)
		end
	end
	return randomItemFromTable(poss)
end

function paintball_on_turn(everySecond1, everySecond2, everySecond4)
	if mg_turn == 1 then
		tmi[TMI_PERSON_MEDICINE_MAN].BaseSpeed = 96
		ggameplay.max_powerups_at_once = 5
		local sti2 = sti[M_SPELL_CONVERT_WILD]
		local sti2_b = sti[M_SPELL_TELEPORT]
		sti2.AvailableSpriteIdx = 2283
		sti2.NotAvailableSpriteIdx = 2283
		sti2.ClickedSpriteIdx = 2283
		sti2.CursorSpriteNum = 163
	
		for _, player in ipairs(_participants) do
			local tribe = player.tribe
			
			if player.ai then
				PA_init_single_AI(tribe)
			end
			
			local limits_spell = getPlayer(tribe).LimitsSpell
			limits_spell.Cost[M_SPELL_CONVERT_WILD] = 4096
			limits_spell.MaxCharges[M_SPELL_CONVERT_WILD] = 1
			limits_spell.WorldCoordRange[M_SPELL_CONVERT_WILD] = 512*20
			set_spell_charges(tribe, M_SPELL_CONVERT_WILD, 1)
			
			local pvars = mg_player_vars[tribe]
			pvars.gsip = _gsi.Players[tribe]
			pvars.maxhp = 2000
			pvars.high_dmg = 0
			pvars.atk2 = 0
		end
		
		disable_spells_effects_for_this_level({M_SPELL_CONVERT_WILD})
	
		mg_vars.custom_reinc_location = function(tribe)
			return marker_to_coord3d(rndb(0, 10))
		end
		mg_vars.paintballs = {}
		mg_vars.colors = {}
		mg_vars.bombs = {}
		mg_vars.paint_colors = { [0]=2453, 2445, 2457, 2437, 2449, 2473, 2465, 2441 }
		mg_vars.moon = is_map_rule_active(1)
		
		if is_map_rule_active(2) then
			ProcessGlobalSpecialList(TRIBE_NEUTRAL, WOODLIST, function(t)
			  if (t.Model < 2) then
				t.u.ObjectInfo.Scale = 128+G_RANDOM(256+64)
			  else
				t.u.ObjectInfo.Scale = t.u.ObjectInfo.Scale+G_RANDOM(64)
			  end
			  return true
			end)
		end
	end
	
	PA_process_shamans(everySecond1, everySecond2, everySecond4)
	PA_process_paintballs()
	PA_process_floor_colors(everySecond1)
	
	if everySecond4 then
		AI_shaman_stuck_checker(512, AI_UNSTUCK_METHOD_CLEAR_C2D)
	end
end

function paintball_on_create_thing(t, owner, type, model)
	if type == T_SPELL then
		if model == M_SPELL_CONVERT_WILD then
			--paintball
			set_spell_charges(owner, model, 1)
			queue_custom_sound_event(nil, chance(50) and "y_paintgun1.wav" or "y_paintgun2.wav", 127)
			local s = getShaman(owner)
			if s then
				local s_c3d = s.Pos.D3
				local clr = 2502+owner
				local max_speed = mg_vars.moon and 32 or 800
				local amt = (mg_player_vars[owner].atk2 > 0) and 3 or 1
				local targ_c3d = copy_c3d(t.Pos.D3)
				for i = 1, amt do
					local pb = {}
					local paintball = createThing(T_EFFECT, M_EFFECT_FIREBALL, owner, s_c3d, false, false)
					paintball.u.Effect.Duration = 96
					set_thing_draw_info(paintball, TDI_SPRITE_F1_D1, clr)
					paintball.DrawInfo.Alpha = -16
					pb.thing = paintball
					targ_c3d = (i == 1) and targ_c3d or c3d_offsetted(targ_c3d, 512)
					local dist = get_world_dist_xyz(s_c3d, targ_c3d)
					pb.targc3d = targ_c3d
					local MIN_SPEED = 2 -- point blank
					local MAX_SPEED = max_speed
					local FULL_RANGE = 512 * 12 -- 4096 units until max speed
					local factor = clamp(dist / FULL_RANGE, 0, 1)
					pb.speed = floor(MIN_SPEED + (MAX_SPEED - MIN_SPEED) * factor) --LOG(pb.speed)
					table.insert(mg_vars.paintballs, pb)
				end
			end
		else
			--paint bomb (lightning bolt)
			--seems not to hit very far targets?
			local s = getShaman(owner)
			if s then
				local WORLD_SIZE = 65536
				local HALF_SIZE = 32768

				-- Compute wrap-aware delta
				local dx = t.Pos.D2.Xpos - s.Pos.D2.Xpos
				if dx > HALF_SIZE then dx = dx - WORLD_SIZE end
				if dx < -HALF_SIZE then dx = dx + WORLD_SIZE end

				local dz = t.Pos.D2.Zpos - s.Pos.D2.Zpos
				if dz > HALF_SIZE then dz = dz - WORLD_SIZE end
				if dz < -HALF_SIZE then dz = dz + WORLD_SIZE end

				-- Compute distance for scaling
				local distance_xyz = math.sqrt(dx*dx + dz*dz) / 512
				local speed = 32 * distance_xyz

				-- Normalize the direction vector and scale
				local veloc = Coord3D.new()
				if distance_xyz > 0 then
					veloc.Xpos = math.ceil(dx / (distance_xyz * 512) * speed)
					veloc.Zpos = math.ceil(dz / (distance_xyz * 512) * speed)
				else
					veloc.Xpos = 0
					veloc.Zpos = 0
				end

				veloc.Ypos = 256

				-- Create grenade and assign velocity
				local grenade = createThing(T_SHOT, M_SHOT_VOLCANO_FIREBALL_1, owner, s.Pos.D3, false, false)
				if grenade then
					local grenade_move = grenade.Move
					grenade_move.Velocity.X = veloc.Xpos
					grenade_move.Velocity.Z = veloc.Zpos
					grenade_move.Velocity.Y = veloc.Ypos
					grenade_move.SelfPowerSpeed = 128
				end
			end
		end
		
		if t then delete_thing_type_safe(t) end
	elseif type == T_SHOT then
		if (model == M_SHOT_VOLCANO_FIREBALL_1) then
			t.u.Shot.TargetThingIdx:set(0)
			set_thing_draw_info(t, TDI_SPRITE_F1_D1, 2284+owner)
			t.DrawInfo.Alpha = -16
		end
	elseif type == T_EFFECT then
		if model == M_EFFECT_SIMPLE_BLAST or model == M_EFFECT_EXPLOSION_3 or model == M_EFFECT_BURN_CELL_OBSTACLES then
			if model == M_EFFECT_SIMPLE_BLAST then
				--paint bomb hits ground
				if PA_bomb_hit(t.Pos.D3, owner) then
					order_scores()
				end
			end
			
			delete_thing_type_safe(t)
		end
	elseif type == T_PERSON then
		t.u.Pers.MaxLife = 2000
		t.u.Pers.Life = 2000
		mg_player_vars[owner].maxhp = 2000
		mg_player_vars[owner].high_dmg = 0
		mg_player_vars[owner].atk2 = 0
	end
end

function PA_on_shaman_dead(victim, killer, killer_was_ally)
	if not killer_was_ally then
		give_points_to_team(3, killer, true)
	end
end

function PA_on_end()
	for _, paint in ipairs(mg_vars.colors) do
		local t = paint.t
		if t then
			if t.u.Effect then
				t.u.Effect.Duration = 1
			end
			
			delete_thing_type(t)
		end
	end
	
	for _, zone in ipairs(mg_vars.bombs) do
		for _, t in ipairs(zone.list) do
			if t then
				if t.u.Effect then
					t.u.Effect.Duration = 1
				end
				
				delete_thing_type(t)
			end
		end
	end
end

----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
--MAP_ICE_ARENA----------------------------------MAP_ICE_ARENA------------------------------------------MAP_ICE_ARENA--------------------------------------MAP_ICE_ARENA----------------------
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

function PS_init_single_AI(tribe)
	local ai = mg_player_vars[tribe]
	ai.c2d = nil
end

function PS_process_AI(tribe, alive, everySecond1, everySecond2, everySecond4, diff, vars, shaman, kick_cdr)
	if alive then
		local c2d = vars.c2d
		
		if not c2d then
			goto pick_c2d
		else
			local shaman_c2d = shaman.Pos.D2
			local dist = get_world_dist_xz(shaman_c2d, c2d)
			
			if dist <= 512+32 then
				if chance(24+diff*24) then
					goto pick_c2d
				else
					local places = get_me_the_closest_powerup_max_rad(tribe, shaman, 5+diff*2)
					if #places == 1 then
						local item = places[1]
						c2d = item.c2d
						vars.c2d = c2d
						command_person_go_to_coord2d(shaman, c2d)
					elseif #places >= 2 then
						if chance(50) then
							local item = places[2]
							c2d = item.c2d
							vars.c2d = c2d
						else
							local item = places[1]
							c2d = item.c2d
							vars.c2d = c2d
						end
						command_person_go_to_coord2d(shaman, c2d)
					else
						goto pick_c2d
					end
				end
			else
				if chance(1+diff) then
					--try_to_dodge_on_land(tribe, rndb(1, 2), 4+diff*2)
					return
				else
					if shaman_can_cast(shaman) then
						if kick_cdr == 0 then
							if chance(4 + diff*2) then
								local targ = get_closest_alive_enemy_shaman(tribe)
								if targ then
									local targ_sh = getShaman(targ)
									
									if get_world_dist_xz(shaman_c2d, targ_sh.Pos.D2) <= 512*5 then
										local min_error, max_error = 100-diff*20, 150-diff*20
										face_thing_towards_with_optional_miss(shaman, targ_sh, min_error, max_error)
										IA_throw_shaman(tribe)
										return
									end
								end
							end
						end
					end
					
					::no_transform_just_move::
					if not is_c2d_water(shaman_c2d) then
						command_person_go_to_coord2d(shaman, c2d)
					end
					return
				end
			end
		end
		
		::pick_c2d::
		
		c2d = c3d_to_c2d(PS_land_c3d())
		vars.c2d = c2d
		command_person_go_to_coord2d(shaman, c2d)
	end
end

function IA_time_freeze(catcher)
	local freeze_time = 12*6
	
	for _, enemy in ipairs(get_enemy_tribes(catcher)) do
		local pvars = mg_player_vars[enemy]
		pvars.kick_cdr = freeze_time
		pvars.kick_max_cdr = freeze_time
	end
end

function IA_pup_c3d()
	local idx = world_coord3d_to_map_idx(marker_to_coord3d(0))
	local radius = 5
	local poss = {}
	
	SearchMapCells(CIRCULAR, 0, radius, radius, idx, function(me)
		if me.Alt > 400 then
			local c3d = me2c3d(me)
			if not is_powerup_in_c3d(c3d) then
				table.insert(poss, c3d)
			end
		end
		return true
	end)
	
	return randomItemFromTable(poss)
end

function PS_process_shamans(everySecond1, everySecond2, everySecond4)
	for _, participant in ipairs(_participants) do
		local tribe = participant.tribe
		local is_ai = participant.ai
		local alive = process_death_shamans(tribe, participant)
		local shaman = getShaman(tribe)
		local vars = mg_player_vars[tribe]
		
		local new_kick_cdr = math.max(0, vars.kick_cdr - 1)
		vars.kick_cdr = new_kick_cdr
		local new_oiled = math.max(0, vars.oiled - 1)
		vars.oiled = new_oiled
		
		if alive then
			remove_shaman_melee(tribe)
		end
		
		if is_ai then
			local diff = participant.diff
			PS_process_AI(tribe, alive, everySecond1, everySecond2, everySecond4, diff, vars, shaman, new_kick_cdr)
		end
	end	
end

function PS_land_c3d()
	local c3d
	while not c3d do
		local _c3d = MAP_XZ_2_WORLD_XYZ(rndb(24, 56), rndb(76, 108))
		if is_c3d_land(_c3d) then
			c3d = _c3d
		end
	end
	return c3d
end

function PS_on_turn(everySecond1, everySecond2, everySecond4)
	if mg_turn == 1 then
		ggameplay.max_powerups_at_once = 2
		tmi[TMI_PERSON_MEDICINE_MAN].BaseSpeed = 120
		mg_vars.custom_reinc_location = function(tribe)
			return PS_land_c3d()
		end
	
		for _, player in ipairs(_participants) do
			local tribe = player.tribe
			
			if player.ai then
				PS_init_single_AI(tribe)
			end
			
			local pvars = mg_player_vars[tribe]
			pvars.ball_form = false
			pvars.kick_cdr = player.ai and rndb(4, 32) or 0
			pvars.kick_max_cdr = 1
			pvars.oiled = 0
		end
	

		mg_vars.shaman_balls = {}
		mg_vars.punches = {"3_punch5.wav","5_punch3.wav","6_punch2.wav", "7_Punch1.wav", "0_Punch31.wav", "1_Punch21.wav", "2_Punch11.wav"}
		mg_vars.kick_cdr_enum = is_map_rule_active(1) and function()
			local cdr = rndb(12, 24) if chance(12) then cdr = rndb(8, 12) elseif chance(8) then cdr = rndb(24, 32) end
			return cdr
		end 
		or 
		function()
			local cdr = rndb(24, 32) if chance(12) then cdr = rndb(16, 22) elseif chance(8) then cdr = rndb(34, 42) end
			return cdr
		end
		mg_vars.ball_veloc_enum = is_map_rule_active(2) and 512 or 256+128
	end

	IA_process_balls()
	PS_process_shamans(everySecond1, everySecond2, everySecond4)
	process_future_private_actions()
	process_bloods()
end

function IA_process_balls()
	local tbl = mg_vars.shaman_balls
	local speed = mg_vars.ball_veloc_enum
	
	for i = #tbl, 1, -1 do
		local ball = tbl[i]
		local thing = ball.t
		
		if not thing then
			table.remove(tbl, i)
		else
			local destc3d = ball.destc3d
			local thingPos = thing.Pos.D3
			local prevX, prevZ = thingPos.Xpos, thingPos.Zpos
			local dist = get_world_dist_xyz(destc3d, thingPos)
			local owner = thing.Owner
			local dir_angle = ball.angle
			
			if dist < speed then
				move_thing_within_mapwho(thing, destc3d)
				local nsh = createThing(T_PERSON, M_PERSON_MEDICINE_MAN, owner, destc3d, false, false)
				mg_player_vars[owner].dont_process_death = false
				nsh.AngleXZ = dir_angle
				if nsh.Move and nsh.Move.CurrDest then
					nsh.Move.CurrDest.AngleXZ = dir_angle
				end
				if not multiplayer then
					try_to_select_thing(nsh, owner)
					pafa(1, try_to_select_thing, nsh, owner)
				end
				mg_player_vars[owner].ball_form = false
				thing.u.Effect.Duration = 1
				thing.DrawInfo.Flags = EnableFlag(thing.DrawInfo.Flags, DF_THING_NO_DRAW)
				table.remove(tbl, i)
			else
				local new_travelled = ball.travelled + 1
				ball.travelled = new_travelled
				local ax = thingPos.Xpos
				local az = thingPos.Zpos
				local new_c3d = Coord3D.new()
				local dx = destc3d.Xpos - ax
				local dz = destc3d.Zpos - az
				local inv = speed / dist
				local bx = floor(thingPos.Xpos + dx * inv)
				local bz = floor(thingPos.Zpos + dz * inv)
				new_c3d.Xpos = bx
				new_c3d.Zpos = bz
				move_thing_within_mapwho(thing, new_c3d)
				
				--need to find any shamans i found /(touched withini max_touch_dist dist)
				-- that i met from A point --> (1024 speed distance) --> B point
				--ax, az = point A ; bx, bz = point B
				
				local rule3 = is_map_rule_active(3)
				local max_touch_dist = rule3 and 1024-256 or 512
				local knock_power = rule3 and 4096 or 2048 + 1024
				knock_power = (new_travelled <= 1) and floor(knock_power *1.5) or knock_power --if travelled < 2 times (eg.: melee casting)
				
				for _, participant in ipairs(_participants) do
                    local target_tribe = participant.tribe
                    if nilS(target_tribe) then
                        local targShaman = getShaman(target_tribe)
                        local sp = targShaman.Pos.D3

                        local hit, cx, cz = segment_hits_point(ax, az, new_c3d.Xpos, new_c3d.Zpos, sp.Xpos, sp.Zpos, max_touch_dist)
                        if hit then
							local collision_c3d = copy_c3d(sp)
							create_blood(collision_c3d, randomItemFromTable({1,2,4,8}))
							for i = 1, rndb(4, 12) do
								local spr = rndb(2336, 2347)
								local t = createThing(T_EFFECT, 60, SAFE_NEUTRAL, c3d_offsetted(collision_c3d, rndb(-1024, 1024)), false, false)
								set_thing_draw_info(t, TDI_SPRITE_F1_D1, spr)
								t.DrawInfo.Alpha = -16
								t.u.Effect.Duration = 12*rndb(8, 16)
							end
							
                            -- Calculate forward vector of projectile
                            local vx, vz = new_c3d.Xpos - ax, new_c3d.Zpos - az
                            local vlen = math.sqrt(vx*vx + vz*vz)
                            vx, vz = vx / vlen, vz / vlen

                            -- Vector from path to shaman (lateral offset)
                            local ox, oz = sp.Xpos - cx, sp.Zpos - cz
                            local lateral_dist = math.sqrt(ox*ox + oz*oz)
                            local side_strength = math.min(lateral_dist / max_touch_dist, 1)
                            if lateral_dist > 0 then
                                ox, oz = ox / lateral_dist, oz / lateral_dist
                            end

                            -- Blend forward + side impulses
                            local forward_power = knock_power * (1 - side_strength) * 1.3
                            local side_power    = knock_power * side_strength * 1.2

                            local pushx = vx * forward_power + ox * side_power
                            local pushz = vz * forward_power + oz * side_power

                            -- Apply movement
                            local push_c3d = Coord3D.new()
                            push_c3d.Xpos = floor(sp.Xpos + pushx)
                            push_c3d.Zpos = floor(sp.Zpos + pushz)
                            push_c3d.Ypos = point_altitude(push_c3d.Xpos, push_c3d.Zpos)
                            move_thing_within_mapwho(targShaman, push_c3d)
							
							-- draw effects along the path from A(collision point) to B (push_c3d)
							
							local ax2, az2 = cx, cz
							local bx2, bz2 = push_c3d.Xpos, push_c3d.Zpos

							-- spacing in world units (512 = 1 cell, 256 = half cell, etc)
							local step = 128 -- change to 256 / 128 / etc

							local dx = bx2 - ax2
							local dz = bz2 - az2
							local dist = math.sqrt(dx*dx + dz*dz)

							if dist > 0 then
								local nx = dx / dist
								local nz = dz / dist

								local steps = floor(dist / step)

								for i = 0, steps do
									local px = ax2 + nx * step * i
									local pz = az2 + nz * step * i

									local ec3d = Coord3D.new()
									ec3d.Xpos = floor(px)
									ec3d.Zpos = floor(pz)
									ec3d.Ypos = point_altitude(ec3d.Xpos, ec3d.Zpos)

									local e = createThing(T_EFFECT, 60, SAFE_NEUTRAL, ec3d, false, false)
									set_thing_draw_info(e, TDI_SPRITE_F1_D1, rndb(2336, 2340))
									e.DrawInfo.Alpha = -16
									e.u.Effect.Duration = 12*rndb(5,8)
								end
							end

                            -- Optional: mark shaman as “hit”/spawn effect
                            createThing(T_EFFECT, M_EFFECT_SPHERE_EXPLODE_1, owner, sp, false, false)
							local impact_c3d = Coord3D.new()
							impact_c3d.Xpos = floor(cx)
							impact_c3d.Zpos = floor(cz)
							impact_c3d.Ypos = point_altitude(impact_c3d.Xpos, impact_c3d.Zpos)
							local nsh = createThing(T_PERSON, M_PERSON_MEDICINE_MAN, owner, impact_c3d, false, false)
							local dizzy = createThing(T_EFFECT, 10, owner, impact_c3d, false, false)
							set_thing_draw_info(dizzy, TDI_SPRITE_F10_D1_ALPHA, 1553)
							dizzy.DrawInfo.Alpha = 2
							dizzy.u.Effect.Duration = 4
							dizzy.Pos.D3.Ypos = nsh.Pos.D3.Ypos + 172
							mg_player_vars[owner].dont_process_death = false
							local angle_rad = atan2(pushx, pushz)
							nsh.AngleXZ = dir_angle
							if nsh.Move and nsh.Move.CurrDest then
								nsh.Move.CurrDest.AngleXZ = dir_angle
							end
                            mg_player_vars[owner].ball_form = false
                            thing.u.Effect.Duration = 1
							thing.DrawInfo.Flags = EnableFlag(thing.DrawInfo.Flags, DF_THING_NO_DRAW)
							table.remove(tbl, i)
							--participant.ldb = owner
							damage_person(targShaman, owner, 64, 1)
							if not multiplayer then
								try_to_select_thing(nsh, owner)
								pafa(1, try_to_select_thing, nsh, owner)
							end
							queue_custom_sound_event(nil, randomItemFromTable(mg_vars.punches) or "", 127)
							break
                        end
                    end
                end
			end
		end
	end
end

function dot2(ax, az, bx, bz)
	return ax * bx + az * bz
end

function segment_hits_point(ax, az, bx, bz, px, pz, radius)
    local abx = bx - ax
    local abz = bz - az
    local apx = px - ax
    local apz = pz - az

    local ab_len_sq = abx*abx + abz*abz
    if ab_len_sq == 0 then return false, ax, az end

    local t = clamp(dot2(apx, apz, abx, abz) / ab_len_sq, 0, 1)

    local cx = ax + abx * t
    local cz = az + abz * t

    local dx = px - cx
    local dz = pz - cz

    return (dx*dx + dz*dz) <= (radius*radius), cx, cz
end

function IA_throw_shaman(tribe)
	if not nilS(tribe) then return end
	if not shaman_has_healthy_state(tribe) then return end
	local pvars = mg_player_vars[tribe]
	if pvars.kick_cdr > 0 then return end
	
	local shaman = getShaman(tribe)
	local angle = shaman.AngleXZ --0-2048 (360º)
	local c3d = copy_c3d(shaman.Pos.D3)
	delete_thing_type(shaman)
	pvars.dont_process_death = true
	pvars.ball_form = true
	
	local t = createThing(T_EFFECT, M_EFFECT_FIREBALL, tribe, c3d, false, false)
	t.u.Effect.Duration = 96
	local spr = is_map_rule_active(3) and 2524 or 2502
	set_thing_draw_info(t, TDI_SPRITE_F1_D1, spr+tribe)
	t.DrawInfo.Alpha = -16--_tribes_to_participants_ptrs[tribe].g_color
	
	local angle_rad = (angle / 2048) * (2 * math.pi)
	local DIST = 5 * 512
	local dest_c3d = Coord3D.new()
	dest_c3d.Xpos = floor(c3d.Xpos + math.sin(angle_rad) * DIST)
	dest_c3d.Zpos = floor(c3d.Zpos + math.cos(angle_rad) * DIST)
	dest_c3d.Ypos = point_altitude(dest_c3d.Xpos, dest_c3d.Zpos)
	
	table.insert(mg_vars.shaman_balls, { t = t, destc3d = dest_c3d, angle = angle, travelled = 0 })
	local cdr = mg_vars.kick_cdr_enum()
	if pvars.oiled > 0 then
		cdr = 6
	end
	pvars.kick_cdr = cdr
	pvars.kick_max_cdr = cdr
end

function IA_on_power_up(id, c3d)
	local c2d = c3d_to_c2d(c3d)
	
	for _, aiplayer in ipairs(_ai_participants) do
		local player = aiplayer.ptr
		local ai_tribe = player.tribe
		
		if nilS(ai_tribe) then
			if chance(16 + 16*player.diff) then
				local shaman = getShaman(ai_tribe)
				local shaman_c2d = shaman.Pos.D2
				local old_c2d = mg_player_vars[ai_tribe].c2d
				
				if (not old_c2d) or (get_world_dist_xz(shaman_c2d, c2d) < get_world_dist_xz(shaman_c2d, old_c2d)) then
					mg_player_vars[ai_tribe].c2d = c2d
					command_person_go_to_coord2d(shaman, c2d)
				end
			end
		end
	end
end

function IA_on_key(key, is_down, tribe)
	if is_down then return end
	if not (key == LB_KEY_SPACE) then return end
	if not nilS(tribe) then return end
	if not shaman_has_healthy_state(tribe) then return end
	if mg_player_vars[tribe].kick_cdr > 0 then return end
	
	IA_throw_shaman(tribe)
end

function IA_on_key_Multiplayer(tribe, str)
	if type(str) ~= "string" then return end

	local is_down = decode_boolean(str:sub(1,1))
	if is_down then return end

	local key = decode_base62(str:sub(2))
	if not (key == LB_KEY_SPACE) then return end
	if not nilS(tribe) then return end
	if not shaman_has_healthy_state(tribe) then return end
	if mg_player_vars[tribe].kick_cdr > 0 then return end
	
	IA_throw_shaman(tribe)
end

function IA_on_shaman_dead(victim, killer, killer_was_ally)
	if not killer_was_ally then
		give_points_to_team(5, killer, false)
	end
	give_points_to_team(-1, victim, false)
	order_scores()
end

function IA_on_create_thing(t, owner, type, model)
	if type == T_PERSON and model == T_SHAMAN then
		mg_player_vars[owner].dont_process_death = false
		mg_player_vars[owner].kick_cdr = 0
		mg_player_vars[owner].kick_max_cdr = 1
		mg_player_vars[owner].oiled = 0
	end
end

function IA_on_frame(ghover)
	local hover = false
	
	if not im_spectating then
		local pvars = mg_player_vars[playernum]
		local kick_cdr = pvars.kick_cdr
		local max_cdr = pvars.kick_max_cdr

		local bar_h = math.max(6, H // 96)
		local bar_w = W // 4
		local center_screen_x = (W + GUIW) // 2
		local bar_x = center_screen_x - bar_w // 2
		local bar_y = H - 6 - bar_h
		
		local percent = floor((kick_cdr / max_cdr) * 100)
		DrawPercentBar(bar_x, bar_y, bar_w, bar_h, percent, 1, 10, "orange_shadow")
	end
	
	return (hover or ghover)
end

function IA_on_end()
	remove_all_future_private_actions()

	for _, v in ipairs(mg_vars.shaman_balls) do
		delete_thing_type_safe(v.t)
	end
end

----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
--MAP_SHOOTING_RANGE----------------------------------MAP_SHOOTING_RANGE------------------------------------------MAP_SHOOTING_RANGE--------------------------------------MAP_SHOOTING_RANGE----------------------
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

