--check if dflag needs the flag id (1,2,3) when not nil, atm its always using flags2 when creating it
local mg_player_vars = game.gameplay.mg_player_vars

powerups_table = {

	[MAP_COLOR_BATTLE] = {
		{	--get pts
			general = 	{ id = 1, name = "color bucket", catch_rad = POWERUP_CATCH_RADIUS_DEFAULT, snd_appear = SND_EVENT_BLDG_STAMP, snd_catch = "y_paint.wav" },
			creation = 	{ T_GENERAL, M_GENERAL_MAPWHO_THING, SAFE_NEUTRAL },
			location = 	function() return marker_to_coord3d(rndb(0,51)) end,
			drawinfo = 	{ min = 1855, max = 1855, turnChanger = 1, alpha = -16, shadow = true, dfflag = nil },
			movement = 	{ moving = true, startingY = 6, Ybounce_offset = 92, speed = 4 },
			timer = 	{ spawn_every_seconds = function() return 6 end, only_after_turn_x = -1, chance = 100, max_of_this_type = 5, cdr = 0, fade_after_turns = false },
			effect = 	function(catcher) Bucket_1(catcher) end,
		},
		{	--remove all enemy colors
			general = 	{ id = 2, name = "remove spray", catch_rad = POWERUP_CATCH_RADIUS_DEFAULT, snd_appear = SND_EVENT_BLDG_STAMP, snd_catch = "y_spray.wav" },
			creation = 	{ T_GENERAL, M_GENERAL_MAPWHO_THING, SAFE_NEUTRAL },
			location = 	function() return marker_to_coord3d(rndb(0,51)) end,
			drawinfo = 	{ min = 1856, max = 1856, turnChanger = 1, alpha = -16, shadow = true, dfflag = nil },
			movement = 	{ moving = true, startingY = 6, Ybounce_offset = 92, speed = 4 },
			timer = 	{ spawn_every_seconds = function() return 14 end, only_after_turn_x = -1, chance = 100, max_of_this_type = 2, cdr = 0, fade_after_turns = false },
			effect = 	function(catcher) Spray_1(catcher) end,
		},
		{	--convert all enemy colors
			general = 	{ id = 3, name = "color brush", catch_rad = POWERUP_CATCH_RADIUS_DEFAULT, snd_appear = SND_EVENT_BLDG_STAMP, snd_catch = "y_recolor.wav" },
			creation = 	{ T_GENERAL, M_GENERAL_MAPWHO_THING, SAFE_NEUTRAL },
			location = 	function() return marker_to_coord3d(rndb(0,51)) end,
			drawinfo = 	{ min = 1857, max = 1857, turnChanger = 1, alpha = -16, shadow = true, dfflag = nil },
			movement = 	{ moving = true, startingY = 6, Ybounce_offset = 92, speed = 4 },
			timer = 	{ spawn_every_seconds = function() return 19 end, only_after_turn_x = -1, chance = 100, max_of_this_type = 1, cdr = 0, fade_after_turns = false },
			effect = 	function(catcher) PaintOver_1(catcher) end,
		},
		{	--give speed to shaman for a while
			general = 	{ id = 4, name = "speed boots", catch_rad = POWERUP_CATCH_RADIUS_DEFAULT, snd_appear = SND_EVENT_BLDG_STAMP, snd_catch = "273_Stomp4.wav" },
			creation = 	{ T_GENERAL, M_GENERAL_MAPWHO_THING, SAFE_NEUTRAL },
			location = 	function() return marker_to_coord3d(rndb(0,51)) end,
			drawinfo = 	{ min = 1852, max = 1852, turnChanger = 1, alpha = -16, shadow = true, dfflag = nil },
			movement = 	{ moving = true, startingY = 6, Ybounce_offset = 92, speed = 4 },
			timer = 	{ spawn_every_seconds = function() return rndb(30, 40) end, only_after_turn_x = 12*30, chance = 100, max_of_this_type = 2, cdr = 0, fade_after_turns = false },
			effect = 	function(catcher) giveBloodlust(getShaman(catcher), rndb(10,15)) end,
		},
	},
	
	[MAP_NAVAL_WARFARE] = {
		{	--circle of fire that burns ships who touch it
			general = 	{ id = 1, name = "greek fire", catch_rad = POWERUP_CATCH_RADIUS_DEFAULT + 250, snd_appear = SND_EVENT_BLDG_STAMP, snd_catch = "15_chop1.wav" },
			creation = 	{ T_GENERAL, M_GENERAL_MAPWHO_THING, SAFE_NEUTRAL },
			location = 	function() return naval_water_c3d() end,
			drawinfo = 	{ min = 1858, max = 1858, turnChanger = 1, alpha = -16, shadow = false, dfflag = nil },
			movement = 	{ moving = false, startingY = 6, Ybounce_offset = 92, speed = 4 },
			timer = 	{ spawn_every_seconds = function() return rndb(3,26) end, only_after_turn_x = -1, chance = 100, max_of_this_type = 3, cdr = 0, fade_after_turns = false },
			effect = 	function(catcher) catch_powerup_3(catcher, 1) end,
		},
		{	--cannonballs refill faster for a while
			general = 	{ id = 2, name = "light iron", catch_rad = POWERUP_CATCH_RADIUS_DEFAULT + 250, snd_appear = SND_EVENT_BLDG_STAMP, snd_catch = "15_chop1.wav" },
			creation = 	{ T_GENERAL, M_GENERAL_MAPWHO_THING, SAFE_NEUTRAL },
			location = 	function() return naval_water_c3d() end,
			drawinfo = 	{ min = 1859, max = 1859, turnChanger = 1, alpha = -16, shadow = false, dfflag = nil },
			movement = 	{ moving = true, startingY = -64, Ybounce_offset = 52, speed = 3 },
			timer = 	{ spawn_every_seconds = function() return rndb(22,30) end, only_after_turn_x = -1, chance = 100, max_of_this_type = 2, cdr = 0, fade_after_turns = false },
			effect = 	function(catcher) catch_powerup_3(catcher, 2) end,
		},
		{	--cannonballs higher aoe and more damage for a while
			general = 	{ id = 3, name = "gun powder", catch_rad = POWERUP_CATCH_RADIUS_DEFAULT + 250, snd_appear = SND_EVENT_BLDG_STAMP, snd_catch = "15_chop1.wav" },
			creation = 	{ T_GENERAL, M_GENERAL_MAPWHO_THING, SAFE_NEUTRAL },
			location = 	function() return naval_water_c3d() end,
			drawinfo = 	{ min = 1860, max = 1860, turnChanger = 1, alpha = -16, shadow = false, dfflag = nil },
			movement = 	{ moving = true, startingY = -64, Ybounce_offset = 52, speed = 3 },
			timer = 	{ spawn_every_seconds = function() return rndb(22,30) end, only_after_turn_x = -1, chance = 100, max_of_this_type = 2, cdr = 0, fade_after_turns = false },
			effect = 	function(catcher) catch_powerup_3(catcher, 3) end,
		},
	},
	
	[MAP_POTION_BATTLE] = {
		{
			general = 	{ id = 1, name = "healing", catch_rad = POWERUP_CATCH_RADIUS_DEFAULT+32, snd_appear = SND_EVENT_BLDG_STAMP, snd_catch = "y_p_4.wav" },
			creation = 	{ T_GENERAL, M_GENERAL_MAPWHO_THING, SAFE_NEUTRAL },
			location = 	function() return potionbattle_potions_c3d() end,
			drawinfo = 	{ min = 2231, max = 2231, turnChanger = 1, alpha = -16, shadow = true, dfflag = nil },
			movement = 	{ moving = true, startingY = 16, Ybounce_offset = 64, speed = 2 },
			timer = 	{ spawn_every_seconds = function() return 0 end, only_after_turn_x = 22, chance = 80, max_of_this_type = 2, cdr = 2, fade_after_turns = 12*25 },
			effect = 	function(catcher) return PB_catch_potion(catcher, 1) end,
		},
		{
			general = 	{ id = 2, name = "success", catch_rad = POWERUP_CATCH_RADIUS_DEFAULT+32, snd_appear = SND_EVENT_BLDG_STAMP, snd_catch = "y_p_4.wav" },
			creation = 	{ T_GENERAL, M_GENERAL_MAPWHO_THING, SAFE_NEUTRAL },
			location = 	function() return potionbattle_potions_c3d() end,
			drawinfo = 	{ min = 2232, max = 2232, turnChanger = 1, alpha = -16, shadow = true, dfflag = nil },
			movement = 	{ moving = true, startingY = 16, Ybounce_offset = 64, speed = 2 },
			timer = 	{ spawn_every_seconds = function() return 0 end, only_after_turn_x = 33, chance = 80, max_of_this_type = 2, cdr = 3, fade_after_turns = 12*25 },
			effect = 	function(catcher) return PB_catch_potion(catcher, 2) end,
		},
		{
			general = 	{ id = 3, name = "anger", catch_rad = POWERUP_CATCH_RADIUS_DEFAULT+32, snd_appear = SND_EVENT_BLDG_STAMP, snd_catch = "y_p_4.wav" },
			creation = 	{ T_GENERAL, M_GENERAL_MAPWHO_THING, SAFE_NEUTRAL },
			location = 	function() return potionbattle_potions_c3d() end,
			drawinfo = 	{ min = 2233, max = 2233, turnChanger = 1, alpha = -16, shadow = true, dfflag = nil },
			movement = 	{ moving = true, startingY = 16, Ybounce_offset = 64, speed = 2 },
			timer = 	{ spawn_every_seconds = function() return 0 end, only_after_turn_x = 44, chance = 80, max_of_this_type = 2, cdr = 2, fade_after_turns = 12*25 },
			effect = 	function(catcher) return PB_catch_potion(catcher, 3) end,
		},
		{
			general = 	{ id = 4, name = "revenge", catch_rad = POWERUP_CATCH_RADIUS_DEFAULT+32, snd_appear = SND_EVENT_BLDG_STAMP, snd_catch = "y_p_4.wav" },
			creation = 	{ T_GENERAL, M_GENERAL_MAPWHO_THING, SAFE_NEUTRAL },
			location = 	function() return potionbattle_potions_c3d() end,
			drawinfo = 	{ min = 2234, max = 2234, turnChanger = 1, alpha = -16, shadow = true, dfflag = nil },
			movement = 	{ moving = true, startingY = 16, Ybounce_offset = 64, speed = 2 },
			timer = 	{ spawn_every_seconds = function() return 0 end, only_after_turn_x = 55, chance = 80, max_of_this_type = 2, cdr = 3, fade_after_turns = 12*25 },
			effect = 	function(catcher) return PB_catch_potion(catcher, 4) end,
		},
		{
			general = 	{ id = 5, name = "magic", catch_rad = POWERUP_CATCH_RADIUS_DEFAULT+32, snd_appear = SND_EVENT_BLDG_STAMP, snd_catch = "y_p_4.wav" },
			creation = 	{ T_GENERAL, M_GENERAL_MAPWHO_THING, SAFE_NEUTRAL },
			location = 	function() return potionbattle_potions_c3d() end,
			drawinfo = 	{ min = 2235, max = 2235, turnChanger = 1, alpha = -16, shadow = true, dfflag = nil },
			movement = 	{ moving = true, startingY = 16, Ybounce_offset = 64, speed = 2 },
			timer = 	{ spawn_every_seconds = function() return 0 end, only_after_turn_x = 22, chance = 80, max_of_this_type = 2, cdr = 2, fade_after_turns = 12*25 },
			effect = 	function(catcher) return PB_catch_potion(catcher, 5) end,
		},
		{
			general = 	{ id = 6, name = "anti-magic", catch_rad = POWERUP_CATCH_RADIUS_DEFAULT+32, snd_appear = SND_EVENT_BLDG_STAMP, snd_catch = "y_p_4.wav" },
			creation = 	{ T_GENERAL, M_GENERAL_MAPWHO_THING, SAFE_NEUTRAL },
			location = 	function() return potionbattle_potions_c3d() end,
			drawinfo = 	{ min = 2236, max = 2236, turnChanger = 1, alpha = -16, shadow = true, dfflag = nil },
			movement = 	{ moving = true, startingY = 16, Ybounce_offset = 64, speed = 2 },
			timer = 	{ spawn_every_seconds = function() return 0 end, only_after_turn_x = 33, chance = 80, max_of_this_type = 2, cdr = 3, fade_after_turns = 12*25 },
			effect = 	function(catcher) return PB_catch_potion(catcher, 6) end,
		},
		{
			general = 	{ id = 7, name = "fortune", catch_rad = POWERUP_CATCH_RADIUS_DEFAULT+32, snd_appear = SND_EVENT_BLDG_STAMP, snd_catch = "y_p_4.wav" },
			creation = 	{ T_GENERAL, M_GENERAL_MAPWHO_THING, SAFE_NEUTRAL },
			location = 	function() return potionbattle_potions_c3d() end,
			drawinfo = 	{ min = 2237, max = 2237, turnChanger = 1, alpha = -16, shadow = true, dfflag = nil },
			movement = 	{ moving = true, startingY = 16, Ybounce_offset = 64, speed = 2 },
			timer = 	{ spawn_every_seconds = function() return 0 end, only_after_turn_x = 44, chance = 80, max_of_this_type = 2, cdr = 2, fade_after_turns = 12*25 },
			effect = 	function(catcher) return PB_catch_potion(catcher, 7) end,
		},
		{
			general = 	{ id = 8, name = "virtue", catch_rad = POWERUP_CATCH_RADIUS_DEFAULT+32, snd_appear = SND_EVENT_BLDG_STAMP, snd_catch = "y_p_4.wav" },
			creation = 	{ T_GENERAL, M_GENERAL_MAPWHO_THING, SAFE_NEUTRAL },
			location = 	function() return potionbattle_potions_c3d() end,
			drawinfo = 	{ min = 2238, max = 2238, turnChanger = 1, alpha = -16, shadow = true, dfflag = nil },
			movement = 	{ moving = true, startingY = 16, Ybounce_offset = 64, speed = 2 },
			timer = 	{ spawn_every_seconds = function() return 0 end, only_after_turn_x = 55, chance = 80, max_of_this_type = 2, cdr = 3, fade_after_turns = 12*25 },
			effect = 	function(catcher) return PB_catch_potion(catcher, 8) end,
		},
		{
			general = 	{ id = 9, name = "darkness", catch_rad = POWERUP_CATCH_RADIUS_DEFAULT+32, snd_appear = SND_EVENT_BLDG_STAMP, snd_catch = "y_p_4.wav" },
			creation = 	{ T_GENERAL, M_GENERAL_MAPWHO_THING, SAFE_NEUTRAL },
			location = 	function() return potionbattle_potions_c3d() end,
			drawinfo = 	{ min = 2239, max = 2239, turnChanger = 1, alpha = -16, shadow = true, dfflag = nil },
			movement = 	{ moving = true, startingY = 16, Ybounce_offset = 64, speed = 2 },
			timer = 	{ spawn_every_seconds = function() return 0 end, only_after_turn_x = 22, chance = 80, max_of_this_type = 2, cdr = 2, fade_after_turns = 12*25 },
			effect = 	function(catcher) return PB_catch_potion(catcher, 9) end,
		},
		{
			general = 	{ id = 10, name = "vigor", catch_rad = POWERUP_CATCH_RADIUS_DEFAULT+32, snd_appear = SND_EVENT_BLDG_STAMP, snd_catch = "y_p_4.wav" },
			creation = 	{ T_GENERAL, M_GENERAL_MAPWHO_THING, SAFE_NEUTRAL },
			location = 	function() return potionbattle_potions_c3d() end,
			drawinfo = 	{ min = 2240, max = 2240, turnChanger = 1, alpha = -16, shadow = true, dfflag = nil },
			movement = 	{ moving = true, startingY = 16, Ybounce_offset = 64, speed = 2 },
			timer = 	{ spawn_every_seconds = function() return 0 end, only_after_turn_x = 33, chance = 80, max_of_this_type = 2, cdr = 3, fade_after_turns = 12*25 },
			effect = 	function(catcher) return PB_catch_potion(catcher, 10) end,
		},
		{
			general = 	{ id = 11, name = "stealth", catch_rad = POWERUP_CATCH_RADIUS_DEFAULT+32, snd_appear = SND_EVENT_BLDG_STAMP, snd_catch = "y_p_4.wav" },
			creation = 	{ T_GENERAL, M_GENERAL_MAPWHO_THING, SAFE_NEUTRAL },
			location = 	function() return potionbattle_potions_c3d() end,
			drawinfo = 	{ min = 2241, max = 2241, turnChanger = 1, alpha = -16, shadow = true, dfflag = nil },
			movement = 	{ moving = true, startingY = 16, Ybounce_offset = 64, speed = 2 },
			timer = 	{ spawn_every_seconds = function() return 0 end, only_after_turn_x = 44, chance = 80, max_of_this_type = 2, cdr = 2, fade_after_turns = 12*25 },
			effect = 	function(catcher) return PB_catch_potion(catcher, 11) end,
		},
		{
			general = 	{ id = 12, name = "skill", catch_rad = POWERUP_CATCH_RADIUS_DEFAULT+32, snd_appear = SND_EVENT_BLDG_STAMP, snd_catch = "y_p_4.wav" },
			creation = 	{ T_GENERAL, M_GENERAL_MAPWHO_THING, SAFE_NEUTRAL },
			location = 	function() return potionbattle_potions_c3d() end,
			drawinfo = 	{ min = 2242, max = 2242, turnChanger = 1, alpha = -16, shadow = true, dfflag = nil },
			movement = 	{ moving = true, startingY = 16, Ybounce_offset = 64, speed = 2 },
			timer = 	{ spawn_every_seconds = function() return 0 end, only_after_turn_x = 55, chance = 80, max_of_this_type = 2, cdr = 3, fade_after_turns = 12*25 },
			effect = 	function(catcher) return PB_catch_potion(catcher, 12) end,
		},
		{
			general = 	{ id = 13, name = "paranoid", catch_rad = POWERUP_CATCH_RADIUS_DEFAULT+32, snd_appear = SND_EVENT_BLDG_STAMP, snd_catch = "y_p_4.wav" },
			creation = 	{ T_GENERAL, M_GENERAL_MAPWHO_THING, SAFE_NEUTRAL },
			location = 	function() return potionbattle_potions_c3d() end,
			drawinfo = 	{ min = 2243, max = 2243, turnChanger = 1, alpha = -16, shadow = true, dfflag = nil },
			movement = 	{ moving = true, startingY = 16, Ybounce_offset = 64, speed = 2 },
			timer = 	{ spawn_every_seconds = function() return 0 end, only_after_turn_x = 33, chance = 80, max_of_this_type = 2, cdr = 2, fade_after_turns = 12*25 },
			effect = 	function(catcher) return PB_catch_potion(catcher, 13) end,
		}
	},
	
	[MAP_TECTONIC] = {
		{	--jump
			general = 	{ id = 1, name = "jump", catch_rad = POWERUP_CATCH_RADIUS_DEFAULT + 64, snd_appear = SND_EVENT_BLDG_STAMP, snd_catch = "15_chop1.wav" },
			creation = 	{ T_GENERAL, M_GENERAL_MAPWHO_THING, SAFE_NEUTRAL },
			location = 	function() return TK_land_c3d(true) end,
			drawinfo = 	{ min = 1834, max = 1834, turnChanger = 1, alpha = -16, shadow = true, dfflag = nil },
			movement = 	{ moving = true, startingY = 32, Ybounce_offset = 92, speed = 4 },
			timer = 	{ spawn_every_seconds = function() return rndb(4, 8) end, only_after_turn_x = -1, chance = 100, max_of_this_type = 2, cdr = 0, fade_after_turns = 12*20 },
			effect = 	function(catcher) GIVE_ONE_SHOT(M_SPELL_CONVERT_WILD, catcher) end,
		},
		{	--blast
			general = 	{ id = 2, name = "blast", catch_rad = POWERUP_CATCH_RADIUS_DEFAULT + 64, snd_appear = SND_EVENT_BLDG_STAMP, snd_catch = "15_chop1.wav" },
			creation = 	{ T_GENERAL, M_GENERAL_MAPWHO_THING, SAFE_NEUTRAL },
			location = 	function() return TK_land_c3d(true) end,
			drawinfo = 	{ min = 391, max = 391, turnChanger = 1, alpha = -16, shadow = true, dfflag = nil },
			movement = 	{ moving = true, startingY = 32, Ybounce_offset = 92, speed = 4 },
			timer = 	{ spawn_every_seconds = function() return rndb(5, 10) end, only_after_turn_x = -1, chance = 100, max_of_this_type = 1, cdr = 0, fade_after_turns = 12*20 },
			effect = 	function(catcher) GIVE_ONE_SHOT(M_SPELL_BLAST, catcher) end,
		}
	},
	
	[MAP_TILES_WAR] = {
		{	--light
			general = 	{ id = 1, name = "light", catch_rad = POWERUP_CATCH_RADIUS_DEFAULT + 64, snd_appear = SND_EVENT_BLDG_STAMP, snd_catch = "15_chop1.wav" },
			creation = 	{ T_GENERAL, M_GENERAL_MAPWHO_THING, SAFE_NEUTRAL },
			location = 	function() return TW_powerup_c3d() end,
			drawinfo = 	{ min = 356, max = 356, turnChanger = 1, alpha = -16, shadow = true, dfflag = nil },
			movement = 	{ moving = true, startingY = 32, Ybounce_offset = 92, speed = 4 },
			timer = 	{ spawn_every_seconds = function() return rndb(2, 4) end, only_after_turn_x = -1, chance = 100, max_of_this_type = 6, cdr = 0, fade_after_turns = 12*20 },
			effect = 	function(catcher) TW_give_spell(catcher, M_SPELL_LIGHTNING_BOLT) end,
		},
		{	--tornado
			general = 	{ id = 2, name = "tornado", catch_rad = POWERUP_CATCH_RADIUS_DEFAULT + 64, snd_appear = SND_EVENT_BLDG_STAMP, snd_catch = "15_chop1.wav" },
			creation = 	{ T_GENERAL, M_GENERAL_MAPWHO_THING, SAFE_NEUTRAL },
			location = 	function() return TW_powerup_c3d() end,
			drawinfo = 	{ min = 357, max = 357, turnChanger = 1, alpha = -16, shadow = true, dfflag = nil },
			movement = 	{ moving = true, startingY = 32, Ybounce_offset = 92, speed = 4 },
			timer = 	{ spawn_every_seconds = function() return rndb(8, 16) end, only_after_turn_x = -1, chance = 100, max_of_this_type = 3, cdr = 0, fade_after_turns = 12*20 },
			effect = 	function(catcher) TW_give_spell(catcher, M_SPELL_WHIRLWIND) end,
		},
		{	--give speed to shaman for a while
			general = 	{ id = 3, name = "speed boots", catch_rad = POWERUP_CATCH_RADIUS_DEFAULT, snd_appear = SND_EVENT_BLDG_STAMP, snd_catch = "273_Stomp4.wav" },
			creation = 	{ T_GENERAL, M_GENERAL_MAPWHO_THING, SAFE_NEUTRAL },
			location = 	function() return TW_powerup_c3d() end,
			drawinfo = 	{ min = 1852, max = 1852, turnChanger = 1, alpha = -16, shadow = true, dfflag = nil },
			movement = 	{ moving = true, startingY = 6, Ybounce_offset = 92, speed = 4 },
			timer = 	{ spawn_every_seconds = function() return rndb(10, 20) end, only_after_turn_x = 12*15, chance = 100, max_of_this_type = 1, cdr = 0, fade_after_turns = 12*20 },
			effect = 	function(catcher) giveBloodlust(getShaman(catcher), rndb(8,10)) end,
		},
	},
	
	[MAP_TESLA_COIL] = {
		{	--turbo
			general = 	{ id = 1, name = "turbo", catch_rad = POWERUP_CATCH_RADIUS_DEFAULT + 64, snd_appear = SND_EVENT_BLDG_STAMP, snd_catch = "15_chop1.wav" },
			creation = 	{ T_GENERAL, M_GENERAL_MAPWHO_THING, SAFE_NEUTRAL },
			location = 	function() return TC_powerup_c3d() end,
			drawinfo = 	{ min = 90, max = 93, turnChanger = 1, alpha = -16, shadow = false, dfflag = nil },
			movement = 	{ moving = false, startingY = 4, Ybounce_offset = 92, speed = 5 },
			timer = 	{ spawn_every_seconds = function() return rndb(12, 16) end, only_after_turn_x = 60, chance = 100, max_of_this_type = 2, cdr = 0, fade_after_turns = 12*20 },
			effect = 	function(catcher) TC_give_turbo(catcher) end,
		},
	},
	
	[MAP_WOOD_BEARERS] = {
		{	--invi
			general = 	{ id = 1, name = "invi", catch_rad = POWERUP_CATCH_RADIUS_DEFAULT + 64, snd_appear = SND_EVENT_BLDG_STAMP, snd_catch = "15_chop1.wav" },
			creation = 	{ T_GENERAL, M_GENERAL_MAPWHO_THING, SAFE_NEUTRAL },
			location = 	function() return WE_powerup_c3d() end,
			drawinfo = 	{ min = 395, max = 395, turnChanger = 1, alpha = -16, shadow = false, dfflag = nil },
			movement = 	{ moving = true, startingY = 16, Ybounce_offset = 92, speed = 4 },
			timer = 	{ spawn_every_seconds = function() return rndb(16, 32) end, only_after_turn_x = 60, chance = 100, max_of_this_type = 2, cdr = 0, fade_after_turns = 12*25 },
			effect = 	function(catcher) giveInvisibility(getShaman(catcher), 6) end,
		},
		{	--bloodlust
			general = 	{ id = 2, name = "bloodlust", catch_rad = POWERUP_CATCH_RADIUS_DEFAULT + 64, snd_appear = SND_EVENT_BLDG_STAMP, snd_catch = "15_chop1.wav" },
			creation = 	{ T_GENERAL, M_GENERAL_MAPWHO_THING, SAFE_NEUTRAL },
			location = 	function() return WE_powerup_c3d() end,
			drawinfo = 	{ min = 415, max = 415, turnChanger = 1, alpha = -16, shadow = false, dfflag = nil },
			movement = 	{ moving = true, startingY = 16, Ybounce_offset = 92, speed = 4 },
			timer = 	{ spawn_every_seconds = function() return rndb(16, 32) end, only_after_turn_x = 60, chance = 100, max_of_this_type = 2, cdr = 0, fade_after_turns = 12*25 },
			effect = 	function(catcher) giveBloodlust(getShaman(catcher), 10) end,
		},
	},
	
	[MAP_QUAKE_ARENA] = {
		{	--grenade
			general = 	{ id = 1, name = "grenade", catch_rad = POWERUP_CATCH_RADIUS_DEFAULT + 64, snd_appear = SND_EVENT_BLDG_STAMP, snd_catch = "83_Invis.wav" },
			creation = 	{ T_GENERAL, M_GENERAL_MAPWHO_THING, SAFE_NEUTRAL },
			location = 	function() return QA_powerup_c3d() end,
			drawinfo = 	{ min = 1058, max = 1058, turnChanger = 1, alpha = -16, shadow = false, dfflag = nil },
			movement = 	{ moving = false, startingY = 192, Ybounce_offset = 64, speed = 6 },
			timer = 	{ spawn_every_seconds = function() return 30 end, only_after_turn_x = -1, chance = 100, max_of_this_type = 1, cdr = 0, fade_after_turns = false },
			effect = 	function(catcher) GIVE_ONE_SHOT(M_SPELL_BLAST, catcher) if nilS(catcher) then for i = 1, 3 do createThing(T_EFFECT, M_EFFECT_ORBITER, SAFE_NEUTRAL, getShaman(catcher).Pos.D3, false, false) end end end,
		},
		{	--shield
			general = 	{ id = 2, name = "shield", catch_rad = POWERUP_CATCH_RADIUS_DEFAULT + 64, snd_appear = SND_EVENT_BLDG_STAMP, snd_catch = "83_Invis.wav" },
			creation = 	{ T_GENERAL, M_GENERAL_MAPWHO_THING, SAFE_NEUTRAL },
			location = 	function() return QA_powerup_c3d() end,
			drawinfo = 	{ min = 682, max = 682, turnChanger = 1, alpha = -16, shadow = false, dfflag = nil },
			movement = 	{ moving = false, startingY = 192, Ybounce_offset = 64, speed = 6 },
			timer = 	{ spawn_every_seconds = function() return 30 end, only_after_turn_x = 60, chance = 100, max_of_this_type = 1, cdr = 0, fade_after_turns = false },
			effect = 	function(catcher) if nilS(catcher) then giveShield(getShaman(catcher), 15) for i = 1, 3 do createThing(T_EFFECT, M_EFFECT_ORBITER, SAFE_NEUTRAL, getShaman(catcher).Pos.D3, false, false) end end end,
		},
	},

	[MAP_JUMPERS] = {
		{	--shield
			general = 	{ id = 1, name = "shield", catch_rad = POWERUP_CATCH_RADIUS_DEFAULT + 64, snd_appear = SND_EVENT_BLDG_STAMP, snd_catch = "83_Invis.wav" },
			creation = 	{ T_GENERAL, M_GENERAL_MAPWHO_THING, SAFE_NEUTRAL },
			location = 	function() return marker_to_coord3d(rndb(0, 8)) end,
			drawinfo = 	{ min = 410, max = 410, turnChanger = 1, alpha = -16, shadow = true, dfflag = nil },
			movement = 	{ moving = true, startingY = 64, Ybounce_offset = 64, speed = 6 },
			timer = 	{ spawn_every_seconds = function() return rndb(25,30) end, only_after_turn_x = 12*12, chance = 100, max_of_this_type = 1, cdr = 12*5, fade_after_turns = false },
			effect = 	function(catcher) if nilS(catcher) then giveShield(getShaman(catcher), 12) end end,
		},
		{	--torn
			general = 	{ id = 2, name = "torn", catch_rad = POWERUP_CATCH_RADIUS_DEFAULT + 64, snd_appear = SND_EVENT_BLDG_STAMP, snd_catch = "83_Invis.wav" },
			creation = 	{ T_GENERAL, M_GENERAL_MAPWHO_THING, SAFE_NEUTRAL },
			location = 	function() return marker_to_coord3d(rndb(0, 8)) end,
			drawinfo = 	{ min = 393, max = 393, turnChanger = 1, alpha = -16, shadow = true, dfflag = nil },
			movement = 	{ moving = true, startingY = 64, Ybounce_offset = 64, speed = 6 },
			timer = 	{ spawn_every_seconds = function() return rndb(25,30) end, only_after_turn_x = 12*10, chance = 100, max_of_this_type = 1, cdr = 12*5, fade_after_turns = false },
			effect = 	function(catcher) GIVE_ONE_SHOT(M_SPELL_WHIRLWIND, catcher) end,
		},
	},
	
	[MAP_PAINTBALL] = {
		{	--shield
			general = 	{ id = 1, name = "shield", catch_rad = POWERUP_CATCH_RADIUS_DEFAULT + 256, snd_appear = SND_EVENT_BLDG_STAMP, snd_catch = "83_Invis.wav" },
			creation = 	{ T_GENERAL, M_GENERAL_MAPWHO_THING, SAFE_NEUTRAL },
			location = 	function() return PA_pup_c3d() end,
			drawinfo = 	{ min = 414, max = 414, turnChanger = 1, alpha = -16, shadow = true, dfflag = nil },
			movement = 	{ moving = true, startingY = 128, Ybounce_offset = 64, speed = 4 },
			timer = 	{ spawn_every_seconds = function() return rndb(12,24) end, only_after_turn_x = 12*2, chance = 100, max_of_this_type = 2, cdr = 12*5, fade_after_turns = false },
			effect = 	function(catcher) if nilS(catcher) then giveShield(getShaman(catcher), 12) end end,
		},
		{	--hp
			general = 	{ id = 2, name = "hp", catch_rad = POWERUP_CATCH_RADIUS_DEFAULT + 256, snd_appear = SND_EVENT_BLDG_STAMP, snd_catch = "83_Invis.wav" },
			creation = 	{ T_GENERAL, M_GENERAL_MAPWHO_THING, SAFE_NEUTRAL },
			location = 	function() return PA_pup_c3d() end,
			drawinfo = 	{ min = 2428, max = 2428, turnChanger = 1, alpha = -16, shadow = true, dfflag = nil },
			movement = 	{ moving = true, startingY = 128, Ybounce_offset = 64, speed = 4 },
			timer = 	{ spawn_every_seconds = function() return rndb(12,24) end, only_after_turn_x = 12*2, chance = 100, max_of_this_type = 2, cdr = 12*5, fade_after_turns = false },
			effect = 	function(catcher) if nilS(catcher) then local curr_max = mg_player_vars[catcher].maxhp if curr_max < 2000 then local new_max = math.min(2000, curr_max + 500) mg_player_vars[catcher].maxhp = new_max getShaman(catcher).u.Pers.Life = new_max end end end,
		},
		{	--speed
			general = 	{ id = 3, name = "speed", catch_rad = POWERUP_CATCH_RADIUS_DEFAULT + 256, snd_appear = SND_EVENT_BLDG_STAMP, snd_catch = "83_Invis.wav" },
			creation = 	{ T_GENERAL, M_GENERAL_MAPWHO_THING, SAFE_NEUTRAL },
			location = 	function() return PA_pup_c3d() end,
			drawinfo = 	{ min = 1852, max = 1852, turnChanger = 1, alpha = -16, shadow = true, dfflag = nil },
			movement = 	{ moving = true, startingY = 128, Ybounce_offset = 64, speed = 4 },
			timer = 	{ spawn_every_seconds = function() return rndb(12,24) end, only_after_turn_x = 12*2, chance = 100, max_of_this_type = 2, cdr = 12*5, fade_after_turns = false },
			effect = 	function(catcher) if nilS(catcher) then giveBloodlust(getShaman(catcher), 12) end end,
		},
		{	--damage
			general = 	{ id = 4, name = "damage", catch_rad = POWERUP_CATCH_RADIUS_DEFAULT + 256, snd_appear = SND_EVENT_BLDG_STAMP, snd_catch = "83_Invis.wav" },
			creation = 	{ T_GENERAL, M_GENERAL_MAPWHO_THING, SAFE_NEUTRAL },
			location = 	function() return PA_pup_c3d() end,
			drawinfo = 	{ min = 1855, max = 1855, turnChanger = 1, alpha = -16, shadow = true, dfflag = nil },
			movement = 	{ moving = true, startingY = 128, Ybounce_offset = 64, speed = 4 },
			timer = 	{ spawn_every_seconds = function() return rndb(12,24) end, only_after_turn_x = 12*2, chance = 100, max_of_this_type = 2, cdr = 12*5, fade_after_turns = false },
			effect = 	function(catcher) mg_player_vars[catcher].high_dmg = math.min(12*20, mg_player_vars[catcher].high_dmg + 12*20) end,
		},
		{	--atk1
			general = 	{ id = 5, name = "atk1", catch_rad = POWERUP_CATCH_RADIUS_DEFAULT + 256, snd_appear = SND_EVENT_BLDG_STAMP, snd_catch = nil },
			creation = 	{ T_GENERAL, M_GENERAL_MAPWHO_THING, SAFE_NEUTRAL },
			location = 	function() return PA_pup_c3d() end,
			drawinfo = 	{ min = 2517, max = 2517, turnChanger = 1, alpha = -16, shadow = true, dfflag = nil },
			movement = 	{ moving = true, startingY = 128, Ybounce_offset = 64, speed = 4 },
			timer = 	{ spawn_every_seconds = function() return rndb(6,12) end, only_after_turn_x = 12*2, chance = 100, max_of_this_type = 3, cdr = 12*2, fade_after_turns = false },
			effect = 	function(catcher) PA_atk1(catcher) end,
		},
		{	--atk2
			general = 	{ id = 6, name = "atk2", catch_rad = POWERUP_CATCH_RADIUS_DEFAULT + 256, snd_appear = SND_EVENT_BLDG_STAMP, snd_catch = "83_Invis.wav" },
			creation = 	{ T_GENERAL, M_GENERAL_MAPWHO_THING, SAFE_NEUTRAL },
			location = 	function() return PA_pup_c3d() end,
			drawinfo = 	{ min = 2511, max = 2511, turnChanger = 1, alpha = -16, shadow = true, dfflag = nil },
			movement = 	{ moving = true, startingY = 128, Ybounce_offset = 64, speed = 4 },
			timer = 	{ spawn_every_seconds = function() return rndb(6,12) end, only_after_turn_x = 12*2, chance = 100, max_of_this_type = 3, cdr = 12*5, fade_after_turns = false },
			effect = 	function(catcher) mg_player_vars[catcher].atk2 = 12*15 end,
		},
	},
	
	[MAP_ICE_ARENA] = {
		{	--Essential oil
			general = 	{ id = 1, name = "Essential oil", catch_rad = POWERUP_CATCH_RADIUS_DEFAULT + 256, snd_appear = SND_EVENT_BLDG_STAMP, snd_catch = "83_Invis.wav" },
			creation = 	{ T_GENERAL, M_GENERAL_MAPWHO_THING, SAFE_NEUTRAL },
			location = 	function() return IA_pup_c3d() end,
			drawinfo = 	{ min = 2420, max = 2420, turnChanger = 1, alpha = -16, shadow = true, dfflag = nil },
			movement = 	{ moving = true, startingY = 32, Ybounce_offset = 16, speed = 2 },
			timer = 	{ spawn_every_seconds = function() return rndb(20,30) end, only_after_turn_x = -1, chance = 100, max_of_this_type = 1, cdr = 12*2, fade_after_turns = false },
			effect = 	function(catcher) if nilS(catcher) then mg_player_vars[catcher].oiled = 12*10 end end,
		},
		{	--time freeze
			general = 	{ id = 2, name = "time freeze", catch_rad = POWERUP_CATCH_RADIUS_DEFAULT + 256, snd_appear = SND_EVENT_BLDG_STAMP, snd_catch = "83_Invis.wav" },
			creation = 	{ T_GENERAL, M_GENERAL_MAPWHO_THING, SAFE_NEUTRAL },
			location = 	function() return IA_pup_c3d() end,
			drawinfo = 	{ min = 1940, max = 1940, turnChanger = 1, alpha = -16, shadow = true, dfflag = nil },
			movement = 	{ moving = true, startingY = 32, Ybounce_offset = 16, speed = 2 },
			timer = 	{ spawn_every_seconds = function() return rndb(20,30) end, only_after_turn_x = -1, chance = 100, max_of_this_type = 1, cdr = 12*2, fade_after_turns = false },
			effect = 	function(catcher) IA_time_freeze(catcher) end,
		},
	},

}