--[[

how to implement a map:

- open map in multiverse editor
- set players to 4 and remove 4+p objects
- save as level 2
- create a .ini file in mv
- open it in MV launcher, with the script that i add at the end of this tutorial
- open said level in mv game, and press "1" to save the non-water coordinates (they get saved as.: state = x, name = z, value = height)
- close level, and create a table out of it. bulk edit it eg.:

					[0]
					179=325
					208=1013
					211=1013
					[1]
					158=1156
					161=1156
					170=444

					becomes:

					[0],{
					179,325,
					208,1013,
					211,1013,
					},[1]={
					158,1156,
					161,1156,
					170,444,
					}

					what happened is: (bulk)

					- replace [ with },[
					- replace = with ,
					- replace ] with ]={
					
								- replace {, with { NOT NEEDED!!!
								- add , at end of every line (shift+alt, select start and end, move to end of line)
					- even better, replace $ with , (using regular expression mode)!!!
					
					- replace {, with {
					
								- replace { with { (careful, add some spaces between "{ ,"and repeat some times (no need if use expression mode))
					- check start and end of file, and do finish touches if needed
					*decorations and 4+p objects dont open in MV, so remove them first and add them manually later*
					https://unminifyall.com/unminify-lua-minifier/

- the functions used in mv:

					IniReader.SetPath("\\mgg.ini")
					IniWriter.SetPath("\\mgg.ini")


					for i = 0, 3 do SET_NO_REINC(i) end

					function get_map(key)
						if key == 1 then
							for i = 0, 255, 1 do
								local section = tostring(i)
							
								for j = 0, 255, 1 do
									local string_z = tostring(j)
									land_h(i, j, string_z, section)
								end
							end
						elseif key == 2 then
							for i = 0, 255, 2 do
								local section = tostring(i)
							
								for j = 0, 255, 2 do
									local string_z = tostring(j)
									objects(i, j, string_z, section)
								end
							end
						else
							get_markers()
						end
					end

					function get_markers()
						for i = 0, 5 do
							local mk = MapPosXZ.new()
							mk = MARKER_IDX_2_MAP_XZ(i)
						end
						
						--MARKER_IDX_2_MAP_XZ
						--marker_to_coord3d
					end

					function land_h(x, z, z_string, section)
						local m = MapPosXZ.new()
						m.XZ.X = x
						m.XZ.Z = z
						
						ProcessMap(SQUARE , 0, 0, 0, m.Pos, function(me)
							local alt = me.Alt
							
							if alt > 0 then
								IniWriter.WriteInteger(section, z_string, alt)
							end
						return true end)
					end

					function objects(x, z, z_string, section)
						local m = MapPosXZ.new()
						m.XZ.X = x
						m.XZ.Z = z
						
						ProcessMap(SQUARE , 0, 0, 0, m.Pos, function(me)
							ProcessMapWho(me, function(t)
								local type = t.Type
								
								if type <= T_EFFECT then
									if type ~= T_GENERAL then
										local model = t.Model
										local owner = t.Owner
										local angle = t.AngleXZ
										local str = string.format("%s,%s,%s,%s", type, model, owner, angle)
										
										IniWriter.WriteString(section, z_string, str)
									end
								end
								
							return true end)
						return true end)
					end

					function OnKeyUp(key) if key >= 2 and (key <= 4) then get_map(key - 1) end
						return false
					end
					
do a similar thing, but for objects on each coordinate, instead of land points.
at end, add important info to the right tables, such as shamans starting locations, and any other releavant things.
in complex maps such as boat races, you will have to add stuff such as timed triggers through scripts, manually. to make it easier, first remove any effect that is from a trigger, then save the map objects. then manually script the triggered effects.
after everything is set up, implementing a new map is a matter of a minute or two. some more minutes if map has triggers/events that require manual editing.

]]

-- !!! ENSURE NO MIDDLE MARKERS ARE IN COORDS 0,0 !!!
-- decorations (x,z,idx,angle)
--M, L,, obj name reference
_decorations = {
					{19,32}, --shield 1
					{19,51}, --windmill 2
					{19,52}, --wooden hut 3
					{19,53}, --well 4
					{19,13}, --tree 1
					{19,21}, --garg 3
					{19,8}, --obelisk 7
					{19,143}, --boat 8
					{19,79}, --tower blue 9
					{19,80}, --tower red 10
					{19,81}, --tower yell 11
					{19,82}, --tower green 12
}

---------------------------------------------------------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------------------------------------
-- duration / points / rounds

map_list = {
	
	[MAP_BOAT_RACE_I]={
	
		info = { 	name = "Boat Race 1", author = "Toxicity & Zyraw",
					desc = "In the original boat race, players must traverse a winding course filled with treacherous fire storms and swamp riddled paths. <br> With multiple opportunities to hinder opponents with a variety of collectible spells, reaching the finish line just once can be considered an achievement. <p> - Gain a random spell when passing through particle effects. <p> - A new Blast spell on the Convert slot will direct blast every player on the map. <p> - Starting and Finish areas are no Spell zones, indicated by a line of clouds. <p> - When stuck, use the Teleport Spell to restart from the beginning.",
					map_objectives = { {value=10, limit=30, step=5, default=false}, {value=3, step=1, limit=10, default=true}, {} },
					image = 2576, texture={2,0}, zoom={94,56,1024}, drop_infos = true, marker_lb={18,102}, reinc_timer=12*1, shield_respawn=false, optional_shaman_zoom_angle = 1024,
					custom_rules = {
						{ default = false, 	name = "Fast boats", desc = "Boats are twice as fast." },
						{ default = false, 	name = "No S clicks", desc = "S clicks (on shamans or boats) won't follow shamans/boats. You can still blast your own boat." },
					}
				},

		land ={
			[0]={158,1156,159,1156,160,1156,161,1156,170,444 ,171,444 ,172,641 ,173,641 ,174,641 ,175,641 ,176,533 ,177,533 ,178,325 ,179,325 ,208,1013,209,1013,210,1013,211,1013,},[1]={ 158,1156,159,1156,160,1156,161,1156,170,444 ,171,444 ,172,641 ,173,641 ,174,641 ,175,641 ,176,533 ,177,533 ,178,325 ,179,325 ,208,1013,209,1013,210,1013,211,1013,},[2]={ 158,1156,159,1156,160,1156,161,1156,170,518 ,171,518 ,172,641 ,173,641 ,174,641 ,175,641 ,176,533 ,177,533 ,178,247 ,179,247 ,208,1013,209,1013,210,1013,211,1013,},[3]={ 158,1156,159,1156,160,1156,161,1156,170,518 ,171,518 ,172,641 ,173,641 ,174,641 ,175,641 ,176,533 ,177,533 ,178,247 ,179,247 ,208,1013,209,1013,210,1013,211,1013,},[4]={ 158,1155,159,1155,160,1155,161,1155,170,502 ,171,502 ,172,569 ,173,569 ,174,542 ,175,542 ,176,416 ,177,416 ,208,1013,209,1013,210,1013,211,1013,},[5]={ 158,1155,159,1155,160,1155,161,1155,170,502 ,171,502 ,172,569 ,173,569 ,174,542 ,175,542 ,176,416 ,177,416 ,208,1013,209,1013,210,1013,211,1013,},[6]={ 158,1153,159,1153,160,1153,161,1153,170,462 ,171,462 ,172,542 ,173,542 ,174,510 ,175,510 ,176,312 ,177,312 ,208,1013,209,1013,210,1013,211,1013,},[7]={ 158,1153,159,1153,160,1153,161,1153,170,462 ,171,462 ,172,542 ,173,542 ,174,510 ,175,510 ,176,312 ,177,312 ,208,1013,209,1013,210,1013,211,1013,},[8]={ 158,1150,159,1150,160,1150,161,1150,170,429 ,171,429 ,172,483 ,173,483 ,174,353 ,175,353 ,208,1013,209,1013,210,1013,211,1013,},[9]={ 158,1150,159,1150,160,1150,161,1150,170,429 ,171,429 ,172,483 ,173,483 ,174,353 ,175,353 ,208,1013,209,1013,210,1013,211,1013,},[10]={ 158,1144,159,1144,160,1144,161,1144,170,234 ,171,234 ,172,234 ,173,234 ,208,1013,209,1013,210,1013,211,1013,},[11]={ 158,1144,159,1144,160,1144,161,1144,170,234 ,171,234 ,172,234 ,173,234 ,208,1013,209,1013,210,1013,211,1013,},[12]={ 158,1131,159,1131,160,1131,161,1131,208,1013,209,1013,210,1013,211,1013,},[13]={ 158,1131,159,1131,160,1131,161,1131,208,1013,209,1013,210,1013,211,1013,},[14]={ 158,1131,159,1131,160,1131,161,1131,208,1013,209,1013,210,1013,211,1013,},[15]={ 158,1131,159,1131,160,1131,161,1131,208,1013,209,1013,210,1013,211,1013,},[16]={ 158,1131,159,1131,160,1131,161,1131,208,1013,209,1013,210,1013,211,1013,},[17]={ 158,1131,159,1131,160,1131,161,1131,208,1013,209,1013,210,1013,211,1013,},[18]={ 158,1131,159,1131,160,1131,161,1131,206,1013,207,1013,208,1013,209,1013,210,1013,211,1013,},[19]={ 158,1131,159,1131,160,1131,161,1131,206,1013,207,1013,208,1013,209,1013,210,1013,211,1013,},[20]={ 158,1131,159,1131,160,1131,161,1131,186,1072,187,1072,188,1062,189,1062,190,1051,191,1051,192,1045,193,1045,194,1036,195,1036,196,1031,197,1031,198,1022,199,1022,200,1018,201,1018,202,1016,203,1016,204,1011,205,1011,206,1013,207,1013,208,1013,209,1013,},[21]={ 158,1131,159,1131,160,1131,161,1131,186,1072,187,1072,188,1062,189,1062,190,1051,191,1051,192,1045,193,1045,194,1036,195,1036,196,1031,197,1031,198,1022,199,1022,200,1018,201,1018,202,1016,203,1016,204,1011,205,1011,206,1013,207,1013,208,1013,209,1013,},[22]={ 158,1131,159,1131,160,1131,161,1131,162,130 ,163,130 ,164,143 ,165,143 ,166,143 ,167,143 ,184,1091,185,1091,186,1072,187,1072,188,1062,189,1062,190,1051,191,1051,192,1045,193,1045,194,1036,195,1036,196,1031,197,1031,198,1022,199,1022,200,1018,201,1018,202,1016,203,1016,204,1011,205,1011,206,1011,207,1011,},[23]={ 158,1131,159,1131,160,1131,161,1131,162,130 ,163,130 ,164,143 ,165,143 ,166,143 ,167,143 ,184,1091,185,1091,186,1072,187,1072,188,1062,189,1062,190,1051,191,1051,192,1045,193,1045,194,1036,195,1036,196,1031,197,1031,198,1022,199,1022,200,1018,201,1018,202,1016,203,1016,204,1011,205,1011,206,1011,207,1011,},[24]={ 158,1131,159,1131,160,1131,161,1131,162,130 ,163,130 ,164,143 ,165,143 ,166,143 ,167,143 ,182,1091,183,1091,184,1091,185,1091,186,1091,187,1091,},[25]={ 158,1131,159,1131,160,1131,161,1131,162,130 ,163,130 ,164,143 ,165,143 ,166,143 ,167,143 ,182,1091,183,1091,184,1091,185,1091,186,1091,187,1091,},[26]={ 158,1131,159,1131,160,1131,161,1131,162,143 ,163,143 ,164,143 ,165,143 ,166,143 ,167,143 ,180,1090,181,1090,182,1091,183,1091,184,1091,185,1091,},[27]={ 158,1131,159,1131,160,1131,161,1131,162,143 ,163,143 ,164,143 ,165,143 ,166,143 ,167,143 ,180,1090,181,1090,182,1091,183,1091,184,1091,185,1091,},[28]={ 158,1131,159,1131,160,1131,161,1131,162,143 ,163,143 ,164,143 ,165,143 ,166,143 ,167,143 ,178,1085,179,1085,180,1090,181,1090,182,1090,183,1090,},[29]={ 158,1131,159,1131,160,1131,161,1131,162,143 ,163,143 ,164,143 ,165,143 ,166,143 ,167,143 ,178,1085,179,1085,180,1090,181,1090,182,1090,183,1090,},[30]={ 158,1131,159,1131,160,1131,161,1131,162,143 ,163,143 ,164,143 ,165,143 ,166,143 ,167,143 ,176,1092,177,1092,178,1085,179,1085,180,1085,181,1085,},[31]={ 158,1131,159,1131,160,1131,161,1131,162,143 ,163,143 ,164,143 ,165,143 ,166,143 ,167,143 ,176,1092,177,1092,178,1085,179,1085,180,1085,181,1085,},[32]={ 158,1131,159,1131,160,1131,161,1131,162,156 ,163,156 ,164,156 ,165,156 ,166,156 ,167,156 ,176,1092,177,1092,178,1092,179,1092,},[33]={ 158,1131,159,1131,160,1131,161,1131,162,156 ,163,156 ,164,156 ,165,156 ,166,156 ,167,156 ,176,1092,177,1092,178,1092,179,1092,},[34]={ 158,1131,159,1131,160,1131,161,1131,162,156 ,163,156 ,164,156 ,165,156 ,166,156 ,167,156 ,176,1092,177,1092,178,1092,179,1092,},[35]={ 158,1131,159,1131,160,1131,161,1131,162,156 ,163,156 ,164,156 ,165,156 ,166,156 ,167,156 ,176,1092,177,1092,178,1092,179,1092,},[36]={ 158,1131,159,1131,160,1131,161,1131,162,156 ,163,156 ,164,156 ,165,156 ,166,156 ,167,156 ,176,1092,177,1092,178,1092,179,1092,},[37]={ 158,1131,159,1131,160,1131,161,1131,162,156 ,163,156 ,164,156 ,165,156 ,166,156 ,167,156 ,176,1092,177,1092,178,1092,179,1092,},[38]={ 158,1131,159,1131,160,1131,161,1131,162,156 ,163,156 ,164,156 ,165,156 ,166,143 ,167,143 ,176,1092,177,1092,178,1092,179,1092,},[39]={ 158,1131,159,1131,160,1131,161,1131,162,156 ,163,156 ,164,156 ,165,156 ,166,143 ,167,143 ,176,1092,177,1092,178,1092,179,1092,},[40]={ 158,1131,159,1131,160,1131,161,1131,176,1092,177,1092,178,1092,179,1092,},[41]={ 158,1131,159,1131,160,1131,161,1131,176,1092,177,1092,178,1092,179,1092,},[42]={ 158,1131,159,1131,160,1131,161,1131,176,1092,177,1092,178,1092,179,1092,},[43]={ 158,1131,159,1131,160,1131,161,1131,176,1092,177,1092,178,1092,179,1092,},[44]={ 158,1131,159,1131,160,1131,161,1131,176,1092,177,1092,178,1092,179,1092,},[45]={ 158,1131,159,1131,160,1131,161,1131,176,1092,177,1092,178,1092,179,1092,},[46]={ 158,1131,159,1131,160,1131,161,1131,176,1092,177,1092,178,1092,179,1092,},[47]={ 158,1131,159,1131,160,1131,161,1131,176,1092,177,1092,178,1092,179,1092,},[48]={ 158,1131,159,1131,160,1131,161,1131,176,1092,177,1092,178,1092,179,1092,},[49]={ 158,1131,159,1131,160,1131,161,1131,176,1092,177,1092,178,1092,179,1092,},[50]={ 158,1131,159,1131,160,1131,161,1131,176,1092,177,1092,178,1092,179,1092,},[51]={ 158,1131,159,1131,160,1131,161,1131,176,1092,177,1092,178,1092,179,1092,},[52]={ 158,1131,159,1131,160,1131,161,1131,176,1092,177,1092,178,1092,179,1092,},[53]={ 158,1131,159,1131,160,1131,161,1131,176,1092,177,1092,178,1092,179,1092,},[54]={ 158,1131,159,1131,160,1131,161,1131,176,1092,177,1092,178,1092,179,1092,},[55]={ 158,1131,159,1131,160,1131,161,1131,176,1092,177,1092,178,1092,179,1092,},[56]={ 158,1131,159,1131,160,1131,161,1131,176,1092,177,1092,178,1092,179,1092,},[57]={ 158,1131,159,1131,160,1131,161,1131,176,1092,177,1092,178,1092,179,1092,},[58]={ 158,1131,159,1131,160,1131,161,1131,176,1092,177,1092,178,1092,179,1092,},[59]={ 158,1131,159,1131,160,1131,161,1131,176,1092,177,1092,178,1092,179,1092,},[60]={ 158,1131,159,1131,160,1131,161,1131,170,104 ,171,104 ,172,104 ,173,104 ,174,104 ,175,104 ,176,1092,177,1092,178,1092,179,1092,},[61]={ 158,1131,159,1131,160,1131,161,1131,170,104 ,171,104 ,172,104 ,173,104 ,174,104 ,175,104 ,176,1092,177,1092,178,1092,179,1092,},[62]={ 158,1131,159,1131,160,1131,161,1131,170,104 ,171,104 ,172,104 ,173,104 ,174,104 ,175,104 ,176,1092,177,1092,178,1092,179,1092,},[63]={ 158,1131,159,1131,160,1131,161,1131,170,104 ,171,104 ,172,104 ,173,104 ,174,104 ,175,104 ,176,1092,177,1092,178,1092,179,1092,},[64]={ 158,1131,159,1131,160,1131,161,1131,170,104 ,171,104 ,172,104 ,173,104 ,174,104 ,175,104 ,176,1092,177,1092,178,1092,179,1092,},[65]={ 158,1131,159,1131,160,1131,161,1131,170,104 ,171,104 ,172,104 ,173,104 ,174,104 ,175,104 ,176,1092,177,1092,178,1092,179,1092,},[66]={ 158,1131,159,1131,160,1131,161,1131,170,91 ,171,91 ,172,91 ,173,91 ,174,91 ,175,91 ,176,1092,177,1092,178,1092,179,1092,},[67]={ 158,1131,159,1131,160,1131,161,1131,170,91 ,171,91 ,172,91 ,173,91 ,174,91 ,175,91 ,176,1092,177,1092,178,1092,179,1092,},[68]={ 158,1131,159,1131,160,1131,161,1131,176,1092,177,1092,178,1092,179,1092,},[69]={ 158,1131,159,1131,160,1131,161,1131,176,1092,177,1092,178,1092,179,1092,},[70]={ 158,1131,159,1131,160,1131,161,1131,176,1092,177,1092,178,1092,179,1092,},[71]={ 158,1131,159,1131,160,1131,161,1131,176,1092,177,1092,178,1092,179,1092,},[72]={ 158,1131,159,1131,160,1131,161,1131,176,1092,177,1092,178,1092,179,1092,},[73]={ 158,1131,159,1131,160,1131,161,1131,176,1092,177,1092,178,1092,179,1092,},[74]={ 158,1131,159,1131,160,1131,161,1131,176,1092,177,1092,178,1092,179,1092,180,1092,181,1092,},[75]={ 158,1131,159,1131,160,1131,161,1131,176,1092,177,1092,178,1092,179,1092,180,1092,181,1092,},[76]={ 158,1131,159,1131,160,1131,161,1131,178,1092,179,1092,180,1092,181,1092,182,1092,183,1092,},[77]={ 158,1131,159,1131,160,1131,161,1131,178,1092,179,1092,180,1092,181,1092,182,1092,183,1092,},[78]={ 158,1131,159,1131,160,1131,161,1131,180,1092,181,1092,182,1092,183,1092,184,1092,185,1092,},[79]={ 158,1131,159,1131,160,1131,161,1131,180,1092,181,1092,182,1092,183,1092,184,1092,185,1092,},[80]={ 14,1092 ,15,1092 ,16,1091 ,17,1091 ,18,1091 ,19,1091 ,20,1091 ,21,1091 ,22,1091 ,23,1091 ,24,1091 ,25,1091 ,26,1091 ,27,1091 ,28,1091 ,29,1091 ,30,1091 ,31,1091 ,32,1091 ,33,1091 ,34,1091 ,35,1091 ,36,1091 ,37,1091 ,38,1091 ,39,1091 ,40,1091 ,41,1091 ,42,1091 ,43,1091 ,44,1091 ,45,1091 ,46,1091 ,47,1091 ,48,1091 ,49,1091 ,50,1091 ,51,1091 ,52,1091 ,53,1091 ,54,1091 ,55,1091 ,56,1091 ,57,1091 ,58,1091 ,59,1091 ,60,1091 ,61,1091 ,62,1091 ,63,1091 ,64,1091 ,65,1091 ,66,1091 ,67,1091 ,68,1091 ,69,1091 ,70,1091 ,71,1091 ,72,1091 ,73,1091 ,74,1091 ,75,1091 ,158,1131,159,1131,160,1131,161,1131,182,1092,183,1092,184,1092,185,1092,186,1092,187,1092,},[81]={ 14,1092 ,15,1092 ,16,1091 ,17,1091 ,18,1091 ,19,1091 ,20,1091 ,21,1091 ,22,1091 ,23,1091 ,24,1091 ,25,1091 ,26,1091 ,27,1091 ,28,1091 ,29,1091 ,30,1091 ,31,1091 ,32,1091 ,33,1091 ,34,1091 ,35,1091 ,36,1091 ,37,1091 ,38,1091 ,39,1091 ,40,1091 ,41,1091 ,42,1091 ,43,1091 ,44,1091 ,45,1091 ,46,1091 ,47,1091 ,48,1091 ,49,1091 ,50,1091 ,51,1091 ,52,1091 ,53,1091 ,54,1091 ,55,1091 ,56,1091 ,57,1091 ,58,1091 ,59,1091 ,60,1091 ,61,1091 ,62,1091 ,63,1091 ,64,1091 ,65,1091 ,66,1091 ,67,1091 ,68,1091 ,69,1091 ,70,1091 ,71,1091 ,72,1091 ,73,1091 ,74,1091 ,75,1091 ,158,1131,159,1131,160,1131,161,1131,182,1092,183,1092,184,1092,185,1092,186,1092,187,1092,},[82]={ 0,1079 ,1,1079 ,2,1079 ,3,1079 ,4,1079 ,5,1079 ,6,1079 ,7,1079 ,8,1079 ,9,1079 ,10,1079 ,11,1079 ,12,1082 ,13,1082 ,14,1082 ,15,1082 ,16,1091 ,17,1091 ,18,1091 ,19,1091 ,20,1091 ,21,1091 ,22,1091 ,23,1091 ,24,1091 ,25,1091 ,26,1091 ,27,1091 ,28,1091 ,29,1091 ,30,1091 ,31,1091 ,32,1091 ,33,1091 ,34,1091 ,35,1091 ,36,1091 ,37,1091 ,38,1091 ,39,1091 ,40,1091 ,41,1091 ,42,1091 ,43,1091 ,44,1091 ,45,1091 ,46,1091 ,47,1091 ,48,1091 ,49,1091 ,50,1091 ,51,1091 ,52,1091 ,53,1091 ,54,1091 ,55,1091 ,56,1091 ,57,1091 ,58,1091 ,59,1091 ,60,1091 ,61,1091 ,62,1091 ,63,1091 ,64,1091 ,65,1091 ,66,1091 ,67,1091 ,68,1091 ,69,1091 ,70,1091 ,71,1091 ,72,1091 ,73,1091 ,74,1091 ,75,1091 ,76,1091 ,77,1091 ,158,1131,159,1131,160,1131,161,1131,184,1092,185,1092,186,1092,187,1092,188,1092,189,1092,190,1092,191,1092,192,1092,193,1092,194,1092,195,1092,196,1092,197,1092,198,1092,199,1092,200,1092,201,1092,202,1092,203,1092,204,1091,205,1091,206,1091,207,1091,208,1091,209,1091,210,1091,211,1091,212,1091,213,1091,214,1091,215,1091,216,1091,217,1091,218,1091,219,1091,220,1091,221,1091,222,1091,223,1091,224,1091,225,1091,226,1091,227,1091,228,1091,229,1091,230,1091,231,1091,232,1091,233,1091,234,1091,235,1091,236,1091,237,1091,238,1091,239,1091,240,1091,241,1091,242,1090,243,1090,244,1088,245,1088,246,1085,247,1085,248,1079,249,1079,250,1079,251,1079,252,1079,253,1079,254,1079,255,1079,},[83]={ 0,1079 ,1,1079 ,2,1079 ,3,1079 ,4,1079 ,5,1079 ,6,1079 ,7,1079 ,8,1079 ,9,1079 ,10,1079 ,11,1079 ,12,1082 ,13,1082 ,14,1082 ,15,1082 ,16,1091 ,17,1091 ,18,1091 ,19,1091 ,20,1091 ,21,1091 ,22,1091 ,23,1091 ,24,1091 ,25,1091 ,26,1091 ,27,1091 ,28,1091 ,29,1091 ,30,1091 ,31,1091 ,32,1091 ,33,1091 ,34,1091 ,35,1091 ,36,1091 ,37,1091 ,38,1091 ,39,1091 ,40,1091 ,41,1091 ,42,1091 ,43,1091 ,44,1091 ,45,1091 ,46,1091 ,47,1091 ,48,1091 ,49,1091 ,50,1091 ,51,1091 ,52,1091 ,53,1091 ,54,1091 ,55,1091 ,56,1091 ,57,1091 ,58,1091 ,59,1091 ,60,1091 ,61,1091 ,62,1091 ,63,1091 ,64,1091 ,65,1091 ,66,1091 ,67,1091 ,68,1091 ,69,1091 ,70,1091 ,71,1091 ,72,1091 ,73,1091 ,74,1091 ,75,1091 ,76,1091 ,77,1091 ,158,1131,159,1131,160,1131,161,1131,184,1092,185,1092,186,1092,187,1092,188,1092,189,1092,190,1092,191,1092,192,1092,193,1092,194,1092,195,1092,196,1092,197,1092,198,1092,199,1092,200,1092,201,1092,202,1092,203,1092,204,1091,205,1091,206,1091,207,1091,208,1091,209,1091,210,1091,211,1091,212,1091,213,1091,214,1091,215,1091,216,1091,217,1091,218,1091,219,1091,220,1091,221,1091,222,1091,223,1091,224,1091,225,1091,226,1091,227,1091,228,1091,229,1091,230,1091,231,1091,232,1091,233,1091,234,1091,235,1091,236,1091,237,1091,238,1091,239,1091,240,1091,241,1091,242,1090,243,1090,244,1088,245,1088,246,1085,247,1085,248,1079,249,1079,250,1079,251,1079,252,1079,253,1079,254,1079,255,1079,},[84]={ 0,1079 ,1,1079 ,2,1079 ,3,1079 ,4,1079 ,5,1079 ,6,1079 ,7,1079 ,8,1079 ,9,1079 ,10,1079 ,11,1079 ,12,1080 ,13,1080 ,14,1080 ,15,1080 ,16,26 ,17,26 ,18,26 ,19,26 ,20,26 ,21,26 ,22,26 ,23,26 ,24,39 ,25,39 ,26,39 ,27,39 ,28,39 ,29,39 ,30,26 ,31,26 ,74,1091 ,75,1091 ,76,1091 ,77,1091 ,78,1091 ,79,1091 ,158,1131,159,1131,160,1131,161,1131,186,1092,187,1092,188,1092,189,1092,190,1092,191,1092,192,1092,193,1092,194,1092,195,1092,196,1092,197,1092,198,1092,199,1092,200,1092,201,1092,202,1092,203,1092,204,1091,205,1091,206,1091,207,1091,208,1091,209,1091,210,1091,211,1091,212,1091,213,1091,214,1091,215,1091,216,1091,217,1091,218,1091,219,1091,220,1091,221,1091,222,1091,223,1091,224,1091,225,1091,226,1091,227,1091,228,1091,229,1091,230,1091,231,1091,232,1091,233,1091,234,1091,235,1091,236,1091,237,1091,238,1091,239,1091,240,1091,241,1091,242,1090,243,1090,244,1088,245,1088,246,1085,247,1085,248,1079,249,1079,250,1079,251,1079,252,1079,253,1079,254,1079,255,1079,},[85]={ 0,1079 ,1,1079 ,2,1079 ,3,1079 ,4,1079 ,5,1079 ,6,1079 ,7,1079 ,8,1079 ,9,1079 ,10,1079 ,11,1079 ,12,1080 ,13,1080 ,14,1080 ,15,1080 ,16,26 ,17,26 ,18,26 ,19,26 ,20,26 ,21,26 ,22,26 ,23,26 ,24,39 ,25,39 ,26,39 ,27,39 ,28,39 ,29,39 ,30,26 ,31,26 ,74,1091 ,75,1091 ,76,1091 ,77,1091 ,78,1091 ,79,1091 ,158,1131,159,1131,160,1131,161,1131,186,1092,187,1092,188,1092,189,1092,190,1092,191,1092,192,1092,193,1092,194,1092,195,1092,196,1092,197,1092,198,1092,199,1092,200,1092,201,1092,202,1092,203,1092,204,1091,205,1091,206,1091,207,1091,208,1091,209,1091,210,1091,211,1091,212,1091,213,1091,214,1091,215,1091,216,1091,217,1091,218,1091,219,1091,220,1091,221,1091,222,1091,223,1091,224,1091,225,1091,226,1091,227,1091,228,1091,229,1091,230,1091,231,1091,232,1091,233,1091,234,1091,235,1091,236,1091,237,1091,238,1091,239,1091,240,1091,241,1091,242,1090,243,1090,244,1088,245,1088,246,1085,247,1085,248,1079,249,1079,250,1079,251,1079,252,1079,253,1079,254,1079,255,1079,},[86]={ 4,13 ,5,13 ,6,13 ,7,13 ,8,26 ,9,26 ,10,26 ,11,26 ,12,1079 ,13,1079 ,14,1079 ,15,1079 ,16,26 ,17,26 ,18,26 ,19,26 ,20,26 ,21,26 ,22,26 ,23,26 ,24,39 ,25,39 ,26,39 ,27,39 ,28,39 ,29,39 ,30,26 ,31,26 ,76,1091 ,77,1091 ,78,1091 ,79,1091 ,80,1091 ,81,1091 ,158,1131,159,1131,160,1131,161,1131,},[87]={ 4,13 ,5,13 ,6,13 ,7,13 ,8,26 ,9,26 ,10,26 ,11,26 ,12,1079 ,13,1079 ,14,1079 ,15,1079 ,16,26 ,17,26 ,18,26 ,19,26 ,20,26 ,21,26 ,22,26 ,23,26 ,24,39 ,25,39 ,26,39 ,27,39 ,28,39 ,29,39 ,30,26 ,31,26 ,76,1091 ,77,1091 ,78,1091 ,79,1091 ,80,1091 ,81,1091 ,158,1131,159,1131,160,1131,161,1131,},[88]={ 4,13 ,5,13 ,6,13 ,7,13 ,8,26 ,9,26 ,10,26 ,11,26 ,12,1079 ,13,1079 ,14,1079 ,15,1079 ,16,26 ,17,26 ,18,26 ,19,26 ,20,26 ,21,26 ,22,26 ,23,26 ,24,39 ,25,39 ,26,39 ,27,39 ,28,39 ,29,39 ,30,26 ,31,26 ,78,1091 ,79,1091 ,80,1091 ,81,1091 ,82,1091 ,83,1091 ,158,1131,159,1131,160,1131,161,1131,},[89]={ 4,13 ,5,13 ,6,13 ,7,13 ,8,26 ,9,26 ,10,26 ,11,26 ,12,1079 ,13,1079 ,14,1079 ,15,1079 ,16,26 ,17,26 ,18,26 ,19,26 ,20,26 ,21,26 ,22,26 ,23,26 ,24,39 ,25,39 ,26,39 ,27,39 ,28,39 ,29,39 ,30,26 ,31,26 ,78,1091 ,79,1091 ,80,1091 ,81,1091 ,82,1091 ,83,1091 ,158,1131,159,1131,160,1131,161,1131,},[90]={ 4,13 ,5,13 ,6,13 ,7,13 ,8,39 ,9,39 ,10,39 ,11,39 ,12,1079 ,13,1079 ,14,1079 ,15,1079 ,16,26 ,17,26 ,18,26 ,19,26 ,20,26 ,21,26 ,22,26 ,23,26 ,24,26 ,25,26 ,26,26 ,27,26 ,28,26 ,29,26 ,30,26 ,31,26 ,80,1091 ,81,1091 ,82,1091 ,83,1091 ,84,1091 ,85,1091 ,158,1131,159,1131,160,1131,161,1131,},[91]={ 4,13 ,5,13 ,6,13 ,7,13 ,8,39 ,9,39 ,10,39 ,11,39 ,12,1079 ,13,1079 ,14,1079 ,15,1079 ,16,26 ,17,26 ,18,26 ,19,26 ,20,26 ,21,26 ,22,26 ,23,26 ,24,26 ,25,26 ,26,26 ,27,26 ,28,26 ,29,26 ,30,26 ,31,26 ,80,1091 ,81,1091 ,82,1091 ,83,1091 ,84,1091 ,85,1091 ,158,1131,159,1131,160,1131,161,1131,},[92]={ 4,13 ,5,13 ,6,13 ,7,13 ,8,39 ,9,39 ,10,39 ,11,39 ,12,1079 ,13,1079 ,14,1079 ,15,1079 ,16,39 ,17,39 ,18,39 ,19,39 ,20,39 ,21,39 ,22,26 ,23,26 ,24,26 ,25,26 ,26,26 ,27,26 ,28,39 ,29,39 ,30,26 ,31,26 ,82,1091 ,83,1091 ,84,1091 ,85,1091 ,86,1091 ,87,1091 ,158,1131,159,1131,160,1131,161,1131,},[93]={ 4,13 ,5,13 ,6,13 ,7,13 ,8,39 ,9,39 ,10,39 ,11,39 ,12,1079 ,13,1079 ,14,1079 ,15,1079 ,16,39 ,17,39 ,18,39 ,19,39 ,20,39 ,21,39 ,22,26 ,23,26 ,24,26 ,25,26 ,26,26 ,27,26 ,28,39 ,29,39 ,30,26 ,31,26 ,82,1091 ,83,1091 ,84,1091 ,85,1091 ,86,1091 ,87,1091 ,158,1131,159,1131,160,1131,161,1131,},[94]={ 4,13 ,5,13 ,6,13 ,7,13 ,8,39 ,9,39 ,10,39 ,11,39 ,12,1079 ,13,1079 ,14,1079 ,15,1079 ,16,39 ,17,39 ,18,39 ,19,39 ,20,39 ,21,39 ,22,26 ,23,26 ,24,26 ,25,26 ,26,26 ,27,26 ,28,39 ,29,39 ,30,39 ,31,39 ,84,1091 ,85,1091 ,86,1091 ,87,1091 ,88,1091 ,89,1091 ,158,1131,159,1131,160,1131,161,1131,},[95]={ 4,13 ,5,13 ,6,13 ,7,13 ,8,39 ,9,39 ,10,39 ,11,39 ,12,1079 ,13,1079 ,14,1079 ,15,1079 ,16,39 ,17,39 ,18,39 ,19,39 ,20,39 ,21,39 ,22,26 ,23,26 ,24,26 ,25,26 ,26,26 ,27,26 ,28,39 ,29,39 ,30,39 ,31,39 ,84,1091 ,85,1091 ,86,1091 ,87,1091 ,88,1091 ,89,1091 ,158,1131,159,1131,160,1131,161,1131,},[96]={ 4,13 ,5,13 ,6,13 ,7,13 ,8,26 ,9,26 ,10,26 ,11,26 ,12,1079 ,13,1079 ,14,1079 ,15,1079 ,16,39 ,17,39 ,18,39 ,19,39 ,20,39 ,21,39 ,22,26 ,23,26 ,24,26 ,25,26 ,26,26 ,27,26 ,28,13 ,29,13 ,30,13 ,31,13 ,32,26 ,33,26 ,34,26 ,35,26 ,86,1091 ,87,1091 ,88,1091 ,89,1091 ,90,1091 ,91,1091 ,158,1131,159,1131,160,1131,161,1131,162,1131,163,1131,},[97]={ 4,13 ,5,13 ,6,13 ,7,13 ,8,26 ,9,26 ,10,26 ,11,26 ,12,1079 ,13,1079 ,14,1079 ,15,1079 ,16,39 ,17,39 ,18,39 ,19,39 ,20,39 ,21,39 ,22,26 ,23,26 ,24,26 ,25,26 ,26,26 ,27,26 ,28,13 ,29,13 ,30,13 ,31,13 ,32,26 ,33,26 ,34,26 ,35,26 ,86,1091 ,87,1091 ,88,1091 ,89,1091 ,90,1091 ,91,1091 ,158,1131,159,1131,160,1131,161,1131,162,1131,163,1131,},[98]={ 4,13 ,5,13 ,6,13 ,7,13 ,8,39 ,9,39 ,10,39 ,11,39 ,12,1079 ,13,1079 ,14,1079 ,15,1079 ,16,13 ,17,13 ,18,13 ,19,13 ,20,13 ,21,13 ,22,26 ,23,26 ,24,26 ,25,26 ,26,26 ,27,26 ,28,24 ,29,24 ,30,24 ,31,24 ,32,26 ,33,26 ,34,26 ,35,26 ,88,1091 ,89,1091 ,90,1091 ,91,1091 ,92,1091 ,93,1091 ,160,1131,161,1131,162,1131,163,1131,164,1131,165,1131,},[99]={ 4,13 ,5,13 ,6,13 ,7,13 ,8,39 ,9,39 ,10,39 ,11,39 ,12,1079 ,13,1079 ,14,1079 ,15,1079 ,16,13 ,17,13 ,18,13 ,19,13 ,20,13 ,21,13 ,22,26 ,23,26 ,24,26 ,25,26 ,26,26 ,27,26 ,28,24 ,29,24 ,30,24 ,31,24 ,32,26 ,33,26 ,34,26 ,35,26 ,88,1091 ,89,1091 ,90,1091 ,91,1091 ,92,1091 ,93,1091 ,160,1131,161,1131,162,1131,163,1131,164,1131,165,1131,},[100]={ 4,13 ,5,13 ,6,13 ,7,13 ,8,39 ,9,39 ,10,39 ,11,39 ,12,1079 ,13,1079 ,14,1079 ,15,1079 ,16,13 ,17,13 ,18,13 ,19,13 ,20,13 ,21,13 ,22,26 ,23,26 ,24,26 ,25,26 ,26,26 ,27,26 ,28,24 ,29,24 ,30,24 ,31,24 ,90,1091 ,91,1091 ,92,1091 ,93,1091 ,94,1091 ,95,1091 ,162,1131,163,1131,164,1131,165,1131,166,1131,167,1131,},[101]={ 4,13 ,5,13 ,6,13 ,7,13 ,8,39 ,9,39 ,10,39 ,11,39 ,12,1079 ,13,1079 ,14,1079 ,15,1079 ,16,13 ,17,13 ,18,13 ,19,13 ,20,13 ,21,13 ,22,26 ,23,26 ,24,26 ,25,26 ,26,26 ,27,26 ,28,24 ,29,24 ,30,24 ,31,24 ,90,1091 ,91,1091 ,92,1091 ,93,1091 ,94,1091 ,95,1091 ,162,1131,163,1131,164,1131,165,1131,166,1131,167,1131,},[102]={ 4,26 ,5,26 ,6,26 ,7,26 ,8,26 ,9,26 ,10,26 ,11,26 ,12,1079 ,13,1079 ,14,1079 ,15,1079 ,16,13 ,17,13 ,18,13 ,19,13 ,20,13 ,21,13 ,22,26 ,23,26 ,24,26 ,25,26 ,26,19 ,27,19 ,28,37 ,29,37 ,30,37 ,31,37 ,92,1091 ,93,1091 ,94,1091 ,95,1091 ,96,1091 ,97,1091 ,164,1131,165,1131,166,1131,167,1131,168,1131,169,1131,},[103]={ 4,26 ,5,26 ,6,26 ,7,26 ,8,26 ,9,26 ,10,26 ,11,26 ,12,1079 ,13,1079 ,14,1079 ,15,1079 ,16,13 ,17,13 ,18,13 ,19,13 ,20,13 ,21,13 ,22,26 ,23,26 ,24,26 ,25,26 ,26,19 ,27,19 ,28,37 ,29,37 ,30,37 ,31,37 ,92,1091 ,93,1091 ,94,1091 ,95,1091 ,96,1091 ,97,1091 ,164,1131,165,1131,166,1131,167,1131,168,1131,169,1131,},[104]={ 4,26 ,5,26 ,6,26 ,7,26 ,8,39 ,9,39 ,10,26 ,11,26 ,12,1079 ,13,1079 ,14,1079 ,15,1079 ,16,13 ,17,13 ,18,13 ,19,13 ,20,13 ,21,13 ,22,6 ,23,6 ,24,6 ,25,6 ,26,6 ,27,6 ,28,37 ,29,37 ,30,37 ,31,37 ,94,1091 ,95,1091 ,96,1091 ,97,1091 ,98,1091 ,99,1091 ,166,1131,167,1131,168,1131,169,1131,170,1131,171,1131,},[105]={ 4,26 ,5,26 ,6,26 ,7,26 ,8,39 ,9,39 ,10,26 ,11,26 ,12,1079 ,13,1079 ,14,1079 ,15,1079 ,16,13 ,17,13 ,18,13 ,19,13 ,20,13 ,21,13 ,22,6 ,23,6 ,24,6 ,25,6 ,26,6 ,27,6 ,28,37 ,29,37 ,30,37 ,31,37 ,94,1091 ,95,1091 ,96,1091 ,97,1091 ,98,1091 ,99,1091 ,166,1131,167,1131,168,1131,169,1131,170,1131,171,1131,},[106]={ 4,39 ,5,39 ,6,39 ,7,39 ,8,39 ,9,39 ,10,26 ,11,26 ,12,1079 ,13,1079 ,14,1079 ,15,1079 ,16,6 ,17,6 ,18,6 ,19,6 ,20,6 ,21,6 ,22,6 ,23,6 ,24,6 ,25,6 ,26,6 ,27,6 ,28,19 ,29,19 ,30,19 ,31,19 ,96,1091 ,97,1091 ,98,1091 ,99,1091 ,100,1091,101,1091,168,1131,169,1131,170,1131,171,1131,172,1131,173,1131,},[107]={ 4,39 ,5,39 ,6,39 ,7,39 ,8,39 ,9,39 ,10,26 ,11,26 ,12,1079 ,13,1079 ,14,1079 ,15,1079 ,16,6 ,17,6 ,18,6 ,19,6 ,20,6 ,21,6 ,22,6 ,23,6 ,24,6 ,25,6 ,26,6 ,27,6 ,28,19 ,29,19 ,30,19 ,31,19 ,96,1091 ,97,1091 ,98,1091 ,99,1091 ,100,1091,101,1091,168,1131,169,1131,170,1131,171,1131,172,1131,173,1131,},[108]={ 4,39 ,5,39 ,6,39 ,7,39 ,8,39 ,9,39 ,10,39 ,11,39 ,12,1105 ,13,1105 ,14,1105 ,15,1105 ,16,6 ,17,6 ,18,6 ,19,6 ,20,6 ,21,6 ,22,6 ,23,6 ,24,6 ,25,6 ,26,6 ,27,6 ,28,19 ,29,19 ,30,19 ,31,19 ,98,1091 ,99,1091 ,100,1091,101,1091,102,1091,103,1091,170,1131,171,1131,172,1131,173,1131,174,1131,175,1131,},[109]={ 4,39 ,5,39 ,6,39 ,7,39 ,8,39 ,9,39 ,10,39 ,11,39 ,12,1105 ,13,1105 ,14,1105 ,15,1105 ,16,6 ,17,6 ,18,6 ,19,6 ,20,6 ,21,6 ,22,6 ,23,6 ,24,6 ,25,6 ,26,6 ,27,6 ,28,19 ,29,19 ,30,19 ,31,19 ,98,1091 ,99,1091 ,100,1091,101,1091,102,1091,103,1091,170,1131,171,1131,172,1131,173,1131,174,1131,175,1131,},[110]={ 0,1130 ,1,1130 ,2,1130 ,3,1130 ,4,1130 ,5,1130 ,6,1130 ,7,1130 ,8,1129 ,9,1129 ,10,1127 ,11,1127 ,12,1124 ,13,1124 ,14,1105 ,15,1105 ,16,6 ,17,6 ,18,6 ,19,6 ,20,6 ,21,6 ,22,6 ,23,6 ,24,6 ,25,6 ,26,6 ,27,6 ,28,19 ,29,19 ,30,19 ,31,19 ,100,1091,101,1091,102,1091,103,1091,104,1091,105,1091,172,1131,173,1131,174,1131,175,1131,176,1131,177,1131,178,1131,179,1131,180,1131,181,1131,182,1131,183,1131,184,1131,185,1131,186,1131,187,1131,188,1131,189,1131,190,1131,191,1131,192,1131,193,1131,194,1131,195,1131,196,1131,197,1131,198,1131,199,1131,200,1131,201,1131,202,1131,203,1131,204,1130,205,1130,206,1130,207,1130,208,1130,209,1130,210,1130,211,1130,212,1130,213,1130,214,1130,215,1130,216,1130,217,1130,218,1130,219,1130,220,1130,221,1130,222,1130,223,1130,224,1130,225,1130,226,1130,227,1130,228,1130,229,1130,230,1130,231,1130,232,1130,233,1130,234,1130,235,1130,236,1130,237,1130,238,1130,239,1130,240,1130,241,1130,242,1130,243,1130,244,1130,245,1130,246,1130,247,1130,248,1130,249,1130,250,1130,251,1130,252,1130,253,1130,254,1130,255,1130,},[111]={ 0,1130 ,1,1130 ,2,1130 ,3,1130 ,4,1130 ,5,1130 ,6,1130 ,7,1130 ,8,1129 ,9,1129 ,10,1127 ,11,1127 ,12,1124 ,13,1124 ,14,1105 ,15,1105 ,16,6 ,17,6 ,18,6 ,19,6 ,20,6 ,21,6 ,22,6 ,23,6 ,24,6 ,25,6 ,26,6 ,27,6 ,28,19 ,29,19 ,30,19 ,31,19 ,100,1091,101,1091,102,1091,103,1091,104,1091,105,1091,172,1131,173,1131,174,1131,175,1131,176,1131,177,1131,178,1131,179,1131,180,1131,181,1131,182,1131,183,1131,184,1131,185,1131,186,1131,187,1131,188,1131,189,1131,190,1131,191,1131,192,1131,193,1131,194,1131,195,1131,196,1131,197,1131,198,1131,199,1131,200,1131,201,1131,202,1131,203,1131,204,1130,205,1130,206,1130,207,1130,208,1130,209,1130,210,1130,211,1130,212,1130,213,1130,214,1130,215,1130,216,1130,217,1130,218,1130,219,1130,220,1130,221,1130,222,1130,223,1130,224,1130,225,1130,226,1130,227,1130,228,1130,229,1130,230,1130,231,1130,232,1130,233,1130,234,1130,235,1130,236,1130,237,1130,238,1130,239,1130,240,1130,241,1130,242,1130,243,1130,244,1130,245,1130,246,1130,247,1130,248,1130,249,1130,250,1130,251,1130,252,1130,253,1130,254,1130,255,1130,},[112]={ 0,1130 ,1,1130 ,2,1130 ,3,1130 ,4,1130 ,5,1130 ,6,1130 ,7,1130 ,8,1129 ,9,1129 ,10,1127 ,11,1127 ,12,1124 ,13,1124 ,14,1131 ,15,1131 ,16,1131 ,17,1131 ,18,1131 ,19,1131 ,20,1131 ,21,1131 ,22,1131 ,23,1131 ,24,1131 ,25,1131 ,26,1131 ,27,1131 ,28,1131 ,29,1131 ,30,1104 ,31,1104 ,32,1091 ,33,1091 ,34,1084 ,35,1084 ,36,1081 ,37,1081 ,38,1079 ,39,1079 ,40,1078 ,41,1078 ,42,1078 ,43,1078 ,44,1078 ,45,1078 ,46,1078 ,47,1078 ,48,1078 ,49,1078 ,50,1078 ,51,1078 ,52,1078 ,53,1078 ,54,1078 ,55,1078 ,56,1078 ,57,1078 ,58,1078 ,59,1078 ,60,1078 ,61,1078 ,62,1078 ,63,1078 ,64,1078 ,65,1078 ,66,1078 ,67,1078 ,68,1078 ,69,1078 ,70,1078 ,71,1078 ,72,1078 ,73,1078 ,74,1078 ,75,1078 ,102,1091,103,1091,104,1091,105,1091,106,1091,107,1091,174,1131,175,1131,176,1131,177,1131,178,1131,179,1131,180,1131,181,1131,182,1131,183,1131,184,1131,185,1131,186,1131,187,1131,188,1131,189,1131,190,1131,191,1131,192,1131,193,1131,194,1131,195,1131,196,1131,197,1131,198,1131,199,1131,200,1131,201,1131,202,1131,203,1131,204,1130,205,1130,206,1130,207,1130,208,1130,209,1130,210,1130,211,1130,212,1130,213,1130,214,1130,215,1130,216,1130,217,1130,218,1130,219,1130,220,1130,221,1130,222,1130,223,1130,224,1130,225,1130,226,1130,227,1130,228,1130,229,1130,230,1130,231,1130,232,1130,233,1130,234,1130,235,1130,236,1130,237,1130,238,1130,239,1130,240,1130,241,1130,242,1130,243,1130,244,1130,245,1130,246,1130,247,1130,248,1130,249,1130,250,1130,251,1130,252,1130,253,1130,254,1130,255,1130,},[113]={ 0,1130 ,1,1130 ,2,1130 ,3,1130 ,4,1130 ,5,1130 ,6,1130 ,7,1130 ,8,1129 ,9,1129 ,10,1127 ,11,1127 ,12,1124 ,13,1124 ,14,1131 ,15,1131 ,16,1131 ,17,1131 ,18,1131 ,19,1131 ,20,1131 ,21,1131 ,22,1131 ,23,1131 ,24,1131 ,25,1131 ,26,1131 ,27,1131 ,28,1131 ,29,1131 ,30,1104 ,31,1104 ,32,1091 ,33,1091 ,34,1084 ,35,1084 ,36,1081 ,37,1081 ,38,1079 ,39,1079 ,40,1078 ,41,1078 ,42,1078 ,43,1078 ,44,1078 ,45,1078 ,46,1078 ,47,1078 ,48,1078 ,49,1078 ,50,1078 ,51,1078 ,52,1078 ,53,1078 ,54,1078 ,55,1078 ,56,1078 ,57,1078 ,58,1078 ,59,1078 ,60,1078 ,61,1078 ,62,1078 ,63,1078 ,64,1078 ,65,1078 ,66,1078 ,67,1078 ,68,1078 ,69,1078 ,70,1078 ,71,1078 ,72,1078 ,73,1078 ,74,1078 ,75,1078 ,102,1091,103,1091,104,1091,105,1091,106,1091,107,1091,174,1131,175,1131,176,1131,177,1131,178,1131,179,1131,180,1131,181,1131,182,1131,183,1131,184,1131,185,1131,186,1131,187,1131,188,1131,189,1131,190,1131,191,1131,192,1131,193,1131,194,1131,195,1131,196,1131,197,1131,198,1131,199,1131,200,1131,201,1131,202,1131,203,1131,204,1130,205,1130,206,1130,207,1130,208,1130,209,1130,210,1130,211,1130,212,1130,213,1130,214,1130,215,1130,216,1130,217,1130,218,1130,219,1130,220,1130,221,1130,222,1130,223,1130,224,1130,225,1130,226,1130,227,1130,228,1130,229,1130,230,1130,231,1130,232,1130,233,1130,234,1130,235,1130,236,1130,237,1130,238,1130,239,1130,240,1130,241,1130,242,1130,243,1130,244,1130,245,1130,246,1130,247,1130,248,1130,249,1130,250,1130,251,1130,252,1130,253,1130,254,1130,255,1130,},[114]={ 14,1131 ,15,1131 ,16,1131 ,17,1131 ,18,1131 ,19,1131 ,20,1131 ,21,1131 ,22,1131 ,23,1131 ,24,1131 ,25,1131 ,26,1131 ,27,1131 ,28,1131 ,29,1131 ,30,1104 ,31,1104 ,32,1091 ,33,1091 ,34,1084 ,35,1084 ,36,1081 ,37,1081 ,38,1079 ,39,1079 ,40,1078 ,41,1078 ,42,1078 ,43,1078 ,44,1078 ,45,1078 ,46,1078 ,47,1078 ,48,1078 ,49,1078 ,50,1078 ,51,1078 ,52,1078 ,53,1078 ,54,1078 ,55,1078 ,56,1078 ,57,1078 ,58,1078 ,59,1078 ,60,1078 ,61,1078 ,62,1078 ,63,1078 ,64,1078 ,65,1078 ,66,1078 ,67,1078 ,68,1078 ,69,1078 ,70,1078 ,71,1078 ,72,1078 ,73,1078 ,74,1078 ,75,1078 ,76,1078 ,77,1078 ,104,1091,105,1091,106,1091,107,1091,108,1091,109,1091,},[115]={ 14,1131 ,15,1131 ,16,1131 ,17,1131 ,18,1131 ,19,1131 ,20,1131 ,21,1131 ,22,1131 ,23,1131 ,24,1131 ,25,1131 ,26,1131 ,27,1131 ,28,1131 ,29,1131 ,30,1104 ,31,1104 ,32,1091 ,33,1091 ,34,1084 ,35,1084 ,36,1081 ,37,1081 ,38,1079 ,39,1079 ,40,1078 ,41,1078 ,42,1078 ,43,1078 ,44,1078 ,45,1078 ,46,1078 ,47,1078 ,48,1078 ,49,1078 ,50,1078 ,51,1078 ,52,1078 ,53,1078 ,54,1078 ,55,1078 ,56,1078 ,57,1078 ,58,1078 ,59,1078 ,60,1078 ,61,1078 ,62,1078 ,63,1078 ,64,1078 ,65,1078 ,66,1078 ,67,1078 ,68,1078 ,69,1078 ,70,1078 ,71,1078 ,72,1078 ,73,1078 ,74,1078 ,75,1078 ,76,1078 ,77,1078 ,104,1091,105,1091,106,1091,107,1091,108,1091,109,1091,},[116]={ 74,1078 ,75,1078 ,76,1078 ,77,1078 ,78,1078 ,79,1078 ,106,1091,107,1091,108,1091,109,1091,110,1091,111,1091,},[117]={ 74,1078 ,75,1078 ,76,1078 ,77,1078 ,78,1078 ,79,1078 ,106,1091,107,1091,108,1091,109,1091,110,1091,111,1091,},[118]={ 76,1078 ,77,1078 ,78,1078 ,79,1078 ,80,1078 ,81,1078 ,108,1091,109,1091,110,1091,111,1091,112,1091,113,1091,},[119]={ 76,1078 ,77,1078 ,78,1078 ,79,1078 ,80,1078 ,81,1078 ,108,1091,109,1091,110,1091,111,1091,112,1091,113,1091,},[120]={ 78,1078 ,79,1078 ,80,1078 ,81,1078 ,82,1078 ,83,1078 ,110,1091,111,1091,112,1091,113,1091,114,1091,115,1091,},[121]={ 78,1078 ,79,1078 ,80,1078 ,81,1078 ,82,1078 ,83,1078 ,110,1091,111,1091,112,1091,113,1091,114,1091,115,1091,},[122]={ 80,1078 ,81,1078 ,82,1078 ,83,1078 ,84,1078 ,85,1078 ,112,1091,113,1091,114,1091,115,1091,116,1090,117,1090,},[123]={ 80,1078 ,81,1078 ,82,1078 ,83,1078 ,84,1078 ,85,1078 ,112,1091,113,1091,114,1091,115,1091,116,1090,117,1090,},[124]={ 82,1078 ,83,1078 ,84,1078 ,85,1078 ,86,1078 ,87,1078 ,114,1090,115,1090,116,1090,117,1090,},[125]={ 82,1078 ,83,1078 ,84,1078 ,85,1078 ,86,1078 ,87,1078 ,114,1090,115,1090,116,1090,117,1090,},[126]={ 84,1078 ,85,1078 ,86,1078 ,87,1078 ,88,1078 ,89,1078 ,114,1088,115,1088,116,1088,117,1088,},[127]={ 84,1078 ,85,1078 ,86,1078 ,87,1078 ,88,1078 ,89,1078 ,114,1088,115,1088,116,1088,117,1088,},[128]={ 86,1078 ,87,1078 ,88,1078 ,89,1078 ,90,1078 ,91,1078 ,114,1085,115,1085,116,1085,117,1085,166,1117,167,1117,168,1117,169,1117,170,1117,171,1117,172,1117,173,1117,174,1117,175,1117,176,1117,177,1117,178,1111,179,1111,180,1114,181,1114,182,1116,183,1116,184,1117,185,1117,186,1114,187,1114,188,1114,189,1114,},[129]={ 86,1078 ,87,1078 ,88,1078 ,89,1078 ,90,1078 ,91,1078 ,114,1085,115,1085,116,1085,117,1085,166,1117,167,1117,168,1117,169,1117,170,1117,171,1117,172,1117,173,1117,174,1117,175,1117,176,1117,177,1117,178,1111,179,1111,180,1114,181,1114,182,1116,183,1116,184,1117,185,1117,186,1114,187,1114,188,1114,189,1114,},[130]={ 88,1078 ,89,1078 ,90,1078 ,91,1078 ,92,1078 ,93,1078 ,114,1079,115,1079,116,1079,117,1079,164,1114,165,1114,166,1117,167,1117,168,1117,169,1117,170,1117,171,1117,172,1117,173,1117,174,1117,175,1117,176,1117,177,1117,178,1111,179,1111,180,1114,181,1114,182,1116,183,1116,184,1117,185,1117,186,1114,187,1114,188,1117,189,1117,190,1117,191,1117,},[131]={ 88,1078 ,89,1078 ,90,1078 ,91,1078 ,92,1078 ,93,1078 ,114,1079,115,1079,116,1079,117,1079,164,1114,165,1114,166,1117,167,1117,168,1117,169,1117,170,1117,171,1117,172,1117,173,1117,174,1117,175,1117,176,1117,177,1117,178,1111,179,1111,180,1114,181,1114,182,1116,183,1116,184,1117,185,1117,186,1114,187,1114,188,1117,189,1117,190,1117,191,1117,},[132]={ 90,1078 ,91,1078 ,92,1078 ,93,1078 ,114,1066,115,1066,116,1066,117,1066,162,1116,163,1116,164,1114,165,1114,166,1114,167,1114,188,1117,189,1117,190,1108,191,1108,192,1108,193,1108,},[133]={ 90,1078 ,91,1078 ,92,1078 ,93,1078 ,114,1066,115,1066,116,1066,117,1066,162,1116,163,1116,164,1114,165,1114,166,1114,167,1114,188,1117,189,1117,190,1108,191,1108,192,1108,193,1108,},[134]={ 90,1078 ,91,1078 ,92,1078 ,93,1078 ,114,1066,115,1066,116,1066,117,1066,160,1111,161,1111,162,1116,163,1116,164,1116,165,1116,190,1108,191,1108,192,1125,193,1125,194,1125,195,1125,},[135]={ 90,1078 ,91,1078 ,92,1078 ,93,1078 ,114,1066,115,1066,116,1066,117,1066,160,1111,161,1111,162,1116,163,1116,164,1116,165,1116,190,1108,191,1108,192,1125,193,1125,194,1125,195,1125,},[136]={ 90,1078 ,91,1078 ,92,1078 ,93,1078 ,114,1066,115,1066,116,1066,117,1066,158,1116,159,1116,160,1111,161,1111,162,1111,163,1111,192,1125,193,1125,194,1129,195,1129,196,1129,197,1129,},[137]={ 90,1078 ,91,1078 ,92,1078 ,93,1078 ,114,1066,115,1066,116,1066,117,1066,158,1116,159,1116,160,1111,161,1111,162,1111,163,1111,192,1125,193,1125,194,1129,195,1129,196,1129,197,1129,},[138]={ 90,1078 ,91,1078 ,92,1078 ,93,1078 ,114,1066,115,1066,116,1066,117,1066,156,1116,157,1116,158,1116,159,1116,160,1116,161,1116,194,1129,195,1129,196,1130,197,1130,198,1130,199,1130,},[139]={ 90,1078 ,91,1078 ,92,1078 ,93,1078 ,114,1066,115,1066,116,1066,117,1066,156,1116,157,1116,158,1116,159,1116,160,1116,161,1116,194,1129,195,1129,196,1130,197,1130,198,1130,199,1130,},[140]={ 90,1078 ,91,1078 ,92,1078 ,93,1078 ,114,1066,115,1066,116,1066,117,1066,154,1114,155,1114,156,1116,157,1116,158,1116,159,1116,196,1130,197,1130,198,1130,199,1130,200,1130,201,1130,},[141]={ 90,1078 ,91,1078 ,92,1078 ,93,1078 ,114,1066,115,1066,116,1066,117,1066,154,1114,155,1114,156,1116,157,1116,158,1116,159,1116,196,1130,197,1130,198,1130,199,1130,200,1130,201,1130,},[142]={ 90,1078 ,91,1078 ,92,1078 ,93,1078 ,114,1066,115,1066,116,1066,117,1066,154,1114,155,1114,156,1114,157,1114,198,1130,199,1130,200,1117,201,1117,202,1117,203,1117,},[143]={ 90,1078 ,91,1078 ,92,1078 ,93,1078 ,114,1066,115,1066,116,1066,117,1066,154,1114,155,1114,156,1114,157,1114,198,1130,199,1130,200,1117,201,1117,202,1117,203,1117,},[144]={ 90,1078 ,91,1078 ,92,1078 ,93,1078 ,114,1066,115,1066,116,1066,117,1066,154,1111,155,1111,156,1111,157,1111,200,1117,201,1117,202,1127,203,1127,204,1127,205,1127,},[145]={ 90,1078 ,91,1078 ,92,1078 ,93,1078 ,114,1066,115,1066,116,1066,117,1066,154,1111,155,1111,156,1111,157,1111,200,1117,201,1117,202,1127,203,1127,204,1127,205,1127,},[146]={ 90,1078 ,91,1078 ,92,1078 ,93,1078 ,114,1066,115,1066,116,1066,117,1066,154,1105,155,1105,156,1105,157,1105,202,1127,203,1127,204,1139,205,1139,206,1139,207,1139,},[147]={ 90,1078 ,91,1078 ,92,1078 ,93,1078 ,114,1066,115,1066,116,1066,117,1066,154,1105,155,1105,156,1105,157,1105,202,1127,203,1127,204,1139,205,1139,206,1139,207,1139,},[148]={ 90,1078 ,91,1078 ,92,1078 ,93,1078 ,114,1066,115,1066,116,1066,117,1066,154,1105,155,1105,156,1105,157,1105,204,1139,205,1139,206,1139,207,1139,208,1144,209,1144,},[149]={ 90,1078 ,91,1078 ,92,1078 ,93,1078 ,114,1066,115,1066,116,1066,117,1066,154,1105,155,1105,156,1105,157,1105,204,1139,205,1139,206,1139,207,1139,208,1144,209,1144,},[150]={ 90,1078 ,91,1078 ,92,1078 ,93,1078 ,114,1066,115,1066,116,1066,117,1066,154,1105,155,1105,156,1105,157,1105,206,1144,207,1144,208,1134,209,1134,210,1134,211,1134,},[151]={ 90,1078 ,91,1078 ,92,1078 ,93,1078 ,114,1066,115,1066,116,1066,117,1066,154,1105,155,1105,156,1105,157,1105,206,1144,207,1144,208,1134,209,1134,210,1134,211,1134,},[152]={ 90,1078 ,91,1078 ,92,1078 ,93,1078 ,114,1066,115,1066,116,1066,117,1066,154,1106,155,1106,156,1106,157,1106,208,1139,209,1139,210,1139,211,1139,},[153]={ 90,1078 ,91,1078 ,92,1078 ,93,1078 ,114,1066,115,1066,116,1066,117,1066,154,1106,155,1106,156,1106,157,1106,208,1139,209,1139,210,1139,211,1139,},[154]={ 90,1078 ,91,1078 ,92,1078 ,93,1078 ,114,1066,115,1066,116,1066,117,1066,154,1107,155,1107,156,1107,157,1107,208,1148,209,1148,210,1148,211,1148,},[155]={ 90,1078 ,91,1078 ,92,1078 ,93,1078 ,114,1066,115,1066,116,1066,117,1066,154,1107,155,1107,156,1107,157,1107,208,1148,209,1148,210,1148,211,1148,},[156]={ 90,1078 ,91,1078 ,92,1078 ,93,1078 ,114,1066,115,1066,116,1066,117,1066,154,1109,155,1109,156,1109,157,1109,178,1001,179,1001,180,1001,181,1001,182,299 ,183,299 ,184,299 ,185,299 ,186,299 ,187,299 ,208,1152,209,1152,210,1152,211,1152,},[157]={ 90,1078 ,91,1078 ,92,1078 ,93,1078 ,114,1066,115,1066,116,1066,117,1066,154,1109,155,1109,156,1109,157,1109,178,1001,179,1001,180,1001,181,1001,182,299 ,183,299 ,184,299 ,185,299 ,186,299 ,187,299 ,208,1152,209,1152,210,1152,211,1152,},[158]={ 90,1078 ,91,1078 ,92,1078 ,93,1078 ,114,1066,115,1066,116,1066,117,1066,154,1113,155,1113,156,1113,157,1113,178,1004,179,1004,180,1004,181,1004,182,299 ,183,299 ,184,299 ,185,299 ,186,299 ,187,299 ,208,1154,209,1154,210,1154,211,1154,},[159]={ 90,1078 ,91,1078 ,92,1078 ,93,1078 ,114,1066,115,1066,116,1066,117,1066,154,1113,155,1113,156,1113,157,1113,178,1004,179,1004,180,1004,181,1004,182,299 ,183,299 ,184,299 ,185,299 ,186,299 ,187,299 ,208,1154,209,1154,210,1154,211,1154,},[160]={ 90,1079 ,91,1079 ,92,1079 ,93,1079 ,114,1066,115,1066,116,1066,117,1066,154,1108,155,1108,156,1108,157,1108,178,1004,179,1004,180,1004,181,1004,182,299 ,183,299 ,184,299 ,185,299 ,186,299 ,187,299 ,208,1155,209,1155,210,1155,211,1155,},[161]={ 90,1079 ,91,1079 ,92,1079 ,93,1079 ,114,1066,115,1066,116,1066,117,1066,154,1108,155,1108,156,1108,157,1108,178,1004,179,1004,180,1004,181,1004,182,299 ,183,299 ,184,299 ,185,299 ,186,299 ,187,299 ,208,1155,209,1155,210,1155,211,1155,},[162]={ 90,1080 ,91,1080 ,92,1080 ,93,1080 ,114,1066,115,1066,116,1066,117,1066,154,1111,155,1111,156,1111,157,1111,178,1010,179,1010,180,1010,181,1010,182,299 ,183,299 ,184,299 ,185,299 ,186,299 ,187,299 ,208,1149,209,1149,210,1149,211,1149,},[163]={ 90,1080 ,91,1080 ,92,1080 ,93,1080 ,114,1066,115,1066,116,1066,117,1066,154,1111,155,1111,156,1111,157,1111,178,1010,179,1010,180,1010,181,1010,182,299 ,183,299 ,184,299 ,185,299 ,186,299 ,187,299 ,208,1149,209,1149,210,1149,211,1149,},[164]={ 90,1082 ,91,1082 ,92,1082 ,93,1082 ,114,1066,115,1066,116,1066,117,1066,154,1118,155,1118,156,1118,157,1118,178,1018,179,1018,180,1018,181,1018,182,299 ,183,299 ,184,299 ,185,299 ,186,299 ,187,299 ,208,1146,209,1146,210,1146,211,1146,},[165]={ 90,1082 ,91,1082 ,92,1082 ,93,1082 ,114,1066,115,1066,116,1066,117,1066,154,1118,155,1118,156,1118,157,1118,178,1018,179,1018,180,1018,181,1018,182,299 ,183,299 ,184,299 ,185,299 ,186,299 ,187,299 ,208,1146,209,1146,210,1146,211,1146,},[166]={ 90,1087 ,91,1087 ,92,1087 ,93,1087 ,114,1066,115,1066,116,1066,117,1066,154,1118,155,1118,156,1118,157,1118,178,1022,179,1022,180,1022,181,1022,182,299 ,183,299 ,184,299 ,185,299 ,186,299 ,187,299 ,208,1151,209,1151,210,1151,211,1151,},[167]={ 90,1087 ,91,1087 ,92,1087 ,93,1087 ,114,1066,115,1066,116,1066,117,1066,154,1118,155,1118,156,1118,157,1118,178,1022,179,1022,180,1022,181,1022,182,299 ,183,299 ,184,299 ,185,299 ,186,299 ,187,299 ,208,1151,209,1151,210,1151,211,1151,},[168]={ 90,1091 ,91,1091 ,92,1091 ,93,1091 ,114,1066,115,1066,116,1066,117,1066,154,1118,155,1118,156,1118,157,1118,178,1024,179,1024,180,1024,181,1024,182,312 ,183,312 ,184,312 ,185,312 ,186,312 ,187,312 ,208,1154,209,1154,210,1154,211,1154,},[169]={ 90,1091 ,91,1091 ,92,1091 ,93,1091 ,114,1066,115,1066,116,1066,117,1066,154,1118,155,1118,156,1118,157,1118,178,1024,179,1024,180,1024,181,1024,182,312 ,183,312 ,184,312 ,185,312 ,186,312 ,187,312 ,208,1154,209,1154,210,1154,211,1154,},[170]={ 2,1156 ,3,1156 ,4,1150 ,5,1150 ,6,1140 ,7,1140 ,8,1135 ,9,1135 ,10,1139 ,11,1139 ,12,1141 ,13,1141 ,14,1136 ,15,1136 ,16,1133 ,17,1133 ,18,1125 ,19,1125 ,20,1121 ,21,1121 ,22,1126 ,23,1126 ,24,1128 ,25,1128 ,26,1123 ,27,1123 ,28,1120 ,29,1120 ,30,1119 ,31,1119 ,32,1125 ,33,1125 ,34,1123 ,35,1123 ,36,1123 ,37,1123 ,88,1090 ,89,1090 ,90,1091 ,91,1091 ,92,1091 ,93,1091 ,114,1066,115,1066,116,1066,117,1066,154,1118,155,1118,156,1118,157,1118,178,1025,179,1025,180,1025,181,1025,182,312 ,183,312 ,184,312 ,185,312 ,186,312 ,187,312 ,208,1154,209,1154,210,1154,211,1154,},[171]={ 2,1156 ,3,1156 ,4,1150 ,5,1150 ,6,1140 ,7,1140 ,8,1135 ,9,1135 ,10,1139 ,11,1139 ,12,1141 ,13,1141 ,14,1136 ,15,1136 ,16,1133 ,17,1133 ,18,1125 ,19,1125 ,20,1121 ,21,1121 ,22,1126 ,23,1126 ,24,1128 ,25,1128 ,26,1123 ,27,1123 ,28,1120 ,29,1120 ,30,1119 ,31,1119 ,32,1125 ,33,1125 ,34,1123 ,35,1123 ,36,1123 ,37,1123 ,88,1090 ,89,1090 ,90,1091 ,91,1091 ,92,1091 ,93,1091 ,114,1066,115,1066,116,1066,117,1066,154,1118,155,1118,156,1118,157,1118,178,1025,179,1025,180,1025,181,1025,182,312 ,183,312 ,184,312 ,185,312 ,186,312 ,187,312 ,208,1154,209,1154,210,1154,211,1154,},[172]={ 0,1169 ,1,1169 ,2,1156 ,3,1156 ,4,1150 ,5,1150 ,6,1140 ,7,1140 ,8,1135 ,9,1135 ,10,1139 ,11,1139 ,12,1141 ,13,1141 ,14,1136 ,15,1136 ,16,1133 ,17,1133 ,18,1125 ,19,1125 ,20,1121 ,21,1121 ,22,1126 ,23,1126 ,24,1128 ,25,1128 ,26,1123 ,27,1123 ,28,1120 ,29,1120 ,30,1119 ,31,1119 ,32,1125 ,33,1125 ,34,1123 ,35,1123 ,36,1123 ,37,1123 ,38,1124 ,39,1124 ,86,1087 ,87,1087 ,88,1090 ,89,1090 ,90,1090 ,91,1090 ,114,1066,115,1066,116,1066,117,1066,154,1118,155,1118,156,1118,157,1118,178,1024,179,1024,180,1024,181,1024,182,325 ,183,325 ,184,325 ,185,325 ,186,325 ,187,325 ,208,1157,209,1157,210,1137,211,1137,212,1137,213,1137,},[173]={ 0,1169 ,1,1169 ,2,1156 ,3,1156 ,4,1150 ,5,1150 ,6,1140 ,7,1140 ,8,1135 ,9,1135 ,10,1139 ,11,1139 ,12,1141 ,13,1141 ,14,1136 ,15,1136 ,16,1133 ,17,1133 ,18,1125 ,19,1125 ,20,1121 ,21,1121 ,22,1126 ,23,1126 ,24,1128 ,25,1128 ,26,1123 ,27,1123 ,28,1120 ,29,1120 ,30,1119 ,31,1119 ,32,1125 ,33,1125 ,34,1123 ,35,1123 ,36,1123 ,37,1123 ,38,1124 ,39,1124 ,86,1087 ,87,1087 ,88,1090 ,89,1090 ,90,1090 ,91,1090 ,114,1066,115,1066,116,1066,117,1066,154,1118,155,1118,156,1118,157,1118,178,1024,179,1024,180,1024,181,1024,182,325 ,183,325 ,184,325 ,185,325 ,186,325 ,187,325 ,208,1157,209,1157,210,1137,211,1137,212,1137,213,1137,},[174]={ 0,1169 ,1,1169 ,2,1169 ,3,1169 ,36,1124 ,37,1124 ,38,1126 ,39,1126 ,40,1126 ,41,1126 ,84,1090 ,85,1090 ,86,1087 ,87,1087 ,88,1087 ,89,1087 ,114,1066,115,1066,116,1066,117,1066,154,1118,155,1118,156,1116,157,1116,158,1116,159,1116,176,1020,177,1020,178,1023,179,1023,180,1023,181,1023,182,325 ,183,325 ,184,325 ,185,325 ,186,325 ,187,325 ,210,1137,211,1137,212,1145,213,1145,214,1145,215,1145,254,1167,255,1167,},[175]={ 0,1169 ,1,1169 ,2,1169 ,3,1169 ,36,1124 ,37,1124 ,38,1126 ,39,1126 ,40,1126 ,41,1126 ,84,1090 ,85,1090 ,86,1087 ,87,1087 ,88,1087 ,89,1087 ,114,1066,115,1066,116,1066,117,1066,154,1118,155,1118,156,1116,157,1116,158,1116,159,1116,176,1020,177,1020,178,1023,179,1023,180,1023,181,1023,182,325 ,183,325 ,184,325 ,185,325 ,186,325 ,187,325 ,210,1137,211,1137,212,1145,213,1145,214,1145,215,1145,254,1167,255,1167,},[176]={ 0,1167 ,1,1167 ,38,1126 ,39,1126 ,40,1136 ,41,1136 ,42,1136 ,43,1136 ,82,1088 ,83,1088 ,84,1090 ,85,1090 ,86,1090 ,87,1090 ,114,1066,115,1066,116,1066,117,1066,156,1116,157,1116,158,1116,159,1116,160,1111,161,1111,174,1013,175,1013,176,1020,177,1020,178,1025,179,1025,180,1025,181,1025,182,325 ,183,325 ,184,325 ,185,325 ,186,325 ,187,325 ,212,1145,213,1145,214,1137,215,1137,216,1137,217,1137,252,1158,253,1158,254,1167,255,1167,},[177]={ 0,1167 ,1,1167 ,38,1126 ,39,1126 ,40,1136 ,41,1136 ,42,1136 ,43,1136 ,82,1088 ,83,1088 ,84,1090 ,85,1090 ,86,1090 ,87,1090 ,114,1066,115,1066,116,1066,117,1066,156,1116,157,1116,158,1116,159,1116,160,1111,161,1111,174,1013,175,1013,176,1020,177,1020,178,1025,179,1025,180,1025,181,1025,182,325 ,183,325 ,184,325 ,185,325 ,186,325 ,187,325 ,212,1145,213,1145,214,1137,215,1137,216,1137,217,1137,252,1158,253,1158,254,1167,255,1167,},[178]={ 40,1136 ,41,1136 ,42,1135 ,43,1135 ,44,1135 ,45,1135 ,80,1094 ,81,1094 ,82,1088 ,83,1088 ,84,1088 ,85,1088 ,114,1067,115,1067,116,1067,117,1067,158,1111,159,1111,160,1111,161,1111,162,1105,163,1105,172,1013,173,1013,174,1013,175,1013,176,1013,177,1013,178,1025,179,1025,180,1026,181,1026,182,1026,183,1026,184,1026,185,1026,186,1026,187,1026,214,1137,215,1137,216,1139,217,1139,218,1139,219,1139,250,1149,251,1149,252,1158,253,1158,254,1158,255,1158,},[179]={ 40,1136 ,41,1136 ,42,1135 ,43,1135 ,44,1135 ,45,1135 ,80,1094 ,81,1094 ,82,1088 ,83,1088 ,84,1088 ,85,1088 ,114,1067,115,1067,116,1067,117,1067,158,1111,159,1111,160,1111,161,1111,162,1105,163,1105,172,1013,173,1013,174,1013,175,1013,176,1013,177,1013,178,1025,179,1025,180,1026,181,1026,182,1026,183,1026,184,1026,185,1026,186,1026,187,1026,214,1137,215,1137,216,1139,217,1139,218,1139,219,1139,250,1149,251,1149,252,1158,253,1158,254,1158,255,1158,},[180]={ 42,1135 ,43,1135 ,44,1132 ,45,1132 ,46,1132 ,47,1132 ,78,1102 ,79,1102 ,80,1102 ,81,1102 ,82,1094 ,83,1094 ,112,1079,113,1079,114,1069,115,1069,116,1069,117,1069,160,1097,161,1097,162,1097,163,1097,172,1013,173,1013,174,1013,175,1013,176,1014,177,1014,178,1027,179,1027,180,1026,181,1026,182,1026,183,1026,184,1026,185,1026,186,1026,187,1026,216,1139,217,1139,218,1149,219,1149,220,1149,221,1149,248,1153,249,1153,250,1149,251,1149,252,1149,253,1149,},[181]={ 42,1135 ,43,1135 ,44,1132 ,45,1132 ,46,1132 ,47,1132 ,78,1102 ,79,1102 ,80,1102 ,81,1102 ,82,1094 ,83,1094 ,112,1079,113,1079,114,1069,115,1069,116,1069,117,1069,160,1097,161,1097,162,1097,163,1097,172,1013,173,1013,174,1013,175,1013,176,1014,177,1014,178,1027,179,1027,180,1026,181,1026,182,1026,183,1026,184,1026,185,1026,186,1026,187,1026,216,1139,217,1139,218,1149,219,1149,220,1149,221,1149,248,1153,249,1153,250,1149,251,1149,252,1149,253,1149,},[182]={ 44,1132 ,45,1132 ,46,1131 ,47,1131 ,48,1131 ,49,1131 ,76,1105 ,77,1105 ,78,1102 ,79,1102 ,80,1102 ,81,1102 ,110,1080,111,1080,112,1079,113,1079,114,1079,115,1079,160,1097,161,1097,162,1097,163,1097,172,1013,173,1013,174,1013,175,1013,184,1026,185,1026,186,1026,187,1026,218,1149,219,1149,220,1162,221,1162,222,1162,223,1162,246,1154,247,1154,248,1153,249,1153,250,1153,251,1153,},[183]={ 44,1132 ,45,1132 ,46,1131 ,47,1131 ,48,1131 ,49,1131 ,76,1105 ,77,1105 ,78,1102 ,79,1102 ,80,1102 ,81,1102 ,110,1080,111,1080,112,1079,113,1079,114,1079,115,1079,160,1097,161,1097,162,1097,163,1097,172,1013,173,1013,174,1013,175,1013,184,1026,185,1026,186,1026,187,1026,218,1149,219,1149,220,1162,221,1162,222,1162,223,1162,246,1154,247,1154,248,1153,249,1153,250,1153,251,1153,},[184]={ 46,1131 ,47,1131 ,48,1124 ,49,1124 ,50,1114 ,51,1114 ,52,1109 ,53,1109 ,54,1107 ,55,1107 ,56,1106 ,57,1106 ,58,1105 ,59,1105 ,60,1105 ,61,1105 ,62,1111 ,63,1111 ,64,1114 ,65,1114 ,66,1109 ,67,1109 ,68,1107 ,69,1107 ,70,1106 ,71,1106 ,72,1105 ,73,1105 ,74,1108 ,75,1108 ,76,1105 ,77,1105 ,78,1105 ,79,1105 ,108,1083,109,1083,110,1080,111,1080,112,1080,113,1080,160,1090,161,1090,162,1090,163,1090,172,1013,173,1013,174,1013,175,1013,184,1026,185,1026,186,1026,187,1026,220,1162,221,1162,222,1162,223,1162,224,1160,225,1160,244,1148,245,1148,246,1154,247,1154,248,1154,249,1154,},[185]={ 46,1131 ,47,1131 ,48,1124 ,49,1124 ,50,1114 ,51,1114 ,52,1109 ,53,1109 ,54,1107 ,55,1107 ,56,1106 ,57,1106 ,58,1105 ,59,1105 ,60,1105 ,61,1105 ,62,1111 ,63,1111 ,64,1114 ,65,1114 ,66,1109 ,67,1109 ,68,1107 ,69,1107 ,70,1106 ,71,1106 ,72,1105 ,73,1105 ,74,1108 ,75,1108 ,76,1105 ,77,1105 ,78,1105 ,79,1105 ,108,1083,109,1083,110,1080,111,1080,112,1080,113,1080,160,1090,161,1090,162,1090,163,1090,172,1013,173,1013,174,1013,175,1013,184,1026,185,1026,186,1026,187,1026,220,1162,221,1162,222,1162,223,1162,224,1160,225,1160,244,1148,245,1148,246,1154,247,1154,248,1154,249,1154,},[186]={ 48,1124 ,49,1124 ,50,1114 ,51,1114 ,52,1109 ,53,1109 ,54,1107 ,55,1107 ,56,1106 ,57,1106 ,58,1105 ,59,1105 ,60,1105 ,61,1105 ,62,1111 ,63,1111 ,64,1114 ,65,1114 ,66,1109 ,67,1109 ,68,1107 ,69,1107 ,70,1106 ,71,1106 ,72,1105 ,73,1105 ,74,1108 ,75,1108 ,76,1108 ,77,1108 ,106,1098,107,1098,108,1083,109,1083,110,1083,111,1083,160,1089,161,1089,162,1089,163,1089,172,1013,173,1013,174,1013,175,1013,184,1026,185,1026,186,1026,187,1026,222,1160,223,1160,224,1164,225,1164,226,1167,227,1167,228,1168,229,1168,230,1169,231,1169,232,1169,233,1169,234,1169,235,1169,236,1169,237,1169,238,1169,239,1169,240,1156,241,1156,242,1150,243,1150,244,1148,245,1148,246,1148,247,1148,},[187]={ 48,1124 ,49,1124 ,50,1114 ,51,1114 ,52,1109 ,53,1109 ,54,1107 ,55,1107 ,56,1106 ,57,1106 ,58,1105 ,59,1105 ,60,1105 ,61,1105 ,62,1111 ,63,1111 ,64,1114 ,65,1114 ,66,1109 ,67,1109 ,68,1107 ,69,1107 ,70,1106 ,71,1106 ,72,1105 ,73,1105 ,74,1108 ,75,1108 ,76,1108 ,77,1108 ,106,1098,107,1098,108,1083,109,1083,110,1083,111,1083,160,1089,161,1089,162,1089,163,1089,172,1013,173,1013,174,1013,175,1013,184,1026,185,1026,186,1026,187,1026,222,1160,223,1160,224,1164,225,1164,226,1167,227,1167,228,1168,229,1168,230,1169,231,1169,232,1169,233,1169,234,1169,235,1169,236,1169,237,1169,238,1169,239,1169,240,1156,241,1156,242,1150,243,1150,244,1148,245,1148,246,1148,247,1148,},[188]={ 104,1096,105,1096,106,1096,107,1096,108,1098,109,1098,160,1086,161,1086,162,1086,163,1086,172,1013,173,1013,174,1013,175,1013,184,1026,185,1026,186,1026,187,1026,188,1026,189,1026,224,1164,225,1164,226,1167,227,1167,228,1168,229,1168,230,1169,231,1169,232,1169,233,1169,234,1169,235,1169,236,1169,237,1169,238,1169,239,1169,240,1156,241,1156,242,1150,243,1150,244,1150,245,1150,},[189]={ 104,1096,105,1096,106,1096,107,1096,108,1098,109,1098,160,1086,161,1086,162,1086,163,1086,172,1013,173,1013,174,1013,175,1013,184,1026,185,1026,186,1026,187,1026,188,1026,189,1026,224,1164,225,1164,226,1167,227,1167,228,1168,229,1168,230,1169,231,1169,232,1169,233,1169,234,1169,235,1169,236,1169,237,1169,238,1169,239,1169,240,1156,241,1156,242,1150,243,1150,244,1150,245,1150,},[190]={ 14,255 ,15,255 ,16,318 ,17,318 ,18,336 ,19,336 ,20,332 ,21,332 ,22,182 ,23,182 ,102,1104,103,1104,104,1096,105,1096,106,1096,107,1096,160,1080,161,1080,162,1080,163,1080,172,1013,173,1013,174,1013,175,1013,186,1026,187,1026,188,1026,189,1026,190,1026,191,1026,},[191]={ 14,255 ,15,255 ,16,318 ,17,318 ,18,336 ,19,336 ,20,332 ,21,332 ,22,182 ,23,182 ,102,1104,103,1104,104,1096,105,1096,106,1096,107,1096,160,1080,161,1080,162,1080,163,1080,172,1013,173,1013,174,1013,175,1013,186,1026,187,1026,188,1026,189,1026,190,1026,191,1026,},[192]={ 14,354 ,15,354 ,16,471 ,17,471 ,18,489 ,19,489 ,20,404 ,21,404 ,22,221 ,23,221 ,100,1104,101,1104,102,1104,103,1104,104,1104,105,1104,160,1081,161,1081,162,1081,163,1081,172,1013,173,1013,174,1013,175,1013,188,1026,189,1026,190,1026,191,1026,192,1026,193,1026,},[193]={ 14,354 ,15,354 ,16,471 ,17,471 ,18,489 ,19,489 ,20,404 ,21,404 ,22,221 ,23,221 ,100,1104,101,1104,102,1104,103,1104,104,1104,105,1104,160,1081,161,1081,162,1081,163,1081,172,1013,173,1013,174,1013,175,1013,188,1026,189,1026,190,1026,191,1026,192,1026,193,1026,},[194]={ 14,381 ,15,381 ,16,543 ,17,543 ,18,543 ,19,543 ,20,462 ,21,462 ,22,260 ,23,260 ,98,1104 ,99,1104 ,100,1104,101,1104,102,1104,103,1104,160,1084,161,1084,162,1084,163,1084,172,1013,173,1013,174,1013,175,1013,190,1026,191,1026,192,1026,193,1026,194,1026,195,1026,},[195]={ 14,381 ,15,381 ,16,543 ,17,543 ,18,543 ,19,543 ,20,462 ,21,462 ,22,260 ,23,260 ,98,1104 ,99,1104 ,100,1104,101,1104,102,1104,103,1104,160,1084,161,1084,162,1084,163,1084,172,1013,173,1013,174,1013,175,1013,190,1026,191,1026,192,1026,193,1026,194,1026,195,1026,},[196]={ 14,390 ,15,390 ,16,543 ,17,543 ,18,543 ,19,543 ,20,471 ,21,471 ,22,281 ,23,281 ,96,1117 ,97,1117 ,98,1104 ,99,1104 ,100,1104,101,1104,160,1089,161,1089,162,1089,163,1089,172,1013,173,1013,174,1013,175,1013,192,1026,193,1026,194,1026,195,1026,196,1026,197,1026,},[197]={ 14,390 ,15,390 ,16,543 ,17,543 ,18,543 ,19,543 ,20,471 ,21,471 ,22,281 ,23,281 ,96,1117 ,97,1117 ,98,1104 ,99,1104 ,100,1104,101,1104,160,1089,161,1089,162,1089,163,1089,172,1013,173,1013,174,1013,175,1013,192,1026,193,1026,194,1026,195,1026,196,1026,197,1026,},[198]={ 14,381 ,15,381 ,16,552 ,17,552 ,18,543 ,19,543 ,20,471 ,21,471 ,22,286 ,23,286 ,94,1117 ,95,1117 ,96,1117 ,97,1117 ,98,1117 ,99,1117 ,160,1099,161,1099,162,1099,163,1099,172,1013,173,1013,174,1013,175,1013,194,1026,195,1026,196,1026,197,1026,198,1026,199,1026,},[199]={ 14,381 ,15,381 ,16,552 ,17,552 ,18,543 ,19,543 ,20,471 ,21,471 ,22,286 ,23,286 ,94,1117 ,95,1117 ,96,1117 ,97,1117 ,98,1117 ,99,1117 ,160,1099,161,1099,162,1099,163,1099,172,1013,173,1013,174,1013,175,1013,194,1026,195,1026,196,1026,197,1026,198,1026,199,1026,},[200]={ 14,372 ,15,372 ,16,543 ,17,543 ,18,543 ,19,543 ,20,471 ,21,471 ,22,282 ,23,282 ,92,1117 ,93,1117 ,94,1117 ,95,1117 ,96,1117 ,97,1117 ,160,1106,161,1106,162,1106,163,1106,172,1013,173,1013,174,1013,175,1013,196,1026,197,1026,198,1026,199,1026,200,1026,201,1026,},[201]={ 14,372 ,15,372 ,16,543 ,17,543 ,18,543 ,19,543 ,20,471 ,21,471 ,22,282 ,23,282 ,92,1117 ,93,1117 ,94,1117 ,95,1117 ,96,1117 ,97,1117 ,160,1106,161,1106,162,1106,163,1106,172,1013,173,1013,174,1013,175,1013,196,1026,197,1026,198,1026,199,1026,200,1026,201,1026,},[202]={ 14,371 ,15,371 ,16,525 ,17,525 ,18,543 ,19,543 ,20,477 ,21,477 ,22,269 ,23,269 ,90,1117 ,91,1117 ,92,1117 ,93,1117 ,94,1117 ,95,1117 ,160,1108,161,1108,162,1108,163,1108,172,1013,173,1013,174,1013,175,1013,198,1026,199,1026,200,1026,201,1026,202,1026,203,1026,},[203]={ 14,371 ,15,371 ,16,525 ,17,525 ,18,543 ,19,543 ,20,477 ,21,477 ,22,269 ,23,269 ,90,1117 ,91,1117 ,92,1117 ,93,1117 ,94,1117 ,95,1117 ,160,1108,161,1108,162,1108,163,1108,172,1013,173,1013,174,1013,175,1013,198,1026,199,1026,200,1026,201,1026,202,1026,203,1026,},[204]={ 14,335 ,15,335 ,16,476 ,17,476 ,18,503 ,19,503 ,20,449 ,21,449 ,22,247 ,23,247 ,88,1116 ,89,1116 ,90,1117 ,91,1117 ,92,1117 ,93,1117 ,160,1111,161,1111,162,1111,163,1111,172,1013,173,1013,174,1013,175,1013,200,1026,201,1026,202,1026,203,1026,204,1026,205,1026,},[205]={ 14,335 ,15,335 ,16,476 ,17,476 ,18,503 ,19,503 ,20,449 ,21,449 ,22,247 ,23,247 ,88,1116 ,89,1116 ,90,1117 ,91,1117 ,92,1117 ,93,1117 ,160,1111,161,1111,162,1111,163,1111,172,1013,173,1013,174,1013,175,1013,200,1026,201,1026,202,1026,203,1026,204,1026,205,1026,},[206]={ 14,243 ,15,243 ,16,342 ,17,342 ,18,343 ,19,343 ,20,338 ,21,338 ,22,204 ,23,204 ,86,1111 ,87,1111 ,88,1116 ,89,1116 ,90,1116 ,91,1116 ,160,1118,161,1118,162,1118,163,1118,172,1013,173,1013,174,1013,175,1013,202,1026,203,1026,204,1026,205,1026,206,1026,207,1026,},[207]={ 14,243 ,15,243 ,16,342 ,17,342 ,18,343 ,19,343 ,20,338 ,21,338 ,22,204 ,23,204 ,86,1111 ,87,1111 ,88,1116 ,89,1116 ,90,1116 ,91,1116 ,160,1118,161,1118,162,1118,163,1118,172,1013,173,1013,174,1013,175,1013,202,1026,203,1026,204,1026,205,1026,206,1026,207,1026,},[208]={ 84,1092 ,85,1092 ,86,1111 ,87,1111 ,88,1111 ,89,1111 ,160,1118,161,1118,162,1118,163,1118,172,1013,173,1013,174,1013,175,1013,204,1026,205,1026,206,1026,207,1026,208,1026,209,1026,},[209]={ 84,1092 ,85,1092 ,86,1111 ,87,1111 ,88,1111 ,89,1111 ,160,1118,161,1118,162,1118,163,1118,172,1013,173,1013,174,1013,175,1013,204,1026,205,1026,206,1026,207,1026,208,1026,209,1026,},[210]={ 48,1066 ,49,1066 ,50,1066 ,51,1066 ,52,1066 ,53,1066 ,54,1066 ,55,1066 ,56,1066 ,57,1066 ,58,1066 ,59,1066 ,60,1066 ,61,1066 ,62,1066 ,63,1066 ,64,1066 ,65,1066 ,66,1066 ,67,1066 ,68,1066 ,69,1066 ,70,1066 ,71,1066 ,72,1066 ,73,1066 ,74,1066 ,75,1066 ,76,1066 ,77,1066 ,78,1066 ,79,1066 ,80,1066 ,81,1066 ,82,1066 ,83,1066 ,84,1092 ,85,1092 ,86,1092 ,87,1092 ,160,1119,161,1119,162,1119,163,1119,172,1013,173,1013,174,1013,175,1013,206,1026,207,1026,208,1026,209,1026,210,1026,211,1026,212,1026,213,1026,214,1026,215,1026,216,1026,217,1026,218,1026,219,1026,220,1026,221,1026,222,1026,223,1026,224,1026,225,1026,226,1026,227,1026,228,1026,229,1026,230,1026,231,1026,232,1026,233,1026,234,1026,235,1026,236,1026,237,1026,238,1026,239,1026,240,1026,241,1026,242,1026,243,1026,244,1026,245,1026,246,1026,247,1026,},[211]={ 48,1066 ,49,1066 ,50,1066 ,51,1066 ,52,1066 ,53,1066 ,54,1066 ,55,1066 ,56,1066 ,57,1066 ,58,1066 ,59,1066 ,60,1066 ,61,1066 ,62,1066 ,63,1066 ,64,1066 ,65,1066 ,66,1066 ,67,1066 ,68,1066 ,69,1066 ,70,1066 ,71,1066 ,72,1066 ,73,1066 ,74,1066 ,75,1066 ,76,1066 ,77,1066 ,78,1066 ,79,1066 ,80,1066 ,81,1066 ,82,1066 ,83,1066 ,84,1092 ,85,1092 ,86,1092 ,87,1092 ,160,1119,161,1119,162,1119,163,1119,172,1013,173,1013,174,1013,175,1013,206,1026,207,1026,208,1026,209,1026,210,1026,211,1026,212,1026,213,1026,214,1026,215,1026,216,1026,217,1026,218,1026,219,1026,220,1026,221,1026,222,1026,223,1026,224,1026,225,1026,226,1026,227,1026,228,1026,229,1026,230,1026,231,1026,232,1026,233,1026,234,1026,235,1026,236,1026,237,1026,238,1026,239,1026,240,1026,241,1026,242,1026,243,1026,244,1026,245,1026,246,1026,247,1026,},[212]={ 46,1066 ,47,1066 ,48,1066 ,49,1066 ,50,1066 ,51,1066 ,52,1066 ,53,1066 ,54,1066 ,55,1066 ,56,1066 ,57,1066 ,58,1066 ,59,1066 ,60,1066 ,61,1066 ,62,1066 ,63,1066 ,64,1066 ,65,1066 ,66,1066 ,67,1066 ,68,1066 ,69,1066 ,70,1066 ,71,1066 ,72,1066 ,73,1066 ,74,1066 ,75,1066 ,76,1066 ,77,1066 ,78,1066 ,79,1066 ,80,1066 ,81,1066 ,82,1066 ,83,1066 ,84,1066 ,85,1066 ,160,1121,161,1121,162,1121,163,1121,172,1013,173,1013,174,1013,175,1013,208,1026,209,1026,210,1026,211,1026,212,1026,213,1026,214,1026,215,1026,216,1026,217,1026,218,1026,219,1026,220,1026,221,1026,222,1026,223,1026,224,1026,225,1026,226,1026,227,1026,228,1026,229,1026,230,1026,231,1026,232,1026,233,1026,234,1026,235,1026,236,1026,237,1026,238,1026,239,1026,240,1026,241,1026,242,1026,243,1026,244,1026,245,1026,246,1026,247,1026,248,1026,249,1026,},[213]={ 46,1066 ,47,1066 ,48,1066 ,49,1066 ,50,1066 ,51,1066 ,52,1066 ,53,1066 ,54,1066 ,55,1066 ,56,1066 ,57,1066 ,58,1066 ,59,1066 ,60,1066 ,61,1066 ,62,1066 ,63,1066 ,64,1066 ,65,1066 ,66,1066 ,67,1066 ,68,1066 ,69,1066 ,70,1066 ,71,1066 ,72,1066 ,73,1066 ,74,1066 ,75,1066 ,76,1066 ,77,1066 ,78,1066 ,79,1066 ,80,1066 ,81,1066 ,82,1066 ,83,1066 ,84,1066 ,85,1066 ,160,1121,161,1121,162,1121,163,1121,172,1013,173,1013,174,1013,175,1013,208,1026,209,1026,210,1026,211,1026,212,1026,213,1026,214,1026,215,1026,216,1026,217,1026,218,1026,219,1026,220,1026,221,1026,222,1026,223,1026,224,1026,225,1026,226,1026,227,1026,228,1026,229,1026,230,1026,231,1026,232,1026,233,1026,234,1026,235,1026,236,1026,237,1026,238,1026,239,1026,240,1026,241,1026,242,1026,243,1026,244,1026,245,1026,246,1026,247,1026,248,1026,249,1026,},[214]={ 44,1066 ,45,1066 ,46,1066 ,47,1066 ,48,1066 ,49,1066 ,160,1124,161,1124,162,1124,163,1124,172,1013,173,1013,174,1013,175,1013,246,1026,247,1026,248,1026,249,1026,250,1026,251,1026,},[215]={ 44,1066 ,45,1066 ,46,1066 ,47,1066 ,48,1066 ,49,1066 ,160,1124,161,1124,162,1124,163,1124,172,1013,173,1013,174,1013,175,1013,246,1026,247,1026,248,1026,249,1026,250,1026,251,1026,},[216]={ 42,1067 ,43,1067 ,44,1066 ,45,1066 ,46,1066 ,47,1066 ,160,1131,161,1131,162,1131,163,1131,172,1013,173,1013,174,1013,175,1013,248,1026,249,1026,250,1026,251,1026,252,1026,253,1026,},[217]={ 42,1067 ,43,1067 ,44,1066 ,45,1066 ,46,1066 ,47,1066 ,160,1131,161,1131,162,1131,163,1131,172,1013,173,1013,174,1013,175,1013,248,1026,249,1026,250,1026,251,1026,252,1026,253,1026,},[218]={ 40,1070 ,41,1070 ,42,1067 ,43,1067 ,44,1067 ,45,1067 ,158,1131,159,1131,160,1131,161,1131,162,1131,163,1131,172,1013,173,1013,174,1013,175,1013,176,1013,177,1013,250,1026,251,1026,252,1026,253,1026,254,1026,255,1026,},[219]={ 40,1070 ,41,1070 ,42,1067 ,43,1067 ,44,1067 ,45,1067 ,158,1131,159,1131,160,1131,161,1131,162,1131,163,1131,172,1013,173,1013,174,1013,175,1013,176,1013,177,1013,250,1026,251,1026,252,1026,253,1026,254,1026,255,1026,},[220]={ 0,1026 ,1,1026 ,38,1084 ,39,1084 ,40,1070 ,41,1070 ,42,1070 ,43,1070 ,156,1131,157,1131,158,1131,159,1131,160,1131,161,1131,174,1013,175,1013,176,1013,177,1013,178,1013,179,1013,252,1026,253,1026,254,1026,255,1026,},[221]={ 0,1026 ,1,1026 ,38,1084 ,39,1084 ,40,1070 ,41,1070 ,42,1070 ,43,1070 ,156,1131,157,1131,158,1131,159,1131,160,1131,161,1131,174,1013,175,1013,176,1013,177,1013,178,1013,179,1013,252,1026,253,1026,254,1026,255,1026,},[222]={ 0,1026 ,1,1026 ,2,1026 ,3,1026 ,36,1086 ,37,1086 ,38,1084 ,39,1084 ,40,1084 ,41,1084 ,154,1131,155,1131,156,1131,157,1131,158,1131,159,1131,176,1013,177,1013,178,1013,179,1013,180,1013,181,1013,254,1026,255,1026,},[223]={ 0,1026 ,1,1026 ,2,1026 ,3,1026 ,36,1086 ,37,1086 ,38,1084 ,39,1084 ,40,1084 ,41,1084 ,154,1131,155,1131,156,1131,157,1131,158,1131,159,1131,176,1013,177,1013,178,1013,179,1013,180,1013,181,1013,254,1026,255,1026,},[224]={ 0,1026 ,1,1026 ,2,1026 ,3,1026 ,4,1026 ,5,1026 ,6,1026 ,7,1026 ,8,1026 ,9,1026 ,10,1026 ,11,1026 ,12,1026 ,13,1026 ,14,1026 ,15,1026 ,16,1026 ,17,1026 ,18,1026 ,19,1026 ,20,1026 ,21,1026 ,22,1026 ,23,1026 ,24,1026 ,25,1026 ,26,1026 ,27,1026 ,28,1029 ,29,1029 ,30,1029 ,31,1029 ,32,1056 ,33,1056 ,34,1070 ,35,1070 ,36,1086 ,37,1086 ,38,1086 ,39,1086 ,152,1144,153,1144,154,1131,155,1131,156,1131,157,1131,178,1013,179,1013,180,1013,181,1013,182,1013,183,1013,},[225]={ 0,1026 ,1,1026 ,2,1026 ,3,1026 ,4,1026 ,5,1026 ,6,1026 ,7,1026 ,8,1026 ,9,1026 ,10,1026 ,11,1026 ,12,1026 ,13,1026 ,14,1026 ,15,1026 ,16,1026 ,17,1026 ,18,1026 ,19,1026 ,20,1026 ,21,1026 ,22,1026 ,23,1026 ,24,1026 ,25,1026 ,26,1026 ,27,1026 ,28,1029 ,29,1029 ,30,1029 ,31,1029 ,32,1056 ,33,1056 ,34,1070 ,35,1070 ,36,1086 ,37,1086 ,38,1086 ,39,1086 ,152,1144,153,1144,154,1131,155,1131,156,1131,157,1131,178,1013,179,1013,180,1013,181,1013,182,1013,183,1013,},[226]={ 2,1026 ,3,1026 ,4,1026 ,5,1026 ,6,1026 ,7,1026 ,8,1026 ,9,1026 ,10,1026 ,11,1026 ,12,1026 ,13,1026 ,14,1026 ,15,1026 ,16,1026 ,17,1026 ,18,1026 ,19,1026 ,20,1026 ,21,1026 ,22,1026 ,23,1026 ,24,1026 ,25,1026 ,26,1026 ,27,1026 ,28,1029 ,29,1029 ,30,1029 ,31,1029 ,32,1056 ,33,1056 ,34,1070 ,35,1070 ,36,1070 ,37,1070 ,152,1144,153,1144,154,1144,155,1144,180,1013,181,1013,182,1013,183,1013,184,1013,185,1013,},[227]={ 2,1026 ,3,1026 ,4,1026 ,5,1026 ,6,1026 ,7,1026 ,8,1026 ,9,1026 ,10,1026 ,11,1026 ,12,1026 ,13,1026 ,14,1026 ,15,1026 ,16,1026 ,17,1026 ,18,1026 ,19,1026 ,20,1026 ,21,1026 ,22,1026 ,23,1026 ,24,1026 ,25,1026 ,26,1026 ,27,1026 ,28,1029 ,29,1029 ,30,1029 ,31,1029 ,32,1056 ,33,1056 ,34,1070 ,35,1070 ,36,1070 ,37,1070 ,152,1144,153,1144,154,1144,155,1144,180,1013,181,1013,182,1013,183,1013,184,1013,185,1013,},[228]={ 152,1157,153,1157,154,1157,155,1157,182,1013,183,1013,184,1013,185,1013,186,1013,187,1013,},[229]={ 152,1157,153,1157,154,1157,155,1157,182,1013,183,1013,184,1013,185,1013,186,1013,187,1013,},[230]={ 152,1157,153,1157,154,1157,155,1157,184,1013,185,1013,186,1013,187,1013,188,1013,189,1013,},[231]={ 152,1157,153,1157,154,1157,155,1157,184,1013,185,1013,186,1013,187,1013,188,1013,189,1013,},[232]={ 152,1157,153,1157,154,1157,155,1157,186,1013,187,1013,188,1013,189,1013,190,1013,191,1013,},[233]={ 152,1157,153,1157,154,1157,155,1157,186,1013,187,1013,188,1013,189,1013,190,1013,191,1013,},[234]={ 152,1157,153,1157,154,1157,155,1157,188,1013,189,1013,190,1013,191,1013,192,1013,193,1013,},[235]={ 152,1157,153,1157,154,1157,155,1157,188,1013,189,1013,190,1013,191,1013,192,1013,193,1013,},[236]={ 152,1157,153,1157,154,1157,155,1157,190,1013,191,1013,192,1013,193,1013,194,1013,195,1013,},[237]={ 152,1157,153,1157,154,1157,155,1157,190,1013,191,1013,192,1013,193,1013,194,1013,195,1013,},[238]={ 152,1157,153,1157,154,1157,155,1157,192,1013,193,1013,194,1013,195,1013,196,1013,197,1013,},[239]={ 152,1157,153,1157,154,1157,155,1157,192,1013,193,1013,194,1013,195,1013,196,1013,197,1013,},[240]={ 152,1157,153,1157,154,1157,155,1157,194,1013,195,1013,196,1013,197,1013,198,1013,199,1013,},[241]={ 152,1157,153,1157,154,1157,155,1157,194,1013,195,1013,196,1013,197,1013,198,1013,199,1013,},[242]={ 152,1157,153,1157,154,1157,155,1157,196,1013,197,1013,198,1013,199,1013,200,1013,201,1013,},[243]={ 152,1157,153,1157,154,1157,155,1157,196,1013,197,1013,198,1013,199,1013,200,1013,201,1013,},[244]={ 152,1157,153,1157,154,1157,155,1157,198,1013,199,1013,200,1013,201,1013,202,1013,203,1013,},[245]={ 152,1157,153,1157,154,1157,155,1157,198,1013,199,1013,200,1013,201,1013,202,1013,203,1013,},[246]={ 152,1157,153,1157,154,1157,155,1157,156,1157,157,1157,200,1013,201,1013,202,1013,203,1013,204,1013,205,1013,},[247]={ 152,1157,153,1157,154,1157,155,1157,156,1157,157,1157,200,1013,201,1013,202,1013,203,1013,204,1013,205,1013,},[248]={ 154,1157,155,1157,156,1157,157,1157,158,1157,159,1157,202,1013,203,1013,204,1013,205,1013,206,1013,207,1013,},[249]={ 154,1157,155,1157,156,1157,157,1157,158,1157,159,1157,202,1013,203,1013,204,1013,205,1013,206,1013,207,1013,},[250]={ 156,1157,157,1157,158,1157,159,1157,160,1157,161,1157,204,1013,205,1013,206,1013,207,1013,208,1013,209,1013,},[251]={ 156,1157,157,1157,158,1157,159,1157,160,1157,161,1157,204,1013,205,1013,206,1013,207,1013,208,1013,209,1013,},[252]={ 158,1156,159,1156,160,1156,161,1156,172,338 ,173,338 ,174,470 ,175,470 ,176,353 ,177,353 ,206,1013,207,1013,208,1013,209,1013,210,1013,211,1013,},[253]={ 158,1156,159,1156,160,1156,161,1156,172,338 ,173,338 ,174,470 ,175,470 ,176,353 ,177,353 ,206,1013,207,1013,208,1013,209,1013,210,1013,211,1013,},[254]={ 158,1156,159,1156,160,1156,161,1156,170,288 ,171,288 ,172,575 ,173,575 ,174,575 ,175,575 ,176,533 ,177,533 ,178,234 ,179,234 ,208,1013,209,1013,210,1013,211,1013,},[255]={ 158,1156,159,1156,160,1156,161,1156,170,288 ,171,288 ,172,575 ,173,575 ,174,575 ,175,575 ,176,533 ,177,533 ,178,234 ,179,234 ,208,1013,209,1013,210,1013,211,1013,}
		},

		objects ={
			[0]={158,5,9,-1,1024 ,172,7,18,-1,0 ,176,7,18,-1,0 ,208,5,9,-1,0 ,},[2]={158,5,9,-1,1024 ,170,5,2,-1,0 ,208,5,9,-1,0 ,},[4]={158,5,9,-1,1024 ,172,7,18,-1,0 ,174,5,3,-1,0 ,208,5,9,-1,0 ,},[6]={158,5,9,-1,1024 ,170,5,3,-1,512 ,172,5,8,-1,0 ,208,5,9,-1,0 ,},[8]={158,5,9,-1,1024 ,170,7,18,-1,0 ,208,5,9,-1,0 ,},[10]={158,5,9,-1,1024 ,208,5,9,-1,0 ,},[12]={158,5,9,-1,1024 ,208,5,9,-1,0 ,},[14]={158,5,9,-1,1024 ,208,5,9,-1,0 ,},[16]={158,5,9,-1,1024 ,208,5,9,-1,0 ,},[18]={158,5,9,-1,1024 ,206,5,9,-1,256 ,},[20]={158,5,9,-1,1024 ,186,5,9,-1,512 ,188,5,9,-1,512 ,190,5,9,-1,512 ,192,5,9,-1,512 ,194,5,9,-1,512 ,196,5,9,-1,512 ,198,5,9,-1,512 ,200,5,9,-1,512 ,202,5,9,-1,512 ,204,5,9,-1,512 ,},[22]={158,5,9,-1,1024 ,164,7,18,-1,0 ,184,5,9,-1,256 ,},[24]={158,5,9,-1,1024 ,162,5,2,-1,0 ,164,5,8,-1,0 ,182,5,9,-1,256 ,},[26]={158,5,9,-1,1024 ,164,7,18,-1,0 ,180,5,9,-1,256 ,},[28]={158,5,9,-1,1024 ,178,5,9,-1,256 ,},[30]={158,5,9,-1,1024 ,162,5,8,-1,0 ,164,5,3,-1,1792 ,176,5,9,-1,0 ,},[32]={158,5,9,-1,1024 ,164,7,18,-1,0 ,176,5,9,-1,0 ,},[34]={158,5,9,-1,1024 ,162,5,2,-1,0 ,176,5,9,-1,0 ,},[36]={158,5,9,-1,1024 ,164,7,18,-1,0 ,176,5,9,-1,0 ,},[38]={158,5,9,-1,1024 ,176,5,9,-1,0 ,},[40]={158,5,9,-1,1024 ,176,5,9,-1,0 ,},[42]={158,5,9,-1,1024 ,176,5,9,-1,0 ,},[44]={158,5,9,-1,1024 ,176,5,9,-1,0 ,},[46]={158,5,9,-1,1024 ,176,5,9,-1,0 ,},[48]={158,5,9,-1,1024 ,176,5,9,-1,0 ,},[50]={158,5,9,-1,1024 ,176,5,9,-1,0 ,},[52]={158,5,9,-1,1024 ,176,5,9,-1,0 ,},[54]={158,5,9,-1,1024 ,176,5,9,-1,0 ,},[56]={158,5,9,-1,1024 ,176,5,9,-1,0 ,},[58]={158,5,9,-1,1024 ,176,5,9,-1,0 ,},[60]={158,5,9,-1,1024 ,170,7,18,-1,0 ,172,5,8,-1,0 ,176,5,9,-1,0 ,},[62]={158,5,9,-1,1024 ,170,5,8,-1,0 ,172,5,2,-1,512 ,176,5,9,-1,0 ,},[64]={158,5,9,-1,1024 ,170,7,18,-1,0 ,172,5,8,-1,0 ,176,5,9,-1,0 ,},[66]={158,5,9,-1,1024 ,176,5,9,-1,0 ,},[68]={158,5,9,-1,1024 ,176,5,9,-1,0 ,},[70]={158,5,9,-1,1024 ,176,5,9,-1,0 ,},[72]={158,5,9,-1,1024 ,176,5,9,-1,0 ,},[74]={158,5,9,-1,1024 ,178,5,9,-1,1792 ,},[76]={158,5,9,-1,1024 ,180,5,9,-1,1792 ,},[78]={158,5,9,-1,1024 ,182,5,9,-1,1792 ,},[80]={14,5,9,-1,1536 ,16,5,9,-1,1536 ,18,5,9,-1,1536 ,20,5,9,-1,1536 ,22,5,9,-1,1536 ,24,5,9,-1,1536 ,26,5,9,-1,1536 ,28,5,9,-1,1536 ,30,5,9,-1,1536 ,32,5,9,-1,1536 ,34,5,9,-1,1536 ,36,5,9,-1,1536 ,38,5,9,-1,1536 ,40,5,9,-1,1536 ,42,5,9,-1,1536 ,44,5,9,-1,1536 ,46,5,9,-1,1536 ,48,5,9,-1,1536 ,50,5,9,-1,1536 ,52,5,9,-1,1536 ,54,5,9,-1,1536 ,56,5,9,-1,1536 ,58,5,9,-1,1536 ,60,5,9,-1,1536 ,62,5,9,-1,1536 ,64,5,9,-1,1536 ,66,5,9,-1,1536 ,68,5,9,-1,1536 ,70,5,9,-1,1536 ,72,5,9,-1,1536 ,158,5,9,-1,1024 ,184,5,9,-1,1792 ,},[82]={0,5,9,-1,1536 ,2,5,9,-1,1536 ,4,5,9,-1,1536 ,6,5,9,-1,1536 ,8,5,9,-1,1536 ,10,5,9,-1,1536 ,12,5,9,-1,1024 ,74,5,9,-1,1792 ,158,5,9,-1,1024 ,186,5,9,-1,1536 ,188,5,9,-1,1536 ,190,5,9,-1,1536 ,192,5,9,-1,1536 ,194,5,9,-1,1536 ,196,5,9,-1,1536 ,198,5,9,-1,1536 ,200,5,9,-1,1536 ,202,5,9,-1,1536 ,204,5,9,-1,1536 ,206,5,9,-1,1536 ,208,5,9,-1,1536 ,210,5,9,-1,1536 ,212,5,9,-1,1536 ,214,5,9,-1,1536 ,216,5,9,-1,1536 ,218,5,9,-1,1536 ,220,5,9,-1,1536 ,222,5,9,-1,1536 ,224,5,9,-1,1536 ,226,5,9,-1,1536 ,228,5,9,-1,1536 ,230,5,9,-1,1536 ,232,5,9,-1,1536 ,234,5,9,-1,1536 ,236,5,9,-1,1536 ,238,5,9,-1,1536 ,240,5,9,-1,1536 ,242,5,9,-1,1536 ,244,5,9,-1,1536 ,246,5,9,-1,1536 ,248,5,9,-1,1536 ,250,5,9,-1,1536 ,252,5,9,-1,1536 ,254,5,9,-1,1536 ,},[84]={12,5,9,-1,1024 ,16,5,2,-1,768 ,28,5,18,-1,1024 ,76,5,9,-1,1792 ,158,5,9,-1,1024 ,},[86]={12,5,9,-1,1024 ,44,7,85,-1,0 ,78,5,9,-1,1792 ,158,5,9,-1,1024 ,},[88]={12,5,9,-1,1024 ,80,5,9,-1,1792 ,158,5,9,-1,1024 ,248,7,85,-1,0 ,},[90]={12,5,9,-1,1024 ,44,7,85,-1,0 ,82,5,9,-1,1792 ,158,5,9,-1,1024 ,},[92]={2,5,18,0,256 ,8,5,18,0,512 ,12,5,9,-1,1024 ,84,5,9,-1,1792 ,158,5,9,-1,1024 ,248,7,85,-1,0 ,},[94]={12,5,9,-1,1024 ,44,7,85,-1,0 ,86,5,9,-1,1792 ,158,5,9,-1,1024 ,},[96]={12,5,9,-1,1024 ,88,5,9,-1,1792 ,160,5,9,-1,768 ,248,7,85,-1,0 ,},[98]={12,5,9,-1,1024 ,44,7,85,-1,0 ,90,5,9,-1,1792 ,162,5,9,-1,768 ,},[100]={2,5,18,0,1536 ,8,5,18,0,0 ,12,5,9,-1,1024 ,92,5,9,-1,1792 ,164,5,9,-1,768 ,248,7,85,-1,0 ,},[102]={12,5,9,-1,1024 ,44,7,85,-1,0 ,94,5,9,-1,1792 ,166,5,9,-1,768 ,},[104]={12,5,9,-1,1024 ,96,5,9,-1,1792 ,168,5,9,-1,768 ,248,7,85,-1,0 ,},[106]={12,5,9,-1,1024 ,44,7,85,-1,0 ,98,5,9,-1,1792 ,170,5,9,-1,768 ,},[108]={12,5,9,-1,1024 ,16,5,2,-1,0 ,28,5,18,-1,0 ,100,5,9,-1,1792 ,172,5,9,-1,768 ,},[110]={0,5,9,-1,512 ,2,5,9,-1,512 ,4,5,9,-1,512 ,6,5,9,-1,512 ,8,5,9,-1,512 ,10,5,9,-1,512 ,12,5,9,-1,1024 ,102,5,9,-1,1792 ,174,5,9,-1,512 ,176,5,9,-1,512 ,178,5,9,-1,512 ,180,5,9,-1,512 ,182,5,9,-1,512 ,184,5,9,-1,512 ,186,5,9,-1,512 ,188,5,9,-1,512 ,190,5,9,-1,512 ,192,5,9,-1,512 ,194,5,9,-1,512 ,196,5,9,-1,512 ,198,5,9,-1,512 ,200,5,9,-1,512 ,202,5,9,-1,512 ,204,5,9,-1,512 ,206,5,9,-1,512 ,208,5,9,-1,512 ,210,5,9,-1,512 ,212,5,9,-1,512 ,214,5,9,-1,512 ,216,5,9,-1,512 ,218,5,9,-1,512 ,220,5,9,-1,512 ,222,5,9,-1,512 ,224,5,9,-1,512 ,226,5,9,-1,512 ,228,5,9,-1,512 ,230,5,9,-1,512 ,232,5,9,-1,512 ,234,5,9,-1,512 ,236,5,9,-1,512 ,238,5,9,-1,512 ,240,5,9,-1,512 ,242,5,9,-1,512 ,244,5,9,-1,512 ,246,5,9,-1,512 ,248,5,9,-1,512 ,250,5,9,-1,512 ,252,5,9,-1,512 ,254,5,9,-1,512 ,},[112]={14,5,9,-1,512 ,16,5,9,-1,512 ,18,5,9,-1,512 ,20,5,9,-1,512 ,22,5,9,-1,512 ,24,5,9,-1,512 ,26,5,9,-1,512 ,28,5,9,-1,512 ,30,5,9,-1,512 ,32,5,9,-1,512 ,34,5,9,-1,512 ,36,5,9,-1,512 ,38,5,9,-1,512 ,40,5,9,-1,512 ,42,5,9,-1,512 ,44,5,9,-1,512 ,46,5,9,-1,512 ,48,5,9,-1,512 ,50,5,9,-1,512 ,52,5,9,-1,512 ,54,5,9,-1,512 ,56,5,9,-1,512 ,58,5,9,-1,512 ,60,5,9,-1,512 ,62,5,9,-1,512 ,64,5,9,-1,512 ,66,5,9,-1,512 ,68,5,9,-1,512 ,70,5,9,-1,512 ,72,5,9,-1,512 ,104,5,9,-1,1792 ,},[114]={74,5,9,-1,768 ,106,5,9,-1,1792 ,},[116]={76,5,9,-1,768 ,108,5,9,-1,1792 ,},[118]={78,5,9,-1,768 ,110,5,9,-1,1792 ,},[120]={80,5,9,-1,768 ,112,5,9,-1,0 ,},[122]={82,5,9,-1,768 ,114,5,9,-1,0 ,},[124]={84,5,9,-1,768 ,114,5,9,-1,0 ,},[126]={86,5,9,-1,768 ,114,5,9,-1,0 ,},[128]={88,5,9,-1,768 ,114,5,9,-1,0 ,166,5,9,-1,1536 ,168,5,9,-1,1536 ,170,5,9,-1,1536 ,172,5,9,-1,1536 ,174,5,9,-1,1536 ,176,5,9,-1,1536 ,178,5,9,-1,1536 ,180,5,9,-1,1536 ,182,5,9,-1,1536 ,184,5,9,-1,1536 ,186,5,9,-1,1536 ,},[130]={90,5,9,-1,1024 ,114,5,9,-1,0 ,164,5,9,-1,1280 ,188,5,9,-1,1792 ,},[132]={90,5,9,-1,1024 ,114,5,9,-1,0 ,162,5,9,-1,1280 ,190,5,9,-1,1792 ,},[134]={90,5,9,-1,1024 ,114,5,9,-1,0 ,160,5,9,-1,1280 ,192,5,9,-1,1792 ,},[136]={90,5,9,-1,1024 ,114,5,9,-1,0 ,158,5,9,-1,1280 ,194,5,9,-1,1792 ,},[138]={90,5,9,-1,1024 ,114,5,9,-1,0 ,156,5,9,-1,1280 ,196,5,9,-1,1792 ,},[140]={90,5,9,-1,1024 ,114,5,9,-1,0 ,154,5,9,-1,1024 ,198,5,9,-1,1792 ,},[142]={90,5,9,-1,1024 ,114,5,9,-1,0 ,154,5,9,-1,1024 ,200,5,9,-1,1792 ,},[144]={90,5,9,-1,1024 ,114,5,9,-1,0 ,154,5,9,-1,1024 ,202,5,9,-1,1792 ,},[146]={90,5,9,-1,1024 ,114,5,9,-1,0 ,154,5,9,-1,1024 ,204,5,9,-1,1792 ,},[148]={90,5,9,-1,1024 ,114,5,9,-1,0 ,154,5,9,-1,1024 ,206,5,9,-1,1792 ,},[150]={90,5,9,-1,1024 ,114,5,9,-1,0 ,154,5,9,-1,1024 ,208,5,9,-1,0 ,},[152]={90,5,9,-1,1024 ,114,5,9,-1,0 ,154,5,9,-1,1024 ,208,5,9,-1,0 ,},[154]={90,5,9,-1,1024 ,114,5,9,-1,0 ,154,5,9,-1,1024 ,208,5,9,-1,0 ,},[156]={90,5,9,-1,1024 ,114,5,9,-1,0 ,154,5,9,-1,1024 ,178,5,9,-1,1024 ,182,5,8,-1,0 ,184,7,18,-1,0 ,208,5,9,-1,0 ,},[158]={90,5,9,-1,1024 ,114,5,9,-1,0 ,154,5,9,-1,1024 ,178,5,9,-1,1024 ,184,5,3,-1,1792 ,208,5,9,-1,0 ,},[160]={90,5,9,-1,1024 ,114,5,9,-1,0 ,154,5,9,-1,1024 ,178,5,9,-1,1024 ,184,7,18,-1,0 ,208,5,9,-1,0 ,},[162]={90,5,9,-1,1024 ,114,5,9,-1,0 ,154,5,9,-1,1024 ,178,5,9,-1,1024 ,182,5,2,-1,0 ,208,5,9,-1,0 ,},[164]={90,5,9,-1,1024 ,114,5,9,-1,0 ,154,5,9,-1,1024 ,178,5,9,-1,1024 ,184,7,18,-1,0 ,208,5,9,-1,0 ,},[166]={90,5,9,-1,1024 ,114,5,9,-1,0 ,154,5,9,-1,1024 ,178,5,9,-1,1024 ,184,5,3,-1,1792 ,208,5,9,-1,0 ,},[168]={90,5,9,-1,1024 ,114,5,9,-1,0 ,154,5,9,-1,1024 ,178,5,9,-1,1024 ,184,7,18,-1,0 ,208,5,9,-1,0 ,},[170]={2,5,9,-1,1536 ,4,5,9,-1,1536 ,6,5,9,-1,1536 ,8,5,9,-1,1536 ,10,5,9,-1,1536 ,12,5,9,-1,1536 ,14,5,9,-1,1536 ,16,5,9,-1,1536 ,18,5,9,-1,1536 ,20,5,9,-1,1536 ,22,5,9,-1,1536 ,24,5,9,-1,1536 ,26,5,9,-1,1536 ,28,5,9,-1,1536 ,30,5,9,-1,1536 ,32,5,9,-1,1536 ,34,5,9,-1,1536 ,88,5,9,-1,1280 ,114,5,9,-1,0 ,154,5,9,-1,1024 ,178,5,9,-1,1024 ,182,5,2,-1,0 ,208,5,9,-1,0 ,},[172]={0,5,9,-1,1280 ,36,5,9,-1,1792 ,86,5,9,-1,1280 ,114,5,9,-1,0 ,154,5,9,-1,768 ,178,5,9,-1,1024 ,184,7,18,-1,0 ,210,5,9,-1,1792 ,},[174]={38,5,9,-1,1792 ,84,5,9,-1,1280 ,114,5,9,-1,0 ,156,5,9,-1,768 ,176,5,9,-1,256 ,178,5,9,-1,1024 ,184,5,3,-1,1792 ,212,5,9,-1,1792 ,254,5,9,-1,1280 ,},[176]={40,5,9,-1,1792 ,82,5,9,-1,1280 ,114,5,9,-1,0 ,158,5,9,-1,768 ,174,5,9,-1,256 ,178,5,9,-1,1024 ,214,5,9,-1,1792 ,252,5,9,-1,1280 ,},[178]={42,5,9,-1,1792 ,80,5,9,-1,1280 ,114,5,9,-1,0 ,160,5,9,-1,1024 ,172,5,9,-1,0 ,180,5,9,-1,512 ,182,5,9,-1,512 ,184,5,9,-1,1024 ,216,5,9,-1,1792 ,250,5,9,-1,1280 ,},[180]={44,5,9,-1,1792 ,78,5,9,-1,1280 ,112,5,9,-1,256 ,160,5,9,-1,1024 ,172,5,9,-1,0 ,184,5,9,-1,1024 ,218,5,9,-1,1792 ,248,5,9,-1,1280 ,},[182]={46,5,9,-1,1792 ,76,5,9,-1,1280 ,110,5,9,-1,256 ,160,5,9,-1,1024 ,172,5,9,-1,0 ,184,5,9,-1,1024 ,220,5,9,-1,1792 ,246,5,9,-1,1280 ,},[184]={48,5,9,-1,1536 ,50,5,9,-1,1536 ,52,5,9,-1,1536 ,54,5,9,-1,1536 ,56,5,9,-1,1536 ,58,5,9,-1,1536 ,60,5,9,-1,1536 ,62,5,9,-1,1536 ,64,5,9,-1,1536 ,66,5,9,-1,1536 ,68,5,9,-1,1536 ,70,5,9,-1,1536 ,72,5,9,-1,1536 ,74,5,9,-1,1536 ,108,5,9,-1,256 ,160,5,9,-1,1024 ,172,5,9,-1,0 ,184,5,9,-1,1024 ,222,5,9,-1,1792 ,244,5,9,-1,1280 ,},[186]={106,5,9,-1,0 ,160,5,9,-1,1024 ,172,5,9,-1,0 ,184,5,9,-1,1024 ,224,5,9,-1,1536 ,226,5,9,-1,1536 ,228,5,9,-1,1536 ,230,5,9,-1,1536 ,232,5,9,-1,1536 ,234,5,9,-1,1536 ,236,5,9,-1,1536 ,238,5,9,-1,1536 ,240,5,9,-1,1536 ,242,5,9,-1,1536 ,},[188]={104,5,9,-1,256 ,160,5,9,-1,1024 ,172,5,9,-1,0 ,186,5,9,-1,768 ,},[190]={14,7,18,-1,0 ,18,5,3,-1,1280 ,20,7,18,-1,0 ,102,5,9,-1,256 ,160,5,9,-1,1024 ,172,5,9,-1,0 ,188,5,9,-1,768 ,},[192]={14,5,7,-1,0 ,16,5,2,-1,0 ,20,5,8,-1,0 ,100,5,9,-1,256 ,160,5,9,-1,1024 ,172,5,9,-1,0 ,190,5,9,-1,768 ,},[194]={14,7,18,-1,0 ,20,7,18,-1,0 ,98,5,9,-1,256 ,160,5,9,-1,1024 ,172,5,9,-1,0 ,192,5,9,-1,768 ,},[196]={14,5,3,-1,512 ,20,5,3,-1,1792 ,96,5,9,-1,256 ,160,5,9,-1,1024 ,172,5,9,-1,0 ,194,5,9,-1,768 ,},[198]={16,5,8,-1,0 ,94,5,9,-1,256 ,160,5,9,-1,1024 ,172,5,9,-1,0 ,196,5,9,-1,768 ,},[200]={14,7,18,-1,0 ,16,5,2,-1,0 ,20,7,18,-1,0 ,92,5,9,-1,256 ,160,5,9,-1,1024 ,172,5,9,-1,0 ,198,5,9,-1,768 ,},[202]={20,5,3,-1,1792 ,90,5,9,-1,256 ,160,5,9,-1,1024 ,172,5,9,-1,0 ,200,5,9,-1,768 ,},[204]={14,7,18,-1,0 ,16,5,3,-1,256 ,20,7,18,-1,0 ,88,5,9,-1,256 ,160,5,9,-1,1024 ,172,5,9,-1,0 ,202,5,9,-1,768 ,},[206]={86,5,9,-1,512 ,160,5,9,-1,1024 ,172,5,9,-1,0 ,204,5,9,-1,768 ,},[208]={84,5,9,-1,512 ,160,5,9,-1,1024 ,172,5,9,-1,0 ,206,5,9,-1,768 ,},[210]={48,5,9,-1,512 ,50,5,9,-1,512 ,52,5,9,-1,512 ,54,5,9,-1,512 ,56,5,9,-1,512 ,58,5,9,-1,512 ,60,5,9,-1,512 ,62,5,9,-1,512 ,64,5,9,-1,512 ,66,5,9,-1,512 ,68,5,9,-1,512 ,70,5,9,-1,512 ,72,5,9,-1,512 ,74,5,9,-1,512 ,76,5,9,-1,512 ,78,5,9,-1,512 ,80,5,9,-1,512 ,82,5,9,-1,512 ,160,5,9,-1,1024 ,172,5,9,-1,0 ,208,5,9,-1,512 ,210,5,9,-1,512 ,212,5,9,-1,512 ,214,5,9,-1,512 ,216,5,9,-1,512 ,218,5,9,-1,512 ,220,5,9,-1,512 ,222,5,9,-1,512 ,224,5,9,-1,512 ,226,5,9,-1,512 ,228,5,9,-1,512 ,230,5,9,-1,512 ,232,5,9,-1,512 ,234,5,9,-1,512 ,236,5,9,-1,512 ,238,5,9,-1,512 ,240,5,9,-1,512 ,242,5,9,-1,512 ,244,5,9,-1,512 ,},[212]={46,5,9,-1,256 ,160,5,9,-1,1024 ,172,5,9,-1,0 ,246,5,9,-1,768 ,},[214]={44,5,9,-1,256 ,160,5,9,-1,1024 ,172,5,9,-1,0 ,248,5,9,-1,768 ,},[216]={42,5,9,-1,256 ,160,5,9,-1,1024 ,172,5,9,-1,0 ,250,5,9,-1,768 ,},[218]={40,5,9,-1,256 ,158,5,9,-1,1280 ,174,5,9,-1,1792 ,252,5,9,-1,768 ,},[220]={38,5,9,-1,256 ,156,5,9,-1,1280 ,176,5,9,-1,1792 ,254,5,9,-1,768 ,},[222]={0,5,9,-1,768 ,36,5,9,-1,256 ,154,5,9,-1,1280 ,178,5,9,-1,1792 ,},[224]={2,5,9,-1,512 ,4,5,9,-1,512 ,6,5,9,-1,512 ,8,5,9,-1,512 ,10,5,9,-1,512 ,12,5,9,-1,512 ,14,5,9,-1,512 ,16,5,9,-1,512 ,18,5,9,-1,512 ,20,5,9,-1,512 ,22,5,9,-1,512 ,24,5,9,-1,512 ,26,5,9,-1,512 ,28,5,9,-1,512 ,30,5,9,-1,512 ,32,5,9,-1,512 ,34,5,9,-1,512 ,152,5,9,-1,1024 ,180,5,9,-1,1792 ,},[226]={152,5,9,-1,1024 ,182,5,9,-1,1792 ,},[228]={152,5,9,-1,1024 ,184,5,9,-1,1792 ,},[230]={152,5,9,-1,1024 ,186,5,9,-1,1792 ,},[232]={152,5,9,-1,1024 ,188,5,9,-1,1792 ,},[234]={152,5,9,-1,1024 ,190,5,9,-1,1792 ,},[236]={152,5,9,-1,1024 ,192,5,9,-1,1792 ,},[238]={152,5,9,-1,1024 ,194,5,9,-1,1792 ,},[240]={152,5,9,-1,1024 ,196,5,9,-1,1792 ,},[242]={152,5,9,-1,1024 ,198,5,9,-1,1792 ,},[244]={152,5,9,-1,768 ,200,5,9,-1,1792 ,},[246]={154,5,9,-1,768 ,202,5,9,-1,1792 ,},[248]={156,5,9,-1,768 ,204,5,9,-1,1792 ,},[250]={158,5,9,-1,1024 ,206,5,9,-1,1792 ,},[252]={158,5,9,-1,1024 ,172,5,8,-1,0 ,174,7,18,-1,0 ,208,5,9,-1,0 ,},[254]={158,5,9,-1,1024 ,170,7,18,-1,0 ,172,5,2,-1,0 ,176,5,3,-1,0 ,208,5,9,-1,0 ,}
		},
		
		markers ={
			136,102,136, 98,136, 106,202, 60,196, 60,192, 60,184, 212,188, 208,192, 204,0, 184,0, 190,0, 196,90, 188,96, 188,102, 188,106, 32,104, 32,102, 32,100, 32,92, 32,90, 32,88, 32,86, 32,86, 248,106, 248,108, 42,84, 42,92, 72,96, 26,98, 4,136, 48,128, 48,96, 36,96, 6,96, 22,168, 166,214, 18,144, 178,14, 164,180, 18,0, 0
		},
		
		decorations = {
			96,14,1,0, 82,44,1,6, 110,44,1,2, 170,184,2,4, 162,184,2,4, 178,170,1,0, 178,162,1,4, 216,170,1,0, 216,162,1,4, 26,162,4,0, 28,162,3,4, 84,248,1,6, 108,248,1,2
		},
		
		shaman_positions = {
			96,22, 96,22, 96,22, 96,22, 96,22, 96,22, 96,22, 96,22
		},
		
		scripts = {
			OnTurn = function(everySecond1, everySecond2, everySecond4) 			boat_race_I_on_turn(everySecond1, everySecond2, everySecond4) end,
			OnCreateThing = function(t, owner, type, model) 						boat_race_on_create_thing(t, owner, type, model) end,
			OnHumanDisconnect = function(player) 									boat_race_init_single_AI(player) end,
		},
		
	},
	
	[MAP_COLOR_BATTLE]={
	
		info = { 	name = "Color Battle", author = "Divinity",
					desc = "Players walk around the arena, colorizing the floor as they move. <br> Shots of blast will be granted frequently, as well as shots of lightning, more rarely. Even though killing shamans will earn 3 points, the big points come from color buckets. <br> The powerups are: <p> - Color Bucket: Earns points for each painted cell, then they fade <br> - Removal Spray: Removes color from any enemies <br> - Color Brush: Paints over any cell, making it your color <br> - Boots: Grants extra strength and speed to your shaman for a while",
					map_objectives = { {value=4, step=1, default=true}, {value=300, limit=500, step=50, default=true}, {} },
					image = 2720, texture={12,0}, zoom={254,246,0}, drop_infos = true, marker_lb={160, 106}, reinc_timer=12*6, shield_respawn=false,
					custom_rules = {
						{ default = false, 	name = "50% faster shamans", desc = "Shamans are 50% faster.", init = function() set_all_shamans_speeds(138) end },
						{ default = false, 	name = "No S clicks", desc = "S clicks won't follow." },
					}
				},
	
		land ={
			[0]={0,24 ,1,24 ,2,24 ,3,24 ,4,24 ,5,24 ,6,24 ,7,24 ,8,24 ,9,24 ,10,24 ,11,24 ,12,24 ,13,24 ,14,24 ,15,24 ,24,6 ,25,6 ,232,6 ,233,6 ,234,12 ,235,12 ,236,6 ,237,6 ,238,6 ,239,6 ,240,6 ,241,6 ,242,24 ,243,24 ,244,24 ,245,24 ,246,24 ,247,24 ,248,24 ,249,24 ,250,24 ,251,24 ,252,24 ,253,24 ,254,24 ,255,24 ,},[1]={0,24 ,1,24 ,2,24 ,3,24 ,4,24 ,5,24 ,6,24 ,7,24 ,8,24 ,9,24 ,10,24 ,11,24 ,12,24 ,13,24 ,14,24 ,15,24 ,24,6 ,25,6 ,232,6 ,233,6 ,234,12 ,235,12 ,236,6 ,237,6 ,238,6 ,239,6 ,240,6 ,241,6 ,242,24 ,243,24 ,244,24 ,245,24 ,246,24 ,247,24 ,248,24 ,249,24 ,250,24 ,251,24 ,252,24 ,253,24 ,254,24 ,255,24 ,},[2]={0,24 ,1,24 ,2,24 ,3,24 ,4,24 ,5,24 ,6,24 ,7,24 ,8,24 ,9,24 ,10,24 ,11,24 ,12,24 ,13,24 ,14,24 ,15,24 ,24,6 ,25,6 ,232,6 ,233,6 ,242,24 ,243,24 ,244,24 ,245,24 ,246,24 ,247,24 ,248,24 ,249,24 ,250,24 ,251,24 ,252,24 ,253,24 ,254,24 ,255,24 ,},[3]={0,24 ,1,24 ,2,24 ,3,24 ,4,24 ,5,24 ,6,24 ,7,24 ,8,24 ,9,24 ,10,24 ,11,24 ,12,24 ,13,24 ,14,24 ,15,24 ,24,6 ,25,6 ,232,6 ,233,6 ,242,24 ,243,24 ,244,24 ,245,24 ,246,24 ,247,24 ,248,24 ,249,24 ,250,24 ,251,24 ,252,24 ,253,24 ,254,24 ,255,24 ,},[4]={0,24 ,1,24 ,2,24 ,3,24 ,4,24 ,5,24 ,6,24 ,7,24 ,8,24 ,9,24 ,10,24 ,11,24 ,12,24 ,13,24 ,14,24 ,15,24 ,24,6 ,25,6 ,232,6 ,233,6 ,242,24 ,243,24 ,244,24 ,245,24 ,246,24 ,247,24 ,248,24 ,249,24 ,250,24 ,251,24 ,252,24 ,253,24 ,254,24 ,255,24 ,},[5]={0,24 ,1,24 ,2,24 ,3,24 ,4,24 ,5,24 ,6,24 ,7,24 ,8,24 ,9,24 ,10,24 ,11,24 ,12,24 ,13,24 ,14,24 ,15,24 ,24,6 ,25,6 ,232,6 ,233,6 ,242,24 ,243,24 ,244,24 ,245,24 ,246,24 ,247,24 ,248,24 ,249,24 ,250,24 ,251,24 ,252,24 ,253,24 ,254,24 ,255,24 ,},[6]={0,24 ,1,24 ,2,24 ,3,24 ,4,24 ,5,24 ,6,24 ,7,24 ,8,24 ,9,24 ,10,24 ,11,24 ,12,24 ,13,24 ,14,24 ,15,24 ,16,6 ,17,6 ,18,6 ,19,6 ,20,6 ,21,6 ,22,6 ,23,6 ,24,6 ,25,6 ,232,6 ,233,6 ,242,24 ,243,24 ,244,24 ,245,24 ,246,24 ,247,24 ,248,24 ,249,24 ,250,24 ,251,24 ,252,24 ,253,24 ,254,24 ,255,24 ,},[7]={0,24 ,1,24 ,2,24 ,3,24 ,4,24 ,5,24 ,6,24 ,7,24 ,8,24 ,9,24 ,10,24 ,11,24 ,12,24 ,13,24 ,14,24 ,15,24 ,16,6 ,17,6 ,18,6 ,19,6 ,20,6 ,21,6 ,22,6 ,23,6 ,24,6 ,25,6 ,232,6 ,233,6 ,242,24 ,243,24 ,244,24 ,245,24 ,246,24 ,247,24 ,248,24 ,249,24 ,250,24 ,251,24 ,252,24 ,253,24 ,254,24 ,255,24 ,},[8]={0,24 ,1,24 ,2,24 ,3,24 ,4,24 ,5,24 ,6,24 ,7,24 ,8,24 ,9,24 ,10,24 ,11,24 ,12,24 ,13,24 ,14,24 ,15,24 ,242,24 ,243,24 ,244,24 ,245,24 ,246,24 ,247,24 ,248,24 ,249,24 ,250,24 ,251,24 ,252,24 ,253,24 ,254,24 ,255,24 ,},[9]={0,24 ,1,24 ,2,24 ,3,24 ,4,24 ,5,24 ,6,24 ,7,24 ,8,24 ,9,24 ,10,24 ,11,24 ,12,24 ,13,24 ,14,24 ,15,24 ,242,24 ,243,24 ,244,24 ,245,24 ,246,24 ,247,24 ,248,24 ,249,24 ,250,24 ,251,24 ,252,24 ,253,24 ,254,24 ,255,24 ,},[10]={0,24 ,1,24 ,2,24 ,3,24 ,4,24 ,5,24 ,6,24 ,7,24 ,8,24 ,9,24 ,10,24 ,11,24 ,12,24 ,13,24 ,14,24 ,15,24 ,242,24 ,243,24 ,244,24 ,245,24 ,246,24 ,247,24 ,248,24 ,249,24 ,250,24 ,251,24 ,252,24 ,253,24 ,254,24 ,255,24 ,},[11]={0,24 ,1,24 ,2,24 ,3,24 ,4,24 ,5,24 ,6,24 ,7,24 ,8,24 ,9,24 ,10,24 ,11,24 ,12,24 ,13,24 ,14,24 ,15,24 ,242,24 ,243,24 ,244,24 ,245,24 ,246,24 ,247,24 ,248,24 ,249,24 ,250,24 ,251,24 ,252,24 ,253,24 ,254,24 ,255,24 ,},[12]={0,24 ,1,24 ,2,24 ,3,24 ,4,24 ,5,24 ,6,24 ,7,24 ,8,24 ,9,24 ,10,24 ,11,24 ,12,24 ,13,24 ,14,24 ,15,24 ,242,24 ,243,24 ,244,24 ,245,24 ,246,24 ,247,24 ,248,24 ,249,24 ,250,24 ,251,24 ,252,24 ,253,24 ,254,24 ,255,24 ,},[13]={0,24 ,1,24 ,2,24 ,3,24 ,4,24 ,5,24 ,6,24 ,7,24 ,8,24 ,9,24 ,10,24 ,11,24 ,12,24 ,13,24 ,14,24 ,15,24 ,242,24 ,243,24 ,244,24 ,245,24 ,246,24 ,247,24 ,248,24 ,249,24 ,250,24 ,251,24 ,252,24 ,253,24 ,254,24 ,255,24 ,},[14]={0,24 ,1,24 ,2,24 ,3,24 ,4,24 ,5,24 ,6,24 ,7,24 ,8,24 ,9,24 ,10,24 ,11,24 ,12,24 ,13,24 ,14,24 ,15,24 ,242,24 ,243,24 ,244,24 ,245,24 ,246,24 ,247,24 ,248,24 ,249,24 ,250,24 ,251,24 ,252,24 ,253,24 ,254,24 ,255,24 ,},[15]={0,24 ,1,24 ,2,24 ,3,24 ,4,24 ,5,24 ,6,24 ,7,24 ,8,24 ,9,24 ,10,24 ,11,24 ,12,24 ,13,24 ,14,24 ,15,24 ,242,24 ,243,24 ,244,24 ,245,24 ,246,24 ,247,24 ,248,24 ,249,24 ,250,24 ,251,24 ,252,24 ,253,24 ,254,24 ,255,24 ,},[16]={0,6 ,1,6 ,},[17]={0,6 ,1,6 ,},[18]={0,12 ,1,12 ,},[19]={0,12 ,1,12 ,},[20]={0,6 ,1,6 ,22,6 ,23,6 ,},[21]={0,6 ,1,6 ,22,6 ,23,6 ,},[22]={0,6 ,1,6 ,2,12 ,3,12 ,4,12 ,5,12 ,6,12 ,7,12 ,22,6 ,23,6 ,24,1 ,25,1 ,26,6 ,27,6 ,230,6 ,231,6 ,232,6 ,233,6 ,234,1 ,235,1 ,236,6 ,237,6 ,238,6 ,239,6 ,},[23]={0,6 ,1,6 ,2,12 ,3,12 ,4,12 ,5,12 ,6,12 ,7,12 ,22,6 ,23,6 ,24,1 ,25,1 ,26,6 ,27,6 ,230,6 ,231,6 ,232,6 ,233,6 ,234,1 ,235,1 ,236,6 ,237,6 ,238,6 ,239,6 ,},[24]={20,6 ,21,6 ,22,1 ,23,1 ,24,1 ,25,1 ,26,1 ,27,1 ,28,24 ,29,24 ,232,12 ,233,12 ,234,1 ,235,1 ,236,1 ,237,1 ,238,6 ,239,6 ,240,6 ,241,6 ,},[25]={20,6 ,21,6 ,22,1 ,23,1 ,24,1 ,25,1 ,26,1 ,27,1 ,28,24 ,29,24 ,232,12 ,233,12 ,234,1 ,235,1 ,236,1 ,237,1 ,238,6 ,239,6 ,240,6 ,241,6 ,},[26]={20,12 ,21,12 ,22,6 ,23,6 ,24,1 ,25,1 ,26,1 ,27,1 ,28,12 ,29,12 ,232,1 ,233,1 ,234,6 ,235,6 ,236,6 ,237,6 ,238,6 ,239,6 ,},[27]={20,12 ,21,12 ,22,6 ,23,6 ,24,1 ,25,1 ,26,1 ,27,1 ,28,12 ,29,12 ,232,1 ,233,1 ,234,6 ,235,6 ,236,6 ,237,6 ,238,6 ,239,6 ,},[28]={26,6 ,27,6 ,232,6 ,233,6 ,234,6 ,235,6 ,},[29]={26,6 ,27,6 ,232,6 ,233,6 ,234,6 ,235,6 ,},[224]={24,6 ,25,6 ,26,1 ,27,1 ,28,18 ,29,18 ,},[225]={24,6 ,25,6 ,26,1 ,27,1 ,28,18 ,29,18 ,},[226]={22,12 ,23,12 ,24,1 ,25,1 ,26,18 ,27,18 ,28,12 ,29,12 ,230,6 ,231,6 ,},[227]={22,12 ,23,12 ,24,1 ,25,1 ,26,18 ,27,18 ,28,12 ,29,12 ,230,6 ,231,6 ,},[228]={20,6 ,21,6 ,22,1 ,23,1 ,24,1 ,25,1 ,26,1 ,27,1 ,28,6 ,29,6 ,226,6 ,227,6 ,228,1 ,229,1 ,230,6 ,231,6 ,232,6 ,233,6 ,},[229]={20,6 ,21,6 ,22,1 ,23,1 ,24,1 ,25,1 ,26,1 ,27,1 ,28,6 ,29,6 ,226,6 ,227,6 ,228,1 ,229,1 ,230,6 ,231,6 ,232,6 ,233,6 ,},[230]={0,6 ,1,6 ,20,1 ,21,1 ,22,1 ,23,1 ,24,1 ,25,1 ,26,12 ,27,12 ,28,1 ,29,1 ,224,6 ,225,6 ,226,1 ,227,1 ,228,6 ,229,6 ,230,24 ,231,24 ,232,6 ,233,6 ,},[231]={0,6 ,1,6 ,20,1 ,21,1 ,22,1 ,23,1 ,24,1 ,25,1 ,26,12 ,27,12 ,28,1 ,29,1 ,224,6 ,225,6 ,226,1 ,227,1 ,228,6 ,229,6 ,230,24 ,231,24 ,232,6 ,233,6 ,},[232]={0,12 ,1,12 ,20,1 ,21,1 ,22,6 ,23,6 ,24,1 ,25,1 ,26,1 ,27,1 ,28,1 ,29,1 ,228,1 ,229,1 ,230,24 ,231,24 ,},[233]={0,12 ,1,12 ,20,1 ,21,1 ,22,6 ,23,6 ,24,1 ,25,1 ,26,1 ,27,1 ,28,1 ,29,1 ,228,1 ,229,1 ,230,24 ,231,24 ,},[234]={0,6 ,1,6 ,20,6 ,21,6 ,22,1 ,23,1 ,24,6 ,25,6 ,26,1 ,27,1 ,28,12 ,29,12 ,228,24 ,229,24 ,230,12 ,231,12 ,},[235]={0,6 ,1,6 ,20,6 ,21,6 ,22,1 ,23,1 ,24,6 ,25,6 ,26,1 ,27,1 ,28,12 ,29,12 ,228,24 ,229,24 ,230,12 ,231,12 ,},[236]={0,12 ,1,12 ,},[237]={0,12 ,1,12 ,},[238]={0,12 ,1,12 ,},[239]={0,12 ,1,12 ,},[240]={0,12 ,1,12 ,},[241]={0,12 ,1,12 ,},[242]={0,24 ,1,24 ,2,24 ,3,24 ,4,24 ,5,24 ,6,24 ,7,24 ,8,24 ,9,24 ,10,24 ,11,24 ,12,24 ,13,24 ,14,24 ,15,24 ,242,24 ,243,24 ,244,24 ,245,24 ,246,24 ,247,24 ,248,24 ,249,24 ,250,24 ,251,24 ,252,24 ,253,24 ,254,24 ,255,24 ,},[243]={0,24 ,1,24 ,2,24 ,3,24 ,4,24 ,5,24 ,6,24 ,7,24 ,8,24 ,9,24 ,10,24 ,11,24 ,12,24 ,13,24 ,14,24 ,15,24 ,242,24 ,243,24 ,244,24 ,245,24 ,246,24 ,247,24 ,248,24 ,249,24 ,250,24 ,251,24 ,252,24 ,253,24 ,254,24 ,255,24 ,},[244]={0,24 ,1,24 ,2,24 ,3,24 ,4,24 ,5,24 ,6,24 ,7,24 ,8,24 ,9,24 ,10,24 ,11,24 ,12,24 ,13,24 ,14,24 ,15,24 ,242,24 ,243,24 ,244,24 ,245,24 ,246,24 ,247,24 ,248,24 ,249,24 ,250,24 ,251,24 ,252,24 ,253,24 ,254,24 ,255,24 ,},[245]={0,24 ,1,24 ,2,24 ,3,24 ,4,24 ,5,24 ,6,24 ,7,24 ,8,24 ,9,24 ,10,24 ,11,24 ,12,24 ,13,24 ,14,24 ,15,24 ,242,24 ,243,24 ,244,24 ,245,24 ,246,24 ,247,24 ,248,24 ,249,24 ,250,24 ,251,24 ,252,24 ,253,24 ,254,24 ,255,24 ,},[246]={0,24 ,1,24 ,2,24 ,3,24 ,4,24 ,5,24 ,6,24 ,7,24 ,8,24 ,9,24 ,10,24 ,11,24 ,12,24 ,13,24 ,14,24 ,15,24 ,242,24 ,243,24 ,244,24 ,245,24 ,246,24 ,247,24 ,248,24 ,249,24 ,250,24 ,251,24 ,252,24 ,253,24 ,254,24 ,255,24 ,},[247]={0,24 ,1,24 ,2,24 ,3,24 ,4,24 ,5,24 ,6,24 ,7,24 ,8,24 ,9,24 ,10,24 ,11,24 ,12,24 ,13,24 ,14,24 ,15,24 ,242,24 ,243,24 ,244,24 ,245,24 ,246,24 ,247,24 ,248,24 ,249,24 ,250,24 ,251,24 ,252,24 ,253,24 ,254,24 ,255,24 ,},[248]={0,24 ,1,24 ,2,24 ,3,24 ,4,24 ,5,24 ,6,24 ,7,24 ,8,24 ,9,24 ,10,24 ,11,24 ,12,24 ,13,24 ,14,24 ,15,24 ,242,24 ,243,24 ,244,24 ,245,24 ,246,24 ,247,24 ,248,24 ,249,24 ,250,24 ,251,24 ,252,24 ,253,24 ,254,24 ,255,24 ,},[249]={0,24 ,1,24 ,2,24 ,3,24 ,4,24 ,5,24 ,6,24 ,7,24 ,8,24 ,9,24 ,10,24 ,11,24 ,12,24 ,13,24 ,14,24 ,15,24 ,242,24 ,243,24 ,244,24 ,245,24 ,246,24 ,247,24 ,248,24 ,249,24 ,250,24 ,251,24 ,252,24 ,253,24 ,254,24 ,255,24 ,},[250]={0,24 ,1,24 ,2,24 ,3,24 ,4,24 ,5,24 ,6,24 ,7,24 ,8,24 ,9,24 ,10,24 ,11,24 ,12,24 ,13,24 ,14,24 ,15,24 ,16,18 ,17,18 ,18,18 ,19,18 ,20,12 ,21,12 ,22,6 ,23,6 ,24,12 ,25,12 ,232,6 ,233,6 ,242,24 ,243,24 ,244,24 ,245,24 ,246,24 ,247,24 ,248,24 ,249,24 ,250,24 ,251,24 ,252,24 ,253,24 ,254,24 ,255,24 ,},[251]={0,24 ,1,24 ,2,24 ,3,24 ,4,24 ,5,24 ,6,24 ,7,24 ,8,24 ,9,24 ,10,24 ,11,24 ,12,24 ,13,24 ,14,24 ,15,24 ,16,18 ,17,18 ,18,18 ,19,18 ,20,12 ,21,12 ,22,6 ,23,6 ,24,12 ,25,12 ,232,6 ,233,6 ,242,24 ,243,24 ,244,24 ,245,24 ,246,24 ,247,24 ,248,24 ,249,24 ,250,24 ,251,24 ,252,24 ,253,24 ,254,24 ,255,24 ,},[252]={0,24 ,1,24 ,2,24 ,3,24 ,4,24 ,5,24 ,6,24 ,7,24 ,8,24 ,9,24 ,10,24 ,11,24 ,12,24 ,13,24 ,14,24 ,15,24 ,24,6 ,25,6 ,232,6 ,233,6 ,242,24 ,243,24 ,244,24 ,245,24 ,246,24 ,247,24 ,248,24 ,249,24 ,250,24 ,251,24 ,252,24 ,253,24 ,254,24 ,255,24 ,},[253]={0,24 ,1,24 ,2,24 ,3,24 ,4,24 ,5,24 ,6,24 ,7,24 ,8,24 ,9,24 ,10,24 ,11,24 ,12,24 ,13,24 ,14,24 ,15,24 ,24,6 ,25,6 ,232,6 ,233,6 ,242,24 ,243,24 ,244,24 ,245,24 ,246,24 ,247,24 ,248,24 ,249,24 ,250,24 ,251,24 ,252,24 ,253,24 ,254,24 ,255,24 ,},[254]={0,24 ,1,24 ,2,24 ,3,24 ,4,24 ,5,24 ,6,24 ,7,24 ,8,24 ,9,24 ,10,24 ,11,24 ,12,24 ,13,24 ,14,24 ,15,24 ,24,12 ,25,12 ,232,6 ,233,6 ,242,24 ,243,24 ,244,24 ,245,24 ,246,24 ,247,24 ,248,24 ,249,24 ,250,24 ,251,24 ,252,24 ,253,24 ,254,24 ,255,24 ,},[255]={0,24 ,1,24 ,2,24 ,3,24 ,4,24 ,5,24 ,6,24 ,7,24 ,8,24 ,9,24 ,10,24 ,11,24 ,12,24 ,13,24 ,14,24 ,15,24 ,24,12 ,25,12 ,232,6 ,233,6 ,242,24 ,243,24 ,244,24 ,245,24 ,246,24 ,247,24 ,248,24 ,249,24 ,250,24 ,251,24 ,252,24 ,253,24 ,254,24 ,255,24 ,}
},

		objects ={
			[18]={22,5,2,-1,0 ,},[20]={24,5,1,-1,0 ,230,5,2,-1,0,234,5,1,-1,0,},[22]={20,5,1,-1,0 ,22,5,1,-1,0 ,28,5,1,-1,0 ,236,5,1,-1,0,240,5,2,-1,0,},[24]={18,5,2,-1,0 ,26,5,2,-1,0 ,230,5,1,-1,0,236,5,1,-1,0,240,5,1,-1,0,},[26]={24,5,2,-1,0 ,232,5,2,-1,0,},[222]={26,5,2,-1,0 ,},[224]={22,5,2,-1,0 ,24,5,1,-1,0 ,},[226]={22,5,1,-1,0 ,24,5,1,-1,0 ,228,5,2,-1,0,},[228]={18,5,2,-1,0 ,22,5,1,-1,0 ,224,5,2,-1,0,226,5,1,-1,0,},[230]={20,5,1,-1,0 ,226,5,1,-1,0,228,5,1,-1,0,230,5,1,-1,0,232,5,2,-1,0,},[232]={26,5,2,-1,0 ,230,5,1,-1,0,},[234]={18,5,1,-1,0 ,22,5,1,-1,0 ,228,5,2,-1,0,}
		},
		
		markers ={
			246, 250, 246, 254, 246, 2, 246, 6, 8, 6, 8, 2, 8, 254, 8, 250, 0, 254, 10, 10, 244, 10, 244, 244, 10, 244, 242, 4, 244, 250, 242, 254, 242, 246, 248, 246, 252, 242, 254, 246, 2, 242, 6, 246, 8, 242, 12, 250, 10, 254, 12, 0, 12, 6, 4, 12, 2, 8, 254, 12, 250, 8, 250, 12, 4, 2, 2, 250, 252, 250, 250, 252, 250, 2, 254, 4, 0, 236, 254, 232, 4, 230, 250, 230, 236, 254, 232, 0, 248, 18, 250, 22, 254, 24, 2, 22, 6, 18, 22, 4, 20, 0, 16, 254, 232, 20, 20,20, 22, 236, 232, 230, 0, 0
		},
		
		shaman_positions = {
			252, 6, 246, 2, 246, 250, 252, 246, 2, 246, 8, 250, 8, 2, 2, 6
		},
		
		scripts = {
			OnTurn = function(everySecond1, everySecond2, everySecond4) 			color_battle_on_turn(everySecond1, everySecond2, everySecond4) end,
			OnCreateThing = function(t, owner, type, model) 						color_battle_on_create_thing(t, owner, type, model) end,
			OnPowerUp = function(id, c3d)											CB_on_power_up(id, c3d) end,											
			OnShamanDeath = function(victim, killer, killer_was_ally)				color_battle_on_shaman_dead(victim, killer, killer_was_ally) end,
			OnHumanDisconnect = function(player) 									CB_init_single_AI(player) end,
		},
		
	},
	
	[MAP_NAVAL_WARFARE]={
	
		info = 	{ 	name = "Naval Warfare", author = "Divinity",
					desc = "Grab a boat, and enter this deadly naval warfare. Sail the dangerous battlezone, combating enemies with cannons and special fire combat tactics! <br> In this game, both killing and surviving is important to ensure your ideal score: Kills grant 5 points, while deaths remove 2 points. <br> The powerups are: <p> - Light Iron: Allows you to recharge cannonballs twice as fast, for a while <br> - GunPowder: Your cannonballs deal extra damage, and have more area of effect, for a while <br> - Greek Fire: grants you one shot of this spell. Casting it spawns a deadly fire arena, trapping enemies inside. Any boat that touches greek fire will burn for good damage.",
					map_objectives = { {value=5, step=1, default=true}, {value=50, step=10, limit=300, default=true}, {} },
					image = 3008, texture={20,3}, zoom={72,34,0}, drop_infos = true, marker_lb={194,196}, reinc_timer=12*3, shield_respawn=true,
					custom_rules = {
						{ default = false, 	name = "Fast boats", desc = "Boats are twice as fast." },
						{ default = false, 	name = "Close Combat", desc = "Cannonball has half the range." },
						{ default = false, 	name = "No losing points", desc = "Deaths won't lose in-game points for you or your team - only kills matter!" },
					}
				},
	
		land ={
			[0]={0,2 ,1,2 ,2,3 ,3,3 ,4,3 ,5,3 ,6,3 ,7,3 ,8,3 ,9,3 ,10,3 ,11,3 ,12,3 ,13,3 ,14,3 ,15,3 ,16,3 ,17,3 ,18,3 ,19,3 ,20,3 ,21,3 ,22,3 ,23,3 ,24,4 ,25,4 ,26,3 ,27,3 ,28,3 ,29,3 ,30,3 ,31,3 ,32,3 ,33,3 ,34,3 ,35,3 ,36,3 ,37,3 ,38,3 ,39,3 ,40,3 ,41,3 ,42,3 ,43,3 ,44,3 ,45,3 ,46,2 ,47,2 ,48,2 ,49,2 ,50,2 ,51,2 ,52,2 ,53,2 ,54,2 ,55,2 ,56,2 ,57,2 ,58,2 ,59,2 ,60,2 ,61,2 ,62,2 ,63,2 ,64,2 ,65,2 ,66,2 ,67,2 ,68,2 ,69,2 ,70,2 ,71,2 ,72,2 ,73,2 ,74,1 ,75,1 ,76,1 ,77,1 ,78,3 ,79,3 ,80,3 ,81,3 ,82,3 ,83,3 ,84,3 ,85,3 ,86,3 ,87,3 ,88,3 ,89,3 ,90,3 ,91,3 ,92,3 ,93,3 ,94,3 ,95,3 ,96,3 ,97,3 ,98,3 ,99,3 ,100,3 ,101,3 ,102,3 ,103,3 ,104,3 ,105,3 ,106,3 ,107,3 ,108,3 ,109,3 ,110,3 ,111,3 ,112,3 ,113,3 ,114,3 ,115,3 ,116,3 ,117,3 ,118,3 ,119,3 ,120,3 ,121,3 ,122,3 ,123,3 ,124,3 ,125,3 ,126,3 ,127,3 ,128,3 ,129,3 ,130,4 ,131,4 ,132,5 ,133,5 ,134,5 ,135,5 ,136,5 ,137,5 ,138,5 ,139,5 ,140,5 ,141,5 ,142,5 ,143,5 ,144,5 ,145,5 ,146,3 ,147,3 ,148,3 ,149,3 ,254,2 ,255,2 ,},[1]={0,2 ,1,2 ,2,3 ,3,3 ,4,3 ,5,3 ,6,3 ,7,3 ,8,3 ,9,3 ,10,3 ,11,3 ,12,3 ,13,3 ,14,3 ,15,3 ,16,3 ,17,3 ,18,3 ,19,3 ,20,3 ,21,3 ,22,3 ,23,3 ,24,4 ,25,4 ,26,3 ,27,3 ,28,3 ,29,3 ,30,3 ,31,3 ,32,3 ,33,3 ,34,3 ,35,3 ,36,3 ,37,3 ,38,3 ,39,3 ,40,3 ,41,3 ,42,3 ,43,3 ,44,3 ,45,3 ,46,2 ,47,2 ,48,2 ,49,2 ,50,2 ,51,2 ,52,2 ,53,2 ,54,2 ,55,2 ,56,2 ,57,2 ,58,2 ,59,2 ,60,2 ,61,2 ,62,2 ,63,2 ,64,2 ,65,2 ,66,2 ,67,2 ,68,2 ,69,2 ,70,2 ,71,2 ,72,2 ,73,2 ,74,1 ,75,1 ,76,1 ,77,1 ,78,3 ,79,3 ,80,3 ,81,3 ,82,3 ,83,3 ,84,3 ,85,3 ,86,3 ,87,3 ,88,3 ,89,3 ,90,3 ,91,3 ,92,3 ,93,3 ,94,3 ,95,3 ,96,3 ,97,3 ,98,3 ,99,3 ,100,3 ,101,3 ,102,3 ,103,3 ,104,3 ,105,3 ,106,3 ,107,3 ,108,3 ,109,3 ,110,3 ,111,3 ,112,3 ,113,3 ,114,3 ,115,3 ,116,3 ,117,3 ,118,3 ,119,3 ,120,3 ,121,3 ,122,3 ,123,3 ,124,3 ,125,3 ,126,3 ,127,3 ,128,3 ,129,3 ,130,4 ,131,4 ,132,5 ,133,5 ,134,5 ,135,5 ,136,5 ,137,5 ,138,5 ,139,5 ,140,5 ,141,5 ,142,5 ,143,5 ,144,5 ,145,5 ,146,3 ,147,3 ,148,3 ,149,3 ,254,2 ,255,2 ,},[2]={0,2 ,1,2 ,2,30 ,3,30 ,4,30 ,5,30 ,6,30 ,7,30 ,70,30 ,71,30 ,72,30 ,73,30 ,74,30 ,75,30 ,76,30 ,77,30 ,140,30 ,141,30 ,142,30 ,143,30 ,144,30 ,145,30 ,146,5 ,147,5 ,148,5 ,149,5 ,254,2 ,255,2 ,},[3]={0,2 ,1,2 ,2,30 ,3,30 ,4,30 ,5,30 ,6,30 ,7,30 ,70,30 ,71,30 ,72,30 ,73,30 ,74,30 ,75,30 ,76,30 ,77,30 ,140,30 ,141,30 ,142,30 ,143,30 ,144,30 ,145,30 ,146,5 ,147,5 ,148,5 ,149,5 ,254,2 ,255,2 ,},[4]={0,2 ,1,2 ,2,30 ,3,30 ,4,30 ,5,30 ,6,30 ,7,30 ,70,30 ,71,30 ,72,30 ,73,30 ,74,30 ,75,30 ,76,30 ,77,30 ,140,30 ,141,30 ,142,30 ,143,30 ,144,30 ,145,30 ,146,5 ,147,5 ,148,5 ,149,5 ,254,2 ,255,2 ,},[5]={0,2 ,1,2 ,2,30 ,3,30 ,4,30 ,5,30 ,6,30 ,7,30 ,70,30 ,71,30 ,72,30 ,73,30 ,74,30 ,75,30 ,76,30 ,77,30 ,140,30 ,141,30 ,142,30 ,143,30 ,144,30 ,145,30 ,146,5 ,147,5 ,148,5 ,149,5 ,254,2 ,255,2 ,},[6]={0,2 ,1,2 ,2,30 ,3,30 ,4,30 ,5,30 ,6,30 ,7,30 ,70,30 ,71,30 ,72,30 ,73,30 ,74,30 ,75,30 ,76,30 ,77,30 ,140,30 ,141,30 ,142,30 ,143,30 ,144,30 ,145,30 ,146,5 ,147,5 ,148,5 ,149,5 ,254,2 ,255,2 ,},[7]={0,2 ,1,2 ,2,30 ,3,30 ,4,30 ,5,30 ,6,30 ,7,30 ,70,30 ,71,30 ,72,30 ,73,30 ,74,30 ,75,30 ,76,30 ,77,30 ,140,30 ,141,30 ,142,30 ,143,30 ,144,30 ,145,30 ,146,5 ,147,5 ,148,5 ,149,5 ,254,2 ,255,2 ,},[8]={0,3 ,1,3 ,70,30 ,71,30 ,72,30 ,73,30 ,74,30 ,75,30 ,76,30 ,77,30 ,146,5 ,147,5 ,148,5 ,149,5 ,254,3 ,255,3 ,},[9]={0,3 ,1,3 ,70,30 ,71,30 ,72,30 ,73,30 ,74,30 ,75,30 ,76,30 ,77,30 ,146,5 ,147,5 ,148,5 ,149,5 ,254,3 ,255,3 ,},[10]={0,3 ,1,3 ,146,5 ,147,5 ,148,5 ,149,5 ,254,3 ,255,3 ,},[11]={0,3 ,1,3 ,146,5 ,147,5 ,148,5 ,149,5 ,254,3 ,255,3 ,},[12]={0,3 ,1,3 ,146,5 ,147,5 ,148,5 ,149,5 ,254,3 ,255,3 ,},[13]={0,3 ,1,3 ,146,5 ,147,5 ,148,5 ,149,5 ,254,3 ,255,3 ,},[14]={0,3 ,1,3 ,146,5 ,147,5 ,148,5 ,149,5 ,254,3 ,255,3 ,},[15]={0,3 ,1,3 ,146,5 ,147,5 ,148,5 ,149,5 ,254,3 ,255,3 ,},[16]={0,3 ,1,3 ,146,5 ,147,5 ,148,5 ,149,5 ,254,3 ,255,3 ,},[17]={0,3 ,1,3 ,146,5 ,147,5 ,148,5 ,149,5 ,254,3 ,255,3 ,},[18]={0,3 ,1,3 ,146,4 ,147,4 ,148,4 ,149,4 ,254,3 ,255,3 ,},[19]={0,3 ,1,3 ,146,4 ,147,4 ,148,4 ,149,4 ,254,3 ,255,3 ,},[20]={0,3 ,1,3 ,146,3 ,147,3 ,148,3 ,149,3 ,254,3 ,255,3 ,},[21]={0,3 ,1,3 ,146,3 ,147,3 ,148,3 ,149,3 ,254,3 ,255,3 ,},[22]={0,3 ,1,3 ,146,3 ,147,3 ,148,3 ,149,3 ,254,3 ,255,3 ,},[23]={0,3 ,1,3 ,146,3 ,147,3 ,148,3 ,149,3 ,254,3 ,255,3 ,},[24]={0,3 ,1,3 ,146,3 ,147,3 ,148,3 ,149,3 ,254,3 ,255,3 ,},[25]={0,3 ,1,3 ,146,3 ,147,3 ,148,3 ,149,3 ,254,3 ,255,3 ,},[26]={0,3 ,1,3 ,146,3 ,147,3 ,148,3 ,149,3 ,254,3 ,255,3 ,},[27]={0,3 ,1,3 ,146,3 ,147,3 ,148,3 ,149,3 ,254,3 ,255,3 ,},[28]={0,3 ,1,3 ,146,3 ,147,3 ,148,3 ,149,3 ,254,3 ,255,3 ,},[29]={0,3 ,1,3 ,146,3 ,147,3 ,148,3 ,149,3 ,254,3 ,255,3 ,},[30]={0,3 ,1,3 ,146,3 ,147,3 ,148,3 ,149,3 ,254,3 ,255,3 ,},[31]={0,3 ,1,3 ,146,3 ,147,3 ,148,3 ,149,3 ,254,3 ,255,3 ,},[32]={0,3 ,1,3 ,146,3 ,147,3 ,148,3 ,149,3 ,254,3 ,255,3 ,},[33]={0,3 ,1,3 ,146,3 ,147,3 ,148,3 ,149,3 ,254,3 ,255,3 ,},[34]={0,4 ,1,4 ,146,3 ,147,3 ,148,3 ,149,3 ,254,4 ,255,4 ,},[35]={0,4 ,1,4 ,146,3 ,147,3 ,148,3 ,149,3 ,254,4 ,255,4 ,},[36]={0,5 ,1,5 ,146,3 ,147,3 ,148,3 ,149,3 ,254,5 ,255,5 ,},[37]={0,5 ,1,5 ,146,3 ,147,3 ,148,3 ,149,3 ,254,5 ,255,5 ,},[38]={0,5 ,1,5 ,146,3 ,147,3 ,148,3 ,149,3 ,254,5 ,255,5 ,},[39]={0,5 ,1,5 ,146,3 ,147,3 ,148,3 ,149,3 ,254,5 ,255,5 ,},[40]={0,6 ,1,6 ,146,3 ,147,3 ,148,3 ,149,3 ,254,6 ,255,6 ,},[41]={0,6 ,1,6 ,146,3 ,147,3 ,148,3 ,149,3 ,254,6 ,255,6 ,},[42]={0,6 ,1,6 ,146,3 ,147,3 ,148,3 ,149,3 ,254,6 ,255,6 ,},[43]={0,6 ,1,6 ,146,3 ,147,3 ,148,3 ,149,3 ,254,6 ,255,6 ,},[44]={0,6 ,1,6 ,146,3 ,147,3 ,148,3 ,149,3 ,254,6 ,255,6 ,},[45]={0,6 ,1,6 ,146,3 ,147,3 ,148,3 ,149,3 ,254,6 ,255,6 ,},[46]={0,6 ,1,6 ,146,3 ,147,3 ,148,3 ,149,3 ,254,6 ,255,6 ,},[47]={0,6 ,1,6 ,146,3 ,147,3 ,148,3 ,149,3 ,254,6 ,255,6 ,},[48]={0,6 ,1,6 ,146,3 ,147,3 ,148,3 ,149,3 ,254,6 ,255,6 ,},[49]={0,6 ,1,6 ,146,3 ,147,3 ,148,3 ,149,3 ,254,6 ,255,6 ,},[50]={0,6 ,1,6 ,146,3 ,147,3 ,148,3 ,149,3 ,254,6 ,255,6 ,},[51]={0,6 ,1,6 ,146,3 ,147,3 ,148,3 ,149,3 ,254,6 ,255,6 ,},[52]={0,4 ,1,4 ,146,3 ,147,3 ,148,3 ,149,3 ,254,4 ,255,4 ,},[53]={0,4 ,1,4 ,146,3 ,147,3 ,148,3 ,149,3 ,254,4 ,255,4 ,},[54]={0,3 ,1,3 ,146,3 ,147,3 ,148,3 ,149,3 ,254,3 ,255,3 ,},[55]={0,3 ,1,3 ,146,3 ,147,3 ,148,3 ,149,3 ,254,3 ,255,3 ,},[56]={0,3 ,1,3 ,146,3 ,147,3 ,148,3 ,149,3 ,254,3 ,255,3 ,},[57]={0,3 ,1,3 ,146,3 ,147,3 ,148,3 ,149,3 ,254,3 ,255,3 ,},[58]={0,3 ,1,3 ,146,3 ,147,3 ,148,3 ,149,3 ,254,3 ,255,3 ,},[59]={0,3 ,1,3 ,146,3 ,147,3 ,148,3 ,149,3 ,254,3 ,255,3 ,},[60]={0,3 ,1,3 ,146,3 ,147,3 ,148,3 ,149,3 ,254,3 ,255,3 ,},[61]={0,3 ,1,3 ,146,3 ,147,3 ,148,3 ,149,3 ,254,3 ,255,3 ,},[62]={0,3 ,1,3 ,146,3 ,147,3 ,148,3 ,149,3 ,254,3 ,255,3 ,},[63]={0,3 ,1,3 ,146,3 ,147,3 ,148,3 ,149,3 ,254,3 ,255,3 ,},[64]={0,3 ,1,3 ,146,3 ,147,3 ,148,3 ,149,3 ,254,3 ,255,3 ,},[65]={0,3 ,1,3 ,146,3 ,147,3 ,148,3 ,149,3 ,254,3 ,255,3 ,},[66]={0,3 ,1,3 ,146,3 ,147,3 ,148,3 ,149,3 ,254,3 ,255,3 ,},[67]={0,3 ,1,3 ,146,3 ,147,3 ,148,3 ,149,3 ,254,3 ,255,3 ,},[68]={0,3 ,1,3 ,146,2 ,147,2 ,148,2 ,149,2 ,254,3 ,255,3 ,},[69]={0,3 ,1,3 ,146,2 ,147,2 ,148,2 ,149,2 ,254,3 ,255,3 ,},[70]={0,1 ,1,1 ,2,30 ,3,30 ,4,30 ,5,30 ,6,30 ,7,30 ,8,30 ,9,30 ,138,30 ,139,30 ,140,30 ,141,30 ,142,30 ,143,30 ,144,30 ,145,30 ,146,2 ,147,2 ,148,2 ,149,2 ,254,1 ,255,1 ,},[71]={0,1 ,1,1 ,2,30 ,3,30 ,4,30 ,5,30 ,6,30 ,7,30 ,8,30 ,9,30 ,138,30 ,139,30 ,140,30 ,141,30 ,142,30 ,143,30 ,144,30 ,145,30 ,146,2 ,147,2 ,148,2 ,149,2 ,254,1 ,255,1 ,},[72]={0,1 ,1,1 ,2,30 ,3,30 ,4,30 ,5,30 ,6,30 ,7,30 ,8,30 ,9,30 ,72,426 ,73,426 ,74,426 ,75,426 ,138,30 ,139,30 ,140,30 ,141,30 ,142,30 ,143,30 ,144,30 ,145,30 ,146,2 ,147,2 ,148,2 ,149,2 ,254,1 ,255,1 ,},[73]={0,1 ,1,1 ,2,30 ,3,30 ,4,30 ,5,30 ,6,30 ,7,30 ,8,30 ,9,30 ,72,426 ,73,426 ,74,426 ,75,426 ,138,30 ,139,30 ,140,30 ,141,30 ,142,30 ,143,30 ,144,30 ,145,30 ,146,2 ,147,2 ,148,2 ,149,2 ,254,1 ,255,1 ,},[74]={0,2 ,1,2 ,2,30 ,3,30 ,4,30 ,5,30 ,6,30 ,7,30 ,8,30 ,9,30 ,72,426 ,73,426 ,74,426 ,75,426 ,138,30 ,139,30 ,140,30 ,141,30 ,142,30 ,143,30 ,144,30 ,145,30 ,146,1 ,147,1 ,148,1 ,149,1 ,254,2 ,255,2 ,},[75]={0,2 ,1,2 ,2,30 ,3,30 ,4,30 ,5,30 ,6,30 ,7,30 ,8,30 ,9,30 ,72,426 ,73,426 ,74,426 ,75,426 ,138,30 ,139,30 ,140,30 ,141,30 ,142,30 ,143,30 ,144,30 ,145,30 ,146,1 ,147,1 ,148,1 ,149,1 ,254,2 ,255,2 ,},[76]={0,2 ,1,2 ,2,30 ,3,30 ,4,30 ,5,30 ,6,30 ,7,30 ,8,30 ,9,30 ,138,30 ,139,30 ,140,30 ,141,30 ,142,30 ,143,30 ,144,30 ,145,30 ,146,1 ,147,1 ,148,1 ,149,1 ,254,2 ,255,2 ,},[77]={0,2 ,1,2 ,2,30 ,3,30 ,4,30 ,5,30 ,6,30 ,7,30 ,8,30 ,9,30 ,138,30 ,139,30 ,140,30 ,141,30 ,142,30 ,143,30 ,144,30 ,145,30 ,146,1 ,147,1 ,148,1 ,149,1 ,254,2 ,255,2 ,},[78]={0,2 ,1,2 ,146,2 ,147,2 ,148,2 ,149,2 ,254,2 ,255,2 ,},[79]={0,2 ,1,2 ,146,2 ,147,2 ,148,2 ,149,2 ,254,2 ,255,2 ,},[80]={0,2 ,1,2 ,146,2 ,147,2 ,148,2 ,149,2 ,254,2 ,255,2 ,},[81]={0,2 ,1,2 ,146,2 ,147,2 ,148,2 ,149,2 ,254,2 ,255,2 ,},[82]={0,2 ,1,2 ,146,2 ,147,2 ,148,2 ,149,2 ,254,2 ,255,2 ,},[83]={0,2 ,1,2 ,146,2 ,147,2 ,148,2 ,149,2 ,254,2 ,255,2 ,},[84]={0,2 ,1,2 ,146,2 ,147,2 ,148,2 ,149,2 ,254,2 ,255,2 ,},[85]={0,2 ,1,2 ,146,2 ,147,2 ,148,2 ,149,2 ,254,2 ,255,2 ,},[86]={0,2 ,1,2 ,146,2 ,147,2 ,148,2 ,149,2 ,254,2 ,255,2 ,},[87]={0,2 ,1,2 ,146,2 ,147,2 ,148,2 ,149,2 ,254,2 ,255,2 ,},[88]={0,2 ,1,2 ,146,2 ,147,2 ,148,2 ,149,2 ,254,2 ,255,2 ,},[89]={0,2 ,1,2 ,146,2 ,147,2 ,148,2 ,149,2 ,254,2 ,255,2 ,},[90]={0,2 ,1,2 ,146,2 ,147,2 ,148,2 ,149,2 ,254,2 ,255,2 ,},[91]={0,2 ,1,2 ,146,2 ,147,2 ,148,2 ,149,2 ,254,2 ,255,2 ,},[92]={0,2 ,1,2 ,146,2 ,147,2 ,148,2 ,149,2 ,254,2 ,255,2 ,},[93]={0,2 ,1,2 ,146,2 ,147,2 ,148,2 ,149,2 ,254,2 ,255,2 ,},[94]={0,2 ,1,2 ,146,2 ,147,2 ,148,2 ,149,2 ,254,2 ,255,2 ,},[95]={0,2 ,1,2 ,146,2 ,147,2 ,148,2 ,149,2 ,254,2 ,255,2 ,},[96]={0,3 ,1,3 ,146,2 ,147,2 ,148,2 ,149,2 ,254,3 ,255,3 ,},[97]={0,3 ,1,3 ,146,2 ,147,2 ,148,2 ,149,2 ,254,3 ,255,3 ,},[98]={0,3 ,1,3 ,146,2 ,147,2 ,148,2 ,149,2 ,254,3 ,255,3 ,},[99]={0,3 ,1,3 ,146,2 ,147,2 ,148,2 ,149,2 ,254,3 ,255,3 ,},[100]={0,3 ,1,3 ,146,2 ,147,2 ,148,2 ,149,2 ,254,3 ,255,3 ,},[101]={0,3 ,1,3 ,146,2 ,147,2 ,148,2 ,149,2 ,254,3 ,255,3 ,},[102]={0,3 ,1,3 ,146,2 ,147,2 ,148,2 ,149,2 ,254,3 ,255,3 ,},[103]={0,3 ,1,3 ,146,2 ,147,2 ,148,2 ,149,2 ,254,3 ,255,3 ,},[104]={0,3 ,1,3 ,146,2 ,147,2 ,148,2 ,149,2 ,254,3 ,255,3 ,},[105]={0,3 ,1,3 ,146,2 ,147,2 ,148,2 ,149,2 ,254,3 ,255,3 ,},[106]={0,3 ,1,3 ,146,2 ,147,2 ,148,2 ,149,2 ,254,3 ,255,3 ,},[107]={0,3 ,1,3 ,146,2 ,147,2 ,148,2 ,149,2 ,254,3 ,255,3 ,},[108]={0,3 ,1,3 ,146,2 ,147,2 ,148,2 ,149,2 ,254,3 ,255,3 ,},[109]={0,3 ,1,3 ,146,2 ,147,2 ,148,2 ,149,2 ,254,3 ,255,3 ,},[110]={0,3 ,1,3 ,146,2 ,147,2 ,148,2 ,149,2 ,254,3 ,255,3 ,},[111]={0,3 ,1,3 ,146,2 ,147,2 ,148,2 ,149,2 ,254,3 ,255,3 ,},[112]={0,3 ,1,3 ,146,2 ,147,2 ,148,2 ,149,2 ,254,3 ,255,3 ,},[113]={0,3 ,1,3 ,146,2 ,147,2 ,148,2 ,149,2 ,254,3 ,255,3 ,},[114]={0,3 ,1,3 ,146,2 ,147,2 ,148,2 ,149,2 ,254,3 ,255,3 ,},[115]={0,3 ,1,3 ,146,2 ,147,2 ,148,2 ,149,2 ,254,3 ,255,3 ,},[116]={0,3 ,1,3 ,146,2 ,147,2 ,148,2 ,149,2 ,254,3 ,255,3 ,},[117]={0,3 ,1,3 ,146,2 ,147,2 ,148,2 ,149,2 ,254,3 ,255,3 ,},[118]={0,3 ,1,3 ,146,2 ,147,2 ,148,2 ,149,2 ,254,3 ,255,3 ,},[119]={0,3 ,1,3 ,146,2 ,147,2 ,148,2 ,149,2 ,254,3 ,255,3 ,},[120]={0,3 ,1,3 ,146,2 ,147,2 ,148,2 ,149,2 ,254,3 ,255,3 ,},[121]={0,3 ,1,3 ,146,2 ,147,2 ,148,2 ,149,2 ,254,3 ,255,3 ,},[122]={0,3 ,1,3 ,146,2 ,147,2 ,148,2 ,149,2 ,254,3 ,255,3 ,},[123]={0,3 ,1,3 ,146,2 ,147,2 ,148,2 ,149,2 ,254,3 ,255,3 ,},[124]={0,3 ,1,3 ,146,2 ,147,2 ,148,2 ,149,2 ,254,3 ,255,3 ,},[125]={0,3 ,1,3 ,146,2 ,147,2 ,148,2 ,149,2 ,254,3 ,255,3 ,},[126]={0,3 ,1,3 ,146,2 ,147,2 ,148,2 ,149,2 ,254,3 ,255,3 ,},[127]={0,3 ,1,3 ,146,2 ,147,2 ,148,2 ,149,2 ,254,3 ,255,3 ,},[128]={0,3 ,1,3 ,146,2 ,147,2 ,148,2 ,149,2 ,254,3 ,255,3 ,},[129]={0,3 ,1,3 ,146,2 ,147,2 ,148,2 ,149,2 ,254,3 ,255,3 ,},[130]={0,3 ,1,3 ,146,2 ,147,2 ,148,2 ,149,2 ,254,3 ,255,3 ,},[131]={0,3 ,1,3 ,146,2 ,147,2 ,148,2 ,149,2 ,254,3 ,255,3 ,},[132]={0,3 ,1,3 ,146,2 ,147,2 ,148,2 ,149,2 ,254,3 ,255,3 ,},[133]={0,3 ,1,3 ,146,2 ,147,2 ,148,2 ,149,2 ,254,3 ,255,3 ,},[134]={0,3 ,1,3 ,146,2 ,147,2 ,148,2 ,149,2 ,254,3 ,255,3 ,},[135]={0,3 ,1,3 ,146,2 ,147,2 ,148,2 ,149,2 ,254,3 ,255,3 ,},[136]={0,3 ,1,3 ,146,2 ,147,2 ,148,2 ,149,2 ,254,3 ,255,3 ,},[137]={0,3 ,1,3 ,146,2 ,147,2 ,148,2 ,149,2 ,254,3 ,255,3 ,},[138]={0,3 ,1,3 ,70,30 ,71,30 ,72,30 ,73,30 ,74,30 ,75,30 ,76,30 ,77,30 ,146,2 ,147,2 ,148,2 ,149,2 ,254,3 ,255,3 ,},[139]={0,3 ,1,3 ,70,30 ,71,30 ,72,30 ,73,30 ,74,30 ,75,30 ,76,30 ,77,30 ,146,2 ,147,2 ,148,2 ,149,2 ,254,3 ,255,3 ,},[140]={0,3 ,1,3 ,2,30 ,3,30 ,4,30 ,5,30 ,6,30 ,7,30 ,70,30 ,71,30 ,72,30 ,73,30 ,74,30 ,75,30 ,76,30 ,77,30 ,140,30 ,141,30 ,142,30 ,143,30 ,144,30 ,145,30 ,146,2 ,147,2 ,148,2 ,149,2 ,254,3 ,255,3 ,},[141]={0,3 ,1,3 ,2,30 ,3,30 ,4,30 ,5,30 ,6,30 ,7,30 ,70,30 ,71,30 ,72,30 ,73,30 ,74,30 ,75,30 ,76,30 ,77,30 ,140,30 ,141,30 ,142,30 ,143,30 ,144,30 ,145,30 ,146,2 ,147,2 ,148,2 ,149,2 ,254,3 ,255,3 ,},[142]={0,3 ,1,3 ,2,30 ,3,30 ,4,30 ,5,30 ,6,30 ,7,30 ,70,30 ,71,30 ,72,30 ,73,30 ,74,30 ,75,30 ,76,30 ,77,30 ,140,30 ,141,30 ,142,30 ,143,30 ,144,30 ,145,30 ,146,2 ,147,2 ,148,2 ,149,2 ,254,3 ,255,3 ,},[143]={0,3 ,1,3 ,2,30 ,3,30 ,4,30 ,5,30 ,6,30 ,7,30 ,70,30 ,71,30 ,72,30 ,73,30 ,74,30 ,75,30 ,76,30 ,77,30 ,140,30 ,141,30 ,142,30 ,143,30 ,144,30 ,145,30 ,146,2 ,147,2 ,148,2 ,149,2 ,254,3 ,255,3 ,},[144]={0,3 ,1,3 ,2,30 ,3,30 ,4,30 ,5,30 ,6,30 ,7,30 ,70,30 ,71,30 ,72,30 ,73,30 ,74,30 ,75,30 ,76,30 ,77,30 ,140,30 ,141,30 ,142,30 ,143,30 ,144,30 ,145,30 ,146,2 ,147,2 ,148,2 ,149,2 ,254,3 ,255,3 ,},[145]={0,3 ,1,3 ,2,30 ,3,30 ,4,30 ,5,30 ,6,30 ,7,30 ,70,30 ,71,30 ,72,30 ,73,30 ,74,30 ,75,30 ,76,30 ,77,30 ,140,30 ,141,30 ,142,30 ,143,30 ,144,30 ,145,30 ,146,2 ,147,2 ,148,2 ,149,2 ,254,3 ,255,3 ,},[146]={0,2 ,1,2 ,2,2 ,3,2 ,4,2 ,5,2 ,6,2 ,7,2 ,8,2 ,9,2 ,10,2 ,11,2 ,12,2 ,13,2 ,14,2 ,15,2 ,16,2 ,17,2 ,18,2 ,19,2 ,20,2 ,21,2 ,22,2 ,23,2 ,24,2 ,25,2 ,26,2 ,27,2 ,28,2 ,29,2 ,30,2 ,31,2 ,32,2 ,33,2 ,34,2 ,35,2 ,36,2 ,37,2 ,38,2 ,39,2 ,40,2 ,41,2 ,42,2 ,43,2 ,44,2 ,45,2 ,46,2 ,47,2 ,48,2 ,49,2 ,50,2 ,51,2 ,52,2 ,53,2 ,54,2 ,55,2 ,56,2 ,57,2 ,58,2 ,59,2 ,60,2 ,61,2 ,62,2 ,63,2 ,64,2 ,65,2 ,66,2 ,67,2 ,68,2 ,69,2 ,70,1 ,71,1 ,72,1 ,73,1 ,74,2 ,75,2 ,76,2 ,77,2 ,78,2 ,79,2 ,80,2 ,81,2 ,82,2 ,83,2 ,84,2 ,85,2 ,86,2 ,87,2 ,88,2 ,89,2 ,90,2 ,91,2 ,92,2 ,93,2 ,94,2 ,95,2 ,96,2 ,97,2 ,98,2 ,99,2 ,100,2 ,101,2 ,102,2 ,103,2 ,104,2 ,105,2 ,106,2 ,107,2 ,108,2 ,109,2 ,110,4 ,111,4 ,112,5 ,113,5 ,114,5 ,115,5 ,116,5 ,117,5 ,118,5 ,119,5 ,120,5 ,121,5 ,122,5 ,123,5 ,124,5 ,125,5 ,126,5 ,127,5 ,128,4 ,129,4 ,130,3 ,131,3 ,132,3 ,133,3 ,134,3 ,135,3 ,136,3 ,137,3 ,138,3 ,139,3 ,140,3 ,141,3 ,142,3 ,143,3 ,144,3 ,145,3 ,146,2 ,147,2 ,148,2 ,149,2 ,254,1 ,255,1 ,},[147]={0,2 ,1,2 ,2,2 ,3,2 ,4,2 ,5,2 ,6,2 ,7,2 ,8,2 ,9,2 ,10,2 ,11,2 ,12,2 ,13,2 ,14,2 ,15,2 ,16,2 ,17,2 ,18,2 ,19,2 ,20,2 ,21,2 ,22,2 ,23,2 ,24,2 ,25,2 ,26,2 ,27,2 ,28,2 ,29,2 ,30,2 ,31,2 ,32,2 ,33,2 ,34,2 ,35,2 ,36,2 ,37,2 ,38,2 ,39,2 ,40,2 ,41,2 ,42,2 ,43,2 ,44,2 ,45,2 ,46,2 ,47,2 ,48,2 ,49,2 ,50,2 ,51,2 ,52,2 ,53,2 ,54,2 ,55,2 ,56,2 ,57,2 ,58,2 ,59,2 ,60,2 ,61,2 ,62,2 ,63,2 ,64,2 ,65,2 ,66,2 ,67,2 ,68,2 ,69,2 ,70,1 ,71,1 ,72,1 ,73,1 ,74,2 ,75,2 ,76,2 ,77,2 ,78,2 ,79,2 ,80,2 ,81,2 ,82,2 ,83,2 ,84,2 ,85,2 ,86,2 ,87,2 ,88,2 ,89,2 ,90,2 ,91,2 ,92,2 ,93,2 ,94,2 ,95,2 ,96,2 ,97,2 ,98,2 ,99,2 ,100,2 ,101,2 ,102,2 ,103,2 ,104,2 ,105,2 ,106,2 ,107,2 ,108,2 ,109,2 ,110,4 ,111,4 ,112,5 ,113,5 ,114,5 ,115,5 ,116,5 ,117,5 ,118,5 ,119,5 ,120,5 ,121,5 ,122,5 ,123,5 ,124,5 ,125,5 ,126,5 ,127,5 ,128,4 ,129,4 ,130,3 ,131,3 ,132,3 ,133,3 ,134,3 ,135,3 ,136,3 ,137,3 ,138,3 ,139,3 ,140,3 ,141,3 ,142,3 ,143,3 ,144,3 ,145,3 ,146,2 ,147,2 ,148,2 ,149,2 ,254,1 ,255,1 ,},[148]={0,2 ,1,2 ,2,2 ,3,2 ,4,2 ,5,2 ,6,2 ,7,2 ,8,2 ,9,2 ,10,2 ,11,2 ,12,2 ,13,2 ,14,2 ,15,2 ,16,2 ,17,2 ,18,2 ,19,2 ,20,2 ,21,2 ,22,2 ,23,2 ,24,2 ,25,2 ,26,2 ,27,2 ,28,2 ,29,2 ,30,2 ,31,2 ,32,2 ,33,2 ,34,2 ,35,2 ,36,2 ,37,2 ,38,2 ,39,2 ,40,2 ,41,2 ,42,2 ,43,2 ,44,2 ,45,2 ,46,2 ,47,2 ,48,2 ,49,2 ,50,2 ,51,2 ,52,2 ,53,2 ,54,2 ,55,2 ,56,2 ,57,2 ,58,2 ,59,2 ,60,2 ,61,2 ,62,2 ,63,2 ,64,2 ,65,2 ,66,2 ,67,2 ,68,2 ,69,2 ,70,1 ,71,1 ,72,1 ,73,1 ,74,2 ,75,2 ,76,2 ,77,2 ,78,2 ,79,2 ,80,2 ,81,2 ,82,2 ,83,2 ,84,2 ,85,2 ,86,2 ,87,2 ,88,2 ,89,2 ,90,2 ,91,2 ,92,2 ,93,2 ,94,2 ,95,2 ,96,2 ,97,2 ,98,2 ,99,2 ,100,2 ,101,2 ,102,2 ,103,2 ,104,2 ,105,2 ,106,2 ,107,2 ,108,2 ,109,2 ,110,4 ,111,4 ,112,5 ,113,5 ,114,5 ,115,5 ,116,5 ,117,5 ,118,5 ,119,5 ,120,5 ,121,5 ,122,5 ,123,5 ,124,5 ,125,5 ,126,5 ,127,5 ,128,4 ,129,4 ,130,3 ,131,3 ,132,3 ,133,3 ,134,3 ,135,3 ,136,3 ,137,3 ,138,3 ,139,3 ,140,3 ,141,3 ,142,3 ,143,3 ,144,3 ,145,3 ,146,1 ,147,1 ,148,1 ,149,1 ,254,1 ,255,1 ,},[149]={0,2 ,1,2 ,2,2 ,3,2 ,4,2 ,5,2 ,6,2 ,7,2 ,8,2 ,9,2 ,10,2 ,11,2 ,12,2 ,13,2 ,14,2 ,15,2 ,16,2 ,17,2 ,18,2 ,19,2 ,20,2 ,21,2 ,22,2 ,23,2 ,24,2 ,25,2 ,26,2 ,27,2 ,28,2 ,29,2 ,30,2 ,31,2 ,32,2 ,33,2 ,34,2 ,35,2 ,36,2 ,37,2 ,38,2 ,39,2 ,40,2 ,41,2 ,42,2 ,43,2 ,44,2 ,45,2 ,46,2 ,47,2 ,48,2 ,49,2 ,50,2 ,51,2 ,52,2 ,53,2 ,54,2 ,55,2 ,56,2 ,57,2 ,58,2 ,59,2 ,60,2 ,61,2 ,62,2 ,63,2 ,64,2 ,65,2 ,66,2 ,67,2 ,68,2 ,69,2 ,70,1 ,71,1 ,72,1 ,73,1 ,74,2 ,75,2 ,76,2 ,77,2 ,78,2 ,79,2 ,80,2 ,81,2 ,82,2 ,83,2 ,84,2 ,85,2 ,86,2 ,87,2 ,88,2 ,89,2 ,90,2 ,91,2 ,92,2 ,93,2 ,94,2 ,95,2 ,96,2 ,97,2 ,98,2 ,99,2 ,100,2 ,101,2 ,102,2 ,103,2 ,104,2 ,105,2 ,106,2 ,107,2 ,108,2 ,109,2 ,110,4 ,111,4 ,112,5 ,113,5 ,114,5 ,115,5 ,116,5 ,117,5 ,118,5 ,119,5 ,120,5 ,121,5 ,122,5 ,123,5 ,124,5 ,125,5 ,126,5 ,127,5 ,128,4 ,129,4 ,130,3 ,131,3 ,132,3 ,133,3 ,134,3 ,135,3 ,136,3 ,137,3 ,138,3 ,139,3 ,140,3 ,141,3 ,142,3 ,143,3 ,144,3 ,145,3 ,146,1 ,147,1 ,148,1 ,149,1 ,254,1 ,255,1 ,},[254]={0,1 ,1,1 ,2,3 ,3,3 ,4,3 ,5,3 ,6,3 ,7,3 ,8,3 ,9,3 ,10,3 ,11,3 ,12,3 ,13,3 ,14,3 ,15,3 ,16,3 ,17,3 ,18,3 ,19,3 ,20,3 ,21,3 ,22,3 ,23,3 ,24,4 ,25,4 ,26,3 ,27,3 ,28,3 ,29,3 ,30,3 ,31,3 ,32,3 ,33,3 ,34,3 ,35,3 ,36,3 ,37,3 ,38,3 ,39,3 ,40,3 ,41,3 ,42,3 ,43,3 ,44,3 ,45,3 ,46,2 ,47,2 ,48,2 ,49,2 ,50,2 ,51,2 ,52,2 ,53,2 ,54,2 ,55,2 ,56,2 ,57,2 ,58,2 ,59,2 ,60,2 ,61,2 ,62,2 ,63,2 ,64,2 ,65,2 ,66,2 ,67,2 ,68,2 ,69,2 ,70,2 ,71,2 ,72,2 ,73,2 ,74,1 ,75,1 ,76,1 ,77,1 ,78,3 ,79,3 ,80,3 ,81,3 ,82,3 ,83,3 ,84,3 ,85,3 ,86,3 ,87,3 ,88,3 ,89,3 ,90,3 ,91,3 ,92,3 ,93,3 ,94,3 ,95,3 ,96,3 ,97,3 ,98,3 ,99,3 ,100,3 ,101,3 ,102,3 ,103,3 ,104,3 ,105,3 ,106,3 ,107,3 ,108,3 ,109,3 ,110,3 ,111,3 ,112,3 ,113,3 ,114,3 ,115,3 ,116,3 ,117,3 ,118,3 ,119,3 ,120,3 ,121,3 ,122,3 ,123,3 ,124,3 ,125,3 ,126,3 ,127,3 ,128,3 ,129,3 ,130,4 ,131,4 ,132,5 ,133,5 ,134,5 ,135,5 ,136,5 ,137,5 ,138,5 ,139,5 ,140,5 ,141,5 ,142,5 ,143,5 ,144,5 ,145,5 ,146,3 ,147,3 ,148,3 ,149,3 ,254,1 ,255,1 ,},[255]={0,1 ,1,1 ,2,3 ,3,3 ,4,3 ,5,3 ,6,3 ,7,3 ,8,3 ,9,3 ,10,3 ,11,3 ,12,3 ,13,3 ,14,3 ,15,3 ,16,3 ,17,3 ,18,3 ,19,3 ,20,3 ,21,3 ,22,3 ,23,3 ,24,4 ,25,4 ,26,3 ,27,3 ,28,3 ,29,3 ,30,3 ,31,3 ,32,3 ,33,3 ,34,3 ,35,3 ,36,3 ,37,3 ,38,3 ,39,3 ,40,3 ,41,3 ,42,3 ,43,3 ,44,3 ,45,3 ,46,2 ,47,2 ,48,2 ,49,2 ,50,2 ,51,2 ,52,2 ,53,2 ,54,2 ,55,2 ,56,2 ,57,2 ,58,2 ,59,2 ,60,2 ,61,2 ,62,2 ,63,2 ,64,2 ,65,2 ,66,2 ,67,2 ,68,2 ,69,2 ,70,2 ,71,2 ,72,2 ,73,2 ,74,1 ,75,1 ,76,1 ,77,1 ,78,3 ,79,3 ,80,3 ,81,3 ,82,3 ,83,3 ,84,3 ,85,3 ,86,3 ,87,3 ,88,3 ,89,3 ,90,3 ,91,3 ,92,3 ,93,3 ,94,3 ,95,3 ,96,3 ,97,3 ,98,3 ,99,3 ,100,3 ,101,3 ,102,3 ,103,3 ,104,3 ,105,3 ,106,3 ,107,3 ,108,3 ,109,3 ,110,3 ,111,3 ,112,3 ,113,3 ,114,3 ,115,3 ,116,3 ,117,3 ,118,3 ,119,3 ,120,3 ,121,3 ,122,3 ,123,3 ,124,3 ,125,3 ,126,3 ,127,3 ,128,3 ,129,3 ,130,4 ,131,4 ,132,5 ,133,5 ,134,5 ,135,5 ,136,5 ,137,5 ,138,5 ,139,5 ,140,5 ,141,5 ,142,5 ,143,5 ,144,5 ,145,5 ,146,3 ,147,3 ,148,3 ,149,3 ,254,1 ,255,1 ,}
		},

		objects ={
			[0]={146,5,9,-1,0 ,254,5,9,-1,1024 ,},[2]={146,5,9,-1,0 ,254,5,9,-1,1024 ,},[4]={146,5,9,-1,0 ,254,5,9,-1,1024 ,},[6]={146,5,9,-1,0 ,254,5,9,-1,1024 ,},[8]={146,5,9,-1,0 ,254,5,9,-1,1024 ,},[10]={146,5,9,-1,0 ,254,5,9,-1,1024 ,},[12]={146,5,9,-1,0 ,254,5,9,-1,1024 ,},[14]={146,5,9,-1,0 ,254,5,9,-1,1024 ,},[16]={146,5,9,-1,0 ,254,5,9,-1,1024 ,},[18]={146,5,9,-1,0 ,254,5,9,-1,1024 ,},[20]={146,5,9,-1,0 ,254,5,9,-1,1024 ,},[22]={146,5,9,-1,0 ,254,5,9,-1,1024 ,},[24]={146,5,9,-1,0 ,254,5,9,-1,1024 ,},[26]={146,5,9,-1,0 ,254,5,9,-1,1024 ,},[28]={146,5,9,-1,0 ,254,5,9,-1,1024 ,},[30]={146,5,9,-1,0 ,254,5,9,-1,1024 ,},[32]={146,5,9,-1,0 ,254,5,9,-1,1024 ,},[34]={146,5,9,-1,0 ,254,5,9,-1,1024 ,},[36]={146,5,9,-1,0 ,254,5,9,-1,1024 ,},[38]={146,5,9,-1,0 ,254,5,9,-1,1024 ,},[40]={146,5,9,-1,0 ,254,5,9,-1,1024 ,},[42]={146,5,9,-1,0 ,254,5,9,-1,1024 ,},[44]={146,5,9,-1,0 ,254,5,9,-1,1024 ,},[46]={146,5,9,-1,0 ,254,5,9,-1,1024 ,},[48]={146,5,9,-1,0 ,254,5,9,-1,1024 ,},[50]={146,5,9,-1,0 ,254,5,9,-1,1024 ,},[52]={146,5,9,-1,0 ,254,5,9,-1,1024 ,},[54]={146,5,9,-1,0 ,254,5,9,-1,1024 ,},[56]={146,5,9,-1,0 ,254,5,9,-1,1024 ,},[58]={146,5,9,-1,0 ,254,5,9,-1,1024 ,},[60]={146,5,9,-1,0 ,254,5,9,-1,1024 ,},[62]={146,5,9,-1,0 ,254,5,9,-1,1024 ,},[64]={146,5,9,-1,0 ,254,5,9,-1,1024 ,},[66]={146,5,9,-1,0 ,254,5,9,-1,1024 ,},[68]={146,5,9,-1,0 ,254,5,9,-1,1024 ,},[70]={146,5,9,-1,0 ,254,5,9,-1,1024 ,},[72]={146,5,9,-1,0 ,254,5,9,-1,1024 ,},[74]={146,5,9,-1,0 ,254,5,9,-1,1024 ,},[76]={146,5,9,-1,0 ,254,5,9,-1,1024 ,},[78]={146,5,9,-1,0 ,254,5,9,-1,1024 ,},[80]={146,5,9,-1,0 ,254,5,9,-1,1024 ,},[82]={146,5,9,-1,0 ,254,5,9,-1,1024 ,},[84]={146,5,9,-1,0 ,254,5,9,-1,1024 ,},[86]={146,5,9,-1,0 ,254,5,9,-1,1024 ,},[88]={146,5,9,-1,0 ,254,5,9,-1,1024 ,},[90]={146,5,9,-1,0 ,254,5,9,-1,1024 ,},[92]={146,5,9,-1,0 ,254,5,9,-1,1024 ,},[94]={146,5,9,-1,0 ,254,5,9,-1,1024 ,},[96]={146,5,9,-1,0 ,254,5,9,-1,1024 ,},[98]={146,5,9,-1,0 ,254,5,9,-1,1024 ,},[100]={146,5,9,-1,0 ,254,5,9,-1,1024 ,},[102]={146,5,9,-1,0 ,254,5,9,-1,1024 ,},[104]={146,5,9,-1,0 ,254,5,9,-1,1024 ,},[106]={146,5,9,-1,0 ,254,5,9,-1,1024 ,},[108]={146,5,9,-1,0 ,254,5,9,-1,1024 ,},[110]={146,5,9,-1,0 ,254,5,9,-1,1024 ,},[112]={146,5,9,-1,0 ,254,5,9,-1,1024 ,},[114]={146,5,9,-1,0 ,254,5,9,-1,1024 ,},[116]={146,5,9,-1,0 ,254,5,9,-1,1024 ,},[118]={146,5,9,-1,0 ,254,5,9,-1,1024 ,},[120]={146,5,9,-1,0 ,254,5,9,-1,1024 ,},[122]={146,5,9,-1,0 ,254,5,9,-1,1024 ,},[124]={146,5,9,-1,0 ,254,5,9,-1,1024 ,},[126]={146,5,9,-1,0 ,254,5,9,-1,1024 ,},[128]={146,5,9,-1,0 ,254,5,9,-1,1024 ,},[130]={146,5,9,-1,0 ,254,5,9,-1,1024 ,},[132]={146,5,9,-1,0 ,254,5,9,-1,1024 ,},[134]={146,5,9,-1,0 ,254,5,9,-1,1024 ,},[136]={146,5,9,-1,0 ,254,5,9,-1,1024 ,},[138]={146,5,9,-1,0 ,254,5,9,-1,1024 ,},[140]={146,5,9,-1,0 ,254,5,9,-1,1024 ,},[142]={146,5,9,-1,0 ,254,5,9,-1,1024 ,},[144]={146,5,9,-1,0 ,254,5,9,-1,1024 ,},[146]={0,5,9,-1,512 ,2,5,9,-1,512 ,4,5,9,-1,512 ,6,5,9,-1,512 ,8,5,9,-1,512 ,10,5,9,-1,512 ,12,5,9,-1,512 ,14,5,9,-1,512 ,16,5,9,-1,512 ,18,5,9,-1,512 ,20,5,9,-1,512 ,22,5,9,-1,512 ,24,5,9,-1,512 ,26,5,9,-1,512 ,28,5,9,-1,512 ,30,5,9,-1,512 ,32,5,9,-1,512 ,34,5,9,-1,512 ,36,5,9,-1,512 ,38,5,9,-1,512 ,40,5,9,-1,512 ,42,5,9,-1,512 ,44,5,9,-1,512 ,46,5,9,-1,512 ,48,5,9,-1,512 ,50,5,9,-1,512 ,52,5,9,-1,512 ,54,5,9,-1,512 ,56,5,9,-1,512 ,58,5,9,-1,512 ,60,5,9,-1,512 ,62,5,9,-1,512 ,64,5,9,-1,512 ,66,5,9,-1,512 ,68,5,9,-1,512 ,70,5,9,-1,512 ,72,5,9,-1,512 ,74,5,9,-1,512 ,76,5,9,-1,512 ,78,5,9,-1,512 ,80,5,9,-1,512 ,82,5,9,-1,512 ,84,5,9,-1,512 ,86,5,9,-1,512 ,88,5,9,-1,512 ,90,5,9,-1,512 ,92,5,9,-1,512 ,94,5,9,-1,512 ,96,5,9,-1,512 ,98,5,9,-1,512 ,100,5,9,-1,512 ,102,5,9,-1,512 ,104,5,9,-1,512 ,106,5,9,-1,512 ,108,5,9,-1,512 ,110,5,9,-1,512 ,112,5,9,-1,512 ,114,5,9,-1,512 ,116,5,9,-1,512 ,118,5,9,-1,512 ,120,5,9,-1,512 ,122,5,9,-1,512 ,124,5,9,-1,512 ,126,5,9,-1,512 ,128,5,9,-1,512 ,130,5,9,-1,512 ,132,5,9,-1,512 ,134,5,9,-1,512 ,136,5,9,-1,512 ,138,5,9,-1,512 ,140,5,9,-1,512 ,142,5,9,-1,512 ,144,5,9,-1,512 ,146,5,9,-1,256 ,254,5,9,-1,768 ,},[254]={0,5,9,-1,1536 ,2,5,9,-1,1536 ,4,5,9,-1,1536 ,6,5,9,-1,1536 ,8,5,9,-1,1536 ,10,5,9,-1,1536 ,12,5,9,-1,1536 ,14,5,9,-1,1536 ,16,5,9,-1,1536 ,18,5,9,-1,1536 ,20,5,9,-1,1536 ,22,5,9,-1,1536 ,24,5,9,-1,1536 ,26,5,9,-1,1536 ,28,5,9,-1,1536 ,30,5,9,-1,1536 ,32,5,9,-1,1536 ,34,5,9,-1,1536 ,36,5,9,-1,1536 ,38,5,9,-1,1536 ,40,5,9,-1,1536 ,42,5,9,-1,1536 ,44,5,9,-1,1536 ,46,5,9,-1,1536 ,48,5,9,-1,1536 ,50,5,9,-1,1536 ,52,5,9,-1,1536 ,54,5,9,-1,1536 ,56,5,9,-1,1536 ,58,5,9,-1,1536 ,60,5,9,-1,1536 ,62,5,9,-1,1536 ,64,5,9,-1,1536 ,66,5,9,-1,1536 ,68,5,9,-1,1536 ,70,5,9,-1,1536 ,72,5,9,-1,1536 ,74,5,9,-1,1536 ,76,5,9,-1,1536 ,78,5,9,-1,1536 ,80,5,9,-1,1536 ,82,5,9,-1,1536 ,84,5,9,-1,1536 ,86,5,9,-1,1536 ,88,5,9,-1,1536 ,90,5,9,-1,1536 ,92,5,9,-1,1536 ,94,5,9,-1,1536 ,96,5,9,-1,1536 ,98,5,9,-1,1536 ,100,5,9,-1,1536 ,102,5,9,-1,1536 ,104,5,9,-1,1536 ,106,5,9,-1,1536 ,108,5,9,-1,1536 ,110,5,9,-1,1536 ,112,5,9,-1,1536 ,114,5,9,-1,1536 ,116,5,9,-1,1536 ,118,5,9,-1,1536 ,120,5,9,-1,1536 ,122,5,9,-1,1536 ,124,5,9,-1,1536 ,126,5,9,-1,1536 ,128,5,9,-1,1536 ,130,5,9,-1,1536 ,132,5,9,-1,1536 ,134,5,9,-1,1536 ,136,5,9,-1,1536 ,138,5,9,-1,1536 ,140,5,9,-1,1536 ,142,5,9,-1,1536 ,144,5,9,-1,1536 ,146,5,9,-1,1792 ,254,5,9,-1,1280 ,}
		},
		
		markers ={
			2, 2,72, 2, 142, 2, 142, 72, 142, 142, 72, 142, 2, 142, 2, 72, 8, 8, 72, 10, 136, 8, 134, 72, 136, 136, 72, 134, 8, 136, 10, 72, 194, 196, 8, 252, 252, 252, 66, 10, 78, 10, 78, 252, 136, 252, 148, 8, 134, 66, 134, 78, 148, 78, 148, 136, 136, 148, 78, 134, 66, 134, 66, 148, 8, 148, 252, 136, 10, 78, 10, 66, 252, 66, 0, 0
		},
		
		decorations = {
			72,72,5,0
		},
		
		shaman_positions = {
			2, 2, 72, 2, 142, 2, 142, 72, 142, 142, 72, 142, 2, 142, 2, 72
		},
		
		scripts = {
			OnTurn = function(everySecond1, everySecond2, everySecond4) 			naval_warfare_on_turn(everySecond1, everySecond2, everySecond4) end,
			OnFrame = function() 													naval_warfare_on_frame() end,
			OnCreateThing = function(t, owner, type, model) 						naval_warfare_on_create_thing(t, owner, type, model) end,
			OnShamanDeath = function(victim, killer, killer_was_ally)				naval_warfare_on_shaman_dead(victim, killer, killer_was_ally) end,
			OnHumanDisconnect = function(player) 									init_single_AI_3(player) end,
			OnEnd = function()														NW_on_end() end,
		},
		
	},
	
	[MAP_TECTONIC]={
	
		info = 	{ 	name = "Tectonic", author = "Divinity",
					desc = "Players try to survive each round, by avoiding unstable locations marked by the earthquake icon. <br> Said zones sink moments after, sending nearby shamans to the depths of the rift... Each round you survive will earn you 1 point. <br> The powerups are: <p> - Jump: The shaman jumps for some seconds. Use this if your shaman is on an instable zone, right before the ground sinks. <br> - Blast: Grants 1 shot of blast.",
					map_objectives = { {value=4, step=1, default=false}, {value=30, step=5, default=true}, {value=40, step=5, default=true} },
					image = 3344, texture={29,4}, zoom={254,238,0}, drop_infos = true,	marker_lb={122,142}, reinc_timer=999, shield_respawn=true,
					custom_rules = {
						{ default = false, 	name = "Randomized shaman speeds", desc = "On each round, shamans have random speeds (all shamans have the same speed)." },
						{ default = false, 	name = "No Power-ups", desc = "Powerups won't appear. Only moving matters!" },
					}
				},
	
		land ={
			[0]={0,510 ,1,510 ,2,510 ,3,510 ,4,510 ,5,510 ,6,510 ,7,510 ,8,510 ,9,510 ,10,510 ,11,510 ,12,510 ,13,510 ,14,510 ,15,510 ,16,510 ,17,510 ,242,510 ,243,510 ,244,510 ,245,510 ,246,510 ,247,510 ,248,510 ,249,510 ,250,510 ,251,510 ,252,510 ,253,510 ,254,510 ,255,510 ,},[1]={0,510 ,1,510 ,2,510 ,3,510 ,4,510 ,5,510 ,6,510 ,7,510 ,8,510 ,9,510 ,10,510 ,11,510 ,12,510 ,13,510 ,14,510 ,15,510 ,16,510 ,17,510 ,242,510 ,243,510 ,244,510 ,245,510 ,246,510 ,247,510 ,248,510 ,249,510 ,250,510 ,251,510 ,252,510 ,253,510 ,254,510 ,255,510 ,},[2]={0,510 ,1,510 ,2,510 ,3,510 ,4,510 ,5,510 ,6,510 ,7,510 ,8,510 ,9,510 ,10,510 ,11,510 ,12,510 ,13,510 ,14,510 ,15,510 ,16,510 ,17,510 ,242,510 ,243,510 ,244,510 ,245,510 ,246,510 ,247,510 ,248,510 ,249,510 ,250,510 ,251,510 ,252,510 ,253,510 ,254,510 ,255,510 ,},[3]={0,510 ,1,510 ,2,510 ,3,510 ,4,510 ,5,510 ,6,510 ,7,510 ,8,510 ,9,510 ,10,510 ,11,510 ,12,510 ,13,510 ,14,510 ,15,510 ,16,510 ,17,510 ,242,510 ,243,510 ,244,510 ,245,510 ,246,510 ,247,510 ,248,510 ,249,510 ,250,510 ,251,510 ,252,510 ,253,510 ,254,510 ,255,510 ,},[4]={0,510 ,1,510 ,2,510 ,3,510 ,4,510 ,5,510 ,6,510 ,7,510 ,8,510 ,9,510 ,10,510 ,11,510 ,12,510 ,13,510 ,14,510 ,15,510 ,16,510 ,17,510 ,242,510 ,243,510 ,244,510 ,245,510 ,246,510 ,247,510 ,248,510 ,249,510 ,250,510 ,251,510 ,252,510 ,253,510 ,254,510 ,255,510 ,},[5]={0,510 ,1,510 ,2,510 ,3,510 ,4,510 ,5,510 ,6,510 ,7,510 ,8,510 ,9,510 ,10,510 ,11,510 ,12,510 ,13,510 ,14,510 ,15,510 ,16,510 ,17,510 ,242,510 ,243,510 ,244,510 ,245,510 ,246,510 ,247,510 ,248,510 ,249,510 ,250,510 ,251,510 ,252,510 ,253,510 ,254,510 ,255,510 ,},[6]={0,510 ,1,510 ,2,510 ,3,510 ,4,510 ,5,510 ,6,510 ,7,510 ,8,510 ,9,510 ,10,510 ,11,510 ,12,510 ,13,510 ,14,510 ,15,510 ,16,510 ,17,510 ,242,510 ,243,510 ,244,510 ,245,510 ,246,510 ,247,510 ,248,510 ,249,510 ,250,510 ,251,510 ,252,510 ,253,510 ,254,510 ,255,510 ,},[7]={0,510 ,1,510 ,2,510 ,3,510 ,4,510 ,5,510 ,6,510 ,7,510 ,8,510 ,9,510 ,10,510 ,11,510 ,12,510 ,13,510 ,14,510 ,15,510 ,16,510 ,17,510 ,242,510 ,243,510 ,244,510 ,245,510 ,246,510 ,247,510 ,248,510 ,249,510 ,250,510 ,251,510 ,252,510 ,253,510 ,254,510 ,255,510 ,},[8]={0,510 ,1,510 ,2,510 ,3,510 ,4,510 ,5,510 ,6,510 ,7,510 ,8,510 ,9,510 ,10,510 ,11,510 ,12,510 ,13,510 ,14,510 ,15,510 ,16,510 ,17,510 ,242,510 ,243,510 ,244,510 ,245,510 ,246,510 ,247,510 ,248,510 ,249,510 ,250,510 ,251,510 ,252,510 ,253,510 ,254,510 ,255,510 ,},[9]={0,510 ,1,510 ,2,510 ,3,510 ,4,510 ,5,510 ,6,510 ,7,510 ,8,510 ,9,510 ,10,510 ,11,510 ,12,510 ,13,510 ,14,510 ,15,510 ,16,510 ,17,510 ,242,510 ,243,510 ,244,510 ,245,510 ,246,510 ,247,510 ,248,510 ,249,510 ,250,510 ,251,510 ,252,510 ,253,510 ,254,510 ,255,510 ,},[10]={0,510 ,1,510 ,2,510 ,3,510 ,4,510 ,5,510 ,6,510 ,7,510 ,8,510 ,9,510 ,10,510 ,11,510 ,12,510 ,13,510 ,14,510 ,15,510 ,16,510 ,17,510 ,242,510 ,243,510 ,244,510 ,245,510 ,246,510 ,247,510 ,248,510 ,249,510 ,250,510 ,251,510 ,252,510 ,253,510 ,254,510 ,255,510 ,},[11]={0,510 ,1,510 ,2,510 ,3,510 ,4,510 ,5,510 ,6,510 ,7,510 ,8,510 ,9,510 ,10,510 ,11,510 ,12,510 ,13,510 ,14,510 ,15,510 ,16,510 ,17,510 ,242,510 ,243,510 ,244,510 ,245,510 ,246,510 ,247,510 ,248,510 ,249,510 ,250,510 ,251,510 ,252,510 ,253,510 ,254,510 ,255,510 ,},[12]={0,510 ,1,510 ,2,510 ,3,510 ,4,510 ,5,510 ,6,510 ,7,510 ,8,510 ,9,510 ,10,510 ,11,510 ,12,510 ,13,510 ,14,510 ,15,510 ,16,510 ,17,510 ,242,510 ,243,510 ,244,510 ,245,510 ,246,510 ,247,510 ,248,510 ,249,510 ,250,510 ,251,510 ,252,510 ,253,510 ,254,510 ,255,510 ,},[13]={0,510 ,1,510 ,2,510 ,3,510 ,4,510 ,5,510 ,6,510 ,7,510 ,8,510 ,9,510 ,10,510 ,11,510 ,12,510 ,13,510 ,14,510 ,15,510 ,16,510 ,17,510 ,242,510 ,243,510 ,244,510 ,245,510 ,246,510 ,247,510 ,248,510 ,249,510 ,250,510 ,251,510 ,252,510 ,253,510 ,254,510 ,255,510 ,},[14]={0,510 ,1,510 ,2,510 ,3,510 ,4,510 ,5,510 ,6,510 ,7,510 ,8,510 ,9,510 ,10,510 ,11,510 ,12,510 ,13,510 ,14,510 ,15,510 ,16,510 ,17,510 ,242,510 ,243,510 ,244,510 ,245,510 ,246,510 ,247,510 ,248,510 ,249,510 ,250,510 ,251,510 ,252,510 ,253,510 ,254,510 ,255,510 ,},[15]={0,510 ,1,510 ,2,510 ,3,510 ,4,510 ,5,510 ,6,510 ,7,510 ,8,510 ,9,510 ,10,510 ,11,510 ,12,510 ,13,510 ,14,510 ,15,510 ,16,510 ,17,510 ,242,510 ,243,510 ,244,510 ,245,510 ,246,510 ,247,510 ,248,510 ,249,510 ,250,510 ,251,510 ,252,510 ,253,510 ,254,510 ,255,510 ,},[22]={24,792 ,25,792 ,26,792 ,27,792 ,232,792 ,233,792 ,234,792 ,235,792 ,},[23]={24,792 ,25,792 ,26,792 ,27,792 ,232,792 ,233,792 ,234,792 ,235,792 ,},[24]={24,792 ,25,792 ,26,792 ,27,792 ,232,792 ,233,792 ,234,792 ,235,792 ,},[25]={24,792 ,25,792 ,26,792 ,27,792 ,232,792 ,233,792 ,234,792 ,235,792 ,},[230]={24,792 ,25,792 ,26,792 ,27,792 ,232,792 ,233,792 ,234,792 ,235,792 ,},[231]={24,792 ,25,792 ,26,792 ,27,792 ,232,792 ,233,792 ,234,792 ,235,792 ,},[232]={24,792 ,25,792 ,26,792 ,27,792 ,232,792 ,233,792 ,234,792 ,235,792 ,},[233]={24,792 ,25,792 ,26,792 ,27,792 ,232,792 ,233,792 ,234,792 ,235,792 ,},[240]={0,510 ,1,510 ,2,510 ,3,510 ,4,510 ,5,510 ,6,510 ,7,510 ,8,510 ,9,510 ,10,510 ,11,510 ,12,510 ,13,510 ,14,510 ,15,510 ,16,510 ,17,510 ,242,510 ,243,510 ,244,510 ,245,510 ,246,510 ,247,510 ,248,510 ,249,510 ,250,510 ,251,510 ,252,510 ,253,510 ,254,510 ,255,510 ,},[241]={0,510 ,1,510 ,2,510 ,3,510 ,4,510 ,5,510 ,6,510 ,7,510 ,8,510 ,9,510 ,10,510 ,11,510 ,12,510 ,13,510 ,14,510 ,15,510 ,16,510 ,17,510 ,242,510 ,243,510 ,244,510 ,245,510 ,246,510 ,247,510 ,248,510 ,249,510 ,250,510 ,251,510 ,252,510 ,253,510 ,254,510 ,255,510 ,},[242]={0,510 ,1,510 ,2,510 ,3,510 ,4,510 ,5,510 ,6,510 ,7,510 ,8,510 ,9,510 ,10,510 ,11,510 ,12,510 ,13,510 ,14,510 ,15,510 ,16,510 ,17,510 ,242,510 ,243,510 ,244,510 ,245,510 ,246,510 ,247,510 ,248,510 ,249,510 ,250,510 ,251,510 ,252,510 ,253,510 ,254,510 ,255,510 ,},[243]={0,510 ,1,510 ,2,510 ,3,510 ,4,510 ,5,510 ,6,510 ,7,510 ,8,510 ,9,510 ,10,510 ,11,510 ,12,510 ,13,510 ,14,510 ,15,510 ,16,510 ,17,510 ,242,510 ,243,510 ,244,510 ,245,510 ,246,510 ,247,510 ,248,510 ,249,510 ,250,510 ,251,510 ,252,510 ,253,510 ,254,510 ,255,510 ,},[244]={0,510 ,1,510 ,2,510 ,3,510 ,4,510 ,5,510 ,6,510 ,7,510 ,8,510 ,9,510 ,10,510 ,11,510 ,12,510 ,13,510 ,14,510 ,15,510 ,16,510 ,17,510 ,242,510 ,243,510 ,244,510 ,245,510 ,246,510 ,247,510 ,248,510 ,249,510 ,250,510 ,251,510 ,252,510 ,253,510 ,254,510 ,255,510 ,},[245]={0,510 ,1,510 ,2,510 ,3,510 ,4,510 ,5,510 ,6,510 ,7,510 ,8,510 ,9,510 ,10,510 ,11,510 ,12,510 ,13,510 ,14,510 ,15,510 ,16,510 ,17,510 ,242,510 ,243,510 ,244,510 ,245,510 ,246,510 ,247,510 ,248,510 ,249,510 ,250,510 ,251,510 ,252,510 ,253,510 ,254,510 ,255,510 ,},[246]={0,510 ,1,510 ,2,510 ,3,510 ,4,510 ,5,510 ,6,510 ,7,510 ,8,510 ,9,510 ,10,510 ,11,510 ,12,510 ,13,510 ,14,510 ,15,510 ,16,510 ,17,510 ,242,510 ,243,510 ,244,510 ,245,510 ,246,510 ,247,510 ,248,510 ,249,510 ,250,510 ,251,510 ,252,510 ,253,510 ,254,510 ,255,510 ,},[247]={0,510 ,1,510 ,2,510 ,3,510 ,4,510 ,5,510 ,6,510 ,7,510 ,8,510 ,9,510 ,10,510 ,11,510 ,12,510 ,13,510 ,14,510 ,15,510 ,16,510 ,17,510 ,242,510 ,243,510 ,244,510 ,245,510 ,246,510 ,247,510 ,248,510 ,249,510 ,250,510 ,251,510 ,252,510 ,253,510 ,254,510 ,255,510 ,},[248]={0,510 ,1,510 ,2,510 ,3,510 ,4,510 ,5,510 ,6,510 ,7,510 ,8,510 ,9,510 ,10,510 ,11,510 ,12,510 ,13,510 ,14,510 ,15,510 ,16,510 ,17,510 ,242,510 ,243,510 ,244,510 ,245,510 ,246,510 ,247,510 ,248,510 ,249,510 ,250,510 ,251,510 ,252,510 ,253,510 ,254,510 ,255,510 ,},[249]={0,510 ,1,510 ,2,510 ,3,510 ,4,510 ,5,510 ,6,510 ,7,510 ,8,510 ,9,510 ,10,510 ,11,510 ,12,510 ,13,510 ,14,510 ,15,510 ,16,510 ,17,510 ,242,510 ,243,510 ,244,510 ,245,510 ,246,510 ,247,510 ,248,510 ,249,510 ,250,510 ,251,510 ,252,510 ,253,510 ,254,510 ,255,510 ,},[250]={0,510 ,1,510 ,2,510 ,3,510 ,4,510 ,5,510 ,6,510 ,7,510 ,8,510 ,9,510 ,10,510 ,11,510 ,12,510 ,13,510 ,14,510 ,15,510 ,16,510 ,17,510 ,242,510 ,243,510 ,244,510 ,245,510 ,246,510 ,247,510 ,248,510 ,249,510 ,250,510 ,251,510 ,252,510 ,253,510 ,254,510 ,255,510 ,},[251]={0,510 ,1,510 ,2,510 ,3,510 ,4,510 ,5,510 ,6,510 ,7,510 ,8,510 ,9,510 ,10,510 ,11,510 ,12,510 ,13,510 ,14,510 ,15,510 ,16,510 ,17,510 ,242,510 ,243,510 ,244,510 ,245,510 ,246,510 ,247,510 ,248,510 ,249,510 ,250,510 ,251,510 ,252,510 ,253,510 ,254,510 ,255,510 ,},[252]={0,510 ,1,510 ,2,510 ,3,510 ,4,510 ,5,510 ,6,510 ,7,510 ,8,510 ,9,510 ,10,510 ,11,510 ,12,510 ,13,510 ,14,510 ,15,510 ,16,510 ,17,510 ,242,510 ,243,510 ,244,510 ,245,510 ,246,510 ,247,510 ,248,510 ,249,510 ,250,510 ,251,510 ,252,510 ,253,510 ,254,510 ,255,510 ,},[253]={0,510 ,1,510 ,2,510 ,3,510 ,4,510 ,5,510 ,6,510 ,7,510 ,8,510 ,9,510 ,10,510 ,11,510 ,12,510 ,13,510 ,14,510 ,15,510 ,16,510 ,17,510 ,242,510 ,243,510 ,244,510 ,245,510 ,246,510 ,247,510 ,248,510 ,249,510 ,250,510 ,251,510 ,252,510 ,253,510 ,254,510 ,255,510 ,},[254]={0,510 ,1,510 ,2,510 ,3,510 ,4,510 ,5,510 ,6,510 ,7,510 ,8,510 ,9,510 ,10,510 ,11,510 ,12,510 ,13,510 ,14,510 ,15,510 ,16,510 ,17,510 ,242,510 ,243,510 ,244,510 ,245,510 ,246,510 ,247,510 ,248,510 ,249,510 ,250,510 ,251,510 ,252,510 ,253,510 ,254,510 ,255,510 ,},[255]={0,510 ,1,510 ,2,510 ,3,510 ,4,510 ,5,510 ,6,510 ,7,510 ,8,510 ,9,510 ,10,510 ,11,510 ,12,510 ,13,510 ,14,510 ,15,510 ,16,510 ,17,510 ,242,510 ,243,510 ,244,510 ,245,510 ,246,510 ,247,510 ,248,510 ,249,510 ,250,510 ,251,510 ,252,510 ,253,510 ,254,510 ,255,510 ,}
		},
		
		markers ={
			122,144, 254,0, 0,2, 0,0
		},
		
		decorations = {
			230,24,6,3, 22,24,6,5, 22,232,6,7, 230,232,6,1
		},
		
		shaman_positions = {
			248, 6, 4, 6, 248, 250, 4, 250, 252, 2, 0, 2, 252, 254, 0, 254
		},
		
		scripts = {
			OnTurn = function(everySecond1, everySecond2, everySecond4) 			tectonic_on_turn(everySecond1, everySecond2, everySecond4) end,
			OnCreateThing = function(t, owner, type, model) 						tectonic_on_create_thing(t, owner, type, model) end,
			OnHumanDisconnect = function(player) 									TK_init_single_AI(player) end,
		},
		
	},
	
	[MAP_QUIZ_EASY]={
		info = { 	name = "Quiz (easy)", author = "Divinity & AI",
					desc = "Grab a beer, and get ready to test your general knowledge with this Quiz. <p> All 2000 questions, split among 21 categories, are AI generated, and range from easy to hard. The only difference between Quiz Easy and Quiz hard, is the number of answers being 4 or 6, as well as 5 more seconds to answer on hard. <br> Each correct answer grant 1 point. Just be sure to answer before you run out of time!",
					map_objectives = { {}, {value=20, step=5, default=false}, {value=15, step=5, default=true} },
					image = 2573, texture={1,1}, zoom={0,0,0}, drop_infos = true, marker_lb={122,142}, reinc_timer=99, shield_respawn=false,
					custom_rules = {
						{ default = false, 	name = "5+ seconds to answer", desc = "Players have 5+ seconds to read and answer the questions (10 -> 15)." },
						{ default = false, 	name = "Teamwork", desc = "Teams can see eachother's selected answer, before it locks in." },
					}
				},
		land ={},
		objects ={},
		markers ={},
		decorations = {},
		shaman_positions = {},
		
		scripts = {
			OnTurn = function(everySecond1, everySecond2, everySecond4) 			quiz_on_turn(everySecond1) end,
			OnFrame = function(ghover) 												return quiz_on_frame(ghover) end,
			OnHumanDisconnect = function(player) 									init_single_AI_quiz(player) end,
			OnMouseUp = function(left)												quiz_on_mouse_up(left) end,
			OnMouseUpMultiplayer = function(from, str)								quiz_on_mouse_up_multiplayer(from, str) end,
		},
	},
	
	[MAP_QUIZ_HARD]={
		info = { 	name = "Quiz (hard)", author = "Divinity & AI",
					desc = "Grab a beer, and get ready to test your general knowledge with this Quiz. <p> All 2000 questions, split among 21 categories, are AI generated, and range from easy to hard. The only difference between Quiz Easy and Quiz hard, is the number of answers being 4 or 6, as well as 5 more seconds to answer on hard. <br> Each correct answer grant 1 point. Just be sure to answer before you run out of time!",
					map_objectives = { {}, {value=20, step=5, default=false}, {value=15, step=5, default=true} },
					image = 2573, texture={1,1}, zoom={0,0,0}, drop_infos = true, marker_lb={122,142}, reinc_timer=99, shield_respawn=false,
					custom_rules = {
						{ default = false, 	name = "5+ seconds to answer", desc = "Players have 5+ seconds to read and answer the questions (15 -> 20)." },
						{ default = false, 	name = "Teamwork", desc = "Teams can see eachother's selected answer, before it locks in." },
					}
				},
		land ={},
		objects ={},
		markers ={},
		decorations = {},
		shaman_positions = {},
		
		scripts = {
			OnTurn = function(everySecond1, everySecond2, everySecond4) 			quiz_on_turn(everySecond1) end,
			OnFrame = function(ghover) 												return quiz_on_frame(ghover) end,
			OnHumanDisconnect = function(player) 									init_single_AI_quiz(player) end,
			OnMouseUp = function(left)												quiz_on_mouse_up(left) end,
			OnMouseUpMultiplayer = function(from, str)								quiz_on_mouse_up_multiplayer(from, str) end,
		},
	},
	
	[MAP_POTION_BATTLE]={
	
		info = { 	name = "Potion Battle", author = "Divinity",
					desc = "Players fight the enemies with an arsenal of unlocked spells, charging which one they think best for the moment. <p> For every kill, players earn 3 points. For every death, they lose 1 point. <br> Battle potions often appear in the arena. Shamans can pick them up, store them, and use them whenever they feel like. You can store 6 different potions, and a maximum of 3 of each kind. <br> Most potions will grant you powers for 40 seconds, and then fade, but you can swap potions any time. <p> Some potions are instant, and/or have an effect only once. Players don't lose their potions upon death, nor the active effect of current potions end. <br> There are 15 different potions, use mouse left click to use, right click to discard, mouse hover to read their effects.",
					map_objectives = { {value=6, step=1, default=true}, {value=50, step=5, default=false}, {} },
					image = 3104, texture={5,3}, zoom={130,124,0}, drop_infos = true, marker_lb={0,0}, reinc_timer=12*3, shield_respawn=true,
					custom_rules = {
						{ default = false, 	name = "Increased Mana Regen", desc = "Mana Regenerates 50% faster." },
						{ default = false, 	name = "Brief Potions", desc = "Potion duration reduced by half, from 40 seconds to 20 seconds." },
					}
				},
	
		land ={
			[88]={92,150 ,93,150 ,94,150 ,95,150 ,96,150 ,97,150 ,98,150 ,99,150 ,100,150 ,101,150 ,102,150 ,103,150 ,104,150 ,105,150 ,106,150 ,107,150 ,108,150 ,109,150 ,110,150 ,111,150 ,112,150 ,113,150 ,114,150 ,115,150 ,116,150 ,117,150 ,118,150 ,119,150 ,120,150 ,121,150 ,122,150 ,123,150 ,124,150 ,125,150 ,126,150 ,127,150 ,128,150 ,129,150 ,130,150 ,131,150 ,132,150 ,133,150 ,134,150 ,135,150 ,136,150 ,137,150 ,138,150 ,139,150 ,140,150 ,141,150 ,142,150 ,143,150 ,144,150 ,145,150 ,146,150 ,147,150 ,148,150 ,149,150 ,150,150 ,151,150 ,152,150 ,153,150 ,154,150 ,155,150 ,156,150 ,157,150 ,158,150 ,159,150 ,160,150 ,161,150 ,162,150 ,163,150 ,164,150 ,165,150 ,166,150 ,167,150 ,168,150 ,169,150 ,170,150 ,171,150 ,172,150 ,173,150 ,174,150 ,175,150 ,176,150 ,177,150 ,178,150 ,179,150 ,},[89]={92,150 ,93,150 ,94,150 ,95,150 ,96,150 ,97,150 ,98,150 ,99,150 ,100,150 ,101,150 ,102,150 ,103,150 ,104,150 ,105,150 ,106,150 ,107,150 ,108,150 ,109,150 ,110,150 ,111,150 ,112,150 ,113,150 ,114,150 ,115,150 ,116,150 ,117,150 ,118,150 ,119,150 ,120,150 ,121,150 ,122,150 ,123,150 ,124,150 ,125,150 ,126,150 ,127,150 ,128,150 ,129,150 ,130,150 ,131,150 ,132,150 ,133,150 ,134,150 ,135,150 ,136,150 ,137,150 ,138,150 ,139,150 ,140,150 ,141,150 ,142,150 ,143,150 ,144,150 ,145,150 ,146,150 ,147,150 ,148,150 ,149,150 ,150,150 ,151,150 ,152,150 ,153,150 ,154,150 ,155,150 ,156,150 ,157,150 ,158,150 ,159,150 ,160,150 ,161,150 ,162,150 ,163,150 ,164,150 ,165,150 ,166,150 ,167,150 ,168,150 ,169,150 ,170,150 ,171,150 ,172,150 ,173,150 ,174,150 ,175,150 ,176,150 ,177,150 ,178,150 ,179,150 ,},[90]={92,150 ,93,150 ,94,150 ,95,150 ,96,150 ,97,150 ,98,150 ,99,150 ,100,150 ,101,150 ,102,150 ,103,150 ,104,150 ,105,150 ,106,150 ,107,150 ,108,150 ,109,150 ,110,150 ,111,150 ,112,304 ,113,304 ,114,304 ,115,304 ,116,150 ,117,150 ,118,150 ,119,150 ,120,150 ,121,150 ,122,150 ,123,150 ,124,150 ,125,150 ,126,150 ,127,150 ,128,150 ,129,150 ,130,150 ,131,150 ,132,150 ,133,150 ,134,150 ,135,150 ,136,150 ,137,150 ,138,150 ,139,150 ,140,150 ,141,150 ,142,150 ,143,150 ,144,150 ,145,150 ,146,150 ,147,150 ,148,150 ,149,150 ,150,150 ,151,150 ,152,150 ,153,150 ,154,150 ,155,150 ,156,304 ,157,304 ,158,304 ,159,304 ,160,150 ,161,150 ,162,150 ,163,150 ,164,150 ,165,150 ,166,150 ,167,150 ,168,150 ,169,150 ,170,150 ,171,150 ,172,150 ,173,150 ,174,150 ,175,150 ,176,150 ,177,150 ,178,150 ,179,150 ,},[91]={92,150 ,93,150 ,94,150 ,95,150 ,96,150 ,97,150 ,98,150 ,99,150 ,100,150 ,101,150 ,102,150 ,103,150 ,104,150 ,105,150 ,106,150 ,107,150 ,108,150 ,109,150 ,110,150 ,111,150 ,112,304 ,113,304 ,114,304 ,115,304 ,116,150 ,117,150 ,118,150 ,119,150 ,120,150 ,121,150 ,122,150 ,123,150 ,124,150 ,125,150 ,126,150 ,127,150 ,128,150 ,129,150 ,130,150 ,131,150 ,132,150 ,133,150 ,134,150 ,135,150 ,136,150 ,137,150 ,138,150 ,139,150 ,140,150 ,141,150 ,142,150 ,143,150 ,144,150 ,145,150 ,146,150 ,147,150 ,148,150 ,149,150 ,150,150 ,151,150 ,152,150 ,153,150 ,154,150 ,155,150 ,156,304 ,157,304 ,158,304 ,159,304 ,160,150 ,161,150 ,162,150 ,163,150 ,164,150 ,165,150 ,166,150 ,167,150 ,168,150 ,169,150 ,170,150 ,171,150 ,172,150 ,173,150 ,174,150 ,175,150 ,176,150 ,177,150 ,178,150 ,179,150 ,},[92]={92,150 ,93,150 ,94,150 ,95,150 ,96,150 ,97,150 ,98,150 ,99,150 ,100,150 ,101,150 ,102,150 ,103,150 ,104,150 ,105,150 ,106,150 ,107,150 ,108,150 ,109,150 ,110,150 ,111,150 ,112,304 ,113,304 ,114,304 ,115,304 ,116,150 ,117,150 ,118,150 ,119,150 ,120,150 ,121,150 ,122,150 ,123,150 ,124,150 ,125,150 ,126,150 ,127,150 ,128,150 ,129,150 ,130,150 ,131,150 ,132,150 ,133,150 ,134,150 ,135,150 ,136,150 ,137,150 ,138,150 ,139,150 ,140,150 ,141,150 ,142,150 ,143,150 ,144,150 ,145,150 ,146,150 ,147,150 ,148,150 ,149,150 ,150,150 ,151,150 ,152,150 ,153,150 ,154,150 ,155,150 ,156,304 ,157,304 ,158,304 ,159,304 ,160,150 ,161,150 ,162,150 ,163,150 ,164,150 ,165,150 ,166,150 ,167,150 ,168,150 ,169,150 ,170,150 ,171,150 ,172,150 ,173,150 ,174,150 ,175,150 ,176,150 ,177,150 ,178,150 ,179,150 ,},[93]={92,150 ,93,150 ,94,150 ,95,150 ,96,150 ,97,150 ,98,150 ,99,150 ,100,150 ,101,150 ,102,150 ,103,150 ,104,150 ,105,150 ,106,150 ,107,150 ,108,150 ,109,150 ,110,150 ,111,150 ,112,304 ,113,304 ,114,304 ,115,304 ,116,150 ,117,150 ,118,150 ,119,150 ,120,150 ,121,150 ,122,150 ,123,150 ,124,150 ,125,150 ,126,150 ,127,150 ,128,150 ,129,150 ,130,150 ,131,150 ,132,150 ,133,150 ,134,150 ,135,150 ,136,150 ,137,150 ,138,150 ,139,150 ,140,150 ,141,150 ,142,150 ,143,150 ,144,150 ,145,150 ,146,150 ,147,150 ,148,150 ,149,150 ,150,150 ,151,150 ,152,150 ,153,150 ,154,150 ,155,150 ,156,304 ,157,304 ,158,304 ,159,304 ,160,150 ,161,150 ,162,150 ,163,150 ,164,150 ,165,150 ,166,150 ,167,150 ,168,150 ,169,150 ,170,150 ,171,150 ,172,150 ,173,150 ,174,150 ,175,150 ,176,150 ,177,150 ,178,150 ,179,150 ,},[94]={92,150 ,93,150 ,94,150 ,95,150 ,96,150 ,97,150 ,98,150 ,99,150 ,100,150 ,101,150 ,102,150 ,103,150 ,104,150 ,105,150 ,106,150 ,107,150 ,108,150 ,109,150 ,110,150 ,111,150 ,112,150 ,113,150 ,114,150 ,115,150 ,116,150 ,117,150 ,118,150 ,119,150 ,120,150 ,121,150 ,122,150 ,123,150 ,124,150 ,125,150 ,126,150 ,127,150 ,128,150 ,129,150 ,130,150 ,131,150 ,132,150 ,133,150 ,134,150 ,135,150 ,136,150 ,137,150 ,138,150 ,139,150 ,140,150 ,141,150 ,142,150 ,143,150 ,144,150 ,145,150 ,146,150 ,147,150 ,148,150 ,149,150 ,150,150 ,151,150 ,152,150 ,153,150 ,154,150 ,155,150 ,156,150 ,157,150 ,158,150 ,159,150 ,160,150 ,161,150 ,162,150 ,163,150 ,164,150 ,165,150 ,166,150 ,167,150 ,168,150 ,169,150 ,170,150 ,171,150 ,172,150 ,173,150 ,174,150 ,175,150 ,176,150 ,177,150 ,178,150 ,179,150 ,},[95]={92,150 ,93,150 ,94,150 ,95,150 ,96,150 ,97,150 ,98,150 ,99,150 ,100,150 ,101,150 ,102,150 ,103,150 ,104,150 ,105,150 ,106,150 ,107,150 ,108,150 ,109,150 ,110,150 ,111,150 ,112,150 ,113,150 ,114,150 ,115,150 ,116,150 ,117,150 ,118,150 ,119,150 ,120,150 ,121,150 ,122,150 ,123,150 ,124,150 ,125,150 ,126,150 ,127,150 ,128,150 ,129,150 ,130,150 ,131,150 ,132,150 ,133,150 ,134,150 ,135,150 ,136,150 ,137,150 ,138,150 ,139,150 ,140,150 ,141,150 ,142,150 ,143,150 ,144,150 ,145,150 ,146,150 ,147,150 ,148,150 ,149,150 ,150,150 ,151,150 ,152,150 ,153,150 ,154,150 ,155,150 ,156,150 ,157,150 ,158,150 ,159,150 ,160,150 ,161,150 ,162,150 ,163,150 ,164,150 ,165,150 ,166,150 ,167,150 ,168,150 ,169,150 ,170,150 ,171,150 ,172,150 ,173,150 ,174,150 ,175,150 ,176,150 ,177,150 ,178,150 ,179,150 ,},[96]={92,150 ,93,150 ,94,150 ,95,150 ,96,150 ,97,150 ,98,150 ,99,150 ,100,150 ,101,150 ,102,150 ,103,150 ,104,150 ,105,150 ,106,150 ,107,150 ,108,150 ,109,150 ,110,150 ,111,150 ,112,150 ,113,150 ,114,150 ,115,150 ,116,150 ,117,150 ,118,150 ,119,150 ,120,150 ,121,150 ,122,150 ,123,150 ,124,150 ,125,150 ,126,150 ,127,150 ,128,150 ,129,150 ,130,150 ,131,150 ,132,150 ,133,150 ,134,150 ,135,150 ,136,150 ,137,150 ,138,150 ,139,150 ,140,150 ,141,150 ,142,150 ,143,150 ,144,150 ,145,150 ,146,150 ,147,150 ,148,150 ,149,150 ,150,150 ,151,150 ,152,150 ,153,150 ,154,150 ,155,150 ,156,150 ,157,150 ,158,150 ,159,150 ,160,150 ,161,150 ,162,150 ,163,150 ,164,150 ,165,150 ,166,150 ,167,150 ,168,150 ,169,150 ,170,150 ,171,150 ,172,150 ,173,150 ,174,150 ,175,150 ,176,150 ,177,150 ,178,150 ,179,150 ,},[97]={92,150 ,93,150 ,94,150 ,95,150 ,96,150 ,97,150 ,98,150 ,99,150 ,100,150 ,101,150 ,102,150 ,103,150 ,104,150 ,105,150 ,106,150 ,107,150 ,108,150 ,109,150 ,110,150 ,111,150 ,112,150 ,113,150 ,114,150 ,115,150 ,116,150 ,117,150 ,118,150 ,119,150 ,120,150 ,121,150 ,122,150 ,123,150 ,124,150 ,125,150 ,126,150 ,127,150 ,128,150 ,129,150 ,130,150 ,131,150 ,132,150 ,133,150 ,134,150 ,135,150 ,136,150 ,137,150 ,138,150 ,139,150 ,140,150 ,141,150 ,142,150 ,143,150 ,144,150 ,145,150 ,146,150 ,147,150 ,148,150 ,149,150 ,150,150 ,151,150 ,152,150 ,153,150 ,154,150 ,155,150 ,156,150 ,157,150 ,158,150 ,159,150 ,160,150 ,161,150 ,162,150 ,163,150 ,164,150 ,165,150 ,166,150 ,167,150 ,168,150 ,169,150 ,170,150 ,171,150 ,172,150 ,173,150 ,174,150 ,175,150 ,176,150 ,177,150 ,178,150 ,179,150 ,},[98]={92,150 ,93,150 ,94,150 ,95,150 ,96,150 ,97,150 ,98,150 ,99,150 ,100,150 ,101,150 ,102,150 ,103,150 ,104,150 ,105,150 ,106,150 ,107,150 ,108,150 ,109,150 ,110,150 ,111,150 ,112,150 ,113,150 ,114,150 ,115,150 ,116,150 ,117,150 ,118,150 ,119,150 ,120,150 ,121,150 ,122,150 ,123,150 ,124,150 ,125,150 ,126,150 ,127,150 ,128,150 ,129,150 ,130,150 ,131,150 ,132,150 ,133,150 ,134,150 ,135,150 ,136,150 ,137,150 ,138,150 ,139,150 ,140,150 ,141,150 ,142,150 ,143,150 ,144,150 ,145,150 ,146,150 ,147,150 ,148,150 ,149,150 ,150,150 ,151,150 ,152,150 ,153,150 ,154,150 ,155,150 ,156,150 ,157,150 ,158,150 ,159,150 ,160,150 ,161,150 ,162,150 ,163,150 ,164,150 ,165,150 ,166,150 ,167,150 ,168,150 ,169,150 ,170,150 ,171,150 ,172,150 ,173,150 ,174,150 ,175,150 ,176,150 ,177,150 ,178,150 ,179,150 ,},[99]={92,150 ,93,150 ,94,150 ,95,150 ,96,150 ,97,150 ,98,150 ,99,150 ,100,150 ,101,150 ,102,150 ,103,150 ,104,150 ,105,150 ,106,150 ,107,150 ,108,150 ,109,150 ,110,150 ,111,150 ,112,150 ,113,150 ,114,150 ,115,150 ,116,150 ,117,150 ,118,150 ,119,150 ,120,150 ,121,150 ,122,150 ,123,150 ,124,150 ,125,150 ,126,150 ,127,150 ,128,150 ,129,150 ,130,150 ,131,150 ,132,150 ,133,150 ,134,150 ,135,150 ,136,150 ,137,150 ,138,150 ,139,150 ,140,150 ,141,150 ,142,150 ,143,150 ,144,150 ,145,150 ,146,150 ,147,150 ,148,150 ,149,150 ,150,150 ,151,150 ,152,150 ,153,150 ,154,150 ,155,150 ,156,150 ,157,150 ,158,150 ,159,150 ,160,150 ,161,150 ,162,150 ,163,150 ,164,150 ,165,150 ,166,150 ,167,150 ,168,150 ,169,150 ,170,150 ,171,150 ,172,150 ,173,150 ,174,150 ,175,150 ,176,150 ,177,150 ,178,150 ,179,150 ,},[100]={92,150 ,93,150 ,94,150 ,95,150 ,96,150 ,97,150 ,98,150 ,99,150 ,100,150 ,101,150 ,102,150 ,103,150 ,104,150 ,105,150 ,106,150 ,107,150 ,108,150 ,109,150 ,110,150 ,111,150 ,112,150 ,113,150 ,114,150 ,115,150 ,116,150 ,117,150 ,118,150 ,119,150 ,120,150 ,121,150 ,122,150 ,123,150 ,124,150 ,125,150 ,126,150 ,127,150 ,128,150 ,129,150 ,130,150 ,131,150 ,132,150 ,133,150 ,134,150 ,135,150 ,136,150 ,137,150 ,138,150 ,139,150 ,140,150 ,141,150 ,142,150 ,143,150 ,144,150 ,145,150 ,146,150 ,147,150 ,148,150 ,149,150 ,150,150 ,151,150 ,152,150 ,153,150 ,154,150 ,155,150 ,156,150 ,157,150 ,158,150 ,159,150 ,160,150 ,161,150 ,162,150 ,163,150 ,164,150 ,165,150 ,166,150 ,167,150 ,168,150 ,169,150 ,170,150 ,171,150 ,172,150 ,173,150 ,174,150 ,175,150 ,176,150 ,177,150 ,178,150 ,179,150 ,},[101]={92,150 ,93,150 ,94,150 ,95,150 ,96,150 ,97,150 ,98,150 ,99,150 ,100,150 ,101,150 ,102,150 ,103,150 ,104,150 ,105,150 ,106,150 ,107,150 ,108,150 ,109,150 ,110,150 ,111,150 ,112,150 ,113,150 ,114,150 ,115,150 ,116,150 ,117,150 ,118,150 ,119,150 ,120,150 ,121,150 ,122,150 ,123,150 ,124,150 ,125,150 ,126,150 ,127,150 ,128,150 ,129,150 ,130,150 ,131,150 ,132,150 ,133,150 ,134,150 ,135,150 ,136,150 ,137,150 ,138,150 ,139,150 ,140,150 ,141,150 ,142,150 ,143,150 ,144,150 ,145,150 ,146,150 ,147,150 ,148,150 ,149,150 ,150,150 ,151,150 ,152,150 ,153,150 ,154,150 ,155,150 ,156,150 ,157,150 ,158,150 ,159,150 ,160,150 ,161,150 ,162,150 ,163,150 ,164,150 ,165,150 ,166,150 ,167,150 ,168,150 ,169,150 ,170,150 ,171,150 ,172,150 ,173,150 ,174,150 ,175,150 ,176,150 ,177,150 ,178,150 ,179,150 ,},[102]={92,150 ,93,150 ,94,150 ,95,150 ,96,150 ,97,150 ,98,150 ,99,150 ,100,150 ,101,150 ,102,150 ,103,150 ,104,150 ,105,150 ,106,150 ,107,150 ,108,150 ,109,150 ,110,150 ,111,150 ,112,150 ,113,150 ,114,150 ,115,150 ,116,150 ,117,150 ,118,150 ,119,150 ,120,150 ,121,150 ,122,150 ,123,150 ,124,150 ,125,150 ,126,150 ,127,150 ,128,150 ,129,150 ,130,150 ,131,150 ,132,150 ,133,150 ,134,150 ,135,150 ,136,150 ,137,150 ,138,150 ,139,150 ,140,150 ,141,150 ,142,150 ,143,150 ,144,150 ,145,150 ,146,150 ,147,150 ,148,150 ,149,150 ,150,150 ,151,150 ,152,150 ,153,150 ,154,150 ,155,150 ,156,150 ,157,150 ,158,150 ,159,150 ,160,150 ,161,150 ,162,150 ,163,150 ,164,150 ,165,150 ,166,150 ,167,150 ,168,150 ,169,150 ,170,150 ,171,150 ,172,150 ,173,150 ,174,150 ,175,150 ,176,150 ,177,150 ,178,150 ,179,150 ,},[103]={92,150 ,93,150 ,94,150 ,95,150 ,96,150 ,97,150 ,98,150 ,99,150 ,100,150 ,101,150 ,102,150 ,103,150 ,104,150 ,105,150 ,106,150 ,107,150 ,108,150 ,109,150 ,110,150 ,111,150 ,112,150 ,113,150 ,114,150 ,115,150 ,116,150 ,117,150 ,118,150 ,119,150 ,120,150 ,121,150 ,122,150 ,123,150 ,124,150 ,125,150 ,126,150 ,127,150 ,128,150 ,129,150 ,130,150 ,131,150 ,132,150 ,133,150 ,134,150 ,135,150 ,136,150 ,137,150 ,138,150 ,139,150 ,140,150 ,141,150 ,142,150 ,143,150 ,144,150 ,145,150 ,146,150 ,147,150 ,148,150 ,149,150 ,150,150 ,151,150 ,152,150 ,153,150 ,154,150 ,155,150 ,156,150 ,157,150 ,158,150 ,159,150 ,160,150 ,161,150 ,162,150 ,163,150 ,164,150 ,165,150 ,166,150 ,167,150 ,168,150 ,169,150 ,170,150 ,171,150 ,172,150 ,173,150 ,174,150 ,175,150 ,176,150 ,177,150 ,178,150 ,179,150 ,},[104]={92,150 ,93,150 ,94,150 ,95,150 ,96,150 ,97,150 ,98,150 ,99,150 ,100,150 ,101,150 ,102,150 ,103,150 ,104,150 ,105,150 ,106,150 ,107,150 ,108,150 ,109,150 ,110,150 ,111,150 ,112,150 ,113,150 ,114,150 ,115,150 ,116,150 ,117,150 ,118,150 ,119,150 ,120,150 ,121,150 ,122,150 ,123,150 ,124,150 ,125,150 ,126,150 ,127,150 ,128,150 ,129,150 ,130,150 ,131,150 ,132,150 ,133,150 ,134,150 ,135,150 ,136,150 ,137,150 ,138,150 ,139,150 ,140,150 ,141,150 ,142,150 ,143,150 ,144,150 ,145,150 ,146,150 ,147,150 ,148,150 ,149,150 ,150,150 ,151,150 ,152,150 ,153,150 ,154,150 ,155,150 ,156,150 ,157,150 ,158,150 ,159,150 ,160,150 ,161,150 ,162,150 ,163,150 ,164,150 ,165,150 ,166,150 ,167,150 ,168,150 ,169,150 ,170,150 ,171,150 ,172,150 ,173,150 ,174,150 ,175,150 ,176,150 ,177,150 ,178,150 ,179,150 ,},[105]={92,150 ,93,150 ,94,150 ,95,150 ,96,150 ,97,150 ,98,150 ,99,150 ,100,150 ,101,150 ,102,150 ,103,150 ,104,150 ,105,150 ,106,150 ,107,150 ,108,150 ,109,150 ,110,150 ,111,150 ,112,150 ,113,150 ,114,150 ,115,150 ,116,150 ,117,150 ,118,150 ,119,150 ,120,150 ,121,150 ,122,150 ,123,150 ,124,150 ,125,150 ,126,150 ,127,150 ,128,150 ,129,150 ,130,150 ,131,150 ,132,150 ,133,150 ,134,150 ,135,150 ,136,150 ,137,150 ,138,150 ,139,150 ,140,150 ,141,150 ,142,150 ,143,150 ,144,150 ,145,150 ,146,150 ,147,150 ,148,150 ,149,150 ,150,150 ,151,150 ,152,150 ,153,150 ,154,150 ,155,150 ,156,150 ,157,150 ,158,150 ,159,150 ,160,150 ,161,150 ,162,150 ,163,150 ,164,150 ,165,150 ,166,150 ,167,150 ,168,150 ,169,150 ,170,150 ,171,150 ,172,150 ,173,150 ,174,150 ,175,150 ,176,150 ,177,150 ,178,150 ,179,150 ,},[106]={92,150 ,93,150 ,94,150 ,95,150 ,96,150 ,97,150 ,98,150 ,99,150 ,100,150 ,101,150 ,102,150 ,103,150 ,104,150 ,105,150 ,106,150 ,107,150 ,108,150 ,109,150 ,118,150 ,119,150 ,120,150 ,121,150 ,122,150 ,123,150 ,124,150 ,125,150 ,126,150 ,127,150 ,128,150 ,129,150 ,130,150 ,131,150 ,132,150 ,133,150 ,134,150 ,135,150 ,136,150 ,137,150 ,138,150 ,139,150 ,140,150 ,141,150 ,142,150 ,143,150 ,144,150 ,145,150 ,146,150 ,147,150 ,148,150 ,149,150 ,150,150 ,151,150 ,152,150 ,153,150 ,162,150 ,163,150 ,164,150 ,165,150 ,166,150 ,167,150 ,168,150 ,169,150 ,170,150 ,171,150 ,172,150 ,173,150 ,174,150 ,175,150 ,176,150 ,177,150 ,178,150 ,179,150 ,},[107]={92,150 ,93,150 ,94,150 ,95,150 ,96,150 ,97,150 ,98,150 ,99,150 ,100,150 ,101,150 ,102,150 ,103,150 ,104,150 ,105,150 ,106,150 ,107,150 ,108,150 ,109,150 ,118,150 ,119,150 ,120,150 ,121,150 ,122,150 ,123,150 ,124,150 ,125,150 ,126,150 ,127,150 ,128,150 ,129,150 ,130,150 ,131,150 ,132,150 ,133,150 ,134,150 ,135,150 ,136,150 ,137,150 ,138,150 ,139,150 ,140,150 ,141,150 ,142,150 ,143,150 ,144,150 ,145,150 ,146,150 ,147,150 ,148,150 ,149,150 ,150,150 ,151,150 ,152,150 ,153,150 ,162,150 ,163,150 ,164,150 ,165,150 ,166,150 ,167,150 ,168,150 ,169,150 ,170,150 ,171,150 ,172,150 ,173,150 ,174,150 ,175,150 ,176,150 ,177,150 ,178,150 ,179,150 ,},[108]={92,150 ,93,150 ,94,304 ,95,304 ,96,304 ,97,304 ,98,150 ,99,150 ,100,150 ,101,150 ,102,150 ,103,150 ,104,150 ,105,150 ,106,150 ,107,150 ,108,150 ,109,150 ,118,150 ,119,150 ,120,150 ,121,150 ,122,150 ,123,150 ,124,150 ,125,150 ,126,150 ,127,150 ,128,150 ,129,150 ,130,150 ,131,150 ,132,150 ,133,150 ,134,150 ,135,150 ,136,150 ,137,150 ,138,150 ,139,150 ,140,150 ,141,150 ,142,150 ,143,150 ,144,150 ,145,150 ,146,150 ,147,150 ,148,150 ,149,150 ,150,150 ,151,150 ,152,150 ,153,150 ,162,150 ,163,150 ,164,150 ,165,150 ,166,150 ,167,150 ,168,150 ,169,150 ,170,150 ,171,150 ,172,150 ,173,150 ,174,304 ,175,304 ,176,304 ,177,304 ,178,150 ,179,150 ,},[109]={92,150 ,93,150 ,94,304 ,95,304 ,96,304 ,97,304 ,98,150 ,99,150 ,100,150 ,101,150 ,102,150 ,103,150 ,104,150 ,105,150 ,106,150 ,107,150 ,108,150 ,109,150 ,118,150 ,119,150 ,120,150 ,121,150 ,122,150 ,123,150 ,124,150 ,125,150 ,126,150 ,127,150 ,128,150 ,129,150 ,130,150 ,131,150 ,132,150 ,133,150 ,134,150 ,135,150 ,136,150 ,137,150 ,138,150 ,139,150 ,140,150 ,141,150 ,142,150 ,143,150 ,144,150 ,145,150 ,146,150 ,147,150 ,148,150 ,149,150 ,150,150 ,151,150 ,152,150 ,153,150 ,162,150 ,163,150 ,164,150 ,165,150 ,166,150 ,167,150 ,168,150 ,169,150 ,170,150 ,171,150 ,172,150 ,173,150 ,174,304 ,175,304 ,176,304 ,177,304 ,178,150 ,179,150 ,},[110]={92,150 ,93,150 ,94,304 ,95,304 ,96,304 ,97,304 ,98,150 ,99,150 ,100,150 ,101,150 ,102,150 ,103,150 ,104,150 ,105,150 ,106,150 ,107,150 ,108,150 ,109,150 ,118,150 ,119,150 ,120,150 ,121,150 ,122,150 ,123,150 ,124,150 ,125,150 ,126,150 ,127,150 ,128,150 ,129,150 ,130,150 ,131,150 ,132,150 ,133,150 ,134,150 ,135,150 ,136,150 ,137,150 ,138,150 ,139,150 ,140,150 ,141,150 ,142,150 ,143,150 ,144,150 ,145,150 ,146,150 ,147,150 ,148,150 ,149,150 ,150,150 ,151,150 ,152,150 ,153,150 ,162,150 ,163,150 ,164,150 ,165,150 ,166,150 ,167,150 ,168,150 ,169,150 ,170,150 ,171,150 ,172,150 ,173,150 ,174,304 ,175,304 ,176,304 ,177,304 ,178,150 ,179,150 ,},[111]={92,150 ,93,150 ,94,304 ,95,304 ,96,304 ,97,304 ,98,150 ,99,150 ,100,150 ,101,150 ,102,150 ,103,150 ,104,150 ,105,150 ,106,150 ,107,150 ,108,150 ,109,150 ,118,150 ,119,150 ,120,150 ,121,150 ,122,150 ,123,150 ,124,150 ,125,150 ,126,150 ,127,150 ,128,150 ,129,150 ,130,150 ,131,150 ,132,150 ,133,150 ,134,150 ,135,150 ,136,150 ,137,150 ,138,150 ,139,150 ,140,150 ,141,150 ,142,150 ,143,150 ,144,150 ,145,150 ,146,150 ,147,150 ,148,150 ,149,150 ,150,150 ,151,150 ,152,150 ,153,150 ,162,150 ,163,150 ,164,150 ,165,150 ,166,150 ,167,150 ,168,150 ,169,150 ,170,150 ,171,150 ,172,150 ,173,150 ,174,304 ,175,304 ,176,304 ,177,304 ,178,150 ,179,150 ,},[112]={92,150 ,93,150 ,94,150 ,95,150 ,96,150 ,97,150 ,98,150 ,99,150 ,100,150 ,101,150 ,102,150 ,103,150 ,104,150 ,105,150 ,106,150 ,107,150 ,108,150 ,109,150 ,118,150 ,119,150 ,120,150 ,121,150 ,122,150 ,123,150 ,124,150 ,125,150 ,126,150 ,127,150 ,128,150 ,129,150 ,130,150 ,131,150 ,132,150 ,133,150 ,134,150 ,135,150 ,136,150 ,137,150 ,138,150 ,139,150 ,140,150 ,141,150 ,142,150 ,143,150 ,144,150 ,145,150 ,146,150 ,147,150 ,148,150 ,149,150 ,150,150 ,151,150 ,152,150 ,153,150 ,162,150 ,163,150 ,164,150 ,165,150 ,166,150 ,167,150 ,168,150 ,169,150 ,170,150 ,171,150 ,172,150 ,173,150 ,174,150 ,175,150 ,176,150 ,177,150 ,178,150 ,179,150 ,},[113]={92,150 ,93,150 ,94,150 ,95,150 ,96,150 ,97,150 ,98,150 ,99,150 ,100,150 ,101,150 ,102,150 ,103,150 ,104,150 ,105,150 ,106,150 ,107,150 ,108,150 ,109,150 ,118,150 ,119,150 ,120,150 ,121,150 ,122,150 ,123,150 ,124,150 ,125,150 ,126,150 ,127,150 ,128,150 ,129,150 ,130,150 ,131,150 ,132,150 ,133,150 ,134,150 ,135,150 ,136,150 ,137,150 ,138,150 ,139,150 ,140,150 ,141,150 ,142,150 ,143,150 ,144,150 ,145,150 ,146,150 ,147,150 ,148,150 ,149,150 ,150,150 ,151,150 ,152,150 ,153,150 ,162,150 ,163,150 ,164,150 ,165,150 ,166,150 ,167,150 ,168,150 ,169,150 ,170,150 ,171,150 ,172,150 ,173,150 ,174,150 ,175,150 ,176,150 ,177,150 ,178,150 ,179,150 ,},[114]={92,150 ,93,150 ,94,150 ,95,150 ,96,150 ,97,150 ,98,150 ,99,150 ,100,150 ,101,150 ,102,150 ,103,150 ,104,150 ,105,150 ,106,150 ,107,150 ,108,150 ,109,150 ,110,150 ,111,150 ,112,150 ,113,150 ,114,150 ,115,150 ,116,150 ,117,150 ,118,150 ,119,150 ,120,150 ,121,150 ,122,150 ,123,150 ,124,150 ,125,150 ,126,304 ,127,304 ,128,304 ,129,304 ,130,150 ,131,150 ,132,150 ,133,150 ,134,150 ,135,150 ,136,150 ,137,150 ,138,150 ,139,150 ,140,150 ,141,150 ,142,304 ,143,304 ,144,304 ,145,304 ,146,150 ,147,150 ,148,150 ,149,150 ,150,150 ,151,150 ,152,150 ,153,150 ,154,150 ,155,150 ,156,150 ,157,150 ,158,150 ,159,150 ,160,150 ,161,150 ,162,150 ,163,150 ,164,150 ,165,150 ,166,150 ,167,150 ,168,150 ,169,150 ,170,150 ,171,150 ,172,150 ,173,150 ,174,150 ,175,150 ,176,150 ,177,150 ,178,150 ,179,150 ,},[115]={92,150 ,93,150 ,94,150 ,95,150 ,96,150 ,97,150 ,98,150 ,99,150 ,100,150 ,101,150 ,102,150 ,103,150 ,104,150 ,105,150 ,106,150 ,107,150 ,108,150 ,109,150 ,110,150 ,111,150 ,112,150 ,113,150 ,114,150 ,115,150 ,116,150 ,117,150 ,118,150 ,119,150 ,120,150 ,121,150 ,122,150 ,123,150 ,124,150 ,125,150 ,126,304 ,127,304 ,128,304 ,129,304 ,130,150 ,131,150 ,132,150 ,133,150 ,134,150 ,135,150 ,136,150 ,137,150 ,138,150 ,139,150 ,140,150 ,141,150 ,142,304 ,143,304 ,144,304 ,145,304 ,146,150 ,147,150 ,148,150 ,149,150 ,150,150 ,151,150 ,152,150 ,153,150 ,154,150 ,155,150 ,156,150 ,157,150 ,158,150 ,159,150 ,160,150 ,161,150 ,162,150 ,163,150 ,164,150 ,165,150 ,166,150 ,167,150 ,168,150 ,169,150 ,170,150 ,171,150 ,172,150 ,173,150 ,174,150 ,175,150 ,176,150 ,177,150 ,178,150 ,179,150 ,},[116]={92,150 ,93,150 ,94,150 ,95,150 ,96,150 ,97,150 ,98,150 ,99,150 ,100,150 ,101,150 ,102,150 ,103,150 ,104,150 ,105,150 ,106,150 ,107,150 ,108,150 ,109,150 ,110,150 ,111,150 ,112,150 ,113,150 ,114,150 ,115,150 ,116,150 ,117,150 ,118,150 ,119,150 ,120,150 ,121,150 ,122,150 ,123,150 ,124,150 ,125,150 ,126,304 ,127,304 ,128,304 ,129,304 ,130,150 ,131,150 ,132,150 ,133,150 ,134,150 ,135,150 ,136,150 ,137,150 ,138,150 ,139,150 ,140,150 ,141,150 ,142,304 ,143,304 ,144,304 ,145,304 ,146,150 ,147,150 ,148,150 ,149,150 ,150,150 ,151,150 ,152,150 ,153,150 ,154,150 ,155,150 ,156,150 ,157,150 ,158,150 ,159,150 ,160,150 ,161,150 ,162,150 ,163,150 ,164,150 ,165,150 ,166,150 ,167,150 ,168,150 ,169,150 ,170,150 ,171,150 ,172,150 ,173,150 ,174,150 ,175,150 ,176,150 ,177,150 ,178,150 ,179,150 ,},[117]={92,150 ,93,150 ,94,150 ,95,150 ,96,150 ,97,150 ,98,150 ,99,150 ,100,150 ,101,150 ,102,150 ,103,150 ,104,150 ,105,150 ,106,150 ,107,150 ,108,150 ,109,150 ,110,150 ,111,150 ,112,150 ,113,150 ,114,150 ,115,150 ,116,150 ,117,150 ,118,150 ,119,150 ,120,150 ,121,150 ,122,150 ,123,150 ,124,150 ,125,150 ,126,304 ,127,304 ,128,304 ,129,304 ,130,150 ,131,150 ,132,150 ,133,150 ,134,150 ,135,150 ,136,150 ,137,150 ,138,150 ,139,150 ,140,150 ,141,150 ,142,304 ,143,304 ,144,304 ,145,304 ,146,150 ,147,150 ,148,150 ,149,150 ,150,150 ,151,150 ,152,150 ,153,150 ,154,150 ,155,150 ,156,150 ,157,150 ,158,150 ,159,150 ,160,150 ,161,150 ,162,150 ,163,150 ,164,150 ,165,150 ,166,150 ,167,150 ,168,150 ,169,150 ,170,150 ,171,150 ,172,150 ,173,150 ,174,150 ,175,150 ,176,150 ,177,150 ,178,150 ,179,150 ,},[118]={92,150 ,93,150 ,94,150 ,95,150 ,96,150 ,97,150 ,98,150 ,99,150 ,100,150 ,101,150 ,102,150 ,103,150 ,104,150 ,105,150 ,106,150 ,107,150 ,108,150 ,109,150 ,110,150 ,111,150 ,112,150 ,113,150 ,114,150 ,115,150 ,116,150 ,117,150 ,118,150 ,119,150 ,120,150 ,121,150 ,122,150 ,123,150 ,124,150 ,125,150 ,126,150 ,127,150 ,128,150 ,129,150 ,130,150 ,131,150 ,132,150 ,133,150 ,134,150 ,135,150 ,136,150 ,137,150 ,138,150 ,139,150 ,140,150 ,141,150 ,142,150 ,143,150 ,144,150 ,145,150 ,146,150 ,147,150 ,148,150 ,149,150 ,150,150 ,151,150 ,152,150 ,153,150 ,154,150 ,155,150 ,156,150 ,157,150 ,158,150 ,159,150 ,160,150 ,161,150 ,162,150 ,163,150 ,164,150 ,165,150 ,166,150 ,167,150 ,168,150 ,169,150 ,170,150 ,171,150 ,172,150 ,173,150 ,174,150 ,175,150 ,176,150 ,177,150 ,178,150 ,179,150 ,},[119]={92,150 ,93,150 ,94,150 ,95,150 ,96,150 ,97,150 ,98,150 ,99,150 ,100,150 ,101,150 ,102,150 ,103,150 ,104,150 ,105,150 ,106,150 ,107,150 ,108,150 ,109,150 ,110,150 ,111,150 ,112,150 ,113,150 ,114,150 ,115,150 ,116,150 ,117,150 ,118,150 ,119,150 ,120,150 ,121,150 ,122,150 ,123,150 ,124,150 ,125,150 ,126,150 ,127,150 ,128,150 ,129,150 ,130,150 ,131,150 ,132,150 ,133,150 ,134,150 ,135,150 ,136,150 ,137,150 ,138,150 ,139,150 ,140,150 ,141,150 ,142,150 ,143,150 ,144,150 ,145,150 ,146,150 ,147,150 ,148,150 ,149,150 ,150,150 ,151,150 ,152,150 ,153,150 ,154,150 ,155,150 ,156,150 ,157,150 ,158,150 ,159,150 ,160,150 ,161,150 ,162,150 ,163,150 ,164,150 ,165,150 ,166,150 ,167,150 ,168,150 ,169,150 ,170,150 ,171,150 ,172,150 ,173,150 ,174,150 ,175,150 ,176,150 ,177,150 ,178,150 ,179,150 ,},[120]={92,150 ,93,150 ,94,150 ,95,150 ,96,150 ,97,150 ,98,150 ,99,150 ,100,150 ,101,150 ,102,150 ,103,150 ,104,150 ,105,150 ,106,150 ,107,150 ,108,150 ,109,150 ,110,150 ,111,150 ,112,150 ,113,150 ,114,150 ,115,150 ,116,150 ,117,150 ,118,150 ,119,150 ,120,150 ,121,150 ,122,150 ,123,150 ,134,150 ,135,150 ,136,150 ,137,150 ,148,150 ,149,150 ,150,150 ,151,150 ,152,150 ,153,150 ,154,150 ,155,150 ,156,150 ,157,150 ,158,150 ,159,150 ,160,150 ,161,150 ,162,150 ,163,150 ,164,150 ,165,150 ,166,150 ,167,150 ,168,150 ,169,150 ,170,150 ,171,150 ,172,150 ,173,150 ,174,150 ,175,150 ,176,150 ,177,150 ,178,150 ,179,150 ,},[121]={92,150 ,93,150 ,94,150 ,95,150 ,96,150 ,97,150 ,98,150 ,99,150 ,100,150 ,101,150 ,102,150 ,103,150 ,104,150 ,105,150 ,106,150 ,107,150 ,108,150 ,109,150 ,110,150 ,111,150 ,112,150 ,113,150 ,114,150 ,115,150 ,116,150 ,117,150 ,118,150 ,119,150 ,120,150 ,121,150 ,122,150 ,123,150 ,134,150 ,135,150 ,136,150 ,137,150 ,148,150 ,149,150 ,150,150 ,151,150 ,152,150 ,153,150 ,154,150 ,155,150 ,156,150 ,157,150 ,158,150 ,159,150 ,160,150 ,161,150 ,162,150 ,163,150 ,164,150 ,165,150 ,166,150 ,167,150 ,168,150 ,169,150 ,170,150 ,171,150 ,172,150 ,173,150 ,174,150 ,175,150 ,176,150 ,177,150 ,178,150 ,179,150 ,},[122]={92,150 ,93,150 ,94,150 ,95,150 ,96,150 ,97,150 ,98,150 ,99,150 ,100,150 ,101,150 ,102,150 ,103,150 ,104,150 ,105,150 ,106,150 ,107,150 ,108,150 ,109,150 ,110,150 ,111,150 ,112,150 ,113,150 ,114,150 ,115,150 ,116,150 ,117,150 ,118,304 ,119,304 ,120,304 ,121,304 ,122,150 ,123,150 ,134,150 ,135,150 ,136,150 ,137,150 ,148,150 ,149,150 ,150,304 ,151,304 ,152,304 ,153,304 ,154,150 ,155,150 ,156,150 ,157,150 ,158,150 ,159,150 ,160,150 ,161,150 ,162,150 ,163,150 ,164,150 ,165,150 ,166,150 ,167,150 ,168,150 ,169,150 ,170,150 ,171,150 ,172,150 ,173,150 ,174,150 ,175,150 ,176,150 ,177,150 ,178,150 ,179,150 ,},[123]={92,150 ,93,150 ,94,150 ,95,150 ,96,150 ,97,150 ,98,150 ,99,150 ,100,150 ,101,150 ,102,150 ,103,150 ,104,150 ,105,150 ,106,150 ,107,150 ,108,150 ,109,150 ,110,150 ,111,150 ,112,150 ,113,150 ,114,150 ,115,150 ,116,150 ,117,150 ,118,304 ,119,304 ,120,304 ,121,304 ,122,150 ,123,150 ,134,150 ,135,150 ,136,150 ,137,150 ,148,150 ,149,150 ,150,304 ,151,304 ,152,304 ,153,304 ,154,150 ,155,150 ,156,150 ,157,150 ,158,150 ,159,150 ,160,150 ,161,150 ,162,150 ,163,150 ,164,150 ,165,150 ,166,150 ,167,150 ,168,150 ,169,150 ,170,150 ,171,150 ,172,150 ,173,150 ,174,150 ,175,150 ,176,150 ,177,150 ,178,150 ,179,150 ,},[124]={92,150 ,93,150 ,94,150 ,95,150 ,96,150 ,97,150 ,98,150 ,99,150 ,100,150 ,101,150 ,102,150 ,103,150 ,104,150 ,105,150 ,106,150 ,107,150 ,108,150 ,109,150 ,110,150 ,111,150 ,112,150 ,113,150 ,114,150 ,115,150 ,116,150 ,117,150 ,118,304 ,119,304 ,120,304 ,121,304 ,122,150 ,123,150 ,148,150 ,149,150 ,150,304 ,151,304 ,152,304 ,153,304 ,154,150 ,155,150 ,156,150 ,157,150 ,158,150 ,159,150 ,160,150 ,161,150 ,162,150 ,163,150 ,164,150 ,165,150 ,166,150 ,167,150 ,168,150 ,169,150 ,170,150 ,171,150 ,172,150 ,173,150 ,174,150 ,175,150 ,176,150 ,177,150 ,178,150 ,179,150 ,},[125]={92,150 ,93,150 ,94,150 ,95,150 ,96,150 ,97,150 ,98,150 ,99,150 ,100,150 ,101,150 ,102,150 ,103,150 ,104,150 ,105,150 ,106,150 ,107,150 ,108,150 ,109,150 ,110,150 ,111,150 ,112,150 ,113,150 ,114,150 ,115,150 ,116,150 ,117,150 ,118,304 ,119,304 ,120,304 ,121,304 ,122,150 ,123,150 ,148,150 ,149,150 ,150,304 ,151,304 ,152,304 ,153,304 ,154,150 ,155,150 ,156,150 ,157,150 ,158,150 ,159,150 ,160,150 ,161,150 ,162,150 ,163,150 ,164,150 ,165,150 ,166,150 ,167,150 ,168,150 ,169,150 ,170,150 ,171,150 ,172,150 ,173,150 ,174,150 ,175,150 ,176,150 ,177,150 ,178,150 ,179,150 ,},[126]={92,150 ,93,150 ,94,150 ,95,150 ,96,150 ,97,150 ,98,150 ,99,150 ,100,150 ,101,150 ,102,150 ,103,150 ,104,150 ,105,150 ,106,150 ,107,150 ,108,150 ,109,150 ,110,150 ,111,150 ,112,150 ,113,150 ,114,150 ,115,150 ,116,150 ,117,150 ,118,150 ,119,150 ,120,150 ,121,150 ,122,150 ,123,150 ,148,150 ,149,150 ,150,150 ,151,150 ,152,150 ,153,150 ,154,150 ,155,150 ,156,150 ,157,150 ,158,150 ,159,150 ,160,150 ,161,150 ,162,150 ,163,150 ,164,150 ,165,150 ,166,150 ,167,150 ,168,150 ,169,150 ,170,150 ,171,150 ,172,150 ,173,150 ,174,150 ,175,150 ,176,150 ,177,150 ,178,150 ,179,150 ,},[127]={92,150 ,93,150 ,94,150 ,95,150 ,96,150 ,97,150 ,98,150 ,99,150 ,100,150 ,101,150 ,102,150 ,103,150 ,104,150 ,105,150 ,106,150 ,107,150 ,108,150 ,109,150 ,110,150 ,111,150 ,112,150 ,113,150 ,114,150 ,115,150 ,116,150 ,117,150 ,118,150 ,119,150 ,120,150 ,121,150 ,122,150 ,123,150 ,148,150 ,149,150 ,150,150 ,151,150 ,152,150 ,153,150 ,154,150 ,155,150 ,156,150 ,157,150 ,158,150 ,159,150 ,160,150 ,161,150 ,162,150 ,163,150 ,164,150 ,165,150 ,166,150 ,167,150 ,168,150 ,169,150 ,170,150 ,171,150 ,172,150 ,173,150 ,174,150 ,175,150 ,176,150 ,177,150 ,178,150 ,179,150 ,},[128]={92,150 ,93,150 ,94,150 ,95,150 ,96,150 ,97,150 ,98,150 ,99,150 ,100,150 ,101,150 ,102,150 ,103,150 ,104,150 ,105,150 ,106,150 ,107,150 ,108,150 ,109,150 ,110,150 ,111,150 ,112,150 ,113,150 ,114,150 ,115,150 ,116,150 ,117,150 ,118,150 ,119,150 ,120,150 ,121,150 ,122,150 ,123,150 ,148,150 ,149,150 ,150,150 ,151,150 ,152,150 ,153,150 ,154,150 ,155,150 ,156,150 ,157,150 ,158,150 ,159,150 ,160,150 ,161,150 ,162,150 ,163,150 ,164,150 ,165,150 ,166,150 ,167,150 ,168,150 ,169,150 ,170,150 ,171,150 ,172,150 ,173,150 ,174,150 ,175,150 ,176,150 ,177,150 ,178,150 ,179,150 ,},[129]={92,150 ,93,150 ,94,150 ,95,150 ,96,150 ,97,150 ,98,150 ,99,150 ,100,150 ,101,150 ,102,150 ,103,150 ,104,150 ,105,150 ,106,150 ,107,150 ,108,150 ,109,150 ,110,150 ,111,150 ,112,150 ,113,150 ,114,150 ,115,150 ,116,150 ,117,150 ,118,150 ,119,150 ,120,150 ,121,150 ,122,150 ,123,150 ,148,150 ,149,150 ,150,150 ,151,150 ,152,150 ,153,150 ,154,150 ,155,150 ,156,150 ,157,150 ,158,150 ,159,150 ,160,150 ,161,150 ,162,150 ,163,150 ,164,150 ,165,150 ,166,150 ,167,150 ,168,150 ,169,150 ,170,150 ,171,150 ,172,150 ,173,150 ,174,150 ,175,150 ,176,150 ,177,150 ,178,150 ,179,150 ,},[130]={92,150 ,93,150 ,94,150 ,95,150 ,96,150 ,97,150 ,98,150 ,99,150 ,100,150 ,101,150 ,102,150 ,103,150 ,104,150 ,105,150 ,106,150 ,107,150 ,108,150 ,109,150 ,110,150 ,111,150 ,112,150 ,113,150 ,114,150 ,115,150 ,116,150 ,117,150 ,118,150 ,119,150 ,120,150 ,121,150 ,122,150 ,123,150 ,124,150 ,125,150 ,126,150 ,127,150 ,144,150 ,145,150 ,146,150 ,147,150 ,148,150 ,149,150 ,150,150 ,151,150 ,152,150 ,153,150 ,154,150 ,155,150 ,156,150 ,157,150 ,158,150 ,159,150 ,160,150 ,161,150 ,162,150 ,163,150 ,164,150 ,165,150 ,166,150 ,167,150 ,168,150 ,169,150 ,170,150 ,171,150 ,172,150 ,173,150 ,174,150 ,175,150 ,176,150 ,177,150 ,178,150 ,179,150 ,},[131]={92,150 ,93,150 ,94,150 ,95,150 ,96,150 ,97,150 ,98,150 ,99,150 ,100,150 ,101,150 ,102,150 ,103,150 ,104,150 ,105,150 ,106,150 ,107,150 ,108,150 ,109,150 ,110,150 ,111,150 ,112,150 ,113,150 ,114,150 ,115,150 ,116,150 ,117,150 ,118,150 ,119,150 ,120,150 ,121,150 ,122,150 ,123,150 ,124,150 ,125,150 ,126,150 ,127,150 ,144,150 ,145,150 ,146,150 ,147,150 ,148,150 ,149,150 ,150,150 ,151,150 ,152,150 ,153,150 ,154,150 ,155,150 ,156,150 ,157,150 ,158,150 ,159,150 ,160,150 ,161,150 ,162,150 ,163,150 ,164,150 ,165,150 ,166,150 ,167,150 ,168,150 ,169,150 ,170,150 ,171,150 ,172,150 ,173,150 ,174,150 ,175,150 ,176,150 ,177,150 ,178,150 ,179,150 ,},[132]={92,150 ,93,150 ,94,150 ,95,150 ,96,150 ,97,150 ,98,150 ,99,150 ,100,150 ,101,150 ,102,150 ,103,150 ,104,150 ,105,150 ,106,150 ,107,150 ,108,150 ,109,150 ,110,150 ,111,150 ,112,150 ,113,150 ,114,150 ,115,150 ,116,150 ,117,150 ,118,150 ,119,150 ,120,150 ,121,150 ,122,150 ,123,150 ,124,150 ,125,150 ,126,150 ,127,150 ,144,150 ,145,150 ,146,150 ,147,150 ,148,150 ,149,150 ,150,150 ,151,150 ,152,150 ,153,150 ,154,150 ,155,150 ,156,150 ,157,150 ,158,150 ,159,150 ,160,150 ,161,150 ,162,150 ,163,150 ,164,150 ,165,150 ,166,150 ,167,150 ,168,150 ,169,150 ,170,150 ,171,150 ,172,150 ,173,150 ,174,150 ,175,150 ,176,150 ,177,150 ,178,150 ,179,150 ,},[133]={92,150 ,93,150 ,94,150 ,95,150 ,96,150 ,97,150 ,98,150 ,99,150 ,100,150 ,101,150 ,102,150 ,103,150 ,104,150 ,105,150 ,106,150 ,107,150 ,108,150 ,109,150 ,110,150 ,111,150 ,112,150 ,113,150 ,114,150 ,115,150 ,116,150 ,117,150 ,118,150 ,119,150 ,120,150 ,121,150 ,122,150 ,123,150 ,124,150 ,125,150 ,126,150 ,127,150 ,144,150 ,145,150 ,146,150 ,147,150 ,148,150 ,149,150 ,150,150 ,151,150 ,152,150 ,153,150 ,154,150 ,155,150 ,156,150 ,157,150 ,158,150 ,159,150 ,160,150 ,161,150 ,162,150 ,163,150 ,164,150 ,165,150 ,166,150 ,167,150 ,168,150 ,169,150 ,170,150 ,171,150 ,172,150 ,173,150 ,174,150 ,175,150 ,176,150 ,177,150 ,178,150 ,179,150 ,},[134]={92,150 ,93,150 ,94,150 ,95,150 ,96,150 ,97,150 ,98,150 ,99,150 ,100,150 ,101,150 ,102,150 ,103,150 ,104,150 ,105,150 ,106,150 ,107,150 ,108,150 ,109,150 ,110,150 ,111,150 ,112,150 ,113,150 ,114,150 ,115,150 ,116,150 ,117,150 ,118,150 ,119,150 ,120,150 ,121,150 ,122,150 ,123,150 ,148,150 ,149,150 ,150,150 ,151,150 ,152,150 ,153,150 ,154,150 ,155,150 ,156,150 ,157,150 ,158,150 ,159,150 ,160,150 ,161,150 ,162,150 ,163,150 ,164,150 ,165,150 ,166,150 ,167,150 ,168,150 ,169,150 ,170,150 ,171,150 ,172,150 ,173,150 ,174,150 ,175,150 ,176,150 ,177,150 ,178,150 ,179,150 ,},[135]={92,150 ,93,150 ,94,150 ,95,150 ,96,150 ,97,150 ,98,150 ,99,150 ,100,150 ,101,150 ,102,150 ,103,150 ,104,150 ,105,150 ,106,150 ,107,150 ,108,150 ,109,150 ,110,150 ,111,150 ,112,150 ,113,150 ,114,150 ,115,150 ,116,150 ,117,150 ,118,150 ,119,150 ,120,150 ,121,150 ,122,150 ,123,150 ,148,150 ,149,150 ,150,150 ,151,150 ,152,150 ,153,150 ,154,150 ,155,150 ,156,150 ,157,150 ,158,150 ,159,150 ,160,150 ,161,150 ,162,150 ,163,150 ,164,150 ,165,150 ,166,150 ,167,150 ,168,150 ,169,150 ,170,150 ,171,150 ,172,150 ,173,150 ,174,150 ,175,150 ,176,150 ,177,150 ,178,150 ,179,150 ,},[136]={92,150 ,93,150 ,94,150 ,95,150 ,96,150 ,97,150 ,98,150 ,99,150 ,100,150 ,101,150 ,102,150 ,103,150 ,104,150 ,105,150 ,106,150 ,107,150 ,108,150 ,109,150 ,110,150 ,111,150 ,112,150 ,113,150 ,114,150 ,115,150 ,116,150 ,117,150 ,118,150 ,119,150 ,120,150 ,121,150 ,122,150 ,123,150 ,148,150 ,149,150 ,150,150 ,151,150 ,152,150 ,153,150 ,154,150 ,155,150 ,156,150 ,157,150 ,158,150 ,159,150 ,160,150 ,161,150 ,162,150 ,163,150 ,164,150 ,165,150 ,166,150 ,167,150 ,168,150 ,169,150 ,170,150 ,171,150 ,172,150 ,173,150 ,174,150 ,175,150 ,176,150 ,177,150 ,178,150 ,179,150 ,},[137]={92,150 ,93,150 ,94,150 ,95,150 ,96,150 ,97,150 ,98,150 ,99,150 ,100,150 ,101,150 ,102,150 ,103,150 ,104,150 ,105,150 ,106,150 ,107,150 ,108,150 ,109,150 ,110,150 ,111,150 ,112,150 ,113,150 ,114,150 ,115,150 ,116,150 ,117,150 ,118,150 ,119,150 ,120,150 ,121,150 ,122,150 ,123,150 ,148,150 ,149,150 ,150,150 ,151,150 ,152,150 ,153,150 ,154,150 ,155,150 ,156,150 ,157,150 ,158,150 ,159,150 ,160,150 ,161,150 ,162,150 ,163,150 ,164,150 ,165,150 ,166,150 ,167,150 ,168,150 ,169,150 ,170,150 ,171,150 ,172,150 ,173,150 ,174,150 ,175,150 ,176,150 ,177,150 ,178,150 ,179,150 ,},[138]={92,150 ,93,150 ,94,150 ,95,150 ,96,150 ,97,150 ,98,150 ,99,150 ,100,150 ,101,150 ,102,150 ,103,150 ,104,150 ,105,150 ,106,150 ,107,150 ,108,150 ,109,150 ,110,150 ,111,150 ,112,150 ,113,150 ,114,150 ,115,150 ,116,150 ,117,150 ,118,304 ,119,304 ,120,304 ,121,304 ,122,150 ,123,150 ,148,150 ,149,150 ,150,304 ,151,304 ,152,304 ,153,304 ,154,150 ,155,150 ,156,150 ,157,150 ,158,150 ,159,150 ,160,150 ,161,150 ,162,150 ,163,150 ,164,150 ,165,150 ,166,150 ,167,150 ,168,150 ,169,150 ,170,150 ,171,150 ,172,150 ,173,150 ,174,150 ,175,150 ,176,150 ,177,150 ,178,150 ,179,150 ,},[139]={92,150 ,93,150 ,94,150 ,95,150 ,96,150 ,97,150 ,98,150 ,99,150 ,100,150 ,101,150 ,102,150 ,103,150 ,104,150 ,105,150 ,106,150 ,107,150 ,108,150 ,109,150 ,110,150 ,111,150 ,112,150 ,113,150 ,114,150 ,115,150 ,116,150 ,117,150 ,118,304 ,119,304 ,120,304 ,121,304 ,122,150 ,123,150 ,148,150 ,149,150 ,150,304 ,151,304 ,152,304 ,153,304 ,154,150 ,155,150 ,156,150 ,157,150 ,158,150 ,159,150 ,160,150 ,161,150 ,162,150 ,163,150 ,164,150 ,165,150 ,166,150 ,167,150 ,168,150 ,169,150 ,170,150 ,171,150 ,172,150 ,173,150 ,174,150 ,175,150 ,176,150 ,177,150 ,178,150 ,179,150 ,},[140]={92,150 ,93,150 ,94,150 ,95,150 ,96,150 ,97,150 ,98,150 ,99,150 ,100,150 ,101,150 ,102,150 ,103,150 ,104,150 ,105,150 ,106,150 ,107,150 ,108,150 ,109,150 ,110,150 ,111,150 ,112,150 ,113,150 ,114,150 ,115,150 ,116,150 ,117,150 ,118,304 ,119,304 ,120,304 ,121,304 ,122,150 ,123,150 ,134,150 ,135,150 ,136,150 ,137,150 ,148,150 ,149,150 ,150,304 ,151,304 ,152,304 ,153,304 ,154,150 ,155,150 ,156,150 ,157,150 ,158,150 ,159,150 ,160,150 ,161,150 ,162,150 ,163,150 ,164,150 ,165,150 ,166,150 ,167,150 ,168,150 ,169,150 ,170,150 ,171,150 ,172,150 ,173,150 ,174,150 ,175,150 ,176,150 ,177,150 ,178,150 ,179,150 ,},[141]={92,150 ,93,150 ,94,150 ,95,150 ,96,150 ,97,150 ,98,150 ,99,150 ,100,150 ,101,150 ,102,150 ,103,150 ,104,150 ,105,150 ,106,150 ,107,150 ,108,150 ,109,150 ,110,150 ,111,150 ,112,150 ,113,150 ,114,150 ,115,150 ,116,150 ,117,150 ,118,304 ,119,304 ,120,304 ,121,304 ,122,150 ,123,150 ,134,150 ,135,150 ,136,150 ,137,150 ,148,150 ,149,150 ,150,304 ,151,304 ,152,304 ,153,304 ,154,150 ,155,150 ,156,150 ,157,150 ,158,150 ,159,150 ,160,150 ,161,150 ,162,150 ,163,150 ,164,150 ,165,150 ,166,150 ,167,150 ,168,150 ,169,150 ,170,150 ,171,150 ,172,150 ,173,150 ,174,150 ,175,150 ,176,150 ,177,150 ,178,150 ,179,150 ,},[142]={92,150 ,93,150 ,94,150 ,95,150 ,96,150 ,97,150 ,98,150 ,99,150 ,100,150 ,101,150 ,102,150 ,103,150 ,104,150 ,105,150 ,106,150 ,107,150 ,108,150 ,109,150 ,110,150 ,111,150 ,112,150 ,113,150 ,114,150 ,115,150 ,116,150 ,117,150 ,118,150 ,119,150 ,120,150 ,121,150 ,122,150 ,123,150 ,134,150 ,135,150 ,136,150 ,137,150 ,148,150 ,149,150 ,150,150 ,151,150 ,152,150 ,153,150 ,154,150 ,155,150 ,156,150 ,157,150 ,158,150 ,159,150 ,160,150 ,161,150 ,162,150 ,163,150 ,164,150 ,165,150 ,166,150 ,167,150 ,168,150 ,169,150 ,170,150 ,171,150 ,172,150 ,173,150 ,174,150 ,175,150 ,176,150 ,177,150 ,178,150 ,179,150 ,},[143]={92,150 ,93,150 ,94,150 ,95,150 ,96,150 ,97,150 ,98,150 ,99,150 ,100,150 ,101,150 ,102,150 ,103,150 ,104,150 ,105,150 ,106,150 ,107,150 ,108,150 ,109,150 ,110,150 ,111,150 ,112,150 ,113,150 ,114,150 ,115,150 ,116,150 ,117,150 ,118,150 ,119,150 ,120,150 ,121,150 ,122,150 ,123,150 ,134,150 ,135,150 ,136,150 ,137,150 ,148,150 ,149,150 ,150,150 ,151,150 ,152,150 ,153,150 ,154,150 ,155,150 ,156,150 ,157,150 ,158,150 ,159,150 ,160,150 ,161,150 ,162,150 ,163,150 ,164,150 ,165,150 ,166,150 ,167,150 ,168,150 ,169,150 ,170,150 ,171,150 ,172,150 ,173,150 ,174,150 ,175,150 ,176,150 ,177,150 ,178,150 ,179,150 ,},[144]={92,150 ,93,150 ,94,150 ,95,150 ,96,150 ,97,150 ,98,150 ,99,150 ,100,150 ,101,150 ,102,150 ,103,150 ,104,150 ,105,150 ,106,150 ,107,150 ,108,150 ,109,150 ,110,150 ,111,150 ,112,150 ,113,150 ,114,150 ,115,150 ,116,150 ,117,150 ,118,150 ,119,150 ,120,150 ,121,150 ,122,150 ,123,150 ,124,150 ,125,150 ,126,150 ,127,150 ,128,150 ,129,150 ,130,150 ,131,150 ,132,150 ,133,150 ,134,150 ,135,150 ,136,150 ,137,150 ,138,150 ,139,150 ,140,150 ,141,150 ,142,150 ,143,150 ,144,150 ,145,150 ,146,150 ,147,150 ,148,150 ,149,150 ,150,150 ,151,150 ,152,150 ,153,150 ,154,150 ,155,150 ,156,150 ,157,150 ,158,150 ,159,150 ,160,150 ,161,150 ,162,150 ,163,150 ,164,150 ,165,150 ,166,150 ,167,150 ,168,150 ,169,150 ,170,150 ,171,150 ,172,150 ,173,150 ,174,150 ,175,150 ,176,150 ,177,150 ,178,150 ,179,150 ,},[145]={92,150 ,93,150 ,94,150 ,95,150 ,96,150 ,97,150 ,98,150 ,99,150 ,100,150 ,101,150 ,102,150 ,103,150 ,104,150 ,105,150 ,106,150 ,107,150 ,108,150 ,109,150 ,110,150 ,111,150 ,112,150 ,113,150 ,114,150 ,115,150 ,116,150 ,117,150 ,118,150 ,119,150 ,120,150 ,121,150 ,122,150 ,123,150 ,124,150 ,125,150 ,126,150 ,127,150 ,128,150 ,129,150 ,130,150 ,131,150 ,132,150 ,133,150 ,134,150 ,135,150 ,136,150 ,137,150 ,138,150 ,139,150 ,140,150 ,141,150 ,142,150 ,143,150 ,144,150 ,145,150 ,146,150 ,147,150 ,148,150 ,149,150 ,150,150 ,151,150 ,152,150 ,153,150 ,154,150 ,155,150 ,156,150 ,157,150 ,158,150 ,159,150 ,160,150 ,161,150 ,162,150 ,163,150 ,164,150 ,165,150 ,166,150 ,167,150 ,168,150 ,169,150 ,170,150 ,171,150 ,172,150 ,173,150 ,174,150 ,175,150 ,176,150 ,177,150 ,178,150 ,179,150 ,},[146]={92,150 ,93,150 ,94,150 ,95,150 ,96,150 ,97,150 ,98,150 ,99,150 ,100,150 ,101,150 ,102,150 ,103,150 ,104,150 ,105,150 ,106,150 ,107,150 ,108,150 ,109,150 ,110,150 ,111,150 ,112,150 ,113,150 ,114,150 ,115,150 ,116,150 ,117,150 ,118,150 ,119,150 ,120,150 ,121,150 ,122,150 ,123,150 ,124,150 ,125,150 ,126,304 ,127,304 ,128,304 ,129,304 ,130,150 ,131,150 ,132,150 ,133,150 ,134,150 ,135,150 ,136,150 ,137,150 ,138,150 ,139,150 ,140,150 ,141,150 ,142,304 ,143,304 ,144,304 ,145,304 ,146,150 ,147,150 ,148,150 ,149,150 ,150,150 ,151,150 ,152,150 ,153,150 ,154,150 ,155,150 ,156,150 ,157,150 ,158,150 ,159,150 ,160,150 ,161,150 ,162,150 ,163,150 ,164,150 ,165,150 ,166,150 ,167,150 ,168,150 ,169,150 ,170,150 ,171,150 ,172,150 ,173,150 ,174,150 ,175,150 ,176,150 ,177,150 ,178,150 ,179,150 ,},[147]={92,150 ,93,150 ,94,150 ,95,150 ,96,150 ,97,150 ,98,150 ,99,150 ,100,150 ,101,150 ,102,150 ,103,150 ,104,150 ,105,150 ,106,150 ,107,150 ,108,150 ,109,150 ,110,150 ,111,150 ,112,150 ,113,150 ,114,150 ,115,150 ,116,150 ,117,150 ,118,150 ,119,150 ,120,150 ,121,150 ,122,150 ,123,150 ,124,150 ,125,150 ,126,304 ,127,304 ,128,304 ,129,304 ,130,150 ,131,150 ,132,150 ,133,150 ,134,150 ,135,150 ,136,150 ,137,150 ,138,150 ,139,150 ,140,150 ,141,150 ,142,304 ,143,304 ,144,304 ,145,304 ,146,150 ,147,150 ,148,150 ,149,150 ,150,150 ,151,150 ,152,150 ,153,150 ,154,150 ,155,150 ,156,150 ,157,150 ,158,150 ,159,150 ,160,150 ,161,150 ,162,150 ,163,150 ,164,150 ,165,150 ,166,150 ,167,150 ,168,150 ,169,150 ,170,150 ,171,150 ,172,150 ,173,150 ,174,150 ,175,150 ,176,150 ,177,150 ,178,150 ,179,150 ,},[148]={92,150 ,93,150 ,94,150 ,95,150 ,96,150 ,97,150 ,98,150 ,99,150 ,100,150 ,101,150 ,102,150 ,103,150 ,104,150 ,105,150 ,106,150 ,107,150 ,108,150 ,109,150 ,110,150 ,111,150 ,112,150 ,113,150 ,114,150 ,115,150 ,116,150 ,117,150 ,118,150 ,119,150 ,120,150 ,121,150 ,122,150 ,123,150 ,124,150 ,125,150 ,126,304 ,127,304 ,128,304 ,129,304 ,130,150 ,131,150 ,132,150 ,133,150 ,134,150 ,135,150 ,136,150 ,137,150 ,138,150 ,139,150 ,140,150 ,141,150 ,142,304 ,143,304 ,144,304 ,145,304 ,146,150 ,147,150 ,148,150 ,149,150 ,150,150 ,151,150 ,152,150 ,153,150 ,154,150 ,155,150 ,156,150 ,157,150 ,158,150 ,159,150 ,160,150 ,161,150 ,162,150 ,163,150 ,164,150 ,165,150 ,166,150 ,167,150 ,168,150 ,169,150 ,170,150 ,171,150 ,172,150 ,173,150 ,174,150 ,175,150 ,176,150 ,177,150 ,178,150 ,179,150 ,},[149]={92,150 ,93,150 ,94,150 ,95,150 ,96,150 ,97,150 ,98,150 ,99,150 ,100,150 ,101,150 ,102,150 ,103,150 ,104,150 ,105,150 ,106,150 ,107,150 ,108,150 ,109,150 ,110,150 ,111,150 ,112,150 ,113,150 ,114,150 ,115,150 ,116,150 ,117,150 ,118,150 ,119,150 ,120,150 ,121,150 ,122,150 ,123,150 ,124,150 ,125,150 ,126,304 ,127,304 ,128,304 ,129,304 ,130,150 ,131,150 ,132,150 ,133,150 ,134,150 ,135,150 ,136,150 ,137,150 ,138,150 ,139,150 ,140,150 ,141,150 ,142,304 ,143,304 ,144,304 ,145,304 ,146,150 ,147,150 ,148,150 ,149,150 ,150,150 ,151,150 ,152,150 ,153,150 ,154,150 ,155,150 ,156,150 ,157,150 ,158,150 ,159,150 ,160,150 ,161,150 ,162,150 ,163,150 ,164,150 ,165,150 ,166,150 ,167,150 ,168,150 ,169,150 ,170,150 ,171,150 ,172,150 ,173,150 ,174,150 ,175,150 ,176,150 ,177,150 ,178,150 ,179,150 ,},[150]={92,150 ,93,150 ,94,150 ,95,150 ,96,150 ,97,150 ,98,150 ,99,150 ,100,150 ,101,150 ,102,150 ,103,150 ,104,150 ,105,150 ,106,150 ,107,150 ,108,150 ,109,150 ,118,150 ,119,150 ,120,150 ,121,150 ,122,150 ,123,150 ,124,150 ,125,150 ,126,150 ,127,150 ,128,150 ,129,150 ,130,150 ,131,150 ,132,150 ,133,150 ,134,150 ,135,150 ,136,150 ,137,150 ,138,150 ,139,150 ,140,150 ,141,150 ,142,150 ,143,150 ,144,150 ,145,150 ,146,150 ,147,150 ,148,150 ,149,150 ,150,150 ,151,150 ,152,150 ,153,150 ,162,150 ,163,150 ,164,150 ,165,150 ,166,150 ,167,150 ,168,150 ,169,150 ,170,150 ,171,150 ,172,150 ,173,150 ,174,150 ,175,150 ,176,150 ,177,150 ,178,150 ,179,150 ,},[151]={92,150 ,93,150 ,94,150 ,95,150 ,96,150 ,97,150 ,98,150 ,99,150 ,100,150 ,101,150 ,102,150 ,103,150 ,104,150 ,105,150 ,106,150 ,107,150 ,108,150 ,109,150 ,118,150 ,119,150 ,120,150 ,121,150 ,122,150 ,123,150 ,124,150 ,125,150 ,126,150 ,127,150 ,128,150 ,129,150 ,130,150 ,131,150 ,132,150 ,133,150 ,134,150 ,135,150 ,136,150 ,137,150 ,138,150 ,139,150 ,140,150 ,141,150 ,142,150 ,143,150 ,144,150 ,145,150 ,146,150 ,147,150 ,148,150 ,149,150 ,150,150 ,151,150 ,152,150 ,153,150 ,162,150 ,163,150 ,164,150 ,165,150 ,166,150 ,167,150 ,168,150 ,169,150 ,170,150 ,171,150 ,172,150 ,173,150 ,174,150 ,175,150 ,176,150 ,177,150 ,178,150 ,179,150 ,},[152]={92,150 ,93,150 ,94,304 ,95,304 ,96,304 ,97,304 ,98,150 ,99,150 ,100,150 ,101,150 ,102,150 ,103,150 ,104,150 ,105,150 ,106,150 ,107,150 ,108,150 ,109,150 ,118,150 ,119,150 ,120,150 ,121,150 ,122,150 ,123,150 ,124,150 ,125,150 ,126,150 ,127,150 ,128,150 ,129,150 ,130,150 ,131,150 ,132,150 ,133,150 ,134,150 ,135,150 ,136,150 ,137,150 ,138,150 ,139,150 ,140,150 ,141,150 ,142,150 ,143,150 ,144,150 ,145,150 ,146,150 ,147,150 ,148,150 ,149,150 ,150,150 ,151,150 ,152,150 ,153,150 ,162,150 ,163,150 ,164,150 ,165,150 ,166,150 ,167,150 ,168,150 ,169,150 ,170,150 ,171,150 ,172,150 ,173,150 ,174,304 ,175,304 ,176,304 ,177,304 ,178,150 ,179,150 ,},[153]={92,150 ,93,150 ,94,304 ,95,304 ,96,304 ,97,304 ,98,150 ,99,150 ,100,150 ,101,150 ,102,150 ,103,150 ,104,150 ,105,150 ,106,150 ,107,150 ,108,150 ,109,150 ,118,150 ,119,150 ,120,150 ,121,150 ,122,150 ,123,150 ,124,150 ,125,150 ,126,150 ,127,150 ,128,150 ,129,150 ,130,150 ,131,150 ,132,150 ,133,150 ,134,150 ,135,150 ,136,150 ,137,150 ,138,150 ,139,150 ,140,150 ,141,150 ,142,150 ,143,150 ,144,150 ,145,150 ,146,150 ,147,150 ,148,150 ,149,150 ,150,150 ,151,150 ,152,150 ,153,150 ,162,150 ,163,150 ,164,150 ,165,150 ,166,150 ,167,150 ,168,150 ,169,150 ,170,150 ,171,150 ,172,150 ,173,150 ,174,304 ,175,304 ,176,304 ,177,304 ,178,150 ,179,150 ,},[154]={92,150 ,93,150 ,94,304 ,95,304 ,96,304 ,97,304 ,98,150 ,99,150 ,100,150 ,101,150 ,102,150 ,103,150 ,104,150 ,105,150 ,106,150 ,107,150 ,108,150 ,109,150 ,118,150 ,119,150 ,120,150 ,121,150 ,122,150 ,123,150 ,124,150 ,125,150 ,126,150 ,127,150 ,128,150 ,129,150 ,130,150 ,131,150 ,132,150 ,133,150 ,134,150 ,135,150 ,136,150 ,137,150 ,138,150 ,139,150 ,140,150 ,141,150 ,142,150 ,143,150 ,144,150 ,145,150 ,146,150 ,147,150 ,148,150 ,149,150 ,150,150 ,151,150 ,152,150 ,153,150 ,162,150 ,163,150 ,164,150 ,165,150 ,166,150 ,167,150 ,168,150 ,169,150 ,170,150 ,171,150 ,172,150 ,173,150 ,174,304 ,175,304 ,176,304 ,177,304 ,178,150 ,179,150 ,},[155]={92,150 ,93,150 ,94,304 ,95,304 ,96,304 ,97,304 ,98,150 ,99,150 ,100,150 ,101,150 ,102,150 ,103,150 ,104,150 ,105,150 ,106,150 ,107,150 ,108,150 ,109,150 ,118,150 ,119,150 ,120,150 ,121,150 ,122,150 ,123,150 ,124,150 ,125,150 ,126,150 ,127,150 ,128,150 ,129,150 ,130,150 ,131,150 ,132,150 ,133,150 ,134,150 ,135,150 ,136,150 ,137,150 ,138,150 ,139,150 ,140,150 ,141,150 ,142,150 ,143,150 ,144,150 ,145,150 ,146,150 ,147,150 ,148,150 ,149,150 ,150,150 ,151,150 ,152,150 ,153,150 ,162,150 ,163,150 ,164,150 ,165,150 ,166,150 ,167,150 ,168,150 ,169,150 ,170,150 ,171,150 ,172,150 ,173,150 ,174,304 ,175,304 ,176,304 ,177,304 ,178,150 ,179,150 ,},[156]={92,150 ,93,150 ,94,150 ,95,150 ,96,150 ,97,150 ,98,150 ,99,150 ,100,150 ,101,150 ,102,150 ,103,150 ,104,150 ,105,150 ,106,150 ,107,150 ,108,150 ,109,150 ,118,150 ,119,150 ,120,150 ,121,150 ,122,150 ,123,150 ,124,150 ,125,150 ,126,150 ,127,150 ,128,150 ,129,150 ,130,150 ,131,150 ,132,150 ,133,150 ,134,150 ,135,150 ,136,150 ,137,150 ,138,150 ,139,150 ,140,150 ,141,150 ,142,150 ,143,150 ,144,150 ,145,150 ,146,150 ,147,150 ,148,150 ,149,150 ,150,150 ,151,150 ,152,150 ,153,150 ,162,150 ,163,150 ,164,150 ,165,150 ,166,150 ,167,150 ,168,150 ,169,150 ,170,150 ,171,150 ,172,150 ,173,150 ,174,150 ,175,150 ,176,150 ,177,150 ,178,150 ,179,150 ,},[157]={92,150 ,93,150 ,94,150 ,95,150 ,96,150 ,97,150 ,98,150 ,99,150 ,100,150 ,101,150 ,102,150 ,103,150 ,104,150 ,105,150 ,106,150 ,107,150 ,108,150 ,109,150 ,118,150 ,119,150 ,120,150 ,121,150 ,122,150 ,123,150 ,124,150 ,125,150 ,126,150 ,127,150 ,128,150 ,129,150 ,130,150 ,131,150 ,132,150 ,133,150 ,134,150 ,135,150 ,136,150 ,137,150 ,138,150 ,139,150 ,140,150 ,141,150 ,142,150 ,143,150 ,144,150 ,145,150 ,146,150 ,147,150 ,148,150 ,149,150 ,150,150 ,151,150 ,152,150 ,153,150 ,162,150 ,163,150 ,164,150 ,165,150 ,166,150 ,167,150 ,168,150 ,169,150 ,170,150 ,171,150 ,172,150 ,173,150 ,174,150 ,175,150 ,176,150 ,177,150 ,178,150 ,179,150 ,},[158]={92,150 ,93,150 ,94,150 ,95,150 ,96,150 ,97,150 ,98,150 ,99,150 ,100,150 ,101,150 ,102,150 ,103,150 ,104,150 ,105,150 ,106,150 ,107,150 ,108,150 ,109,150 ,110,150 ,111,150 ,112,150 ,113,150 ,114,150 ,115,150 ,116,150 ,117,150 ,118,150 ,119,150 ,120,150 ,121,150 ,122,150 ,123,150 ,124,150 ,125,150 ,126,150 ,127,150 ,128,150 ,129,150 ,130,150 ,131,150 ,132,150 ,133,150 ,134,150 ,135,150 ,136,150 ,137,150 ,138,150 ,139,150 ,140,150 ,141,150 ,142,150 ,143,150 ,144,150 ,145,150 ,146,150 ,147,150 ,148,150 ,149,150 ,150,150 ,151,150 ,152,150 ,153,150 ,154,150 ,155,150 ,156,150 ,157,150 ,158,150 ,159,150 ,160,150 ,161,150 ,162,150 ,163,150 ,164,150 ,165,150 ,166,150 ,167,150 ,168,150 ,169,150 ,170,150 ,171,150 ,172,150 ,173,150 ,174,150 ,175,150 ,176,150 ,177,150 ,178,150 ,179,150 ,},[159]={92,150 ,93,150 ,94,150 ,95,150 ,96,150 ,97,150 ,98,150 ,99,150 ,100,150 ,101,150 ,102,150 ,103,150 ,104,150 ,105,150 ,106,150 ,107,150 ,108,150 ,109,150 ,110,150 ,111,150 ,112,150 ,113,150 ,114,150 ,115,150 ,116,150 ,117,150 ,118,150 ,119,150 ,120,150 ,121,150 ,122,150 ,123,150 ,124,150 ,125,150 ,126,150 ,127,150 ,128,150 ,129,150 ,130,150 ,131,150 ,132,150 ,133,150 ,134,150 ,135,150 ,136,150 ,137,150 ,138,150 ,139,150 ,140,150 ,141,150 ,142,150 ,143,150 ,144,150 ,145,150 ,146,150 ,147,150 ,148,150 ,149,150 ,150,150 ,151,150 ,152,150 ,153,150 ,154,150 ,155,150 ,156,150 ,157,150 ,158,150 ,159,150 ,160,150 ,161,150 ,162,150 ,163,150 ,164,150 ,165,150 ,166,150 ,167,150 ,168,150 ,169,150 ,170,150 ,171,150 ,172,150 ,173,150 ,174,150 ,175,150 ,176,150 ,177,150 ,178,150 ,179,150 ,},[160]={92,150 ,93,150 ,94,150 ,95,150 ,96,150 ,97,150 ,98,150 ,99,150 ,100,150 ,101,150 ,102,150 ,103,150 ,104,150 ,105,150 ,106,150 ,107,150 ,108,150 ,109,150 ,110,150 ,111,150 ,112,150 ,113,150 ,114,150 ,115,150 ,116,150 ,117,150 ,118,150 ,119,150 ,120,150 ,121,150 ,122,150 ,123,150 ,124,150 ,125,150 ,126,150 ,127,150 ,128,150 ,129,150 ,130,150 ,131,150 ,132,150 ,133,150 ,134,150 ,135,150 ,136,150 ,137,150 ,138,150 ,139,150 ,140,150 ,141,150 ,142,150 ,143,150 ,144,150 ,145,150 ,146,150 ,147,150 ,148,150 ,149,150 ,150,150 ,151,150 ,152,150 ,153,150 ,154,150 ,155,150 ,156,150 ,157,150 ,158,150 ,159,150 ,160,150 ,161,150 ,162,150 ,163,150 ,164,150 ,165,150 ,166,150 ,167,150 ,168,150 ,169,150 ,170,150 ,171,150 ,172,150 ,173,150 ,174,150 ,175,150 ,176,150 ,177,150 ,178,150 ,179,150 ,},[161]={92,150 ,93,150 ,94,150 ,95,150 ,96,150 ,97,150 ,98,150 ,99,150 ,100,150 ,101,150 ,102,150 ,103,150 ,104,150 ,105,150 ,106,150 ,107,150 ,108,150 ,109,150 ,110,150 ,111,150 ,112,150 ,113,150 ,114,150 ,115,150 ,116,150 ,117,150 ,118,150 ,119,150 ,120,150 ,121,150 ,122,150 ,123,150 ,124,150 ,125,150 ,126,150 ,127,150 ,128,150 ,129,150 ,130,150 ,131,150 ,132,150 ,133,150 ,134,150 ,135,150 ,136,150 ,137,150 ,138,150 ,139,150 ,140,150 ,141,150 ,142,150 ,143,150 ,144,150 ,145,150 ,146,150 ,147,150 ,148,150 ,149,150 ,150,150 ,151,150 ,152,150 ,153,150 ,154,150 ,155,150 ,156,150 ,157,150 ,158,150 ,159,150 ,160,150 ,161,150 ,162,150 ,163,150 ,164,150 ,165,150 ,166,150 ,167,150 ,168,150 ,169,150 ,170,150 ,171,150 ,172,150 ,173,150 ,174,150 ,175,150 ,176,150 ,177,150 ,178,150 ,179,150 ,},[162]={92,150 ,93,150 ,94,150 ,95,150 ,96,150 ,97,150 ,98,150 ,99,150 ,100,150 ,101,150 ,102,150 ,103,150 ,104,150 ,105,150 ,106,150 ,107,150 ,108,150 ,109,150 ,110,150 ,111,150 ,112,150 ,113,150 ,114,150 ,115,150 ,116,150 ,117,150 ,118,150 ,119,150 ,120,150 ,121,150 ,122,150 ,123,150 ,124,150 ,125,150 ,126,150 ,127,150 ,128,150 ,129,150 ,130,150 ,131,150 ,132,150 ,133,150 ,134,150 ,135,150 ,136,150 ,137,150 ,138,150 ,139,150 ,140,150 ,141,150 ,142,150 ,143,150 ,144,150 ,145,150 ,146,150 ,147,150 ,148,150 ,149,150 ,150,150 ,151,150 ,152,150 ,153,150 ,154,150 ,155,150 ,156,150 ,157,150 ,158,150 ,159,150 ,160,150 ,161,150 ,162,150 ,163,150 ,164,150 ,165,150 ,166,150 ,167,150 ,168,150 ,169,150 ,170,150 ,171,150 ,172,150 ,173,150 ,174,150 ,175,150 ,176,150 ,177,150 ,178,150 ,179,150 ,},[163]={92,150 ,93,150 ,94,150 ,95,150 ,96,150 ,97,150 ,98,150 ,99,150 ,100,150 ,101,150 ,102,150 ,103,150 ,104,150 ,105,150 ,106,150 ,107,150 ,108,150 ,109,150 ,110,150 ,111,150 ,112,150 ,113,150 ,114,150 ,115,150 ,116,150 ,117,150 ,118,150 ,119,150 ,120,150 ,121,150 ,122,150 ,123,150 ,124,150 ,125,150 ,126,150 ,127,150 ,128,150 ,129,150 ,130,150 ,131,150 ,132,150 ,133,150 ,134,150 ,135,150 ,136,150 ,137,150 ,138,150 ,139,150 ,140,150 ,141,150 ,142,150 ,143,150 ,144,150 ,145,150 ,146,150 ,147,150 ,148,150 ,149,150 ,150,150 ,151,150 ,152,150 ,153,150 ,154,150 ,155,150 ,156,150 ,157,150 ,158,150 ,159,150 ,160,150 ,161,150 ,162,150 ,163,150 ,164,150 ,165,150 ,166,150 ,167,150 ,168,150 ,169,150 ,170,150 ,171,150 ,172,150 ,173,150 ,174,150 ,175,150 ,176,150 ,177,150 ,178,150 ,179,150 ,},[164]={92,150 ,93,150 ,94,150 ,95,150 ,96,150 ,97,150 ,98,150 ,99,150 ,100,150 ,101,150 ,102,150 ,103,150 ,104,150 ,105,150 ,106,150 ,107,150 ,108,150 ,109,150 ,110,150 ,111,150 ,112,150 ,113,150 ,114,150 ,115,150 ,116,150 ,117,150 ,118,150 ,119,150 ,120,150 ,121,150 ,122,150 ,123,150 ,124,150 ,125,150 ,126,150 ,127,150 ,128,150 ,129,150 ,130,150 ,131,150 ,132,150 ,133,150 ,134,150 ,135,150 ,136,150 ,137,150 ,138,150 ,139,150 ,140,150 ,141,150 ,142,150 ,143,150 ,144,150 ,145,150 ,146,150 ,147,150 ,148,150 ,149,150 ,150,150 ,151,150 ,152,150 ,153,150 ,154,150 ,155,150 ,156,150 ,157,150 ,158,150 ,159,150 ,160,150 ,161,150 ,162,150 ,163,150 ,164,150 ,165,150 ,166,150 ,167,150 ,168,150 ,169,150 ,170,150 ,171,150 ,172,150 ,173,150 ,174,150 ,175,150 ,176,150 ,177,150 ,178,150 ,179,150 ,},[165]={92,150 ,93,150 ,94,150 ,95,150 ,96,150 ,97,150 ,98,150 ,99,150 ,100,150 ,101,150 ,102,150 ,103,150 ,104,150 ,105,150 ,106,150 ,107,150 ,108,150 ,109,150 ,110,150 ,111,150 ,112,150 ,113,150 ,114,150 ,115,150 ,116,150 ,117,150 ,118,150 ,119,150 ,120,150 ,121,150 ,122,150 ,123,150 ,124,150 ,125,150 ,126,150 ,127,150 ,128,150 ,129,150 ,130,150 ,131,150 ,132,150 ,133,150 ,134,150 ,135,150 ,136,150 ,137,150 ,138,150 ,139,150 ,140,150 ,141,150 ,142,150 ,143,150 ,144,150 ,145,150 ,146,150 ,147,150 ,148,150 ,149,150 ,150,150 ,151,150 ,152,150 ,153,150 ,154,150 ,155,150 ,156,150 ,157,150 ,158,150 ,159,150 ,160,150 ,161,150 ,162,150 ,163,150 ,164,150 ,165,150 ,166,150 ,167,150 ,168,150 ,169,150 ,170,150 ,171,150 ,172,150 ,173,150 ,174,150 ,175,150 ,176,150 ,177,150 ,178,150 ,179,150 ,},[166]={92,150 ,93,150 ,94,150 ,95,150 ,96,150 ,97,150 ,98,150 ,99,150 ,100,150 ,101,150 ,102,150 ,103,150 ,104,150 ,105,150 ,106,150 ,107,150 ,108,150 ,109,150 ,110,150 ,111,150 ,112,150 ,113,150 ,114,150 ,115,150 ,116,150 ,117,150 ,118,150 ,119,150 ,120,150 ,121,150 ,122,150 ,123,150 ,124,150 ,125,150 ,126,150 ,127,150 ,128,150 ,129,150 ,130,150 ,131,150 ,132,150 ,133,150 ,134,150 ,135,150 ,136,150 ,137,150 ,138,150 ,139,150 ,140,150 ,141,150 ,142,150 ,143,150 ,144,150 ,145,150 ,146,150 ,147,150 ,148,150 ,149,150 ,150,150 ,151,150 ,152,150 ,153,150 ,154,150 ,155,150 ,156,150 ,157,150 ,158,150 ,159,150 ,160,150 ,161,150 ,162,150 ,163,150 ,164,150 ,165,150 ,166,150 ,167,150 ,168,150 ,169,150 ,170,150 ,171,150 ,172,150 ,173,150 ,174,150 ,175,150 ,176,150 ,177,150 ,178,150 ,179,150 ,},[167]={92,150 ,93,150 ,94,150 ,95,150 ,96,150 ,97,150 ,98,150 ,99,150 ,100,150 ,101,150 ,102,150 ,103,150 ,104,150 ,105,150 ,106,150 ,107,150 ,108,150 ,109,150 ,110,150 ,111,150 ,112,150 ,113,150 ,114,150 ,115,150 ,116,150 ,117,150 ,118,150 ,119,150 ,120,150 ,121,150 ,122,150 ,123,150 ,124,150 ,125,150 ,126,150 ,127,150 ,128,150 ,129,150 ,130,150 ,131,150 ,132,150 ,133,150 ,134,150 ,135,150 ,136,150 ,137,150 ,138,150 ,139,150 ,140,150 ,141,150 ,142,150 ,143,150 ,144,150 ,145,150 ,146,150 ,147,150 ,148,150 ,149,150 ,150,150 ,151,150 ,152,150 ,153,150 ,154,150 ,155,150 ,156,150 ,157,150 ,158,150 ,159,150 ,160,150 ,161,150 ,162,150 ,163,150 ,164,150 ,165,150 ,166,150 ,167,150 ,168,150 ,169,150 ,170,150 ,171,150 ,172,150 ,173,150 ,174,150 ,175,150 ,176,150 ,177,150 ,178,150 ,179,150 ,},[168]={92,150 ,93,150 ,94,150 ,95,150 ,96,150 ,97,150 ,98,150 ,99,150 ,100,150 ,101,150 ,102,150 ,103,150 ,104,150 ,105,150 ,106,150 ,107,150 ,108,150 ,109,150 ,110,150 ,111,150 ,112,150 ,113,150 ,114,150 ,115,150 ,116,150 ,117,150 ,118,150 ,119,150 ,120,150 ,121,150 ,122,150 ,123,150 ,124,150 ,125,150 ,126,150 ,127,150 ,128,150 ,129,150 ,130,150 ,131,150 ,132,150 ,133,150 ,134,150 ,135,150 ,136,150 ,137,150 ,138,150 ,139,150 ,140,150 ,141,150 ,142,150 ,143,150 ,144,150 ,145,150 ,146,150 ,147,150 ,148,150 ,149,150 ,150,150 ,151,150 ,152,150 ,153,150 ,154,150 ,155,150 ,156,150 ,157,150 ,158,150 ,159,150 ,160,150 ,161,150 ,162,150 ,163,150 ,164,150 ,165,150 ,166,150 ,167,150 ,168,150 ,169,150 ,170,150 ,171,150 ,172,150 ,173,150 ,174,150 ,175,150 ,176,150 ,177,150 ,178,150 ,179,150 ,},[169]={92,150 ,93,150 ,94,150 ,95,150 ,96,150 ,97,150 ,98,150 ,99,150 ,100,150 ,101,150 ,102,150 ,103,150 ,104,150 ,105,150 ,106,150 ,107,150 ,108,150 ,109,150 ,110,150 ,111,150 ,112,150 ,113,150 ,114,150 ,115,150 ,116,150 ,117,150 ,118,150 ,119,150 ,120,150 ,121,150 ,122,150 ,123,150 ,124,150 ,125,150 ,126,150 ,127,150 ,128,150 ,129,150 ,130,150 ,131,150 ,132,150 ,133,150 ,134,150 ,135,150 ,136,150 ,137,150 ,138,150 ,139,150 ,140,150 ,141,150 ,142,150 ,143,150 ,144,150 ,145,150 ,146,150 ,147,150 ,148,150 ,149,150 ,150,150 ,151,150 ,152,150 ,153,150 ,154,150 ,155,150 ,156,150 ,157,150 ,158,150 ,159,150 ,160,150 ,161,150 ,162,150 ,163,150 ,164,150 ,165,150 ,166,150 ,167,150 ,168,150 ,169,150 ,170,150 ,171,150 ,172,150 ,173,150 ,174,150 ,175,150 ,176,150 ,177,150 ,178,150 ,179,150 ,},[170]={92,150 ,93,150 ,94,150 ,95,150 ,96,150 ,97,150 ,98,150 ,99,150 ,100,150 ,101,150 ,102,150 ,103,150 ,104,150 ,105,150 ,106,150 ,107,150 ,108,150 ,109,150 ,110,150 ,111,150 ,112,304 ,113,304 ,114,304 ,115,304 ,116,150 ,117,150 ,118,150 ,119,150 ,120,150 ,121,150 ,122,150 ,123,150 ,124,150 ,125,150 ,126,150 ,127,150 ,128,150 ,129,150 ,130,150 ,131,150 ,132,150 ,133,150 ,134,150 ,135,150 ,136,150 ,137,150 ,138,150 ,139,150 ,140,150 ,141,150 ,142,150 ,143,150 ,144,150 ,145,150 ,146,150 ,147,150 ,148,150 ,149,150 ,150,150 ,151,150 ,152,150 ,153,150 ,154,150 ,155,150 ,156,304 ,157,304 ,158,304 ,159,304 ,160,150 ,161,150 ,162,150 ,163,150 ,164,150 ,165,150 ,166,150 ,167,150 ,168,150 ,169,150 ,170,150 ,171,150 ,172,150 ,173,150 ,174,150 ,175,150 ,176,150 ,177,150 ,178,150 ,179,150 ,},[171]={92,150 ,93,150 ,94,150 ,95,150 ,96,150 ,97,150 ,98,150 ,99,150 ,100,150 ,101,150 ,102,150 ,103,150 ,104,150 ,105,150 ,106,150 ,107,150 ,108,150 ,109,150 ,110,150 ,111,150 ,112,304 ,113,304 ,114,304 ,115,304 ,116,150 ,117,150 ,118,150 ,119,150 ,120,150 ,121,150 ,122,150 ,123,150 ,124,150 ,125,150 ,126,150 ,127,150 ,128,150 ,129,150 ,130,150 ,131,150 ,132,150 ,133,150 ,134,150 ,135,150 ,136,150 ,137,150 ,138,150 ,139,150 ,140,150 ,141,150 ,142,150 ,143,150 ,144,150 ,145,150 ,146,150 ,147,150 ,148,150 ,149,150 ,150,150 ,151,150 ,152,150 ,153,150 ,154,150 ,155,150 ,156,304 ,157,304 ,158,304 ,159,304 ,160,150 ,161,150 ,162,150 ,163,150 ,164,150 ,165,150 ,166,150 ,167,150 ,168,150 ,169,150 ,170,150 ,171,150 ,172,150 ,173,150 ,174,150 ,175,150 ,176,150 ,177,150 ,178,150 ,179,150 ,},[172]={92,150 ,93,150 ,94,150 ,95,150 ,96,150 ,97,150 ,98,150 ,99,150 ,100,150 ,101,150 ,102,150 ,103,150 ,104,150 ,105,150 ,106,150 ,107,150 ,108,150 ,109,150 ,110,150 ,111,150 ,112,304 ,113,304 ,114,304 ,115,304 ,116,150 ,117,150 ,118,150 ,119,150 ,120,150 ,121,150 ,122,150 ,123,150 ,124,150 ,125,150 ,126,150 ,127,150 ,128,150 ,129,150 ,130,150 ,131,150 ,132,150 ,133,150 ,134,150 ,135,150 ,136,150 ,137,150 ,138,150 ,139,150 ,140,150 ,141,150 ,142,150 ,143,150 ,144,150 ,145,150 ,146,150 ,147,150 ,148,150 ,149,150 ,150,150 ,151,150 ,152,150 ,153,150 ,154,150 ,155,150 ,156,304 ,157,304 ,158,304 ,159,304 ,160,150 ,161,150 ,162,150 ,163,150 ,164,150 ,165,150 ,166,150 ,167,150 ,168,150 ,169,150 ,170,150 ,171,150 ,172,150 ,173,150 ,174,150 ,175,150 ,176,150 ,177,150 ,178,150 ,179,150 ,},[173]={92,150 ,93,150 ,94,150 ,95,150 ,96,150 ,97,150 ,98,150 ,99,150 ,100,150 ,101,150 ,102,150 ,103,150 ,104,150 ,105,150 ,106,150 ,107,150 ,108,150 ,109,150 ,110,150 ,111,150 ,112,304 ,113,304 ,114,304 ,115,304 ,116,150 ,117,150 ,118,150 ,119,150 ,120,150 ,121,150 ,122,150 ,123,150 ,124,150 ,125,150 ,126,150 ,127,150 ,128,150 ,129,150 ,130,150 ,131,150 ,132,150 ,133,150 ,134,150 ,135,150 ,136,150 ,137,150 ,138,150 ,139,150 ,140,150 ,141,150 ,142,150 ,143,150 ,144,150 ,145,150 ,146,150 ,147,150 ,148,150 ,149,150 ,150,150 ,151,150 ,152,150 ,153,150 ,154,150 ,155,150 ,156,304 ,157,304 ,158,304 ,159,304 ,160,150 ,161,150 ,162,150 ,163,150 ,164,150 ,165,150 ,166,150 ,167,150 ,168,150 ,169,150 ,170,150 ,171,150 ,172,150 ,173,150 ,174,150 ,175,150 ,176,150 ,177,150 ,178,150 ,179,150 ,},[174]={92,150 ,93,150 ,94,150 ,95,150 ,96,150 ,97,150 ,98,150 ,99,150 ,100,150 ,101,150 ,102,150 ,103,150 ,104,150 ,105,150 ,106,150 ,107,150 ,108,150 ,109,150 ,110,150 ,111,150 ,112,150 ,113,150 ,114,150 ,115,150 ,116,150 ,117,150 ,118,150 ,119,150 ,120,150 ,121,150 ,122,150 ,123,150 ,124,150 ,125,150 ,126,150 ,127,150 ,128,150 ,129,150 ,130,150 ,131,150 ,132,150 ,133,150 ,134,150 ,135,150 ,136,150 ,137,150 ,138,150 ,139,150 ,140,150 ,141,150 ,142,150 ,143,150 ,144,150 ,145,150 ,146,150 ,147,150 ,148,150 ,149,150 ,150,150 ,151,150 ,152,150 ,153,150 ,154,150 ,155,150 ,156,150 ,157,150 ,158,150 ,159,150 ,160,150 ,161,150 ,162,150 ,163,150 ,164,150 ,165,150 ,166,150 ,167,150 ,168,150 ,169,150 ,170,150 ,171,150 ,172,150 ,173,150 ,174,150 ,175,150 ,176,150 ,177,150 ,178,150 ,179,150 ,},[175]={92,150 ,93,150 ,94,150 ,95,150 ,96,150 ,97,150 ,98,150 ,99,150 ,100,150 ,101,150 ,102,150 ,103,150 ,104,150 ,105,150 ,106,150 ,107,150 ,108,150 ,109,150 ,110,150 ,111,150 ,112,150 ,113,150 ,114,150 ,115,150 ,116,150 ,117,150 ,118,150 ,119,150 ,120,150 ,121,150 ,122,150 ,123,150 ,124,150 ,125,150 ,126,150 ,127,150 ,128,150 ,129,150 ,130,150 ,131,150 ,132,150 ,133,150 ,134,150 ,135,150 ,136,150 ,137,150 ,138,150 ,139,150 ,140,150 ,141,150 ,142,150 ,143,150 ,144,150 ,145,150 ,146,150 ,147,150 ,148,150 ,149,150 ,150,150 ,151,150 ,152,150 ,153,150 ,154,150 ,155,150 ,156,150 ,157,150 ,158,150 ,159,150 ,160,150 ,161,150 ,162,150 ,163,150 ,164,150 ,165,150 ,166,150 ,167,150 ,168,150 ,169,150 ,170,150 ,171,150 ,172,150 ,173,150 ,174,150 ,175,150 ,176,150 ,177,150 ,178,150 ,179,150 ,}
		},
		
		markers ={
			92, 96, 168, 96, 168, 172, 92, 172, 130, 96, 168, 134, 130, 172, 92, 134, 130, 134, 108, 94, 152, 94, 170, 112, 170, 156, 152, 174, 108, 174, 90, 156, 90, 112, 122, 118, 138, 118, 146, 126, 146, 142, 138, 150, 122, 150, 114, 142, 114, 126, 116, 104, 100, 120, 144, 104, 160, 120, 160, 148, 144, 164, 116, 164, 100, 148, 0, 0
		},
		
		shaman_positions = {
			92, 96, 168, 96, 168, 172, 92, 172, 130, 96, 168, 134, 130, 172, 92, 134
		},
		
		scripts = {
			OnTurn = function(everySecond1, everySecond2, everySecond4) 			potionbattle_on_turn(everySecond1, everySecond2, everySecond4) end,
			OnFrame = function(ghover) 												return potionbattle_on_frame(ghover) end,
			OnCreateThing = function(t, owner, type, model) 						potionbattle_on_create_thing(t, owner, type, model) end,
			OnShamanDeath = function(victim, killer, killer_was_ally)				PB_on_shaman_dead(victim, killer, killer_was_ally) end,
			OnHumanDisconnect = function(player) 									PB_init_single_AI(player) end,
			OnMouseUp = function(left)												PB_on_mouse_up(left) end,
			OnMouseUpMultiplayer = function(from, str)								PB_on_mouse_up_multiplayer(from, str) end,
		},
		
	},

	[MAP_SHIFTING_SANDS]={
	
		info = 	{ 	name = "Shifting Sands", author = "Ralimurr",
					desc = "It's time to put the pedal to the metal, and kill as many opposing shamans as possible. <br> Duel enemies with blasts, but beware the ever shifting sands - and remember, blasting a tree will be your doom.",
					map_objectives = { {value=6, step=1, default=true}, {value=30, step=5, default=false}, {} },
					image = 3200, texture={5,4}, zoom={0,228,0}, drop_infos = true,	marker_lb={130,130}, reinc_timer=12, shield_respawn=true,
					custom_rules = {
						{ default = false, 	name = "More trees", desc = "More trees spawn and at faster rates! Dangerous stuff..." },
					}
				},
	
		land ={
			[0]={0,248,1,248,2,220,3,220,4,174,5,174,6,121,7,121,8,110,9,110,10,72,11,72,12,108,13,108,14,108,15,108,16,90,17,90,18,90,19,90,20,90,21,90,22,123,23,123,24,205,25,205,26,243,27,243,28,238,29,238,30,235,31,235,32,233,33,233,34,201,35,201,36,146,37,146,38,80,39,80,216,54,217,54,218,137,219,137,220,176,221,176,222,207,223,207,224,222,225,222,226,231,227,231,228,234,229,234,230,227,231,227,232,185,233,185,234,100,235,100,236,54,237,54,238,81,239,81,240,81,241,81,242,63,243,63,244,45,245,45,246,64,247,64,248,122,249,122,250,204,251,204,252,221,253,221,254,238,255,238,},[1]={0,248,1,248,2,220,3,220,4,174,5,174,6,121,7,121,8,110,9,110,10,72,11,72,12,108,13,108,14,108,15,108,16,90,17,90,18,90,19,90,20,90,21,90,22,123,23,123,24,205,25,205,26,243,27,243,28,238,29,238,30,235,31,235,32,233,33,233,34,201,35,201,36,146,37,146,38,80,39,80,216,54,217,54,218,137,219,137,220,176,221,176,222,207,223,207,224,222,225,222,226,231,227,231,228,234,229,234,230,227,231,227,232,185,233,185,234,100,235,100,236,54,237,54,238,81,239,81,240,81,241,81,242,63,243,63,244,45,245,45,246,64,247,64,248,122,249,122,250,204,251,204,252,221,253,221,254,238,255,238,},[2]={0,226,1,226,2,201,3,201,4,157,5,157,6,121,7,121,8,99,9,99,10,72,11,72,12,108,13,108,14,108,15,108,16,90,17,90,18,90,19,90,20,90,21,90,22,101,23,101,24,219,25,219,26,250,27,250,28,246,29,246,30,248,31,248,32,247,33,247,34,214,35,214,36,154,37,154,38,89,39,89,216,63,217,63,218,95,219,95,220,156,221,156,222,200,223,200,224,240,225,240,226,253,227,253,228,234,229,234,230,221,231,221,232,177,233,177,234,100,235,100,236,54,237,54,238,81,239,81,240,81,241,81,242,63,243,63,244,45,245,45,246,64,247,64,248,118,249,118,250,184,251,184,252,220,253,220,254,236,255,236,},[3]={0,226,1,226,2,201,3,201,4,157,5,157,6,121,7,121,8,99,9,99,10,72,11,72,12,108,13,108,14,108,15,108,16,90,17,90,18,90,19,90,20,90,21,90,22,101,23,101,24,219,25,219,26,250,27,250,28,246,29,246,30,248,31,248,32,247,33,247,34,214,35,214,36,154,37,154,38,89,39,89,216,63,217,63,218,95,219,95,220,156,221,156,222,200,223,200,224,240,225,240,226,253,227,253,228,234,229,234,230,221,231,221,232,177,233,177,234,100,235,100,236,54,237,54,238,81,239,81,240,81,241,81,242,63,243,63,244,45,245,45,246,64,247,64,248,118,249,118,250,184,251,184,252,220,253,220,254,236,255,236,},[4]={0,195,1,195,2,175,3,175,4,137,5,137,6,121,7,121,8,72,9,72,10,72,11,72,12,108,13,108,14,108,15,108,16,90,17,90,18,90,19,90,20,90,21,90,22,108,23,108,24,207,25,207,26,237,27,237,28,246,29,246,30,251,31,251,32,254,33,254,34,209,35,209,36,148,37,148,38,84,39,84,216,71,217,71,218,86,219,86,220,141,221,141,222,188,223,188,224,248,225,248,226,262,227,262,228,230,229,230,230,199,231,199,232,154,233,154,234,99,235,99,236,54,237,54,238,81,239,81,240,81,241,81,242,63,243,63,244,45,245,45,246,64,247,64,248,116,249,116,250,152,251,152,252,182,253,182,254,199,255,199,},[5]={0,195,1,195,2,175,3,175,4,137,5,137,6,121,7,121,8,72,9,72,10,72,11,72,12,108,13,108,14,108,15,108,16,90,17,90,18,90,19,90,20,90,21,90,22,108,23,108,24,207,25,207,26,237,27,237,28,246,29,246,30,251,31,251,32,254,33,254,34,209,35,209,36,148,37,148,38,84,39,84,216,71,217,71,218,86,219,86,220,141,221,141,222,188,223,188,224,248,225,248,226,262,227,262,228,230,229,230,230,199,231,199,232,154,233,154,234,99,235,99,236,54,237,54,238,81,239,81,240,81,241,81,242,63,243,63,244,45,245,45,246,64,247,64,248,116,249,116,250,152,251,152,252,182,253,182,254,199,255,199,},[6]={0,149,1,149,2,133,3,133,4,103,5,103,6,65,7,65,8,18,9,18,20,107,21,107,22,122,23,122,24,181,25,181,26,210,27,210,28,240,29,240,30,269,31,269,32,253,33,253,34,192,35,192,36,96,37,96,38,72,39,72,216,65,217,65,218,77,219,77,220,129,221,129,222,171,223,171,224,199,225,199,226,220,227,220,228,207,229,207,230,171,231,171,232,129,233,129,234,66,235,66,236,9,237,9,246,42,247,42,248,92,249,92,250,116,251,116,252,136,253,136,254,151,255,151,},[7]={0,149,1,149,2,133,3,133,4,103,5,103,6,65,7,65,8,18,9,18,20,107,21,107,22,122,23,122,24,181,25,181,26,210,27,210,28,240,29,240,30,269,31,269,32,253,33,253,34,192,35,192,36,96,37,96,38,72,39,72,216,65,217,65,218,77,219,77,220,129,221,129,222,171,223,171,224,199,225,199,226,220,227,220,228,207,229,207,230,171,231,171,232,129,233,129,234,66,235,66,236,9,237,9,246,42,247,42,248,92,249,92,250,116,251,116,252,136,253,136,254,151,255,151,},[8]={0,106,1,106,2,103,3,103,4,71,5,71,6,36,7,36,8,18,9,18,20,101,21,101,22,113,23,113,24,132,25,132,26,180,27,180,28,210,29,210,30,217,31,217,32,205,33,205,34,171,35,171,36,135,37,135,38,93,39,93,216,54,217,54,218,99,219,99,220,128,221,128,222,128,223,128,224,132,225,132,226,151,227,151,228,148,229,148,230,135,231,135,232,101,233,101,234,101,235,101,236,9,237,9,246,36,247,36,248,67,249,67,250,75,251,75,252,85,253,85,254,94,255,94,},[9]={0,106,1,106,2,103,3,103,4,71,5,71,6,36,7,36,8,18,9,18,20,101,21,101,22,113,23,113,24,132,25,132,26,180,27,180,28,210,29,210,30,217,31,217,32,205,33,205,34,171,35,171,36,135,37,135,38,93,39,93,216,54,217,54,218,99,219,99,220,128,221,128,222,128,223,128,224,132,225,132,226,151,227,151,228,148,229,148,230,135,231,135,232,101,233,101,234,101,235,101,236,9,237,9,246,36,247,36,248,67,249,67,250,75,251,75,252,85,253,85,254,94,255,94,},[10]={0,42,1,42,2,38,3,38,4,31,5,31,6,18,7,18,20,90,21,90,22,108,23,108,24,126,25,126,26,174,27,174,28,174,29,174,30,162,31,162,32,174,33,174,34,174,35,174,36,135,37,135,38,89,39,89,216,1,217,1,218,54,219,54,220,72,221,72,222,101,223,101,224,101,225,101,226,101,227,101,228,101,229,101,230,101,231,101,232,101,233,101,234,72,235,72,236,9,237,9,248,36,249,36,250,36,251,36,252,36,253,36,254,39,255,39,},[11]={0,42,1,42,2,38,3,38,4,31,5,31,6,18,7,18,20,90,21,90,22,108,23,108,24,126,25,126,26,174,27,174,28,174,29,174,30,162,31,162,32,174,33,174,34,174,35,174,36,135,37,135,38,89,39,89,216,1,217,1,218,54,219,54,220,72,221,72,222,101,223,101,224,101,225,101,226,101,227,101,228,101,229,101,230,101,231,101,232,101,233,101,234,72,235,72,236,9,237,9,248,36,249,36,250,36,251,36,252,36,253,36,254,39,255,39,},[12]={0,18,1,18,2,18,3,18,4,18,5,18,20,147,21,147,22,147,23,147,24,147,25,147,26,147,27,147,28,147,29,147,30,147,31,147,32,147,33,147,34,147,35,147,36,108,37,108,38,72,39,72,216,1,217,1,218,54,219,54,220,72,221,72,222,101,223,101,224,101,225,101,226,101,227,101,228,101,229,101,230,101,231,101,232,101,233,101,234,90,235,90,236,9,237,9,252,18,253,18,254,18,255,18,},[13]={0,18,1,18,2,18,3,18,4,18,5,18,20,147,21,147,22,147,23,147,24,147,25,147,26,147,27,147,28,147,29,147,30,147,31,147,32,147,33,147,34,147,35,147,36,108,37,108,38,72,39,72,216,1,217,1,218,54,219,54,220,72,221,72,222,101,223,101,224,101,225,101,226,101,227,101,228,101,229,101,230,101,231,101,232,101,233,101,234,90,235,90,236,9,237,9,252,18,253,18,254,18,255,18,},[14]={0,18,1,18,2,18,3,18,4,18,5,18,20,126,21,126,22,126,23,126,24,135,25,135,26,147,27,147,28,147,29,147,30,147,31,147,32,147,33,147,34,147,35,147,36,108,37,108,38,72,39,72,214,99,215,99,216,99,217,99,218,101,219,101,220,101,221,101,222,101,223,101,224,101,225,101,226,101,227,101,228,101,229,101,230,101,231,101,232,101,233,101,234,90,235,90,236,9,237,9,252,18,253,18,254,18,255,18,},[15]={0,18,1,18,2,18,3,18,4,18,5,18,20,126,21,126,22,126,23,126,24,135,25,135,26,147,27,147,28,147,29,147,30,147,31,147,32,147,33,147,34,147,35,147,36,108,37,108,38,72,39,72,214,99,215,99,216,99,217,99,218,101,219,101,220,101,221,101,222,101,223,101,224,101,225,101,226,101,227,101,228,101,229,101,230,101,231,101,232,101,233,101,234,90,235,90,236,9,237,9,252,18,253,18,254,18,255,18,},[16]={0,36,1,36,2,36,3,36,4,36,5,36,20,135,21,135,22,135,23,135,24,135,25,135,26,135,27,135,28,135,29,135,30,135,31,135,32,135,33,135,34,135,35,135,36,135,37,135,38,135,39,135,40,135,41,135,42,135,43,135,214,99,215,99,216,99,217,99,218,101,219,101,220,101,221,101,222,101,223,101,224,101,225,101,226,101,227,101,228,101,229,101,230,101,231,101,232,101,233,101,234,101,235,101,236,63,237,63,252,36,253,36,254,36,255,36,},[17]={0,36,1,36,2,36,3,36,4,36,5,36,20,135,21,135,22,135,23,135,24,135,25,135,26,135,27,135,28,135,29,135,30,135,31,135,32,135,33,135,34,135,35,135,36,135,37,135,38,135,39,135,40,135,41,135,42,135,43,135,214,99,215,99,216,99,217,99,218,101,219,101,220,101,221,101,222,101,223,101,224,101,225,101,226,101,227,101,228,101,229,101,230,101,231,101,232,101,233,101,234,101,235,101,236,63,237,63,252,36,253,36,254,36,255,36,},[18]={0,36,1,36,2,36,3,36,4,36,5,36,18,108,19,108,20,129,21,129,22,135,23,135,24,135,25,135,26,135,27,135,28,135,29,135,30,99,31,99,32,99,33,99,34,135,35,135,36,135,37,135,38,135,39,135,40,135,41,135,42,135,43,135,210,99,211,99,212,99,213,99,214,99,215,99,216,99,217,99,218,99,219,99,220,99,221,99,222,101,223,101,224,72,225,72,226,90,227,90,228,101,229,101,230,101,231,101,232,81,233,81,234,81,235,81,236,63,237,63,252,36,253,36,254,36,255,36,},[19]={0,36,1,36,2,36,3,36,4,36,5,36,18,108,19,108,20,129,21,129,22,135,23,135,24,135,25,135,26,135,27,135,28,135,29,135,30,99,31,99,32,99,33,99,34,135,35,135,36,135,37,135,38,135,39,135,40,135,41,135,42,135,43,135,210,99,211,99,212,99,213,99,214,99,215,99,216,99,217,99,218,99,219,99,220,99,221,99,222,101,223,101,224,72,225,72,226,90,227,90,228,101,229,101,230,101,231,101,232,81,233,81,234,81,235,81,236,63,237,63,252,36,253,36,254,36,255,36,},[20]={0,36,1,36,2,36,3,36,4,63,5,63,6,36,7,36,8,63,9,63,10,99,11,99,12,99,13,99,14,72,15,72,16,144,17,144,18,133,19,133,20,131,21,131,22,135,23,135,24,135,25,135,26,135,27,135,28,135,29,135,30,99,31,99,32,99,33,99,34,135,35,135,36,135,37,135,38,135,39,135,40,135,41,135,42,135,43,135,44,135,45,135,46,135,47,135,210,99,211,99,212,99,213,99,214,99,215,99,216,99,217,99,218,99,219,99,220,99,221,99,222,99,223,99,224,1,225,1,226,18,227,18,228,81,229,81,230,81,231,81,232,99,233,99,234,99,235,99,236,81,237,81,238,81,239,81,240,81,241,81,242,72,243,72,244,72,245,72,246,72,247,72,248,72,249,72,250,72,251,72,252,36,253,36,254,36,255,36,},[21]={0,36,1,36,2,36,3,36,4,63,5,63,6,36,7,36,8,63,9,63,10,99,11,99,12,99,13,99,14,72,15,72,16,144,17,144,18,133,19,133,20,131,21,131,22,135,23,135,24,135,25,135,26,135,27,135,28,135,29,135,30,99,31,99,32,99,33,99,34,135,35,135,36,135,37,135,38,135,39,135,40,135,41,135,42,135,43,135,44,135,45,135,46,135,47,135,210,99,211,99,212,99,213,99,214,99,215,99,216,99,217,99,218,99,219,99,220,99,221,99,222,99,223,99,224,1,225,1,226,18,227,18,228,81,229,81,230,81,231,81,232,99,233,99,234,99,235,99,236,81,237,81,238,81,239,81,240,81,241,81,242,72,243,72,244,72,245,72,246,72,247,72,248,72,249,72,250,72,251,72,252,36,253,36,254,36,255,36,},[22]={0,101,1,101,2,70,3,70,4,96,5,96,6,97,7,97,8,104,9,104,10,117,11,117,12,144,13,144,14,99,15,99,16,144,17,144,18,144,19,144,20,135,21,135,22,135,23,135,24,135,25,135,26,72,27,72,28,72,29,72,30,1,31,1,32,1,33,1,34,135,35,135,36,135,37,135,38,135,39,135,40,135,41,135,42,135,43,135,44,135,45,135,46,135,47,135,206,99,207,99,208,99,209,99,210,99,211,99,212,99,213,99,214,99,215,99,216,99,217,99,218,99,219,99,220,99,221,99,222,99,223,99,224,1,225,1,226,1,227,1,228,63,229,63,230,63,231,63,232,81,233,81,234,81,235,81,236,81,237,81,238,81,239,81,240,90,241,90,242,108,243,108,244,123,245,123,246,123,247,123,248,123,249,123,250,102,251,102,252,99,253,99,254,101,255,101,},[23]={0,101,1,101,2,70,3,70,4,96,5,96,6,97,7,97,8,104,9,104,10,117,11,117,12,144,13,144,14,99,15,99,16,144,17,144,18,144,19,144,20,135,21,135,22,135,23,135,24,135,25,135,26,72,27,72,28,72,29,72,30,1,31,1,32,1,33,1,34,135,35,135,36,135,37,135,38,135,39,135,40,135,41,135,42,135,43,135,44,135,45,135,46,135,47,135,206,99,207,99,208,99,209,99,210,99,211,99,212,99,213,99,214,99,215,99,216,99,217,99,218,99,219,99,220,99,221,99,222,99,223,99,224,1,225,1,226,1,227,1,228,63,229,63,230,63,231,63,232,81,233,81,234,81,235,81,236,81,237,81,238,81,239,81,240,90,241,90,242,108,243,108,244,123,245,123,246,123,247,123,248,123,249,123,250,102,251,102,252,99,253,99,254,101,255,101,},[24]={0,174,1,174,2,173,3,173,4,154,5,154,6,148,7,148,8,143,9,143,10,156,11,156,12,156,13,156,14,144,15,144,16,144,17,144,18,144,19,144,20,135,21,135,22,135,23,135,24,135,25,135,26,72,27,72,28,72,29,72,30,1,31,1,32,1,33,1,34,135,35,135,36,135,37,135,38,135,39,135,40,135,41,135,42,135,43,135,44,135,45,135,46,135,47,135,48,126,49,126,50,126,51,126,206,99,207,99,208,99,209,99,210,99,211,99,212,99,213,99,214,99,215,99,216,99,217,99,218,99,219,99,228,63,229,63,230,63,231,63,232,81,233,81,234,81,235,81,236,81,237,81,238,90,239,90,240,90,241,90,242,123,243,123,244,123,245,123,246,123,247,123,248,123,249,123,250,130,251,130,252,146,253,146,254,170,255,170,},[25]={0,174,1,174,2,173,3,173,4,154,5,154,6,148,7,148,8,143,9,143,10,156,11,156,12,156,13,156,14,144,15,144,16,144,17,144,18,144,19,144,20,135,21,135,22,135,23,135,24,135,25,135,26,72,27,72,28,72,29,72,30,1,31,1,32,1,33,1,34,135,35,135,36,135,37,135,38,135,39,135,40,135,41,135,42,135,43,135,44,135,45,135,46,135,47,135,48,126,49,126,50,126,51,126,206,99,207,99,208,99,209,99,210,99,211,99,212,99,213,99,214,99,215,99,216,99,217,99,218,99,219,99,228,63,229,63,230,63,231,63,232,81,233,81,234,81,235,81,236,81,237,81,238,90,239,90,240,90,241,90,242,123,243,123,244,123,245,123,246,123,247,123,248,123,249,123,250,130,251,130,252,146,253,146,254,170,255,170,},[26]={0,226,1,226,2,221,3,221,4,211,5,211,6,200,7,200,8,176,9,176,10,156,11,156,12,156,13,156,14,144,15,144,16,144,17,144,18,144,19,144,20,117,21,117,22,90,23,90,24,90,25,90,38,135,39,135,40,135,41,135,42,135,43,135,44,135,45,135,46,135,47,135,48,126,49,126,50,126,51,126,206,99,207,99,208,99,209,99,210,99,211,99,212,99,213,99,214,99,215,99,216,99,217,99,218,99,219,99,232,81,233,81,234,81,235,81,236,81,237,81,238,90,239,90,240,90,241,90,242,123,243,123,244,123,245,123,246,123,247,123,248,123,249,123,250,146,251,146,252,185,253,185,254,219,255,219,},[27]={0,226,1,226,2,221,3,221,4,211,5,211,6,200,7,200,8,176,9,176,10,156,11,156,12,156,13,156,14,144,15,144,16,144,17,144,18,144,19,144,20,117,21,117,22,90,23,90,24,90,25,90,38,135,39,135,40,135,41,135,42,135,43,135,44,135,45,135,46,135,47,135,48,126,49,126,50,126,51,126,206,99,207,99,208,99,209,99,210,99,211,99,212,99,213,99,214,99,215,99,216,99,217,99,218,99,219,99,232,81,233,81,234,81,235,81,236,81,237,81,238,90,239,90,240,90,241,90,242,123,243,123,244,123,245,123,246,123,247,123,248,123,249,123,250,146,251,146,252,185,253,185,254,219,255,219,},[28]={0,267,1,267,2,272,3,272,4,249,5,249,6,230,7,230,8,196,9,196,10,156,11,156,12,156,13,156,14,144,15,144,16,144,17,144,18,144,19,144,20,117,21,117,22,90,23,90,24,90,25,90,38,135,39,135,40,135,41,135,42,135,43,135,44,135,45,135,46,135,47,135,48,126,49,126,50,126,51,126,206,99,207,99,208,99,209,99,210,99,211,99,212,99,213,99,214,99,215,99,232,81,233,81,234,81,235,81,236,81,237,81,238,90,239,90,240,90,241,90,242,123,243,123,244,123,245,123,246,123,247,123,248,103,249,103,250,154,251,154,252,195,253,195,254,222,255,222,},[29]={0,267,1,267,2,272,3,272,4,249,5,249,6,230,7,230,8,196,9,196,10,156,11,156,12,156,13,156,14,144,15,144,16,144,17,144,18,144,19,144,20,117,21,117,22,90,23,90,24,90,25,90,38,135,39,135,40,135,41,135,42,135,43,135,44,135,45,135,46,135,47,135,48,126,49,126,50,126,51,126,206,99,207,99,208,99,209,99,210,99,211,99,212,99,213,99,214,99,215,99,232,81,233,81,234,81,235,81,236,81,237,81,238,90,239,90,240,90,241,90,242,123,243,123,244,123,245,123,246,123,247,123,248,103,249,103,250,154,251,154,252,195,253,195,254,222,255,222,},[30]={0,272,1,272,2,317,3,317,4,272,5,272,6,228,7,228,8,193,9,193,10,156,11,156,12,156,13,156,14,153,15,153,16,153,17,153,18,144,19,144,20,63,21,63,22,1,23,1,24,1,25,1,42,126,43,126,44,126,45,126,46,126,47,126,48,126,49,126,50,126,51,126,206,99,207,99,208,99,209,99,210,99,211,99,212,99,213,99,214,99,215,99,234,1,235,1,236,1,237,1,238,72,239,72,240,119,241,119,242,119,243,119,244,137,245,137,246,128,247,128,248,99,249,99,250,147,251,147,252,177,253,177,254,215,255,215,},[31]={0,272,1,272,2,317,3,317,4,272,5,272,6,228,7,228,8,193,9,193,10,156,11,156,12,156,13,156,14,153,15,153,16,153,17,153,18,144,19,144,20,63,21,63,22,1,23,1,24,1,25,1,42,126,43,126,44,126,45,126,46,126,47,126,48,126,49,126,50,126,51,126,206,99,207,99,208,99,209,99,210,99,211,99,212,99,213,99,214,99,215,99,234,1,235,1,236,1,237,1,238,72,239,72,240,119,241,119,242,119,243,119,244,137,245,137,246,128,247,128,248,99,249,99,250,147,251,147,252,177,253,177,254,215,255,215,},[32]={0,228,1,228,2,235,3,235,4,246,5,246,6,209,7,209,8,153,9,153,10,153,11,153,12,153,13,153,14,153,15,153,16,153,17,153,18,117,19,117,20,36,21,36,22,1,23,1,24,1,25,1,42,126,43,126,44,126,45,126,46,126,47,126,48,126,49,126,50,126,51,126,234,1,235,1,236,1,237,1,238,72,239,72,240,99,241,99,242,99,243,99,244,99,245,99,246,99,247,99,248,99,249,99,250,102,251,102,252,163,253,163,254,199,255,199,},[33]={0,228,1,228,2,235,3,235,4,246,5,246,6,209,7,209,8,153,9,153,10,153,11,153,12,153,13,153,14,153,15,153,16,153,17,153,18,117,19,117,20,36,21,36,22,1,23,1,24,1,25,1,42,126,43,126,44,126,45,126,46,126,47,126,48,126,49,126,50,126,51,126,234,1,235,1,236,1,237,1,238,72,239,72,240,99,241,99,242,99,243,99,244,99,245,99,246,99,247,99,248,99,249,99,250,102,251,102,252,163,253,163,254,199,255,199,},[34]={0,175,1,175,2,175,3,175,4,181,5,181,6,163,7,163,8,153,9,153,10,153,11,153,12,153,13,153,14,153,15,153,16,153,17,153,18,135,19,135,20,108,21,108,22,108,23,108,24,108,25,108,234,81,235,81,236,81,237,81,238,99,239,99,240,119,241,119,242,119,243,119,244,64,245,64,246,107,247,107,248,99,249,99,250,99,251,99,252,146,253,146,254,174,255,174,},[35]={0,175,1,175,2,175,3,175,4,181,5,181,6,163,7,163,8,153,9,153,10,153,11,153,12,153,13,153,14,153,15,153,16,153,17,153,18,135,19,135,20,108,21,108,22,108,23,108,24,108,25,108,234,81,235,81,236,81,237,81,238,99,239,99,240,119,241,119,242,119,243,119,244,64,245,64,246,107,247,107,248,99,249,99,250,99,251,99,252,146,253,146,254,174,255,174,},[36]={0,121,1,121,2,117,3,117,4,101,5,101,6,121,7,121,8,129,9,129,10,99,11,99,12,99,13,99,14,99,15,99,16,135,17,135,18,108,19,108,20,108,21,108,22,108,23,108,24,108,25,108,234,81,235,81,236,81,237,81,238,99,239,99,240,119,241,119,242,119,243,119,244,63,245,63,246,101,247,101,248,99,249,99,250,99,251,99,252,125,253,125,254,124,255,124,},[37]={0,121,1,121,2,117,3,117,4,101,5,101,6,121,7,121,8,129,9,129,10,99,11,99,12,99,13,99,14,99,15,99,16,135,17,135,18,108,19,108,20,108,21,108,22,108,23,108,24,108,25,108,234,81,235,81,236,81,237,81,238,99,239,99,240,119,241,119,242,119,243,119,244,63,245,63,246,101,247,101,248,99,249,99,250,99,251,99,252,125,253,125,254,124,255,124,},[38]={0,54,1,54,2,90,3,90,4,92,5,92,6,119,7,119,8,125,9,125,10,99,11,99,12,99,13,99,14,99,15,99,16,135,17,135,18,108,19,108,20,108,21,108,22,108,23,108,24,108,25,108,26,108,27,108,28,108,29,108,230,81,231,81,232,81,233,81,234,99,235,99,236,99,237,99,238,99,239,99,240,119,241,119,242,119,243,119,244,63,245,63,246,99,247,99,248,108,249,108,250,99,251,99,252,114,253,114,254,137,255,137,},[39]={0,54,1,54,2,90,3,90,4,92,5,92,6,119,7,119,8,125,9,125,10,99,11,99,12,99,13,99,14,99,15,99,16,135,17,135,18,108,19,108,20,108,21,108,22,108,23,108,24,108,25,108,26,108,27,108,28,108,29,108,230,81,231,81,232,81,233,81,234,99,235,99,236,99,237,99,238,99,239,99,240,119,241,119,242,119,243,119,244,63,245,63,246,99,247,99,248,108,249,108,250,99,251,99,252,114,253,114,254,137,255,137,},[40]={16,108,17,108,18,108,19,108,20,108,21,108,22,108,23,108,24,108,25,108,26,108,27,108,28,108,29,108,230,81,231,81,232,81,233,81,234,99,235,99,236,99,237,99,238,99,239,99,240,81,241,81,242,81,243,81,},[41]={16,108,17,108,18,108,19,108,20,108,21,108,22,108,23,108,24,108,25,108,26,108,27,108,28,108,29,108,230,81,231,81,232,81,233,81,234,99,235,99,236,99,237,99,238,99,239,99,240,81,241,81,242,81,243,81,},[42]={16,108,17,108,18,108,19,108,20,108,21,108,22,108,23,108,24,108,25,108,26,108,27,108,28,108,29,108,30,99,31,99,32,99,33,99,226,99,227,99,228,99,229,99,230,99,231,99,232,99,233,99,234,99,235,99,236,99,237,99,238,99,239,99,240,81,241,81,242,81,243,81,},[43]={16,108,17,108,18,108,19,108,20,108,21,108,22,108,23,108,24,108,25,108,26,108,27,108,28,108,29,108,30,99,31,99,32,99,33,99,226,99,227,99,228,99,229,99,230,99,231,99,232,99,233,99,234,99,235,99,236,99,237,99,238,99,239,99,240,81,241,81,242,81,243,81,},[44]={20,108,21,108,22,108,23,108,24,108,25,108,26,108,27,108,28,108,29,108,30,99,31,99,32,99,33,99,226,99,227,99,228,99,229,99,230,99,231,99,232,99,233,99,234,99,235,99,236,81,237,81,238,81,239,81,},[45]={20,108,21,108,22,108,23,108,24,108,25,108,26,108,27,108,28,108,29,108,30,99,31,99,32,99,33,99,226,99,227,99,228,99,229,99,230,99,231,99,232,99,233,99,234,99,235,99,236,81,237,81,238,81,239,81,},[46]={20,108,21,108,22,108,23,108,24,108,25,108,26,108,27,108,28,108,29,108,30,99,31,99,32,99,33,99,226,99,227,99,228,99,229,99,230,99,231,99,232,99,233,99,234,99,235,99,236,81,237,81,238,81,239,81,},[47]={20,108,21,108,22,108,23,108,24,108,25,108,26,108,27,108,28,108,29,108,30,99,31,99,32,99,33,99,226,99,227,99,228,99,229,99,230,99,231,99,232,99,233,99,234,99,235,99,236,81,237,81,238,81,239,81,},[48]={24,99,25,99,26,99,27,99,28,99,29,99,30,99,31,99,32,99,33,99,226,99,227,99,228,99,229,99,230,99,231,99,232,99,233,99,234,99,235,99,},[49]={24,99,25,99,26,99,27,99,28,99,29,99,30,99,31,99,32,99,33,99,226,99,227,99,228,99,229,99,230,99,231,99,232,99,233,99,234,99,235,99,},[50]={24,99,25,99,26,99,27,99,28,99,29,99,30,99,31,99,32,99,33,99,226,99,227,99,228,99,229,99,230,99,231,99,232,99,233,99,234,99,235,99,},[51]={24,99,25,99,26,99,27,99,28,99,29,99,30,99,31,99,32,99,33,99,226,99,227,99,228,99,229,99,230,99,231,99,232,99,233,99,234,99,235,99,},[206]={22,108,23,108,24,108,25,108,26,108,27,108,28,108,29,108,30,108,31,108,226,90,227,90,228,90,229,90,230,90,231,90,232,90,233,90,234,90,235,90,},[207]={22,108,23,108,24,108,25,108,26,108,27,108,28,108,29,108,30,108,31,108,226,90,227,90,228,90,229,90,230,90,231,90,232,90,233,90,234,90,235,90,},[208]={22,108,23,108,24,108,25,108,26,108,27,108,28,108,29,108,30,108,31,108,226,90,227,90,228,90,229,90,230,90,231,90,232,90,233,90,234,90,235,90,},[209]={22,108,23,108,24,108,25,108,26,108,27,108,28,108,29,108,30,108,31,108,226,90,227,90,228,90,229,90,230,90,231,90,232,90,233,90,234,90,235,90,},[210]={18,108,19,108,20,108,21,108,22,108,23,108,24,108,25,108,26,108,27,108,28,108,29,108,30,108,31,108,226,90,227,90,228,90,229,90,230,99,231,99,232,99,233,99,234,99,235,99,236,99,237,99,238,99,239,99,},[211]={18,108,19,108,20,108,21,108,22,108,23,108,24,108,25,108,26,108,27,108,28,108,29,108,30,108,31,108,226,90,227,90,228,90,229,90,230,99,231,99,232,99,233,99,234,99,235,99,236,99,237,99,238,99,239,99,},[212]={18,108,19,108,20,108,21,108,22,108,23,108,24,108,25,108,26,108,27,108,28,108,29,108,30,108,31,108,226,90,227,90,228,90,229,90,230,99,231,99,232,99,233,99,234,99,235,99,236,99,237,99,238,99,239,99,},[213]={18,108,19,108,20,108,21,108,22,108,23,108,24,108,25,108,26,108,27,108,28,108,29,108,30,108,31,108,226,90,227,90,228,90,229,90,230,99,231,99,232,99,233,99,234,99,235,99,236,99,237,99,238,99,239,99,},[214]={14,90,15,90,16,90,17,90,18,108,19,108,20,108,21,108,22,108,23,108,24,108,25,108,26,108,27,108,28,108,29,108,30,108,31,108,226,90,227,90,228,90,229,90,230,99,231,99,232,99,233,99,234,108,235,108,236,108,237,108,238,108,239,108,240,108,241,108,242,108,243,108,},[215]={14,90,15,90,16,90,17,90,18,108,19,108,20,108,21,108,22,108,23,108,24,108,25,108,26,108,27,108,28,108,29,108,30,108,31,108,226,90,227,90,228,90,229,90,230,99,231,99,232,99,233,99,234,108,235,108,236,108,237,108,238,108,239,108,240,108,241,108,242,108,243,108,},[216]={14,90,15,90,16,90,17,90,18,108,19,108,20,108,21,108,22,108,23,108,24,108,25,108,26,108,27,108,230,99,231,99,232,99,233,99,234,108,235,108,236,108,237,108,238,108,239,108,240,108,241,108,242,108,243,108,},[217]={14,90,15,90,16,90,17,90,18,108,19,108,20,108,21,108,22,108,23,108,24,108,25,108,26,108,27,108,230,99,231,99,232,99,233,99,234,108,235,108,236,108,237,108,238,108,239,108,240,108,241,108,242,108,243,108,},[218]={0,45,1,45,2,45,3,45,4,36,5,36,6,63,7,63,8,36,9,36,10,36,11,36,12,54,13,54,14,126,15,126,16,99,17,99,18,108,19,108,20,108,21,108,22,108,23,108,24,108,25,108,26,108,27,108,230,99,231,99,232,99,233,99,234,108,235,108,236,108,237,108,238,108,239,108,240,108,241,108,242,108,243,108,244,54,245,54,246,54,247,54,248,54,249,54,250,63,251,63,252,63,253,63,254,45,255,45,},[219]={0,45,1,45,2,45,3,45,4,36,5,36,6,63,7,63,8,36,9,36,10,36,11,36,12,54,13,54,14,126,15,126,16,99,17,99,18,108,19,108,20,108,21,108,22,108,23,108,24,108,25,108,26,108,27,108,230,99,231,99,232,99,233,99,234,108,235,108,236,108,237,108,238,108,239,108,240,108,241,108,242,108,243,108,244,54,245,54,246,54,247,54,248,54,249,54,250,63,251,63,252,63,253,63,254,45,255,45,},[220]={0,156,1,156,2,141,3,141,4,124,5,124,6,105,7,105,8,82,9,82,10,57,11,57,12,54,13,54,14,126,15,126,16,99,17,99,18,99,19,99,20,90,21,90,22,90,23,90,234,108,235,108,236,108,237,108,238,108,239,108,240,108,241,108,242,108,243,108,244,108,245,108,246,108,247,108,248,126,249,126,250,135,251,135,252,147,253,147,254,141,255,141,},[221]={0,156,1,156,2,141,3,141,4,124,5,124,6,105,7,105,8,82,9,82,10,57,11,57,12,54,13,54,14,126,15,126,16,99,17,99,18,99,19,99,20,90,21,90,22,90,23,90,234,108,235,108,236,108,237,108,238,108,239,108,240,108,241,108,242,108,243,108,244,108,245,108,246,108,247,108,248,126,249,126,250,135,251,135,252,147,253,147,254,141,255,141,},[222]={0,175,1,175,2,176,3,176,4,161,5,161,6,137,7,137,8,107,9,107,10,75,11,75,12,54,13,54,14,126,15,126,16,99,17,99,18,99,19,99,20,90,21,90,22,90,23,90,234,108,235,108,236,108,237,108,238,108,239,108,240,108,241,108,242,108,243,108,244,108,245,108,246,108,247,108,248,126,249,126,250,135,251,135,252,156,253,156,254,169,255,169,},[223]={0,175,1,175,2,176,3,176,4,161,5,161,6,137,7,137,8,107,9,107,10,75,11,75,12,54,13,54,14,126,15,126,16,99,17,99,18,99,19,99,20,90,21,90,22,90,23,90,234,108,235,108,236,108,237,108,238,108,239,108,240,108,241,108,242,108,243,108,244,108,245,108,246,108,247,108,248,126,249,126,250,135,251,135,252,156,253,156,254,169,255,169,},[224]={0,209,1,209,2,207,3,207,4,199,5,199,6,169,7,169,8,131,9,131,10,136,11,136,12,99,13,99,14,99,15,99,16,72,17,72,18,72,19,72,20,1,21,1,22,1,23,1,234,1,235,1,236,1,237,1,238,36,239,36,240,108,241,108,242,108,243,108,244,108,245,108,246,108,247,108,248,127,249,127,250,150,251,150,252,174,253,174,254,197,255,197,},[225]={0,209,1,209,2,207,3,207,4,199,5,199,6,169,7,169,8,131,9,131,10,136,11,136,12,99,13,99,14,99,15,99,16,72,17,72,18,72,19,72,20,1,21,1,22,1,23,1,234,1,235,1,236,1,237,1,238,36,239,36,240,108,241,108,242,108,243,108,244,108,245,108,246,108,247,108,248,127,249,127,250,150,251,150,252,174,253,174,254,197,255,197,},[226]={0,251,1,251,2,248,3,248,4,238,5,238,6,202,7,202,8,160,9,160,10,151,11,151,12,151,13,151,14,151,15,151,16,151,17,151,18,108,19,108,20,1,21,1,22,1,23,1,40,90,41,90,42,90,43,90,44,90,45,90,46,90,47,90,48,90,49,90,206,108,207,108,208,108,209,108,210,108,211,108,212,108,213,108,214,108,215,108,234,1,235,1,236,1,237,1,238,36,239,36,240,108,241,108,242,108,243,108,244,108,245,108,246,108,247,108,248,133,249,133,250,164,251,164,252,199,253,199,254,236,255,236,},[227]={0,251,1,251,2,248,3,248,4,238,5,238,6,202,7,202,8,160,9,160,10,151,11,151,12,151,13,151,14,151,15,151,16,151,17,151,18,108,19,108,20,1,21,1,22,1,23,1,40,90,41,90,42,90,43,90,44,90,45,90,46,90,47,90,48,90,49,90,206,108,207,108,208,108,209,108,210,108,211,108,212,108,213,108,214,108,215,108,234,1,235,1,236,1,237,1,238,36,239,36,240,108,241,108,242,108,243,108,244,108,245,108,246,108,247,108,248,133,249,133,250,164,251,164,252,199,253,199,254,236,255,236,},[228]={0,259,1,259,2,249,3,249,4,234,5,234,6,230,7,230,8,186,9,186,10,151,11,151,12,151,13,151,14,108,15,108,16,108,17,108,18,108,19,108,20,108,21,108,22,108,23,108,24,72,25,72,38,36,39,36,40,90,41,90,42,90,43,90,44,90,45,90,46,90,47,90,48,90,49,90,206,108,207,108,208,108,209,108,210,108,211,108,212,108,213,108,214,108,215,108,232,81,233,81,234,81,235,81,236,81,237,81,238,81,239,81,240,108,241,108,242,108,243,108,244,108,245,108,246,108,247,108,248,132,249,132,250,171,251,171,252,207,253,207,254,244,255,244,},[229]={0,259,1,259,2,249,3,249,4,234,5,234,6,230,7,230,8,186,9,186,10,151,11,151,12,151,13,151,14,108,15,108,16,108,17,108,18,108,19,108,20,108,21,108,22,108,23,108,24,72,25,72,38,36,39,36,40,90,41,90,42,90,43,90,44,90,45,90,46,90,47,90,48,90,49,90,206,108,207,108,208,108,209,108,210,108,211,108,212,108,213,108,214,108,215,108,232,81,233,81,234,81,235,81,236,81,237,81,238,81,239,81,240,108,241,108,242,108,243,108,244,108,245,108,246,108,247,108,248,132,249,132,250,171,251,171,252,207,253,207,254,244,255,244,},[230]={0,266,1,266,2,256,3,256,4,231,5,231,6,222,7,222,8,188,9,188,10,151,11,151,12,151,13,151,14,108,15,108,16,108,17,108,18,108,19,108,20,108,21,108,22,108,23,108,24,72,25,72,38,36,39,36,40,90,41,90,42,90,43,90,44,90,45,90,46,90,47,90,48,90,49,90,206,108,207,108,208,108,209,108,210,117,211,117,212,117,213,117,214,117,215,117,216,117,217,117,218,117,219,117,232,81,233,81,234,81,235,81,236,81,237,81,238,81,239,81,240,108,241,108,242,108,243,108,244,108,245,108,246,108,247,108,248,117,249,117,250,164,251,164,252,200,253,200,254,241,255,241,},[231]={0,266,1,266,2,256,3,256,4,231,5,231,6,222,7,222,8,188,9,188,10,151,11,151,12,151,13,151,14,108,15,108,16,108,17,108,18,108,19,108,20,108,21,108,22,108,23,108,24,72,25,72,38,36,39,36,40,90,41,90,42,90,43,90,44,90,45,90,46,90,47,90,48,90,49,90,206,108,207,108,208,108,209,108,210,117,211,117,212,117,213,117,214,117,215,117,216,117,217,117,218,117,219,117,232,81,233,81,234,81,235,81,236,81,237,81,238,81,239,81,240,108,241,108,242,108,243,108,244,108,245,108,246,108,247,108,248,117,249,117,250,164,251,164,252,200,253,200,254,241,255,241,},[232]={0,256,1,256,2,247,3,247,4,222,5,222,6,191,7,191,8,173,9,173,10,151,11,151,12,151,13,151,14,108,15,108,16,108,17,108,18,108,19,108,20,108,21,108,22,108,23,108,24,72,25,72,26,27,27,27,28,27,29,27,30,1,31,1,32,1,33,1,34,90,35,90,36,90,37,90,38,90,39,90,40,90,41,90,42,90,43,90,44,90,45,90,46,90,47,90,48,90,49,90,206,108,207,108,208,108,209,108,210,117,211,117,212,117,213,117,214,117,215,117,216,117,217,117,218,117,219,117,228,90,229,90,230,90,231,90,232,117,233,117,234,117,235,117,236,117,237,117,238,81,239,81,240,108,241,108,242,108,243,108,244,108,245,108,246,108,247,108,248,108,249,108,250,122,251,122,252,182,253,182,254,231,255,231,},[233]={0,256,1,256,2,247,3,247,4,222,5,222,6,191,7,191,8,173,9,173,10,151,11,151,12,151,13,151,14,108,15,108,16,108,17,108,18,108,19,108,20,108,21,108,22,108,23,108,24,72,25,72,26,27,27,27,28,27,29,27,30,1,31,1,32,1,33,1,34,90,35,90,36,90,37,90,38,90,39,90,40,90,41,90,42,90,43,90,44,90,45,90,46,90,47,90,48,90,49,90,206,108,207,108,208,108,209,108,210,117,211,117,212,117,213,117,214,117,215,117,216,117,217,117,218,117,219,117,228,90,229,90,230,90,231,90,232,117,233,117,234,117,235,117,236,117,237,117,238,81,239,81,240,108,241,108,242,108,243,108,244,108,245,108,246,108,247,108,248,108,249,108,250,122,251,122,252,182,253,182,254,231,255,231,},[234]={0,196,1,196,2,187,3,187,4,167,5,167,6,149,7,149,8,139,9,139,10,151,11,151,12,126,13,126,14,108,15,108,16,108,17,108,18,108,19,108,20,108,21,108,22,108,23,108,24,99,25,99,26,54,27,54,28,54,29,54,30,1,31,1,32,1,33,1,34,90,35,90,36,90,37,90,38,90,39,90,40,90,41,90,42,90,43,90,44,90,45,90,46,90,47,90,48,90,49,90,206,108,207,108,208,108,209,108,210,117,211,117,212,117,213,117,214,117,215,117,216,117,217,117,218,117,219,117,220,99,221,99,222,99,223,99,224,1,225,1,226,1,227,1,228,117,229,117,230,117,231,117,232,117,233,117,234,117,235,117,236,117,237,117,238,81,239,81,240,108,241,108,242,45,243,45,244,45,245,45,246,45,247,45,248,65,249,65,250,68,251,68,252,151,253,151,254,183,255,183,},[235]={0,196,1,196,2,187,3,187,4,167,5,167,6,149,7,149,8,139,9,139,10,151,11,151,12,126,13,126,14,108,15,108,16,108,17,108,18,108,19,108,20,108,21,108,22,108,23,108,24,99,25,99,26,54,27,54,28,54,29,54,30,1,31,1,32,1,33,1,34,90,35,90,36,90,37,90,38,90,39,90,40,90,41,90,42,90,43,90,44,90,45,90,46,90,47,90,48,90,49,90,206,108,207,108,208,108,209,108,210,117,211,117,212,117,213,117,214,117,215,117,216,117,217,117,218,117,219,117,220,99,221,99,222,99,223,99,224,1,225,1,226,1,227,1,228,117,229,117,230,117,231,117,232,117,233,117,234,117,235,117,236,117,237,117,238,81,239,81,240,108,241,108,242,45,243,45,244,45,245,45,246,45,247,45,248,65,249,65,250,68,251,68,252,151,253,151,254,183,255,183,},[236]={0,119,1,119,2,119,3,119,4,119,5,119,6,92,7,92,8,83,9,83,10,98,11,98,12,45,13,45,14,99,15,99,16,108,17,108,18,108,19,108,20,108,21,108,22,108,23,108,24,108,25,108,26,81,27,81,28,90,29,90,30,99,31,99,32,99,33,99,34,90,35,90,36,90,37,90,38,90,39,90,40,90,41,90,42,90,43,90,44,36,45,36,46,36,47,36,210,117,211,117,212,117,213,117,214,117,215,117,216,117,217,117,218,117,219,117,220,99,221,99,222,99,223,99,224,1,225,1,226,1,227,1,228,117,229,117,230,117,231,117,232,117,233,117,234,117,235,117,236,117,237,117,238,81,239,81,240,108,241,108,242,45,243,45,244,45,245,45,246,45,247,45,248,54,249,54,250,63,251,63,252,103,253,103,254,116,255,116,},[237]={0,119,1,119,2,119,3,119,4,119,5,119,6,92,7,92,8,83,9,83,10,98,11,98,12,45,13,45,14,99,15,99,16,108,17,108,18,108,19,108,20,108,21,108,22,108,23,108,24,108,25,108,26,81,27,81,28,90,29,90,30,99,31,99,32,99,33,99,34,90,35,90,36,90,37,90,38,90,39,90,40,90,41,90,42,90,43,90,44,36,45,36,46,36,47,36,210,117,211,117,212,117,213,117,214,117,215,117,216,117,217,117,218,117,219,117,220,99,221,99,222,99,223,99,224,1,225,1,226,1,227,1,228,117,229,117,230,117,231,117,232,117,233,117,234,117,235,117,236,117,237,117,238,81,239,81,240,108,241,108,242,45,243,45,244,45,245,45,246,45,247,45,248,54,249,54,250,63,251,63,252,103,253,103,254,116,255,116,},[238]={0,90,1,90,2,90,3,90,4,72,5,72,20,99,21,99,22,99,23,99,24,99,25,99,26,81,27,81,28,90,29,90,30,99,31,99,32,99,33,99,34,90,35,90,36,90,37,90,38,90,39,90,40,90,41,90,42,90,43,90,210,117,211,117,212,117,213,117,214,117,215,117,216,117,217,117,218,117,219,117,220,108,221,108,222,108,223,108,224,9,225,9,226,45,227,45,228,135,229,135,230,135,231,135,232,135,233,135,234,135,235,135,236,117,237,117,252,72,253,72,254,72,255,72,},[239]={0,90,1,90,2,90,3,90,4,72,5,72,20,99,21,99,22,99,23,99,24,99,25,99,26,81,27,81,28,90,29,90,30,99,31,99,32,99,33,99,34,90,35,90,36,90,37,90,38,90,39,90,40,90,41,90,42,90,43,90,210,117,211,117,212,117,213,117,214,117,215,117,216,117,217,117,218,117,219,117,220,108,221,108,222,108,223,108,224,9,225,9,226,45,227,45,228,135,229,135,230,135,231,135,232,135,233,135,234,135,235,135,236,117,237,117,252,72,253,72,254,72,255,72,},[240]={0,72,1,72,2,72,3,72,4,72,5,72,20,81,21,81,22,81,23,81,24,108,25,108,26,108,27,108,28,99,29,99,30,108,31,108,32,108,33,108,34,72,35,72,36,72,37,72,38,90,39,90,40,90,41,90,42,90,43,90,214,99,215,99,216,99,217,99,218,117,219,117,220,144,221,144,222,144,223,144,224,99,225,99,226,135,227,135,228,135,229,135,230,135,231,135,232,135,233,135,234,135,235,135,236,117,237,117,252,72,253,72,254,72,255,72,},[241]={0,72,1,72,2,72,3,72,4,72,5,72,20,81,21,81,22,81,23,81,24,108,25,108,26,108,27,108,28,99,29,99,30,108,31,108,32,108,33,108,34,72,35,72,36,72,37,72,38,90,39,90,40,90,41,90,42,90,43,90,214,99,215,99,216,99,217,99,218,117,219,117,220,144,221,144,222,144,223,144,224,99,225,99,226,135,227,135,228,135,229,135,230,135,231,135,232,135,233,135,234,135,235,135,236,117,237,117,252,72,253,72,254,72,255,72,},[242]={0,72,1,72,2,72,3,72,4,72,5,72,20,90,21,90,22,90,23,90,24,108,25,108,26,108,27,108,28,108,29,108,30,108,31,108,32,108,33,108,34,90,35,90,36,101,37,101,38,99,39,99,214,99,215,99,216,99,217,99,218,117,219,117,220,108,221,108,222,113,223,113,224,90,225,90,226,99,227,99,228,126,229,126,230,135,231,135,232,117,233,117,234,81,235,81,236,36,237,36,252,72,253,72,254,72,255,72,},[243]={0,72,1,72,2,72,3,72,4,72,5,72,20,90,21,90,22,90,23,90,24,108,25,108,26,108,27,108,28,108,29,108,30,108,31,108,32,108,33,108,34,90,35,90,36,101,37,101,38,99,39,99,214,99,215,99,216,99,217,99,218,117,219,117,220,108,221,108,222,113,223,113,224,90,225,90,226,99,227,99,228,126,229,126,230,135,231,135,232,117,233,117,234,81,235,81,236,36,237,36,252,72,253,72,254,72,255,72,},[244]={0,72,1,72,2,72,3,72,4,72,5,72,20,72,21,72,22,72,23,72,24,108,25,108,26,108,27,108,28,108,29,108,30,108,31,108,32,108,33,108,34,90,35,90,36,101,37,101,38,99,39,99,216,1,217,1,218,36,219,36,220,90,221,90,222,90,223,90,224,90,225,90,226,113,227,113,228,113,229,113,230,153,231,153,232,126,233,126,234,90,235,90,236,9,237,9,252,72,253,72,254,72,255,72,},[245]={0,72,1,72,2,72,3,72,4,72,5,72,20,72,21,72,22,72,23,72,24,108,25,108,26,108,27,108,28,108,29,108,30,108,31,108,32,108,33,108,34,90,35,90,36,101,37,101,38,99,39,99,216,1,217,1,218,36,219,36,220,90,221,90,222,90,223,90,224,90,225,90,226,113,227,113,228,113,229,113,230,153,231,153,232,126,233,126,234,90,235,90,236,9,237,9,252,72,253,72,254,72,255,72,},[246]={0,76,1,76,2,76,3,76,4,63,5,63,6,27,7,27,20,45,21,45,22,45,23,45,24,99,25,99,26,108,27,108,28,108,29,108,30,108,31,108,32,108,33,108,34,90,35,90,36,72,37,72,38,36,39,36,216,54,217,54,218,54,219,54,220,90,221,90,222,90,223,90,224,113,225,113,226,113,227,113,228,113,229,113,230,176,231,176,232,126,233,126,234,90,235,90,236,9,237,9,248,36,249,36,250,57,251,57,252,76,253,76,254,76,255,76,},[247]={0,76,1,76,2,76,3,76,4,63,5,63,6,27,7,27,20,45,21,45,22,45,23,45,24,99,25,99,26,108,27,108,28,108,29,108,30,108,31,108,32,108,33,108,34,90,35,90,36,72,37,72,38,36,39,36,216,54,217,54,218,54,219,54,220,90,221,90,222,90,223,90,224,113,225,113,226,113,227,113,228,113,229,113,230,176,231,176,232,126,233,126,234,90,235,90,236,9,237,9,248,36,249,36,250,57,251,57,252,76,253,76,254,76,255,76,},[248]={0,137,1,137,2,122,3,122,4,101,5,101,6,63,7,63,8,27,9,27,20,45,21,45,22,45,23,45,24,99,25,99,26,108,27,108,28,108,29,108,30,108,31,108,32,108,33,108,34,90,35,90,36,72,37,72,38,9,39,9,216,54,217,54,218,90,219,90,220,111,221,111,222,113,223,113,224,113,225,113,226,113,227,113,228,113,229,113,230,168,231,168,232,127,233,127,234,75,235,75,236,9,237,9,246,36,247,36,248,61,249,61,250,95,251,95,252,123,253,123,254,137,255,137,},[249]={0,137,1,137,2,122,3,122,4,101,5,101,6,63,7,63,8,27,9,27,20,45,21,45,22,45,23,45,24,99,25,99,26,108,27,108,28,108,29,108,30,108,31,108,32,108,33,108,34,90,35,90,36,72,37,72,38,9,39,9,216,54,217,54,218,90,219,90,220,111,221,111,222,113,223,113,224,113,225,113,226,113,227,113,228,113,229,113,230,168,231,168,232,127,233,127,234,75,235,75,236,9,237,9,246,36,247,36,248,61,249,61,250,95,251,95,252,123,253,123,254,137,255,137,},[250]={0,214,1,214,2,188,3,188,4,148,5,148,6,81,7,81,8,27,9,27,20,45,21,45,22,45,23,45,24,102,25,102,26,108,27,108,28,108,29,108,30,117,31,117,32,132,33,132,34,116,35,116,36,109,37,109,38,30,39,30,216,54,217,54,218,113,219,113,220,100,221,100,222,131,223,131,224,131,225,131,226,113,227,113,228,113,229,113,230,146,231,146,232,131,233,131,234,93,235,93,236,9,237,9,246,36,247,36,248,80,249,80,250,133,251,133,252,182,253,182,254,199,255,199,},[251]={0,214,1,214,2,188,3,188,4,148,5,148,6,81,7,81,8,27,9,27,20,45,21,45,22,45,23,45,24,102,25,102,26,108,27,108,28,108,29,108,30,117,31,117,32,132,33,132,34,116,35,116,36,109,37,109,38,30,39,30,216,54,217,54,218,113,219,113,220,100,221,100,222,131,223,131,224,131,225,131,226,113,227,113,228,113,229,113,230,146,231,146,232,131,233,131,234,93,235,93,236,9,237,9,246,36,247,36,248,80,249,80,250,133,251,133,252,182,253,182,254,199,255,199,},[252]={0,277,1,277,2,245,3,245,4,176,5,176,6,121,7,121,8,72,9,72,10,72,11,72,12,108,13,108,14,108,15,108,16,90,17,90,18,90,19,90,20,90,21,90,22,99,23,99,24,124,25,124,26,150,27,150,28,186,29,186,30,180,31,180,32,168,33,168,34,147,35,147,36,98,37,98,38,48,39,48,216,54,217,54,218,123,219,123,220,151,221,151,222,156,223,156,224,171,225,171,226,178,227,178,228,198,229,198,230,180,231,180,232,144,233,144,234,100,235,100,236,54,237,54,238,81,239,81,240,81,241,81,242,63,243,63,244,45,245,45,246,64,247,64,248,106,249,106,250,171,251,171,252,227,253,227,254,268,255,268,},[253]={0,277,1,277,2,245,3,245,4,176,5,176,6,121,7,121,8,72,9,72,10,72,11,72,12,108,13,108,14,108,15,108,16,90,17,90,18,90,19,90,20,90,21,90,22,99,23,99,24,124,25,124,26,150,27,150,28,186,29,186,30,180,31,180,32,168,33,168,34,147,35,147,36,98,37,98,38,48,39,48,216,54,217,54,218,123,219,123,220,151,221,151,222,156,223,156,224,171,225,171,226,178,227,178,228,198,229,198,230,180,231,180,232,144,233,144,234,100,235,100,236,54,237,54,238,81,239,81,240,81,241,81,242,63,243,63,244,45,245,45,246,64,247,64,248,106,249,106,250,171,251,171,252,227,253,227,254,268,255,268,},[254]={0,269,1,269,2,240,3,240,4,205,5,205,6,121,7,121,8,99,9,99,10,72,11,72,12,108,13,108,14,108,15,108,16,90,17,90,18,90,19,90,20,90,21,90,22,124,23,124,24,159,25,159,26,195,27,195,28,212,29,212,30,209,31,209,32,220,33,220,34,180,35,180,36,122,37,122,38,64,39,64,216,54,217,54,218,132,219,132,220,165,221,165,222,186,223,186,224,199,225,199,226,220,227,220,228,227,229,227,230,198,231,198,232,166,233,166,234,100,235,100,236,54,237,54,238,81,239,81,240,81,241,81,242,63,243,63,244,45,245,45,246,64,247,64,248,122,249,122,250,188,251,188,252,224,253,224,254,251,255,251,},[255]={0,269,1,269,2,240,3,240,4,205,5,205,6,121,7,121,8,99,9,99,10,72,11,72,12,108,13,108,14,108,15,108,16,90,17,90,18,90,19,90,20,90,21,90,22,124,23,124,24,159,25,159,26,195,27,195,28,212,29,212,30,209,31,209,32,220,33,220,34,180,35,180,36,122,37,122,38,64,39,64,216,54,217,54,218,132,219,132,220,165,221,165,222,186,223,186,224,199,225,199,226,220,227,220,228,227,229,227,230,198,231,198,232,166,233,166,234,100,235,100,236,54,237,54,238,81,239,81,240,81,241,81,242,63,243,63,244,45,245,45,246,64,247,64,248,122,249,122,250,188,251,188,252,224,253,224,254,251,255,251}
		},
		
		markers ={
			24, 42, 230, 42, 212, 22, 212, 230, 232, 210, 22, 214, 40, 232, 42, 24,
		},
		
		objects = {
			[0]={0,5,3,-1,0,28,5,2,-1,0,226,5,2,-1,0,},[14]={34,7,85,-1,0,36,7,85,-1,0,38,7,85,-1,0,40,7,85,-1,0,42,7,85,-1,0,212,7,85,-1,0,214,7,85,-1,0,216,7,85,-1,0,218,7,85,-1,0,220,7,85,-1,0,},[16]={32,7,85,-1,0,222,7,85,-1,0,},[18]={32,7,85,-1,0,222,7,85,-1,0,},[20]={32,7,85,-1,0,222,7,85,-1,0,},[22]={32,7,85,-1,0,222,7,85,-1,0,},[24]={32,7,85,-1,0,},[28]={0,5,3,-1,0,},[32]={16,7,85,-1,0,18,7,85,-1,0,20,7,85,-1,0,22,7,85,-1,0,24,7,85,-1,0,230,7,85,-1,0,232,7,85,-1,0,234,7,85,-1,0,236,7,85,-1,0,238,7,85,-1,0,},[34]={14,7,85,-1,0,240,7,85,-1,0,},[36]={14,7,85,-1,0,240,7,85,-1,0,},[38]={14,7,85,-1,0,240,7,85,-1,0,},[40]={14,7,85,-1,0,240,7,85,-1,0,},[42]={14,7,85,-1,0,240,7,85,-1,0,},[212]={12,7,85,-1,0,240,7,85,-1,0,},[214]={12,7,85,-1,0,240,7,85,-1,0,},[216]={12,7,85,-1,0,240,7,85,-1,0,},[218]={12,7,85,-1,0,240,7,85,-1,0,},[220]={12,7,85,-1,0,240,7,85,-1,0,},[222]={14,7,85,-1,0,16,7,85,-1,0,18,7,85,-1,0,20,7,85,-1,0,22,7,85,-1,0,232,7,85,-1,0,234,7,85,-1,0,236,7,85,-1,0,238,7,85,-1,0,},[228]={0,5,3,-1,0,},[230]={32,7,85,-1,0,},[232]={32,7,85,-1,0,220,7,85,-1,0,},[234]={32,7,85,-1,0,220,7,85,-1,0,},[236]={32,7,85,-1,0,220,7,85,-1,0,},[238]={32,7,85,-1,0,220,7,85,-1,0,},[240]={34,7,85,-1,0,36,7,85,-1,0,38,7,85,-1,0,40,7,85,-1,0,42,7,85,-1,0,220,7,85,-1,0,},[242]={212,7,85,-1,0,214,7,85,-1,0,216,7,85,-1,0,218,7,85,-1,0,}
		},
		
		shaman_positions = {
			28, 46, 228, 44, 208, 26, 208, 228, 228, 208, 26, 208, 46, 228, 46, 28
		},
		
		scripts = {
			OnTurn = function(everySecond1, everySecond2, everySecond4) 			shifting_sands_on_turn(everySecond1, everySecond2, everySecond4) end,
			OnCreateThing = function(t, owner, type, model) 						shifting_sands_on_create_thing(t, owner, type, model) end,
			OnShamanDeath = function(victim, killer, killer_was_ally)				shifting_sands_on_shaman_dead(victim, killer, killer_was_ally) end,
			OnHumanDisconnect = function(player) 									SS_init_single_AI(player) end,
		},
		
	},
	
	[MAP_TEMPEST]={
	
		info = 	{ 	name = "Tempest", author = "Ralimurr",
					desc = "With blast and lightning at your shaman's disposal, duel your enemies to the death in this chaotic arena. <br> Remember to stay away from reincarnation pillars, as they occasionally act as lightning coils!",
					map_objectives = { {value=6, step=1, default=true}, {value=30, step=5, default=false}, {} },
					image = 3392, texture={20,0}, zoom={0,224,0}, drop_infos = true,	marker_lb={130,130}, reinc_timer=12, shield_respawn=true,
					custom_rules = {
						{ default = false, 	name = "No light S-clicks", desc = "Lightning S-clicks won't follow." },
					}
				},
	
		land ={
			[0]={10,126,11,126,12,126,13,126,14,126,15,126,16,117,17,117,18,99,19,99,20,72,21,72,22,91,23,91,24,112,25,112,26,128,27,128,28,135,29,135,30,124,31,124,32,106,33,106,34,60,35,60,222,63,223,63,224,63,225,63,226,63,227,63,228,63,229,63,230,98,231,98,232,169,233,169,234,251,235,251,236,349,237,349,238,349,239,349,240,278,241,278,242,209,243,209,244,137,245,137,246,27,247,27,248,27,249,27,},[1]={10,126,11,126,12,126,13,126,14,126,15,126,16,117,17,117,18,99,19,99,20,72,21,72,22,91,23,91,24,112,25,112,26,128,27,128,28,135,29,135,30,124,31,124,32,106,33,106,34,60,35,60,222,63,223,63,224,63,225,63,226,63,227,63,228,63,229,63,230,98,231,98,232,169,233,169,234,251,235,251,236,349,237,349,238,349,239,349,240,278,241,278,242,209,243,209,244,137,245,137,246,27,247,27,248,27,249,27,},[2]={10,126,11,126,12,126,13,126,14,126,15,126,16,117,17,117,18,90,19,90,20,90,21,90,22,91,23,91,24,91,25,91,26,91,27,91,28,91,29,91,30,81,31,81,32,63,33,63,34,27,35,27,222,27,223,27,224,83,225,83,226,83,227,83,228,83,229,83,230,83,231,83,232,134,233,134,234,186,235,186,236,226,237,226,238,225,239,225,240,198,241,198,242,144,243,144,244,82,245,82,246,27,247,27,248,1,249,1,},[3]={10,126,11,126,12,126,13,126,14,126,15,126,16,117,17,117,18,90,19,90,20,90,21,90,22,91,23,91,24,91,25,91,26,91,27,91,28,91,29,91,30,81,31,81,32,63,33,63,34,27,35,27,222,27,223,27,224,83,225,83,226,83,227,83,228,83,229,83,230,83,231,83,232,134,233,134,234,186,235,186,236,226,237,226,238,225,239,225,240,198,241,198,242,144,243,144,244,82,245,82,246,27,247,27,248,1,249,1,},[4]={10,117,11,117,12,117,13,117,14,117,15,117,16,117,17,117,18,117,19,117,20,117,21,117,22,108,23,108,24,90,25,90,26,91,27,91,28,90,29,90,30,81,31,81,32,63,33,63,34,18,35,18,222,27,223,27,224,80,225,80,226,105,227,105,228,99,229,99,230,99,231,99,232,91,233,91,234,93,235,93,236,113,237,113,238,111,239,111,240,83,241,83,242,27,243,27,244,27,245,27,246,27,247,27,248,1,249,1,},[5]={10,117,11,117,12,117,13,117,14,117,15,117,16,117,17,117,18,117,19,117,20,117,21,117,22,108,23,108,24,90,25,90,26,91,27,91,28,90,29,90,30,81,31,81,32,63,33,63,34,18,35,18,222,27,223,27,224,80,225,80,226,105,227,105,228,99,229,99,230,99,231,99,232,91,233,91,234,93,235,93,236,113,237,113,238,111,239,111,240,83,241,83,242,27,243,27,244,27,245,27,246,27,247,27,248,1,249,1,},[6]={10,90,11,90,12,108,13,108,14,108,15,108,16,117,17,117,18,117,19,117,20,108,21,108,22,117,23,117,24,91,25,91,26,91,27,91,28,91,29,91,30,91,31,91,32,63,33,63,34,1,35,1,222,27,223,27,224,107,225,107,226,151,227,151,228,169,229,169,230,160,231,160,232,119,233,119,234,54,235,54,236,45,237,45,238,45,239,45,240,36,241,36,242,27,243,27,244,27,245,27,246,27,247,27,248,27,249,27,250,18,251,18,},[7]={10,90,11,90,12,108,13,108,14,108,15,108,16,117,17,117,18,117,19,117,20,108,21,108,22,117,23,117,24,91,25,91,26,91,27,91,28,91,29,91,30,91,31,91,32,63,33,63,34,1,35,1,222,27,223,27,224,107,225,107,226,151,227,151,228,169,229,169,230,160,231,160,232,119,233,119,234,54,235,54,236,45,237,45,238,45,239,45,240,36,241,36,242,27,243,27,244,27,245,27,246,27,247,27,248,27,249,27,250,18,251,18,},[8]={0,63,1,63,8,112,9,112,10,142,11,142,12,157,13,157,14,162,15,162,16,153,17,153,18,108,19,108,20,117,21,117,22,117,23,117,24,118,25,118,26,127,27,127,28,114,29,114,30,94,31,94,32,54,33,54,34,1,35,1,214,108,215,108,216,108,217,108,218,134,219,134,220,134,221,134,222,36,223,36,224,134,225,134,226,191,227,191,228,252,229,252,230,222,231,222,232,149,233,149,234,72,235,72,236,63,237,63,238,63,239,63,240,72,241,72,242,101,243,101,244,123,245,123,246,148,247,148,248,178,249,178,250,188,251,188,252,166,253,166,254,90,255,90,},[9]={0,63,1,63,8,112,9,112,10,142,11,142,12,157,13,157,14,162,15,162,16,153,17,153,18,108,19,108,20,117,21,117,22,117,23,117,24,118,25,118,26,127,27,127,28,114,29,114,30,94,31,94,32,54,33,54,34,1,35,1,214,108,215,108,216,108,217,108,218,134,219,134,220,134,221,134,222,36,223,36,224,134,225,134,226,191,227,191,228,252,229,252,230,222,231,222,232,149,233,149,234,72,235,72,236,63,237,63,238,63,239,63,240,72,241,72,242,101,243,101,244,123,245,123,246,148,247,148,248,178,249,178,250,188,251,188,252,166,253,166,254,90,255,90,},[10]={0,83,1,83,8,140,9,140,10,200,11,200,12,242,13,242,14,245,15,245,16,228,17,228,18,201,19,201,20,170,21,170,22,142,23,142,24,163,25,163,26,176,27,176,28,158,29,158,30,114,31,114,32,54,33,54,34,9,35,9,212,27,213,27,214,134,215,134,216,134,217,134,218,134,219,134,220,134,221,134,222,90,223,90,224,163,225,163,226,211,227,211,228,297,229,297,230,288,231,288,232,166,233,166,234,81,235,81,236,90,237,90,238,90,239,90,240,114,241,114,242,162,243,162,244,201,245,201,246,241,247,241,248,316,249,316,250,270,251,270,252,212,253,212,254,155,255,155,},[11]={0,83,1,83,8,140,9,140,10,200,11,200,12,242,13,242,14,245,15,245,16,228,17,228,18,201,19,201,20,170,21,170,22,142,23,142,24,163,25,163,26,176,27,176,28,158,29,158,30,114,31,114,32,54,33,54,34,9,35,9,212,27,213,27,214,134,215,134,216,134,217,134,218,134,219,134,220,134,221,134,222,90,223,90,224,163,225,163,226,211,227,211,228,297,229,297,230,288,231,288,232,166,233,166,234,81,235,81,236,90,237,90,238,90,239,90,240,114,241,114,242,162,243,162,244,201,245,201,246,241,247,241,248,316,249,316,250,270,251,270,252,212,253,212,254,155,255,155,},[12]={0,90,1,90,2,54,3,54,4,81,5,81,6,81,7,81,8,162,9,162,10,275,11,275,12,312,13,312,14,331,15,331,16,356,17,356,18,278,19,278,20,216,21,216,22,171,23,171,24,204,25,204,26,216,27,216,28,206,29,206,30,147,31,147,32,70,33,70,34,36,35,36,204,116,205,116,206,116,207,116,208,116,209,116,210,134,211,134,212,134,213,134,214,134,215,134,216,134,217,134,218,134,219,134,220,134,221,134,222,103,223,103,224,154,225,154,226,195,227,195,228,279,229,279,230,243,231,243,232,164,233,164,234,110,235,110,236,90,237,90,238,90,239,90,240,119,241,119,242,201,243,201,244,256,245,256,246,333,247,333,248,345,249,345,250,351,251,351,252,265,253,265,254,193,255,193,},[13]={0,90,1,90,2,54,3,54,4,81,5,81,6,81,7,81,8,162,9,162,10,275,11,275,12,312,13,312,14,331,15,331,16,356,17,356,18,278,19,278,20,216,21,216,22,171,23,171,24,204,25,204,26,216,27,216,28,206,29,206,30,147,31,147,32,70,33,70,34,36,35,36,204,116,205,116,206,116,207,116,208,116,209,116,210,134,211,134,212,134,213,134,214,134,215,134,216,134,217,134,218,134,219,134,220,134,221,134,222,103,223,103,224,154,225,154,226,195,227,195,228,279,229,279,230,243,231,243,232,164,233,164,234,110,235,110,236,90,237,90,238,90,239,90,240,119,241,119,242,201,243,201,244,256,245,256,246,333,247,333,248,345,249,345,250,351,251,351,252,265,253,265,254,193,255,193,},[14]={0,98,1,98,2,99,3,99,4,99,5,99,6,99,7,99,8,174,9,174,10,263,11,263,12,338,13,338,14,410,15,410,16,410,17,410,18,312,19,312,20,247,21,247,22,194,23,194,24,243,25,243,26,297,27,297,28,270,29,270,30,170,31,170,32,113,33,113,34,99,35,99,36,72,37,72,38,72,39,72,40,72,41,72,42,63,43,63,44,63,45,63,46,63,47,63,48,63,49,63,50,63,51,63,204,116,205,116,206,116,207,116,208,116,209,116,210,134,211,134,212,134,213,134,214,134,215,134,216,134,217,134,218,134,219,134,220,134,221,134,222,103,223,103,224,129,225,129,226,153,227,153,228,153,229,153,230,164,231,164,232,141,233,141,234,117,235,117,236,108,237,108,238,108,239,108,240,90,241,90,242,217,243,217,244,293,245,293,246,338,247,338,248,377,249,377,250,342,251,342,252,305,253,305,254,212,255,212,},[15]={0,98,1,98,2,99,3,99,4,99,5,99,6,99,7,99,8,174,9,174,10,263,11,263,12,338,13,338,14,410,15,410,16,410,17,410,18,312,19,312,20,247,21,247,22,194,23,194,24,243,25,243,26,297,27,297,28,270,29,270,30,170,31,170,32,113,33,113,34,99,35,99,36,72,37,72,38,72,39,72,40,72,41,72,42,63,43,63,44,63,45,63,46,63,47,63,48,63,49,63,50,63,51,63,204,116,205,116,206,116,207,116,208,116,209,116,210,134,211,134,212,134,213,134,214,134,215,134,216,134,217,134,218,134,219,134,220,134,221,134,222,103,223,103,224,129,225,129,226,153,227,153,228,153,229,153,230,164,231,164,232,141,233,141,234,117,235,117,236,108,237,108,238,108,239,108,240,90,241,90,242,217,243,217,244,293,245,293,246,338,247,338,248,377,249,377,250,342,251,342,252,305,253,305,254,212,255,212,},[16]={0,122,1,122,2,99,3,99,4,99,5,99,6,99,7,99,8,168,9,168,10,272,11,272,12,349,13,349,14,412,15,412,16,401,17,401,18,327,19,327,20,257,21,257,22,180,23,180,24,261,25,261,26,270,27,270,28,215,29,215,30,163,31,163,32,100,33,100,34,100,35,100,36,73,37,73,38,73,39,73,40,72,41,72,42,63,43,63,44,63,45,63,46,63,47,63,48,63,49,63,50,63,51,63,204,116,205,116,206,116,207,116,208,116,209,116,210,134,211,134,212,134,213,134,214,134,215,134,216,134,217,134,218,90,219,90,220,126,221,126,222,90,223,90,224,106,225,106,226,110,227,110,228,102,229,102,230,72,231,72,232,108,233,108,234,108,235,108,236,108,237,108,238,108,239,108,240,108,241,108,242,209,243,209,244,264,245,264,246,342,247,342,248,360,249,360,250,310,251,310,252,287,253,287,254,211,255,211,},[17]={0,122,1,122,2,99,3,99,4,99,5,99,6,99,7,99,8,168,9,168,10,272,11,272,12,349,13,349,14,412,15,412,16,401,17,401,18,327,19,327,20,257,21,257,22,180,23,180,24,261,25,261,26,270,27,270,28,215,29,215,30,163,31,163,32,100,33,100,34,100,35,100,36,73,37,73,38,73,39,73,40,72,41,72,42,63,43,63,44,63,45,63,46,63,47,63,48,63,49,63,50,63,51,63,204,116,205,116,206,116,207,116,208,116,209,116,210,134,211,134,212,134,213,134,214,134,215,134,216,134,217,134,218,90,219,90,220,126,221,126,222,90,223,90,224,106,225,106,226,110,227,110,228,102,229,102,230,72,231,72,232,108,233,108,234,108,235,108,236,108,237,108,238,108,239,108,240,108,241,108,242,209,243,209,244,264,245,264,246,342,247,342,248,360,249,360,250,310,251,310,252,287,253,287,254,211,255,211,},[18]={0,122,1,122,2,99,3,99,4,99,5,99,6,99,7,99,8,179,9,179,10,264,11,264,12,374,13,374,14,419,15,419,16,410,17,410,18,323,19,323,20,240,21,240,22,169,23,169,24,184,25,184,26,201,27,201,28,172,29,172,30,138,31,138,32,100,33,100,34,100,35,100,36,73,37,73,38,73,39,73,40,72,41,72,42,63,43,63,44,63,45,63,46,63,47,63,48,63,49,63,50,63,51,63,204,116,205,116,206,116,207,116,208,116,209,116,210,134,211,134,212,134,213,134,214,134,215,134,216,134,217,134,218,1,219,1,220,81,221,81,222,90,223,90,224,90,225,90,226,90,227,90,228,90,229,90,230,90,231,90,232,108,233,108,234,108,235,108,236,108,237,108,238,108,239,108,240,108,241,108,242,182,243,182,244,228,245,228,246,279,247,279,248,279,249,279,250,270,251,270,252,261,253,261,254,188,255,188,},[19]={0,122,1,122,2,99,3,99,4,99,5,99,6,99,7,99,8,179,9,179,10,264,11,264,12,374,13,374,14,419,15,419,16,410,17,410,18,323,19,323,20,240,21,240,22,169,23,169,24,184,25,184,26,201,27,201,28,172,29,172,30,138,31,138,32,100,33,100,34,100,35,100,36,73,37,73,38,73,39,73,40,72,41,72,42,63,43,63,44,63,45,63,46,63,47,63,48,63,49,63,50,63,51,63,204,116,205,116,206,116,207,116,208,116,209,116,210,134,211,134,212,134,213,134,214,134,215,134,216,134,217,134,218,1,219,1,220,81,221,81,222,90,223,90,224,90,225,90,226,90,227,90,228,90,229,90,230,90,231,90,232,108,233,108,234,108,235,108,236,108,237,108,238,108,239,108,240,108,241,108,242,182,243,182,244,228,245,228,246,279,247,279,248,279,249,279,250,270,251,270,252,261,253,261,254,188,255,188,},[20]={0,102,1,102,2,99,3,99,4,99,5,99,6,99,7,99,8,164,9,164,10,249,11,249,12,312,13,312,14,336,15,336,16,356,17,356,18,280,19,280,20,210,21,210,22,123,23,123,24,135,25,135,26,135,27,135,28,129,29,129,30,129,31,129,32,100,33,100,34,100,35,100,36,73,37,73,38,73,39,73,40,72,41,72,42,63,43,63,44,63,45,63,46,63,47,63,48,63,49,63,50,63,51,63,220,27,221,27,222,81,223,81,224,90,225,90,226,90,227,90,228,90,229,90,230,90,231,90,232,108,233,108,234,108,235,108,236,108,237,108,238,108,239,108,240,108,241,108,242,141,243,141,244,178,245,178,246,210,247,210,248,233,249,233,250,230,251,230,252,202,253,202,254,156,255,156,},[21]={0,102,1,102,2,99,3,99,4,99,5,99,6,99,7,99,8,164,9,164,10,249,11,249,12,312,13,312,14,336,15,336,16,356,17,356,18,280,19,280,20,210,21,210,22,123,23,123,24,135,25,135,26,135,27,135,28,129,29,129,30,129,31,129,32,100,33,100,34,100,35,100,36,73,37,73,38,73,39,73,40,72,41,72,42,63,43,63,44,63,45,63,46,63,47,63,48,63,49,63,50,63,51,63,220,27,221,27,222,81,223,81,224,90,225,90,226,90,227,90,228,90,229,90,230,90,231,90,232,108,233,108,234,108,235,108,236,108,237,108,238,108,239,108,240,108,241,108,242,141,243,141,244,178,245,178,246,210,247,210,248,233,249,233,250,230,251,230,252,202,253,202,254,156,255,156,},[22]={0,117,1,117,2,117,3,117,4,99,5,99,6,99,7,99,8,148,9,148,10,204,11,204,12,241,13,241,14,259,15,259,16,252,17,252,18,224,19,224,20,173,21,173,22,117,23,117,24,102,25,102,26,102,27,102,28,93,29,93,30,105,31,105,220,18,221,18,222,72,223,72,224,90,225,90,226,90,227,90,228,90,229,90,230,90,231,90,232,90,233,90,234,108,235,108,236,108,237,108,238,108,239,108,240,108,241,108,242,90,243,90,244,96,245,96,246,115,247,115,248,99,249,99,250,157,251,157,252,147,253,147,254,117,255,117,},[23]={0,117,1,117,2,117,3,117,4,99,5,99,6,99,7,99,8,148,9,148,10,204,11,204,12,241,13,241,14,259,15,259,16,252,17,252,18,224,19,224,20,173,21,173,22,117,23,117,24,102,25,102,26,102,27,102,28,93,29,93,30,105,31,105,220,18,221,18,222,72,223,72,224,90,225,90,226,90,227,90,228,90,229,90,230,90,231,90,232,90,233,90,234,108,235,108,236,108,237,108,238,108,239,108,240,108,241,108,242,90,243,90,244,96,245,96,246,115,247,115,248,99,249,99,250,157,251,157,252,147,253,147,254,117,255,117,},[24]={0,117,1,117,2,117,3,117,4,99,5,99,6,99,7,99,8,139,9,139,10,157,11,157,12,164,13,164,14,162,15,162,16,171,17,171,18,163,19,163,20,142,21,142,22,117,23,117,24,117,25,117,26,117,27,117,28,111,29,111,30,90,31,90,226,18,227,18,228,18,229,18,230,63,231,63,232,63,233,63,234,108,235,108,236,108,237,108,238,108,239,108,240,108,241,108,242,90,243,90,244,117,245,117,246,108,247,108,248,99,249,99,250,126,251,126,252,126,253,126,254,117,255,117,},[25]={0,117,1,117,2,117,3,117,4,99,5,99,6,99,7,99,8,139,9,139,10,157,11,157,12,164,13,164,14,162,15,162,16,171,17,171,18,163,19,163,20,142,21,142,22,117,23,117,24,117,25,117,26,117,27,117,28,111,29,111,30,90,31,90,226,18,227,18,228,18,229,18,230,63,231,63,232,63,233,63,234,108,235,108,236,108,237,108,238,108,239,108,240,108,241,108,242,90,243,90,244,117,245,117,246,108,247,108,248,99,249,99,250,126,251,126,252,126,253,126,254,117,255,117,},[26]={0,117,1,117,2,117,3,117,4,113,5,113,6,144,7,144,8,153,9,153,10,158,11,158,12,136,13,136,14,117,15,117,16,117,17,117,18,117,19,117,20,117,21,117,22,117,23,117,24,117,25,117,26,117,27,117,28,111,29,111,30,72,31,72,230,18,231,18,232,18,233,18,234,72,235,72,236,81,237,81,238,108,239,108,240,108,241,108,242,96,243,96,244,142,245,142,246,164,247,164,248,173,249,173,250,168,251,168,252,134,253,134,254,117,255,117,},[27]={0,117,1,117,2,117,3,117,4,113,5,113,6,144,7,144,8,153,9,153,10,158,11,158,12,136,13,136,14,117,15,117,16,117,17,117,18,117,19,117,20,117,21,117,22,117,23,117,24,117,25,117,26,117,27,117,28,111,29,111,30,72,31,72,230,18,231,18,232,18,233,18,234,72,235,72,236,81,237,81,238,108,239,108,240,108,241,108,242,96,243,96,244,142,245,142,246,164,247,164,248,173,249,173,250,168,251,168,252,134,253,134,254,117,255,117,},[28]={0,93,1,93,2,72,3,72,4,141,5,141,6,202,7,202,8,252,9,252,10,200,11,200,12,165,13,165,14,90,15,90,16,117,17,117,18,117,19,117,20,117,21,117,22,117,23,117,24,117,25,117,26,117,27,117,28,108,29,108,234,135,235,135,236,135,237,135,238,135,239,135,240,135,241,135,242,112,243,112,244,172,245,172,246,213,247,213,248,234,249,234,250,220,251,220,252,158,253,158,254,93,255,93,},[29]={0,93,1,93,2,72,3,72,4,141,5,141,6,202,7,202,8,252,9,252,10,200,11,200,12,165,13,165,14,90,15,90,16,117,17,117,18,117,19,117,20,117,21,117,22,117,23,117,24,117,25,117,26,117,27,117,28,108,29,108,234,135,235,135,236,135,237,135,238,135,239,135,240,135,241,135,242,112,243,112,244,172,245,172,246,213,247,213,248,234,249,234,250,220,251,220,252,158,253,158,254,93,255,93,},[30]={0,99,1,99,2,99,3,99,4,168,5,168,6,254,7,254,8,270,9,270,10,234,11,234,12,153,13,153,14,117,15,117,16,117,17,117,18,117,19,117,20,117,21,117,22,117,23,117,24,117,25,117,26,81,27,81,28,81,29,81,234,117,235,117,236,126,237,126,238,135,239,135,240,135,241,135,242,151,243,151,244,207,245,207,246,234,247,234,248,279,249,279,250,216,251,216,252,159,253,159,254,99,255,99,},[31]={0,99,1,99,2,99,3,99,4,168,5,168,6,254,7,254,8,270,9,270,10,234,11,234,12,153,13,153,14,117,15,117,16,117,17,117,18,117,19,117,20,117,21,117,22,117,23,117,24,117,25,117,26,81,27,81,28,81,29,81,234,117,235,117,236,126,237,126,238,135,239,135,240,135,241,135,242,151,243,151,244,207,245,207,246,234,247,234,248,279,249,279,250,216,251,216,252,159,253,159,254,99,255,99,},[32]={0,108,1,108,2,108,3,108,4,154,5,154,6,208,7,208,8,243,9,243,10,191,11,191,12,166,13,166,14,117,15,117,16,117,17,117,18,117,19,117,20,117,21,117,22,117,23,117,24,90,25,90,234,117,235,117,236,126,237,126,238,135,239,135,240,135,241,135,242,150,243,150,244,193,245,193,246,200,247,200,248,198,249,198,250,188,251,188,252,154,253,154,254,120,255,120,},[33]={0,108,1,108,2,108,3,108,4,154,5,154,6,208,7,208,8,243,9,243,10,191,11,191,12,166,13,166,14,117,15,117,16,117,17,117,18,117,19,117,20,117,21,117,22,117,23,117,24,90,25,90,234,117,235,117,236,126,237,126,238,135,239,135,240,135,241,135,242,150,243,150,244,193,245,193,246,200,247,200,248,198,249,198,250,188,251,188,252,154,253,154,254,120,255,120,},[34]={0,108,1,108,2,108,3,108,4,133,5,133,6,158,7,158,8,171,9,171,10,158,11,158,12,135,13,135,14,117,15,117,16,117,17,117,18,117,19,117,20,90,21,90,22,81,23,81,234,117,235,117,236,126,237,126,238,135,239,135,240,135,241,135,242,135,243,135,244,164,245,164,246,161,247,161,248,156,249,156,250,155,251,155,252,146,253,146,254,125,255,125,},[35]={0,108,1,108,2,108,3,108,4,133,5,133,6,158,7,158,8,171,9,171,10,158,11,158,12,135,13,135,14,117,15,117,16,117,17,117,18,117,19,117,20,90,21,90,22,81,23,81,234,117,235,117,236,126,237,126,238,135,239,135,240,135,241,135,242,135,243,135,244,164,245,164,246,161,247,161,248,156,249,156,250,155,251,155,252,146,253,146,254,125,255,125,},[36]={0,108,1,108,2,108,3,108,4,126,5,126,6,99,7,99,8,99,9,99,10,108,11,108,12,90,13,90,14,99,15,99,16,99,17,99,18,90,19,90,236,63,237,63,238,135,239,135,240,135,241,135,242,135,243,135,244,136,245,136,246,128,247,128,248,99,249,99,250,108,251,108,252,126,253,126,254,108,255,108,},[37]={0,108,1,108,2,108,3,108,4,126,5,126,6,99,7,99,8,99,9,99,10,108,11,108,12,90,13,90,14,99,15,99,16,99,17,99,18,90,19,90,236,63,237,63,238,135,239,135,240,135,241,135,242,135,243,135,244,136,245,136,246,128,247,128,248,99,249,99,250,108,251,108,252,126,253,126,254,108,255,108,},[38]={0,90,1,90,2,108,3,108,4,126,5,126,6,99,7,99,8,99,9,99,10,108,11,108,12,90,13,90,14,90,15,90,16,1,17,1,18,1,19,1,238,18,239,18,240,108,241,108,242,108,243,108,244,108,245,108,246,126,247,126,248,72,249,72,250,108,251,108,252,126,253,126,254,90,255,90,},[39]={0,90,1,90,2,108,3,108,4,126,5,126,6,99,7,99,8,99,9,99,10,108,11,108,12,90,13,90,14,90,15,90,16,1,17,1,18,1,19,1,238,18,239,18,240,108,241,108,242,108,243,108,244,108,245,108,246,126,247,126,248,72,249,72,250,108,251,108,252,126,253,126,254,90,255,90,},[40]={2,90,3,90,4,90,5,90,6,90,7,90,8,117,9,117,10,90,11,90,12,90,13,90,14,90,15,90,16,1,17,1,18,1,19,1,240,90,241,90,242,90,243,90,244,90,245,90,246,90,247,90,},[41]={2,90,3,90,4,90,5,90,6,90,7,90,8,117,9,117,10,90,11,90,12,90,13,90,14,90,15,90,16,1,17,1,18,1,19,1,240,90,241,90,242,90,243,90,244,90,245,90,246,90,247,90,},[42]={8,90,9,90,10,90,11,90,12,90,13,90,14,90,15,90,16,90,17,90,18,90,19,90,240,90,241,90,242,90,243,90,244,90,245,90,246,90,247,90,},[43]={8,90,9,90,10,90,11,90,12,90,13,90,14,90,15,90,16,90,17,90,18,90,19,90,240,90,241,90,242,90,243,90,244,90,245,90,246,90,247,90,},[44]={8,90,9,90,10,90,11,90,12,90,13,90,14,90,15,90,16,90,17,90,18,90,19,90,240,90,241,90,242,90,243,90,244,90,245,90,246,90,247,90,},[45]={8,90,9,90,10,90,11,90,12,90,13,90,14,90,15,90,16,90,17,90,18,90,19,90,240,90,241,90,242,90,243,90,244,90,245,90,246,90,247,90,},[46]={12,90,13,90,14,90,15,90,16,90,17,90,18,90,19,90,240,90,241,90,242,90,243,90,244,90,245,90,246,90,247,90,},[47]={12,90,13,90,14,90,15,90,16,90,17,90,18,90,19,90,240,90,241,90,242,90,243,90,244,90,245,90,246,90,247,90,},[48]={12,90,13,90,14,90,15,90,16,90,17,90,18,90,19,90,240,81,241,81,242,81,243,81,244,81,245,81,246,81,247,81,},[49]={12,90,13,90,14,90,15,90,16,90,17,90,18,90,19,90,240,81,241,81,242,81,243,81,244,81,245,81,246,81,247,81,},[50]={12,97,13,97,14,97,15,97,16,97,17,97,18,97,19,97,240,81,241,81,242,81,243,81,244,81,245,81,246,81,247,81,},[51]={12,97,13,97,14,97,15,97,16,97,17,97,18,97,19,97,240,81,241,81,242,81,243,81,244,81,245,81,246,81,247,81,},[52]={12,97,13,97,14,97,15,97,16,97,17,97,18,97,19,97,240,81,241,81,242,81,243,81,244,81,245,81,246,81,247,81,},[53]={12,97,13,97,14,97,15,97,16,97,17,97,18,97,19,97,240,81,241,81,242,81,243,81,244,81,245,81,246,81,247,81,},[54]={12,97,13,97,14,97,15,97,16,97,17,97,18,97,19,97,},[55]={12,97,13,97,14,97,15,97,16,97,17,97,18,97,19,97,},[204]={4,72,5,72,6,72,7,72,8,72,9,72,10,72,11,72,},[205]={4,72,5,72,6,72,7,72,8,72,9,72,10,72,11,72,},[206]={4,72,5,72,6,72,7,72,8,72,9,72,10,72,11,72,},[207]={4,72,5,72,6,72,7,72,8,72,9,72,10,72,11,72,},[208]={4,81,5,81,6,81,7,81,8,81,9,81,10,81,11,81,},[209]={4,81,5,81,6,81,7,81,8,81,9,81,10,81,11,81,},[210]={4,90,5,90,6,90,7,90,8,90,9,90,10,90,11,90,226,81,227,81,228,81,229,81,230,81,231,81,232,81,233,81,},[211]={4,90,5,90,6,90,7,90,8,90,9,90,10,90,11,90,226,81,227,81,228,81,229,81,230,81,231,81,232,81,233,81,},[212]={4,90,5,90,6,90,7,90,8,90,9,90,10,90,11,90,226,81,227,81,228,81,229,81,230,81,231,81,232,81,233,81,},[213]={4,90,5,90,6,90,7,90,8,90,9,90,10,90,11,90,226,81,227,81,228,81,229,81,230,81,231,81,232,81,233,81,},[214]={4,90,5,90,6,90,7,90,8,90,9,90,10,90,11,90,226,81,227,81,228,81,229,81,230,96,231,96,232,96,233,96,234,63,235,63,236,63,237,63,},[215]={4,90,5,90,6,90,7,90,8,90,9,90,10,90,11,90,226,81,227,81,228,81,229,81,230,96,231,96,232,96,233,96,234,63,235,63,236,63,237,63,},[216]={4,90,5,90,6,90,7,90,8,90,9,90,10,90,11,90,226,81,227,81,228,81,229,81,230,96,231,96,232,96,233,96,234,63,235,63,236,63,237,63,},[217]={4,90,5,90,6,90,7,90,8,90,9,90,10,90,11,90,226,81,227,81,228,81,229,81,230,96,231,96,232,96,233,96,234,63,235,63,236,63,237,63,},[218]={4,117,5,117,6,117,7,117,8,117,9,117,10,117,11,117,230,63,231,63,232,63,233,63,234,87,235,87,236,87,237,87,238,63,239,63,240,63,241,63,},[219]={4,117,5,117,6,117,7,117,8,117,9,117,10,117,11,117,230,63,231,63,232,63,233,63,234,87,235,87,236,87,237,87,238,63,239,63,240,63,241,63,},[220]={4,117,5,117,6,117,7,117,8,117,9,117,10,117,11,117,40,90,41,90,42,90,43,90,44,90,45,90,46,90,47,90,230,63,231,63,232,63,233,63,234,87,235,87,236,63,237,63,238,63,239,63,240,63,241,63,},[221]={4,117,5,117,6,117,7,117,8,117,9,117,10,117,11,117,40,90,41,90,42,90,43,90,44,90,45,90,46,90,47,90,230,63,231,63,232,63,233,63,234,87,235,87,236,63,237,63,238,63,239,63,240,63,241,63,},[222]={2,27,3,27,4,117,5,117,6,117,7,117,8,117,9,117,10,162,11,162,12,72,13,72,14,72,15,72,16,54,17,54,40,90,41,90,42,90,43,90,44,90,45,90,46,90,47,90,234,72,235,72,236,63,237,63,238,63,239,63,240,63,241,63,},[223]={2,27,3,27,4,117,5,117,6,117,7,117,8,117,9,117,10,162,11,162,12,72,13,72,14,72,15,72,16,54,17,54,40,90,41,90,42,90,43,90,44,90,45,90,46,90,47,90,234,72,235,72,236,63,237,63,238,63,239,63,240,63,241,63,},[224]={0,125,1,125,2,125,3,125,4,133,5,133,6,162,7,162,8,162,9,162,10,158,11,158,12,136,13,136,14,115,15,115,16,108,17,108,18,63,19,63,36,72,37,72,38,72,39,72,40,90,41,90,42,90,43,90,44,90,45,90,46,90,47,90,234,72,235,72,236,63,237,63,238,63,239,63,240,108,241,108,242,90,243,90,244,63,245,63,246,107,247,107,248,81,249,81,250,107,251,107,252,107,253,107,254,107,255,107,},[225]={0,125,1,125,2,125,3,125,4,133,5,133,6,162,7,162,8,162,9,162,10,158,11,158,12,136,13,136,14,115,15,115,16,108,17,108,18,63,19,63,36,72,37,72,38,72,39,72,40,90,41,90,42,90,43,90,44,90,45,90,46,90,47,90,234,72,235,72,236,63,237,63,238,63,239,63,240,108,241,108,242,90,243,90,244,63,245,63,246,107,247,107,248,81,249,81,250,107,251,107,252,107,253,107,254,107,255,107,},[226]={0,117,1,117,2,125,3,125,4,168,5,168,6,225,7,225,8,243,9,243,10,207,11,207,12,159,13,159,14,115,15,115,16,115,17,115,18,97,19,97,20,45,21,45,22,45,23,45,24,36,25,36,26,27,27,27,36,72,37,72,38,72,39,72,40,90,41,90,42,90,43,90,44,90,45,90,46,90,47,90,234,72,235,72,236,79,237,79,238,109,239,109,240,138,241,138,242,159,243,159,244,138,245,138,246,114,247,114,248,81,249,81,250,81,251,81,252,81,253,81,254,99,255,99,},[227]={0,117,1,117,2,125,3,125,4,168,5,168,6,225,7,225,8,243,9,243,10,207,11,207,12,159,13,159,14,115,15,115,16,115,17,115,18,97,19,97,20,45,21,45,22,45,23,45,24,36,25,36,26,27,27,27,36,72,37,72,38,72,39,72,40,90,41,90,42,90,43,90,44,90,45,90,46,90,47,90,234,72,235,72,236,79,237,79,238,109,239,109,240,138,241,138,242,159,243,159,244,138,245,138,246,114,247,114,248,81,249,81,250,81,251,81,252,81,253,81,254,99,255,99,},[228]={0,117,1,117,2,125,3,125,4,180,5,180,6,226,7,226,8,279,9,279,10,234,11,234,12,169,13,169,14,115,15,115,16,142,17,142,18,124,19,124,20,81,21,81,22,90,23,90,24,63,25,63,26,63,27,63,28,72,29,72,30,90,31,90,32,90,33,90,34,90,35,90,36,90,37,90,38,90,39,90,40,72,41,72,42,72,43,72,234,36,235,36,236,79,237,79,238,135,239,135,240,191,241,191,242,237,243,237,244,192,245,192,246,146,247,146,248,110,249,110,250,81,251,81,252,81,253,81,254,99,255,99,},[229]={0,117,1,117,2,125,3,125,4,180,5,180,6,226,7,226,8,279,9,279,10,234,11,234,12,169,13,169,14,115,15,115,16,142,17,142,18,124,19,124,20,81,21,81,22,90,23,90,24,63,25,63,26,63,27,63,28,72,29,72,30,90,31,90,32,90,33,90,34,90,35,90,36,90,37,90,38,90,39,90,40,72,41,72,42,72,43,72,234,36,235,36,236,79,237,79,238,135,239,135,240,191,241,191,242,237,243,237,244,192,245,192,246,146,247,146,248,110,249,110,250,81,251,81,252,81,253,81,254,99,255,99,},[230]={0,117,1,117,2,125,3,125,4,167,5,167,6,234,7,234,8,279,9,279,10,216,11,216,12,159,13,159,14,97,15,97,16,124,17,124,18,124,19,124,20,126,21,126,22,129,23,129,24,134,25,134,26,127,27,127,28,105,29,105,30,90,31,90,32,90,33,90,34,90,35,90,36,90,37,90,38,90,39,90,40,72,41,72,42,72,43,72,234,36,235,36,236,63,237,63,238,153,239,153,240,270,241,270,242,324,243,324,244,261,245,261,246,163,247,163,248,112,249,112,250,81,251,81,252,81,253,81,254,99,255,99,},[231]={0,117,1,117,2,125,3,125,4,167,5,167,6,234,7,234,8,279,9,279,10,216,11,216,12,159,13,159,14,97,15,97,16,124,17,124,18,124,19,124,20,126,21,126,22,129,23,129,24,134,25,134,26,127,27,127,28,105,29,105,30,90,31,90,32,90,33,90,34,90,35,90,36,90,37,90,38,90,39,90,40,72,41,72,42,72,43,72,234,36,235,36,236,63,237,63,238,153,239,153,240,270,241,270,242,324,243,324,244,261,245,261,246,163,247,163,248,112,249,112,250,81,251,81,252,81,253,81,254,99,255,99,},[232]={0,81,1,81,2,99,3,99,4,146,5,146,6,179,7,179,8,189,9,189,10,177,11,177,12,140,13,140,14,97,15,97,16,124,17,124,18,126,19,126,20,152,21,152,22,184,23,184,24,203,25,203,26,180,27,180,28,131,29,131,30,90,31,90,32,90,33,90,34,90,35,90,36,90,37,90,38,54,39,54,234,54,235,54,236,81,237,81,238,144,239,144,240,207,241,207,242,261,243,261,244,190,245,190,246,139,247,139,248,97,249,97,250,54,251,54,252,54,253,54,254,81,255,81,},[233]={0,81,1,81,2,99,3,99,4,146,5,146,6,179,7,179,8,189,9,189,10,177,11,177,12,140,13,140,14,97,15,97,16,124,17,124,18,126,19,126,20,152,21,152,22,184,23,184,24,203,25,203,26,180,27,180,28,131,29,131,30,90,31,90,32,90,33,90,34,90,35,90,36,90,37,90,38,54,39,54,234,54,235,54,236,81,237,81,238,144,239,144,240,207,241,207,242,261,243,261,244,190,245,190,246,139,247,139,248,97,249,97,250,54,251,54,252,54,253,54,254,81,255,81,},[234]={0,81,1,81,2,99,3,99,4,116,5,116,6,138,7,138,8,147,9,147,10,132,11,132,12,115,13,115,14,97,15,97,16,124,17,124,18,108,19,108,20,148,21,148,22,203,23,203,24,279,25,279,26,193,27,193,28,150,29,150,30,90,31,90,32,90,33,90,34,90,35,90,36,90,37,90,38,54,39,54,208,99,209,99,210,99,211,99,212,99,213,99,214,99,215,99,230,45,231,45,232,73,233,73,234,73,235,73,236,90,237,90,238,118,239,118,240,138,241,138,242,142,243,142,244,125,245,125,246,97,247,97,248,69,249,69,250,45,251,45,252,63,253,63,254,81,255,81,},[235]={0,81,1,81,2,99,3,99,4,116,5,116,6,138,7,138,8,147,9,147,10,132,11,132,12,115,13,115,14,97,15,97,16,124,17,124,18,108,19,108,20,148,21,148,22,203,23,203,24,279,25,279,26,193,27,193,28,150,29,150,30,90,31,90,32,90,33,90,34,90,35,90,36,90,37,90,38,54,39,54,208,99,209,99,210,99,211,99,212,99,213,99,214,99,215,99,230,45,231,45,232,73,233,73,234,73,235,73,236,90,237,90,238,118,239,118,240,138,241,138,242,142,243,142,244,125,245,125,246,97,247,97,248,69,249,69,250,45,251,45,252,63,253,63,254,81,255,81,},[236]={0,102,1,102,2,121,3,121,4,130,5,130,6,81,7,81,8,81,9,81,10,126,11,126,12,144,13,144,14,106,15,106,16,90,17,90,18,81,19,81,20,119,21,119,22,168,23,168,24,176,25,176,26,167,27,167,28,144,29,144,30,117,31,117,32,90,33,90,34,90,35,90,36,45,37,45,208,99,209,99,210,99,211,99,212,99,213,99,214,99,215,99,230,45,231,45,232,73,233,73,234,73,235,73,236,90,237,90,238,90,239,90,240,72,241,72,242,63,243,63,244,45,245,45,246,60,247,60,248,56,249,56,250,45,251,45,252,90,253,90,254,102,255,102,},[237]={0,102,1,102,2,121,3,121,4,130,5,130,6,81,7,81,8,81,9,81,10,126,11,126,12,144,13,144,14,106,15,106,16,90,17,90,18,81,19,81,20,119,21,119,22,168,23,168,24,176,25,176,26,167,27,167,28,144,29,144,30,117,31,117,32,90,33,90,34,90,35,90,36,45,37,45,208,99,209,99,210,99,211,99,212,99,213,99,214,99,215,99,230,45,231,45,232,73,233,73,234,73,235,73,236,90,237,90,238,90,239,90,240,72,241,72,242,63,243,63,244,45,245,45,246,60,247,60,248,56,249,56,250,45,251,45,252,90,253,90,254,102,255,102,},[238]={0,116,1,116,2,147,3,147,4,164,5,164,6,174,7,174,8,179,9,179,10,183,11,183,12,178,13,178,14,171,15,171,16,130,17,130,18,45,19,45,20,63,21,63,22,124,23,124,24,133,25,133,26,131,27,131,28,128,29,128,30,81,31,81,32,54,33,54,34,54,35,54,36,54,37,54,208,99,209,99,210,99,211,99,212,99,213,99,214,99,215,99,216,90,217,90,218,90,219,90,220,1,221,1,222,1,223,1,224,45,225,45,226,45,227,45,228,45,229,45,230,73,231,73,232,73,233,73,234,73,235,73,236,90,237,90,238,90,239,90,240,63,241,63,242,45,243,45,244,45,245,45,246,45,247,45,248,45,249,45,250,45,251,45,252,99,253,99,254,102,255,102,},[239]={0,116,1,116,2,147,3,147,4,164,5,164,6,174,7,174,8,179,9,179,10,183,11,183,12,178,13,178,14,171,15,171,16,130,17,130,18,45,19,45,20,63,21,63,22,124,23,124,24,133,25,133,26,131,27,131,28,128,29,128,30,81,31,81,32,54,33,54,34,54,35,54,36,54,37,54,208,99,209,99,210,99,211,99,212,99,213,99,214,99,215,99,216,90,217,90,218,90,219,90,220,1,221,1,222,1,223,1,224,45,225,45,226,45,227,45,228,45,229,45,230,73,231,73,232,73,233,73,234,73,235,73,236,90,237,90,238,90,239,90,240,63,241,63,242,45,243,45,244,45,245,45,246,45,247,45,248,45,249,45,250,45,251,45,252,99,253,99,254,102,255,102,},[240]={0,128,1,128,2,174,3,174,4,200,5,200,6,233,7,233,8,270,9,270,10,252,11,252,12,230,13,230,14,204,15,204,16,159,17,159,18,111,19,111,20,83,21,83,22,83,23,83,24,90,25,90,26,90,27,90,28,90,29,90,30,117,31,117,32,90,33,90,34,90,35,90,36,90,37,90,208,99,209,99,210,99,211,99,212,99,213,99,214,99,215,99,216,108,217,108,218,108,219,108,220,108,221,108,222,108,223,108,224,63,225,63,226,45,227,45,228,45,229,45,230,73,231,73,232,73,233,73,234,73,235,73,236,90,237,90,238,90,239,90,240,45,241,45,242,45,243,45,244,45,245,45,246,45,247,45,248,45,249,45,250,45,251,45,252,90,253,90,254,72,255,72,},[241]={0,128,1,128,2,174,3,174,4,200,5,200,6,233,7,233,8,270,9,270,10,252,11,252,12,230,13,230,14,204,15,204,16,159,17,159,18,111,19,111,20,83,21,83,22,83,23,83,24,90,25,90,26,90,27,90,28,90,29,90,30,117,31,117,32,90,33,90,34,90,35,90,36,90,37,90,208,99,209,99,210,99,211,99,212,99,213,99,214,99,215,99,216,108,217,108,218,108,219,108,220,108,221,108,222,108,223,108,224,63,225,63,226,45,227,45,228,45,229,45,230,73,231,73,232,73,233,73,234,73,235,73,236,90,237,90,238,90,239,90,240,45,241,45,242,45,243,45,244,45,245,45,246,45,247,45,248,45,249,45,250,45,251,45,252,90,253,90,254,72,255,72,},[242]={0,120,1,120,2,188,3,188,4,232,5,232,6,275,7,275,8,307,9,307,10,299,11,299,12,290,13,290,14,234,15,234,16,190,17,190,18,129,19,129,20,99,21,99,22,99,23,99,24,99,25,99,26,99,27,99,28,99,29,99,30,117,31,117,32,90,33,90,34,90,35,90,36,90,37,90,38,18,39,18,212,90,213,90,214,99,215,99,216,108,217,108,218,108,219,108,220,108,221,108,222,125,223,125,224,137,225,137,226,147,227,147,228,129,229,129,230,103,231,103,232,55,233,55,234,55,235,55,236,55,237,55,238,73,239,73,240,27,241,27,242,45,243,45,244,45,245,45,246,63,247,63,248,63,249,63,250,72,251,72,252,102,253,102,254,102,255,102,},[243]={0,120,1,120,2,188,3,188,4,232,5,232,6,275,7,275,8,307,9,307,10,299,11,299,12,290,13,290,14,234,15,234,16,190,17,190,18,129,19,129,20,99,21,99,22,99,23,99,24,99,25,99,26,99,27,99,28,99,29,99,30,117,31,117,32,90,33,90,34,90,35,90,36,90,37,90,38,18,39,18,212,90,213,90,214,99,215,99,216,108,217,108,218,108,219,108,220,108,221,108,222,125,223,125,224,137,225,137,226,147,227,147,228,129,229,129,230,103,231,103,232,55,233,55,234,55,235,55,236,55,237,55,238,73,239,73,240,27,241,27,242,45,243,45,244,45,245,45,246,63,247,63,248,63,249,63,250,72,251,72,252,102,253,102,254,102,255,102,},[244]={0,72,1,72,2,189,3,189,4,256,5,256,6,299,7,299,8,334,9,334,10,369,11,369,12,324,13,324,14,252,15,252,16,199,17,199,18,117,19,117,20,99,21,99,22,99,23,99,24,90,25,90,26,75,27,75,28,90,29,90,30,90,31,90,32,90,33,90,34,91,35,91,36,90,37,90,38,36,39,36,212,90,213,90,214,99,215,99,216,108,217,108,218,108,219,108,220,108,221,108,222,160,223,160,224,185,225,185,226,206,227,206,228,202,229,202,230,145,231,145,232,92,233,92,234,103,235,103,236,110,237,110,238,96,239,96,240,27,241,27,242,45,243,45,244,45,245,45,246,63,247,63,248,63,249,63,250,72,251,72,252,102,253,102,254,102,255,102,},[245]={0,72,1,72,2,189,3,189,4,256,5,256,6,299,7,299,8,334,9,334,10,369,11,369,12,324,13,324,14,252,15,252,16,199,17,199,18,117,19,117,20,99,21,99,22,99,23,99,24,90,25,90,26,75,27,75,28,90,29,90,30,90,31,90,32,90,33,90,34,91,35,91,36,90,37,90,38,36,39,36,212,90,213,90,214,99,215,99,216,108,217,108,218,108,219,108,220,108,221,108,222,160,223,160,224,185,225,185,226,206,227,206,228,202,229,202,230,145,231,145,232,92,233,92,234,103,235,103,236,110,237,110,238,96,239,96,240,27,241,27,242,45,243,45,244,45,245,45,246,63,247,63,248,63,249,63,250,72,251,72,252,102,253,102,254,102,255,102,},[246]={0,63,1,63,2,181,3,181,4,244,5,244,6,300,7,300,8,370,9,370,10,406,11,406,12,330,13,330,14,251,15,251,16,187,17,187,18,108,19,108,20,99,21,99,22,99,23,99,24,122,25,122,26,146,27,146,28,154,29,154,30,147,31,147,32,122,33,122,34,100,35,100,36,90,37,90,38,36,39,36,214,54,215,54,216,108,217,108,218,108,219,108,220,108,221,108,222,175,223,175,224,200,225,200,226,306,227,306,228,266,229,266,230,183,231,183,232,121,233,121,234,159,235,159,236,185,237,185,238,184,239,184,240,165,241,165,242,137,243,137,244,106,245,106,246,54,247,54,248,72,249,72,250,72,251,72,252,102,253,102,254,102,255,102,},[247]={0,63,1,63,2,181,3,181,4,244,5,244,6,300,7,300,8,370,9,370,10,406,11,406,12,330,13,330,14,251,15,251,16,187,17,187,18,108,19,108,20,99,21,99,22,99,23,99,24,122,25,122,26,146,27,146,28,154,29,154,30,147,31,147,32,122,33,122,34,100,35,100,36,90,37,90,38,36,39,36,214,54,215,54,216,108,217,108,218,108,219,108,220,108,221,108,222,175,223,175,224,200,225,200,226,306,227,306,228,266,229,266,230,183,231,183,232,121,233,121,234,159,235,159,236,185,237,185,238,184,239,184,240,165,241,165,242,137,243,137,244,106,245,106,246,54,247,54,248,72,249,72,250,72,251,72,252,102,253,102,254,102,255,102,},[248]={0,63,1,63,2,156,3,156,4,217,5,217,6,267,7,267,8,306,9,306,10,311,11,311,12,287,13,287,14,236,15,236,16,166,17,166,18,72,19,72,20,72,21,72,22,110,23,110,24,154,25,154,26,203,27,203,28,243,29,243,30,192,31,192,32,153,33,153,34,99,35,99,36,54,37,54,38,36,39,36,216,63,217,63,218,63,219,63,220,90,221,90,222,147,223,147,224,191,225,191,226,210,227,210,228,208,229,208,230,176,231,176,232,148,233,148,234,214,235,214,236,258,237,258,238,285,239,285,240,271,241,271,242,233,243,233,244,160,245,160,246,106,247,106,248,72,249,72,250,72,251,72,252,102,253,102,254,102,255,102,},[249]={0,63,1,63,2,156,3,156,4,217,5,217,6,267,7,267,8,306,9,306,10,311,11,311,12,287,13,287,14,236,15,236,16,166,17,166,18,72,19,72,20,72,21,72,22,110,23,110,24,154,25,154,26,203,27,203,28,243,29,243,30,192,31,192,32,153,33,153,34,99,35,99,36,54,37,54,38,36,39,36,216,63,217,63,218,63,219,63,220,90,221,90,222,147,223,147,224,191,225,191,226,210,227,210,228,208,229,208,230,176,231,176,232,148,233,148,234,214,235,214,236,258,237,258,238,285,239,285,240,271,241,271,242,233,243,233,244,160,245,160,246,106,247,106,248,72,249,72,250,72,251,72,252,102,253,102,254,102,255,102,},[250]={0,27,1,27,2,123,3,123,4,171,5,171,6,213,7,213,8,243,9,243,10,254,11,254,12,242,13,242,14,215,15,215,16,148,17,148,18,63,19,63,20,54,21,54,22,118,23,118,24,183,25,183,26,255,27,255,28,297,29,297,30,234,31,234,32,174,33,174,34,107,35,107,36,61,37,61,38,18,39,18,220,54,221,54,222,112,223,112,224,149,225,149,226,148,227,148,228,141,229,141,230,147,231,147,232,172,233,172,234,272,235,272,236,376,237,376,238,381,239,381,240,385,241,385,242,270,243,270,244,186,245,186,246,127,247,127,248,18,249,18,250,9,251,9,252,1,253,1,254,1,255,1,},[251]={0,27,1,27,2,123,3,123,4,171,5,171,6,213,7,213,8,243,9,243,10,254,11,254,12,242,13,242,14,215,15,215,16,148,17,148,18,63,19,63,20,54,21,54,22,118,23,118,24,183,25,183,26,255,27,255,28,297,29,297,30,234,31,234,32,174,33,174,34,107,35,107,36,61,37,61,38,18,39,18,220,54,221,54,222,112,223,112,224,149,225,149,226,148,227,148,228,141,229,141,230,147,231,147,232,172,233,172,234,272,235,272,236,376,237,376,238,381,239,381,240,385,241,385,242,270,243,270,244,186,245,186,246,127,247,127,248,18,249,18,250,9,251,9,252,1,253,1,254,1,255,1,},[252]={4,125,5,125,6,170,7,170,8,207,9,207,10,217,11,217,12,207,13,207,14,186,15,186,16,135,17,135,18,90,19,90,20,81,21,81,22,116,23,116,24,163,25,163,26,205,27,205,28,231,29,231,30,208,31,208,32,158,33,158,34,96,35,96,36,36,37,36,220,54,221,54,222,90,223,90,224,90,225,90,226,90,227,90,228,63,229,63,230,63,231,63,232,188,233,188,234,290,235,290,236,412,237,412,238,466,239,466,240,412,241,412,242,280,243,280,244,185,245,185,246,115,247,115,248,18,249,18,250,9,251,9,},[253]={4,125,5,125,6,170,7,170,8,207,9,207,10,217,11,217,12,207,13,207,14,186,15,186,16,135,17,135,18,90,19,90,20,81,21,81,22,116,23,116,24,163,25,163,26,205,27,205,28,231,29,231,30,208,31,208,32,158,33,158,34,96,35,96,36,36,37,36,220,54,221,54,222,90,223,90,224,90,225,90,226,90,227,90,228,63,229,63,230,63,231,63,232,188,233,188,234,290,235,290,236,412,237,412,238,466,239,466,240,412,241,412,242,280,243,280,244,185,245,185,246,115,247,115,248,18,249,18,250,9,251,9,},[254]={6,63,7,63,8,156,9,156,10,175,11,175,12,170,13,170,14,150,15,150,16,123,17,123,18,81,19,81,20,54,21,54,22,105,23,105,24,137,25,137,26,160,27,160,28,171,29,171,30,158,31,158,32,125,33,125,34,85,35,85,36,9,37,9,220,54,221,54,222,90,223,90,224,90,225,90,226,90,227,90,228,63,229,63,230,109,231,109,232,182,233,182,234,284,235,284,236,403,237,403,238,439,239,439,240,358,241,358,242,257,243,257,244,175,245,175,246,63,247,63,248,27,249,27,250,18,251,18,},[255]={6,63,7,63,8,156,9,156,10,175,11,175,12,170,13,170,14,150,15,150,16,123,17,123,18,81,19,81,20,54,21,54,22,105,23,105,24,137,25,137,26,160,27,160,28,171,29,171,30,158,31,158,32,125,33,125,34,85,35,85,36,9,37,9,220,54,221,54,222,90,223,90,224,90,225,90,226,90,227,90,228,63,229,63,230,109,231,109,232,182,233,182,234,284,235,284,236,403,237,403,238,439,239,439,240,358,241,358,242,257,243,257,244,175,245,175,246,63,247,63,248,27,249,27,250,18,251,18,}
		},
		
		markers ={
			206, 6, 212, 228, 236, 210, 14, 206, 48, 242, 50, 14, 16, 46, 222, 42
		},
		
		objects = {
			[8]={228,5,12,-1,768,},[14]={26,5,12,-1,256,248,5,12,-1,512,},[16]={14,5,12,-1,256,},[28]={244,5,12,-1,768,},[30]={6,5,12,-1,512,},[228]={8,5,12,-1,1536,242,5,12,-1,1280,},[232]={22,5,12,-1,1792,},[246]={8,5,12,-1,1792,224,5,12,-1,1024,},[250]={28,5,12,-1,0,},[252]={236,5,12,-1,1024,}
		},
		
		shaman_positions = {
			206, 6, 212, 228, 236, 210, 14, 206, 48, 242, 50, 14, 16, 46, 222, 42
		},
		
		scripts = {
			OnTurn = function(everySecond1, everySecond2, everySecond4) 			tempest_on_turn(everySecond1, everySecond2, everySecond4) end,
			OnCreateThing = function(t, owner, type, model) 						tempest_on_create_thing(t, owner, type, model) end,
			OnShamanDeath = function(victim, killer, killer_was_ally)				tempest_on_shaman_dead(victim, killer, killer_was_ally) end,
			OnHumanDisconnect = function(player) 									TP_init_single_AI(player) end,
		},
		
	},
	
	[MAP_TILES_WAR]={
	
		info = 	{ 	name = "Tiles War", author = "Divinity",
					desc = "As the shamans move, the ground underneath them darkens. Once it reaches the maximum darkness, it kills the shaman that step on it. <p> Occasionally, the arena's darkness resets to a random value. <br> Shamans earn points while moving in the arena, dodging dark tiles, and trying to get powerups.",
					map_objectives = { {value=5, step=1, default=true}, {value=500, step=100, limit=1000, default=true}, {} },
					image = 3488, texture=function() return (is_map_rule_active(1)) and {1, 0} or (is_map_rule_active(2)) and {14, 0} or {18, 0} end, zoom={30,48,512}, drop_infos = true,	marker_lb={156,168}, reinc_timer=12*3, shield_respawn=true, custom_shield_spawn_timer = 2, optional_shaman_zoom_angle = function(tribe) return ((tribe % 2) == 0) and 512 or 1536 end,
					custom_rules = {
						{ default = true, 	name = "Sand Texture", desc = "Play this mini-game using the sand texture.", OnPostClick = function() set_all_custom_rules_except(false, 1) end, no_click_msg = true },
						{ default = false, 	name = "Grass Texture", desc = "Play this mini-game using the grass texture.", OnPostClick = function() set_all_custom_rules_except(false, 2) end, no_click_msg = true },
						{ default = false, 	name = "Night Texture", desc = "Play this mini-game using the night texture.", OnPostClick = function() set_all_custom_rules_except(false, 3) end, no_click_msg = true },
						-- { default = false, 	name = "No Power-ups", desc = "Play this mini-game without power-ups." },
						-- { default = false, 	name = "No Spells", desc = "Play this mini-game without owned spells (you can still obtain spells if they come from powerups)." },
					}
				},
	
		land ={
			[32]={30,512,31,512,32,512,33,512,34,512,35,512,36,512,37,512,38,512,39,512,40,512,41,512,42,512,43,512,44,512,45,512,46,512,47,512,48,512,49,512,50,512,51,512,52,512,53,512,54,512,55,512,56,512,57,512,58,512,59,512,60,512,61,512,62,512,63,512,64,512,65,512,66,512,67,512,68,512,69,512,},[33]={30,512,31,512,32,512,33,512,34,512,35,512,36,512,37,512,38,512,39,512,40,512,41,512,42,512,43,512,44,512,45,512,46,512,47,512,48,512,49,512,50,512,51,512,52,512,53,512,54,512,55,512,56,512,57,512,58,512,59,512,60,512,61,512,62,512,63,512,64,512,65,512,66,512,67,512,68,512,69,512,},[34]={30,512,31,512,32,512,33,512,34,512,35,512,36,512,37,512,38,512,39,512,40,512,41,512,42,512,43,512,44,512,45,512,46,512,47,512,48,512,49,512,50,512,51,512,52,512,53,512,54,512,55,512,56,512,57,512,58,512,59,512,60,512,61,512,62,512,63,512,64,512,65,512,66,512,67,512,68,512,69,512,},[35]={30,512,31,512,32,512,33,512,34,512,35,512,36,512,37,512,38,512,39,512,40,512,41,512,42,512,43,512,44,512,45,512,46,512,47,512,48,512,49,512,50,512,51,512,52,512,53,512,54,512,55,512,56,512,57,512,58,512,59,512,60,512,61,512,62,512,63,512,64,512,65,512,66,512,67,512,68,512,69,512,},[36]={30,512,31,512,32,512,33,512,34,512,35,512,36,512,37,512,38,512,39,512,40,512,41,512,42,512,43,512,44,512,45,512,46,512,47,512,48,512,49,512,50,512,51,512,52,512,53,512,54,512,55,512,56,512,57,512,58,512,59,512,60,512,61,512,62,512,63,512,64,512,65,512,66,512,67,512,68,512,69,512,},[37]={30,512,31,512,32,512,33,512,34,512,35,512,36,512,37,512,38,512,39,512,40,512,41,512,42,512,43,512,44,512,45,512,46,512,47,512,48,512,49,512,50,512,51,512,52,512,53,512,54,512,55,512,56,512,57,512,58,512,59,512,60,512,61,512,62,512,63,512,64,512,65,512,66,512,67,512,68,512,69,512,},[38]={30,512,31,512,32,512,33,512,34,512,35,512,36,512,37,512,38,512,39,512,40,512,41,512,42,512,43,512,44,512,45,512,46,512,47,512,48,512,49,512,50,512,51,512,52,512,53,512,54,512,55,512,56,512,57,512,58,512,59,512,60,512,61,512,62,512,63,512,64,512,65,512,66,512,67,512,68,512,69,512,},[39]={30,512,31,512,32,512,33,512,34,512,35,512,36,512,37,512,38,512,39,512,40,512,41,512,42,512,43,512,44,512,45,512,46,512,47,512,48,512,49,512,50,512,51,512,52,512,53,512,54,512,55,512,56,512,57,512,58,512,59,512,60,512,61,512,62,512,63,512,64,512,65,512,66,512,67,512,68,512,69,512,},[40]={30,390,31,390,32,390,33,390,34,390,35,390,36,390,37,390,38,398,39,398,40,398,41,398,42,398,43,398,44,398,45,398,46,391,47,391,48,391,49,391,50,391,51,391,52,391,53,391,54,391,55,391,56,391,57,391,58,391,59,391,60,391,61,391,62,391,63,391,64,391,65,391,66,391,67,391,68,391,69,391,},[41]={30,390,31,390,32,390,33,390,34,390,35,390,36,390,37,390,38,398,39,398,40,398,41,398,42,398,43,398,44,398,45,398,46,391,47,391,48,391,49,391,50,391,51,391,52,391,53,391,54,391,55,391,56,391,57,391,58,391,59,391,60,391,61,391,62,391,63,391,64,391,65,391,66,391,67,391,68,391,69,391,},[42]={30,390,31,390,32,390,33,390,34,390,35,390,36,392,37,392,38,392,39,392,40,392,41,392,42,392,43,392,44,392,45,392,46,392,47,392,48,392,49,392,50,391,51,391,52,391,53,391,54,391,55,391,56,391,57,391,58,391,59,391,60,391,61,391,62,391,63,391,64,391,65,391,66,391,67,391,68,391,69,391,},[43]={30,390,31,390,32,390,33,390,34,390,35,390,36,392,37,392,38,392,39,392,40,392,41,392,42,392,43,392,44,392,45,392,46,392,47,392,48,392,49,392,50,391,51,391,52,391,53,391,54,391,55,391,56,391,57,391,58,391,59,391,60,391,61,391,62,391,63,391,64,391,65,391,66,391,67,391,68,391,69,391,},[44]={30,390,31,390,32,390,33,390,34,390,35,390,36,392,37,392,38,392,39,392,40,392,41,392,42,392,43,392,44,392,45,392,46,392,47,392,48,392,49,392,50,391,51,391,52,391,53,391,54,391,55,391,56,391,57,391,58,391,59,391,60,391,61,391,62,391,63,391,64,391,65,391,66,391,67,391,68,391,69,391,},[45]={30,390,31,390,32,390,33,390,34,390,35,390,36,392,37,392,38,392,39,392,40,392,41,392,42,392,43,392,44,392,45,392,46,392,47,392,48,392,49,392,50,391,51,391,52,391,53,391,54,391,55,391,56,391,57,391,58,391,59,391,60,391,61,391,62,391,63,391,64,391,65,391,66,391,67,391,68,391,69,391,},[46]={30,392,31,392,32,392,33,392,34,392,35,392,36,392,37,392,38,392,39,392,40,392,41,392,42,392,43,392,44,392,45,392,46,392,47,392,48,392,49,392,50,391,51,391,52,392,53,392,54,392,55,392,56,392,57,392,58,392,59,392,60,392,61,392,62,392,63,392,64,392,65,392,66,391,67,391,68,391,69,391,},[47]={30,392,31,392,32,392,33,392,34,392,35,392,36,392,37,392,38,392,39,392,40,392,41,392,42,392,43,392,44,392,45,392,46,392,47,392,48,392,49,392,50,391,51,391,52,392,53,392,54,392,55,392,56,392,57,392,58,392,59,392,60,392,61,392,62,392,63,392,64,392,65,392,66,391,67,391,68,391,69,391,},[48]={30,392,31,392,32,392,33,392,34,392,35,392,36,392,37,392,38,392,39,392,40,392,41,392,42,392,43,392,44,392,45,392,46,392,47,392,48,392,49,392,50,392,51,392,52,392,53,392,54,392,55,392,56,392,57,392,58,392,59,392,60,392,61,392,62,392,63,392,64,392,65,392,66,391,67,391,68,391,69,391,},[49]={30,392,31,392,32,392,33,392,34,392,35,392,36,392,37,392,38,392,39,392,40,392,41,392,42,392,43,392,44,392,45,392,46,392,47,392,48,392,49,392,50,392,51,392,52,392,53,392,54,392,55,392,56,392,57,392,58,392,59,392,60,392,61,392,62,392,63,392,64,392,65,392,66,391,67,391,68,391,69,391,},[50]={30,392,31,392,32,392,33,392,34,392,35,392,36,392,37,392,38,392,39,392,40,392,41,392,42,392,43,392,44,392,45,392,46,392,47,392,48,392,49,392,50,392,51,392,52,392,53,392,54,392,55,392,56,392,57,392,58,392,59,392,60,392,61,392,62,392,63,392,64,392,65,392,66,391,67,391,68,391,69,391,},[51]={30,392,31,392,32,392,33,392,34,392,35,392,36,392,37,392,38,392,39,392,40,392,41,392,42,392,43,392,44,392,45,392,46,392,47,392,48,392,49,392,50,392,51,392,52,392,53,392,54,392,55,392,56,392,57,392,58,392,59,392,60,392,61,392,62,392,63,392,64,392,65,392,66,391,67,391,68,391,69,391,},[52]={30,392,31,392,32,392,33,392,34,392,35,392,36,392,37,392,38,392,39,392,40,392,41,392,42,392,43,392,44,392,45,392,46,392,47,392,48,392,49,392,50,392,51,392,52,392,53,392,54,392,55,392,56,392,57,392,58,392,59,392,60,392,61,392,62,392,63,392,64,392,65,392,66,391,67,391,68,391,69,391,},[53]={30,392,31,392,32,392,33,392,34,392,35,392,36,392,37,392,38,392,39,392,40,392,41,392,42,392,43,392,44,392,45,392,46,392,47,392,48,392,49,392,50,392,51,392,52,392,53,392,54,392,55,392,56,392,57,392,58,392,59,392,60,392,61,392,62,392,63,392,64,392,65,392,66,391,67,391,68,391,69,391,},[54]={30,392,31,392,32,392,33,392,34,392,35,392,36,392,37,392,38,392,39,392,40,392,41,392,42,392,43,392,44,392,45,392,46,392,47,392,48,392,49,392,50,392,51,392,52,392,53,392,54,392,55,392,56,392,57,392,58,392,59,392,60,392,61,392,62,392,63,392,64,392,65,392,66,391,67,391,68,391,69,391,},[55]={30,392,31,392,32,392,33,392,34,392,35,392,36,392,37,392,38,392,39,392,40,392,41,392,42,392,43,392,44,392,45,392,46,392,47,392,48,392,49,392,50,392,51,392,52,392,53,392,54,392,55,392,56,392,57,392,58,392,59,392,60,392,61,392,62,392,63,392,64,392,65,392,66,391,67,391,68,391,69,391,},[56]={30,392,31,392,32,392,33,392,34,392,35,392,36,392,37,392,38,392,39,392,40,392,41,392,42,392,43,392,44,392,45,392,46,392,47,392,48,392,49,392,50,392,51,392,52,392,53,392,54,392,55,392,56,392,57,392,58,392,59,392,60,392,61,392,62,392,63,392,64,392,65,392,66,391,67,391,68,391,69,391,},[57]={30,392,31,392,32,392,33,392,34,392,35,392,36,392,37,392,38,392,39,392,40,392,41,392,42,392,43,392,44,392,45,392,46,392,47,392,48,392,49,392,50,392,51,392,52,392,53,392,54,392,55,392,56,392,57,392,58,392,59,392,60,392,61,392,62,392,63,392,64,392,65,392,66,391,67,391,68,391,69,391,},[58]={30,392,31,392,32,392,33,392,34,392,35,392,36,392,37,392,38,392,39,392,40,392,41,392,42,392,43,392,44,392,45,392,46,392,47,392,48,392,49,392,50,392,51,392,52,392,53,392,54,392,55,392,56,392,57,392,58,392,59,392,60,392,61,392,62,392,63,392,64,392,65,392,66,391,67,391,68,391,69,391,},[59]={30,392,31,392,32,392,33,392,34,392,35,392,36,392,37,392,38,392,39,392,40,392,41,392,42,392,43,392,44,392,45,392,46,392,47,392,48,392,49,392,50,392,51,392,52,392,53,392,54,392,55,392,56,392,57,392,58,392,59,392,60,392,61,392,62,392,63,392,64,392,65,392,66,391,67,391,68,391,69,391,},[60]={30,392,31,392,32,392,33,392,34,392,35,392,36,392,37,392,38,392,39,392,40,392,41,392,42,392,43,392,44,392,45,392,46,392,47,392,48,392,49,392,50,392,51,392,52,392,53,392,54,392,55,392,56,392,57,392,58,392,59,392,60,392,61,392,62,392,63,392,64,392,65,392,66,391,67,391,68,391,69,391,},[61]={30,392,31,392,32,392,33,392,34,392,35,392,36,392,37,392,38,392,39,392,40,392,41,392,42,392,43,392,44,392,45,392,46,392,47,392,48,392,49,392,50,392,51,392,52,392,53,392,54,392,55,392,56,392,57,392,58,392,59,392,60,392,61,392,62,392,63,392,64,392,65,392,66,391,67,391,68,391,69,391,},[62]={30,392,31,392,32,392,33,392,34,392,35,392,36,392,37,392,38,392,39,392,40,392,41,392,42,392,43,392,44,392,45,392,46,392,47,392,48,392,49,392,50,392,51,392,52,392,53,392,54,392,55,392,56,392,57,392,58,392,59,392,60,392,61,392,62,392,63,392,64,391,65,391,66,391,67,391,68,391,69,391,},[63]={30,392,31,392,32,392,33,392,34,392,35,392,36,392,37,392,38,392,39,392,40,392,41,392,42,392,43,392,44,392,45,392,46,392,47,392,48,392,49,392,50,392,51,392,52,392,53,392,54,392,55,392,56,392,57,392,58,392,59,392,60,392,61,392,62,392,63,392,64,391,65,391,66,391,67,391,68,391,69,391,},[64]={30,392,31,392,32,392,33,392,34,392,35,392,36,392,37,392,38,392,39,392,40,392,41,392,42,392,43,392,44,392,45,392,46,392,47,392,48,392,49,392,50,392,51,392,52,392,53,392,54,392,55,392,56,392,57,392,58,392,59,392,60,392,61,392,62,392,63,392,64,391,65,391,66,391,67,391,68,391,69,391,},[65]={30,392,31,392,32,392,33,392,34,392,35,392,36,392,37,392,38,392,39,392,40,392,41,392,42,392,43,392,44,392,45,392,46,392,47,392,48,392,49,392,50,392,51,392,52,392,53,392,54,392,55,392,56,392,57,392,58,392,59,392,60,392,61,392,62,392,63,392,64,391,65,391,66,391,67,391,68,391,69,391,},[66]={30,392,31,392,32,392,33,392,34,392,35,392,36,392,37,392,38,392,39,392,40,392,41,392,42,392,43,392,44,392,45,392,46,392,47,392,48,392,49,392,50,392,51,392,52,392,53,392,54,392,55,392,56,392,57,392,58,392,59,392,60,392,61,392,62,392,63,392,64,391,65,391,66,391,67,391,68,391,69,391,},[67]={30,392,31,392,32,392,33,392,34,392,35,392,36,392,37,392,38,392,39,392,40,392,41,392,42,392,43,392,44,392,45,392,46,392,47,392,48,392,49,392,50,392,51,392,52,392,53,392,54,392,55,392,56,392,57,392,58,392,59,392,60,392,61,392,62,392,63,392,64,391,65,391,66,391,67,391,68,391,69,391,},[68]={30,392,31,392,32,392,33,392,34,392,35,392,36,392,37,392,38,392,39,392,40,392,41,392,42,392,43,392,44,392,45,392,46,392,47,392,48,392,49,392,50,392,51,392,52,392,53,392,54,392,55,392,56,392,57,392,58,392,59,392,60,392,61,392,62,392,63,392,64,391,65,391,66,391,67,391,68,391,69,391,},[69]={30,392,31,392,32,392,33,392,34,392,35,392,36,392,37,392,38,392,39,392,40,392,41,392,42,392,43,392,44,392,45,392,46,392,47,392,48,392,49,392,50,392,51,392,52,392,53,392,54,392,55,392,56,392,57,392,58,392,59,392,60,392,61,392,62,392,63,392,64,391,65,391,66,391,67,391,68,391,69,391,},[70]={30,392,31,392,32,392,33,392,34,392,35,392,36,392,37,392,38,392,39,392,40,392,41,392,42,392,43,392,44,392,45,392,46,392,47,392,48,392,49,392,50,392,51,392,52,392,53,392,54,392,55,392,56,392,57,392,58,392,59,392,60,392,61,392,62,392,63,392,64,391,65,391,66,391,67,391,68,391,69,391,},[71]={30,392,31,392,32,392,33,392,34,392,35,392,36,392,37,392,38,392,39,392,40,392,41,392,42,392,43,392,44,392,45,392,46,392,47,392,48,392,49,392,50,392,51,392,52,392,53,392,54,392,55,392,56,392,57,392,58,392,59,392,60,392,61,392,62,392,63,392,64,391,65,391,66,391,67,391,68,391,69,391,},[72]={30,392,31,392,32,392,33,392,34,392,35,392,36,392,37,392,38,392,39,392,40,392,41,392,42,392,43,392,44,392,45,392,46,392,47,392,48,392,49,392,50,392,51,392,52,392,53,392,54,392,55,392,56,392,57,392,58,392,59,392,60,392,61,392,62,392,63,392,64,391,65,391,66,391,67,391,68,391,69,391,},[73]={30,392,31,392,32,392,33,392,34,392,35,392,36,392,37,392,38,392,39,392,40,392,41,392,42,392,43,392,44,392,45,392,46,392,47,392,48,392,49,392,50,392,51,392,52,392,53,392,54,392,55,392,56,392,57,392,58,392,59,392,60,392,61,392,62,392,63,392,64,391,65,391,66,391,67,391,68,391,69,391,},[74]={30,392,31,392,32,392,33,392,34,392,35,392,36,392,37,392,38,392,39,392,40,392,41,392,42,392,43,392,44,392,45,392,46,392,47,392,48,392,49,392,50,392,51,392,52,392,53,392,54,392,55,392,56,392,57,392,58,392,59,392,60,392,61,392,62,392,63,392,64,391,65,391,66,391,67,391,68,391,69,391,},[75]={30,392,31,392,32,392,33,392,34,392,35,392,36,392,37,392,38,392,39,392,40,392,41,392,42,392,43,392,44,392,45,392,46,392,47,392,48,392,49,392,50,392,51,392,52,392,53,392,54,392,55,392,56,392,57,392,58,392,59,392,60,392,61,392,62,392,63,392,64,391,65,391,66,391,67,391,68,391,69,391,},[76]={30,392,31,392,32,392,33,392,34,392,35,392,36,392,37,392,38,392,39,392,40,392,41,392,42,392,43,392,44,392,45,392,46,392,47,392,48,392,49,392,50,392,51,392,52,392,53,392,54,392,55,392,56,392,57,392,58,392,59,392,60,392,61,392,62,392,63,392,64,391,65,391,66,391,67,391,68,391,69,391,},[77]={30,392,31,392,32,392,33,392,34,392,35,392,36,392,37,392,38,392,39,392,40,392,41,392,42,392,43,392,44,392,45,392,46,392,47,392,48,392,49,392,50,392,51,392,52,392,53,392,54,392,55,392,56,392,57,392,58,392,59,392,60,392,61,392,62,392,63,392,64,391,65,391,66,391,67,391,68,391,69,391,},[78]={30,392,31,392,32,392,33,392,34,392,35,392,36,392,37,392,38,392,39,392,40,392,41,392,42,392,43,392,44,392,45,392,46,392,47,392,48,392,49,392,50,392,51,392,52,392,53,392,54,392,55,392,56,392,57,392,58,392,59,392,60,392,61,392,62,392,63,392,64,391,65,391,66,391,67,391,68,391,69,391,},[79]={30,392,31,392,32,392,33,392,34,392,35,392,36,392,37,392,38,392,39,392,40,392,41,392,42,392,43,392,44,392,45,392,46,392,47,392,48,392,49,392,50,392,51,392,52,392,53,392,54,392,55,392,56,392,57,392,58,392,59,392,60,392,61,392,62,392,63,392,64,391,65,391,66,391,67,391,68,391,69,391,},[80]={30,392,31,392,32,392,33,392,34,392,35,392,36,392,37,392,38,392,39,392,40,392,41,392,42,392,43,392,44,392,45,392,46,392,47,392,48,392,49,392,50,392,51,392,52,392,53,392,54,392,55,392,56,392,57,392,58,392,59,392,60,392,61,392,62,392,63,392,64,391,65,391,66,391,67,391,68,391,69,391,},[81]={30,392,31,392,32,392,33,392,34,392,35,392,36,392,37,392,38,392,39,392,40,392,41,392,42,392,43,392,44,392,45,392,46,392,47,392,48,392,49,392,50,392,51,392,52,392,53,392,54,392,55,392,56,392,57,392,58,392,59,392,60,392,61,392,62,392,63,392,64,391,65,391,66,391,67,391,68,391,69,391,},[82]={30,392,31,392,32,392,33,392,34,392,35,392,36,392,37,392,38,392,39,392,40,392,41,392,42,392,43,392,44,392,45,392,46,392,47,392,48,392,49,392,50,392,51,392,52,392,53,392,54,392,55,392,56,392,57,392,58,392,59,392,60,392,61,392,62,392,63,392,64,391,65,391,66,391,67,391,68,391,69,391,},[83]={30,392,31,392,32,392,33,392,34,392,35,392,36,392,37,392,38,392,39,392,40,392,41,392,42,392,43,392,44,392,45,392,46,392,47,392,48,392,49,392,50,392,51,392,52,392,53,392,54,392,55,392,56,392,57,392,58,392,59,392,60,392,61,392,62,392,63,392,64,391,65,391,66,391,67,391,68,391,69,391,},[84]={30,392,31,392,32,392,33,392,34,392,35,392,36,392,37,392,38,392,39,392,40,392,41,392,42,392,43,392,44,392,45,392,46,392,47,392,48,392,49,392,50,392,51,392,52,392,53,392,54,392,55,392,56,392,57,392,58,391,59,391,60,391,61,391,62,391,63,391,64,391,65,391,66,391,67,391,68,391,69,391,},[85]={30,392,31,392,32,392,33,392,34,392,35,392,36,392,37,392,38,392,39,392,40,392,41,392,42,392,43,392,44,392,45,392,46,392,47,392,48,392,49,392,50,392,51,392,52,392,53,392,54,392,55,392,56,392,57,392,58,391,59,391,60,391,61,391,62,391,63,391,64,391,65,391,66,391,67,391,68,391,69,391,},[86]={30,392,31,392,32,392,33,392,34,392,35,392,36,392,37,392,38,392,39,392,40,392,41,392,42,392,43,392,44,392,45,392,46,392,47,392,48,392,49,392,50,392,51,392,52,392,53,392,54,392,55,392,56,392,57,392,58,391,59,391,60,391,61,391,62,391,63,391,64,391,65,391,66,391,67,391,68,391,69,391,},[87]={30,392,31,392,32,392,33,392,34,392,35,392,36,392,37,392,38,392,39,392,40,392,41,392,42,392,43,392,44,392,45,392,46,392,47,392,48,392,49,392,50,392,51,392,52,392,53,392,54,392,55,392,56,392,57,392,58,391,59,391,60,391,61,391,62,391,63,391,64,391,65,391,66,391,67,391,68,391,69,391,},[88]={30,392,31,392,32,392,33,392,34,392,35,392,36,392,37,392,38,392,39,392,40,392,41,392,42,392,43,392,44,392,45,392,46,392,47,392,48,392,49,392,50,392,51,392,52,392,53,392,54,392,55,392,56,392,57,392,58,391,59,391,60,391,61,391,62,391,63,391,64,391,65,391,66,391,67,391,68,391,69,391,},[89]={30,392,31,392,32,392,33,392,34,392,35,392,36,392,37,392,38,392,39,392,40,392,41,392,42,392,43,392,44,392,45,392,46,392,47,392,48,392,49,392,50,392,51,392,52,392,53,392,54,392,55,392,56,392,57,392,58,391,59,391,60,391,61,391,62,391,63,391,64,391,65,391,66,391,67,391,68,391,69,391,},[90]={30,392,31,392,32,392,33,392,34,392,35,392,36,392,37,392,38,392,39,392,40,392,41,392,42,392,43,392,44,392,45,392,46,392,47,392,48,392,49,392,50,392,51,392,52,392,53,392,54,392,55,392,56,392,57,392,58,391,59,391,60,391,61,391,62,391,63,391,64,391,65,391,66,391,67,391,68,391,69,391,},[91]={30,392,31,392,32,392,33,392,34,392,35,392,36,392,37,392,38,392,39,392,40,392,41,392,42,392,43,392,44,392,45,392,46,392,47,392,48,392,49,392,50,392,51,392,52,392,53,392,54,392,55,392,56,392,57,392,58,391,59,391,60,391,61,391,62,391,63,391,64,391,65,391,66,391,67,391,68,391,69,391,},[92]={30,392,31,392,32,392,33,392,34,392,35,392,36,392,37,392,38,392,39,392,40,392,41,392,42,392,43,392,44,392,45,392,46,392,47,392,48,392,49,392,50,392,51,392,52,392,53,392,54,392,55,392,56,392,57,392,58,391,59,391,60,391,61,391,62,391,63,391,64,391,65,391,66,391,67,391,68,391,69,391,},[93]={30,392,31,392,32,392,33,392,34,392,35,392,36,392,37,392,38,392,39,392,40,392,41,392,42,392,43,392,44,392,45,392,46,392,47,392,48,392,49,392,50,392,51,392,52,392,53,392,54,392,55,392,56,392,57,392,58,391,59,391,60,391,61,391,62,391,63,391,64,391,65,391,66,391,67,391,68,391,69,391,},[94]={30,512,31,512,32,512,33,512,34,512,35,512,36,512,37,512,38,512,39,512,40,512,41,512,42,512,43,512,44,512,45,512,46,512,47,512,48,512,49,512,50,512,51,512,52,512,53,512,54,512,55,512,56,512,57,512,58,512,59,512,60,512,61,512,62,512,63,512,64,512,65,512,66,512,67,512,68,512,69,512,},[95]={30,512,31,512,32,512,33,512,34,512,35,512,36,512,37,512,38,512,39,512,40,512,41,512,42,512,43,512,44,512,45,512,46,512,47,512,48,512,49,512,50,512,51,512,52,512,53,512,54,512,55,512,56,512,57,512,58,512,59,512,60,512,61,512,62,512,63,512,64,512,65,512,66,512,67,512,68,512,69,512,},[96]={30,512,31,512,32,512,33,512,34,512,35,512,36,512,37,512,38,512,39,512,40,512,41,512,42,512,43,512,44,512,45,512,46,512,47,512,48,512,49,512,50,512,51,512,52,512,53,512,54,512,55,512,56,512,57,512,58,512,59,512,60,512,61,512,62,512,63,512,64,512,65,512,66,512,67,512,68,512,69,512,},[97]={30,512,31,512,32,512,33,512,34,512,35,512,36,512,37,512,38,512,39,512,40,512,41,512,42,512,43,512,44,512,45,512,46,512,47,512,48,512,49,512,50,512,51,512,52,512,53,512,54,512,55,512,56,512,57,512,58,512,59,512,60,512,61,512,62,512,63,512,64,512,65,512,66,512,67,512,68,512,69,512,},[98]={30,512,31,512,32,512,33,512,34,512,35,512,36,512,37,512,38,512,39,512,40,512,41,512,42,512,43,512,44,512,45,512,46,512,47,512,48,512,49,512,50,512,51,512,52,512,53,512,54,512,55,512,56,512,57,512,58,512,59,512,60,512,61,512,62,512,63,512,64,512,65,512,66,512,67,512,68,512,69,512,},[99]={30,512,31,512,32,512,33,512,34,512,35,512,36,512,37,512,38,512,39,512,40,512,41,512,42,512,43,512,44,512,45,512,46,512,47,512,48,512,49,512,50,512,51,512,52,512,53,512,54,512,55,512,56,512,57,512,58,512,59,512,60,512,61,512,62,512,63,512,64,512,65,512,66,512,67,512,68,512,69,512,},[100]={30,512,31,512,32,512,33,512,34,512,35,512,36,512,37,512,38,512,39,512,40,512,41,512,42,512,43,512,44,512,45,512,46,512,47,512,48,512,49,512,50,512,51,512,52,512,53,512,54,512,55,512,56,512,57,512,58,512,59,512,60,512,61,512,62,512,63,512,64,512,65,512,66,512,67,512,68,512,69,512,},[101]={30,512,31,512,32,512,33,512,34,512,35,512,36,512,37,512,38,512,39,512,40,512,41,512,42,512,43,512,44,512,45,512,46,512,47,512,48,512,49,512,50,512,51,512,52,512,53,512,54,512,55,512,56,512,57,512,58,512,59,512,60,512,61,512,62,512,63,512,64,512,65,512,66,512,67,512,68,512,69,512,}
		},
		
		markers ={
			34, 60, 96, 36, 34, 52, 96, 44, 34, 44, 96, 52, 34, 36, 96, 60, 76, 44, 54, 44, 76, 52, 54, 52, 44, 62, 44, 34, 86, 34, 86, 62, 66, 62, 66, 34
		},
		
		decorations = {32,66,5,0, 32,64,5,0, 32,62,5,0, 32,60,5,0, 32,58,5,0, 32,56,5,0, 32,54,5,0, 32,52,5,0, 32,50,5,0, 32,48,5,0, 32,46,5,0, 32,44,5,0, 32,42,5,0, 32,40,5,0, 32,38,5,0, 32,36,5,0, 32,34,5,0, 32,32,5,0, 32,30,5,0,     98,66,5,0, 98,64,5,0, 98,62,5,0, 98,60,5,0, 98,58,5,0, 98,56,5,0, 98,54,5,0, 98,52,5,0, 98,50,5,0, 98,48,5,0, 98,46,5,0, 98,44,5,0, 98,42,5,0, 98,40,5,0, 98,38,5,0, 98,36,5,0, 98,34,5,0, 98,32,5,0, 98,30,5,0, },
		
		shaman_positions = {
			34, 60, 96, 36, 34, 52, 96, 44, 34, 44, 96, 52, 34, 36, 96, 60
		},
		
		scripts = {
			OnTurn = function(everySecond1, everySecond2, everySecond4) 			tiles_war_on_turn(everySecond1, everySecond2, everySecond4) end,
			OnHumanDisconnect = function(player) 									TW_init_single_AI(player) end,
			OnEnd = function()														TW_reset_shadowincr(0) end,
		},
		
	},

	[MAP_SUN_AND_MOON]={
	
		info = 	{ 	name = "Sun & Moon", author = "Divinity",
					desc = "Shamans fight for the ownership of the sun/moon. It can obtain it by casting 'acquire' spell on the current holder, or by walking over it (if it's on the floor). <p> - Catching the son/moon instantly earns the team 5 points. <br> - During the day, the sun earns the team 2 points per second. <br> - During the night, the moon earns the team 1 point per second, and removes 1 point from all enemies. <p> Each day/night cycle lasts 1 minute. <br> Shamans can not steal the sun/moon from their allies. <br> Shamans occasionally earn blast spells. Whoever is holding the sun/moon also earns lights (half as often).",
					map_objectives = { {value=5, step=1, default=true}, {value=200, step=50, limit=500, default=true}, {} },
					image = 3296, texture={14, 3}, zoom={26,2,512*3}, drop_infos = true,	marker_lb={138,124}, reinc_timer=12*3, shield_respawn=true,
					custom_rules = {
						{ default = false, 	name = "Easier to acquire", desc = "Acquire spell has a larger hitbox radius." },
					}
				},

		land ={
			[0]={0,103,1,103,2,52,3,52,4,23,5,23,6,25,7,25,8,49,9,49,10,79,11,79,12,121,13,121,14,189,15,189,16,195,17,195,18,195,19,195,20,219,21,219,22,238,23,238,24,338,25,338,26,351,27,351,28,481,29,481,30,598,31,598,32,798,33,798,34,870,35,870,36,800,37,800,38,559,39,559,40,351,41,351,42,195,43,195,44,26,45,26,46,78,47,78,48,299,49,299,50,377,51,377,52,442,53,442,54,260,55,260,56,182,57,182,58,208,59,208,60,208,61,208,62,208,63,208,64,208,65,208,66,208,67,208,68,104,69,104,70,26,71,26,222,24,223,24,224,32,225,32,226,84,227,84,228,130,229,130,230,180,231,180,232,180,233,180,234,180,235,180,236,168,237,168,238,126,239,126,240,120,241,120,242,144,243,144,244,167,245,167,246,173,247,173,248,179,249,179,250,167,251,167,252,108,253,108,254,31,255,31,},[1]={0,103,1,103,2,52,3,52,4,23,5,23,6,25,7,25,8,49,9,49,10,79,11,79,12,121,13,121,14,189,15,189,16,195,17,195,18,195,19,195,20,219,21,219,22,238,23,238,24,338,25,338,26,351,27,351,28,481,29,481,30,598,31,598,32,798,33,798,34,870,35,870,36,800,37,800,38,559,39,559,40,351,41,351,42,195,43,195,44,26,45,26,46,78,47,78,48,299,49,299,50,377,51,377,52,442,53,442,54,260,55,260,56,182,57,182,58,208,59,208,60,208,61,208,62,208,63,208,64,208,65,208,66,208,67,208,68,104,69,104,70,26,71,26,222,24,223,24,224,32,225,32,226,84,227,84,228,130,229,130,230,180,231,180,232,180,233,180,234,180,235,180,236,168,237,168,238,126,239,126,240,120,241,120,242,144,243,144,244,167,245,167,246,173,247,173,248,179,249,179,250,167,251,167,252,108,253,108,254,31,255,31,},[2]={0,6,1,6,2,6,3,6,4,6,5,6,6,6,7,6,8,1,9,1,10,1,11,1,12,92,13,92,14,117,15,117,16,135,17,135,18,146,19,146,20,114,21,114,22,157,23,157,24,272,25,272,26,357,27,357,28,481,29,481,30,559,31,559,32,565,33,565,34,799,35,799,36,817,37,817,38,571,39,571,40,351,41,351,42,195,43,195,44,65,45,65,46,117,47,117,48,299,49,299,50,338,51,338,52,338,53,338,54,156,55,156,56,117,57,117,58,169,59,169,60,169,61,169,62,169,63,169,64,169,65,169,66,130,67,130,68,13,69,13,222,18,223,18,224,32,225,32,226,78,227,78,228,130,229,130,230,150,231,150,232,180,233,180,234,180,235,180,236,114,237,114,238,108,239,108,240,114,241,114,242,174,243,174,244,179,245,179,246,179,247,179,248,179,249,179,250,180,251,180,252,96,253,96,254,6,255,6,},[3]={0,6,1,6,2,6,3,6,4,6,5,6,6,6,7,6,8,1,9,1,10,1,11,1,12,92,13,92,14,117,15,117,16,135,17,135,18,146,19,146,20,114,21,114,22,157,23,157,24,272,25,272,26,357,27,357,28,481,29,481,30,559,31,559,32,565,33,565,34,799,35,799,36,817,37,817,38,571,39,571,40,351,41,351,42,195,43,195,44,65,45,65,46,117,47,117,48,299,49,299,50,338,51,338,52,338,53,338,54,156,55,156,56,117,57,117,58,169,59,169,60,169,61,169,62,169,63,169,64,169,65,169,66,130,67,130,68,13,69,13,222,18,223,18,224,32,225,32,226,78,227,78,228,130,229,130,230,150,231,150,232,180,233,180,234,180,235,180,236,114,237,114,238,108,239,108,240,114,241,114,242,174,243,174,244,179,245,179,246,179,247,179,248,179,249,179,250,180,251,180,252,96,253,96,254,6,255,6,},[4]={0,1,1,1,2,6,3,6,4,6,5,6,14,4,15,4,16,90,17,90,18,107,19,107,20,129,21,129,22,173,23,173,24,235,25,235,26,320,27,320,28,370,29,370,30,517,31,517,32,499,33,499,34,823,35,823,36,919,37,919,38,601,39,601,40,338,41,338,42,234,43,234,44,104,45,104,46,117,47,117,48,182,49,182,50,195,51,195,52,195,53,195,54,130,55,130,56,117,57,117,58,117,59,117,60,91,61,91,62,78,63,78,64,78,65,78,66,78,67,78,68,13,69,13,222,1,223,1,224,52,225,52,226,104,227,104,228,130,229,130,230,180,231,180,232,180,233,180,234,126,235,126,236,60,237,60,238,96,239,96,240,102,241,102,242,180,243,180,244,168,245,168,246,180,247,180,248,180,249,180,250,168,251,168,252,5,253,5,254,1,255,1,},[5]={0,1,1,1,2,6,3,6,4,6,5,6,14,4,15,4,16,90,17,90,18,107,19,107,20,129,21,129,22,173,23,173,24,235,25,235,26,320,27,320,28,370,29,370,30,517,31,517,32,499,33,499,34,823,35,823,36,919,37,919,38,601,39,601,40,338,41,338,42,234,43,234,44,104,45,104,46,117,47,117,48,182,49,182,50,195,51,195,52,195,53,195,54,130,55,130,56,117,57,117,58,117,59,117,60,91,61,91,62,78,63,78,64,78,65,78,66,78,67,78,68,13,69,13,222,1,223,1,224,52,225,52,226,104,227,104,228,130,229,130,230,180,231,180,232,180,233,180,234,126,235,126,236,60,237,60,238,96,239,96,240,102,241,102,242,180,243,180,244,168,245,168,246,180,247,180,248,180,249,180,250,168,251,168,252,5,253,5,254,1,255,1,},[6]={14,1,15,1,16,63,17,63,18,83,19,83,20,113,21,113,22,158,23,158,24,212,25,212,26,279,27,279,28,345,29,345,30,361,31,361,32,388,33,388,34,578,35,578,36,796,37,796,38,656,39,656,40,338,41,338,42,247,43,247,44,117,45,117,46,117,47,117,48,117,49,117,50,117,51,117,52,117,53,117,54,117,55,117,56,117,57,117,58,104,59,104,60,26,61,26,222,65,223,65,224,117,225,117,226,169,227,169,228,169,229,169,230,180,231,180,232,138,233,138,234,30,235,30,236,12,237,12,238,12,239,12,240,60,241,60,242,120,243,120,244,144,245,144,246,180,247,180,248,180,249,180,250,116,251,116,},[7]={14,1,15,1,16,63,17,63,18,83,19,83,20,113,21,113,22,158,23,158,24,212,25,212,26,279,27,279,28,345,29,345,30,361,31,361,32,388,33,388,34,578,35,578,36,796,37,796,38,656,39,656,40,338,41,338,42,247,43,247,44,117,45,117,46,117,47,117,48,117,49,117,50,117,51,117,52,117,53,117,54,117,55,117,56,117,57,117,58,104,59,104,60,26,61,26,222,65,223,65,224,117,225,117,226,169,227,169,228,169,229,169,230,180,231,180,232,138,233,138,234,30,235,30,236,12,237,12,238,12,239,12,240,60,241,60,242,120,243,120,244,144,245,144,246,180,247,180,248,180,249,180,250,116,251,116,},[8]={14,43,15,43,16,48,17,48,18,48,19,48,20,93,21,93,22,138,23,138,24,182,25,182,26,230,27,230,28,254,29,254,30,260,31,260,32,260,33,260,34,356,35,356,36,518,37,518,38,467,39,467,40,290,41,290,42,182,43,182,44,117,45,117,46,99,47,99,48,99,49,99,50,117,51,117,52,117,53,117,54,117,55,117,56,117,57,117,58,91,59,91,60,26,61,26,214,39,215,39,216,52,217,52,218,117,219,117,220,169,221,169,222,180,223,180,224,180,225,180,226,180,227,180,228,180,229,180,230,180,231,180,232,84,233,84,234,24,235,24,236,24,237,24,238,30,239,30,240,36,241,36,242,114,243,114,244,156,245,156,246,180,247,180,248,180,249,180,250,90,251,90,},[9]={14,43,15,43,16,48,17,48,18,48,19,48,20,93,21,93,22,138,23,138,24,182,25,182,26,230,27,230,28,254,29,254,30,260,31,260,32,260,33,260,34,356,35,356,36,518,37,518,38,467,39,467,40,290,41,290,42,182,43,182,44,117,45,117,46,99,47,99,48,99,49,99,50,117,51,117,52,117,53,117,54,117,55,117,56,117,57,117,58,91,59,91,60,26,61,26,214,39,215,39,216,52,217,52,218,117,219,117,220,169,221,169,222,180,223,180,224,180,225,180,226,180,227,180,228,180,229,180,230,180,231,180,232,84,233,84,234,24,235,24,236,24,237,24,238,30,239,30,240,36,241,36,242,114,243,114,244,156,245,156,246,180,247,180,248,180,249,180,250,90,251,90,},[10]={14,30,15,30,16,36,17,36,18,62,19,62,20,100,21,100,22,123,23,123,24,135,25,135,26,162,27,162,28,195,29,195,30,195,31,195,32,169,33,169,34,211,35,211,36,241,37,241,38,205,39,205,40,162,41,162,42,117,43,117,44,87,45,87,46,87,47,87,48,93,49,93,50,93,51,93,52,117,53,117,54,117,55,117,56,117,57,117,58,52,59,52,60,13,61,13,212,104,213,104,214,143,215,143,216,156,217,156,218,180,219,180,220,206,221,206,222,206,223,206,224,206,225,206,226,206,227,206,228,180,229,180,230,180,231,180,232,126,233,126,234,96,235,96,236,102,237,102,238,66,239,66,240,66,241,66,242,156,243,156,244,174,245,174,246,180,247,180,248,180,249,180,250,90,251,90,},[11]={14,30,15,30,16,36,17,36,18,62,19,62,20,100,21,100,22,123,23,123,24,135,25,135,26,162,27,162,28,195,29,195,30,195,31,195,32,169,33,169,34,211,35,211,36,241,37,241,38,205,39,205,40,162,41,162,42,117,43,117,44,87,45,87,46,87,47,87,48,93,49,93,50,93,51,93,52,117,53,117,54,117,55,117,56,117,57,117,58,52,59,52,60,13,61,13,212,104,213,104,214,143,215,143,216,156,217,156,218,180,219,180,220,206,221,206,222,206,223,206,224,206,225,206,226,206,227,206,228,180,229,180,230,180,231,180,232,126,233,126,234,96,235,96,236,102,237,102,238,66,239,66,240,66,241,66,242,156,243,156,244,174,245,174,246,180,247,180,248,180,249,180,250,90,251,90,},[12]={12,55,13,55,14,57,15,57,16,72,17,72,18,117,19,117,20,117,21,117,22,117,23,117,24,117,25,117,26,156,27,156,28,169,29,169,30,169,31,169,32,130,33,130,34,130,35,130,36,154,37,154,38,190,39,190,40,178,41,178,42,111,43,111,44,87,45,87,46,87,47,87,48,93,49,93,50,93,51,93,52,117,53,117,54,117,55,117,56,91,57,91,58,26,59,26,210,65,211,65,212,156,213,156,214,193,215,193,216,206,217,206,218,206,219,206,220,206,221,206,222,206,223,206,224,206,225,206,226,245,227,245,228,232,229,232,230,245,231,245,232,206,233,206,234,193,235,193,236,150,237,150,238,102,239,102,240,102,241,102,242,114,243,114,244,180,245,180,246,180,247,180,248,180,249,180,250,96,251,96,252,57,253,57,},[13]={12,55,13,55,14,57,15,57,16,72,17,72,18,117,19,117,20,117,21,117,22,117,23,117,24,117,25,117,26,156,27,156,28,169,29,169,30,169,31,169,32,130,33,130,34,130,35,130,36,154,37,154,38,190,39,190,40,178,41,178,42,111,43,111,44,87,45,87,46,87,47,87,48,93,49,93,50,93,51,93,52,117,53,117,54,117,55,117,56,91,57,91,58,26,59,26,210,65,211,65,212,156,213,156,214,193,215,193,216,206,217,206,218,206,219,206,220,206,221,206,222,206,223,206,224,206,225,206,226,245,227,245,228,232,229,232,230,245,231,245,232,206,233,206,234,193,235,193,236,150,237,150,238,102,239,102,240,102,241,102,242,114,243,114,244,180,245,180,246,180,247,180,248,180,249,180,250,96,251,96,252,57,253,57,},[14]={12,1,13,1,14,1,15,1,16,88,17,88,18,117,19,117,20,117,21,117,22,117,23,117,24,117,25,117,26,169,27,169,28,234,29,234,30,234,31,234,32,182,33,182,34,117,35,117,36,141,37,141,38,183,39,183,40,231,41,231,42,153,43,153,44,81,45,81,46,87,47,87,48,93,49,93,50,93,51,93,52,117,53,117,54,52,55,52,56,52,57,52,58,13,59,13,210,65,211,65,212,156,213,156,214,206,215,206,216,206,217,206,218,206,219,206,220,206,221,206,222,206,223,206,224,219,225,219,226,297,227,297,228,375,229,375,230,427,231,427,232,349,233,349,234,245,235,245,236,168,237,168,238,138,239,138,240,108,241,108,242,132,243,132,244,174,245,174,246,169,247,169,248,145,249,145,250,120,251,120,252,99,253,99,254,99,255,99,},[15]={12,1,13,1,14,1,15,1,16,88,17,88,18,117,19,117,20,117,21,117,22,117,23,117,24,117,25,117,26,169,27,169,28,234,29,234,30,234,31,234,32,182,33,182,34,117,35,117,36,141,37,141,38,183,39,183,40,231,41,231,42,153,43,153,44,81,45,81,46,87,47,87,48,93,49,93,50,93,51,93,52,117,53,117,54,52,55,52,56,52,57,52,58,13,59,13,210,65,211,65,212,156,213,156,214,206,215,206,216,206,217,206,218,206,219,206,220,206,221,206,222,206,223,206,224,219,225,219,226,297,227,297,228,375,229,375,230,427,231,427,232,349,233,349,234,245,235,245,236,168,237,168,238,138,239,138,240,108,241,108,242,132,243,132,244,174,245,174,246,169,247,169,248,145,249,145,250,120,251,120,252,99,253,99,254,99,255,99,},[16]={0,104,1,104,2,91,3,91,12,1,13,1,14,1,15,1,16,92,17,92,18,117,19,117,20,117,21,117,22,260,23,260,24,338,25,338,26,455,27,455,28,416,29,416,30,338,31,338,32,221,33,221,34,117,35,117,36,117,37,117,38,123,39,123,40,183,41,183,42,141,43,141,44,81,45,81,46,91,47,91,48,78,49,78,50,52,51,52,52,39,53,39,54,13,55,13,56,13,57,13,210,65,211,65,212,169,213,169,214,206,215,206,216,206,217,206,218,219,219,219,220,232,221,232,222,232,223,232,224,271,225,271,226,349,227,349,228,440,229,440,230,505,231,505,232,427,233,427,234,297,235,297,236,180,237,180,238,45,239,45,240,1,241,1,242,1,243,1,244,162,245,162,246,164,247,164,248,146,249,146,250,128,251,128,252,114,253,114,254,105,255,105,},[17]={0,104,1,104,2,91,3,91,12,1,13,1,14,1,15,1,16,92,17,92,18,117,19,117,20,117,21,117,22,260,23,260,24,338,25,338,26,455,27,455,28,416,29,416,30,338,31,338,32,221,33,221,34,117,35,117,36,117,37,117,38,123,39,123,40,183,41,183,42,141,43,141,44,81,45,81,46,91,47,91,48,78,49,78,50,52,51,52,52,39,53,39,54,13,55,13,56,13,57,13,210,65,211,65,212,169,213,169,214,206,215,206,216,206,217,206,218,219,219,219,220,232,221,232,222,232,223,232,224,271,225,271,226,349,227,349,228,440,229,440,230,505,231,505,232,427,233,427,234,297,235,297,236,180,237,180,238,45,239,45,240,1,241,1,242,1,243,1,244,162,245,162,246,164,247,164,248,146,249,146,250,128,251,128,252,114,253,114,254,105,255,105,},[18]={0,96,1,96,2,96,3,96,4,91,5,91,6,39,7,39,8,26,9,26,10,38,11,38,12,44,13,44,14,50,15,50,16,117,17,117,18,117,19,117,20,130,21,130,22,494,23,494,24,624,25,624,26,715,27,715,28,455,29,455,30,325,31,325,32,221,33,221,34,117,35,117,36,117,37,117,38,91,39,91,40,91,41,91,42,91,43,91,44,78,45,78,46,52,47,52,48,39,49,39,50,26,51,26,52,13,53,13,210,39,211,39,212,91,213,91,214,206,215,206,216,206,217,206,218,219,219,219,220,232,221,232,222,232,223,232,224,271,225,271,226,323,227,323,228,440,229,440,230,479,231,479,232,427,233,427,234,284,235,284,236,180,237,180,246,34,247,34,248,147,249,147,250,131,251,131,252,117,253,117,254,105,255,105,},[19]={0,96,1,96,2,96,3,96,4,91,5,91,6,39,7,39,8,26,9,26,10,38,11,38,12,44,13,44,14,50,15,50,16,117,17,117,18,117,19,117,20,130,21,130,22,494,23,494,24,624,25,624,26,715,27,715,28,455,29,455,30,325,31,325,32,221,33,221,34,117,35,117,36,117,37,117,38,91,39,91,40,91,41,91,42,91,43,91,44,78,45,78,46,52,47,52,48,39,49,39,50,26,51,26,52,13,53,13,210,39,211,39,212,91,213,91,214,206,215,206,216,206,217,206,218,219,219,219,220,232,221,232,222,232,223,232,224,271,225,271,226,323,227,323,228,440,229,440,230,479,231,479,232,427,233,427,234,284,235,284,236,180,237,180,246,34,247,34,248,147,249,147,250,131,251,131,252,117,253,117,254,105,255,105,},[20]={0,78,1,78,2,90,3,90,4,130,5,130,6,78,7,78,8,104,9,104,10,84,11,84,12,109,13,109,14,109,15,109,16,117,17,117,18,117,19,117,20,130,21,130,22,507,23,507,24,637,25,637,26,715,27,715,28,338,29,338,30,156,31,156,32,65,33,65,34,26,35,26,36,26,37,26,38,52,39,52,40,65,41,65,42,78,43,78,44,65,45,65,46,26,47,26,48,52,49,52,50,26,51,26,52,13,53,13,214,131,215,131,216,206,217,206,218,219,219,219,220,232,221,232,222,232,223,232,224,258,225,258,226,271,227,271,228,310,229,310,230,336,231,336,232,323,233,323,234,271,235,271,236,180,237,180,248,150,249,150,250,129,251,129,252,117,253,117,254,89,255,89,},[21]={0,78,1,78,2,90,3,90,4,130,5,130,6,78,7,78,8,104,9,104,10,84,11,84,12,109,13,109,14,109,15,109,16,117,17,117,18,117,19,117,20,130,21,130,22,507,23,507,24,637,25,637,26,715,27,715,28,338,29,338,30,156,31,156,32,65,33,65,34,26,35,26,36,26,37,26,38,52,39,52,40,65,41,65,42,78,43,78,44,65,45,65,46,26,47,26,48,52,49,52,50,26,51,26,52,13,53,13,214,131,215,131,216,206,217,206,218,219,219,219,220,232,221,232,222,232,223,232,224,258,225,258,226,271,227,271,228,310,229,310,230,336,231,336,232,323,233,323,234,271,235,271,236,180,237,180,248,150,249,150,250,129,251,129,252,117,253,117,254,89,255,89,},[22]={0,52,1,52,2,52,3,52,4,143,5,143,6,299,7,299,8,351,9,351,10,221,11,221,12,143,13,143,14,117,15,117,16,117,17,117,18,117,19,117,20,130,21,130,22,364,23,364,24,416,25,416,26,403,27,403,28,117,29,117,30,39,31,39,32,52,33,52,34,1,35,1,36,1,37,1,38,65,39,65,40,65,41,65,42,52,43,52,44,39,45,39,46,13,47,13,216,55,217,55,218,130,219,130,220,232,221,232,222,232,223,232,224,232,225,232,226,245,227,245,228,258,229,258,230,258,231,258,232,245,233,245,234,219,235,219,236,180,237,180,248,104,249,104,250,120,251,120,252,91,253,91,254,77,255,77,},[23]={0,52,1,52,2,52,3,52,4,143,5,143,6,299,7,299,8,351,9,351,10,221,11,221,12,143,13,143,14,117,15,117,16,117,17,117,18,117,19,117,20,130,21,130,22,364,23,364,24,416,25,416,26,403,27,403,28,117,29,117,30,39,31,39,32,52,33,52,34,1,35,1,36,1,37,1,38,65,39,65,40,65,41,65,42,52,43,52,44,39,45,39,46,13,47,13,216,55,217,55,218,130,219,130,220,232,221,232,222,232,223,232,224,232,225,232,226,245,227,245,228,258,229,258,230,258,231,258,232,245,233,245,234,219,235,219,236,180,237,180,248,104,249,104,250,120,251,120,252,91,253,91,254,77,255,77,},[24]={0,78,1,78,2,78,3,78,4,221,5,221,6,416,7,416,8,572,9,572,10,494,11,494,12,325,13,325,14,169,15,169,16,117,17,117,18,117,19,117,20,117,21,117,22,130,23,130,24,130,25,130,26,130,27,130,28,52,29,52,38,1,39,1,40,65,41,65,42,52,43,52,44,52,45,52,46,13,47,13,216,3,217,3,218,13,219,13,220,91,221,91,222,104,223,104,224,117,225,117,226,219,227,219,228,219,229,219,230,219,231,219,232,219,233,219,234,219,235,219,236,193,237,193,238,76,239,76,250,91,251,91,252,76,253,76,254,62,255,62,},[25]={0,78,1,78,2,78,3,78,4,221,5,221,6,416,7,416,8,572,9,572,10,494,11,494,12,325,13,325,14,169,15,169,16,117,17,117,18,117,19,117,20,117,21,117,22,130,23,130,24,130,25,130,26,130,27,130,28,52,29,52,38,1,39,1,40,65,41,65,42,52,43,52,44,52,45,52,46,13,47,13,216,3,217,3,218,13,219,13,220,91,221,91,222,104,223,104,224,117,225,117,226,219,227,219,228,219,229,219,230,219,231,219,232,219,233,219,234,219,235,219,236,193,237,193,238,76,239,76,250,91,251,91,252,76,253,76,254,62,255,62,},[26]={0,65,1,65,2,91,3,91,4,208,5,208,6,377,7,377,8,546,9,546,10,507,11,507,12,338,13,338,14,169,15,169,16,117,17,117,18,117,19,117,20,117,21,117,22,117,23,117,24,91,25,91,26,104,27,104,28,1,29,1,38,1,39,1,40,65,41,65,42,13,43,13,44,13,45,13,224,13,225,13,226,143,227,143,228,219,229,219,230,219,231,219,232,219,233,219,234,219,235,219,236,193,237,193,238,180,239,180,252,91,253,91,254,65,255,65,},[27]={0,65,1,65,2,91,3,91,4,208,5,208,6,377,7,377,8,546,9,546,10,507,11,507,12,338,13,338,14,169,15,169,16,117,17,117,18,117,19,117,20,117,21,117,22,117,23,117,24,91,25,91,26,104,27,104,28,1,29,1,38,1,39,1,40,65,41,65,42,13,43,13,44,13,45,13,224,13,225,13,226,143,227,143,228,219,229,219,230,219,231,219,232,219,233,219,234,219,235,219,236,193,237,193,238,180,239,180,252,91,253,91,254,65,255,65,},[28]={0,117,1,117,2,117,3,117,4,117,5,117,6,208,7,208,8,364,9,364,10,416,11,416,12,325,13,325,14,169,15,169,16,117,17,117,18,117,19,117,20,117,21,117,22,117,23,117,24,78,25,78,26,91,27,91,28,1,29,1,38,65,39,65,40,65,41,65,42,13,43,13,226,117,227,117,228,219,229,219,230,219,231,219,232,219,233,219,234,193,235,193,236,193,237,193,238,180,239,180,240,89,241,89,252,104,253,104,254,104,255,104,},[29]={0,117,1,117,2,117,3,117,4,117,5,117,6,208,7,208,8,364,9,364,10,416,11,416,12,325,13,325,14,169,15,169,16,117,17,117,18,117,19,117,20,117,21,117,22,117,23,117,24,78,25,78,26,91,27,91,28,1,29,1,38,65,39,65,40,65,41,65,42,13,43,13,226,117,227,117,228,219,229,219,230,219,231,219,232,219,233,219,234,193,235,193,236,193,237,193,238,180,239,180,240,89,241,89,252,104,253,104,254,104,255,104,},[30]={0,117,1,117,2,117,3,117,4,117,5,117,6,117,7,117,8,143,9,143,10,143,11,143,12,143,13,143,14,117,15,117,16,117,17,117,18,117,19,117,20,117,21,117,22,117,23,117,24,78,25,78,26,78,27,78,28,39,29,39,36,39,37,39,38,13,39,13,226,91,227,91,228,182,229,182,230,219,231,219,232,219,233,219,234,193,235,193,236,193,237,193,238,169,239,169,240,156,241,156,252,78,253,78,254,117,255,117,},[31]={0,117,1,117,2,117,3,117,4,117,5,117,6,117,7,117,8,143,9,143,10,143,11,143,12,143,13,143,14,117,15,117,16,117,17,117,18,117,19,117,20,117,21,117,22,117,23,117,24,78,25,78,26,78,27,78,28,39,29,39,36,39,37,39,38,13,39,13,226,91,227,91,228,182,229,182,230,219,231,219,232,219,233,219,234,193,235,193,236,193,237,193,238,169,239,169,240,156,241,156,252,78,253,78,254,117,255,117,},[32]={0,117,1,117,2,117,3,117,4,117,5,117,6,117,7,117,8,130,9,130,10,130,11,130,12,130,13,130,14,117,15,117,16,117,17,117,18,117,19,117,20,117,21,117,22,104,23,104,24,65,25,65,26,52,27,52,28,13,29,13,30,13,31,13,32,13,33,13,34,13,35,13,36,26,37,26,226,52,227,52,228,117,229,117,230,169,231,169,232,180,233,180,234,180,235,180,236,180,237,180,238,130,239,130,240,117,241,117,242,104,243,104,252,117,253,117,254,117,255,117,},[33]={0,117,1,117,2,117,3,117,4,117,5,117,6,117,7,117,8,130,9,130,10,130,11,130,12,130,13,130,14,117,15,117,16,117,17,117,18,117,19,117,20,117,21,117,22,104,23,104,24,65,25,65,26,52,27,52,28,13,29,13,30,13,31,13,32,13,33,13,34,13,35,13,36,26,37,26,226,52,227,52,228,117,229,117,230,169,231,169,232,180,233,180,234,180,235,180,236,180,237,180,238,130,239,130,240,117,241,117,242,104,243,104,252,117,253,117,254,117,255,117,},[34]={0,117,1,117,2,117,3,117,4,117,5,117,6,117,7,117,8,117,9,117,10,117,11,117,12,104,13,104,14,104,15,104,16,78,17,78,18,65,19,65,20,65,21,65,22,39,23,39,24,13,25,13,26,13,27,13,226,52,227,52,228,65,229,65,230,104,231,104,232,117,233,117,234,117,235,117,236,117,237,117,238,78,239,78,240,65,241,65,242,65,243,65,244,65,245,65,246,13,247,13,248,81,249,81,250,117,251,117,252,117,253,117,254,117,255,117,},[35]={0,117,1,117,2,117,3,117,4,117,5,117,6,117,7,117,8,117,9,117,10,117,11,117,12,104,13,104,14,104,15,104,16,78,17,78,18,65,19,65,20,65,21,65,22,39,23,39,24,13,25,13,26,13,27,13,226,52,227,52,228,65,229,65,230,104,231,104,232,117,233,117,234,117,235,117,236,117,237,117,238,78,239,78,240,65,241,65,242,65,243,65,244,65,245,65,246,13,247,13,248,81,249,81,250,117,251,117,252,117,253,117,254,117,255,117,},[36]={0,117,1,117,2,117,3,117,4,104,5,104,6,104,7,104,8,78,9,78,10,78,11,78,12,65,13,65,14,52,15,52,226,40,227,40,228,65,229,65,230,65,231,65,232,65,233,65,234,65,235,65,236,65,237,65,238,65,239,65,240,65,241,65,242,65,243,65,244,65,245,65,246,13,247,13,248,81,249,81,250,117,251,117,252,117,253,117,254,117,255,117,},[37]={0,117,1,117,2,117,3,117,4,104,5,104,6,104,7,104,8,78,9,78,10,78,11,78,12,65,13,65,14,52,15,52,226,40,227,40,228,65,229,65,230,65,231,65,232,65,233,65,234,65,235,65,236,65,237,65,238,65,239,65,240,65,241,65,242,65,243,65,244,65,245,65,246,13,247,13,248,81,249,81,250,117,251,117,252,117,253,117,254,117,255,117,},[38]={0,105,1,105,2,105,3,105,4,91,5,91,6,91,7,91,8,26,9,26,10,26,11,26,12,13,13,13,14,13,15,13,228,28,229,28,230,52,231,52,232,52,233,52,234,52,235,52,236,52,237,52,238,52,239,52,240,52,241,52,242,52,243,52,250,15,251,15,252,87,253,87,254,117,255,117,},[39]={0,105,1,105,2,105,3,105,4,91,5,91,6,91,7,91,8,26,9,26,10,26,11,26,12,13,13,13,14,13,15,13,228,28,229,28,230,52,231,52,232,52,233,52,234,52,235,52,236,52,237,52,238,52,239,52,240,52,241,52,242,52,243,52,250,15,251,15,252,87,253,87,254,117,255,117,},[40]={0,105,1,105,2,105,3,105,4,52,5,52,6,52,7,52,232,26,233,26,234,26,235,26,236,26,237,26,238,26,239,26,240,26,241,26,252,22,253,22,254,52,255,52,},[41]={0,105,1,105,2,105,3,105,4,52,5,52,6,52,7,52,232,26,233,26,234,26,235,26,236,26,237,26,238,26,239,26,240,26,241,26,252,22,253,22,254,52,255,52,},[194]={24,39,25,39,26,91,27,91,28,91,29,91,30,52,31,52,},[195]={24,39,25,39,26,91,27,91,28,91,29,91,30,52,31,52,},[196]={22,52,23,52,24,78,25,78,26,195,27,195,28,195,29,195,30,169,31,169,32,59,33,59,},[197]={22,52,23,52,24,78,25,78,26,195,27,195,28,195,29,195,30,169,31,169,32,59,33,59,},[198]={22,91,23,91,24,182,25,182,26,221,27,221,28,221,29,221,30,221,31,221,32,143,33,143,},[199]={22,91,23,91,24,182,25,182,26,221,27,221,28,221,29,221,30,221,31,221,32,143,33,143,},[200]={6,13,7,13,8,7,9,7,20,13,21,13,22,156,23,156,24,221,25,221,26,221,27,221,28,221,29,221,30,221,31,221,32,143,33,143,},[201]={6,13,7,13,8,7,9,7,20,13,21,13,22,156,23,156,24,221,25,221,26,221,27,221,28,221,29,221,30,221,31,221,32,143,33,143,},[202]={0,65,1,65,2,65,3,65,4,65,5,65,6,52,7,52,8,52,9,52,20,130,21,130,22,221,23,221,24,221,25,221,26,221,27,221,28,221,29,221,30,221,31,221,32,91,33,91,250,11,251,11,252,29,253,29,254,65,255,65,},[203]={0,65,1,65,2,65,3,65,4,65,5,65,6,52,7,52,8,52,9,52,20,130,21,130,22,221,23,221,24,221,25,221,26,221,27,221,28,221,29,221,30,221,31,221,32,91,33,91,250,11,251,11,252,29,253,29,254,65,255,65,},[204]={0,65,1,65,2,65,3,65,4,65,5,65,6,65,7,65,8,65,9,65,10,65,11,65,12,65,13,65,14,13,15,13,16,1,17,1,18,26,19,26,20,221,21,221,22,221,23,221,24,221,25,221,26,221,27,221,28,221,29,221,30,104,31,104,242,13,243,13,244,26,245,26,246,26,247,26,248,39,249,39,250,65,251,65,252,65,253,65,254,65,255,65,},[205]={0,65,1,65,2,65,3,65,4,65,5,65,6,65,7,65,8,65,9,65,10,65,11,65,12,65,13,65,14,13,15,13,16,1,17,1,18,26,19,26,20,221,21,221,22,221,23,221,24,221,25,221,26,221,27,221,28,221,29,221,30,104,31,104,242,13,243,13,244,26,245,26,246,26,247,26,248,39,249,39,250,65,251,65,252,65,253,65,254,65,255,65,},[206]={0,71,1,71,2,77,3,77,4,83,5,83,6,71,7,71,8,65,9,65,10,65,11,65,12,65,13,65,14,52,15,52,16,39,17,39,18,130,19,130,20,221,21,221,22,221,23,221,24,221,25,221,26,221,27,221,28,169,29,169,30,39,31,39,242,26,243,26,244,130,245,130,246,156,247,156,248,156,249,156,250,175,251,175,252,237,253,237,254,120,255,120,},[207]={0,71,1,71,2,77,3,77,4,83,5,83,6,71,7,71,8,65,9,65,10,65,11,65,12,65,13,65,14,52,15,52,16,39,17,39,18,130,19,130,20,221,21,221,22,221,23,221,24,221,25,221,26,221,27,221,28,169,29,169,30,39,31,39,242,26,243,26,244,130,245,130,246,156,247,156,248,156,249,156,250,175,251,175,252,237,253,237,254,120,255,120,},[208]={0,168,1,168,2,118,3,118,4,94,5,94,6,71,7,71,8,65,9,65,10,65,11,65,12,65,13,65,14,65,15,65,16,52,17,52,18,208,19,208,20,234,21,234,22,234,23,234,24,234,25,234,26,221,27,221,28,78,29,78,234,20,235,20,236,26,237,26,238,26,239,26,240,26,241,26,242,52,243,52,244,195,245,195,246,180,247,180,248,295,249,295,250,313,251,313,252,326,253,326,254,308,255,308,},[209]={0,168,1,168,2,118,3,118,4,94,5,94,6,71,7,71,8,65,9,65,10,65,11,65,12,65,13,65,14,65,15,65,16,52,17,52,18,208,19,208,20,234,21,234,22,234,23,234,24,234,25,234,26,221,27,221,28,78,29,78,234,20,235,20,236,26,237,26,238,26,239,26,240,26,241,26,242,52,243,52,244,195,245,195,246,180,247,180,248,295,249,295,250,313,251,313,252,326,253,326,254,308,255,308,},[210]={0,216,1,216,2,125,3,125,4,85,5,85,6,69,7,69,8,69,9,69,10,66,11,66,12,65,13,65,14,65,15,65,16,65,17,65,18,260,19,260,20,299,21,299,22,299,23,299,24,247,25,247,26,221,27,221,28,52,29,52,232,20,233,20,234,26,235,26,242,52,243,52,244,298,245,298,246,263,247,263,248,462,249,462,250,374,251,374,252,525,253,525,254,308,255,308,},[211]={0,216,1,216,2,125,3,125,4,85,5,85,6,69,7,69,8,69,9,69,10,66,11,66,12,65,13,65,14,65,15,65,16,65,17,65,18,260,19,260,20,299,21,299,22,299,23,299,24,247,25,247,26,221,27,221,28,52,29,52,232,20,233,20,234,26,235,26,242,52,243,52,244,298,245,298,246,263,247,263,248,462,249,462,250,374,251,374,252,525,253,525,254,308,255,308,},[212]={0,183,1,183,2,104,3,104,4,95,5,95,6,80,7,80,8,77,9,77,10,71,11,71,12,65,13,65,14,77,15,77,16,200,17,200,18,381,19,381,20,455,21,455,22,338,23,338,24,234,25,234,26,117,27,117,28,39,29,39,230,26,231,26,232,26,233,26,234,1,235,1,242,29,243,29,244,232,245,232,246,291,247,291,248,391,249,391,250,453,251,453,252,449,253,449,254,317,255,317,},[213]={0,183,1,183,2,104,3,104,4,95,5,95,6,80,7,80,8,77,9,77,10,71,11,71,12,65,13,65,14,77,15,77,16,200,17,200,18,381,19,381,20,455,21,455,22,338,23,338,24,234,25,234,26,117,27,117,28,39,29,39,230,26,231,26,232,26,233,26,234,1,235,1,242,29,243,29,244,232,245,232,246,291,247,291,248,391,249,391,250,453,251,453,252,449,253,449,254,317,255,317,},[214]={0,170,1,170,2,104,3,104,4,116,5,116,6,95,7,95,8,95,9,95,10,83,11,83,12,77,13,77,14,89,15,89,16,182,17,182,18,357,19,357,20,442,21,442,22,325,23,325,24,221,25,221,26,52,27,52,228,13,229,13,230,26,231,26,232,26,233,26,234,1,235,1,242,94,243,94,244,247,245,247,246,298,247,298,248,364,249,364,250,404,251,404,252,391,253,391,254,302,255,302,},[215]={0,170,1,170,2,104,3,104,4,116,5,116,6,95,7,95,8,95,9,95,10,83,11,83,12,77,13,77,14,89,15,89,16,182,17,182,18,357,19,357,20,442,21,442,22,325,23,325,24,221,25,221,26,52,27,52,228,13,229,13,230,26,231,26,232,26,233,26,234,1,235,1,242,94,243,94,244,247,245,247,246,298,247,298,248,364,249,364,250,404,251,404,252,391,253,391,254,302,255,302,},[216]={0,312,1,312,2,247,3,247,4,234,5,234,6,169,7,169,8,143,9,143,10,135,11,135,12,117,13,117,14,125,15,125,16,167,17,167,18,223,19,223,20,247,21,247,22,130,23,130,24,78,25,78,26,52,27,52,228,13,229,13,230,26,231,26,232,26,233,26,234,23,235,23,242,145,243,145,244,274,245,274,246,317,247,317,248,392,249,392,250,432,251,432,252,427,253,427,254,380,255,380,},[217]={0,312,1,312,2,247,3,247,4,234,5,234,6,169,7,169,8,143,9,143,10,135,11,135,12,117,13,117,14,125,15,125,16,167,17,167,18,223,19,223,20,247,21,247,22,130,23,130,24,78,25,78,26,52,27,52,228,13,229,13,230,26,231,26,232,26,233,26,234,23,235,23,242,145,243,145,244,274,245,274,246,317,247,317,248,392,249,392,250,432,251,432,252,427,253,427,254,380,255,380,},[218]={0,559,1,559,2,494,3,494,4,429,5,429,6,351,7,351,8,312,9,312,10,205,11,205,12,149,13,149,14,128,15,128,16,113,17,113,18,65,19,65,20,65,21,65,22,65,23,65,24,65,25,65,26,65,27,65,228,13,229,13,230,26,231,26,232,26,233,26,234,36,235,36,236,1,237,1,238,1,239,1,240,158,241,158,242,316,243,316,244,363,245,363,246,369,247,369,248,457,249,457,250,513,251,513,252,545,253,545,254,556,255,556,},[219]={0,559,1,559,2,494,3,494,4,429,5,429,6,351,7,351,8,312,9,312,10,205,11,205,12,149,13,149,14,128,15,128,16,113,17,113,18,65,19,65,20,65,21,65,22,65,23,65,24,65,25,65,26,65,27,65,228,13,229,13,230,26,231,26,232,26,233,26,234,36,235,36,236,1,237,1,238,1,239,1,240,158,241,158,242,316,243,316,244,363,245,363,246,369,247,369,248,457,249,457,250,513,251,513,252,545,253,545,254,556,255,556,},[220]={0,676,1,676,2,611,3,611,4,533,5,533,6,455,7,455,8,416,9,416,10,239,11,239,12,158,13,158,14,119,15,119,16,87,17,87,18,65,19,65,20,65,21,65,22,65,23,65,24,65,25,65,26,65,27,65,228,13,229,13,230,26,231,26,232,26,233,26,234,29,235,29,236,45,237,45,238,188,239,188,240,347,241,347,242,438,243,438,244,533,245,533,246,540,247,540,248,593,249,593,250,620,251,620,252,729,253,729,254,702,255,702,},[221]={0,676,1,676,2,611,3,611,4,533,5,533,6,455,7,455,8,416,9,416,10,239,11,239,12,158,13,158,14,119,15,119,16,87,17,87,18,65,19,65,20,65,21,65,22,65,23,65,24,65,25,65,26,65,27,65,228,13,229,13,230,26,231,26,232,26,233,26,234,29,235,29,236,45,237,45,238,188,239,188,240,347,241,347,242,438,243,438,244,533,245,533,246,540,247,540,248,593,249,593,250,620,251,620,252,729,253,729,254,702,255,702,},[222]={0,702,1,702,2,650,3,650,4,637,5,637,6,585,7,585,8,559,9,559,10,359,11,359,12,96,13,96,14,71,15,71,16,71,17,71,18,65,19,65,20,65,21,65,22,65,23,65,24,65,25,65,26,65,27,65,230,13,231,13,232,13,233,13,234,13,235,13,236,26,237,26,238,194,239,194,240,404,241,404,242,499,243,499,244,572,245,572,246,585,247,585,248,663,249,663,250,702,251,702,252,767,253,767,254,728,255,728,},[223]={0,702,1,702,2,650,3,650,4,637,5,637,6,585,7,585,8,559,9,559,10,359,11,359,12,96,13,96,14,71,15,71,16,71,17,71,18,65,19,65,20,65,21,65,22,65,23,65,24,65,25,65,26,65,27,65,230,13,231,13,232,13,233,13,234,13,235,13,236,26,237,26,238,194,239,194,240,404,241,404,242,499,243,499,244,572,245,572,246,585,247,585,248,663,249,663,250,702,251,702,252,767,253,767,254,728,255,728,},[224]={0,793,1,793,2,715,3,715,4,702,5,702,6,650,7,650,8,626,9,626,10,296,11,296,12,89,13,89,14,53,15,53,16,53,17,53,18,53,19,53,20,65,21,65,22,65,23,65,24,65,25,65,26,52,27,52,28,24,29,24,230,13,231,13,232,13,233,13,234,30,235,30,236,50,237,50,238,219,239,219,240,429,241,429,242,585,243,585,244,689,245,689,246,702,247,702,248,780,249,780,250,832,251,832,252,871,253,871,254,845,255,845,},[225]={0,793,1,793,2,715,3,715,4,702,5,702,6,650,7,650,8,626,9,626,10,296,11,296,12,89,13,89,14,53,15,53,16,53,17,53,18,53,19,53,20,65,21,65,22,65,23,65,24,65,25,65,26,52,27,52,28,24,29,24,230,13,231,13,232,13,233,13,234,30,235,30,236,50,237,50,238,219,239,219,240,429,241,429,242,585,243,585,244,689,245,689,246,702,247,702,248,780,249,780,250,832,251,832,252,871,253,871,254,845,255,845,},[226]={0,897,1,897,2,806,3,806,4,780,5,780,6,728,7,728,8,618,9,618,10,126,11,126,12,89,13,89,14,53,15,53,16,53,17,53,18,53,19,53,20,83,21,83,22,65,23,65,24,28,25,28,26,37,27,37,28,24,29,24,230,13,231,13,232,13,233,13,234,44,235,44,236,89,237,89,238,246,239,246,240,455,241,455,242,598,243,598,244,728,245,728,246,754,247,754,248,832,249,832,250,897,251,897,252,949,253,949,254,962,255,962,},[227]={0,897,1,897,2,806,3,806,4,780,5,780,6,728,7,728,8,618,9,618,10,126,11,126,12,89,13,89,14,53,15,53,16,53,17,53,18,53,19,53,20,83,21,83,22,65,23,65,24,28,25,28,26,37,27,37,28,24,29,24,230,13,231,13,232,13,233,13,234,44,235,44,236,89,237,89,238,246,239,246,240,455,241,455,242,598,243,598,244,728,245,728,246,754,247,754,248,832,249,832,250,897,251,897,252,949,253,949,254,962,255,962,},[228]={0,975,1,975,2,845,3,845,4,780,5,780,6,735,7,735,8,519,9,519,10,329,11,329,12,165,13,165,14,89,15,89,16,71,17,71,18,65,19,65,20,86,21,86,22,73,23,73,24,99,25,99,26,81,27,81,28,117,29,117,30,117,31,117,32,117,33,117,34,91,35,91,230,13,231,13,232,26,233,26,234,63,235,63,236,102,237,102,238,219,239,219,240,416,241,416,242,572,243,572,244,728,245,728,246,806,247,806,248,871,249,871,250,923,251,923,252,1001,253,1001,254,1040,255,1040,},[229]={0,975,1,975,2,845,3,845,4,780,5,780,6,735,7,735,8,519,9,519,10,329,11,329,12,165,13,165,14,89,15,89,16,71,17,71,18,65,19,65,20,86,21,86,22,73,23,73,24,99,25,99,26,81,27,81,28,117,29,117,30,117,31,117,32,117,33,117,34,91,35,91,230,13,231,13,232,26,233,26,234,63,235,63,236,102,237,102,238,219,239,219,240,416,241,416,242,572,243,572,244,728,245,728,246,806,247,806,248,871,249,871,250,923,251,923,252,1001,253,1001,254,1040,255,1040,},[230]={0,936,1,936,2,871,3,871,4,806,5,806,6,736,7,736,8,535,9,535,10,381,11,381,12,256,13,256,14,189,15,189,16,145,17,145,18,122,19,122,20,115,21,115,22,98,23,98,24,93,25,93,26,111,27,111,28,117,29,117,30,117,31,117,32,117,33,117,34,117,35,117,36,78,37,78,38,13,39,13,222,7,223,7,224,13,225,13,226,13,227,13,228,13,229,13,230,48,231,48,232,73,233,73,234,111,235,111,236,168,237,168,238,234,239,234,240,403,241,403,242,520,243,520,244,637,245,637,246,702,247,702,248,767,249,767,250,819,251,819,252,910,253,910,254,988,255,988,},[231]={0,936,1,936,2,871,3,871,4,806,5,806,6,736,7,736,8,535,9,535,10,381,11,381,12,256,13,256,14,189,15,189,16,145,17,145,18,122,19,122,20,115,21,115,22,98,23,98,24,93,25,93,26,111,27,111,28,117,29,117,30,117,31,117,32,117,33,117,34,117,35,117,36,78,37,78,38,13,39,13,222,7,223,7,224,13,225,13,226,13,227,13,228,13,229,13,230,48,231,48,232,73,233,73,234,111,235,111,236,168,237,168,238,234,239,234,240,403,241,403,242,520,243,520,244,637,245,637,246,702,247,702,248,767,249,767,250,819,251,819,252,910,253,910,254,988,255,988,},[232]={0,793,1,793,2,728,3,728,4,687,5,687,6,648,7,648,8,551,9,551,10,426,11,426,12,324,13,324,14,257,15,257,16,219,17,219,18,166,19,166,20,109,21,109,22,80,23,80,24,99,25,99,26,117,27,117,28,117,29,117,30,143,31,143,32,273,33,273,34,273,35,273,36,221,37,221,38,26,39,26,40,13,41,13,222,13,223,13,224,13,225,13,226,26,227,26,228,26,229,26,230,69,231,69,232,117,233,117,234,168,235,168,236,225,237,225,238,303,239,303,240,390,241,390,242,495,243,495,244,569,245,569,246,646,247,646,248,661,249,661,250,715,251,715,252,754,253,754,254,832,255,832,},[233]={0,793,1,793,2,728,3,728,4,687,5,687,6,648,7,648,8,551,9,551,10,426,11,426,12,324,13,324,14,257,15,257,16,219,17,219,18,166,19,166,20,109,21,109,22,80,23,80,24,99,25,99,26,117,27,117,28,117,29,117,30,143,31,143,32,273,33,273,34,273,35,273,36,221,37,221,38,26,39,26,40,13,41,13,222,13,223,13,224,13,225,13,226,26,227,26,228,26,229,26,230,69,231,69,232,117,233,117,234,168,235,168,236,225,237,225,238,303,239,303,240,390,241,390,242,495,243,495,244,569,245,569,246,646,247,646,248,661,249,661,250,715,251,715,252,754,253,754,254,832,255,832,},[234]={0,793,1,793,2,728,3,728,4,653,5,653,6,647,7,647,8,572,9,572,10,479,11,479,12,394,13,394,14,325,15,325,16,311,17,311,18,36,19,36,20,1,21,1,22,1,23,1,24,26,25,26,26,99,27,99,28,117,29,117,30,247,31,247,32,403,33,403,34,403,35,403,36,273,37,273,38,117,39,117,40,104,41,104,42,91,43,91,44,52,45,52,220,13,221,13,222,13,223,13,224,13,225,13,226,26,227,26,228,26,229,26,230,96,231,96,232,160,233,160,234,219,235,219,236,275,237,275,238,335,239,335,240,401,241,401,242,463,243,463,244,521,245,521,246,559,247,559,248,551,249,551,250,533,251,533,252,637,253,637,254,793,255,793,},[235]={0,793,1,793,2,728,3,728,4,653,5,653,6,647,7,647,8,572,9,572,10,479,11,479,12,394,13,394,14,325,15,325,16,311,17,311,18,36,19,36,20,1,21,1,22,1,23,1,24,26,25,26,26,99,27,99,28,117,29,117,30,247,31,247,32,403,33,403,34,403,35,403,36,273,37,273,38,117,39,117,40,104,41,104,42,91,43,91,44,52,45,52,220,13,221,13,222,13,223,13,224,13,225,13,226,26,227,26,228,26,229,26,230,96,231,96,232,160,233,160,234,219,235,219,236,275,237,275,238,335,239,335,240,401,241,401,242,463,243,463,244,521,245,521,246,559,247,559,248,551,249,551,250,533,251,533,252,637,253,637,254,793,255,793,},[236]={0,973,1,973,2,895,3,895,4,772,5,772,6,679,7,679,8,598,9,598,10,501,11,501,12,414,13,414,14,342,15,342,16,183,17,183,26,78,27,78,28,117,29,117,30,247,31,247,32,403,33,403,34,403,35,403,36,273,37,273,38,117,39,117,40,117,41,117,42,117,43,117,44,91,45,91,46,26,47,26,48,13,49,13,216,13,217,13,218,26,219,26,220,26,221,26,222,26,223,26,224,26,225,26,226,39,227,39,228,39,229,39,230,129,231,129,232,211,233,211,234,276,235,276,236,325,237,325,238,365,239,365,240,402,241,402,242,442,243,442,244,479,245,479,246,510,247,510,248,539,249,539,250,596,251,596,252,687,253,687,254,934,255,934,},[237]={0,973,1,973,2,895,3,895,4,772,5,772,6,679,7,679,8,598,9,598,10,501,11,501,12,414,13,414,14,342,15,342,16,183,17,183,26,78,27,78,28,117,29,117,30,247,31,247,32,403,33,403,34,403,35,403,36,273,37,273,38,117,39,117,40,117,41,117,42,117,43,117,44,91,45,91,46,26,47,26,48,13,49,13,216,13,217,13,218,26,219,26,220,26,221,26,222,26,223,26,224,26,225,26,226,39,227,39,228,39,229,39,230,129,231,129,232,211,233,211,234,276,235,276,236,325,237,325,238,365,239,365,240,402,241,402,242,442,243,442,244,479,245,479,246,510,247,510,248,539,249,539,250,596,251,596,252,687,253,687,254,934,255,934,},[238]={0,1038,1,1038,2,986,3,986,4,869,5,869,6,765,7,765,8,609,9,609,10,520,11,520,12,424,13,424,14,333,15,333,16,173,17,173,28,78,29,78,30,221,31,221,32,247,33,247,34,247,35,247,36,143,37,143,38,117,39,117,40,117,41,117,42,117,43,117,44,117,45,117,46,117,47,117,48,117,49,117,50,26,51,26,216,13,217,13,218,26,219,26,220,26,221,26,222,26,223,26,224,26,225,26,226,39,227,39,228,52,229,52,230,169,231,169,232,287,233,287,234,353,235,353,236,384,237,384,238,394,239,394,240,404,241,404,242,422,243,422,244,445,245,445,246,474,247,474,248,515,249,515,250,583,251,583,252,713,253,713,254,934,255,934,},[239]={0,1038,1,1038,2,986,3,986,4,869,5,869,6,765,7,765,8,609,9,609,10,520,11,520,12,424,13,424,14,333,15,333,16,173,17,173,28,78,29,78,30,221,31,221,32,247,33,247,34,247,35,247,36,143,37,143,38,117,39,117,40,117,41,117,42,117,43,117,44,117,45,117,46,117,47,117,48,117,49,117,50,26,51,26,216,13,217,13,218,26,219,26,220,26,221,26,222,26,223,26,224,26,225,26,226,39,227,39,228,52,229,52,230,169,231,169,232,287,233,287,234,353,235,353,236,384,237,384,238,394,239,394,240,404,241,404,242,422,243,422,244,445,245,445,246,474,247,474,248,515,249,515,250,583,251,583,252,713,253,713,254,934,255,934,},[240]={0,1038,1,1038,2,999,3,999,4,895,5,895,6,791,7,791,8,635,9,635,10,567,11,567,12,414,13,414,14,308,15,308,16,146,17,146,28,104,29,104,30,143,31,143,32,143,33,143,34,143,35,143,36,117,37,117,38,117,39,117,40,117,41,117,42,117,43,117,44,117,45,117,46,117,47,117,48,117,49,117,50,52,51,52,52,26,53,26,216,13,217,13,218,26,219,26,220,26,221,26,222,26,223,26,224,26,225,26,226,52,227,52,228,91,229,91,230,273,231,273,232,429,233,429,234,450,235,450,236,446,237,446,238,420,239,420,240,399,241,399,242,399,243,399,244,411,245,411,246,433,247,433,248,467,249,467,250,531,251,531,252,674,253,674,254,869,255,869,},[241]={0,1038,1,1038,2,999,3,999,4,895,5,895,6,791,7,791,8,635,9,635,10,567,11,567,12,414,13,414,14,308,15,308,16,146,17,146,28,104,29,104,30,143,31,143,32,143,33,143,34,143,35,143,36,117,37,117,38,117,39,117,40,117,41,117,42,117,43,117,44,117,45,117,46,117,47,117,48,117,49,117,50,52,51,52,52,26,53,26,216,13,217,13,218,26,219,26,220,26,221,26,222,26,223,26,224,26,225,26,226,52,227,52,228,91,229,91,230,273,231,273,232,429,233,429,234,450,235,450,236,446,237,446,238,420,239,420,240,399,241,399,242,399,243,399,244,411,245,411,246,433,247,433,248,467,249,467,250,531,251,531,252,674,253,674,254,869,255,869,},[242]={0,973,1,973,2,973,3,973,4,908,5,908,6,830,7,830,8,674,9,674,10,532,11,532,12,380,13,380,14,249,15,249,16,218,17,218,18,105,19,105,28,100,29,100,30,104,31,104,32,143,33,143,34,169,35,169,36,143,37,143,38,143,39,143,40,117,41,117,42,117,43,117,44,117,45,117,46,117,47,117,48,117,49,117,50,104,51,104,52,78,53,78,54,52,55,52,216,13,217,13,218,26,219,26,220,26,221,26,222,26,223,26,224,26,225,26,226,104,227,104,228,208,229,208,230,390,231,390,232,546,233,546,234,599,235,599,236,508,237,508,238,416,239,416,240,378,241,378,242,368,243,368,244,371,245,371,246,384,247,384,248,405,249,405,250,427,251,427,252,557,253,557,254,804,255,804,},[243]={0,973,1,973,2,973,3,973,4,908,5,908,6,830,7,830,8,674,9,674,10,532,11,532,12,380,13,380,14,249,15,249,16,218,17,218,18,105,19,105,28,100,29,100,30,104,31,104,32,143,33,143,34,169,35,169,36,143,37,143,38,143,39,143,40,117,41,117,42,117,43,117,44,117,45,117,46,117,47,117,48,117,49,117,50,104,51,104,52,78,53,78,54,52,55,52,216,13,217,13,218,26,219,26,220,26,221,26,222,26,223,26,224,26,225,26,226,104,227,104,228,208,229,208,230,390,231,390,232,546,233,546,234,599,235,599,236,508,237,508,238,416,239,416,240,378,241,378,242,368,243,368,244,371,245,371,246,384,247,384,248,405,249,405,250,427,251,427,252,557,253,557,254,804,255,804,},[244]={0,817,1,817,2,817,3,817,4,765,5,765,6,700,7,700,8,570,9,570,10,479,11,479,12,321,13,321,14,220,15,220,16,199,17,199,18,169,19,169,26,117,27,117,28,169,29,169,30,169,31,169,32,169,33,169,34,169,35,169,36,169,37,169,38,169,39,169,40,130,41,130,42,117,43,117,44,117,45,117,46,117,47,117,48,99,49,99,50,117,51,117,52,117,53,117,54,117,55,117,56,104,57,104,58,117,59,117,60,117,61,117,62,78,63,78,64,26,65,26,66,13,67,13,216,13,217,13,218,26,219,26,220,37,221,37,222,68,223,68,224,132,225,132,226,262,227,262,228,416,229,416,230,559,231,559,232,624,233,624,234,552,235,552,236,427,237,427,238,362,239,362,240,337,241,337,242,328,243,328,244,327,245,327,246,335,247,335,248,347,249,347,250,375,251,375,252,466,253,466,254,648,255,648,},[245]={0,817,1,817,2,817,3,817,4,765,5,765,6,700,7,700,8,570,9,570,10,479,11,479,12,321,13,321,14,220,15,220,16,199,17,199,18,169,19,169,26,117,27,117,28,169,29,169,30,169,31,169,32,169,33,169,34,169,35,169,36,169,37,169,38,169,39,169,40,130,41,130,42,117,43,117,44,117,45,117,46,117,47,117,48,99,49,99,50,117,51,117,52,117,53,117,54,117,55,117,56,104,57,104,58,117,59,117,60,117,61,117,62,78,63,78,64,26,65,26,66,13,67,13,216,13,217,13,218,26,219,26,220,37,221,37,222,68,223,68,224,132,225,132,226,262,227,262,228,416,229,416,230,559,231,559,232,624,233,624,234,552,235,552,236,427,237,427,238,362,239,362,240,337,241,337,242,328,243,328,244,327,245,327,246,335,247,335,248,347,249,347,250,375,251,375,252,466,253,466,254,648,255,648,},[246]={0,584,1,584,2,584,3,584,4,610,5,610,6,635,7,635,8,518,9,518,10,453,11,453,12,294,13,294,14,225,15,225,16,188,17,188,18,150,19,150,20,120,21,120,22,102,23,102,24,117,25,117,26,182,27,182,28,182,29,182,30,182,31,182,32,182,33,182,34,182,35,182,36,182,37,182,38,182,39,182,40,130,41,130,42,117,43,117,44,111,45,111,46,105,47,105,48,117,49,117,50,117,51,117,52,156,53,156,54,195,55,195,56,208,57,208,58,208,59,208,60,169,61,169,62,130,63,130,64,130,65,130,66,117,67,117,68,39,69,39,70,7,71,7,218,13,219,13,220,37,221,37,222,91,223,91,224,182,225,182,226,305,227,305,228,468,229,468,230,611,231,611,232,663,233,663,234,544,235,544,236,375,237,375,238,284,239,284,240,291,241,291,242,282,243,282,244,280,245,280,246,282,247,282,248,291,249,291,250,336,251,336,252,401,253,401,254,493,255,493,},[247]={0,584,1,584,2,584,3,584,4,610,5,610,6,635,7,635,8,518,9,518,10,453,11,453,12,294,13,294,14,225,15,225,16,188,17,188,18,150,19,150,20,120,21,120,22,102,23,102,24,117,25,117,26,182,27,182,28,182,29,182,30,182,31,182,32,182,33,182,34,182,35,182,36,182,37,182,38,182,39,182,40,130,41,130,42,117,43,117,44,111,45,111,46,105,47,105,48,117,49,117,50,117,51,117,52,156,53,156,54,195,55,195,56,208,57,208,58,208,59,208,60,169,61,169,62,130,63,130,64,130,65,130,66,117,67,117,68,39,69,39,70,7,71,7,218,13,219,13,220,37,221,37,222,91,223,91,224,182,225,182,226,305,227,305,228,468,229,468,230,611,231,611,232,663,233,663,234,544,235,544,236,375,237,375,238,284,239,284,240,291,241,291,242,282,243,282,244,280,245,280,246,282,247,282,248,291,249,291,250,336,251,336,252,401,253,401,254,493,255,493,},[248]={0,454,1,454,2,454,3,454,4,480,5,480,6,519,7,519,8,428,9,428,10,363,11,363,12,249,13,249,14,222,15,222,16,200,17,200,18,189,19,189,20,219,21,219,22,237,23,237,24,169,25,169,26,351,27,351,28,455,29,455,30,455,31,455,32,455,33,455,34,455,35,455,36,455,37,455,38,351,39,351,40,234,41,234,42,130,43,130,44,99,45,99,46,93,47,93,48,117,49,117,50,117,51,117,52,156,53,156,54,195,55,195,56,208,57,208,58,208,59,208,60,208,61,208,62,169,63,169,64,182,65,182,66,182,67,182,68,117,69,117,70,111,71,111,218,18,219,18,220,30,221,30,222,90,223,90,224,189,225,189,226,325,227,325,228,494,229,494,230,637,231,637,232,687,233,687,234,544,235,544,236,375,237,375,238,271,239,271,240,238,241,238,242,232,243,232,244,230,245,230,246,230,247,230,248,232,249,232,250,284,251,284,252,298,253,298,254,363,255,363,},[249]={0,454,1,454,2,454,3,454,4,480,5,480,6,519,7,519,8,428,9,428,10,363,11,363,12,249,13,249,14,222,15,222,16,200,17,200,18,189,19,189,20,219,21,219,22,237,23,237,24,169,25,169,26,351,27,351,28,455,29,455,30,455,31,455,32,455,33,455,34,455,35,455,36,455,37,455,38,351,39,351,40,234,41,234,42,130,43,130,44,99,45,99,46,93,47,93,48,117,49,117,50,117,51,117,52,156,53,156,54,195,55,195,56,208,57,208,58,208,59,208,60,208,61,208,62,169,63,169,64,182,65,182,66,182,67,182,68,117,69,117,70,111,71,111,218,18,219,18,220,30,221,30,222,90,223,90,224,189,225,189,226,325,227,325,228,494,229,494,230,637,231,637,232,687,233,687,234,544,235,544,236,375,237,375,238,271,239,271,240,238,241,238,242,232,243,232,244,230,245,230,246,230,247,230,248,232,249,232,250,284,251,284,252,298,253,298,254,363,255,363,},[250]={0,337,1,337,2,337,3,337,4,350,5,350,6,389,7,389,8,311,9,311,10,252,11,252,12,226,13,226,14,211,15,211,16,217,17,217,18,227,19,227,20,237,21,237,22,237,23,237,24,338,25,338,26,351,27,351,28,494,29,494,30,637,31,637,32,741,33,741,34,650,35,650,36,520,37,520,38,455,39,455,40,351,41,351,42,104,43,104,44,99,45,99,46,105,47,105,48,117,49,117,50,117,51,117,52,208,53,208,54,247,55,247,56,260,57,260,58,208,59,208,60,208,61,208,62,208,63,208,64,208,65,208,66,208,67,208,68,208,69,208,70,143,71,143,218,18,219,18,220,30,221,30,222,48,223,48,224,172,225,172,226,310,227,310,228,494,229,494,230,559,231,559,232,583,233,583,234,440,235,440,236,284,237,284,238,193,239,193,240,180,241,180,242,180,243,180,244,180,245,180,246,180,247,180,248,216,249,216,250,234,251,234,252,253,253,253,254,285,255,285,},[251]={0,337,1,337,2,337,3,337,4,350,5,350,6,389,7,389,8,311,9,311,10,252,11,252,12,226,13,226,14,211,15,211,16,217,17,217,18,227,19,227,20,237,21,237,22,237,23,237,24,338,25,338,26,351,27,351,28,494,29,494,30,637,31,637,32,741,33,741,34,650,35,650,36,520,37,520,38,455,39,455,40,351,41,351,42,104,43,104,44,99,45,99,46,105,47,105,48,117,49,117,50,117,51,117,52,208,53,208,54,247,55,247,56,260,57,260,58,208,59,208,60,208,61,208,62,208,63,208,64,208,65,208,66,208,67,208,68,208,69,208,70,143,71,143,218,18,219,18,220,30,221,30,222,48,223,48,224,172,225,172,226,310,227,310,228,494,229,494,230,559,231,559,232,583,233,583,234,440,235,440,236,284,237,284,238,193,239,193,240,180,241,180,242,180,243,180,244,180,245,180,246,180,247,180,248,216,249,216,250,234,251,234,252,253,253,253,254,285,255,285,},[252]={0,181,1,181,2,181,3,181,4,181,5,181,6,194,7,194,8,174,9,174,10,173,11,173,12,149,13,149,14,199,15,199,16,221,17,221,18,231,19,231,20,237,21,237,22,237,23,237,24,338,25,338,26,351,27,351,28,494,29,494,30,728,31,728,32,838,33,838,34,838,35,838,36,728,37,728,38,559,39,559,40,351,41,351,42,156,43,156,44,91,45,91,46,117,47,117,48,117,49,117,50,156,51,156,52,312,53,312,54,351,55,351,56,325,57,325,58,208,59,208,60,208,61,208,62,208,63,208,64,208,65,208,66,208,67,208,68,208,69,208,70,143,71,143,72,26,73,26,220,12,221,12,222,24,223,24,224,150,225,150,226,281,227,281,228,377,229,377,230,429,231,429,232,453,233,453,234,310,235,310,236,206,237,206,238,180,239,180,240,180,241,180,242,180,243,180,244,180,245,180,246,180,247,180,248,192,249,192,250,197,251,197,252,192,253,192,254,168,255,168,},[253]={0,181,1,181,2,181,3,181,4,181,5,181,6,194,7,194,8,174,9,174,10,173,11,173,12,149,13,149,14,199,15,199,16,221,17,221,18,231,19,231,20,237,21,237,22,237,23,237,24,338,25,338,26,351,27,351,28,494,29,494,30,728,31,728,32,838,33,838,34,838,35,838,36,728,37,728,38,559,39,559,40,351,41,351,42,156,43,156,44,91,45,91,46,117,47,117,48,117,49,117,50,156,51,156,52,312,53,312,54,351,55,351,56,325,57,325,58,208,59,208,60,208,61,208,62,208,63,208,64,208,65,208,66,208,67,208,68,208,69,208,70,143,71,143,72,26,73,26,220,12,221,12,222,24,223,24,224,150,225,150,226,281,227,281,228,377,229,377,230,429,231,429,232,453,233,453,234,310,235,310,236,206,237,206,238,180,239,180,240,180,241,180,242,180,243,180,244,180,245,180,246,180,247,180,248,192,249,192,250,197,251,197,252,192,253,192,254,168,255,168,},[254]={0,161,1,161,2,161,3,161,4,77,5,77,6,77,7,77,8,101,9,101,10,116,11,116,12,128,13,128,14,207,15,207,16,225,17,225,18,237,19,237,20,237,21,237,22,237,23,237,24,338,25,338,26,351,27,351,28,494,29,494,30,676,31,676,32,850,33,850,34,850,35,850,36,728,37,728,38,559,39,559,40,351,41,351,42,195,43,195,44,65,45,65,46,104,47,104,48,234,49,234,50,299,51,299,52,416,53,416,54,299,55,299,56,247,57,247,58,208,59,208,60,208,61,208,62,208,63,208,64,208,65,208,66,208,67,208,68,208,69,208,70,143,71,143,72,26,73,26,220,6,221,6,222,12,223,12,224,71,225,71,226,123,227,123,228,169,229,169,230,208,231,208,232,232,233,232,234,180,235,180,236,180,237,180,238,180,239,180,240,180,241,180,242,174,243,174,244,173,245,173,246,173,247,173,248,182,249,182,250,170,251,170,252,139,253,139,254,90,255,90,},[255]={0,161,1,161,2,161,3,161,4,77,5,77,6,77,7,77,8,101,9,101,10,116,11,116,12,128,13,128,14,207,15,207,16,225,17,225,18,237,19,237,20,237,21,237,22,237,23,237,24,338,25,338,26,351,27,351,28,494,29,494,30,676,31,676,32,850,33,850,34,850,35,850,36,728,37,728,38,559,39,559,40,351,41,351,42,195,43,195,44,65,45,65,46,104,47,104,48,234,49,234,50,299,51,299,52,416,53,416,54,299,55,299,56,247,57,247,58,208,59,208,60,208,61,208,62,208,63,208,64,208,65,208,66,208,67,208,68,208,69,208,70,143,71,143,72,26,73,26,220,6,221,6,222,12,223,12,224,71,225,71,226,123,227,123,228,169,229,169,230,208,231,208,232,232,233,232,234,180,235,180,236,180,237,180,238,180,239,180,240,180,241,180,242,174,243,174,244,173,245,173,246,173,247,173,248,182,249,182,250,170,251,170,252,139,253,139,254,90,255,90,}
		},
		
		markers ={ --8, 1, 21
			254, 58, 252, 58, 250, 58, 248, 58, 254, 60, 252, 60, 250, 60, 248, 60, 2, 246, 244, 12, 252, 64, 10, 30, 246, 48, 0, 44, 32, 230, 240, 40, 254, 24, 10, 48, 18, 36, 234, 26, 252, 32, 202, 24, 210, 12, 234, 250, 226, 2, 250, 16, 8, 14, 20, 18, 30, 4, 216, 242, 228, 236, 242, 244, 246, 230, 12, 242, 26, 254, 30, 236, 22, 232, 14, 220
		},
		
		objects = {
			[0]={16,5,2,-1,768,50,5,4,-1,0,},[2]={234,5,3,-1,768,},[4]={4,5,7,-1,0,14,5,7,-1,0,},[6]={22,5,7,-1,0,48,5,7,-1,0,52,5,7,-1,0,230,5,4,-1,1280,234,5,1,-1,1792,},[8]={22,5,4,-1,1792,46,5,2,-1,1536,250,5,7,-1,0,},[10]={30,5,7,-1,0,42,5,6,-1,0,224,5,5,-1,0,236,5,7,-1,0,},[12]={16,5,7,-1,0,218,5,7,-1,0,250,5,3,-1,768,},[14]={46,5,7,-1,0,218,5,1,-1,768,252,5,3,-1,1024,},[16]={0,5,7,-1,0,8,5,7,-1,0,12,5,1,-1,1792,34,5,1,-1,1536,220,5,7,-1,0,236,5,7,-1,0,246,5,6,-1,0,},[20]={38,5,2,-1,0,246,5,7,-1,0,248,5,6,-1,0,},[22]={32,5,1,-1,1024,},[24]={20,5,2,-1,768,234,5,2,-1,256,252,5,4,-1,256,},[26]={238,5,7,-1,0,},[28]={18,5,5,-1,1536,250,5,7,-1,0,},[30]={0,5,2,-1,256,238,5,5,-1,512,},[32]={246,5,1,-1,1792,},[198]={26,5,2,-1,1024,},[202]={24,5,7,-1,0,},[206]={8,5,3,-1,1280,22,5,7,-1,0,},[208]={4,5,7,-1,0,},[210]={6,5,7,-1,0,14,5,7,-1,0,},[212]={6,5,2,-1,256,242,5,7,-1,0,250,5,1,-1,1792,},[214]={8,5,5,-1,256,12,5,2,-1,0,248,5,7,-1,0,},[216]={234,5,3,-1,1024,},[220]={18,5,4,-1,1792,234,5,7,-1,0,246,5,5,-1,1792,},[224]={14,5,7,-1,0,16,5,1,-1,512,},[226]={234,5,1,-1,1536,252,5,1,-1,1280,},[228]={20,5,7,-1,0,},[232]={0,5,6,-1,0,20,5,2,-1,512,26,5,3,-1,0,234,5,7,-1,0,},[234]={24,5,7,-1,0,230,5,7,-1,0,},[236]={224,5,3,-1,1024,236,5,4,-1,768,},[238]={242,5,1,-1,768,},[240]={26,5,1,-1,768,36,5,7,-1,0,222,5,7,-1,0,},[242]={14,5,1,-1,1024,16,5,7,-1,0,32,5,3,-1,768,40,5,5,-1,0,222,5,7,-1,0,},[244]={26,5,7,-1,0,46,5,7,-1,0,},[246]={42,5,1,-1,1280,238,5,5,-1,768,},[248]={16,5,4,-1,512,20,5,6,-1,1792,48,5,2,-1,1280,56,5,7,-1,0,64,5,7,-1,0,},[250]={30,5,2,-1,1536,64,5,6,-1,0,248,5,7,-1,0,},[252]={2,5,7,-1,0,18,5,3,-1,256,24,5,6,-1,1792,44,5,7,-1,0,66,5,7,-1,0,240,5,2,-1,256,},[254]={8,5,7,-1,0,62,5,1,-1,1792,228,5,6,-1,0,}
		},
		
		shaman_positions = {
			254, 58, 252, 58, 250, 58, 248, 58, 254, 60, 252, 60, 250, 60, 248, 60
		},
		
		scripts = {
			OnTurn = function(everySecond1, everySecond2, everySecond4) 			sun_moon_on_turn(everySecond1, everySecond2, everySecond4) end,
			OnCreateThing = function(t, owner, type, model) 						sun_moon_on_create_thing(t, owner, type, model) end,
			OnShamanDeath = function(victim, killer, killer_was_ally)				sun_moon_on_shaman_dead(victim, killer, killer_was_ally) end,
			OnHumanDisconnect = function(player) 									SM_init_single_AI(player) end,
		},
		
	},
	
	[MAP_TESLA_COIL]={
	
		info = 	{ 	name = "Tesla Coil", author = "Divinity",
					desc = "Shamans must sail on a boat, and remain close to the target objective (the closer, the greater the points they earn), while preventing enemy shamans from doing the same. <br> All this while avoiding being in the proximity of active lightning rods. <br> Note that the target objective changes periodically. <p> Powerup: <br> - Turbo: Instantly restores all HP and increases your boat's speed for 10 seconds.",
					map_objectives = { {value=5, step=1, default=true}, {value=3000, step=500, limit=5000, default=true}, {} },
					image = 3440, texture={1, 3}, zoom={198,70,512*3 + 256}, drop_infos = true,	marker_lb={18, 198}, reinc_timer=12*3, shield_respawn=true,
				},

		land ={
			[114]={92,117,93,117,94,117,95,117,96,117,97,117,98,117,99,117,108,117,109,117,110,117,111,117,112,117,113,117,114,117,115,117,},[115]={92,117,93,117,94,117,95,117,96,117,97,117,98,117,99,117,108,117,109,117,110,117,111,117,112,117,113,117,114,117,115,117,},[116]={92,117,93,117,94,117,95,117,96,117,97,117,98,117,99,117,108,117,109,117,110,117,111,117,112,117,113,117,114,117,115,117,},[117]={92,117,93,117,94,117,95,117,96,117,97,117,98,117,99,117,108,117,109,117,110,117,111,117,112,117,113,117,114,117,115,117,},[118]={92,117,93,117,94,117,95,117,96,117,97,117,98,117,99,117,108,117,109,117,110,117,111,117,112,117,113,117,114,117,115,117,},[119]={92,117,93,117,94,117,95,117,96,117,97,117,98,117,99,117,108,117,109,117,110,117,111,117,112,117,113,117,114,117,115,117,},[120]={92,117,93,117,94,117,95,117,96,117,97,117,98,117,99,117,108,117,109,117,110,117,111,117,112,117,113,117,114,117,115,117,},[121]={92,117,93,117,94,117,95,117,96,117,97,117,98,117,99,117,108,117,109,117,110,117,111,117,112,117,113,117,114,117,115,117,},[152]={54,117,55,117,56,117,57,117,58,117,59,117,60,117,61,117,146,117,147,117,148,117,149,117,150,117,151,117,152,117,153,117,},[153]={54,117,55,117,56,117,57,117,58,117,59,117,60,117,61,117,146,117,147,117,148,117,149,117,150,117,151,117,152,117,153,117,},[154]={54,117,55,117,56,117,57,117,58,117,59,117,60,117,61,117,146,117,147,117,148,117,149,117,150,117,151,117,152,117,153,117,},[155]={54,117,55,117,56,117,57,117,58,117,59,117,60,117,61,117,146,117,147,117,148,117,149,117,150,117,151,117,152,117,153,117,},[156]={54,117,55,117,56,117,57,117,58,117,59,117,60,117,61,117,146,117,147,117,148,117,149,117,150,117,151,117,152,117,153,117,},[157]={54,117,55,117,56,117,57,117,58,117,59,117,60,117,61,117,146,117,147,117,148,117,149,117,150,117,151,117,152,117,153,117,},[158]={54,117,55,117,56,117,57,117,58,117,59,117,60,117,61,117,146,117,147,117,148,117,149,117,150,117,151,117,152,117,153,117,},[159]={54,117,55,117,56,117,57,117,58,117,59,117,60,117,61,117,146,117,147,117,148,117,149,117,150,117,151,117,152,117,153,117,},[160]={100,494,101,494,102,494,103,494,104,494,105,494,106,494,107,494,},[161]={100,494,101,494,102,494,103,494,104,494,105,494,106,494,107,494,},[162]={100,494,101,494,102,962,103,962,104,962,105,962,106,494,107,494,},[163]={100,494,101,494,102,962,103,962,104,962,105,962,106,494,107,494,},[164]={100,494,101,494,102,962,103,962,104,962,105,962,106,494,107,494,},[165]={100,494,101,494,102,962,103,962,104,962,105,962,106,494,107,494,},[166]={100,494,101,494,102,494,103,494,104,494,105,494,106,494,107,494,},[167]={100,494,101,494,102,494,103,494,104,494,105,494,106,494,107,494,},[168]={54,117,55,117,56,117,57,117,58,117,59,117,60,117,61,117,146,117,147,117,148,117,149,117,150,117,151,117,152,117,153,117,},[169]={54,117,55,117,56,117,57,117,58,117,59,117,60,117,61,117,146,117,147,117,148,117,149,117,150,117,151,117,152,117,153,117,},[170]={54,117,55,117,56,117,57,117,58,117,59,117,60,117,61,117,146,117,147,117,148,117,149,117,150,117,151,117,152,117,153,117,},[171]={54,117,55,117,56,117,57,117,58,117,59,117,60,117,61,117,146,117,147,117,148,117,149,117,150,117,151,117,152,117,153,117,},[172]={54,117,55,117,56,117,57,117,58,117,59,117,60,117,61,117,146,117,147,117,148,117,149,117,150,117,151,117,152,117,153,117,},[173]={54,117,55,117,56,117,57,117,58,117,59,117,60,117,61,117,146,117,147,117,148,117,149,117,150,117,151,117,152,117,153,117,},[174]={54,117,55,117,56,117,57,117,58,117,59,117,60,117,61,117,146,117,147,117,148,117,149,117,150,117,151,117,152,117,153,117,},[175]={54,117,55,117,56,117,57,117,58,117,59,117,60,117,61,117,146,117,147,117,148,117,149,117,150,117,151,117,152,117,153,117,},[206]={92,117,93,117,94,117,95,117,96,117,97,117,98,117,99,117,108,117,109,117,110,117,111,117,112,117,113,117,114,117,115,117,},[207]={92,117,93,117,94,117,95,117,96,117,97,117,98,117,99,117,108,117,109,117,110,117,111,117,112,117,113,117,114,117,115,117,},[208]={92,117,93,117,94,117,95,117,96,117,97,117,98,117,99,117,108,117,109,117,110,117,111,117,112,117,113,117,114,117,115,117,},[209]={92,117,93,117,94,117,95,117,96,117,97,117,98,117,99,117,108,117,109,117,110,117,111,117,112,117,113,117,114,117,115,117,},[210]={92,117,93,117,94,117,95,117,96,117,97,117,98,117,99,117,108,117,109,117,110,117,111,117,112,117,113,117,114,117,115,117,},[211]={92,117,93,117,94,117,95,117,96,117,97,117,98,117,99,117,108,117,109,117,110,117,111,117,112,117,113,117,114,117,115,117,},[212]={92,117,93,117,94,117,95,117,96,117,97,117,98,117,99,117,108,117,109,117,110,117,111,117,112,117,113,117,114,117,115,117,},[213]={92,117,93,117,94,117,95,117,96,117,97,117,98,117,99,117,108,117,109,117,110,117,111,117,112,117,113,117,114,117,115,117,}
		},
		
		markers ={
			116, 110, 116, 94, 154, 56, 170, 56, 208, 94, 208, 110, 170, 148, 154, 148, 162, 102, 122, 110, 122, 94, 154, 62, 170, 62, 202, 94, 202, 110, 170, 142, 154, 142, 136, 74, 156, 76, 140, 86, 158, 90, 136, 104, 152, 110, 136, 118, 150, 130, 162, 116, 178, 136, 176, 114, 196, 122, 188, 104, 170, 98, 170, 84, 186, 92, 188, 72
		},
		
		objects = {
			[114]={92,5,1,-1,0,96,5,1,-1,0,108,5,1,-1,0,112,5,1,-1,0,},[118]={92,5,1,-1,0,96,5,1,-1,0,108,5,1,-1,0,112,5,1,-1,0,},[152]={54,5,1,-1,0,58,5,1,-1,0,146,5,1,-1,0,150,5,1,-1,0,},[156]={54,5,1,-1,0,58,5,1,-1,0,146,5,1,-1,0,150,5,1,-1,0,},[162]={102,5,1,-1,0,},[168]={54,5,1,-1,0,58,5,1,-1,0,146,5,1,-1,0,150,5,1,-1,0,},[172]={54,5,1,-1,0,58,5,1,-1,0,146,5,1,-1,0,150,5,1,-1,0,},[206]={92,5,1,-1,0,96,5,1,-1,0,108,5,1,-1,0,112,5,1,-1,0,},[210]={92,5,1,-1,0,96,5,1,-1,0,108,5,1,-1,0,112,5,1,-1,0,}
		},
		
		shaman_positions = {
			116, 110, 116, 94, 154, 56, 170, 56, 208, 94, 208, 110, 170, 148, 154, 148
		},
		
		scripts = {
			OnTurn = function(everySecond1, everySecond2, everySecond4) 			tesla_on_turn(everySecond1, everySecond2, everySecond4) end,
			OnEnd = function()														TC_on_end() end,
			OnHumanDisconnect = function(player) 									TC_init_single_AI(player) end,
		},
		
	},
	
	[MAP_WOOD_BEARERS]={
	
		info = 	{ 	name = "Woodbearers", author = "Divinity",
					desc = "Shamans must grab as many wood piles as possible (max 8 at once), and return them to any base, earning 1 point per wood pile. <p> Picking up wood piles grant 1 wood, while trees grant up to 4 wood piles! <p> Manage how much wood you want to be carrying, as the longer you stay, the riskier it becomes - dying will deplet all the current wood from your shaman! <br> You can cast blasts and lights, and remember that lights have huge range, but do not instantly kill! <p> Powerups: <br> - Invisibility: Grants invisibility to your shaman for 6 seconds. <br> - Bloodlust: Grants bloodlust to your shaman for 10 seconds, and she can carry 4 more piles. <p> Sweet Succulent Wood!",
					map_objectives = { {value=5, step=1, default=true}, {value=50, step=5, default=true}, {} },
					image = 3536, texture={9, 3}, zoom={186,56,512*3 + 256}, drop_infos = true,	marker_lb={18, 198}, reinc_timer=12*2, shield_respawn=true,
				},

		land ={
			[124]={70,65,71,65,72,65,73,65,74,65,75,65,76,65,77,65,90,65,91,65,92,65,93,65,94,65,95,65,96,65,97,65,},[125]={70,65,71,65,72,65,73,65,74,65,75,65,76,65,77,65,90,65,91,65,92,65,93,65,94,65,95,65,96,65,97,65,},[126]={70,65,71,65,72,65,73,65,74,65,75,65,76,65,77,65,90,65,91,65,92,65,93,65,94,65,95,65,96,65,97,65,},[127]={70,65,71,65,72,65,73,65,74,65,75,65,76,65,77,65,90,65,91,65,92,65,93,65,94,65,95,65,96,65,97,65,},[128]={70,65,71,65,72,65,73,65,74,65,75,65,76,65,77,65,90,65,91,65,92,65,93,65,94,65,95,65,96,65,97,65,},[129]={70,65,71,65,72,65,73,65,74,65,75,65,76,65,77,65,90,65,91,65,92,65,93,65,94,65,95,65,96,65,97,65,},[130]={70,65,71,65,72,65,73,65,74,65,75,65,76,65,77,65,90,65,91,65,92,65,93,65,94,65,95,65,96,65,97,65,},[131]={70,65,71,65,72,65,73,65,74,65,75,65,76,65,77,65,90,65,91,65,92,65,93,65,94,65,95,65,96,65,97,65,},[132]={76,13,77,13,90,13,91,13,},[133]={76,13,77,13,90,13,91,13,},[134]={76,26,77,26,90,13,91,13,},[135]={76,26,77,26,90,13,91,13,},[136]={76,13,77,13,90,13,91,13,},[137]={76,13,77,13,90,13,91,13,},[138]={72,13,73,13,74,1,75,1,76,1,77,1,90,1,91,1,92,1,93,1,94,26,95,26,},[139]={72,13,73,13,74,1,75,1,76,1,77,1,90,1,91,1,92,1,93,1,94,26,95,26,},[140]={74,1,75,1,76,1,77,1,90,1,91,1,92,1,93,1,},[141]={74,1,75,1,76,1,77,1,90,1,91,1,92,1,93,1,},[142]={74,13,75,13,76,13,77,13,90,13,91,13,92,13,93,13,},[143]={74,13,75,13,76,13,77,13,90,13,91,13,92,13,93,13,},[144]={74,13,75,13,76,13,77,13,90,13,91,13,92,13,93,13,},[145]={74,13,75,13,76,13,77,13,90,13,91,13,92,13,93,13,},[146]={76,26,77,26,90,26,91,26,},[147]={76,26,77,26,90,26,91,26,},[148]={76,13,77,13,90,13,91,13,},[149]={76,13,77,13,90,13,91,13,},[150]={44,65,45,65,46,65,47,65,48,65,49,65,50,65,51,65,76,13,77,13,90,26,91,26,116,65,117,65,118,65,119,65,120,65,121,65,122,65,123,65,},[151]={44,65,45,65,46,65,47,65,48,65,49,65,50,65,51,65,76,13,77,13,90,26,91,26,116,65,117,65,118,65,119,65,120,65,121,65,122,65,123,65,},[152]={44,65,45,65,46,65,47,65,48,65,49,65,50,65,51,65,58,13,59,13,76,13,77,13,90,13,91,13,108,26,109,26,116,65,117,65,118,65,119,65,120,65,121,65,122,65,123,65,},[153]={44,65,45,65,46,65,47,65,48,65,49,65,50,65,51,65,58,13,59,13,76,13,77,13,90,13,91,13,108,26,109,26,116,65,117,65,118,65,119,65,120,65,121,65,122,65,123,65,},[154]={44,65,45,65,46,65,47,65,48,65,49,65,50,65,51,65,58,1,59,1,60,1,61,1,62,26,63,26,64,26,65,26,74,13,75,13,76,13,77,13,78,13,79,13,80,13,81,13,82,13,83,13,84,13,85,13,86,13,87,13,88,13,89,13,90,13,91,13,92,13,93,13,102,13,103,13,104,13,105,13,106,1,107,1,108,1,109,1,116,65,117,65,118,65,119,65,120,65,121,65,122,65,123,65,},[155]={44,65,45,65,46,65,47,65,48,65,49,65,50,65,51,65,58,1,59,1,60,1,61,1,62,26,63,26,64,26,65,26,74,13,75,13,76,13,77,13,78,13,79,13,80,13,81,13,82,13,83,13,84,13,85,13,86,13,87,13,88,13,89,13,90,13,91,13,92,13,93,13,102,13,103,13,104,13,105,13,106,1,107,1,108,1,109,1,116,65,117,65,118,65,119,65,120,65,121,65,122,65,123,65,},[156]={44,65,45,65,46,65,47,65,48,65,49,65,50,65,51,65,52,13,53,13,54,26,55,26,56,26,57,26,58,1,59,1,60,1,61,1,62,26,63,26,64,26,65,26,66,26,67,26,68,13,69,13,70,13,71,13,72,13,73,13,74,13,75,13,76,41,77,41,78,59,79,59,80,67,81,67,82,56,83,56,84,52,85,52,86,78,87,78,88,78,89,78,90,52,91,52,92,13,93,13,94,13,95,13,96,13,97,13,98,13,99,13,100,13,101,13,102,13,103,13,104,13,105,13,106,1,107,1,108,1,109,1,110,26,111,26,112,13,113,13,114,26,115,26,116,65,117,65,118,65,119,65,120,65,121,65,122,65,123,65,},[157]={44,65,45,65,46,65,47,65,48,65,49,65,50,65,51,65,52,13,53,13,54,26,55,26,56,26,57,26,58,1,59,1,60,1,61,1,62,26,63,26,64,26,65,26,66,26,67,26,68,13,69,13,70,13,71,13,72,13,73,13,74,13,75,13,76,41,77,41,78,59,79,59,80,67,81,67,82,56,83,56,84,52,85,52,86,78,87,78,88,78,89,78,90,52,91,52,92,13,93,13,94,13,95,13,96,13,97,13,98,13,99,13,100,13,101,13,102,13,103,13,104,13,105,13,106,1,107,1,108,1,109,1,110,26,111,26,112,13,113,13,114,26,115,26,116,65,117,65,118,65,119,65,120,65,121,65,122,65,123,65,},[158]={74,13,75,13,76,62,77,62,78,114,79,114,80,105,81,105,82,86,83,86,84,65,85,65,86,92,87,92,88,91,89,91,90,78,91,78,92,26,93,26,},[159]={74,13,75,13,76,62,77,62,78,114,79,114,80,105,81,105,82,86,83,86,84,65,85,65,86,92,87,92,88,91,89,91,90,78,91,78,92,26,93,26,},[160]={74,13,75,13,76,78,77,78,78,122,79,122,80,116,81,116,82,101,83,101,84,121,85,121,86,114,87,114,88,120,89,120,90,104,91,104,92,65,93,65,},[161]={74,13,75,13,76,78,77,78,78,122,79,122,80,116,81,116,82,101,83,101,84,121,85,121,86,114,87,114,88,120,89,120,90,104,91,104,92,65,93,65,},[162]={74,39,75,39,76,91,77,91,78,123,79,123,80,131,81,131,82,142,83,142,84,139,85,139,86,136,87,136,88,134,89,134,90,117,91,117,92,91,93,91,},[163]={74,39,75,39,76,91,77,91,78,123,79,123,80,131,81,131,82,142,83,142,84,139,85,139,86,136,87,136,88,134,89,134,90,117,91,117,92,91,93,91,},[164]={74,39,75,39,76,78,77,78,78,134,79,134,80,134,81,134,82,151,83,151,84,150,85,150,86,131,87,131,88,104,89,104,90,91,91,91,92,52,93,52,},[165]={74,39,75,39,76,78,77,78,78,134,79,134,80,134,81,134,82,151,83,151,84,150,85,150,86,131,87,131,88,104,89,104,90,91,91,91,92,52,93,52,},[166]={74,13,75,13,76,52,77,52,78,99,79,99,80,137,81,137,82,147,83,147,84,135,85,135,86,130,87,130,88,130,89,130,90,52,91,52,92,13,93,13,},[167]={74,13,75,13,76,52,77,52,78,99,79,99,80,137,81,137,82,147,83,147,84,135,85,135,86,130,87,130,88,130,89,130,90,52,91,52,92,13,93,13,},[168]={44,65,45,65,46,65,47,65,48,65,49,65,50,65,51,65,52,13,53,13,54,26,55,26,56,26,57,26,58,1,59,1,60,1,61,1,62,13,63,13,64,13,65,13,66,13,67,13,68,26,69,26,70,26,71,26,72,13,73,13,74,13,75,13,76,52,77,52,78,74,79,74,80,101,81,101,82,113,83,113,84,113,85,113,86,104,87,104,88,104,89,104,90,52,91,52,92,13,93,13,},[169]={44,65,45,65,46,65,47,65,48,65,49,65,50,65,51,65,52,13,53,13,54,26,55,26,56,26,57,26,58,1,59,1,60,1,61,1,62,13,63,13,64,13,65,13,66,13,67,13,68,26,69,26,70,26,71,26,72,13,73,13,74,13,75,13,76,52,77,52,78,74,79,74,80,101,81,101,82,113,83,113,84,113,85,113,86,104,87,104,88,104,89,104,90,52,91,52,92,13,93,13,},[170]={44,65,45,65,46,65,47,65,48,65,49,65,50,65,51,65,58,1,59,1,60,1,61,1,62,13,63,13,64,13,65,13,74,13,75,13,76,52,77,52,78,52,79,52,80,86,81,86,82,86,83,86,84,88,85,88,86,95,87,95,88,52,89,52,90,52,91,52,92,13,93,13,94,13,95,13,96,13,97,13,98,26,99,26,100,26,101,26,102,13,103,13,104,13,105,13,},[171]={44,65,45,65,46,65,47,65,48,65,49,65,50,65,51,65,58,1,59,1,60,1,61,1,62,13,63,13,64,13,65,13,74,13,75,13,76,52,77,52,78,52,79,52,80,86,81,86,82,86,83,86,84,88,85,88,86,95,87,95,88,52,89,52,90,52,91,52,92,13,93,13,94,13,95,13,96,13,97,13,98,26,99,26,100,26,101,26,102,13,103,13,104,13,105,13,},[172]={44,65,45,65,46,65,47,65,48,65,49,65,50,65,51,65,58,13,59,13,74,13,75,13,76,13,77,13,78,13,79,13,80,52,81,52,82,52,83,52,84,74,85,74,86,64,87,64,88,13,89,13,90,13,91,13,92,13,93,13,102,13,103,13,104,13,105,13,},[173]={44,65,45,65,46,65,47,65,48,65,49,65,50,65,51,65,58,13,59,13,74,13,75,13,76,13,77,13,78,13,79,13,80,52,81,52,82,52,83,52,84,74,85,74,86,64,87,64,88,13,89,13,90,13,91,13,92,13,93,13,102,13,103,13,104,13,105,13,},[174]={44,65,45,65,46,65,47,65,48,65,49,65,50,65,51,65,76,39,77,39,90,26,91,26,106,1,107,1,108,1,109,1,110,26,111,26,112,26,113,26,114,26,115,26,116,65,117,65,118,65,119,65,120,65,121,65,122,65,123,65,},[175]={44,65,45,65,46,65,47,65,48,65,49,65,50,65,51,65,76,39,77,39,90,26,91,26,106,1,107,1,108,1,109,1,110,26,111,26,112,26,113,26,114,26,115,26,116,65,117,65,118,65,119,65,120,65,121,65,122,65,123,65,},[176]={76,26,77,26,90,39,91,39,106,13,107,13,116,65,117,65,118,65,119,65,120,65,121,65,122,65,123,65,},[177]={76,26,77,26,90,39,91,39,106,13,107,13,116,65,117,65,118,65,119,65,120,65,121,65,122,65,123,65,},[178]={76,39,77,39,90,26,91,26,116,65,117,65,118,65,119,65,120,65,121,65,122,65,123,65,},[179]={76,39,77,39,90,26,91,26,116,65,117,65,118,65,119,65,120,65,121,65,122,65,123,65,},[180]={76,13,77,13,90,39,91,39,116,65,117,65,118,65,119,65,120,65,121,65,122,65,123,65,},[181]={76,13,77,13,90,39,91,39,116,65,117,65,118,65,119,65,120,65,121,65,122,65,123,65,},[182]={74,13,75,13,76,13,77,13,90,13,91,13,92,13,93,13,},[183]={74,13,75,13,76,13,77,13,90,13,91,13,92,13,93,13,},[184]={74,13,75,13,76,13,77,13,90,13,91,13,92,13,93,13,},[185]={74,13,75,13,76,13,77,13,90,13,91,13,92,13,93,13,},[186]={74,1,75,1,76,1,77,1,90,1,91,1,92,1,93,1,},[187]={74,1,75,1,76,1,77,1,90,1,91,1,92,1,93,1,},[188]={72,13,73,13,74,1,75,1,76,1,77,1,90,1,91,1,92,1,93,1,94,26,95,26,},[189]={72,13,73,13,74,1,75,1,76,1,77,1,90,1,91,1,92,1,93,1,94,26,95,26,},[190]={76,26,77,26,90,13,91,13,},[191]={76,26,77,26,90,13,91,13,},[192]={76,26,77,26,90,13,91,13,},[193]={76,26,77,26,90,13,91,13,},[194]={76,13,77,13,90,13,91,13,},[195]={76,13,77,13,90,13,91,13,},[196]={70,65,71,65,72,65,73,65,74,65,75,65,76,65,77,65,90,65,91,65,92,65,93,65,94,65,95,65,96,65,97,65,},[197]={70,65,71,65,72,65,73,65,74,65,75,65,76,65,77,65,90,65,91,65,92,65,93,65,94,65,95,65,96,65,97,65,},[198]={70,65,71,65,72,65,73,65,74,65,75,65,76,65,77,65,90,65,91,65,92,65,93,65,94,65,95,65,96,65,97,65,},[199]={70,65,71,65,72,65,73,65,74,65,75,65,76,65,77,65,90,65,91,65,92,65,93,65,94,65,95,65,96,65,97,65,},[200]={70,65,71,65,72,65,73,65,74,65,75,65,76,65,77,65,90,65,91,65,92,65,93,65,94,65,95,65,96,65,97,65,},[201]={70,65,71,65,72,65,73,65,74,65,75,65,76,65,77,65,90,65,91,65,92,65,93,65,94,65,95,65,96,65,97,65,},[202]={70,65,71,65,72,65,73,65,74,65,75,65,76,65,77,65,90,65,91,65,92,65,93,65,94,65,95,65,96,65,97,65,},[203]={70,65,71,65,72,65,73,65,74,65,75,65,76,65,77,65,90,65,91,65,92,65,93,65,94,65,95,65,96,65,97,65,}
		},
		
		markers ={
			176, 118, 126, 72, 198, 72, 152, 118, 152, 46, 198, 92, 126, 92, 170, 46, 162, 82, 32, 210
		},
		
		objects = {
			[132]={74,5,7,-1,0,},[134]={74,5,7,-1,0,88,5,7,-1,0,},[144]={90,5,7,-1,0,92,5,7,-1,0,},[148]={76,5,7,-1,0,},[152]={62,5,7,-1,0,82,5,7,-1,0,84,5,8,-1,0,108,5,7,-1,0,46,5,12,-1,1280,118,5,12,-1,1792,},[154]={68,5,7,-1,0,98,5,7,-1,0,},[156]={62,5,7,-1,0,102,5,7,-1,0,},[162]={72,5,7,-1,0,92,5,7,-1,0,},[164]={72,5,8,-1,0,92,5,8,-1,0,},[168]={60,5,7,-1,0,62,5,7,-1,0,68,5,7,-1,0,100,5,7,-1,0,},[172]={80,5,8,-1,0,82,5,7,-1,0,112,5,7,-1,0,},[174]={106,5,7,-1,0,},[176]={74,5,7,-1,0,118,5,12,-1,256,},[182]={72,5,7,-1,0,92,5,7,-1,0,},[188]={88,5,7,-1,0,},[190]={76,5,7,-1,0,90,5,7,-1,0,},[126]={72,5,12,-1,1280,92,5,12,-1,1792,},[170]={46,5,12,-1,768,},[198]={72,5,12,-1,768,92,5,12,-1,256,}
		},
		
		shaman_positions = {
			176, 118, 126, 72, 198, 72, 152, 118, 152, 46, 198, 92, 126, 92, 170, 46
		},
		
		scripts = {
			OnTurn = function(everySecond1, everySecond2, everySecond4) 			wood_bearers_on_turn(everySecond1, everySecond2, everySecond4) end,
			OnCreateThing = function(t, owner, type, model) 						wood_bearers_on_create_thing(t, owner, type, model) end,
			OnShamanDeath = function(victim, killer, killer_was_ally)				WE_on_shaman_dead(victim, killer, killer_was_ally) end,
			OnHumanDisconnect = function(player) 									WE_init_single_AI(player) end,
			OnEnd = function()														WE_on_end() end,
		},
		
	},
	
	[MAP_CORROSION]={
	
		info = 	{ 	name = "Corrosion", author = "Divinity",
					desc = "Shamans battle each other on this ring shaped arena. They move fast, and are immune to damage, meaning they can only die by falling into the water. <p> Both blasts and lights have greater range, and corrode the land. However, the arena regenerates over time. <p> Special spell: <br> - Backstab: quickly teleports the shaman to a target location. If an enemy shaman is really close, it instantly blasts them.",
					map_objectives = { {value=5, step=1, default=true}, {value=30, step=5, limit=50, default=true}, {} },
					image = 2768, texture={16, 3}, zoom={90,124,0}, drop_infos = true,	marker_lb={222, 34}, reinc_timer=4, shield_respawn=false,
				},

		land ={
			[58]={154,24,155,24,156,100,157,100,158,88,159,88,160,56,161,56,},[59]={154,24,155,24,156,100,157,100,158,88,159,88,160,56,161,56,},[60]={140,26,141,26,142,78,143,78,144,130,145,130,146,182,147,182,148,208,149,208,150,234,151,234,152,234,153,234,154,262,155,262,156,214,157,214,158,222,159,222,160,248,161,248,162,234,163,234,164,208,165,208,166,156,167,156,168,78,169,78,170,26,171,26,},[61]={140,26,141,26,142,78,143,78,144,130,145,130,146,182,147,182,148,208,149,208,150,234,151,234,152,234,153,234,154,262,155,262,156,214,157,214,158,222,159,222,160,248,161,248,162,234,163,234,164,208,165,208,166,156,167,156,168,78,169,78,170,26,171,26,},[62]={138,52,139,52,140,156,141,156,142,234,143,234,144,312,145,312,146,312,147,312,148,364,149,364,150,370,151,370,152,376,153,376,154,376,155,376,156,354,157,354,158,326,159,326,160,360,161,360,162,364,163,364,164,364,165,364,166,312,167,312,168,234,169,234,170,208,171,208,172,78,173,78,174,26,175,26,},[63]={138,52,139,52,140,156,141,156,142,234,143,234,144,312,145,312,146,312,147,312,148,364,149,364,150,370,151,370,152,376,153,376,154,376,155,376,156,354,157,354,158,326,159,326,160,360,161,360,162,364,163,364,164,364,165,364,166,312,167,312,168,234,169,234,170,208,171,208,172,78,173,78,174,26,175,26,},[64]={134,26,135,26,136,130,137,130,138,208,139,208,140,312,141,312,142,364,143,364,144,364,145,364,146,364,147,364,148,364,149,364,150,370,151,370,152,376,153,376,154,376,155,376,156,376,157,376,158,364,159,364,160,364,161,364,162,364,163,364,164,364,165,364,166,364,167,364,168,364,169,364,170,364,171,364,172,260,173,260,174,208,175,208,176,52,177,52,},[65]={134,26,135,26,136,130,137,130,138,208,139,208,140,312,141,312,142,364,143,364,144,364,145,364,146,364,147,364,148,364,149,364,150,370,151,370,152,376,153,376,154,376,155,376,156,376,157,376,158,364,159,364,160,364,161,364,162,364,163,364,164,364,165,364,166,364,167,364,168,364,169,364,170,364,171,364,172,260,173,260,174,208,175,208,176,52,177,52,},[66]={132,52,133,52,134,156,135,156,136,286,137,286,138,376,139,376,140,376,141,376,142,370,143,370,144,364,145,364,146,334,147,334,148,310,149,310,150,340,151,340,152,364,153,364,154,376,155,376,156,350,157,350,158,338,159,338,160,364,161,364,162,355,163,355,164,355,165,355,166,364,167,364,168,364,169,364,170,370,171,370,172,370,173,370,174,338,175,338,176,234,177,234,178,182,179,182,180,26,181,26,},[67]={132,52,133,52,134,156,135,156,136,286,137,286,138,376,139,376,140,376,141,376,142,370,143,370,144,364,145,364,146,334,147,334,148,310,149,310,150,340,151,340,152,364,153,364,154,376,155,376,156,350,157,350,158,338,159,338,160,364,161,364,162,355,163,355,164,355,165,355,166,364,167,364,168,364,169,364,170,370,171,370,172,370,173,370,174,338,175,338,176,234,177,234,178,182,179,182,180,26,181,26,},[68]={128,1,129,1,130,52,131,52,132,182,133,182,134,338,135,338,136,370,137,370,138,376,139,376,140,376,141,376,142,349,143,349,144,343,145,343,146,238,147,238,148,132,149,132,150,50,151,50,162,35,163,35,164,139,165,139,166,312,167,312,168,364,169,364,170,370,171,370,172,370,173,370,174,370,175,370,176,338,177,338,178,260,179,260,180,130,181,130,182,52,183,52,},[69]={128,1,129,1,130,52,131,52,132,182,133,182,134,338,135,338,136,370,137,370,138,376,139,376,140,376,141,376,142,349,143,349,144,343,145,343,146,238,147,238,148,132,149,132,150,50,151,50,162,35,163,35,164,139,165,139,166,312,167,312,168,364,169,364,170,370,171,370,172,370,173,370,174,370,175,370,176,338,177,338,178,260,179,260,180,130,181,130,182,52,183,52,},[70]={128,78,129,78,130,156,131,156,132,338,133,338,134,364,135,364,136,370,137,370,138,370,139,370,140,364,141,364,142,255,143,255,144,73,145,73,168,52,169,52,170,286,171,286,172,370,173,370,174,370,175,370,176,364,177,364,178,338,179,338,180,260,181,260,182,130,183,130,184,26,185,26,},[71]={128,78,129,78,130,156,131,156,132,338,133,338,134,364,135,364,136,370,137,370,138,370,139,370,140,364,141,364,142,255,143,255,144,73,145,73,168,52,169,52,170,286,171,286,172,370,173,370,174,370,175,370,176,364,177,364,178,338,179,338,180,260,181,260,182,130,183,130,184,26,185,26,},[72]={126,18,127,18,128,156,129,156,130,312,131,312,132,346,133,346,134,350,135,350,136,343,137,343,138,317,139,317,140,104,141,104,170,26,171,26,172,182,173,182,174,364,175,364,176,364,177,364,178,364,179,364,180,338,181,338,182,234,183,234,184,104,185,104,},[73]={126,18,127,18,128,156,129,156,130,312,131,312,132,346,133,346,134,350,135,350,136,343,137,343,138,317,139,317,140,104,141,104,170,26,171,26,172,182,173,182,174,364,175,364,176,364,177,364,178,364,179,364,180,338,181,338,182,234,183,234,184,104,185,104,},[74]={126,104,127,104,128,234,129,234,130,364,131,364,132,346,133,346,134,319,135,319,136,290,137,290,138,125,139,125,172,26,173,26,174,156,175,156,176,364,177,364,178,370,179,370,180,370,181,370,182,344,183,344,184,208,185,208,186,78,187,78,},[75]={126,104,127,104,128,234,129,234,130,364,131,364,132,346,133,346,134,319,135,319,136,290,137,290,138,125,139,125,172,26,173,26,174,156,175,156,176,364,177,364,178,370,179,370,180,370,181,370,182,344,183,344,184,208,185,208,186,78,187,78,},[76]={124,48,125,48,126,182,127,182,128,312,129,312,130,364,131,364,132,337,133,337,134,310,135,310,136,105,137,105,176,182,177,182,178,370,179,370,180,370,181,370,182,370,183,370,184,312,185,312,186,130,187,130,188,26,189,26,},[77]={124,48,125,48,126,182,127,182,128,312,129,312,130,364,131,364,132,337,133,337,134,310,135,310,136,105,137,105,176,182,177,182,178,370,179,370,180,370,181,370,182,370,183,370,184,312,185,312,186,130,187,130,188,26,189,26,},[78]={124,104,125,104,126,234,127,234,128,364,129,364,130,364,131,364,132,343,133,343,134,183,135,183,176,26,177,26,178,234,179,234,180,370,181,370,182,370,183,370,184,370,185,370,186,182,187,182,188,78,189,78,},[79]={124,104,125,104,126,234,127,234,128,364,129,364,130,364,131,364,132,343,133,343,134,183,135,183,176,26,177,26,178,234,179,234,180,370,181,370,182,370,183,370,184,370,185,370,186,182,187,182,188,78,189,78,},[80]={122,26,123,26,124,156,125,156,126,312,127,312,128,370,129,370,130,370,131,370,132,337,133,337,134,26,135,26,178,78,179,78,180,364,181,364,182,370,183,370,184,370,185,370,186,286,187,286,188,130,189,130,},[81]={122,26,123,26,124,156,125,156,126,312,127,312,128,370,129,370,130,370,131,370,132,337,133,337,134,26,135,26,178,78,179,78,180,364,181,364,182,370,183,370,184,370,185,370,186,286,187,286,188,130,189,130,},[82]={122,78,123,78,124,208,125,208,126,364,127,364,128,370,129,370,130,370,131,370,132,189,133,189,180,234,181,234,182,364,183,364,184,364,185,364,186,338,187,338,188,182,189,182,190,26,191,26,},[83]={122,78,123,78,124,208,125,208,126,364,127,364,128,370,129,370,130,370,131,370,132,189,133,189,180,234,181,234,182,364,183,364,184,364,185,364,186,338,187,338,188,182,189,182,190,26,191,26,},[84]={122,104,123,104,124,260,125,260,126,364,127,364,128,364,129,364,130,364,131,364,132,26,133,26,180,104,181,104,182,364,183,364,184,364,185,364,186,364,187,364,188,234,189,234,190,52,191,52,},[85]={122,104,123,104,124,260,125,260,126,364,127,364,128,364,129,364,130,364,131,364,132,26,133,26,180,104,181,104,182,364,183,364,184,364,185,364,186,364,187,364,188,234,189,234,190,52,191,52,},[86]={122,130,123,130,124,286,125,286,126,370,127,370,128,360,129,360,130,346,131,346,180,26,181,26,182,364,183,364,184,364,185,364,186,364,187,364,188,260,189,260,190,104,191,104,},[87]={122,130,123,130,124,286,125,286,126,370,127,370,128,360,129,360,130,346,131,346,180,26,181,26,182,364,183,364,184,364,185,364,186,364,187,364,188,260,189,260,190,104,191,104,},[88]={120,26,121,26,122,156,123,156,124,338,125,338,126,370,127,370,128,358,129,358,130,284,131,284,182,338,183,338,184,364,185,364,186,364,187,364,188,260,189,260,190,104,191,104,},[89]={120,26,121,26,122,156,123,156,124,338,125,338,126,370,127,370,128,358,129,358,130,284,131,284,182,338,183,338,184,364,185,364,186,364,187,364,188,260,189,260,190,104,191,104,},[90]={120,52,121,52,122,156,123,156,124,338,125,338,126,370,127,370,128,370,129,370,130,234,131,234,182,312,183,312,184,370,185,370,186,370,187,370,188,260,189,260,190,104,191,104,},[91]={120,52,121,52,122,156,123,156,124,338,125,338,126,370,127,370,128,370,129,370,130,234,131,234,182,312,183,312,184,370,185,370,186,370,187,370,188,260,189,260,190,104,191,104,},[92]={120,52,121,52,122,156,123,156,124,338,125,338,126,370,127,370,128,370,129,370,130,208,131,208,182,286,183,286,184,376,185,376,186,376,187,376,188,312,189,312,190,130,191,130,},[93]={120,52,121,52,122,156,123,156,124,338,125,338,126,370,127,370,128,370,129,370,130,208,131,208,182,286,183,286,184,376,185,376,186,376,187,376,188,312,189,312,190,130,191,130,},[94]={120,26,121,26,122,156,123,156,124,312,125,312,126,370,127,370,128,370,129,370,130,234,131,234,182,234,183,234,184,376,185,376,186,376,187,376,188,312,189,312,190,130,191,130,},[95]={120,26,121,26,122,156,123,156,124,312,125,312,126,370,127,370,128,370,129,370,130,234,131,234,182,234,183,234,184,376,185,376,186,376,187,376,188,312,189,312,190,130,191,130,},[96]={122,156,123,156,124,312,125,312,126,382,127,382,128,382,129,382,130,260,131,260,182,258,183,258,184,346,185,346,186,370,187,370,188,312,189,312,190,130,191,130,},[97]={122,156,123,156,124,312,125,312,126,382,127,382,128,382,129,382,130,260,131,260,182,258,183,258,184,346,185,346,186,370,187,370,188,312,189,312,190,130,191,130,},[98]={122,130,123,130,124,312,125,312,126,382,127,382,128,382,129,382,130,292,131,292,182,298,183,298,184,338,185,338,186,364,187,364,188,260,189,260,190,104,191,104,},[99]={122,130,123,130,124,312,125,312,126,382,127,382,128,382,129,382,130,292,131,292,182,298,183,298,184,338,185,338,186,364,187,364,188,260,189,260,190,104,191,104,},[100]={122,104,123,104,124,260,125,260,126,364,127,364,128,361,129,361,130,355,131,355,180,26,181,26,182,346,183,346,184,364,185,364,186,364,187,364,188,234,189,234,190,78,191,78,},[101]={122,104,123,104,124,260,125,260,126,364,127,364,128,361,129,361,130,355,131,355,180,26,181,26,182,346,183,346,184,364,185,364,186,364,187,364,188,234,189,234,190,78,191,78,},[102]={122,78,123,78,124,208,125,208,126,364,127,364,128,363,129,363,130,361,131,361,132,130,133,130,180,191,181,191,182,355,183,355,184,364,185,364,186,340,187,340,188,182,189,182,190,26,191,26,},[103]={122,78,123,78,124,208,125,208,126,364,127,364,128,363,129,363,130,361,131,361,132,130,133,130,180,191,181,191,182,355,183,355,184,364,185,364,186,340,187,340,188,182,189,182,190,26,191,26,},[104]={122,26,123,26,124,182,125,182,126,364,127,364,128,364,129,364,130,364,131,364,132,260,133,260,178,26,179,26,180,303,181,303,182,355,183,355,184,364,185,364,186,286,187,286,188,156,189,156,},[105]={122,26,123,26,124,182,125,182,126,364,127,364,128,364,129,364,130,364,131,364,132,260,133,260,178,26,179,26,180,303,181,303,182,355,183,355,184,364,185,364,186,286,187,286,188,156,189,156,},[106]={124,130,125,130,126,260,127,260,128,364,129,364,130,364,131,364,132,355,133,355,134,174,135,174,178,211,179,211,180,361,181,361,182,364,183,364,184,364,185,364,186,234,187,234,188,104,189,104,},[107]={124,130,125,130,126,260,127,260,128,364,129,364,130,364,131,364,132,355,133,355,134,174,135,174,178,211,179,211,180,361,181,361,182,364,183,364,184,364,185,364,186,234,187,234,188,104,189,104,},[108]={124,104,125,104,126,208,127,208,128,364,129,364,130,364,131,364,132,355,133,355,134,331,135,331,136,102,137,102,176,78,177,78,178,361,179,361,180,361,181,361,182,364,183,364,184,286,185,286,186,156,187,156,188,26,189,26,},[109]={124,104,125,104,126,208,127,208,128,364,129,364,130,364,131,364,132,355,133,355,134,331,135,331,136,102,137,102,176,78,177,78,178,361,179,361,180,361,181,361,182,364,183,364,184,286,185,286,186,156,187,156,188,26,189,26,},[110]={126,130,127,130,128,286,129,286,130,364,131,364,132,364,133,364,134,349,135,349,136,288,137,288,138,61,139,61,174,104,175,104,176,338,177,338,178,364,179,364,180,364,181,364,182,364,183,364,184,234,185,234,186,104,187,104,},[111]={126,130,127,130,128,286,129,286,130,364,131,364,132,364,133,364,134,349,135,349,136,288,137,288,138,61,139,61,174,104,175,104,176,338,177,338,178,364,179,364,180,364,181,364,182,364,183,364,184,234,185,234,186,104,187,104,},[112]={126,52,127,52,128,182,129,182,130,312,131,312,132,364,133,364,134,364,135,364,136,355,137,355,138,243,139,243,140,104,141,104,172,116,173,116,174,272,175,272,176,364,177,364,178,364,179,364,180,364,181,364,182,234,183,234,184,156,185,156,186,52,187,52,},[113]={126,52,127,52,128,182,129,182,130,312,131,312,132,364,133,364,134,364,135,364,136,355,137,355,138,243,139,243,140,104,141,104,172,116,173,116,174,272,175,272,176,364,177,364,178,364,179,364,180,364,181,364,182,234,183,234,184,156,185,156,186,52,187,52,},[114]={128,104,129,104,130,208,131,208,132,338,133,338,134,364,135,364,136,364,137,364,138,364,139,364,140,341,141,341,142,145,143,145,168,26,169,26,170,87,171,87,172,317,173,317,174,352,175,352,176,364,177,364,178,364,179,364,180,338,181,338,182,156,183,156,184,78,185,78,},[115]={128,104,129,104,130,208,131,208,132,338,133,338,134,364,135,364,136,364,137,364,138,364,139,364,140,341,141,341,142,145,143,145,168,26,169,26,170,87,171,87,172,317,173,317,174,352,175,352,176,364,177,364,178,364,179,364,180,338,181,338,182,156,183,156,184,78,185,78,},[116]={128,1,129,1,130,130,131,130,132,234,133,234,134,338,135,338,136,364,137,364,138,364,139,364,140,364,141,364,142,340,143,340,144,249,145,249,146,130,147,130,164,53,165,53,166,117,167,117,168,220,169,220,170,337,171,337,172,337,173,337,174,364,175,364,176,364,177,364,178,312,179,312,180,234,181,234,182,104,183,104,184,26,185,26,},[117]={128,1,129,1,130,130,131,130,132,234,133,234,134,338,135,338,136,364,137,364,138,364,139,364,140,364,141,364,142,340,143,340,144,249,145,249,146,130,147,130,164,53,165,53,166,117,167,117,168,220,169,220,170,337,171,337,172,337,173,337,174,364,175,364,176,364,177,364,178,312,179,312,180,234,181,234,182,104,183,104,184,26,185,26,},[118]={128,1,129,1,130,14,131,14,132,100,133,100,134,260,135,260,136,338,137,338,138,364,139,364,140,364,141,364,142,361,143,361,144,361,145,361,146,364,147,364,148,352,149,352,150,275,151,275,152,214,153,214,154,113,155,113,156,149,157,149,158,170,159,170,160,235,161,235,162,286,163,286,164,343,165,343,166,343,167,343,168,376,169,376,170,376,171,376,172,346,173,346,174,364,175,364,176,338,177,338,178,182,179,182,180,104,181,104,},[119]={128,1,129,1,130,14,131,14,132,100,133,100,134,260,135,260,136,338,137,338,138,364,139,364,140,364,141,364,142,361,143,361,144,361,145,361,146,364,147,364,148,352,149,352,150,275,151,275,152,214,153,214,154,113,155,113,156,149,157,149,158,170,159,170,160,235,161,235,162,286,163,286,164,343,165,343,166,343,167,343,168,376,169,376,170,376,171,376,172,346,173,346,174,364,175,364,176,338,177,338,178,182,179,182,180,104,181,104,},[120]={132,10,133,10,134,78,135,78,136,156,137,156,138,312,139,312,140,364,141,364,142,364,143,364,144,364,145,364,146,364,147,364,148,352,149,352,150,358,151,358,152,358,153,358,154,328,155,328,156,331,157,331,158,352,159,352,160,361,161,361,162,400,163,400,164,424,165,424,166,424,167,424,168,376,169,376,170,376,171,376,172,338,173,338,174,286,175,286,176,182,177,182,178,78,179,78,180,26,181,26,},[121]={132,10,133,10,134,78,135,78,136,156,137,156,138,312,139,312,140,364,141,364,142,364,143,364,144,364,145,364,146,364,147,364,148,352,149,352,150,358,151,358,152,358,153,358,154,328,155,328,156,331,157,331,158,352,159,352,160,361,161,361,162,400,163,400,164,424,165,424,166,424,167,424,168,376,169,376,170,376,171,376,172,338,173,338,174,286,175,286,176,182,177,182,178,78,179,78,180,26,181,26,},[122]={136,48,137,48,138,130,139,130,140,208,141,208,142,312,143,312,144,364,145,364,146,364,147,364,148,364,149,364,150,358,151,358,152,358,153,358,154,349,155,349,156,382,157,382,158,382,159,382,160,382,161,382,162,400,163,400,164,424,165,424,166,424,167,424,168,364,169,364,170,260,171,260,172,208,173,208,174,130,175,130,176,52,177,52,},[123]={136,48,137,48,138,130,139,130,140,208,141,208,142,312,143,312,144,364,145,364,146,364,147,364,148,364,149,364,150,358,151,358,152,358,153,358,154,349,155,349,156,382,157,382,158,382,159,382,160,382,161,382,162,400,163,400,164,424,165,424,166,424,167,424,168,364,169,364,170,260,171,260,172,208,173,208,174,130,175,130,176,52,177,52,},[124]={140,38,141,38,142,118,143,118,144,208,145,208,146,260,147,260,148,286,149,286,150,338,151,338,152,338,153,338,154,364,155,364,156,382,157,382,158,382,159,382,160,376,161,376,162,362,163,362,164,304,165,304,166,260,167,260,168,208,169,208,170,130,171,130,172,78,173,78,174,26,175,26,},[125]={140,38,141,38,142,118,143,118,144,208,145,208,146,260,147,260,148,286,149,286,150,338,151,338,152,338,153,338,154,364,155,364,156,382,157,382,158,382,159,382,160,376,161,376,162,362,163,362,164,304,165,304,166,260,167,260,168,208,169,208,170,130,171,130,172,78,173,78,174,26,175,26,},[126]={146,104,147,104,148,130,149,130,150,156,151,156,152,182,153,182,154,182,155,182,156,182,157,182,158,182,159,182,160,182,161,182,162,156,163,156,164,130,165,130,166,104,167,104,168,52,169,52,170,26,171,26,},[127]={146,104,147,104,148,130,149,130,150,156,151,156,152,182,153,182,154,182,155,182,156,182,157,182,158,182,159,182,160,182,161,182,162,156,163,156,164,130,165,130,166,104,167,104,168,52,169,52,170,26,171,26,},[128]={150,40,151,40,152,52,153,52,154,52,155,52,156,52,157,52,158,12,159,12,},[129]={150,40,151,40,152,52,153,52,154,52,155,52,156,52,157,52,158,12,159,12,}
		},
		
		markers ={
			90, 184, 72, 176, 64, 160, 64, 142, 80, 128, 98, 126, 116, 138, 120, 156, 116, 174, 104, 182, 90, 154, 
		},
		
		objects = {
			[60]={156,5,1,-1,0,},[62]={148,5,7,-1,0,},[64]={156,5,7,-1,0,},[68]={168,5,1,-1,0,},[70]={170,5,1,-1,0,},[72]={132,5,2,-1,512,},[84]={190,5,3,-1,0,},[94]={190,5,7,-1,0,},[98]={190,5,7,-1,0,},[100]={128,5,7,-1,0,},[102]={128,5,7,-1,0,},[106]={176,5,7,-1,0,},[110]={176,5,1,-1,0,},[112]={136,5,1,-1,0,},[116]={164,5,7,-1,0,},[122]={150,5,7,-1,0,},[124]={144,5,2,-1,0,},
		},
		
		shaman_positions = {
			
		},
		
		scripts = {
				OnTurn = function(everySecond1, everySecond2, everySecond4) 			corrosion_on_turn(everySecond1, everySecond2, everySecond4) end,
				OnCreateThing = function(t, owner, type, model) 						CO_on_create_thing(t, owner, type, model) end,
				OnShamanDeath = function(victim, killer, killer_was_ally)				CO_on_shaman_dead(victim, killer, killer_was_ally) end,
				OnHumanDisconnect = function(player) 									CO_init_single_AI(player) end,
		},
		
	},
	
	[MAP_BOAT_RACE_II]={
	
		info = 	{ 	name = "Boat Race 2", author = "Toxicity & Zyraw",
					desc = "Short, fast, and manic. This track requires players to be consistently attentive to their positions and the dangers surrounding them. <p> Whilst other players will be able to disable one another, avoiding the hazards of the track is paramount to success. <p> - Gain a random spell when passing through particle effects. <p> - A new Blast spell on the Convert slot will direct blast every player on the map. <p> - Starting and Finish areas are no Spell zones, indicated by a line of clouds. <p> - When stuck, use the Teleport Spell to restart from the beginning.",
					map_objectives = { {value=10, limit=30, step=5, default=false}, {value=6, step=1, limit=15, default=true}, {} },
					image = 2624, texture={12, 0}, zoom={80,84,1024}, drop_infos = true,	marker_lb={204, 148}, reinc_timer=12*1, shield_respawn=false, optional_shaman_zoom_angle = 1024,
					custom_rules = {
						{ default = false, 	name = "No S clicks", desc = "S clicks (on shamans or boats) won't follow shamans/boats. You can still blast your own boat." },
					}
				},

		land ={
			[48]={0,1014,1,1014,2,1014,3,1014,4,1014,5,1014,6,1014,7,1014,8,1014,9,1014,10,1014,11,1014,12,1014,13,1014,14,1014,15,1014,16,1014,17,1014,18,1014,19,1014,20,1014,21,1014,22,1014,23,1014,24,1014,25,1014,26,1014,27,1014,28,1014,29,1014,30,1014,31,1014,32,1014,33,1014,34,1014,35,1014,36,1014,37,1014,38,1014,39,1014,40,1011,41,1011,42,1011,43,1011,44,1009,45,1009,46,1004,47,1004,48,1004,49,1004,50,1004,51,1004,52,1004,53,1004,54,1004,55,1004,56,1004,57,1004,58,1004,59,1004,60,1004,61,1004,62,1004,63,1004,64,1004,65,1004,66,1004,67,1004,68,1004,69,1004,70,1004,71,1004,72,1004,73,1004,74,1004,75,1004,76,1004,77,1004,78,1004,79,1004,80,1004,81,1004,82,1004,83,1004,84,1004,85,1004,86,1004,87,1004,88,1004,89,1004,90,1004,91,1004,92,1004,93,1004,94,1004,95,1004,96,1004,97,1004,98,1004,99,1004,100,1004,101,1004,102,1004,103,1004,104,1003,105,1003,204,1014,205,1014,206,1014,207,1014,208,1014,209,1014,210,1014,211,1014,212,1014,213,1014,214,1014,215,1014,216,1014,217,1014,218,1014,219,1014,220,1014,221,1014,222,1014,223,1014,224,1014,225,1014,226,1014,227,1014,228,1014,229,1014,230,1014,231,1014,232,1014,233,1014,234,1014,235,1014,236,1014,237,1014,238,1014,239,1014,240,1014,241,1014,242,1014,243,1014,244,1014,245,1014,246,1014,247,1014,248,1014,249,1014,250,1014,251,1014,252,1014,253,1014,254,1014,255,1014,},[49]={0,1014,1,1014,2,1014,3,1014,4,1014,5,1014,6,1014,7,1014,8,1014,9,1014,10,1014,11,1014,12,1014,13,1014,14,1014,15,1014,16,1014,17,1014,18,1014,19,1014,20,1014,21,1014,22,1014,23,1014,24,1014,25,1014,26,1014,27,1014,28,1014,29,1014,30,1014,31,1014,32,1014,33,1014,34,1014,35,1014,36,1014,37,1014,38,1014,39,1014,40,1011,41,1011,42,1011,43,1011,44,1009,45,1009,46,1004,47,1004,48,1004,49,1004,50,1004,51,1004,52,1004,53,1004,54,1004,55,1004,56,1004,57,1004,58,1004,59,1004,60,1004,61,1004,62,1004,63,1004,64,1004,65,1004,66,1004,67,1004,68,1004,69,1004,70,1004,71,1004,72,1004,73,1004,74,1004,75,1004,76,1004,77,1004,78,1004,79,1004,80,1004,81,1004,82,1004,83,1004,84,1004,85,1004,86,1004,87,1004,88,1004,89,1004,90,1004,91,1004,92,1004,93,1004,94,1004,95,1004,96,1004,97,1004,98,1004,99,1004,100,1004,101,1004,102,1004,103,1004,104,1003,105,1003,204,1014,205,1014,206,1014,207,1014,208,1014,209,1014,210,1014,211,1014,212,1014,213,1014,214,1014,215,1014,216,1014,217,1014,218,1014,219,1014,220,1014,221,1014,222,1014,223,1014,224,1014,225,1014,226,1014,227,1014,228,1014,229,1014,230,1014,231,1014,232,1014,233,1014,234,1014,235,1014,236,1014,237,1014,238,1014,239,1014,240,1014,241,1014,242,1014,243,1014,244,1014,245,1014,246,1014,247,1014,248,1014,249,1014,250,1014,251,1014,252,1014,253,1014,254,1014,255,1014,},[50]={0,1014,1,1014,2,1014,3,1014,4,1014,5,1014,6,1014,7,1014,8,1014,9,1014,10,1014,11,1014,12,1014,13,1014,14,1014,15,1014,16,1014,17,1014,18,1014,19,1014,20,1014,21,1014,22,1014,23,1014,24,1014,25,1014,26,1014,27,1014,28,1014,29,1014,30,1014,31,1014,32,1014,33,1014,34,1014,35,1014,36,1014,37,1014,38,1014,39,1014,40,1011,41,1011,42,1011,43,1011,44,1009,45,1009,46,1004,47,1004,48,1004,49,1004,50,1004,51,1004,52,1004,53,1004,54,1004,55,1004,56,1004,57,1004,58,1004,59,1004,60,1004,61,1004,62,1004,63,1004,64,1004,65,1004,66,1004,67,1004,68,1004,69,1004,70,1004,71,1004,72,1004,73,1004,74,1004,75,1004,76,1004,77,1004,78,1004,79,1004,80,1004,81,1004,82,1004,83,1004,84,1004,85,1004,86,1004,87,1004,88,1004,89,1004,90,1004,91,1004,92,1004,93,1004,94,1004,95,1004,96,1004,97,1004,98,1004,99,1004,100,1004,101,1004,102,1004,103,1004,104,1003,105,1003,106,999,107,999,202,1014,203,1014,204,1014,205,1014,206,1014,207,1014,208,1014,209,1014,210,1014,211,1014,212,1014,213,1014,214,1014,215,1014,216,1014,217,1014,218,1014,219,1014,220,1014,221,1014,222,1014,223,1014,224,1014,225,1014,226,1014,227,1014,228,1014,229,1014,230,1014,231,1014,232,1014,233,1014,234,1014,235,1014,236,1014,237,1014,238,1014,239,1014,240,1014,241,1014,242,1014,243,1014,244,1014,245,1014,246,1014,247,1014,248,1014,249,1014,250,1014,251,1014,252,1014,253,1014,254,1014,255,1014,},[51]={0,1014,1,1014,2,1014,3,1014,4,1014,5,1014,6,1014,7,1014,8,1014,9,1014,10,1014,11,1014,12,1014,13,1014,14,1014,15,1014,16,1014,17,1014,18,1014,19,1014,20,1014,21,1014,22,1014,23,1014,24,1014,25,1014,26,1014,27,1014,28,1014,29,1014,30,1014,31,1014,32,1014,33,1014,34,1014,35,1014,36,1014,37,1014,38,1014,39,1014,40,1011,41,1011,42,1011,43,1011,44,1009,45,1009,46,1004,47,1004,48,1004,49,1004,50,1004,51,1004,52,1004,53,1004,54,1004,55,1004,56,1004,57,1004,58,1004,59,1004,60,1004,61,1004,62,1004,63,1004,64,1004,65,1004,66,1004,67,1004,68,1004,69,1004,70,1004,71,1004,72,1004,73,1004,74,1004,75,1004,76,1004,77,1004,78,1004,79,1004,80,1004,81,1004,82,1004,83,1004,84,1004,85,1004,86,1004,87,1004,88,1004,89,1004,90,1004,91,1004,92,1004,93,1004,94,1004,95,1004,96,1004,97,1004,98,1004,99,1004,100,1004,101,1004,102,1004,103,1004,104,1003,105,1003,106,999,107,999,202,1014,203,1014,204,1014,205,1014,206,1014,207,1014,208,1014,209,1014,210,1014,211,1014,212,1014,213,1014,214,1014,215,1014,216,1014,217,1014,218,1014,219,1014,220,1014,221,1014,222,1014,223,1014,224,1014,225,1014,226,1014,227,1014,228,1014,229,1014,230,1014,231,1014,232,1014,233,1014,234,1014,235,1014,236,1014,237,1014,238,1014,239,1014,240,1014,241,1014,242,1014,243,1014,244,1014,245,1014,246,1014,247,1014,248,1014,249,1014,250,1014,251,1014,252,1014,253,1014,254,1014,255,1014,},[52]={38,258,39,258,40,271,41,271,42,271,43,271,44,266,45,266,68,540,69,540,70,540,71,540,72,540,73,540,74,540,75,540,76,540,77,540,78,540,79,540,80,540,81,540,82,540,83,540,104,999,105,999,106,999,107,999,108,984,109,984,200,1014,201,1014,202,1014,203,1014,204,1014,205,1014,250,390,251,390,252,390,253,390,},[53]={38,258,39,258,40,271,41,271,42,271,43,271,44,266,45,266,68,540,69,540,70,540,71,540,72,540,73,540,74,540,75,540,76,540,77,540,78,540,79,540,80,540,81,540,82,540,83,540,104,999,105,999,106,999,107,999,108,984,109,984,200,1014,201,1014,202,1014,203,1014,204,1014,205,1014,250,390,251,390,252,390,253,390,},[54]={38,180,39,180,40,219,41,219,42,219,43,219,44,193,45,193,68,540,69,540,70,540,71,540,72,540,73,540,74,540,75,540,76,540,77,540,78,540,79,540,80,540,81,540,82,540,83,540,106,984,107,984,108,984,109,984,110,978,111,978,198,1014,199,1014,200,1014,201,1014,202,1014,203,1014,250,390,251,390,252,390,253,390,},[55]={38,180,39,180,40,219,41,219,42,219,43,219,44,193,45,193,68,540,69,540,70,540,71,540,72,540,73,540,74,540,75,540,76,540,77,540,78,540,79,540,80,540,81,540,82,540,83,540,106,984,107,984,108,984,109,984,110,978,111,978,198,1014,199,1014,200,1014,201,1014,202,1014,203,1014,250,390,251,390,252,390,253,390,},[56]={108,978,109,978,110,978,111,978,112,978,113,978,196,1014,197,1014,198,1014,199,1014,200,1014,201,1014,},[57]={108,978,109,978,110,978,111,978,112,978,113,978,196,1014,197,1014,198,1014,199,1014,200,1014,201,1014,},[58]={110,978,111,978,112,978,113,978,114,978,115,978,194,1014,195,1014,196,1014,197,1014,198,1014,199,1014,},[59]={110,978,111,978,112,978,113,978,114,978,115,978,194,1014,195,1014,196,1014,197,1014,198,1014,199,1014,},[60]={10,65,11,65,12,52,13,52,24,65,25,65,26,52,27,52,112,978,113,978,114,978,115,978,116,978,117,978,192,1014,193,1014,194,1014,195,1014,196,1014,197,1014,},[61]={10,65,11,65,12,52,13,52,24,65,25,65,26,52,27,52,112,978,113,978,114,978,115,978,116,978,117,978,192,1014,193,1014,194,1014,195,1014,196,1014,197,1014,},[62]={114,978,115,978,116,978,117,978,118,978,119,978,190,1014,191,1014,192,1014,193,1014,194,1014,195,1014,},[63]={114,978,115,978,116,978,117,978,118,978,119,978,190,1014,191,1014,192,1014,193,1014,194,1014,195,1014,},[64]={116,978,117,978,118,978,119,978,190,1014,191,1014,192,1014,193,1014,},[65]={116,978,117,978,118,978,119,978,190,1014,191,1014,192,1014,193,1014,},[66]={116,978,117,978,118,978,119,978,190,1014,191,1014,192,1014,193,1014,},[67]={116,978,117,978,118,978,119,978,190,1014,191,1014,192,1014,193,1014,},[68]={116,978,117,978,118,978,119,978,190,1014,191,1014,192,1014,193,1014,},[69]={116,978,117,978,118,978,119,978,190,1014,191,1014,192,1014,193,1014,},[70]={10,65,11,65,12,65,13,65,24,65,25,65,26,65,27,65,116,979,117,979,118,979,119,979,190,1014,191,1014,192,1014,193,1014,},[71]={10,65,11,65,12,65,13,65,24,65,25,65,26,65,27,65,116,979,117,979,118,979,119,979,190,1014,191,1014,192,1014,193,1014,},[72]={116,980,117,980,118,980,119,980,190,1014,191,1014,192,1014,193,1014,},[73]={116,980,117,980,118,980,119,980,190,1014,191,1014,192,1014,193,1014,},[74]={116,979,117,979,118,979,119,979,190,1014,191,1014,192,1014,193,1014,},[75]={116,979,117,979,118,979,119,979,190,1014,191,1014,192,1014,193,1014,},[76]={38,193,39,193,40,219,41,219,42,219,43,219,44,180,45,180,68,585,69,585,70,585,71,585,72,585,73,585,74,585,75,585,76,585,77,585,78,585,79,585,80,585,81,585,82,585,83,585,116,978,117,978,118,978,119,978,190,1014,191,1014,192,1014,193,1014,250,390,251,390,252,390,253,390,},[77]={38,193,39,193,40,219,41,219,42,219,43,219,44,180,45,180,68,585,69,585,70,585,71,585,72,585,73,585,74,585,75,585,76,585,77,585,78,585,79,585,80,585,81,585,82,585,83,585,116,978,117,978,118,978,119,978,190,1014,191,1014,192,1014,193,1014,250,390,251,390,252,390,253,390,},[78]={38,266,39,266,40,271,41,271,42,271,43,271,44,258,45,258,68,585,69,585,70,1,71,1,72,1,73,1,74,1,75,1,76,1,77,1,78,1,79,1,80,1,81,1,82,585,83,585,98,48,99,48,100,106,101,106,102,114,103,114,104,54,105,54,116,979,117,979,118,979,119,979,190,1014,191,1014,192,1014,193,1014,250,390,251,390,252,390,253,390,},[79]={38,266,39,266,40,271,41,271,42,271,43,271,44,258,45,258,68,585,69,585,70,1,71,1,72,1,73,1,74,1,75,1,76,1,77,1,78,1,79,1,80,1,81,1,82,585,83,585,98,48,99,48,100,106,101,106,102,114,103,114,104,54,105,54,116,979,117,979,118,979,119,979,190,1014,191,1014,192,1014,193,1014,250,390,251,390,252,390,253,390,},[80]={0,1014,1,1014,2,1014,3,1014,4,1014,5,1014,6,1014,7,1014,8,1014,9,1014,10,1014,11,1014,12,1014,13,1014,14,1014,15,1014,16,1014,17,1014,18,1014,19,1014,20,1014,21,1014,22,1014,23,1014,24,1014,25,1014,26,1014,27,1014,28,1014,29,1014,30,1014,31,1014,32,1014,33,1014,34,1014,35,1014,36,1014,37,1014,38,1017,39,1017,40,1018,41,1018,42,1018,43,1018,44,1020,45,1020,46,1020,47,1020,48,1020,49,1020,50,260,51,260,52,261,53,261,54,261,55,261,56,262,57,262,58,265,59,265,60,270,61,270,62,280,63,280,64,300,65,300,66,341,67,341,68,503,69,503,70,503,71,503,72,585,73,585,74,585,75,585,76,585,77,585,78,585,79,585,80,585,81,585,82,585,83,585,98,108,99,108,100,166,101,166,102,166,103,166,104,132,105,132,116,980,117,980,118,980,119,980,190,1014,191,1014,192,1014,193,1014,194,325,195,325,196,325,197,325,198,325,199,325,200,325,201,325,218,334,219,334,220,334,221,334,222,334,223,334,224,334,225,334,226,334,227,334,228,334,229,334,230,333,231,333,232,333,233,333,234,331,235,331,236,330,237,330,238,330,239,330,240,1014,241,1014,242,1014,243,1014,244,1014,245,1014,246,1014,247,1014,248,1014,249,1014,250,1014,251,1014,252,1014,253,1014,254,1014,255,1014,},[81]={0,1014,1,1014,2,1014,3,1014,4,1014,5,1014,6,1014,7,1014,8,1014,9,1014,10,1014,11,1014,12,1014,13,1014,14,1014,15,1014,16,1014,17,1014,18,1014,19,1014,20,1014,21,1014,22,1014,23,1014,24,1014,25,1014,26,1014,27,1014,28,1014,29,1014,30,1014,31,1014,32,1014,33,1014,34,1014,35,1014,36,1014,37,1014,38,1017,39,1017,40,1018,41,1018,42,1018,43,1018,44,1020,45,1020,46,1020,47,1020,48,1020,49,1020,50,260,51,260,52,261,53,261,54,261,55,261,56,262,57,262,58,265,59,265,60,270,61,270,62,280,63,280,64,300,65,300,66,341,67,341,68,503,69,503,70,503,71,503,72,585,73,585,74,585,75,585,76,585,77,585,78,585,79,585,80,585,81,585,82,585,83,585,98,108,99,108,100,166,101,166,102,166,103,166,104,132,105,132,116,980,117,980,118,980,119,980,190,1014,191,1014,192,1014,193,1014,194,325,195,325,196,325,197,325,198,325,199,325,200,325,201,325,218,334,219,334,220,334,221,334,222,334,223,334,224,334,225,334,226,334,227,334,228,334,229,334,230,333,231,333,232,333,233,333,234,331,235,331,236,330,237,330,238,330,239,330,240,1014,241,1014,242,1014,243,1014,244,1014,245,1014,246,1014,247,1014,248,1014,249,1014,250,1014,251,1014,252,1014,253,1014,254,1014,255,1014,},[82]={0,1014,1,1014,2,1014,3,1014,4,1014,5,1014,6,1014,7,1014,8,1014,9,1014,10,1014,11,1014,12,1014,13,1014,14,1014,15,1014,16,1014,17,1014,18,1014,19,1014,20,1014,21,1014,22,1014,23,1014,24,1014,25,1014,26,1014,27,1014,28,1014,29,1014,30,1014,31,1014,32,1014,33,1014,34,1014,35,1014,36,1014,37,1014,38,1017,39,1017,40,1018,41,1018,42,1018,43,1018,44,1020,45,1020,46,1020,47,1020,48,1020,49,1020,50,260,51,260,52,261,53,261,54,261,55,261,56,262,57,262,58,265,59,265,60,270,61,270,62,280,63,280,64,300,65,300,66,341,67,341,68,503,69,503,70,503,71,503,72,585,73,585,74,585,75,585,76,585,77,585,78,585,79,585,80,585,81,585,82,585,83,585,98,108,99,108,100,166,101,166,102,166,103,166,104,139,105,139,116,980,117,980,118,980,119,980,190,1014,191,1014,192,1014,193,1014,194,325,195,325,196,325,197,325,198,325,199,325,200,325,201,325,218,334,219,334,220,334,221,334,222,334,223,334,224,334,225,334,226,334,227,334,228,334,229,334,230,333,231,333,232,333,233,333,234,331,235,331,236,330,237,330,238,330,239,330,240,1014,241,1014,242,1014,243,1014,244,1014,245,1014,246,1014,247,1014,248,1014,249,1014,250,1014,251,1014,252,1014,253,1014,254,1014,255,1014,},[83]={0,1014,1,1014,2,1014,3,1014,4,1014,5,1014,6,1014,7,1014,8,1014,9,1014,10,1014,11,1014,12,1014,13,1014,14,1014,15,1014,16,1014,17,1014,18,1014,19,1014,20,1014,21,1014,22,1014,23,1014,24,1014,25,1014,26,1014,27,1014,28,1014,29,1014,30,1014,31,1014,32,1014,33,1014,34,1014,35,1014,36,1014,37,1014,38,1017,39,1017,40,1018,41,1018,42,1018,43,1018,44,1020,45,1020,46,1020,47,1020,48,1020,49,1020,50,260,51,260,52,261,53,261,54,261,55,261,56,262,57,262,58,265,59,265,60,270,61,270,62,280,63,280,64,300,65,300,66,341,67,341,68,503,69,503,70,503,71,503,72,585,73,585,74,585,75,585,76,585,77,585,78,585,79,585,80,585,81,585,82,585,83,585,98,108,99,108,100,166,101,166,102,166,103,166,104,139,105,139,116,980,117,980,118,980,119,980,190,1014,191,1014,192,1014,193,1014,194,325,195,325,196,325,197,325,198,325,199,325,200,325,201,325,218,334,219,334,220,334,221,334,222,334,223,334,224,334,225,334,226,334,227,334,228,334,229,334,230,333,231,333,232,333,233,333,234,331,235,331,236,330,237,330,238,330,239,330,240,1014,241,1014,242,1014,243,1014,244,1014,245,1014,246,1014,247,1014,248,1014,249,1014,250,1014,251,1014,252,1014,253,1014,254,1014,255,1014,},[84]={4,22,5,22,6,22,7,22,8,22,9,22,10,22,11,22,12,1014,13,1014,14,1014,15,1014,16,26,17,26,18,26,19,26,20,26,21,26,22,26,23,26,24,39,25,39,26,39,27,39,28,39,29,39,30,26,31,26,68,585,69,585,70,1,71,1,72,1,73,1,74,1,75,1,76,1,77,1,78,1,79,1,80,1,81,1,82,585,83,585,98,48,99,48,100,120,101,120,102,114,103,114,104,72,105,72,116,980,117,980,118,980,119,980,190,1014,191,1014,192,1014,193,1014,},[85]={4,22,5,22,6,22,7,22,8,22,9,22,10,22,11,22,12,1014,13,1014,14,1014,15,1014,16,26,17,26,18,26,19,26,20,26,21,26,22,26,23,26,24,39,25,39,26,39,27,39,28,39,29,39,30,26,31,26,68,585,69,585,70,1,71,1,72,1,73,1,74,1,75,1,76,1,77,1,78,1,79,1,80,1,81,1,82,585,83,585,98,48,99,48,100,120,101,120,102,114,103,114,104,72,105,72,116,980,117,980,118,980,119,980,190,1014,191,1014,192,1014,193,1014,},[86]={4,22,5,22,6,22,7,22,8,22,9,22,10,22,11,22,12,1014,13,1014,14,1014,15,1014,16,26,17,26,18,26,19,26,20,26,21,26,22,26,23,26,24,39,25,39,26,39,27,39,28,39,29,39,30,26,31,26,68,585,69,585,70,585,71,585,72,585,73,585,74,585,75,585,76,585,77,585,78,585,79,585,80,585,81,585,82,585,83,585,116,980,117,980,118,980,119,980,190,1014,191,1014,192,1014,193,1014,},[87]={4,22,5,22,6,22,7,22,8,22,9,22,10,22,11,22,12,1014,13,1014,14,1014,15,1014,16,26,17,26,18,26,19,26,20,26,21,26,22,26,23,26,24,39,25,39,26,39,27,39,28,39,29,39,30,26,31,26,68,585,69,585,70,585,71,585,72,585,73,585,74,585,75,585,76,585,77,585,78,585,79,585,80,585,81,585,82,585,83,585,116,980,117,980,118,980,119,980,190,1014,191,1014,192,1014,193,1014,},[88]={4,22,5,22,6,22,7,22,8,22,9,22,10,22,11,22,12,1014,13,1014,14,1014,15,1014,16,26,17,26,18,26,19,26,20,26,21,26,22,26,23,26,24,33,25,33,26,33,27,33,28,39,29,39,30,26,31,26,116,979,117,979,118,979,119,979,190,1014,191,1014,192,1014,193,1014,},[89]={4,22,5,22,6,22,7,22,8,22,9,22,10,22,11,22,12,1014,13,1014,14,1014,15,1014,16,26,17,26,18,26,19,26,20,26,21,26,22,26,23,26,24,33,25,33,26,33,27,33,28,39,29,39,30,26,31,26,116,979,117,979,118,979,119,979,190,1014,191,1014,192,1014,193,1014,},[90]={4,22,5,22,6,22,7,22,8,22,9,22,10,22,11,22,12,1014,13,1014,14,1014,15,1014,16,26,17,26,18,26,19,26,20,26,21,26,22,26,23,26,24,26,25,26,26,26,27,26,28,26,29,26,30,26,31,26,116,978,117,978,118,978,119,978,190,1014,191,1014,192,1014,193,1014,},[91]={4,22,5,22,6,22,7,22,8,22,9,22,10,22,11,22,12,1014,13,1014,14,1014,15,1014,16,26,17,26,18,26,19,26,20,26,21,26,22,26,23,26,24,26,25,26,26,26,27,26,28,26,29,26,30,26,31,26,116,978,117,978,118,978,119,978,190,1014,191,1014,192,1014,193,1014,},[92]={4,22,5,22,6,22,7,22,8,22,9,22,10,22,11,22,12,1014,13,1014,14,1014,15,1014,16,26,17,26,18,26,19,26,20,26,21,26,22,26,23,26,24,26,25,26,26,26,27,26,28,30,29,30,30,26,31,26,116,979,117,979,118,979,119,979,190,1014,191,1014,192,1014,193,1014,},[93]={4,22,5,22,6,22,7,22,8,22,9,22,10,22,11,22,12,1014,13,1014,14,1014,15,1014,16,26,17,26,18,26,19,26,20,26,21,26,22,26,23,26,24,26,25,26,26,26,27,26,28,30,29,30,30,26,31,26,116,979,117,979,118,979,119,979,190,1014,191,1014,192,1014,193,1014,},[94]={4,22,5,22,6,22,7,22,8,22,9,22,10,22,11,22,12,1014,13,1014,14,1014,15,1014,16,26,17,26,18,26,19,26,20,26,21,26,22,26,23,26,24,26,25,26,26,26,27,26,28,26,29,26,30,39,31,39,116,981,117,981,118,981,119,981,190,1014,191,1014,192,1014,193,1014,},[95]={4,22,5,22,6,22,7,22,8,22,9,22,10,22,11,22,12,1014,13,1014,14,1014,15,1014,16,26,17,26,18,26,19,26,20,26,21,26,22,26,23,26,24,26,25,26,26,26,27,26,28,26,29,26,30,39,31,39,116,981,117,981,118,981,119,981,190,1014,191,1014,192,1014,193,1014,},[96]={4,22,5,22,6,22,7,22,8,22,9,22,10,22,11,22,12,1014,13,1014,14,1014,15,1014,16,26,17,26,18,26,19,26,20,26,21,26,22,26,23,26,24,26,25,26,26,26,27,26,28,26,29,26,30,13,31,13,32,26,33,26,34,26,35,26,116,982,117,982,118,982,119,982,190,1014,191,1014,192,1014,193,1014,},[97]={4,22,5,22,6,22,7,22,8,22,9,22,10,22,11,22,12,1014,13,1014,14,1014,15,1014,16,26,17,26,18,26,19,26,20,26,21,26,22,26,23,26,24,26,25,26,26,26,27,26,28,26,29,26,30,13,31,13,32,26,33,26,34,26,35,26,116,982,117,982,118,982,119,982,190,1014,191,1014,192,1014,193,1014,},[98]={4,22,5,22,6,22,7,22,8,22,9,22,10,22,11,22,12,1014,13,1014,14,1014,15,1014,16,26,17,26,18,26,19,26,20,26,21,26,22,26,23,26,24,26,25,26,26,26,27,26,28,26,29,26,30,24,31,24,32,26,33,26,34,26,35,26,114,983,115,983,116,983,117,983,118,983,119,983,190,1014,191,1014,192,1014,193,1014,194,1014,195,1014,},[99]={4,22,5,22,6,22,7,22,8,22,9,22,10,22,11,22,12,1014,13,1014,14,1014,15,1014,16,26,17,26,18,26,19,26,20,26,21,26,22,26,23,26,24,26,25,26,26,26,27,26,28,26,29,26,30,24,31,24,32,26,33,26,34,26,35,26,114,983,115,983,116,983,117,983,118,983,119,983,190,1014,191,1014,192,1014,193,1014,194,1014,195,1014,},[100]={4,22,5,22,6,22,7,22,8,22,9,22,10,22,11,22,12,1014,13,1014,14,1014,15,1014,16,26,17,26,18,26,19,26,20,26,21,26,22,26,23,26,24,26,25,26,26,26,27,26,28,26,29,26,30,24,31,24,112,983,113,983,114,983,115,983,116,983,117,983,192,1014,193,1014,194,1014,195,1014,196,1014,197,1014,},[101]={4,22,5,22,6,22,7,22,8,22,9,22,10,22,11,22,12,1014,13,1014,14,1014,15,1014,16,26,17,26,18,26,19,26,20,26,21,26,22,26,23,26,24,26,25,26,26,26,27,26,28,26,29,26,30,24,31,24,112,983,113,983,114,983,115,983,116,983,117,983,192,1014,193,1014,194,1014,195,1014,196,1014,197,1014,},[102]={4,26,5,26,6,26,7,26,8,26,9,26,10,26,11,26,12,1014,13,1014,14,1014,15,1014,16,26,17,26,18,26,19,26,20,26,21,26,22,26,23,26,24,26,25,26,26,26,27,26,28,31,29,31,30,37,31,37,110,983,111,983,112,983,113,983,114,983,115,983,194,1014,195,1014,196,1014,197,1014,198,1014,199,1014,},[103]={4,26,5,26,6,26,7,26,8,26,9,26,10,26,11,26,12,1014,13,1014,14,1014,15,1014,16,26,17,26,18,26,19,26,20,26,21,26,22,26,23,26,24,26,25,26,26,26,27,26,28,31,29,31,30,37,31,37,110,983,111,983,112,983,113,983,114,983,115,983,194,1014,195,1014,196,1014,197,1014,198,1014,199,1014,},[104]={4,26,5,26,6,26,7,26,8,26,9,26,10,26,11,26,12,1014,13,1014,14,1014,15,1014,16,26,17,26,18,26,19,26,20,26,21,26,22,26,23,26,24,26,25,26,26,18,27,18,28,34,29,34,30,37,31,37,108,983,109,983,110,983,111,983,112,983,113,983,196,1014,197,1014,198,1014,199,1014,200,1014,201,1014,},[105]={4,26,5,26,6,26,7,26,8,26,9,26,10,26,11,26,12,1014,13,1014,14,1014,15,1014,16,26,17,26,18,26,19,26,20,26,21,26,22,26,23,26,24,26,25,26,26,18,27,18,28,34,29,34,30,37,31,37,108,983,109,983,110,983,111,983,112,983,113,983,196,1014,197,1014,198,1014,199,1014,200,1014,201,1014,},[106]={4,26,5,26,6,26,7,26,8,26,9,26,10,26,11,26,12,1014,13,1014,14,1014,15,1014,16,6,17,6,18,24,19,24,20,26,21,26,22,26,23,26,24,26,25,26,26,12,27,12,28,19,29,19,30,19,31,19,106,983,107,983,108,983,109,983,110,983,111,983,198,1014,199,1014,200,1014,201,1014,202,1014,203,1014,},[107]={4,26,5,26,6,26,7,26,8,26,9,26,10,26,11,26,12,1014,13,1014,14,1014,15,1014,16,6,17,6,18,24,19,24,20,26,21,26,22,26,23,26,24,26,25,26,26,12,27,12,28,19,29,19,30,19,31,19,106,983,107,983,108,983,109,983,110,983,111,983,198,1014,199,1014,200,1014,201,1014,202,1014,203,1014,},[108]={4,26,5,26,6,26,7,26,8,26,9,26,10,26,11,26,12,1014,13,1014,14,1014,15,1014,16,6,17,6,18,6,19,6,20,6,21,6,22,6,23,6,24,6,25,6,26,6,27,6,28,19,29,19,30,19,31,19,68,540,69,540,70,540,71,540,72,540,73,540,74,540,75,540,76,540,77,540,78,540,79,540,80,540,81,540,82,540,83,540,104,983,105,983,106,983,107,983,108,983,109,983,200,1014,201,1014,202,1014,203,1014,204,1014,205,1014,},[109]={4,26,5,26,6,26,7,26,8,26,9,26,10,26,11,26,12,1014,13,1014,14,1014,15,1014,16,6,17,6,18,6,19,6,20,6,21,6,22,6,23,6,24,6,25,6,26,6,27,6,28,19,29,19,30,19,31,19,68,540,69,540,70,540,71,540,72,540,73,540,74,540,75,540,76,540,77,540,78,540,79,540,80,540,81,540,82,540,83,540,104,983,105,983,106,983,107,983,108,983,109,983,200,1014,201,1014,202,1014,203,1014,204,1014,205,1014,},[110]={4,26,5,26,6,26,7,26,8,26,9,26,10,26,11,26,12,1014,13,1014,14,1014,15,1014,16,6,17,6,18,6,19,6,20,6,21,6,22,6,23,6,24,6,25,6,26,6,27,6,28,19,29,19,30,19,31,19,68,540,69,540,70,540,71,540,72,540,73,540,74,540,75,540,76,540,77,540,78,540,79,540,80,540,81,540,82,540,83,540,102,983,103,983,104,983,105,983,106,983,107,983,202,1014,203,1014,204,1014,205,1014,206,1014,207,1014,},[111]={4,26,5,26,6,26,7,26,8,26,9,26,10,26,11,26,12,1014,13,1014,14,1014,15,1014,16,6,17,6,18,6,19,6,20,6,21,6,22,6,23,6,24,6,25,6,26,6,27,6,28,19,29,19,30,19,31,19,68,540,69,540,70,540,71,540,72,540,73,540,74,540,75,540,76,540,77,540,78,540,79,540,80,540,81,540,82,540,83,540,102,983,103,983,104,983,105,983,106,983,107,983,202,1014,203,1014,204,1014,205,1014,206,1014,207,1014,},[112]={0,1014,1,1014,2,1014,3,1014,4,1014,5,1014,6,1014,7,1014,8,1014,9,1014,10,1014,11,1014,12,1014,13,1014,14,1014,15,1014,16,1015,17,1015,18,1018,19,1018,20,1019,21,1019,22,1019,23,1019,24,1019,25,1019,26,1019,27,1019,28,1019,29,1019,30,1019,31,1019,32,1019,33,1019,34,1019,35,1019,36,1019,37,1019,38,1019,39,1019,40,1019,41,1019,42,1019,43,1019,44,1019,45,1019,46,1019,47,1019,48,1019,49,1019,50,1019,51,1019,52,1019,53,1019,54,1019,55,1019,56,1019,57,1019,58,1019,59,1019,60,1019,61,1019,62,1019,63,1019,64,1019,65,1019,66,1019,67,1019,68,1019,69,1019,70,1019,71,1019,72,1019,73,1019,74,1019,75,1019,76,1019,77,1019,78,1019,79,1019,80,1019,81,1019,82,998,83,998,84,988,85,988,86,984,87,984,88,982,89,982,90,983,91,983,92,983,93,983,94,983,95,983,96,983,97,983,98,983,99,983,100,983,101,983,102,983,103,983,104,983,105,983,204,1014,205,1014,206,1014,207,1014,208,1014,209,1014,210,1014,211,1014,212,1014,213,1014,214,1014,215,1014,216,1014,217,1014,218,1014,219,1014,220,1014,221,1014,222,1014,223,1014,224,1014,225,1014,226,1014,227,1014,228,1014,229,1014,230,1014,231,1014,232,1014,233,1014,234,1014,235,1014,236,1014,237,1014,238,1014,239,1014,240,1014,241,1014,242,1014,243,1014,244,1014,245,1014,246,1014,247,1014,248,1014,249,1014,250,1014,251,1014,252,1014,253,1014,254,1014,255,1014,},[113]={0,1014,1,1014,2,1014,3,1014,4,1014,5,1014,6,1014,7,1014,8,1014,9,1014,10,1014,11,1014,12,1014,13,1014,14,1014,15,1014,16,1015,17,1015,18,1018,19,1018,20,1019,21,1019,22,1019,23,1019,24,1019,25,1019,26,1019,27,1019,28,1019,29,1019,30,1019,31,1019,32,1019,33,1019,34,1019,35,1019,36,1019,37,1019,38,1019,39,1019,40,1019,41,1019,42,1019,43,1019,44,1019,45,1019,46,1019,47,1019,48,1019,49,1019,50,1019,51,1019,52,1019,53,1019,54,1019,55,1019,56,1019,57,1019,58,1019,59,1019,60,1019,61,1019,62,1019,63,1019,64,1019,65,1019,66,1019,67,1019,68,1019,69,1019,70,1019,71,1019,72,1019,73,1019,74,1019,75,1019,76,1019,77,1019,78,1019,79,1019,80,1019,81,1019,82,998,83,998,84,988,85,988,86,984,87,984,88,982,89,982,90,983,91,983,92,983,93,983,94,983,95,983,96,983,97,983,98,983,99,983,100,983,101,983,102,983,103,983,104,983,105,983,204,1014,205,1014,206,1014,207,1014,208,1014,209,1014,210,1014,211,1014,212,1014,213,1014,214,1014,215,1014,216,1014,217,1014,218,1014,219,1014,220,1014,221,1014,222,1014,223,1014,224,1014,225,1014,226,1014,227,1014,228,1014,229,1014,230,1014,231,1014,232,1014,233,1014,234,1014,235,1014,236,1014,237,1014,238,1014,239,1014,240,1014,241,1014,242,1014,243,1014,244,1014,245,1014,246,1014,247,1014,248,1014,249,1014,250,1014,251,1014,252,1014,253,1014,254,1014,255,1014,},[114]={0,1014,1,1014,2,1014,3,1014,4,1014,5,1014,6,1014,7,1014,8,1014,9,1014,10,1014,11,1014,12,1014,13,1014,14,1014,15,1014,16,1015,17,1015,18,1018,19,1018,20,1019,21,1019,22,1019,23,1019,24,1019,25,1019,26,1019,27,1019,28,1019,29,1019,30,1019,31,1019,32,1019,33,1019,34,1019,35,1019,36,1019,37,1019,38,1019,39,1019,40,1019,41,1019,42,1019,43,1019,44,1019,45,1019,46,1019,47,1019,48,1019,49,1019,50,1019,51,1019,52,1019,53,1019,54,1019,55,1019,56,1019,57,1019,58,1019,59,1019,60,1019,61,1019,62,1019,63,1019,64,1019,65,1019,66,1019,67,1019,68,1019,69,1019,70,1019,71,1019,72,1019,73,1019,74,1019,75,1019,76,1019,77,1019,78,1019,79,1019,80,1019,81,1019,82,998,83,998,84,988,85,988,86,984,87,984,88,982,89,982,90,983,91,983,92,983,93,983,94,983,95,983,96,983,97,983,98,983,99,983,100,983,101,983,102,983,103,983,206,1014,207,1014,208,1014,209,1014,210,1014,211,1014,212,1014,213,1014,214,1014,215,1014,216,1014,217,1014,218,1014,219,1014,220,1014,221,1014,222,1014,223,1014,224,1014,225,1014,226,1014,227,1014,228,1014,229,1014,230,1014,231,1014,232,1014,233,1014,234,1014,235,1014,236,1014,237,1014,238,1014,239,1014,240,1014,241,1014,242,1014,243,1014,244,1014,245,1014,246,1014,247,1014,248,1014,249,1014,250,1014,251,1014,252,1014,253,1014,254,1014,255,1014,},[115]={0,1014,1,1014,2,1014,3,1014,4,1014,5,1014,6,1014,7,1014,8,1014,9,1014,10,1014,11,1014,12,1014,13,1014,14,1014,15,1014,16,1015,17,1015,18,1018,19,1018,20,1019,21,1019,22,1019,23,1019,24,1019,25,1019,26,1019,27,1019,28,1019,29,1019,30,1019,31,1019,32,1019,33,1019,34,1019,35,1019,36,1019,37,1019,38,1019,39,1019,40,1019,41,1019,42,1019,43,1019,44,1019,45,1019,46,1019,47,1019,48,1019,49,1019,50,1019,51,1019,52,1019,53,1019,54,1019,55,1019,56,1019,57,1019,58,1019,59,1019,60,1019,61,1019,62,1019,63,1019,64,1019,65,1019,66,1019,67,1019,68,1019,69,1019,70,1019,71,1019,72,1019,73,1019,74,1019,75,1019,76,1019,77,1019,78,1019,79,1019,80,1019,81,1019,82,998,83,998,84,988,85,988,86,984,87,984,88,982,89,982,90,983,91,983,92,983,93,983,94,983,95,983,96,983,97,983,98,983,99,983,100,983,101,983,102,983,103,983,206,1014,207,1014,208,1014,209,1014,210,1014,211,1014,212,1014,213,1014,214,1014,215,1014,216,1014,217,1014,218,1014,219,1014,220,1014,221,1014,222,1014,223,1014,224,1014,225,1014,226,1014,227,1014,228,1014,229,1014,230,1014,231,1014,232,1014,233,1014,234,1014,235,1014,236,1014,237,1014,238,1014,239,1014,240,1014,241,1014,242,1014,243,1014,244,1014,245,1014,246,1014,247,1014,248,1014,249,1014,250,1014,251,1014,252,1014,253,1014,254,1014,255,1014,}
		},
		
		markers ={
			96, 74, 92, 74, 100, 74, 64, 74, 68, 74, 60, 74, 64, 40, 60, 40, 68, 40, 64, 250, 60, 250, 68, 250, 80, 208, 80, 212, 80, 204, 106, 32, 104, 32, 102, 32, 100, 32, 92, 32, 90, 32, 88, 32, 86, 32, 86, 248, 106, 248, 108, 42, 84, 42, 64, 226, 96, 26, 98, 4, 136, 48, 128, 48, 96, 36, 96, 6, 96, 22, 64, 210, 96, 100, 64, 100, 64, 56, 64, 18, 52, 72, 0, 0
		},
		
		objects = {
			[48]={0,5,9,-1,1536,2,5,9,-1,1536,4,5,9,-1,1536,6,5,9,-1,1536,8,5,9,-1,1536,10,5,9,-1,1536,12,5,9,-1,1536,14,5,9,-1,1536,16,5,9,-1,1536,18,5,9,-1,1536,20,5,9,-1,1536,22,5,9,-1,1536,24,5,9,-1,1536,26,5,9,-1,1536,28,5,9,-1,1536,30,5,9,-1,1536,32,5,9,-1,1536,34,5,9,-1,1536,36,5,9,-1,1536,38,5,9,-1,1536,40,5,9,-1,1536,42,5,9,-1,1536,44,5,9,-1,1536,46,5,9,-1,1536,48,5,9,-1,1536,50,5,9,-1,1536,52,5,9,-1,1536,54,5,9,-1,1536,56,5,9,-1,1536,58,5,9,-1,1536,60,5,9,-1,1536,62,5,9,-1,1536,64,5,9,-1,1536,66,5,9,-1,1536,68,5,9,-1,1536,70,5,9,-1,1536,72,5,9,-1,1536,74,5,9,-1,1536,76,5,9,-1,1536,78,5,9,-1,1536,80,5,9,-1,1536,82,5,9,-1,1536,84,5,9,-1,1536,86,5,9,-1,1536,88,5,9,-1,1536,90,5,9,-1,1536,92,5,9,-1,1536,94,5,9,-1,1536,96,5,9,-1,1536,98,5,9,-1,1536,100,5,9,-1,1536,102,5,9,-1,1536,204,5,9,-1,1536,206,5,9,-1,1536,208,5,9,-1,1536,210,5,9,-1,1536,212,5,9,-1,1536,214,5,9,-1,1536,216,5,9,-1,1536,218,5,9,-1,1536,220,5,9,-1,1536,222,5,9,-1,1536,224,5,9,-1,1536,226,5,9,-1,1536,228,5,9,-1,1536,230,5,9,-1,1536,232,5,9,-1,1536,234,5,9,-1,1536,236,5,9,-1,1536,238,5,9,-1,1536,240,5,9,-1,1536,242,5,9,-1,1536,244,5,9,-1,1536,246,5,9,-1,1536,248,5,9,-1,1536,250,5,9,-1,1536,252,5,9,-1,1536,254,5,9,-1,1536,},[50]={104,5,9,-1,1792,202,5,9,-1,1280,},[52]={40,5,18,-1,1024,106,5,9,-1,1792,200,5,9,-1,1280,250,5,9,-1,1536,},[54]={38,7,18,-1,0,42,7,18,-1,0,108,5,9,-1,1792,198,5,9,-1,1280,},[56]={110,5,9,-1,1792,196,5,9,-1,1280,},[58]={112,5,9,-1,1792,194,5,9,-1,1280,},[60]={10,5,8,-1,0,24,5,8,-1,0,114,5,9,-1,1792,192,5,9,-1,1280,},[62]={116,5,9,-1,0,190,5,9,-1,1024,},[64]={116,5,9,-1,0,190,5,9,-1,1024,},[66]={116,5,9,-1,0,190,5,9,-1,1024,},[68]={10,5,8,-1,0,24,5,8,-1,0,116,5,9,-1,0,190,5,9,-1,1024,},[70]={116,5,9,-1,0,190,5,9,-1,1024,},[72]={116,5,9,-1,0,190,5,9,-1,1024,},[74]={38,7,18,-1,0,42,7,18,-1,0,116,5,9,-1,0,190,5,9,-1,1024,},[76]={40,5,18,-1,0,98,5,8,-1,0,102,5,3,-1,1280,116,5,9,-1,0,190,5,9,-1,1024,250,5,9,-1,512,},[78]={96,5,3,-1,768,98,7,18,-1,0,102,7,18,-1,0,104,5,8,-1,0,116,5,9,-1,0,190,5,9,-1,1024,},[80]={0,5,9,-1,1536,2,5,9,-1,1536,4,5,9,-1,1536,6,5,9,-1,1536,8,5,9,-1,1536,10,5,9,-1,1536,12,5,9,-1,1536,14,5,9,-1,1536,16,5,9,-1,1536,18,5,9,-1,1536,20,5,9,-1,1536,22,5,9,-1,1536,24,5,9,-1,1536,26,5,9,-1,1536,28,5,9,-1,1536,30,5,9,-1,1536,32,5,9,-1,1536,34,5,9,-1,1536,36,5,9,-1,1536,38,5,9,-1,1536,40,5,9,-1,1536,42,5,9,-1,1536,44,5,9,-1,1536,46,5,9,-1,1536,50,5,9,-1,1536,52,5,9,-1,1536,54,5,9,-1,1536,56,5,9,-1,1536,58,5,9,-1,1536,60,5,9,-1,1536,62,5,9,-1,1536,64,5,9,-1,1536,66,5,9,-1,1536,68,5,9,-1,1536,70,5,9,-1,1536,72,5,9,-1,1536,74,5,9,-1,1536,76,5,9,-1,1536,78,5,9,-1,1536,80,5,9,-1,1536,116,5,9,-1,0,190,5,9,-1,1024,194,5,9,-1,512,196,5,9,-1,512,198,5,9,-1,512,218,5,9,-1,1536,220,5,9,-1,1536,222,5,9,-1,1536,224,5,9,-1,1536,226,5,9,-1,1536,228,5,9,-1,1536,230,5,9,-1,1536,232,5,9,-1,1536,234,5,9,-1,1536,236,5,9,-1,1536,240,5,9,-1,1536,242,5,9,-1,1536,244,5,9,-1,1536,246,5,9,-1,1536,248,5,9,-1,1536,250,5,9,-1,1536,252,5,9,-1,1536,254,5,9,-1,1536,},[82]={12,5,9,-1,0,96,5,8,-1,0,98,7,18,-1,0,102,7,18,-1,0,104,5,3,-1,1792,116,5,9,-1,0,190,5,9,-1,1024,},[84]={8,5,2,-1,1792,12,5,9,-1,0,16,5,2,-1,1024,28,5,18,-1,1024,44,7,85,-1,0,98,5,3,-1,256,102,5,8,-1,0,116,5,9,-1,0,190,5,9,-1,1024,248,7,85,-1,0,},[86]={12,5,9,-1,0,116,5,9,-1,0,190,5,9,-1,1024,},[88]={12,5,9,-1,0,44,7,85,-1,0,116,5,9,-1,0,190,5,9,-1,1024,248,7,85,-1,0,},[90]={4,5,18,-1,0,8,5,18,-1,0,12,5,9,-1,0,116,5,9,-1,0,190,5,9,-1,1024,},[92]={12,5,9,-1,0,44,7,85,-1,0,116,5,9,-1,0,190,5,9,-1,1024,248,7,85,-1,0,},[94]={12,5,9,-1,0,116,5,9,-1,0,190,5,9,-1,1024,},[96]={12,5,9,-1,0,44,7,85,-1,0,116,5,9,-1,0,190,5,9,-1,1024,248,7,85,-1,0,},[98]={12,5,9,-1,0,114,5,9,-1,256,192,5,9,-1,768,},[100]={4,5,18,-1,0,8,5,18,-1,0,12,5,9,-1,0,44,7,85,-1,0,112,5,9,-1,256,194,5,9,-1,768,248,7,85,-1,0,},[102]={12,5,9,-1,0,110,5,9,-1,256,196,5,9,-1,768,},[104]={12,5,9,-1,0,44,7,85,-1,0,108,5,9,-1,256,198,5,9,-1,768,248,7,85,-1,0,},[106]={12,5,9,-1,0,106,5,9,-1,256,200,5,9,-1,768,},[108]={8,5,2,-1,0,12,5,9,-1,0,16,5,2,-1,0,28,5,18,-1,0,44,7,85,-1,0,104,5,9,-1,256,202,5,9,-1,768,248,7,85,-1,0,},[110]={12,5,9,-1,0,102,5,9,-1,256,204,5,9,-1,768,},[112]={0,5,9,-1,512,2,5,9,-1,512,4,5,9,-1,512,6,5,9,-1,512,8,5,9,-1,512,10,5,9,-1,512,12,5,9,-1,512,14,5,9,-1,512,16,5,9,-1,512,18,5,9,-1,512,20,5,9,-1,512,22,5,9,-1,512,24,5,9,-1,512,26,5,9,-1,512,28,5,9,-1,512,30,5,9,-1,512,32,5,9,-1,512,34,5,9,-1,512,36,5,9,-1,512,38,5,9,-1,512,40,5,9,-1,512,42,5,9,-1,512,44,5,9,-1,512,46,5,9,-1,512,48,5,9,-1,512,50,5,9,-1,512,52,5,9,-1,512,54,5,9,-1,512,56,5,9,-1,512,58,5,9,-1,512,60,5,9,-1,512,62,5,9,-1,512,64,5,9,-1,512,66,5,9,-1,512,68,5,9,-1,512,70,5,9,-1,512,72,5,9,-1,512,74,5,9,-1,512,76,5,9,-1,512,78,5,9,-1,512,80,5,9,-1,512,82,5,9,-1,512,84,5,9,-1,512,86,5,9,-1,512,88,5,9,-1,512,90,5,9,-1,512,92,5,9,-1,512,94,5,9,-1,512,96,5,9,-1,512,98,5,9,-1,512,100,5,9,-1,512,206,5,9,-1,512,208,5,9,-1,512,210,5,9,-1,512,212,5,9,-1,512,214,5,9,-1,512,216,5,9,-1,512,218,5,9,-1,512,220,5,9,-1,512,222,5,9,-1,512,224,5,9,-1,512,226,5,9,-1,512,228,5,9,-1,512,230,5,9,-1,512,232,5,9,-1,512,234,5,9,-1,512,236,5,9,-1,512,238,5,9,-1,512,240,5,9,-1,512,242,5,9,-1,512,244,5,9,-1,512,246,5,9,-1,512,248,5,9,-1,512,250,5,9,-1,512,252,5,9,-1,512,254,5,9,-1,512,}
		},
		
		decorations = {
			82,44,1,6, 110,44,1,2, 82,248,1,6, 110,248,1,2, 108,70,2,2, 108,74,2,2, 108,78,2,2, 52,78,2,6, 52,74,2,6, 52,70,2,6, 80,100,3,0
		},
		
		shaman_positions = {
			96, 22,96, 22,96, 22,96, 22,96, 22,96, 22,96, 22,96, 22
		},
		
		scripts = {
			OnTurn = function(everySecond1, everySecond2, everySecond4) 			boat_race_2_on_turn(everySecond1, everySecond2, everySecond4) end,
			OnCreateThing = function(t, owner, type, model) 						boat_race_on_create_thing(t, owner, type, model) end,
			OnHumanDisconnect = function(player) 									boat_race_init_single_AI(player) end,
		},
		
	},
	
	[MAP_BOAT_RACE_III]={
	
		info = 	{ 	name = "Boat Race 3", author = "Toxicity & Zyraw",
					desc = "On a track where being blasted is unavoidable, you must propel or be propelled. <p> The most beautiful and unpredictable course is sure to cause distress as players' olympic dreams are thwarted by the boat gods themselves. <p> - Gain a random spell when passing through particle effects. <p> - A new Blast spell on the Convert slot will direct blast every player on the map. <p> - Starting and Finish areas are no Spell zones, indicated by a line of clouds. <p> - When stuck, use the Teleport Spell to restart from the beginning.",
					map_objectives = { {value=10, limit=30, step=5, default=false}, {value=3, step=1, limit=10, default=true}, {} },
					image = 2672, texture={5, 0}, zoom={96,50,1024}, drop_infos = true,	marker_lb={160, 46}, reinc_timer=12*1, shield_respawn=false, optional_shaman_zoom_angle = 1024,
					custom_rules = {
						{ default = false, 	name = "No S clicks", desc = "S clicks (on shamans or boats) won't follow shamans/boats. You can still blast your own boat." },
					}
				},

		land ={
			[0]={82,975,83,975,84,975,85,975,112,552,113,552,114,1020,115,1020,116,1020,117,1020,118,1020,119,1020,120,1020,121,1020,122,1020,123,1020,124,1020,125,1020,126,1020,127,1020,166,585,167,585,168,585,169,585,206,678,207,678,208,678,209,678,210,678,211,678,212,1003,213,1003,214,1003,215,1003,216,1003,217,1003,218,1003,219,1003,220,1003,221,1003,222,1003,223,1003,224,678,225,678,226,678,227,678,228,678,229,678,250,1014,251,1014,252,1014,253,1014,},[1]={82,975,83,975,84,975,85,975,112,552,113,552,114,1020,115,1020,116,1020,117,1020,118,1020,119,1020,120,1020,121,1020,122,1020,123,1020,124,1020,125,1020,126,1020,127,1020,166,585,167,585,168,585,169,585,206,678,207,678,208,678,209,678,210,678,211,678,212,1003,213,1003,214,1003,215,1003,216,1003,217,1003,218,1003,219,1003,220,1003,221,1003,222,1003,223,1003,224,678,225,678,226,678,227,678,228,678,229,678,250,1014,251,1014,252,1014,253,1014,},[2]={82,975,83,975,84,975,85,975,114,1020,115,1020,116,1020,117,1020,118,1020,119,1020,120,1020,121,1020,122,1020,123,1020,124,1020,125,1020,166,585,167,585,168,585,169,585,208,678,209,678,210,678,211,678,212,678,213,678,214,678,215,678,216,678,217,678,218,678,219,678,220,678,221,678,222,678,223,678,224,678,225,678,226,678,227,678,250,1014,251,1014,252,1014,253,1014,},[3]={82,975,83,975,84,975,85,975,114,1020,115,1020,116,1020,117,1020,118,1020,119,1020,120,1020,121,1020,122,1020,123,1020,124,1020,125,1020,166,585,167,585,168,585,169,585,208,678,209,678,210,678,211,678,212,678,213,678,214,678,215,678,216,678,217,678,218,678,219,678,220,678,221,678,222,678,223,678,224,678,225,678,226,678,227,678,250,1014,251,1014,252,1014,253,1014,},[4]={82,975,83,975,84,975,85,975,116,630,117,630,118,630,119,630,120,630,121,630,122,630,123,630,210,678,211,678,212,678,213,678,214,678,215,678,216,678,217,678,218,678,219,678,220,678,221,678,222,678,223,678,224,678,225,678,250,1014,251,1014,252,1014,253,1014,},[5]={82,975,83,975,84,975,85,975,116,630,117,630,118,630,119,630,120,630,121,630,122,630,123,630,210,678,211,678,212,678,213,678,214,678,215,678,216,678,217,678,218,678,219,678,220,678,221,678,222,678,223,678,224,678,225,678,250,1014,251,1014,252,1014,253,1014,},[6]={82,975,83,975,84,975,85,975,250,1014,251,1014,252,1014,253,1014,},[7]={82,975,83,975,84,975,85,975,250,1014,251,1014,252,1014,253,1014,},[8]={82,975,83,975,84,975,85,975,250,1014,251,1014,252,1014,253,1014,},[9]={82,975,83,975,84,975,85,975,250,1014,251,1014,252,1014,253,1014,},[10]={82,975,83,975,84,975,85,975,250,1014,251,1014,252,1014,253,1014,},[11]={82,975,83,975,84,975,85,975,250,1014,251,1014,252,1014,253,1014,},[12]={82,975,83,975,84,975,85,975,250,1014,251,1014,252,1014,253,1014,},[13]={82,975,83,975,84,975,85,975,250,1014,251,1014,252,1014,253,1014,},[14]={82,975,83,975,84,975,85,975,166,585,167,585,168,585,169,585,250,1014,251,1014,252,1014,253,1014,},[15]={82,975,83,975,84,975,85,975,166,585,167,585,168,585,169,585,250,1014,251,1014,252,1014,253,1014,},[16]={82,975,83,975,84,975,85,975,166,585,167,585,168,585,169,585,250,1014,251,1014,252,1014,253,1014,},[17]={82,975,83,975,84,975,85,975,166,585,167,585,168,585,169,585,250,1014,251,1014,252,1014,253,1014,},[18]={82,975,83,975,84,975,85,975,86,975,87,975,248,1014,249,1014,250,1014,251,1014,252,1014,253,1014,},[19]={82,975,83,975,84,975,85,975,86,975,87,975,248,1014,249,1014,250,1014,251,1014,252,1014,253,1014,},[20]={84,975,85,975,86,975,87,975,88,975,89,975,246,1014,247,1014,248,1014,249,1014,250,1014,251,1014,},[21]={84,975,85,975,86,975,87,975,88,975,89,975,246,1014,247,1014,248,1014,249,1014,250,1014,251,1014,},[22]={86,975,87,975,88,975,89,975,90,975,91,975,244,1014,245,1014,246,1014,247,1014,248,1014,249,1014,},[23]={86,975,87,975,88,975,89,975,90,975,91,975,244,1014,245,1014,246,1014,247,1014,248,1014,249,1014,},[24]={88,975,89,975,90,975,91,975,92,975,93,975,242,1014,243,1014,244,1014,245,1014,246,1014,247,1014,},[25]={88,975,89,975,90,975,91,975,92,975,93,975,242,1014,243,1014,244,1014,245,1014,246,1014,247,1014,},[26]={90,975,91,975,92,975,93,975,94,975,95,975,114,598,115,598,116,585,117,585,118,585,119,585,120,585,121,585,122,585,123,585,124,598,125,598,208,676,209,676,210,676,211,676,212,676,213,676,214,663,215,663,216,663,217,663,218,663,219,663,220,663,221,663,222,663,223,663,224,663,225,663,240,1014,241,1014,242,1014,243,1014,244,1014,245,1014,},[27]={90,975,91,975,92,975,93,975,94,975,95,975,114,598,115,598,116,585,117,585,118,585,119,585,120,585,121,585,122,585,123,585,124,598,125,598,208,676,209,676,210,676,211,676,212,676,213,676,214,663,215,663,216,663,217,663,218,663,219,663,220,663,221,663,222,663,223,663,224,663,225,663,240,1014,241,1014,242,1014,243,1014,244,1014,245,1014,},[28]={92,975,93,975,94,975,95,975,96,975,97,975,98,975,99,975,100,975,101,975,102,975,103,975,104,975,105,975,106,975,107,975,108,975,109,975,110,975,111,975,112,975,113,975,114,975,115,975,116,976,117,976,118,977,119,977,120,979,121,979,122,984,123,984,124,994,125,994,126,1014,127,1014,128,1014,129,1014,130,1014,131,1014,132,1014,133,1014,134,1014,135,1014,136,1014,137,1014,138,1014,139,1014,140,1014,141,1014,142,1014,143,1014,144,1014,145,1014,146,1014,147,1014,148,1014,149,1014,150,1014,151,1014,152,1014,153,1014,154,1014,155,1014,156,1014,157,1014,158,1014,159,1014,160,1014,161,1014,162,585,163,585,164,585,165,585,166,585,167,585,168,585,169,585,170,585,171,585,172,585,173,585,174,1014,175,1014,176,1014,177,1014,178,1014,179,1014,180,1014,181,1014,182,1014,183,1014,184,1014,185,1014,186,1014,187,1014,188,1014,189,1014,190,1014,191,1014,192,1014,193,1014,194,1014,195,1014,196,1014,197,1014,198,1014,199,1014,200,1014,201,1014,202,1014,203,1014,204,1014,205,1014,206,1014,207,1014,208,1014,209,1014,210,1014,211,1014,212,1014,213,1014,214,1014,215,1014,216,1014,217,1014,218,1014,219,1014,220,1014,221,1014,222,1014,223,1014,224,1014,225,1014,226,1014,227,1014,228,1014,229,1014,230,1014,231,1014,232,1014,233,1014,234,1014,235,1014,236,1014,237,1014,238,1014,239,1014,240,1014,241,1014,242,1014,243,1014,},[29]={92,975,93,975,94,975,95,975,96,975,97,975,98,975,99,975,100,975,101,975,102,975,103,975,104,975,105,975,106,975,107,975,108,975,109,975,110,975,111,975,112,975,113,975,114,975,115,975,116,976,117,976,118,977,119,977,120,979,121,979,122,984,123,984,124,994,125,994,126,1014,127,1014,128,1014,129,1014,130,1014,131,1014,132,1014,133,1014,134,1014,135,1014,136,1014,137,1014,138,1014,139,1014,140,1014,141,1014,142,1014,143,1014,144,1014,145,1014,146,1014,147,1014,148,1014,149,1014,150,1014,151,1014,152,1014,153,1014,154,1014,155,1014,156,1014,157,1014,158,1014,159,1014,160,1014,161,1014,162,585,163,585,164,585,165,585,166,585,167,585,168,585,169,585,170,585,171,585,172,585,173,585,174,1014,175,1014,176,1014,177,1014,178,1014,179,1014,180,1014,181,1014,182,1014,183,1014,184,1014,185,1014,186,1014,187,1014,188,1014,189,1014,190,1014,191,1014,192,1014,193,1014,194,1014,195,1014,196,1014,197,1014,198,1014,199,1014,200,1014,201,1014,202,1014,203,1014,204,1014,205,1014,206,1014,207,1014,208,1014,209,1014,210,1014,211,1014,212,1014,213,1014,214,1014,215,1014,216,1014,217,1014,218,1014,219,1014,220,1014,221,1014,222,1014,223,1014,224,1014,225,1014,226,1014,227,1014,228,1014,229,1014,230,1014,231,1014,232,1014,233,1014,234,1014,235,1014,236,1014,237,1014,238,1014,239,1014,240,1014,241,1014,242,1014,243,1014,},[30]={94,975,95,975,96,975,97,975,98,975,99,975,100,975,101,975,102,975,103,975,104,975,105,975,106,975,107,975,108,975,109,975,110,975,111,975,112,975,113,975,114,975,115,975,116,976,117,976,118,977,119,977,120,979,121,979,122,984,123,984,124,994,125,994,126,1014,127,1014,128,1014,129,1014,130,1014,131,1014,132,1014,133,1014,134,1014,135,1014,136,1014,137,1014,138,1014,139,1014,140,1014,141,1014,142,1014,143,1014,144,1014,145,1014,146,1014,147,1014,148,1014,149,1014,150,1014,151,1014,152,1014,153,1014,154,1014,155,1014,156,1014,157,1014,158,1014,159,1014,160,1014,161,1014,162,585,163,585,164,585,165,585,166,585,167,585,168,585,169,585,170,585,171,585,172,585,173,585,174,1014,175,1014,176,1014,177,1014,178,1014,179,1014,180,1014,181,1014,182,1014,183,1014,184,1014,185,1014,186,1014,187,1014,188,1014,189,1014,190,1014,191,1014,192,1014,193,1014,194,1014,195,1014,196,1014,197,1014,198,1014,199,1014,200,1014,201,1014,202,1014,203,1014,204,1014,205,1014,206,1014,207,1014,208,1014,209,1014,210,1014,211,1014,212,1014,213,1014,214,1014,215,1014,216,1014,217,1014,218,1014,219,1014,220,1014,221,1014,222,1014,223,1014,224,1014,225,1014,226,1014,227,1014,228,1014,229,1014,230,1014,231,1014,232,1014,233,1014,234,1014,235,1014,236,1014,237,1014,238,1014,239,1014,240,1014,241,1014,},[31]={94,975,95,975,96,975,97,975,98,975,99,975,100,975,101,975,102,975,103,975,104,975,105,975,106,975,107,975,108,975,109,975,110,975,111,975,112,975,113,975,114,975,115,975,116,976,117,976,118,977,119,977,120,979,121,979,122,984,123,984,124,994,125,994,126,1014,127,1014,128,1014,129,1014,130,1014,131,1014,132,1014,133,1014,134,1014,135,1014,136,1014,137,1014,138,1014,139,1014,140,1014,141,1014,142,1014,143,1014,144,1014,145,1014,146,1014,147,1014,148,1014,149,1014,150,1014,151,1014,152,1014,153,1014,154,1014,155,1014,156,1014,157,1014,158,1014,159,1014,160,1014,161,1014,162,585,163,585,164,585,165,585,166,585,167,585,168,585,169,585,170,585,171,585,172,585,173,585,174,1014,175,1014,176,1014,177,1014,178,1014,179,1014,180,1014,181,1014,182,1014,183,1014,184,1014,185,1014,186,1014,187,1014,188,1014,189,1014,190,1014,191,1014,192,1014,193,1014,194,1014,195,1014,196,1014,197,1014,198,1014,199,1014,200,1014,201,1014,202,1014,203,1014,204,1014,205,1014,206,1014,207,1014,208,1014,209,1014,210,1014,211,1014,212,1014,213,1014,214,1014,215,1014,216,1014,217,1014,218,1014,219,1014,220,1014,221,1014,222,1014,223,1014,224,1014,225,1014,226,1014,227,1014,228,1014,229,1014,230,1014,231,1014,232,1014,233,1014,234,1014,235,1014,236,1014,237,1014,238,1014,239,1014,240,1014,241,1014,},[32]={158,1014,159,1014,160,1014,161,1014,162,585,163,585,164,585,165,585,166,585,167,585,168,585,169,585,170,585,171,585,172,585,173,585,174,1014,175,1014,176,1014,177,1014,},[33]={158,1014,159,1014,160,1014,161,1014,162,585,163,585,164,585,165,585,166,585,167,585,168,585,169,585,170,585,171,585,172,585,173,585,174,1014,175,1014,176,1014,177,1014,},[34]={158,1014,159,1014,160,1014,161,1014,162,1014,163,1014,164,1014,165,1014,166,1014,167,1014,168,1014,169,1014,170,1014,171,1014,172,1014,173,1014,174,1014,175,1014,176,1014,177,1014,},[35]={158,1014,159,1014,160,1014,161,1014,162,1014,163,1014,164,1014,165,1014,166,1014,167,1014,168,1014,169,1014,170,1014,171,1014,172,1014,173,1014,174,1014,175,1014,176,1014,177,1014,},[36]={158,1014,159,1014,160,1014,161,1014,162,1014,163,1014,164,1014,165,1014,166,1014,167,1014,168,1014,169,1014,170,1014,171,1014,172,1014,173,1014,174,1014,175,1014,176,1014,177,1014,},[37]={158,1014,159,1014,160,1014,161,1014,162,1014,163,1014,164,1014,165,1014,166,1014,167,1014,168,1014,169,1014,170,1014,171,1014,172,1014,173,1014,174,1014,175,1014,176,1014,177,1014,},[80]={0,1014,1,1014,2,1014,3,1014,4,1014,5,1014,6,1014,7,1014,8,1014,9,1014,10,1014,11,1014,12,1014,13,1014,14,1014,15,1014,16,1014,17,1014,18,1014,19,1014,20,1014,21,1014,22,1014,23,1014,24,1014,25,1014,26,1014,27,1014,28,1014,29,1014,30,1014,31,1014,32,1014,33,1014,34,1014,35,1014,36,1014,37,1014,38,1017,39,1017,40,1018,41,1018,42,1018,43,1018,44,1020,45,1020,46,1020,47,1020,48,1020,49,1020,50,1020,51,1020,52,1020,53,1020,54,1020,55,1020,56,1020,57,1020,58,1020,59,1020,60,1020,61,1020,62,1020,63,1020,64,1020,65,1020,66,1020,67,1020,68,1020,69,1020,70,1020,71,1020,72,1020,73,1020,74,1020,75,1020,76,1020,77,1020,78,1020,79,1020,80,1020,81,1020,82,1020,83,1020,84,1020,85,1020,86,1020,87,1020,88,1020,89,1020,90,1020,91,1020,92,1020,93,1020,94,1020,95,1020,96,1020,97,1020,98,1020,99,1020,100,1020,101,1020,102,1020,103,1020,104,1020,105,1020,106,1020,107,1020,108,1020,109,1020,110,1020,111,1020,112,1020,113,1020,114,1020,115,1020,116,1020,117,1020,118,1020,119,1020,120,1020,121,1020,122,1020,123,1020,124,1020,125,1020,126,1020,127,1020,128,1020,129,1020,130,1020,131,1020,132,1020,133,1020,134,1020,135,1020,136,1020,137,1020,138,1020,139,1020,140,1020,141,1020,142,1020,143,1020,144,1020,145,1020,146,1020,147,1020,148,1020,149,1020,150,1020,151,1020,152,1020,153,1020,154,1020,155,1020,156,1020,157,1020,158,1020,159,1020,160,1020,161,1020,162,1020,163,1020,164,1020,165,1020,166,1020,167,1020,168,1020,169,1020,170,1020,171,1020,172,1020,173,1020,174,1020,175,1020,176,1020,177,1020,178,1020,179,1020,180,1020,181,1020,182,1020,183,1020,184,1020,185,1020,186,1020,187,1020,188,1020,189,1020,190,1020,191,1020,192,1019,193,1019,194,1019,195,1019,230,1014,231,1014,232,1014,233,1014,234,1014,235,1014,236,1014,237,1014,238,1014,239,1014,240,1014,241,1014,242,1014,243,1014,244,1014,245,1014,246,1014,247,1014,248,1014,249,1014,250,1014,251,1014,252,1014,253,1014,254,1014,255,1014,},[81]={0,1014,1,1014,2,1014,3,1014,4,1014,5,1014,6,1014,7,1014,8,1014,9,1014,10,1014,11,1014,12,1014,13,1014,14,1014,15,1014,16,1014,17,1014,18,1014,19,1014,20,1014,21,1014,22,1014,23,1014,24,1014,25,1014,26,1014,27,1014,28,1014,29,1014,30,1014,31,1014,32,1014,33,1014,34,1014,35,1014,36,1014,37,1014,38,1017,39,1017,40,1018,41,1018,42,1018,43,1018,44,1020,45,1020,46,1020,47,1020,48,1020,49,1020,50,1020,51,1020,52,1020,53,1020,54,1020,55,1020,56,1020,57,1020,58,1020,59,1020,60,1020,61,1020,62,1020,63,1020,64,1020,65,1020,66,1020,67,1020,68,1020,69,1020,70,1020,71,1020,72,1020,73,1020,74,1020,75,1020,76,1020,77,1020,78,1020,79,1020,80,1020,81,1020,82,1020,83,1020,84,1020,85,1020,86,1020,87,1020,88,1020,89,1020,90,1020,91,1020,92,1020,93,1020,94,1020,95,1020,96,1020,97,1020,98,1020,99,1020,100,1020,101,1020,102,1020,103,1020,104,1020,105,1020,106,1020,107,1020,108,1020,109,1020,110,1020,111,1020,112,1020,113,1020,114,1020,115,1020,116,1020,117,1020,118,1020,119,1020,120,1020,121,1020,122,1020,123,1020,124,1020,125,1020,126,1020,127,1020,128,1020,129,1020,130,1020,131,1020,132,1020,133,1020,134,1020,135,1020,136,1020,137,1020,138,1020,139,1020,140,1020,141,1020,142,1020,143,1020,144,1020,145,1020,146,1020,147,1020,148,1020,149,1020,150,1020,151,1020,152,1020,153,1020,154,1020,155,1020,156,1020,157,1020,158,1020,159,1020,160,1020,161,1020,162,1020,163,1020,164,1020,165,1020,166,1020,167,1020,168,1020,169,1020,170,1020,171,1020,172,1020,173,1020,174,1020,175,1020,176,1020,177,1020,178,1020,179,1020,180,1020,181,1020,182,1020,183,1020,184,1020,185,1020,186,1020,187,1020,188,1020,189,1020,190,1020,191,1020,192,1019,193,1019,194,1019,195,1019,230,1014,231,1014,232,1014,233,1014,234,1014,235,1014,236,1014,237,1014,238,1014,239,1014,240,1014,241,1014,242,1014,243,1014,244,1014,245,1014,246,1014,247,1014,248,1014,249,1014,250,1014,251,1014,252,1014,253,1014,254,1014,255,1014,},[82]={0,1014,1,1014,2,1014,3,1014,4,1014,5,1014,6,1014,7,1014,8,1014,9,1014,10,1014,11,1014,12,1014,13,1014,14,1014,15,1014,16,1014,17,1014,18,1014,19,1014,20,1014,21,1014,22,1014,23,1014,24,1014,25,1014,26,1014,27,1014,28,1014,29,1014,30,1014,31,1014,32,1014,33,1014,34,1014,35,1014,36,1014,37,1014,38,1017,39,1017,40,1018,41,1018,42,1018,43,1018,44,1020,45,1020,46,1020,47,1020,48,1020,49,1020,50,1020,51,1020,52,1020,53,1020,54,1020,55,1020,56,1020,57,1020,58,1020,59,1020,60,1020,61,1020,62,1020,63,1020,64,1020,65,1020,66,1020,67,1020,68,1020,69,1020,70,1020,71,1020,72,1020,73,1020,74,1020,75,1020,76,1020,77,1020,78,1020,79,1020,80,1020,81,1020,82,1020,83,1020,84,1020,85,1020,86,1020,87,1020,88,1020,89,1020,90,1020,91,1020,92,1020,93,1020,94,1020,95,1020,96,1020,97,1020,98,1020,99,1020,100,1020,101,1020,102,1020,103,1020,104,1020,105,1020,106,1020,107,1020,108,1020,109,1020,110,1020,111,1020,112,1020,113,1020,114,1020,115,1020,116,1020,117,1020,118,1020,119,1020,120,1020,121,1020,122,1020,123,1020,124,1020,125,1020,126,1020,127,1020,128,1020,129,1020,130,1020,131,1020,132,1020,133,1020,134,1020,135,1020,136,1020,137,1020,138,1020,139,1020,140,1020,141,1020,142,1020,143,1020,144,1020,145,1020,146,1020,147,1020,148,1020,149,1020,150,1020,151,1020,152,1020,153,1020,154,1020,155,1020,156,1020,157,1020,158,1020,159,1020,160,1020,161,1020,162,1020,163,1020,164,1020,165,1020,166,1020,167,1020,168,1020,169,1020,170,1020,171,1020,172,1020,173,1020,174,1020,175,1020,176,1020,177,1020,178,1020,179,1020,180,1020,181,1020,182,1020,183,1020,184,1020,185,1020,186,1020,187,1020,188,1020,189,1020,190,1020,191,1020,192,1019,193,1019,194,1019,195,1019,196,1019,197,1019,228,1014,229,1014,230,1014,231,1014,232,1014,233,1014,234,1014,235,1014,236,1014,237,1014,238,1014,239,1014,240,1014,241,1014,242,1014,243,1014,244,1014,245,1014,246,1014,247,1014,248,1014,249,1014,250,1014,251,1014,252,1014,253,1014,254,1014,255,1014,},[83]={0,1014,1,1014,2,1014,3,1014,4,1014,5,1014,6,1014,7,1014,8,1014,9,1014,10,1014,11,1014,12,1014,13,1014,14,1014,15,1014,16,1014,17,1014,18,1014,19,1014,20,1014,21,1014,22,1014,23,1014,24,1014,25,1014,26,1014,27,1014,28,1014,29,1014,30,1014,31,1014,32,1014,33,1014,34,1014,35,1014,36,1014,37,1014,38,1017,39,1017,40,1018,41,1018,42,1018,43,1018,44,1020,45,1020,46,1020,47,1020,48,1020,49,1020,50,1020,51,1020,52,1020,53,1020,54,1020,55,1020,56,1020,57,1020,58,1020,59,1020,60,1020,61,1020,62,1020,63,1020,64,1020,65,1020,66,1020,67,1020,68,1020,69,1020,70,1020,71,1020,72,1020,73,1020,74,1020,75,1020,76,1020,77,1020,78,1020,79,1020,80,1020,81,1020,82,1020,83,1020,84,1020,85,1020,86,1020,87,1020,88,1020,89,1020,90,1020,91,1020,92,1020,93,1020,94,1020,95,1020,96,1020,97,1020,98,1020,99,1020,100,1020,101,1020,102,1020,103,1020,104,1020,105,1020,106,1020,107,1020,108,1020,109,1020,110,1020,111,1020,112,1020,113,1020,114,1020,115,1020,116,1020,117,1020,118,1020,119,1020,120,1020,121,1020,122,1020,123,1020,124,1020,125,1020,126,1020,127,1020,128,1020,129,1020,130,1020,131,1020,132,1020,133,1020,134,1020,135,1020,136,1020,137,1020,138,1020,139,1020,140,1020,141,1020,142,1020,143,1020,144,1020,145,1020,146,1020,147,1020,148,1020,149,1020,150,1020,151,1020,152,1020,153,1020,154,1020,155,1020,156,1020,157,1020,158,1020,159,1020,160,1020,161,1020,162,1020,163,1020,164,1020,165,1020,166,1020,167,1020,168,1020,169,1020,170,1020,171,1020,172,1020,173,1020,174,1020,175,1020,176,1020,177,1020,178,1020,179,1020,180,1020,181,1020,182,1020,183,1020,184,1020,185,1020,186,1020,187,1020,188,1020,189,1020,190,1020,191,1020,192,1019,193,1019,194,1019,195,1019,196,1019,197,1019,228,1014,229,1014,230,1014,231,1014,232,1014,233,1014,234,1014,235,1014,236,1014,237,1014,238,1014,239,1014,240,1014,241,1014,242,1014,243,1014,244,1014,245,1014,246,1014,247,1014,248,1014,249,1014,250,1014,251,1014,252,1014,253,1014,254,1014,255,1014,},[84]={4,22,5,22,6,22,7,22,8,22,9,22,10,22,11,22,12,1014,13,1014,14,1014,15,1014,16,26,17,26,18,26,19,26,20,26,21,26,22,26,23,26,24,39,25,39,26,39,27,39,28,39,29,39,30,26,31,26,68,585,69,585,70,585,71,585,72,585,73,585,74,585,75,585,76,585,77,585,78,585,79,585,80,585,81,585,82,585,83,585,140,585,141,585,142,585,143,585,144,585,145,585,146,585,147,585,148,585,149,585,150,585,151,585,152,585,153,585,154,585,155,585,194,1019,195,1019,196,1019,197,1019,198,1019,199,1019,226,1014,227,1014,228,1014,229,1014,230,1014,231,1014,},[85]={4,22,5,22,6,22,7,22,8,22,9,22,10,22,11,22,12,1014,13,1014,14,1014,15,1014,16,26,17,26,18,26,19,26,20,26,21,26,22,26,23,26,24,39,25,39,26,39,27,39,28,39,29,39,30,26,31,26,68,585,69,585,70,585,71,585,72,585,73,585,74,585,75,585,76,585,77,585,78,585,79,585,80,585,81,585,82,585,83,585,140,585,141,585,142,585,143,585,144,585,145,585,146,585,147,585,148,585,149,585,150,585,151,585,152,585,153,585,154,585,155,585,194,1019,195,1019,196,1019,197,1019,198,1019,199,1019,226,1014,227,1014,228,1014,229,1014,230,1014,231,1014,},[86]={4,22,5,22,6,22,7,22,8,22,9,22,10,22,11,22,12,1014,13,1014,14,1014,15,1014,16,26,17,26,18,26,19,26,20,26,21,26,22,26,23,26,24,39,25,39,26,39,27,39,28,39,29,39,30,26,31,26,68,585,69,585,70,585,71,585,72,585,73,585,74,585,75,585,76,585,77,585,78,585,79,585,80,585,81,585,82,585,83,585,140,585,141,585,142,585,143,585,144,585,145,585,146,585,147,585,148,585,149,585,150,585,151,585,152,585,153,585,154,585,155,585,196,1019,197,1019,198,1019,199,1019,200,1019,201,1019,224,1014,225,1014,226,1014,227,1014,228,1014,229,1014,},[87]={4,22,5,22,6,22,7,22,8,22,9,22,10,22,11,22,12,1014,13,1014,14,1014,15,1014,16,26,17,26,18,26,19,26,20,26,21,26,22,26,23,26,24,39,25,39,26,39,27,39,28,39,29,39,30,26,31,26,68,585,69,585,70,585,71,585,72,585,73,585,74,585,75,585,76,585,77,585,78,585,79,585,80,585,81,585,82,585,83,585,140,585,141,585,142,585,143,585,144,585,145,585,146,585,147,585,148,585,149,585,150,585,151,585,152,585,153,585,154,585,155,585,196,1019,197,1019,198,1019,199,1019,200,1019,201,1019,224,1014,225,1014,226,1014,227,1014,228,1014,229,1014,},[88]={4,22,5,22,6,22,7,22,8,22,9,22,10,22,11,22,12,1014,13,1014,14,1014,15,1014,16,26,17,26,18,26,19,26,20,26,21,26,22,26,23,26,24,33,25,33,26,33,27,33,28,39,29,39,30,26,31,26,198,1019,199,1019,200,1019,201,1019,202,1019,203,1019,222,1014,223,1014,224,1014,225,1014,226,1014,227,1014,},[89]={4,22,5,22,6,22,7,22,8,22,9,22,10,22,11,22,12,1014,13,1014,14,1014,15,1014,16,26,17,26,18,26,19,26,20,26,21,26,22,26,23,26,24,33,25,33,26,33,27,33,28,39,29,39,30,26,31,26,198,1019,199,1019,200,1019,201,1019,202,1019,203,1019,222,1014,223,1014,224,1014,225,1014,226,1014,227,1014,},[90]={4,22,5,22,6,22,7,22,8,22,9,22,10,22,11,22,12,1014,13,1014,14,1014,15,1014,16,26,17,26,18,26,19,26,20,26,21,26,22,26,23,26,24,26,25,26,26,26,27,26,28,26,29,26,30,26,31,26,200,1019,201,1019,202,1019,203,1019,204,1017,205,1017,220,1014,221,1014,222,1014,223,1014,224,1014,225,1014,},[91]={4,22,5,22,6,22,7,22,8,22,9,22,10,22,11,22,12,1014,13,1014,14,1014,15,1014,16,26,17,26,18,26,19,26,20,26,21,26,22,26,23,26,24,26,25,26,26,26,27,26,28,26,29,26,30,26,31,26,200,1019,201,1019,202,1019,203,1019,204,1017,205,1017,220,1014,221,1014,222,1014,223,1014,224,1014,225,1014,},[92]={4,22,5,22,6,22,7,22,8,22,9,22,10,22,11,22,12,1014,13,1014,14,1014,15,1014,16,26,17,26,18,26,19,26,20,26,21,26,22,26,23,26,24,26,25,26,26,26,27,26,28,30,29,30,30,26,31,26,202,1017,203,1017,204,1017,205,1017,206,1010,207,1010,208,986,209,986,210,980,211,980,212,977,213,977,214,976,215,976,216,995,217,995,218,1004,219,1004,220,1004,221,1004,222,1014,223,1014,},[93]={4,22,5,22,6,22,7,22,8,22,9,22,10,22,11,22,12,1014,13,1014,14,1014,15,1014,16,26,17,26,18,26,19,26,20,26,21,26,22,26,23,26,24,26,25,26,26,26,27,26,28,30,29,30,30,26,31,26,202,1017,203,1017,204,1017,205,1017,206,1010,207,1010,208,986,209,986,210,980,211,980,212,977,213,977,214,976,215,976,216,995,217,995,218,1004,219,1004,220,1004,221,1004,222,1014,223,1014,},[94]={4,22,5,22,6,22,7,22,8,22,9,22,10,22,11,22,12,1014,13,1014,14,1014,15,1014,16,26,17,26,18,26,19,26,20,26,21,26,22,26,23,26,24,26,25,26,26,26,27,26,28,26,29,26,30,39,31,39,204,1010,205,1010,206,1010,207,1010,208,986,209,986,210,980,211,980,212,977,213,977,214,976,215,976,216,995,217,995,218,1009,219,1009,220,1009,221,1009,},[95]={4,22,5,22,6,22,7,22,8,22,9,22,10,22,11,22,12,1014,13,1014,14,1014,15,1014,16,26,17,26,18,26,19,26,20,26,21,26,22,26,23,26,24,26,25,26,26,26,27,26,28,26,29,26,30,39,31,39,204,1010,205,1010,206,1010,207,1010,208,986,209,986,210,980,211,980,212,977,213,977,214,976,215,976,216,995,217,995,218,1009,219,1009,220,1009,221,1009,},[96]={4,22,5,22,6,22,7,22,8,22,9,22,10,22,11,22,12,1014,13,1014,14,1014,15,1014,16,26,17,26,18,26,19,26,20,26,21,26,22,26,23,26,24,26,25,26,26,26,27,26,28,26,29,26,30,13,31,13,32,26,33,26,34,26,35,26,204,1013,205,1013,206,1013,207,1013,208,325,209,325,210,325,211,325,212,325,213,325,214,325,215,325,216,325,217,325,218,1011,219,1011,220,1011,221,1011,},[97]={4,22,5,22,6,22,7,22,8,22,9,22,10,22,11,22,12,1014,13,1014,14,1014,15,1014,16,26,17,26,18,26,19,26,20,26,21,26,22,26,23,26,24,26,25,26,26,26,27,26,28,26,29,26,30,13,31,13,32,26,33,26,34,26,35,26,204,1013,205,1013,206,1013,207,1013,208,325,209,325,210,325,211,325,212,325,213,325,214,325,215,325,216,325,217,325,218,1011,219,1011,220,1011,221,1011,},[98]={4,22,5,22,6,22,7,22,8,22,9,22,10,22,11,22,12,1014,13,1014,14,1014,15,1014,16,26,17,26,18,26,19,26,20,26,21,26,22,26,23,26,24,26,25,26,26,26,27,26,28,26,29,26,30,24,31,24,32,26,33,26,34,26,35,26,204,1019,205,1019,206,1019,207,1019,208,325,209,325,210,325,211,325,212,325,213,325,214,325,215,325,216,325,217,325,218,1012,219,1012,220,1012,221,1012,},[99]={4,22,5,22,6,22,7,22,8,22,9,22,10,22,11,22,12,1014,13,1014,14,1014,15,1014,16,26,17,26,18,26,19,26,20,26,21,26,22,26,23,26,24,26,25,26,26,26,27,26,28,26,29,26,30,24,31,24,32,26,33,26,34,26,35,26,204,1019,205,1019,206,1019,207,1019,208,325,209,325,210,325,211,325,212,325,213,325,214,325,215,325,216,325,217,325,218,1012,219,1012,220,1012,221,1012,},[100]={4,22,5,22,6,22,7,22,8,22,9,22,10,22,11,22,12,1014,13,1014,14,1014,15,1014,16,26,17,26,18,26,19,26,20,26,21,26,22,26,23,26,24,26,25,26,26,26,27,26,28,26,29,26,30,24,31,24,204,1019,205,1019,206,1019,207,1019,208,325,209,325,210,325,211,325,212,325,213,325,214,325,215,325,216,325,217,325,218,1013,219,1013,220,1013,221,1013,},[101]={4,22,5,22,6,22,7,22,8,22,9,22,10,22,11,22,12,1014,13,1014,14,1014,15,1014,16,26,17,26,18,26,19,26,20,26,21,26,22,26,23,26,24,26,25,26,26,26,27,26,28,26,29,26,30,24,31,24,204,1019,205,1019,206,1019,207,1019,208,325,209,325,210,325,211,325,212,325,213,325,214,325,215,325,216,325,217,325,218,1013,219,1013,220,1013,221,1013,},[102]={4,26,5,26,6,26,7,26,8,26,9,26,10,26,11,26,12,1014,13,1014,14,1014,15,1014,16,26,17,26,18,26,19,26,20,26,21,26,22,26,23,26,24,26,25,26,26,26,27,26,28,31,29,31,30,37,31,37,204,1019,205,1019,206,1019,207,1019,208,325,209,325,210,325,211,325,212,325,213,325,214,325,215,325,216,325,217,325,218,1013,219,1013,220,1013,221,1013,},[103]={4,26,5,26,6,26,7,26,8,26,9,26,10,26,11,26,12,1014,13,1014,14,1014,15,1014,16,26,17,26,18,26,19,26,20,26,21,26,22,26,23,26,24,26,25,26,26,26,27,26,28,31,29,31,30,37,31,37,204,1019,205,1019,206,1019,207,1019,208,325,209,325,210,325,211,325,212,325,213,325,214,325,215,325,216,325,217,325,218,1013,219,1013,220,1013,221,1013,},[104]={4,26,5,26,6,26,7,26,8,26,9,26,10,26,11,26,12,1014,13,1014,14,1014,15,1014,16,26,17,26,18,26,19,26,20,26,21,26,22,26,23,26,24,26,25,26,26,18,27,18,28,34,29,34,30,37,31,37,204,1019,205,1019,206,1019,207,1019,208,325,209,325,210,325,211,325,212,325,213,325,214,325,215,325,216,325,217,325,218,1013,219,1013,220,1013,221,1013,},[105]={4,26,5,26,6,26,7,26,8,26,9,26,10,26,11,26,12,1014,13,1014,14,1014,15,1014,16,26,17,26,18,26,19,26,20,26,21,26,22,26,23,26,24,26,25,26,26,18,27,18,28,34,29,34,30,37,31,37,204,1019,205,1019,206,1019,207,1019,208,325,209,325,210,325,211,325,212,325,213,325,214,325,215,325,216,325,217,325,218,1013,219,1013,220,1013,221,1013,},[106]={4,26,5,26,6,26,7,26,8,26,9,26,10,26,11,26,12,1014,13,1014,14,1014,15,1014,16,6,17,6,18,24,19,24,20,26,21,26,22,26,23,26,24,26,25,26,26,12,27,12,28,19,29,19,30,19,31,19,204,1019,205,1019,206,1019,207,1019,208,325,209,325,210,325,211,325,212,325,213,325,214,325,215,325,216,325,217,325,218,1012,219,1012,220,1012,221,1012,},[107]={4,26,5,26,6,26,7,26,8,26,9,26,10,26,11,26,12,1014,13,1014,14,1014,15,1014,16,6,17,6,18,24,19,24,20,26,21,26,22,26,23,26,24,26,25,26,26,12,27,12,28,19,29,19,30,19,31,19,204,1019,205,1019,206,1019,207,1019,208,325,209,325,210,325,211,325,212,325,213,325,214,325,215,325,216,325,217,325,218,1012,219,1012,220,1012,221,1012,},[108]={4,26,5,26,6,26,7,26,8,26,9,26,10,26,11,26,12,1014,13,1014,14,1014,15,1014,16,6,17,6,18,6,19,6,20,6,21,6,22,6,23,6,24,6,25,6,26,6,27,6,28,19,29,19,30,19,31,19,68,585,69,585,70,585,71,585,72,585,73,585,74,585,75,585,76,585,77,585,78,585,79,585,80,585,81,585,82,585,83,585,140,585,141,585,142,585,143,585,144,585,145,585,146,585,147,585,148,585,149,585,150,585,151,585,152,585,153,585,154,585,155,585,204,1019,205,1019,206,1019,207,1019,208,325,209,325,210,325,211,325,212,325,213,325,214,325,215,325,216,325,217,325,218,1012,219,1012,220,1012,221,1012,},[109]={4,26,5,26,6,26,7,26,8,26,9,26,10,26,11,26,12,1014,13,1014,14,1014,15,1014,16,6,17,6,18,6,19,6,20,6,21,6,22,6,23,6,24,6,25,6,26,6,27,6,28,19,29,19,30,19,31,19,68,585,69,585,70,585,71,585,72,585,73,585,74,585,75,585,76,585,77,585,78,585,79,585,80,585,81,585,82,585,83,585,140,585,141,585,142,585,143,585,144,585,145,585,146,585,147,585,148,585,149,585,150,585,151,585,152,585,153,585,154,585,155,585,204,1019,205,1019,206,1019,207,1019,208,325,209,325,210,325,211,325,212,325,213,325,214,325,215,325,216,325,217,325,218,1012,219,1012,220,1012,221,1012,},[110]={4,26,5,26,6,26,7,26,8,26,9,26,10,26,11,26,12,1014,13,1014,14,1014,15,1014,16,6,17,6,18,6,19,6,20,6,21,6,22,6,23,6,24,6,25,6,26,6,27,6,28,19,29,19,30,19,31,19,68,585,69,585,70,585,71,585,72,585,73,585,74,585,75,585,76,585,77,585,78,585,79,585,80,585,81,585,82,585,83,585,140,585,141,585,142,585,143,585,144,585,145,585,146,585,147,585,148,585,149,585,150,585,151,585,152,585,153,585,154,585,155,585,204,1019,205,1019,206,1019,207,1019,208,325,209,325,210,325,211,325,212,325,213,325,214,325,215,325,216,325,217,325,218,1012,219,1012,220,1012,221,1012,},[111]={4,26,5,26,6,26,7,26,8,26,9,26,10,26,11,26,12,1014,13,1014,14,1014,15,1014,16,6,17,6,18,6,19,6,20,6,21,6,22,6,23,6,24,6,25,6,26,6,27,6,28,19,29,19,30,19,31,19,68,585,69,585,70,585,71,585,72,585,73,585,74,585,75,585,76,585,77,585,78,585,79,585,80,585,81,585,82,585,83,585,140,585,141,585,142,585,143,585,144,585,145,585,146,585,147,585,148,585,149,585,150,585,151,585,152,585,153,585,154,585,155,585,204,1019,205,1019,206,1019,207,1019,208,325,209,325,210,325,211,325,212,325,213,325,214,325,215,325,216,325,217,325,218,1012,219,1012,220,1012,221,1012,},[112]={0,1014,1,1014,2,1014,3,1014,4,1014,5,1014,6,1014,7,1014,8,1014,9,1014,10,1014,11,1014,12,1014,13,1014,14,1014,15,1014,16,1015,17,1015,18,1018,19,1018,20,1019,21,1019,22,1019,23,1019,24,1019,25,1019,26,1019,27,1019,28,1019,29,1019,30,1019,31,1019,32,1019,33,1019,34,1019,35,1019,36,1019,37,1019,38,1019,39,1019,40,1019,41,1019,42,1019,43,1019,44,1019,45,1019,46,1019,47,1019,48,1019,49,1019,50,1019,51,1019,52,1019,53,1019,54,1019,55,1019,56,1019,57,1019,58,1019,59,1019,60,1019,61,1019,62,1019,63,1019,64,1019,65,1019,66,1019,67,1019,68,1019,69,1019,70,1019,71,1019,72,1019,73,1019,74,1019,75,1019,76,1019,77,1019,78,1019,79,1019,80,1019,81,1019,82,998,83,998,84,988,85,988,86,984,87,984,88,982,89,982,90,983,91,983,92,983,93,983,94,983,95,983,96,983,97,983,98,983,99,983,100,983,101,983,102,983,103,983,104,984,105,984,106,984,107,984,108,984,109,984,110,984,111,984,112,984,113,984,114,984,115,984,116,984,117,984,118,984,119,984,120,984,121,984,122,984,123,984,124,984,125,984,126,984,127,984,128,984,129,984,130,984,131,984,132,984,133,984,134,984,135,984,136,984,137,984,138,984,139,984,140,984,141,984,142,984,143,984,144,984,145,984,146,984,147,984,148,984,149,984,150,984,151,984,152,984,153,984,154,984,155,984,156,984,157,984,158,984,159,984,160,984,161,984,162,983,163,983,164,983,165,983,166,983,167,983,168,983,169,983,170,983,171,983,172,983,173,983,174,983,175,983,176,983,177,983,178,983,179,983,180,983,181,983,182,983,183,983,204,1019,205,1019,206,1019,207,1019,208,325,209,325,210,325,211,325,212,325,213,325,214,325,215,325,216,325,217,325,218,1012,219,1012,220,1012,221,1012,242,1014,243,1014,244,1014,245,1014,246,1014,247,1014,248,1014,249,1014,250,1014,251,1014,252,1014,253,1014,254,1014,255,1014,},[113]={0,1014,1,1014,2,1014,3,1014,4,1014,5,1014,6,1014,7,1014,8,1014,9,1014,10,1014,11,1014,12,1014,13,1014,14,1014,15,1014,16,1015,17,1015,18,1018,19,1018,20,1019,21,1019,22,1019,23,1019,24,1019,25,1019,26,1019,27,1019,28,1019,29,1019,30,1019,31,1019,32,1019,33,1019,34,1019,35,1019,36,1019,37,1019,38,1019,39,1019,40,1019,41,1019,42,1019,43,1019,44,1019,45,1019,46,1019,47,1019,48,1019,49,1019,50,1019,51,1019,52,1019,53,1019,54,1019,55,1019,56,1019,57,1019,58,1019,59,1019,60,1019,61,1019,62,1019,63,1019,64,1019,65,1019,66,1019,67,1019,68,1019,69,1019,70,1019,71,1019,72,1019,73,1019,74,1019,75,1019,76,1019,77,1019,78,1019,79,1019,80,1019,81,1019,82,998,83,998,84,988,85,988,86,984,87,984,88,982,89,982,90,983,91,983,92,983,93,983,94,983,95,983,96,983,97,983,98,983,99,983,100,983,101,983,102,983,103,983,104,984,105,984,106,984,107,984,108,984,109,984,110,984,111,984,112,984,113,984,114,984,115,984,116,984,117,984,118,984,119,984,120,984,121,984,122,984,123,984,124,984,125,984,126,984,127,984,128,984,129,984,130,984,131,984,132,984,133,984,134,984,135,984,136,984,137,984,138,984,139,984,140,984,141,984,142,984,143,984,144,984,145,984,146,984,147,984,148,984,149,984,150,984,151,984,152,984,153,984,154,984,155,984,156,984,157,984,158,984,159,984,160,984,161,984,162,983,163,983,164,983,165,983,166,983,167,983,168,983,169,983,170,983,171,983,172,983,173,983,174,983,175,983,176,983,177,983,178,983,179,983,180,983,181,983,182,983,183,983,204,1019,205,1019,206,1019,207,1019,208,325,209,325,210,325,211,325,212,325,213,325,214,325,215,325,216,325,217,325,218,1012,219,1012,220,1012,221,1012,242,1014,243,1014,244,1014,245,1014,246,1014,247,1014,248,1014,249,1014,250,1014,251,1014,252,1014,253,1014,254,1014,255,1014,},[114]={0,1014,1,1014,2,1014,3,1014,4,1014,5,1014,6,1014,7,1014,8,1014,9,1014,10,1014,11,1014,12,1014,13,1014,14,1014,15,1014,16,1015,17,1015,18,1018,19,1018,20,1019,21,1019,22,1019,23,1019,24,1019,25,1019,26,1019,27,1019,28,1019,29,1019,30,1019,31,1019,32,1019,33,1019,34,1019,35,1019,36,1019,37,1019,38,1019,39,1019,40,1019,41,1019,42,1019,43,1019,44,1019,45,1019,46,1019,47,1019,48,1019,49,1019,50,1019,51,1019,52,1019,53,1019,54,1019,55,1019,56,1019,57,1019,58,1019,59,1019,60,1019,61,1019,62,1019,63,1019,64,1019,65,1019,66,1019,67,1019,68,1019,69,1019,70,1019,71,1019,72,1019,73,1019,74,1019,75,1019,76,1019,77,1019,78,1019,79,1019,80,1019,81,1019,82,998,83,998,84,988,85,988,86,984,87,984,88,982,89,982,90,983,91,983,92,983,93,983,94,983,95,983,96,983,97,983,98,983,99,983,100,983,101,983,102,983,103,983,104,984,105,984,106,984,107,984,108,984,109,984,110,984,111,984,112,984,113,984,114,984,115,984,116,984,117,984,118,984,119,984,120,984,121,984,122,984,123,984,124,984,125,984,126,984,127,984,128,984,129,984,130,984,131,984,132,984,133,984,134,984,135,984,136,984,137,984,138,984,139,984,140,984,141,984,142,984,143,984,144,984,145,984,146,984,147,984,148,984,149,984,150,984,151,984,152,984,153,984,154,984,155,984,156,984,157,984,158,984,159,984,160,984,161,984,162,983,163,983,164,983,165,983,166,983,167,983,168,983,169,983,170,983,171,983,172,983,173,983,174,983,175,983,176,983,177,983,178,983,179,983,180,983,181,983,182,983,183,983,184,981,185,981,204,1018,205,1018,206,1018,207,1018,208,1014,209,1014,210,325,211,325,212,325,213,325,214,325,215,325,216,325,217,325,218,1012,219,1012,220,1012,221,1012,240,1014,241,1014,242,1014,243,1014,244,1014,245,1014,246,1014,247,1014,248,1014,249,1014,250,1014,251,1014,252,1014,253,1014,254,1014,255,1014,},[115]={0,1014,1,1014,2,1014,3,1014,4,1014,5,1014,6,1014,7,1014,8,1014,9,1014,10,1014,11,1014,12,1014,13,1014,14,1014,15,1014,16,1015,17,1015,18,1018,19,1018,20,1019,21,1019,22,1019,23,1019,24,1019,25,1019,26,1019,27,1019,28,1019,29,1019,30,1019,31,1019,32,1019,33,1019,34,1019,35,1019,36,1019,37,1019,38,1019,39,1019,40,1019,41,1019,42,1019,43,1019,44,1019,45,1019,46,1019,47,1019,48,1019,49,1019,50,1019,51,1019,52,1019,53,1019,54,1019,55,1019,56,1019,57,1019,58,1019,59,1019,60,1019,61,1019,62,1019,63,1019,64,1019,65,1019,66,1019,67,1019,68,1019,69,1019,70,1019,71,1019,72,1019,73,1019,74,1019,75,1019,76,1019,77,1019,78,1019,79,1019,80,1019,81,1019,82,998,83,998,84,988,85,988,86,984,87,984,88,982,89,982,90,983,91,983,92,983,93,983,94,983,95,983,96,983,97,983,98,983,99,983,100,983,101,983,102,983,103,983,104,984,105,984,106,984,107,984,108,984,109,984,110,984,111,984,112,984,113,984,114,984,115,984,116,984,117,984,118,984,119,984,120,984,121,984,122,984,123,984,124,984,125,984,126,984,127,984,128,984,129,984,130,984,131,984,132,984,133,984,134,984,135,984,136,984,137,984,138,984,139,984,140,984,141,984,142,984,143,984,144,984,145,984,146,984,147,984,148,984,149,984,150,984,151,984,152,984,153,984,154,984,155,984,156,984,157,984,158,984,159,984,160,984,161,984,162,983,163,983,164,983,165,983,166,983,167,983,168,983,169,983,170,983,171,983,172,983,173,983,174,983,175,983,176,983,177,983,178,983,179,983,180,983,181,983,182,983,183,983,184,981,185,981,204,1018,205,1018,206,1018,207,1018,208,1014,209,1014,210,325,211,325,212,325,213,325,214,325,215,325,216,325,217,325,218,1012,219,1012,220,1012,221,1012,240,1014,241,1014,242,1014,243,1014,244,1014,245,1014,246,1014,247,1014,248,1014,249,1014,250,1014,251,1014,252,1014,253,1014,254,1014,255,1014,},[116]={182,981,183,981,184,981,185,981,186,507,187,507,204,533,205,533,206,1014,207,1014,208,1014,209,1014,210,996,211,996,212,325,213,325,214,325,215,325,216,325,217,325,218,1012,219,1012,220,1012,221,1012,238,1014,239,1014,240,1014,241,1014,242,1014,243,1014,},[117]={182,981,183,981,184,981,185,981,186,507,187,507,204,533,205,533,206,1014,207,1014,208,1014,209,1014,210,996,211,996,212,325,213,325,214,325,215,325,216,325,217,325,218,1012,219,1012,220,1012,221,1012,238,1014,239,1014,240,1014,241,1014,242,1014,243,1014,},[118]={182,978,183,978,184,978,185,978,186,507,187,507,188,507,189,507,204,533,205,533,206,533,207,533,208,996,209,996,210,996,211,996,212,325,213,325,214,325,215,325,216,325,217,325,218,1012,219,1012,220,1012,221,1012,238,1014,239,1014,240,1014,241,1014,},[119]={182,978,183,978,184,978,185,978,186,507,187,507,188,507,189,507,204,533,205,533,206,533,207,533,208,996,209,996,210,996,211,996,212,325,213,325,214,325,215,325,216,325,217,325,218,1012,219,1012,220,1012,221,1012,238,1014,239,1014,240,1014,241,1014,},[120]={182,973,183,973,184,973,185,973,186,507,187,507,188,507,189,507,204,533,205,533,206,533,207,533,208,988,209,988,210,988,211,988,212,325,213,325,214,325,215,325,216,325,217,325,218,1012,219,1012,220,1012,221,1012,238,1014,239,1014,240,1014,241,1014,},[121]={182,973,183,973,184,973,185,973,186,507,187,507,188,507,189,507,204,533,205,533,206,533,207,533,208,988,209,988,210,988,211,988,212,325,213,325,214,325,215,325,216,325,217,325,218,1012,219,1012,220,1012,221,1012,238,1014,239,1014,240,1014,241,1014,},[122]={182,962,183,962,184,962,185,962,186,507,187,507,188,507,189,507,204,533,205,533,206,533,207,533,208,988,209,988,210,988,211,988,212,325,213,325,214,325,215,325,216,325,217,325,218,1012,219,1012,220,1012,221,1012,238,1014,239,1014,240,1014,241,1014,},[123]={182,962,183,962,184,962,185,962,186,507,187,507,188,507,189,507,204,533,205,533,206,533,207,533,208,988,209,988,210,988,211,988,212,325,213,325,214,325,215,325,216,325,217,325,218,1012,219,1012,220,1012,221,1012,238,1014,239,1014,240,1014,241,1014,},[124]={182,962,183,962,184,962,185,962,186,507,187,507,188,507,189,507,204,533,205,533,206,533,207,533,208,988,209,988,210,988,211,988,212,325,213,325,214,325,215,325,216,325,217,325,218,1012,219,1012,220,1012,221,1012,238,1014,239,1014,240,1014,241,1014,242,1014,243,1014,},[125]={182,962,183,962,184,962,185,962,186,507,187,507,188,507,189,507,204,533,205,533,206,533,207,533,208,988,209,988,210,988,211,988,212,325,213,325,214,325,215,325,216,325,217,325,218,1012,219,1012,220,1012,221,1012,238,1014,239,1014,240,1014,241,1014,242,1014,243,1014,},[126]={182,962,183,962,184,962,185,962,186,507,187,507,188,507,189,507,204,533,205,533,206,533,207,533,208,988,209,988,210,988,211,988,212,325,213,325,214,325,215,325,216,325,217,325,218,1012,219,1012,220,1012,221,1012,240,1014,241,1014,242,1014,243,1014,244,1014,245,1014,},[127]={182,962,183,962,184,962,185,962,186,507,187,507,188,507,189,507,204,533,205,533,206,533,207,533,208,988,209,988,210,988,211,988,212,325,213,325,214,325,215,325,216,325,217,325,218,1012,219,1012,220,1012,221,1012,240,1014,241,1014,242,1014,243,1014,244,1014,245,1014,},[128]={182,962,183,962,184,962,185,962,186,507,187,507,188,507,189,507,204,533,205,533,206,533,207,533,208,988,209,988,210,988,211,988,212,325,213,325,214,325,215,325,216,325,217,325,218,1012,219,1012,220,1012,221,1012,242,1014,243,1014,244,1014,245,1014,246,1014,247,1014,248,1014,249,1014,250,1014,251,1014,},[129]={182,962,183,962,184,962,185,962,186,507,187,507,188,507,189,507,204,533,205,533,206,533,207,533,208,988,209,988,210,988,211,988,212,325,213,325,214,325,215,325,216,325,217,325,218,1012,219,1012,220,1012,221,1012,242,1014,243,1014,244,1014,245,1014,246,1014,247,1014,248,1014,249,1014,250,1014,251,1014,},[130]={182,962,183,962,184,962,185,962,186,507,187,507,188,507,189,507,204,533,205,533,206,533,207,533,208,988,209,988,210,988,211,988,212,325,213,325,214,325,215,325,216,325,217,325,218,1012,219,1012,220,1012,221,1012,244,1014,245,1014,246,1014,247,1014,248,1014,249,1014,250,1014,251,1014,252,1014,253,1014,},[131]={182,962,183,962,184,962,185,962,186,507,187,507,188,507,189,507,204,533,205,533,206,533,207,533,208,988,209,988,210,988,211,988,212,325,213,325,214,325,215,325,216,325,217,325,218,1012,219,1012,220,1012,221,1012,244,1014,245,1014,246,1014,247,1014,248,1014,249,1014,250,1014,251,1014,252,1014,253,1014,},[132]={182,962,183,962,184,962,185,962,186,507,187,507,188,507,189,507,204,533,205,533,206,533,207,533,208,988,209,988,210,988,211,988,212,325,213,325,214,325,215,325,216,325,217,325,218,1012,219,1012,220,1012,221,1012,250,1014,251,1014,252,1014,253,1014,254,1014,255,1014,},[133]={182,962,183,962,184,962,185,962,186,507,187,507,188,507,189,507,204,533,205,533,206,533,207,533,208,988,209,988,210,988,211,988,212,325,213,325,214,325,215,325,216,325,217,325,218,1012,219,1012,220,1012,221,1012,250,1014,251,1014,252,1014,253,1014,254,1014,255,1014,},[134]={0,1014,1,1014,182,962,183,962,184,962,185,962,186,507,187,507,188,507,189,507,204,533,205,533,206,533,207,533,208,988,209,988,210,988,211,988,212,325,213,325,214,325,215,325,216,325,217,325,218,1012,219,1012,220,1012,221,1012,252,1014,253,1014,254,1014,255,1014,},[135]={0,1014,1,1014,182,962,183,962,184,962,185,962,186,507,187,507,188,507,189,507,204,533,205,533,206,533,207,533,208,988,209,988,210,988,211,988,212,325,213,325,214,325,215,325,216,325,217,325,218,1012,219,1012,220,1012,221,1012,252,1014,253,1014,254,1014,255,1014,},[136]={0,1014,1,1014,2,1014,3,1014,182,962,183,962,184,962,185,962,186,507,187,507,188,507,189,507,204,533,205,533,206,533,207,533,208,988,209,988,210,988,211,988,212,325,213,325,214,325,215,325,216,325,217,325,218,1012,219,1012,220,1012,221,1012,254,1014,255,1014,},[137]={0,1014,1,1014,2,1014,3,1014,182,962,183,962,184,962,185,962,186,507,187,507,188,507,189,507,204,533,205,533,206,533,207,533,208,988,209,988,210,988,211,988,212,325,213,325,214,325,215,325,216,325,217,325,218,1012,219,1012,220,1012,221,1012,254,1014,255,1014,},[138]={0,1014,1,1014,2,1014,3,1014,4,1014,5,1014,182,962,183,962,184,962,185,962,186,507,187,507,188,507,189,507,204,533,205,533,206,533,207,533,208,988,209,988,210,988,211,988,212,325,213,325,214,325,215,325,216,325,217,325,218,1012,219,1012,220,1012,221,1012,},[139]={0,1014,1,1014,2,1014,3,1014,4,1014,5,1014,182,962,183,962,184,962,185,962,186,507,187,507,188,507,189,507,204,533,205,533,206,533,207,533,208,988,209,988,210,988,211,988,212,325,213,325,214,325,215,325,216,325,217,325,218,1012,219,1012,220,1012,221,1012,},[140]={2,1014,3,1014,4,1014,5,1014,6,1014,7,1014,182,962,183,962,184,962,185,962,186,507,187,507,188,507,189,507,204,533,205,533,206,533,207,533,208,988,209,988,210,988,211,988,212,325,213,325,214,325,215,325,216,325,217,325,218,1012,219,1012,220,1012,221,1012,},[141]={2,1014,3,1014,4,1014,5,1014,6,1014,7,1014,182,962,183,962,184,962,185,962,186,507,187,507,188,507,189,507,204,533,205,533,206,533,207,533,208,988,209,988,210,988,211,988,212,325,213,325,214,325,215,325,216,325,217,325,218,1012,219,1012,220,1012,221,1012,},[142]={4,1014,5,1014,6,1014,7,1014,182,962,183,962,184,962,185,962,186,507,187,507,188,507,189,507,204,533,205,533,206,533,207,533,208,988,209,988,210,988,211,988,212,325,213,325,214,325,215,325,216,325,217,325,218,1012,219,1012,220,1012,221,1012,222,715,223,715,224,325,225,325,},[143]={4,1014,5,1014,6,1014,7,1014,182,962,183,962,184,962,185,962,186,507,187,507,188,507,189,507,204,533,205,533,206,533,207,533,208,988,209,988,210,988,211,988,212,325,213,325,214,325,215,325,216,325,217,325,218,1012,219,1012,220,1012,221,1012,222,715,223,715,224,325,225,325,},[144]={4,1014,5,1014,6,1014,7,1014,182,962,183,962,184,962,185,962,186,507,187,507,188,507,189,507,204,533,205,533,206,533,207,533,208,988,209,988,210,988,211,988,212,325,213,325,214,325,215,325,216,325,217,325,218,1012,219,1012,220,1012,221,1012,222,715,223,715,224,455,225,455,},[145]={4,1014,5,1014,6,1014,7,1014,182,962,183,962,184,962,185,962,186,507,187,507,188,507,189,507,204,533,205,533,206,533,207,533,208,988,209,988,210,988,211,988,212,325,213,325,214,325,215,325,216,325,217,325,218,1012,219,1012,220,1012,221,1012,222,715,223,715,224,455,225,455,},[146]={4,1014,5,1014,6,1014,7,1014,182,962,183,962,184,962,185,962,186,507,187,507,188,507,189,507,204,533,205,533,206,533,207,533,208,988,209,988,210,988,211,988,212,325,213,325,214,325,215,325,216,325,217,325,218,1012,219,1012,220,1012,221,1012,222,715,223,715,224,455,225,455,},[147]={4,1014,5,1014,6,1014,7,1014,182,962,183,962,184,962,185,962,186,507,187,507,188,507,189,507,204,533,205,533,206,533,207,533,208,988,209,988,210,988,211,988,212,325,213,325,214,325,215,325,216,325,217,325,218,1012,219,1012,220,1012,221,1012,222,715,223,715,224,455,225,455,},[148]={4,1014,5,1014,6,1014,7,1014,182,963,183,963,184,963,185,963,186,507,187,507,188,507,189,507,204,533,205,533,206,533,207,533,208,989,209,989,210,989,211,989,212,325,213,325,214,325,215,325,216,325,217,325,218,1012,219,1012,220,1012,221,1012,222,715,223,715,224,455,225,455,},[149]={4,1014,5,1014,6,1014,7,1014,182,963,183,963,184,963,185,963,186,507,187,507,188,507,189,507,204,533,205,533,206,533,207,533,208,989,209,989,210,989,211,989,212,325,213,325,214,325,215,325,216,325,217,325,218,1012,219,1012,220,1012,221,1012,222,715,223,715,224,455,225,455,},[150]={4,1014,5,1014,6,1014,7,1014,128,975,129,975,130,975,131,975,132,975,133,975,134,975,135,975,136,975,137,975,138,975,139,975,140,975,141,975,142,975,143,975,144,975,145,975,146,975,147,975,148,975,149,975,150,975,151,975,152,975,153,975,154,975,155,975,156,975,157,975,158,975,159,975,160,975,161,975,162,975,163,975,164,975,165,975,166,975,167,975,168,975,169,975,170,975,171,975,172,975,173,975,174,975,175,975,176,975,177,975,178,975,179,975,180,971,181,971,182,965,183,965,184,965,185,965,186,507,187,507,188,507,189,507,204,533,205,533,206,533,207,533,208,990,209,990,210,990,211,990,212,325,213,325,214,325,215,325,216,325,217,325,218,1012,219,1012,220,1012,221,1012,222,715,223,715,224,455,225,455,},[151]={4,1014,5,1014,6,1014,7,1014,128,975,129,975,130,975,131,975,132,975,133,975,134,975,135,975,136,975,137,975,138,975,139,975,140,975,141,975,142,975,143,975,144,975,145,975,146,975,147,975,148,975,149,975,150,975,151,975,152,975,153,975,154,975,155,975,156,975,157,975,158,975,159,975,160,975,161,975,162,975,163,975,164,975,165,975,166,975,167,975,168,975,169,975,170,975,171,975,172,975,173,975,174,975,175,975,176,975,177,975,178,975,179,975,180,971,181,971,182,965,183,965,184,965,185,965,186,507,187,507,188,507,189,507,204,533,205,533,206,533,207,533,208,990,209,990,210,990,211,990,212,325,213,325,214,325,215,325,216,325,217,325,218,1012,219,1012,220,1012,221,1012,222,715,223,715,224,455,225,455,},[152]={4,1014,5,1014,6,1014,7,1014,126,975,127,975,128,975,129,975,130,975,131,975,132,975,133,975,134,975,135,975,136,975,137,975,138,975,139,975,140,975,141,975,142,975,143,975,144,975,145,975,146,975,147,975,148,975,149,975,150,975,151,975,152,975,153,975,154,975,155,975,156,975,157,975,158,975,159,975,160,975,161,975,162,975,163,975,164,975,165,975,166,975,167,975,168,975,169,975,170,975,171,975,172,975,173,975,174,975,175,975,176,975,177,975,178,975,179,975,180,971,181,971,182,969,183,969,184,969,185,969,186,507,187,507,204,533,205,533,206,533,207,533,208,992,209,992,210,992,211,992,212,325,213,325,214,325,215,325,216,325,217,325,218,1012,219,1012,220,1012,221,1012,222,715,223,715,224,455,225,455,},[153]={4,1014,5,1014,6,1014,7,1014,126,975,127,975,128,975,129,975,130,975,131,975,132,975,133,975,134,975,135,975,136,975,137,975,138,975,139,975,140,975,141,975,142,975,143,975,144,975,145,975,146,975,147,975,148,975,149,975,150,975,151,975,152,975,153,975,154,975,155,975,156,975,157,975,158,975,159,975,160,975,161,975,162,975,163,975,164,975,165,975,166,975,167,975,168,975,169,975,170,975,171,975,172,975,173,975,174,975,175,975,176,975,177,975,178,975,179,975,180,971,181,971,182,969,183,969,184,969,185,969,186,507,187,507,204,533,205,533,206,533,207,533,208,992,209,992,210,992,211,992,212,325,213,325,214,325,215,325,216,325,217,325,218,1012,219,1012,220,1012,221,1012,222,715,223,715,224,455,225,455,},[154]={4,1014,5,1014,6,1014,7,1014,124,975,125,975,126,975,127,975,128,975,129,975,204,1020,205,1020,206,1020,207,1020,208,996,209,996,210,996,211,996,212,325,213,325,214,325,215,325,216,325,217,325,218,1012,219,1012,220,1012,221,1012,222,716,223,716,224,455,225,455,226,455,227,455,},[155]={4,1014,5,1014,6,1014,7,1014,124,975,125,975,126,975,127,975,128,975,129,975,204,1020,205,1020,206,1020,207,1020,208,996,209,996,210,996,211,996,212,325,213,325,214,325,215,325,216,325,217,325,218,1012,219,1012,220,1012,221,1012,222,716,223,716,224,455,225,455,226,455,227,455,},[156]={4,1014,5,1014,6,1014,7,1014,122,975,123,975,124,975,125,975,126,975,127,975,204,1020,205,1020,206,1020,207,1020,208,1020,209,1020,210,325,211,325,212,325,213,325,214,325,215,325,216,325,217,325,218,1012,219,1012,220,1012,221,1012,222,725,223,725,224,455,225,455,226,455,227,455,240,455,241,455,242,455,243,455,},[157]={4,1014,5,1014,6,1014,7,1014,122,975,123,975,124,975,125,975,126,975,127,975,204,1020,205,1020,206,1020,207,1020,208,1020,209,1020,210,325,211,325,212,325,213,325,214,325,215,325,216,325,217,325,218,1012,219,1012,220,1012,221,1012,222,725,223,725,224,455,225,455,226,455,227,455,240,455,241,455,242,455,243,455,},[158]={4,1014,5,1014,6,1014,7,1014,120,975,121,975,122,975,123,975,124,975,125,975,204,1020,205,1020,206,1020,207,1020,208,325,209,325,210,325,211,325,212,325,213,325,214,325,215,325,216,325,217,325,218,1012,219,1012,220,1012,221,1012,222,716,223,716,224,455,225,455,226,455,227,455,240,455,241,455,242,455,243,455,},[159]={4,1014,5,1014,6,1014,7,1014,120,975,121,975,122,975,123,975,124,975,125,975,204,1020,205,1020,206,1020,207,1020,208,325,209,325,210,325,211,325,212,325,213,325,214,325,215,325,216,325,217,325,218,1012,219,1012,220,1012,221,1012,222,716,223,716,224,455,225,455,226,455,227,455,240,455,241,455,242,455,243,455,},[160]={4,1014,5,1014,6,1014,7,1014,118,975,119,975,120,975,121,975,122,975,123,975,204,1020,205,1020,206,1020,207,1020,208,325,209,325,210,325,211,325,212,325,213,325,214,325,215,325,216,325,217,325,218,1012,219,1012,220,1012,221,1012,222,716,223,716,224,455,225,455,226,455,227,455,},[161]={4,1014,5,1014,6,1014,7,1014,118,975,119,975,120,975,121,975,122,975,123,975,204,1020,205,1020,206,1020,207,1020,208,325,209,325,210,325,211,325,212,325,213,325,214,325,215,325,216,325,217,325,218,1012,219,1012,220,1012,221,1012,222,716,223,716,224,455,225,455,226,455,227,455,},[162]={4,1014,5,1014,6,1014,7,1014,116,975,117,975,118,975,119,975,120,975,121,975,204,1020,205,1020,206,1020,207,1020,208,325,209,325,210,325,211,325,212,325,213,325,214,325,215,325,216,325,217,325,218,1012,219,1012,220,1012,221,1012,222,715,223,715,224,455,225,455,},[163]={4,1014,5,1014,6,1014,7,1014,116,975,117,975,118,975,119,975,120,975,121,975,204,1020,205,1020,206,1020,207,1020,208,325,209,325,210,325,211,325,212,325,213,325,214,325,215,325,216,325,217,325,218,1012,219,1012,220,1012,221,1012,222,715,223,715,224,455,225,455,},[164]={4,1014,5,1014,6,1014,7,1014,114,975,115,975,116,975,117,975,118,975,119,975,204,1020,205,1020,206,1020,207,1020,208,325,209,325,210,325,211,325,212,325,213,325,214,325,215,325,216,325,217,325,218,1012,219,1012,220,1012,221,1012,222,715,223,715,224,455,225,455,},[165]={4,1014,5,1014,6,1014,7,1014,114,975,115,975,116,975,117,975,118,975,119,975,204,1020,205,1020,206,1020,207,1020,208,325,209,325,210,325,211,325,212,325,213,325,214,325,215,325,216,325,217,325,218,1012,219,1012,220,1012,221,1012,222,715,223,715,224,455,225,455,},[166]={4,1014,5,1014,6,1014,7,1014,112,975,113,975,114,975,115,975,116,975,117,975,204,1020,205,1020,206,1020,207,1020,208,325,209,325,210,325,211,325,212,325,213,325,214,325,215,325,216,325,217,325,218,1012,219,1012,220,1012,221,1012,222,715,223,715,224,455,225,455,},[167]={4,1014,5,1014,6,1014,7,1014,112,975,113,975,114,975,115,975,116,975,117,975,204,1020,205,1020,206,1020,207,1020,208,325,209,325,210,325,211,325,212,325,213,325,214,325,215,325,216,325,217,325,218,1012,219,1012,220,1012,221,1012,222,715,223,715,224,455,225,455,},[168]={4,1014,5,1014,6,1014,7,1014,110,975,111,975,112,975,113,975,114,975,115,975,204,1020,205,1020,206,1020,207,1020,208,325,209,325,210,325,211,325,212,325,213,325,214,325,215,325,216,325,217,325,218,1012,219,1012,220,1012,221,1012,222,715,223,715,224,455,225,455,},[169]={4,1014,5,1014,6,1014,7,1014,110,975,111,975,112,975,113,975,114,975,115,975,204,1020,205,1020,206,1020,207,1020,208,325,209,325,210,325,211,325,212,325,213,325,214,325,215,325,216,325,217,325,218,1012,219,1012,220,1012,221,1012,222,715,223,715,224,455,225,455,},[170]={4,1014,5,1014,6,1014,7,1014,108,975,109,975,110,975,111,975,112,975,113,975,204,1019,205,1019,206,1019,207,1019,208,325,209,325,210,325,211,325,212,325,213,325,214,325,215,325,216,325,217,325,218,1012,219,1012,220,1012,221,1012,222,715,223,715,224,455,225,455,},[171]={4,1014,5,1014,6,1014,7,1014,108,975,109,975,110,975,111,975,112,975,113,975,204,1019,205,1019,206,1019,207,1019,208,325,209,325,210,325,211,325,212,325,213,325,214,325,215,325,216,325,217,325,218,1012,219,1012,220,1012,221,1012,222,715,223,715,224,455,225,455,},[172]={4,1014,5,1014,6,1014,7,1014,106,975,107,975,108,975,109,975,110,975,111,975,204,1019,205,1019,206,1019,207,1019,208,325,209,325,210,325,211,325,212,325,213,325,214,325,215,325,216,325,217,325,218,1012,219,1012,220,1012,221,1012,222,715,223,715,224,455,225,455,},[173]={4,1014,5,1014,6,1014,7,1014,106,975,107,975,108,975,109,975,110,975,111,975,204,1019,205,1019,206,1019,207,1019,208,325,209,325,210,325,211,325,212,325,213,325,214,325,215,325,216,325,217,325,218,1012,219,1012,220,1012,221,1012,222,715,223,715,224,455,225,455,},[174]={4,1014,5,1014,6,1014,7,1014,104,975,105,975,106,975,107,975,108,975,109,975,204,1019,205,1019,206,1019,207,1019,208,325,209,325,210,325,211,325,212,325,213,325,214,325,215,325,216,325,217,325,218,1012,219,1012,220,1012,221,1012,222,715,223,715,224,455,225,455,},[175]={4,1014,5,1014,6,1014,7,1014,104,975,105,975,106,975,107,975,108,975,109,975,204,1019,205,1019,206,1019,207,1019,208,325,209,325,210,325,211,325,212,325,213,325,214,325,215,325,216,325,217,325,218,1012,219,1012,220,1012,221,1012,222,715,223,715,224,455,225,455,},[176]={4,1014,5,1014,6,1014,7,1014,102,975,103,975,104,975,105,975,106,975,107,975,164,39,165,39,166,52,167,52,168,39,169,39,170,26,171,26,204,1019,205,1019,206,1019,207,1019,208,325,209,325,210,325,211,325,212,325,213,325,214,325,215,325,216,325,217,325,218,1012,219,1012,220,1012,221,1012,222,715,223,715,224,455,225,455,},[177]={4,1014,5,1014,6,1014,7,1014,102,975,103,975,104,975,105,975,106,975,107,975,164,39,165,39,166,52,167,52,168,39,169,39,170,26,171,26,204,1019,205,1019,206,1019,207,1019,208,325,209,325,210,325,211,325,212,325,213,325,214,325,215,325,216,325,217,325,218,1012,219,1012,220,1012,221,1012,222,715,223,715,224,455,225,455,},[178]={4,1014,5,1014,6,1014,7,1014,100,975,101,975,102,975,103,975,104,975,105,975,162,2,163,2,164,54,165,54,166,71,167,71,168,71,169,71,170,32,171,32,172,6,173,6,204,1019,205,1019,206,1019,207,1019,208,325,209,325,210,325,211,325,212,325,213,325,214,325,215,325,216,325,217,325,218,1012,219,1012,220,1012,221,1012,222,715,223,715,224,455,225,455,},[179]={4,1014,5,1014,6,1014,7,1014,100,975,101,975,102,975,103,975,104,975,105,975,162,2,163,2,164,54,165,54,166,71,167,71,168,71,169,71,170,32,171,32,172,6,173,6,204,1019,205,1019,206,1019,207,1019,208,325,209,325,210,325,211,325,212,325,213,325,214,325,215,325,216,325,217,325,218,1012,219,1012,220,1012,221,1012,222,715,223,715,224,455,225,455,},[180]={4,1014,5,1014,6,1014,7,1014,98,975,99,975,100,975,101,975,102,975,103,975,162,2,163,2,164,54,165,54,166,71,167,71,168,71,169,71,170,56,171,56,172,4,173,4,204,1019,205,1019,206,1019,207,1019,208,325,209,325,210,325,211,325,212,325,213,325,214,325,215,325,216,325,217,325,218,1012,219,1012,220,1012,221,1012,222,715,223,715,224,455,225,455,},[181]={4,1014,5,1014,6,1014,7,1014,98,975,99,975,100,975,101,975,102,975,103,975,162,2,163,2,164,54,165,54,166,71,167,71,168,71,169,71,170,56,171,56,172,4,173,4,204,1019,205,1019,206,1019,207,1019,208,325,209,325,210,325,211,325,212,325,213,325,214,325,215,325,216,325,217,325,218,1012,219,1012,220,1012,221,1012,222,715,223,715,224,455,225,455,},[182]={4,1014,5,1014,6,1014,7,1014,96,975,97,975,98,975,99,975,100,975,101,975,128,1,129,1,130,487,131,487,132,487,133,487,134,487,135,487,136,487,137,487,138,487,139,487,140,487,141,487,142,487,143,487,144,487,145,487,146,487,147,487,148,487,149,487,150,487,151,487,152,487,153,487,154,487,155,487,156,487,157,487,158,487,159,487,160,487,161,487,162,487,163,487,164,487,165,487,166,487,167,487,168,487,169,487,170,487,171,487,172,487,173,487,174,487,175,487,176,487,177,487,178,487,179,487,180,487,181,487,182,487,183,487,184,487,185,487,186,1007,187,1007,188,1007,189,1007,190,474,191,474,192,474,193,474,194,474,195,474,196,474,197,474,198,474,199,474,200,474,201,474,202,474,203,474,204,1019,205,1019,206,1019,207,1019,208,325,209,325,210,325,211,325,212,325,213,325,214,325,215,325,216,325,217,325,218,1012,219,1012,220,1012,221,1012,222,707,223,707,224,429,225,429,},[183]={4,1014,5,1014,6,1014,7,1014,96,975,97,975,98,975,99,975,100,975,101,975,128,1,129,1,130,487,131,487,132,487,133,487,134,487,135,487,136,487,137,487,138,487,139,487,140,487,141,487,142,487,143,487,144,487,145,487,146,487,147,487,148,487,149,487,150,487,151,487,152,487,153,487,154,487,155,487,156,487,157,487,158,487,159,487,160,487,161,487,162,487,163,487,164,487,165,487,166,487,167,487,168,487,169,487,170,487,171,487,172,487,173,487,174,487,175,487,176,487,177,487,178,487,179,487,180,487,181,487,182,487,183,487,184,487,185,487,186,1007,187,1007,188,1007,189,1007,190,474,191,474,192,474,193,474,194,474,195,474,196,474,197,474,198,474,199,474,200,474,201,474,202,474,203,474,204,1019,205,1019,206,1019,207,1019,208,325,209,325,210,325,211,325,212,325,213,325,214,325,215,325,216,325,217,325,218,1012,219,1012,220,1012,221,1012,222,707,223,707,224,429,225,429,},[184]={4,1014,5,1014,6,1014,7,1014,94,975,95,975,96,975,97,975,98,975,99,975,128,1020,129,1020,130,1020,131,1020,132,1020,133,1020,134,487,135,487,136,487,137,487,138,487,139,487,140,487,141,487,142,487,143,487,144,487,145,487,146,487,147,487,148,487,149,487,150,487,151,487,152,487,153,487,154,487,155,487,156,487,157,487,158,487,159,487,160,487,161,487,162,487,163,487,164,487,165,487,166,487,167,487,168,487,169,487,170,487,171,487,172,487,173,487,174,487,175,487,176,487,177,487,178,487,179,487,180,487,181,487,182,487,183,487,184,487,185,487,186,1013,187,1013,188,1013,189,1013,190,474,191,474,192,474,193,474,194,474,195,474,196,474,197,474,198,474,199,474,200,474,201,474,202,474,203,474,204,1019,205,1019,206,1019,207,1019,208,325,209,325,210,325,211,325,212,325,213,325,214,325,215,325,216,325,217,325,218,1012,219,1012,220,1012,221,1012,222,699,223,699,224,429,225,429,226,429,227,429,},[185]={4,1014,5,1014,6,1014,7,1014,94,975,95,975,96,975,97,975,98,975,99,975,128,1020,129,1020,130,1020,131,1020,132,1020,133,1020,134,487,135,487,136,487,137,487,138,487,139,487,140,487,141,487,142,487,143,487,144,487,145,487,146,487,147,487,148,487,149,487,150,487,151,487,152,487,153,487,154,487,155,487,156,487,157,487,158,487,159,487,160,487,161,487,162,487,163,487,164,487,165,487,166,487,167,487,168,487,169,487,170,487,171,487,172,487,173,487,174,487,175,487,176,487,177,487,178,487,179,487,180,487,181,487,182,487,183,487,184,487,185,487,186,1013,187,1013,188,1013,189,1013,190,474,191,474,192,474,193,474,194,474,195,474,196,474,197,474,198,474,199,474,200,474,201,474,202,474,203,474,204,1019,205,1019,206,1019,207,1019,208,325,209,325,210,325,211,325,212,325,213,325,214,325,215,325,216,325,217,325,218,1012,219,1012,220,1012,221,1012,222,699,223,699,224,429,225,429,226,429,227,429,},[186]={4,1014,5,1014,6,1014,7,1014,92,975,93,975,94,975,95,975,96,975,97,975,126,1020,127,1020,128,1020,129,1020,130,1020,131,1020,132,1020,133,1020,134,1020,135,1020,136,1020,137,1020,138,1020,139,1020,140,1020,141,1020,142,1020,143,1020,144,1020,145,1020,146,1020,147,1020,148,1020,149,1020,150,1020,151,1020,152,1020,153,1020,154,1020,155,1020,156,1020,157,1020,158,1020,159,1020,160,1020,161,1020,162,1020,163,1020,164,1020,165,1020,166,1020,167,1020,168,1020,169,1020,170,1020,171,1020,172,1020,173,1020,174,1020,175,1020,176,1020,177,1020,178,1020,179,1020,180,1020,181,1020,182,1020,183,1020,184,1020,185,1020,186,1016,187,1016,188,1018,189,1018,190,1019,191,1019,192,1019,193,1019,194,1019,195,1019,196,1019,197,1019,198,1019,199,1019,200,1019,201,1019,202,1019,203,1019,204,1019,205,1019,206,1019,207,1019,208,325,209,325,210,325,211,325,212,325,213,325,214,325,215,325,216,325,217,325,218,1012,219,1012,220,1012,221,1012,222,708,223,708,224,429,225,429,226,429,227,429,240,455,241,455,242,455,243,455,},[187]={4,1014,5,1014,6,1014,7,1014,92,975,93,975,94,975,95,975,96,975,97,975,126,1020,127,1020,128,1020,129,1020,130,1020,131,1020,132,1020,133,1020,134,1020,135,1020,136,1020,137,1020,138,1020,139,1020,140,1020,141,1020,142,1020,143,1020,144,1020,145,1020,146,1020,147,1020,148,1020,149,1020,150,1020,151,1020,152,1020,153,1020,154,1020,155,1020,156,1020,157,1020,158,1020,159,1020,160,1020,161,1020,162,1020,163,1020,164,1020,165,1020,166,1020,167,1020,168,1020,169,1020,170,1020,171,1020,172,1020,173,1020,174,1020,175,1020,176,1020,177,1020,178,1020,179,1020,180,1020,181,1020,182,1020,183,1020,184,1020,185,1020,186,1016,187,1016,188,1018,189,1018,190,1019,191,1019,192,1019,193,1019,194,1019,195,1019,196,1019,197,1019,198,1019,199,1019,200,1019,201,1019,202,1019,203,1019,204,1019,205,1019,206,1019,207,1019,208,325,209,325,210,325,211,325,212,325,213,325,214,325,215,325,216,325,217,325,218,1012,219,1012,220,1012,221,1012,222,708,223,708,224,429,225,429,226,429,227,429,240,455,241,455,242,455,243,455,},[188]={4,1014,5,1014,6,1014,7,1014,90,975,91,975,92,975,93,975,94,975,95,975,124,1020,125,1020,126,1020,127,1020,128,1020,129,1020,130,1020,131,1020,132,1020,133,1020,134,1020,135,1020,136,1020,137,1020,138,1020,139,1020,140,1020,141,1020,142,1020,143,1020,144,1020,145,1020,146,1020,147,1020,148,1020,149,1020,150,1020,151,1020,152,1020,153,1020,154,1020,155,1020,156,1020,157,1020,158,1020,159,1020,160,1020,161,1020,162,1020,163,1020,164,1020,165,1020,166,1020,167,1020,168,1020,169,1020,170,1020,171,1020,172,1020,173,1020,174,1020,175,1020,176,1020,177,1020,178,1020,179,1020,180,1020,181,1020,182,1020,183,1020,184,1020,185,1020,186,1016,187,1016,188,1018,189,1018,190,1019,191,1019,192,1019,193,1019,194,1019,195,1019,196,1019,197,1019,198,1019,199,1019,200,1019,201,1019,202,1019,203,1019,204,1019,205,1019,206,1019,207,1019,208,325,209,325,210,325,211,325,212,325,213,325,214,325,215,325,216,325,217,325,218,1012,219,1012,220,1012,221,1012,222,699,223,699,224,429,225,429,226,429,227,429,240,455,241,455,242,455,243,455,},[189]={4,1014,5,1014,6,1014,7,1014,90,975,91,975,92,975,93,975,94,975,95,975,124,1020,125,1020,126,1020,127,1020,128,1020,129,1020,130,1020,131,1020,132,1020,133,1020,134,1020,135,1020,136,1020,137,1020,138,1020,139,1020,140,1020,141,1020,142,1020,143,1020,144,1020,145,1020,146,1020,147,1020,148,1020,149,1020,150,1020,151,1020,152,1020,153,1020,154,1020,155,1020,156,1020,157,1020,158,1020,159,1020,160,1020,161,1020,162,1020,163,1020,164,1020,165,1020,166,1020,167,1020,168,1020,169,1020,170,1020,171,1020,172,1020,173,1020,174,1020,175,1020,176,1020,177,1020,178,1020,179,1020,180,1020,181,1020,182,1020,183,1020,184,1020,185,1020,186,1016,187,1016,188,1018,189,1018,190,1019,191,1019,192,1019,193,1019,194,1019,195,1019,196,1019,197,1019,198,1019,199,1019,200,1019,201,1019,202,1019,203,1019,204,1019,205,1019,206,1019,207,1019,208,325,209,325,210,325,211,325,212,325,213,325,214,325,215,325,216,325,217,325,218,1012,219,1012,220,1012,221,1012,222,699,223,699,224,429,225,429,226,429,227,429,240,455,241,455,242,455,243,455,},[190]={4,1014,5,1014,6,1014,7,1014,88,975,89,975,90,975,91,975,92,975,93,975,122,1020,123,1020,124,1020,125,1020,126,1020,127,1020,128,1020,129,1020,130,1020,131,1020,132,1020,133,1020,134,1020,135,1020,136,1019,137,1019,138,1019,139,1019,140,1019,141,1019,142,1019,143,1019,144,1019,145,1019,146,1019,147,1019,148,1019,149,1019,150,1019,151,1019,152,1019,153,1019,154,1019,155,1019,156,1019,157,1019,158,1019,159,1019,160,1019,161,1019,162,1019,163,1019,164,1019,165,1019,166,1019,167,1019,168,1019,169,1019,170,1019,171,1019,172,1019,173,1019,174,1019,175,1019,176,1019,177,1019,178,1019,179,1019,180,1019,181,1019,182,1019,183,1019,184,1019,185,1019,186,1019,187,1019,188,1019,189,1019,190,1019,191,1019,192,1019,193,1019,194,1019,195,1019,196,325,197,325,198,325,199,325,200,325,201,325,202,325,203,325,204,325,205,325,206,325,207,325,208,325,209,325,210,325,211,325,212,325,213,325,214,325,215,325,216,325,217,325,218,1012,219,1012,220,1012,221,1012,222,699,223,699,224,429,225,429,226,429,227,429,},[191]={4,1014,5,1014,6,1014,7,1014,88,975,89,975,90,975,91,975,92,975,93,975,122,1020,123,1020,124,1020,125,1020,126,1020,127,1020,128,1020,129,1020,130,1020,131,1020,132,1020,133,1020,134,1020,135,1020,136,1019,137,1019,138,1019,139,1019,140,1019,141,1019,142,1019,143,1019,144,1019,145,1019,146,1019,147,1019,148,1019,149,1019,150,1019,151,1019,152,1019,153,1019,154,1019,155,1019,156,1019,157,1019,158,1019,159,1019,160,1019,161,1019,162,1019,163,1019,164,1019,165,1019,166,1019,167,1019,168,1019,169,1019,170,1019,171,1019,172,1019,173,1019,174,1019,175,1019,176,1019,177,1019,178,1019,179,1019,180,1019,181,1019,182,1019,183,1019,184,1019,185,1019,186,1019,187,1019,188,1019,189,1019,190,1019,191,1019,192,1019,193,1019,194,1019,195,1019,196,325,197,325,198,325,199,325,200,325,201,325,202,325,203,325,204,325,205,325,206,325,207,325,208,325,209,325,210,325,211,325,212,325,213,325,214,325,215,325,216,325,217,325,218,1012,219,1012,220,1012,221,1012,222,699,223,699,224,429,225,429,226,429,227,429,},[192]={4,1014,5,1014,6,1014,7,1014,86,975,87,975,88,975,89,975,90,975,91,975,120,1020,121,1020,122,1020,123,1020,124,1020,125,1020,126,1020,127,1020,128,1020,129,1020,130,1020,131,1020,132,1020,133,1020,134,1019,135,1019,136,1019,137,1019,138,1019,139,1019,140,1019,141,1019,142,1019,143,1019,144,1019,145,1019,146,1019,147,1019,148,1019,149,1019,150,1019,151,1019,152,1019,153,1019,154,1019,155,1019,156,1019,157,1019,158,1019,159,1019,160,1019,161,1019,162,1019,163,1019,164,1019,165,1019,166,1019,167,1019,168,1019,169,1019,170,1019,171,1019,172,1019,173,1019,174,1019,175,1019,176,1019,177,1019,178,1019,179,1019,180,1019,181,1019,182,1019,183,1019,184,1019,185,1019,186,1019,187,1019,188,1019,189,1019,190,1019,191,1019,192,1019,193,1019,194,1019,195,1019,196,325,197,325,198,325,199,325,200,325,201,325,202,325,203,325,204,325,205,325,206,325,207,325,208,325,209,325,210,325,211,325,212,325,213,325,214,325,215,325,216,325,217,325,218,1012,219,1012,220,1012,221,1012,222,689,223,689,224,429,225,429,},[193]={4,1014,5,1014,6,1014,7,1014,86,975,87,975,88,975,89,975,90,975,91,975,120,1020,121,1020,122,1020,123,1020,124,1020,125,1020,126,1020,127,1020,128,1020,129,1020,130,1020,131,1020,132,1020,133,1020,134,1019,135,1019,136,1019,137,1019,138,1019,139,1019,140,1019,141,1019,142,1019,143,1019,144,1019,145,1019,146,1019,147,1019,148,1019,149,1019,150,1019,151,1019,152,1019,153,1019,154,1019,155,1019,156,1019,157,1019,158,1019,159,1019,160,1019,161,1019,162,1019,163,1019,164,1019,165,1019,166,1019,167,1019,168,1019,169,1019,170,1019,171,1019,172,1019,173,1019,174,1019,175,1019,176,1019,177,1019,178,1019,179,1019,180,1019,181,1019,182,1019,183,1019,184,1019,185,1019,186,1019,187,1019,188,1019,189,1019,190,1019,191,1019,192,1019,193,1019,194,1019,195,1019,196,325,197,325,198,325,199,325,200,325,201,325,202,325,203,325,204,325,205,325,206,325,207,325,208,325,209,325,210,325,211,325,212,325,213,325,214,325,215,325,216,325,217,325,218,1012,219,1012,220,1012,221,1012,222,689,223,689,224,429,225,429,},[194]={4,1014,5,1014,6,1014,7,1014,84,975,85,975,86,975,87,975,88,975,89,975,118,1020,119,1020,120,1020,121,1020,122,1020,123,1020,124,1020,125,1020,126,1020,127,1020,128,1020,129,1020,130,1020,131,1020,132,1019,133,1019,134,1019,135,1019,136,1019,137,1019,138,565,139,565,140,565,141,565,142,565,143,565,144,565,145,565,146,565,147,565,148,565,149,565,150,565,151,565,152,565,153,565,154,565,155,565,156,565,157,565,158,565,159,565,160,565,161,565,162,565,163,565,164,565,165,565,166,565,167,565,168,565,169,565,170,565,171,565,172,565,173,565,174,565,175,565,176,565,177,565,178,565,179,565,180,565,181,565,182,565,183,565,184,565,185,565,186,565,187,565,188,565,189,565,190,565,191,565,192,1019,193,1019,194,1019,195,1019,196,325,197,325,198,325,199,325,200,325,201,325,202,325,203,325,204,325,205,325,206,325,207,325,208,325,209,325,210,325,211,325,212,325,213,325,214,325,215,325,216,325,217,325,218,1012,219,1012,220,1012,221,1012,222,689,223,689,224,429,225,429,},[195]={4,1014,5,1014,6,1014,7,1014,84,975,85,975,86,975,87,975,88,975,89,975,118,1020,119,1020,120,1020,121,1020,122,1020,123,1020,124,1020,125,1020,126,1020,127,1020,128,1020,129,1020,130,1020,131,1020,132,1019,133,1019,134,1019,135,1019,136,1019,137,1019,138,565,139,565,140,565,141,565,142,565,143,565,144,565,145,565,146,565,147,565,148,565,149,565,150,565,151,565,152,565,153,565,154,565,155,565,156,565,157,565,158,565,159,565,160,565,161,565,162,565,163,565,164,565,165,565,166,565,167,565,168,565,169,565,170,565,171,565,172,565,173,565,174,565,175,565,176,565,177,565,178,565,179,565,180,565,181,565,182,565,183,565,184,565,185,565,186,565,187,565,188,565,189,565,190,565,191,565,192,1019,193,1019,194,1019,195,1019,196,325,197,325,198,325,199,325,200,325,201,325,202,325,203,325,204,325,205,325,206,325,207,325,208,325,209,325,210,325,211,325,212,325,213,325,214,325,215,325,216,325,217,325,218,1012,219,1012,220,1012,221,1012,222,689,223,689,224,429,225,429,},[196]={4,1014,5,1014,6,1014,7,1014,82,975,83,975,84,975,85,975,86,975,87,975,116,1020,117,1020,118,1020,119,1020,120,1020,121,1020,122,1020,123,1020,124,1020,125,1020,126,1020,127,1020,128,1020,129,1020,130,1019,131,1019,132,1019,133,1019,134,1019,135,1019,136,565,137,565,138,565,139,565,140,565,141,565,142,565,143,565,144,565,145,565,146,565,147,565,148,565,149,565,150,565,151,565,152,565,153,565,154,565,155,565,156,565,157,565,158,565,159,565,160,565,161,565,162,565,163,565,164,565,165,565,166,565,167,565,168,565,169,565,170,565,171,565,172,565,173,565,174,565,175,565,176,565,177,565,178,565,179,565,180,565,181,565,182,565,183,565,184,565,185,565,186,565,187,565,188,565,189,565,190,565,191,565,192,1019,193,1019,194,1019,195,1019,196,325,197,325,198,325,199,325,200,325,201,325,202,325,203,325,204,325,205,325,206,325,207,325,208,325,209,325,210,325,211,325,212,325,213,325,214,325,215,325,216,325,217,325,218,1016,219,1016,220,1016,221,1016,222,689,223,689,224,429,225,429,},[197]={4,1014,5,1014,6,1014,7,1014,82,975,83,975,84,975,85,975,86,975,87,975,116,1020,117,1020,118,1020,119,1020,120,1020,121,1020,122,1020,123,1020,124,1020,125,1020,126,1020,127,1020,128,1020,129,1020,130,1019,131,1019,132,1019,133,1019,134,1019,135,1019,136,565,137,565,138,565,139,565,140,565,141,565,142,565,143,565,144,565,145,565,146,565,147,565,148,565,149,565,150,565,151,565,152,565,153,565,154,565,155,565,156,565,157,565,158,565,159,565,160,565,161,565,162,565,163,565,164,565,165,565,166,565,167,565,168,565,169,565,170,565,171,565,172,565,173,565,174,565,175,565,176,565,177,565,178,565,179,565,180,565,181,565,182,565,183,565,184,565,185,565,186,565,187,565,188,565,189,565,190,565,191,565,192,1019,193,1019,194,1019,195,1019,196,325,197,325,198,325,199,325,200,325,201,325,202,325,203,325,204,325,205,325,206,325,207,325,208,325,209,325,210,325,211,325,212,325,213,325,214,325,215,325,216,325,217,325,218,1016,219,1016,220,1016,221,1016,222,689,223,689,224,429,225,429,},[198]={4,1014,5,1014,6,1014,7,1014,82,975,83,975,84,975,85,975,114,1020,115,1020,116,1020,117,1020,118,1020,119,1020,120,1020,121,1020,122,1020,123,1020,124,1020,125,1020,126,1020,127,1020,128,1023,129,1023,130,1023,131,1023,132,1019,133,1019,134,565,135,565,136,565,137,565,138,565,139,565,140,565,141,565,142,565,143,565,144,565,145,565,146,565,147,565,148,565,149,565,150,565,151,565,152,565,153,565,154,565,155,565,156,565,157,565,158,565,159,565,160,565,161,565,162,565,163,565,164,565,165,565,166,565,167,565,168,565,169,565,170,565,171,565,172,565,173,565,174,565,175,565,176,565,177,565,178,565,179,565,180,565,181,565,182,565,183,565,184,565,185,565,186,565,187,565,188,565,189,565,190,565,191,565,192,1019,193,1019,194,1019,195,1019,196,325,197,325,198,325,199,325,200,325,201,325,202,325,203,325,204,325,205,325,206,325,207,325,208,325,209,325,210,325,211,325,212,325,213,325,214,325,215,325,216,1020,217,1020,218,1018,219,1018,220,1018,221,1018,222,689,223,689,224,429,225,429,},[199]={4,1014,5,1014,6,1014,7,1014,82,975,83,975,84,975,85,975,114,1020,115,1020,116,1020,117,1020,118,1020,119,1020,120,1020,121,1020,122,1020,123,1020,124,1020,125,1020,126,1020,127,1020,128,1023,129,1023,130,1023,131,1023,132,1019,133,1019,134,565,135,565,136,565,137,565,138,565,139,565,140,565,141,565,142,565,143,565,144,565,145,565,146,565,147,565,148,565,149,565,150,565,151,565,152,565,153,565,154,565,155,565,156,565,157,565,158,565,159,565,160,565,161,565,162,565,163,565,164,565,165,565,166,565,167,565,168,565,169,565,170,565,171,565,172,565,173,565,174,565,175,565,176,565,177,565,178,565,179,565,180,565,181,565,182,565,183,565,184,565,185,565,186,565,187,565,188,565,189,565,190,565,191,565,192,1019,193,1019,194,1019,195,1019,196,325,197,325,198,325,199,325,200,325,201,325,202,325,203,325,204,325,205,325,206,325,207,325,208,325,209,325,210,325,211,325,212,325,213,325,214,325,215,325,216,1020,217,1020,218,1018,219,1018,220,1018,221,1018,222,689,223,689,224,429,225,429,},[200]={4,1014,5,1014,6,1014,7,1014,82,975,83,975,84,975,85,975,112,1020,113,1020,114,1020,115,1020,116,1020,117,1020,118,1020,119,1020,120,1020,121,1020,122,1020,123,1020,124,1020,125,1020,126,1020,127,1020,128,1020,129,1020,130,1023,131,1023,132,565,133,565,134,565,135,565,136,565,137,565,138,565,139,565,140,565,141,565,142,565,143,565,144,565,145,565,146,565,147,565,148,565,149,565,150,565,151,565,152,565,153,565,154,565,155,565,156,565,157,565,158,565,159,565,160,565,161,565,162,565,163,565,164,565,165,565,166,565,167,565,168,565,169,565,170,565,171,565,172,565,173,565,174,565,175,565,176,565,177,565,178,565,179,565,180,565,181,565,182,565,183,565,184,565,185,565,186,565,187,565,188,565,189,565,190,565,191,565,192,1019,193,1019,194,1019,195,1019,196,1019,197,1019,198,325,199,325,200,325,201,325,202,325,203,325,204,325,205,325,206,325,207,325,208,325,209,325,210,325,211,325,212,325,213,325,214,1020,215,1020,216,1020,217,1020,218,1019,219,1019,220,1019,221,1019,222,689,223,689,224,429,225,429,},[201]={4,1014,5,1014,6,1014,7,1014,82,975,83,975,84,975,85,975,112,1020,113,1020,114,1020,115,1020,116,1020,117,1020,118,1020,119,1020,120,1020,121,1020,122,1020,123,1020,124,1020,125,1020,126,1020,127,1020,128,1020,129,1020,130,1023,131,1023,132,565,133,565,134,565,135,565,136,565,137,565,138,565,139,565,140,565,141,565,142,565,143,565,144,565,145,565,146,565,147,565,148,565,149,565,150,565,151,565,152,565,153,565,154,565,155,565,156,565,157,565,158,565,159,565,160,565,161,565,162,565,163,565,164,565,165,565,166,565,167,565,168,565,169,565,170,565,171,565,172,565,173,565,174,565,175,565,176,565,177,565,178,565,179,565,180,565,181,565,182,565,183,565,184,565,185,565,186,565,187,565,188,565,189,565,190,565,191,565,192,1019,193,1019,194,1019,195,1019,196,1019,197,1019,198,325,199,325,200,325,201,325,202,325,203,325,204,325,205,325,206,325,207,325,208,325,209,325,210,325,211,325,212,325,213,325,214,1020,215,1020,216,1020,217,1020,218,1019,219,1019,220,1019,221,1019,222,689,223,689,224,429,225,429,},[202]={4,1014,5,1014,6,1014,7,1014,82,975,83,975,84,975,85,975,110,1020,111,1020,112,1020,113,1020,114,1020,115,1020,116,1020,117,1020,118,1020,119,1020,120,1020,121,1020,122,1020,123,1020,124,1020,125,1020,126,1020,127,1020,128,1020,129,1020,130,565,131,565,132,565,133,565,134,565,135,565,136,565,137,565,138,565,139,565,194,1019,195,1019,196,1019,197,1019,198,1019,199,1019,200,1019,201,1019,202,1019,203,1019,204,1019,205,1019,206,1020,207,1020,208,1020,209,1020,210,1020,211,1020,212,1019,213,1019,214,1019,215,1019,216,1019,217,1019,218,1019,219,1019,220,1019,221,1019,222,695,223,695,224,429,225,429,},[203]={4,1014,5,1014,6,1014,7,1014,82,975,83,975,84,975,85,975,110,1020,111,1020,112,1020,113,1020,114,1020,115,1020,116,1020,117,1020,118,1020,119,1020,120,1020,121,1020,122,1020,123,1020,124,1020,125,1020,126,1020,127,1020,128,1020,129,1020,130,565,131,565,132,565,133,565,134,565,135,565,136,565,137,565,138,565,139,565,194,1019,195,1019,196,1019,197,1019,198,1019,199,1019,200,1019,201,1019,202,1019,203,1019,204,1019,205,1019,206,1020,207,1020,208,1020,209,1020,210,1020,211,1020,212,1019,213,1019,214,1019,215,1019,216,1019,217,1019,218,1019,219,1019,220,1019,221,1019,222,695,223,695,224,429,225,429,},[204]={2,1014,3,1014,4,1014,5,1014,6,1014,7,1014,82,975,83,975,84,975,85,975,110,1020,111,1020,112,1020,113,1020,114,1020,115,1020,116,1020,117,1020,118,1020,119,1020,120,1020,121,1020,122,1020,123,1020,124,1020,125,1020,126,1020,127,1020,128,565,129,565,130,565,131,565,132,565,133,565,134,565,135,565,136,565,137,565,196,1019,197,1019,198,1019,199,1019,200,1019,201,1019,202,1019,203,1019,204,1019,205,1019,206,1019,207,1019,208,1019,209,1019,210,1019,211,1019,212,1019,213,1019,214,1019,215,1019,216,1019,217,1019,218,1019,219,1019,220,1019,221,1019,222,695,223,695,},[205]={2,1014,3,1014,4,1014,5,1014,6,1014,7,1014,82,975,83,975,84,975,85,975,110,1020,111,1020,112,1020,113,1020,114,1020,115,1020,116,1020,117,1020,118,1020,119,1020,120,1020,121,1020,122,1020,123,1020,124,1020,125,1020,126,1020,127,1020,128,565,129,565,130,565,131,565,132,565,133,565,134,565,135,565,136,565,137,565,196,1019,197,1019,198,1019,199,1019,200,1019,201,1019,202,1019,203,1019,204,1019,205,1019,206,1019,207,1019,208,1019,209,1019,210,1019,211,1019,212,1019,213,1019,214,1019,215,1019,216,1019,217,1019,218,1019,219,1019,220,1019,221,1019,222,695,223,695,},[206]={0,1014,1,1014,2,1014,3,1014,4,1014,5,1014,82,975,83,975,84,975,85,975,110,565,111,565,112,565,113,565,114,1020,115,1020,116,1020,117,1020,118,1020,119,1020,120,1020,121,1020,122,1020,123,1020,124,1020,125,1020,126,565,127,565,128,565,129,565,130,565,131,565,132,565,133,565,134,565,135,565,198,678,199,678,200,678,201,678,202,1019,203,1019,204,1019,205,1019,206,1019,207,1019,208,1019,209,1019,210,1019,211,1019,212,1019,213,1019,214,1019,215,1019,216,678,217,678,218,678,219,678,220,601,221,601,},[207]={0,1014,1,1014,2,1014,3,1014,4,1014,5,1014,82,975,83,975,84,975,85,975,110,565,111,565,112,565,113,565,114,1020,115,1020,116,1020,117,1020,118,1020,119,1020,120,1020,121,1020,122,1020,123,1020,124,1020,125,1020,126,565,127,565,128,565,129,565,130,565,131,565,132,565,133,565,134,565,135,565,198,678,199,678,200,678,201,678,202,1019,203,1019,204,1019,205,1019,206,1019,207,1019,208,1019,209,1019,210,1019,211,1019,212,1019,213,1019,214,1019,215,1019,216,678,217,678,218,678,219,678,220,601,221,601,},[208]={0,1014,1,1014,2,1014,3,1014,78,975,79,975,80,975,81,975,82,975,83,975,84,975,85,975,110,565,111,565,112,565,113,565,114,1020,115,1020,116,1020,117,1020,118,1020,119,1020,120,1020,121,1020,122,1020,123,1020,124,565,125,565,126,565,127,565,128,565,129,565,130,565,131,565,132,565,133,565,200,678,201,678,202,678,203,678,204,678,205,678,206,678,207,678,208,678,209,678,210,678,211,678,212,678,213,678,214,678,215,678,216,678,217,678,218,678,219,678,254,1014,255,1014,},[209]={0,1014,1,1014,2,1014,3,1014,78,975,79,975,80,975,81,975,82,975,83,975,84,975,85,975,110,565,111,565,112,565,113,565,114,1020,115,1020,116,1020,117,1020,118,1020,119,1020,120,1020,121,1020,122,1020,123,1020,124,565,125,565,126,565,127,565,128,565,129,565,130,565,131,565,132,565,133,565,200,678,201,678,202,678,203,678,204,678,205,678,206,678,207,678,208,678,209,678,210,678,211,678,212,678,213,678,214,678,215,678,216,678,217,678,218,678,219,678,254,1014,255,1014,},[210]={0,1014,1,1014,78,975,79,975,80,975,81,975,82,975,83,975,84,975,85,975,110,565,111,565,112,565,113,565,114,1020,115,1020,116,1020,117,1020,118,1020,119,1020,120,1020,121,1020,122,565,123,565,124,565,125,565,126,565,127,565,128,565,129,565,130,565,131,565,202,678,203,678,204,678,205,678,206,678,207,678,208,678,209,678,210,678,211,678,212,678,213,678,214,678,215,678,216,678,217,678,252,1014,253,1014,254,1014,255,1014,},[211]={0,1014,1,1014,78,975,79,975,80,975,81,975,82,975,83,975,84,975,85,975,110,565,111,565,112,565,113,565,114,1020,115,1020,116,1020,117,1020,118,1020,119,1020,120,1020,121,1020,122,565,123,565,124,565,125,565,126,565,127,565,128,565,129,565,130,565,131,565,202,678,203,678,204,678,205,678,206,678,207,678,208,678,209,678,210,678,211,678,212,678,213,678,214,678,215,678,216,678,217,678,252,1014,253,1014,254,1014,255,1014,},[212]={78,975,79,975,80,975,81,975,82,565,83,565,84,565,85,565,110,565,111,565,112,565,113,565,114,1020,115,1020,116,1020,117,1020,118,1020,119,1020,120,1020,121,1020,122,565,123,565,124,565,125,565,126,565,127,565,128,565,129,565,250,1014,251,1014,252,1014,253,1014,254,1014,255,1014,},[213]={78,975,79,975,80,975,81,975,82,565,83,565,84,565,85,565,110,565,111,565,112,565,113,565,114,1020,115,1020,116,1020,117,1020,118,1020,119,1020,120,1020,121,1020,122,565,123,565,124,565,125,565,126,565,127,565,128,565,129,565,250,1014,251,1014,252,1014,253,1014,254,1014,255,1014,},[214]={78,975,79,975,80,975,81,975,82,565,83,565,84,565,85,565,96,565,97,565,98,565,99,565,110,565,111,565,112,565,113,565,114,1020,115,1020,116,1020,117,1020,118,1020,119,1020,120,1020,121,1020,122,565,123,565,124,565,125,565,126,565,127,565,128,565,129,565,250,1014,251,1014,252,1014,253,1014,},[215]={78,975,79,975,80,975,81,975,82,565,83,565,84,565,85,565,96,565,97,565,98,565,99,565,110,565,111,565,112,565,113,565,114,1020,115,1020,116,1020,117,1020,118,1020,119,1020,120,1020,121,1020,122,565,123,565,124,565,125,565,126,565,127,565,128,565,129,565,250,1014,251,1014,252,1014,253,1014,},[216]={78,975,79,975,80,975,81,975,82,565,83,565,84,565,85,565,96,565,97,565,98,565,99,565,110,565,111,565,112,565,113,565,114,1020,115,1020,116,1020,117,1020,118,1020,119,1020,120,1020,121,1020,122,565,123,565,124,565,125,565,126,565,127,565,128,565,129,565,250,1014,251,1014,252,1014,253,1014,},[217]={78,975,79,975,80,975,81,975,82,565,83,565,84,565,85,565,96,565,97,565,98,565,99,565,110,565,111,565,112,565,113,565,114,1020,115,1020,116,1020,117,1020,118,1020,119,1020,120,1020,121,1020,122,565,123,565,124,565,125,565,126,565,127,565,128,565,129,565,250,1014,251,1014,252,1014,253,1014,},[218]={78,975,79,975,80,975,81,975,82,565,83,565,84,565,85,565,110,565,111,565,112,565,113,565,114,1020,115,1020,116,1020,117,1020,118,1020,119,1020,120,1020,121,1020,122,565,123,565,124,565,125,565,126,565,127,565,128,565,129,565,250,1014,251,1014,252,1014,253,1014,},[219]={78,975,79,975,80,975,81,975,82,565,83,565,84,565,85,565,110,565,111,565,112,565,113,565,114,1020,115,1020,116,1020,117,1020,118,1020,119,1020,120,1020,121,1020,122,565,123,565,124,565,125,565,126,565,127,565,128,565,129,565,250,1014,251,1014,252,1014,253,1014,},[220]={78,975,79,975,80,975,81,975,82,975,83,975,84,975,85,975,110,565,111,565,112,565,113,565,114,1020,115,1020,116,1020,117,1020,118,1020,119,1020,120,1020,121,1020,122,565,123,565,124,565,125,565,126,565,127,565,128,565,129,565,250,1014,251,1014,252,1014,253,1014,},[221]={78,975,79,975,80,975,81,975,82,975,83,975,84,975,85,975,110,565,111,565,112,565,113,565,114,1020,115,1020,116,1020,117,1020,118,1020,119,1020,120,1020,121,1020,122,565,123,565,124,565,125,565,126,565,127,565,128,565,129,565,250,1014,251,1014,252,1014,253,1014,},[222]={78,975,79,975,80,975,81,975,82,975,83,975,84,975,85,975,110,565,111,565,112,565,113,565,114,1020,115,1020,116,1020,117,1020,118,1020,119,1020,120,1020,121,1020,122,565,123,565,124,565,125,565,126,565,127,565,128,565,129,565,204,678,205,678,206,678,207,678,208,678,209,678,210,678,211,678,212,678,213,678,214,678,215,678,216,678,217,678,218,678,219,678,220,678,221,678,222,678,223,678,224,678,225,678,250,1014,251,1014,252,1014,253,1014,},[223]={78,975,79,975,80,975,81,975,82,975,83,975,84,975,85,975,110,565,111,565,112,565,113,565,114,1020,115,1020,116,1020,117,1020,118,1020,119,1020,120,1020,121,1020,122,565,123,565,124,565,125,565,126,565,127,565,128,565,129,565,204,678,205,678,206,678,207,678,208,678,209,678,210,678,211,678,212,678,213,678,214,678,215,678,216,678,217,678,218,678,219,678,220,678,221,678,222,678,223,678,224,678,225,678,250,1014,251,1014,252,1014,253,1014,},[224]={82,975,83,975,84,975,85,975,110,565,111,565,112,565,113,565,114,1020,115,1020,116,1020,117,1020,118,1020,119,1020,120,1020,121,1020,122,565,123,565,124,565,125,565,126,565,127,565,128,565,129,565,204,678,205,678,206,678,207,678,208,678,209,678,210,678,211,678,212,678,213,678,214,678,215,678,216,678,217,678,218,678,219,678,220,678,221,678,222,678,223,678,224,678,225,678,226,678,227,678,250,1014,251,1014,252,1014,253,1014,},[225]={82,975,83,975,84,975,85,975,110,565,111,565,112,565,113,565,114,1020,115,1020,116,1020,117,1020,118,1020,119,1020,120,1020,121,1020,122,565,123,565,124,565,125,565,126,565,127,565,128,565,129,565,204,678,205,678,206,678,207,678,208,678,209,678,210,678,211,678,212,678,213,678,214,678,215,678,216,678,217,678,218,678,219,678,220,678,221,678,222,678,223,678,224,678,225,678,226,678,227,678,250,1014,251,1014,252,1014,253,1014,},[226]={82,975,83,975,84,975,85,975,110,565,111,565,112,565,113,565,114,1020,115,1020,116,1020,117,1020,118,1020,119,1020,120,1020,121,1020,122,565,123,565,124,565,125,565,126,565,127,565,128,565,129,565,204,678,205,678,206,678,207,678,208,1003,209,1003,210,1003,211,1003,212,1003,213,1003,214,1003,215,1003,216,1003,217,1003,218,1003,219,1003,220,1003,221,1003,222,1003,223,1003,224,678,225,678,226,678,227,678,228,678,229,678,250,1014,251,1014,252,1014,253,1014,},[227]={82,975,83,975,84,975,85,975,110,565,111,565,112,565,113,565,114,1020,115,1020,116,1020,117,1020,118,1020,119,1020,120,1020,121,1020,122,565,123,565,124,565,125,565,126,565,127,565,128,565,129,565,204,678,205,678,206,678,207,678,208,1003,209,1003,210,1003,211,1003,212,1003,213,1003,214,1003,215,1003,216,1003,217,1003,218,1003,219,1003,220,1003,221,1003,222,1003,223,1003,224,678,225,678,226,678,227,678,228,678,229,678,250,1014,251,1014,252,1014,253,1014,},[228]={82,975,83,975,84,975,85,975,110,565,111,565,112,565,113,565,114,1020,115,1020,116,1020,117,1020,118,1020,119,1020,120,1020,121,1020,122,565,123,565,124,565,125,565,126,565,127,565,128,565,129,565,164,378,165,378,166,477,167,477,168,477,169,477,170,351,171,351,204,678,205,678,206,678,207,678,208,1003,209,1003,210,1003,211,1003,212,1003,213,1003,214,1003,215,1003,216,1003,217,1003,218,1003,219,1003,220,1003,221,1003,222,1003,223,1003,224,1003,225,1003,226,678,227,678,228,678,229,678,250,1014,251,1014,252,1014,253,1014,},[229]={82,975,83,975,84,975,85,975,110,565,111,565,112,565,113,565,114,1020,115,1020,116,1020,117,1020,118,1020,119,1020,120,1020,121,1020,122,565,123,565,124,565,125,565,126,565,127,565,128,565,129,565,164,378,165,378,166,477,167,477,168,477,169,477,170,351,171,351,204,678,205,678,206,678,207,678,208,1003,209,1003,210,1003,211,1003,212,1003,213,1003,214,1003,215,1003,216,1003,217,1003,218,1003,219,1003,220,1003,221,1003,222,1003,223,1003,224,1003,225,1003,226,678,227,678,228,678,229,678,250,1014,251,1014,252,1014,253,1014,},[230]={82,975,83,975,84,975,85,975,110,565,111,565,112,565,113,565,114,1020,115,1020,116,1020,117,1020,118,1020,119,1020,120,1020,121,1020,122,565,123,565,124,565,125,565,126,565,127,565,128,565,129,565,162,488,163,488,164,614,165,614,166,695,167,695,168,695,169,695,170,632,171,632,172,497,173,497,204,678,205,678,206,678,207,678,208,1003,209,1003,210,1003,211,1003,222,1003,223,1003,224,1003,225,1003,226,678,227,678,228,678,229,678,250,1014,251,1014,252,1014,253,1014,},[231]={82,975,83,975,84,975,85,975,110,565,111,565,112,565,113,565,114,1020,115,1020,116,1020,117,1020,118,1020,119,1020,120,1020,121,1020,122,565,123,565,124,565,125,565,126,565,127,565,128,565,129,565,162,488,163,488,164,614,165,614,166,695,167,695,168,695,169,695,170,632,171,632,172,497,173,497,204,678,205,678,206,678,207,678,208,1003,209,1003,210,1003,211,1003,222,1003,223,1003,224,1003,225,1003,226,678,227,678,228,678,229,678,250,1014,251,1014,252,1014,253,1014,},[232]={82,975,83,975,84,975,85,975,110,565,111,565,112,565,113,565,114,1020,115,1020,116,1020,117,1020,118,1020,119,1020,120,1020,121,1020,122,565,123,565,124,565,125,565,126,565,127,565,128,565,129,565,160,441,161,441,162,668,163,668,164,731,165,731,166,742,167,742,168,731,169,731,170,695,171,695,172,632,173,632,174,351,175,351,204,678,205,678,206,678,207,678,208,1003,209,1003,210,1003,211,1003,222,1003,223,1003,224,1003,225,1003,226,678,227,678,228,678,229,678,250,1014,251,1014,252,1014,253,1014,},[233]={82,975,83,975,84,975,85,975,110,565,111,565,112,565,113,565,114,1020,115,1020,116,1020,117,1020,118,1020,119,1020,120,1020,121,1020,122,565,123,565,124,565,125,565,126,565,127,565,128,565,129,565,160,441,161,441,162,668,163,668,164,731,165,731,166,742,167,742,168,731,169,731,170,695,171,695,172,632,173,632,174,351,175,351,204,678,205,678,206,678,207,678,208,1003,209,1003,210,1003,211,1003,222,1003,223,1003,224,1003,225,1003,226,678,227,678,228,678,229,678,250,1014,251,1014,252,1014,253,1014,},[234]={82,975,83,975,84,975,85,975,110,565,111,565,112,565,113,565,114,1020,115,1020,116,1020,117,1020,118,1020,119,1020,120,1020,121,1020,122,565,123,565,124,565,125,565,126,565,127,565,128,565,129,565,160,504,161,504,162,704,163,704,164,724,165,724,166,607,167,607,168,607,169,607,170,731,171,731,172,677,173,677,174,468,175,468,204,678,205,678,206,678,207,678,208,1003,209,1003,210,1003,211,1003,222,1003,223,1003,224,1003,225,1003,226,678,227,678,228,678,229,678,250,1014,251,1014,252,1014,253,1014,},[235]={82,975,83,975,84,975,85,975,110,565,111,565,112,565,113,565,114,1020,115,1020,116,1020,117,1020,118,1020,119,1020,120,1020,121,1020,122,565,123,565,124,565,125,565,126,565,127,565,128,565,129,565,160,504,161,504,162,704,163,704,164,724,165,724,166,607,167,607,168,607,169,607,170,731,171,731,172,677,173,677,174,468,175,468,204,678,205,678,206,678,207,678,208,1003,209,1003,210,1003,211,1003,222,1003,223,1003,224,1003,225,1003,226,678,227,678,228,678,229,678,250,1014,251,1014,252,1014,253,1014,},[236]={78,975,79,975,80,975,81,975,82,975,83,975,84,975,85,975,110,565,111,565,112,565,113,565,114,1020,115,1020,116,1020,117,1020,118,1020,119,1020,120,1020,121,1020,122,565,123,565,124,565,125,565,126,565,127,565,128,565,129,565,160,504,161,504,162,704,163,704,164,733,165,733,166,607,167,607,168,607,169,607,170,722,171,722,172,677,173,677,174,468,175,468,204,678,205,678,206,678,207,678,208,1003,209,1003,210,1003,211,1003,222,1003,223,1003,224,1003,225,1003,226,678,227,678,228,678,229,678,250,1014,251,1014,252,1014,253,1014,},[237]={78,975,79,975,80,975,81,975,82,975,83,975,84,975,85,975,110,565,111,565,112,565,113,565,114,1020,115,1020,116,1020,117,1020,118,1020,119,1020,120,1020,121,1020,122,565,123,565,124,565,125,565,126,565,127,565,128,565,129,565,160,504,161,504,162,704,163,704,164,733,165,733,166,607,167,607,168,607,169,607,170,722,171,722,172,677,173,677,174,468,175,468,204,678,205,678,206,678,207,678,208,1003,209,1003,210,1003,211,1003,222,1003,223,1003,224,1003,225,1003,226,678,227,678,228,678,229,678,250,1014,251,1014,252,1014,253,1014,},[238]={78,975,79,975,80,975,81,975,82,975,83,975,84,975,85,975,110,565,111,565,112,565,113,565,114,1020,115,1020,116,1020,117,1020,118,1020,119,1020,120,1020,121,1020,122,565,123,565,124,565,125,565,126,565,127,565,128,565,129,565,160,423,161,423,162,605,163,605,164,731,165,731,166,742,167,742,168,740,169,740,170,722,171,722,172,641,173,641,174,378,175,378,204,678,205,678,206,678,207,678,208,1003,209,1003,210,1003,211,1003,222,1003,223,1003,224,1003,225,1003,226,678,227,678,228,678,229,678,250,1014,251,1014,252,1014,253,1014,},[239]={78,975,79,975,80,975,81,975,82,975,83,975,84,975,85,975,110,565,111,565,112,565,113,565,114,1020,115,1020,116,1020,117,1020,118,1020,119,1020,120,1020,121,1020,122,565,123,565,124,565,125,565,126,565,127,565,128,565,129,565,160,423,161,423,162,605,163,605,164,731,165,731,166,742,167,742,168,740,169,740,170,722,171,722,172,641,173,641,174,378,175,378,204,678,205,678,206,678,207,678,208,1003,209,1003,210,1003,211,1003,222,1003,223,1003,224,1003,225,1003,226,678,227,678,228,678,229,678,250,1014,251,1014,252,1014,253,1014,},[240]={78,975,79,975,80,975,81,975,82,565,83,565,84,565,85,565,110,565,111,565,112,565,113,565,114,1020,115,1020,116,1020,117,1020,118,1020,119,1020,120,1020,121,1020,122,565,123,565,124,565,125,565,126,565,127,565,128,565,129,565,162,479,163,479,164,650,165,650,166,686,167,686,168,686,169,686,170,641,171,641,172,497,173,497,204,678,205,678,206,678,207,678,208,1003,209,1003,210,1003,211,1003,222,1003,223,1003,224,1003,225,1003,226,678,227,678,228,678,229,678,250,1014,251,1014,252,1014,253,1014,},[241]={78,975,79,975,80,975,81,975,82,565,83,565,84,565,85,565,110,565,111,565,112,565,113,565,114,1020,115,1020,116,1020,117,1020,118,1020,119,1020,120,1020,121,1020,122,565,123,565,124,565,125,565,126,565,127,565,128,565,129,565,162,479,163,479,164,650,165,650,166,686,167,686,168,686,169,686,170,641,171,641,172,497,173,497,204,678,205,678,206,678,207,678,208,1003,209,1003,210,1003,211,1003,222,1003,223,1003,224,1003,225,1003,226,678,227,678,228,678,229,678,250,1014,251,1014,252,1014,253,1014,},[242]={78,975,79,975,80,975,81,975,82,565,83,565,84,565,85,565,96,565,97,565,98,565,99,565,110,565,111,565,112,565,113,565,114,1020,115,1020,116,1020,117,1020,118,1020,119,1020,120,1020,121,1020,122,565,123,565,124,565,125,565,126,565,127,565,128,565,129,565,164,360,165,360,166,504,167,504,168,504,169,504,170,333,171,333,204,678,205,678,206,678,207,678,208,1003,209,1003,210,1003,211,1003,222,1003,223,1003,224,1003,225,1003,226,678,227,678,228,678,229,678,250,1014,251,1014,252,1014,253,1014,},[243]={78,975,79,975,80,975,81,975,82,565,83,565,84,565,85,565,96,565,97,565,98,565,99,565,110,565,111,565,112,565,113,565,114,1020,115,1020,116,1020,117,1020,118,1020,119,1020,120,1020,121,1020,122,565,123,565,124,565,125,565,126,565,127,565,128,565,129,565,164,360,165,360,166,504,167,504,168,504,169,504,170,333,171,333,204,678,205,678,206,678,207,678,208,1003,209,1003,210,1003,211,1003,222,1003,223,1003,224,1003,225,1003,226,678,227,678,228,678,229,678,250,1014,251,1014,252,1014,253,1014,},[244]={78,975,79,975,80,975,81,975,82,565,83,565,84,565,85,565,96,565,97,565,98,565,99,565,110,565,111,565,112,565,113,565,114,1020,115,1020,116,1020,117,1020,118,1020,119,1020,120,1020,121,1020,122,565,123,565,124,565,125,565,126,565,127,565,128,565,129,565,204,678,205,678,206,678,207,678,208,1003,209,1003,210,1003,211,1003,222,1003,223,1003,224,1003,225,1003,226,678,227,678,228,678,229,678,250,1014,251,1014,252,1014,253,1014,},[245]={78,975,79,975,80,975,81,975,82,565,83,565,84,565,85,565,96,565,97,565,98,565,99,565,110,565,111,565,112,565,113,565,114,1020,115,1020,116,1020,117,1020,118,1020,119,1020,120,1020,121,1020,122,565,123,565,124,565,125,565,126,565,127,565,128,565,129,565,204,678,205,678,206,678,207,678,208,1003,209,1003,210,1003,211,1003,222,1003,223,1003,224,1003,225,1003,226,678,227,678,228,678,229,678,250,1014,251,1014,252,1014,253,1014,},[246]={78,975,79,975,80,975,81,975,82,565,83,565,84,565,85,565,110,565,111,565,112,565,113,565,114,1020,115,1020,116,1020,117,1020,118,1020,119,1020,120,1020,121,1020,122,565,123,565,124,565,125,565,126,565,127,565,128,565,129,565,204,678,205,678,206,678,207,678,208,1003,209,1003,210,1003,211,1003,222,1003,223,1003,224,1003,225,1003,226,678,227,678,228,678,229,678,250,1014,251,1014,252,1014,253,1014,},[247]={78,975,79,975,80,975,81,975,82,565,83,565,84,565,85,565,110,565,111,565,112,565,113,565,114,1020,115,1020,116,1020,117,1020,118,1020,119,1020,120,1020,121,1020,122,565,123,565,124,565,125,565,126,565,127,565,128,565,129,565,204,678,205,678,206,678,207,678,208,1003,209,1003,210,1003,211,1003,222,1003,223,1003,224,1003,225,1003,226,678,227,678,228,678,229,678,250,1014,251,1014,252,1014,253,1014,},[248]={78,975,79,975,80,975,81,975,82,975,83,975,84,975,85,975,110,565,111,565,112,565,113,565,114,1020,115,1020,116,1020,117,1020,118,1020,119,1020,120,1020,121,1020,122,565,123,565,124,565,125,565,126,565,127,565,128,565,129,565,204,678,205,678,206,678,207,678,208,1003,209,1003,210,1003,211,1003,222,1003,223,1003,224,1003,225,1003,226,678,227,678,228,678,229,678,250,1014,251,1014,252,1014,253,1014,},[249]={78,975,79,975,80,975,81,975,82,975,83,975,84,975,85,975,110,565,111,565,112,565,113,565,114,1020,115,1020,116,1020,117,1020,118,1020,119,1020,120,1020,121,1020,122,565,123,565,124,565,125,565,126,565,127,565,128,565,129,565,204,678,205,678,206,678,207,678,208,1003,209,1003,210,1003,211,1003,222,1003,223,1003,224,1003,225,1003,226,678,227,678,228,678,229,678,250,1014,251,1014,252,1014,253,1014,},[250]={78,975,79,975,80,975,81,975,82,975,83,975,84,975,85,975,110,565,111,565,112,565,113,565,114,1020,115,1020,116,1020,117,1020,118,1020,119,1020,120,1020,121,1020,122,565,123,565,124,565,125,565,126,565,127,565,128,565,129,565,204,678,205,678,206,678,207,678,208,1003,209,1003,210,1003,211,1003,222,1003,223,1003,224,1003,225,1003,226,678,227,678,228,678,229,678,250,1014,251,1014,252,1014,253,1014,},[251]={78,975,79,975,80,975,81,975,82,975,83,975,84,975,85,975,110,565,111,565,112,565,113,565,114,1020,115,1020,116,1020,117,1020,118,1020,119,1020,120,1020,121,1020,122,565,123,565,124,565,125,565,126,565,127,565,128,565,129,565,204,678,205,678,206,678,207,678,208,1003,209,1003,210,1003,211,1003,222,1003,223,1003,224,1003,225,1003,226,678,227,678,228,678,229,678,250,1014,251,1014,252,1014,253,1014,},[252]={82,975,83,975,84,975,85,975,110,565,111,565,112,565,113,565,114,1020,115,1020,116,1020,117,1020,118,1020,119,1020,120,1020,121,1020,122,565,123,565,124,565,125,565,126,565,127,565,128,565,129,565,204,678,205,678,206,678,207,678,208,1003,209,1003,210,1003,211,1003,212,1003,213,1003,220,1003,221,1003,222,1003,223,1003,224,1003,225,1003,226,678,227,678,228,678,229,678,250,1014,251,1014,252,1014,253,1014,},[253]={82,975,83,975,84,975,85,975,110,565,111,565,112,565,113,565,114,1020,115,1020,116,1020,117,1020,118,1020,119,1020,120,1020,121,1020,122,565,123,565,124,565,125,565,126,565,127,565,128,565,129,565,204,678,205,678,206,678,207,678,208,1003,209,1003,210,1003,211,1003,212,1003,213,1003,220,1003,221,1003,222,1003,223,1003,224,1003,225,1003,226,678,227,678,228,678,229,678,250,1014,251,1014,252,1014,253,1014,},[254]={82,975,83,975,84,975,85,975,110,565,111,565,112,565,113,565,114,1020,115,1020,116,1020,117,1020,118,1020,119,1020,120,1020,121,1020,122,1020,123,1020,124,1020,125,1020,126,1020,127,1020,128,565,129,565,204,678,205,678,206,678,207,678,208,678,209,678,210,1003,211,1003,212,1003,213,1003,214,1003,215,1003,216,1003,217,1003,218,1003,219,1003,220,1003,221,1003,222,1003,223,1003,224,1003,225,1003,226,678,227,678,228,678,229,678,250,1014,251,1014,252,1014,253,1014,},[255]={82,975,83,975,84,975,85,975,110,565,111,565,112,565,113,565,114,1020,115,1020,116,1020,117,1020,118,1020,119,1020,120,1020,121,1020,122,1020,123,1020,124,1020,125,1020,126,1020,127,1020,128,565,129,565,204,678,205,678,206,678,207,678,208,678,209,678,210,1003,211,1003,212,1003,213,1003,214,1003,215,1003,216,1003,217,1003,218,1003,219,1003,220,1003,221,1003,222,1003,223,1003,224,1003,225,1003,226,678,227,678,228,678,229,678,250,1014,251,1014,252,1014,253,1014,}
		},
		
		markers ={
			96, 74, 92, 74, 100, 74, 96, 146, 100, 146, 92, 146, 170, 166, 164, 166, 158, 166, 10, 216, 14, 216, 18, 216, 10, 118, 14, 118, 18, 118, 106, 32, 104, 32, 102, 32, 100, 32, 92, 32, 90, 32, 88, 32, 86, 32, 86, 248, 106, 248, 108, 42, 84, 42, 92, 192, 96, 26, 98, 4, 136, 48, 128, 48, 96, 36, 96, 6, 96, 22, 192, 104, 230, 96, 166, 128, 212, 190, 14, 152, 208, 208, 222, 208, 214, 96, 214, 110, 242, 96, 242, 82, 28, 166, 0, 166, 234, 166, 38, 36, 32, 36, 26, 36, 20, 36, 44, 36, 206, 166, 208, 166, 210, 166, 164, 242, 170, 242, 176, 242, 14, 180, 0, 0, 234, 156, 244, 166, 234, 176, 224, 166, 242, 158, 242, 174, 226, 174, 226, 158, 
		},
		
		objects = {
			[0]={82,5,9,-1,1024,114,5,9,-1,1792,116,5,9,-1,1536,118,5,9,-1,1536,120,5,9,-1,1536,122,5,9,-1,1536,250,5,9,-1,0,},[2]={82,5,9,-1,1024,250,5,9,-1,0,},[4]={82,5,9,-1,1024,250,5,9,-1,0,},[6]={82,5,9,-1,1024,250,5,9,-1,0,},[8]={82,5,9,-1,1024,250,5,9,-1,0,},[10]={82,5,9,-1,1024,250,5,9,-1,0,},[12]={82,5,9,-1,1024,250,5,9,-1,0,},[14]={82,5,9,-1,1024,250,5,9,-1,0,},[16]={82,5,9,-1,768,250,5,9,-1,0,},[18]={84,5,9,-1,768,248,5,9,-1,256,},[20]={86,5,9,-1,768,246,5,9,-1,256,},[22]={88,5,9,-1,768,244,5,9,-1,256,},[24]={90,5,9,-1,768,242,5,9,-1,256,},[26]={92,5,9,-1,768,240,5,9,-1,256,},[28]={94,5,9,-1,768,96,5,9,-1,512,98,5,9,-1,512,100,5,9,-1,512,102,5,9,-1,512,104,5,9,-1,512,106,5,9,-1,512,108,5,9,-1,512,110,5,9,-1,512,112,5,9,-1,512,114,5,9,-1,512,116,5,9,-1,512,118,5,9,-1,512,120,5,9,-1,512,122,5,9,-1,512,124,5,9,-1,512,126,5,9,-1,512,128,5,9,-1,512,130,5,9,-1,512,132,5,9,-1,512,134,5,9,-1,512,136,5,9,-1,512,138,5,9,-1,512,140,5,9,-1,512,142,5,9,-1,512,144,5,9,-1,512,146,5,9,-1,512,148,5,9,-1,512,150,5,9,-1,512,152,5,9,-1,512,154,5,9,-1,512,156,5,9,-1,512,158,5,9,-1,512,174,5,9,-1,512,176,5,9,-1,512,178,5,9,-1,512,180,5,9,-1,512,182,5,9,-1,512,184,5,9,-1,512,186,5,9,-1,512,188,5,9,-1,512,190,5,9,-1,512,192,5,9,-1,512,194,5,9,-1,512,196,5,9,-1,512,198,5,9,-1,512,200,5,9,-1,512,202,5,9,-1,512,204,5,9,-1,512,206,5,9,-1,512,208,5,9,-1,512,210,5,9,-1,512,212,5,9,-1,512,214,5,9,-1,512,216,5,9,-1,512,218,5,9,-1,512,220,5,9,-1,512,222,5,9,-1,512,224,5,9,-1,512,226,5,9,-1,512,228,5,9,-1,512,230,5,9,-1,512,232,5,9,-1,512,234,5,9,-1,512,236,5,9,-1,512,238,5,9,-1,512,},[30]={158,5,9,-1,1024,164,5,1,-1,0,168,5,1,-1,0,174,5,9,-1,0,},[32]={158,5,9,-1,1024,174,5,9,-1,0,},[34]={158,5,9,-1,768,160,5,9,-1,512,162,5,9,-1,512,164,5,9,-1,512,166,5,9,-1,512,168,5,9,-1,512,170,5,9,-1,512,172,5,9,-1,512,174,5,9,-1,256,},[80]={0,5,9,-1,1536,2,5,9,-1,1536,4,5,9,-1,1536,6,5,9,-1,1536,8,5,9,-1,1536,10,5,9,-1,1536,12,5,9,-1,1536,14,5,9,-1,1536,16,5,9,-1,1536,18,5,9,-1,1536,20,5,9,-1,1536,22,5,9,-1,1536,24,5,9,-1,1536,26,5,9,-1,1536,28,5,9,-1,1536,30,5,9,-1,1536,32,5,9,-1,1536,34,5,9,-1,1536,36,5,9,-1,1536,38,5,9,-1,1536,40,5,9,-1,1536,42,5,9,-1,1536,44,5,9,-1,1536,46,5,9,-1,1536,48,5,9,-1,1536,50,5,9,-1,1536,52,5,9,-1,1536,54,5,9,-1,1536,56,5,9,-1,1536,58,5,9,-1,1536,60,5,9,-1,1536,62,5,9,-1,1536,64,5,9,-1,1536,66,5,9,-1,1536,68,5,9,-1,1536,70,5,9,-1,1536,72,5,9,-1,1536,74,5,9,-1,1536,76,5,9,-1,1536,78,5,9,-1,1536,80,5,9,-1,1536,82,5,9,-1,1536,84,5,9,-1,1536,86,5,9,-1,1536,88,5,9,-1,1536,90,5,9,-1,1536,92,5,9,-1,1536,94,5,9,-1,1536,96,5,9,-1,1536,98,5,9,-1,1536,100,5,9,-1,1536,102,5,9,-1,1536,104,5,9,-1,1536,106,5,9,-1,1536,108,5,9,-1,1536,110,5,9,-1,1536,112,5,9,-1,1536,114,5,9,-1,1536,116,5,9,-1,1536,118,5,9,-1,1536,120,5,9,-1,1536,122,5,9,-1,1536,124,5,9,-1,1536,126,5,9,-1,1536,128,5,9,-1,1536,130,5,9,-1,1536,132,5,9,-1,1536,134,5,9,-1,1536,136,5,9,-1,1536,138,5,9,-1,1536,140,5,9,-1,1536,142,5,9,-1,1536,144,5,9,-1,1536,146,5,9,-1,1536,148,5,9,-1,1536,150,5,9,-1,1536,152,5,9,-1,1536,154,5,9,-1,1536,156,5,9,-1,1536,158,5,9,-1,1536,160,5,9,-1,1536,162,5,9,-1,1536,164,5,9,-1,1536,166,5,9,-1,1536,168,5,9,-1,1536,170,5,9,-1,1536,172,5,9,-1,1536,174,5,9,-1,1536,176,5,9,-1,1536,178,5,9,-1,1536,180,5,9,-1,1536,182,5,9,-1,1536,184,5,9,-1,1536,186,5,9,-1,1536,188,5,9,-1,1536,190,5,9,-1,1536,192,5,9,-1,1536,230,5,9,-1,1536,232,5,9,-1,1536,234,5,9,-1,1536,236,5,9,-1,1536,238,5,9,-1,1536,240,5,9,-1,1536,242,5,9,-1,1536,244,5,9,-1,1536,246,5,9,-1,1536,248,5,9,-1,1536,250,5,9,-1,1536,252,5,9,-1,1536,254,5,9,-1,1536,},[82]={12,5,9,-1,0,194,5,9,-1,1792,228,5,9,-1,1280,},[84]={8,5,2,-1,1792,12,5,9,-1,0,16,5,2,-1,1024,28,5,18,-1,1024,44,7,85,-1,0,72,5,1,-1,0,76,5,1,-1,0,144,5,1,-1,0,148,5,1,-1,0,196,5,9,-1,1792,226,5,9,-1,1280,248,7,85,-1,0,},[86]={12,5,9,-1,0,198,5,9,-1,1792,224,5,9,-1,1280,},[88]={12,5,9,-1,0,44,7,85,-1,0,200,5,9,-1,1792,222,5,9,-1,1280,248,7,85,-1,0,},[90]={4,5,18,-1,0,8,5,18,-1,0,12,5,9,-1,0,202,5,9,-1,1792,220,5,9,-1,1280,},[92]={12,5,9,-1,0,44,7,85,-1,0,204,5,9,-1,1792,206,5,9,-1,1536,208,5,9,-1,1536,210,5,9,-1,1536,212,5,9,-1,1536,214,5,9,-1,1536,216,5,9,-1,1536,218,5,9,-1,1024,248,7,85,-1,0,},[94]={12,5,9,-1,0,204,5,9,-1,0,218,5,9,-1,1024,},[96]={12,5,9,-1,0,44,7,85,-1,0,204,5,9,-1,0,218,5,9,-1,1024,248,7,85,-1,0,},[98]={12,5,9,-1,0,204,5,9,-1,0,218,5,9,-1,1024,},[100]={4,5,18,-1,0,8,5,18,-1,0,12,5,9,-1,0,44,7,85,-1,0,204,5,9,-1,0,218,5,9,-1,1024,248,7,85,-1,0,},[102]={12,5,9,-1,0,204,5,9,-1,0,218,5,9,-1,1024,},[104]={12,5,9,-1,0,44,7,85,-1,0,204,5,9,-1,0,218,5,9,-1,1024,248,7,85,-1,0,},[106]={12,5,9,-1,0,204,5,9,-1,0,218,5,9,-1,1024,},[108]={8,5,2,-1,0,12,5,9,-1,0,16,5,2,-1,0,28,5,18,-1,0,44,7,85,-1,0,72,5,1,-1,0,76,5,1,-1,0,144,5,1,-1,0,148,5,1,-1,0,204,5,9,-1,0,218,5,9,-1,1024,248,7,85,-1,0,},[110]={12,5,9,-1,0,204,5,9,-1,0,218,5,9,-1,1024,},[112]={0,5,9,-1,512,2,5,9,-1,512,4,5,9,-1,512,6,5,9,-1,512,8,5,9,-1,512,10,5,9,-1,512,12,5,9,-1,512,14,5,9,-1,512,16,5,9,-1,512,18,5,9,-1,512,20,5,9,-1,512,22,5,9,-1,512,24,5,9,-1,512,26,5,9,-1,512,28,5,9,-1,512,30,5,9,-1,512,32,5,9,-1,512,34,5,9,-1,512,36,5,9,-1,512,38,5,9,-1,512,40,5,9,-1,512,42,5,9,-1,512,44,5,9,-1,512,46,5,9,-1,512,48,5,9,-1,512,50,5,9,-1,512,52,5,9,-1,512,54,5,9,-1,512,56,5,9,-1,512,58,5,9,-1,512,60,5,9,-1,512,62,5,9,-1,512,64,5,9,-1,512,66,5,9,-1,512,68,5,9,-1,512,70,5,9,-1,512,72,5,9,-1,512,74,5,9,-1,512,76,5,9,-1,512,78,5,9,-1,512,80,5,9,-1,512,82,5,9,-1,512,84,5,9,-1,512,86,5,9,-1,512,88,5,9,-1,512,90,5,9,-1,512,92,5,9,-1,512,94,5,9,-1,512,96,5,9,-1,512,98,5,9,-1,512,100,5,9,-1,512,102,5,9,-1,512,104,5,9,-1,512,106,5,9,-1,512,108,5,9,-1,512,110,5,9,-1,512,112,5,9,-1,512,114,5,9,-1,512,116,5,9,-1,512,118,5,9,-1,512,120,5,9,-1,512,122,5,9,-1,512,124,5,9,-1,512,126,5,9,-1,512,128,5,9,-1,512,130,5,9,-1,512,132,5,9,-1,512,134,5,9,-1,512,136,5,9,-1,512,138,5,9,-1,512,140,5,9,-1,512,142,5,9,-1,512,144,5,9,-1,512,146,5,9,-1,512,148,5,9,-1,512,150,5,9,-1,512,152,5,9,-1,512,154,5,9,-1,512,156,5,9,-1,512,158,5,9,-1,512,160,5,9,-1,512,162,5,9,-1,512,164,5,9,-1,512,166,5,9,-1,512,168,5,9,-1,512,170,5,9,-1,512,172,5,9,-1,512,174,5,9,-1,512,176,5,9,-1,512,178,5,9,-1,512,180,5,9,-1,512,204,5,9,-1,0,218,5,9,-1,1024,242,5,9,-1,512,244,5,9,-1,512,246,5,9,-1,512,248,5,9,-1,512,250,5,9,-1,512,252,5,9,-1,512,254,5,9,-1,512,},[114]={182,5,9,-1,1024,206,5,9,-1,1792,218,5,9,-1,1024,240,5,9,-1,256,},[116]={182,5,9,-1,1024,208,5,9,-1,0,218,5,9,-1,1024,238,5,9,-1,256,},[118]={182,5,9,-1,1024,208,5,9,-1,0,218,5,9,-1,1024,238,5,9,-1,0,},[120]={182,5,9,-1,1024,208,5,9,-1,0,218,5,9,-1,1024,238,5,9,-1,0,},[122]={182,5,9,-1,1024,208,5,9,-1,0,218,5,9,-1,1024,238,5,9,-1,0,},[124]={182,5,9,-1,1024,208,5,9,-1,0,218,5,9,-1,1024,240,5,9,-1,1792,},[126]={182,5,9,-1,1024,208,5,9,-1,0,218,5,9,-1,1024,242,5,9,-1,1792,},[128]={182,5,9,-1,1024,208,5,9,-1,0,218,5,9,-1,1024,244,5,9,-1,1792,246,5,9,-1,1536,248,5,9,-1,1792,},[130]={182,5,9,-1,1024,208,5,9,-1,0,218,5,9,-1,1024,250,5,9,-1,1792,},[132]={182,5,9,-1,1024,208,5,9,-1,0,218,5,9,-1,1024,252,5,9,-1,1792,},[134]={182,5,9,-1,1024,208,5,9,-1,0,218,5,9,-1,1024,254,5,9,-1,1792,},[136]={0,5,9,-1,1792,182,5,9,-1,1024,208,5,9,-1,0,218,5,9,-1,1024,},[138]={2,5,9,-1,1792,182,5,9,-1,1024,208,5,9,-1,0,218,5,9,-1,1024,},[140]={4,5,9,-1,0,182,5,9,-1,1024,208,5,9,-1,0,218,5,9,-1,1024,},[142]={4,5,9,-1,0,182,5,9,-1,1024,208,5,9,-1,0,218,5,9,-1,1024,},[144]={4,5,9,-1,0,182,5,9,-1,1024,208,5,9,-1,0,218,5,9,-1,1024,},[146]={4,5,9,-1,0,182,5,9,-1,1024,208,5,9,-1,0,218,5,9,-1,1024,222,5,3,-1,1792,},[148]={4,5,9,-1,0,182,5,9,-1,1024,208,5,9,-1,0,218,5,9,-1,1024,},[150]={4,5,9,-1,0,128,5,9,-1,1536,130,5,9,-1,1536,132,5,9,-1,1536,134,5,9,-1,1536,136,5,9,-1,1536,138,5,9,-1,1536,140,5,9,-1,1536,142,5,9,-1,1536,144,5,9,-1,1536,146,5,9,-1,1536,148,5,9,-1,1536,150,5,9,-1,1536,152,5,9,-1,1536,154,5,9,-1,1536,156,5,9,-1,1536,158,5,9,-1,1536,160,5,9,-1,1536,162,5,9,-1,1536,164,5,9,-1,1536,166,5,9,-1,1536,168,5,9,-1,1536,170,5,9,-1,1536,172,5,9,-1,1536,174,5,9,-1,1536,176,5,9,-1,1536,178,5,9,-1,1536,180,5,9,-1,1536,182,5,9,-1,1280,208,5,9,-1,0,218,5,9,-1,1024,},[152]={4,5,9,-1,0,126,5,9,-1,1280,208,5,9,-1,0,218,5,9,-1,1024,},[154]={4,5,9,-1,0,124,5,9,-1,1280,204,5,9,-1,0,206,5,9,-1,512,218,5,9,-1,1024,},[156]={4,5,9,-1,0,122,5,9,-1,1280,204,5,9,-1,0,218,5,9,-1,1024,228,7,10,-1,0,230,7,10,-1,0,232,7,10,-1,0,234,7,10,-1,0,236,7,10,-1,0,240,5,18,-1,1024,},[158]={4,5,9,-1,0,120,5,9,-1,1280,204,5,9,-1,0,218,5,9,-1,1024,},[160]={4,5,9,-1,0,118,5,9,-1,1280,204,5,9,-1,0,218,5,9,-1,1024,},[162]={4,5,9,-1,0,116,5,9,-1,1280,204,5,9,-1,0,218,5,9,-1,1024,},[164]={4,5,9,-1,0,114,5,9,-1,1280,204,5,9,-1,0,218,5,9,-1,1024,},[166]={4,5,9,-1,0,112,5,9,-1,1280,204,5,9,-1,0,218,5,9,-1,1024,222,5,3,-1,1792,},[168]={4,5,9,-1,0,110,5,9,-1,1280,204,5,9,-1,0,218,5,9,-1,1024,},[170]={4,5,9,-1,0,108,5,9,-1,1280,204,5,9,-1,0,218,5,9,-1,1024,},[172]={4,5,9,-1,0,106,5,9,-1,1280,204,5,9,-1,0,218,5,9,-1,1024,},[174]={4,5,9,-1,0,104,5,9,-1,1280,204,5,9,-1,0,218,5,9,-1,1024,},[176]={4,5,9,-1,0,102,5,9,-1,1280,162,7,18,-1,0,166,7,18,-1,0,170,7,18,-1,0,204,5,9,-1,0,218,5,9,-1,1024,222,5,3,-1,1792,},[178]={4,5,9,-1,0,100,5,9,-1,1280,162,5,2,-1,1024,170,5,2,-1,1536,204,5,9,-1,0,218,5,9,-1,1024,},[180]={4,5,9,-1,0,98,5,9,-1,1280,204,5,9,-1,0,218,5,9,-1,1024,},[182]={4,5,9,-1,0,96,5,9,-1,1280,136,5,1,-1,0,140,5,1,-1,0,144,5,1,-1,0,148,5,1,-1,0,152,5,1,-1,0,156,5,1,-1,0,160,5,1,-1,0,164,5,1,-1,0,168,5,1,-1,0,172,5,1,-1,0,176,5,1,-1,0,180,5,1,-1,0,186,5,9,-1,512,204,5,9,-1,0,218,5,9,-1,1024,},[184]={4,5,9,-1,0,94,5,9,-1,1280,128,5,9,-1,512,130,5,9,-1,512,186,5,9,-1,512,204,5,9,-1,0,218,5,9,-1,1024,},[186]={4,5,9,-1,0,92,5,9,-1,1280,126,5,9,-1,256,128,5,9,-1,256,130,5,9,-1,768,132,5,9,-1,512,134,5,9,-1,512,136,5,9,-1,512,138,5,9,-1,512,140,5,9,-1,512,142,5,9,-1,512,144,5,9,-1,512,146,5,9,-1,512,148,5,9,-1,512,150,5,9,-1,512,152,5,9,-1,512,154,5,9,-1,512,156,5,9,-1,512,158,5,9,-1,512,160,5,9,-1,512,162,5,9,-1,512,164,5,9,-1,512,166,5,9,-1,512,168,5,9,-1,512,170,5,9,-1,512,172,5,9,-1,512,174,5,9,-1,512,176,5,9,-1,512,178,5,9,-1,512,180,5,9,-1,512,182,5,9,-1,512,184,5,9,-1,512,186,5,9,-1,512,188,5,9,-1,512,190,5,9,-1,512,192,5,9,-1,512,194,5,9,-1,512,196,5,9,-1,512,198,5,9,-1,512,200,5,9,-1,512,202,5,9,-1,512,204,5,9,-1,256,218,5,9,-1,1024,228,7,10,-1,0,230,7,10,-1,0,232,7,10,-1,0,234,7,10,-1,0,236,7,10,-1,0,240,5,18,-1,0,},[188]={4,5,9,-1,0,90,5,9,-1,1280,124,5,9,-1,256,126,5,9,-1,256,218,5,9,-1,1024,},[190]={4,5,9,-1,0,88,5,9,-1,1280,122,5,9,-1,256,124,5,9,-1,256,134,5,9,-1,1280,136,5,9,-1,1536,138,5,9,-1,1536,140,5,9,-1,1536,142,5,9,-1,1536,144,5,9,-1,1536,146,5,9,-1,1536,148,5,9,-1,1536,150,5,9,-1,1536,152,5,9,-1,1536,154,5,9,-1,1536,156,5,9,-1,1536,158,5,9,-1,1536,160,5,9,-1,1536,162,5,9,-1,1536,164,5,9,-1,1536,166,5,9,-1,1536,168,5,9,-1,1536,170,5,9,-1,1536,172,5,9,-1,1536,174,5,9,-1,1536,176,5,9,-1,1536,178,5,9,-1,1536,180,5,9,-1,1536,182,5,9,-1,1536,184,5,9,-1,1536,186,5,9,-1,1536,188,5,9,-1,1536,190,5,9,-1,1536,192,5,9,-1,1792,218,5,9,-1,1024,},[192]={4,5,9,-1,0,86,5,9,-1,1280,120,5,9,-1,256,122,5,9,-1,256,132,5,9,-1,1280,134,5,9,-1,1280,192,5,9,-1,0,218,5,9,-1,1024,},[194]={4,5,9,-1,0,84,5,9,-1,1280,118,5,9,-1,256,120,5,9,-1,256,130,5,9,-1,1280,132,5,9,-1,1280,192,5,9,-1,0,218,5,9,-1,1024,},[196]={4,5,9,-1,0,82,5,9,-1,1024,116,5,9,-1,256,118,5,9,-1,256,128,5,9,-1,1280,130,5,9,-1,1280,192,5,9,-1,0,218,5,9,-1,1024,222,5,3,-1,1792,},[198]={4,5,9,-1,0,82,5,9,-1,1024,114,5,9,-1,256,116,5,9,-1,256,126,5,9,-1,1280,128,5,9,-1,1280,192,5,9,-1,0,218,5,9,-1,1024,},[200]={4,5,9,-1,0,82,5,9,-1,1024,112,5,9,-1,256,114,5,9,-1,256,124,5,9,-1,1280,126,5,9,-1,1280,194,5,9,-1,1792,218,5,9,-1,1024,},[202]={4,5,9,-1,0,82,5,9,-1,1024,110,5,9,-1,0,112,5,9,-1,256,114,5,9,-1,0,122,5,9,-1,1280,124,5,9,-1,1280,196,5,9,-1,1792,198,5,9,-1,1536,200,5,9,-1,1536,202,5,9,-1,1792,212,5,9,-1,1280,214,5,9,-1,1536,216,5,9,-1,1536,218,5,9,-1,1280,},[204]={2,5,9,-1,256,82,5,9,-1,1024,114,5,9,-1,0,120,5,9,-1,1280,122,5,9,-1,1280,202,5,9,-1,1536,204,5,9,-1,1536,206,5,9,-1,1536,208,5,9,-1,1536,210,5,9,-1,1536,212,5,9,-1,1536,},[206]={0,5,9,-1,256,82,5,9,-1,1024,110,5,18,-1,1024,114,5,9,-1,0,118,5,9,-1,1280,120,5,9,-1,1280,},[208]={78,5,9,-1,1280,80,5,9,-1,1536,82,5,9,-1,1024,114,5,9,-1,0,118,5,9,-1,1024,254,5,9,-1,256,},[210]={78,5,9,-1,1024,110,5,8,-1,0,114,5,9,-1,0,118,5,9,-1,1024,252,5,9,-1,256,},[212]={78,5,9,-1,1024,114,5,9,-1,0,118,5,9,-1,1024,250,5,9,-1,256,},[214]={78,5,9,-1,1024,82,5,2,-1,0,110,5,1,-1,0,114,5,9,-1,0,118,5,9,-1,1024,250,5,9,-1,0,},[216]={78,5,9,-1,1024,114,5,9,-1,0,118,5,9,-1,1024,250,5,9,-1,0,},[218]={78,5,9,-1,1024,110,5,8,-1,0,114,5,9,-1,0,118,5,9,-1,1024,250,5,9,-1,0,},[220]={78,5,9,-1,768,80,5,9,-1,512,82,5,9,-1,1024,114,5,9,-1,0,118,5,9,-1,1024,250,5,9,-1,0,},[222]={82,5,9,-1,1024,114,5,9,-1,0,118,5,9,-1,1024,250,5,9,-1,0,},[224]={82,5,9,-1,1024,110,5,18,-1,0,114,5,9,-1,0,118,5,9,-1,1024,250,5,9,-1,0,},[226]={82,5,9,-1,1024,114,5,9,-1,0,118,5,9,-1,1024,204,5,2,-1,0,208,5,9,-1,256,210,5,9,-1,512,212,5,9,-1,512,214,5,9,-1,512,216,5,9,-1,512,218,5,9,-1,512,220,5,9,-1,512,250,5,9,-1,0,},[228]={82,5,9,-1,1024,114,5,9,-1,0,118,5,9,-1,1024,208,5,9,-1,0,222,5,9,-1,768,226,5,1,-1,0,250,5,9,-1,0,},[230]={82,5,9,-1,1024,114,5,9,-1,0,118,5,9,-1,1024,208,5,9,-1,0,222,5,9,-1,1024,250,5,9,-1,0,},[232]={82,5,9,-1,1024,114,5,9,-1,0,118,5,9,-1,1024,208,5,9,-1,0,222,5,9,-1,1024,250,5,9,-1,0,},[234]={82,5,9,-1,1024,110,5,18,-1,1024,114,5,9,-1,0,118,5,9,-1,1024,204,5,2,-1,512,208,5,9,-1,0,222,5,9,-1,1024,250,5,9,-1,0,},[236]={78,5,9,-1,1280,80,5,9,-1,1536,82,5,9,-1,1024,114,5,9,-1,0,118,5,9,-1,1024,208,5,9,-1,0,222,5,9,-1,1024,226,5,1,-1,0,250,5,9,-1,0,},[238]={78,5,9,-1,1024,110,5,8,-1,0,114,5,9,-1,0,118,5,9,-1,1024,208,5,9,-1,0,222,5,9,-1,1024,250,5,9,-1,0,},[240]={78,5,9,-1,1024,114,5,9,-1,0,118,5,9,-1,1024,208,5,9,-1,0,222,5,9,-1,1024,250,5,9,-1,0,},[242]={78,5,9,-1,1024,82,5,2,-1,0,110,5,1,-1,0,114,5,9,-1,0,118,5,9,-1,1024,204,5,2,-1,1024,208,5,9,-1,0,222,5,9,-1,1024,250,5,9,-1,0,},[244]={78,5,9,-1,1024,114,5,9,-1,0,118,5,9,-1,1024,208,5,9,-1,0,222,5,9,-1,1024,226,5,1,-1,0,250,5,9,-1,0,},[246]={78,5,9,-1,1024,110,5,8,-1,0,114,5,9,-1,0,118,5,9,-1,1024,208,5,9,-1,0,222,5,9,-1,1024,250,5,9,-1,0,},[248]={78,5,9,-1,768,80,5,9,-1,512,82,5,9,-1,1024,114,5,9,-1,0,118,5,9,-1,1024,208,5,9,-1,0,222,5,9,-1,1024,250,5,9,-1,0,},[250]={82,5,9,-1,1024,110,5,18,-1,512,114,5,9,-1,0,118,5,9,-1,1024,204,5,2,-1,1536,208,5,9,-1,1792,222,5,9,-1,1024,250,5,9,-1,0,},[252]={82,5,9,-1,1024,114,5,9,-1,0,118,5,9,-1,1024,210,5,9,-1,1792,222,5,9,-1,1280,226,5,1,-1,0,250,5,9,-1,0,},[254]={82,5,9,-1,1024,114,5,9,-1,0,118,5,9,-1,768,120,5,9,-1,512,122,5,9,-1,512,124,5,9,-1,1024,212,5,9,-1,1536,214,5,9,-1,1536,216,5,9,-1,1536,218,5,9,-1,1536,220,5,9,-1,1280,250,5,9,-1,0,}
		},
		
		decorations = {
			82,44,1,6, 110,44,1,2, 82,248,1,6, 110,248,1,2, 108,68,2,2, 108,80,2,2, 84,68,2,6, 84,80,2,6, 108,140,2,2, 108,152,2,2, 84,140,2,6, 84,152,2,6, 118,186,2,4, 148,186,2,4, 118,204,2,0, 150,204,2,0, 182,198,7,0, 182,192,7,0, 178,166,3,2, 214,96,8,0, 242,96,8,0, 14,166,8,6, 0,166,8,6, 244,124,9,0, 236,124,12,0, 228,124,11,0, 220,124,10,0, 212,124,9,0, 204,128,12,1, 198,134,11,1, 196,142,10,2, 196,150,9,2, 196,158,12,2, 196,166,11,2, 196,174,10,2, 196,182,9,2, 186,224,3,4, 156,224,3,4
		},
		
		shaman_positions = {
			96, 22, 96, 22, 96, 22, 96, 22, 96, 22, 96, 22, 96, 22, 96, 22
		},
		
		scripts = {
			OnTurn = function(everySecond1, everySecond2, everySecond4) 			boat_race_3_on_turn(everySecond1, everySecond2, everySecond4) end,
			OnCreateThing = function(t, owner, type, model) 						boat_race_on_create_thing(t, owner, type, model) end,
			OnHumanDisconnect = function(player) 									boat_race_init_single_AI(player) end,
			OnPlayerPoints = function(player, awarded, old_pts, new_pts)			BR3_on_lap_finished(player, awarded, old_pts, new_pts) end,
		},
		
	},
	
	[MAP_LUCK_OF_THE_DRAW]={
	
		info = 	{ 	name = "Luck of the Draw", author = "MrKosjaK",
					desc = "Avoid the lightning bolts and earn points by remaining within the colored zones. <br> The closer to the centre, the more you earn. However, the storm worsens the deeper you get. <p> Smoke effects predict lightning bolts, so avoid such locations!",
					map_objectives = { {value=5, step=1, default=false}, {value=20000, limit = 50000, step=2500, default=true}, {} },
					image = 2960, texture={6, 2}, zoom={80,44,1024 + 512+256}, drop_infos = true,	marker_lb={194, 190}, reinc_timer=2, shield_respawn=true,
				},

		land ={
			[6]={30,5,31,5,32,7,33,7,34,10,35,10,36,16,37,16,38,23,39,23,40,26,41,26,42,27,43,27,44,20,45,20,46,11,47,11,48,8,49,8,50,8,51,8,52,10,53,10,54,14,55,14,56,15,57,15,58,13,59,13,60,9,61,9,62,10,63,10,64,13,65,13,66,15,67,15,68,14,69,14,70,11,71,11,72,11,73,11,74,14,75,14,76,16,77,16,78,15,79,15,80,12,81,12,82,10,83,10,84,9,85,9,86,8,87,8,88,7,89,7,90,7,91,7,92,7,93,7,94,7,95,7,96,7,97,7,98,8,99,8,100,8,101,8,102,8,103,8,104,8,105,8,106,14,107,14,108,23,109,23,110,25,111,25,112,23,113,23,114,22,115,22,116,21,117,21,118,20,119,20,120,13,121,13,},[7]={30,5,31,5,32,7,33,7,34,10,35,10,36,16,37,16,38,23,39,23,40,26,41,26,42,27,43,27,44,20,45,20,46,11,47,11,48,8,49,8,50,8,51,8,52,10,53,10,54,14,55,14,56,15,57,15,58,13,59,13,60,9,61,9,62,10,63,10,64,13,65,13,66,15,67,15,68,14,69,14,70,11,71,11,72,11,73,11,74,14,75,14,76,16,77,16,78,15,79,15,80,12,81,12,82,10,83,10,84,9,85,9,86,8,87,8,88,7,89,7,90,7,91,7,92,7,93,7,94,7,95,7,96,7,97,7,98,8,99,8,100,8,101,8,102,8,103,8,104,8,105,8,106,14,107,14,108,23,109,23,110,25,111,25,112,23,113,23,114,22,115,22,116,21,117,21,118,20,119,20,120,13,121,13,},[8]={30,7,31,7,32,14,33,14,34,27,35,27,36,39,37,39,38,48,39,48,40,52,41,52,42,53,43,53,44,39,45,39,46,21,47,21,48,17,49,17,50,16,51,16,52,24,53,24,54,33,55,33,56,36,57,36,58,28,59,28,60,19,61,19,62,23,63,23,64,30,65,30,66,33,67,33,68,29,69,29,70,24,71,24,72,26,73,26,74,32,75,32,76,36,77,36,78,36,79,36,80,30,81,30,82,24,83,24,84,19,85,19,86,14,87,14,88,12,89,12,90,11,91,11,92,11,93,11,94,15,95,15,96,25,97,25,98,30,99,30,100,32,101,32,102,28,103,28,104,19,105,19,106,31,107,31,108,48,109,48,110,52,111,52,112,51,113,51,114,44,115,44,116,37,117,37,118,35,119,35,120,21,121,21,},[9]={30,7,31,7,32,14,33,14,34,27,35,27,36,39,37,39,38,48,39,48,40,52,41,52,42,53,43,53,44,39,45,39,46,21,47,21,48,17,49,17,50,16,51,16,52,24,53,24,54,33,55,33,56,36,57,36,58,28,59,28,60,19,61,19,62,23,63,23,64,30,65,30,66,33,67,33,68,29,69,29,70,24,71,24,72,26,73,26,74,32,75,32,76,36,77,36,78,36,79,36,80,30,81,30,82,24,83,24,84,19,85,19,86,14,87,14,88,12,89,12,90,11,91,11,92,11,93,11,94,15,95,15,96,25,97,25,98,30,99,30,100,32,101,32,102,28,103,28,104,19,105,19,106,31,107,31,108,48,109,48,110,52,111,52,112,51,113,51,114,44,115,44,116,37,117,37,118,35,119,35,120,21,121,21,},[10]={30,12,31,12,32,29,33,29,34,46,35,46,36,60,37,60,38,67,39,67,40,70,41,70,42,71,43,71,44,52,45,52,46,37,47,37,48,35,49,35,50,39,51,39,52,53,53,53,54,62,55,62,56,63,57,63,58,49,59,49,60,38,61,38,62,46,63,46,64,61,65,61,66,69,67,69,68,66,69,66,70,62,71,62,72,57,73,57,74,57,75,57,76,59,77,59,78,59,79,59,80,55,81,55,82,47,83,47,84,33,85,33,86,20,87,20,88,16,89,16,90,16,91,16,92,16,93,16,94,28,95,28,96,53,97,53,98,69,99,69,100,74,101,74,102,66,103,66,104,43,105,43,106,49,107,49,108,70,109,70,110,76,111,76,112,76,113,76,114,65,115,65,116,51,117,51,118,47,119,47,120,29,121,29,},[11]={30,12,31,12,32,29,33,29,34,46,35,46,36,60,37,60,38,67,39,67,40,70,41,70,42,71,43,71,44,52,45,52,46,37,47,37,48,35,49,35,50,39,51,39,52,53,53,53,54,62,55,62,56,63,57,63,58,49,59,49,60,38,61,38,62,46,63,46,64,61,65,61,66,69,67,69,68,66,69,66,70,62,71,62,72,57,73,57,74,57,75,57,76,59,77,59,78,59,79,59,80,55,81,55,82,47,83,47,84,33,85,33,86,20,87,20,88,16,89,16,90,16,91,16,92,16,93,16,94,28,95,28,96,53,97,53,98,69,99,69,100,74,101,74,102,66,103,66,104,43,105,43,106,49,107,49,108,70,109,70,110,76,111,76,112,76,113,76,114,65,115,65,116,51,117,51,118,47,119,47,120,29,121,29,},[12]={30,20,31,20,32,46,33,46,34,64,35,64,36,77,37,77,38,86,39,86,40,88,41,88,42,84,43,84,44,68,45,68,46,58,47,58,48,56,49,56,50,66,51,66,52,84,53,84,54,89,55,89,56,87,57,87,58,68,59,68,60,57,61,57,62,67,63,67,64,86,65,86,66,99,67,99,68,103,69,103,70,102,71,102,72,97,73,97,74,89,75,89,76,82,77,82,78,79,79,79,80,74,81,74,82,69,83,69,84,52,85,52,86,33,87,33,88,26,89,26,90,26,91,26,92,27,93,27,94,47,95,47,96,83,97,83,98,106,99,106,100,114,101,114,102,105,103,105,104,77,105,77,106,79,107,79,108,95,109,95,110,100,111,100,112,100,113,100,114,84,115,84,116,66,117,66,118,59,119,59,120,36,121,36,},[13]={30,20,31,20,32,46,33,46,34,64,35,64,36,77,37,77,38,86,39,86,40,88,41,88,42,84,43,84,44,68,45,68,46,58,47,58,48,56,49,56,50,66,51,66,52,84,53,84,54,89,55,89,56,87,57,87,58,68,59,68,60,57,61,57,62,67,63,67,64,86,65,86,66,99,67,99,68,103,69,103,70,102,71,102,72,97,73,97,74,89,75,89,76,82,77,82,78,79,79,79,80,74,81,74,82,69,83,69,84,52,85,52,86,33,87,33,88,26,89,26,90,26,91,26,92,27,93,27,94,47,95,47,96,83,97,83,98,106,99,106,100,114,101,114,102,105,103,105,104,77,105,77,106,79,107,79,108,95,109,95,110,100,111,100,112,100,113,100,114,84,115,84,116,66,117,66,118,59,119,59,120,36,121,36,},[14]={30,27,31,27,32,54,33,54,34,73,35,73,36,92,37,92,38,107,39,107,40,112,41,112,42,106,43,106,44,89,45,89,46,76,47,76,48,73,49,73,50,87,51,87,52,102,53,102,54,107,55,107,56,104,57,104,58,83,59,83,60,69,61,69,62,78,63,78,64,98,65,98,66,115,67,115,68,124,69,124,70,126,71,126,72,122,73,122,74,114,75,114,76,100,77,100,78,89,79,89,80,85,81,85,82,81,83,81,84,66,85,66,86,48,87,48,88,43,89,43,90,47,91,47,92,54,93,54,94,79,95,79,96,110,97,110,98,128,99,128,100,137,101,137,102,132,103,132,104,104,105,104,106,104,107,104,108,121,109,121,110,124,111,124,112,123,113,123,114,104,115,104,116,82,117,82,118,70,119,70,120,42,121,42,},[15]={30,27,31,27,32,54,33,54,34,73,35,73,36,92,37,92,38,107,39,107,40,112,41,112,42,106,43,106,44,89,45,89,46,76,47,76,48,73,49,73,50,87,51,87,52,102,53,102,54,107,55,107,56,104,57,104,58,83,59,83,60,69,61,69,62,78,63,78,64,98,65,98,66,115,67,115,68,124,69,124,70,126,71,126,72,122,73,122,74,114,75,114,76,100,77,100,78,89,79,89,80,85,81,85,82,81,83,81,84,66,85,66,86,48,87,48,88,43,89,43,90,47,91,47,92,54,93,54,94,79,95,79,96,110,97,110,98,128,99,128,100,137,101,137,102,132,103,132,104,104,105,104,106,104,107,104,108,121,109,121,110,124,111,124,112,123,113,123,114,104,115,104,116,82,117,82,118,70,119,70,120,42,121,42,},[16]={30,28,31,28,32,56,33,56,34,80,35,80,36,104,37,104,38,123,39,123,40,130,41,130,42,125,43,125,44,110,45,110,46,90,47,90,48,80,49,80,50,89,51,89,52,107,53,107,54,120,55,120,56,120,57,120,58,91,59,91,60,67,61,67,62,76,63,76,64,98,65,98,66,117,67,117,68,129,69,129,70,133,71,133,72,136,73,136,74,129,75,129,76,109,77,109,78,94,79,94,80,90,81,90,82,88,83,88,84,76,85,76,86,60,87,60,88,63,89,63,90,70,91,70,92,82,93,82,94,109,95,109,96,128,97,128,98,138,99,138,100,147,101,147,102,145,103,145,104,123,105,123,106,130,107,130,108,146,109,146,110,149,111,149,112,148,113,148,114,125,115,125,116,94,117,94,118,78,119,78,120,46,121,46,},[17]={30,28,31,28,32,56,33,56,34,80,35,80,36,104,37,104,38,123,39,123,40,130,41,130,42,125,43,125,44,110,45,110,46,90,47,90,48,80,49,80,50,89,51,89,52,107,53,107,54,120,55,120,56,120,57,120,58,91,59,91,60,67,61,67,62,76,63,76,64,98,65,98,66,117,67,117,68,129,69,129,70,133,71,133,72,136,73,136,74,129,75,129,76,109,77,109,78,94,79,94,80,90,81,90,82,88,83,88,84,76,85,76,86,60,87,60,88,63,89,63,90,70,91,70,92,82,93,82,94,109,95,109,96,128,97,128,98,138,99,138,100,147,101,147,102,145,103,145,104,123,105,123,106,130,107,130,108,146,109,146,110,149,111,149,112,148,113,148,114,125,115,125,116,94,117,94,118,78,119,78,120,46,121,46,},[18]={30,24,31,24,32,51,33,51,34,81,35,81,36,105,37,105,38,127,39,127,40,140,41,140,42,143,43,143,44,138,45,138,46,126,47,126,48,118,49,118,50,117,51,117,52,136,53,136,54,160,55,160,56,164,57,164,58,137,59,137,60,110,61,110,62,112,63,112,64,126,65,126,66,140,67,140,68,148,69,148,70,152,71,152,72,156,73,156,74,153,75,153,76,135,77,135,78,117,79,117,80,109,81,109,82,106,83,106,84,97,85,97,86,88,87,88,88,94,89,94,90,100,91,100,92,116,93,116,94,136,95,136,96,146,97,146,98,153,99,153,100,158,101,158,102,157,103,157,104,144,105,144,106,154,107,154,108,164,109,164,110,166,111,166,112,166,113,166,114,145,115,145,116,110,117,110,118,86,119,86,120,49,121,49,},[19]={30,24,31,24,32,51,33,51,34,81,35,81,36,105,37,105,38,127,39,127,40,140,41,140,42,143,43,143,44,138,45,138,46,126,47,126,48,118,49,118,50,117,51,117,52,136,53,136,54,160,55,160,56,164,57,164,58,137,59,137,60,110,61,110,62,112,63,112,64,126,65,126,66,140,67,140,68,148,69,148,70,152,71,152,72,156,73,156,74,153,75,153,76,135,77,135,78,117,79,117,80,109,81,109,82,106,83,106,84,97,85,97,86,88,87,88,88,94,89,94,90,100,91,100,92,116,93,116,94,136,95,136,96,146,97,146,98,153,99,153,100,158,101,158,102,157,103,157,104,144,105,144,106,154,107,154,108,164,109,164,110,166,111,166,112,166,113,166,114,145,115,145,116,110,117,110,118,86,119,86,120,49,121,49,},[20]={30,20,31,20,32,44,33,44,34,74,35,74,36,95,37,95,38,119,39,119,40,136,41,136,42,150,43,150,44,161,45,161,46,163,47,163,48,159,49,159,50,155,51,155,52,174,53,174,54,200,55,200,56,209,57,209,58,184,59,184,60,161,61,161,62,157,63,157,64,157,65,157,66,158,67,158,68,162,69,162,70,167,71,167,72,173,73,173,74,172,75,172,76,162,77,162,78,148,79,148,80,132,81,132,82,124,83,124,84,117,85,117,86,114,87,114,88,116,89,116,90,119,91,119,92,137,93,137,94,154,95,154,96,161,97,161,98,165,99,165,100,168,101,168,102,167,103,167,104,165,105,165,106,171,107,171,108,173,109,173,110,175,111,175,112,176,113,176,114,157,115,157,116,125,117,125,118,94,119,94,120,51,121,51,},[21]={30,20,31,20,32,44,33,44,34,74,35,74,36,95,37,95,38,119,39,119,40,136,41,136,42,150,43,150,44,161,45,161,46,163,47,163,48,159,49,159,50,155,51,155,52,174,53,174,54,200,55,200,56,209,57,209,58,184,59,184,60,161,61,161,62,157,63,157,64,157,65,157,66,158,67,158,68,162,69,162,70,167,71,167,72,173,73,173,74,172,75,172,76,162,77,162,78,148,79,148,80,132,81,132,82,124,83,124,84,117,85,117,86,114,87,114,88,116,89,116,90,119,91,119,92,137,93,137,94,154,95,154,96,161,97,161,98,165,99,165,100,168,101,168,102,167,103,167,104,165,105,165,106,171,107,171,108,173,109,173,110,175,111,175,112,176,113,176,114,157,115,157,116,125,117,125,118,94,119,94,120,51,121,51,},[22]={30,16,31,16,32,37,33,37,34,63,35,63,36,80,37,80,38,101,39,101,40,116,41,116,42,140,43,140,44,173,45,173,46,184,47,184,48,187,49,187,50,181,51,181,52,198,53,198,54,221,55,221,56,233,57,233,58,211,59,211,60,182,61,182,62,169,63,169,64,156,65,156,66,144,67,144,68,146,69,146,70,158,71,158,72,171,73,171,74,178,75,178,76,176,77,176,78,161,79,161,80,143,81,143,82,129,83,129,84,124,85,124,86,122,87,122,88,121,89,121,90,126,91,126,92,141,93,141,94,155,95,155,96,161,97,161,98,168,99,168,100,173,101,173,102,175,103,175,104,176,105,176,106,176,107,176,108,177,109,177,110,178,111,178,112,178,113,178,114,169,115,169,116,136,117,136,118,98,119,98,120,53,121,53,},[23]={30,16,31,16,32,37,33,37,34,63,35,63,36,80,37,80,38,101,39,101,40,116,41,116,42,140,43,140,44,173,45,173,46,184,47,184,48,187,49,187,50,181,51,181,52,198,53,198,54,221,55,221,56,233,57,233,58,211,59,211,60,182,61,182,62,169,63,169,64,156,65,156,66,144,67,144,68,146,69,146,70,158,71,158,72,171,73,171,74,178,75,178,76,176,77,176,78,161,79,161,80,143,81,143,82,129,83,129,84,124,85,124,86,122,87,122,88,121,89,121,90,126,91,126,92,141,93,141,94,155,95,155,96,161,97,161,98,168,99,168,100,173,101,173,102,175,103,175,104,176,105,176,106,176,107,176,108,177,109,177,110,178,111,178,112,178,113,178,114,169,115,169,116,136,117,136,118,98,119,98,120,53,121,53,},[24]={30,17,31,17,32,34,33,34,34,54,35,54,36,62,37,62,38,76,39,76,40,79,41,79,42,117,43,117,44,164,45,164,46,183,47,183,48,191,49,191,50,188,51,188,52,200,53,200,54,222,55,222,56,233,57,233,58,204,59,204,60,173,61,173,62,158,63,158,64,139,65,139,66,123,67,123,68,124,69,124,70,144,71,144,72,164,73,164,74,174,75,174,76,176,77,176,78,164,79,164,80,144,81,144,82,127,83,127,84,120,85,120,86,117,87,117,88,119,89,119,90,123,91,123,92,137,93,137,94,147,95,147,96,154,97,154,98,164,99,164,100,174,101,174,102,177,103,177,104,178,105,178,106,178,107,178,108,178,109,178,110,179,111,179,112,179,113,179,114,175,115,175,116,142,117,142,118,100,119,100,120,54,121,54,},[25]={30,17,31,17,32,34,33,34,34,54,35,54,36,62,37,62,38,76,39,76,40,79,41,79,42,117,43,117,44,164,45,164,46,183,47,183,48,191,49,191,50,188,51,188,52,200,53,200,54,222,55,222,56,233,57,233,58,204,59,204,60,173,61,173,62,158,63,158,64,139,65,139,66,123,67,123,68,124,69,124,70,144,71,144,72,164,73,164,74,174,75,174,76,176,77,176,78,164,79,164,80,144,81,144,82,127,83,127,84,120,85,120,86,117,87,117,88,119,89,119,90,123,91,123,92,137,93,137,94,147,95,147,96,154,97,154,98,164,99,164,100,174,101,174,102,177,103,177,104,178,105,178,106,178,107,178,108,178,109,178,110,179,111,179,112,179,113,179,114,175,115,175,116,142,117,142,118,100,119,100,120,54,121,54,},[26]={30,21,31,21,32,36,33,36,34,50,35,50,36,52,37,52,38,55,39,55,40,49,41,49,42,90,43,90,44,141,45,141,46,169,47,169,48,188,49,188,50,195,51,195,52,206,53,206,54,227,55,227,56,235,57,235,58,203,59,203,60,169,61,169,62,151,63,151,64,132,65,132,66,116,67,116,68,120,69,120,70,143,71,143,72,162,73,162,74,168,75,168,76,169,77,169,78,161,79,161,80,145,81,145,82,124,83,124,84,112,85,112,86,111,87,111,88,113,89,113,90,119,91,119,92,127,93,127,94,139,95,139,96,151,97,151,98,164,99,164,100,174,101,174,102,177,103,177,104,178,105,178,106,178,107,178,108,178,109,178,110,178,111,178,112,179,113,179,114,175,115,175,116,139,117,139,118,98,119,98,120,53,121,53,},[27]={30,21,31,21,32,36,33,36,34,50,35,50,36,52,37,52,38,55,39,55,40,49,41,49,42,90,43,90,44,141,45,141,46,169,47,169,48,188,49,188,50,195,51,195,52,206,53,206,54,227,55,227,56,235,57,235,58,203,59,203,60,169,61,169,62,151,63,151,64,132,65,132,66,116,67,116,68,120,69,120,70,143,71,143,72,162,73,162,74,168,75,168,76,169,77,169,78,161,79,161,80,145,81,145,82,124,83,124,84,112,85,112,86,111,87,111,88,113,89,113,90,119,91,119,92,127,93,127,94,139,95,139,96,151,97,151,98,164,99,164,100,174,101,174,102,177,103,177,104,178,105,178,106,178,107,178,108,178,109,178,110,178,111,178,112,179,113,179,114,175,115,175,116,139,117,139,118,98,119,98,120,53,121,53,},[28]={30,23,31,23,32,39,33,39,34,47,35,47,36,49,37,49,38,48,39,48,40,37,41,37,42,74,43,74,44,120,45,120,46,154,47,154,48,186,49,186,50,203,51,203,52,218,53,218,54,235,55,235,56,240,57,240,58,207,59,207,60,170,61,170,62,148,63,148,64,131,65,131,66,119,67,119,68,126,69,126,70,151,71,151,72,165,73,165,74,166,75,166,76,166,77,166,78,162,79,162,80,148,81,148,82,122,83,122,84,105,85,105,86,103,87,103,88,108,89,108,90,115,91,115,92,122,93,122,94,138,95,138,96,155,97,155,98,168,99,168,100,173,101,173,102,171,103,171,104,173,105,173,106,168,107,168,108,167,109,167,110,175,111,175,112,178,113,178,114,174,115,174,116,135,117,135,118,93,119,93,120,50,121,50,},[29]={30,23,31,23,32,39,33,39,34,47,35,47,36,49,37,49,38,48,39,48,40,37,41,37,42,74,43,74,44,120,45,120,46,154,47,154,48,186,49,186,50,203,51,203,52,218,53,218,54,235,55,235,56,240,57,240,58,207,59,207,60,170,61,170,62,148,63,148,64,131,65,131,66,119,67,119,68,126,69,126,70,151,71,151,72,165,73,165,74,166,75,166,76,166,77,166,78,162,79,162,80,148,81,148,82,122,83,122,84,105,85,105,86,103,87,103,88,108,89,108,90,115,91,115,92,122,93,122,94,138,95,138,96,155,97,155,98,168,99,168,100,173,101,173,102,171,103,171,104,173,105,173,106,168,107,168,108,167,109,167,110,175,111,175,112,178,113,178,114,174,115,174,116,135,117,135,118,93,119,93,120,50,121,50,},[30]={30,20,31,20,32,36,33,36,34,46,35,46,36,49,37,49,38,49,39,49,40,37,41,37,42,70,43,70,44,116,45,116,46,152,47,152,48,186,49,186,50,206,51,206,52,219,53,219,54,230,55,230,56,230,57,230,58,197,59,197,60,160,61,160,62,138,63,138,64,122,65,122,66,113,67,113,68,124,69,124,70,148,71,148,72,161,73,161,74,165,75,165,76,169,77,169,78,169,79,169,80,153,81,153,82,125,83,125,84,104,85,104,86,95,87,95,88,101,89,101,90,110,91,110,92,120,93,120,94,144,95,144,96,167,97,167,98,181,99,181,100,176,101,176,102,165,103,165,104,168,105,168,106,162,107,162,108,160,109,160,110,173,111,173,112,177,113,177,114,173,115,173,116,135,117,135,118,90,119,90,120,47,121,47,},[31]={30,20,31,20,32,36,33,36,34,46,35,46,36,49,37,49,38,49,39,49,40,37,41,37,42,70,43,70,44,116,45,116,46,152,47,152,48,186,49,186,50,206,51,206,52,219,53,219,54,230,55,230,56,230,57,230,58,197,59,197,60,160,61,160,62,138,63,138,64,122,65,122,66,113,67,113,68,124,69,124,70,148,71,148,72,161,73,161,74,165,75,165,76,169,77,169,78,169,79,169,80,153,81,153,82,125,83,125,84,104,85,104,86,95,87,95,88,101,89,101,90,110,91,110,92,120,93,120,94,144,95,144,96,167,97,167,98,181,99,181,100,176,101,176,102,165,103,165,104,168,105,168,106,162,107,162,108,160,109,160,110,173,111,173,112,177,113,177,114,173,115,173,116,135,117,135,118,90,119,90,120,47,121,47,},[32]={30,14,31,14,32,28,33,28,34,42,35,42,36,50,37,50,38,52,39,52,40,41,41,41,42,79,43,79,44,125,45,125,46,155,47,155,48,180,49,180,50,194,51,194,52,201,53,201,54,203,55,203,56,198,57,198,58,169,59,169,60,141,61,141,62,123,63,123,64,111,65,111,66,106,67,106,68,117,69,117,70,138,71,138,72,154,73,154,74,162,75,162,76,170,77,170,78,174,79,174,80,159,81,159,82,132,83,132,84,107,85,107,86,92,87,92,88,95,89,95,90,105,91,105,92,117,93,117,94,144,95,144,96,177,97,177,98,193,99,193,100,180,101,180,102,164,103,164,104,169,105,169,106,157,107,157,108,163,109,163,110,173,111,173,112,177,113,177,114,176,115,176,116,136,117,136,118,87,119,87,120,43,121,43,},[33]={30,14,31,14,32,28,33,28,34,42,35,42,36,50,37,50,38,52,39,52,40,41,41,41,42,79,43,79,44,125,45,125,46,155,47,155,48,180,49,180,50,194,51,194,52,201,53,201,54,203,55,203,56,198,57,198,58,169,59,169,60,141,61,141,62,123,63,123,64,111,65,111,66,106,67,106,68,117,69,117,70,138,71,138,72,154,73,154,74,162,75,162,76,170,77,170,78,174,79,174,80,159,81,159,82,132,83,132,84,107,85,107,86,92,87,92,88,95,89,95,90,105,91,105,92,117,93,117,94,144,95,144,96,177,97,177,98,193,99,193,100,180,101,180,102,164,103,164,104,169,105,169,106,157,107,157,108,163,109,163,110,173,111,173,112,177,113,177,114,176,115,176,116,136,117,136,118,87,119,87,120,43,121,43,},[34]={30,12,31,12,32,24,33,24,34,35,35,35,36,43,37,43,38,46,39,46,40,42,41,42,42,88,43,88,44,134,45,134,46,158,47,158,48,170,49,170,50,176,51,176,52,177,53,177,54,172,55,172,56,167,57,167,58,145,59,145,60,130,61,130,62,117,63,117,64,108,65,108,66,105,67,105,68,114,69,114,70,132,71,132,72,149,73,149,74,158,75,158,76,170,77,170,78,175,79,175,80,162,81,162,82,137,83,137,84,111,85,111,86,96,87,96,88,96,89,96,90,106,91,106,92,117,93,117,94,143,95,143,96,179,97,179,98,197,99,197,100,183,101,183,102,168,103,168,104,171,105,171,106,166,107,166,108,168,109,168,110,175,111,175,112,177,113,177,114,178,115,178,116,140,117,140,118,86,119,86,120,40,121,40,},[35]={30,12,31,12,32,24,33,24,34,35,35,35,36,43,37,43,38,46,39,46,40,42,41,42,42,88,43,88,44,134,45,134,46,158,47,158,48,170,49,170,50,176,51,176,52,177,53,177,54,172,55,172,56,167,57,167,58,145,59,145,60,130,61,130,62,117,63,117,64,108,65,108,66,105,67,105,68,114,69,114,70,132,71,132,72,149,73,149,74,158,75,158,76,170,77,170,78,175,79,175,80,162,81,162,82,137,83,137,84,111,85,111,86,96,87,96,88,96,89,96,90,106,91,106,92,117,93,117,94,143,95,143,96,179,97,179,98,197,99,197,100,183,101,183,102,168,103,168,104,171,105,171,106,166,107,166,108,168,109,168,110,175,111,175,112,177,113,177,114,178,115,178,116,140,117,140,118,86,119,86,120,40,121,40,},[36]={30,12,31,12,32,23,33,23,34,31,35,31,36,35,37,35,38,37,39,37,40,39,41,39,42,89,43,89,44,138,45,138,46,158,47,158,48,162,49,162,50,161,51,161,52,159,53,159,54,155,55,155,56,151,57,151,58,139,59,139,60,131,61,131,62,120,63,120,64,110,65,110,66,105,67,105,68,111,69,111,70,125,71,125,72,140,73,140,74,149,75,149,76,162,77,162,78,168,79,168,80,158,81,158,82,140,83,140,84,119,85,119,86,106,87,106,88,104,89,104,90,113,91,113,92,122,93,122,94,145,95,145,96,180,97,180,98,199,99,199,100,190,101,190,102,177,103,177,104,176,105,176,106,172,107,172,108,174,109,174,110,176,111,176,112,178,113,178,114,179,115,179,116,143,117,143,118,87,119,87,120,39,121,39,},[37]={30,12,31,12,32,23,33,23,34,31,35,31,36,35,37,35,38,37,39,37,40,39,41,39,42,89,43,89,44,138,45,138,46,158,47,158,48,162,49,162,50,161,51,161,52,159,53,159,54,155,55,155,56,151,57,151,58,139,59,139,60,131,61,131,62,120,63,120,64,110,65,110,66,105,67,105,68,111,69,111,70,125,71,125,72,140,73,140,74,149,75,149,76,162,77,162,78,168,79,168,80,158,81,158,82,140,83,140,84,119,85,119,86,106,87,106,88,104,89,104,90,113,91,113,92,122,93,122,94,145,95,145,96,180,97,180,98,199,99,199,100,190,101,190,102,177,103,177,104,176,105,176,106,172,107,172,108,174,109,174,110,176,111,176,112,178,113,178,114,179,115,179,116,143,117,143,118,87,119,87,120,39,121,39,},[38]={30,14,31,14,32,25,33,25,34,31,35,31,36,34,37,34,38,35,39,35,40,37,41,37,42,89,43,89,44,144,45,144,46,162,47,162,48,155,49,155,50,148,51,148,52,144,53,144,54,141,55,141,56,137,57,137,58,130,59,130,60,127,61,127,62,119,63,119,64,108,65,108,66,100,67,100,68,105,69,105,70,119,71,119,72,132,73,132,74,142,75,142,76,155,77,155,78,159,79,159,80,151,81,151,82,140,83,140,84,127,85,127,86,118,87,118,88,115,89,115,90,120,91,120,92,129,93,129,94,147,95,147,96,177,97,177,98,197,99,197,100,196,101,196,102,191,103,191,104,186,105,186,106,172,107,172,108,168,109,168,110,175,111,175,112,178,113,178,114,179,115,179,116,147,117,147,118,88,119,88,120,39,121,39,},[39]={30,14,31,14,32,25,33,25,34,31,35,31,36,34,37,34,38,35,39,35,40,37,41,37,42,89,43,89,44,144,45,144,46,162,47,162,48,155,49,155,50,148,51,148,52,144,53,144,54,141,55,141,56,137,57,137,58,130,59,130,60,127,61,127,62,119,63,119,64,108,65,108,66,100,67,100,68,105,69,105,70,119,71,119,72,132,73,132,74,142,75,142,76,155,77,155,78,159,79,159,80,151,81,151,82,140,83,140,84,127,85,127,86,118,87,118,88,115,89,115,90,120,91,120,92,129,93,129,94,147,95,147,96,177,97,177,98,197,99,197,100,196,101,196,102,191,103,191,104,186,105,186,106,172,107,172,108,168,109,168,110,175,111,175,112,178,113,178,114,179,115,179,116,147,117,147,118,88,119,88,120,39,121,39,},[40]={30,16,31,16,32,30,33,30,34,39,35,39,36,44,37,44,38,48,39,48,40,48,41,48,42,100,43,100,44,156,45,156,46,170,47,170,48,154,49,154,50,138,51,138,52,129,53,129,54,125,55,125,56,122,57,122,58,117,59,117,60,117,61,117,62,114,63,114,64,105,65,105,66,95,67,95,68,101,69,101,70,113,71,113,72,127,73,127,74,136,75,136,76,146,77,146,78,146,79,146,80,142,81,142,82,136,83,136,84,130,85,130,86,127,87,127,88,125,89,125,90,126,91,126,92,133,93,133,94,148,95,148,96,173,97,173,98,190,99,190,100,196,101,196,102,200,103,200,104,193,105,193,106,169,107,169,108,161,109,161,110,173,111,173,112,176,113,176,114,177,115,177,116,148,117,148,118,90,119,90,120,39,121,39,},[41]={30,16,31,16,32,30,33,30,34,39,35,39,36,44,37,44,38,48,39,48,40,48,41,48,42,100,43,100,44,156,45,156,46,170,47,170,48,154,49,154,50,138,51,138,52,129,53,129,54,125,55,125,56,122,57,122,58,117,59,117,60,117,61,117,62,114,63,114,64,105,65,105,66,95,67,95,68,101,69,101,70,113,71,113,72,127,73,127,74,136,75,136,76,146,77,146,78,146,79,146,80,142,81,142,82,136,83,136,84,130,85,130,86,127,87,127,88,125,89,125,90,126,91,126,92,133,93,133,94,148,95,148,96,173,97,173,98,190,99,190,100,196,101,196,102,200,103,200,104,193,105,193,106,169,107,169,108,161,109,161,110,173,111,173,112,176,113,176,114,177,115,177,116,148,117,148,118,90,119,90,120,39,121,39,},[42]={30,19,31,19,32,37,33,37,34,48,35,48,36,57,37,57,38,62,39,62,40,62,41,62,42,115,43,115,44,170,45,170,46,181,47,181,48,159,49,159,50,137,51,137,52,122,53,122,54,115,55,115,56,113,57,113,58,111,59,111,60,116,61,116,62,118,63,118,64,110,65,110,66,100,67,100,68,104,69,104,70,118,71,118,72,127,73,127,74,131,75,131,76,136,77,136,78,132,79,132,80,128,81,128,82,125,83,125,84,126,85,126,86,132,87,132,88,131,89,131,90,130,91,130,92,135,93,135,94,145,95,145,96,164,97,164,98,176,99,176,100,188,101,188,102,200,103,200,104,193,105,193,106,163,107,163,108,156,109,156,110,162,111,162,112,164,113,164,114,164,115,164,116,141,117,141,118,89,119,89,120,40,121,40,},[43]={30,19,31,19,32,37,33,37,34,48,35,48,36,57,37,57,38,62,39,62,40,62,41,62,42,115,43,115,44,170,45,170,46,181,47,181,48,159,49,159,50,137,51,137,52,122,53,122,54,115,55,115,56,113,57,113,58,111,59,111,60,116,61,116,62,118,63,118,64,110,65,110,66,100,67,100,68,104,69,104,70,118,71,118,72,127,73,127,74,131,75,131,76,136,77,136,78,132,79,132,80,128,81,128,82,125,83,125,84,126,85,126,86,132,87,132,88,131,89,131,90,130,91,130,92,135,93,135,94,145,95,145,96,164,97,164,98,176,99,176,100,188,101,188,102,200,103,200,104,193,105,193,106,163,107,163,108,156,109,156,110,162,111,162,112,164,113,164,114,164,115,164,116,141,117,141,118,89,119,89,120,40,121,40,},[44]={20,16,21,16,22,11,23,11,30,22,31,22,32,41,33,41,34,54,35,54,36,67,37,67,38,71,39,71,40,71,41,71,42,120,43,120,44,176,45,176,46,189,47,189,48,165,49,165,50,143,51,143,52,123,53,123,54,114,55,114,56,114,57,114,58,116,59,116,60,124,61,124,62,130,63,130,64,122,65,122,66,111,67,111,68,116,69,116,70,128,71,128,72,133,73,133,74,133,75,133,76,131,77,131,78,123,79,123,80,117,81,117,82,116,83,116,84,122,85,122,86,132,87,132,88,135,89,135,90,133,91,133,92,135,93,135,94,140,95,140,96,151,97,151,98,159,99,159,100,173,101,173,102,189,103,189,104,188,105,188,106,162,107,162,108,149,109,149,110,147,111,147,112,147,113,147,114,146,115,146,116,127,117,127,118,86,119,86,120,41,121,41,128,10,129,10,130,7,131,7,},[45]={20,16,21,16,22,11,23,11,30,22,31,22,32,41,33,41,34,54,35,54,36,67,37,67,38,71,39,71,40,71,41,71,42,120,43,120,44,176,45,176,46,189,47,189,48,165,49,165,50,143,51,143,52,123,53,123,54,114,55,114,56,114,57,114,58,116,59,116,60,124,61,124,62,130,63,130,64,122,65,122,66,111,67,111,68,116,69,116,70,128,71,128,72,133,73,133,74,133,75,133,76,131,77,131,78,123,79,123,80,117,81,117,82,116,83,116,84,122,85,122,86,132,87,132,88,135,89,135,90,133,91,133,92,135,93,135,94,140,95,140,96,151,97,151,98,159,99,159,100,173,101,173,102,189,103,189,104,188,105,188,106,162,107,162,108,149,109,149,110,147,111,147,112,147,113,147,114,146,115,146,116,127,117,127,118,86,119,86,120,41,121,41,128,10,129,10,130,7,131,7,},[46]={20,13,21,13,22,8,23,8,30,23,31,23,32,41,33,41,34,57,35,57,36,68,37,68,38,72,39,72,40,65,41,65,42,113,43,113,44,179,45,179,46,194,47,194,48,173,49,173,50,155,51,155,52,134,53,134,54,125,55,125,56,126,57,126,58,131,59,131,60,140,61,140,62,143,63,143,64,134,65,134,66,123,67,123,68,128,69,128,70,135,71,135,72,137,73,137,74,137,75,137,76,132,77,132,78,121,79,121,80,116,81,116,82,116,83,116,84,123,85,123,86,131,87,131,88,134,89,134,90,131,91,131,92,130,93,130,94,131,95,131,96,138,97,138,98,144,99,144,100,157,101,157,102,174,103,174,104,179,105,179,106,158,107,158,108,140,109,140,110,135,111,135,112,132,113,132,114,128,115,128,116,115,117,115,118,83,119,83,120,40,121,40,128,9,129,9,130,5,131,5,},[47]={20,13,21,13,22,8,23,8,30,23,31,23,32,41,33,41,34,57,35,57,36,68,37,68,38,72,39,72,40,65,41,65,42,113,43,113,44,179,45,179,46,194,47,194,48,173,49,173,50,155,51,155,52,134,53,134,54,125,55,125,56,126,57,126,58,131,59,131,60,140,61,140,62,143,63,143,64,134,65,134,66,123,67,123,68,128,69,128,70,135,71,135,72,137,73,137,74,137,75,137,76,132,77,132,78,121,79,121,80,116,81,116,82,116,83,116,84,123,85,123,86,131,87,131,88,134,89,134,90,131,91,131,92,130,93,130,94,131,95,131,96,138,97,138,98,144,99,144,100,157,101,157,102,174,103,174,104,179,105,179,106,158,107,158,108,140,109,140,110,135,111,135,112,132,113,132,114,128,115,128,116,115,117,115,118,83,119,83,120,40,121,40,128,9,129,9,130,5,131,5,},[48]={30,21,31,21,32,37,33,37,34,51,35,51,36,63,37,63,38,68,39,68,40,59,41,59,42,109,43,109,44,177,45,177,46,194,47,194,48,177,49,177,50,166,51,166,52,145,53,145,54,134,55,134,56,133,57,133,58,137,59,137,60,146,61,146,62,147,63,147,64,137,65,137,66,129,67,129,68,132,69,132,70,138,71,138,72,140,73,140,74,142,75,142,76,139,77,139,78,129,79,129,80,124,81,124,82,124,83,124,84,128,85,128,86,132,87,132,88,131,89,131,90,124,91,124,92,123,93,123,94,121,95,121,96,125,97,125,98,133,99,133,100,143,101,143,102,157,103,157,104,164,105,164,106,144,107,144,108,125,109,125,110,121,111,121,112,118,113,118,114,114,115,114,116,107,117,107,118,79,119,79,120,39,121,39,},[49]={30,21,31,21,32,37,33,37,34,51,35,51,36,63,37,63,38,68,39,68,40,59,41,59,42,109,43,109,44,177,45,177,46,194,47,194,48,177,49,177,50,166,51,166,52,145,53,145,54,134,55,134,56,133,57,133,58,137,59,137,60,146,61,146,62,147,63,147,64,137,65,137,66,129,67,129,68,132,69,132,70,138,71,138,72,140,73,140,74,142,75,142,76,139,77,139,78,129,79,129,80,124,81,124,82,124,83,124,84,128,85,128,86,132,87,132,88,131,89,131,90,124,91,124,92,123,93,123,94,121,95,121,96,125,97,125,98,133,99,133,100,143,101,143,102,157,103,157,104,164,105,164,106,144,107,144,108,125,109,125,110,121,111,121,112,118,113,118,114,114,115,114,116,107,117,107,118,79,119,79,120,39,121,39,},[50]={30,16,31,16,32,26,33,26,34,39,35,39,36,55,37,55,38,63,39,63,40,57,41,57,42,113,43,113,44,172,45,172,46,188,47,188,48,176,49,176,50,169,51,169,52,150,53,150,54,138,55,138,56,134,57,134,58,136,59,136,60,146,61,146,62,145,63,145,64,137,65,137,66,130,67,130,68,131,69,131,70,136,71,136,72,138,73,138,74,142,75,142,76,145,77,145,78,138,79,138,80,135,81,135,82,135,83,135,84,136,85,136,86,134,87,134,88,126,89,126,90,117,91,117,92,116,93,116,94,113,95,113,96,117,97,117,98,123,99,123,100,132,101,132,102,142,103,142,104,149,105,149,106,127,107,127,108,109,109,109,110,108,111,108,112,106,113,106,114,105,115,105,116,101,117,101,118,77,119,77,120,38,121,38,},[51]={30,16,31,16,32,26,33,26,34,39,35,39,36,55,37,55,38,63,39,63,40,57,41,57,42,113,43,113,44,172,45,172,46,188,47,188,48,176,49,176,50,169,51,169,52,150,53,150,54,138,55,138,56,134,57,134,58,136,59,136,60,146,61,146,62,145,63,145,64,137,65,137,66,130,67,130,68,131,69,131,70,136,71,136,72,138,73,138,74,142,75,142,76,145,77,145,78,138,79,138,80,135,81,135,82,135,83,135,84,136,85,136,86,134,87,134,88,126,89,126,90,117,91,117,92,116,93,116,94,113,95,113,96,117,97,117,98,123,99,123,100,132,101,132,102,142,103,142,104,149,105,149,106,127,107,127,108,109,109,109,110,108,111,108,112,106,113,106,114,105,115,105,116,101,117,101,118,77,119,77,120,38,121,38,},[52]={30,11,31,11,32,16,33,16,34,30,35,30,36,50,37,50,38,66,39,66,40,72,41,72,42,118,43,118,44,166,45,166,46,180,47,180,48,171,49,171,50,168,51,168,52,151,53,151,54,138,55,138,56,133,57,133,58,135,59,135,60,147,61,147,62,147,63,147,64,142,65,142,66,137,67,137,68,135,69,135,70,136,71,136,72,135,73,135,74,142,75,142,76,147,77,147,78,142,79,142,80,140,81,140,82,142,83,142,84,142,85,142,86,134,87,134,88,120,89,120,90,110,91,110,92,110,93,110,94,108,95,108,96,111,97,111,98,119,99,119,100,129,101,129,102,135,103,135,104,138,105,138,106,116,107,116,108,99,109,99,110,100,111,100,112,100,113,100,114,100,115,100,116,99,117,99,118,75,119,75,120,36,121,36,},[53]={30,11,31,11,32,16,33,16,34,30,35,30,36,50,37,50,38,66,39,66,40,72,41,72,42,118,43,118,44,166,45,166,46,180,47,180,48,171,49,171,50,168,51,168,52,151,53,151,54,138,55,138,56,133,57,133,58,135,59,135,60,147,61,147,62,147,63,147,64,142,65,142,66,137,67,137,68,135,69,135,70,136,71,136,72,135,73,135,74,142,75,142,76,147,77,147,78,142,79,142,80,140,81,140,82,142,83,142,84,142,85,142,86,134,87,134,88,120,89,120,90,110,91,110,92,110,93,110,94,108,95,108,96,111,97,111,98,119,99,119,100,129,101,129,102,135,103,135,104,138,105,138,106,116,107,116,108,99,109,99,110,100,111,100,112,100,113,100,114,100,115,100,116,99,117,99,118,75,119,75,120,36,121,36,},[54]={30,14,31,14,32,29,33,29,34,44,35,44,36,62,37,62,38,79,39,79,40,91,41,91,42,127,43,127,44,161,45,161,46,173,47,173,48,168,49,168,50,167,51,167,52,154,53,154,54,145,55,145,56,142,57,142,58,146,59,146,60,155,61,155,62,154,63,154,64,152,65,152,66,148,67,148,68,139,69,139,70,133,71,133,72,132,73,132,74,139,75,139,76,144,77,144,78,140,79,140,80,141,81,141,82,145,83,145,84,144,85,144,86,132,87,132,88,117,89,117,90,110,91,110,92,111,93,111,94,113,95,113,96,114,97,114,98,122,99,122,100,131,101,131,102,132,103,132,104,134,105,134,106,111,107,111,108,96,109,96,110,98,111,98,112,98,113,98,114,98,115,98,116,98,117,98,118,73,119,73,120,35,121,35,},[55]={30,14,31,14,32,29,33,29,34,44,35,44,36,62,37,62,38,79,39,79,40,91,41,91,42,127,43,127,44,161,45,161,46,173,47,173,48,168,49,168,50,167,51,167,52,154,53,154,54,145,55,145,56,142,57,142,58,146,59,146,60,155,61,155,62,154,63,154,64,152,65,152,66,148,67,148,68,139,69,139,70,133,71,133,72,132,73,132,74,139,75,139,76,144,77,144,78,140,79,140,80,141,81,141,82,145,83,145,84,144,85,144,86,132,87,132,88,117,89,117,90,110,91,110,92,111,93,111,94,113,95,113,96,114,97,114,98,122,99,122,100,131,101,131,102,132,103,132,104,134,105,134,106,111,107,111,108,96,109,96,110,98,111,98,112,98,113,98,114,98,115,98,116,98,117,98,118,73,119,73,120,35,121,35,},[56]={20,16,21,16,22,11,23,11,30,22,31,22,32,49,33,49,34,68,35,68,36,79,37,79,38,95,39,95,40,108,41,108,42,135,43,135,44,161,45,161,46,169,47,169,48,168,49,168,50,168,51,168,52,160,53,160,54,156,55,156,56,157,57,157,58,161,59,161,60,162,61,162,62,156,63,156,64,158,65,158,66,157,67,157,68,141,69,141,70,132,71,132,72,133,73,133,74,138,75,138,76,139,77,139,78,133,79,133,80,138,81,138,82,143,83,143,84,141,85,141,86,132,87,132,88,121,89,121,90,117,91,117,92,123,93,123,94,125,95,125,96,126,97,126,98,131,99,131,100,135,101,135,102,131,103,131,104,129,105,129,106,107,107,107,108,94,109,94,110,97,111,97,112,97,113,97,114,98,115,98,116,98,117,98,118,71,119,71,120,32,121,32,128,13,129,13,130,9,131,9,},[57]={20,16,21,16,22,11,23,11,30,22,31,22,32,49,33,49,34,68,35,68,36,79,37,79,38,95,39,95,40,108,41,108,42,135,43,135,44,161,45,161,46,169,47,169,48,168,49,168,50,168,51,168,52,160,53,160,54,156,55,156,56,157,57,157,58,161,59,161,60,162,61,162,62,156,63,156,64,158,65,158,66,157,67,157,68,141,69,141,70,132,71,132,72,133,73,133,74,138,75,138,76,139,77,139,78,133,79,133,80,138,81,138,82,143,83,143,84,141,85,141,86,132,87,132,88,121,89,121,90,117,91,117,92,123,93,123,94,125,95,125,96,126,97,126,98,131,99,131,100,135,101,135,102,131,103,131,104,129,105,129,106,107,107,107,108,94,109,94,110,97,111,97,112,97,113,97,114,98,115,98,116,98,117,98,118,71,119,71,120,32,121,32,128,13,129,13,130,9,131,9,},[58]={20,13,21,13,22,8,23,8,30,34,31,34,32,64,33,64,34,82,35,82,36,90,37,90,38,103,39,103,40,114,41,114,42,137,43,137,44,156,45,156,46,159,47,159,48,160,49,160,50,161,51,161,52,158,53,158,54,155,55,155,56,156,57,156,58,158,59,158,60,151,61,151,62,142,63,142,64,150,65,150,66,155,67,155,68,141,69,141,70,136,71,136,72,138,73,138,74,141,75,141,76,135,77,135,78,124,79,124,80,131,81,131,82,136,83,136,84,135,85,135,86,133,87,133,88,128,89,128,90,132,91,132,92,140,93,140,94,143,95,143,96,143,97,143,98,143,99,143,100,143,101,143,102,133,103,133,104,126,105,126,106,103,107,103,108,90,109,90,110,92,111,92,112,95,113,95,114,96,115,96,116,97,117,97,118,68,119,68,120,29,121,29,128,11,129,11,130,7,131,7,},[59]={20,13,21,13,22,8,23,8,30,34,31,34,32,64,33,64,34,82,35,82,36,90,37,90,38,103,39,103,40,114,41,114,42,137,43,137,44,156,45,156,46,159,47,159,48,160,49,160,50,161,51,161,52,158,53,158,54,155,55,155,56,156,57,156,58,158,59,158,60,151,61,151,62,142,63,142,64,150,65,150,66,155,67,155,68,141,69,141,70,136,71,136,72,138,73,138,74,141,75,141,76,135,77,135,78,124,79,124,80,131,81,131,82,136,83,136,84,135,85,135,86,133,87,133,88,128,89,128,90,132,91,132,92,140,93,140,94,143,95,143,96,143,97,143,98,143,99,143,100,143,101,143,102,133,103,133,104,126,105,126,106,103,107,103,108,90,109,90,110,92,111,92,112,95,113,95,114,96,115,96,116,97,117,97,118,68,119,68,120,29,121,29,128,11,129,11,130,7,131,7,},[60]={30,37,31,37,32,66,33,66,34,84,35,84,36,92,37,92,38,102,39,102,40,107,41,107,42,132,43,132,44,153,45,153,46,153,47,153,48,156,49,156,50,158,51,158,52,158,53,158,54,155,55,155,56,154,57,154,58,153,59,153,60,137,61,137,62,127,63,127,64,141,65,141,66,152,67,152,68,143,69,143,70,141,71,141,72,144,73,144,74,143,75,143,76,124,77,124,78,110,79,110,80,118,81,118,82,120,83,120,84,122,85,122,86,128,87,128,88,133,89,133,90,141,91,141,92,150,93,150,94,155,95,155,96,155,97,155,98,153,99,153,100,150,101,150,102,135,103,135,104,123,105,123,106,100,107,100,108,88,109,88,110,92,111,92,112,97,113,97,114,99,115,99,116,97,117,97,118,65,119,65,120,29,121,29,},[61]={30,37,31,37,32,66,33,66,34,84,35,84,36,92,37,92,38,102,39,102,40,107,41,107,42,132,43,132,44,153,45,153,46,153,47,153,48,156,49,156,50,158,51,158,52,158,53,158,54,155,55,155,56,154,57,154,58,153,59,153,60,137,61,137,62,127,63,127,64,141,65,141,66,152,67,152,68,143,69,143,70,141,71,141,72,144,73,144,74,143,75,143,76,124,77,124,78,110,79,110,80,118,81,118,82,120,83,120,84,122,85,122,86,128,87,128,88,133,89,133,90,141,91,141,92,150,93,150,94,155,95,155,96,155,97,155,98,153,99,153,100,150,101,150,102,135,103,135,104,123,105,123,106,100,107,100,108,88,109,88,110,92,111,92,112,97,113,97,114,99,115,99,116,97,117,97,118,65,119,65,120,29,121,29,},[62]={30,34,31,34,32,59,33,59,34,75,35,75,36,87,37,87,38,96,39,96,40,98,41,98,42,125,43,125,44,150,45,150,46,153,47,153,48,157,49,157,50,161,51,161,52,165,53,165,54,161,55,161,56,162,57,162,58,158,59,158,60,134,61,134,62,120,63,120,64,138,65,138,66,151,67,151,68,146,69,146,70,145,71,145,72,149,73,149,74,143,75,143,76,113,77,113,78,98,79,98,80,107,81,107,82,109,83,109,84,112,85,112,86,123,87,123,88,134,89,134,90,143,91,143,92,148,93,148,94,154,95,154,96,157,97,157,98,156,99,156,100,155,101,155,102,140,103,140,104,126,105,126,106,106,107,106,108,97,109,97,110,105,111,105,112,109,113,109,114,110,115,110,116,101,117,101,118,65,119,65,120,29,121,29,},[63]={30,34,31,34,32,59,33,59,34,75,35,75,36,87,37,87,38,96,39,96,40,98,41,98,42,125,43,125,44,150,45,150,46,153,47,153,48,157,49,157,50,161,51,161,52,165,53,165,54,161,55,161,56,162,57,162,58,158,59,158,60,134,61,134,62,120,63,120,64,138,65,138,66,151,67,151,68,146,69,146,70,145,71,145,72,149,73,149,74,143,75,143,76,113,77,113,78,98,79,98,80,107,81,107,82,109,83,109,84,112,85,112,86,123,87,123,88,134,89,134,90,143,91,143,92,148,93,148,94,154,95,154,96,157,97,157,98,156,99,156,100,155,101,155,102,140,103,140,104,126,105,126,106,106,107,106,108,97,109,97,110,105,111,105,112,109,113,109,114,110,115,110,116,101,117,101,118,65,119,65,120,29,121,29,},[64]={30,23,31,23,32,41,33,41,34,59,35,59,36,79,37,79,38,91,39,91,40,91,41,91,42,122,43,122,44,150,45,150,46,154,47,154,48,159,49,159,50,164,51,164,52,171,53,171,54,169,55,169,56,172,57,172,58,166,59,166,60,136,61,136,62,120,63,120,64,136,65,136,66,152,67,152,68,148,69,148,70,148,71,148,72,152,73,152,74,140,75,140,76,106,77,106,78,93,79,93,80,103,81,103,82,106,83,106,84,110,85,110,86,124,87,124,88,136,89,136,90,142,91,142,92,141,93,141,94,146,95,146,96,151,97,151,98,152,99,152,100,153,101,153,102,145,103,145,104,141,105,141,106,131,107,131,108,125,109,125,110,129,111,129,112,127,113,127,114,122,115,122,116,103,117,103,118,65,119,65,120,31,121,31,},[65]={30,23,31,23,32,41,33,41,34,59,35,59,36,79,37,79,38,91,39,91,40,91,41,91,42,122,43,122,44,150,45,150,46,154,47,154,48,159,49,159,50,164,51,164,52,171,53,171,54,169,55,169,56,172,57,172,58,166,59,166,60,136,61,136,62,120,63,120,64,136,65,136,66,152,67,152,68,148,69,148,70,148,71,148,72,152,73,152,74,140,75,140,76,106,77,106,78,93,79,93,80,103,81,103,82,106,83,106,84,110,85,110,86,124,87,124,88,136,89,136,90,142,91,142,92,141,93,141,94,146,95,146,96,151,97,151,98,152,99,152,100,153,101,153,102,145,103,145,104,141,105,141,106,131,107,131,108,125,109,125,110,129,111,129,112,127,113,127,114,122,115,122,116,103,117,103,118,65,119,65,120,31,121,31,},[66]={30,13,31,13,32,24,33,24,34,42,35,42,36,71,37,71,38,91,39,91,40,96,41,96,42,122,43,122,44,148,45,148,46,152,47,152,48,155,49,155,50,161,51,161,52,167,53,167,54,166,55,166,56,169,57,169,58,160,59,160,60,130,61,130,62,113,63,113,64,131,65,131,66,149,67,149,68,149,69,149,70,151,71,151,72,155,73,155,74,145,75,145,76,111,77,111,78,100,79,100,80,110,81,110,82,111,83,111,84,114,85,114,86,125,87,125,88,135,89,135,90,135,91,135,92,129,93,129,94,134,95,134,96,142,97,142,98,145,99,145,100,151,101,151,102,152,103,152,104,160,105,160,106,159,107,159,108,153,109,153,110,149,111,149,112,139,113,139,114,123,115,123,116,96,117,96,118,62,119,62,120,31,121,31,},[67]={30,13,31,13,32,24,33,24,34,42,35,42,36,71,37,71,38,91,39,91,40,96,41,96,42,122,43,122,44,148,45,148,46,152,47,152,48,155,49,155,50,161,51,161,52,167,53,167,54,166,55,166,56,169,57,169,58,160,59,160,60,130,61,130,62,113,63,113,64,131,65,131,66,149,67,149,68,149,69,149,70,151,71,151,72,155,73,155,74,145,75,145,76,111,77,111,78,100,79,100,80,110,81,110,82,111,83,111,84,114,85,114,86,125,87,125,88,135,89,135,90,135,91,135,92,129,93,129,94,134,95,134,96,142,97,142,98,145,99,145,100,151,101,151,102,152,103,152,104,160,105,160,106,159,107,159,108,153,109,153,110,149,111,149,112,139,113,139,114,123,115,123,116,96,117,96,118,62,119,62,120,31,121,31,},[68]={30,8,31,8,32,19,33,19,34,42,35,42,36,69,37,69,38,94,39,94,40,104,41,104,42,126,43,126,44,145,45,145,46,148,47,148,48,148,49,148,50,152,51,152,52,159,53,159,54,159,55,159,56,158,57,158,58,148,59,148,60,125,61,125,62,111,63,111,64,128,65,128,66,147,67,147,68,152,69,152,70,156,71,156,72,159,73,159,74,151,75,151,76,122,77,122,78,112,79,112,80,119,81,119,82,118,83,118,84,119,85,119,86,125,87,125,88,128,89,128,90,123,91,123,92,113,93,113,94,118,95,118,96,130,97,130,98,137,99,137,100,152,101,152,102,163,103,163,104,177,105,177,106,178,107,178,108,169,109,169,110,160,111,160,112,138,113,138,114,111,115,111,116,83,117,83,118,56,119,56,120,30,121,30,},[69]={30,8,31,8,32,19,33,19,34,42,35,42,36,69,37,69,38,94,39,94,40,104,41,104,42,126,43,126,44,145,45,145,46,148,47,148,48,148,49,148,50,152,51,152,52,159,53,159,54,159,55,159,56,158,57,158,58,148,59,148,60,125,61,125,62,111,63,111,64,128,65,128,66,147,67,147,68,152,69,152,70,156,71,156,72,159,73,159,74,151,75,151,76,122,77,122,78,112,79,112,80,119,81,119,82,118,83,118,84,119,85,119,86,125,87,125,88,128,89,128,90,123,91,123,92,113,93,113,94,118,95,118,96,130,97,130,98,137,99,137,100,152,101,152,102,163,103,163,104,177,105,177,106,178,107,178,108,169,109,169,110,160,111,160,112,138,113,138,114,111,115,111,116,83,117,83,118,56,119,56,120,30,121,30,},[70]={30,10,31,10,32,27,33,27,34,54,35,54,36,75,37,75,38,99,39,99,40,107,41,107,42,123,43,123,44,144,45,144,46,148,47,148,48,147,49,147,50,148,51,148,52,155,53,155,54,155,55,155,56,153,57,153,58,147,59,147,60,131,61,131,62,118,63,118,64,128,65,128,66,144,67,144,68,152,69,152,70,156,71,156,72,157,73,157,74,152,75,152,76,131,77,131,78,123,79,123,80,125,81,125,82,121,83,121,84,120,85,120,86,118,87,118,88,114,89,114,90,106,91,106,92,98,93,98,94,106,95,106,96,119,97,119,98,132,99,132,100,153,101,153,102,172,103,172,104,183,105,183,106,186,107,186,108,176,109,176,110,162,111,162,112,129,113,129,114,93,115,93,116,67,117,67,118,51,119,51,120,29,121,29,},[71]={30,10,31,10,32,27,33,27,34,54,35,54,36,75,37,75,38,99,39,99,40,107,41,107,42,123,43,123,44,144,45,144,46,148,47,148,48,147,49,147,50,148,51,148,52,155,53,155,54,155,55,155,56,153,57,153,58,147,59,147,60,131,61,131,62,118,63,118,64,128,65,128,66,144,67,144,68,152,69,152,70,156,71,156,72,157,73,157,74,152,75,152,76,131,77,131,78,123,79,123,80,125,81,125,82,121,83,121,84,120,85,120,86,118,87,118,88,114,89,114,90,106,91,106,92,98,93,98,94,106,95,106,96,119,97,119,98,132,99,132,100,153,101,153,102,172,103,172,104,183,105,183,106,186,107,186,108,176,109,176,110,162,111,162,112,129,113,129,114,93,115,93,116,67,117,67,118,51,119,51,120,29,121,29,},[72]={30,13,31,13,32,41,33,41,34,67,35,67,36,83,37,83,38,98,39,98,40,99,41,99,42,114,43,114,44,142,45,142,46,150,47,150,48,145,49,145,50,145,51,145,52,151,53,151,54,150,55,150,56,149,57,149,58,149,59,149,60,142,61,142,62,127,63,127,64,129,65,129,66,140,67,140,68,148,69,148,70,151,71,151,72,151,73,151,74,151,75,151,76,140,77,140,78,134,79,134,80,131,81,131,82,123,83,123,84,119,85,119,86,110,87,110,88,102,89,102,90,97,91,97,92,95,93,95,94,104,95,104,96,119,97,119,98,134,99,134,100,159,101,159,102,178,103,178,104,186,105,186,106,186,107,186,108,173,109,173,110,158,111,158,112,121,113,121,114,84,115,84,116,59,117,59,118,47,119,47,120,27,121,27,},[73]={30,13,31,13,32,41,33,41,34,67,35,67,36,83,37,83,38,98,39,98,40,99,41,99,42,114,43,114,44,142,45,142,46,150,47,150,48,145,49,145,50,145,51,145,52,151,53,151,54,150,55,150,56,149,57,149,58,149,59,149,60,142,61,142,62,127,63,127,64,129,65,129,66,140,67,140,68,148,69,148,70,151,71,151,72,151,73,151,74,151,75,151,76,140,77,140,78,134,79,134,80,131,81,131,82,123,83,123,84,119,85,119,86,110,87,110,88,102,89,102,90,97,91,97,92,95,93,95,94,104,95,104,96,119,97,119,98,134,99,134,100,159,101,159,102,178,103,178,104,186,105,186,106,186,107,186,108,173,109,173,110,158,111,158,112,121,113,121,114,84,115,84,116,59,117,59,118,47,119,47,120,27,121,27,},[74]={30,20,31,20,32,50,33,50,34,74,35,74,36,85,37,85,38,95,39,95,40,90,41,90,42,105,43,105,44,138,45,138,46,153,47,153,48,146,49,146,50,139,51,139,52,141,53,141,54,138,55,138,56,139,57,139,58,147,59,147,60,145,61,145,62,135,63,135,64,136,65,136,66,148,67,148,68,155,69,155,70,156,71,156,72,155,73,155,74,157,75,157,76,148,77,148,78,139,79,139,80,129,81,129,82,119,83,119,84,112,85,112,86,102,87,102,88,97,89,97,90,101,91,101,92,109,93,109,94,120,95,120,96,132,97,132,98,150,99,150,100,175,101,175,102,188,103,188,104,191,105,191,106,183,107,183,108,167,109,167,110,152,111,152,112,124,113,124,114,87,115,87,116,57,117,57,118,46,119,46,120,27,121,27,},[75]={30,20,31,20,32,50,33,50,34,74,35,74,36,85,37,85,38,95,39,95,40,90,41,90,42,105,43,105,44,138,45,138,46,153,47,153,48,146,49,146,50,139,51,139,52,141,53,141,54,138,55,138,56,139,57,139,58,147,59,147,60,145,61,145,62,135,63,135,64,136,65,136,66,148,67,148,68,155,69,155,70,156,71,156,72,155,73,155,74,157,75,157,76,148,77,148,78,139,79,139,80,129,81,129,82,119,83,119,84,112,85,112,86,102,87,102,88,97,89,97,90,101,91,101,92,109,93,109,94,120,95,120,96,132,97,132,98,150,99,150,100,175,101,175,102,188,103,188,104,191,105,191,106,183,107,183,108,167,109,167,110,152,111,152,112,124,113,124,114,87,115,87,116,57,117,57,118,46,119,46,120,27,121,27,},[76]={30,28,31,28,32,56,33,56,34,74,35,74,36,89,37,89,38,99,39,99,40,97,41,97,42,109,43,109,44,138,45,138,46,155,47,155,48,146,49,146,50,134,51,134,52,131,53,131,54,126,55,126,56,127,57,127,58,139,59,139,60,146,61,146,62,142,63,142,64,149,65,149,66,162,67,162,68,172,69,172,70,173,71,173,72,169,73,169,74,167,75,167,76,154,77,154,78,139,79,139,80,124,81,124,82,111,83,111,84,105,85,105,86,100,87,100,88,105,89,105,90,124,91,124,92,142,93,142,94,152,95,152,96,161,97,161,98,180,99,180,100,200,101,200,102,201,103,201,104,193,105,193,106,179,107,179,108,163,109,163,110,151,111,151,112,133,113,133,114,94,115,94,116,58,117,58,118,46,119,46,120,27,121,27,},[77]={30,28,31,28,32,56,33,56,34,74,35,74,36,89,37,89,38,99,39,99,40,97,41,97,42,109,43,109,44,138,45,138,46,155,47,155,48,146,49,146,50,134,51,134,52,131,53,131,54,126,55,126,56,127,57,127,58,139,59,139,60,146,61,146,62,142,63,142,64,149,65,149,66,162,67,162,68,172,69,172,70,173,71,173,72,169,73,169,74,167,75,167,76,154,77,154,78,139,79,139,80,124,81,124,82,111,83,111,84,105,85,105,86,100,87,100,88,105,89,105,90,124,91,124,92,142,93,142,94,152,95,152,96,161,97,161,98,180,99,180,100,200,101,200,102,201,103,201,104,193,105,193,106,179,107,179,108,163,109,163,110,151,111,151,112,133,113,133,114,94,115,94,116,58,117,58,118,46,119,46,120,27,121,27,},[78]={30,35,31,35,32,50,33,50,34,68,35,68,36,91,37,91,38,107,39,107,40,110,41,110,42,116,43,116,44,141,45,141,46,157,47,157,48,148,49,148,50,134,51,134,52,129,53,129,54,121,55,121,56,120,57,120,58,132,59,132,60,143,61,143,62,147,63,147,64,158,65,158,66,170,67,170,68,182,69,182,70,187,71,187,72,181,73,181,74,178,75,178,76,166,77,166,78,155,79,155,80,135,81,135,82,118,83,118,84,113,85,113,86,114,87,114,88,127,89,127,90,157,91,157,92,180,93,180,94,185,95,185,96,193,97,193,98,209,99,209,100,218,101,218,102,210,103,210,104,194,105,194,106,175,107,175,108,162,109,162,110,153,111,153,112,139,113,139,114,96,115,96,116,59,117,59,118,46,119,46,120,27,121,27,},[79]={30,35,31,35,32,50,33,50,34,68,35,68,36,91,37,91,38,107,39,107,40,110,41,110,42,116,43,116,44,141,45,141,46,157,47,157,48,148,49,148,50,134,51,134,52,129,53,129,54,121,55,121,56,120,57,120,58,132,59,132,60,143,61,143,62,147,63,147,64,158,65,158,66,170,67,170,68,182,69,182,70,187,71,187,72,181,73,181,74,178,75,178,76,166,77,166,78,155,79,155,80,135,81,135,82,118,83,118,84,113,85,113,86,114,87,114,88,127,89,127,90,157,91,157,92,180,93,180,94,185,95,185,96,193,97,193,98,209,99,209,100,218,101,218,102,210,103,210,104,194,105,194,106,175,107,175,108,162,109,162,110,153,111,153,112,139,113,139,114,96,115,96,116,59,117,59,118,46,119,46,120,27,121,27,},[80]={30,27,31,27,32,35,33,35,34,55,35,55,36,90,37,90,38,110,39,110,40,117,41,117,42,120,43,120,44,142,45,142,46,156,47,156,48,146,49,146,50,136,51,136,52,133,53,133,54,123,55,123,56,117,57,117,58,125,59,125,60,137,61,137,62,144,63,144,64,153,65,153,66,163,67,163,68,177,69,177,70,183,71,183,72,182,73,182,74,182,75,182,76,177,77,177,78,171,79,171,80,152,81,152,82,132,83,132,84,132,85,132,86,139,87,139,88,157,89,157,90,182,91,182,92,198,93,198,94,203,95,203,96,211,97,211,98,220,99,220,100,226,101,226,102,212,103,212,104,191,105,191,106,175,107,175,108,163,109,163,110,156,111,156,112,140,113,140,114,94,115,94,116,59,117,59,118,46,119,46,120,27,121,27,},[81]={30,27,31,27,32,35,33,35,34,55,35,55,36,90,37,90,38,110,39,110,40,117,41,117,42,120,43,120,44,142,45,142,46,156,47,156,48,146,49,146,50,136,51,136,52,133,53,133,54,123,55,123,56,117,57,117,58,125,59,125,60,137,61,137,62,144,63,144,64,153,65,153,66,163,67,163,68,177,69,177,70,183,71,183,72,182,73,182,74,182,75,182,76,177,77,177,78,171,79,171,80,152,81,152,82,132,83,132,84,132,85,132,86,139,87,139,88,157,89,157,90,182,91,182,92,198,93,198,94,203,95,203,96,211,97,211,98,220,99,220,100,226,101,226,102,212,103,212,104,191,105,191,106,175,107,175,108,163,109,163,110,156,111,156,112,140,113,140,114,94,115,94,116,59,117,59,118,46,119,46,120,27,121,27,},[82]={30,18,31,18,32,21,33,21,34,43,35,43,36,77,37,77,38,101,39,101,40,112,41,112,42,112,43,112,44,117,45,117,46,116,47,116,48,118,49,118,50,126,51,126,52,125,53,125,54,115,55,115,56,106,57,106,58,119,59,119,60,140,61,140,62,131,63,131,64,118,65,118,66,125,67,125,68,138,69,138,70,145,71,145,72,153,73,153,74,157,75,157,76,154,77,154,78,151,79,151,80,137,81,137,82,127,83,127,84,128,85,128,86,134,87,134,88,148,89,148,90,166,91,166,92,178,93,178,94,185,95,185,96,200,97,200,98,214,99,214,100,220,101,220,102,208,103,208,104,189,105,189,106,177,107,177,108,169,109,169,110,163,111,163,112,139,113,139,114,89,115,89,116,58,117,58,118,46,119,46,120,27,121,27,},[83]={30,18,31,18,32,21,33,21,34,43,35,43,36,77,37,77,38,101,39,101,40,112,41,112,42,112,43,112,44,117,45,117,46,116,47,116,48,118,49,118,50,126,51,126,52,125,53,125,54,115,55,115,56,106,57,106,58,119,59,119,60,140,61,140,62,131,63,131,64,118,65,118,66,125,67,125,68,138,69,138,70,145,71,145,72,153,73,153,74,157,75,157,76,154,77,154,78,151,79,151,80,137,81,137,82,127,83,127,84,128,85,128,86,134,87,134,88,148,89,148,90,166,91,166,92,178,93,178,94,185,95,185,96,200,97,200,98,214,99,214,100,220,101,220,102,208,103,208,104,189,105,189,106,177,107,177,108,169,109,169,110,163,111,163,112,139,113,139,114,89,115,89,116,58,117,58,118,46,119,46,120,27,121,27,},[84]={30,14,31,14,32,17,33,17,34,33,35,33,36,61,37,61,38,86,39,86,40,99,41,99,42,94,43,94,44,84,45,84,46,68,47,68,48,83,49,83,50,110,51,110,52,111,53,111,54,101,55,101,56,95,57,95,58,116,59,116,60,148,61,148,62,135,63,135,64,109,65,109,66,101,67,101,68,101,69,101,70,108,71,108,72,120,73,120,74,127,75,127,76,121,77,121,78,116,79,116,80,110,81,110,82,109,83,109,84,111,85,111,86,116,87,116,88,123,89,123,90,134,91,134,92,146,93,146,94,157,95,157,96,179,97,179,98,197,99,197,100,206,101,206,102,200,103,200,104,190,105,190,106,180,107,180,108,174,109,174,110,168,111,168,112,136,113,136,114,86,115,86,116,57,117,57,118,46,119,46,120,27,121,27,},[85]={30,14,31,14,32,17,33,17,34,33,35,33,36,61,37,61,38,86,39,86,40,99,41,99,42,94,43,94,44,84,45,84,46,68,47,68,48,83,49,83,50,110,51,110,52,111,53,111,54,101,55,101,56,95,57,95,58,116,59,116,60,148,61,148,62,135,63,135,64,109,65,109,66,101,67,101,68,101,69,101,70,108,71,108,72,120,73,120,74,127,75,127,76,121,77,121,78,116,79,116,80,110,81,110,82,109,83,109,84,111,85,111,86,116,87,116,88,123,89,123,90,134,91,134,92,146,93,146,94,157,95,157,96,179,97,179,98,197,99,197,100,206,101,206,102,200,103,200,104,190,105,190,106,180,107,180,108,174,109,174,110,168,111,168,112,136,113,136,114,86,115,86,116,57,117,57,118,46,119,46,120,27,121,27,},[86]={30,12,31,12,32,16,33,16,34,24,35,24,36,46,37,46,38,71,39,71,40,80,41,80,42,74,43,74,44,59,45,59,46,46,47,46,48,64,49,64,50,82,51,82,52,82,53,82,54,74,55,74,56,71,57,71,58,114,59,114,60,153,61,153,62,142,63,142,64,132,65,132,66,110,67,110,68,92,69,92,70,94,71,94,72,103,73,103,74,103,75,103,76,94,77,94,78,91,79,91,80,93,81,93,82,94,83,94,84,97,85,97,86,101,87,101,88,104,89,104,90,116,91,116,92,126,93,126,94,138,95,138,96,160,97,160,98,177,99,177,100,188,101,188,102,190,103,190,104,186,105,186,106,182,107,182,108,177,109,177,110,171,111,171,112,137,113,137,114,90,115,90,116,60,117,60,118,46,119,46,120,27,121,27,},[87]={30,12,31,12,32,16,33,16,34,24,35,24,36,46,37,46,38,71,39,71,40,80,41,80,42,74,43,74,44,59,45,59,46,46,47,46,48,64,49,64,50,82,51,82,52,82,53,82,54,74,55,74,56,71,57,71,58,114,59,114,60,153,61,153,62,142,63,142,64,132,65,132,66,110,67,110,68,92,69,92,70,94,71,94,72,103,73,103,74,103,75,103,76,94,77,94,78,91,79,91,80,93,81,93,82,94,83,94,84,97,85,97,86,101,87,101,88,104,89,104,90,116,91,116,92,126,93,126,94,138,95,138,96,160,97,160,98,177,99,177,100,188,101,188,102,190,103,190,104,186,105,186,106,182,107,182,108,177,109,177,110,171,111,171,112,137,113,137,114,90,115,90,116,60,117,60,118,46,119,46,120,27,121,27,},[88]={30,12,31,12,32,19,33,19,34,28,35,28,36,44,37,44,38,60,39,60,40,65,41,65,42,62,43,62,44,55,45,55,46,49,47,49,48,54,49,54,50,58,51,58,52,60,53,60,54,52,55,52,56,54,57,54,58,103,59,103,60,152,61,152,62,161,63,161,64,157,65,157,66,127,67,127,68,102,69,102,70,95,71,95,72,95,73,95,74,90,75,90,76,81,77,81,78,81,79,81,80,86,81,86,82,89,83,89,84,94,85,94,86,99,87,99,88,101,89,101,90,111,91,111,92,121,93,121,94,130,95,130,96,143,97,143,98,160,99,160,100,173,101,173,102,178,103,178,104,178,105,178,106,177,107,177,108,174,109,174,110,166,111,166,112,135,113,135,114,94,115,94,116,63,117,63,118,46,119,46,120,26,121,26,},[89]={30,12,31,12,32,19,33,19,34,28,35,28,36,44,37,44,38,60,39,60,40,65,41,65,42,62,43,62,44,55,45,55,46,49,47,49,48,54,49,54,50,58,51,58,52,60,53,60,54,52,55,52,56,54,57,54,58,103,59,103,60,152,61,152,62,161,63,161,64,157,65,157,66,127,67,127,68,102,69,102,70,95,71,95,72,95,73,95,74,90,75,90,76,81,77,81,78,81,79,81,80,86,81,86,82,89,83,89,84,94,85,94,86,99,87,99,88,101,89,101,90,111,91,111,92,121,93,121,94,130,95,130,96,143,97,143,98,160,99,160,100,173,101,173,102,178,103,178,104,178,105,178,106,177,107,177,108,174,109,174,110,166,111,166,112,135,113,135,114,94,115,94,116,63,117,63,118,46,119,46,120,26,121,26,},[90]={30,19,31,19,32,33,33,33,34,47,35,47,36,54,37,54,38,51,39,51,40,48,41,48,42,45,43,45,44,43,45,43,46,40,47,40,48,41,49,41,50,49,51,49,52,52,53,52,54,43,55,43,56,45,57,45,58,99,59,99,60,147,61,147,62,163,63,163,64,163,65,163,66,131,67,131,68,100,69,100,70,89,71,89,72,84,73,84,74,76,75,76,76,70,77,70,78,72,79,72,80,80,81,80,82,85,83,85,84,92,85,92,86,97,87,97,88,99,89,99,90,109,91,109,92,119,93,119,94,123,95,123,96,131,97,131,98,142,99,142,100,153,101,153,102,159,103,159,104,162,105,162,106,160,107,160,108,155,109,155,110,146,111,146,112,120,113,120,114,88,115,88,116,58,117,58,118,42,119,42,120,23,121,23,},[91]={30,19,31,19,32,33,33,33,34,47,35,47,36,54,37,54,38,51,39,51,40,48,41,48,42,45,43,45,44,43,45,43,46,40,47,40,48,41,49,41,50,49,51,49,52,52,53,52,54,43,55,43,56,45,57,45,58,99,59,99,60,147,61,147,62,163,63,163,64,163,65,163,66,131,67,131,68,100,69,100,70,89,71,89,72,84,73,84,74,76,75,76,76,70,77,70,78,72,79,72,80,80,81,80,82,85,83,85,84,92,85,92,86,97,87,97,88,99,89,99,90,109,91,109,92,119,93,119,94,123,95,123,96,131,97,131,98,142,99,142,100,153,101,153,102,159,103,159,104,162,105,162,106,160,107,160,108,155,109,155,110,146,111,146,112,120,113,120,114,88,115,88,116,58,117,58,118,42,119,42,120,23,121,23,},[92]={30,26,31,26,32,48,33,48,34,67,35,67,36,59,37,59,38,41,39,41,40,31,41,31,42,27,43,27,44,26,45,26,46,25,47,25,48,34,49,34,50,51,51,51,52,55,53,55,54,42,55,42,56,36,57,36,58,75,59,75,60,110,61,110,62,124,63,124,64,128,65,128,66,108,67,108,68,85,69,85,70,76,71,76,72,67,73,67,74,60,75,60,76,55,77,55,78,61,79,61,80,71,81,71,82,77,83,77,84,83,85,83,86,89,87,89,88,93,89,93,90,101,91,101,92,107,93,107,94,108,95,108,96,111,97,111,98,118,99,118,100,126,101,126,102,133,103,133,104,134,105,134,106,130,107,130,108,122,109,122,110,109,111,109,112,92,113,92,114,70,115,70,116,47,117,47,118,33,119,33,120,17,121,17,},[93]={30,26,31,26,32,48,33,48,34,67,35,67,36,59,37,59,38,41,39,41,40,31,41,31,42,27,43,27,44,26,45,26,46,25,47,25,48,34,49,34,50,51,51,51,52,55,53,55,54,42,55,42,56,36,57,36,58,75,59,75,60,110,61,110,62,124,63,124,64,128,65,128,66,108,67,108,68,85,69,85,70,76,71,76,72,67,73,67,74,60,75,60,76,55,77,55,78,61,79,61,80,71,81,71,82,77,83,77,84,83,85,83,86,89,87,89,88,93,89,93,90,101,91,101,92,107,93,107,94,108,95,108,96,111,97,111,98,118,99,118,100,126,101,126,102,133,103,133,104,134,105,134,106,130,107,130,108,122,109,122,110,109,111,109,112,92,113,92,114,70,115,70,116,47,117,47,118,33,119,33,120,17,121,17,},[94]={30,25,31,25,32,45,33,45,34,56,35,56,36,44,37,44,38,27,39,27,40,19,41,19,42,16,43,16,44,15,45,15,46,14,47,14,48,27,49,27,50,38,51,38,52,42,53,42,54,31,55,31,56,25,57,25,58,45,59,45,60,60,61,60,62,68,63,68,64,72,65,72,66,64,67,64,68,56,69,56,70,50,71,50,72,44,73,44,74,38,75,38,76,35,77,35,78,43,79,43,80,53,81,53,82,61,83,61,84,67,85,67,86,74,87,74,88,80,89,80,90,85,91,85,92,87,93,87,94,87,95,87,96,87,97,87,98,89,99,89,100,95,101,95,102,99,103,99,104,98,105,98,106,89,107,89,108,77,109,77,110,65,111,65,112,55,113,55,114,44,115,44,116,30,117,30,118,21,119,21,120,11,121,11,},[95]={30,25,31,25,32,45,33,45,34,56,35,56,36,44,37,44,38,27,39,27,40,19,41,19,42,16,43,16,44,15,45,15,46,14,47,14,48,27,49,27,50,38,51,38,52,42,53,42,54,31,55,31,56,25,57,25,58,45,59,45,60,60,61,60,62,68,63,68,64,72,65,72,66,64,67,64,68,56,69,56,70,50,71,50,72,44,73,44,74,38,75,38,76,35,77,35,78,43,79,43,80,53,81,53,82,61,83,61,84,67,85,67,86,74,87,74,88,80,89,80,90,85,91,85,92,87,93,87,94,87,95,87,96,87,97,87,98,89,99,89,100,95,101,95,102,99,103,99,104,98,105,98,106,89,107,89,108,77,109,77,110,65,111,65,112,55,113,55,114,44,115,44,116,30,117,30,118,21,119,21,120,11,121,11,},[96]={30,14,31,14,32,26,33,26,34,28,35,28,36,19,37,19,38,14,39,14,40,10,41,10,42,9,43,9,44,8,45,8,46,8,47,8,48,15,49,15,50,18,51,18,52,20,53,20,54,14,55,14,56,11,57,11,58,16,59,16,60,21,61,21,62,24,63,24,64,28,65,28,66,28,67,28,68,25,69,25,70,23,71,23,72,19,73,19,74,17,75,17,76,17,77,17,78,21,79,21,80,28,81,28,82,33,83,33,84,37,85,37,86,44,87,44,88,48,89,48,90,49,91,49,92,49,93,49,94,49,95,49,96,49,97,49,98,50,99,50,100,53,101,53,102,54,103,54,104,51,105,51,106,45,107,45,108,35,109,35,110,28,111,28,112,24,113,24,114,19,115,19,116,13,117,13,118,10,119,10,120,5,121,5,},[97]={30,14,31,14,32,26,33,26,34,28,35,28,36,19,37,19,38,14,39,14,40,10,41,10,42,9,43,9,44,8,45,8,46,8,47,8,48,15,49,15,50,18,51,18,52,20,53,20,54,14,55,14,56,11,57,11,58,16,59,16,60,21,61,21,62,24,63,24,64,28,65,28,66,28,67,28,68,25,69,25,70,23,71,23,72,19,73,19,74,17,75,17,76,17,77,17,78,21,79,21,80,28,81,28,82,33,83,33,84,37,85,37,86,44,87,44,88,48,89,48,90,49,91,49,92,49,93,49,94,49,95,49,96,49,97,49,98,50,99,50,100,53,101,53,102,54,103,54,104,51,105,51,106,45,107,45,108,35,109,35,110,28,111,28,112,24,113,24,114,19,115,19,116,13,117,13,118,10,119,10,120,5,121,5,},[104]={68,10,69,10,70,7,71,7,80,8,81,8,82,5,83,5,},[105]={68,10,69,10,70,7,71,7,80,8,81,8,82,5,83,5,},[106]={68,9,69,9,70,5,71,5,80,6,81,6,82,4,83,4,},[107]={68,9,69,9,70,5,71,5,80,6,81,6,82,4,83,4,},[252]={68,18,69,18,70,13,71,13,80,18,81,18,82,13,83,13,},[253]={68,18,69,18,70,13,71,13,80,18,81,18,82,13,83,13,},[254]={68,16,69,16,70,9,71,9,80,16,81,16,82,9,83,9,},[255]={68,16,69,16,70,9,71,9,80,16,81,16,82,9,83,9,}
		},
		
		markers ={
			50, 74
		},
		
		objects = {
			[42]={20,5,18,-1,0,128,5,18,-1,0,},[44]={18,5,18,-1,0,22,5,18,-1,0,126,5,18,-1,0,130,5,18,-1,0,},[46]={20,5,18,-1,0,128,5,18,-1,0,},[48]={74,5,18,-1,0,},[50]={72,5,18,-1,0,76,5,18,-1,0,},[52]={74,5,18,-1,0,},[54]={20,5,18,-1,0,128,5,18,-1,0,},[56]={18,5,18,-1,0,22,5,18,-1,0,126,5,18,-1,0,130,5,18,-1,0,},[58]={20,5,18,-1,0,128,5,18,-1,0,},[102]={68,5,18,-1,0,80,5,18,-1,0,},[104]={66,5,18,-1,0,70,5,18,-1,0,78,5,18,-1,0,82,5,18,-1,0,},[106]={68,5,18,-1,0,80,5,18,-1,0,},[250]={68,5,18,-1,0,80,5,18,-1,0,},[252]={66,5,18,-1,0,70,5,18,-1,0,78,5,18,-1,0,82,5,18,-1,0,},[254]={68,5,18,-1,0,80,5,18,-1,0,}
		},
		
		shaman_positions = {
			56, 128, 44, 128, 252, 80, 252, 68, 44, 20, 56, 20, 104, 68, 104, 80
		},
		
		scripts = {
			OnTurn = function(everySecond1, everySecond2, everySecond4) 			luck_draw_on_turn(everySecond1, everySecond2, everySecond4) end,
			OnCreateThing = function(t, owner, type, model) 						luck_draw_on_create_thing(t, owner, type, model) end,
			OnHumanDisconnect = function(player) 									LD_init_single_AI(player) end,
			OnEnd = function()														LD_onEnd() end,
		},
		
	},
	
	[MAP_SPARKLING_TILES]={
	
		info = 	{ 	name = "Sparkling Tiles", author = "MrKosjaK",
					desc = "You've got points to accrue, and shamans to disrupt. <br> Convert as many tiles as possible whilst preventing enemy shamans from doing the same. <br> The more sparkling tiles of your colour, the more points and mana you'll earn.",
					map_objectives = { {value=5, step=1, default=true}, {value=60000, step=5000, limit=150000, default=true}, {} },
					image = 3248, texture={15, 2}, zoom={218,206,0}, drop_infos = true,	marker_lb={90, 96}, reinc_timer=2, shield_respawn=true,
				},

		land ={
			[0]={0,321,1,321,2,388,3,388,4,488,5,488,6,605,7,605,8,707,9,707,10,810,11,810,12,879,13,879,14,925,15,925,16,972,17,972,18,997,19,997,20,986,21,986,22,902,23,902,24,717,25,717,26,473,27,473,28,239,29,239,30,96,31,96,32,49,33,49,34,25,35,25,166,23,167,23,168,62,169,62,170,97,171,97,172,124,173,124,174,142,175,142,176,146,177,146,178,154,179,154,180,168,181,168,182,181,183,181,184,197,185,197,186,207,187,207,188,203,189,203,190,190,191,190,192,176,193,176,194,168,195,168,196,165,197,165,198,159,199,159,200,147,201,147,202,124,203,124,204,101,205,101,206,81,207,81,208,64,209,64,210,54,211,54,212,54,213,54,214,59,215,59,216,65,217,65,218,72,219,72,220,85,221,85,222,96,223,96,224,100,225,100,226,104,227,104,228,113,229,113,230,120,231,120,232,123,233,123,234,123,235,123,236,126,237,126,238,136,239,136,240,146,241,146,242,152,243,152,244,152,245,152,246,149,247,149,248,148,249,148,250,165,251,165,252,206,253,206,254,257,255,257,},[1]={0,321,1,321,2,388,3,388,4,488,5,488,6,605,7,605,8,707,9,707,10,810,11,810,12,879,13,879,14,925,15,925,16,972,17,972,18,997,19,997,20,986,21,986,22,902,23,902,24,717,25,717,26,473,27,473,28,239,29,239,30,96,31,96,32,49,33,49,34,25,35,25,166,23,167,23,168,62,169,62,170,97,171,97,172,124,173,124,174,142,175,142,176,146,177,146,178,154,179,154,180,168,181,168,182,181,183,181,184,197,185,197,186,207,187,207,188,203,189,203,190,190,191,190,192,176,193,176,194,168,195,168,196,165,197,165,198,159,199,159,200,147,201,147,202,124,203,124,204,101,205,101,206,81,207,81,208,64,209,64,210,54,211,54,212,54,213,54,214,59,215,59,216,65,217,65,218,72,219,72,220,85,221,85,222,96,223,96,224,100,225,100,226,104,227,104,228,113,229,113,230,120,231,120,232,123,233,123,234,123,235,123,236,126,237,126,238,136,239,136,240,146,241,146,242,152,243,152,244,152,245,152,246,149,247,149,248,148,249,148,250,165,251,165,252,206,253,206,254,257,255,257,},[2]={0,296,1,296,2,349,3,349,4,453,5,453,6,580,7,580,8,703,9,703,10,828,11,828,12,899,13,899,14,937,15,937,16,973,17,973,18,996,19,996,20,986,21,986,22,894,23,894,24,701,25,701,26,463,27,463,28,250,29,250,30,121,31,121,32,64,33,64,34,37,35,37,36,18,37,18,166,22,167,22,168,61,169,61,170,95,171,95,172,129,173,129,174,161,175,161,176,190,177,190,178,228,179,228,180,271,181,271,182,296,183,296,184,304,185,304,186,301,187,301,188,283,189,283,190,261,191,261,192,246,193,246,194,236,195,236,196,228,197,228,198,215,199,215,200,191,201,191,202,160,203,160,204,131,205,131,206,109,207,109,208,90,209,90,210,80,211,80,212,80,213,80,214,84,215,84,216,84,217,84,218,87,219,87,220,98,221,98,222,110,223,110,224,116,225,116,226,125,227,125,228,137,229,137,230,146,231,146,232,150,233,150,234,148,235,148,236,145,237,145,238,147,239,147,240,153,241,153,242,156,243,156,244,158,245,158,246,159,247,159,248,160,249,160,250,175,251,175,252,206,253,206,254,248,255,248,},[3]={0,296,1,296,2,349,3,349,4,453,5,453,6,580,7,580,8,703,9,703,10,828,11,828,12,899,13,899,14,937,15,937,16,973,17,973,18,996,19,996,20,986,21,986,22,894,23,894,24,701,25,701,26,463,27,463,28,250,29,250,30,121,31,121,32,64,33,64,34,37,35,37,36,18,37,18,166,22,167,22,168,61,169,61,170,95,171,95,172,129,173,129,174,161,175,161,176,190,177,190,178,228,179,228,180,271,181,271,182,296,183,296,184,304,185,304,186,301,187,301,188,283,189,283,190,261,191,261,192,246,193,246,194,236,195,236,196,228,197,228,198,215,199,215,200,191,201,191,202,160,203,160,204,131,205,131,206,109,207,109,208,90,209,90,210,80,211,80,212,80,213,80,214,84,215,84,216,84,217,84,218,87,219,87,220,98,221,98,222,110,223,110,224,116,225,116,226,125,227,125,228,137,229,137,230,146,231,146,232,150,233,150,234,148,235,148,236,145,237,145,238,147,239,147,240,153,241,153,242,156,243,156,244,158,245,158,246,159,247,159,248,160,249,160,250,175,251,175,252,206,253,206,254,248,255,248,},[4]={0,268,1,268,2,313,3,313,4,417,5,417,6,550,7,550,8,688,9,688,10,835,11,835,12,917,13,917,14,952,15,952,16,980,17,980,18,1000,19,1000,20,989,21,989,22,896,23,896,24,708,25,708,26,489,27,489,28,286,29,286,30,152,31,152,32,82,33,82,34,52,35,52,36,31,37,31,38,13,39,13,166,30,167,30,168,64,169,64,170,99,171,99,172,150,173,150,174,214,175,214,176,291,177,291,178,371,179,371,180,444,181,444,182,482,183,482,184,476,185,476,186,448,187,448,188,403,189,403,190,359,191,359,192,328,193,328,194,306,195,306,196,285,197,285,198,258,199,258,200,223,201,223,202,186,203,186,204,156,205,156,206,133,207,133,208,115,209,115,210,108,211,108,212,111,213,111,214,113,215,113,216,108,217,108,218,105,219,105,220,114,221,114,222,125,223,125,224,134,225,134,226,147,227,147,228,164,229,164,230,177,231,177,232,184,233,184,234,181,235,181,236,171,237,171,238,166,239,166,240,166,241,166,242,165,243,165,244,165,245,165,246,166,247,166,248,168,249,168,250,179,251,179,252,202,253,202,254,234,255,234,},[5]={0,268,1,268,2,313,3,313,4,417,5,417,6,550,7,550,8,688,9,688,10,835,11,835,12,917,13,917,14,952,15,952,16,980,17,980,18,1000,19,1000,20,989,21,989,22,896,23,896,24,708,25,708,26,489,27,489,28,286,29,286,30,152,31,152,32,82,33,82,34,52,35,52,36,31,37,31,38,13,39,13,166,30,167,30,168,64,169,64,170,99,171,99,172,150,173,150,174,214,175,214,176,291,177,291,178,371,179,371,180,444,181,444,182,482,183,482,184,476,185,476,186,448,187,448,188,403,189,403,190,359,191,359,192,328,193,328,194,306,195,306,196,285,197,285,198,258,199,258,200,223,201,223,202,186,203,186,204,156,205,156,206,133,207,133,208,115,209,115,210,108,211,108,212,111,213,111,214,113,215,113,216,108,217,108,218,105,219,105,220,114,221,114,222,125,223,125,224,134,225,134,226,147,227,147,228,164,229,164,230,177,231,177,232,184,233,184,234,181,235,181,236,171,237,171,238,166,239,166,240,166,241,166,242,165,243,165,244,165,245,165,246,166,247,166,248,168,249,168,250,179,251,179,252,202,253,202,254,234,255,234,},[6]={0,250,1,250,2,291,3,291,4,394,5,394,6,526,7,526,8,677,9,677,10,842,11,842,12,928,13,928,14,960,15,960,16,980,17,980,18,982,19,982,20,955,21,955,22,866,23,866,24,716,25,716,26,529,27,529,28,344,29,344,30,193,31,193,32,107,33,107,34,70,35,70,36,46,37,46,38,24,39,24,166,38,167,38,168,71,169,71,170,112,171,112,172,191,173,191,174,310,175,310,176,452,177,452,178,573,179,573,180,663,181,663,182,697,183,697,184,672,185,672,186,614,187,614,188,539,189,539,190,461,191,461,192,398,193,398,194,358,195,358,196,323,197,323,198,283,199,283,200,242,201,242,202,204,203,204,204,175,205,175,206,154,207,154,208,140,209,140,210,137,211,137,212,145,213,145,214,148,215,148,216,139,217,139,218,131,219,131,220,137,221,137,222,144,223,144,224,150,225,150,226,166,227,166,228,185,229,185,230,202,231,202,232,215,233,215,234,212,235,212,236,197,237,197,238,184,239,184,240,178,241,178,242,173,243,173,244,171,245,171,246,173,247,173,248,177,249,177,250,185,251,185,252,201,253,201,254,226,255,226,},[7]={0,250,1,250,2,291,3,291,4,394,5,394,6,526,7,526,8,677,9,677,10,842,11,842,12,928,13,928,14,960,15,960,16,980,17,980,18,982,19,982,20,955,21,955,22,866,23,866,24,716,25,716,26,529,27,529,28,344,29,344,30,193,31,193,32,107,33,107,34,70,35,70,36,46,37,46,38,24,39,24,166,38,167,38,168,71,169,71,170,112,171,112,172,191,173,191,174,310,175,310,176,452,177,452,178,573,179,573,180,663,181,663,182,697,183,697,184,672,185,672,186,614,187,614,188,539,189,539,190,461,191,461,192,398,193,398,194,358,195,358,196,323,197,323,198,283,199,283,200,242,201,242,202,204,203,204,204,175,205,175,206,154,207,154,208,140,209,140,210,137,211,137,212,145,213,145,214,148,215,148,216,139,217,139,218,131,219,131,220,137,221,137,222,144,223,144,224,150,225,150,226,166,227,166,228,185,229,185,230,202,231,202,232,215,233,215,234,212,235,212,236,197,237,197,238,184,239,184,240,178,241,178,242,173,243,173,244,171,245,171,246,173,247,173,248,177,249,177,250,185,251,185,252,201,253,201,254,226,255,226,},[8]={0,243,1,243,2,278,3,278,4,381,5,381,6,529,7,529,8,704,9,704,10,869,11,869,12,944,13,944,14,970,15,970,16,960,17,960,18,909,19,909,20,843,21,843,22,771,23,771,24,672,25,672,26,531,27,531,28,371,29,371,30,225,31,225,32,133,33,133,34,93,35,93,36,66,37,66,38,39,39,39,40,16,41,16,166,46,167,46,168,83,169,83,170,136,171,136,172,243,173,243,174,422,175,422,176,624,177,624,178,759,179,759,180,840,181,840,182,869,183,869,184,839,185,839,186,765,187,765,188,663,189,663,190,545,191,545,192,444,193,444,194,385,195,385,196,337,197,337,198,292,199,292,200,253,201,253,202,218,203,218,204,191,205,191,206,174,207,174,208,163,209,163,210,165,211,165,212,177,213,177,214,184,215,184,216,177,217,177,218,168,219,168,220,170,221,170,222,170,223,170,224,171,225,171,226,183,227,183,228,201,229,201,230,222,231,222,232,240,233,240,234,238,235,238,236,217,237,217,238,196,239,196,240,185,241,185,242,181,243,181,244,181,245,181,246,186,247,186,248,192,249,192,250,198,251,198,252,207,253,207,254,223,255,223,},[9]={0,243,1,243,2,278,3,278,4,381,5,381,6,529,7,529,8,704,9,704,10,869,11,869,12,944,13,944,14,970,15,970,16,960,17,960,18,909,19,909,20,843,21,843,22,771,23,771,24,672,25,672,26,531,27,531,28,371,29,371,30,225,31,225,32,133,33,133,34,93,35,93,36,66,37,66,38,39,39,39,40,16,41,16,166,46,167,46,168,83,169,83,170,136,171,136,172,243,173,243,174,422,175,422,176,624,177,624,178,759,179,759,180,840,181,840,182,869,183,869,184,839,185,839,186,765,187,765,188,663,189,663,190,545,191,545,192,444,193,444,194,385,195,385,196,337,197,337,198,292,199,292,200,253,201,253,202,218,203,218,204,191,205,191,206,174,207,174,208,163,209,163,210,165,211,165,212,177,213,177,214,184,215,184,216,177,217,177,218,168,219,168,220,170,221,170,222,170,223,170,224,171,225,171,226,183,227,183,228,201,229,201,230,222,231,222,232,240,233,240,234,238,235,238,236,217,237,217,238,196,239,196,240,185,241,185,242,181,243,181,244,181,245,181,246,186,247,186,248,192,249,192,250,198,251,198,252,207,253,207,254,223,255,223,},[10]={0,233,1,233,2,261,3,261,4,360,5,360,6,518,7,518,8,711,9,711,10,878,11,878,12,940,13,940,14,937,15,937,16,874,17,874,18,759,19,759,20,663,21,663,22,616,23,616,24,559,25,559,26,471,27,471,28,356,29,356,30,232,31,232,32,152,33,152,34,117,35,117,36,91,37,91,38,59,39,59,40,29,41,29,166,58,167,58,168,105,169,105,170,163,171,163,172,283,173,283,174,493,175,493,176,728,177,728,178,873,179,873,180,940,181,940,182,960,183,960,184,939,185,939,186,866,187,866,188,754,189,754,190,608,191,608,192,481,193,481,194,405,195,405,196,344,197,344,198,295,199,295,200,260,201,260,202,231,203,231,204,208,205,208,206,193,207,193,208,184,209,184,210,188,211,188,212,201,213,201,214,212,215,212,216,212,217,212,218,210,219,210,220,214,221,214,222,209,223,209,224,203,225,203,226,207,227,207,228,221,229,221,230,245,231,245,232,265,233,265,234,260,235,260,236,232,237,232,238,203,239,203,240,191,241,191,242,192,243,192,244,199,245,199,246,209,247,209,248,215,249,215,250,214,251,214,252,213,253,213,254,219,255,219,},[11]={0,233,1,233,2,261,3,261,4,360,5,360,6,518,7,518,8,711,9,711,10,878,11,878,12,940,13,940,14,937,15,937,16,874,17,874,18,759,19,759,20,663,21,663,22,616,23,616,24,559,25,559,26,471,27,471,28,356,29,356,30,232,31,232,32,152,33,152,34,117,35,117,36,91,37,91,38,59,39,59,40,29,41,29,166,58,167,58,168,105,169,105,170,163,171,163,172,283,173,283,174,493,175,493,176,728,177,728,178,873,179,873,180,940,181,940,182,960,183,960,184,939,185,939,186,866,187,866,188,754,189,754,190,608,191,608,192,481,193,481,194,405,195,405,196,344,197,344,198,295,199,295,200,260,201,260,202,231,203,231,204,208,205,208,206,193,207,193,208,184,209,184,210,188,211,188,212,201,213,201,214,212,215,212,216,212,217,212,218,210,219,210,220,214,221,214,222,209,223,209,224,203,225,203,226,207,227,207,228,221,229,221,230,245,231,245,232,265,233,265,234,260,235,260,236,232,237,232,238,203,239,203,240,191,241,191,242,192,243,192,244,199,245,199,246,209,247,209,248,215,249,215,250,214,251,214,252,213,253,213,254,219,255,219,},[12]={0,216,1,216,2,239,3,239,4,331,5,331,6,482,7,482,8,664,9,664,10,811,11,811,12,867,13,867,14,819,15,819,16,709,17,709,18,563,19,563,20,453,21,453,22,408,23,408,24,384,25,384,26,349,27,349,28,292,29,292,30,218,31,218,32,169,33,169,34,146,35,146,36,122,37,122,38,88,39,88,40,49,41,49,42,20,43,20,164,14,165,14,166,70,167,70,168,121,169,121,170,168,171,168,172,275,173,275,174,488,175,488,176,731,177,731,178,895,179,895,180,965,181,965,182,993,183,993,184,988,185,988,186,928,187,928,188,824,189,824,190,675,191,675,192,539,193,539,194,446,195,446,196,366,197,366,198,305,199,305,200,267,201,267,202,242,203,242,204,226,205,226,206,213,207,213,208,205,209,205,210,206,211,206,212,214,213,214,214,226,215,226,216,236,217,236,218,250,219,250,220,265,221,265,222,264,223,264,224,254,225,254,226,250,227,250,228,260,229,260,230,284,231,284,232,299,233,299,234,288,235,288,236,251,237,251,238,213,239,213,240,199,241,199,242,208,243,208,244,225,245,225,246,239,247,239,248,239,249,239,250,226,251,226,252,213,253,213,254,210,255,210,},[13]={0,216,1,216,2,239,3,239,4,331,5,331,6,482,7,482,8,664,9,664,10,811,11,811,12,867,13,867,14,819,15,819,16,709,17,709,18,563,19,563,20,453,21,453,22,408,23,408,24,384,25,384,26,349,27,349,28,292,29,292,30,218,31,218,32,169,33,169,34,146,35,146,36,122,37,122,38,88,39,88,40,49,41,49,42,20,43,20,164,14,165,14,166,70,167,70,168,121,169,121,170,168,171,168,172,275,173,275,174,488,175,488,176,731,177,731,178,895,179,895,180,965,181,965,182,993,183,993,184,988,185,988,186,928,187,928,188,824,189,824,190,675,191,675,192,539,193,539,194,446,195,446,196,366,197,366,198,305,199,305,200,267,201,267,202,242,203,242,204,226,205,226,206,213,207,213,208,205,209,205,210,206,211,206,212,214,213,214,214,226,215,226,216,236,217,236,218,250,219,250,220,265,221,265,222,264,223,264,224,254,225,254,226,250,227,250,228,260,229,260,230,284,231,284,232,299,233,299,234,288,235,288,236,251,237,251,238,213,239,213,240,199,241,199,242,208,243,208,244,225,245,225,246,239,247,239,248,239,249,239,250,226,251,226,252,213,253,213,254,210,255,210,},[14]={0,195,1,195,2,213,3,213,4,284,5,284,6,411,7,411,8,557,9,557,10,684,11,684,12,709,13,709,14,635,15,635,16,521,17,521,18,383,19,383,20,286,21,286,22,239,23,239,24,225,25,225,26,221,27,221,28,204,29,204,30,181,31,181,32,170,33,170,34,164,35,164,36,148,37,148,38,116,39,116,40,75,41,75,42,38,43,38,164,23,165,23,166,86,167,86,168,133,169,133,170,161,171,161,172,233,173,233,174,409,175,409,176,659,177,659,178,858,179,858,180,956,181,956,182,994,183,994,184,1003,185,1003,186,971,187,971,188,906,189,906,190,780,191,780,192,646,193,646,194,525,195,525,196,407,197,407,198,323,199,323,200,274,201,274,202,250,203,250,204,239,205,239,206,232,207,232,208,224,209,224,210,218,211,218,212,217,213,217,214,228,215,228,216,251,217,251,218,286,219,286,220,316,221,316,222,328,223,328,224,323,225,323,226,316,227,316,228,325,229,325,230,343,231,343,232,348,233,348,234,328,235,328,236,281,237,281,238,233,239,233,240,215,241,215,242,228,243,228,244,250,245,250,246,264,247,264,248,255,249,255,250,229,251,229,252,205,253,205,254,194,255,194,},[15]={0,195,1,195,2,213,3,213,4,284,5,284,6,411,7,411,8,557,9,557,10,684,11,684,12,709,13,709,14,635,15,635,16,521,17,521,18,383,19,383,20,286,21,286,22,239,23,239,24,225,25,225,26,221,27,221,28,204,29,204,30,181,31,181,32,170,33,170,34,164,35,164,36,148,37,148,38,116,39,116,40,75,41,75,42,38,43,38,164,23,165,23,166,86,167,86,168,133,169,133,170,161,171,161,172,233,173,233,174,409,175,409,176,659,177,659,178,858,179,858,180,956,181,956,182,994,183,994,184,1003,185,1003,186,971,187,971,188,906,189,906,190,780,191,780,192,646,193,646,194,525,195,525,196,407,197,407,198,323,199,323,200,274,201,274,202,250,203,250,204,239,205,239,206,232,207,232,208,224,209,224,210,218,211,218,212,217,213,217,214,228,215,228,216,251,217,251,218,286,219,286,220,316,221,316,222,328,223,328,224,323,225,323,226,316,227,316,228,325,229,325,230,343,231,343,232,348,233,348,234,328,235,328,236,281,237,281,238,233,239,233,240,215,241,215,242,228,243,228,244,250,245,250,246,264,247,264,248,255,249,255,250,229,251,229,252,205,253,205,254,194,255,194,},[16]={0,170,1,170,2,180,3,180,4,221,5,221,6,296,7,296,8,384,9,384,10,460,11,460,12,458,13,458,14,405,15,405,16,334,17,334,18,251,19,251,20,185,21,185,22,159,23,159,24,143,25,143,26,142,27,142,28,144,29,144,30,146,31,146,32,160,33,160,34,170,35,170,36,168,37,168,38,147,39,147,40,107,41,107,42,65,43,65,44,28,45,28,164,33,165,33,166,94,167,94,168,127,169,127,170,136,171,136,172,173,173,173,174,289,175,289,176,530,177,530,178,774,179,774,180,917,181,917,182,977,183,977,184,1000,185,1000,186,993,187,993,188,969,189,969,190,889,191,889,192,769,193,769,194,613,195,613,196,450,197,450,198,335,199,335,200,272,201,272,202,247,203,247,204,243,205,243,206,241,207,241,208,234,209,234,210,221,211,221,212,213,213,213,214,225,215,225,216,265,217,265,218,320,219,320,220,367,221,367,222,397,223,397,224,405,225,405,226,403,227,403,228,411,229,411,230,418,231,418,232,408,233,408,234,378,235,378,236,322,237,322,238,264,239,264,240,237,241,237,242,243,243,243,244,263,245,263,246,272,247,272,248,255,249,255,250,221,251,221,252,189,253,189,254,174,255,174,},[17]={0,170,1,170,2,180,3,180,4,221,5,221,6,296,7,296,8,384,9,384,10,460,11,460,12,458,13,458,14,405,15,405,16,334,17,334,18,251,19,251,20,185,21,185,22,159,23,159,24,143,25,143,26,142,27,142,28,144,29,144,30,146,31,146,32,160,33,160,34,170,35,170,36,168,37,168,38,147,39,147,40,107,41,107,42,65,43,65,44,28,45,28,164,33,165,33,166,94,167,94,168,127,169,127,170,136,171,136,172,173,173,173,174,289,175,289,176,530,177,530,178,774,179,774,180,917,181,917,182,977,183,977,184,1000,185,1000,186,993,187,993,188,969,189,969,190,889,191,889,192,769,193,769,194,613,195,613,196,450,197,450,198,335,199,335,200,272,201,272,202,247,203,247,204,243,205,243,206,241,207,241,208,234,209,234,210,221,211,221,212,213,213,213,214,225,215,225,216,265,217,265,218,320,219,320,220,367,221,367,222,397,223,397,224,405,225,405,226,403,227,403,228,411,229,411,230,418,231,418,232,408,233,408,234,378,235,378,236,322,237,322,238,264,239,264,240,237,241,237,242,243,243,243,244,263,245,263,246,272,247,272,248,255,249,255,250,221,251,221,252,189,253,189,254,174,255,174,},[18]={0,138,1,138,2,137,3,137,4,149,5,149,6,176,7,176,8,207,9,207,10,236,11,236,12,234,13,234,14,217,15,217,16,196,17,196,18,163,19,163,20,147,21,147,22,126,23,126,24,112,25,112,26,112,27,112,28,116,29,116,30,132,31,132,32,154,33,154,34,172,35,172,36,185,37,185,38,177,39,177,40,145,41,145,42,99,43,99,44,51,45,51,162,13,163,13,164,46,165,46,166,97,167,97,168,114,169,114,170,117,171,117,172,126,173,126,174,205,175,205,176,413,177,413,178,646,179,646,180,814,181,814,182,909,183,909,184,956,185,956,186,984,187,984,188,995,189,995,190,947,191,947,192,837,193,837,194,654,195,654,196,462,197,462,198,327,199,327,200,254,201,254,202,229,203,229,204,229,205,229,206,233,207,233,208,227,209,227,210,211,211,211,212,202,213,202,214,223,215,223,216,280,217,280,218,349,219,349,220,416,221,416,222,471,223,471,224,498,225,498,226,509,227,509,228,511,229,511,230,497,231,497,232,466,233,466,234,424,235,424,236,364,237,364,238,298,239,298,240,255,241,255,242,246,243,246,244,256,245,256,246,260,247,260,248,241,249,241,250,206,251,206,252,171,253,171,254,149,255,149,},[19]={0,138,1,138,2,137,3,137,4,149,5,149,6,176,7,176,8,207,9,207,10,236,11,236,12,234,13,234,14,217,15,217,16,196,17,196,18,163,19,163,20,147,21,147,22,126,23,126,24,112,25,112,26,112,27,112,28,116,29,116,30,132,31,132,32,154,33,154,34,172,35,172,36,185,37,185,38,177,39,177,40,145,41,145,42,99,43,99,44,51,45,51,162,13,163,13,164,46,165,46,166,97,167,97,168,114,169,114,170,117,171,117,172,126,173,126,174,205,175,205,176,413,177,413,178,646,179,646,180,814,181,814,182,909,183,909,184,956,185,956,186,984,187,984,188,995,189,995,190,947,191,947,192,837,193,837,194,654,195,654,196,462,197,462,198,327,199,327,200,254,201,254,202,229,203,229,204,229,205,229,206,233,207,233,208,227,209,227,210,211,211,211,212,202,213,202,214,223,215,223,216,280,217,280,218,349,219,349,220,416,221,416,222,471,223,471,224,498,225,498,226,509,227,509,228,511,229,511,230,497,231,497,232,466,233,466,234,424,235,424,236,364,237,364,238,298,239,298,240,255,241,255,242,246,243,246,244,256,245,256,246,260,247,260,248,241,249,241,250,206,251,206,252,171,253,171,254,149,255,149,},[20]={0,101,1,101,2,91,3,91,4,83,5,83,6,82,7,82,8,86,9,86,10,97,11,97,12,107,13,107,14,120,15,120,16,124,17,124,18,124,19,124,20,119,21,119,22,106,23,106,24,100,25,100,26,105,27,105,28,111,29,111,30,129,31,129,32,146,33,146,34,162,35,162,36,185,37,185,38,190,39,190,40,171,41,171,42,129,43,129,44,72,45,72,46,27,47,27,162,15,163,15,164,52,165,52,166,93,167,93,168,102,169,102,170,116,171,116,172,127,173,127,174,200,175,200,176,372,177,372,178,532,179,532,180,669,181,669,182,768,183,768,184,836,185,836,186,912,187,912,188,962,189,962,190,930,191,930,192,817,193,817,194,630,195,630,196,438,197,438,198,302,199,302,200,230,201,230,202,203,203,203,204,201,205,201,206,206,207,206,208,200,209,200,210,186,211,186,212,185,213,185,214,220,215,220,216,292,217,292,218,378,219,378,220,470,221,470,222,548,223,548,224,596,225,596,226,612,227,612,228,597,229,597,230,557,231,557,232,508,233,508,234,458,235,458,236,397,237,397,238,324,239,324,240,263,241,263,242,231,243,231,244,228,245,228,246,228,247,228,248,211,249,211,250,182,251,182,252,147,253,147,254,119,255,119,},[21]={0,101,1,101,2,91,3,91,4,83,5,83,6,82,7,82,8,86,9,86,10,97,11,97,12,107,13,107,14,120,15,120,16,124,17,124,18,124,19,124,20,119,21,119,22,106,23,106,24,100,25,100,26,105,27,105,28,111,29,111,30,129,31,129,32,146,33,146,34,162,35,162,36,185,37,185,38,190,39,190,40,171,41,171,42,129,43,129,44,72,45,72,46,27,47,27,162,15,163,15,164,52,165,52,166,93,167,93,168,102,169,102,170,116,171,116,172,127,173,127,174,200,175,200,176,372,177,372,178,532,179,532,180,669,181,669,182,768,183,768,184,836,185,836,186,912,187,912,188,962,189,962,190,930,191,930,192,817,193,817,194,630,195,630,196,438,197,438,198,302,199,302,200,230,201,230,202,203,203,203,204,201,205,201,206,206,207,206,208,200,209,200,210,186,211,186,212,185,213,185,214,220,215,220,216,292,217,292,218,378,219,378,220,470,221,470,222,548,223,548,224,596,225,596,226,612,227,612,228,597,229,597,230,557,231,557,232,508,233,508,234,458,235,458,236,397,237,397,238,324,239,324,240,263,241,263,242,231,243,231,244,228,245,228,246,228,247,228,248,211,249,211,250,182,251,182,252,147,253,147,254,119,255,119,},[22]={0,64,1,64,2,51,3,51,4,40,5,40,6,34,7,34,8,35,9,35,10,49,11,49,12,66,13,66,14,80,15,80,16,87,17,87,18,90,19,90,20,88,21,88,22,83,23,83,24,87,25,87,26,97,27,97,28,108,29,108,30,124,31,124,32,134,33,134,34,143,35,143,36,168,37,168,38,183,39,183,40,174,41,174,42,144,43,144,44,89,45,89,46,38,47,38,162,13,163,13,164,54,165,54,166,85,167,85,168,95,169,95,170,126,171,126,172,163,173,163,174,250,175,250,176,363,177,363,178,435,179,435,180,504,181,504,182,564,183,564,184,640,185,640,186,751,187,751,188,832,189,832,190,811,191,811,192,709,193,709,194,546,195,546,196,378,197,378,198,256,199,256,200,195,201,195,202,171,203,171,204,163,205,163,206,167,207,167,208,161,209,161,210,152,211,152,212,166,213,166,214,221,215,221,216,315,217,315,218,428,219,428,220,542,221,542,222,634,223,634,224,688,225,688,226,694,227,694,228,656,229,656,230,598,231,598,232,541,233,541,234,490,235,490,236,427,237,427,238,344,239,344,240,260,241,260,242,206,243,206,244,190,245,190,246,184,247,184,248,170,249,170,250,148,251,148,252,114,253,114,254,86,255,86,},[23]={0,64,1,64,2,51,3,51,4,40,5,40,6,34,7,34,8,35,9,35,10,49,11,49,12,66,13,66,14,80,15,80,16,87,17,87,18,90,19,90,20,88,21,88,22,83,23,83,24,87,25,87,26,97,27,97,28,108,29,108,30,124,31,124,32,134,33,134,34,143,35,143,36,168,37,168,38,183,39,183,40,174,41,174,42,144,43,144,44,89,45,89,46,38,47,38,162,13,163,13,164,54,165,54,166,85,167,85,168,95,169,95,170,126,171,126,172,163,173,163,174,250,175,250,176,363,177,363,178,435,179,435,180,504,181,504,182,564,183,564,184,640,185,640,186,751,187,751,188,832,189,832,190,811,191,811,192,709,193,709,194,546,195,546,196,378,197,378,198,256,199,256,200,195,201,195,202,171,203,171,204,163,205,163,206,167,207,167,208,161,209,161,210,152,211,152,212,166,213,166,214,221,215,221,216,315,217,315,218,428,219,428,220,542,221,542,222,634,223,634,224,688,225,688,226,694,227,694,228,656,229,656,230,598,231,598,232,541,233,541,234,490,235,490,236,427,237,427,238,344,239,344,240,260,241,260,242,206,243,206,244,190,245,190,246,184,247,184,248,170,249,170,250,148,251,148,252,114,253,114,254,86,255,86,},[24]={0,33,1,33,2,22,3,22,4,15,5,15,6,11,7,11,8,16,9,16,10,25,11,25,12,39,13,39,14,52,15,52,16,59,17,59,18,60,19,60,20,57,21,57,22,55,23,55,24,64,25,64,26,79,27,79,28,92,29,92,30,109,31,109,32,112,33,112,34,112,35,112,36,139,37,139,38,160,39,160,40,161,41,161,42,144,43,144,44,94,45,94,46,41,47,41,162,20,163,20,164,61,165,61,166,88,167,88,168,101,169,101,170,147,171,147,172,200,173,200,174,283,175,283,176,351,177,351,178,359,179,359,180,354,181,354,182,374,183,374,184,448,185,448,186,562,187,562,188,626,189,626,190,613,191,613,192,532,193,532,194,405,195,405,196,277,197,277,198,189,199,189,200,148,201,148,202,129,203,129,204,124,205,124,206,127,207,127,208,121,209,121,210,119,211,119,212,153,213,153,214,239,215,239,216,371,217,371,218,518,219,518,220,646,221,646,222,733,223,733,224,768,225,768,226,752,227,752,228,702,229,702,230,641,231,641,232,586,233,586,234,535,235,535,236,462,237,462,238,358,239,358,240,252,241,252,242,180,243,180,244,153,245,153,246,141,247,141,248,129,249,129,250,110,251,110,252,80,253,80,254,53,255,53,},[25]={0,33,1,33,2,22,3,22,4,15,5,15,6,11,7,11,8,16,9,16,10,25,11,25,12,39,13,39,14,52,15,52,16,59,17,59,18,60,19,60,20,57,21,57,22,55,23,55,24,64,25,64,26,79,27,79,28,92,29,92,30,109,31,109,32,112,33,112,34,112,35,112,36,139,37,139,38,160,39,160,40,161,41,161,42,144,43,144,44,94,45,94,46,41,47,41,162,20,163,20,164,61,165,61,166,88,167,88,168,101,169,101,170,147,171,147,172,200,173,200,174,283,175,283,176,351,177,351,178,359,179,359,180,354,181,354,182,374,183,374,184,448,185,448,186,562,187,562,188,626,189,626,190,613,191,613,192,532,193,532,194,405,195,405,196,277,197,277,198,189,199,189,200,148,201,148,202,129,203,129,204,124,205,124,206,127,207,127,208,121,209,121,210,119,211,119,212,153,213,153,214,239,215,239,216,371,217,371,218,518,219,518,220,646,221,646,222,733,223,733,224,768,225,768,226,752,227,752,228,702,229,702,230,641,231,641,232,586,233,586,234,535,235,535,236,462,237,462,238,358,239,358,240,252,241,252,242,180,243,180,244,153,245,153,246,141,247,141,248,129,249,129,250,110,251,110,252,80,253,80,254,53,255,53,},[26]={14,24,15,24,16,29,17,29,18,30,19,30,20,27,21,27,22,26,23,26,24,36,25,36,26,52,27,52,28,66,29,66,30,81,31,81,32,78,33,78,34,72,35,72,36,96,37,96,38,120,39,120,40,129,41,129,42,128,43,128,44,91,45,91,46,41,47,41,160,10,161,10,162,32,163,32,164,74,165,74,166,99,167,99,168,115,169,115,170,164,171,164,172,220,173,220,174,281,175,281,176,315,177,315,178,298,179,298,180,265,181,265,182,257,183,257,184,313,185,313,186,374,187,374,188,409,189,409,190,398,191,398,192,344,193,344,194,264,195,264,196,183,197,183,198,130,199,130,200,106,201,106,202,93,203,93,204,90,205,90,206,95,207,95,208,90,209,90,210,99,211,99,212,155,213,155,214,279,215,279,216,460,217,460,218,638,219,638,220,772,221,772,222,835,223,835,224,832,225,832,226,800,227,800,228,751,229,751,230,699,231,699,232,654,233,654,234,599,235,599,236,505,237,505,238,373,239,373,240,244,241,244,242,160,243,160,244,123,245,123,246,105,247,105,248,90,249,90,250,70,251,70,252,46,253,46,254,27,255,27,},[27]={14,24,15,24,16,29,17,29,18,30,19,30,20,27,21,27,22,26,23,26,24,36,25,36,26,52,27,52,28,66,29,66,30,81,31,81,32,78,33,78,34,72,35,72,36,96,37,96,38,120,39,120,40,129,41,129,42,128,43,128,44,91,45,91,46,41,47,41,160,10,161,10,162,32,163,32,164,74,165,74,166,99,167,99,168,115,169,115,170,164,171,164,172,220,173,220,174,281,175,281,176,315,177,315,178,298,179,298,180,265,181,265,182,257,183,257,184,313,185,313,186,374,187,374,188,409,189,409,190,398,191,398,192,344,193,344,194,264,195,264,196,183,197,183,198,130,199,130,200,106,201,106,202,93,203,93,204,90,205,90,206,95,207,95,208,90,209,90,210,99,211,99,212,155,213,155,214,279,215,279,216,460,217,460,218,638,219,638,220,772,221,772,222,835,223,835,224,832,225,832,226,800,227,800,228,751,229,751,230,699,231,699,232,654,233,654,234,599,235,599,236,505,237,505,238,373,239,373,240,244,241,244,242,160,243,160,244,123,245,123,246,105,247,105,248,90,249,90,250,70,251,70,252,46,253,46,254,27,255,27,},[28]={24,14,25,14,26,25,27,25,28,34,29,34,30,43,31,43,32,39,33,39,34,33,35,33,36,56,37,56,38,78,39,78,40,88,41,88,42,98,43,98,44,76,45,76,46,38,47,38,160,17,161,17,162,46,163,46,164,88,165,88,166,116,167,116,168,136,169,136,170,178,171,178,172,213,173,213,174,247,175,247,176,265,177,265,178,250,179,250,180,224,181,224,182,219,183,219,184,241,185,241,186,256,187,256,188,260,189,260,190,247,191,247,192,210,193,210,194,161,195,161,196,118,197,118,198,83,199,83,200,68,201,68,202,63,203,63,204,66,205,66,206,76,207,76,208,76,209,76,210,92,211,92,212,161,213,161,214,318,215,318,216,552,217,552,218,755,219,755,220,876,221,876,222,918,223,918,224,902,225,902,226,869,227,869,228,829,229,829,230,795,231,795,232,758,233,758,234,690,235,690,236,567,237,567,238,394,239,394,240,238,241,238,242,145,243,145,244,99,245,99,246,76,247,76,248,57,249,57,250,38,251,38,252,21,253,21,},[29]={24,14,25,14,26,25,27,25,28,34,29,34,30,43,31,43,32,39,33,39,34,33,35,33,36,56,37,56,38,78,39,78,40,88,41,88,42,98,43,98,44,76,45,76,46,38,47,38,160,17,161,17,162,46,163,46,164,88,165,88,166,116,167,116,168,136,169,136,170,178,171,178,172,213,173,213,174,247,175,247,176,265,177,265,178,250,179,250,180,224,181,224,182,219,183,219,184,241,185,241,186,256,187,256,188,260,189,260,190,247,191,247,192,210,193,210,194,161,195,161,196,118,197,118,198,83,199,83,200,68,201,68,202,63,203,63,204,66,205,66,206,76,207,76,208,76,209,76,210,92,211,92,212,161,213,161,214,318,215,318,216,552,217,552,218,755,219,755,220,876,221,876,222,918,223,918,224,902,225,902,226,869,227,869,228,829,229,829,230,795,231,795,232,758,233,758,234,690,235,690,236,567,237,567,238,394,239,394,240,238,241,238,242,145,243,145,244,99,245,99,246,76,247,76,248,57,249,57,250,38,251,38,252,21,253,21,},[30]={32,12,33,12,34,10,35,10,36,28,37,28,38,42,39,42,40,53,41,53,42,65,43,65,44,54,45,54,46,28,47,28,48,9,49,9,158,9,159,9,160,24,161,24,162,59,163,59,164,103,165,103,166,130,167,130,168,153,169,153,170,177,171,177,172,184,173,184,174,200,175,200,176,202,177,202,178,195,179,195,180,192,181,192,182,187,183,187,184,195,185,195,186,187,187,187,188,174,189,174,190,155,191,155,192,126,193,126,194,99,195,99,196,69,197,69,198,47,199,47,200,38,201,38,202,35,203,35,204,46,205,46,206,63,207,63,208,70,209,70,210,88,211,88,212,153,213,153,214,332,215,332,216,596,217,596,218,817,219,817,220,928,221,928,222,961,223,961,224,960,225,960,226,943,227,943,228,921,229,921,230,902,231,902,232,866,233,866,234,773,235,773,236,614,237,614,238,402,239,402,240,221,241,221,242,124,243,124,244,79,245,79,246,54,247,54,248,34,249,34,250,18,251,18,},[31]={32,12,33,12,34,10,35,10,36,28,37,28,38,42,39,42,40,53,41,53,42,65,43,65,44,54,45,54,46,28,47,28,48,9,49,9,158,9,159,9,160,24,161,24,162,59,163,59,164,103,165,103,166,130,167,130,168,153,169,153,170,177,171,177,172,184,173,184,174,200,175,200,176,202,177,202,178,195,179,195,180,192,181,192,182,187,183,187,184,195,185,195,186,187,187,187,188,174,189,174,190,155,191,155,192,126,193,126,194,99,195,99,196,69,197,69,198,47,199,47,200,38,201,38,202,35,203,35,204,46,205,46,206,63,207,63,208,70,209,70,210,88,211,88,212,153,213,153,214,332,215,332,216,596,217,596,218,817,219,817,220,928,221,928,222,961,223,961,224,960,225,960,226,943,227,943,228,921,229,921,230,902,231,902,232,866,233,866,234,773,235,773,236,614,237,614,238,402,239,402,240,221,241,221,242,124,243,124,244,79,245,79,246,54,247,54,248,34,249,34,250,18,251,18,},[32]={38,18,39,18,40,24,41,24,42,32,43,32,44,27,45,27,46,15,47,15,158,8,159,8,160,29,161,29,162,71,163,71,164,118,165,118,166,150,167,150,168,170,169,170,170,172,171,172,172,160,173,160,174,154,175,154,176,138,177,138,178,135,179,135,180,137,181,137,182,139,183,139,184,145,185,145,186,131,187,131,188,112,189,112,190,91,191,91,192,67,193,67,194,49,195,49,196,33,197,33,198,22,199,22,200,15,201,15,202,16,203,16,204,29,205,29,206,49,207,49,208,67,209,67,210,84,211,84,212,139,213,139,214,309,215,309,216,567,217,567,218,792,219,792,220,922,221,922,222,974,223,974,224,989,225,989,226,990,227,990,228,984,229,984,230,969,231,969,232,908,233,908,234,790,235,790,236,606,237,606,238,368,239,368,240,188,241,188,242,102,243,102,244,63,245,63,246,39,247,39,248,21,249,21,},[33]={38,18,39,18,40,24,41,24,42,32,43,32,44,27,45,27,46,15,47,15,158,8,159,8,160,29,161,29,162,71,163,71,164,118,165,118,166,150,167,150,168,170,169,170,170,172,171,172,172,160,173,160,174,154,175,154,176,138,177,138,178,135,179,135,180,137,181,137,182,139,183,139,184,145,185,145,186,131,187,131,188,112,189,112,190,91,191,91,192,67,193,67,194,49,195,49,196,33,197,33,198,22,199,22,200,15,201,15,202,16,203,16,204,29,205,29,206,49,207,49,208,67,209,67,210,84,211,84,212,139,213,139,214,309,215,309,216,567,217,567,218,792,219,792,220,922,221,922,222,974,223,974,224,989,225,989,226,990,227,990,228,984,229,984,230,969,231,969,232,908,233,908,234,790,235,790,236,606,237,606,238,368,239,368,240,188,241,188,242,102,243,102,244,63,245,63,246,39,247,39,248,21,249,21,},[34]={160,37,161,37,162,85,163,85,164,132,165,132,166,166,167,166,168,180,169,180,170,167,171,167,172,142,173,142,174,121,175,121,176,91,177,91,178,79,179,79,180,79,181,79,182,79,183,79,184,81,185,81,186,69,187,69,188,55,189,55,190,41,191,41,192,28,193,28,194,20,195,20,196,13,197,13,206,32,207,32,208,57,209,57,210,75,211,75,212,118,213,118,214,246,215,246,216,458,217,458,218,676,219,676,220,842,221,842,222,934,223,934,224,978,225,978,226,996,227,996,228,999,229,999,230,968,231,968,232,868,233,868,234,724,235,724,236,533,237,533,238,309,239,309,240,149,241,149,242,87,243,87,244,52,245,52,246,28,247,28,248,12,249,12,},[35]={160,37,161,37,162,85,163,85,164,132,165,132,166,166,167,166,168,180,169,180,170,167,171,167,172,142,173,142,174,121,175,121,176,91,177,91,178,79,179,79,180,79,181,79,182,79,183,79,184,81,185,81,186,69,187,69,188,55,189,55,190,41,191,41,192,28,193,28,194,20,195,20,196,13,197,13,206,32,207,32,208,57,209,57,210,75,211,75,212,118,213,118,214,246,215,246,216,458,217,458,218,676,219,676,220,842,221,842,222,934,223,934,224,978,225,978,226,996,227,996,228,999,229,999,230,968,231,968,232,868,233,868,234,724,235,724,236,533,237,533,238,309,239,309,240,149,241,149,242,87,243,87,244,52,245,52,246,28,247,28,248,12,249,12,},[36]={160,42,161,42,162,90,163,90,164,136,165,136,166,164,167,164,168,167,169,167,170,144,171,144,172,114,173,114,174,86,175,86,176,55,177,55,178,42,179,42,180,35,181,35,182,32,183,32,184,31,185,31,186,25,187,25,188,20,189,20,190,15,191,15,206,17,207,17,208,42,209,42,210,70,211,70,212,101,213,101,214,173,215,173,216,312,217,312,218,490,219,490,220,646,221,646,222,785,223,785,224,889,225,889,226,934,227,934,228,940,229,940,230,872,231,872,232,723,233,723,234,562,235,562,236,395,237,395,238,224,239,224,240,122,241,122,242,74,243,74,244,40,245,40,246,18,247,18,},[37]={160,42,161,42,162,90,163,90,164,136,165,136,166,164,167,164,168,167,169,167,170,144,171,144,172,114,173,114,174,86,175,86,176,55,177,55,178,42,179,42,180,35,181,35,182,32,183,32,184,31,185,31,186,25,187,25,188,20,189,20,190,15,191,15,206,17,207,17,208,42,209,42,210,70,211,70,212,101,213,101,214,173,215,173,216,312,217,312,218,490,219,490,220,646,221,646,222,785,223,785,224,889,225,889,226,934,227,934,228,940,229,940,230,872,231,872,232,723,233,723,234,562,235,562,236,395,237,395,238,224,239,224,240,122,241,122,242,74,243,74,244,40,245,40,246,18,247,18,},[38]={160,41,161,41,162,81,163,81,164,119,165,119,166,143,167,143,168,138,169,138,170,114,171,114,172,86,173,86,174,55,175,55,176,31,177,31,178,19,179,19,208,29,209,29,210,62,211,62,212,91,213,91,214,133,215,133,216,197,217,197,218,287,219,287,220,383,221,383,222,546,223,546,224,724,225,724,226,804,227,804,228,813,229,813,230,700,231,700,232,510,233,510,234,373,235,373,236,257,237,257,238,158,239,158,240,101,241,101,242,60,243,60,244,29,245,29,},[39]={160,41,161,41,162,81,163,81,164,119,165,119,166,143,167,143,168,138,169,138,170,114,171,114,172,86,173,86,174,55,175,55,176,31,177,31,178,19,179,19,208,29,209,29,210,62,211,62,212,91,213,91,214,133,215,133,216,197,217,197,218,287,219,287,220,383,221,383,222,546,223,546,224,724,225,724,226,804,227,804,228,813,229,813,230,700,231,700,232,510,233,510,234,373,235,373,236,257,237,257,238,158,239,158,240,101,241,101,242,60,243,60,244,29,245,29,},[40]={160,28,161,28,162,56,163,56,164,85,165,85,166,101,167,101,168,96,169,96,170,80,171,80,172,56,173,56,174,31,175,31,176,14,177,14,208,17,209,17,210,51,211,51,212,88,213,88,214,115,215,115,216,143,217,143,218,160,219,160,220,184,221,184,222,338,223,338,224,537,225,537,226,629,227,629,228,657,229,657,230,527,231,527,232,347,233,347,234,246,235,246,236,180,237,180,238,130,239,130,240,86,241,86,242,47,243,47,244,20,245,20,},[41]={160,28,161,28,162,56,163,56,164,85,165,85,166,101,167,101,168,96,169,96,170,80,171,80,172,56,173,56,174,31,175,31,176,14,177,14,208,17,209,17,210,51,211,51,212,88,213,88,214,115,215,115,216,143,217,143,218,160,219,160,220,184,221,184,222,338,223,338,224,537,225,537,226,629,227,629,228,657,229,657,230,527,231,527,232,347,233,347,234,246,235,246,236,180,237,180,238,130,239,130,240,86,241,86,242,47,243,47,244,20,245,20,},[42]={162,27,163,27,164,44,165,44,166,52,167,52,168,49,169,49,170,42,171,42,172,28,173,28,210,36,211,36,212,74,213,74,214,107,215,107,216,121,217,121,218,114,219,114,220,105,221,105,222,237,223,237,224,399,225,399,226,481,227,481,228,509,229,509,230,395,231,395,232,259,233,259,234,196,235,196,236,154,237,154,238,113,239,113,240,73,241,73,242,35,243,35,},[43]={162,27,163,27,164,44,165,44,166,52,167,52,168,49,169,49,170,42,171,42,172,28,173,28,210,36,211,36,212,74,213,74,214,107,215,107,216,121,217,121,218,114,219,114,220,105,221,105,222,237,223,237,224,399,225,399,226,481,227,481,228,509,229,509,230,395,231,395,232,259,233,259,234,196,235,196,236,154,237,154,238,113,239,113,240,73,241,73,242,35,243,35,},[44]={212,52,213,52,214,91,215,91,216,112,217,112,218,114,219,114,220,109,221,109,222,192,223,192,224,303,225,303,226,356,227,356,228,376,229,376,230,297,231,297,232,207,233,207,234,168,235,168,236,134,237,134,238,99,239,99,240,58,241,58,242,24,243,24,},[45]={212,52,213,52,214,91,215,91,216,112,217,112,218,114,219,114,220,109,221,109,222,192,223,192,224,303,225,303,226,356,227,356,228,376,229,376,230,297,231,297,232,207,233,207,234,168,235,168,236,134,237,134,238,99,239,99,240,58,241,58,242,24,243,24,},[46]={212,30,213,30,214,68,215,68,216,95,217,95,218,112,219,112,220,125,221,125,222,174,223,174,224,229,225,229,226,250,227,250,228,254,229,254,230,210,231,210,232,169,233,169,234,146,235,146,236,116,237,116,238,81,239,81,240,42,241,42,},[47]={212,30,213,30,214,68,215,68,216,95,217,95,218,112,219,112,220,125,221,125,222,174,223,174,224,229,225,229,226,250,227,250,228,254,229,254,230,210,231,210,232,169,233,169,234,146,235,146,236,116,237,116,238,81,239,81,240,42,241,42,},[48]={212,15,213,15,214,45,215,45,216,73,217,73,218,103,219,103,220,128,221,128,222,152,223,152,224,176,225,176,226,177,227,177,228,171,229,171,230,160,231,160,232,146,233,146,234,128,235,128,236,101,237,101,238,62,239,62,240,27,241,27,},[49]={212,15,213,15,214,45,215,45,216,73,217,73,218,103,219,103,220,128,221,128,222,152,223,152,224,176,225,176,226,177,227,177,228,171,229,171,230,160,231,160,232,146,233,146,234,128,235,128,236,101,237,101,238,62,239,62,240,27,241,27,},[50]={214,29,215,29,216,55,217,55,218,90,219,90,220,121,221,121,222,137,223,137,224,152,225,152,226,147,227,147,228,141,229,141,230,140,231,140,232,129,233,129,234,113,235,113,236,84,237,84,238,46,239,46,},[51]={214,29,215,29,216,55,217,55,218,90,219,90,220,121,221,121,222,137,223,137,224,152,225,152,226,147,227,147,228,141,229,141,230,140,231,140,232,129,233,129,234,113,235,113,236,84,237,84,238,46,239,46,},[52]={216,41,217,41,218,76,219,76,220,110,221,110,222,137,223,137,224,156,225,156,226,154,227,154,228,152,229,152,230,146,231,146,232,125,233,125,234,105,235,105,236,72,237,72,238,35,239,35,},[53]={216,41,217,41,218,76,219,76,220,110,221,110,222,137,223,137,224,156,225,156,226,154,227,154,228,152,229,152,230,146,231,146,232,125,233,125,234,105,235,105,236,72,237,72,238,35,239,35,},[54]={216,26,217,26,218,59,219,59,220,99,221,99,222,137,223,137,224,164,225,164,226,171,227,171,228,171,229,171,230,156,231,156,232,130,233,130,234,101,235,101,236,65,237,65,238,30,239,30,},[55]={216,26,217,26,218,59,219,59,220,99,221,99,222,137,223,137,224,164,225,164,226,171,227,171,228,171,229,171,230,156,231,156,232,130,233,130,234,101,235,101,236,65,237,65,238,30,239,30,},[56]={218,42,219,42,220,87,221,87,222,134,223,134,224,173,225,173,226,191,227,191,228,190,229,190,230,169,231,169,232,135,233,135,234,97,235,97,236,56,237,56,238,25,239,25,},[57]={218,42,219,42,220,87,221,87,222,134,223,134,224,173,225,173,226,191,227,191,228,190,229,190,230,169,231,169,232,135,233,135,234,97,235,97,236,56,237,56,238,25,239,25,},[58]={218,27,219,27,220,69,221,69,222,118,223,118,224,164,225,164,226,190,227,190,228,189,229,189,230,170,231,170,232,133,233,133,234,88,235,88,236,47,237,47,},[59]={218,27,219,27,220,69,221,69,222,118,223,118,224,164,225,164,226,190,227,190,228,189,229,189,230,170,231,170,232,133,233,133,234,88,235,88,236,47,237,47,},[60]={220,40,221,40,222,79,223,79,224,131,225,131,226,162,227,162,228,163,229,163,230,151,231,151,232,117,233,117,234,69,235,69,236,32,237,32,},[61]={220,40,221,40,222,79,223,79,224,131,225,131,226,162,227,162,228,163,229,163,230,151,231,151,232,117,233,117,234,69,235,69,236,32,237,32,},[62]={222,38,223,38,224,85,225,85,226,120,227,120,228,125,229,125,230,123,231,123,232,90,233,90,234,46,235,46,},[63]={222,38,223,38,224,85,225,85,226,120,227,120,228,125,229,125,230,123,231,123,232,90,233,90,234,46,235,46,},[64]={224,46,225,46,226,71,227,71,228,81,229,81,230,83,231,83,232,56,233,56,234,25,235,25,},[65]={224,46,225,46,226,71,227,71,228,81,229,81,230,83,231,83,232,56,233,56,234,25,235,25,},[66]={226,33,227,33,228,42,229,42,230,44,231,44,232,26,233,26,},[67]={226,33,227,33,228,42,229,42,230,44,231,44,232,26,233,26,},[68]={228,16,229,16,230,16,231,16,},[69]={228,16,229,16,230,16,231,16,},[122]={234,19,235,19,236,24,237,24,238,22,239,22,240,13,241,13,},[123]={234,19,235,19,236,24,237,24,238,22,239,22,240,13,241,13,},[124]={232,24,233,24,234,50,235,50,236,62,237,62,238,54,239,54,240,32,241,32,},[125]={232,24,233,24,234,50,235,50,236,62,237,62,238,54,239,54,240,32,241,32,},[126]={232,54,233,54,234,88,235,88,236,105,237,105,238,87,239,87,240,56,241,56,242,28,243,28,},[127]={232,54,233,54,234,88,235,88,236,105,237,105,238,87,239,87,240,56,241,56,242,28,243,28,},[128]={230,37,231,37,232,81,233,81,234,123,235,123,236,139,237,139,238,114,239,114,240,77,241,77,242,40,243,40,},[129]={230,37,231,37,232,81,233,81,234,123,235,123,236,139,237,139,238,114,239,114,240,77,241,77,242,40,243,40,},[130]={230,57,231,57,232,106,233,106,234,151,235,151,236,167,237,167,238,138,239,138,240,95,241,95,242,50,243,50,},[131]={230,57,231,57,232,106,233,106,234,151,235,151,236,167,237,167,238,138,239,138,240,95,241,95,242,50,243,50,},[132]={224,8,225,8,226,16,227,16,228,35,229,35,230,75,231,75,232,125,233,125,234,166,235,166,236,179,237,179,238,153,239,153,240,109,241,109,242,63,243,63,244,28,245,28,},[133]={224,8,225,8,226,16,227,16,228,35,229,35,230,75,231,75,232,125,233,125,234,166,235,166,236,179,237,179,238,153,239,153,240,109,241,109,242,63,243,63,244,28,245,28,},[134]={224,25,225,25,226,39,227,39,228,59,229,59,230,93,231,93,232,134,233,134,234,167,235,167,236,177,237,177,238,158,239,158,240,119,241,119,242,76,243,76,244,43,245,43,},[135]={224,25,225,25,226,39,227,39,228,59,229,59,230,93,231,93,232,134,233,134,234,167,235,167,236,177,237,177,238,158,239,158,240,119,241,119,242,76,243,76,244,43,245,43,},[136]={222,24,223,24,224,47,225,47,226,69,227,69,228,90,229,90,230,123,231,123,232,155,233,155,234,173,235,173,236,178,237,178,238,159,239,159,240,123,241,123,242,89,243,89,244,54,245,54,246,25,247,25,},[137]={222,24,223,24,224,47,225,47,226,69,227,69,228,90,229,90,230,123,231,123,232,155,233,155,234,173,235,173,236,178,237,178,238,159,239,159,240,123,241,123,242,89,243,89,244,54,245,54,246,25,247,25,},[138]={220,13,221,13,222,36,223,36,224,68,225,68,226,95,227,95,228,123,229,123,230,167,231,167,232,194,233,194,234,203,235,203,236,197,237,197,238,167,239,167,240,132,241,132,242,102,243,102,244,68,245,68,246,34,247,34,},[139]={220,13,221,13,222,36,223,36,224,68,225,68,226,95,227,95,228,123,229,123,230,167,231,167,232,194,233,194,234,203,235,203,236,197,237,197,238,167,239,167,240,132,241,132,242,102,243,102,244,68,245,68,246,34,247,34,},[140]={220,20,221,20,222,46,223,46,224,81,225,81,226,111,227,111,228,161,229,161,230,234,231,234,232,271,233,271,234,275,235,275,236,247,237,247,238,191,239,191,240,149,241,149,242,122,243,122,244,88,245,88,246,47,247,47,},[141]={220,20,221,20,222,46,223,46,224,81,225,81,226,111,227,111,228,161,229,161,230,234,231,234,232,271,233,271,234,275,235,275,236,247,237,247,238,191,239,191,240,149,241,149,242,122,243,122,244,88,245,88,246,47,247,47,},[142]={218,18,219,18,220,35,221,35,222,58,223,58,224,85,225,85,226,111,227,111,228,189,229,189,230,305,231,305,232,370,233,370,234,376,235,376,236,321,237,321,238,229,239,229,240,169,241,169,242,145,243,145,244,111,245,111,246,65,247,65,248,27,249,27,},[143]={218,18,219,18,220,35,221,35,222,58,223,58,224,85,225,85,226,111,227,111,228,189,229,189,230,305,231,305,232,370,233,370,234,376,235,376,236,321,237,321,238,229,239,229,240,169,241,169,242,145,243,145,244,111,245,111,246,65,247,65,248,27,249,27,},[144]={216,24,217,24,218,45,219,45,220,58,221,58,222,72,223,72,224,80,225,80,226,100,227,100,228,211,229,211,230,384,231,384,232,496,233,496,234,510,235,510,236,426,237,426,238,283,239,283,240,194,241,194,242,167,243,167,244,134,245,134,246,84,247,84,248,38,249,38,},[145]={216,24,217,24,218,45,219,45,220,58,221,58,222,72,223,72,224,80,225,80,226,100,227,100,228,211,229,211,230,384,231,384,232,496,233,496,234,510,235,510,236,426,237,426,238,283,239,283,240,194,241,194,242,167,243,167,244,134,245,134,246,84,247,84,248,38,249,38,},[146]={158,15,159,15,160,17,161,17,162,16,163,16,164,18,165,18,166,15,167,15,214,21,215,21,216,50,217,50,218,73,219,73,220,82,221,82,222,86,223,86,224,92,225,92,226,129,227,129,228,264,229,264,230,481,231,481,232,613,233,613,234,615,235,615,236,513,237,513,238,332,239,332,240,215,241,215,242,180,243,180,244,149,245,149,246,100,247,100,248,48,249,48,},[147]={158,15,159,15,160,17,161,17,162,16,163,16,164,18,165,18,166,15,167,15,214,21,215,21,216,50,217,50,218,73,219,73,220,82,221,82,222,86,223,86,224,92,225,92,226,129,227,129,228,264,229,264,230,481,231,481,232,613,233,613,234,615,235,615,236,513,237,513,238,332,239,332,240,215,241,215,242,180,243,180,244,149,245,149,246,100,247,100,248,48,249,48,},[148]={156,9,157,9,158,23,159,23,160,28,161,28,162,35,163,35,164,44,165,44,166,42,167,42,168,38,169,38,170,29,171,29,212,16,213,16,214,39,215,39,216,73,217,73,218,108,219,108,220,139,221,139,222,159,223,159,224,190,225,190,226,258,227,258,228,410,229,410,230,634,231,634,232,755,233,755,234,735,235,735,236,609,237,609,238,396,239,396,240,252,241,252,242,194,243,194,244,155,245,155,246,111,247,111,248,59,249,59,},[149]={156,9,157,9,158,23,159,23,160,28,161,28,162,35,163,35,164,44,165,44,166,42,167,42,168,38,169,38,170,29,171,29,212,16,213,16,214,39,215,39,216,73,217,73,218,108,219,108,220,139,221,139,222,159,223,159,224,190,225,190,226,258,227,258,228,410,229,410,230,634,231,634,232,755,233,755,234,735,235,735,236,609,237,609,238,396,239,396,240,252,241,252,242,194,243,194,244,155,245,155,246,111,247,111,248,59,249,59,},[150]={156,11,157,11,158,28,159,28,160,40,161,40,162,57,163,57,164,73,165,73,166,77,167,77,168,76,169,76,170,63,171,63,172,48,173,48,174,43,175,43,176,41,177,41,178,38,179,38,180,34,181,34,182,21,183,21,212,32,213,32,214,60,215,60,216,102,217,102,218,160,219,160,220,227,221,227,222,292,223,292,224,373,225,373,226,468,227,468,228,619,229,619,230,798,231,798,232,870,233,870,234,864,235,864,236,747,237,747,238,521,239,521,240,338,241,338,242,241,243,241,244,179,245,179,246,128,247,128,248,73,249,73,250,32,251,32,252,12,253,12,},[151]={156,11,157,11,158,28,159,28,160,40,161,40,162,57,163,57,164,73,165,73,166,77,167,77,168,76,169,76,170,63,171,63,172,48,173,48,174,43,175,43,176,41,177,41,178,38,179,38,180,34,181,34,182,21,183,21,212,32,213,32,214,60,215,60,216,102,217,102,218,160,219,160,220,227,221,227,222,292,223,292,224,373,225,373,226,468,227,468,228,619,229,619,230,798,231,798,232,870,233,870,234,864,235,864,236,747,237,747,238,521,239,521,240,338,241,338,242,241,243,241,244,179,245,179,246,128,247,128,248,73,249,73,250,32,251,32,252,12,253,12,},[152]={156,7,157,7,158,23,159,23,160,39,161,39,162,67,163,67,164,91,165,91,166,102,167,102,168,105,169,105,170,91,171,91,172,80,173,80,174,78,175,78,176,71,177,71,178,68,179,68,180,62,181,62,182,42,183,42,184,27,185,27,186,15,187,15,210,29,211,29,212,58,213,58,214,87,215,87,216,135,217,135,218,219,219,219,220,323,221,323,222,442,223,442,224,563,225,563,226,686,227,686,228,811,229,811,230,916,231,916,232,958,233,958,234,955,235,955,236,887,237,887,238,701,239,701,240,501,241,501,242,360,243,360,244,257,245,257,246,168,247,168,248,99,249,99,250,54,251,54,252,24,253,24,},[153]={156,7,157,7,158,23,159,23,160,39,161,39,162,67,163,67,164,91,165,91,166,102,167,102,168,105,169,105,170,91,171,91,172,80,173,80,174,78,175,78,176,71,177,71,178,68,179,68,180,62,181,62,182,42,183,42,184,27,185,27,186,15,187,15,210,29,211,29,212,58,213,58,214,87,215,87,216,135,217,135,218,219,219,219,220,323,221,323,222,442,223,442,224,563,225,563,226,686,227,686,228,811,229,811,230,916,231,916,232,958,233,958,234,955,235,955,236,887,237,887,238,701,239,701,240,501,241,501,242,360,243,360,244,257,245,257,246,168,247,168,248,99,249,99,250,54,251,54,252,24,253,24,},[154]={160,35,161,35,162,68,163,68,164,93,165,93,166,109,167,109,168,118,169,118,170,110,171,110,172,106,173,106,174,104,175,104,176,93,177,93,178,88,179,88,180,81,181,81,182,62,183,62,184,47,185,47,186,31,187,31,188,17,189,17,190,10,191,10,208,26,209,26,210,59,211,59,212,89,213,89,214,115,215,115,216,166,217,166,218,252,219,252,220,386,221,386,222,549,223,549,224,708,225,708,226,837,227,837,228,926,229,926,230,971,231,971,232,995,233,995,234,1004,235,1004,236,974,237,974,238,865,239,865,240,714,241,714,242,563,243,563,244,411,245,411,246,255,247,255,248,139,249,139,250,77,251,77,252,35,253,35,},[155]={160,35,161,35,162,68,163,68,164,93,165,93,166,109,167,109,168,118,169,118,170,110,171,110,172,106,173,106,174,104,175,104,176,93,177,93,178,88,179,88,180,81,181,81,182,62,183,62,184,47,185,47,186,31,187,31,188,17,189,17,190,10,191,10,208,26,209,26,210,59,211,59,212,89,213,89,214,115,215,115,216,166,217,166,218,252,219,252,220,386,221,386,222,549,223,549,224,708,225,708,226,837,227,837,228,926,229,926,230,971,231,971,232,995,233,995,234,1004,235,1004,236,974,237,974,238,865,239,865,240,714,241,714,242,563,243,563,244,411,245,411,246,255,247,255,248,139,249,139,250,77,251,77,252,35,253,35,},[156]={32,9,33,9,34,10,35,10,36,7,37,7,38,3,39,3,160,35,161,35,162,69,163,69,164,98,165,98,166,125,167,125,168,138,169,138,170,138,171,138,172,136,173,136,174,122,175,122,176,101,177,101,178,93,179,93,180,86,181,86,182,73,183,73,184,61,185,61,186,44,187,44,188,30,189,30,190,21,191,21,192,20,193,20,194,25,195,25,196,26,197,26,198,26,199,26,200,28,201,28,202,30,203,30,204,25,205,25,206,26,207,26,208,49,209,49,210,84,211,84,212,113,213,113,214,134,215,134,216,173,217,173,218,254,219,254,220,403,221,403,222,599,223,599,224,783,225,783,226,909,227,909,228,966,229,966,230,994,231,994,232,1008,233,1008,234,1014,235,1014,236,1013,237,1013,238,967,239,967,240,887,241,887,242,763,243,763,244,582,245,582,246,355,247,355,248,180,249,180,250,103,251,103,252,49,253,49,},[157]={32,9,33,9,34,10,35,10,36,7,37,7,38,3,39,3,160,35,161,35,162,69,163,69,164,98,165,98,166,125,167,125,168,138,169,138,170,138,171,138,172,136,173,136,174,122,175,122,176,101,177,101,178,93,179,93,180,86,181,86,182,73,183,73,184,61,185,61,186,44,187,44,188,30,189,30,190,21,191,21,192,20,193,20,194,25,195,25,196,26,197,26,198,26,199,26,200,28,201,28,202,30,203,30,204,25,205,25,206,26,207,26,208,49,209,49,210,84,211,84,212,113,213,113,214,134,215,134,216,173,217,173,218,254,219,254,220,403,221,403,222,599,223,599,224,783,225,783,226,909,227,909,228,966,229,966,230,994,231,994,232,1008,233,1008,234,1014,235,1014,236,1013,237,1013,238,967,239,967,240,887,241,887,242,763,243,763,244,582,245,582,246,355,247,355,248,180,249,180,250,103,251,103,252,49,253,49,},[158]={30,19,31,19,32,24,33,24,34,25,35,25,36,19,37,19,38,10,39,10,160,35,161,35,162,65,163,65,164,103,165,103,166,153,167,153,168,182,169,182,170,195,171,195,172,186,173,186,174,150,175,150,176,115,177,115,178,102,179,102,180,95,181,95,182,83,183,83,184,71,185,71,186,60,187,60,188,51,189,51,190,57,191,57,192,73,193,73,194,80,195,80,196,78,197,78,198,73,199,73,200,71,201,71,202,64,203,64,204,50,205,50,206,46,207,46,208,66,209,66,210,96,211,96,212,120,213,120,214,133,215,133,216,160,217,160,218,227,219,227,220,376,221,376,222,581,223,581,224,775,225,775,226,903,227,903,228,970,229,970,230,996,231,996,232,1007,233,1007,234,1013,235,1013,236,1015,237,1015,238,1009,239,1009,240,976,241,976,242,888,243,888,244,707,245,707,246,439,247,439,248,230,249,230,250,133,251,133,252,70,253,70,},[159]={30,19,31,19,32,24,33,24,34,25,35,25,36,19,37,19,38,10,39,10,160,35,161,35,162,65,163,65,164,103,165,103,166,153,167,153,168,182,169,182,170,195,171,195,172,186,173,186,174,150,175,150,176,115,177,115,178,102,179,102,180,95,181,95,182,83,183,83,184,71,185,71,186,60,187,60,188,51,189,51,190,57,191,57,192,73,193,73,194,80,195,80,196,78,197,78,198,73,199,73,200,71,201,71,202,64,203,64,204,50,205,50,206,46,207,46,208,66,209,66,210,96,211,96,212,120,213,120,214,133,215,133,216,160,217,160,218,227,219,227,220,376,221,376,222,581,223,581,224,775,225,775,226,903,227,903,228,970,229,970,230,996,231,996,232,1007,233,1007,234,1013,235,1013,236,1015,237,1015,238,1009,239,1009,240,976,241,976,242,888,243,888,244,707,245,707,246,439,247,439,248,230,249,230,250,133,251,133,252,70,253,70,},[160]={0,6,1,6,26,20,27,20,28,31,29,31,30,40,31,40,32,45,33,45,34,45,35,45,36,35,37,35,38,19,39,19,160,31,161,31,162,56,163,56,164,104,165,104,166,172,167,172,168,226,169,226,170,267,171,267,172,265,173,265,174,222,175,222,176,185,177,185,178,160,179,160,180,142,181,142,182,145,183,145,184,161,185,161,186,180,187,180,188,193,189,193,190,194,191,194,192,191,193,191,194,176,195,176,196,153,197,153,198,133,199,133,200,117,201,117,202,97,203,97,204,71,205,71,206,59,207,59,208,71,209,71,210,88,211,88,212,105,213,105,214,114,215,114,216,130,217,130,218,186,219,186,220,315,221,315,222,505,223,505,224,692,225,692,226,839,227,839,228,936,229,936,230,969,231,969,232,975,233,975,234,977,235,977,236,969,237,969,238,976,239,976,240,974,241,974,242,892,243,892,244,737,245,737,246,482,247,482,248,274,249,274,250,164,251,164,252,90,253,90,254,36,255,36,},[161]={0,6,1,6,26,20,27,20,28,31,29,31,30,40,31,40,32,45,33,45,34,45,35,45,36,35,37,35,38,19,39,19,160,31,161,31,162,56,163,56,164,104,165,104,166,172,167,172,168,226,169,226,170,267,171,267,172,265,173,265,174,222,175,222,176,185,177,185,178,160,179,160,180,142,181,142,182,145,183,145,184,161,185,161,186,180,187,180,188,193,189,193,190,194,191,194,192,191,193,191,194,176,195,176,196,153,197,153,198,133,199,133,200,117,201,117,202,97,203,97,204,71,205,71,206,59,207,59,208,71,209,71,210,88,211,88,212,105,213,105,214,114,215,114,216,130,217,130,218,186,219,186,220,315,221,315,222,505,223,505,224,692,225,692,226,839,227,839,228,936,229,936,230,969,231,969,232,975,233,975,234,977,235,977,236,969,237,969,238,976,239,976,240,974,241,974,242,892,243,892,244,737,245,737,246,482,247,482,248,274,249,274,250,164,251,164,252,90,253,90,254,36,255,36,},[162]={0,11,1,11,18,12,19,12,20,18,21,18,22,27,23,27,24,39,25,39,26,49,27,49,28,61,29,61,30,66,31,66,32,67,33,67,34,64,35,64,36,48,37,48,38,27,39,27,40,11,41,11,160,24,161,24,162,44,163,44,164,96,165,96,166,178,167,178,168,251,169,251,170,325,171,325,172,354,173,354,174,336,175,336,176,321,177,321,178,295,179,295,180,272,181,272,182,299,183,299,184,365,185,365,186,427,187,427,188,453,189,453,190,428,191,428,192,361,193,361,194,296,195,296,196,235,197,235,198,190,199,190,200,156,201,156,202,123,203,123,204,86,205,86,206,66,207,66,208,64,209,64,210,68,211,68,212,81,213,81,214,89,215,89,216,104,217,104,218,149,219,149,220,246,221,246,222,402,223,402,224,575,225,575,226,735,227,735,228,852,229,852,230,900,231,900,232,905,233,905,234,897,235,897,236,877,237,877,238,873,239,873,240,863,241,863,242,781,243,781,244,657,245,657,246,460,247,460,248,279,249,279,250,179,251,179,252,100,253,100,254,47,255,47,},[163]={0,11,1,11,18,12,19,12,20,18,21,18,22,27,23,27,24,39,25,39,26,49,27,49,28,61,29,61,30,66,31,66,32,67,33,67,34,64,35,64,36,48,37,48,38,27,39,27,40,11,41,11,160,24,161,24,162,44,163,44,164,96,165,96,166,178,167,178,168,251,169,251,170,325,171,325,172,354,173,354,174,336,175,336,176,321,177,321,178,295,179,295,180,272,181,272,182,299,183,299,184,365,185,365,186,427,187,427,188,453,189,453,190,428,191,428,192,361,193,361,194,296,195,296,196,235,197,235,198,190,199,190,200,156,201,156,202,123,203,123,204,86,205,86,206,66,207,66,208,64,209,64,210,68,211,68,212,81,213,81,214,89,215,89,216,104,217,104,218,149,219,149,220,246,221,246,222,402,223,402,224,575,225,575,226,735,227,735,228,852,229,852,230,900,231,900,232,905,233,905,234,897,235,897,236,877,237,877,238,873,239,873,240,863,241,863,242,781,243,781,244,657,245,657,246,460,247,460,248,279,249,279,250,179,251,179,252,100,253,100,254,47,255,47,},[164]={0,17,1,17,10,11,11,11,12,20,13,20,14,25,15,25,16,28,17,28,18,30,19,30,20,36,21,36,22,50,23,50,24,65,25,65,26,77,27,77,28,93,29,93,30,95,31,95,32,93,33,93,34,85,35,85,36,60,37,60,38,34,39,34,40,16,41,16,160,15,161,15,162,28,163,28,164,73,165,73,166,151,167,151,168,235,169,235,170,337,171,337,172,403,173,403,174,440,175,440,176,476,177,476,178,478,179,478,180,480,181,480,182,544,183,544,184,636,185,636,186,710,187,710,188,731,189,731,190,657,191,657,192,538,193,538,194,418,195,418,196,312,197,312,198,237,199,237,200,184,201,184,202,139,203,139,204,96,205,96,206,67,207,67,208,53,209,53,210,50,211,50,212,60,213,60,214,72,215,72,216,92,217,92,218,127,219,127,220,194,221,194,222,311,223,311,224,457,225,457,226,611,227,611,228,733,229,733,230,791,231,791,232,799,233,799,234,781,235,781,236,748,237,748,238,735,239,735,240,690,241,690,242,614,243,614,244,524,245,524,246,381,247,381,248,257,249,257,250,172,251,172,252,103,253,103,254,54,255,54,},[165]={0,17,1,17,10,11,11,11,12,20,13,20,14,25,15,25,16,28,17,28,18,30,19,30,20,36,21,36,22,50,23,50,24,65,25,65,26,77,27,77,28,93,29,93,30,95,31,95,32,93,33,93,34,85,35,85,36,60,37,60,38,34,39,34,40,16,41,16,160,15,161,15,162,28,163,28,164,73,165,73,166,151,167,151,168,235,169,235,170,337,171,337,172,403,173,403,174,440,175,440,176,476,177,476,178,478,179,478,180,480,181,480,182,544,183,544,184,636,185,636,186,710,187,710,188,731,189,731,190,657,191,657,192,538,193,538,194,418,195,418,196,312,197,312,198,237,199,237,200,184,201,184,202,139,203,139,204,96,205,96,206,67,207,67,208,53,209,53,210,50,211,50,212,60,213,60,214,72,215,72,216,92,217,92,218,127,219,127,220,194,221,194,222,311,223,311,224,457,225,457,226,611,227,611,228,733,229,733,230,791,231,791,232,799,233,799,234,781,235,781,236,748,237,748,238,735,239,735,240,690,241,690,242,614,243,614,244,524,245,524,246,381,247,381,248,257,249,257,250,172,251,172,252,103,253,103,254,54,255,54,},[166]={0,26,1,26,10,36,11,36,12,46,13,46,14,52,15,52,16,53,17,53,18,50,19,50,20,55,21,55,22,74,23,74,24,96,25,96,26,122,27,122,28,147,29,147,30,147,31,147,32,134,33,134,34,110,35,110,36,71,37,71,38,40,39,40,40,19,41,19,162,14,163,14,164,44,165,44,166,101,167,101,168,176,169,176,170,283,171,283,172,378,173,378,174,476,175,476,176,580,177,580,178,646,179,646,180,695,181,695,182,770,183,770,184,848,185,848,186,898,187,898,188,904,189,904,190,823,191,823,192,674,193,674,194,514,195,514,196,371,197,371,198,266,199,266,200,196,201,196,202,144,203,144,204,99,205,99,206,65,207,65,208,47,209,47,210,41,211,41,212,49,213,49,214,65,215,65,216,88,217,88,218,120,219,120,220,171,221,171,222,256,223,256,224,375,225,375,226,509,227,509,228,619,229,619,230,677,231,677,232,680,233,680,234,649,235,649,236,607,237,607,238,568,239,568,240,516,241,516,242,451,243,451,244,384,245,384,246,295,247,295,248,210,249,210,250,148,251,148,252,96,253,96,254,57,255,57,},[167]={0,26,1,26,10,36,11,36,12,46,13,46,14,52,15,52,16,53,17,53,18,50,19,50,20,55,21,55,22,74,23,74,24,96,25,96,26,122,27,122,28,147,29,147,30,147,31,147,32,134,33,134,34,110,35,110,36,71,37,71,38,40,39,40,40,19,41,19,162,14,163,14,164,44,165,44,166,101,167,101,168,176,169,176,170,283,171,283,172,378,173,378,174,476,175,476,176,580,177,580,178,646,179,646,180,695,181,695,182,770,183,770,184,848,185,848,186,898,187,898,188,904,189,904,190,823,191,823,192,674,193,674,194,514,195,514,196,371,197,371,198,266,199,266,200,196,201,196,202,144,203,144,204,99,205,99,206,65,207,65,208,47,209,47,210,41,211,41,212,49,213,49,214,65,215,65,216,88,217,88,218,120,219,120,220,171,221,171,222,256,223,256,224,375,225,375,226,509,227,509,228,619,229,619,230,677,231,677,232,680,233,680,234,649,235,649,236,607,237,607,238,568,239,568,240,516,241,516,242,451,243,451,244,384,245,384,246,295,247,295,248,210,249,210,250,148,251,148,252,96,253,96,254,57,255,57,},[168]={0,37,1,37,2,30,3,30,4,32,5,32,6,40,7,40,8,56,9,56,10,71,11,71,12,81,13,81,14,89,15,89,16,87,17,87,18,75,19,75,20,73,21,73,22,93,23,93,24,126,25,126,26,173,27,173,28,213,29,213,30,211,31,211,32,182,33,182,34,135,35,135,36,79,37,79,38,42,39,42,40,20,41,20,164,24,165,24,166,65,167,65,168,116,169,116,170,200,171,200,172,296,173,296,174,427,175,427,176,599,177,599,178,744,179,744,180,839,181,839,182,910,183,910,184,955,185,955,186,978,187,978,188,982,189,982,190,901,191,901,192,748,193,748,194,570,195,570,196,402,197,402,198,276,199,276,200,194,201,194,202,138,203,138,204,93,205,93,206,62,207,62,208,47,209,47,210,39,211,39,212,46,213,46,214,63,215,63,216,87,217,87,218,122,219,122,220,165,221,165,222,228,223,228,224,328,225,328,226,438,227,438,228,528,229,528,230,573,231,573,232,560,233,560,234,516,235,516,236,468,237,468,238,423,239,423,240,374,241,374,242,324,243,324,244,277,245,277,246,220,247,220,248,165,249,165,250,123,251,123,252,86,253,86,254,60,255,60,},[169]={0,37,1,37,2,30,3,30,4,32,5,32,6,40,7,40,8,56,9,56,10,71,11,71,12,81,13,81,14,89,15,89,16,87,17,87,18,75,19,75,20,73,21,73,22,93,23,93,24,126,25,126,26,173,27,173,28,213,29,213,30,211,31,211,32,182,33,182,34,135,35,135,36,79,37,79,38,42,39,42,40,20,41,20,164,24,165,24,166,65,167,65,168,116,169,116,170,200,171,200,172,296,173,296,174,427,175,427,176,599,177,599,178,744,179,744,180,839,181,839,182,910,183,910,184,955,185,955,186,978,187,978,188,982,189,982,190,901,191,901,192,748,193,748,194,570,195,570,196,402,197,402,198,276,199,276,200,194,201,194,202,138,203,138,204,93,205,93,206,62,207,62,208,47,209,47,210,39,211,39,212,46,213,46,214,63,215,63,216,87,217,87,218,122,219,122,220,165,221,165,222,228,223,228,224,328,225,328,226,438,227,438,228,528,229,528,230,573,231,573,232,560,233,560,234,516,235,516,236,468,237,468,238,423,239,423,240,374,241,374,242,324,243,324,244,277,245,277,246,220,247,220,248,165,249,165,250,123,251,123,252,86,253,86,254,60,255,60,},[170]={0,51,1,51,2,50,3,50,4,64,5,64,6,84,7,84,8,112,9,112,10,134,11,134,12,142,13,142,14,140,15,140,16,121,17,121,18,102,19,102,20,97,21,97,22,118,23,118,24,171,25,171,26,237,27,237,28,282,29,282,30,273,31,273,32,220,33,220,34,148,35,148,36,81,37,81,38,40,39,40,40,18,41,18,164,20,165,20,166,50,167,50,168,80,169,80,170,133,171,133,172,193,173,193,174,327,175,327,176,546,177,546,178,755,179,755,180,891,181,891,182,958,183,958,184,989,185,989,186,998,187,998,188,987,189,987,190,904,191,904,192,751,193,751,194,576,195,576,196,404,197,404,198,269,199,269,200,183,201,183,202,126,203,126,204,83,205,83,206,57,207,57,208,47,209,47,210,40,211,40,212,47,213,47,214,61,215,61,216,86,217,86,218,123,219,123,220,162,221,162,222,214,223,214,224,296,225,296,226,385,227,385,228,453,229,453,230,479,231,479,232,455,233,455,234,405,235,405,236,357,237,357,238,316,239,316,240,277,241,277,242,240,243,240,244,207,245,207,246,172,247,172,248,137,249,137,250,110,251,110,252,86,253,86,254,68,255,68,},[171]={0,51,1,51,2,50,3,50,4,64,5,64,6,84,7,84,8,112,9,112,10,134,11,134,12,142,13,142,14,140,15,140,16,121,17,121,18,102,19,102,20,97,21,97,22,118,23,118,24,171,25,171,26,237,27,237,28,282,29,282,30,273,31,273,32,220,33,220,34,148,35,148,36,81,37,81,38,40,39,40,40,18,41,18,164,20,165,20,166,50,167,50,168,80,169,80,170,133,171,133,172,193,173,193,174,327,175,327,176,546,177,546,178,755,179,755,180,891,181,891,182,958,183,958,184,989,185,989,186,998,187,998,188,987,189,987,190,904,191,904,192,751,193,751,194,576,195,576,196,404,197,404,198,269,199,269,200,183,201,183,202,126,203,126,204,83,205,83,206,57,207,57,208,47,209,47,210,40,211,40,212,47,213,47,214,61,215,61,216,86,217,86,218,123,219,123,220,162,221,162,222,214,223,214,224,296,225,296,226,385,227,385,228,453,229,453,230,479,231,479,232,455,233,455,234,405,235,405,236,357,237,357,238,316,239,316,240,277,241,277,242,240,243,240,244,207,245,207,246,172,247,172,248,137,249,137,250,110,251,110,252,86,253,86,254,68,255,68,},[172]={0,64,1,64,2,69,3,69,4,104,5,104,6,151,7,151,8,201,9,201,10,239,11,239,12,257,13,257,14,245,15,245,16,205,17,205,18,164,19,164,20,147,21,147,22,179,23,179,24,242,25,242,26,308,27,308,28,343,29,343,30,314,31,314,32,237,33,237,34,149,35,149,36,78,37,78,38,36,39,36,40,15,41,15,164,23,165,23,166,47,167,47,168,67,169,67,170,95,171,95,172,118,173,118,174,247,175,247,176,498,177,498,178,732,179,732,180,884,181,884,182,965,183,965,184,1000,185,1000,186,995,187,995,188,959,189,959,190,860,191,860,192,703,193,703,194,544,195,544,196,386,197,386,198,260,199,260,200,174,201,174,202,116,203,116,204,73,205,73,206,53,207,53,208,46,209,46,210,41,211,41,212,47,213,47,214,58,215,58,216,81,217,81,218,116,219,116,220,151,221,151,222,198,223,198,224,266,225,266,226,339,227,339,228,392,229,392,230,403,231,403,232,376,233,376,234,329,235,329,236,288,237,288,238,256,239,256,240,226,241,226,242,200,243,200,244,176,245,176,246,155,247,155,248,133,249,133,250,114,251,114,252,95,253,95,254,79,255,79,},[173]={0,64,1,64,2,69,3,69,4,104,5,104,6,151,7,151,8,201,9,201,10,239,11,239,12,257,13,257,14,245,15,245,16,205,17,205,18,164,19,164,20,147,21,147,22,179,23,179,24,242,25,242,26,308,27,308,28,343,29,343,30,314,31,314,32,237,33,237,34,149,35,149,36,78,37,78,38,36,39,36,40,15,41,15,164,23,165,23,166,47,167,47,168,67,169,67,170,95,171,95,172,118,173,118,174,247,175,247,176,498,177,498,178,732,179,732,180,884,181,884,182,965,183,965,184,1000,185,1000,186,995,187,995,188,959,189,959,190,860,191,860,192,703,193,703,194,544,195,544,196,386,197,386,198,260,199,260,200,174,201,174,202,116,203,116,204,73,205,73,206,53,207,53,208,46,209,46,210,41,211,41,212,47,213,47,214,58,215,58,216,81,217,81,218,116,219,116,220,151,221,151,222,198,223,198,224,266,225,266,226,339,227,339,228,392,229,392,230,403,231,403,232,376,233,376,234,329,235,329,236,288,237,288,238,256,239,256,240,226,241,226,242,200,243,200,244,176,245,176,246,155,247,155,248,133,249,133,250,114,251,114,252,95,253,95,254,79,255,79,},[174]={0,77,1,77,2,91,3,91,4,156,5,156,6,244,7,244,8,331,9,331,10,395,11,395,12,426,13,426,14,404,15,404,16,354,17,354,18,305,19,305,20,278,21,278,22,302,23,302,24,354,25,354,26,372,27,372,28,360,29,360,30,306,31,306,32,215,33,215,34,132,35,132,36,69,37,69,38,30,39,30,40,12,41,12,166,46,167,46,168,69,169,69,170,91,171,91,172,118,173,118,174,270,175,270,176,524,177,524,178,749,179,749,180,895,181,895,182,971,183,971,184,1004,185,1004,186,985,187,985,188,919,189,919,190,793,191,793,192,639,193,639,194,502,195,502,196,369,197,369,198,257,199,257,200,174,201,174,202,112,203,112,204,68,205,68,206,48,207,48,208,41,209,41,210,37,211,37,212,41,213,41,214,49,215,49,216,70,217,70,218,100,219,100,220,134,221,134,222,182,223,182,224,242,225,242,226,306,227,306,228,346,229,346,230,348,231,348,232,322,233,322,234,283,235,283,236,252,237,252,238,230,239,230,240,211,241,211,242,191,243,191,244,174,245,174,246,160,247,160,248,146,249,146,250,129,251,129,252,110,253,110,254,93,255,93,},[175]={0,77,1,77,2,91,3,91,4,156,5,156,6,244,7,244,8,331,9,331,10,395,11,395,12,426,13,426,14,404,15,404,16,354,17,354,18,305,19,305,20,278,21,278,22,302,23,302,24,354,25,354,26,372,27,372,28,360,29,360,30,306,31,306,32,215,33,215,34,132,35,132,36,69,37,69,38,30,39,30,40,12,41,12,166,46,167,46,168,69,169,69,170,91,171,91,172,118,173,118,174,270,175,270,176,524,177,524,178,749,179,749,180,895,181,895,182,971,183,971,184,1004,185,1004,186,985,187,985,188,919,189,919,190,793,191,793,192,639,193,639,194,502,195,502,196,369,197,369,198,257,199,257,200,174,201,174,202,112,203,112,204,68,205,68,206,48,207,48,208,41,209,41,210,37,211,37,212,41,213,41,214,49,215,49,216,70,217,70,218,100,219,100,220,134,221,134,222,182,223,182,224,242,225,242,226,306,227,306,228,346,229,346,230,348,231,348,232,322,233,322,234,283,235,283,236,252,237,252,238,230,239,230,240,211,241,211,242,191,243,191,244,174,245,174,246,160,247,160,248,146,249,146,250,129,251,129,252,110,253,110,254,93,255,93,},[176]={0,94,1,94,2,123,3,123,4,224,5,224,6,360,7,360,8,493,9,493,10,587,11,587,12,628,13,628,14,605,15,605,16,541,17,541,18,495,19,495,20,473,21,473,22,466,23,466,24,462,25,462,26,411,27,411,28,339,29,339,30,264,31,264,32,179,33,179,34,110,35,110,36,57,37,57,38,24,39,24,166,38,167,38,168,69,169,69,170,104,171,104,172,165,173,165,174,357,175,357,176,597,177,597,178,801,179,801,180,926,181,926,182,984,183,984,184,1005,185,1005,186,963,187,963,188,863,189,863,190,717,191,717,192,579,193,579,194,467,195,467,196,359,197,359,198,263,199,263,200,180,201,180,202,114,203,114,204,67,205,67,206,45,207,45,208,35,209,35,210,30,211,30,212,32,213,32,214,38,215,38,216,57,217,57,218,83,219,83,220,121,221,121,222,170,223,170,224,225,225,225,226,282,227,282,228,311,229,311,230,307,231,307,232,283,233,283,234,255,235,255,236,235,237,235,238,224,239,224,240,213,241,213,242,200,243,200,244,187,245,187,246,177,247,177,248,164,249,164,250,146,251,146,252,125,253,125,254,109,255,109,},[177]={0,94,1,94,2,123,3,123,4,224,5,224,6,360,7,360,8,493,9,493,10,587,11,587,12,628,13,628,14,605,15,605,16,541,17,541,18,495,19,495,20,473,21,473,22,466,23,466,24,462,25,462,26,411,27,411,28,339,29,339,30,264,31,264,32,179,33,179,34,110,35,110,36,57,37,57,38,24,39,24,166,38,167,38,168,69,169,69,170,104,171,104,172,165,173,165,174,357,175,357,176,597,177,597,178,801,179,801,180,926,181,926,182,984,183,984,184,1005,185,1005,186,963,187,963,188,863,189,863,190,717,191,717,192,579,193,579,194,467,195,467,196,359,197,359,198,263,199,263,200,180,201,180,202,114,203,114,204,67,205,67,206,45,207,45,208,35,209,35,210,30,211,30,212,32,213,32,214,38,215,38,216,57,217,57,218,83,219,83,220,121,221,121,222,170,223,170,224,225,225,225,226,282,227,282,228,311,229,311,230,307,231,307,232,283,233,283,234,255,235,255,236,235,237,235,238,224,239,224,240,213,241,213,242,200,243,200,244,187,245,187,246,177,247,177,248,164,249,164,250,146,251,146,252,125,253,125,254,109,255,109,},[178]={0,113,1,113,2,162,3,162,4,298,5,298,6,485,7,485,8,660,9,660,10,771,11,771,12,816,13,816,14,793,15,793,16,735,17,735,18,703,19,703,20,671,21,671,22,631,23,631,24,540,25,540,26,400,27,400,28,292,29,292,30,213,31,213,32,146,33,146,34,97,35,97,36,51,37,51,166,29,167,29,168,63,169,63,170,112,171,112,172,225,173,225,174,427,175,427,176,660,177,660,178,844,179,844,180,947,181,947,182,990,183,990,184,990,185,990,186,913,187,913,188,784,189,784,190,643,191,643,192,528,193,528,194,440,195,440,196,352,197,352,198,269,199,269,200,189,201,189,202,122,203,122,204,73,205,73,206,46,207,46,208,32,209,32,210,25,211,25,212,24,213,24,214,29,215,29,216,48,217,48,218,75,219,75,220,113,221,113,222,160,223,160,224,211,225,211,226,259,227,259,228,280,229,280,230,275,231,275,232,259,233,259,234,244,235,244,236,236,237,236,238,231,239,231,240,226,241,226,242,216,243,216,244,204,245,204,246,194,247,194,248,179,249,179,250,158,251,158,252,138,253,138,254,123,255,123,},[179]={0,113,1,113,2,162,3,162,4,298,5,298,6,485,7,485,8,660,9,660,10,771,11,771,12,816,13,816,14,793,15,793,16,735,17,735,18,703,19,703,20,671,21,671,22,631,23,631,24,540,25,540,26,400,27,400,28,292,29,292,30,213,31,213,32,146,33,146,34,97,35,97,36,51,37,51,166,29,167,29,168,63,169,63,170,112,171,112,172,225,173,225,174,427,175,427,176,660,177,660,178,844,179,844,180,947,181,947,182,990,183,990,184,990,185,990,186,913,187,913,188,784,189,784,190,643,191,643,192,528,193,528,194,440,195,440,196,352,197,352,198,269,199,269,200,189,201,189,202,122,203,122,204,73,205,73,206,46,207,46,208,32,209,32,210,25,211,25,212,24,213,24,214,29,215,29,216,48,217,48,218,75,219,75,220,113,221,113,222,160,223,160,224,211,225,211,226,259,227,259,228,280,229,280,230,275,231,275,232,259,233,259,234,244,235,244,236,236,237,236,238,231,239,231,240,226,241,226,242,216,243,216,244,204,245,204,246,194,247,194,248,179,249,179,250,158,251,158,252,138,253,138,254,123,255,123,},[180]={0,129,1,129,2,193,3,193,4,352,5,352,6,565,7,565,8,768,9,768,10,886,11,886,12,929,13,929,14,921,15,921,16,886,17,886,18,867,19,867,20,840,21,840,22,763,23,763,24,608,25,608,26,393,27,393,28,249,29,249,30,174,31,174,32,127,33,127,34,91,35,91,36,47,37,47,166,21,167,21,168,54,169,54,170,115,171,115,172,243,173,243,174,449,175,449,176,664,177,664,178,835,179,835,180,938,181,938,182,968,183,968,184,927,185,927,186,815,187,815,188,688,189,688,190,568,191,568,192,483,193,483,194,411,195,411,196,341,197,341,198,271,199,271,200,199,201,199,202,136,203,136,204,88,205,88,206,54,207,54,208,35,209,35,210,25,211,25,212,20,213,20,214,26,215,26,216,45,217,45,218,71,219,71,220,106,221,106,222,148,223,148,224,193,225,193,226,235,227,235,228,254,229,254,230,257,231,257,232,256,233,256,234,255,235,255,236,258,237,258,238,259,239,259,240,254,241,254,242,241,243,241,244,225,245,225,246,208,247,208,248,187,249,187,250,164,251,164,252,146,253,146,254,134,255,134,},[181]={0,129,1,129,2,193,3,193,4,352,5,352,6,565,7,565,8,768,9,768,10,886,11,886,12,929,13,929,14,921,15,921,16,886,17,886,18,867,19,867,20,840,21,840,22,763,23,763,24,608,25,608,26,393,27,393,28,249,29,249,30,174,31,174,32,127,33,127,34,91,35,91,36,47,37,47,166,21,167,21,168,54,169,54,170,115,171,115,172,243,173,243,174,449,175,449,176,664,177,664,178,835,179,835,180,938,181,938,182,968,183,968,184,927,185,927,186,815,187,815,188,688,189,688,190,568,191,568,192,483,193,483,194,411,195,411,196,341,197,341,198,271,199,271,200,199,201,199,202,136,203,136,204,88,205,88,206,54,207,54,208,35,209,35,210,25,211,25,212,20,213,20,214,26,215,26,216,45,217,45,218,71,219,71,220,106,221,106,222,148,223,148,224,193,225,193,226,235,227,235,228,254,229,254,230,257,231,257,232,256,233,256,234,255,235,255,236,258,237,258,238,259,239,259,240,254,241,254,242,241,243,241,244,225,245,225,246,208,247,208,248,187,249,187,250,164,251,164,252,146,253,146,254,134,255,134,},[182]={0,139,1,139,2,206,3,206,4,359,5,359,6,572,7,572,8,788,9,788,10,922,11,922,12,973,13,973,14,984,15,984,16,969,17,969,18,964,19,964,20,936,21,936,22,845,23,845,24,649,25,649,26,401,27,401,28,231,29,231,30,164,31,164,32,126,33,126,34,90,35,90,36,47,37,47,166,15,167,15,168,40,169,40,170,101,171,101,172,228,173,228,174,409,175,409,176,591,177,591,178,745,179,745,180,841,181,841,182,854,183,854,184,783,185,783,186,680,187,680,188,583,189,583,190,502,191,502,192,439,193,439,194,379,195,379,196,323,197,323,198,268,199,268,200,210,201,210,202,155,203,155,204,106,205,106,206,67,207,67,208,41,209,41,210,26,211,26,212,20,213,20,214,26,215,26,216,44,217,44,218,68,219,68,220,97,221,97,222,133,223,133,224,176,225,176,226,216,227,216,228,240,229,240,230,256,231,256,232,271,233,271,234,287,235,287,236,301,237,301,238,305,239,305,240,295,241,295,242,274,243,274,244,250,245,250,246,225,247,225,248,198,249,198,250,173,251,173,252,155,253,155,254,145,255,145,},[183]={0,139,1,139,2,206,3,206,4,359,5,359,6,572,7,572,8,788,9,788,10,922,11,922,12,973,13,973,14,984,15,984,16,969,17,969,18,964,19,964,20,936,21,936,22,845,23,845,24,649,25,649,26,401,27,401,28,231,29,231,30,164,31,164,32,126,33,126,34,90,35,90,36,47,37,47,166,15,167,15,168,40,169,40,170,101,171,101,172,228,173,228,174,409,175,409,176,591,177,591,178,745,179,745,180,841,181,841,182,854,183,854,184,783,185,783,186,680,187,680,188,583,189,583,190,502,191,502,192,439,193,439,194,379,195,379,196,323,197,323,198,268,199,268,200,210,201,210,202,155,203,155,204,106,205,106,206,67,207,67,208,41,209,41,210,26,211,26,212,20,213,20,214,26,215,26,216,44,217,44,218,68,219,68,220,97,221,97,222,133,223,133,224,176,225,176,226,216,227,216,228,240,229,240,230,256,231,256,232,271,233,271,234,287,235,287,236,301,237,301,238,305,239,305,240,295,241,295,242,274,243,274,244,250,245,250,246,225,247,225,248,198,249,198,250,173,251,173,252,155,253,155,254,145,255,145,},[184]={0,148,1,148,2,206,3,206,4,333,5,333,6,519,7,519,8,740,9,740,10,904,11,904,12,972,13,972,14,997,15,997,16,1000,17,1000,18,1002,19,1002,20,977,21,977,22,887,23,887,24,708,25,708,26,454,27,454,28,271,29,271,30,189,31,189,32,138,33,138,34,92,35,92,36,47,37,47,166,11,167,11,168,30,169,30,170,84,171,84,172,189,173,189,174,325,175,325,176,460,177,460,178,578,179,578,180,650,181,650,182,646,183,646,184,592,185,592,186,536,187,536,188,488,189,488,190,445,191,445,192,396,193,396,194,346,195,346,196,301,197,301,198,260,199,260,200,216,201,216,202,170,203,170,204,122,205,122,206,79,207,79,208,47,209,47,210,30,211,30,212,23,213,23,214,29,215,29,216,46,217,46,218,67,219,67,220,91,221,91,222,124,223,124,224,168,225,168,226,209,227,209,228,240,229,240,230,269,231,269,232,296,233,296,234,326,235,326,236,348,237,348,238,352,239,352,240,336,241,336,242,305,243,305,244,275,245,275,246,246,247,246,248,217,249,217,250,191,251,191,252,171,253,171,254,159,255,159,},[185]={0,148,1,148,2,206,3,206,4,333,5,333,6,519,7,519,8,740,9,740,10,904,11,904,12,972,13,972,14,997,15,997,16,1000,17,1000,18,1002,19,1002,20,977,21,977,22,887,23,887,24,708,25,708,26,454,27,454,28,271,29,271,30,189,31,189,32,138,33,138,34,92,35,92,36,47,37,47,166,11,167,11,168,30,169,30,170,84,171,84,172,189,173,189,174,325,175,325,176,460,177,460,178,578,179,578,180,650,181,650,182,646,183,646,184,592,185,592,186,536,187,536,188,488,189,488,190,445,191,445,192,396,193,396,194,346,195,346,196,301,197,301,198,260,199,260,200,216,201,216,202,170,203,170,204,122,205,122,206,79,207,79,208,47,209,47,210,30,211,30,212,23,213,23,214,29,215,29,216,46,217,46,218,67,219,67,220,91,221,91,222,124,223,124,224,168,225,168,226,209,227,209,228,240,229,240,230,269,231,269,232,296,233,296,234,326,235,326,236,348,237,348,238,352,239,352,240,336,241,336,242,305,243,305,244,275,245,275,246,246,247,246,248,217,249,217,250,191,251,191,252,171,253,171,254,159,255,159,},[186]={0,167,1,167,2,213,3,213,4,314,5,314,6,459,7,459,8,661,9,661,10,830,11,830,12,927,13,927,14,979,15,979,16,1001,17,1001,18,1006,19,1006,20,989,21,989,22,923,23,923,24,774,25,774,26,541,27,541,28,341,29,341,30,218,31,218,32,149,33,149,34,90,35,90,36,44,37,44,166,7,167,7,168,24,169,24,170,70,171,70,172,140,173,140,174,225,175,225,176,313,177,313,178,389,179,389,180,434,181,434,182,438,183,438,184,421,185,421,186,414,187,414,188,410,189,410,190,389,191,389,192,353,193,353,194,311,195,311,196,275,197,275,198,244,199,244,200,212,201,212,202,173,203,173,204,129,205,129,206,87,207,87,208,56,209,56,210,38,211,38,212,33,213,33,214,39,215,39,216,54,217,54,218,73,219,73,220,94,221,94,222,126,223,126,224,172,225,172,226,216,227,216,228,252,229,252,230,284,231,284,232,315,233,315,234,350,235,350,236,374,237,374,238,376,239,376,240,354,241,354,242,320,243,320,244,291,245,291,246,266,247,266,248,241,249,241,250,215,251,215,252,191,253,191,254,177,255,177,},[187]={0,167,1,167,2,213,3,213,4,314,5,314,6,459,7,459,8,661,9,661,10,830,11,830,12,927,13,927,14,979,15,979,16,1001,17,1001,18,1006,19,1006,20,989,21,989,22,923,23,923,24,774,25,774,26,541,27,541,28,341,29,341,30,218,31,218,32,149,33,149,34,90,35,90,36,44,37,44,166,7,167,7,168,24,169,24,170,70,171,70,172,140,173,140,174,225,175,225,176,313,177,313,178,389,179,389,180,434,181,434,182,438,183,438,184,421,185,421,186,414,187,414,188,410,189,410,190,389,191,389,192,353,193,353,194,311,195,311,196,275,197,275,198,244,199,244,200,212,201,212,202,173,203,173,204,129,205,129,206,87,207,87,208,56,209,56,210,38,211,38,212,33,213,33,214,39,215,39,216,54,217,54,218,73,219,73,220,94,221,94,222,126,223,126,224,172,225,172,226,216,227,216,228,252,229,252,230,284,231,284,232,315,233,315,234,350,235,350,236,374,237,374,238,376,239,376,240,354,241,354,242,320,243,320,244,291,245,291,246,266,247,266,248,241,249,241,250,215,251,215,252,191,253,191,254,177,255,177,},[188]={0,196,1,196,2,247,3,247,4,333,5,333,6,443,7,443,8,598,9,598,10,740,11,740,12,845,13,845,14,929,15,929,16,979,17,979,18,996,19,996,20,999,21,999,22,962,23,962,24,845,25,845,26,629,27,629,28,385,29,385,30,233,31,233,32,146,33,146,34,83,35,83,36,38,37,38,166,6,167,6,168,24,169,24,170,55,171,55,172,95,173,95,174,141,175,141,176,191,177,191,178,235,179,235,180,270,181,270,182,287,183,287,184,301,185,301,186,322,187,322,188,336,189,336,190,328,191,328,192,303,193,303,194,272,195,272,196,243,197,243,198,219,199,219,200,194,201,194,202,164,203,164,204,129,205,129,206,95,207,95,208,69,209,69,210,55,211,55,212,52,213,52,214,59,215,59,216,75,217,75,218,93,219,93,220,112,221,112,222,142,223,142,224,187,225,187,226,230,227,230,228,264,229,264,230,289,231,289,232,314,233,314,234,343,235,343,236,361,237,361,238,359,239,359,240,338,241,338,242,309,243,309,244,291,245,291,246,277,247,277,248,259,249,259,250,234,251,234,252,208,253,208,254,197,255,197,},[189]={0,196,1,196,2,247,3,247,4,333,5,333,6,443,7,443,8,598,9,598,10,740,11,740,12,845,13,845,14,929,15,929,16,979,17,979,18,996,19,996,20,999,21,999,22,962,23,962,24,845,25,845,26,629,27,629,28,385,29,385,30,233,31,233,32,146,33,146,34,83,35,83,36,38,37,38,166,6,167,6,168,24,169,24,170,55,171,55,172,95,173,95,174,141,175,141,176,191,177,191,178,235,179,235,180,270,181,270,182,287,183,287,184,301,185,301,186,322,187,322,188,336,189,336,190,328,191,328,192,303,193,303,194,272,195,272,196,243,197,243,198,219,199,219,200,194,201,194,202,164,203,164,204,129,205,129,206,95,207,95,208,69,209,69,210,55,211,55,212,52,213,52,214,59,215,59,216,75,217,75,218,93,219,93,220,112,221,112,222,142,223,142,224,187,225,187,226,230,227,230,228,264,229,264,230,289,231,289,232,314,233,314,234,343,235,343,236,361,237,361,238,359,239,359,240,338,241,338,242,309,243,309,244,291,245,291,246,277,247,277,248,259,249,259,250,234,251,234,252,208,253,208,254,197,255,197,},[190]={0,231,1,231,2,296,3,296,4,381,5,381,6,463,7,463,8,564,9,564,10,659,11,659,12,749,13,749,14,843,15,843,16,926,17,926,18,976,19,976,20,1000,21,1000,22,988,23,988,24,894,25,894,26,670,27,670,28,394,29,394,30,225,31,225,32,134,33,134,34,70,35,70,36,30,37,30,166,10,167,10,168,25,169,25,170,44,171,44,172,63,173,63,174,86,175,86,176,114,177,114,178,143,179,143,180,172,181,172,182,198,183,198,184,223,185,223,186,250,187,250,188,266,189,266,190,263,191,263,192,249,193,249,194,230,195,230,196,209,197,209,198,189,199,189,200,171,201,171,202,151,203,151,204,127,205,127,206,104,207,104,208,88,209,88,210,80,211,80,212,80,213,80,214,89,215,89,216,107,217,107,218,128,219,128,220,145,221,145,222,172,223,172,224,209,225,209,226,243,227,243,228,267,229,267,230,279,231,279,232,292,233,292,234,310,235,310,236,317,237,317,238,313,239,313,240,296,241,296,242,281,243,281,244,278,245,278,246,276,247,276,248,264,249,264,250,241,251,241,252,218,253,218,254,216,255,216,},[191]={0,231,1,231,2,296,3,296,4,381,5,381,6,463,7,463,8,564,9,564,10,659,11,659,12,749,13,749,14,843,15,843,16,926,17,926,18,976,19,976,20,1000,21,1000,22,988,23,988,24,894,25,894,26,670,27,670,28,394,29,394,30,225,31,225,32,134,33,134,34,70,35,70,36,30,37,30,166,10,167,10,168,25,169,25,170,44,171,44,172,63,173,63,174,86,175,86,176,114,177,114,178,143,179,143,180,172,181,172,182,198,183,198,184,223,185,223,186,250,187,250,188,266,189,266,190,263,191,263,192,249,193,249,194,230,195,230,196,209,197,209,198,189,199,189,200,171,201,171,202,151,203,151,204,127,205,127,206,104,207,104,208,88,209,88,210,80,211,80,212,80,213,80,214,89,215,89,216,107,217,107,218,128,219,128,220,145,221,145,222,172,223,172,224,209,225,209,226,243,227,243,228,267,229,267,230,279,231,279,232,292,233,292,234,310,235,310,236,317,237,317,238,313,239,313,240,296,241,296,242,281,243,281,244,278,245,278,246,276,247,276,248,264,249,264,250,241,251,241,252,218,253,218,254,216,255,216,},[192]={0,261,1,261,2,338,3,338,4,417,5,417,6,478,7,478,8,528,9,528,10,569,11,569,12,624,13,624,14,715,15,715,16,823,17,823,18,925,19,925,20,978,21,978,22,974,23,974,24,875,25,875,26,639,27,639,28,359,29,359,30,194,31,194,32,113,33,113,34,56,35,56,162,6,163,6,164,11,165,11,166,18,167,18,168,29,169,29,170,38,171,38,172,46,173,46,174,56,175,56,176,72,177,72,178,94,179,94,180,119,181,119,182,147,183,147,184,173,185,173,186,196,187,196,188,208,189,208,190,207,191,207,192,202,193,202,194,194,195,194,196,179,197,179,198,164,199,164,200,154,201,154,202,144,203,144,204,131,205,131,206,119,207,119,208,112,209,112,210,110,211,110,212,113,213,113,214,126,215,126,216,149,217,149,218,172,219,172,220,189,221,189,222,210,223,210,224,234,225,234,226,253,227,253,228,262,229,262,230,262,231,262,232,263,233,263,234,269,235,269,236,267,237,267,238,260,239,260,240,251,241,251,242,248,243,248,244,258,245,258,246,264,247,264,248,257,249,257,250,240,251,240,252,224,253,224,254,233,255,233,},[193]={0,261,1,261,2,338,3,338,4,417,5,417,6,478,7,478,8,528,9,528,10,569,11,569,12,624,13,624,14,715,15,715,16,823,17,823,18,925,19,925,20,978,21,978,22,974,23,974,24,875,25,875,26,639,27,639,28,359,29,359,30,194,31,194,32,113,33,113,34,56,35,56,162,6,163,6,164,11,165,11,166,18,167,18,168,29,169,29,170,38,171,38,172,46,173,46,174,56,175,56,176,72,177,72,178,94,179,94,180,119,181,119,182,147,183,147,184,173,185,173,186,196,187,196,188,208,189,208,190,207,191,207,192,202,193,202,194,194,195,194,196,179,197,179,198,164,199,164,200,154,201,154,202,144,203,144,204,131,205,131,206,119,207,119,208,112,209,112,210,110,211,110,212,113,213,113,214,126,215,126,216,149,217,149,218,172,219,172,220,189,221,189,222,210,223,210,224,234,225,234,226,253,227,253,228,262,229,262,230,262,231,262,232,263,233,263,234,269,235,269,236,267,237,267,238,260,239,260,240,251,241,251,242,248,243,248,244,258,245,258,246,264,247,264,248,257,249,257,250,240,251,240,252,224,253,224,254,233,255,233,},[194]={0,280,1,280,2,348,3,348,4,408,5,408,6,441,7,441,8,452,9,452,10,456,11,456,12,484,13,484,14,561,15,561,16,684,17,684,18,814,19,814,20,893,21,893,22,888,23,888,24,777,25,777,26,549,27,549,28,306,29,306,30,165,31,165,32,91,33,91,34,44,35,44,160,7,161,7,162,15,163,15,164,22,165,22,166,26,167,26,168,31,169,31,170,33,171,33,172,35,173,35,174,39,175,39,176,49,177,49,178,65,179,65,180,85,181,85,182,109,183,109,184,136,185,136,186,159,187,159,188,169,189,169,190,170,191,170,192,173,193,173,194,173,195,173,196,163,197,163,198,154,199,154,200,152,201,152,202,151,203,151,204,146,205,146,206,141,207,141,208,140,209,140,210,143,211,143,212,150,213,150,214,167,215,167,216,194,217,194,218,221,219,221,220,240,221,240,222,252,223,252,224,261,225,261,226,264,227,264,228,260,229,260,230,250,231,250,232,245,233,245,234,243,235,243,236,235,237,235,238,225,239,225,240,218,241,218,242,220,243,220,244,233,245,233,246,242,247,242,248,242,249,242,250,234,251,234,252,228,253,228,254,244,255,244,},[195]={0,280,1,280,2,348,3,348,4,408,5,408,6,441,7,441,8,452,9,452,10,456,11,456,12,484,13,484,14,561,15,561,16,684,17,684,18,814,19,814,20,893,21,893,22,888,23,888,24,777,25,777,26,549,27,549,28,306,29,306,30,165,31,165,32,91,33,91,34,44,35,44,160,7,161,7,162,15,163,15,164,22,165,22,166,26,167,26,168,31,169,31,170,33,171,33,172,35,173,35,174,39,175,39,176,49,177,49,178,65,179,65,180,85,181,85,182,109,183,109,184,136,185,136,186,159,187,159,188,169,189,169,190,170,191,170,192,173,193,173,194,173,195,173,196,163,197,163,198,154,199,154,200,152,201,152,202,151,203,151,204,146,205,146,206,141,207,141,208,140,209,140,210,143,211,143,212,150,213,150,214,167,215,167,216,194,217,194,218,221,219,221,220,240,221,240,222,252,223,252,224,261,225,261,226,264,227,264,228,260,229,260,230,250,231,250,232,245,233,245,234,243,235,243,236,235,237,235,238,225,239,225,240,218,241,218,242,220,243,220,244,233,245,233,246,242,247,242,248,242,249,242,250,234,251,234,252,228,253,228,254,244,255,244,},[196]={0,279,1,279,2,323,3,323,4,352,5,352,6,357,7,357,8,346,9,346,10,337,11,337,12,354,13,354,14,420,15,420,16,535,17,535,18,669,19,669,20,738,21,738,22,723,23,723,24,619,25,619,26,431,27,431,28,248,29,248,30,140,31,140,32,76,33,76,34,35,35,35,158,9,159,9,160,17,161,17,162,28,163,28,164,34,165,34,166,32,167,32,168,31,169,31,170,28,171,28,172,26,173,26,174,27,175,27,176,32,177,32,178,42,179,42,180,55,181,55,182,76,183,76,184,106,185,106,186,133,187,133,188,146,189,146,190,153,191,153,192,163,193,163,194,168,195,168,196,164,197,164,198,162,199,162,200,168,201,168,202,172,203,172,204,171,205,171,206,169,207,169,208,171,209,171,210,179,211,179,212,191,213,191,214,211,215,211,216,242,217,242,218,273,219,273,220,291,221,291,222,292,223,292,224,285,225,285,226,276,227,276,228,264,229,264,230,251,231,251,232,245,233,245,234,244,235,244,236,233,237,233,238,218,239,218,240,203,241,203,242,199,243,199,244,207,245,207,246,214,247,214,248,219,249,219,250,222,251,222,252,227,253,227,254,246,255,246,},[197]={0,279,1,279,2,323,3,323,4,352,5,352,6,357,7,357,8,346,9,346,10,337,11,337,12,354,13,354,14,420,15,420,16,535,17,535,18,669,19,669,20,738,21,738,22,723,23,723,24,619,25,619,26,431,27,431,28,248,29,248,30,140,31,140,32,76,33,76,34,35,35,35,158,9,159,9,160,17,161,17,162,28,163,28,164,34,165,34,166,32,167,32,168,31,169,31,170,28,171,28,172,26,173,26,174,27,175,27,176,32,177,32,178,42,179,42,180,55,181,55,182,76,183,76,184,106,185,106,186,133,187,133,188,146,189,146,190,153,191,153,192,163,193,163,194,168,195,168,196,164,197,164,198,162,199,162,200,168,201,168,202,172,203,172,204,171,205,171,206,169,207,169,208,171,209,171,210,179,211,179,212,191,213,191,214,211,215,211,216,242,217,242,218,273,219,273,220,291,221,291,222,292,223,292,224,285,225,285,226,276,227,276,228,264,229,264,230,251,231,251,232,245,233,245,234,244,235,244,236,233,237,233,238,218,239,218,240,203,241,203,242,199,243,199,244,207,245,207,246,214,247,214,248,219,249,219,250,222,251,222,252,227,253,227,254,246,255,246,},[198]={0,259,1,259,2,275,3,275,4,276,5,276,6,263,7,263,8,248,9,248,10,243,11,243,12,260,13,260,14,313,15,313,16,400,17,400,18,493,19,493,20,532,21,532,22,511,23,511,24,430,25,430,26,303,27,303,28,191,29,191,30,111,31,111,32,60,33,60,34,27,35,27,156,10,157,10,158,19,159,19,160,30,161,30,162,42,163,42,164,44,165,44,166,37,167,37,168,29,169,29,170,23,171,23,172,19,173,19,174,18,175,18,176,19,177,19,178,23,179,23,180,30,181,30,182,49,183,49,184,82,185,82,186,113,187,113,188,133,189,133,190,150,191,150,192,166,193,166,194,176,195,176,196,176,197,176,198,181,199,181,200,193,201,193,202,198,203,198,204,197,205,197,206,196,207,196,208,202,209,202,210,216,211,216,212,234,213,234,214,258,215,258,216,291,217,291,218,322,219,322,220,334,221,334,222,322,223,322,224,301,225,301,226,285,227,285,228,273,229,273,230,264,231,264,232,264,233,264,234,268,235,268,236,257,237,257,238,232,239,232,240,205,241,205,242,186,243,186,244,183,245,183,246,185,247,185,248,194,249,194,250,205,251,205,252,217,253,217,254,234,255,234,},[199]={0,259,1,259,2,275,3,275,4,276,5,276,6,263,7,263,8,248,9,248,10,243,11,243,12,260,13,260,14,313,15,313,16,400,17,400,18,493,19,493,20,532,21,532,22,511,23,511,24,430,25,430,26,303,27,303,28,191,29,191,30,111,31,111,32,60,33,60,34,27,35,27,156,10,157,10,158,19,159,19,160,30,161,30,162,42,163,42,164,44,165,44,166,37,167,37,168,29,169,29,170,23,171,23,172,19,173,19,174,18,175,18,176,19,177,19,178,23,179,23,180,30,181,30,182,49,183,49,184,82,185,82,186,113,187,113,188,133,189,133,190,150,191,150,192,166,193,166,194,176,195,176,196,176,197,176,198,181,199,181,200,193,201,193,202,198,203,198,204,197,205,197,206,196,207,196,208,202,209,202,210,216,211,216,212,234,213,234,214,258,215,258,216,291,217,291,218,322,219,322,220,334,221,334,222,322,223,322,224,301,225,301,226,285,227,285,228,273,229,273,230,264,231,264,232,264,233,264,234,268,235,268,236,257,237,257,238,232,239,232,240,205,241,205,242,186,243,186,244,183,245,183,246,185,247,185,248,194,249,194,250,205,251,205,252,217,253,217,254,234,255,234,},[200]={0,226,1,226,2,224,3,224,4,212,5,212,6,195,7,195,8,185,9,185,10,187,11,187,12,203,13,203,14,240,15,240,16,292,17,292,18,334,19,334,20,341,21,341,22,315,23,315,24,261,25,261,26,194,27,194,28,135,29,135,30,83,31,83,32,46,33,46,34,22,35,22,152,8,153,8,154,14,155,14,156,23,157,23,158,31,159,31,160,46,161,46,162,63,163,63,164,61,165,61,166,47,167,47,168,33,169,33,170,22,171,22,172,16,173,16,174,13,175,13,176,11,177,11,178,11,179,11,180,16,181,16,182,35,183,35,184,67,185,67,186,99,187,99,188,127,189,127,190,152,191,152,192,173,193,173,194,185,195,185,196,189,197,189,198,201,199,201,200,215,201,215,202,218,203,218,204,215,205,215,206,215,207,215,208,227,209,227,210,249,211,249,212,273,213,273,214,300,215,300,216,331,217,331,218,357,219,357,220,359,221,359,222,336,223,336,224,308,225,308,226,292,227,292,228,284,229,284,230,284,231,284,232,294,233,294,234,305,235,305,236,293,237,293,238,261,239,261,240,221,241,221,242,189,243,189,244,172,245,172,246,167,247,167,248,173,249,173,250,185,251,185,252,200,253,200,254,212,255,212,},[201]={0,226,1,226,2,224,3,224,4,212,5,212,6,195,7,195,8,185,9,185,10,187,11,187,12,203,13,203,14,240,15,240,16,292,17,292,18,334,19,334,20,341,21,341,22,315,23,315,24,261,25,261,26,194,27,194,28,135,29,135,30,83,31,83,32,46,33,46,34,22,35,22,152,8,153,8,154,14,155,14,156,23,157,23,158,31,159,31,160,46,161,46,162,63,163,63,164,61,165,61,166,47,167,47,168,33,169,33,170,22,171,22,172,16,173,16,174,13,175,13,176,11,177,11,178,11,179,11,180,16,181,16,182,35,183,35,184,67,185,67,186,99,187,99,188,127,189,127,190,152,191,152,192,173,193,173,194,185,195,185,196,189,197,189,198,201,199,201,200,215,201,215,202,218,203,218,204,215,205,215,206,215,207,215,208,227,209,227,210,249,211,249,212,273,213,273,214,300,215,300,216,331,217,331,218,357,219,357,220,359,221,359,222,336,223,336,224,308,225,308,226,292,227,292,228,284,229,284,230,284,231,284,232,294,233,294,234,305,235,305,236,293,237,293,238,261,239,261,240,221,241,221,242,189,243,189,244,172,245,172,246,167,247,167,248,173,249,173,250,185,251,185,252,200,253,200,254,212,255,212,},[202]={0,189,1,189,2,184,3,184,4,172,5,172,6,159,7,159,8,154,9,154,10,158,11,158,12,169,13,169,14,189,15,189,16,209,17,209,18,216,19,216,20,204,21,204,22,176,23,176,24,148,25,148,26,121,27,121,28,92,29,92,30,63,31,63,32,41,33,41,34,24,35,24,148,5,149,5,150,12,151,12,152,21,153,21,154,29,155,29,156,45,157,45,158,65,159,65,160,85,161,85,162,103,163,103,164,97,165,97,166,73,167,73,168,47,169,47,170,29,171,29,172,18,173,18,174,12,175,12,176,8,177,8,178,9,179,9,180,15,181,15,182,34,183,34,184,65,185,65,186,97,187,97,188,128,189,128,190,158,191,158,192,180,193,180,194,191,195,191,196,199,197,199,198,215,199,215,200,228,201,228,202,227,203,227,204,225,205,225,206,230,207,230,208,250,209,250,210,278,211,278,212,304,213,304,214,328,215,328,216,354,217,354,218,374,219,374,220,369,221,369,222,339,223,339,224,310,225,310,226,297,227,297,228,297,229,297,230,306,231,306,232,326,233,326,234,343,235,343,236,336,237,336,238,304,239,304,240,258,241,258,242,216,243,216,244,186,245,186,246,168,247,168,248,163,249,163,250,168,251,168,252,177,253,177,254,184,255,184,},[203]={0,189,1,189,2,184,3,184,4,172,5,172,6,159,7,159,8,154,9,154,10,158,11,158,12,169,13,169,14,189,15,189,16,209,17,209,18,216,19,216,20,204,21,204,22,176,23,176,24,148,25,148,26,121,27,121,28,92,29,92,30,63,31,63,32,41,33,41,34,24,35,24,148,5,149,5,150,12,151,12,152,21,153,21,154,29,155,29,156,45,157,45,158,65,159,65,160,85,161,85,162,103,163,103,164,97,165,97,166,73,167,73,168,47,169,47,170,29,171,29,172,18,173,18,174,12,175,12,176,8,177,8,178,9,179,9,180,15,181,15,182,34,183,34,184,65,185,65,186,97,187,97,188,128,189,128,190,158,191,158,192,180,193,180,194,191,195,191,196,199,197,199,198,215,199,215,200,228,201,228,202,227,203,227,204,225,205,225,206,230,207,230,208,250,209,250,210,278,211,278,212,304,213,304,214,328,215,328,216,354,217,354,218,374,219,374,220,369,221,369,222,339,223,339,224,310,225,310,226,297,227,297,228,297,229,297,230,306,231,306,232,326,233,326,234,343,235,343,236,336,237,336,238,304,239,304,240,258,241,258,242,216,243,216,244,186,245,186,246,168,247,168,248,163,249,163,250,168,251,168,252,177,253,177,254,184,255,184,},[204]={0,156,1,156,2,155,3,155,4,148,5,148,6,139,7,139,8,134,9,134,10,134,11,134,12,139,13,139,14,146,15,146,16,149,17,149,18,141,19,141,20,120,21,120,22,97,23,97,24,84,25,84,26,76,27,76,28,65,29,65,30,53,31,53,32,44,33,44,34,34,35,34,36,25,37,25,38,18,39,18,40,10,41,10,146,4,147,4,148,13,149,13,150,25,151,25,152,36,153,36,154,54,155,54,156,91,157,91,158,127,159,127,160,157,161,157,162,167,163,167,164,151,165,151,166,114,167,114,168,73,169,73,170,43,171,43,172,26,173,26,174,15,175,15,176,11,177,11,178,14,179,14,180,24,181,24,182,46,183,46,184,78,185,78,186,108,187,108,188,139,189,139,190,169,191,169,192,188,193,188,194,197,195,197,196,207,197,207,198,227,199,227,200,236,201,236,202,233,203,233,204,234,205,234,206,247,207,247,208,274,209,274,210,303,211,303,212,322,213,322,214,339,215,339,216,359,217,359,218,375,219,375,220,368,221,368,222,339,223,339,224,312,225,312,226,303,227,303,228,307,229,307,230,323,231,323,232,351,233,351,234,376,235,376,236,379,237,379,238,357,239,357,240,317,241,317,242,272,243,272,244,228,245,228,246,192,247,192,248,170,249,170,250,159,251,159,252,157,253,157,254,158,255,158,},[205]={0,156,1,156,2,155,3,155,4,148,5,148,6,139,7,139,8,134,9,134,10,134,11,134,12,139,13,139,14,146,15,146,16,149,17,149,18,141,19,141,20,120,21,120,22,97,23,97,24,84,25,84,26,76,27,76,28,65,29,65,30,53,31,53,32,44,33,44,34,34,35,34,36,25,37,25,38,18,39,18,40,10,41,10,146,4,147,4,148,13,149,13,150,25,151,25,152,36,153,36,154,54,155,54,156,91,157,91,158,127,159,127,160,157,161,157,162,167,163,167,164,151,165,151,166,114,167,114,168,73,169,73,170,43,171,43,172,26,173,26,174,15,175,15,176,11,177,11,178,14,179,14,180,24,181,24,182,46,183,46,184,78,185,78,186,108,187,108,188,139,189,139,190,169,191,169,192,188,193,188,194,197,195,197,196,207,197,207,198,227,199,227,200,236,201,236,202,233,203,233,204,234,205,234,206,247,207,247,208,274,209,274,210,303,211,303,212,322,213,322,214,339,215,339,216,359,217,359,218,375,219,375,220,368,221,368,222,339,223,339,224,312,225,312,226,303,227,303,228,307,229,307,230,323,231,323,232,351,233,351,234,376,235,376,236,379,237,379,238,357,239,357,240,317,241,317,242,272,243,272,244,228,245,228,246,192,247,192,248,170,249,170,250,159,251,159,252,157,253,157,254,158,255,158,},[206]={0,134,1,134,2,135,3,135,4,129,5,129,6,118,7,118,8,109,9,109,10,105,11,105,12,104,13,104,14,105,15,105,16,100,17,100,18,87,19,87,20,68,21,68,22,53,23,53,24,50,25,50,26,53,27,53,28,53,29,53,30,53,31,53,32,53,33,53,34,47,35,47,36,42,37,42,38,36,39,36,40,29,41,29,42,22,43,22,44,17,45,17,146,9,147,9,148,23,149,23,150,37,151,37,152,57,153,57,154,102,155,102,156,173,157,173,158,227,159,227,160,255,161,255,162,253,163,253,164,221,165,221,166,165,167,165,168,107,169,107,170,66,171,66,172,40,173,40,174,23,175,23,176,15,177,15,178,20,179,20,180,35,181,35,182,63,183,63,184,99,185,99,186,129,187,129,188,158,189,158,190,181,191,181,192,195,193,195,194,202,195,202,196,214,197,214,198,236,199,236,200,241,201,241,202,238,203,238,204,246,205,246,206,268,207,268,208,299,209,299,210,321,211,321,212,330,213,330,214,336,215,336,216,350,217,350,218,364,219,364,220,359,221,359,222,335,223,335,224,312,225,312,226,306,227,306,228,312,229,312,230,333,231,333,232,366,233,366,234,398,235,398,236,416,237,416,238,411,239,411,240,383,241,383,242,339,243,339,244,283,245,283,246,231,247,231,248,191,249,191,250,163,251,163,252,148,253,148,254,143,255,143,},[207]={0,134,1,134,2,135,3,135,4,129,5,129,6,118,7,118,8,109,9,109,10,105,11,105,12,104,13,104,14,105,15,105,16,100,17,100,18,87,19,87,20,68,21,68,22,53,23,53,24,50,25,50,26,53,27,53,28,53,29,53,30,53,31,53,32,53,33,53,34,47,35,47,36,42,37,42,38,36,39,36,40,29,41,29,42,22,43,22,44,17,45,17,146,9,147,9,148,23,149,23,150,37,151,37,152,57,153,57,154,102,155,102,156,173,157,173,158,227,159,227,160,255,161,255,162,253,163,253,164,221,165,221,166,165,167,165,168,107,169,107,170,66,171,66,172,40,173,40,174,23,175,23,176,15,177,15,178,20,179,20,180,35,181,35,182,63,183,63,184,99,185,99,186,129,187,129,188,158,189,158,190,181,191,181,192,195,193,195,194,202,195,202,196,214,197,214,198,236,199,236,200,241,201,241,202,238,203,238,204,246,205,246,206,268,207,268,208,299,209,299,210,321,211,321,212,330,213,330,214,336,215,336,216,350,217,350,218,364,219,364,220,359,221,359,222,335,223,335,224,312,225,312,226,306,227,306,228,312,229,312,230,333,231,333,232,366,233,366,234,398,235,398,236,416,237,416,238,411,239,411,240,383,241,383,242,339,243,339,244,283,245,283,246,231,247,231,248,191,249,191,250,163,251,163,252,148,253,148,254,143,255,143,},[208]={0,126,1,126,2,123,3,123,4,113,5,113,6,96,7,96,8,81,9,81,10,73,11,73,12,69,13,69,14,66,15,66,16,60,17,60,18,49,19,49,20,37,21,37,22,31,23,31,24,37,25,37,26,49,27,49,28,56,29,56,30,63,31,63,32,77,33,77,34,86,35,86,36,78,37,78,38,64,39,64,40,58,41,58,42,55,43,55,44,52,45,52,46,43,47,43,48,30,49,30,146,21,147,21,148,36,149,36,150,51,151,51,152,97,153,97,154,196,155,196,156,301,157,301,158,374,159,374,160,394,161,394,162,373,163,373,164,317,165,317,166,236,167,236,168,155,169,155,170,96,171,96,172,59,173,59,174,34,175,34,176,22,177,22,178,26,179,26,180,45,181,45,182,81,183,81,184,121,185,121,186,151,187,151,188,175,189,175,190,189,191,189,192,197,193,197,194,202,195,202,196,216,197,216,198,236,199,236,200,239,201,239,202,241,203,241,204,257,205,257,206,284,207,284,208,314,209,314,210,329,211,329,212,326,213,326,214,322,215,322,216,329,217,329,218,340,219,340,220,336,221,336,222,317,223,317,224,300,225,300,226,298,227,298,228,305,229,305,230,329,231,329,232,366,233,366,234,404,235,404,236,435,237,435,238,446,239,446,240,432,241,432,242,390,243,390,244,328,245,328,246,267,247,267,248,217,249,217,250,179,251,179,252,154,253,154,254,141,255,141,},[209]={0,126,1,126,2,123,3,123,4,113,5,113,6,96,7,96,8,81,9,81,10,73,11,73,12,69,13,69,14,66,15,66,16,60,17,60,18,49,19,49,20,37,21,37,22,31,23,31,24,37,25,37,26,49,27,49,28,56,29,56,30,63,31,63,32,77,33,77,34,86,35,86,36,78,37,78,38,64,39,64,40,58,41,58,42,55,43,55,44,52,45,52,46,43,47,43,48,30,49,30,146,21,147,21,148,36,149,36,150,51,151,51,152,97,153,97,154,196,155,196,156,301,157,301,158,374,159,374,160,394,161,394,162,373,163,373,164,317,165,317,166,236,167,236,168,155,169,155,170,96,171,96,172,59,173,59,174,34,175,34,176,22,177,22,178,26,179,26,180,45,181,45,182,81,183,81,184,121,185,121,186,151,187,151,188,175,189,175,190,189,191,189,192,197,193,197,194,202,195,202,196,216,197,216,198,236,199,236,200,239,201,239,202,241,203,241,204,257,205,257,206,284,207,284,208,314,209,314,210,329,211,329,212,326,213,326,214,322,215,322,216,329,217,329,218,340,219,340,220,336,221,336,222,317,223,317,224,300,225,300,226,298,227,298,228,305,229,305,230,329,231,329,232,366,233,366,234,404,235,404,236,435,237,435,238,446,239,446,240,432,241,432,242,390,243,390,244,328,245,328,246,267,247,267,248,217,249,217,250,179,251,179,252,154,253,154,254,141,255,141,},[210]={0,129,1,129,2,117,3,117,4,100,5,100,6,78,7,78,8,58,9,58,10,46,11,46,12,41,13,41,14,38,15,38,16,34,17,34,18,29,19,29,20,24,21,24,22,28,23,28,24,42,25,42,26,62,27,62,28,76,29,76,30,93,31,93,32,129,33,129,34,170,35,170,36,190,37,190,38,183,39,183,40,171,41,171,42,152,43,152,44,126,45,126,46,99,47,99,48,77,49,77,50,51,51,51,52,26,53,26,140,6,141,6,142,12,143,12,144,22,145,22,146,36,147,36,148,49,149,49,150,77,151,77,152,172,153,172,154,327,155,327,156,478,157,478,158,567,159,567,160,576,161,576,162,535,163,535,164,448,165,448,166,330,167,330,168,215,169,215,170,130,171,130,172,80,173,80,174,47,175,47,176,31,177,31,178,35,179,35,180,57,181,57,182,96,183,96,184,138,185,138,186,168,187,168,188,184,189,184,190,188,191,188,192,189,193,189,194,193,195,193,196,207,197,207,198,227,199,227,200,232,201,232,202,238,203,238,204,259,205,259,206,288,207,288,208,314,209,314,210,320,211,320,212,308,213,308,214,297,215,297,216,296,217,296,218,299,219,299,220,294,221,294,222,280,223,280,224,273,225,273,226,276,227,276,228,285,229,285,230,311,231,311,232,348,233,348,234,389,235,389,236,430,237,430,238,453,239,453,240,448,241,448,242,409,243,409,244,348,245,348,246,288,247,288,248,238,249,238,250,199,251,199,252,170,253,170,254,150,255,150,},[211]={0,129,1,129,2,117,3,117,4,100,5,100,6,78,7,78,8,58,9,58,10,46,11,46,12,41,13,41,14,38,15,38,16,34,17,34,18,29,19,29,20,24,21,24,22,28,23,28,24,42,25,42,26,62,27,62,28,76,29,76,30,93,31,93,32,129,33,129,34,170,35,170,36,190,37,190,38,183,39,183,40,171,41,171,42,152,43,152,44,126,45,126,46,99,47,99,48,77,49,77,50,51,51,51,52,26,53,26,140,6,141,6,142,12,143,12,144,22,145,22,146,36,147,36,148,49,149,49,150,77,151,77,152,172,153,172,154,327,155,327,156,478,157,478,158,567,159,567,160,576,161,576,162,535,163,535,164,448,165,448,166,330,167,330,168,215,169,215,170,130,171,130,172,80,173,80,174,47,175,47,176,31,177,31,178,35,179,35,180,57,181,57,182,96,183,96,184,138,185,138,186,168,187,168,188,184,189,184,190,188,191,188,192,189,193,189,194,193,195,193,196,207,197,207,198,227,199,227,200,232,201,232,202,238,203,238,204,259,205,259,206,288,207,288,208,314,209,314,210,320,211,320,212,308,213,308,214,297,215,297,216,296,217,296,218,299,219,299,220,294,221,294,222,280,223,280,224,273,225,273,226,276,227,276,228,285,229,285,230,311,231,311,232,348,233,348,234,389,235,389,236,430,237,430,238,453,239,453,240,448,241,448,242,409,243,409,244,348,245,348,246,288,247,288,248,238,249,238,250,199,251,199,252,170,253,170,254,150,255,150,},[212]={0,137,1,137,2,114,3,114,4,91,5,91,6,66,7,66,8,45,9,45,10,33,11,33,12,28,13,28,14,28,15,28,16,28,17,28,18,28,19,28,20,30,21,30,22,38,23,38,24,59,25,59,26,86,27,86,28,108,29,108,30,138,31,138,32,207,33,207,34,302,35,302,36,368,37,368,38,401,39,401,40,385,41,385,42,335,43,335,44,264,45,264,46,186,47,186,48,130,49,130,50,92,51,92,52,57,53,57,54,30,55,30,56,16,57,16,138,10,139,10,140,19,141,19,142,30,143,30,144,43,145,43,146,52,147,52,148,60,149,60,150,114,151,114,152,274,153,274,154,481,155,481,156,668,157,668,158,758,159,758,160,754,161,754,162,699,163,699,164,585,165,585,166,431,167,431,168,280,169,280,170,167,171,167,172,101,173,101,174,63,175,63,176,45,177,45,178,50,179,50,180,72,181,72,182,110,183,110,184,151,185,151,186,176,187,176,188,184,189,184,190,178,191,178,192,175,193,175,194,177,195,177,196,189,197,189,198,209,199,209,200,220,201,220,202,229,203,229,204,249,205,249,206,275,207,275,208,295,209,295,210,295,211,295,212,279,213,279,214,264,215,264,216,255,217,255,218,249,219,249,220,242,221,242,222,233,223,233,224,236,225,236,226,245,227,245,228,257,229,257,230,284,231,284,232,321,233,321,234,364,235,364,236,408,237,408,238,438,239,438,240,437,241,437,242,402,243,402,244,347,245,347,246,295,247,295,248,254,249,254,250,220,251,220,252,192,253,192,254,165,255,165,},[213]={0,137,1,137,2,114,3,114,4,91,5,91,6,66,7,66,8,45,9,45,10,33,11,33,12,28,13,28,14,28,15,28,16,28,17,28,18,28,19,28,20,30,21,30,22,38,23,38,24,59,25,59,26,86,27,86,28,108,29,108,30,138,31,138,32,207,33,207,34,302,35,302,36,368,37,368,38,401,39,401,40,385,41,385,42,335,43,335,44,264,45,264,46,186,47,186,48,130,49,130,50,92,51,92,52,57,53,57,54,30,55,30,56,16,57,16,138,10,139,10,140,19,141,19,142,30,143,30,144,43,145,43,146,52,147,52,148,60,149,60,150,114,151,114,152,274,153,274,154,481,155,481,156,668,157,668,158,758,159,758,160,754,161,754,162,699,163,699,164,585,165,585,166,431,167,431,168,280,169,280,170,167,171,167,172,101,173,101,174,63,175,63,176,45,177,45,178,50,179,50,180,72,181,72,182,110,183,110,184,151,185,151,186,176,187,176,188,184,189,184,190,178,191,178,192,175,193,175,194,177,195,177,196,189,197,189,198,209,199,209,200,220,201,220,202,229,203,229,204,249,205,249,206,275,207,275,208,295,209,295,210,295,211,295,212,279,213,279,214,264,215,264,216,255,217,255,218,249,219,249,220,242,221,242,222,233,223,233,224,236,225,236,226,245,227,245,228,257,229,257,230,284,231,284,232,321,233,321,234,364,235,364,236,408,237,408,238,438,239,438,240,437,241,437,242,402,243,402,244,347,245,347,246,295,247,295,248,254,249,254,250,220,251,220,252,192,253,192,254,165,255,165,},[214]={0,150,1,150,2,118,3,118,4,91,5,91,6,65,7,65,8,46,9,46,10,36,11,36,12,33,13,33,14,37,15,37,16,42,17,42,18,46,19,46,20,50,21,50,22,60,23,60,24,81,25,81,26,113,27,113,28,141,29,141,30,184,31,184,32,292,33,292,34,447,35,447,36,579,37,579,38,649,39,649,40,632,41,632,42,547,43,547,44,427,45,427,46,287,47,287,48,177,49,177,50,128,51,128,52,86,53,86,54,55,55,55,56,35,57,35,58,18,59,18,134,5,135,5,136,16,137,16,138,30,139,30,140,44,141,44,142,56,143,56,144,63,145,63,146,64,147,64,148,68,149,68,150,161,151,161,152,374,153,374,154,624,155,624,156,816,157,816,158,891,159,891,160,887,161,887,162,830,163,830,164,702,165,702,166,528,167,528,168,353,169,353,170,216,171,216,172,130,173,130,174,85,175,85,176,68,177,68,178,74,179,74,180,95,181,95,182,127,183,127,184,161,185,161,186,179,187,179,188,178,189,178,190,165,191,165,192,159,193,159,194,157,195,157,196,164,197,164,198,185,199,185,200,202,201,202,202,213,203,213,204,229,205,229,206,251,207,251,208,264,209,264,210,259,211,259,212,245,213,245,214,230,215,230,216,216,217,216,218,205,219,205,220,196,221,196,222,191,223,191,224,200,225,200,226,215,227,215,228,229,229,229,230,255,231,255,232,293,233,293,234,334,235,334,236,378,237,378,238,410,239,410,240,413,241,413,242,384,243,384,244,339,245,339,246,299,247,299,248,269,249,269,250,244,251,244,252,217,253,217,254,186,255,186,},[215]={0,150,1,150,2,118,3,118,4,91,5,91,6,65,7,65,8,46,9,46,10,36,11,36,12,33,13,33,14,37,15,37,16,42,17,42,18,46,19,46,20,50,21,50,22,60,23,60,24,81,25,81,26,113,27,113,28,141,29,141,30,184,31,184,32,292,33,292,34,447,35,447,36,579,37,579,38,649,39,649,40,632,41,632,42,547,43,547,44,427,45,427,46,287,47,287,48,177,49,177,50,128,51,128,52,86,53,86,54,55,55,55,56,35,57,35,58,18,59,18,134,5,135,5,136,16,137,16,138,30,139,30,140,44,141,44,142,56,143,56,144,63,145,63,146,64,147,64,148,68,149,68,150,161,151,161,152,374,153,374,154,624,155,624,156,816,157,816,158,891,159,891,160,887,161,887,162,830,163,830,164,702,165,702,166,528,167,528,168,353,169,353,170,216,171,216,172,130,173,130,174,85,175,85,176,68,177,68,178,74,179,74,180,95,181,95,182,127,183,127,184,161,185,161,186,179,187,179,188,178,189,178,190,165,191,165,192,159,193,159,194,157,195,157,196,164,197,164,198,185,199,185,200,202,201,202,202,213,203,213,204,229,205,229,206,251,207,251,208,264,209,264,210,259,211,259,212,245,213,245,214,230,215,230,216,216,217,216,218,205,219,205,220,196,221,196,222,191,223,191,224,200,225,200,226,215,227,215,228,229,229,229,230,255,231,255,232,293,233,293,234,334,235,334,236,378,237,378,238,410,239,410,240,413,241,413,242,384,243,384,244,339,245,339,246,299,247,299,248,269,249,269,250,244,251,244,252,217,253,217,254,186,255,186,},[216]={0,172,1,172,2,136,3,136,4,106,5,106,6,80,7,80,8,64,9,64,10,55,11,55,12,55,13,55,14,63,15,63,16,72,17,72,18,79,19,79,20,84,21,84,22,91,23,91,24,110,25,110,26,142,27,142,28,173,29,173,30,227,31,227,32,369,33,369,34,574,35,574,36,745,37,745,38,835,39,835,40,828,41,828,42,735,43,735,44,585,45,585,46,368,47,368,48,212,49,212,50,157,51,157,52,116,53,116,54,84,55,84,56,60,57,60,58,37,59,37,60,18,61,18,134,38,135,38,136,57,137,57,138,72,139,72,140,79,141,79,142,79,143,79,144,75,145,75,146,70,147,70,148,81,149,81,150,208,151,208,152,458,153,458,154,725,155,725,156,897,157,897,158,954,159,954,160,960,161,960,162,915,163,915,164,795,165,795,166,625,167,625,168,439,169,439,170,281,171,281,172,176,173,176,174,120,175,120,176,103,177,103,178,107,179,107,180,123,181,123,182,147,183,147,184,172,185,172,186,179,187,179,188,168,189,168,190,151,191,151,192,141,193,141,194,135,195,135,196,136,197,136,198,158,199,158,200,180,201,180,202,191,203,191,204,205,205,205,206,222,207,222,208,231,209,231,210,228,211,228,212,218,213,218,214,205,215,205,216,191,217,191,218,179,219,179,220,169,221,169,222,166,223,166,224,176,225,176,226,192,227,192,228,207,229,207,230,232,231,232,232,264,233,264,234,299,235,299,236,338,237,338,238,372,239,372,240,381,241,381,242,363,243,363,244,331,245,331,246,303,247,303,248,284,249,284,250,268,251,268,252,245,253,245,254,212,255,212,},[217]={0,172,1,172,2,136,3,136,4,106,5,106,6,80,7,80,8,64,9,64,10,55,11,55,12,55,13,55,14,63,15,63,16,72,17,72,18,79,19,79,20,84,21,84,22,91,23,91,24,110,25,110,26,142,27,142,28,173,29,173,30,227,31,227,32,369,33,369,34,574,35,574,36,745,37,745,38,835,39,835,40,828,41,828,42,735,43,735,44,585,45,585,46,368,47,368,48,212,49,212,50,157,51,157,52,116,53,116,54,84,55,84,56,60,57,60,58,37,59,37,60,18,61,18,134,38,135,38,136,57,137,57,138,72,139,72,140,79,141,79,142,79,143,79,144,75,145,75,146,70,147,70,148,81,149,81,150,208,151,208,152,458,153,458,154,725,155,725,156,897,157,897,158,954,159,954,160,960,161,960,162,915,163,915,164,795,165,795,166,625,167,625,168,439,169,439,170,281,171,281,172,176,173,176,174,120,175,120,176,103,177,103,178,107,179,107,180,123,181,123,182,147,183,147,184,172,185,172,186,179,187,179,188,168,189,168,190,151,191,151,192,141,193,141,194,135,195,135,196,136,197,136,198,158,199,158,200,180,201,180,202,191,203,191,204,205,205,205,206,222,207,222,208,231,209,231,210,228,211,228,212,218,213,218,214,205,215,205,216,191,217,191,218,179,219,179,220,169,221,169,222,166,223,166,224,176,225,176,226,192,227,192,228,207,229,207,230,232,231,232,232,264,233,264,234,299,235,299,236,338,237,338,238,372,239,372,240,381,241,381,242,363,243,363,244,331,245,331,246,303,247,303,248,284,249,284,250,268,251,268,252,245,253,245,254,212,255,212,},[218]={0,204,1,204,2,167,3,167,4,137,5,137,6,113,7,113,8,99,9,99,10,90,11,90,12,91,13,91,14,101,15,101,16,112,17,112,18,120,19,120,20,127,21,127,22,136,23,136,24,156,25,156,26,186,27,186,28,218,29,218,30,278,31,278,32,435,33,435,34,659,35,659,36,842,37,842,38,930,39,930,40,935,41,935,42,876,43,876,44,730,45,730,46,490,47,490,48,306,49,306,50,223,51,223,52,170,53,170,54,125,55,125,56,92,57,92,58,64,59,64,60,44,61,44,62,30,63,30,128,1,129,1,130,35,131,35,132,63,133,63,134,93,135,93,136,114,137,114,138,120,139,120,140,112,141,112,142,97,143,97,144,81,145,81,146,85,147,85,148,117,149,117,150,273,151,273,152,538,153,538,154,792,155,792,156,930,157,930,158,973,159,973,160,985,161,985,162,958,163,958,164,865,165,865,166,721,167,721,168,536,169,536,170,369,171,369,172,249,173,249,174,178,175,178,176,150,177,150,178,147,179,147,180,155,181,155,182,169,183,169,184,180,185,180,186,175,187,175,188,156,189,156,190,135,191,135,192,124,193,124,194,114,195,114,196,113,197,113,198,134,199,134,200,159,201,159,202,174,203,174,204,186,205,186,206,197,207,197,208,203,209,203,210,205,211,205,212,201,213,201,214,193,215,193,216,185,217,185,218,175,219,175,220,165,221,165,222,160,223,160,224,167,225,167,226,179,227,179,228,194,229,194,230,214,231,214,232,238,233,238,234,262,235,262,236,293,237,293,238,326,239,326,240,345,241,345,242,343,243,343,244,324,245,324,246,303,247,303,248,292,249,292,250,284,251,284,252,267,253,267,254,237,255,237,},[219]={0,204,1,204,2,167,3,167,4,137,5,137,6,113,7,113,8,99,9,99,10,90,11,90,12,91,13,91,14,101,15,101,16,112,17,112,18,120,19,120,20,127,21,127,22,136,23,136,24,156,25,156,26,186,27,186,28,218,29,218,30,278,31,278,32,435,33,435,34,659,35,659,36,842,37,842,38,930,39,930,40,935,41,935,42,876,43,876,44,730,45,730,46,490,47,490,48,306,49,306,50,223,51,223,52,170,53,170,54,125,55,125,56,92,57,92,58,64,59,64,60,44,61,44,62,30,63,30,128,1,129,1,130,35,131,35,132,63,133,63,134,93,135,93,136,114,137,114,138,120,139,120,140,112,141,112,142,97,143,97,144,81,145,81,146,85,147,85,148,117,149,117,150,273,151,273,152,538,153,538,154,792,155,792,156,930,157,930,158,973,159,973,160,985,161,985,162,958,163,958,164,865,165,865,166,721,167,721,168,536,169,536,170,369,171,369,172,249,173,249,174,178,175,178,176,150,177,150,178,147,179,147,180,155,181,155,182,169,183,169,184,180,185,180,186,175,187,175,188,156,189,156,190,135,191,135,192,124,193,124,194,114,195,114,196,113,197,113,198,134,199,134,200,159,201,159,202,174,203,174,204,186,205,186,206,197,207,197,208,203,209,203,210,205,211,205,212,201,213,201,214,193,215,193,216,185,217,185,218,175,219,175,220,165,221,165,222,160,223,160,224,167,225,167,226,179,227,179,228,194,229,194,230,214,231,214,232,238,233,238,234,262,235,262,236,293,237,293,238,326,239,326,240,345,241,345,242,343,243,343,244,324,245,324,246,303,247,303,248,292,249,292,250,284,251,284,252,267,253,267,254,237,255,237,},[220]={0,235,1,235,2,204,3,204,4,177,5,177,6,158,7,158,8,146,9,146,10,137,11,137,12,138,13,138,14,145,15,145,16,151,17,151,18,159,19,159,20,170,21,170,22,187,23,187,24,215,25,215,26,250,27,250,28,287,29,287,30,348,31,348,32,495,33,495,34,707,35,707,36,874,37,874,38,959,39,959,40,985,41,985,42,957,43,957,44,857,45,857,46,650,47,650,48,468,49,468,50,355,51,355,52,268,53,268,54,189,55,189,56,133,57,133,58,96,59,96,60,81,61,81,62,70,63,70,64,55,65,55,66,34,67,34,128,39,129,39,130,73,131,73,132,113,133,113,134,147,135,147,136,161,137,161,138,155,139,155,140,138,141,138,142,124,143,124,144,120,145,120,146,162,147,162,148,235,149,235,150,397,151,397,152,646,153,646,154,856,155,856,156,949,157,949,158,969,159,969,160,985,161,985,162,981,163,981,164,923,165,923,166,810,167,810,168,635,169,635,170,466,171,466,172,338,173,338,174,250,175,250,176,203,177,203,178,187,179,187,180,185,181,185,182,186,183,186,184,184,185,184,186,168,187,168,188,143,189,143,190,121,191,121,192,109,193,109,194,99,195,99,196,99,197,99,198,120,199,120,200,145,201,145,202,164,203,164,204,180,205,180,206,189,207,189,208,195,209,195,210,202,211,202,212,204,213,204,214,204,215,204,216,203,217,203,218,196,219,196,220,183,221,183,222,172,223,172,224,171,225,171,226,178,227,178,228,190,229,190,230,207,231,207,232,222,233,222,234,236,235,236,236,257,237,257,238,285,239,285,240,313,241,313,242,325,243,325,244,317,245,317,246,300,247,300,248,290,249,290,250,286,251,286,252,277,253,277,254,256,255,256,},[221]={0,235,1,235,2,204,3,204,4,177,5,177,6,158,7,158,8,146,9,146,10,137,11,137,12,138,13,138,14,145,15,145,16,151,17,151,18,159,19,159,20,170,21,170,22,187,23,187,24,215,25,215,26,250,27,250,28,287,29,287,30,348,31,348,32,495,33,495,34,707,35,707,36,874,37,874,38,959,39,959,40,985,41,985,42,957,43,957,44,857,45,857,46,650,47,650,48,468,49,468,50,355,51,355,52,268,53,268,54,189,55,189,56,133,57,133,58,96,59,96,60,81,61,81,62,70,63,70,64,55,65,55,66,34,67,34,128,39,129,39,130,73,131,73,132,113,133,113,134,147,135,147,136,161,137,161,138,155,139,155,140,138,141,138,142,124,143,124,144,120,145,120,146,162,147,162,148,235,149,235,150,397,151,397,152,646,153,646,154,856,155,856,156,949,157,949,158,969,159,969,160,985,161,985,162,981,163,981,164,923,165,923,166,810,167,810,168,635,169,635,170,466,171,466,172,338,173,338,174,250,175,250,176,203,177,203,178,187,179,187,180,185,181,185,182,186,183,186,184,184,185,184,186,168,187,168,188,143,189,143,190,121,191,121,192,109,193,109,194,99,195,99,196,99,197,99,198,120,199,120,200,145,201,145,202,164,203,164,204,180,205,180,206,189,207,189,208,195,209,195,210,202,211,202,212,204,213,204,214,204,215,204,216,203,217,203,218,196,219,196,220,183,221,183,222,172,223,172,224,171,225,171,226,178,227,178,228,190,229,190,230,207,231,207,232,222,233,222,234,236,235,236,236,257,237,257,238,285,239,285,240,313,241,313,242,325,243,325,244,317,245,317,246,300,247,300,248,290,249,290,250,286,251,286,252,277,253,277,254,256,255,256,},[222]={0,256,1,256,2,233,3,233,4,214,5,214,6,204,7,204,8,196,9,196,10,188,11,188,12,185,13,185,14,183,15,183,16,180,17,180,18,184,19,184,20,200,21,200,22,230,23,230,24,271,25,271,26,316,27,316,28,360,29,360,30,417,31,417,32,546,33,546,34,725,35,725,36,870,37,870,38,957,39,957,40,995,41,995,42,998,43,998,44,949,45,949,46,805,47,805,48,609,49,609,50,473,51,473,52,355,53,355,54,245,55,245,56,174,57,174,58,135,59,135,60,126,61,126,62,118,63,118,64,98,65,98,66,65,67,65,68,31,69,31,70,8,71,8,124,14,125,14,126,38,127,38,128,67,129,67,130,102,131,102,132,145,133,145,134,175,135,175,136,182,137,182,138,166,139,166,140,152,141,152,142,161,143,161,144,194,145,194,146,294,147,294,148,408,149,408,150,554,151,554,152,757,153,757,154,907,155,907,156,959,157,959,158,963,159,963,160,985,161,985,162,994,163,994,164,958,165,958,166,866,167,866,168,705,169,705,170,545,171,545,172,418,173,418,174,317,175,317,176,253,177,253,178,222,179,222,180,208,181,208,182,198,183,198,184,185,185,185,186,161,187,161,188,133,189,133,190,111,191,111,192,99,193,99,194,90,195,90,196,93,197,93,198,113,199,113,200,137,201,137,202,160,203,160,204,181,205,181,206,197,207,197,208,213,209,213,210,231,211,231,212,243,213,243,214,252,215,252,216,257,217,257,218,247,219,247,220,226,221,226,222,203,223,203,224,190,225,190,226,190,227,190,228,201,229,201,230,215,231,215,232,226,233,226,234,233,235,233,236,244,237,244,238,266,239,266,240,295,241,295,242,314,243,314,244,311,245,311,246,296,247,296,248,284,249,284,250,279,251,279,252,275,253,275,254,264,255,264,},[223]={0,256,1,256,2,233,3,233,4,214,5,214,6,204,7,204,8,196,9,196,10,188,11,188,12,185,13,185,14,183,15,183,16,180,17,180,18,184,19,184,20,200,21,200,22,230,23,230,24,271,25,271,26,316,27,316,28,360,29,360,30,417,31,417,32,546,33,546,34,725,35,725,36,870,37,870,38,957,39,957,40,995,41,995,42,998,43,998,44,949,45,949,46,805,47,805,48,609,49,609,50,473,51,473,52,355,53,355,54,245,55,245,56,174,57,174,58,135,59,135,60,126,61,126,62,118,63,118,64,98,65,98,66,65,67,65,68,31,69,31,70,8,71,8,124,14,125,14,126,38,127,38,128,67,129,67,130,102,131,102,132,145,133,145,134,175,135,175,136,182,137,182,138,166,139,166,140,152,141,152,142,161,143,161,144,194,145,194,146,294,147,294,148,408,149,408,150,554,151,554,152,757,153,757,154,907,155,907,156,959,157,959,158,963,159,963,160,985,161,985,162,994,163,994,164,958,165,958,166,866,167,866,168,705,169,705,170,545,171,545,172,418,173,418,174,317,175,317,176,253,177,253,178,222,179,222,180,208,181,208,182,198,183,198,184,185,185,185,186,161,187,161,188,133,189,133,190,111,191,111,192,99,193,99,194,90,195,90,196,93,197,93,198,113,199,113,200,137,201,137,202,160,203,160,204,181,205,181,206,197,207,197,208,213,209,213,210,231,211,231,212,243,213,243,214,252,215,252,216,257,217,257,218,247,219,247,220,226,221,226,222,203,223,203,224,190,225,190,226,190,227,190,228,201,229,201,230,215,231,215,232,226,233,226,234,233,235,233,236,244,237,244,238,266,239,266,240,295,241,295,242,314,243,314,244,311,245,311,246,296,247,296,248,284,249,284,250,279,251,279,252,275,253,275,254,264,255,264,},[224]={0,263,1,263,2,249,3,249,4,241,5,241,6,241,7,241,8,237,9,237,10,228,11,228,12,219,13,219,14,206,15,206,16,192,17,192,18,189,19,189,20,207,21,207,22,247,23,247,24,300,25,300,26,355,27,355,28,404,29,404,30,455,31,455,32,568,33,568,34,718,35,718,36,847,37,847,38,939,39,939,40,992,41,992,42,1010,43,1010,44,998,45,998,46,884,47,884,48,683,49,683,50,531,51,531,52,394,53,394,54,279,55,279,56,203,57,203,58,168,59,168,60,165,61,165,62,154,63,154,64,126,65,126,66,84,67,84,68,40,69,40,70,14,71,14,122,10,123,10,124,24,125,24,126,52,127,52,128,81,129,81,130,111,131,111,132,144,133,144,134,163,135,163,136,162,137,162,138,145,139,145,140,146,141,146,142,189,143,189,144,258,145,258,146,405,147,405,148,531,149,531,150,648,151,648,152,813,153,813,154,919,155,919,156,954,157,954,158,969,159,969,160,993,161,993,162,1004,163,1004,164,968,165,968,166,878,167,878,168,726,169,726,170,580,171,580,172,461,173,461,174,362,175,362,176,289,177,289,178,247,179,247,180,223,181,223,182,206,183,206,184,186,185,186,186,158,187,158,188,129,189,129,190,108,191,108,192,95,193,95,194,88,195,88,196,93,197,93,198,109,199,109,200,131,201,131,202,157,203,157,204,185,205,185,206,213,207,213,208,247,209,247,210,282,211,282,212,309,213,309,214,329,215,329,216,335,217,335,218,317,219,317,220,283,221,283,222,248,223,248,224,224,225,224,226,216,227,216,228,222,229,222,230,233,231,233,232,242,233,242,234,248,235,248,236,256,237,256,238,272,239,272,240,295,241,295,242,312,243,312,244,308,245,308,246,291,247,291,248,275,249,275,250,267,251,267,252,265,253,265,254,261,255,261,},[225]={0,263,1,263,2,249,3,249,4,241,5,241,6,241,7,241,8,237,9,237,10,228,11,228,12,219,13,219,14,206,15,206,16,192,17,192,18,189,19,189,20,207,21,207,22,247,23,247,24,300,25,300,26,355,27,355,28,404,29,404,30,455,31,455,32,568,33,568,34,718,35,718,36,847,37,847,38,939,39,939,40,992,41,992,42,1010,43,1010,44,998,45,998,46,884,47,884,48,683,49,683,50,531,51,531,52,394,53,394,54,279,55,279,56,203,57,203,58,168,59,168,60,165,61,165,62,154,63,154,64,126,65,126,66,84,67,84,68,40,69,40,70,14,71,14,122,10,123,10,124,24,125,24,126,52,127,52,128,81,129,81,130,111,131,111,132,144,133,144,134,163,135,163,136,162,137,162,138,145,139,145,140,146,141,146,142,189,143,189,144,258,145,258,146,405,147,405,148,531,149,531,150,648,151,648,152,813,153,813,154,919,155,919,156,954,157,954,158,969,159,969,160,993,161,993,162,1004,163,1004,164,968,165,968,166,878,167,878,168,726,169,726,170,580,171,580,172,461,173,461,174,362,175,362,176,289,177,289,178,247,179,247,180,223,181,223,182,206,183,206,184,186,185,186,186,158,187,158,188,129,189,129,190,108,191,108,192,95,193,95,194,88,195,88,196,93,197,93,198,109,199,109,200,131,201,131,202,157,203,157,204,185,205,185,206,213,207,213,208,247,209,247,210,282,211,282,212,309,213,309,214,329,215,329,216,335,217,335,218,317,219,317,220,283,221,283,222,248,223,248,224,224,225,224,226,216,227,216,228,222,229,222,230,233,231,233,232,242,233,242,234,248,235,248,236,256,237,256,238,272,239,272,240,295,241,295,242,312,243,312,244,308,245,308,246,291,247,291,248,275,249,275,250,267,251,267,252,265,253,265,254,261,255,261,},[226]={0,257,1,257,2,252,3,252,4,254,5,254,6,262,7,262,8,262,9,262,10,252,11,252,12,237,13,237,14,213,15,213,16,187,17,187,18,178,19,178,20,194,21,194,22,234,23,234,24,287,25,287,26,344,27,344,28,390,29,390,30,436,31,436,32,548,33,548,34,692,35,692,36,816,37,816,38,923,39,923,40,987,41,987,42,1009,43,1009,44,991,45,991,46,852,47,852,48,634,49,634,50,490,51,490,52,373,53,373,54,278,55,278,56,213,57,213,58,181,59,181,60,173,61,173,62,156,63,156,64,125,65,125,66,82,67,82,68,40,69,40,70,14,71,14,122,9,123,9,124,22,125,22,126,48,127,48,128,73,129,73,130,94,131,94,132,114,133,114,134,122,135,122,136,118,137,118,138,109,139,109,140,127,141,127,142,196,143,196,144,283,145,283,146,439,147,439,148,552,149,552,150,636,151,636,152,775,153,775,154,880,155,880,156,933,157,933,158,974,159,974,160,1001,161,1001,162,1005,163,1005,164,958,165,958,166,854,167,854,168,700,169,700,170,562,171,562,172,458,173,458,174,373,175,373,176,305,177,305,178,259,179,259,180,229,181,229,182,207,183,207,184,185,185,185,186,157,187,157,188,130,189,130,190,110,191,110,192,98,193,98,194,91,195,91,196,95,197,95,198,106,199,106,200,124,201,124,202,150,203,150,204,184,205,184,206,226,207,226,208,277,209,277,210,330,211,330,212,373,213,373,214,402,215,402,216,408,217,408,218,383,219,383,220,339,221,339,222,296,223,296,224,263,225,263,226,247,227,247,228,245,229,245,230,251,231,251,232,259,233,259,234,267,235,267,236,278,237,278,238,293,239,293,240,309,241,309,242,317,243,317,244,306,245,306,246,284,247,284,248,262,249,262,250,248,251,248,252,247,253,247,254,250,255,250,},[227]={0,257,1,257,2,252,3,252,4,254,5,254,6,262,7,262,8,262,9,262,10,252,11,252,12,237,13,237,14,213,15,213,16,187,17,187,18,178,19,178,20,194,21,194,22,234,23,234,24,287,25,287,26,344,27,344,28,390,29,390,30,436,31,436,32,548,33,548,34,692,35,692,36,816,37,816,38,923,39,923,40,987,41,987,42,1009,43,1009,44,991,45,991,46,852,47,852,48,634,49,634,50,490,51,490,52,373,53,373,54,278,55,278,56,213,57,213,58,181,59,181,60,173,61,173,62,156,63,156,64,125,65,125,66,82,67,82,68,40,69,40,70,14,71,14,122,9,123,9,124,22,125,22,126,48,127,48,128,73,129,73,130,94,131,94,132,114,133,114,134,122,135,122,136,118,137,118,138,109,139,109,140,127,141,127,142,196,143,196,144,283,145,283,146,439,147,439,148,552,149,552,150,636,151,636,152,775,153,775,154,880,155,880,156,933,157,933,158,974,159,974,160,1001,161,1001,162,1005,163,1005,164,958,165,958,166,854,167,854,168,700,169,700,170,562,171,562,172,458,173,458,174,373,175,373,176,305,177,305,178,259,179,259,180,229,181,229,182,207,183,207,184,185,185,185,186,157,187,157,188,130,189,130,190,110,191,110,192,98,193,98,194,91,195,91,196,95,197,95,198,106,199,106,200,124,201,124,202,150,203,150,204,184,205,184,206,226,207,226,208,277,209,277,210,330,211,330,212,373,213,373,214,402,215,402,216,408,217,408,218,383,219,383,220,339,221,339,222,296,223,296,224,263,225,263,226,247,227,247,228,245,229,245,230,251,231,251,232,259,233,259,234,267,235,267,236,278,237,278,238,293,239,293,240,309,241,309,242,317,243,317,244,306,245,306,246,284,247,284,248,262,249,262,250,248,251,248,252,247,253,247,254,250,255,250,},[228]={0,242,1,242,2,246,3,246,4,258,5,258,6,273,7,273,8,276,9,276,10,264,11,264,12,243,13,243,14,211,15,211,16,176,17,176,18,160,19,160,20,168,21,168,22,198,23,198,24,241,25,241,26,288,27,288,28,325,29,325,30,366,31,366,32,489,33,489,34,647,35,647,36,793,37,793,38,917,39,917,40,981,41,981,42,991,43,991,44,917,45,917,46,705,47,705,48,478,49,478,50,361,51,361,52,286,53,286,54,232,55,232,56,190,57,190,58,167,59,167,60,150,61,150,62,126,63,126,64,95,65,95,66,60,67,60,68,29,69,29,70,9,71,9,126,32,127,32,128,49,129,49,130,63,131,63,132,73,133,73,134,77,135,77,136,79,137,79,138,83,139,83,140,112,141,112,142,178,143,178,144,252,145,252,146,371,147,371,148,444,149,444,150,505,151,505,152,641,153,641,154,768,155,768,156,883,157,883,158,965,159,965,160,997,161,997,162,995,163,995,164,924,165,924,166,792,167,792,168,631,169,631,170,504,171,504,172,420,173,420,174,353,175,353,176,298,177,298,178,255,179,255,180,223,181,223,182,201,183,201,184,181,185,181,186,156,187,156,188,132,189,132,190,114,191,114,192,102,193,102,194,95,195,95,196,94,197,94,198,100,199,100,200,115,201,115,202,140,203,140,204,176,205,176,206,228,207,228,208,292,209,292,210,356,211,356,212,408,213,408,214,443,215,443,216,449,217,449,218,422,219,422,220,377,221,377,222,332,223,332,224,296,225,296,226,275,227,275,228,266,229,266,230,266,231,266,232,271,233,271,234,281,235,281,236,297,237,297,238,312,239,312,240,322,241,322,242,321,243,321,244,302,245,302,246,274,247,274,248,245,249,245,250,226,251,226,252,226,253,226,254,233,255,233,},[229]={0,242,1,242,2,246,3,246,4,258,5,258,6,273,7,273,8,276,9,276,10,264,11,264,12,243,13,243,14,211,15,211,16,176,17,176,18,160,19,160,20,168,21,168,22,198,23,198,24,241,25,241,26,288,27,288,28,325,29,325,30,366,31,366,32,489,33,489,34,647,35,647,36,793,37,793,38,917,39,917,40,981,41,981,42,991,43,991,44,917,45,917,46,705,47,705,48,478,49,478,50,361,51,361,52,286,53,286,54,232,55,232,56,190,57,190,58,167,59,167,60,150,61,150,62,126,63,126,64,95,65,95,66,60,67,60,68,29,69,29,70,9,71,9,126,32,127,32,128,49,129,49,130,63,131,63,132,73,133,73,134,77,135,77,136,79,137,79,138,83,139,83,140,112,141,112,142,178,143,178,144,252,145,252,146,371,147,371,148,444,149,444,150,505,151,505,152,641,153,641,154,768,155,768,156,883,157,883,158,965,159,965,160,997,161,997,162,995,163,995,164,924,165,924,166,792,167,792,168,631,169,631,170,504,171,504,172,420,173,420,174,353,175,353,176,298,177,298,178,255,179,255,180,223,181,223,182,201,183,201,184,181,185,181,186,156,187,156,188,132,189,132,190,114,191,114,192,102,193,102,194,95,195,95,196,94,197,94,198,100,199,100,200,115,201,115,202,140,203,140,204,176,205,176,206,228,207,228,208,292,209,292,210,356,211,356,212,408,213,408,214,443,215,443,216,449,217,449,218,422,219,422,220,377,221,377,222,332,223,332,224,296,225,296,226,275,227,275,228,266,229,266,230,266,231,266,232,271,233,271,234,281,235,281,236,297,237,297,238,312,239,312,240,322,241,322,242,321,243,321,244,302,245,302,246,274,247,274,248,245,249,245,250,226,251,226,252,226,253,226,254,233,255,233,},[230]={0,227,1,227,2,240,3,240,4,260,5,260,6,280,7,280,8,284,9,284,10,269,11,269,12,242,13,242,14,203,15,203,16,164,17,164,18,144,19,144,20,144,21,144,22,160,23,160,24,187,25,187,26,219,27,219,28,243,29,243,30,283,31,283,32,413,33,413,34,583,35,583,36,751,37,751,38,889,39,889,40,944,41,944,42,911,43,911,44,763,45,763,46,515,47,515,48,309,49,309,50,234,51,234,52,193,53,193,54,172,55,172,56,145,57,145,58,127,59,127,60,106,61,106,62,79,63,79,64,55,65,55,66,33,67,33,128,25,129,25,130,37,131,37,132,43,133,43,134,48,135,48,136,54,137,54,138,67,139,67,140,98,141,98,142,145,143,145,144,186,145,186,146,248,147,248,148,273,149,273,150,317,151,317,152,448,153,448,154,611,155,611,156,791,157,791,158,919,159,919,160,973,161,973,162,956,163,956,164,857,165,857,166,704,167,704,168,540,169,540,170,429,171,429,172,362,173,362,174,314,175,314,176,272,177,272,178,236,179,236,180,209,181,209,182,192,183,192,184,177,185,177,186,155,187,155,188,134,189,134,190,117,191,117,192,103,193,103,194,93,195,93,196,88,197,88,198,90,199,90,200,101,201,101,202,125,203,125,204,164,205,164,206,223,207,223,208,292,209,292,210,356,211,356,212,409,213,409,214,444,215,444,216,452,217,452,218,429,219,429,220,390,221,390,222,352,223,352,224,319,225,319,226,298,227,298,228,285,229,285,230,279,231,279,232,280,233,280,234,290,235,290,236,308,237,308,238,321,239,321,240,325,241,325,242,317,243,317,244,294,245,294,246,263,247,263,248,229,249,229,250,209,251,209,252,210,253,210,254,220,255,220,},[231]={0,227,1,227,2,240,3,240,4,260,5,260,6,280,7,280,8,284,9,284,10,269,11,269,12,242,13,242,14,203,15,203,16,164,17,164,18,144,19,144,20,144,21,144,22,160,23,160,24,187,25,187,26,219,27,219,28,243,29,243,30,283,31,283,32,413,33,413,34,583,35,583,36,751,37,751,38,889,39,889,40,944,41,944,42,911,43,911,44,763,45,763,46,515,47,515,48,309,49,309,50,234,51,234,52,193,53,193,54,172,55,172,56,145,57,145,58,127,59,127,60,106,61,106,62,79,63,79,64,55,65,55,66,33,67,33,128,25,129,25,130,37,131,37,132,43,133,43,134,48,135,48,136,54,137,54,138,67,139,67,140,98,141,98,142,145,143,145,144,186,145,186,146,248,147,248,148,273,149,273,150,317,151,317,152,448,153,448,154,611,155,611,156,791,157,791,158,919,159,919,160,973,161,973,162,956,163,956,164,857,165,857,166,704,167,704,168,540,169,540,170,429,171,429,172,362,173,362,174,314,175,314,176,272,177,272,178,236,179,236,180,209,181,209,182,192,183,192,184,177,185,177,186,155,187,155,188,134,189,134,190,117,191,117,192,103,193,103,194,93,195,93,196,88,197,88,198,90,199,90,200,101,201,101,202,125,203,125,204,164,205,164,206,223,207,223,208,292,209,292,210,356,211,356,212,409,213,409,214,444,215,444,216,452,217,452,218,429,219,429,220,390,221,390,222,352,223,352,224,319,225,319,226,298,227,298,228,285,229,285,230,279,231,279,232,280,233,280,234,290,235,290,236,308,237,308,238,321,239,321,240,325,241,325,242,317,243,317,244,294,245,294,246,263,247,263,248,229,249,229,250,209,251,209,252,210,253,210,254,220,255,220,},[232]={0,222,1,222,2,240,3,240,4,266,5,266,6,289,7,289,8,291,9,291,10,271,11,271,12,237,13,237,14,195,15,195,16,157,17,157,18,136,19,136,20,131,21,131,22,136,23,136,24,150,25,150,26,169,27,169,28,183,29,183,30,218,31,218,32,339,33,339,34,501,35,501,36,665,37,665,38,790,39,790,40,827,41,827,42,748,43,748,44,572,45,572,46,346,47,346,48,201,49,201,50,150,51,150,52,129,53,129,54,114,55,114,56,96,57,96,58,79,59,79,60,57,61,57,62,39,63,39,64,23,65,23,128,11,129,11,130,19,131,19,132,23,133,23,134,28,135,28,136,38,137,38,138,55,139,55,140,83,141,83,142,117,143,117,144,134,145,134,146,151,147,151,148,148,149,148,150,165,151,165,152,275,153,275,154,455,155,455,156,662,157,662,158,819,159,819,160,892,161,892,162,861,163,861,164,749,165,749,166,595,167,595,168,446,169,446,170,352,171,352,172,301,173,301,174,265,175,265,176,237,177,237,178,213,179,213,180,197,181,197,182,187,183,187,184,177,185,177,186,158,187,158,188,136,189,136,190,115,191,115,192,98,193,98,194,84,195,84,196,75,197,75,198,75,199,75,200,84,201,84,202,106,203,106,204,146,205,146,206,206,207,206,208,271,209,271,210,329,211,329,212,375,213,375,214,407,215,407,216,418,217,418,218,405,219,405,220,380,221,380,222,354,223,354,224,332,225,332,226,315,227,315,228,300,229,300,230,289,231,289,232,285,233,285,234,292,235,292,236,308,237,308,238,318,239,318,240,317,241,317,242,304,243,304,244,280,245,280,246,250,247,250,248,218,249,218,250,200,251,200,252,202,253,202,254,213,255,213,},[233]={0,222,1,222,2,240,3,240,4,266,5,266,6,289,7,289,8,291,9,291,10,271,11,271,12,237,13,237,14,195,15,195,16,157,17,157,18,136,19,136,20,131,21,131,22,136,23,136,24,150,25,150,26,169,27,169,28,183,29,183,30,218,31,218,32,339,33,339,34,501,35,501,36,665,37,665,38,790,39,790,40,827,41,827,42,748,43,748,44,572,45,572,46,346,47,346,48,201,49,201,50,150,51,150,52,129,53,129,54,114,55,114,56,96,57,96,58,79,59,79,60,57,61,57,62,39,63,39,64,23,65,23,128,11,129,11,130,19,131,19,132,23,133,23,134,28,135,28,136,38,137,38,138,55,139,55,140,83,141,83,142,117,143,117,144,134,145,134,146,151,147,151,148,148,149,148,150,165,151,165,152,275,153,275,154,455,155,455,156,662,157,662,158,819,159,819,160,892,161,892,162,861,163,861,164,749,165,749,166,595,167,595,168,446,169,446,170,352,171,352,172,301,173,301,174,265,175,265,176,237,177,237,178,213,179,213,180,197,181,197,182,187,183,187,184,177,185,177,186,158,187,158,188,136,189,136,190,115,191,115,192,98,193,98,194,84,195,84,196,75,197,75,198,75,199,75,200,84,201,84,202,106,203,106,204,146,205,146,206,206,207,206,208,271,209,271,210,329,211,329,212,375,213,375,214,407,215,407,216,418,217,418,218,405,219,405,220,380,221,380,222,354,223,354,224,332,225,332,226,315,227,315,228,300,229,300,230,289,231,289,232,285,233,285,234,292,235,292,236,308,237,308,238,318,239,318,240,317,241,317,242,304,243,304,244,280,245,280,246,250,247,250,248,218,249,218,250,200,251,200,252,202,253,202,254,213,255,213,},[234]={0,226,1,226,2,247,3,247,4,278,5,278,6,302,7,302,8,301,9,301,10,275,11,275,12,237,13,237,14,194,15,194,16,159,17,159,18,140,19,140,20,132,21,132,22,130,23,130,24,135,25,135,26,144,27,144,28,151,29,151,30,177,31,177,32,267,33,267,34,393,35,393,36,526,37,526,38,627,39,627,40,632,41,632,42,542,43,542,44,389,45,389,46,227,47,227,48,140,49,140,50,102,51,102,52,83,53,83,54,68,55,68,56,51,57,51,58,37,59,37,60,24,61,24,128,1,129,1,130,7,131,7,132,9,133,9,134,15,135,15,136,24,137,24,138,42,139,42,140,73,141,73,142,99,143,99,144,111,145,111,146,113,147,113,148,96,149,96,150,91,151,91,152,162,153,162,154,314,155,314,156,500,157,500,158,662,159,662,160,730,161,730,162,697,163,697,164,600,165,600,166,467,167,467,168,349,169,349,170,279,171,279,172,240,173,240,174,217,175,217,176,203,177,203,178,195,179,195,180,191,181,191,182,189,183,189,184,182,185,182,186,163,187,163,188,136,189,136,190,108,191,108,192,86,193,86,194,69,195,69,196,59,197,59,198,58,199,58,200,66,201,66,202,85,203,85,204,122,205,122,206,176,207,176,208,230,209,230,210,274,211,274,212,309,213,309,214,336,215,336,216,352,217,352,218,353,219,353,220,346,221,346,222,337,223,337,224,328,225,328,226,318,227,318,228,302,229,302,230,287,231,287,232,278,233,278,234,283,235,283,236,296,237,296,238,303,239,303,240,297,241,297,242,280,243,280,244,258,245,258,246,233,247,233,248,206,249,206,250,194,251,194,252,199,253,199,254,212,255,212,},[235]={0,226,1,226,2,247,3,247,4,278,5,278,6,302,7,302,8,301,9,301,10,275,11,275,12,237,13,237,14,194,15,194,16,159,17,159,18,140,19,140,20,132,21,132,22,130,23,130,24,135,25,135,26,144,27,144,28,151,29,151,30,177,31,177,32,267,33,267,34,393,35,393,36,526,37,526,38,627,39,627,40,632,41,632,42,542,43,542,44,389,45,389,46,227,47,227,48,140,49,140,50,102,51,102,52,83,53,83,54,68,55,68,56,51,57,51,58,37,59,37,60,24,61,24,128,1,129,1,130,7,131,7,132,9,133,9,134,15,135,15,136,24,137,24,138,42,139,42,140,73,141,73,142,99,143,99,144,111,145,111,146,113,147,113,148,96,149,96,150,91,151,91,152,162,153,162,154,314,155,314,156,500,157,500,158,662,159,662,160,730,161,730,162,697,163,697,164,600,165,600,166,467,167,467,168,349,169,349,170,279,171,279,172,240,173,240,174,217,175,217,176,203,177,203,178,195,179,195,180,191,181,191,182,189,183,189,184,182,185,182,186,163,187,163,188,136,189,136,190,108,191,108,192,86,193,86,194,69,195,69,196,59,197,59,198,58,199,58,200,66,201,66,202,85,203,85,204,122,205,122,206,176,207,176,208,230,209,230,210,274,211,274,212,309,213,309,214,336,215,336,216,352,217,352,218,353,219,353,220,346,221,346,222,337,223,337,224,328,225,328,226,318,227,318,228,302,229,302,230,287,231,287,232,278,233,278,234,283,235,283,236,296,237,296,238,303,239,303,240,297,241,297,242,280,243,280,244,258,245,258,246,233,247,233,248,206,249,206,250,194,251,194,252,199,253,199,254,212,255,212,},[236]={0,232,1,232,2,258,3,258,4,292,5,292,6,319,7,319,8,316,9,316,10,286,11,286,12,246,13,246,14,205,15,205,16,173,17,173,18,155,19,155,20,144,21,144,22,135,23,135,24,132,25,132,26,134,27,134,28,135,29,135,30,147,31,147,32,199,33,199,34,275,35,275,36,359,37,359,38,417,39,417,40,403,41,403,42,333,43,333,44,237,45,237,46,144,47,144,48,93,49,93,50,64,51,64,52,46,53,46,54,33,55,33,56,22,57,22,58,13,59,13,136,12,137,12,138,25,139,25,140,52,141,52,142,76,143,76,144,94,145,94,146,102,147,102,148,88,149,88,150,68,151,68,152,104,153,104,154,198,155,198,156,340,157,340,158,466,159,466,160,518,161,518,162,495,163,495,164,427,165,427,166,336,167,336,168,257,169,257,170,211,171,211,172,184,173,184,174,174,175,174,176,177,177,177,178,184,179,184,180,191,181,191,182,194,183,194,184,188,185,188,186,165,187,165,188,130,189,130,190,97,191,97,192,72,193,72,194,54,195,54,196,43,197,43,198,42,199,42,200,48,201,48,202,65,203,65,204,96,205,96,206,138,207,138,208,176,209,176,210,203,211,203,212,226,213,226,214,249,215,249,216,269,217,269,218,283,219,283,220,294,221,294,222,302,223,302,224,305,225,305,226,302,227,302,228,288,229,288,230,270,231,270,232,261,233,261,234,265,235,265,236,276,237,276,238,278,239,278,240,267,241,267,242,247,243,247,244,228,245,228,246,209,247,209,248,190,249,190,250,185,251,185,252,195,253,195,254,212,255,212,},[237]={0,232,1,232,2,258,3,258,4,292,5,292,6,319,7,319,8,316,9,316,10,286,11,286,12,246,13,246,14,205,15,205,16,173,17,173,18,155,19,155,20,144,21,144,22,135,23,135,24,132,25,132,26,134,27,134,28,135,29,135,30,147,31,147,32,199,33,199,34,275,35,275,36,359,37,359,38,417,39,417,40,403,41,403,42,333,43,333,44,237,45,237,46,144,47,144,48,93,49,93,50,64,51,64,52,46,53,46,54,33,55,33,56,22,57,22,58,13,59,13,136,12,137,12,138,25,139,25,140,52,141,52,142,76,143,76,144,94,145,94,146,102,147,102,148,88,149,88,150,68,151,68,152,104,153,104,154,198,155,198,156,340,157,340,158,466,159,466,160,518,161,518,162,495,163,495,164,427,165,427,166,336,167,336,168,257,169,257,170,211,171,211,172,184,173,184,174,174,175,174,176,177,177,177,178,184,179,184,180,191,181,191,182,194,183,194,184,188,185,188,186,165,187,165,188,130,189,130,190,97,191,97,192,72,193,72,194,54,195,54,196,43,197,43,198,42,199,42,200,48,201,48,202,65,203,65,204,96,205,96,206,138,207,138,208,176,209,176,210,203,211,203,212,226,213,226,214,249,215,249,216,269,217,269,218,283,219,283,220,294,221,294,222,302,223,302,224,305,225,305,226,302,227,302,228,288,229,288,230,270,231,270,232,261,233,261,234,265,235,265,236,276,237,276,238,278,239,278,240,267,241,267,242,247,243,247,244,228,245,228,246,209,247,209,248,190,249,190,250,185,251,185,252,195,253,195,254,212,255,212,},[238]={0,237,1,237,2,270,3,270,4,309,5,309,6,339,7,339,8,338,9,338,10,306,11,306,12,265,13,265,14,226,15,226,16,196,17,196,18,177,19,177,20,162,21,162,22,147,23,147,24,136,25,136,26,131,27,131,28,124,29,124,30,122,31,122,32,142,33,142,34,179,35,179,36,221,37,221,38,242,39,242,40,225,41,225,42,182,43,182,44,132,45,132,46,89,47,89,48,56,49,56,50,35,51,35,52,21,53,21,54,12,55,12,142,47,143,47,144,68,145,68,146,83,147,83,148,80,149,80,150,68,151,68,152,78,153,78,154,123,155,123,156,211,157,211,158,291,159,291,160,324,161,324,162,315,163,315,164,279,165,279,166,229,167,229,168,184,169,184,170,153,171,153,172,137,173,137,174,140,175,140,176,158,177,158,178,178,179,178,180,193,181,193,182,199,183,199,184,190,185,190,186,162,187,162,188,123,189,123,190,86,191,86,192,60,193,60,194,41,195,41,196,31,197,31,198,29,199,29,200,33,201,33,202,47,203,47,204,72,205,72,206,101,207,101,208,123,209,123,210,138,211,138,212,151,213,151,214,169,215,169,216,191,217,191,218,214,219,214,220,236,221,236,222,255,223,255,224,269,225,269,226,273,227,273,228,263,229,263,230,247,231,247,232,239,233,239,234,242,235,242,236,249,237,249,238,246,239,246,240,231,241,231,242,210,243,210,244,194,245,194,246,180,247,180,248,170,249,170,250,173,251,173,252,189,253,189,254,211,255,211,},[239]={0,237,1,237,2,270,3,270,4,309,5,309,6,339,7,339,8,338,9,338,10,306,11,306,12,265,13,265,14,226,15,226,16,196,17,196,18,177,19,177,20,162,21,162,22,147,23,147,24,136,25,136,26,131,27,131,28,124,29,124,30,122,31,122,32,142,33,142,34,179,35,179,36,221,37,221,38,242,39,242,40,225,41,225,42,182,43,182,44,132,45,132,46,89,47,89,48,56,49,56,50,35,51,35,52,21,53,21,54,12,55,12,142,47,143,47,144,68,145,68,146,83,147,83,148,80,149,80,150,68,151,68,152,78,153,78,154,123,155,123,156,211,157,211,158,291,159,291,160,324,161,324,162,315,163,315,164,279,165,279,166,229,167,229,168,184,169,184,170,153,171,153,172,137,173,137,174,140,175,140,176,158,177,158,178,178,179,178,180,193,181,193,182,199,183,199,184,190,185,190,186,162,187,162,188,123,189,123,190,86,191,86,192,60,193,60,194,41,195,41,196,31,197,31,198,29,199,29,200,33,201,33,202,47,203,47,204,72,205,72,206,101,207,101,208,123,209,123,210,138,211,138,212,151,213,151,214,169,215,169,216,191,217,191,218,214,219,214,220,236,221,236,222,255,223,255,224,269,225,269,226,273,227,273,228,263,229,263,230,247,231,247,232,239,233,239,234,242,235,242,236,249,237,249,238,246,239,246,240,231,241,231,242,210,243,210,244,194,245,194,246,180,247,180,248,170,249,170,250,173,251,173,252,189,253,189,254,211,255,211,},[240]={0,242,1,242,2,284,3,284,4,330,5,330,6,364,7,364,8,365,9,365,10,334,11,334,12,292,13,292,14,253,15,253,16,223,17,223,18,205,19,205,20,188,21,188,22,168,23,168,24,151,25,151,26,136,27,136,28,120,29,120,30,109,31,109,32,111,33,111,34,125,35,125,36,137,37,137,38,138,39,138,40,119,41,119,42,101,43,101,44,76,45,76,46,49,47,49,48,29,49,29,50,15,51,15,142,19,143,19,144,36,145,36,146,53,147,53,148,61,149,61,150,62,151,62,152,65,153,65,154,88,155,88,156,127,157,127,158,172,159,172,160,192,161,192,162,191,163,191,164,179,165,179,166,157,167,157,168,131,169,131,170,111,171,111,172,104,173,104,174,118,175,118,176,145,177,145,178,174,179,174,180,193,181,193,182,198,183,198,184,186,185,186,186,157,187,157,188,116,189,116,190,79,191,79,192,53,193,53,194,33,195,33,196,22,197,22,198,19,199,19,200,21,201,21,202,32,203,32,204,51,205,51,206,69,207,69,208,81,209,81,210,88,211,88,212,97,213,97,214,112,215,112,216,133,217,133,218,157,219,157,220,184,221,184,222,209,223,209,224,230,225,230,226,240,227,240,228,234,229,234,230,222,231,222,232,213,233,213,234,212,235,212,236,215,237,215,238,210,239,210,240,196,241,196,242,178,243,178,244,165,245,165,246,155,247,155,248,151,249,151,250,160,251,160,252,181,253,181,254,209,255,209,},[241]={0,242,1,242,2,284,3,284,4,330,5,330,6,364,7,364,8,365,9,365,10,334,11,334,12,292,13,292,14,253,15,253,16,223,17,223,18,205,19,205,20,188,21,188,22,168,23,168,24,151,25,151,26,136,27,136,28,120,29,120,30,109,31,109,32,111,33,111,34,125,35,125,36,137,37,137,38,138,39,138,40,119,41,119,42,101,43,101,44,76,45,76,46,49,47,49,48,29,49,29,50,15,51,15,142,19,143,19,144,36,145,36,146,53,147,53,148,61,149,61,150,62,151,62,152,65,153,65,154,88,155,88,156,127,157,127,158,172,159,172,160,192,161,192,162,191,163,191,164,179,165,179,166,157,167,157,168,131,169,131,170,111,171,111,172,104,173,104,174,118,175,118,176,145,177,145,178,174,179,174,180,193,181,193,182,198,183,198,184,186,185,186,186,157,187,157,188,116,189,116,190,79,191,79,192,53,193,53,194,33,195,33,196,22,197,22,198,19,199,19,200,21,201,21,202,32,203,32,204,51,205,51,206,69,207,69,208,81,209,81,210,88,211,88,212,97,213,97,214,112,215,112,216,133,217,133,218,157,219,157,220,184,221,184,222,209,223,209,224,230,225,230,226,240,227,240,228,234,229,234,230,222,231,222,232,213,233,213,234,212,235,212,236,215,237,215,238,210,239,210,240,196,241,196,242,178,243,178,244,165,245,165,246,155,247,155,248,151,249,151,250,160,251,160,252,181,253,181,254,209,255,209,},[242]={0,245,1,245,2,299,3,299,4,355,5,355,6,396,7,396,8,399,9,399,10,369,11,369,12,324,13,324,14,283,15,283,16,260,17,260,18,250,19,250,20,237,21,237,22,216,23,216,24,188,25,188,26,156,27,156,28,125,29,125,30,105,31,105,32,98,33,98,34,101,35,101,36,98,37,98,38,85,39,85,40,73,41,73,42,56,43,56,44,38,45,38,46,21,47,21,146,25,147,25,148,38,149,38,150,49,151,49,152,59,153,59,154,68,155,68,156,83,157,83,158,106,159,106,160,120,161,120,162,123,163,123,164,122,165,122,166,114,167,114,168,100,169,100,170,87,171,87,172,87,173,87,174,107,175,107,176,140,177,140,178,171,179,171,180,189,181,189,182,193,183,193,184,180,185,180,186,152,187,152,188,113,189,113,190,76,191,76,192,49,193,49,194,29,195,29,196,18,197,18,198,13,199,13,200,12,201,12,202,20,203,20,204,32,205,32,206,43,207,43,208,48,209,48,210,53,211,53,212,61,213,61,214,74,215,74,216,94,217,94,218,117,219,117,220,143,221,143,222,171,223,171,224,194,225,194,226,207,227,207,228,205,229,205,230,195,231,195,232,184,233,184,234,179,235,179,236,180,237,180,238,179,239,179,240,172,241,172,242,161,243,161,244,151,245,151,246,142,247,142,248,139,249,139,250,149,251,149,252,171,253,171,254,205,255,205,},[243]={0,245,1,245,2,299,3,299,4,355,5,355,6,396,7,396,8,399,9,399,10,369,11,369,12,324,13,324,14,283,15,283,16,260,17,260,18,250,19,250,20,237,21,237,22,216,23,216,24,188,25,188,26,156,27,156,28,125,29,125,30,105,31,105,32,98,33,98,34,101,35,101,36,98,37,98,38,85,39,85,40,73,41,73,42,56,43,56,44,38,45,38,46,21,47,21,146,25,147,25,148,38,149,38,150,49,151,49,152,59,153,59,154,68,155,68,156,83,157,83,158,106,159,106,160,120,161,120,162,123,163,123,164,122,165,122,166,114,167,114,168,100,169,100,170,87,171,87,172,87,173,87,174,107,175,107,176,140,177,140,178,171,179,171,180,189,181,189,182,193,183,193,184,180,185,180,186,152,187,152,188,113,189,113,190,76,191,76,192,49,193,49,194,29,195,29,196,18,197,18,198,13,199,13,200,12,201,12,202,20,203,20,204,32,205,32,206,43,207,43,208,48,209,48,210,53,211,53,212,61,213,61,214,74,215,74,216,94,217,94,218,117,219,117,220,143,221,143,222,171,223,171,224,194,225,194,226,207,227,207,228,205,229,205,230,195,231,195,232,184,233,184,234,179,235,179,236,180,237,180,238,179,239,179,240,172,241,172,242,161,243,161,244,151,245,151,246,142,247,142,248,139,249,139,250,149,251,149,252,171,253,171,254,205,255,205,},[244]={0,246,1,246,2,314,3,314,4,384,5,384,6,433,7,433,8,442,9,442,10,412,11,412,12,368,13,368,14,342,15,342,16,345,17,345,18,353,19,353,20,342,21,342,22,306,23,306,24,255,25,255,26,195,27,195,28,141,29,141,30,106,31,106,32,89,33,89,34,83,35,83,36,69,37,69,38,53,39,53,40,39,41,39,42,26,43,26,146,8,147,8,148,19,149,19,150,30,151,30,152,43,153,43,154,49,155,49,156,58,157,58,158,71,159,71,160,83,161,83,162,89,163,89,164,93,165,93,166,92,167,92,168,85,169,85,170,77,171,77,172,82,173,82,174,105,175,105,176,138,177,138,178,166,179,166,180,183,181,183,182,187,183,187,184,177,185,177,186,154,187,154,188,117,189,117,190,79,191,79,192,49,193,49,194,28,195,28,196,16,197,16,198,9,199,9,200,7,201,7,202,11,203,11,204,18,205,18,206,23,207,23,208,25,209,25,210,29,211,29,212,36,213,36,214,50,215,50,216,68,217,68,218,87,219,87,220,111,221,111,222,138,223,138,224,161,225,161,226,174,227,174,228,175,229,175,230,167,231,167,232,156,233,156,234,151,235,151,236,154,237,154,238,160,239,160,240,164,241,164,242,161,243,161,244,152,245,152,246,140,247,140,248,133,249,133,250,139,251,139,252,161,253,161,254,200,255,200,},[245]={0,246,1,246,2,314,3,314,4,384,5,384,6,433,7,433,8,442,9,442,10,412,11,412,12,368,13,368,14,342,15,342,16,345,17,345,18,353,19,353,20,342,21,342,22,306,23,306,24,255,25,255,26,195,27,195,28,141,29,141,30,106,31,106,32,89,33,89,34,83,35,83,36,69,37,69,38,53,39,53,40,39,41,39,42,26,43,26,146,8,147,8,148,19,149,19,150,30,151,30,152,43,153,43,154,49,155,49,156,58,157,58,158,71,159,71,160,83,161,83,162,89,163,89,164,93,165,93,166,92,167,92,168,85,169,85,170,77,171,77,172,82,173,82,174,105,175,105,176,138,177,138,178,166,179,166,180,183,181,183,182,187,183,187,184,177,185,177,186,154,187,154,188,117,189,117,190,79,191,79,192,49,193,49,194,28,195,28,196,16,197,16,198,9,199,9,200,7,201,7,202,11,203,11,204,18,205,18,206,23,207,23,208,25,209,25,210,29,211,29,212,36,213,36,214,50,215,50,216,68,217,68,218,87,219,87,220,111,221,111,222,138,223,138,224,161,225,161,226,174,227,174,228,175,229,175,230,167,231,167,232,156,233,156,234,151,235,151,236,154,237,154,238,160,239,160,240,164,241,164,242,161,243,161,244,152,245,152,246,140,247,140,248,133,249,133,250,139,251,139,252,161,253,161,254,200,255,200,},[246]={0,248,1,248,2,333,3,333,4,419,5,419,6,478,7,478,8,494,9,494,10,472,11,472,12,442,13,442,14,453,15,453,16,495,17,495,18,517,19,517,20,498,21,498,22,433,23,433,24,347,25,347,26,253,27,253,28,167,29,167,30,107,31,107,32,73,33,73,34,60,35,60,36,44,37,44,38,28,39,28,40,17,41,17,150,13,151,13,152,22,153,22,154,30,155,30,156,37,157,37,158,49,159,49,160,61,161,61,162,71,163,71,164,79,165,79,166,82,167,82,168,79,169,79,170,76,171,76,172,85,173,85,174,109,175,109,176,138,177,138,178,160,179,160,180,174,181,174,182,181,183,181,184,177,185,177,186,161,187,161,188,127,189,127,190,88,191,88,192,56,193,56,194,32,195,32,196,17,197,17,198,9,199,9,200,6,201,6,202,7,203,7,204,9,205,9,206,11,207,11,208,12,209,12,210,15,211,15,212,20,213,20,214,33,215,33,216,49,217,49,218,65,219,65,220,84,221,84,222,108,223,108,224,130,225,130,226,144,227,144,228,147,229,147,230,142,231,142,232,134,233,134,234,133,235,133,236,142,237,142,238,156,239,156,240,168,241,168,242,170,243,170,244,161,245,161,246,143,247,143,248,130,249,130,250,133,251,133,252,154,253,154,254,198,255,198,},[247]={0,248,1,248,2,333,3,333,4,419,5,419,6,478,7,478,8,494,9,494,10,472,11,472,12,442,13,442,14,453,15,453,16,495,17,495,18,517,19,517,20,498,21,498,22,433,23,433,24,347,25,347,26,253,27,253,28,167,29,167,30,107,31,107,32,73,33,73,34,60,35,60,36,44,37,44,38,28,39,28,40,17,41,17,150,13,151,13,152,22,153,22,154,30,155,30,156,37,157,37,158,49,159,49,160,61,161,61,162,71,163,71,164,79,165,79,166,82,167,82,168,79,169,79,170,76,171,76,172,85,173,85,174,109,175,109,176,138,177,138,178,160,179,160,180,174,181,174,182,181,183,181,184,177,185,177,186,161,187,161,188,127,189,127,190,88,191,88,192,56,193,56,194,32,195,32,196,17,197,17,198,9,199,9,200,6,201,6,202,7,203,7,204,9,205,9,206,11,207,11,208,12,209,12,210,15,211,15,212,20,213,20,214,33,215,33,216,49,217,49,218,65,219,65,220,84,221,84,222,108,223,108,224,130,225,130,226,144,227,144,228,147,229,147,230,142,231,142,232,134,233,134,234,133,235,133,236,142,237,142,238,156,239,156,240,168,241,168,242,170,243,170,244,161,245,161,246,143,247,143,248,130,249,130,250,133,251,133,252,154,253,154,254,198,255,198,},[248]={0,260,1,260,2,357,3,357,4,457,5,457,6,526,7,526,8,551,9,551,10,543,11,543,12,542,13,542,14,598,15,598,16,674,17,674,18,704,19,704,20,671,21,671,22,580,23,580,24,462,25,462,26,327,27,327,28,192,29,192,30,98,31,98,32,54,33,54,34,36,35,36,36,23,37,23,38,11,39,11,152,7,153,7,154,14,155,14,156,20,157,20,158,30,159,30,160,43,161,43,162,56,163,56,164,68,165,68,166,76,167,76,168,78,169,78,170,80,171,80,172,93,173,93,174,116,175,116,176,140,177,140,178,156,179,156,180,166,181,166,182,173,183,173,184,176,185,176,186,167,187,167,188,139,189,139,190,103,191,103,192,69,193,69,194,42,195,42,196,24,197,24,198,15,199,15,200,11,201,11,202,9,203,9,204,8,205,8,206,7,207,7,208,7,209,7,210,8,211,8,212,12,213,12,214,23,215,23,216,37,217,37,218,48,219,48,220,64,221,64,222,86,223,86,224,105,225,105,226,119,227,119,228,125,229,125,230,124,231,124,232,121,233,121,234,124,235,124,236,138,237,138,238,158,239,158,240,175,241,175,242,179,243,179,244,168,245,168,246,147,247,147,248,130,249,130,250,131,251,131,252,156,253,156,254,205,255,205,},[249]={0,260,1,260,2,357,3,357,4,457,5,457,6,526,7,526,8,551,9,551,10,543,11,543,12,542,13,542,14,598,15,598,16,674,17,674,18,704,19,704,20,671,21,671,22,580,23,580,24,462,25,462,26,327,27,327,28,192,29,192,30,98,31,98,32,54,33,54,34,36,35,36,36,23,37,23,38,11,39,11,152,7,153,7,154,14,155,14,156,20,157,20,158,30,159,30,160,43,161,43,162,56,163,56,164,68,165,68,166,76,167,76,168,78,169,78,170,80,171,80,172,93,173,93,174,116,175,116,176,140,177,140,178,156,179,156,180,166,181,166,182,173,183,173,184,176,185,176,186,167,187,167,188,139,189,139,190,103,191,103,192,69,193,69,194,42,195,42,196,24,197,24,198,15,199,15,200,11,201,11,202,9,203,9,204,8,205,8,206,7,207,7,208,7,209,7,210,8,211,8,212,12,213,12,214,23,215,23,216,37,217,37,218,48,219,48,220,64,221,64,222,86,223,86,224,105,225,105,226,119,227,119,228,125,229,125,230,124,231,124,232,121,233,121,234,124,235,124,236,138,237,138,238,158,239,158,240,175,241,175,242,179,243,179,244,168,245,168,246,147,247,147,248,130,249,130,250,131,251,131,252,156,253,156,254,205,255,205,},[250]={0,284,1,284,2,385,3,385,4,490,5,490,6,566,7,566,8,603,9,603,10,620,11,620,12,653,13,653,14,743,15,743,16,831,17,831,18,859,19,859,20,828,21,828,22,726,23,726,24,582,25,582,26,403,27,403,28,215,29,215,30,89,31,89,32,42,33,42,34,22,35,22,156,8,157,8,158,15,159,15,160,26,161,26,162,39,163,39,164,53,165,53,166,67,167,67,168,75,169,75,170,83,171,83,172,101,173,101,174,124,175,124,176,144,177,144,178,154,179,154,180,159,181,159,182,163,183,163,184,170,185,170,186,168,187,168,188,148,189,148,190,117,191,117,192,85,193,85,194,58,195,58,196,41,197,41,198,32,199,32,200,27,201,27,202,22,203,22,204,17,205,17,206,13,207,13,208,10,209,10,210,9,211,9,212,11,213,11,214,20,215,20,216,32,217,32,218,42,219,42,220,56,221,56,222,74,223,74,224,90,225,90,226,102,227,102,228,110,229,110,230,112,231,112,232,113,233,113,234,118,235,118,236,134,237,134,238,156,239,156,240,174,241,174,242,178,243,178,244,167,245,167,246,145,247,145,248,131,249,131,250,136,251,136,252,167,253,167,254,222,255,222,},[251]={0,284,1,284,2,385,3,385,4,490,5,490,6,566,7,566,8,603,9,603,10,620,11,620,12,653,13,653,14,743,15,743,16,831,17,831,18,859,19,859,20,828,21,828,22,726,23,726,24,582,25,582,26,403,27,403,28,215,29,215,30,89,31,89,32,42,33,42,34,22,35,22,156,8,157,8,158,15,159,15,160,26,161,26,162,39,163,39,164,53,165,53,166,67,167,67,168,75,169,75,170,83,171,83,172,101,173,101,174,124,175,124,176,144,177,144,178,154,179,154,180,159,181,159,182,163,183,163,184,170,185,170,186,168,187,168,188,148,189,148,190,117,191,117,192,85,193,85,194,58,195,58,196,41,197,41,198,32,199,32,200,27,201,27,202,22,203,22,204,17,205,17,206,13,207,13,208,10,209,10,210,9,211,9,212,11,213,11,214,20,215,20,216,32,217,32,218,42,219,42,220,56,221,56,222,74,223,74,224,90,225,90,226,102,227,102,228,110,229,110,230,112,231,112,232,113,233,113,234,118,235,118,236,134,237,134,238,156,239,156,240,174,241,174,242,178,243,178,244,167,245,167,246,145,247,145,248,131,249,131,250,136,251,136,252,167,253,167,254,222,255,222,},[252]={0,311,1,311,2,406,3,406,4,510,5,510,6,596,7,596,8,650,9,650,10,698,11,698,12,757,13,757,14,852,15,852,16,929,17,929,18,952,19,952,20,930,21,930,22,834,23,834,24,669,25,669,26,453,27,453,28,229,29,229,30,93,31,93,32,42,33,42,34,18,35,18,160,11,161,11,162,21,163,21,164,34,165,34,166,54,167,54,168,74,169,74,170,93,171,93,172,115,173,115,174,136,175,136,176,149,177,149,178,153,179,153,180,153,181,153,182,155,183,155,184,163,185,163,186,166,187,166,188,154,189,154,190,131,191,131,192,104,193,104,194,83,195,83,196,70,197,70,198,63,199,63,200,56,201,56,202,47,203,47,204,38,205,38,206,30,207,30,208,22,209,22,210,18,211,18,212,18,213,18,214,26,215,26,216,36,217,36,218,46,219,46,220,60,221,60,222,74,223,74,224,84,225,84,226,93,227,93,228,101,229,101,230,105,231,105,232,107,233,107,234,113,235,113,236,128,237,128,238,147,239,147,240,163,241,163,242,168,243,168,244,159,245,159,246,142,247,142,248,133,249,133,250,146,251,146,252,184,253,184,254,242,255,242,},[253]={0,311,1,311,2,406,3,406,4,510,5,510,6,596,7,596,8,650,9,650,10,698,11,698,12,757,13,757,14,852,15,852,16,929,17,929,18,952,19,952,20,930,21,930,22,834,23,834,24,669,25,669,26,453,27,453,28,229,29,229,30,93,31,93,32,42,33,42,34,18,35,18,160,11,161,11,162,21,163,21,164,34,165,34,166,54,167,54,168,74,169,74,170,93,171,93,172,115,173,115,174,136,175,136,176,149,177,149,178,153,179,153,180,153,181,153,182,155,183,155,184,163,185,163,186,166,187,166,188,154,189,154,190,131,191,131,192,104,193,104,194,83,195,83,196,70,197,70,198,63,199,63,200,56,201,56,202,47,203,47,204,38,205,38,206,30,207,30,208,22,209,22,210,18,211,18,212,18,213,18,214,26,215,26,216,36,217,36,218,46,219,46,220,60,221,60,222,74,223,74,224,84,225,84,226,93,227,93,228,101,229,101,230,105,231,105,232,107,233,107,234,113,235,113,236,128,237,128,238,147,239,147,240,163,241,163,242,168,243,168,244,159,245,159,246,142,247,142,248,133,249,133,250,146,251,146,252,184,253,184,254,242,255,242,},[254]={0,326,1,326,2,407,3,407,4,512,5,512,6,607,7,607,8,686,9,686,10,764,11,764,12,829,13,829,14,908,15,908,16,962,17,962,18,988,19,988,20,971,21,971,22,879,23,879,24,702,25,702,26,470,27,470,28,240,29,240,30,107,31,107,32,48,33,48,34,21,35,21,164,16,165,16,166,38,167,38,168,70,169,70,170,98,171,98,172,123,173,123,174,141,175,141,176,148,177,148,178,151,179,151,180,153,181,153,182,158,183,158,184,169,185,169,186,175,187,175,188,168,189,168,190,152,191,152,192,133,193,133,194,120,195,120,196,113,197,113,198,107,199,107,200,98,201,98,202,83,203,83,204,67,205,67,206,54,207,54,208,41,209,41,210,34,211,34,212,34,213,34,214,40,215,40,216,48,217,48,218,58,219,58,220,72,221,72,222,82,223,82,224,87,225,87,226,94,227,94,228,102,229,102,230,107,231,107,232,110,233,110,234,113,235,113,236,124,237,124,238,139,239,139,240,152,241,152,242,156,243,156,244,152,245,152,246,142,247,142,248,139,249,139,250,158,251,158,252,200,253,200,254,255,255,255,},[255]={0,326,1,326,2,407,3,407,4,512,5,512,6,607,7,607,8,686,9,686,10,764,11,764,12,829,13,829,14,908,15,908,16,962,17,962,18,988,19,988,20,971,21,971,22,879,23,879,24,702,25,702,26,470,27,470,28,240,29,240,30,107,31,107,32,48,33,48,34,21,35,21,164,16,165,16,166,38,167,38,168,70,169,70,170,98,171,98,172,123,173,123,174,141,175,141,176,148,177,148,178,151,179,151,180,153,181,153,182,158,183,158,184,169,185,169,186,175,187,175,188,168,189,168,190,152,191,152,192,133,193,133,194,120,195,120,196,113,197,113,198,107,199,107,200,98,201,98,202,83,203,83,204,67,205,67,206,54,207,54,208,41,209,41,210,34,211,34,212,34,213,34,214,40,215,40,216,48,217,48,218,58,219,58,220,72,221,72,222,82,223,82,224,87,225,87,226,94,227,94,228,102,229,102,230,107,231,107,232,110,233,110,234,113,235,113,236,124,237,124,238,139,239,139,240,152,241,152,242,156,243,156,244,152,245,152,246,142,247,142,248,139,249,139,250,158,251,158,252,200,253,200,254,255,255,255,}
		},
		
		markers ={
			
		},
		
		objects = {
			[0]={16,5,18,-1,0,30,5,2,-1,1792,234,5,1,-1,0,},[2]={208,5,2,-1,0,226,5,2,-1,0,},[4]={12,5,18,-1,0,36,5,2,-1,0,170,5,2,-1,1536,},[8]={192,5,2,-1,0,220,5,1,-1,0,},[10]={236,5,2,-1,0,},[12]={166,5,2,-1,1792,182,5,18,-1,0,198,5,1,-1,0,},[14]={172,5,1,-1,0,224,5,2,-1,0,252,5,1,-1,0,},[16]={16,5,3,-1,0,186,5,18,-1,0,230,5,1,-1,0,240,5,1,-1,0,},[18]={8,5,1,-1,0,},[20]={206,5,1,-1,0,},[22]={14,5,2,-1,0,250,5,1,-1,0,},[28]={200,5,1,-1,0,},[30]={184,5,2,-1,1536,222,5,18,-1,0,226,5,18,-1,0,},[32]={188,5,1,-1,0,},[34]={210,5,1,-1,0,238,5,3,-1,1792,},[36]={214,5,1,-1,0,},[40]={236,5,2,-1,0,},[42]={212,5,1,-1,0,},[136]={222,5,1,-1,0,},[148]={220,5,1,-1,0,},[150]={182,5,1,-1,0,},[152]={244,5,3,-1,1280,},[156]={188,5,2,-1,1024,210,5,1,-1,0,230,5,18,-1,0,234,5,18,-1,0,},[158]={194,5,1,-1,0,248,5,3,-1,1536,},[162]={208,5,1,-1,0,246,5,3,-1,1792,},[164]={16,5,2,-1,256,},[168]={164,5,2,-1,0,},[170]={0,5,1,-1,0,12,5,3,-1,1024,186,5,18,-1,0,222,5,2,-1,0,},[172]={200,5,2,-1,0,218,5,1,-1,0,},[174]={182,5,18,-1,0,226,5,1,-1,0,248,5,1,-1,0,},[176]={234,5,1,-1,0,},[178]={172,5,3,-1,512,206,5,1,-1,0,224,5,2,-1,0,},[182]={14,5,18,-1,0,190,5,1,-1,0,254,5,1,-1,0,},[184]={224,5,1,-1,0,236,5,2,-1,0,},[186]={0,5,2,-1,0,18,5,18,-1,0,30,5,2,-1,0,202,5,2,-1,0,},[188]={34,5,2,-1,1280,184,5,1,-1,0,},[190]={28,5,2,-1,1536,168,5,1,-1,0,188,5,2,-1,0,228,5,1,-1,0,252,5,1,-1,0,},[194]={206,5,1,-1,0,232,5,1,-1,0,248,5,2,-1,0,},[196]={192,5,1,-1,0,198,5,1,-1,0,},[198]={170,5,1,-1,0,210,5,1,-1,0,224,5,1,-1,0,},[200]={10,5,1,-1,0,32,5,1,-1,0,},[202]={250,5,1,-1,0,},[204]={154,5,1,-1,0,210,5,2,-1,1024,246,5,1,-1,0,},[206]={4,5,2,-1,0,26,5,1,-1,0,40,5,2,-1,0,146,5,1,-1,0,214,5,2,-1,1024,},[208]={180,5,1,-1,0,202,5,2,-1,512,236,5,2,-1,1280,244,5,1,-1,0,},[210]={46,5,1,-1,0,190,5,2,-1,0,206,5,2,-1,0,234,5,2,-1,1792,250,5,1,-1,0,},[212]={148,5,2,-1,1280,174,5,2,-1,0,240,5,2,-1,512,},[214]={16,5,1,-1,0,28,5,1,-1,0,182,5,2,-1,0,244,5,2,-1,1024,},[216]={24,5,2,-1,0,},[218]={176,5,1,-1,0,194,5,1,-1,0,},[220]={30,5,2,-1,0,158,5,18,-1,0,198,5,1,-1,0,},[222]={40,5,18,-1,0,254,5,1,-1,0,},[224]={4,5,1,-1,0,12,5,1,-1,0,158,5,18,-1,0,236,5,2,-1,1280,},[226]={6,5,1,-1,0,40,5,18,-1,0,192,5,1,-1,0,},[228]={14,5,2,-1,0,178,5,2,-1,0,210,5,2,-1,256,240,5,2,-1,512,},[230]={186,5,1,-1,0,218,5,2,-1,768,234,5,2,-1,512,},[232]={18,5,1,-1,0,},[234]={48,5,1,-1,0,142,5,2,-1,1280,206,5,2,-1,0,242,5,1,-1,0,254,5,2,-1,0,},[236]={2,5,1,-1,0,42,5,1,-1,0,238,5,2,-1,1792,},[238]={148,5,2,-1,512,206,5,1,-1,0,214,5,2,-1,1792,},[240]={28,5,1,-1,0,200,5,1,-1,0,240,5,1,-1,0,244,5,1,-1,0,},[242]={8,5,1,-1,0,44,5,1,-1,0,206,5,1,-1,0,},[244]={4,5,1,-1,0,34,5,1,-1,0,170,5,1,-1,0,242,5,1,-1,0,},[246]={162,5,1,-1,0,200,5,1,-1,0,},[248]={6,5,2,-1,0,192,5,2,-1,0,226,5,1,-1,0,},[250]={220,5,1,-1,0,244,5,2,-1,0,},[252]={184,5,2,-1,0,224,5,1,-1,0,},[254]={190,5,1,-1,0,252,5,1,-1,0,}
		},
		
		shaman_positions = {
			222, 158, 224, 40, 30, 224, 156, 232, 14, 184, 184, 16, 172, 184, 2, 14
		},
		
		scripts = {
			OnTurn = function(everySecond1, everySecond2, everySecond4) 			sparkling_tiles_on_turn(everySecond1, everySecond2, everySecond4) end,
			OnCreateThing = function(t, owner, type, model) 						sparkling_tiles_on_create_thing(t, owner, type, model) end,
			OnHumanDisconnect = function(player) 									ST_init_single_AI(player) end,
		},
		
	},
	
	[MAP_QUAKE_ARENA]={
	
		info = 	{ 	name = "Quake Arena", author = "MrKosjaK",
					desc = "Your convert spell has become a laser and will instantly kill enemy shamans. <br> With precision shooting, you'll hit shamans from across the globe, and game changing powerups will give you the edge to earn the most kills and become champion of the arena. <p> Kills grant 1 point. Powerups occasionally spawn on the map. They are: <p> - Grenade: throws a grenade, killing any shamans in a wide area. <br> - Shield: greatly reduces any damage taken for a short duration.",
					map_objectives = { {value=5, step=1, default=true}, {value=35, step=5, default=true}, {} },
					image = 3152, texture={12, 2}, zoom={88,192,256}, drop_infos = true,	marker_lb={216, 92}, reinc_timer=4, shield_respawn=true,
					custom_rules = {
						{ default = false, 	name = "Laser is tribe colored", desc = "The laser color (sparkles) become the color of the caster. (by default, the sparkles are white + yellow)" },
						{ default = false, 	name = "Deathmatch", desc = "When enabled, each shaman has 10 lives. Once all lives are depleted from a player, they are permanently out of the game. Every time a solo player or team lose all its players, points get awarded accordingly. This happens until only one player/team remains. Note: Deathmatch ignores any preset winning conditions (like timer-goal and/or points-goal)" },
					}
				},

		land ={
			[30]={222,25,223,25,224,28,225,28,226,18,227,18,},[31]={222,25,223,25,224,28,225,28,226,18,227,18,},[32]={220,37,221,37,222,59,223,59,224,61,225,61,226,43,227,43,228,18,229,18,},[33]={220,37,221,37,222,59,223,59,224,61,225,61,226,43,227,43,228,18,229,18,},[34]={220,69,221,69,222,95,223,95,224,95,225,95,226,67,227,67,228,30,229,30,},[35]={220,69,221,69,222,95,223,95,224,95,225,95,226,67,227,67,228,30,229,30,},[36]={218,40,219,40,220,103,221,103,222,124,223,124,224,116,225,116,226,81,227,81,228,38,229,38,},[37]={218,40,219,40,220,103,221,103,222,124,223,124,224,116,225,116,226,81,227,81,228,38,229,38,},[38]={216,36,217,36,218,87,219,87,220,126,221,126,222,133,223,133,224,115,225,115,226,79,227,79,228,42,229,42,230,18,231,18,},[39]={216,36,217,36,218,87,219,87,220,126,221,126,222,133,223,133,224,115,225,115,226,79,227,79,228,42,229,42,230,18,231,18,},[40]={214,24,215,24,216,67,217,67,218,112,219,112,220,137,221,137,222,125,223,125,224,97,225,97,226,64,227,64,228,42,229,42,230,26,231,26,},[41]={214,24,215,24,216,67,217,67,218,112,219,112,220,137,221,137,222,125,223,125,224,97,225,97,226,64,227,64,228,42,229,42,230,26,231,26,},[42]={212,9,213,9,214,36,215,36,216,77,217,77,218,112,219,112,220,125,221,125,222,107,223,107,224,75,225,75,226,48,227,48,228,39,229,39,230,32,231,32,232,18,233,18,},[43]={212,9,213,9,214,36,215,36,216,77,217,77,218,112,219,112,220,125,221,125,222,107,223,107,224,75,225,75,226,48,227,48,228,39,229,39,230,32,231,32,232,18,233,18,},[44]={210,11,211,11,212,23,213,23,214,46,215,46,216,75,217,75,218,99,219,99,220,103,221,103,222,87,223,87,224,61,225,61,226,41,227,41,228,39,229,39,230,41,231,41,232,31,233,31,234,14,235,14,},[45]={210,11,211,11,212,23,213,23,214,46,215,46,216,75,217,75,218,99,219,99,220,103,221,103,222,87,223,87,224,61,225,61,226,41,227,41,228,39,229,39,230,41,231,41,232,31,233,31,234,14,235,14,},[46]={8,11,9,11,10,19,11,19,12,31,13,31,14,38,15,38,16,36,17,36,18,29,19,29,20,16,21,16,166,21,167,21,168,38,169,38,170,48,171,48,172,46,173,46,174,37,175,37,176,27,177,27,208,29,209,29,210,47,211,47,212,64,213,64,214,76,215,76,216,90,217,90,218,99,219,99,220,96,221,96,222,83,223,83,224,60,225,60,226,46,227,46,228,49,229,49,230,58,231,58,232,50,233,50,234,29,235,29,},[47]={8,11,9,11,10,19,11,19,12,31,13,31,14,38,15,38,16,36,17,36,18,29,19,29,20,16,21,16,166,21,167,21,168,38,169,38,170,48,171,48,172,46,173,46,174,37,175,37,176,27,177,27,208,29,209,29,210,47,211,47,212,64,213,64,214,76,215,76,216,90,217,90,218,99,219,99,220,96,221,96,222,83,223,83,224,60,225,60,226,46,227,46,228,49,229,49,230,58,231,58,232,50,233,50,234,29,235,29,},[48]={4,8,5,8,6,14,7,14,8,23,9,23,10,35,11,35,12,54,13,54,14,69,15,69,16,66,17,66,18,55,19,55,20,32,21,32,166,34,167,34,168,70,169,70,170,92,171,92,172,98,173,98,174,92,175,92,176,88,177,88,178,90,179,90,180,80,181,80,182,69,183,69,184,54,185,54,186,38,187,38,188,1024,189,1024,190,1024,191,1024,206,91,207,91,208,138,209,138,210,175,211,175,212,196,213,196,214,184,215,184,216,163,217,163,218,152,219,152,220,136,221,136,222,117,223,117,224,91,225,91,226,72,227,72,228,75,229,75,230,219,231,219,232,617,233,617,234,453,235,453,},[49]={4,8,5,8,6,14,7,14,8,23,9,23,10,35,11,35,12,54,13,54,14,69,15,69,16,66,17,66,18,55,19,55,20,32,21,32,166,34,167,34,168,70,169,70,170,92,171,92,172,98,173,98,174,92,175,92,176,88,177,88,178,90,179,90,180,80,181,80,182,69,183,69,184,54,185,54,186,38,187,38,188,1024,189,1024,190,1024,191,1024,206,91,207,91,208,138,209,138,210,175,211,175,212,196,213,196,214,184,215,184,216,163,217,163,218,152,219,152,220,136,221,136,222,117,223,117,224,91,225,91,226,72,227,72,228,75,229,75,230,219,231,219,232,617,233,617,234,453,235,453,},[50]={0,8,1,8,2,15,3,15,4,23,5,23,6,30,7,30,8,39,9,39,10,48,11,48,12,71,13,71,14,87,15,87,16,84,17,84,18,70,19,70,20,37,21,37,166,43,167,43,168,87,169,87,170,118,171,118,172,136,173,136,174,136,175,136,176,155,177,155,178,175,179,175,180,167,181,167,182,153,183,153,184,123,185,123,186,93,187,93,188,1024,189,1024,190,1024,191,1024,192,350,193,350,194,29,195,29,196,42,197,42,198,63,199,63,200,93,201,93,202,126,203,126,204,164,205,164,206,229,207,229,208,298,209,298,210,336,211,336,212,347,213,347,214,311,215,311,216,255,217,255,218,225,219,225,220,204,221,204,222,179,223,179,224,158,225,158,226,546,227,546,228,585,229,585,230,1024,231,1024,232,1024,233,1024,234,835,235,835,},[51]={0,8,1,8,2,15,3,15,4,23,5,23,6,30,7,30,8,39,9,39,10,48,11,48,12,71,13,71,14,87,15,87,16,84,17,84,18,70,19,70,20,37,21,37,166,43,167,43,168,87,169,87,170,118,171,118,172,136,173,136,174,136,175,136,176,155,177,155,178,175,179,175,180,167,181,167,182,153,183,153,184,123,185,123,186,93,187,93,188,1024,189,1024,190,1024,191,1024,192,350,193,350,194,29,195,29,196,42,197,42,198,63,199,63,200,93,201,93,202,126,203,126,204,164,205,164,206,229,207,229,208,298,209,298,210,336,211,336,212,347,213,347,214,311,215,311,216,255,217,255,218,225,219,225,220,204,221,204,222,179,223,179,224,158,225,158,226,546,227,546,228,585,229,585,230,1024,231,1024,232,1024,233,1024,234,835,235,835,},[52]={0,18,1,18,2,29,3,29,4,42,5,42,6,49,7,49,8,54,9,54,10,56,11,56,12,71,13,71,14,85,15,85,16,79,17,79,18,63,19,63,20,33,21,33,166,37,167,37,168,80,169,80,170,122,171,122,172,156,173,156,174,174,175,174,176,207,177,207,178,233,179,233,180,235,181,235,182,224,183,224,184,192,185,192,186,160,187,160,188,1024,189,1024,190,1024,191,1024,192,750,193,750,194,78,195,78,196,112,197,112,198,162,199,162,200,211,201,211,202,251,203,251,204,294,205,294,206,358,207,358,208,417,209,417,210,439,211,439,212,434,213,434,214,376,215,376,216,310,217,310,218,273,219,273,220,247,221,247,222,224,223,224,224,664,225,664,226,1024,227,1024,228,1024,229,1024,230,1024,231,1024,232,1024,233,1024,234,528,235,528,254,15,255,15,},[53]={0,18,1,18,2,29,3,29,4,42,5,42,6,49,7,49,8,54,9,54,10,56,11,56,12,71,13,71,14,85,15,85,16,79,17,79,18,63,19,63,20,33,21,33,166,37,167,37,168,80,169,80,170,122,171,122,172,156,173,156,174,174,175,174,176,207,177,207,178,233,179,233,180,235,181,235,182,224,183,224,184,192,185,192,186,160,187,160,188,1024,189,1024,190,1024,191,1024,192,750,193,750,194,78,195,78,196,112,197,112,198,162,199,162,200,211,201,211,202,251,203,251,204,294,205,294,206,358,207,358,208,417,209,417,210,439,211,439,212,434,213,434,214,376,215,376,216,310,217,310,218,273,219,273,220,247,221,247,222,224,223,224,224,664,225,664,226,1024,227,1024,228,1024,229,1024,230,1024,231,1024,232,1024,233,1024,234,528,235,528,254,15,255,15,},[54]={0,36,1,36,2,50,3,50,4,62,5,62,6,63,7,63,8,64,9,64,10,59,11,59,12,66,13,66,14,73,15,73,16,61,17,61,18,41,19,41,20,18,21,18,168,58,169,58,170,103,171,103,172,148,173,148,174,185,175,185,176,229,177,229,178,265,179,265,180,275,181,275,182,270,183,270,184,250,185,250,186,219,187,219,188,1024,189,1024,190,1024,191,1024,192,754,193,754,194,156,195,156,196,218,197,218,198,291,199,291,200,332,201,332,202,351,203,351,204,370,205,370,206,411,207,411,208,440,209,440,210,437,211,437,212,422,213,422,214,365,215,365,216,303,217,303,218,943,219,943,220,921,221,921,222,588,223,588,224,1024,225,1024,226,1024,227,1024,228,1024,229,1024,230,1024,231,1024,232,349,233,349,234,245,235,245,236,122,237,122,238,61,239,61,250,32,251,32,252,34,253,34,254,37,255,37,},[55]={0,36,1,36,2,50,3,50,4,62,5,62,6,63,7,63,8,64,9,64,10,59,11,59,12,66,13,66,14,73,15,73,16,61,17,61,18,41,19,41,20,18,21,18,168,58,169,58,170,103,171,103,172,148,173,148,174,185,175,185,176,229,177,229,178,265,179,265,180,275,181,275,182,270,183,270,184,250,185,250,186,219,187,219,188,1024,189,1024,190,1024,191,1024,192,754,193,754,194,156,195,156,196,218,197,218,198,291,199,291,200,332,201,332,202,351,203,351,204,370,205,370,206,411,207,411,208,440,209,440,210,437,211,437,212,422,213,422,214,365,215,365,216,303,217,303,218,943,219,943,220,921,221,921,222,588,223,588,224,1024,225,1024,226,1024,227,1024,228,1024,229,1024,230,1024,231,1024,232,349,233,349,234,245,235,245,236,122,237,122,238,61,239,61,250,32,251,32,252,34,253,34,254,37,255,37,},[56]={0,62,1,62,2,72,3,72,4,77,5,77,6,71,7,71,8,69,9,69,10,63,11,63,12,67,13,67,14,62,15,62,16,41,17,41,168,36,169,36,170,75,171,75,172,126,173,126,174,166,175,166,176,212,177,212,178,259,179,259,180,275,181,275,182,277,183,277,184,269,185,269,186,237,187,237,188,1024,189,1024,190,1024,191,1024,192,454,193,454,194,250,195,250,196,334,197,334,198,407,199,407,200,410,201,410,202,385,203,385,204,368,205,368,206,366,207,366,208,360,209,360,210,338,211,338,212,447,213,447,214,1024,215,1024,216,1024,217,1024,218,1024,219,1024,220,1024,221,1024,222,921,223,921,224,1024,225,1024,226,1024,227,1024,228,986,229,986,230,472,231,472,232,307,233,307,234,262,235,262,236,206,237,206,238,147,239,147,240,123,241,123,242,124,243,124,244,126,245,126,246,118,247,118,248,96,249,96,250,72,251,72,252,64,253,64,254,66,255,66,},[57]={0,62,1,62,2,72,3,72,4,77,5,77,6,71,7,71,8,69,9,69,10,63,11,63,12,67,13,67,14,62,15,62,16,41,17,41,168,36,169,36,170,75,171,75,172,126,173,126,174,166,175,166,176,212,177,212,178,259,179,259,180,275,181,275,182,277,183,277,184,269,185,269,186,237,187,237,188,1024,189,1024,190,1024,191,1024,192,454,193,454,194,250,195,250,196,334,197,334,198,407,199,407,200,410,201,410,202,385,203,385,204,368,205,368,206,366,207,366,208,360,209,360,210,338,211,338,212,447,213,447,214,1024,215,1024,216,1024,217,1024,218,1024,219,1024,220,1024,221,1024,222,921,223,921,224,1024,225,1024,226,1024,227,1024,228,986,229,986,230,472,231,472,232,307,233,307,234,262,235,262,236,206,237,206,238,147,239,147,240,123,241,123,242,124,243,124,244,126,245,126,246,118,247,118,248,96,249,96,250,72,251,72,252,64,253,64,254,66,255,66,},[58]={0,89,1,89,2,94,3,94,4,92,5,92,6,83,7,83,8,81,9,81,10,76,11,76,12,68,13,68,14,52,15,52,16,25,17,25,170,54,171,54,172,102,173,102,174,143,175,143,176,187,177,187,178,235,179,235,180,255,181,255,182,262,183,262,184,261,185,261,186,240,187,240,188,1024,189,1024,190,1024,191,1024,192,295,193,295,194,332,195,332,196,415,197,415,198,462,199,462,200,417,201,417,202,352,203,352,204,303,205,303,206,274,207,274,208,249,209,249,210,223,211,223,212,335,213,335,214,930,215,930,216,1024,217,1024,218,1024,219,1024,220,1024,221,1024,222,1020,223,1020,224,816,225,816,226,840,227,840,228,741,229,741,230,263,231,263,232,283,233,283,234,288,235,288,236,260,237,260,238,225,239,225,240,219,241,219,242,227,243,227,244,219,245,219,246,199,247,199,248,163,249,163,250,120,251,120,252,107,253,107,254,100,255,100,},[59]={0,89,1,89,2,94,3,94,4,92,5,92,6,83,7,83,8,81,9,81,10,76,11,76,12,68,13,68,14,52,15,52,16,25,17,25,170,54,171,54,172,102,173,102,174,143,175,143,176,187,177,187,178,235,179,235,180,255,181,255,182,262,183,262,184,261,185,261,186,240,187,240,188,1024,189,1024,190,1024,191,1024,192,295,193,295,194,332,195,332,196,415,197,415,198,462,199,462,200,417,201,417,202,352,203,352,204,303,205,303,206,274,207,274,208,249,209,249,210,223,211,223,212,335,213,335,214,930,215,930,216,1024,217,1024,218,1024,219,1024,220,1024,221,1024,222,1020,223,1020,224,816,225,816,226,840,227,840,228,741,229,741,230,263,231,263,232,283,233,283,234,288,235,288,236,260,237,260,238,225,239,225,240,219,241,219,242,227,243,227,244,219,245,219,246,199,247,199,248,163,249,163,250,120,251,120,252,107,253,107,254,100,255,100,},[60]={0,115,1,115,2,114,3,114,4,110,5,110,6,99,7,99,8,99,9,99,10,90,11,90,12,70,13,70,14,40,15,40,170,41,171,41,172,85,173,85,174,120,175,120,176,158,177,158,178,208,179,208,180,226,181,226,182,239,183,239,184,253,185,253,186,255,187,255,188,1024,189,1024,190,1024,191,1024,192,733,193,733,194,390,195,390,196,441,197,441,198,446,199,446,200,368,201,368,202,291,203,291,204,233,205,233,206,195,207,195,208,174,209,174,210,161,211,161,212,146,213,146,214,122,215,122,216,106,217,106,218,95,219,95,220,489,221,489,222,710,223,710,224,315,225,315,226,102,227,102,228,137,229,137,230,186,231,186,232,218,233,218,234,251,235,251,236,270,237,270,238,271,239,271,240,294,241,294,242,307,243,307,244,285,245,285,246,262,247,262,248,216,249,216,250,173,251,173,252,157,253,157,254,137,255,137,},[61]={0,115,1,115,2,114,3,114,4,110,5,110,6,99,7,99,8,99,9,99,10,90,11,90,12,70,13,70,14,40,15,40,170,41,171,41,172,85,173,85,174,120,175,120,176,158,177,158,178,208,179,208,180,226,181,226,182,239,183,239,184,253,185,253,186,255,187,255,188,1024,189,1024,190,1024,191,1024,192,733,193,733,194,390,195,390,196,441,197,441,198,446,199,446,200,368,201,368,202,291,203,291,204,233,205,233,206,195,207,195,208,174,209,174,210,161,211,161,212,146,213,146,214,122,215,122,216,106,217,106,218,95,219,95,220,489,221,489,222,710,223,710,224,315,225,315,226,102,227,102,228,137,229,137,230,186,231,186,232,218,233,218,234,251,235,251,236,270,237,270,238,271,239,271,240,294,241,294,242,307,243,307,244,285,245,285,246,262,247,262,248,216,249,216,250,173,251,173,252,157,253,157,254,137,255,137,},[62]={0,183,1,183,2,224,3,224,4,177,5,177,6,120,7,120,8,117,9,117,10,98,11,98,12,62,13,62,14,28,15,28,170,26,171,26,172,64,173,64,174,95,175,95,176,131,177,131,178,177,179,177,180,207,181,207,182,247,183,247,184,291,185,291,186,326,187,326,188,1024,189,1024,190,1024,191,1024,192,1024,193,1024,194,493,195,493,196,412,197,412,198,380,199,380,200,298,201,298,202,239,203,239,204,195,205,195,206,168,207,168,208,161,209,161,210,167,211,167,212,160,213,160,214,136,215,136,216,116,217,116,218,100,219,100,220,81,221,81,222,69,223,69,224,67,225,67,226,70,227,70,228,90,229,90,230,118,231,118,232,148,233,148,234,186,235,186,236,232,237,232,238,270,239,270,240,319,241,319,242,347,243,347,244,335,245,335,246,320,247,320,248,277,249,277,250,233,251,233,252,206,253,206,254,170,255,170,},[63]={0,183,1,183,2,224,3,224,4,177,5,177,6,120,7,120,8,117,9,117,10,98,11,98,12,62,13,62,14,28,15,28,170,26,171,26,172,64,173,64,174,95,175,95,176,131,177,131,178,177,179,177,180,207,181,207,182,247,183,247,184,291,185,291,186,326,187,326,188,1024,189,1024,190,1024,191,1024,192,1024,193,1024,194,493,195,493,196,412,197,412,198,380,199,380,200,298,201,298,202,239,203,239,204,195,205,195,206,168,207,168,208,161,209,161,210,167,211,167,212,160,213,160,214,136,215,136,216,116,217,116,218,100,219,100,220,81,221,81,222,69,223,69,224,67,225,67,226,70,227,70,228,90,229,90,230,118,231,118,232,148,233,148,234,186,235,186,236,232,237,232,238,270,239,270,240,319,241,319,242,347,243,347,244,335,245,335,246,320,247,320,248,277,249,277,250,233,251,233,252,206,253,206,254,170,255,170,},[64]={0,649,1,649,2,874,3,874,4,381,5,381,6,143,7,143,8,132,9,132,10,99,11,99,12,50,13,50,172,43,173,43,174,73,175,73,176,104,177,104,178,146,179,146,180,201,181,201,182,285,183,285,184,366,185,366,186,430,187,430,188,455,189,455,190,1024,191,1024,192,1024,193,1024,194,1024,195,1024,196,340,197,340,198,290,199,290,200,228,201,228,202,199,203,199,204,172,205,172,206,159,207,159,208,166,209,166,210,182,211,182,212,183,213,183,214,159,215,159,216,132,217,132,218,110,219,110,220,85,221,85,222,69,223,69,224,63,225,63,226,62,227,62,228,69,229,69,230,82,231,82,232,99,233,99,234,129,235,129,236,183,237,183,238,231,239,231,240,295,241,295,242,339,243,339,244,345,245,345,246,351,247,351,248,323,249,323,250,281,251,281,252,241,253,241,254,197,255,197,},[65]={0,649,1,649,2,874,3,874,4,381,5,381,6,143,7,143,8,132,9,132,10,99,11,99,12,50,13,50,172,43,173,43,174,73,175,73,176,104,177,104,178,146,179,146,180,201,181,201,182,285,183,285,184,366,185,366,186,430,187,430,188,455,189,455,190,1024,191,1024,192,1024,193,1024,194,1024,195,1024,196,340,197,340,198,290,199,290,200,228,201,228,202,199,203,199,204,172,205,172,206,159,207,159,208,166,209,166,210,182,211,182,212,183,213,183,214,159,215,159,216,132,217,132,218,110,219,110,220,85,221,85,222,69,223,69,224,63,225,63,226,62,227,62,228,69,229,69,230,82,231,82,232,99,233,99,234,129,235,129,236,183,237,183,238,231,239,231,240,295,241,295,242,339,243,339,244,345,245,345,246,351,247,351,248,323,249,323,250,281,251,281,252,241,253,241,254,197,255,197,},[66]={0,945,1,945,2,1024,3,1024,4,534,5,534,6,160,7,160,8,139,9,139,10,93,11,93,12,43,13,43,172,30,173,30,174,60,175,60,176,85,177,85,178,134,179,134,180,217,181,217,182,336,183,336,184,449,185,449,186,518,187,518,188,524,189,524,190,471,191,471,192,1024,193,1024,194,1024,195,1024,196,372,197,372,198,214,199,214,200,177,201,177,202,169,203,169,204,159,205,159,206,158,207,158,208,174,209,174,210,192,211,192,212,193,213,193,214,165,215,165,216,132,217,132,218,108,219,108,220,83,221,83,222,68,223,68,224,66,225,66,226,69,227,69,228,73,229,73,230,80,231,80,232,86,233,86,234,102,235,102,236,143,237,143,238,185,239,185,240,252,241,252,242,306,243,306,244,327,245,327,246,350,247,350,248,333,249,333,250,297,251,297,252,260,253,260,254,220,255,220,},[67]={0,945,1,945,2,1024,3,1024,4,534,5,534,6,160,7,160,8,139,9,139,10,93,11,93,12,43,13,43,172,30,173,30,174,60,175,60,176,85,177,85,178,134,179,134,180,217,181,217,182,336,183,336,184,449,185,449,186,518,187,518,188,524,189,524,190,471,191,471,192,1024,193,1024,194,1024,195,1024,196,372,197,372,198,214,199,214,200,177,201,177,202,169,203,169,204,159,205,159,206,158,207,158,208,174,209,174,210,192,211,192,212,193,213,193,214,165,215,165,216,132,217,132,218,108,219,108,220,83,221,83,222,68,223,68,224,66,225,66,226,69,227,69,228,73,229,73,230,80,231,80,232,86,233,86,234,102,235,102,236,143,237,143,238,185,239,185,240,252,241,252,242,306,243,306,244,327,245,327,246,350,247,350,248,333,249,333,250,297,251,297,252,260,253,260,254,220,255,220,},[68]={0,530,1,530,2,1017,3,1017,4,914,5,914,6,399,7,399,8,143,9,143,10,91,11,91,12,44,13,44,172,22,173,22,174,45,175,45,176,76,177,76,178,139,179,139,180,242,181,242,182,382,183,382,184,505,185,505,186,565,187,565,188,549,189,549,190,463,191,463,192,483,193,483,194,550,195,550,196,390,197,390,198,170,199,170,200,156,201,156,202,169,203,169,204,177,205,177,206,184,207,184,208,202,209,202,210,210,211,210,212,199,213,199,214,170,215,170,216,139,217,139,218,116,219,116,220,272,221,272,222,258,223,258,224,79,225,79,226,86,227,86,228,92,229,92,230,96,231,96,232,98,233,98,234,100,235,100,236,120,237,120,238,149,239,149,240,204,241,204,242,260,243,260,244,292,245,292,246,320,247,320,248,314,249,314,250,288,251,288,252,266,253,266,254,246,255,246,},[69]={0,530,1,530,2,1017,3,1017,4,914,5,914,6,399,7,399,8,143,9,143,10,91,11,91,12,44,13,44,172,22,173,22,174,45,175,45,176,76,177,76,178,139,179,139,180,242,181,242,182,382,183,382,184,505,185,505,186,565,187,565,188,549,189,549,190,463,191,463,192,483,193,483,194,550,195,550,196,390,197,390,198,170,199,170,200,156,201,156,202,169,203,169,204,177,205,177,206,184,207,184,208,202,209,202,210,210,211,210,212,199,213,199,214,170,215,170,216,139,217,139,218,116,219,116,220,272,221,272,222,258,223,258,224,79,225,79,226,86,227,86,228,92,229,92,230,96,231,96,232,98,233,98,234,100,235,100,236,120,237,120,238,149,239,149,240,204,241,204,242,260,243,260,244,292,245,292,246,320,247,320,248,314,249,314,250,288,251,288,252,266,253,266,254,246,255,246,},[70]={0,268,1,268,2,742,3,742,4,1024,5,1024,6,1024,7,1024,8,160,9,160,10,110,11,110,12,55,13,55,174,34,175,34,176,76,177,76,178,152,179,152,180,262,181,262,182,403,183,403,184,513,185,513,186,557,187,557,188,527,189,527,190,428,191,428,192,307,193,307,194,263,195,263,196,221,197,221,198,152,199,152,200,156,201,156,202,182,203,182,204,203,205,203,206,220,207,220,208,241,209,241,210,239,211,239,212,223,213,223,214,205,215,205,216,362,217,362,218,923,219,923,220,1024,221,1024,222,966,223,966,224,518,225,518,226,127,227,127,228,132,229,132,230,131,231,131,232,122,233,122,234,110,235,110,236,114,237,114,238,127,239,127,240,169,241,169,242,223,243,223,244,255,245,255,246,282,247,282,248,282,249,282,250,273,251,273,252,278,253,278,254,281,255,281,},[71]={0,268,1,268,2,742,3,742,4,1024,5,1024,6,1024,7,1024,8,160,9,160,10,110,11,110,12,55,13,55,174,34,175,34,176,76,177,76,178,152,179,152,180,262,181,262,182,403,183,403,184,513,185,513,186,557,187,557,188,527,189,527,190,428,191,428,192,307,193,307,194,263,195,263,196,221,197,221,198,152,199,152,200,156,201,156,202,182,203,182,204,203,205,203,206,220,207,220,208,241,209,241,210,239,211,239,212,223,213,223,214,205,215,205,216,362,217,362,218,923,219,923,220,1024,221,1024,222,966,223,966,224,518,225,518,226,127,227,127,228,132,229,132,230,131,231,131,232,122,233,122,234,110,235,110,236,114,237,114,238,127,239,127,240,169,241,169,242,223,243,223,244,255,245,255,246,282,247,282,248,282,249,282,250,273,251,273,252,278,253,278,254,281,255,281,},[72]={0,330,1,330,2,664,3,664,4,1024,5,1024,6,1024,7,1024,8,241,9,241,10,144,11,144,12,76,13,76,174,31,175,31,176,92,177,92,178,176,179,176,180,287,181,287,182,413,183,413,184,491,185,491,186,518,187,518,188,479,189,479,190,381,191,381,192,268,193,268,194,194,195,194,196,164,197,164,198,156,199,156,200,171,201,171,202,200,203,200,204,221,205,221,206,240,207,240,208,258,209,258,210,248,211,248,212,464,213,464,214,1024,215,1024,216,1024,217,1024,218,1024,219,1024,220,1024,221,1024,222,1024,223,1024,224,1024,225,1024,226,481,227,481,228,173,229,173,230,165,231,165,232,146,233,146,234,126,235,126,236,117,237,117,238,124,239,124,240,163,241,163,242,216,243,216,244,248,245,248,246,272,247,272,248,270,249,270,250,265,251,265,252,297,253,297,254,320,255,320,},[73]={0,330,1,330,2,664,3,664,4,1024,5,1024,6,1024,7,1024,8,241,9,241,10,144,11,144,12,76,13,76,174,31,175,31,176,92,177,92,178,176,179,176,180,287,181,287,182,413,183,413,184,491,185,491,186,518,187,518,188,479,189,479,190,381,191,381,192,268,193,268,194,194,195,194,196,164,197,164,198,156,199,156,200,171,201,171,202,200,203,200,204,221,205,221,206,240,207,240,208,258,209,258,210,248,211,248,212,464,213,464,214,1024,215,1024,216,1024,217,1024,218,1024,219,1024,220,1024,221,1024,222,1024,223,1024,224,1024,225,1024,226,481,227,481,228,173,229,173,230,165,231,165,232,146,233,146,234,126,235,126,236,117,237,117,238,124,239,124,240,163,241,163,242,216,243,216,244,248,245,248,246,272,247,272,248,270,249,270,250,265,251,265,252,297,253,297,254,320,255,320,},[74]={0,365,1,365,2,623,3,623,4,1024,5,1024,6,1024,7,1024,8,685,9,685,10,181,11,181,12,99,13,99,174,30,175,30,176,102,177,102,178,184,179,184,180,296,181,296,182,408,183,408,184,457,185,457,186,476,187,476,188,426,189,426,190,331,191,331,192,236,193,236,194,178,195,178,196,169,197,169,198,178,199,178,200,196,201,196,202,217,203,217,204,271,205,271,206,1024,207,1024,208,1024,209,1024,210,918,211,918,212,945,213,945,214,1024,215,1024,216,1024,217,1024,218,529,219,529,220,547,221,547,222,1024,223,1024,224,1024,225,1024,226,1024,227,1024,228,336,229,336,230,187,231,187,232,160,233,160,234,140,235,140,236,129,237,129,238,137,239,137,240,182,241,182,242,238,243,238,244,271,245,271,246,292,247,292,248,280,249,280,250,264,251,264,252,304,253,304,254,343,255,343,},[75]={0,365,1,365,2,623,3,623,4,1024,5,1024,6,1024,7,1024,8,685,9,685,10,181,11,181,12,99,13,99,174,30,175,30,176,102,177,102,178,184,179,184,180,296,181,296,182,408,183,408,184,457,185,457,186,476,187,476,188,426,189,426,190,331,191,331,192,236,193,236,194,178,195,178,196,169,197,169,198,178,199,178,200,196,201,196,202,217,203,217,204,271,205,271,206,1024,207,1024,208,1024,209,1024,210,918,211,918,212,945,213,945,214,1024,215,1024,216,1024,217,1024,218,529,219,529,220,547,221,547,222,1024,223,1024,224,1024,225,1024,226,1024,227,1024,228,336,229,336,230,187,231,187,232,160,233,160,234,140,235,140,236,129,237,129,238,137,239,137,240,182,241,182,242,238,243,238,244,271,245,271,246,292,247,292,248,280,249,280,250,264,251,264,252,304,253,304,254,343,255,343,},[76]={0,385,1,385,2,520,3,520,4,1023,5,1023,6,1024,7,1024,8,1024,9,1024,10,203,11,203,12,117,13,117,14,42,15,42,174,29,175,29,176,104,177,104,178,180,179,180,180,297,181,297,182,398,183,398,184,427,185,427,186,437,187,437,188,367,189,367,190,271,191,271,192,196,193,196,194,164,195,164,196,178,197,178,198,202,199,202,200,224,201,224,202,233,203,233,204,270,205,270,206,1024,207,1024,208,1024,209,1024,210,856,211,856,212,758,213,758,214,566,215,566,216,389,217,389,218,235,219,235,220,211,221,211,222,493,223,493,224,1024,225,1024,226,1024,227,1024,228,1024,229,1024,230,567,231,567,232,174,233,174,234,151,235,151,236,141,237,141,238,152,239,152,240,206,241,206,242,269,243,269,244,308,245,308,246,329,247,329,248,303,249,303,250,272,251,272,252,309,253,309,254,349,255,349,},[77]={0,385,1,385,2,520,3,520,4,1023,5,1023,6,1024,7,1024,8,1024,9,1024,10,203,11,203,12,117,13,117,14,42,15,42,174,29,175,29,176,104,177,104,178,180,179,180,180,297,181,297,182,398,183,398,184,427,185,427,186,437,187,437,188,367,189,367,190,271,191,271,192,196,193,196,194,164,195,164,196,178,197,178,198,202,199,202,200,224,201,224,202,233,203,233,204,270,205,270,206,1024,207,1024,208,1024,209,1024,210,856,211,856,212,758,213,758,214,566,215,566,216,389,217,389,218,235,219,235,220,211,221,211,222,493,223,493,224,1024,225,1024,226,1024,227,1024,228,1024,229,1024,230,567,231,567,232,174,233,174,234,151,235,151,236,141,237,141,238,152,239,152,240,206,241,206,242,269,243,269,244,308,245,308,246,329,247,329,248,303,249,303,250,272,251,272,252,309,253,309,254,349,255,349,},[78]={0,372,1,372,2,440,3,440,4,1024,5,1024,6,1024,7,1024,8,1024,9,1024,10,607,11,607,12,123,13,123,14,55,15,55,172,405,173,405,174,428,175,428,176,97,177,97,178,177,179,177,180,294,181,294,182,383,183,383,184,398,185,398,186,390,187,390,188,309,189,309,190,224,191,224,192,167,193,167,194,160,195,160,196,194,197,194,198,225,199,225,200,252,201,252,202,255,203,255,204,233,205,233,206,223,207,223,208,212,209,212,210,210,211,210,212,238,213,238,214,264,215,264,216,268,217,268,218,250,219,250,220,231,221,231,222,194,223,194,224,294,225,294,226,1024,227,1024,228,1024,229,1024,230,1024,231,1024,232,1024,233,1024,234,1024,235,1024,236,734,237,734,238,160,239,160,240,215,241,215,242,281,243,281,244,326,245,326,246,348,247,348,248,317,249,317,250,274,251,274,252,301,253,301,254,341,255,341,},[79]={0,372,1,372,2,440,3,440,4,1024,5,1024,6,1024,7,1024,8,1024,9,1024,10,607,11,607,12,123,13,123,14,55,15,55,172,405,173,405,174,428,175,428,176,97,177,97,178,177,179,177,180,294,181,294,182,383,183,383,184,398,185,398,186,390,187,390,188,309,189,309,190,224,191,224,192,167,193,167,194,160,195,160,196,194,197,194,198,225,199,225,200,252,201,252,202,255,203,255,204,233,205,233,206,223,207,223,208,212,209,212,210,210,211,210,212,238,213,238,214,264,215,264,216,268,217,268,218,250,219,250,220,231,221,231,222,194,223,194,224,294,225,294,226,1024,227,1024,228,1024,229,1024,230,1024,231,1024,232,1024,233,1024,234,1024,235,1024,236,734,237,734,238,160,239,160,240,215,241,215,242,281,243,281,244,326,245,326,246,348,247,348,248,317,249,317,250,274,251,274,252,301,253,301,254,341,255,341,},[80]={0,350,1,350,2,383,3,383,4,1024,5,1024,6,1024,7,1024,8,1024,9,1024,10,1024,11,1024,12,482,13,482,14,61,15,61,170,630,171,630,172,1024,173,1024,174,1024,175,1024,176,1024,177,1024,178,1024,179,1024,180,338,181,338,182,409,183,409,184,361,185,361,186,333,187,333,188,253,189,253,190,199,191,199,192,173,193,173,194,184,195,184,196,229,197,229,198,256,199,256,200,278,201,278,202,276,203,276,204,255,205,255,206,244,207,244,208,222,209,222,210,234,211,234,212,272,213,272,214,294,215,294,216,297,217,297,218,284,219,284,220,273,221,273,222,227,223,227,224,229,225,229,226,1024,227,1024,228,1024,229,1024,230,1024,231,1024,232,1024,233,1024,234,1024,235,1024,236,1024,237,1024,238,808,239,808,240,352,241,352,242,293,243,293,244,341,245,341,246,354,247,354,248,319,249,319,250,275,251,275,252,283,253,283,254,314,255,314,},[81]={0,350,1,350,2,383,3,383,4,1024,5,1024,6,1024,7,1024,8,1024,9,1024,10,1024,11,1024,12,482,13,482,14,61,15,61,170,630,171,630,172,1024,173,1024,174,1024,175,1024,176,1024,177,1024,178,1024,179,1024,180,338,181,338,182,409,183,409,184,361,185,361,186,333,187,333,188,253,189,253,190,199,191,199,192,173,193,173,194,184,195,184,196,229,197,229,198,256,199,256,200,278,201,278,202,276,203,276,204,255,205,255,206,244,207,244,208,222,209,222,210,234,211,234,212,272,213,272,214,294,215,294,216,297,217,297,218,284,219,284,220,273,221,273,222,227,223,227,224,229,225,229,226,1024,227,1024,228,1024,229,1024,230,1024,231,1024,232,1024,233,1024,234,1024,235,1024,236,1024,237,1024,238,808,239,808,240,352,241,352,242,293,243,293,244,341,245,341,246,354,247,354,248,319,249,319,250,275,251,275,252,283,253,283,254,314,255,314,},[82]={0,326,1,326,2,381,3,381,4,1024,5,1024,6,1024,7,1024,8,1024,9,1024,10,1024,11,1024,12,1024,13,1024,14,1024,15,1024,16,1013,17,1013,170,630,171,630,172,1024,173,1024,174,1024,175,1024,176,1024,177,1024,178,1024,179,1024,180,1024,181,1024,182,1024,183,1024,184,429,185,429,186,287,187,287,188,224,189,224,190,290,191,290,192,291,193,291,194,228,195,228,196,269,197,269,198,279,199,279,200,294,201,294,202,294,203,294,204,282,205,282,206,280,207,280,208,257,209,257,210,271,211,271,212,309,213,309,214,327,215,327,216,329,217,329,218,324,219,324,220,315,221,315,222,259,223,259,224,249,225,249,226,852,227,852,228,1024,229,1024,230,1024,231,1024,232,1024,233,1024,234,1007,235,1007,236,1024,237,1024,238,837,239,837,240,384,241,384,242,312,243,312,244,358,245,358,246,360,247,360,248,325,249,325,250,277,251,277,252,266,253,266,254,292,255,292,},[83]={0,326,1,326,2,381,3,381,4,1024,5,1024,6,1024,7,1024,8,1024,9,1024,10,1024,11,1024,12,1024,13,1024,14,1024,15,1024,16,1013,17,1013,170,630,171,630,172,1024,173,1024,174,1024,175,1024,176,1024,177,1024,178,1024,179,1024,180,1024,181,1024,182,1024,183,1024,184,429,185,429,186,287,187,287,188,224,189,224,190,290,191,290,192,291,193,291,194,228,195,228,196,269,197,269,198,279,199,279,200,294,201,294,202,294,203,294,204,282,205,282,206,280,207,280,208,257,209,257,210,271,211,271,212,309,213,309,214,327,215,327,216,329,217,329,218,324,219,324,220,315,221,315,222,259,223,259,224,249,225,249,226,852,227,852,228,1024,229,1024,230,1024,231,1024,232,1024,233,1024,234,1007,235,1007,236,1024,237,1024,238,837,239,837,240,384,241,384,242,312,243,312,244,358,245,358,246,360,247,360,248,325,249,325,250,277,251,277,252,266,253,266,254,292,255,292,},[84]={0,316,1,316,2,389,3,389,4,1024,5,1024,6,1024,7,1024,8,1024,9,1024,10,1024,11,1024,12,1024,13,1024,14,1024,15,1024,16,1024,17,1024,18,17,19,17,170,1,171,1,172,1,173,1,174,36,175,36,176,643,177,643,178,1024,179,1024,180,1024,181,1024,182,1024,183,1024,184,1024,185,1024,186,1024,187,1024,188,1024,189,1024,190,529,191,529,192,326,193,326,194,265,195,265,196,290,197,290,198,277,199,277,200,285,201,285,202,291,203,291,204,290,205,290,206,300,207,300,208,284,209,284,210,297,211,297,212,330,213,330,214,344,215,344,216,344,217,344,218,343,219,343,220,333,221,333,222,272,223,272,224,257,225,257,226,628,227,628,228,1024,229,1024,230,1024,231,1024,232,1024,233,1024,234,1024,235,1024,236,621,237,621,238,235,239,235,240,274,241,274,242,339,243,339,244,377,245,377,246,374,247,374,248,345,249,345,250,295,251,295,252,266,253,266,254,281,255,281,},[85]={0,316,1,316,2,389,3,389,4,1024,5,1024,6,1024,7,1024,8,1024,9,1024,10,1024,11,1024,12,1024,13,1024,14,1024,15,1024,16,1024,17,1024,18,17,19,17,170,1,171,1,172,1,173,1,174,36,175,36,176,643,177,643,178,1024,179,1024,180,1024,181,1024,182,1024,183,1024,184,1024,185,1024,186,1024,187,1024,188,1024,189,1024,190,529,191,529,192,326,193,326,194,265,195,265,196,290,197,290,198,277,199,277,200,285,201,285,202,291,203,291,204,290,205,290,206,300,207,300,208,284,209,284,210,297,211,297,212,330,213,330,214,344,215,344,216,344,217,344,218,343,219,343,220,333,221,333,222,272,223,272,224,257,225,257,226,628,227,628,228,1024,229,1024,230,1024,231,1024,232,1024,233,1024,234,1024,235,1024,236,621,237,621,238,235,239,235,240,274,241,274,242,339,243,339,244,377,245,377,246,374,247,374,248,345,249,345,250,295,251,295,252,266,253,266,254,281,255,281,},[86]={0,309,1,309,2,395,3,395,4,1024,5,1024,6,1024,7,1024,8,287,9,287,10,169,11,169,12,106,13,106,14,73,15,73,16,51,17,51,18,35,19,35,20,24,21,24,22,13,23,13,170,1,171,1,172,1,173,1,174,79,175,79,176,208,177,208,178,308,179,308,180,992,181,992,182,1024,183,1024,184,1024,185,1024,186,1024,187,1024,188,1024,189,1024,190,471,191,471,192,269,193,269,194,281,195,281,196,280,197,280,198,258,199,258,200,264,201,264,202,272,203,272,204,279,205,279,206,293,207,293,208,277,209,277,210,286,211,286,212,318,213,318,214,330,215,330,216,333,217,333,218,337,219,337,220,327,221,327,222,276,223,276,224,260,225,260,226,312,227,312,228,403,229,403,230,363,231,363,232,518,233,518,234,499,235,499,236,242,237,242,238,267,239,267,240,304,241,304,242,368,243,368,244,399,245,399,246,392,247,392,248,367,249,367,250,313,251,313,252,269,253,269,254,277,255,277,},[87]={0,309,1,309,2,395,3,395,4,1024,5,1024,6,1024,7,1024,8,287,9,287,10,169,11,169,12,106,13,106,14,73,15,73,16,51,17,51,18,35,19,35,20,24,21,24,22,13,23,13,170,1,171,1,172,1,173,1,174,79,175,79,176,208,177,208,178,308,179,308,180,992,181,992,182,1024,183,1024,184,1024,185,1024,186,1024,187,1024,188,1024,189,1024,190,471,191,471,192,269,193,269,194,281,195,281,196,280,197,280,198,258,199,258,200,264,201,264,202,272,203,272,204,279,205,279,206,293,207,293,208,277,209,277,210,286,211,286,212,318,213,318,214,330,215,330,216,333,217,333,218,337,219,337,220,327,221,327,222,276,223,276,224,260,225,260,226,312,227,312,228,403,229,403,230,363,231,363,232,518,233,518,234,499,235,499,236,242,237,242,238,267,239,267,240,304,241,304,242,368,243,368,244,399,245,399,246,392,247,392,248,367,249,367,250,313,251,313,252,269,253,269,254,277,255,277,},[88]={0,313,1,313,2,401,3,401,4,484,5,484,6,464,7,464,8,299,9,299,10,177,11,177,12,114,13,114,14,87,15,87,16,69,17,69,18,53,19,53,20,44,21,44,22,31,23,31,170,19,171,19,172,56,173,56,174,145,175,145,176,275,177,275,178,358,179,358,180,383,181,383,182,349,183,349,184,273,185,273,186,248,187,248,188,262,189,262,190,285,191,285,192,292,193,292,194,273,195,273,196,248,197,248,198,225,199,225,200,234,201,234,202,247,203,247,204,255,205,255,206,264,207,264,208,247,209,247,210,249,211,249,212,280,213,280,214,391,215,391,216,450,217,450,218,383,219,383,220,345,221,345,222,311,223,311,224,294,225,294,226,284,227,284,228,271,229,271,230,268,231,268,232,255,233,255,234,250,235,250,236,271,237,271,238,290,239,290,240,319,241,319,242,372,243,372,244,394,245,394,246,396,247,396,248,383,249,383,250,333,251,333,252,284,253,284,254,285,255,285,},[89]={0,313,1,313,2,401,3,401,4,484,5,484,6,464,7,464,8,299,9,299,10,177,11,177,12,114,13,114,14,87,15,87,16,69,17,69,18,53,19,53,20,44,21,44,22,31,23,31,170,19,171,19,172,56,173,56,174,145,175,145,176,275,177,275,178,358,179,358,180,383,181,383,182,349,183,349,184,273,185,273,186,248,187,248,188,262,189,262,190,285,191,285,192,292,193,292,194,273,195,273,196,248,197,248,198,225,199,225,200,234,201,234,202,247,203,247,204,255,205,255,206,264,207,264,208,247,209,247,210,249,211,249,212,280,213,280,214,391,215,391,216,450,217,450,218,383,219,383,220,345,221,345,222,311,223,311,224,294,225,294,226,284,227,284,228,271,229,271,230,268,231,268,232,255,233,255,234,250,235,250,236,271,237,271,238,290,239,290,240,319,241,319,242,372,243,372,244,394,245,394,246,396,247,396,248,383,249,383,250,333,251,333,252,284,253,284,254,285,255,285,},[90]={0,329,1,329,2,413,3,413,4,454,5,454,6,431,7,431,8,309,9,309,10,192,11,192,12,130,13,130,14,107,15,107,16,93,17,93,18,75,19,75,20,70,21,70,22,57,23,57,24,36,25,36,26,27,27,27,28,16,29,16,164,10,165,10,166,19,167,19,168,44,169,44,170,80,171,80,172,140,173,140,174,236,175,236,176,345,177,345,178,397,179,397,180,398,181,398,182,343,183,343,184,270,185,270,186,275,187,275,188,305,189,305,190,321,191,321,192,305,193,305,194,255,195,255,196,216,197,216,198,199,199,199,200,211,201,211,202,230,203,230,204,234,205,234,206,231,207,231,208,210,209,210,210,214,211,214,212,431,213,431,214,691,215,691,216,584,217,584,218,400,219,400,220,383,221,383,222,365,223,365,224,347,225,347,226,320,227,320,228,288,229,288,230,278,231,278,232,272,233,272,234,274,235,274,236,295,237,295,238,297,239,297,240,310,241,310,242,347,243,347,244,357,245,357,246,373,247,373,248,373,249,373,250,336,251,336,252,299,253,299,254,304,255,304,},[91]={0,329,1,329,2,413,3,413,4,454,5,454,6,431,7,431,8,309,9,309,10,192,11,192,12,130,13,130,14,107,15,107,16,93,17,93,18,75,19,75,20,70,21,70,22,57,23,57,24,36,25,36,26,27,27,27,28,16,29,16,164,10,165,10,166,19,167,19,168,44,169,44,170,80,171,80,172,140,173,140,174,236,175,236,176,345,177,345,178,397,179,397,180,398,181,398,182,343,183,343,184,270,185,270,186,275,187,275,188,305,189,305,190,321,191,321,192,305,193,305,194,255,195,255,196,216,197,216,198,199,199,199,200,211,201,211,202,230,203,230,204,234,205,234,206,231,207,231,208,210,209,210,210,214,211,214,212,431,213,431,214,691,215,691,216,584,217,584,218,400,219,400,220,383,221,383,222,365,223,365,224,347,225,347,226,320,227,320,228,288,229,288,230,278,231,278,232,272,233,272,234,274,235,274,236,295,237,295,238,297,239,297,240,310,241,310,242,347,243,347,244,357,245,357,246,373,247,373,248,373,249,373,250,336,251,336,252,299,253,299,254,304,255,304,},[92]={0,345,1,345,2,419,3,419,4,458,5,458,6,429,7,429,8,319,9,319,10,214,11,214,12,151,13,151,14,129,15,129,16,117,17,117,18,96,19,96,20,96,21,96,22,83,23,83,24,59,25,59,26,48,27,48,28,30,29,30,160,34,161,34,162,39,163,39,164,33,165,33,166,67,167,67,168,138,169,138,170,206,171,206,172,279,173,279,174,351,175,351,176,409,177,409,178,425,179,425,180,409,181,409,182,344,183,344,184,283,185,283,186,310,187,310,188,348,189,348,190,352,191,352,192,318,193,318,194,245,195,245,196,201,197,201,198,203,199,203,200,221,201,221,202,238,203,238,204,239,205,239,206,218,207,218,208,192,209,192,210,512,211,512,212,1024,213,1024,214,1024,215,1024,216,1024,217,1024,218,365,219,365,220,407,221,407,222,408,223,408,224,391,225,391,226,354,227,354,228,315,229,315,230,299,231,299,232,298,233,298,234,296,235,296,236,305,237,305,238,297,239,297,240,292,241,292,242,310,243,310,244,318,245,318,246,341,247,341,248,344,249,344,250,320,251,320,252,302,253,302,254,314,255,314,},[93]={0,345,1,345,2,419,3,419,4,458,5,458,6,429,7,429,8,319,9,319,10,214,11,214,12,151,13,151,14,129,15,129,16,117,17,117,18,96,19,96,20,96,21,96,22,83,23,83,24,59,25,59,26,48,27,48,28,30,29,30,160,34,161,34,162,39,163,39,164,33,165,33,166,67,167,67,168,138,169,138,170,206,171,206,172,279,173,279,174,351,175,351,176,409,177,409,178,425,179,425,180,409,181,409,182,344,183,344,184,283,185,283,186,310,187,310,188,348,189,348,190,352,191,352,192,318,193,318,194,245,195,245,196,201,197,201,198,203,199,203,200,221,201,221,202,238,203,238,204,239,205,239,206,218,207,218,208,192,209,192,210,512,211,512,212,1024,213,1024,214,1024,215,1024,216,1024,217,1024,218,365,219,365,220,407,221,407,222,408,223,408,224,391,225,391,226,354,227,354,228,315,229,315,230,299,231,299,232,298,233,298,234,296,235,296,236,305,237,305,238,297,239,297,240,292,241,292,242,310,243,310,244,318,245,318,246,341,247,341,248,344,249,344,250,320,251,320,252,302,253,302,254,314,255,314,},[94]={0,351,1,351,2,416,3,416,4,451,5,451,6,420,7,420,8,327,9,327,10,238,11,238,12,175,13,175,14,156,15,156,16,142,17,142,18,119,19,119,20,119,21,119,22,103,23,103,24,78,25,78,26,66,27,66,28,42,29,42,30,17,31,17,32,1024,33,1024,34,1024,35,1024,156,40,157,40,158,67,159,67,160,72,161,72,162,72,163,72,164,63,165,63,166,133,167,133,168,252,169,252,170,351,171,351,172,424,173,424,174,446,175,446,176,447,177,447,178,433,179,433,180,411,181,411,182,349,183,349,184,297,185,297,186,326,187,326,188,445,189,445,190,665,191,665,192,1024,193,1024,194,1024,195,1024,196,608,197,608,198,395,199,395,200,227,201,227,202,239,203,239,204,237,205,237,206,300,207,300,208,503,209,503,210,1024,211,1024,212,1024,213,1024,214,1024,215,1024,216,1024,217,1024,218,1024,219,1024,220,432,221,432,222,458,223,458,224,453,225,453,226,414,227,414,228,360,229,360,230,331,231,331,232,320,233,320,234,307,235,307,236,304,237,304,238,285,239,285,240,273,241,273,242,279,243,279,244,287,245,287,246,310,247,310,248,308,249,308,250,296,251,296,252,298,253,298,254,315,255,315,},[95]={0,351,1,351,2,416,3,416,4,451,5,451,6,420,7,420,8,327,9,327,10,238,11,238,12,175,13,175,14,156,15,156,16,142,17,142,18,119,19,119,20,119,21,119,22,103,23,103,24,78,25,78,26,66,27,66,28,42,29,42,30,17,31,17,32,1024,33,1024,34,1024,35,1024,156,40,157,40,158,67,159,67,160,72,161,72,162,72,163,72,164,63,165,63,166,133,167,133,168,252,169,252,170,351,171,351,172,424,173,424,174,446,175,446,176,447,177,447,178,433,179,433,180,411,181,411,182,349,183,349,184,297,185,297,186,326,187,326,188,445,189,445,190,665,191,665,192,1024,193,1024,194,1024,195,1024,196,608,197,608,198,395,199,395,200,227,201,227,202,239,203,239,204,237,205,237,206,300,207,300,208,503,209,503,210,1024,211,1024,212,1024,213,1024,214,1024,215,1024,216,1024,217,1024,218,1024,219,1024,220,432,221,432,222,458,223,458,224,453,225,453,226,414,227,414,228,360,229,360,230,331,231,331,232,320,233,320,234,307,235,307,236,304,237,304,238,285,239,285,240,273,241,273,242,279,243,279,244,287,245,287,246,310,247,310,248,308,249,308,250,296,251,296,252,298,253,298,254,315,255,315,},[96]={0,334,1,334,2,400,3,400,4,433,5,433,6,403,7,403,8,330,9,330,10,252,11,252,12,192,13,192,14,174,15,174,16,161,17,161,18,139,19,139,20,135,21,135,22,116,23,116,24,90,25,90,26,75,27,75,28,52,29,52,30,839,31,839,32,1024,33,1024,34,1024,35,1024,36,1024,37,1024,154,51,155,51,156,91,157,91,158,114,159,114,160,109,161,109,162,96,163,96,164,86,165,86,166,186,167,186,168,336,169,336,170,454,171,454,172,521,173,521,174,502,175,502,176,460,177,460,178,425,179,425,180,407,181,407,182,355,183,355,184,311,185,311,186,331,187,331,188,653,189,653,190,1024,191,1024,192,1024,193,1024,194,1024,195,1024,196,969,197,969,198,394,199,394,200,220,201,220,202,273,203,273,204,542,205,542,206,972,207,972,208,1024,209,1024,210,1024,211,1024,212,1024,213,1024,214,1024,215,1024,216,1024,217,1024,218,1024,219,1024,220,433,221,433,222,487,223,487,224,499,225,499,226,466,227,466,228,404,229,404,230,355,231,355,232,326,233,326,234,303,235,303,236,294,237,294,238,271,239,271,240,256,241,256,242,257,243,257,244,262,245,262,246,274,247,274,248,261,249,261,250,257,251,257,252,274,253,274,254,300,255,300,},[97]={0,334,1,334,2,400,3,400,4,433,5,433,6,403,7,403,8,330,9,330,10,252,11,252,12,192,13,192,14,174,15,174,16,161,17,161,18,139,19,139,20,135,21,135,22,116,23,116,24,90,25,90,26,75,27,75,28,52,29,52,30,839,31,839,32,1024,33,1024,34,1024,35,1024,36,1024,37,1024,154,51,155,51,156,91,157,91,158,114,159,114,160,109,161,109,162,96,163,96,164,86,165,86,166,186,167,186,168,336,169,336,170,454,171,454,172,521,173,521,174,502,175,502,176,460,177,460,178,425,179,425,180,407,181,407,182,355,183,355,184,311,185,311,186,331,187,331,188,653,189,653,190,1024,191,1024,192,1024,193,1024,194,1024,195,1024,196,969,197,969,198,394,199,394,200,220,201,220,202,273,203,273,204,542,205,542,206,972,207,972,208,1024,209,1024,210,1024,211,1024,212,1024,213,1024,214,1024,215,1024,216,1024,217,1024,218,1024,219,1024,220,433,221,433,222,487,223,487,224,499,225,499,226,466,227,466,228,404,229,404,230,355,231,355,232,326,233,326,234,303,235,303,236,294,237,294,238,271,239,271,240,256,241,256,242,257,243,257,244,262,245,262,246,274,247,274,248,261,249,261,250,257,251,257,252,274,253,274,254,300,255,300,},[98]={0,315,1,315,2,380,3,380,4,410,5,410,6,386,7,386,8,329,9,329,10,263,11,263,12,211,13,211,14,191,15,191,16,172,17,172,18,148,19,148,20,137,21,137,22,116,23,116,24,93,25,93,26,213,27,213,28,1024,29,1024,30,1024,31,1024,32,1024,33,1024,34,1024,35,1024,36,1024,37,1024,150,27,151,27,152,56,153,56,154,92,155,92,156,133,157,133,158,144,159,144,160,132,161,132,162,109,163,109,164,100,165,100,166,205,167,205,168,355,169,355,170,493,171,493,172,579,173,579,174,555,175,555,176,500,177,500,178,444,179,444,180,404,181,404,182,353,183,353,184,314,185,314,186,316,187,316,188,570,189,570,190,1024,191,1024,192,1024,193,1024,194,1024,195,1024,196,1024,197,1024,198,963,199,963,200,883,201,883,202,1024,203,1024,204,1024,205,1024,206,1024,207,1024,208,1024,209,1024,210,1024,211,1024,212,1024,213,1024,214,384,215,384,216,268,217,268,218,321,219,321,220,411,221,411,222,485,223,485,224,506,225,506,226,484,227,484,228,919,229,919,230,991,231,991,232,455,233,455,234,290,235,290,236,282,237,282,238,265,239,265,240,251,241,251,242,248,243,248,244,247,245,247,246,242,247,242,248,219,249,219,250,371,251,371,252,395,253,395,254,273,255,273,},[99]={0,315,1,315,2,380,3,380,4,410,5,410,6,386,7,386,8,329,9,329,10,263,11,263,12,211,13,211,14,191,15,191,16,172,17,172,18,148,19,148,20,137,21,137,22,116,23,116,24,93,25,93,26,213,27,213,28,1024,29,1024,30,1024,31,1024,32,1024,33,1024,34,1024,35,1024,36,1024,37,1024,150,27,151,27,152,56,153,56,154,92,155,92,156,133,157,133,158,144,159,144,160,132,161,132,162,109,163,109,164,100,165,100,166,205,167,205,168,355,169,355,170,493,171,493,172,579,173,579,174,555,175,555,176,500,177,500,178,444,179,444,180,404,181,404,182,353,183,353,184,314,185,314,186,316,187,316,188,570,189,570,190,1024,191,1024,192,1024,193,1024,194,1024,195,1024,196,1024,197,1024,198,963,199,963,200,883,201,883,202,1024,203,1024,204,1024,205,1024,206,1024,207,1024,208,1024,209,1024,210,1024,211,1024,212,1024,213,1024,214,384,215,384,216,268,217,268,218,321,219,321,220,411,221,411,222,485,223,485,224,506,225,506,226,484,227,484,228,919,229,919,230,991,231,991,232,455,233,455,234,290,235,290,236,282,237,282,238,265,239,265,240,251,241,251,242,248,243,248,244,247,245,247,246,242,247,242,248,219,249,219,250,371,251,371,252,395,253,395,254,273,255,273,},[100]={0,293,1,293,2,368,3,368,4,389,5,389,6,372,7,372,8,323,9,323,10,259,11,259,12,222,13,222,14,198,15,198,16,171,17,171,18,144,19,144,20,125,21,125,22,781,23,781,24,1024,25,1024,26,1024,27,1024,28,1024,29,1024,30,1024,31,1024,32,903,33,903,34,35,35,35,36,22,37,22,38,11,39,11,150,39,151,39,152,73,153,73,154,114,155,114,156,143,157,143,158,147,159,147,160,134,161,134,162,109,163,109,164,103,165,103,166,186,167,186,168,302,169,302,170,457,171,457,172,583,173,583,174,588,175,588,176,558,177,558,178,481,179,481,180,406,181,406,182,354,183,354,184,317,185,317,186,298,187,298,188,303,189,303,190,672,191,672,192,1024,193,1024,194,1024,195,1024,196,1024,197,1024,198,1024,199,1024,200,1024,201,1024,202,1024,203,1024,204,1024,205,1024,206,1024,207,1024,208,1024,209,1024,210,1024,211,1024,212,389,213,389,214,249,215,249,216,246,217,246,218,276,219,276,220,364,221,364,222,445,223,445,224,475,225,475,226,469,227,469,228,1024,229,1024,230,1024,231,1024,232,441,233,441,234,278,235,278,236,279,237,279,238,267,239,267,240,256,241,256,242,251,243,251,244,236,245,236,246,216,247,216,248,459,249,459,250,686,251,686,252,408,253,408,254,250,255,250,},[101]={0,293,1,293,2,368,3,368,4,389,5,389,6,372,7,372,8,323,9,323,10,259,11,259,12,222,13,222,14,198,15,198,16,171,17,171,18,144,19,144,20,125,21,125,22,781,23,781,24,1024,25,1024,26,1024,27,1024,28,1024,29,1024,30,1024,31,1024,32,903,33,903,34,35,35,35,36,22,37,22,38,11,39,11,150,39,151,39,152,73,153,73,154,114,155,114,156,143,157,143,158,147,159,147,160,134,161,134,162,109,163,109,164,103,165,103,166,186,167,186,168,302,169,302,170,457,171,457,172,583,173,583,174,588,175,588,176,558,177,558,178,481,179,481,180,406,181,406,182,354,183,354,184,317,185,317,186,298,187,298,188,303,189,303,190,672,191,672,192,1024,193,1024,194,1024,195,1024,196,1024,197,1024,198,1024,199,1024,200,1024,201,1024,202,1024,203,1024,204,1024,205,1024,206,1024,207,1024,208,1024,209,1024,210,1024,211,1024,212,389,213,389,214,249,215,249,216,246,217,246,218,276,219,276,220,364,221,364,222,445,223,445,224,475,225,475,226,469,227,469,228,1024,229,1024,230,1024,231,1024,232,441,233,441,234,278,235,278,236,279,237,279,238,267,239,267,240,256,241,256,242,251,243,251,244,236,245,236,246,216,247,216,248,459,249,459,250,686,251,686,252,408,253,408,254,250,255,250,},[102]={0,288,1,288,2,361,3,361,4,374,5,374,6,355,7,355,8,295,9,295,10,235,11,235,12,206,13,206,14,178,15,178,16,1024,17,1024,18,1024,19,1024,20,1024,21,1024,22,1024,23,1024,24,1024,25,1024,26,1024,27,1024,28,976,29,976,30,119,31,119,32,67,33,67,34,52,35,52,36,36,37,36,38,19,39,19,150,28,151,28,152,56,153,56,154,97,155,97,156,120,157,120,158,123,159,123,160,117,161,117,162,106,163,106,164,108,165,108,166,154,167,154,168,227,169,227,170,385,171,385,172,543,173,543,174,606,175,606,176,619,177,619,178,526,179,526,180,424,181,424,182,368,183,368,184,328,185,328,186,296,187,296,188,241,189,241,190,186,191,186,192,242,193,242,194,902,195,902,196,1024,197,1024,198,1024,199,1024,200,1024,201,1024,202,1024,203,1024,204,835,205,835,206,541,207,541,208,337,209,337,210,307,211,307,212,282,213,282,214,254,215,254,216,231,217,231,218,242,219,242,220,315,221,315,222,388,223,388,224,559,225,559,226,1024,227,1024,228,1024,229,1024,230,1024,231,1024,232,603,233,603,234,442,235,442,236,270,237,270,238,263,239,263,240,252,241,252,242,290,243,290,244,312,245,312,246,246,247,246,248,880,249,880,250,968,251,968,252,368,253,368,254,230,255,230,},[103]={0,288,1,288,2,361,3,361,4,374,5,374,6,355,7,355,8,295,9,295,10,235,11,235,12,206,13,206,14,178,15,178,16,1024,17,1024,18,1024,19,1024,20,1024,21,1024,22,1024,23,1024,24,1024,25,1024,26,1024,27,1024,28,976,29,976,30,119,31,119,32,67,33,67,34,52,35,52,36,36,37,36,38,19,39,19,150,28,151,28,152,56,153,56,154,97,155,97,156,120,157,120,158,123,159,123,160,117,161,117,162,106,163,106,164,108,165,108,166,154,167,154,168,227,169,227,170,385,171,385,172,543,173,543,174,606,175,606,176,619,177,619,178,526,179,526,180,424,181,424,182,368,183,368,184,328,185,328,186,296,187,296,188,241,189,241,190,186,191,186,192,242,193,242,194,902,195,902,196,1024,197,1024,198,1024,199,1024,200,1024,201,1024,202,1024,203,1024,204,835,205,835,206,541,207,541,208,337,209,337,210,307,211,307,212,282,213,282,214,254,215,254,216,231,217,231,218,242,219,242,220,315,221,315,222,388,223,388,224,559,225,559,226,1024,227,1024,228,1024,229,1024,230,1024,231,1024,232,603,233,603,234,442,235,442,236,270,237,270,238,263,239,263,240,252,241,252,242,290,243,290,244,312,245,312,246,246,247,246,248,880,249,880,250,968,251,968,252,368,253,368,254,230,255,230,},[104]={0,297,1,297,2,366,3,366,4,368,5,368,6,333,7,333,8,256,9,256,10,200,11,200,12,177,13,177,14,151,15,151,16,1024,17,1024,18,1024,19,1024,20,1024,21,1024,22,926,23,926,24,162,25,162,26,75,27,75,28,79,29,79,30,85,31,85,32,81,33,81,34,65,35,65,36,49,37,49,38,27,39,27,152,28,153,28,154,54,155,54,156,68,157,68,158,77,159,77,160,89,161,89,162,95,163,95,164,106,165,106,166,126,167,126,168,164,169,164,170,312,171,312,172,485,173,485,174,599,175,599,176,654,177,654,178,564,179,564,180,458,181,458,182,402,183,402,184,360,185,360,186,323,187,323,188,255,189,255,190,179,191,179,192,134,193,134,194,164,195,164,196,352,197,352,198,372,199,372,200,229,201,229,202,228,203,228,204,281,205,281,206,325,207,325,208,358,209,358,210,375,211,375,212,329,213,329,214,265,215,265,216,218,217,218,218,213,219,213,220,264,221,264,222,321,223,321,224,539,225,539,226,1024,227,1024,228,1024,229,1024,230,1024,231,1024,232,1024,233,1024,234,738,235,738,236,388,237,388,238,470,239,470,240,325,241,325,242,630,243,630,244,651,245,651,246,232,247,232,248,971,249,971,250,1024,251,1024,252,803,253,803,254,225,255,225,},[105]={0,297,1,297,2,366,3,366,4,368,5,368,6,333,7,333,8,256,9,256,10,200,11,200,12,177,13,177,14,151,15,151,16,1024,17,1024,18,1024,19,1024,20,1024,21,1024,22,926,23,926,24,162,25,162,26,75,27,75,28,79,29,79,30,85,31,85,32,81,33,81,34,65,35,65,36,49,37,49,38,27,39,27,152,28,153,28,154,54,155,54,156,68,157,68,158,77,159,77,160,89,161,89,162,95,163,95,164,106,165,106,166,126,167,126,168,164,169,164,170,312,171,312,172,485,173,485,174,599,175,599,176,654,177,654,178,564,179,564,180,458,181,458,182,402,183,402,184,360,185,360,186,323,187,323,188,255,189,255,190,179,191,179,192,134,193,134,194,164,195,164,196,352,197,352,198,372,199,372,200,229,201,229,202,228,203,228,204,281,205,281,206,325,207,325,208,358,209,358,210,375,211,375,212,329,213,329,214,265,215,265,216,218,217,218,218,213,219,213,220,264,221,264,222,321,223,321,224,539,225,539,226,1024,227,1024,228,1024,229,1024,230,1024,231,1024,232,1024,233,1024,234,738,235,738,236,388,237,388,238,470,239,470,240,325,241,325,242,630,243,630,244,651,245,651,246,232,247,232,248,971,249,971,250,1024,251,1024,252,803,253,803,254,225,255,225,},[106]={0,306,1,306,2,361,3,361,4,352,5,352,6,296,7,296,8,217,9,217,10,165,11,165,12,143,13,143,14,118,15,118,16,95,17,95,18,72,19,72,20,56,21,56,22,54,23,54,24,58,25,58,26,69,27,69,28,81,29,81,30,96,31,96,32,101,33,101,34,89,35,89,36,72,37,72,38,46,39,46,40,19,41,19,158,35,159,35,160,51,161,51,162,72,163,72,164,93,165,93,166,101,167,101,168,119,169,119,170,231,171,231,172,389,173,389,174,534,175,534,176,633,177,633,178,586,179,586,180,516,181,516,182,466,183,466,184,417,185,417,186,378,187,378,188,298,189,298,190,202,191,202,192,143,193,143,194,120,195,120,196,128,197,128,198,147,199,147,200,187,201,187,202,231,203,231,204,293,205,293,206,362,207,362,208,409,209,409,210,426,211,426,212,363,213,363,214,268,215,268,216,202,217,202,218,185,219,185,220,217,221,217,222,265,223,265,224,353,225,353,226,732,227,732,228,1024,229,1024,230,1024,231,1024,232,1024,233,1024,234,1024,235,1024,236,866,237,866,238,811,239,811,240,619,241,619,242,1024,243,1024,244,1024,245,1024,246,1024,247,1024,248,1024,249,1024,250,1024,251,1024,252,1024,253,1024,254,771,255,771,},[107]={0,306,1,306,2,361,3,361,4,352,5,352,6,296,7,296,8,217,9,217,10,165,11,165,12,143,13,143,14,118,15,118,16,95,17,95,18,72,19,72,20,56,21,56,22,54,23,54,24,58,25,58,26,69,27,69,28,81,29,81,30,96,31,96,32,101,33,101,34,89,35,89,36,72,37,72,38,46,39,46,40,19,41,19,158,35,159,35,160,51,161,51,162,72,163,72,164,93,165,93,166,101,167,101,168,119,169,119,170,231,171,231,172,389,173,389,174,534,175,534,176,633,177,633,178,586,179,586,180,516,181,516,182,466,183,466,184,417,185,417,186,378,187,378,188,298,189,298,190,202,191,202,192,143,193,143,194,120,195,120,196,128,197,128,198,147,199,147,200,187,201,187,202,231,203,231,204,293,205,293,206,362,207,362,208,409,209,409,210,426,211,426,212,363,213,363,214,268,215,268,216,202,217,202,218,185,219,185,220,217,221,217,222,265,223,265,224,353,225,353,226,732,227,732,228,1024,229,1024,230,1024,231,1024,232,1024,233,1024,234,1024,235,1024,236,866,237,866,238,811,239,811,240,619,241,619,242,1024,243,1024,244,1024,245,1024,246,1024,247,1024,248,1024,249,1024,250,1024,251,1024,252,1024,253,1024,254,771,255,771,},[108]={0,307,1,307,2,338,3,338,4,319,5,319,6,258,7,258,8,188,9,188,10,151,11,151,12,126,13,126,14,100,15,100,16,79,17,79,18,61,19,61,20,48,21,48,22,44,23,44,24,50,25,50,26,63,27,63,28,79,29,79,30,100,31,100,32,111,33,111,34,106,35,106,36,88,37,88,38,60,39,60,40,29,41,29,162,40,163,40,164,62,165,62,166,75,167,75,168,81,169,81,170,149,171,149,172,260,173,260,174,411,175,411,176,544,177,544,178,567,179,567,180,568,181,568,182,544,183,544,184,505,185,505,186,462,187,462,188,373,189,373,190,258,191,258,192,176,193,176,194,142,195,142,196,143,197,143,198,155,199,155,200,183,201,183,202,215,203,215,204,282,205,282,206,369,207,369,208,425,209,425,210,446,211,446,212,372,213,372,214,260,215,260,216,188,217,188,218,172,219,172,220,205,221,205,222,255,223,255,224,301,225,301,226,322,227,322,228,346,229,346,230,849,231,849,232,1024,233,1024,234,1024,235,1024,236,1024,237,1024,238,1024,239,1024,240,1024,241,1024,242,1024,243,1024,244,1024,245,1024,246,1024,247,1024,248,1024,249,1024,250,1024,251,1024,252,1024,253,1024,254,872,255,872,},[109]={0,307,1,307,2,338,3,338,4,319,5,319,6,258,7,258,8,188,9,188,10,151,11,151,12,126,13,126,14,100,15,100,16,79,17,79,18,61,19,61,20,48,21,48,22,44,23,44,24,50,25,50,26,63,27,63,28,79,29,79,30,100,31,100,32,111,33,111,34,106,35,106,36,88,37,88,38,60,39,60,40,29,41,29,162,40,163,40,164,62,165,62,166,75,167,75,168,81,169,81,170,149,171,149,172,260,173,260,174,411,175,411,176,544,177,544,178,567,179,567,180,568,181,568,182,544,183,544,184,505,185,505,186,462,187,462,188,373,189,373,190,258,191,258,192,176,193,176,194,142,195,142,196,143,197,143,198,155,199,155,200,183,201,183,202,215,203,215,204,282,205,282,206,369,207,369,208,425,209,425,210,446,211,446,212,372,213,372,214,260,215,260,216,188,217,188,218,172,219,172,220,205,221,205,222,255,223,255,224,301,225,301,226,322,227,322,228,346,229,346,230,849,231,849,232,1024,233,1024,234,1024,235,1024,236,1024,237,1024,238,1024,239,1024,240,1024,241,1024,242,1024,243,1024,244,1024,245,1024,246,1024,247,1024,248,1024,249,1024,250,1024,251,1024,252,1024,253,1024,254,872,255,872,},[110]={0,315,1,315,2,323,3,323,4,293,5,293,6,231,7,231,8,175,9,175,10,146,11,146,12,119,13,119,14,90,15,90,16,72,17,72,18,59,19,59,20,49,21,49,22,45,23,45,24,50,25,50,26,62,27,62,28,76,29,76,30,98,31,98,32,111,33,111,34,108,35,108,36,91,37,91,38,64,39,64,40,32,41,32,164,29,165,29,166,39,167,39,168,41,169,41,170,72,171,72,172,142,173,142,174,281,175,281,176,421,177,421,178,511,179,511,180,584,181,584,182,611,183,611,184,601,185,601,186,561,187,561,188,467,189,467,190,335,191,335,192,236,193,236,194,186,195,186,196,169,197,169,198,168,199,168,200,184,201,184,202,198,203,198,204,263,205,263,206,358,207,358,208,416,209,416,210,435,211,435,212,363,213,363,214,247,215,247,216,176,217,176,218,168,219,168,220,206,221,206,222,264,223,264,224,315,225,315,226,344,227,344,228,333,229,333,230,299,231,299,232,543,233,543,234,1024,235,1024,236,1024,237,1024,238,1024,239,1024,240,1024,241,1024,242,1024,243,1024,244,1024,245,1024,246,981,247,981,248,490,249,490,250,177,251,177,252,303,253,303,254,359,255,359,},[111]={0,315,1,315,2,323,3,323,4,293,5,293,6,231,7,231,8,175,9,175,10,146,11,146,12,119,13,119,14,90,15,90,16,72,17,72,18,59,19,59,20,49,21,49,22,45,23,45,24,50,25,50,26,62,27,62,28,76,29,76,30,98,31,98,32,111,33,111,34,108,35,108,36,91,37,91,38,64,39,64,40,32,41,32,164,29,165,29,166,39,167,39,168,41,169,41,170,72,171,72,172,142,173,142,174,281,175,281,176,421,177,421,178,511,179,511,180,584,181,584,182,611,183,611,184,601,185,601,186,561,187,561,188,467,189,467,190,335,191,335,192,236,193,236,194,186,195,186,196,169,197,169,198,168,199,168,200,184,201,184,202,198,203,198,204,263,205,263,206,358,207,358,208,416,209,416,210,435,211,435,212,363,213,363,214,247,215,247,216,176,217,176,218,168,219,168,220,206,221,206,222,264,223,264,224,315,225,315,226,344,227,344,228,333,229,333,230,299,231,299,232,543,233,543,234,1024,235,1024,236,1024,237,1024,238,1024,239,1024,240,1024,241,1024,242,1024,243,1024,244,1024,245,1024,246,981,247,981,248,490,249,490,250,177,251,177,252,303,253,303,254,359,255,359,},[112]={0,329,1,329,2,310,3,310,4,271,5,271,6,209,7,209,8,167,9,167,10,141,11,141,12,112,13,112,14,82,15,82,16,64,17,64,18,58,19,58,20,55,21,55,22,53,23,53,24,58,25,58,26,62,27,62,28,68,29,68,30,83,31,83,32,96,33,96,34,95,35,95,36,81,37,81,38,59,39,59,40,29,41,29,172,65,173,65,174,168,175,168,176,293,177,293,178,413,179,413,180,532,181,532,182,612,183,612,184,636,185,636,186,613,187,613,188,541,189,541,190,414,191,414,192,314,193,314,194,253,195,253,196,210,197,210,198,195,199,195,200,205,201,205,202,210,203,210,204,262,205,262,206,344,207,344,208,385,209,385,210,397,211,397,212,334,213,334,214,228,215,228,216,169,217,169,218,169,219,169,220,210,221,210,222,273,223,273,224,329,225,329,226,365,227,365,228,370,229,370,230,342,231,342,232,310,233,310,234,291,235,291,236,529,237,529,238,668,239,668,240,504,241,504,242,446,243,446,244,304,245,304,246,175,247,175,248,195,249,195,250,217,251,217,252,266,253,266,254,312,255,312,},[113]={0,329,1,329,2,310,3,310,4,271,5,271,6,209,7,209,8,167,9,167,10,141,11,141,12,112,13,112,14,82,15,82,16,64,17,64,18,58,19,58,20,55,21,55,22,53,23,53,24,58,25,58,26,62,27,62,28,68,29,68,30,83,31,83,32,96,33,96,34,95,35,95,36,81,37,81,38,59,39,59,40,29,41,29,172,65,173,65,174,168,175,168,176,293,177,293,178,413,179,413,180,532,181,532,182,612,183,612,184,636,185,636,186,613,187,613,188,541,189,541,190,414,191,414,192,314,193,314,194,253,195,253,196,210,197,210,198,195,199,195,200,205,201,205,202,210,203,210,204,262,205,262,206,344,207,344,208,385,209,385,210,397,211,397,212,334,213,334,214,228,215,228,216,169,217,169,218,169,219,169,220,210,221,210,222,273,223,273,224,329,225,329,226,365,227,365,228,370,229,370,230,342,231,342,232,310,233,310,234,291,235,291,236,529,237,529,238,668,239,668,240,504,241,504,242,446,243,446,244,304,245,304,246,175,247,175,248,195,249,195,250,217,251,217,252,266,253,266,254,312,255,312,},[114]={0,357,1,357,2,308,3,308,4,249,5,249,6,185,7,185,8,144,9,144,10,118,11,118,12,92,13,92,14,66,15,66,16,54,17,54,18,54,19,54,20,59,21,59,22,61,23,61,24,64,25,64,26,58,27,58,28,54,29,54,30,58,31,58,32,63,33,63,34,62,35,62,36,52,37,52,38,36,39,36,40,17,41,17,174,81,175,81,176,164,177,164,178,277,179,277,180,410,181,410,182,520,183,520,184,580,185,580,186,595,187,595,188,569,189,569,190,482,191,482,192,406,193,406,194,342,195,342,196,272,197,272,198,248,199,248,200,256,201,256,202,258,203,258,204,299,205,299,206,350,207,350,208,362,209,362,210,359,211,359,212,304,213,304,214,217,215,217,216,169,217,169,218,171,219,171,220,214,221,214,222,274,223,274,224,329,225,329,226,368,227,368,228,381,229,381,230,358,231,358,232,325,233,325,234,300,235,300,236,262,237,262,238,226,239,226,240,196,241,196,242,185,243,185,244,181,245,181,246,194,247,194,248,227,249,227,250,273,251,273,252,332,253,332,254,357,255,357,},[115]={0,357,1,357,2,308,3,308,4,249,5,249,6,185,7,185,8,144,9,144,10,118,11,118,12,92,13,92,14,66,15,66,16,54,17,54,18,54,19,54,20,59,21,59,22,61,23,61,24,64,25,64,26,58,27,58,28,54,29,54,30,58,31,58,32,63,33,63,34,62,35,62,36,52,37,52,38,36,39,36,40,17,41,17,174,81,175,81,176,164,177,164,178,277,179,277,180,410,181,410,182,520,183,520,184,580,185,580,186,595,187,595,188,569,189,569,190,482,191,482,192,406,193,406,194,342,195,342,196,272,197,272,198,248,199,248,200,256,201,256,202,258,203,258,204,299,205,299,206,350,207,350,208,362,209,362,210,359,211,359,212,304,213,304,214,217,215,217,216,169,217,169,218,171,219,171,220,214,221,214,222,274,223,274,224,329,225,329,226,368,227,368,228,381,229,381,230,358,231,358,232,325,233,325,234,300,235,300,236,262,237,262,238,226,239,226,240,196,241,196,242,185,243,185,244,181,245,181,246,194,247,194,248,227,249,227,250,273,251,273,252,332,253,332,254,357,255,357,},[116]={0,385,1,385,2,313,3,313,4,227,5,227,6,154,7,154,8,106,9,106,10,77,11,77,12,59,13,59,14,44,15,44,16,38,17,38,18,44,19,44,20,50,21,50,22,49,23,49,24,50,25,50,26,42,27,42,28,32,29,32,30,28,31,28,32,29,33,29,34,26,35,26,176,68,177,68,178,144,179,144,180,255,181,255,182,368,183,368,184,445,185,445,186,506,187,506,188,542,189,542,190,511,191,511,192,1024,193,1024,194,1024,195,1024,196,531,197,531,198,319,199,319,200,328,201,328,202,332,203,332,204,361,205,361,206,388,207,388,208,370,209,370,210,344,211,344,212,295,213,295,214,229,215,229,216,196,217,196,218,207,219,207,220,243,221,243,222,292,223,292,224,334,225,334,226,358,227,358,228,370,229,370,230,351,231,351,232,325,233,325,234,310,235,310,236,291,237,291,238,273,239,273,240,247,241,247,242,230,243,230,244,222,245,222,246,234,247,234,248,274,249,274,250,329,251,329,252,390,253,390,254,401,255,401,},[117]={0,385,1,385,2,313,3,313,4,227,5,227,6,154,7,154,8,106,9,106,10,77,11,77,12,59,13,59,14,44,15,44,16,38,17,38,18,44,19,44,20,50,21,50,22,49,23,49,24,50,25,50,26,42,27,42,28,32,29,32,30,28,31,28,32,29,33,29,34,26,35,26,176,68,177,68,178,144,179,144,180,255,181,255,182,368,183,368,184,445,185,445,186,506,187,506,188,542,189,542,190,511,191,511,192,1024,193,1024,194,1024,195,1024,196,531,197,531,198,319,199,319,200,328,201,328,202,332,203,332,204,361,205,361,206,388,207,388,208,370,209,370,210,344,211,344,212,295,213,295,214,229,215,229,216,196,217,196,218,207,219,207,220,243,221,243,222,292,223,292,224,334,225,334,226,358,227,358,228,370,229,370,230,351,231,351,232,325,233,325,234,310,235,310,236,291,237,291,238,273,239,273,240,247,241,247,242,230,243,230,244,222,245,222,246,234,247,234,248,274,249,274,250,329,251,329,252,390,253,390,254,401,255,401,},[118]={0,406,1,406,2,310,3,310,4,196,5,196,6,112,7,112,8,66,9,66,10,40,11,40,12,31,13,31,14,25,15,25,16,22,17,22,18,28,19,28,20,29,21,29,22,26,23,26,24,26,25,26,26,19,27,19,178,54,179,54,180,123,181,123,182,207,183,207,184,275,185,275,186,370,187,370,188,461,189,461,190,763,191,763,192,1024,193,1024,194,1024,195,1024,196,615,197,615,198,412,199,412,200,427,201,427,202,432,203,432,204,438,205,438,206,442,207,442,208,407,209,407,210,364,211,364,212,321,213,321,214,267,215,267,216,242,217,242,218,258,219,258,220,287,221,287,222,322,223,322,224,348,225,348,226,354,227,354,228,359,229,359,230,343,231,343,232,322,233,322,234,320,235,320,236,335,237,335,238,340,239,340,240,319,241,319,242,294,243,294,244,276,245,276,246,286,247,286,248,323,249,323,250,384,251,384,252,439,253,439,254,432,255,432,},[119]={0,406,1,406,2,310,3,310,4,196,5,196,6,112,7,112,8,66,9,66,10,40,11,40,12,31,13,31,14,25,15,25,16,22,17,22,18,28,19,28,20,29,21,29,22,26,23,26,24,26,25,26,26,19,27,19,178,54,179,54,180,123,181,123,182,207,183,207,184,275,185,275,186,370,187,370,188,461,189,461,190,763,191,763,192,1024,193,1024,194,1024,195,1024,196,615,197,615,198,412,199,412,200,427,201,427,202,432,203,432,204,438,205,438,206,442,207,442,208,407,209,407,210,364,211,364,212,321,213,321,214,267,215,267,216,242,217,242,218,258,219,258,220,287,221,287,222,322,223,322,224,348,225,348,226,354,227,354,228,359,229,359,230,343,231,343,232,322,233,322,234,320,235,320,236,335,237,335,238,340,239,340,240,319,241,319,242,294,243,294,244,276,245,276,246,286,247,286,248,323,249,323,250,384,251,384,252,439,253,439,254,432,255,432,},[120]={0,400,1,400,2,292,3,292,4,163,5,163,6,78,7,78,8,36,9,36,10,16,11,16,12,13,13,13,14,10,15,10,16,10,17,10,18,12,19,12,180,47,181,47,182,89,183,89,184,143,185,143,186,1024,187,1024,188,1024,189,1024,190,1024,191,1024,192,1024,193,1024,194,1024,195,1024,196,473,197,473,198,472,199,472,200,503,201,503,202,509,203,509,204,494,205,494,206,478,207,478,208,434,209,434,210,383,211,383,212,660,213,660,214,622,215,622,216,296,217,296,218,316,219,316,220,348,221,348,222,386,223,386,224,398,225,398,226,391,227,391,228,382,229,382,230,358,231,358,232,328,233,328,234,335,235,335,236,374,237,374,238,392,239,392,240,372,241,372,242,338,243,338,244,330,245,330,246,358,247,358,248,390,249,390,250,443,251,443,252,472,253,472,254,434,255,434,},[121]={0,400,1,400,2,292,3,292,4,163,5,163,6,78,7,78,8,36,9,36,10,16,11,16,12,13,13,13,14,10,15,10,16,10,17,10,18,12,19,12,180,47,181,47,182,89,183,89,184,143,185,143,186,1024,187,1024,188,1024,189,1024,190,1024,191,1024,192,1024,193,1024,194,1024,195,1024,196,473,197,473,198,472,199,472,200,503,201,503,202,509,203,509,204,494,205,494,206,478,207,478,208,434,209,434,210,383,211,383,212,660,213,660,214,622,215,622,216,296,217,296,218,316,219,316,220,348,221,348,222,386,223,386,224,398,225,398,226,391,227,391,228,382,229,382,230,358,231,358,232,328,233,328,234,335,235,335,236,374,237,374,238,392,239,392,240,372,241,372,242,338,243,338,244,330,245,330,246,358,247,358,248,390,249,390,250,443,251,443,252,472,253,472,254,434,255,434,},[122]={0,364,1,364,2,259,3,259,4,136,5,136,6,58,7,58,180,495,181,495,182,1024,183,1024,184,1024,185,1024,186,1024,187,1024,188,1024,189,1024,190,1024,191,1024,192,1024,193,1024,194,440,195,440,196,448,197,448,198,466,199,466,200,510,201,510,202,511,203,511,204,486,205,486,206,471,207,471,208,437,209,437,210,392,211,392,212,1024,213,1024,214,1024,215,1024,216,324,217,324,218,357,219,357,220,397,221,397,222,441,223,441,224,457,225,457,226,444,227,444,228,430,229,430,230,398,231,398,232,359,233,359,234,374,235,374,236,416,237,416,238,430,239,430,240,405,241,405,242,359,243,359,244,370,245,370,246,421,247,421,248,458,249,458,250,496,251,496,252,479,253,479,254,411,255,411,},[123]={0,364,1,364,2,259,3,259,4,136,5,136,6,58,7,58,180,495,181,495,182,1024,183,1024,184,1024,185,1024,186,1024,187,1024,188,1024,189,1024,190,1024,191,1024,192,1024,193,1024,194,440,195,440,196,448,197,448,198,466,199,466,200,510,201,510,202,511,203,511,204,486,205,486,206,471,207,471,208,437,209,437,210,392,211,392,212,1024,213,1024,214,1024,215,1024,216,324,217,324,218,357,219,357,220,397,221,397,222,441,223,441,224,457,225,457,226,444,227,444,228,430,229,430,230,398,231,398,232,359,233,359,234,374,235,374,236,416,237,416,238,430,239,430,240,405,241,405,242,359,243,359,244,370,245,370,246,421,247,421,248,458,249,458,250,496,251,496,252,479,253,479,254,411,255,411,},[124]={0,311,1,311,2,221,3,221,4,116,5,116,6,47,7,47,180,1024,181,1024,182,1024,183,1024,184,1024,185,1024,186,1024,187,1024,188,1024,189,1024,190,778,191,778,192,318,193,318,194,346,195,346,196,368,197,368,198,399,199,399,200,444,201,444,202,447,203,447,204,415,205,415,206,404,207,404,208,387,209,387,210,358,211,358,212,1024,213,1024,214,1024,215,1024,216,396,217,396,218,335,219,335,220,381,221,381,222,434,223,434,224,463,225,463,226,469,227,469,228,463,229,463,230,438,231,438,232,403,233,403,234,416,235,416,236,443,237,443,238,441,239,441,240,410,241,410,242,364,243,364,244,398,245,398,246,459,247,459,248,493,249,493,250,514,251,514,252,456,253,456,254,371,255,371,},[125]={0,311,1,311,2,221,3,221,4,116,5,116,6,47,7,47,180,1024,181,1024,182,1024,183,1024,184,1024,185,1024,186,1024,187,1024,188,1024,189,1024,190,778,191,778,192,318,193,318,194,346,195,346,196,368,197,368,198,399,199,399,200,444,201,444,202,447,203,447,204,415,205,415,206,404,207,404,208,387,209,387,210,358,211,358,212,1024,213,1024,214,1024,215,1024,216,396,217,396,218,335,219,335,220,381,221,381,222,434,223,434,224,463,225,463,226,469,227,469,228,463,229,463,230,438,231,438,232,403,233,403,234,416,235,416,236,443,237,443,238,441,239,441,240,410,241,410,242,364,243,364,244,398,245,398,246,459,247,459,248,493,249,493,250,514,251,514,252,456,253,456,254,371,255,371,},[126]={0,250,1,250,2,188,3,188,4,104,5,104,180,1024,181,1024,182,1024,183,1024,184,1024,185,1024,186,589,187,589,188,175,189,175,190,221,191,221,192,242,193,242,194,251,195,251,196,257,197,257,198,281,199,281,200,320,201,320,202,321,203,321,204,306,205,306,206,303,207,303,208,296,209,296,210,280,211,280,212,1024,213,1024,214,1024,215,1024,216,1024,217,1024,218,259,219,259,220,303,221,303,222,361,223,361,224,402,225,402,226,426,227,426,228,440,229,440,230,434,231,434,232,417,233,417,234,429,235,429,236,438,237,438,238,426,239,426,240,390,241,390,242,354,243,354,244,407,245,407,246,441,247,441,248,467,249,467,250,491,251,491,252,404,253,404,254,311,255,311,},[127]={0,250,1,250,2,188,3,188,4,104,5,104,180,1024,181,1024,182,1024,183,1024,184,1024,185,1024,186,589,187,589,188,175,189,175,190,221,191,221,192,242,193,242,194,251,195,251,196,257,197,257,198,281,199,281,200,320,201,320,202,321,203,321,204,306,205,306,206,303,207,303,208,296,209,296,210,280,211,280,212,1024,213,1024,214,1024,215,1024,216,1024,217,1024,218,259,219,259,220,303,221,303,222,361,223,361,224,402,225,402,226,426,227,426,228,440,229,440,230,434,231,434,232,417,233,417,234,429,235,429,236,438,237,438,238,426,239,426,240,390,241,390,242,354,243,354,244,407,245,407,246,441,247,441,248,467,249,467,250,491,251,491,252,404,253,404,254,311,255,311,},[128]={0,187,1,187,2,158,3,158,4,94,5,94,184,17,185,17,186,74,187,74,188,143,189,143,190,181,191,181,192,198,193,198,194,186,195,186,196,173,197,173,198,182,199,182,200,199,201,199,202,200,203,200,204,200,205,200,206,207,207,207,208,210,209,210,210,201,211,201,212,214,213,214,214,1024,215,1024,216,1024,217,1024,218,149,219,149,220,181,221,181,222,234,223,234,224,283,225,283,226,318,227,318,228,355,229,355,230,379,231,379,232,392,233,392,234,415,235,415,236,425,237,425,238,418,239,418,240,380,241,380,242,351,243,351,244,397,245,397,246,572,247,572,248,570,249,570,250,418,251,418,252,323,253,323,254,241,255,241,},[129]={0,187,1,187,2,158,3,158,4,94,5,94,184,17,185,17,186,74,187,74,188,143,189,143,190,181,191,181,192,198,193,198,194,186,195,186,196,173,197,173,198,182,199,182,200,199,201,199,202,200,203,200,204,200,205,200,206,207,207,207,208,210,209,210,210,201,211,201,212,214,213,214,214,1024,215,1024,216,1024,217,1024,218,149,219,149,220,181,221,181,222,234,223,234,224,283,225,283,226,318,227,318,228,355,229,355,230,379,231,379,232,392,233,392,234,415,235,415,236,425,237,425,238,418,239,418,240,380,241,380,242,351,243,351,244,397,245,397,246,572,247,572,248,570,249,570,250,418,251,418,252,323,253,323,254,241,255,241,},[130]={0,358,1,358,2,316,3,316,4,265,5,265,184,12,185,12,186,62,187,62,188,116,189,116,190,148,191,148,192,163,193,163,194,138,195,138,196,118,197,118,198,119,199,119,200,130,201,130,202,137,203,137,204,146,205,146,206,152,207,152,208,154,209,154,210,146,211,146,212,114,213,114,214,1024,215,1024,216,1024,217,1024,218,287,219,287,220,78,221,78,222,116,223,116,224,157,225,157,226,202,227,202,228,250,229,250,230,295,231,295,232,329,233,329,234,359,235,359,236,384,237,384,238,389,239,389,240,368,241,368,242,353,243,353,244,373,245,373,246,1024,247,1024,248,1024,249,1024,250,1024,251,1024,252,1024,253,1024,254,626,255,626,},[131]={0,358,1,358,2,316,3,316,4,265,5,265,184,12,185,12,186,62,187,62,188,116,189,116,190,148,191,148,192,163,193,163,194,138,195,138,196,118,197,118,198,119,199,119,200,130,201,130,202,137,203,137,204,146,205,146,206,152,207,152,208,154,209,154,210,146,211,146,212,114,213,114,214,1024,215,1024,216,1024,217,1024,218,287,219,287,220,78,221,78,222,116,223,116,224,157,225,157,226,202,227,202,228,250,229,250,230,295,231,295,232,329,233,329,234,359,235,359,236,384,237,384,238,389,239,389,240,368,241,368,242,353,243,353,244,373,245,373,246,1024,247,1024,248,1024,249,1024,250,1024,251,1024,252,1024,253,1024,254,626,255,626,},[132]={0,1024,1,1024,2,1024,3,1024,4,1024,5,1024,6,675,7,675,8,270,9,270,184,14,185,14,186,55,187,55,188,92,189,92,190,115,191,115,192,124,193,124,194,103,195,103,196,88,197,88,198,93,199,93,200,107,201,107,202,115,203,115,204,128,205,128,206,127,207,127,208,119,209,119,210,109,211,109,212,75,213,75,214,1024,215,1024,216,1024,217,1024,218,225,219,225,220,1,221,1,222,1,223,1,224,79,225,79,226,120,227,120,228,169,229,169,230,213,231,213,232,249,233,249,234,284,235,284,236,324,237,324,238,347,239,347,240,348,241,348,242,341,243,341,244,336,245,336,246,1024,247,1024,248,1024,249,1024,250,1024,251,1024,252,1024,253,1024,254,1024,255,1024,},[133]={0,1024,1,1024,2,1024,3,1024,4,1024,5,1024,6,675,7,675,8,270,9,270,184,14,185,14,186,55,187,55,188,92,189,92,190,115,191,115,192,124,193,124,194,103,195,103,196,88,197,88,198,93,199,93,200,107,201,107,202,115,203,115,204,128,205,128,206,127,207,127,208,119,209,119,210,109,211,109,212,75,213,75,214,1024,215,1024,216,1024,217,1024,218,225,219,225,220,1,221,1,222,1,223,1,224,79,225,79,226,120,227,120,228,169,229,169,230,213,231,213,232,249,233,249,234,284,235,284,236,324,237,324,238,347,239,347,240,348,241,348,242,341,243,341,244,336,245,336,246,1024,247,1024,248,1024,249,1024,250,1024,251,1024,252,1024,253,1024,254,1024,255,1024,},[134]={0,1024,1,1024,2,1024,3,1024,4,1024,5,1024,6,1024,7,1024,8,720,9,720,184,18,185,18,186,47,187,47,188,68,189,68,190,81,191,81,192,83,193,83,194,70,195,70,196,67,197,67,198,84,199,84,200,102,201,102,202,111,203,111,204,120,205,120,206,106,207,106,208,88,209,88,210,69,211,69,212,42,213,42,214,1024,215,1024,216,1024,217,1024,224,39,225,39,226,78,227,78,228,120,229,120,230,149,231,149,232,175,233,175,234,214,235,214,236,264,237,264,238,304,239,304,240,331,241,331,242,324,243,324,244,300,245,300,246,258,247,258,248,207,249,207,250,885,251,885,252,1024,253,1024,254,1024,255,1024,},[135]={0,1024,1,1024,2,1024,3,1024,4,1024,5,1024,6,1024,7,1024,8,720,9,720,184,18,185,18,186,47,187,47,188,68,189,68,190,81,191,81,192,83,193,83,194,70,195,70,196,67,197,67,198,84,199,84,200,102,201,102,202,111,203,111,204,120,205,120,206,106,207,106,208,88,209,88,210,69,211,69,212,42,213,42,214,1024,215,1024,216,1024,217,1024,224,39,225,39,226,78,227,78,228,120,229,120,230,149,231,149,232,175,233,175,234,214,235,214,236,264,237,264,238,304,239,304,240,331,241,331,242,324,243,324,244,300,245,300,246,258,247,258,248,207,249,207,250,885,251,885,252,1024,253,1024,254,1024,255,1024,},[136]={0,390,1,390,2,1024,3,1024,4,1024,5,1024,6,1024,7,1024,8,450,9,450,184,18,185,18,186,37,187,37,188,49,189,49,190,54,191,54,192,50,193,50,194,46,195,46,196,51,197,51,198,72,199,72,200,93,201,93,202,101,203,101,204,105,205,105,206,84,207,84,208,57,209,57,210,36,211,36,226,41,227,41,228,67,229,67,230,90,231,90,232,113,233,113,234,154,235,154,236,202,237,202,238,252,239,252,240,296,241,296,242,291,243,291,244,260,245,260,246,211,247,211,248,159,249,159,250,128,251,128,252,103,253,103,254,91,255,91,},[137]={0,390,1,390,2,1024,3,1024,4,1024,5,1024,6,1024,7,1024,8,450,9,450,184,18,185,18,186,37,187,37,188,49,189,49,190,54,191,54,192,50,193,50,194,46,195,46,196,51,197,51,198,72,199,72,200,93,201,93,202,101,203,101,204,105,205,105,206,84,207,84,208,57,209,57,210,36,211,36,226,41,227,41,228,67,229,67,230,90,231,90,232,113,233,113,234,154,235,154,236,202,237,202,238,252,239,252,240,296,241,296,242,291,243,291,244,260,245,260,246,211,247,211,248,159,249,159,250,128,251,128,252,103,253,103,254,91,255,91,},[138]={0,78,1,78,2,83,3,83,4,79,5,79,6,40,7,40,184,15,185,15,186,27,187,27,188,35,189,35,190,37,191,37,192,34,193,34,194,37,195,37,196,44,197,44,198,60,199,60,200,71,201,71,202,71,203,71,204,70,205,70,206,51,207,51,208,28,209,28,232,59,233,59,234,98,235,98,236,141,237,141,238,195,239,195,240,243,241,243,242,242,243,242,244,215,245,215,246,169,247,169,248,133,249,133,250,111,251,111,252,101,253,101,254,94,255,94,},[139]={0,78,1,78,2,83,3,83,4,79,5,79,6,40,7,40,184,15,185,15,186,27,187,27,188,35,189,35,190,37,191,37,192,34,193,34,194,37,195,37,196,44,197,44,198,60,199,60,200,71,201,71,202,71,203,71,204,70,205,70,206,51,207,51,208,28,209,28,232,59,233,59,234,98,235,98,236,141,237,141,238,195,239,195,240,243,241,243,242,242,243,242,244,215,245,215,246,169,247,169,248,133,249,133,250,111,251,111,252,101,253,101,254,94,255,94,},[140]={0,82,1,82,2,70,3,70,4,50,5,50,6,22,7,22,184,8,185,8,186,15,187,15,188,23,189,23,190,28,191,28,192,34,193,34,194,42,195,42,196,46,197,46,198,51,199,51,200,47,201,47,202,39,203,39,204,33,205,33,234,45,235,45,236,76,237,76,238,125,239,125,240,175,241,175,242,182,243,182,244,165,245,165,246,138,247,138,248,117,249,117,250,105,251,105,252,101,253,101,254,91,255,91,},[141]={0,82,1,82,2,70,3,70,4,50,5,50,6,22,7,22,184,8,185,8,186,15,187,15,188,23,189,23,190,28,191,28,192,34,193,34,194,42,195,42,196,46,197,46,198,51,199,51,200,47,201,47,202,39,203,39,204,33,205,33,234,45,235,45,236,76,237,76,238,125,239,125,240,175,241,175,242,182,243,182,244,165,245,165,246,138,247,138,248,117,249,117,250,105,251,105,252,101,253,101,254,91,255,91,},[142]={0,73,1,73,2,53,3,53,4,26,5,26,188,14,189,14,190,27,191,27,192,45,193,45,194,57,195,57,196,56,197,56,198,45,199,45,200,30,201,30,202,17,203,17,238,64,239,64,240,109,241,109,242,127,243,127,244,129,245,129,246,119,247,119,248,110,249,110,250,100,251,100,252,91,253,91,254,79,255,79,},[143]={0,73,1,73,2,53,3,53,4,26,5,26,188,14,189,14,190,27,191,27,192,45,193,45,194,57,195,57,196,56,197,56,198,45,199,45,200,30,201,30,202,17,203,17,238,64,239,64,240,109,241,109,242,127,243,127,244,129,245,129,246,119,247,119,248,110,249,110,250,100,251,100,252,91,253,91,254,79,255,79,},[144]={0,54,1,54,2,38,3,38,190,34,191,34,192,59,193,59,194,72,195,72,196,65,197,65,198,43,199,43,200,21,201,21,238,23,239,23,240,56,241,56,242,83,243,83,244,102,245,102,246,104,247,104,248,101,249,101,250,86,251,86,252,69,253,69,254,59,255,59,},[145]={0,54,1,54,2,38,3,38,190,34,191,34,192,59,193,59,194,72,195,72,196,65,197,65,198,43,199,43,200,21,201,21,238,23,239,23,240,56,241,56,242,83,243,83,244,102,245,102,246,104,247,104,248,101,249,101,250,86,251,86,252,69,253,69,254,59,255,59,},[146]={0,47,1,47,2,34,3,34,190,39,191,39,192,66,193,66,194,76,195,76,196,65,197,65,198,37,199,37,200,15,201,15,242,54,243,54,244,80,245,80,246,88,247,88,248,83,249,83,250,69,251,69,252,51,253,51,254,47,255,47,},[147]={0,47,1,47,2,34,3,34,190,39,191,39,192,66,193,66,194,76,195,76,196,65,197,65,198,37,199,37,200,15,201,15,242,54,243,54,244,80,245,80,246,88,247,88,248,83,249,83,250,69,251,69,252,51,253,51,254,47,255,47,},[148]={0,53,1,53,2,39,3,39,190,37,191,37,192,59,193,59,194,67,195,67,196,54,197,54,198,28,199,28,242,47,243,47,244,74,245,74,246,80,247,80,248,74,249,74,250,62,251,62,252,49,253,49,254,50,255,50,},[149]={0,53,1,53,2,39,3,39,190,37,191,37,192,59,193,59,194,67,195,67,196,54,197,54,198,28,199,28,242,47,243,47,244,74,245,74,246,80,247,80,248,74,249,74,250,62,251,62,252,49,253,49,254,50,255,50,},[150]={0,66,1,66,2,43,3,43,190,28,191,28,192,42,193,42,194,47,195,47,196,36,197,36,198,17,199,17,242,40,243,40,244,65,245,65,246,72,247,72,248,71,249,71,250,65,251,65,252,57,253,57,254,60,255,60,},[151]={0,66,1,66,2,43,3,43,190,28,191,28,192,42,193,42,194,47,195,47,196,36,197,36,198,17,199,17,242,40,243,40,244,65,245,65,246,72,247,72,248,71,249,71,250,65,251,65,252,57,253,57,254,60,255,60,},[152]={0,79,1,79,2,42,3,42,190,14,191,14,192,21,193,21,194,23,195,23,196,16,197,16,244,47,245,47,246,63,247,63,248,68,249,68,250,71,251,71,252,72,253,72,254,72,255,72,},[153]={0,79,1,79,2,42,3,42,190,14,191,14,192,21,193,21,194,23,195,23,196,16,197,16,244,47,245,47,246,63,247,63,248,68,249,68,250,71,251,71,252,72,253,72,254,72,255,72,},[154]={0,72,1,72,2,32,3,32,244,29,245,29,246,51,247,51,248,63,249,63,250,72,251,72,252,76,253,76,254,73,255,73,},[155]={0,72,1,72,2,32,3,32,244,29,245,29,246,51,247,51,248,63,249,63,250,72,251,72,252,76,253,76,254,73,255,73,},[156]={0,48,1,48,246,32,247,32,248,48,249,48,250,61,251,61,252,66,253,66,254,57,255,57,},[157]={0,48,1,48,246,32,247,32,248,48,249,48,250,61,251,61,252,66,253,66,254,57,255,57,},[158]={248,26,249,26,250,38,251,38,252,48,253,48,254,37,255,37,},[159]={248,26,249,26,250,38,251,38,252,48,253,48,254,37,255,37,},[160]={250,18,251,18,252,26,253,26,254,16,255,16,},[161]={250,18,251,18,252,26,253,26,254,16,255,16,}
		},
		
		markers ={
			108, 34, 52, 12, 36, 224, 50, 172, 98, 158, 136, 194, 148, 248, 72, 232, 112, 250, 106, 196, 70, 196
		},
		
		objects = {
			[30]={220,5,7,-1,0,},[34]={224,5,18,-1,0,},[36]={222,5,18,-1,0,226,5,18,-1,0,},[38]={224,5,18,-1,0,},[40]={232,5,7,-1,0,},[44]={18,5,7,-1,0,214,5,7,-1,0,},[46]={182,5,7,-1,0,},[48]={172,5,18,-1,0,},[50]={12,5,18,-1,0,164,5,7,-1,0,170,5,18,-1,0,174,5,18,-1,0,},[52]={6,5,7,-1,0,10,5,18,-1,0,14,5,18,-1,0,172,5,18,-1,0,194,5,7,-1,0,},[54]={12,5,18,-1,0,},[56]={206,5,2,-1,0,208,5,2,-1,0,210,5,2,-1,0,},[58]={206,5,2,-1,0,208,5,2,-1,0,210,5,2,-1,0,238,5,7,-1,0,},[60]={10,5,7,-1,0,174,5,7,-1,0,206,5,2,-1,0,208,5,2,-1,0,210,5,2,-1,0,},[64]={212,5,7,-1,0,246,5,7,-1,0,},[66]={186,5,7,-1,0,198,5,7,-1,0,230,5,7,-1,0,},[70]={196,5,18,-1,0,},[72]={232,5,18,-1,0,},[74]={202,5,7,-1,0,},[76]={182,5,7,-1,0,188,5,2,-1,0,190,5,2,-1,0,192,5,2,-1,0,218,5,7,-1,0,246,5,2,-1,0,248,5,2,-1,0,250,5,2,-1,0,},[78]={188,5,2,-1,0,190,5,2,-1,0,192,5,2,-1,0,246,5,2,-1,0,248,5,2,-1,0,250,5,2,-1,0,},[80]={188,5,2,-1,0,190,5,2,-1,0,192,5,2,-1,0,246,5,2,-1,0,248,5,2,-1,0,250,5,2,-1,0,},[82]={214,5,7,-1,0,},[84]={198,5,7,-1,0,},[86]={222,5,2,-1,0,224,5,2,-1,0,226,5,2,-1,0,238,5,7,-1,0,254,5,7,-1,0,},[88]={12,5,7,-1,0,222,5,2,-1,0,224,5,2,-1,0,226,5,2,-1,0,},[90]={168,5,7,-1,0,222,5,2,-1,0,224,5,2,-1,0,226,5,2,-1,0,},[92]={22,5,7,-1,0,},[96]={150,5,7,-1,0,158,5,18,-1,0,178,5,7,-1,0,242,5,7,-1,0,},[98]={156,5,18,-1,0,160,5,18,-1,0,},[100]={2,5,7,-1,0,158,5,18,-1,0,},[102]={182,5,2,-1,0,184,5,2,-1,0,186,5,2,-1,0,220,5,7,-1,0,},[104]={8,5,2,-1,0,10,5,2,-1,0,12,5,2,-1,0,40,5,7,-1,0,162,5,7,-1,0,182,5,2,-1,0,184,5,2,-1,0,186,5,2,-1,0,},[106]={8,5,2,-1,0,10,5,2,-1,0,12,5,2,-1,0,28,5,7,-1,0,34,5,18,-1,0,182,5,2,-1,0,184,5,2,-1,0,186,5,2,-1,0,196,5,18,-1,0,202,5,7,-1,0,},[108]={8,5,2,-1,0,10,5,2,-1,0,12,5,2,-1,0,32,5,18,-1,0,36,5,18,-1,0,},[110]={34,5,18,-1,0,178,5,7,-1,0,},[112]={208,5,2,-1,0,210,5,2,-1,0,212,5,2,-1,0,250,5,18,-1,0,},[114]={208,5,2,-1,0,210,5,2,-1,0,212,5,2,-1,0,248,5,7,-1,0,},[116]={22,5,7,-1,0,208,5,2,-1,0,210,5,2,-1,0,212,5,2,-1,0,},[120]={232,5,7,-1,0,},[122]={2,5,7,-1,0,},[124]={208,5,7,-1,0,238,5,2,-1,0,240,5,2,-1,0,242,5,2,-1,0,},[126]={192,5,7,-1,0,238,5,2,-1,0,240,5,2,-1,0,242,5,2,-1,0,},[128]={238,5,2,-1,0,240,5,2,-1,0,242,5,2,-1,0,},[130]={228,5,7,-1,0,},[134]={194,5,18,-1,0,},[136]={182,5,7,-1,0,192,5,18,-1,0,196,5,18,-1,0,},[138]={194,5,18,-1,0,},[140]={200,5,7,-1,0,248,5,7,-1,0,},[146]={248,5,18,-1,0,},[148]={240,5,7,-1,0,246,5,18,-1,0,250,5,18,-1,0,},[150]={2,5,7,-1,0,248,5,18,-1,0,}
		},
		
		shaman_positions = {
			78, 216, 80, 218, 84, 218, 86, 216, 86, 212, 84, 210, 80, 210, 78, 212
		},
		
		scripts = {
			OnTurn = function(everySecond1, everySecond2, everySecond4) 			quake_on_turn(everySecond1, everySecond2, everySecond4) end,
			OnCreateThing = function(t, owner, type, model) 						quake_on_create_thing(t, owner, type, model) end,
			OnFrame = function(ghover) 												return quake_on_frame(ghover) end,
			OnPowerUp = function(id, c3d)											QA_on_power_up(id, c3d) end,
			OnHumanDisconnect = function(player) 									QA_init_single_AI(player) end,
		},
		
	},

	[MAP_DISCO_FLOOR]={
	
		info = 	{ 	name = "Disco Floor", author = "MrKosjaK",
					desc = "Shamans must dance around the arena, making sure they are not stepping on the wrong color, once the timer ends. <br> Patterns are wilder, and timers are dangerously random, so pay attention and move your feet! <br> Shamans are able to melee attack other shamans, but careful - karma could hit you back! <p> Dance like nobody's watching!",
					map_objectives = { {value=6, step=1, default=false}, {value=25, step=5, default=false}, {value=30, limit=50, step=5, default=true} },
					image = 2816, texture={15, 0}, zoom={44,138,0}, drop_infos = true,	marker_lb={186, 16}, reinc_timer=12, shield_respawn=false,
					custom_rules = {
						{ default = false, 	name = "use boats", desc = "Why not play the mini game using boats instead? It's chaotic!" },
					}
				},

		land ={
			[16]={132,2,133,2,134,4,135,4,136,6,137,6,138,7,139,7,140,8,141,8,142,9,143,9,144,10,145,10,146,10,147,10,148,10,149,10,150,10,151,10,152,10,153,10,154,10,155,10,156,10,157,10,158,10,159,10,160,10,161,10,162,9,163,9,164,8,165,8,166,7,167,7,168,6,169,6,170,5,171,5,172,5,173,5,174,6,175,6,176,8,177,8,178,9,179,9,180,11,181,11,182,12,183,12,184,12,185,12,186,10,187,10,188,7,189,7,190,18,191,18,192,18,193,18,},[17]={132,2,133,2,134,4,135,4,136,6,137,6,138,7,139,7,140,8,141,8,142,9,143,9,144,10,145,10,146,10,147,10,148,10,149,10,150,10,151,10,152,10,153,10,154,10,155,10,156,10,157,10,158,10,159,10,160,10,161,10,162,9,163,9,164,8,165,8,166,7,167,7,168,6,169,6,170,5,171,5,172,5,173,5,174,6,175,6,176,8,177,8,178,9,179,9,180,11,181,11,182,12,183,12,184,12,185,12,186,10,187,10,188,7,189,7,190,18,191,18,192,18,193,18,},[18]={132,4,133,4,134,8,135,8,136,11,137,11,138,14,139,14,140,16,141,16,142,18,143,18,144,19,145,19,146,20,147,20,148,20,149,20,150,20,151,20,152,20,153,20,154,20,155,20,156,20,157,20,158,20,159,20,160,19,161,19,162,18,163,18,164,16,165,16,166,13,167,13,168,12,169,12,170,11,171,11,172,11,173,11,174,13,175,13,176,15,177,15,178,19,179,19,180,22,181,22,182,23,183,23,184,22,185,22,186,19,187,19,188,13,189,13,190,18,191,18,192,18,193,18,},[19]={132,4,133,4,134,8,135,8,136,11,137,11,138,14,139,14,140,16,141,16,142,18,143,18,144,19,145,19,146,20,147,20,148,20,149,20,150,20,151,20,152,20,153,20,154,20,155,20,156,20,157,20,158,20,159,20,160,19,161,19,162,18,163,18,164,16,165,16,166,13,167,13,168,12,169,12,170,11,171,11,172,11,173,11,174,13,175,13,176,15,177,15,178,19,179,19,180,22,181,22,182,23,183,23,184,22,185,22,186,19,187,19,188,13,189,13,190,18,191,18,192,18,193,18,},[20]={132,6,133,6,134,11,135,11,136,16,137,16,138,22,139,22,140,26,141,26,142,29,143,29,144,31,145,31,146,32,147,32,148,32,149,32,150,33,151,33,152,35,153,35,154,35,155,35,156,35,157,35,158,35,159,35,160,34,161,34,162,29,163,29,164,23,165,23,166,19,167,19,168,17,169,17,170,16,171,16,172,16,173,16,174,18,175,18,176,22,177,22,178,26,179,26,180,30,181,30,182,32,183,32,184,30,185,30,186,26,187,26,188,18,189,18,190,18,191,18,192,18,193,18,},[21]={132,6,133,6,134,11,135,11,136,16,137,16,138,22,139,22,140,26,141,26,142,29,143,29,144,31,145,31,146,32,147,32,148,32,149,32,150,33,151,33,152,35,153,35,154,35,155,35,156,35,157,35,158,35,159,35,160,34,161,34,162,29,163,29,164,23,165,23,166,19,167,19,168,17,169,17,170,16,171,16,172,16,173,16,174,18,175,18,176,22,177,22,178,26,179,26,180,30,181,30,182,32,183,32,184,30,185,30,186,26,187,26,188,18,189,18,190,18,191,18,192,18,193,18,},[22]={132,7,133,7,134,13,135,13,136,20,137,20,138,28,139,28,140,35,141,35,142,39,143,39,144,41,145,41,146,42,147,42,148,42,149,42,150,44,151,44,152,48,153,48,154,50,155,50,156,50,157,50,158,49,159,49,160,48,161,48,162,40,163,40,164,30,165,30,166,25,167,25,168,21,169,21,170,20,171,20,172,20,173,20,174,23,175,23,176,27,177,27,178,32,179,32,180,36,181,36,182,37,183,37,184,36,185,36,186,30,187,30,188,21,189,21,190,17,191,17,192,17,193,17,},[23]={132,7,133,7,134,13,135,13,136,20,137,20,138,28,139,28,140,35,141,35,142,39,143,39,144,41,145,41,146,42,147,42,148,42,149,42,150,44,151,44,152,48,153,48,154,50,155,50,156,50,157,50,158,49,159,49,160,48,161,48,162,40,163,40,164,30,165,30,166,25,167,25,168,21,169,21,170,20,171,20,172,20,173,20,174,23,175,23,176,27,177,27,178,32,179,32,180,36,181,36,182,37,183,37,184,36,185,36,186,30,187,30,188,21,189,21,190,17,191,17,192,17,193,17,},[24]={132,8,133,8,134,15,135,15,136,22,137,22,138,33,139,33,140,42,141,42,142,47,143,47,144,49,145,49,146,50,147,50,148,49,149,49,150,53,151,53,152,57,153,57,154,58,155,58,156,58,157,58,158,58,159,58,160,57,161,57,162,46,163,46,164,35,165,35,166,29,167,29,168,25,169,25,170,24,171,24,172,24,173,24,174,27,175,27,176,30,177,30,178,35,179,35,180,38,181,38,182,40,183,40,184,38,185,38,186,32,187,32,188,22,189,22,190,17,191,17,192,17,193,17,},[25]={132,8,133,8,134,15,135,15,136,22,137,22,138,33,139,33,140,42,141,42,142,47,143,47,144,49,145,49,146,50,147,50,148,49,149,49,150,53,151,53,152,57,153,57,154,58,155,58,156,58,157,58,158,58,159,58,160,57,161,57,162,46,163,46,164,35,165,35,166,29,167,29,168,25,169,25,170,24,171,24,172,24,173,24,174,27,175,27,176,30,177,30,178,35,179,35,180,38,181,38,182,40,183,40,184,38,185,38,186,32,187,32,188,22,189,22,190,17,191,17,192,17,193,17,},[26]={132,8,133,8,134,15,135,15,136,23,137,23,138,36,139,36,140,47,141,47,142,53,143,53,144,56,145,56,146,57,147,57,148,56,149,56,150,58,151,58,152,60,153,60,154,61,155,61,156,61,157,61,158,61,159,61,160,62,161,62,162,53,163,53,164,42,165,42,166,37,167,37,168,34,169,34,170,32,171,32,172,31,173,31,174,31,175,31,176,33,177,33,178,36,179,36,180,39,181,39,182,40,183,40,184,38,185,38,186,32,187,32,188,22,189,22,190,11,191,11,192,11,193,11,},[27]={132,8,133,8,134,15,135,15,136,23,137,23,138,36,139,36,140,47,141,47,142,53,143,53,144,56,145,56,146,57,147,57,148,56,149,56,150,58,151,58,152,60,153,60,154,61,155,61,156,61,157,61,158,61,159,61,160,62,161,62,162,53,163,53,164,42,165,42,166,37,167,37,168,34,169,34,170,32,171,32,172,31,173,31,174,31,175,31,176,33,177,33,178,36,179,36,180,39,181,39,182,40,183,40,184,38,185,38,186,32,187,32,188,22,189,22,190,11,191,11,192,11,193,11,},[28]={132,8,133,8,134,15,135,15,136,23,137,23,138,38,139,38,140,51,141,51,142,57,143,57,144,61,145,61,146,62,147,62,148,61,149,61,150,61,151,61,152,61,153,61,154,61,155,61,156,61,157,61,158,61,159,61,160,64,161,64,162,58,163,58,164,50,165,50,166,46,167,46,168,44,169,44,170,41,171,41,172,38,173,38,174,35,175,35,176,35,177,35,178,37,179,37,180,39,181,39,182,39,183,39,184,37,185,37,186,31,187,31,188,22,189,22,190,11,191,11,192,11,193,11,},[29]={132,8,133,8,134,15,135,15,136,23,137,23,138,38,139,38,140,51,141,51,142,57,143,57,144,61,145,61,146,62,147,62,148,61,149,61,150,61,151,61,152,61,153,61,154,61,155,61,156,61,157,61,158,61,159,61,160,64,161,64,162,58,163,58,164,50,165,50,166,46,167,46,168,44,169,44,170,41,171,41,172,38,173,38,174,35,175,35,176,35,177,35,178,37,179,37,180,39,181,39,182,39,183,39,184,37,185,37,186,31,187,31,188,22,189,22,190,11,191,11,192,11,193,11,},[30]={132,8,133,8,134,15,135,15,136,23,137,23,138,40,139,40,140,55,141,55,142,61,143,61,144,64,145,64,146,66,147,66,148,65,149,65,150,62,151,62,152,60,153,60,154,59,155,59,156,58,157,58,158,60,159,60,160,64,161,64,162,61,163,61,164,56,165,56,166,54,167,54,168,53,169,53,170,51,171,51,172,46,173,46,174,41,175,41,176,38,177,38,178,38,179,38,180,39,181,39,182,40,183,40,184,37,185,37,186,31,187,31,188,22,189,22,190,11,191,11,192,6,193,6,},[31]={132,8,133,8,134,15,135,15,136,23,137,23,138,40,139,40,140,55,141,55,142,61,143,61,144,64,145,64,146,66,147,66,148,65,149,65,150,62,151,62,152,60,153,60,154,59,155,59,156,58,157,58,158,60,159,60,160,64,161,64,162,61,163,61,164,56,165,56,166,54,167,54,168,53,169,53,170,51,171,51,172,46,173,46,174,41,175,41,176,38,177,38,178,38,179,38,180,39,181,39,182,40,183,40,184,37,185,37,186,31,187,31,188,22,189,22,190,11,191,11,192,6,193,6,},[32]={132,8,133,8,134,15,135,15,136,22,137,22,138,38,139,38,140,53,141,53,142,60,143,60,144,63,145,63,146,64,147,64,148,63,149,63,150,58,151,58,152,52,153,52,154,50,155,50,156,49,157,49,158,50,159,50,160,55,161,55,162,59,163,59,164,62,165,62,166,63,167,63,168,64,169,64,170,64,171,64,172,60,173,60,174,52,175,52,176,45,177,45,178,44,179,44,180,44,181,44,182,43,183,43,184,39,185,39,186,32,187,32,188,23,189,23,190,17,191,17,192,6,193,6,},[33]={132,8,133,8,134,15,135,15,136,22,137,22,138,38,139,38,140,53,141,53,142,60,143,60,144,63,145,63,146,64,147,64,148,63,149,63,150,58,151,58,152,52,153,52,154,50,155,50,156,49,157,49,158,50,159,50,160,55,161,55,162,59,163,59,164,62,165,62,166,63,167,63,168,64,169,64,170,64,171,64,172,60,173,60,174,52,175,52,176,45,177,45,178,44,179,44,180,44,181,44,182,43,183,43,184,39,185,39,186,32,187,32,188,23,189,23,190,17,191,17,192,6,193,6,},[34]={132,8,133,8,134,15,135,15,136,21,137,21,138,36,139,36,140,50,141,50,142,56,143,56,144,58,145,58,146,59,147,59,148,58,149,58,150,51,151,51,152,42,153,42,154,39,155,39,156,38,157,38,158,39,159,39,160,45,161,45,162,56,163,56,164,67,165,67,166,71,167,71,168,73,169,73,170,75,171,75,172,75,173,75,174,64,175,64,176,54,177,54,178,52,179,52,180,52,181,52,182,49,183,49,184,42,185,42,186,35,187,35,188,24,189,24,190,18,191,18,192,12,193,12,},[35]={132,8,133,8,134,15,135,15,136,21,137,21,138,36,139,36,140,50,141,50,142,56,143,56,144,58,145,58,146,59,147,59,148,58,149,58,150,51,151,51,152,42,153,42,154,39,155,39,156,38,157,38,158,39,159,39,160,45,161,45,162,56,163,56,164,67,165,67,166,71,167,71,168,73,169,73,170,75,171,75,172,75,173,75,174,64,175,64,176,54,177,54,178,52,179,52,180,52,181,52,182,49,183,49,184,42,185,42,186,35,187,35,188,24,189,24,190,18,191,18,192,12,193,12,},[36]={132,7,133,7,134,14,135,14,136,20,137,20,138,33,139,33,140,45,141,45,142,50,143,50,144,53,145,53,146,53,147,53,148,53,149,53,150,44,151,44,152,35,153,35,154,32,155,32,156,31,157,31,158,32,159,32,160,38,161,38,162,54,163,54,164,68,165,68,166,74,167,74,168,77,169,77,170,83,171,83,172,85,173,85,174,73,175,73,176,64,177,64,178,62,179,62,180,62,181,62,182,56,183,56,184,47,185,47,186,38,187,38,188,27,189,27,190,26,191,26,192,18,193,18,},[37]={132,7,133,7,134,14,135,14,136,20,137,20,138,33,139,33,140,45,141,45,142,50,143,50,144,53,145,53,146,53,147,53,148,53,149,53,150,44,151,44,152,35,153,35,154,32,155,32,156,31,157,31,158,32,159,32,160,38,161,38,162,54,163,54,164,68,165,68,166,74,167,74,168,77,169,77,170,83,171,83,172,85,173,85,174,73,175,73,176,64,177,64,178,62,179,62,180,62,181,62,182,56,183,56,184,47,185,47,186,38,187,38,188,27,189,27,190,26,191,26,192,18,193,18,},[38]={132,7,133,7,134,14,135,14,136,19,137,19,138,31,139,31,140,40,141,40,142,45,143,45,144,48,145,48,146,50,147,50,148,50,149,50,150,42,151,42,152,35,153,35,154,32,155,32,156,30,157,30,158,30,159,30,160,34,161,34,162,49,163,49,164,63,165,63,166,69,167,69,168,73,169,73,170,81,171,81,172,87,173,87,174,79,175,79,176,71,177,71,178,70,179,70,180,70,181,70,182,64,183,64,184,53,185,53,186,43,187,43,188,31,189,31,190,28,191,28,192,24,193,24,},[39]={132,7,133,7,134,14,135,14,136,19,137,19,138,31,139,31,140,40,141,40,142,45,143,45,144,48,145,48,146,50,147,50,148,50,149,50,150,42,151,42,152,35,153,35,154,32,155,32,156,30,157,30,158,30,159,30,160,34,161,34,162,49,163,49,164,63,165,63,166,69,167,69,168,73,169,73,170,81,171,81,172,87,173,87,174,79,175,79,176,71,177,71,178,70,179,70,180,70,181,70,182,64,183,64,184,53,185,53,186,43,187,43,188,31,189,31,190,28,191,28,192,24,193,24,},[40]={132,7,133,7,134,14,135,14,136,19,137,19,138,29,139,29,140,36,141,36,142,39,143,39,144,45,145,45,146,50,147,50,148,51,149,51,150,46,151,46,152,41,153,41,154,39,155,39,156,34,157,34,158,30,159,30,160,31,161,31,162,43,163,43,164,56,165,56,166,63,167,63,168,67,169,67,170,77,171,77,172,86,173,86,174,81,175,81,176,75,177,75,178,75,179,75,180,77,181,77,182,70,183,70,184,60,185,60,186,49,187,49,188,35,189,35,190,29,191,29,192,29,193,29,},[41]={132,7,133,7,134,14,135,14,136,19,137,19,138,29,139,29,140,36,141,36,142,39,143,39,144,45,145,45,146,50,147,50,148,51,149,51,150,46,151,46,152,41,153,41,154,39,155,39,156,34,157,34,158,30,159,30,160,31,161,31,162,43,163,43,164,56,165,56,166,63,167,63,168,67,169,67,170,77,171,77,172,86,173,86,174,81,175,81,176,75,177,75,178,75,179,75,180,77,181,77,182,70,183,70,184,60,185,60,186,49,187,49,188,35,189,35,190,29,191,29,192,29,193,29,},[42]={132,7,133,7,134,14,135,14,136,19,137,19,138,26,139,26,140,31,141,31,142,37,143,37,144,48,145,48,146,56,147,56,148,58,149,58,150,56,151,56,152,53,153,53,154,49,155,49,156,39,157,39,158,31,159,31,160,29,161,29,162,39,163,39,164,50,165,50,166,56,167,56,168,60,169,60,170,71,171,71,172,82,173,82,174,80,175,80,176,77,177,77,178,79,179,79,180,82,181,82,182,76,183,76,184,66,185,66,186,55,187,55,188,41,189,41,190,29,191,29,192,29,193,29,},[43]={132,7,133,7,134,14,135,14,136,19,137,19,138,26,139,26,140,31,141,31,142,37,143,37,144,48,145,48,146,56,147,56,148,58,149,58,150,56,151,56,152,53,153,53,154,49,155,49,156,39,157,39,158,31,159,31,160,29,161,29,162,39,163,39,164,50,165,50,166,56,167,56,168,60,169,60,170,71,171,71,172,82,173,82,174,80,175,80,176,77,177,77,178,79,179,79,180,82,181,82,182,76,183,76,184,66,185,66,186,55,187,55,188,41,189,41,190,29,191,29,192,29,193,29,},[44]={132,7,133,7,134,14,135,14,136,19,137,19,138,24,139,24,140,28,141,28,142,36,143,36,144,52,145,52,146,62,147,62,148,65,149,65,150,65,151,65,152,64,153,64,154,58,155,58,156,43,157,43,158,33,159,33,160,30,161,30,162,36,163,36,164,43,165,43,166,48,167,48,168,52,169,52,170,62,171,62,172,72,173,72,174,74,175,74,176,76,177,76,178,79,179,79,180,83,181,83,182,79,183,79,184,71,185,71,186,61,187,61,188,47,189,47,190,29,191,29,192,13,193,13,},[45]={132,7,133,7,134,14,135,14,136,19,137,19,138,24,139,24,140,28,141,28,142,36,143,36,144,52,145,52,146,62,147,62,148,65,149,65,150,65,151,65,152,64,153,64,154,58,155,58,156,43,157,43,158,33,159,33,160,30,161,30,162,36,163,36,164,43,165,43,166,48,167,48,168,52,169,52,170,62,171,62,172,72,173,72,174,74,175,74,176,76,177,76,178,79,179,79,180,83,181,83,182,79,183,79,184,71,185,71,186,61,187,61,188,47,189,47,190,29,191,29,192,13,193,13,},[46]={132,7,133,7,134,14,135,14,136,19,137,19,138,23,139,23,140,26,141,26,142,37,143,37,144,55,145,55,146,66,147,66,148,70,149,70,150,72,151,72,152,72,153,72,154,63,155,63,156,47,157,47,158,36,159,36,160,33,161,33,162,35,163,35,164,38,165,38,166,42,167,42,168,46,169,46,170,54,171,54,172,62,173,62,174,67,175,67,176,72,177,72,178,78,179,78,180,82,181,82,182,80,183,80,184,75,185,75,186,66,187,66,188,53,189,53,190,36,191,36,192,17,193,17,},[47]={132,7,133,7,134,14,135,14,136,19,137,19,138,23,139,23,140,26,141,26,142,37,143,37,144,55,145,55,146,66,147,66,148,70,149,70,150,72,151,72,152,72,153,72,154,63,155,63,156,47,157,47,158,36,159,36,160,33,161,33,162,35,163,35,164,38,165,38,166,42,167,42,168,46,169,46,170,54,171,54,172,62,173,62,174,67,175,67,176,72,177,72,178,78,179,78,180,82,181,82,182,80,183,80,184,75,185,75,186,66,187,66,188,53,189,53,190,36,191,36,192,17,193,17,},[48]={132,7,133,7,134,14,135,14,136,19,137,19,138,24,139,24,140,27,141,27,142,38,143,38,144,56,145,56,146,69,147,69,148,74,149,74,150,76,151,76,152,77,153,77,154,68,155,68,156,51,157,51,158,40,159,40,160,36,161,36,162,35,163,35,164,37,165,37,166,40,167,40,168,43,169,43,170,50,171,50,172,57,173,57,174,63,175,63,176,69,177,69,178,76,179,76,180,81,181,81,182,82,183,82,184,79,185,79,186,71,187,71,188,58,189,58,190,40,191,40,192,20,193,20,},[49]={132,7,133,7,134,14,135,14,136,19,137,19,138,24,139,24,140,27,141,27,142,38,143,38,144,56,145,56,146,69,147,69,148,74,149,74,150,76,151,76,152,77,153,77,154,68,155,68,156,51,157,51,158,40,159,40,160,36,161,36,162,35,163,35,164,37,165,37,166,40,167,40,168,43,169,43,170,50,171,50,172,57,173,57,174,63,175,63,176,69,177,69,178,76,179,76,180,81,181,81,182,82,183,82,184,79,185,79,186,71,187,71,188,58,189,58,190,40,191,40,192,20,193,20,},[50]={132,7,133,7,134,14,135,14,136,20,137,20,138,24,139,24,140,28,141,28,142,39,143,39,144,58,145,58,146,70,147,70,148,76,149,76,150,79,151,79,152,81,153,81,154,71,155,71,156,53,157,53,158,42,159,42,160,36,161,36,162,34,163,34,164,35,165,35,166,38,167,38,168,44,169,44,170,50,171,50,172,56,173,56,174,62,175,62,176,69,177,69,178,76,179,76,180,82,181,82,182,84,183,84,184,83,185,83,186,75,187,75,188,62,189,62,190,43,191,43,192,22,193,22,},[51]={132,7,133,7,134,14,135,14,136,20,137,20,138,24,139,24,140,28,141,28,142,39,143,39,144,58,145,58,146,70,147,70,148,76,149,76,150,79,151,79,152,81,153,81,154,71,155,71,156,53,157,53,158,42,159,42,160,36,161,36,162,34,163,34,164,35,165,35,166,38,167,38,168,44,169,44,170,50,171,50,172,56,173,56,174,62,175,62,176,69,177,69,178,76,179,76,180,82,181,82,182,84,183,84,184,83,185,83,186,75,187,75,188,62,189,62,190,43,191,43,192,22,193,22,},[52]={132,7,133,7,134,14,135,14,136,21,137,21,138,26,139,26,140,29,141,29,142,42,143,42,144,59,145,59,146,70,147,70,148,79,149,79,150,83,151,83,152,86,153,86,154,75,155,75,156,57,157,57,158,45,159,45,160,38,161,38,162,34,163,34,164,33,165,33,166,37,167,37,168,44,169,44,170,50,171,50,172,57,173,57,174,63,175,63,176,71,177,71,178,78,179,78,180,85,181,85,182,88,183,88,184,86,185,86,186,79,187,79,188,65,189,65,190,46,191,46,192,23,193,23,},[53]={132,7,133,7,134,14,135,14,136,21,137,21,138,26,139,26,140,29,141,29,142,42,143,42,144,59,145,59,146,70,147,70,148,79,149,79,150,83,151,83,152,86,153,86,154,75,155,75,156,57,157,57,158,45,159,45,160,38,161,38,162,34,163,34,164,33,165,33,166,37,167,37,168,44,169,44,170,50,171,50,172,57,173,57,174,63,175,63,176,71,177,71,178,78,179,78,180,85,181,85,182,88,183,88,184,86,185,86,186,79,187,79,188,65,189,65,190,46,191,46,192,23,193,23,},[54]={132,8,133,8,134,15,135,15,136,22,137,22,138,27,139,27,140,32,141,32,142,43,143,43,144,55,145,55,146,66,147,66,148,77,149,77,150,83,151,83,152,86,153,86,154,76,155,76,156,63,157,63,158,52,159,52,160,41,161,41,162,35,163,35,164,30,165,30,166,34,167,34,168,44,169,44,170,54,171,54,172,62,173,62,174,71,175,71,176,80,177,80,178,89,179,89,180,93,181,93,182,92,183,92,184,90,185,90,186,82,187,82,188,68,189,68,190,48,191,48,192,24,193,24,},[55]={132,8,133,8,134,15,135,15,136,22,137,22,138,27,139,27,140,32,141,32,142,43,143,43,144,55,145,55,146,66,147,66,148,77,149,77,150,83,151,83,152,86,153,86,154,76,155,76,156,63,157,63,158,52,159,52,160,41,161,41,162,35,163,35,164,30,165,30,166,34,167,34,168,44,169,44,170,54,171,54,172,62,173,62,174,71,175,71,176,80,177,80,178,89,179,89,180,93,181,93,182,92,183,92,184,90,185,90,186,82,187,82,188,68,189,68,190,48,191,48,192,24,193,24,},[56]={132,8,133,8,134,16,135,16,136,24,137,24,138,30,139,30,140,36,141,36,142,45,143,45,144,52,145,52,146,64,147,64,148,75,149,75,150,82,151,82,152,86,153,86,154,79,155,79,156,71,157,71,158,59,159,59,160,47,161,47,162,38,163,38,164,30,165,30,166,30,167,30,168,41,169,41,170,55,171,55,172,66,173,66,174,76,175,76,176,87,177,87,178,99,179,99,180,101,181,101,182,96,183,96,184,92,185,92,186,84,187,84,188,70,189,70,190,49,191,49,192,24,193,24,},[57]={132,8,133,8,134,16,135,16,136,24,137,24,138,30,139,30,140,36,141,36,142,45,143,45,144,52,145,52,146,64,147,64,148,75,149,75,150,82,151,82,152,86,153,86,154,79,155,79,156,71,157,71,158,59,159,59,160,47,161,47,162,38,163,38,164,30,165,30,166,30,167,30,168,41,169,41,170,55,171,55,172,66,173,66,174,76,175,76,176,87,177,87,178,99,179,99,180,101,181,101,182,96,183,96,184,92,185,92,186,84,187,84,188,70,189,70,190,49,191,49,192,24,193,24,},[58]={132,9,133,9,134,18,135,18,136,28,137,28,138,37,139,37,140,44,141,44,142,49,143,49,144,54,145,54,146,65,147,65,148,77,149,77,150,85,151,85,152,92,153,92,154,90,155,90,156,84,157,84,158,73,159,73,160,58,161,58,162,44,163,44,164,31,165,31,166,27,167,27,168,39,169,39,170,54,171,54,172,65,173,65,174,76,175,76,176,88,177,88,178,102,179,102,180,103,181,103,182,96,183,96,184,91,185,91,186,84,187,84,188,70,189,70,190,49,191,49,192,24,193,24,},[59]={132,9,133,9,134,18,135,18,136,28,137,28,138,37,139,37,140,44,141,44,142,49,143,49,144,54,145,54,146,65,147,65,148,77,149,77,150,85,151,85,152,92,153,92,154,90,155,90,156,84,157,84,158,73,159,73,160,58,161,58,162,44,163,44,164,31,165,31,166,27,167,27,168,39,169,39,170,54,171,54,172,65,173,65,174,76,175,76,176,88,177,88,178,102,179,102,180,103,181,103,182,96,183,96,184,91,185,91,186,84,187,84,188,70,189,70,190,49,191,49,192,24,193,24,},[60]={132,7,133,7,134,14,135,14,136,26,137,26,138,38,139,38,140,43,141,43,142,44,143,44,144,49,145,49,146,61,147,61,148,71,149,71,150,77,151,77,152,86,153,86,154,90,155,90,156,88,157,88,158,79,159,79,160,64,161,64,162,48,163,48,164,34,165,34,166,27,167,27,168,37,169,37,170,52,171,52,172,62,173,62,174,73,175,73,176,85,177,85,178,100,179,100,180,100,181,100,182,93,183,93,184,88,185,88,186,81,187,81,188,67,189,67,190,47,191,47,192,23,193,23,},[61]={132,7,133,7,134,14,135,14,136,26,137,26,138,38,139,38,140,43,141,43,142,44,143,44,144,49,145,49,146,61,147,61,148,71,149,71,150,77,151,77,152,86,153,86,154,90,155,90,156,88,157,88,158,79,159,79,160,64,161,64,162,48,163,48,164,34,165,34,166,27,167,27,168,37,169,37,170,52,171,52,172,62,173,62,174,73,175,73,176,85,177,85,178,100,179,100,180,100,181,100,182,93,183,93,184,88,185,88,186,81,187,81,188,67,189,67,190,47,191,47,192,23,193,23,},[62]={132,4,133,4,134,8,135,8,136,20,137,20,138,32,139,32,140,35,141,35,142,33,143,33,144,39,145,39,146,55,147,55,148,62,149,62,150,65,151,65,152,74,153,74,154,84,155,84,156,88,157,88,158,81,159,81,160,66,161,66,162,52,163,52,164,39,165,39,166,30,167,30,168,37,169,37,170,52,171,52,172,63,173,63,174,73,175,73,176,84,177,84,178,98,179,98,180,97,181,97,182,88,183,88,184,82,185,82,186,75,187,75,188,62,189,62,190,44,191,44,192,22,193,22,},[63]={132,4,133,4,134,8,135,8,136,20,137,20,138,32,139,32,140,35,141,35,142,33,143,33,144,39,145,39,146,55,147,55,148,62,149,62,150,65,151,65,152,74,153,74,154,84,155,84,156,88,157,88,158,81,159,81,160,66,161,66,162,52,163,52,164,39,165,39,166,30,167,30,168,37,169,37,170,52,171,52,172,63,173,63,174,73,175,73,176,84,177,84,178,98,179,98,180,97,181,97,182,88,183,88,184,82,185,82,186,75,187,75,188,62,189,62,190,44,191,44,192,22,193,22,},[64]={132,2,133,2,134,4,135,4,136,15,137,15,138,28,139,28,140,28,141,28,142,25,143,25,144,34,145,34,146,50,147,50,148,54,149,54,150,53,151,53,152,63,153,63,154,76,155,76,156,84,157,84,158,79,159,79,160,68,161,68,162,57,163,57,164,45,165,45,166,33,167,33,168,37,169,37,170,51,171,51,172,62,173,62,174,71,175,71,176,81,177,81,178,93,179,93,180,91,181,91,182,80,183,80,184,73,185,73,186,67,187,67,188,55,189,55,190,39,191,39,192,19,193,19,},[65]={132,2,133,2,134,4,135,4,136,15,137,15,138,28,139,28,140,28,141,28,142,25,143,25,144,34,145,34,146,50,147,50,148,54,149,54,150,53,151,53,152,63,153,63,154,76,155,76,156,84,157,84,158,79,159,79,160,68,161,68,162,57,163,57,164,45,165,45,166,33,167,33,168,37,169,37,170,51,171,51,172,62,173,62,174,71,175,71,176,81,177,81,178,93,179,93,180,91,181,91,182,80,183,80,184,73,185,73,186,67,187,67,188,55,189,55,190,39,191,39,192,19,193,19,},[66]={132,2,133,2,134,3,135,3,136,16,137,16,138,30,139,30,140,29,141,29,142,24,143,24,144,35,145,35,146,49,147,49,148,51,149,51,150,48,151,48,152,57,153,57,154,72,155,72,156,80,157,80,158,78,159,78,160,70,161,70,162,61,163,61,164,50,165,50,166,37,167,37,168,38,169,38,170,47,171,47,172,55,173,55,174,61,175,61,176,67,177,67,178,77,179,77,180,77,181,77,182,68,183,68,184,62,185,62,186,56,187,56,188,47,189,47,190,33,191,33,192,16,193,16,},[67]={132,2,133,2,134,3,135,3,136,16,137,16,138,30,139,30,140,29,141,29,142,24,143,24,144,35,145,35,146,49,147,49,148,51,149,51,150,48,151,48,152,57,153,57,154,72,155,72,156,80,157,80,158,78,159,78,160,70,161,70,162,61,163,61,164,50,165,50,166,37,167,37,168,38,169,38,170,47,171,47,172,55,173,55,174,61,175,61,176,67,177,67,178,77,179,77,180,77,181,77,182,68,183,68,184,62,185,62,186,56,187,56,188,47,189,47,190,33,191,33,192,16,193,16,},[68]={132,2,133,2,134,4,135,4,136,18,137,18,138,32,139,32,140,30,141,30,142,25,143,25,144,35,145,35,146,48,147,48,148,48,149,48,150,44,151,44,152,52,153,52,154,67,155,67,156,75,157,75,158,74,159,74,160,68,161,68,162,61,163,61,164,52,165,52,166,42,167,42,168,40,169,40,170,44,171,44,172,48,173,48,174,50,175,50,176,53,177,53,178,59,179,59,180,59,181,59,182,54,183,54,184,50,185,50,186,45,187,45,188,37,189,37,190,26,191,26,192,13,193,13,},[69]={132,2,133,2,134,4,135,4,136,18,137,18,138,32,139,32,140,30,141,30,142,25,143,25,144,35,145,35,146,48,147,48,148,48,149,48,150,44,151,44,152,52,153,52,154,67,155,67,156,75,157,75,158,74,159,74,160,68,161,68,162,61,163,61,164,52,165,52,166,42,167,42,168,40,169,40,170,44,171,44,172,48,173,48,174,50,175,50,176,53,177,53,178,59,179,59,180,59,181,59,182,54,183,54,184,50,185,50,186,45,187,45,188,37,189,37,190,26,191,26,192,13,193,13,},[70]={132,2,133,2,134,4,135,4,136,15,137,15,138,27,139,27,140,25,141,25,142,20,143,20,144,31,145,31,146,43,147,43,148,43,149,43,150,37,151,37,152,42,153,42,154,54,155,54,156,61,157,61,158,60,159,60,160,56,161,56,162,54,163,54,164,50,165,50,166,42,167,42,168,39,169,39,170,41,171,41,172,42,173,42,174,42,175,42,176,42,177,42,178,45,179,45,180,45,181,45,182,41,183,41,184,37,185,37,186,34,187,34,188,28,189,28,190,19,191,19,192,9,193,9,},[71]={132,2,133,2,134,4,135,4,136,15,137,15,138,27,139,27,140,25,141,25,142,20,143,20,144,31,145,31,146,43,147,43,148,43,149,43,150,37,151,37,152,42,153,42,154,54,155,54,156,61,157,61,158,60,159,60,160,56,161,56,162,54,163,54,164,50,165,50,166,42,167,42,168,39,169,39,170,41,171,41,172,42,173,42,174,42,175,42,176,42,177,42,178,45,179,45,180,45,181,45,182,41,183,41,184,37,185,37,186,34,187,34,188,28,189,28,190,19,191,19,192,9,193,9,},[72]={132,3,133,3,134,6,135,6,136,15,137,15,138,23,139,23,140,23,141,23,142,21,143,21,144,31,145,31,146,41,147,41,148,42,149,42,150,38,151,38,152,40,153,40,154,47,155,47,156,49,157,49,158,48,159,48,160,45,161,45,162,44,163,44,164,42,165,42,166,37,167,37,168,34,169,34,170,35,171,35,172,36,173,36,174,35,175,35,176,34,177,34,178,34,179,34,180,34,181,34,182,30,183,30,184,26,185,26,186,23,187,23,188,19,189,19,190,13,191,13,192,6,193,6,},[73]={132,3,133,3,134,6,135,6,136,15,137,15,138,23,139,23,140,23,141,23,142,21,143,21,144,31,145,31,146,41,147,41,148,42,149,42,150,38,151,38,152,40,153,40,154,47,155,47,156,49,157,49,158,48,159,48,160,45,161,45,162,44,163,44,164,42,165,42,166,37,167,37,168,34,169,34,170,35,171,35,172,36,173,36,174,35,175,35,176,34,177,34,178,34,179,34,180,34,181,34,182,30,183,30,184,26,185,26,186,23,187,23,188,19,189,19,190,13,191,13,192,6,193,6,},[74]={132,5,133,5,134,9,135,9,136,16,137,16,138,21,139,21,140,22,141,22,142,23,143,23,144,30,145,30,146,36,147,36,148,37,149,37,150,35,151,35,152,37,153,37,154,38,155,38,156,38,157,38,158,36,159,36,160,34,161,34,162,33,163,33,164,30,165,30,166,27,167,27,168,25,169,25,170,25,171,25,172,24,173,24,174,23,175,23,176,22,177,22,178,21,179,21,180,21,181,21,182,18,183,18,184,16,185,16,186,14,187,14,188,11,189,11,190,7,191,7,192,3,193,3,},[75]={132,5,133,5,134,9,135,9,136,16,137,16,138,21,139,21,140,22,141,22,142,23,143,23,144,30,145,30,146,36,147,36,148,37,149,37,150,35,151,35,152,37,153,37,154,38,155,38,156,38,157,38,158,36,159,36,160,34,161,34,162,33,163,33,164,30,165,30,166,27,167,27,168,25,169,25,170,25,171,25,172,24,173,24,174,23,175,23,176,22,177,22,178,21,179,21,180,21,181,21,182,18,183,18,184,16,185,16,186,14,187,14,188,11,189,11,190,7,191,7,192,3,193,3,},[76]={132,4,133,4,134,8,135,8,136,11,137,11,138,14,139,14,140,16,141,16,142,16,143,16,144,19,145,19,146,21,147,21,148,23,149,23,150,23,151,23,152,23,153,23,154,22,155,22,156,22,157,22,158,20,159,20,160,19,161,19,162,17,163,17,164,16,165,16,166,14,167,14,168,12,169,12,170,12,171,12,172,11,173,11,174,11,175,11,176,10,177,10,178,9,179,9,180,9,181,9,182,8,183,8,184,7,185,7,186,6,187,6,188,5,189,5,190,3,191,3,192,1,193,1,},[77]={132,4,133,4,134,8,135,8,136,11,137,11,138,14,139,14,140,16,141,16,142,16,143,16,144,19,145,19,146,21,147,21,148,23,149,23,150,23,151,23,152,23,153,23,154,22,155,22,156,22,157,22,158,20,159,20,160,19,161,19,162,17,163,17,164,16,165,16,166,14,167,14,168,12,169,12,170,12,171,12,172,11,173,11,174,11,175,11,176,10,177,10,178,9,179,9,180,9,181,9,182,8,183,8,184,7,185,7,186,6,187,6,188,5,189,5,190,3,191,3,192,1,193,1,}
		},
		
		objects ={},
		markers ={},
		
		shaman_positions = {
			52, 158, 52, 164, 38, 164, 38, 158, 42, 154, 48, 154, 48, 168, 42, 168
		},
		
		scripts = {
			OnTurn = function(everySecond1, everySecond2, everySecond4) 			disco_floor_on_turn(everySecond1, everySecond2, everySecond4) end,
			OnFrame = function(ghover) 												return DF_on_frame(ghover) end,
			-- OnCreateThing = function(t, owner, type, model) 						quake_on_create_thing(t, owner, type, model) end,
			OnHumanDisconnect = function(player) 									DF_init_single_AI(player) end,
		},
		
	},
	
	[MAP_JUMPERS]={
	
		info = 	{ 	name = "Jumpers", author = "Divinity",
					desc = "Shamans must battle in a fast paced island-hopping war! <br> There are 9 islands players can jump to, and killing enemy shamans will grant 1 point. <p> Spells: <br> - Blast: massive range <br> - lightning: small range <br> - Teleport: teleports to target location after 1 second <p> PowerUps: <br> - Shield: grants shield for 12 seconds <br> - Tornado: grants 1 shot of a long range tornado",
					map_objectives = { {value=5, step=1, default=true}, {value=25, step=5, default=false}, {} },
					image = 2912, texture={22, 0}, zoom={152,82,256}, drop_infos = true,	marker_lb={74, 204}, reinc_timer=12*2, shield_respawn=false,
					-- custom_rules = {
						-- { default = false, 	name = "use boats", desc = "Why not play the mini game using boats instead? It's chaotic!" },
					-- }
				},

		land ={
			[142]={92,96,93,96,94,96,95,96,96,96,97,96,98,96,99,96,},[143]={92,96,93,96,94,96,95,96,96,96,97,96,98,96,99,96,},[144]={92,96,93,96,94,132,95,132,96,132,97,132,98,96,99,96,},[145]={92,96,93,96,94,132,95,132,96,132,97,132,98,96,99,96,},[146]={92,96,93,96,94,132,95,132,96,132,97,132,98,96,99,96,},[147]={92,96,93,96,94,132,95,132,96,132,97,132,98,96,99,96,},[148]={92,96,93,96,94,96,95,96,96,96,97,96,98,96,99,96,},[149]={92,96,93,96,94,96,95,96,96,96,97,96,98,96,99,96,},[154]={124,96,125,96,126,96,127,96,128,96,129,96,130,96,131,96,},[155]={124,96,125,96,126,96,127,96,128,96,129,96,130,96,131,96,},[156]={124,96,125,96,126,132,127,132,128,132,129,132,130,96,131,96,},[157]={124,96,125,96,126,132,127,132,128,132,129,132,130,96,131,96,},[158]={124,96,125,96,126,132,127,132,128,132,129,132,130,96,131,96,},[159]={124,96,125,96,126,132,127,132,128,132,129,132,130,96,131,96,},[160]={124,96,125,96,126,96,127,96,128,96,129,96,130,96,131,96,},[161]={124,96,125,96,126,96,127,96,128,96,129,96,130,96,131,96,},[162]={68,96,69,96,70,96,71,96,72,96,73,96,74,96,75,96,},[163]={68,96,69,96,70,96,71,96,72,96,73,96,74,96,75,96,},[164]={68,96,69,96,70,132,71,132,72,132,73,132,74,96,75,96,},[165]={68,96,69,96,70,132,71,132,72,132,73,132,74,96,75,96,},[166]={68,96,69,96,70,132,71,132,72,132,73,132,74,96,75,96,},[167]={68,96,69,96,70,132,71,132,72,132,73,132,74,96,75,96,},[168]={68,96,69,96,70,96,71,96,72,96,73,96,74,96,75,96,},[169]={68,96,69,96,70,96,71,96,72,96,73,96,74,96,75,96,},[174]={46,96,47,96,48,96,49,96,50,96,51,96,52,96,53,96,},[175]={46,96,47,96,48,96,49,96,50,96,51,96,52,96,53,96,},[176]={46,96,47,96,48,132,49,132,50,132,51,132,52,96,53,96,},[177]={46,96,47,96,48,132,49,132,50,132,51,132,52,96,53,96,},[178]={46,96,47,96,48,132,49,132,50,132,51,132,52,96,53,96,},[179]={46,96,47,96,48,132,49,132,50,132,51,132,52,96,53,96,},[180]={46,96,47,96,48,96,49,96,50,96,51,96,52,96,53,96,98,96,99,96,100,96,101,96,102,96,103,96,104,96,105,96,136,96,137,96,138,96,139,96,140,96,141,96,142,96,143,96,},[181]={46,96,47,96,48,96,49,96,50,96,51,96,52,96,53,96,98,96,99,96,100,96,101,96,102,96,103,96,104,96,105,96,136,96,137,96,138,96,139,96,140,96,141,96,142,96,143,96,},[182]={98,96,99,96,100,132,101,132,102,132,103,132,104,96,105,96,136,96,137,96,138,132,139,132,140,132,141,132,142,96,143,96,},[183]={98,96,99,96,100,132,101,132,102,132,103,132,104,96,105,96,136,96,137,96,138,132,139,132,140,132,141,132,142,96,143,96,},[184]={98,96,99,96,100,132,101,132,102,132,103,132,104,96,105,96,136,96,137,96,138,132,139,132,140,132,141,132,142,96,143,96,},[185]={98,96,99,96,100,132,101,132,102,132,103,132,104,96,105,96,136,96,137,96,138,132,139,132,140,132,141,132,142,96,143,96,},[186]={98,96,99,96,100,96,101,96,102,96,103,96,104,96,105,96,136,96,137,96,138,96,139,96,140,96,141,96,142,96,143,96,},[187]={98,96,99,96,100,96,101,96,102,96,103,96,104,96,105,96,136,96,137,96,138,96,139,96,140,96,141,96,142,96,143,96,},[200]={66,96,67,96,68,96,69,96,70,96,71,96,72,96,73,96,},[201]={66,96,67,96,68,96,69,96,70,96,71,96,72,96,73,96,},[202]={66,96,67,96,68,132,69,132,70,132,71,132,72,96,73,96,},[203]={66,96,67,96,68,132,69,132,70,132,71,132,72,96,73,96,},[204]={66,96,67,96,68,132,69,132,70,132,71,132,72,96,73,96,116,96,117,96,118,96,119,96,120,96,121,96,122,96,123,96,},[205]={66,96,67,96,68,132,69,132,70,132,71,132,72,96,73,96,116,96,117,96,118,96,119,96,120,96,121,96,122,96,123,96,},[206]={66,96,67,96,68,96,69,96,70,96,71,96,72,96,73,96,116,96,117,96,118,132,119,132,120,132,121,132,122,96,123,96,},[207]={66,96,67,96,68,96,69,96,70,96,71,96,72,96,73,96,116,96,117,96,118,132,119,132,120,132,121,132,122,96,123,96,},[208]={116,96,117,96,118,132,119,132,120,132,121,132,122,96,123,96,},[209]={116,96,117,96,118,132,119,132,120,132,121,132,122,96,123,96,},[210]={116,96,117,96,118,96,119,96,120,96,121,96,122,96,123,96,},[211]={116,96,117,96,118,96,119,96,120,96,121,96,122,96,123,96,},[224]={90,96,91,96,92,96,93,96,94,96,95,96,96,96,97,96,},[225]={90,96,91,96,92,96,93,96,94,96,95,96,96,96,97,96,},[226]={90,96,91,96,92,132,93,132,94,132,95,132,96,96,97,96,},[227]={90,96,91,96,92,132,93,132,94,132,95,132,96,96,97,96,},[228]={90,96,91,96,92,132,93,132,94,132,95,132,96,96,97,96,},[229]={90,96,91,96,92,132,93,132,94,132,95,132,96,96,97,96,},[230]={90,96,91,96,92,96,93,96,94,96,95,96,96,96,97,96,},[231]={90,96,91,96,92,96,93,96,94,96,95,96,96,96,97,96,}
		},
		
		objects ={
			[140]={96,5,7,-1,0,},[142]={104,7,79,-1,0,},[144]={82,7,79,-1,0,},[146]={92,7,84,-1,0,98,5,7,-1,0,},[152]={86,7,79,-1,0,},[158]={126,5,7,-1,0,128,5,7,-1,0,},[160]={74,5,7,-1,0,126,7,84,-1,0,},[164]={70,5,7,-1,0,},[166]={106,7,79,-1,0,130,7,85,-1,0,},[168]={128,7,85,-1,0,132,7,85,-1,0,134,7,85,-1,0,},[172]={132,7,85,-1,0,},[174]={46,5,7,-1,0,96,7,85,-1,0,110,7,85,-1,0,},[176]={68,7,79,-1,0,94,7,85,-1,0,96,7,85,-1,0,},[178]={48,5,7,-1,0,98,7,84,-1,0,104,5,7,-1,0,106,7,85,-1,0,138,7,85,-1,0,},[180]={68,7,79,-1,0,96,7,84,-1,0,104,7,85,-1,0,108,7,85,-1,0,136,5,7,-1,0,},[182]={78,7,79,-1,0,96,5,7,-1,0,},[184]={102,5,7,-1,0,},[186]={50,7,79,-1,0,98,5,8,-1,0,110,7,79,-1,0,},[198]={64,7,84,-1,0,66,7,84,-1,0,},[202]={68,5,7,-1,0,},[204]={66,7,84,-1,0,68,5,7,-1,0,70,7,85,-1,0,116,5,7,-1,0,118,7,84,-1,0,},[206]={70,7,85,-1,0,72,7,85,-1,0,118,5,7,-1,0,},[208]={74,7,85,-1,0,90,7,79,-1,0,},[212]={88,7,85,-1,0,90,7,85,-1,0,},[214]={86,7,85,-1,0,},[216]={90,7,85,-1,0,},[220]={70,7,79,-1,0,},[222]={92,7,85,-1,0,},[224]={76,7,79,-1,0,90,7,85,-1,0,94,7,85,-1,0,},[228]={90,5,7,-1,0,}
		},
		
		markers ={
			182, 100, 156, 126, 144, 94, 164, 70, 176, 48, 202, 68, 226, 92, 206, 118, 182, 138
		},
		
		decorations ={
			204, 120, 5,0, 200, 66,5,0, 154, 122,5,0, 154, 124,5,0, 156, 124,5,0
		},
		
		shaman_positions = {
			156, 126, 144, 94, 164, 70, 176, 48, 202, 68, 226, 92, 206, 118, 182, 138
		},
		
		scripts = {
			OnTurn = function(everySecond1, everySecond2, everySecond4) 			jumpers_on_turn(everySecond1, everySecond2, everySecond4) end,
			OnCreateThing = function(t, owner, type, model) 						jumpers_on_create_thing(t, owner, type, model) end,
			OnShamanDeath = function(victim, killer, killer_was_ally)				JU_on_shaman_dead(victim, killer, killer_was_ally) end,
			OnHumanDisconnect = function(player) 									JU_init_single_AI(player) end,
		},
		
	},

	[MAP_PAINTBALL]={
	
		info = 	{ 	name = "Paintball", author = "Divinity",
					desc = "Shamans fire their paint guns to hit enemy players. Each successful hit awards 1 point, and eliminating a target awards 3 points. <br> Shamans can fast-cast and start with 2000 HP. Each time they are hit, they lose 500 HP. Health does not regenerate. <p> Power-Ups: <br> - Shield: Blocks all damage for 12 seconds. <br> - Boots: Increases movement speed for 12 seconds. <br> - Vaccine: Restores 500 HP. <br> - Bucket: Paintballs deal 1000 damage instead of 500 for 20 seconds. <br> - Triple Gun: Shoots 3 paintballs instead of 1 (the first shot is always accurate). Lasts 15 seconds. <br> - Paint Bomb: Launches one bomb toward each enemy, dealing 500 hp and removing any buff they might have.",
					map_objectives = { {value=5, step=1, default=true}, {value=150, limit=500, step=25, default=false}, {} },
					image = 3056, texture={11, 0}, zoom={80,160,256}, drop_infos = false, marker_lb={4, 26}, reinc_timer=12*1, shield_respawn=false,
					custom_rules = {
						{ default = false, 	name = "Thrust Guns", desc = "Paintballs start slow, but rapidily accelerate. Paintballs also deal double damage (1000)." },
						{ default = false, 	name = "Forest", desc = "Trees randomize their sizes, and can be taller than normal." },
					}
				},

		land ={
			[28]={162,12,163,12,164,18,165,18,166,18,167,18,168,6,169,6,},[29]={162,12,163,12,164,18,165,18,166,18,167,18,168,6,169,6,},[30]={162,18,163,18,164,81,165,81,166,87,167,87,168,75,169,75,170,12,171,12,},[31]={162,18,163,18,164,81,165,81,166,87,167,87,168,75,169,75,170,12,171,12,},[32]={162,18,163,18,164,120,165,120,166,139,167,139,168,139,169,139,170,55,171,55,172,30,173,30,},[33]={162,18,163,18,164,120,165,120,166,139,167,139,168,139,169,139,170,55,171,55,172,30,173,30,},[34]={162,24,163,24,164,143,165,143,166,143,167,143,168,143,169,143,170,111,171,111,172,42,173,42,},[35]={162,24,163,24,164,143,165,143,166,143,167,143,168,143,169,143,170,111,171,111,172,42,173,42,},[36]={164,90,165,90,166,182,167,182,168,221,169,221,170,208,171,208,172,101,173,101,174,21,175,21,},[37]={164,90,165,90,166,182,167,182,168,221,169,221,170,208,171,208,172,101,173,101,174,21,175,21,},[38]={164,21,165,21,166,149,167,149,168,221,169,221,170,221,171,221,172,151,173,151,174,69,175,69,176,6,177,6,},[39]={164,21,165,21,166,149,167,149,168,221,169,221,170,221,171,221,172,151,173,151,174,69,175,69,176,6,177,6,},[40]={166,84,167,84,168,229,169,229,170,247,171,247,172,182,173,182,174,134,175,134,176,82,177,82,178,9,179,9,},[41]={166,84,167,84,168,229,169,229,170,247,171,247,172,182,173,182,174,134,175,134,176,82,177,82,178,9,179,9,},[42]={166,48,167,48,168,152,169,152,170,242,171,242,172,296,173,296,174,197,175,197,176,125,177,125,178,33,179,33,},[43]={166,48,167,48,168,152,169,152,170,242,171,242,172,296,173,296,174,197,175,197,176,125,177,125,178,33,179,33,},[44]={166,1,167,1,168,54,169,54,170,242,171,242,172,305,173,305,174,246,175,246,176,183,177,183,178,39,179,39,180,9,181,9,},[45]={166,1,167,1,168,54,169,54,170,242,171,242,172,305,173,305,174,246,175,246,176,183,177,183,178,39,179,39,180,9,181,9,},[46]={166,1,167,1,168,54,169,54,170,221,171,221,172,284,173,284,174,320,175,320,176,327,177,327,178,143,179,143,180,30,181,30,182,9,183,9,},[47]={166,1,167,1,168,54,169,54,170,221,171,221,172,284,173,284,174,320,175,320,176,327,177,327,178,143,179,143,180,30,181,30,182,9,183,9,},[48]={166,42,167,42,168,171,169,171,170,297,171,297,172,317,173,317,174,351,175,351,176,401,177,401,178,235,179,235,180,21,181,21,182,15,183,15,184,6,185,6,186,15,187,15,188,9,189,9,},[49]={166,42,167,42,168,171,169,171,170,297,171,297,172,317,173,317,174,351,175,351,176,401,177,401,178,235,179,235,180,21,181,21,182,15,183,15,184,6,185,6,186,15,187,15,188,9,189,9,},[50]={166,114,167,114,168,219,169,219,170,319,171,319,172,373,173,373,174,373,175,373,176,374,177,374,178,318,179,318,180,284,181,284,182,223,183,223,184,87,185,87,186,87,187,87,188,54,189,54,190,30,191,30,192,18,193,18,},[51]={166,114,167,114,168,219,169,219,170,319,171,319,172,373,173,373,174,373,175,373,176,374,177,374,178,318,179,318,180,284,181,284,182,223,183,223,184,87,185,87,186,87,187,87,188,54,189,54,190,30,191,30,192,18,193,18,},[52]={166,108,167,108,168,236,169,236,170,391,171,391,172,382,173,382,174,472,175,472,176,450,177,450,178,376,179,376,180,442,181,442,182,383,183,383,184,267,185,267,186,174,187,174,188,75,189,75,190,60,191,60,192,48,193,48,194,6,195,6,},[53]={166,108,167,108,168,236,169,236,170,391,171,391,172,382,173,382,174,472,175,472,176,450,177,450,178,376,179,376,180,442,181,442,182,383,183,383,184,267,185,267,186,174,187,174,188,75,189,75,190,60,191,60,192,48,193,48,194,6,195,6,},[54]={168,208,169,208,170,371,171,371,172,456,173,456,174,511,175,511,176,547,177,547,178,472,179,472,180,464,181,464,182,459,183,459,184,387,185,387,186,297,187,297,188,117,189,117,190,109,191,109,192,109,193,109,194,42,195,42,196,12,197,12,},[55]={168,208,169,208,170,371,171,371,172,456,173,456,174,511,175,511,176,547,177,547,178,472,179,472,180,464,181,464,182,459,183,459,184,387,185,387,186,297,187,297,188,117,189,117,190,109,191,109,192,109,193,109,194,42,195,42,196,12,197,12,},[56]={168,225,169,225,170,367,171,367,172,453,173,453,174,528,175,528,176,528,177,528,178,472,179,472,180,437,181,437,182,366,183,366,184,342,185,342,186,279,187,279,188,228,189,228,190,236,191,236,192,236,193,236,194,98,195,98,196,48,197,48,},[57]={168,225,169,225,170,367,171,367,172,453,173,453,174,528,175,528,176,528,177,528,178,472,179,472,180,437,181,437,182,366,183,366,184,342,185,342,186,279,187,279,188,228,189,228,190,236,191,236,192,236,193,236,194,98,195,98,196,48,197,48,},[58]={168,268,169,268,170,344,171,344,172,456,173,456,174,519,175,519,176,465,177,465,178,418,179,418,180,399,181,399,182,357,183,357,184,293,185,293,186,243,187,243,188,234,189,234,190,254,191,254,192,254,193,254,194,189,195,189,196,144,197,144,},[59]={168,268,169,268,170,344,171,344,172,456,173,456,174,519,175,519,176,465,177,465,178,418,179,418,180,399,181,399,182,357,183,357,184,293,185,293,186,243,187,243,188,234,189,234,190,254,191,254,192,254,193,254,194,189,195,189,196,144,197,144,},[60]={166,39,167,39,168,221,169,221,170,348,171,348,172,366,173,366,174,368,175,368,176,393,177,393,178,336,179,336,180,271,181,271,182,199,183,199,184,126,185,126,186,103,187,103,188,202,189,202,190,189,191,189,192,189,193,189,194,189,195,189,196,170,197,170,198,79,199,79,},[61]={166,39,167,39,168,221,169,221,170,348,171,348,172,366,173,366,174,368,175,368,176,393,177,393,178,336,179,336,180,271,181,271,182,199,183,199,184,126,185,126,186,103,187,103,188,202,189,202,190,189,191,189,192,189,193,189,194,189,195,189,196,170,197,170,198,79,199,79,},[62]={140,18,141,18,164,136,165,136,166,290,167,290,168,299,169,299,170,299,171,299,172,235,173,235,174,208,175,208,176,310,177,310,178,328,179,328,180,75,181,75,182,37,183,37,184,36,185,36,186,166,187,166,188,189,189,189,190,189,191,189,192,189,193,189,194,189,195,189,196,221,197,221,198,145,199,145,},[63]={140,18,141,18,164,136,165,136,166,290,167,290,168,299,169,299,170,299,171,299,172,235,173,235,174,208,175,208,176,310,177,310,178,328,179,328,180,75,181,75,182,37,183,37,184,36,185,36,186,166,187,166,188,189,189,189,190,189,191,189,192,189,193,189,194,189,195,189,196,221,197,221,198,145,199,145,},[64]={140,1,141,1,162,140,163,140,164,256,165,256,166,326,167,326,168,326,169,326,170,299,171,299,172,210,173,210,174,169,175,169,176,227,177,227,178,168,179,168,180,39,181,39,182,1,183,1,184,18,185,18,186,159,187,159,188,172,189,172,190,189,191,189,192,221,193,221,194,221,195,221,196,221,197,221,198,131,199,131,},[65]={140,1,141,1,162,140,163,140,164,256,165,256,166,326,167,326,168,326,169,326,170,299,171,299,172,210,173,210,174,169,175,169,176,227,177,227,178,168,179,168,180,39,181,39,182,1,183,1,184,18,185,18,186,159,187,159,188,172,189,172,190,189,191,189,192,221,193,221,194,221,195,221,196,221,197,221,198,131,199,131,},[66]={134,62,135,62,136,71,137,71,138,49,139,49,140,1,141,1,162,191,163,191,164,341,165,341,166,371,167,371,168,299,169,299,170,218,171,218,172,121,173,121,174,24,175,24,176,18,177,18,178,12,179,12,186,81,187,81,188,120,189,120,190,208,191,208,192,221,193,221,194,221,195,221,196,221,197,221,198,181,199,181,},[67]={134,62,135,62,136,71,137,71,138,49,139,49,140,1,141,1,162,191,163,191,164,341,165,341,166,371,167,371,168,299,169,299,170,218,171,218,172,121,173,121,174,24,175,24,176,18,177,18,178,12,179,12,186,81,187,81,188,120,189,120,190,208,191,208,192,221,193,221,194,221,195,221,196,221,197,221,198,181,199,181,},[68]={126,79,127,79,128,145,129,145,130,131,131,131,132,181,133,181,134,134,135,134,136,98,137,98,138,124,139,124,140,54,141,54,160,169,161,169,162,241,163,241,164,304,165,304,166,304,167,304,168,147,169,147,170,135,171,135,172,90,173,90,174,1,175,1,186,68,187,68,188,172,189,172,190,208,191,208,192,221,193,221,194,221,195,221,196,194,197,194,198,134,199,134,200,62,201,62,},[69]={126,79,127,79,128,145,129,145,130,131,131,131,132,181,133,181,134,134,135,134,136,98,137,98,138,124,139,124,140,54,141,54,160,169,161,169,162,241,163,241,164,304,165,304,166,304,167,304,168,147,169,147,170,135,171,135,172,90,173,90,174,1,175,1,186,68,187,68,188,172,189,172,190,208,191,208,192,221,193,221,194,221,195,221,196,194,197,194,198,134,199,134,200,62,201,62,},[70]={120,12,121,12,122,48,123,48,124,144,125,144,126,170,127,170,128,221,129,221,130,221,131,221,132,221,133,221,134,194,135,194,136,158,137,158,138,185,139,185,140,92,141,92,142,54,143,54,154,36,155,36,156,81,157,81,158,156,159,156,160,205,161,205,162,223,163,223,164,232,165,232,166,214,167,214,168,73,169,73,170,36,171,36,172,1,173,1,174,1,175,1,186,42,187,42,188,133,189,133,190,208,191,208,192,221,193,221,194,221,195,221,196,158,197,158,198,98,199,98,200,71,201,71,},[71]={120,12,121,12,122,48,123,48,124,144,125,144,126,170,127,170,128,221,129,221,130,221,131,221,132,221,133,221,134,194,135,194,136,158,137,158,138,185,139,185,140,92,141,92,142,54,143,54,154,36,155,36,156,81,157,81,158,156,159,156,160,205,161,205,162,223,163,223,164,232,165,232,166,214,167,214,168,73,169,73,170,36,171,36,172,1,173,1,174,1,175,1,186,42,187,42,188,133,189,133,190,208,191,208,192,221,193,221,194,221,195,221,196,158,197,158,198,98,199,98,200,71,201,71,},[72]={118,6,119,6,120,42,121,42,122,98,123,98,124,189,125,189,126,189,127,189,128,189,129,189,130,221,131,221,132,221,133,221,134,221,135,221,136,221,137,221,138,208,139,208,140,208,141,208,142,93,143,93,144,58,145,58,146,15,147,15,148,18,149,18,150,18,151,18,152,18,153,18,154,84,155,84,156,129,157,129,158,170,159,170,160,205,161,205,162,205,163,205,164,205,165,205,166,166,167,166,168,88,169,88,170,18,171,18,172,6,173,6,174,6,175,6,184,6,185,6,186,108,187,108,188,162,189,162,190,208,191,208,192,208,193,208,194,208,195,208,196,185,197,185,198,124,199,124,200,49,201,49,},[73]={118,6,119,6,120,42,121,42,122,98,123,98,124,189,125,189,126,189,127,189,128,189,129,189,130,221,131,221,132,221,133,221,134,221,135,221,136,221,137,221,138,208,139,208,140,208,141,208,142,93,143,93,144,58,145,58,146,15,147,15,148,18,149,18,150,18,151,18,152,18,153,18,154,84,155,84,156,129,157,129,158,170,159,170,160,205,161,205,162,205,163,205,164,205,165,205,166,166,167,166,168,88,169,88,170,18,171,18,172,6,173,6,174,6,175,6,184,6,185,6,186,108,187,108,188,162,189,162,190,208,191,208,192,208,193,208,194,208,195,208,196,185,197,185,198,124,199,124,200,49,201,49,},[74]={116,18,117,18,118,48,119,48,120,109,121,109,122,236,123,236,124,254,125,254,126,189,127,189,128,189,129,189,130,221,131,221,132,221,133,221,134,221,135,221,136,221,137,221,138,208,139,208,140,208,141,208,142,195,143,195,144,153,145,153,146,15,147,15,148,30,149,30,150,30,151,30,152,66,153,66,154,114,155,114,156,153,157,153,158,205,159,205,160,205,161,205,162,205,163,205,164,205,165,205,166,146,167,146,168,133,169,133,170,55,171,55,172,18,173,18,174,18,175,18,176,12,177,12,178,1,179,1,180,1,181,1,182,6,183,6,184,19,185,19,186,186,187,186,188,186,189,186,190,208,191,208,192,208,193,208,194,181,195,181,196,92,197,92,198,54,199,54,200,1,201,1,},[75]={116,18,117,18,118,48,119,48,120,109,121,109,122,236,123,236,124,254,125,254,126,189,127,189,128,189,129,189,130,221,131,221,132,221,133,221,134,221,135,221,136,221,137,221,138,208,139,208,140,208,141,208,142,195,143,195,144,153,145,153,146,15,147,15,148,30,149,30,150,30,151,30,152,66,153,66,154,114,155,114,156,153,157,153,158,205,159,205,160,205,161,205,162,205,163,205,164,205,165,205,166,146,167,146,168,133,169,133,170,55,171,55,172,18,173,18,174,18,175,18,176,12,177,12,178,1,179,1,180,1,181,1,182,6,183,6,184,19,185,19,186,186,187,186,188,186,189,186,190,208,191,208,192,208,193,208,194,181,195,181,196,92,197,92,198,54,199,54,200,1,201,1,},[76]={116,30,117,30,118,60,119,60,120,109,121,109,122,236,123,236,124,254,125,254,126,189,127,189,128,189,129,189,130,189,131,189,132,208,133,208,134,208,135,208,136,208,137,208,138,208,139,208,140,208,141,208,142,195,143,195,144,181,145,181,146,95,147,95,148,131,149,131,150,119,151,119,152,143,153,143,154,165,155,165,156,205,157,205,158,231,159,231,160,231,161,231,162,205,163,205,164,172,165,172,166,185,167,185,168,198,169,198,170,198,171,198,172,120,173,120,174,36,175,36,176,24,177,24,178,91,179,91,180,127,181,127,182,116,183,116,184,91,185,91,186,168,187,168,188,195,189,195,190,195,191,195,192,177,193,177,194,111,195,111,196,54,197,54,198,1,199,1,200,1,201,1,},[77]={116,30,117,30,118,60,119,60,120,109,121,109,122,236,123,236,124,254,125,254,126,189,127,189,128,189,129,189,130,189,131,189,132,208,133,208,134,208,135,208,136,208,137,208,138,208,139,208,140,208,141,208,142,195,143,195,144,181,145,181,146,95,147,95,148,131,149,131,150,119,151,119,152,143,153,143,154,165,155,165,156,205,157,205,158,231,159,231,160,231,161,231,162,205,163,205,164,172,165,172,166,185,167,185,168,198,169,198,170,198,171,198,172,120,173,120,174,36,175,36,176,24,177,24,178,91,179,91,180,127,181,127,182,116,183,116,184,91,185,91,186,168,187,168,188,195,189,195,190,195,191,195,192,177,193,177,194,111,195,111,196,54,197,54,198,1,199,1,200,1,201,1,},[78]={114,9,115,9,116,54,117,54,118,75,119,75,120,117,121,117,122,228,123,228,124,234,125,234,126,202,127,202,128,189,129,189,130,172,131,172,132,120,133,120,134,172,135,172,136,133,137,133,138,162,139,162,140,186,141,186,142,195,143,195,144,190,145,190,146,182,147,182,148,218,149,218,150,236,151,236,152,218,153,218,154,197,155,197,156,231,157,231,158,231,159,231,160,231,161,231,162,181,163,181,164,159,165,159,166,198,167,198,168,198,169,198,170,198,171,198,172,198,173,198,174,172,175,172,176,146,177,146,178,160,179,160,180,239,181,239,182,266,183,266,184,213,185,213,186,194,187,194,188,190,189,190,190,181,191,181,192,153,193,153,194,75,195,75,196,63,197,63,198,18,199,18,200,6,201,6,},[79]={114,9,115,9,116,54,117,54,118,75,119,75,120,117,121,117,122,228,123,228,124,234,125,234,126,202,127,202,128,189,129,189,130,172,131,172,132,120,133,120,134,172,135,172,136,133,137,133,138,162,139,162,140,186,141,186,142,195,143,195,144,190,145,190,146,182,147,182,148,218,149,218,150,236,151,236,152,218,153,218,154,197,155,197,156,231,157,231,158,231,159,231,160,231,161,231,162,181,163,181,164,159,165,159,166,198,167,198,168,198,169,198,170,198,171,198,172,198,173,198,174,172,175,172,176,146,177,146,178,160,179,160,180,239,181,239,182,266,183,266,184,213,185,213,186,194,187,194,188,190,189,190,190,181,191,181,192,153,193,153,194,75,195,75,196,63,197,63,198,18,199,18,200,6,201,6,},[80]={114,15,115,15,116,87,117,87,118,174,119,174,120,297,121,297,122,279,123,279,124,243,125,243,126,103,127,103,128,166,129,166,130,159,131,159,132,81,133,81,134,68,135,68,136,42,137,42,138,108,139,108,140,168,141,168,142,168,143,168,144,194,145,194,146,227,147,227,148,236,149,236,150,262,151,262,152,279,153,279,154,244,155,244,156,231,157,231,158,218,159,218,160,205,161,205,162,193,163,193,164,172,165,172,166,198,167,198,168,198,169,198,170,198,171,198,172,182,173,182,174,175,175,175,176,198,177,198,178,198,179,198,180,266,181,266,182,266,183,266,184,248,185,248,186,209,187,209,188,181,189,181,190,181,191,181,192,93,193,93,194,90,195,90,196,81,197,81,198,87,199,87,200,75,201,75,202,12,203,12,},[81]={114,15,115,15,116,87,117,87,118,174,119,174,120,297,121,297,122,279,123,279,124,243,125,243,126,103,127,103,128,166,129,166,130,159,131,159,132,81,133,81,134,68,135,68,136,42,137,42,138,108,139,108,140,168,141,168,142,168,143,168,144,194,145,194,146,227,147,227,148,236,149,236,150,262,151,262,152,279,153,279,154,244,155,244,156,231,157,231,158,218,159,218,160,205,161,205,162,193,163,193,164,172,165,172,166,198,167,198,168,198,169,198,170,198,171,198,172,182,173,182,174,175,175,175,176,198,177,198,178,198,179,198,180,266,181,266,182,266,183,266,184,248,185,248,186,209,187,209,188,181,189,181,190,181,191,181,192,93,193,93,194,90,195,90,196,81,197,81,198,87,199,87,200,75,201,75,202,12,203,12,},[82]={114,6,115,6,116,87,117,87,118,267,119,267,120,387,121,387,122,342,123,342,124,293,125,293,126,126,127,126,128,36,129,36,130,18,131,18,138,6,139,6,140,19,141,19,142,91,143,91,144,213,145,213,146,236,147,236,148,249,149,249,150,327,151,327,152,282,153,282,154,255,155,255,156,244,157,244,158,218,159,218,160,244,161,244,162,258,163,258,164,228,165,228,166,224,167,224,168,198,169,198,170,198,171,198,172,159,173,159,174,151,175,151,176,189,177,189,178,200,179,200,180,237,181,237,182,303,183,303,184,258,185,258,186,187,187,187,188,156,189,156,190,92,191,92,192,39,193,39,194,45,195,45,196,120,197,120,198,139,199,139,200,139,201,139,202,55,203,55,204,30,205,30,},[83]={114,6,115,6,116,87,117,87,118,267,119,267,120,387,121,387,122,342,123,342,124,293,125,293,126,126,127,126,128,36,129,36,130,18,131,18,138,6,139,6,140,19,141,19,142,91,143,91,144,213,145,213,146,236,147,236,148,249,149,249,150,327,151,327,152,282,153,282,154,255,155,255,156,244,157,244,158,218,159,218,160,244,161,244,162,258,163,258,164,228,165,228,166,224,167,224,168,198,169,198,170,198,171,198,172,159,173,159,174,151,175,151,176,189,177,189,178,200,179,200,180,237,181,237,182,303,183,303,184,258,185,258,186,187,187,187,188,156,189,156,190,92,191,92,192,39,193,39,194,45,195,45,196,120,197,120,198,139,199,139,200,139,201,139,202,55,203,55,204,30,205,30,},[84]={112,9,113,9,114,15,115,15,116,223,117,223,118,383,119,383,120,459,121,459,122,366,123,366,124,357,125,357,126,199,127,199,128,37,129,37,130,1,131,1,146,182,147,182,148,249,149,249,150,300,151,300,152,264,153,264,154,253,155,253,156,223,157,223,158,244,159,244,160,258,161,258,162,258,163,258,164,257,165,257,166,217,167,217,168,198,169,198,170,148,171,148,172,119,173,119,174,101,175,101,176,85,177,85,178,179,179,179,180,247,181,247,182,323,183,323,184,217,185,217,186,156,187,156,188,105,189,105,190,30,191,30,192,9,193,9,194,33,195,33,196,143,197,143,198,143,199,143,200,143,201,143,202,111,203,111,204,42,205,42,},[85]={112,9,113,9,114,15,115,15,116,223,117,223,118,383,119,383,120,459,121,459,122,366,123,366,124,357,125,357,126,199,127,199,128,37,129,37,130,1,131,1,146,182,147,182,148,249,149,249,150,300,151,300,152,264,153,264,154,253,155,253,156,223,157,223,158,244,159,244,160,258,161,258,162,258,163,258,164,257,165,257,166,217,167,217,168,198,169,198,170,148,171,148,172,119,173,119,174,101,175,101,176,85,177,85,178,179,179,179,180,247,181,247,182,323,183,323,184,217,185,217,186,156,187,156,188,105,189,105,190,30,191,30,192,9,193,9,194,33,195,33,196,143,197,143,198,143,199,143,200,143,201,143,202,111,203,111,204,42,205,42,},[86]={110,9,111,9,112,30,113,30,114,21,115,21,116,284,117,284,118,442,119,442,120,464,121,464,122,437,123,437,124,399,125,399,126,271,127,271,128,75,129,75,130,39,131,39,148,218,149,218,150,247,151,247,152,261,153,261,154,223,155,223,156,236,157,236,158,258,159,258,160,258,161,258,162,258,163,258,164,258,165,258,166,217,167,217,168,193,169,193,170,148,171,148,172,49,173,49,174,9,175,9,176,54,177,54,178,167,179,167,180,252,181,252,182,308,183,308,184,262,185,262,186,172,187,172,188,30,189,30,190,9,191,9,192,27,193,27,194,18,195,18,196,90,197,90,198,182,199,182,200,221,201,221,202,208,203,208,204,101,205,101,206,21,207,21,},[87]={110,9,111,9,112,30,113,30,114,21,115,21,116,284,117,284,118,442,119,442,120,464,121,464,122,437,123,437,124,399,125,399,126,271,127,271,128,75,129,75,130,39,131,39,148,218,149,218,150,247,151,247,152,261,153,261,154,223,155,223,156,236,157,236,158,258,159,258,160,258,161,258,162,258,163,258,164,258,165,258,166,217,167,217,168,193,169,193,170,148,171,148,172,49,173,49,174,9,175,9,176,54,177,54,178,167,179,167,180,252,181,252,182,308,183,308,184,262,185,262,186,172,187,172,188,30,189,30,190,9,191,9,192,27,193,27,194,18,195,18,196,90,197,90,198,182,199,182,200,221,201,221,202,208,203,208,204,101,205,101,206,21,207,21,},[88]={106,9,107,9,108,33,109,33,110,39,111,39,112,143,113,143,114,235,115,235,116,318,117,318,118,376,119,376,120,472,121,472,122,472,123,472,124,418,125,418,126,336,127,336,128,328,129,328,130,168,131,168,132,12,133,12,148,108,149,108,150,209,151,209,152,217,153,217,154,241,155,241,156,242,157,242,158,275,159,275,160,270,161,270,162,258,163,258,164,231,165,231,166,218,167,218,168,217,169,217,170,147,171,147,172,9,173,9,174,9,175,9,176,45,177,45,178,172,179,172,180,307,181,307,182,316,183,316,184,244,185,244,186,172,187,172,188,30,189,30,190,330,191,330,192,240,193,240,194,6,195,6,196,21,197,21,198,149,199,149,200,221,201,221,202,221,203,221,204,151,205,151,206,69,207,69,208,6,209,6,},[89]={106,9,107,9,108,33,109,33,110,39,111,39,112,143,113,143,114,235,115,235,116,318,117,318,118,376,119,376,120,472,121,472,122,472,123,472,124,418,125,418,126,336,127,336,128,328,129,328,130,168,131,168,132,12,133,12,148,108,149,108,150,209,151,209,152,217,153,217,154,241,155,241,156,242,157,242,158,275,159,275,160,270,161,270,162,258,163,258,164,231,165,231,166,218,167,218,168,217,169,217,170,147,171,147,172,9,173,9,174,9,175,9,176,45,177,45,178,172,179,172,180,307,181,307,182,316,183,316,184,244,185,244,186,172,187,172,188,30,189,30,190,330,191,330,192,240,193,240,194,6,195,6,196,21,197,21,198,149,199,149,200,221,201,221,202,221,203,221,204,151,205,151,206,69,207,69,208,6,209,6,},[90]={104,6,105,6,106,82,107,82,108,125,109,125,110,183,111,183,112,309,113,309,114,383,115,383,116,374,117,374,118,450,119,450,120,547,121,547,122,528,123,528,124,465,125,465,126,393,127,393,128,310,129,310,130,227,131,227,132,18,133,18,150,148,151,148,152,185,153,185,154,241,155,241,156,271,157,271,158,291,159,291,160,291,161,291,162,257,163,257,164,244,165,244,166,226,167,226,168,230,169,230,170,159,171,159,172,67,173,67,174,9,175,9,176,45,177,45,178,139,179,139,180,256,181,256,182,320,183,320,184,402,185,402,186,500,187,500,188,551,189,551,190,474,191,474,192,474,193,474,194,294,195,294,196,75,197,75,198,84,199,84,200,229,201,229,202,247,203,247,204,182,205,182,206,134,207,134,208,82,209,82,210,9,211,9,},[91]={104,6,105,6,106,82,107,82,108,125,109,125,110,183,111,183,112,309,113,309,114,383,115,383,116,374,117,374,118,450,119,450,120,547,121,547,122,528,123,528,124,465,125,465,126,393,127,393,128,310,129,310,130,227,131,227,132,18,133,18,150,148,151,148,152,185,153,185,154,241,155,241,156,271,157,271,158,291,159,291,160,291,161,291,162,257,163,257,164,244,165,244,166,226,167,226,168,230,169,230,170,159,171,159,172,67,173,67,174,9,175,9,176,45,177,45,178,139,179,139,180,256,181,256,182,320,183,320,184,402,185,402,186,500,187,500,188,551,189,551,190,474,191,474,192,474,193,474,194,294,195,294,196,75,197,75,198,84,199,84,200,229,201,229,202,247,203,247,204,182,205,182,206,134,207,134,208,82,209,82,210,9,211,9,},[92]={102,21,103,21,104,69,105,69,106,134,107,134,108,197,109,197,110,246,111,246,112,302,113,302,114,339,115,339,116,373,117,373,118,472,119,472,120,511,121,511,122,528,123,528,124,519,125,519,126,368,127,368,128,208,129,208,130,169,131,169,132,24,133,24,150,22,151,22,152,101,153,101,154,159,155,159,156,253,157,253,158,291,159,291,160,302,161,302,162,284,163,284,164,257,165,257,166,257,167,257,168,257,169,257,170,193,171,193,172,129,173,129,174,36,175,36,176,72,177,72,178,174,179,174,180,258,181,258,182,365,183,365,184,377,185,377,186,400,187,400,188,353,189,353,190,394,191,394,192,442,193,442,194,394,195,394,196,152,197,152,198,48,199,48,200,152,201,152,202,242,203,242,204,296,205,296,206,197,207,197,208,125,209,125,210,33,211,33,},[93]={102,21,103,21,104,69,105,69,106,134,107,134,108,197,109,197,110,246,111,246,112,302,113,302,114,339,115,339,116,373,117,373,118,472,119,472,120,511,121,511,122,528,123,528,124,519,125,519,126,368,127,368,128,208,129,208,130,169,131,169,132,24,133,24,150,22,151,22,152,101,153,101,154,159,155,159,156,253,157,253,158,291,159,291,160,302,161,302,162,284,163,284,164,257,165,257,166,257,167,257,168,257,169,257,170,193,171,193,172,129,173,129,174,36,175,36,176,72,177,72,178,174,179,174,180,258,181,258,182,365,183,365,184,377,185,377,186,400,187,400,188,353,189,353,190,394,191,394,192,442,193,442,194,394,195,394,196,152,197,152,198,48,199,48,200,152,201,152,202,242,203,242,204,296,205,296,206,197,207,197,208,125,209,125,210,33,211,33,},[94]={98,30,99,30,100,42,101,42,102,101,103,101,104,151,105,151,106,182,107,182,108,296,109,296,110,305,111,305,112,284,113,284,114,317,115,317,116,373,117,373,118,382,119,382,120,456,121,456,122,453,123,453,124,456,125,456,126,366,127,366,128,235,129,235,130,210,131,210,132,121,133,121,134,90,135,90,150,22,151,22,152,101,153,101,154,159,155,159,156,189,157,189,158,271,159,271,160,311,161,311,162,284,163,284,164,257,165,257,166,257,167,257,168,257,169,257,170,239,171,239,172,182,173,182,174,137,175,137,176,126,177,126,178,198,179,198,180,320,181,320,182,338,183,338,184,334,185,334,186,330,187,330,188,356,189,356,190,361,191,361,192,317,193,317,194,286,195,286,196,205,197,205,198,12,199,12,200,54,201,54,202,242,203,242,204,305,205,305,206,246,207,246,208,183,209,183,210,39,211,39,212,9,213,9,},[95]={98,30,99,30,100,42,101,42,102,101,103,101,104,151,105,151,106,182,107,182,108,296,109,296,110,305,111,305,112,284,113,284,114,317,115,317,116,373,117,373,118,382,119,382,120,456,121,456,122,453,123,453,124,456,125,456,126,366,127,366,128,235,129,235,130,210,131,210,132,121,133,121,134,90,135,90,150,22,151,22,152,101,153,101,154,159,155,159,156,189,157,189,158,271,159,271,160,311,161,311,162,284,163,284,164,257,165,257,166,257,167,257,168,257,169,257,170,239,171,239,172,182,173,182,174,137,175,137,176,126,177,126,178,198,179,198,180,320,181,320,182,338,183,338,184,334,185,334,186,330,187,330,188,356,189,356,190,361,191,361,192,317,193,317,194,286,195,286,196,205,197,205,198,12,199,12,200,54,201,54,202,242,203,242,204,305,205,305,206,246,207,246,208,183,209,183,210,39,211,39,212,9,213,9,},[96]={96,12,97,12,98,55,99,55,100,111,101,111,102,208,103,208,104,221,105,221,106,247,107,247,108,242,109,242,110,242,111,242,112,221,113,221,114,297,115,297,116,319,117,319,118,391,119,391,120,371,121,371,122,367,123,367,124,344,125,344,126,348,127,348,128,299,129,299,130,299,131,299,132,218,133,218,134,135,135,135,136,36,137,36,138,18,139,18,148,18,149,18,150,59,151,59,152,148,153,148,154,208,155,208,156,244,157,244,158,244,159,244,160,257,161,257,162,257,163,257,164,257,165,257,166,257,167,257,168,257,169,257,170,257,171,257,172,239,173,239,174,221,175,221,176,186,177,186,178,205,179,205,180,275,181,275,182,279,183,279,184,306,185,306,186,279,187,279,188,270,189,270,190,276,191,276,192,267,193,267,194,267,195,267,196,160,197,160,198,102,199,102,200,54,201,54,202,221,203,221,204,284,205,284,206,320,207,320,208,327,209,327,210,143,211,143,212,30,213,30,214,9,215,9,},[97]={96,12,97,12,98,55,99,55,100,111,101,111,102,208,103,208,104,221,105,221,106,247,107,247,108,242,109,242,110,242,111,242,112,221,113,221,114,297,115,297,116,319,117,319,118,391,119,391,120,371,121,371,122,367,123,367,124,344,125,344,126,348,127,348,128,299,129,299,130,299,131,299,132,218,133,218,134,135,135,135,136,36,137,36,138,18,139,18,148,18,149,18,150,59,151,59,152,148,153,148,154,208,155,208,156,244,157,244,158,244,159,244,160,257,161,257,162,257,163,257,164,257,165,257,166,257,167,257,168,257,169,257,170,257,171,257,172,239,173,239,174,221,175,221,176,186,177,186,178,205,179,205,180,275,181,275,182,279,183,279,184,306,185,306,186,279,187,279,188,270,189,270,190,276,191,276,192,267,193,267,194,267,195,267,196,160,197,160,198,102,199,102,200,54,201,54,202,221,203,221,204,284,205,284,206,320,207,320,208,327,209,327,210,143,211,143,212,30,213,30,214,9,215,9,},[98]={94,6,95,6,96,75,97,75,98,139,99,139,100,143,101,143,102,221,103,221,104,221,105,221,106,229,107,229,108,152,109,152,110,54,111,54,112,54,113,54,114,171,115,171,116,219,117,219,118,236,119,236,120,208,121,208,122,225,123,225,124,268,125,268,126,221,127,221,128,299,129,299,130,326,131,326,132,299,133,299,134,147,135,147,136,73,137,73,138,88,139,88,140,115,141,115,142,90,143,90,144,9,145,9,146,9,147,9,148,27,149,27,150,117,151,117,152,193,153,193,154,217,155,217,156,244,157,244,158,244,159,244,160,244,161,244,162,213,163,213,164,222,165,222,166,240,167,240,168,257,169,257,170,257,171,257,172,257,173,257,174,257,175,257,176,196,177,196,178,173,179,173,180,177,181,177,182,139,183,139,184,135,185,135,186,186,187,186,188,211,189,211,190,227,191,227,192,226,193,226,194,186,195,186,196,160,197,160,198,42,199,42,200,171,201,171,202,297,203,297,204,317,205,317,206,351,207,351,208,401,209,401,210,235,211,235,212,21,213,21,214,15,215,15,216,6,217,6,218,15,219,15,220,9,221,9,},[99]={94,6,95,6,96,75,97,75,98,139,99,139,100,143,101,143,102,221,103,221,104,221,105,221,106,229,107,229,108,152,109,152,110,54,111,54,112,54,113,54,114,171,115,171,116,219,117,219,118,236,119,236,120,208,121,208,122,225,123,225,124,268,125,268,126,221,127,221,128,299,129,299,130,326,131,326,132,299,133,299,134,147,135,147,136,73,137,73,138,88,139,88,140,115,141,115,142,90,143,90,144,9,145,9,146,9,147,9,148,27,149,27,150,117,151,117,152,193,153,193,154,217,155,217,156,244,157,244,158,244,159,244,160,244,161,244,162,213,163,213,164,222,165,222,166,240,167,240,168,257,169,257,170,257,171,257,172,257,173,257,174,257,175,257,176,196,177,196,178,173,179,173,180,177,181,177,182,139,183,139,184,135,185,135,186,186,187,186,188,211,189,211,190,227,191,227,192,226,193,226,194,186,195,186,196,160,197,160,198,42,199,42,200,171,201,171,202,297,203,297,204,317,205,317,206,351,207,351,208,401,209,401,210,235,211,235,212,21,213,21,214,15,215,15,216,6,217,6,218,15,219,15,220,9,221,9,},[100]={94,18,95,18,96,87,97,87,98,139,99,139,100,143,101,143,102,182,103,182,104,149,105,149,106,84,107,84,108,48,109,48,110,1,111,1,112,1,113,1,114,42,115,42,116,114,117,114,118,108,119,108,126,39,127,39,128,290,129,290,130,326,131,326,132,371,133,371,134,304,135,304,136,214,137,214,138,166,139,166,140,146,141,146,142,185,143,185,144,117,145,117,146,117,147,117,148,143,149,143,150,163,151,163,152,244,153,244,154,218,155,218,156,205,157,205,158,205,159,205,160,200,161,200,162,187,163,187,164,245,165,245,166,245,167,245,168,245,169,245,170,245,171,245,172,245,173,245,174,245,175,245,176,168,177,168,178,100,179,100,180,85,181,85,188,147,189,147,190,190,191,190,192,199,193,199,194,199,195,199,196,160,197,160,198,114,199,114,200,219,201,219,202,319,203,319,204,373,205,373,206,373,207,373,208,374,209,374,210,318,211,318,212,284,213,284,214,223,215,223,216,87,217,87,218,87,219,87,220,54,221,54,222,30,223,30,224,18,225,18,},[101]={94,18,95,18,96,87,97,87,98,139,99,139,100,143,101,143,102,182,103,182,104,149,105,149,106,84,107,84,108,48,109,48,110,1,111,1,112,1,113,1,114,42,115,42,116,114,117,114,118,108,119,108,126,39,127,39,128,290,129,290,130,326,131,326,132,371,133,371,134,304,135,304,136,214,137,214,138,166,139,166,140,146,141,146,142,185,143,185,144,117,145,117,146,117,147,117,148,143,149,143,150,163,151,163,152,244,153,244,154,218,155,218,156,205,157,205,158,205,159,205,160,200,161,200,162,187,163,187,164,245,165,245,166,245,167,245,168,245,169,245,170,245,171,245,172,245,173,245,174,245,175,245,176,168,177,168,178,100,179,100,180,85,181,85,188,147,189,147,190,190,191,190,192,199,193,199,194,199,195,199,196,160,197,160,198,114,199,114,200,219,201,219,202,319,203,319,204,373,205,373,206,373,207,373,208,374,209,374,210,318,211,318,212,284,213,284,214,223,215,223,216,87,217,87,218,87,219,87,220,54,221,54,222,30,223,30,224,18,225,18,},[102]={94,18,95,18,96,81,97,81,98,120,99,120,100,143,101,143,102,90,103,90,104,21,105,21,128,136,129,136,130,256,131,256,132,341,133,341,134,304,135,304,136,232,137,232,138,205,139,205,140,205,141,205,142,172,143,172,144,159,145,159,146,172,147,172,148,228,149,228,150,257,151,257,152,258,153,258,154,231,155,231,156,218,157,218,158,218,159,218,160,239,161,239,162,245,163,245,164,245,165,245,166,245,167,245,168,245,169,245,170,245,171,245,172,245,173,245,174,169,175,169,176,57,177,57,188,57,189,57,190,153,191,153,192,199,193,199,194,199,195,199,196,160,197,160,198,108,199,108,200,236,201,236,202,391,203,391,204,382,205,382,206,472,207,472,208,450,209,450,210,376,211,376,212,442,213,442,214,383,215,383,216,267,217,267,218,174,219,174,220,75,221,75,222,60,223,60,224,48,225,48,226,6,227,6,},[103]={94,18,95,18,96,81,97,81,98,120,99,120,100,143,101,143,102,90,103,90,104,21,105,21,128,136,129,136,130,256,131,256,132,341,133,341,134,304,135,304,136,232,137,232,138,205,139,205,140,205,141,205,142,172,143,172,144,159,145,159,146,172,147,172,148,228,149,228,150,257,151,257,152,258,153,258,154,231,155,231,156,218,157,218,158,218,159,218,160,239,161,239,162,245,163,245,164,245,165,245,166,245,167,245,168,245,169,245,170,245,171,245,172,245,173,245,174,169,175,169,176,57,177,57,188,57,189,57,190,153,191,153,192,199,193,199,194,199,195,199,196,160,197,160,198,108,199,108,200,236,201,236,202,391,203,391,204,382,205,382,206,472,207,472,208,450,209,450,210,376,211,376,212,442,213,442,214,383,215,383,216,267,217,267,218,174,219,174,220,75,221,75,222,60,223,60,224,48,225,48,226,6,227,6,},[104]={94,12,95,12,96,18,97,18,98,18,99,18,100,24,101,24,128,1,129,1,130,140,131,140,132,191,133,191,134,241,135,241,136,223,137,223,138,205,139,205,140,205,141,205,142,205,143,205,144,181,145,181,146,193,147,193,148,258,149,258,150,258,151,258,152,258,153,258,154,258,155,258,156,258,157,258,158,257,159,257,160,258,161,258,162,245,163,245,164,245,165,245,166,245,167,245,168,245,169,245,170,245,171,245,172,245,173,245,174,142,175,142,188,16,189,16,190,160,191,160,192,212,193,212,194,212,195,212,196,137,197,137,198,42,199,42,200,208,201,208,202,371,203,371,204,456,205,456,206,511,207,511,208,547,209,547,210,472,211,472,212,464,213,464,214,459,215,459,216,387,217,387,218,297,219,297,220,117,221,117,222,109,223,109,224,109,225,109,226,42,227,42,228,12,229,12,},[105]={94,12,95,12,96,18,97,18,98,18,99,18,100,24,101,24,128,1,129,1,130,140,131,140,132,191,133,191,134,241,135,241,136,223,137,223,138,205,139,205,140,205,141,205,142,205,143,205,144,181,145,181,146,193,147,193,148,258,149,258,150,258,151,258,152,258,153,258,154,258,155,258,156,258,157,258,158,257,159,257,160,258,161,258,162,245,163,245,164,245,165,245,166,245,167,245,168,245,169,245,170,245,171,245,172,245,173,245,174,142,175,142,188,16,189,16,190,160,191,160,192,212,193,212,194,212,195,212,196,137,197,137,198,42,199,42,200,208,201,208,202,371,203,371,204,456,205,456,206,511,207,511,208,547,209,547,210,472,211,472,212,464,213,464,214,459,215,459,216,387,217,387,218,297,219,297,220,117,221,117,222,109,223,109,224,109,225,109,226,42,227,42,228,12,229,12,},[106]={134,169,135,169,136,205,137,205,138,205,139,205,140,205,141,205,142,231,143,231,144,231,145,231,146,205,147,205,148,244,149,244,150,258,151,258,152,258,153,258,154,258,155,258,156,258,157,258,158,258,159,258,160,258,161,258,162,245,163,245,164,245,165,245,166,245,167,245,168,272,169,272,170,272,171,272,172,184,173,184,174,33,175,33,188,55,189,55,190,160,191,160,192,212,193,212,194,212,195,212,196,127,197,127,198,48,199,48,200,225,201,225,202,367,203,367,204,453,205,453,206,528,207,528,208,528,209,528,210,472,211,472,212,437,213,437,214,366,215,366,216,342,217,342,218,279,219,279,220,228,221,228,222,236,223,236,224,236,225,236,226,98,227,98,228,48,229,48,},[107]={134,169,135,169,136,205,137,205,138,205,139,205,140,205,141,205,142,231,143,231,144,231,145,231,146,205,147,205,148,244,149,244,150,258,151,258,152,258,153,258,154,258,155,258,156,258,157,258,158,258,159,258,160,258,161,258,162,245,163,245,164,245,165,245,166,245,167,245,168,272,169,272,170,272,171,272,172,184,173,184,174,33,175,33,188,55,189,55,190,160,191,160,192,212,193,212,194,212,195,212,196,127,197,127,198,48,199,48,200,225,201,225,202,367,203,367,204,453,205,453,206,528,207,528,208,528,209,528,210,472,211,472,212,437,213,437,214,366,215,366,216,342,217,342,218,279,219,279,220,228,221,228,222,236,223,236,224,236,225,236,226,98,227,98,228,48,229,48,},[108]={136,156,137,156,138,170,139,170,140,205,141,205,142,231,143,231,144,231,145,231,146,218,147,218,148,218,149,218,150,244,151,244,152,258,153,258,154,258,155,258,156,258,157,258,158,285,159,285,160,312,161,312,162,285,163,285,164,245,165,245,166,290,167,290,168,323,169,323,170,175,171,175,172,29,173,29,186,24,187,24,188,156,189,156,190,156,191,156,192,156,193,156,194,92,195,92,196,36,197,36,198,1,199,1,200,268,201,268,202,344,203,344,204,456,205,456,206,519,207,519,208,465,209,465,210,418,211,418,212,399,213,399,214,357,215,357,216,293,217,293,218,243,219,243,220,234,221,234,222,254,223,254,224,254,225,254,226,189,227,189,228,144,229,144,},[109]={136,156,137,156,138,170,139,170,140,205,141,205,142,231,143,231,144,231,145,231,146,218,147,218,148,218,149,218,150,244,151,244,152,258,153,258,154,258,155,258,156,258,157,258,158,285,159,285,160,312,161,312,162,285,163,285,164,245,165,245,166,290,167,290,168,323,169,323,170,175,171,175,172,29,173,29,186,24,187,24,188,156,189,156,190,156,191,156,192,156,193,156,194,92,195,92,196,36,197,36,198,1,199,1,200,268,201,268,202,344,203,344,204,456,205,456,206,519,207,519,208,465,209,465,210,418,211,418,212,399,213,399,214,357,215,357,216,293,217,293,218,243,219,243,220,234,221,234,222,254,223,254,224,254,225,254,226,189,227,189,228,144,229,144,},[110]={136,81,137,81,138,129,139,129,140,153,141,153,142,205,143,205,144,231,145,231,146,231,147,231,148,244,149,244,150,223,151,223,152,236,153,236,154,249,155,249,156,258,157,258,158,321,159,321,160,375,161,375,162,375,163,375,164,380,165,380,166,475,167,475,168,367,169,367,170,109,171,109,186,135,187,135,188,154,189,154,190,147,191,147,192,127,193,127,194,33,195,33,196,12,197,12,198,39,199,39,200,221,201,221,202,348,203,348,204,366,205,366,206,368,207,368,208,393,209,393,210,336,211,336,212,271,213,271,214,199,215,199,216,126,217,126,218,103,219,103,220,202,221,202,222,189,223,189,224,189,225,189,226,189,227,189,228,170,229,170,230,79,231,79,},[111]={136,81,137,81,138,129,139,129,140,153,141,153,142,205,143,205,144,231,145,231,146,231,147,231,148,244,149,244,150,223,151,223,152,236,153,236,154,249,155,249,156,258,157,258,158,321,159,321,160,375,161,375,162,375,163,375,164,380,165,380,166,475,167,475,168,367,169,367,170,109,171,109,186,135,187,135,188,154,189,154,190,147,191,147,192,127,193,127,194,33,195,33,196,12,197,12,198,39,199,39,200,221,201,221,202,348,203,348,204,366,205,366,206,368,207,368,208,393,209,393,210,336,211,336,212,271,213,271,214,199,215,199,216,126,217,126,218,103,219,103,220,202,221,202,222,189,223,189,224,189,225,189,226,189,227,189,228,170,229,170,230,79,231,79,},[112]={136,36,137,36,138,84,139,84,140,114,141,114,142,165,143,165,144,197,145,197,146,249,147,249,148,275,149,275,150,249,151,249,152,223,153,223,154,210,155,210,156,254,157,254,158,384,159,384,160,429,161,429,162,456,163,456,164,488,165,488,166,484,167,484,168,332,169,332,170,165,171,165,184,69,185,69,186,252,187,252,188,185,189,185,190,144,191,144,192,93,193,93,194,21,195,21,196,136,197,136,198,290,199,290,200,299,201,299,202,299,203,299,204,235,205,235,206,208,207,208,208,310,209,310,210,328,211,328,212,75,213,75,214,37,215,37,216,36,217,36,218,166,219,166,220,189,221,189,222,189,223,189,224,189,225,189,226,189,227,189,228,221,229,221,230,145,231,145,},[113]={136,36,137,36,138,84,139,84,140,114,141,114,142,165,143,165,144,197,145,197,146,249,147,249,148,275,149,275,150,249,151,249,152,223,153,223,154,210,155,210,156,254,157,254,158,384,159,384,160,429,161,429,162,456,163,456,164,488,165,488,166,484,167,484,168,332,169,332,170,165,171,165,184,69,185,69,186,252,187,252,188,185,189,185,190,144,191,144,192,93,193,93,194,21,195,21,196,136,197,136,198,290,199,290,200,299,201,299,202,299,203,299,204,235,205,235,206,208,207,208,208,310,209,310,210,328,211,328,212,75,213,75,214,37,215,37,216,36,217,36,218,166,219,166,220,189,221,189,222,189,223,189,224,189,225,189,226,189,227,189,228,221,229,221,230,145,231,145,},[114]={138,18,139,18,140,66,141,66,142,143,143,143,144,218,145,218,146,288,147,288,148,327,149,327,150,327,151,327,152,288,153,288,154,262,155,262,156,254,157,254,158,348,159,348,160,504,161,504,162,567,163,567,164,549,165,549,166,426,167,426,168,242,169,242,170,197,171,197,180,9,181,9,182,72,183,72,184,200,185,200,186,243,187,243,188,225,189,225,190,143,191,143,192,60,193,60,194,140,195,140,196,256,197,256,198,326,199,326,200,326,201,326,202,299,203,299,204,210,205,210,206,169,207,169,208,227,209,227,210,168,211,168,212,39,213,39,214,1,215,1,216,18,217,18,218,159,219,159,220,172,221,172,222,189,223,189,224,221,225,221,226,221,227,221,228,221,229,221,230,131,231,131,},[115]={138,18,139,18,140,66,141,66,142,143,143,143,144,218,145,218,146,288,147,288,148,327,149,327,150,327,151,327,152,288,153,288,154,262,155,262,156,254,157,254,158,348,159,348,160,504,161,504,162,567,163,567,164,549,165,549,166,426,167,426,168,242,169,242,170,197,171,197,180,9,181,9,182,72,183,72,184,200,185,200,186,243,187,243,188,225,189,225,190,143,191,143,192,60,193,60,194,140,195,140,196,256,197,256,198,326,199,326,200,326,201,326,202,299,203,299,204,210,205,210,206,169,207,169,208,227,209,227,210,168,211,168,212,39,213,39,214,1,215,1,216,18,217,18,218,159,219,159,220,172,221,172,222,189,223,189,224,221,225,221,226,221,227,221,228,221,229,221,230,131,231,131,},[116]={138,18,139,18,140,30,141,30,142,119,143,119,144,236,145,236,146,262,147,262,148,327,149,327,150,327,151,327,152,288,153,288,154,262,155,262,156,249,157,249,158,348,159,348,160,531,161,531,162,567,163,567,164,540,165,540,166,426,167,426,168,273,169,273,170,197,171,197,178,97,179,97,180,108,181,108,182,162,183,162,184,239,185,239,186,225,187,225,188,173,189,173,190,67,191,67,192,24,193,24,194,191,195,191,196,341,197,341,198,371,199,371,200,299,201,299,202,218,203,218,204,121,205,121,206,24,207,24,208,18,209,18,210,12,211,12,218,81,219,81,220,120,221,120,222,208,223,208,224,221,225,221,226,221,227,221,228,221,229,221,230,181,231,181,},[117]={138,18,139,18,140,30,141,30,142,119,143,119,144,236,145,236,146,262,147,262,148,327,149,327,150,327,151,327,152,288,153,288,154,262,155,262,156,249,157,249,158,348,159,348,160,531,161,531,162,567,163,567,164,540,165,540,166,426,167,426,168,273,169,273,170,197,171,197,178,97,179,97,180,108,181,108,182,162,183,162,184,239,185,239,186,225,187,225,188,173,189,173,190,67,191,67,192,24,193,24,194,191,195,191,196,341,197,341,198,371,199,371,200,299,201,299,202,218,203,218,204,121,205,121,206,24,207,24,208,18,209,18,210,12,211,12,218,81,219,81,220,120,221,120,222,208,223,208,224,221,225,221,226,221,227,221,228,221,229,221,230,181,231,181,},[118]={138,18,139,18,140,30,141,30,142,131,143,131,144,218,145,218,146,236,147,236,148,249,149,249,150,249,151,249,152,262,153,262,154,262,155,262,156,249,157,249,158,357,159,357,160,513,161,513,162,450,163,450,164,441,165,441,166,304,167,304,168,228,169,228,170,209,171,209,172,109,173,109,174,96,175,96,176,113,177,113,178,153,179,153,180,155,181,155,182,156,183,156,184,155,185,155,186,164,187,164,188,104,189,104,190,18,191,18,192,169,193,169,194,241,195,241,196,304,197,304,198,304,199,304,200,147,201,147,202,135,203,135,204,90,205,90,206,1,207,1,218,68,219,68,220,172,221,172,222,208,223,208,224,221,225,221,226,221,227,221,228,194,229,194,230,134,231,134,232,62,233,62,},[119]={138,18,139,18,140,30,141,30,142,131,143,131,144,218,145,218,146,236,147,236,148,249,149,249,150,249,151,249,152,262,153,262,154,262,155,262,156,249,157,249,158,357,159,357,160,513,161,513,162,450,163,450,164,441,165,441,166,304,167,304,168,228,169,228,170,209,171,209,172,109,173,109,174,96,175,96,176,113,177,113,178,153,179,153,180,155,181,155,182,156,183,156,184,155,185,155,186,164,187,164,188,104,189,104,190,18,191,18,192,169,193,169,194,241,195,241,196,304,197,304,198,304,199,304,200,147,201,147,202,135,203,135,204,90,205,90,206,1,207,1,218,68,219,68,220,172,221,172,222,208,223,208,224,221,225,221,226,221,227,221,228,194,229,194,230,134,231,134,232,62,233,62,},[120]={138,6,139,6,140,6,141,6,142,95,143,95,144,182,145,182,146,227,147,227,148,236,149,236,150,236,151,236,152,236,153,236,154,236,155,236,156,258,157,258,158,321,159,321,160,428,161,428,162,365,163,365,164,293,165,293,166,254,167,254,168,223,169,223,170,183,171,183,172,191,173,191,174,194,175,194,176,212,177,212,178,184,179,184,180,173,181,173,182,131,183,131,184,110,185,110,186,54,187,54,188,81,189,81,190,156,191,156,192,205,193,205,194,223,195,223,196,232,197,232,198,214,199,214,200,73,201,73,202,36,203,36,204,1,205,1,206,1,207,1,218,42,219,42,220,133,221,133,222,208,223,208,224,221,225,221,226,221,227,221,228,158,229,158,230,98,231,98,232,71,233,71,},[121]={138,6,139,6,140,6,141,6,142,95,143,95,144,182,145,182,146,227,147,227,148,236,149,236,150,236,151,236,152,236,153,236,154,236,155,236,156,258,157,258,158,321,159,321,160,428,161,428,162,365,163,365,164,293,165,293,166,254,167,254,168,223,169,223,170,183,171,183,172,191,173,191,174,194,175,194,176,212,177,212,178,184,179,184,180,173,181,173,182,131,183,131,184,110,185,110,186,54,187,54,188,81,189,81,190,156,191,156,192,205,193,205,194,223,195,223,196,232,197,232,198,214,199,214,200,73,201,73,202,36,203,36,204,1,205,1,206,1,207,1,218,42,219,42,220,133,221,133,222,208,223,208,224,221,225,221,226,221,227,221,228,158,229,158,230,98,231,98,232,71,233,71,},[122]={142,39,143,39,144,122,145,122,146,175,147,175,148,236,149,236,150,236,151,236,152,236,153,236,154,210,155,210,156,267,157,267,158,303,159,303,160,374,161,374,162,338,163,338,164,275,165,275,166,249,167,249,168,223,169,223,170,222,171,222,172,248,173,248,174,230,175,230,176,175,177,175,178,87,179,87,180,36,181,36,182,72,183,72,184,63,185,63,186,84,187,84,188,129,189,129,190,170,191,170,192,205,193,205,194,205,195,205,196,205,197,205,198,166,199,166,200,88,201,88,202,18,203,18,204,6,205,6,206,6,207,6,216,6,217,6,218,108,219,108,220,162,221,162,222,208,223,208,224,208,225,208,226,190,227,190,228,185,229,185,230,124,231,124,232,49,233,49,},[123]={142,39,143,39,144,122,145,122,146,175,147,175,148,236,149,236,150,236,151,236,152,236,153,236,154,210,155,210,156,267,157,267,158,303,159,303,160,374,161,374,162,338,163,338,164,275,165,275,166,249,167,249,168,223,169,223,170,222,171,222,172,248,173,248,174,230,175,230,176,175,177,175,178,87,179,87,180,36,181,36,182,72,183,72,184,63,185,63,186,84,187,84,188,129,189,129,190,170,191,170,192,205,193,205,194,205,195,205,196,205,197,205,198,166,199,166,200,88,201,88,202,18,203,18,204,6,205,6,206,6,207,6,216,6,217,6,218,108,219,108,220,162,221,162,222,208,223,208,224,208,225,208,226,190,227,190,228,185,229,185,230,124,231,124,232,49,233,49,},[124]={134,6,135,6,142,6,143,6,144,48,145,48,146,93,147,93,148,197,149,197,150,223,151,223,152,288,153,288,154,275,155,275,156,232,157,232,158,254,159,254,160,302,161,302,162,293,163,293,164,275,165,275,166,249,167,249,168,223,169,223,170,223,171,223,172,248,173,248,174,230,175,230,176,174,177,174,178,105,179,105,180,30,181,30,182,30,183,30,184,66,185,66,186,114,187,114,188,153,189,153,190,205,191,205,192,205,193,205,194,205,195,205,196,205,197,205,198,146,199,146,200,133,201,133,202,55,203,55,204,18,205,18,206,18,207,18,208,12,209,12,210,1,211,1,212,1,213,1,214,6,215,6,216,19,217,19,218,186,219,186,220,186,221,186,222,208,223,208,224,199,225,199,226,190,227,190,228,92,229,92,230,54,231,54,},[125]={134,6,135,6,142,6,143,6,144,48,145,48,146,93,147,93,148,197,149,197,150,223,151,223,152,288,153,288,154,275,155,275,156,232,157,232,158,254,159,254,160,302,161,302,162,293,163,293,164,275,165,275,166,249,167,249,168,223,169,223,170,223,171,223,172,248,173,248,174,230,175,230,176,174,177,174,178,105,179,105,180,30,181,30,182,30,183,30,184,66,185,66,186,114,187,114,188,153,189,153,190,205,191,205,192,205,193,205,194,205,195,205,196,205,197,205,198,146,199,146,200,133,201,133,202,55,203,55,204,18,205,18,206,18,207,18,208,12,209,12,210,1,211,1,212,1,213,1,214,6,215,6,216,19,217,19,218,186,219,186,220,186,221,186,222,208,223,208,224,199,225,199,226,190,227,190,228,92,229,92,230,54,231,54,},[126]={142,6,143,6,144,42,145,42,146,68,147,68,148,120,149,120,150,172,151,172,152,270,153,270,154,275,155,275,156,223,157,223,158,210,159,210,160,210,161,210,162,223,163,223,164,236,165,236,166,236,167,236,168,223,169,223,170,223,171,223,172,248,173,248,174,248,175,248,176,194,177,194,178,149,179,149,180,131,181,131,182,119,183,119,184,143,185,143,186,165,187,165,188,205,189,205,190,231,191,231,192,231,193,231,194,205,195,205,196,172,197,172,198,185,199,185,200,198,201,198,202,198,203,198,204,120,205,120,206,36,207,36,208,24,209,24,210,91,211,91,212,145,213,145,214,134,215,134,216,91,217,91,218,168,219,168,220,195,221,195,222,195,223,195,224,195,225,195,226,93,227,93,228,54,229,54,},[127]={142,6,143,6,144,42,145,42,146,68,147,68,148,120,149,120,150,172,151,172,152,270,153,270,154,275,155,275,156,223,157,223,158,210,159,210,160,210,161,210,162,223,163,223,164,236,165,236,166,236,167,236,168,223,169,223,170,223,171,223,172,248,173,248,174,248,175,248,176,194,177,194,178,149,179,149,180,131,181,131,182,119,183,119,184,143,185,143,186,165,187,165,188,205,189,205,190,231,191,231,192,231,193,231,194,205,195,205,196,172,197,172,198,185,199,185,200,198,201,198,202,198,203,198,204,120,205,120,206,36,207,36,208,24,209,24,210,91,211,91,212,145,213,145,214,134,215,134,216,91,217,91,218,168,219,168,220,195,221,195,222,195,223,195,224,195,225,195,226,93,227,93,228,54,229,54,},[128]={128,1,129,1,130,6,131,6,142,1,143,1,144,18,145,18,146,18,147,18,148,18,149,18,150,60,151,60,152,196,153,196,154,205,155,205,156,204,157,204,158,202,159,202,160,196,161,196,162,223,163,223,164,236,165,236,166,236,167,236,168,223,169,223,170,223,171,223,172,222,173,222,174,222,175,222,176,221,177,221,178,199,179,199,180,218,181,218,182,236,183,236,184,218,185,218,186,197,187,197,188,231,189,231,190,231,191,231,192,231,193,231,194,181,195,181,196,159,197,159,198,198,199,198,200,198,201,198,202,198,203,198,204,198,205,198,206,172,207,172,208,146,209,146,210,160,211,160,212,221,213,221,214,248,215,248,216,213,217,213,218,194,219,194,220,190,221,190,222,181,223,181,224,171,225,171,226,49,227,49,},[129]={128,1,129,1,130,6,131,6,142,1,143,1,144,18,145,18,146,18,147,18,148,18,149,18,150,60,151,60,152,196,153,196,154,205,155,205,156,204,157,204,158,202,159,202,160,196,161,196,162,223,163,223,164,236,165,236,166,236,167,236,168,223,169,223,170,223,171,223,172,222,173,222,174,222,175,222,176,221,177,221,178,199,179,199,180,218,181,218,182,236,183,236,184,218,185,218,186,197,187,197,188,231,189,231,190,231,191,231,192,231,193,231,194,181,195,181,196,159,197,159,198,198,199,198,200,198,201,198,202,198,203,198,204,198,205,198,206,172,207,172,208,146,209,146,210,160,211,160,212,221,213,221,214,248,215,248,216,213,217,213,218,194,219,194,220,190,221,190,222,181,223,181,224,171,225,171,226,49,227,49,},[130]={128,1,129,1,130,1,131,1,142,1,143,1,144,12,145,12,152,52,153,52,154,112,155,112,156,201,157,201,158,192,159,192,160,150,161,150,162,158,163,158,164,184,165,184,166,184,167,184,168,158,169,158,170,196,171,196,172,209,173,209,174,209,175,209,176,222,177,222,178,227,179,227,180,236,181,236,182,262,183,262,184,288,185,288,186,249,187,249,188,231,189,231,190,218,191,218,192,205,193,205,194,193,195,193,196,172,197,172,198,198,199,198,200,198,201,198,202,198,203,198,204,198,205,198,206,198,207,198,208,198,209,198,210,198,211,198,212,266,213,266,214,266,215,266,216,248,217,248,218,209,219,209,220,181,221,181,222,181,223,181,224,93,225,93,},[131]={128,1,129,1,130,1,131,1,142,1,143,1,144,12,145,12,152,52,153,52,154,112,155,112,156,201,157,201,158,192,159,192,160,150,161,150,162,158,163,158,164,184,165,184,166,184,167,184,168,158,169,158,170,196,171,196,172,209,173,209,174,209,175,209,176,222,177,222,178,227,179,227,180,236,181,236,182,262,183,262,184,288,185,288,186,249,187,249,188,231,189,231,190,218,191,218,192,205,193,205,194,193,195,193,196,172,197,172,198,198,199,198,200,198,201,198,202,198,203,198,204,198,205,198,206,198,207,198,208,198,209,198,210,198,211,198,212,266,213,266,214,266,215,266,216,248,217,248,218,209,219,209,220,181,221,181,222,181,223,181,224,93,225,93,},[132]={128,1,129,1,130,1,131,1,140,6,141,6,152,9,153,9,154,24,155,24,156,74,157,74,158,80,159,80,160,48,161,48,162,100,163,100,164,132,165,132,166,115,167,115,168,44,169,44,170,51,171,51,172,97,173,97,174,140,175,140,176,174,177,174,178,236,179,236,180,249,181,249,182,327,183,327,184,327,185,327,186,275,187,275,188,244,189,244,190,218,191,218,192,244,193,244,194,258,195,258,196,228,197,228,198,224,199,224,200,198,201,198,202,198,203,198,204,198,205,198,206,198,207,198,208,198,209,198,210,207,211,207,212,237,213,237,214,303,215,303,216,258,217,258,218,187,219,187,220,156,221,156,222,92,223,92,224,12,225,12,},[133]={128,1,129,1,130,1,131,1,140,6,141,6,152,9,153,9,154,24,155,24,156,74,157,74,158,80,159,80,160,48,161,48,162,100,163,100,164,132,165,132,166,115,167,115,168,44,169,44,170,51,171,51,172,97,173,97,174,140,175,140,176,174,177,174,178,236,179,236,180,249,181,249,182,327,183,327,184,327,185,327,186,275,187,275,188,244,189,244,190,218,191,218,192,244,193,244,194,258,195,258,196,228,197,228,198,224,199,224,200,198,201,198,202,198,203,198,204,198,205,198,206,198,207,198,208,198,209,198,210,207,211,207,212,237,213,237,214,303,215,303,216,258,217,258,218,187,219,187,220,156,221,156,222,92,223,92,224,12,225,12,},[134]={128,1,129,1,130,6,131,6,132,1,133,1,134,1,135,1,136,6,137,6,154,6,155,6,156,18,157,18,158,1,159,1,160,1,161,1,162,30,163,30,164,18,165,18,166,6,167,6,168,1,169,1,170,1,171,1,172,19,173,19,174,99,175,99,176,158,177,158,178,209,179,209,180,249,181,249,182,327,183,327,184,327,185,327,186,249,187,249,188,223,189,223,190,244,191,244,192,258,193,258,194,258,195,258,196,257,197,257,198,244,199,244,200,221,201,221,202,212,203,212,204,211,205,211,206,260,207,260,208,283,209,283,210,282,211,282,212,314,213,314,214,323,215,323,216,217,217,217,218,156,219,156,220,105,221,105,222,30,223,30,},[135]={128,1,129,1,130,6,131,6,132,1,133,1,134,1,135,1,136,6,137,6,154,6,155,6,156,18,157,18,158,1,159,1,160,1,161,1,162,30,163,30,164,18,165,18,166,6,167,6,168,1,169,1,170,1,171,1,172,19,173,19,174,99,175,99,176,158,177,158,178,209,179,209,180,249,181,249,182,327,183,327,184,327,185,327,186,249,187,249,188,223,189,223,190,244,191,244,192,258,193,258,194,258,195,258,196,257,197,257,198,244,199,244,200,221,201,221,202,212,203,212,204,211,205,211,206,260,207,260,208,283,209,283,210,282,211,282,212,314,213,314,214,323,215,323,216,217,217,217,218,156,219,156,220,105,221,105,222,30,223,30,},[136]={162,6,163,6,172,6,173,6,174,70,175,70,176,127,177,127,178,182,179,182,180,262,181,262,182,288,183,288,184,270,185,270,186,261,187,261,188,252,189,252,190,258,191,258,192,258,193,258,194,258,195,258,196,258,197,258,198,255,199,255,200,250,201,250,202,256,203,256,204,280,205,280,206,313,207,313,208,386,209,386,210,415,211,415,212,406,213,406,214,344,215,344,216,271,217,271,218,181,219,181,220,30,221,30,222,9,223,9,},[137]={162,6,163,6,172,6,173,6,174,70,175,70,176,127,177,127,178,182,179,182,180,262,181,262,182,288,183,288,184,270,185,270,186,261,187,261,188,252,189,252,190,258,191,258,192,258,193,258,194,258,195,258,196,258,197,258,198,255,199,255,200,250,201,250,202,256,203,256,204,280,205,280,206,313,207,313,208,386,209,386,210,415,211,415,212,406,213,406,214,344,215,344,216,271,217,271,218,181,219,181,220,30,221,30,222,9,223,9,},[138]={162,1,163,1,172,1,173,1,174,45,175,45,176,104,177,104,178,138,179,138,180,181,181,181,182,216,183,216,184,225,185,225,186,220,187,220,188,218,189,218,190,222,191,222,192,249,193,249,194,235,195,235,196,249,197,249,198,260,199,260,200,265,201,265,202,289,203,289,204,291,205,291,206,312,207,312,208,343,209,343,210,397,211,397,212,397,213,397,214,334,215,334,216,200,217,200,218,145,219,145,220,30,221,30,},[139]={162,1,163,1,172,1,173,1,174,45,175,45,176,104,177,104,178,138,179,138,180,181,181,181,182,216,183,216,184,225,185,225,186,220,187,220,188,218,189,218,190,222,191,222,192,249,193,249,194,235,195,235,196,249,197,249,198,260,199,260,200,265,201,265,202,289,203,289,204,291,205,291,206,312,207,312,208,343,209,343,210,397,211,397,212,397,213,397,214,334,215,334,216,200,217,200,218,145,219,145,220,30,221,30,},[140]={162,6,163,6,172,1,173,1,174,6,175,6,176,69,177,69,178,96,179,96,180,87,181,87,182,117,183,117,184,157,185,157,186,180,187,180,188,168,189,168,190,171,191,171,192,171,193,171,194,211,195,211,196,231,197,231,198,252,199,252,200,264,201,264,202,278,203,278,204,287,205,287,206,272,207,272,208,275,209,275,210,276,211,276,212,261,213,261,214,217,215,217,216,81,217,81,218,45,219,45,},[141]={162,6,163,6,172,1,173,1,174,6,175,6,176,69,177,69,178,96,179,96,180,87,181,87,182,117,183,117,184,157,185,157,186,180,187,180,188,168,189,168,190,171,191,171,192,171,193,171,194,211,195,211,196,231,197,231,198,252,199,252,200,264,201,264,202,278,203,278,204,287,205,287,206,272,207,272,208,275,209,275,210,276,211,276,212,261,213,261,214,217,215,217,216,81,217,81,218,45,219,45,},[142]={162,6,163,6,164,1,165,1,166,1,167,1,168,12,169,12,170,6,171,6,172,6,173,6,184,9,185,9,186,90,187,90,188,90,189,90,190,135,191,135,192,135,193,135,194,189,195,189,196,201,197,201,198,228,199,228,200,270,201,270,202,270,203,270,204,261,205,261,206,209,207,209,208,162,209,162,210,207,211,207,212,162,213,162,214,108,215,108,},[143]={162,6,163,6,164,1,165,1,166,1,167,1,168,12,169,12,170,6,171,6,172,6,173,6,184,9,185,9,186,90,187,90,188,90,189,90,190,135,191,135,192,135,193,135,194,189,195,189,196,201,197,201,198,228,199,228,200,270,201,270,202,270,203,270,204,261,205,261,206,209,207,209,208,162,209,162,210,207,211,207,212,162,213,162,214,108,215,108,},[144]={162,54,163,54,164,54,165,54,166,36,167,36,168,12,169,12,170,1,171,1,188,9,189,9,190,36,191,36,192,45,193,45,194,119,195,119,196,180,197,180,198,186,199,186,200,225,201,225,202,205,203,205,204,171,205,171,206,144,207,144,208,90,209,90,210,45,211,45,212,36,213,36,214,36,215,36,},[145]={162,54,163,54,164,54,165,54,166,36,167,36,168,12,169,12,170,1,171,1,188,9,189,9,190,36,191,36,192,45,193,45,194,119,195,119,196,180,197,180,198,186,199,186,200,225,201,225,202,205,203,205,204,171,205,171,206,144,207,144,208,90,209,90,210,45,211,45,212,36,213,36,214,36,215,36,},[146]={162,72,163,72,164,96,165,96,166,96,167,96,168,78,169,78,170,6,171,6,192,18,193,18,194,63,195,63,196,106,197,106,198,135,199,135,200,162,201,162,202,135,203,135,204,81,205,81,206,9,207,9,},[147]={162,72,163,72,164,96,165,96,166,96,167,96,168,78,169,78,170,6,171,6,192,18,193,18,194,63,195,63,196,106,197,106,198,135,199,135,200,162,201,162,202,135,203,135,204,81,205,81,206,9,207,9,},[148]={156,9,157,9,158,1,159,1,160,6,161,6,162,74,163,74,164,125,165,125,166,125,167,125,168,57,169,57,170,24,171,24,194,9,195,9,196,45,197,45,198,117,199,117,200,63,201,63,202,45,203,45,},[149]={156,9,157,9,158,1,159,1,160,6,161,6,162,74,163,74,164,125,165,125,166,125,167,125,168,57,169,57,170,24,171,24,194,9,195,9,196,45,197,45,198,117,199,117,200,63,201,63,202,45,203,45,},[150]={160,6,161,6,162,44,163,44,164,125,165,125,166,80,167,80,168,27,169,27,198,45,199,45,200,36,201,36,},[151]={160,6,161,6,162,44,163,44,164,125,165,125,166,80,167,80,168,27,169,27,198,45,199,45,200,36,201,36,},[152]={160,6,161,6,162,66,163,66,164,165,165,165,166,106,167,106,200,108,201,108,},[153]={160,6,161,6,162,66,163,66,164,165,165,165,166,106,167,106,200,108,201,108,},[154]={162,133,163,133,164,160,165,160,166,124,167,124,},[155]={162,133,163,133,164,160,165,160,166,124,167,124,},[156]={162,132,163,132,164,132,165,132,166,42,167,42,},[157]={162,132,163,132,164,132,165,132,166,42,167,42,},[158]={162,36,163,36,164,36,165,36,},[159]={162,36,163,36,164,36,165,36,}
		},
		
		objects ={
			[26]={162,5,7,-1,0,},[30]={164,5,1,-1,512,},[50]={172,5,1,-1,1792,},[54]={172,5,1,-1,1024,176,5,1,-1,512,188,5,1,-1,1536,190,5,2,-1,1280,192,5,2,-1,768,},[56]={188,5,2,-1,1024,190,5,2,-1,512,192,5,2,-1,1280,194,5,2,-1,256,},[58]={186,5,1,-1,256,192,5,2,-1,1792,194,5,2,-1,256,},[60]={186,5,2,-1,1792,188,5,2,-1,1536,190,5,2,-1,1280,192,5,2,-1,768,194,5,1,-1,1536,},[62]={182,5,7,-1,0,188,5,2,-1,1536,190,5,2,-1,1024,},[64]={172,5,7,-1,0,},[70]={196,5,18,-1,0,},[72]={126,5,2,-1,1024,182,5,7,-1,0,},[74]={120,5,2,-1,512,122,5,2,-1,1792,124,5,1,-1,1536,128,5,2,-1,1280,130,5,1,-1,256,132,5,1,-1,1536,156,5,18,-1,0,},[76]={122,5,2,-1,1792,124,5,2,-1,1792,128,5,2,-1,0,130,5,2,-1,1792,144,5,7,-1,0,150,5,1,-1,1024,152,5,1,-1,1536,},[78]={120,5,2,-1,256,122,5,2,-1,256,124,5,2,-1,1280,128,5,1,-1,768,200,5,7,-1,0,},[80]={120,5,2,-1,1280,122,5,2,-1,1536,150,5,1,-1,768,174,5,7,-1,0,},[82]={118,5,1,-1,0,122,5,1,-1,1280,140,5,7,-1,0,168,5,7,-1,0,194,5,1,-1,1280,},[84]={118,5,1,-1,0,120,5,1,-1,256,174,5,2,-1,512,192,5,7,-1,0,},[86]={152,5,2,-1,1792,172,5,1,-1,0,174,5,2,-1,1024,176,5,2,-1,1792,180,5,1,-1,512,194,5,7,-1,0,},[88]={118,5,1,-1,768,148,5,7,-1,0,170,5,2,-1,768,172,5,2,-1,768,174,5,2,-1,256,176,5,2,-1,512,},[90]={108,5,7,-1,0,172,5,2,-1,1024,174,5,2,-1,256,176,5,1,-1,256,190,5,1,-1,256,},[92]={132,5,7,-1,0,160,5,1,-1,1792,174,5,1,-1,1280,},[94]={164,5,7,-1,0,170,5,1,-1,512,172,5,1,-1,0,212,5,2,-1,512,},[96]={214,5,2,-1,1280,216,5,2,-1,1024,},[98]={198,5,2,-1,1280,218,5,2,-1,512,},[100]={92,5,1,-1,768,94,5,18,-1,0,154,5,18,-1,0,190,5,7,-1,0,196,5,2,-1,1280,198,5,2,-1,256,200,5,2,-1,1024,224,5,7,-1,0,},[102]={92,5,1,-1,1536,94,5,1,-1,1792,152,5,1,-1,1792,154,5,2,-1,1792,156,5,1,-1,1792,172,5,7,-1,0,198,5,2,-1,1280,226,5,7,-1,0,},[104]={92,5,1,-1,1792,94,5,1,-1,0,96,5,1,-1,512,152,5,1,-1,1536,154,5,1,-1,1024,156,5,2,-1,0,158,5,1,-1,256,170,5,7,-1,0,190,5,1,-1,1024,},[106]={148,5,1,-1,0,150,5,2,-1,256,152,5,2,-1,1024,154,5,2,-1,256,156,5,2,-1,512,158,5,2,-1,512,160,5,2,-1,0,162,5,1,-1,1792,208,5,1,-1,0,},[108]={150,5,1,-1,1024,152,5,2,-1,1280,154,5,2,-1,768,156,5,2,-1,1536,158,5,2,-1,1280,160,5,1,-1,0,184,5,7,-1,0,190,5,18,-1,0,206,5,1,-1,0,},[110]={148,5,2,-1,0,150,5,1,-1,1280,152,5,1,-1,1280,154,5,2,-1,256,156,5,2,-1,768,158,5,2,-1,0,160,5,1,-1,1792,},[112]={156,5,2,-1,0,192,5,7,-1,0,},[114]={138,5,7,-1,0,188,5,1,-1,0,228,5,1,-1,1792,},[116]={170,5,7,-1,0,},[120]={200,5,1,-1,1792,},[126]={222,5,18,-1,0,},[128]={190,5,2,-1,1024,192,5,2,-1,256,},[130]={192,5,2,-1,1536,194,5,2,-1,1280,},[132]={200,5,7,-1,0,},[134]={208,5,1,-1,1024,},[136]={190,5,1,-1,1792,208,5,1,-1,1536,210,5,1,-1,768,},[138]={178,5,7,-1,0,},[142]={188,5,1,-1,256,192,5,1,-1,768,},[144]={160,5,7,-1,0,},[146]={164,5,1,-1,1536,166,5,1,-1,1280,},[148]={156,5,1,-1,0,164,5,18,-1,0,}
		},
		
		markers ={
			108, 222, 138, 198, 124, 172, 152, 162, 106, 142, 88, 120, 72, 136, 90, 158, 38, 168, 68, 192, 92, 186, 126, 222, 108, 190, 70, 196, 74, 156, 100, 154, 100, 94, 148, 164, 
		},
		
		decorations ={
			
		},
		
		shaman_positions = {
			108, 222, 138, 198, 124, 172, 152, 162, 106, 142, 88, 120, 72, 136, 90, 158
		},
		
		scripts = {
			OnTurn = function(everySecond1, everySecond2, everySecond4) 			paintball_on_turn(everySecond1, everySecond2, everySecond4) end,
			OnCreateThing = function(t, owner, type, model) 						paintball_on_create_thing(t, owner, type, model) end,
			OnPowerUp = function(id, c3d)											PA_on_power_up(id, c3d) end,
			OnFrame = function(ghover) 												return paintball_on_frame(ghover) end,
			OnShamanDeath = function(victim, killer, killer_was_ally)				PA_on_shaman_dead(victim, killer, killer_was_ally) end,
			OnHumanDisconnect = function(player) 									PA_init_single_AI(player) end,
			OnEnd = function()														PA_on_end() end,
		},
		
	},
	
	[MAP_ICE_ARENA]={
	
		info = 	{ 	name = "Ice Arena", author = "Divinity",
					desc = "Shamans must walk toward enemies, then transform into an unstoppable projectile that launches in that direction. Any enemy touched will be knocked away, even more at point blank (keep your distance from enemies). <br> Be careful, as missing your target may send you flying off the arena yourself! <p> Each shaman kill grants 5 points. Each death removes 1 point. <p> Press Spacebar to transform. It then cooldowns for a random short duration. <p> PowerUps: <br> - Essential Oils: your shaman can transform with virtually no cooldown. Lasts 10 seconds. <br> - Freeze Time: sets every enemy shaman's transform ability cooldown to 6 seconds, meaning they can't transform anytime soon.",
					map_objectives = { {value=5, step=1, default=true}, {value=150, limit=500, step=25, default=true}, {} },
					image = 2864, texture={16, 0}, zoom={40,78,0}, drop_infos = false, marker_lb={216, 242}, reinc_timer=12*1, shield_respawn=false,
					custom_rules = {
						{ default = false, 	name = "Quick Recharge", desc = "Shamans are able to charge more frequently." },
						{ default = false, 	name = "Bullet Shamans", desc = "Shaman charges have more velocity." },
						{ default = false, 	name = "Keith's Moment", desc = "Shamans in charging state transform into bowling balls, and will hit targets easier and harder." },
					}
				},

		land ={
			[24]={88,128,89,128,90,128,91,128,92,128,93,128,94,128,95,128,96,128,97,128,98,128,99,128,},[25]={88,128,89,128,90,128,91,128,92,128,93,128,94,128,95,128,96,128,97,128,98,128,99,128,},[26]={82,128,83,128,84,128,85,128,86,128,87,128,88,128,89,128,90,128,91,128,92,128,93,128,94,128,95,128,96,128,97,128,98,128,99,128,100,128,101,128,102,128,103,128,104,128,105,128,},[27]={82,128,83,128,84,128,85,128,86,128,87,128,88,128,89,128,90,128,91,128,92,128,93,128,94,128,95,128,96,128,97,128,98,128,99,128,100,128,101,128,102,128,103,128,104,128,105,128,},[28]={82,128,83,128,84,128,85,128,86,128,87,128,88,128,89,128,90,128,91,128,92,128,93,128,94,128,95,128,96,128,97,128,98,128,99,128,100,128,101,128,102,128,103,128,104,128,105,128,},[29]={82,128,83,128,84,128,85,128,86,128,87,128,88,128,89,128,90,128,91,128,92,128,93,128,94,128,95,128,96,128,97,128,98,128,99,128,100,128,101,128,102,128,103,128,104,128,105,128,},[30]={78,128,79,128,80,128,81,128,82,128,83,128,84,128,85,128,86,128,87,128,88,128,89,128,90,128,91,128,92,128,93,128,94,128,95,128,96,128,97,128,98,128,99,128,100,128,101,128,102,128,103,128,104,128,105,128,106,128,107,128,108,128,109,128,},[31]={78,128,79,128,80,128,81,128,82,128,83,128,84,128,85,128,86,128,87,128,88,128,89,128,90,128,91,128,92,128,93,128,94,128,95,128,96,128,97,128,98,128,99,128,100,128,101,128,102,128,103,128,104,128,105,128,106,128,107,128,108,128,109,128,},[32]={78,128,79,128,80,128,81,128,82,128,83,128,84,128,85,128,86,128,87,128,88,128,89,128,90,128,91,128,92,128,93,128,94,128,95,128,96,128,97,128,98,128,99,128,100,128,101,128,102,128,103,128,104,128,105,128,106,128,107,128,108,128,109,128,},[33]={78,128,79,128,80,128,81,128,82,128,83,128,84,128,85,128,86,128,87,128,88,128,89,128,90,128,91,128,92,128,93,128,94,128,95,128,96,128,97,128,98,128,99,128,100,128,101,128,102,128,103,128,104,128,105,128,106,128,107,128,108,128,109,128,},[34]={98,128,86,128,78,128,79,128,80,128,81,128,82,128,83,128,84,128,85,128,86,128,87,128,88,128,89,128,90,128,91,128,92,128,93,128,94,128,95,128,96,128,97,128,98,128,99,128,100,128,101,128,102,128,103,128,104,128,105,128,106,128,107,128,108,128,109,128,},[35]={78,128,79,128,80,128,81,128,82,128,83,128,84,128,85,128,86,128,87,128,88,128,89,128,90,128,91,128,92,128,93,128,94,128,95,128,96,128,97,128,98,128,99,128,100,128,101,128,102,128,103,128,104,128,105,128,106,128,107,128,108,128,109,128,},[36]={76,128,77,128,78,128,79,128,80,128,81,128,82,128,83,128,84,128,85,128,86,128,87,128,100,128,101,128,102,128,103,128,104,128,105,128,106,128,107,128,108,128,109,128,110,128,111,128,},[37]={76,128,77,128,78,128,79,128,80,128,81,128,82,128,83,128,84,128,85,128,86,128,87,128,100,128,101,128,102,128,103,128,104,128,105,128,106,128,107,128,108,128,109,128,110,128,111,128,},[38]={76,128,77,128,78,128,79,128,80,128,81,128,82,128,83,128,84,128,85,128,86,128,87,128,100,128,101,128,102,128,103,128,104,128,105,128,106,128,107,128,108,128,109,128,110,128,111,128,},[39]={76,128,77,128,78,128,79,128,80,128,81,128,82,128,83,128,84,128,85,128,86,128,87,128,100,128,101,128,102,128,103,128,104,128,105,128,106,128,107,128,108,128,109,128,110,128,111,128,},[40]={76,128,77,128,78,128,79,128,80,128,81,128,82,128,83,128,84,128,85,128,86,128,87,128,100,128,101,128,102,128,103,128,104,128,105,128,106,128,107,128,108,128,109,128,110,128,111,128,},[41]={76,128,77,128,78,128,79,128,80,128,81,128,82,128,83,128,84,128,85,128,86,128,87,128,100,128,101,128,102,128,103,128,104,128,105,128,106,128,107,128,108,128,109,128,110,128,111,128,},[42]={76,128,77,128,78,128,79,128,80,128,81,128,82,128,83,128,84,128,85,128,86,128,87,128,100,128,101,128,102,128,103,128,104,128,105,128,106,128,107,128,108,128,109,128,110,128,111,128,},[43]={76,128,77,128,78,128,79,128,80,128,81,128,82,128,83,128,84,128,85,128,86,128,87,128,100,128,101,128,102,128,103,128,104,128,105,128,106,128,107,128,108,128,109,128,110,128,111,128,},[44]={76,128,77,128,78,128,79,128,80,128,81,128,82,128,83,128,84,128,85,128,86,128,87,128,100,128,101,128,102,128,103,128,104,128,105,128,106,128,107,128,108,128,109,128,110,128,111,128,},[45]={76,128,77,128,78,128,79,128,80,128,81,128,82,128,83,128,84,128,85,128,86,128,87,128,100,128,101,128,102,128,103,128,104,128,105,128,106,128,107,128,108,128,109,128,110,128,111,128,},[46]={76,128,77,128,78,128,79,128,80,128,81,128,82,128,83,128,84,128,85,128,86,128,87,128,100,128,101,128,102,128,103,128,104,128,105,128,106,128,107,128,108,128,109,128,110,128,111,128,98,128,86,128},[47]={76,128,77,128,78,128,79,128,80,128,81,128,82,128,83,128,84,128,85,128,86,128,87,128,100,128,101,128,102,128,103,128,104,128,105,128,106,128,107,128,108,128,109,128,110,128,111,128,},[48]={78,128,79,128,80,128,81,128,82,128,83,128,84,128,85,128,86,128,87,128,88,128,89,128,90,128,91,128,92,128,93,128,94,128,95,128,96,128,97,128,98,128,99,128,100,128,101,128,102,128,103,128,104,128,105,128,106,128,107,128,108,128,109,128,},[49]={78,128,79,128,80,128,81,128,82,128,83,128,84,128,85,128,86,128,87,128,88,128,89,128,90,128,91,128,92,128,93,128,94,128,95,128,96,128,97,128,98,128,99,128,100,128,101,128,102,128,103,128,104,128,105,128,106,128,107,128,108,128,109,128,},[50]={78,128,79,128,80,128,81,128,82,128,83,128,84,128,85,128,86,128,87,128,88,128,89,128,90,128,91,128,92,128,93,128,94,128,95,128,96,128,97,128,98,128,99,128,100,128,101,128,102,128,103,128,104,128,105,128,106,128,107,128,108,128,109,128,},[51]={78,128,79,128,80,128,81,128,82,128,83,128,84,128,85,128,86,128,87,128,88,128,89,128,90,128,91,128,92,128,93,128,94,128,95,128,96,128,97,128,98,128,99,128,100,128,101,128,102,128,103,128,104,128,105,128,106,128,107,128,108,128,109,128,},[52]={78,128,79,128,80,128,81,128,82,128,83,128,84,128,85,128,86,128,87,128,88,128,89,128,90,128,91,128,92,128,93,128,94,128,95,128,96,128,97,128,98,128,99,128,100,128,101,128,102,128,103,128,104,128,105,128,106,128,107,128,108,128,109,128,},[53]={78,128,79,128,80,128,81,128,82,128,83,128,84,128,85,128,86,128,87,128,88,128,89,128,90,128,91,128,92,128,93,128,94,128,95,128,96,128,97,128,98,128,99,128,100,128,101,128,102,128,103,128,104,128,105,128,106,128,107,128,108,128,109,128,},[54]={82,128,83,128,84,128,85,128,86,128,87,128,88,128,89,128,90,128,91,128,92,128,93,128,94,128,95,128,96,128,97,128,98,128,99,128,100,128,101,128,102,128,103,128,104,128,105,128,106,128,107,128,},[55]={82,128,83,128,84,128,85,128,86,128,87,128,88,128,89,128,90,128,91,128,92,128,93,128,94,128,95,128,96,128,97,128,98,128,99,128,100,128,101,128,102,128,103,128,104,128,105,128,106,128,107,128,},[56]={82,128,83,128,84,128,85,128,86,128,87,128,88,128,89,128,90,128,91,128,92,128,93,128,94,128,95,128,96,128,97,128,98,128,99,128,100,128,101,128,102,128,103,128,104,128,105,128,},[57]={82,128,83,128,84,128,85,128,86,128,87,128,88,128,89,128,90,128,91,128,92,128,93,128,94,128,95,128,96,128,97,128,98,128,99,128,100,128,101,128,102,128,103,128,104,128,105,128,},[58]={88,128,89,128,90,128,91,128,92,128,93,128,94,128,95,128,96,128,97,128,98,128,99,128,},[59]={88,128,89,128,90,128,91,128,92,128,93,128,94,128,95,128,96,128,97,128,98,128,99,128,}
			--[30]={84,455,85,455,86,455,87,455,88,455,89,455,90,455,91,455,92,455,93,455,94,455,95,455,96,455,97,455,98,455,99,455,100,455,101,455,102,455,103,455,},[31]={84,455,85,455,86,455,87,455,88,455,89,455,90,455,91,455,92,455,93,455,94,455,95,455,96,455,97,455,98,455,99,455,100,455,101,455,102,455,103,455,},[32]={82,455,83,455,84,455,85,455,86,455,87,455,88,455,89,455,90,455,91,455,92,455,93,455,94,455,95,455,96,455,97,455,98,455,99,455,100,455,101,455,102,455,103,455,104,455,105,455,},[33]={82,455,83,455,84,455,85,455,86,455,87,455,88,455,89,455,90,455,91,455,92,455,93,455,94,455,95,455,96,455,97,455,98,455,99,455,100,455,101,455,102,455,103,455,104,455,105,455,},[34]={82,455,83,455,84,455,85,455,86,455,87,455,88,455,89,455,90,455,91,455,92,455,93,455,94,455,95,455,96,455,97,455,98,455,99,455,100,455,101,455,102,455,103,455,104,455,105,455,},[35]={82,455,83,455,84,455,85,455,86,455,87,455,88,455,89,455,90,455,91,455,92,455,93,455,94,455,95,455,96,455,97,455,98,455,99,455,100,455,101,455,102,455,103,455,104,455,105,455,},[36]={82,455,83,455,84,455,85,455,86,455,87,455,88,455,89,455,90,455,91,455,92,455,93,455,94,455,95,455,96,455,97,455,98,455,99,455,100,455,101,455,102,455,103,455,104,455,105,455,},[37]={82,455,83,455,84,455,85,455,86,455,87,455,88,455,89,455,90,455,91,455,92,455,93,455,94,455,95,455,96,455,97,455,98,455,99,455,100,455,101,455,102,455,103,455,104,455,105,455,},[38]={82,455,83,455,84,455,85,455,86,455,87,455,88,455,89,455,90,455,91,455,92,455,93,455,94,455,95,455,96,455,97,455,98,455,99,455,100,455,101,455,102,455,103,455,104,455,105,455,},[39]={82,455,83,455,84,455,85,455,86,455,87,455,88,455,89,455,90,455,91,455,92,455,93,455,94,455,95,455,96,455,97,455,98,455,99,455,100,455,101,455,102,455,103,455,104,455,105,455,},[40]={82,455,83,455,84,455,85,455,86,455,87,455,88,455,89,455,90,455,91,455,92,455,93,455,94,455,95,455,96,455,97,455,98,455,99,455,100,455,101,455,102,455,103,455,104,455,105,455,},[41]={82,455,83,455,84,455,85,455,86,455,87,455,88,455,89,455,90,455,91,455,92,455,93,455,94,455,95,455,96,455,97,455,98,455,99,455,100,455,101,455,102,455,103,455,104,455,105,455,},[42]={82,455,83,455,84,455,85,455,86,455,87,455,88,455,89,455,90,455,91,455,92,455,93,455,94,455,95,455,96,455,97,455,98,455,99,455,100,455,101,455,102,455,103,455,104,455,105,455,},[43]={82,455,83,455,84,455,85,455,86,455,87,455,88,455,89,455,90,455,91,455,92,455,93,455,94,455,95,455,96,455,97,455,98,455,99,455,100,455,101,455,102,455,103,455,104,455,105,455,},[44]={82,455,83,455,84,455,85,455,86,455,87,455,88,455,89,455,90,455,91,455,92,455,93,455,94,455,95,455,96,455,97,455,98,455,99,455,100,455,101,455,102,455,103,455,104,455,105,455,},[45]={82,455,83,455,84,455,85,455,86,455,87,455,88,455,89,455,90,455,91,455,92,455,93,455,94,455,95,455,96,455,97,455,98,455,99,455,100,455,101,455,102,455,103,455,104,455,105,455,},[46]={82,455,83,455,84,455,85,455,86,455,87,455,88,455,89,455,90,455,91,455,92,455,93,455,94,455,95,455,96,455,97,455,98,455,99,455,100,455,101,455,102,455,103,455,104,455,105,455,},[47]={82,455,83,455,84,455,85,455,86,455,87,455,88,455,89,455,90,455,91,455,92,455,93,455,94,455,95,455,96,455,97,455,98,455,99,455,100,455,101,455,102,455,103,455,104,455,105,455,},[48]={82,455,83,455,84,455,85,455,86,455,87,455,88,455,89,455,90,455,91,455,92,455,93,455,94,455,95,455,96,455,97,455,98,455,99,455,100,455,101,455,102,455,103,455,104,455,105,455,},[49]={82,455,83,455,84,455,85,455,86,455,87,455,88,455,89,455,90,455,91,455,92,455,93,455,94,455,95,455,96,455,97,455,98,455,99,455,100,455,101,455,102,455,103,455,104,455,105,455,},[50]={82,455,83,455,84,455,85,455,86,455,87,455,88,455,89,455,90,455,91,455,92,455,93,455,94,455,95,455,96,455,97,455,98,455,99,455,100,455,101,455,102,455,103,455,104,455,105,455,},[51]={82,455,83,455,84,455,85,455,86,455,87,455,88,455,89,455,90,455,91,455,92,455,93,455,94,455,95,455,96,455,97,455,98,455,99,455,100,455,101,455,102,455,103,455,104,455,105,455,},[52]={84,455,85,455,86,455,87,455,88,455,89,455,90,455,91,455,92,455,93,455,94,455,95,455,96,455,97,455,98,455,99,455,100,455,101,455,102,455,103,455,},[53]={84,455,85,455,86,455,87,455,88,455,89,455,90,455,91,455,92,455,93,455,94,455,95,455,96,455,97,455,98,455,99,455,100,455,101,455,102,455,103,455,}
		},
		
		objects ={
			[24]={92,5,1,-1,0,},[56]={92,5,1,-1,0,},[40]={76,5,1,-1,0, 108,5,1,-1,0,}
		},
		
		markers ={
			40, 92
		},
		
		decorations ={
			
		},
		
		shaman_positions = {
			30, 92, 50, 92, 40, 82, 40, 102, 50, 102, 30, 82, 50, 82, 30, 102
		},
		
		scripts = {
			OnTurn = function(everySecond1, everySecond2, everySecond4) 			PS_on_turn(everySecond1, everySecond2, everySecond4) end,
			OnCreateThing = function(t, owner, type, model) 						IA_on_create_thing(t, owner, type, model) end,
			OnFrame = function(ghover) 												return IA_on_frame(ghover) end,
			OnPowerUp = function(id, c3d)											IA_on_power_up(id, c3d) end,
			OnShamanDeath = function(victim, killer, killer_was_ally)				IA_on_shaman_dead(victim, killer, killer_was_ally) end,
			OnHumanDisconnect = function(player) 									PS_init_single_AI(player) end,
			OnKey = function(key, is_down, playernum)								IA_on_key(key, is_down, playernum) end,
			OnKeyMultiplayer = function(clicker, str)								IA_on_key_Multiplayer(clicker, str) end,
			OnEnd = function()														IA_on_end() end,
		},
		
	},
	
}


-- cache map names and authors if you are the host (to use in search bar)
map_list_names = {}
--map_list_authors = {}

if gnsi().PlayerNum == TRIBE_BLUE then
	for i = 1, MAX_MAPS do
		local tbl = map_list[i].info
		local name = tbl.name
		--local author = tbl.author
		map_list_names[i] = name
		--map_list_authors[i] = author
	end
end