-- global vars

--debug
debug = false
default_selected_map = debug and MAP_QUIZ_EASY or MAP_BOAT_RACE_II --coolest img? xD

_gsi = gsi()
_gnsi = gnsi()
sti = spells_type_info()
pti = people_type_info()
tmi = thing_move_info()
_constants = constants()
multiplayer = debug or (_gnsi.Flags & GNS_NETWORK > 0)
playernum = _gnsi.PlayerNum
host, master = TRIBE_BLUE, TRIBE_BLUE
im_host, im_master = (playernum == host), (playernum == master)
im_spectating = false
_NO_SPELL_MODEL = M_SPELL_BURN
SAFE_NEUTRAL = TRIBE_NEUTRAL

state = STATE_INITIALIZE
hovering, hovering_id = nil, nil
hovering_zone = nil
hovering_ingame = nil
W, H, GUIW = ScreenWidth(), ScreenHeight(), GFGetGuiWidth()
W2, H2 = W // 2, H // 2
mouseX, mouseY = get_mouse_x(), get_mouse_y()
turn, framer = 0, 0
mg_turn = 0
curr_font, curr_font_h = -1, 0
custom_string_widths = {}
font_heights, centered_font_heights = {10,19,28}, {5,9,14}
hub_cache, game_draw_cache = nil, {}
scripts_ptr = nil

-- global tables

game = {
	players = {
		{ mode=TRIBE_HUMAN, difficulty = 0, points=0, played_games=0, full_name="", short_name="", color=4,		g_color=2, 	ready=false, 	spectator=false, 	sprite=6879,	card=1762 },
		{ mode=TRIBE_HUMAN, difficulty = 0, points=0, played_games=0, full_name="", short_name="", color=12,	g_color=-2, ready=false, 	spectator=false, 	sprite=6899,	card=1763 },
		{ mode=TRIBE_HUMAN, difficulty = 0, points=0, played_games=0, full_name="", short_name="", color=5,		g_color=3, 	ready=false, 	spectator=false, 	sprite=6919,	card=1732 },
		{ mode=TRIBE_HUMAN, difficulty = 0, points=0, played_games=0, full_name="", short_name="", color=3,		g_color=1, 	ready=false, 	spectator=false, 	sprite=6939,	card=1764 },
		{ mode=TRIBE_HUMAN, difficulty = 0, points=0, played_games=0, full_name="", short_name="", color=7,		g_color=10, ready=false, 	spectator=false, 	sprite=6879,	card=1765 },
		{ mode=TRIBE_HUMAN, difficulty = 0, points=0, played_games=0, full_name="", short_name="", color=6,		g_color=11, ready=false, 	spectator=false,	sprite=6899,	card=1766 },
		{ mode=TRIBE_HUMAN, difficulty = 0, points=0, played_games=0, full_name="", short_name="", color=1,		g_color=12, ready=false, 	spectator=false,  	sprite=6919,	card=1740 },
		{ mode=TRIBE_HUMAN, difficulty = 0, points=0, played_games=0, full_name="", short_name="", color=14, 	g_color=-1, ready=false, 	spectator=false, 	sprite=6939,	card=1767 }
	},
	hub = {
		games_played = 0,
		total_game_time = 0,
		total_hub_time = 0,
		previous_map = nil,
		selected_map = default_selected_map,
		map_info_ptr = nil,
		custom_rules = {},
		circular_maps_cache = {},
		map_changer_offset = 0,
		map_objectives = {},
		hub_log = {},
		log_fading_timer = MAX_LOG_FADING_TIMER,
		awarded_manual_points = {0,0,0,0,0,0,0,0,   0,0,0,0},
		did_award_manual_points = false,
		active_players = 0,
		humans_tbl = {},
		gui_teams = {
			{ default_name = "Solo Players", 	players = {}, locked = false, },
			{ default_name = "Team A", 			players = {}, locked = false, points = 0 },
			{ default_name = "Team B", 			players = {}, locked = false, points = 0 },
			{ default_name = "Team C", 			players = {}, locked = false, points = 0 },
			{ default_name = "Team D", 			players = {}, locked = false, points = 0 }
		}
	},
	gameplay = {
		--mg_state = MG_STATE_COUNTDOWN,
		countdown = -1,
		AI_difficulty = 0,
		map_target_score_type = POINTS_SYSTEM_CLASSIC_NORMAL,
		cached_curr_values_strings = {"00:00", "0", "0"},
		highest_score = 0,
		highest_score_decimals = 1,
		clear_drop_infos = false,
		dropIcon = 0,
		processing = false,
		shield_respawn = false,
		map_respawn_timer = 12*3,
		shaman_speed = 58,
		map_curr_duration = 0,
		map_curr_round = 0,
		map_curr_round_timer = -1,
		mg_effects_list = {},
		mg_obj_list = {},
		bloods = {},
		mg_created_land_locations = {},
		mg_unwalkable_zones = {},
		powerups_pointer = nil,
		active_powerups = {},
		max_powerups_at_once = -1,
		participants_by_teams = {},
		participants = {},
		tribes_to_participants_ptrs = {},
		AI_participants = {},
		mg_player_vars = {},
		mg_vars = {},
		post_mg_table = {}, --id, name, players{}, points, played_games
	},
	forge = {
		init = false,
		ptr = nil,
		total_things = 0,
		amounts = {},
		remaining = 0,
		percent = 0,
		idx = 0,
		enum = FORGING_LAND,
		forging_speed = 1,
		forging_str = "",
		forging_str_timer = 0,
		unforging = false,
		unforging_done_notificate = false,
		unforging_enum = nil,
	},
	misc = {
		ready_set_timer = -1, 
		before_results_timer = 0,
		post_mg_table = {},
		past_played_minigames = {},
		font_heights = {},
		emojis_enabled = true,
	},
}

-- player table

player = {
			master = {
				searching = { active = false, str = "", map_list = {} },
				imgui_open = false,
			},
			hub_misc = {
				dragging_card = nil,
				name_editing = false,
				name_editing_string = "",
				rules_font_idx = 3,
				rules_font = 8,
				rules_offset = 0,
				card_border = 1780,
				shaman_frame = 0,
				lock = { id=nil, moving=0 },
				map_hover_img = {},
				tooltip = false,
				l_mouse_pressing = false,
				r_mouse_pressing = false,
				l_shift_pressing = false,
				l_ctrl_pressing = false,
				sounds_muted = false,
				sounds_cdr = 0,
				follow_forge = false,
				hovering_past_mg = 0,
				patchnotes_id = #patch_notes,
			},
			settings = {
				scores_small_font = false,
				zoom_on_respawn = false,
				objectives_hide = false,
				disable_emojis = false,
			},
			emojis_wheel = {
				showing = false,
				hovering = false,
				cache = {},
			},
}

-- state logic
local ggameplay = game.gameplay

OnTurn_action_function = {
							[STATE_INITIALIZE] = function()
								if turn == 1 then
									init_player_tables()
								elseif turn == 12 then
									prepare_for_hub()
									set_font_heights()
								end						
							end,
							
							[STATE_HUB] = function(everySecond1)
								process_deforging()
								process_log_fading_timer(everySecond1)
								process_lock_moving()
								process_start_game_countdown()
								process_sounds_cdr()
							end,
							
							[STATE_FORGING] = function(everySecond1)
								if not game.forge.init then
									init_forging()
								else
									process_forging()
								end
							end,
							
							[STATE_READY_SET] = function(everySecond1)
								process_ready_set(everySecond1)
							end,
							
							[STATE_PLAYING] = function(everySecond1)
								process_emojis(everySecond1)
								process_mg_timer(everySecond1)
								process_power_ups(everySecond1) --maybe move to processing?
								
								if ggameplay.processing then
									local everyMgSecond1, everyMgSecond2, everyMgSecond4, everyMgSecond8 =
										everySeconds_mg(1), everySeconds_mg(2), everySeconds_mg(4), everySeconds_mg(8)
								
									if mg_turn == 1 then
										OnMgInitGeneral()
									else
										if everyMgSecond1 then
											process_automatic_powerup_creation()
										end
									end
									
									if scripts_ptr and scripts_ptr.OnTurn then
										scripts_ptr.OnTurn(everyMgSecond1, everyMgSecond2, everyMgSecond4, everyMgSecond8)
									end
								end
							end,
							
							[STATE_FINAL_RESULTS] = function(everySecond1)
								process_deforging()
								process_final_results_timer()
								process_emojis(everySecond1)
							end
}

OnFrame_action_function = {
							[STATE_INITIALIZE] = function()
								hide_panel()
							end,
							
							[STATE_HUB] = function()
								hide_panel()
								if no_menus_open() then
									draw_mg_hub()
									increase_card_border()
									increase_framer()
									shaman_framer()
								else
									reset_zone_hovering()
									reset_mouse_btns()
									reset_dragging_card()
									reset_map_searching()
								end
							end,
							
							[STATE_FORGING] = function()
								hide_panel()
								draw_forge_progress()
								increase_framer()
							end,
							
							[STATE_READY_SET] = function()
								ready_set_traffic_light()
								render_mg_scoreboard()
								render_mg_personal_setttings()
								render_mg_objectives()
							end,
							
							[STATE_PLAYING] = function()
								local ghover = render_mg_personal_setttings()
								render_mg_scoreboard()
								render_mg_objectives()
								increase_framer()
								draw_emoji_wheel()
								
								if ggameplay.processing then
									local mg_onframe = scripts_ptr.OnFrame
									if mg_onframe then
										if mg_turn > 1 then
											ghover = mg_onframe(ghover)
										end
									end
								end
								
								--if (not ghover) and hovering_ingame ~= HOVERING_PERSONAL_SETTINGS_BTN then reset_ingame_cursors() end
							end,
							
							[STATE_FINAL_RESULTS] = function()
								before_results_frame()
								hide_panel(guiW)
								draw_mg_end_results()
								increase_framer()
								draw_emoji_wheel()
							end
}

OnCreateThing_action_function = {
							[STATE_PLAYING] = function(t, owner, type, model)
								if scripts_ptr and scripts_ptr.OnCreateThing then
									scripts_ptr.OnCreateThing(t, owner, type, model)
									
									if type == T_SPELL then
										clean_drop_infos()
										
										if model == M_SPELL_LAND_BRIDGE or model == M_SPELL_FLATTEN then
											local from = getShaman(owner) and copy_c3d(getShaman(owner).Pos.D3) or nil
											on_land_spell(model, from, copy_c3d(t.Pos.D3))
										end
									end
								end
							end,
}


