patch_notes = {
	{ "Credits", 	"www.popre.net", 		"Made by Divinity" },
	{ "1.0", 	"December 18, 2025", 		"- Release version. <br> - Supports 23 mini-games by various authors." },
}

import(Module_Building)
import(Module_Commands)
import(Module_Control)
import(Module_DataTypes)
import(Module_Defines)
import(Module_Draw)
import(Module_Features)
import(Module_Game)
import(Module_Globals)
import(Module_Helpers)
import(Module_ImGui)
import(Module_Level)
import(Module_Map)
import(Module_MapWho)
import(Module_Math)
import(Module_Network)
import(Module_Objects)
import(Module_Person)
import(Module_Players)
import(Module_PopScript)
import(Module_Sound)
import(Module_Shapes)
import(Module_Spells)
import(Module_String)
import(Module_System)
import(Module_Table)

include("mgHub_enums.lua")
include("mgHub_map_info.lua")
include("mgHub_globals.lua")
include("mgHub_powerups.lua")
include("mgHub_assets.lua")
include("mgHub_scripts.lua")

_gnsi.GameParams.Flags3 = _gnsi.GameParams.Flags3 | GPF3_NO_GAME_OVER_PROCESS
enable_feature(F_WILD_NO_RESPAWN)
enable_feature(F_DISABLE_PAUSE)
enable_feature(F_DISABLE_ALLY_CHANGE)

local ggameplay = game.gameplay




function OnTurn()
	local everySecond1, everySecond2 = everySeconds(1), everySeconds(2)

	OnTurn_action_function[state](everySecond1)
	process_future_actions()
	periodically_find_dc_humans(everySecond2)
	
	if turn == 1 then OnInit() end
	turn = turn + 1
end

function OnInit()
	cache_default_constants()
	update_string_widths()
	set_map_texture(true)
	
	--mm calls features turn 0, we should call after
	enable_feature(F_WILD_NO_RESPAWN)
	enable_feature(F_DISABLE_PAUSE)
	enable_feature(F_DISABLE_ALLY_CHANGE)
	
	-- if im_host and not debug then
		-- player.master.imgui_open = true
	-- end
	
	for i = 0,7 do set_player_cannot_build(M_BUILDING_GUARD_POST, i) end
end

function OnCreateThing(t)
	if not ggameplay.processing then return end
	if HasFlag(t.Flags3, TF3_LOCAL) then return end
	
	local owner, type, model = t.Owner, t.Type, t.Model
	local mg_on_create_thing = OnCreateThing_action_function[state]

	if mg_on_create_thing then
		mg_on_create_thing(t, owner, type, model)
	end
	
	--in case disable feature isnt working
	if t then
		if type == T_PERSON and model == M_PERSON_WILD then
			delete_thing_type(t)
		elseif type == T_SPELL then
			if state == STATE_FINAL_RESULTS then
				if not game.forge.unforging then
					t.Model = _NO_SPELL_MODEL
					delete_thing_type(t)
				end
			end
		end
	end
end

function OnFrame()
	update_screen_res()
	
	mouseX, mouseY = get_mouse_x(), get_mouse_y()
	OnFrame_action_function[state]()
	draw_patchnotes()
	
	-- PopSetFont(3, 0)
	-- LbDraw_Text(GUIW, 100, tostring(hovering_ingame), 0)
	-- LbDraw_Text(GUIW, 120, tostring(hovering_ingame_id), 0)

	--OBS rec outbox
	--DrawBoxOutline(centerW - halfsize, centerH - halfsize, size, size, 13)
	--use 1600x900
	--DrawBoxOutline(585, 281, 428, 337, 2)
end

function OnResolutionChange()
	hub_cache = nil
	game_draw_cache.scoreboard = nil
end

function OnMouseButton(key_num, is_down, x, y)
	local left = (key_num == LB_KEY_MOUSE0)
	
	if not is_down then
		OnMouseUp(left, x, y)
	else
		OnMouseDown(left, x, y)
	end
	
	-- if debug then
		-- if key_num == 259 then
				-- local mouseX, guiW = get_mouse_x(), GFGetGuiWidth()

				-- if not (mouseX > guiW) then
					-- return
				-- end
				
				-- local mp = MapPosXZ.new()
				-- mp.Pos = world_coord2d_to_map_idx(get_mouse_pointed_at_coord2d())
				-- local x, z = mp.XZ.X, mp.XZ.Z
				-- LOG(x .. " " .. z)
				-- -- local c2d = Coord2D.new()
				-- -- map_xz_to_world_coord2d(x, z, c2d)
				-- -- local c3d = Coord3D.new()
				-- -- coord2D_to_coord3D(c2d, c3d)
		-- end
	-- end
end

function OnMouseUp(left, x, y)
	if state == STATE_HUB then
		press_hub_button(left)
		if left then
			set_left_mouse_pressing(false)
			try_to_apply_dragging_card()
		else
			reset_map_searching()
			set_right_mouse_pressing(false)
		end
	elseif state == STATE_READY_SET or state == STATE_PLAYING then
		click_ingame_button(playernum, left)
	end
end

function OnMouseDown(left, x, y)
	if state == STATE_HUB then
		if left then
			set_left_mouse_pressing(true)
			
			if state == STATE_HUB then
				try_to_drag_card()
			end
		else
			set_right_mouse_pressing(true)
		end
	end
end

function OnKeyUp(key)
	if state == STATE_FINAL_RESULTS then
		if key == LB_KEY_SPACE then
			if im_host then
				if not multiplayer then
					leave_final_results_to_hub()
				else
					send_packet_now("d", encode_base62(key))
				end
			end
		end
	elseif state == STATE_READY_SET or state == STATE_PLAYING then
		ingame_on_key(key, false)
	
		if state == STATE_PLAYING then
			if key == LB_KEY_F11 or key == LB_KEY_F12 then
				if im_host then
					try_to_end_game_prematurely(key)
				end
			end
		end
	elseif state == STATE_HUB then
		if not searching_type(key) then
			manual_awarding_pts(key)
		end
	end
	
	if key == IN_GAME_EMOJI_KEY then
		onkeyup_wheel()
	elseif key == LB_KEY_LSHIFT then
		set_left_shift_pressing(false)
	elseif key == LB_KEY_LCONTROL then
		set_left_ctrl_pressing(false)
	elseif key == LB_KEY_TAB then
		if im_host then
			open_host_imgui()
		end
	end
end

function OnKeyDown(key)
	if key == IN_GAME_EMOJI_KEY then
		onkeydown_wheel()
	elseif key == LB_KEY_LSHIFT then
		set_left_shift_pressing(true)
	elseif key == LB_KEY_LCONTROL then
		set_left_ctrl_pressing(true)
	end
	
	-- lets not use this on key down
	-- in mp it sends too many packets
	-- also calls the function(s) too many times even if no packets
	-- if state == STATE_READY_SET or state == STATE_PLAYING then
		-- ingame_on_key(key, true)
	-- end
end

function OnSoundEvent(t_thing, event, flags)
	--doesnt seem to work properly, calls sounds whilte turn 0 (before setting funcs and variables), so can't do much with it
	--this is the only way (making funcs to spells, checking sounds first, and then map...)
	--ret = loadstring("ON_SND_VOLCANO" .. "_boat_wars_I((t_thing, event, flags))")() even loadstring doesnt work?
	--LOG(string.format("%s, %i, %i", tostring(t_thing), event, flags))
	
	local ret = FALSE

	if sound_event_triggers[event] ~= nil then
		ret = sound_event_triggers[event](t_thing, flags)
	end
	
	return ret
end

-- ORE, GAMMAMON