import(Module_DataTypes)
import(Module_Globals)
import(Module_Table)
import(Module_Players)
import(Module_Level)
import(Module_Objects)
import(Module_Map)

PThing = {}

PThing.SpellSet = function (player, spell, input, charge)
  if (input == 0) then
    _gsi.ThisLevelInfo.PlayerThings[player].SpellsAvailable = _gsi.ThisLevelInfo.PlayerThings[player].SpellsAvailable ~ (1<<spell);
	else
		if (charge == 0) then
			_gsi.ThisLevelInfo.PlayerThings[player].SpellsNotCharging = _gsi.ThisLevelInfo.PlayerThings[player].SpellsNotCharging | (1<<spell-1);
		else
			_gsi.ThisLevelInfo.PlayerThings[player].SpellsNotCharging = _gsi.ThisLevelInfo.PlayerThings[player].SpellsNotCharging ~ (1<<spell-1);
		end

		_gsi.ThisLevelInfo.PlayerThings[player].SpellsAvailable = _gsi.ThisLevelInfo.PlayerThings[player].SpellsAvailable | (1<<spell);
	end
end

PThing.BldgSet = function (player, building, input)
  if (input == 0) then
		_gsi.ThisLevelInfo.PlayerThings[player].BuildingsAvailable = _gsi.ThisLevelInfo.PlayerThings[player].BuildingsAvailable ~ (1<<building);
	else
		_gsi.ThisLevelInfo.PlayerThings[player].BuildingsAvailable = _gsi.ThisLevelInfo.PlayerThings[player].BuildingsAvailable | (1<<building);
	end
end

PThing.GiveShot = function (player, spell, amount)
  if (amount > 4) then
    _gsi.ThisLevelInfo.PlayerThings[player].SpellsAvailableOnce[spell] = 4
  else
    _gsi.ThisLevelInfo.PlayerThings[player].SpellsAvailableOnce[spell] = _gsi.ThisLevelInfo.PlayerThings[player].SpellsAvailableOnce[spell] + amount
  end
end

function player_has_spell_unlocked(pn, spell)
  og_value = _gsi.ThisLevelInfo.PlayerThings[pn].SpellsAvailable
  new_value = _gsi.ThisLevelInfo.PlayerThings[pn].SpellsAvailable ~ (1<<spell)
  if (og_value > new_value) then
    return true;
  end
  return false;
--  if (_gsi.ThisLevelInfo.PlayerThings[pn].SpellsAvailable & spell ~= 0) then
--    return true;
--  end
--  return false;
end


--function flatten_location(build)
--  local buildPos = MapPosXZ.new() 
--  buildPos.Pos = world_coord3d_to_map_idx(build.Pos.D3)	
--  BuildPosX = buildPos.XZ.X
--  BuildPosZ = buildPos.XZ.Z
--  Positioning = MAP_XZ_2_WORLD_XYZ(BuildPosX, BuildPosZ)
--  local map_idx = MapPosXZ.new()
--  map_idx.Pos = world_coord3d_to_map_idx(Positioning)
--  return Positioning
--end

function flatten_location_xz(x, z)
  local abuildPos = MapPosXZ.new()
  abuildPos.XZ.X = x
  abuildPos.XZ.Z = z
  local c3d = Coord3D.new()
  map_idx_to_world_coord3d(abuildPos.Pos, c3d)
  return c3d.Ypos
end

function flatten_location(build)
  local buildPos = MapPosXZ.new()
  buildPos.Pos = world_coord3d_to_map_idx(build.Pos.D3)
  originalBuildY = build.Pos.D3.Ypos
  found_location = false
  for i = 1,5 do
    for v = 1,3 do
      if (found_location == false) then
        BuildPosX = (buildPos.XZ.X) - ((v * 2) + 2)
        BuildPosZ = (buildPos.XZ.Z) - ((i - 3) * 2)
        flattenCastY = flatten_location_xz(BuildPosX, BuildPosZ)
        if (flattenCastY < (originalBuildY - 400) or flattenCastY > (originalBuildY + 400) or flattenCastY <= 0) then
          found_location = true
        end
      end
    end
  end
  for i = 1,5 do
    for v = 1,3 do
      if (found_location == false) then
        BuildPosX = (buildPos.XZ.X) + ((v * 2) + 2)
        BuildPosZ = (buildPos.XZ.Z) - ((i - 3) * 2)
        flattenCastY = flatten_location_xz(BuildPosX, BuildPosZ)
        if (flattenCastY < (originalBuildY - 400) or flattenCastY > (originalBuildY + 400) or flattenCastY <= 0) then
          found_location = true
        end
      end
    end
  end
  for i = 1,5 do
    for v = 1,3 do
      if (found_location == false) then
        BuildPosX = (buildPos.XZ.X) - ((i - 3) * 2)
        BuildPosZ = (buildPos.XZ.Z) - ((v * 2) + 2)
        flattenCastY = flatten_location_xz(BuildPosX, BuildPosZ)
        if (flattenCastY < (originalBuildY - 400) or flattenCastY > (originalBuildY + 400) or flattenCastY <= 0) then
          found_location = true
        end
      end
    end
  end
  for i = 1,5 do
    for v = 1,3 do
      if (found_location == false) then
        BuildPosX = (buildPos.XZ.X) - ((i - 3) * 2)
        BuildPosZ = (buildPos.XZ.Z) + ((v * 2) + 2)
        flattenCastY = flatten_location_xz(BuildPosX, BuildPosZ)
        if (flattenCastY < (originalBuildY - 400) or flattenCastY > (originalBuildY + 400) or flattenCastY <= 0) then
          found_location = true
        end
      end
    end
  end
  if (found_location == true) then
    Positioning = MAP_XZ_2_WORLD_XYZ(BuildPosX, BuildPosZ)
    return Positioning
  end
  return false
end